#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
/*
 * QuietDatabase.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include <vector>
#include <map>

#include <boost/lexical_cast.hpp>
#include <fmt/ranges.h>

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/SystemData.h"
#include "fdbrpc/simulator.h"
#include "flow/flow.h"
#include "flow/ProcessEvents.h"
#include "flow/Trace.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getWorkers()
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetWorkersActor>
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetWorkersActorState {
															#line 52 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetWorkersActorState(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,int const& flags = 0) 
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : dbInfo(dbInfo),
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   flags(flags)
															#line 61 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkersActorState() 
	{
		fdb_probe_actor_destroy("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 76 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 46 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = brokenPromiseToNever( dbInfo->get().clusterInterface.getWorkers.getReply(GetWorkersRequest(flags)));
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 50 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfo->onChange();
															#line 112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetWorkersActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetWorkersActor*>(this)));
															#line 50 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 1, Void >*>(static_cast<GetWorkersActor*>(this)));
															#line 119 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& w,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<WorkerDetails>>::futures) { (void)(w); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 134 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<WorkerDetails> >::value()) std::vector<WorkerDetails>(w);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && w,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetWorkersActor*>(this)->SAV<std::vector<WorkerDetails>>::futures) { (void)(w); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetWorkersActor*>(this)->SAV< std::vector<WorkerDetails> >::value()) std::vector<WorkerDetails>(w);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >::remove();
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int flags;
															#line 291 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getWorkers()
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetWorkersActor final : public Actor<std::vector<WorkerDetails>>, public ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetWorkersActor, 1, Void >, public FastAllocated<GetWorkersActor>, public GetWorkersActorState<GetWorkersActor> {
															#line 296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetWorkersActor>::operator new;
	using FastAllocated<GetWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16365686453547327744UL, 6988039874695325952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<WorkerDetails>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetWorkersActor, 1, Void >;
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetWorkersActor(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,int const& flags = 0) 
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::vector<WorkerDetails>>(),
		   GetWorkersActorState<GetWorkersActor>(dbInfo, flags),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14779239272732970240UL, 16642038601798370048UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkersActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::vector<WorkerDetails>> getWorkers( Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, int const& flags = 0 ) {
															#line 43 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::vector<WorkerDetails>>(new GetWorkersActor(dbInfo, flags));
															#line 347 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 54 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the WorkerInterface representing the Master server.
															#line 353 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getMasterWorker()
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetMasterWorkerActor>
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetMasterWorkerActorState {
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetMasterWorkerActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getMasterWorker", reinterpret_cast<unsigned long>(this));

	}
	~GetMasterWorkerActorState() 
	{
		fdb_probe_actor_destroy("getMasterWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 57 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("GetMasterWorker").detail("Stage", "GettingWorkers");
															#line 59 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 386 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMasterWorkerActorState();
		static_cast<GetMasterWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(dbInfo);
															#line 60 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetMasterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 418 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetMasterWorkerActor*>(this)->actor_wait_state = 1;
															#line 60 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetMasterWorkerActor*>(this)));
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 63 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (workers[i].interf.address() == dbInfo->get().master.address())
															#line 434 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 64 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("GetMasterWorker") .detail("Stage", "GotWorkers") .detail("MasterId", dbInfo->get().master.id()) .detail("WorkerId", workers[i].interf.id());
															#line 68 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetMasterWorkerActor*>(this)->SAV<WorkerInterface>::futures) { (void)(workers[i].interf); this->~GetMasterWorkerActorState(); static_cast<GetMasterWorkerActor*>(this)->destroy(); return 0; }
															#line 440 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetMasterWorkerActor*>(this)->SAV< WorkerInterface >::value()) WorkerInterface(workers[i].interf);
				this->~GetMasterWorkerActorState();
				static_cast<GetMasterWorkerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent(SevWarn, "GetMasterWorkerError") .detail("Error", "MasterWorkerNotFound") .detail("Master", dbInfo->get().master.id()) .detail("MasterAddress", dbInfo->get().master.address()) .detail("WorkerCount", workers.size());
															#line 78 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 78 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetMasterWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 453 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetMasterWorkerActor*>(this)->actor_wait_state = 2;
															#line 78 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetMasterWorkerActor, 1, Void >*>(static_cast<GetMasterWorkerActor*>(this)));
															#line 458 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 60 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 467 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMasterWorkerActor*>(this)->actor_wait_state > 0) static_cast<GetMasterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<GetMasterWorkerActor*>(this)->ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetMasterWorkerActor*>(this)->actor_wait_state > 0) static_cast<GetMasterWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<GetMasterWorkerActor*>(this)->ActorCallback< GetMasterWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMasterWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetMasterWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetMasterWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 60 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getMasterWorker()
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetMasterWorkerActor final : public Actor<WorkerInterface>, public ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetMasterWorkerActor, 1, Void >, public FastAllocated<GetMasterWorkerActor>, public GetMasterWorkerActorState<GetMasterWorkerActor> {
															#line 640 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetMasterWorkerActor>::operator new;
	using FastAllocated<GetMasterWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5453758594955492608UL, 4990853138221001728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<WorkerInterface>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetMasterWorkerActor, 1, Void >;
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetMasterWorkerActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<WorkerInterface>(),
		   GetMasterWorkerActorState<GetMasterWorkerActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMasterWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(126253898944419840UL, 13347791939979559936UL);
		ActorExecutionContextHelper __helper(static_cast<GetMasterWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMasterWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMasterWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMasterWorkerActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetMasterWorkerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<WorkerInterface> getMasterWorker( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<WorkerInterface>(new GetMasterWorkerActor(cx, dbInfo));
															#line 692 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 81 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the WorkerInterface representing the data distributor.
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataDistributorWorker()
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataDistributorWorkerActor>
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributorWorkerActorState {
															#line 705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributorWorkerActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 714 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataDistributorWorker", reinterpret_cast<unsigned long>(this));

	}
	~GetDataDistributorWorkerActorState() 
	{
		fdb_probe_actor_destroy("getDataDistributorWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("GetDataDistributorWorker").detail("Stage", "GettingWorkers");
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 731 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataDistributorWorkerActorState();
		static_cast<GetDataDistributorWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 87 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(dbInfo);
															#line 87 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataDistributorWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetDataDistributorWorkerActor*>(this)->actor_wait_state = 1;
															#line 87 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetDataDistributorWorkerActor*>(this)));
															#line 768 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 88 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!dbInfo->get().distributor.present())
															#line 777 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < workers.size();i++) {
															#line 92 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (workers[i].interf.address() == dbInfo->get().distributor.get().address())
															#line 785 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 93 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("GetDataDistributorWorker") .detail("Stage", "GotWorkers") .detail("DataDistributorId", dbInfo->get().distributor.get().id()) .detail("WorkerId", workers[i].interf.id());
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetDataDistributorWorkerActor*>(this)->SAV<WorkerInterface>::futures) { (void)(workers[i].interf); this->~GetDataDistributorWorkerActorState(); static_cast<GetDataDistributorWorkerActor*>(this)->destroy(); return 0; }
															#line 791 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetDataDistributorWorkerActor*>(this)->SAV< WorkerInterface >::value()) WorkerInterface(workers[i].interf);
				this->~GetDataDistributorWorkerActorState();
				static_cast<GetDataDistributorWorkerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent(SevWarn, "GetDataDistributorWorker") .detail("Error", "DataDistributorWorkerNotFound") .detail("DataDistributorId", dbInfo->get().distributor.get().id()) .detail("DataDistributorAddress", dbInfo->get().distributor.get().address()) .detail("WorkerCount", workers.size());
															#line 800 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 87 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 809 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataDistributorWorkerActor*>(this)->actor_wait_state > 0) static_cast<GetDataDistributorWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributorWorkerActor*>(this)->ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 87 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 890 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataDistributorWorker()
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributorWorkerActor final : public Actor<WorkerInterface>, public ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >, public FastAllocated<GetDataDistributorWorkerActor>, public GetDataDistributorWorkerActorState<GetDataDistributorWorkerActor> {
															#line 895 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataDistributorWorkerActor>::operator new;
	using FastAllocated<GetDataDistributorWorkerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11141736061334457600UL, 518266875216878848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<WorkerInterface>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >;
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributorWorkerActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 912 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<WorkerInterface>(),
		   GetDataDistributorWorkerActorState<GetDataDistributorWorkerActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(588571917037638656UL, 7461604007364582144UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributorWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataDistributorWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataDistributorWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataDistributorWorkerActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<WorkerInterface> getDataDistributorWorker( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<WorkerInterface>(new GetDataDistributorWorkerActor(cx, dbInfo));
															#line 945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the number of bytes in flight from the data distributor.
															#line 951 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataInFlight()
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataInFlightActor>
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataInFlightActorState {
															#line 958 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataInFlightActorState(Database const& cx,WorkerInterface const& distributorWorker) 
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker)
															#line 967 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataInFlight", reinterpret_cast<unsigned long>(this));

	}
	~GetDataInFlightActorState() 
	{
		fdb_probe_actor_destroy("getDataInFlight", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("DataInFlight").detail("Stage", "ContactingDataDistributor");
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<TraceEventFields> __when_expr_0 = timeoutError(distributorWorker.eventLogRequest.getReply(EventLogRequest("TotalDataInFlight"_sr)), 1.0);
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetDataInFlightActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 987 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetDataInFlightActor*>(this)->actor_wait_state = 1;
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*>(static_cast<GetDataInFlightActor*>(this)));
															#line 992 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataInFlightActorState();
		static_cast<GetDataInFlightActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", distributorWorker.id()) .error(e) .detail("Reason", "Failed to extract DataInFlight");
															#line 121 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1024 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields const& md,int loopDepth) 
	{
															#line 115 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t dataInFlight = boost::lexical_cast<int64_t>(md.getValue("TotalBytes"));
															#line 116 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataInFlightActor*>(this)->SAV<int64_t>::futures) { (void)(dataInFlight); this->~GetDataInFlightActorState(); static_cast<GetDataInFlightActor*>(this)->destroy(); return 0; }
															#line 1040 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataInFlightActor*>(this)->SAV< int64_t >::value()) int64_t(dataInFlight);
		this->~GetDataInFlightActorState();
		static_cast<GetDataInFlightActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && md,int loopDepth) 
	{
															#line 115 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t dataInFlight = boost::lexical_cast<int64_t>(md.getValue("TotalBytes"));
															#line 116 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataInFlightActor*>(this)->SAV<int64_t>::futures) { (void)(dataInFlight); this->~GetDataInFlightActorState(); static_cast<GetDataInFlightActor*>(this)->destroy(); return 0; }
															#line 1054 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataInFlightActor*>(this)->SAV< int64_t >::value()) int64_t(dataInFlight);
		this->~GetDataInFlightActorState();
		static_cast<GetDataInFlightActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TraceEventFields const& md,int loopDepth) 
	{
		loopDepth = a_body1cont2(md, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TraceEventFields && md,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(md), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataInFlightActor*>(this)->actor_wait_state > 0) static_cast<GetDataInFlightActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataInFlightActor*>(this)->ActorCallback< GetDataInFlightActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 1141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataInFlight()
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataInFlightActor final : public Actor<int64_t>, public ActorCallback< GetDataInFlightActor, 0, TraceEventFields >, public FastAllocated<GetDataInFlightActor>, public GetDataInFlightActorState<GetDataInFlightActor> {
															#line 1146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataInFlightActor>::operator new;
	using FastAllocated<GetDataInFlightActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6563488437375608576UL, 3324023739332323328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataInFlightActor, 0, TraceEventFields >;
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataInFlightActor(Database const& cx,WorkerInterface const& distributorWorker) 
															#line 1163 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDataInFlightActorState<GetDataInFlightActor>(cx, distributorWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12984054617648128512UL, 5570494499612544512UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataInFlight");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataInFlightActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getDataInFlight( Database const& cx, WorkerInterface const& distributorWorker ) {
															#line 110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetDataInFlightActor(cx, distributorWorker));
															#line 1196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the number of bytes in flight from the data distributor.
															#line 1202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataInFlight()
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataInFlightActor1>
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataInFlightActor1State {
															#line 1209 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataInFlightActor1State(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 1218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataInFlight", reinterpret_cast<unsigned long>(this));

	}
	~GetDataInFlightActor1State() 
	{
		fdb_probe_actor_destroy("getDataInFlight", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_0 = getDataDistributorWorker(cx, dbInfo);
															#line 127 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 1;
															#line 127 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*>(static_cast<GetDataInFlightActor1*>(this)));
															#line 1240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataInFlightActor1State();
		static_cast<GetDataInFlightActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface const& distributorInterf,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getDataInFlight(cx, distributorInterf);
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1265 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataInFlightActor1, 1, int64_t >*>(static_cast<GetDataInFlightActor1*>(this)));
															#line 1270 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface && distributorInterf,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getDataInFlight(cx, distributorInterf);
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataInFlightActor1, 1, int64_t >*>(static_cast<GetDataInFlightActor1*>(this)));
															#line 1286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(WorkerInterface const& distributorInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1(distributorInterf, loopDepth);

		return loopDepth;
	}
	int a_body1when1(WorkerInterface && distributorInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(distributorInterf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state > 0) static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 0;
		static_cast<GetDataInFlightActor1*>(this)->ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int64_t const& dataInFlight,int loopDepth) 
	{
															#line 129 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataInFlightActor1*>(this)->SAV<int64_t>::futures) { (void)(dataInFlight); this->~GetDataInFlightActor1State(); static_cast<GetDataInFlightActor1*>(this)->destroy(); return 0; }
															#line 1370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataInFlightActor1*>(this)->SAV< int64_t >::value()) int64_t(dataInFlight);
		this->~GetDataInFlightActor1State();
		static_cast<GetDataInFlightActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t && dataInFlight,int loopDepth) 
	{
															#line 129 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataInFlightActor1*>(this)->SAV<int64_t>::futures) { (void)(dataInFlight); this->~GetDataInFlightActor1State(); static_cast<GetDataInFlightActor1*>(this)->destroy(); return 0; }
															#line 1382 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataInFlightActor1*>(this)->SAV< int64_t >::value()) int64_t(dataInFlight);
		this->~GetDataInFlightActor1State();
		static_cast<GetDataInFlightActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& dataInFlight,int loopDepth) 
	{
		loopDepth = a_body1cont2(dataInFlight, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && dataInFlight,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dataInFlight), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDataInFlightActor1*>(this)->actor_wait_state > 0) static_cast<GetDataInFlightActor1*>(this)->actor_wait_state = 0;
		static_cast<GetDataInFlightActor1*>(this)->ActorCallback< GetDataInFlightActor1, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor1, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDataInFlightActor1, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDataInFlightActor1, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataInFlight()
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataInFlightActor1 final : public Actor<int64_t>, public ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >, public ActorCallback< GetDataInFlightActor1, 1, int64_t >, public FastAllocated<GetDataInFlightActor1>, public GetDataInFlightActor1State<GetDataInFlightActor1> {
															#line 1474 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataInFlightActor1>::operator new;
	using FastAllocated<GetDataInFlightActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6563488437375608576UL, 3324023739332323328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >;
friend struct ActorCallback< GetDataInFlightActor1, 1, int64_t >;
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataInFlightActor1(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDataInFlightActor1State<GetDataInFlightActor1>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataInFlight", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16099919889532499712UL, 8724869199332730624UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataInFlightActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataInFlight");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataInFlight", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataInFlightActor1, 0, WorkerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDataInFlightActor1, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getDataInFlight( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetDataInFlightActor1(cx, dbInfo));
															#line 1526 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Computes the queue size for storage servers and tlogs using the bytesInput and bytesDurable attributes
int64_t getQueueSize(const TraceEventFields& md) {
	double inputRate, durableRate;
	double inputRoughness, durableRoughness;
	int64_t inputBytes, durableBytes;

	sscanf(md.getValue("BytesInput").c_str(), "%lf %lf %" SCNd64, &inputRate, &inputRoughness, &inputBytes);
	sscanf(md.getValue("BytesDurable").c_str(), "%lf %lf %" SCNd64, &durableRate, &durableRoughness, &durableBytes);

	return inputBytes - durableBytes;
}

int64_t getDurableVersion(const TraceEventFields& md) {
	return boost::lexical_cast<int64_t>(md.getValue("DurableVersion"));
}

// Computes the popped version lag for tlogs
int64_t getPoppedVersionLag(const TraceEventFields& md) {
	int64_t persistentDataDurableVersion = boost::lexical_cast<int64_t>(md.getValue("PersistentDataDurableVersion"));
	int64_t queuePoppedVersion = boost::lexical_cast<int64_t>(md.getValue("QueuePoppedVersion"));

	return persistentDataDurableVersion - queuePoppedVersion;
}

															#line 1555 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getCoordWorkers()
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetCoordWorkersActor>
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetCoordWorkersActorState {
															#line 1562 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetCoordWorkersActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 1571 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getCoordWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetCoordWorkersActorState() 
	{
		fdb_probe_actor_destroy("getCoordWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(dbInfo);
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1588 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetCoordWorkersActor*>(this)));
															#line 1593 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetCoordWorkersActorState();
		static_cast<GetCoordWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); return tr->get(coordinatorsKey); });
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1618 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 2;
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*>(static_cast<GetCoordWorkersActor*>(this)));
															#line 1623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 1632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetCoordWorkersActor*>(this)->ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& coordinators,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!coordinators.present())
															#line 1711 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(operation_failed(), loopDepth);
															#line 1715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ClusterConnectionString ccs(coordinators.get().toString());
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_2 = ccs.tryResolveHostnames();
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1723 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 3;
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*>(static_cast<GetCoordWorkersActor*>(this)));
															#line 1728 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && coordinators,int loopDepth) 
	{
															#line 166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!coordinators.present())
															#line 1737 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(operation_failed(), loopDepth);
															#line 1741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ClusterConnectionString ccs(coordinators.get().toString());
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<NetworkAddress>> __when_expr_2 = ccs.tryResolveHostnames();
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 3;
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*>(static_cast<GetCoordWorkersActor*>(this)));
															#line 1754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& coordinators,int loopDepth) 
	{
		loopDepth = a_body1cont2(coordinators, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && coordinators,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(coordinators), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetCoordWorkersActor*>(this)->ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::vector<NetworkAddress> const& coordinatorsAddr,int loopDepth) 
	{
															#line 171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::set<NetworkAddress> coordinatorsAddrSet;
															#line 172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& addr : coordinatorsAddr ) {
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorAddress").detail("Addr", addr);
															#line 174 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			coordinatorsAddrSet.insert(addr);
															#line 1844 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<WorkerInterface> result;
															#line 178 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& worker : workers ) {
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			NetworkAddress primary = worker.interf.address();
															#line 180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			Optional<NetworkAddress> secondary = worker.interf.tLog.getEndpoint().addresses.secondaryAddress;
															#line 181 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (coordinatorsAddrSet.find(primary) != coordinatorsAddrSet.end() || (secondary.present() && (coordinatorsAddrSet.find(secondary.get()) != coordinatorsAddrSet.end())))
															#line 1856 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				result.push_back(worker.interf);
															#line 1860 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
		}
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetCoordWorkersActor*>(this)->SAV<std::vector<WorkerInterface>>::futures) { (void)(result); this->~GetCoordWorkersActorState(); static_cast<GetCoordWorkersActor*>(this)->destroy(); return 0; }
															#line 1865 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetCoordWorkersActor*>(this)->SAV< std::vector<WorkerInterface> >::value()) std::vector<WorkerInterface>(result);
		this->~GetCoordWorkersActorState();
		static_cast<GetCoordWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<NetworkAddress> && coordinatorsAddr,int loopDepth) 
	{
															#line 171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::set<NetworkAddress> coordinatorsAddrSet;
															#line 172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& addr : coordinatorsAddr ) {
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(SevDebug, "CoordinatorAddress").detail("Addr", addr);
															#line 174 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			coordinatorsAddrSet.insert(addr);
															#line 1883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<WorkerInterface> result;
															#line 178 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& worker : workers ) {
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			NetworkAddress primary = worker.interf.address();
															#line 180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			Optional<NetworkAddress> secondary = worker.interf.tLog.getEndpoint().addresses.secondaryAddress;
															#line 181 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (coordinatorsAddrSet.find(primary) != coordinatorsAddrSet.end() || (secondary.present() && (coordinatorsAddrSet.find(secondary.get()) != coordinatorsAddrSet.end())))
															#line 1895 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				result.push_back(worker.interf);
															#line 1899 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
		}
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetCoordWorkersActor*>(this)->SAV<std::vector<WorkerInterface>>::futures) { (void)(result); this->~GetCoordWorkersActorState(); static_cast<GetCoordWorkersActor*>(this)->destroy(); return 0; }
															#line 1904 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetCoordWorkersActor*>(this)->SAV< std::vector<WorkerInterface> >::value()) std::vector<WorkerInterface>(result);
		this->~GetCoordWorkersActorState();
		static_cast<GetCoordWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<NetworkAddress> const& coordinatorsAddr,int loopDepth) 
	{
		loopDepth = a_body1cont3(coordinatorsAddr, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<NetworkAddress> && coordinatorsAddr,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(coordinatorsAddr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetCoordWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetCoordWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetCoordWorkersActor*>(this)->ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 1993 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getCoordWorkers()
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetCoordWorkersActor final : public Actor<std::vector<WorkerInterface>>, public ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >, public ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >, public FastAllocated<GetCoordWorkersActor>, public GetCoordWorkersActorState<GetCoordWorkersActor> {
															#line 1998 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetCoordWorkersActor>::operator new;
	using FastAllocated<GetCoordWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12159662467813739776UL, 9586144272449769984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<WorkerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >;
friend struct ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >;
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetCoordWorkersActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 2017 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::vector<WorkerInterface>>(),
		   GetCoordWorkersActorState<GetCoordWorkersActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCoordWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6656396714784752384UL, 15106635022399449344UL);
		ActorExecutionContextHelper __helper(static_cast<GetCoordWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCoordWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCoordWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetCoordWorkersActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetCoordWorkersActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetCoordWorkersActor, 2, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::vector<WorkerInterface>> getCoordWorkers( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::vector<WorkerInterface>>(new GetCoordWorkersActor(cx, dbInfo));
															#line 2052 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// This is not robust in the face of a TLog failure
															#line 2058 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getTLogQueueInfo()
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetTLogQueueInfoActor>
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTLogQueueInfoActorState {
															#line 2065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTLogQueueInfoActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 2074 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getTLogQueueInfo", reinterpret_cast<unsigned long>(this));

	}
	~GetTLogQueueInfoActorState() 
	{
		fdb_probe_actor_destroy("getTLogQueueInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 192 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("MaxTLogQueueSize").detail("Stage", "ContactingLogs");
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(dbInfo);
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2093 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state = 1;
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*>(static_cast<GetTLogQueueInfoActor*>(this)));
															#line 2098 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTLogQueueInfoActorState();
		static_cast<GetTLogQueueInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 195 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::map<NetworkAddress, WorkerInterface> workersMap;
															#line 196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( auto worker : workers ) {
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 2125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		messages = std::vector<Future<TraceEventFields>>();
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tlogs = dbInfo->get().logSystemConfig.allPresentLogs();
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < tlogs.size();i++) {
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			auto itr = workersMap.find(tlogs[i].address());
															#line 204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (itr == workersMap.end())
															#line 2137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not find worker for log server") .detail("Tlog", tlogs[i].id());
															#line 208 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				return a_body1Catch1(attribute_not_found(), loopDepth);
															#line 2143 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 210 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			messages.push_back(timeoutError( itr->second.eventLogRequest.getReply(EventLogRequest(StringRef(tlogs[i].id().toString() + "/TLogMetrics"))), 1.0));
															#line 2147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 214 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(messages);
															#line 214 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state = 2;
															#line 214 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTLogQueueInfoActor, 1, Void >*>(static_cast<GetTLogQueueInfoActor*>(this)));
															#line 2158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 2167 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state > 0) static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogQueueInfoActor*>(this)->ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("MaxTLogQueueSize").detail("Stage", "ComputingMax").detail("MessageCount", messages.size());
															#line 218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxQueueSize = 0;
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxPoppedVersionLag = 0;
															#line 220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		i = 0;
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 2254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("MaxTLogQueueSize").detail("Stage", "ComputingMax").detail("MessageCount", messages.size());
															#line 218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxQueueSize = 0;
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxPoppedVersionLag = 0;
															#line 220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		i = 0;
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 2271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state > 0) static_cast<GetTLogQueueInfoActor*>(this)->actor_wait_state = 0;
		static_cast<GetTLogQueueInfoActor*>(this)->ActorCallback< GetTLogQueueInfoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTLogQueueInfoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTLogQueueInfoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTLogQueueInfoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 233 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetTLogQueueInfoActor*>(this)->SAV<std::pair<int64_t, int64_t>>::futures) { (void)(std::make_pair(maxQueueSize, maxPoppedVersionLag)); this->~GetTLogQueueInfoActorState(); static_cast<GetTLogQueueInfoActor*>(this)->destroy(); return 0; }
															#line 2355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetTLogQueueInfoActor*>(this)->SAV< std::pair<int64_t, int64_t> >::value()) std::pair<int64_t, int64_t>(std::make_pair(maxQueueSize, maxPoppedVersionLag));
		this->~GetTLogQueueInfoActorState();
		static_cast<GetTLogQueueInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!(i < messages.size()))
															#line 2374 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			maxQueueSize = std::max(maxQueueSize, getQueueSize(messages[i].get()));
															#line 224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			maxPoppedVersionLag = std::max(maxPoppedVersionLag, getPoppedVersionLag(messages[i].get()));
															#line 2383 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1cont2loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		i++;
															#line 2411 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 226 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure") .detail("Reason", "Failed to extract MaxTLogQueue") .detail("Tlog", tlogs[i].id());
															#line 229 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<Future<TraceEventFields>> messages;
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<TLogInterface> tlogs;
															#line 218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxQueueSize;
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxPoppedVersionLag;
															#line 220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int i;
															#line 2462 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getTLogQueueInfo()
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTLogQueueInfoActor final : public Actor<std::pair<int64_t, int64_t>>, public ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >, public ActorCallback< GetTLogQueueInfoActor, 1, Void >, public FastAllocated<GetTLogQueueInfoActor>, public GetTLogQueueInfoActorState<GetTLogQueueInfoActor> {
															#line 2467 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetTLogQueueInfoActor>::operator new;
	using FastAllocated<GetTLogQueueInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11470991450572216576UL, 195245823699437824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<int64_t, int64_t>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetTLogQueueInfoActor, 1, Void >;
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTLogQueueInfoActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 2485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::pair<int64_t, int64_t>>(),
		   GetTLogQueueInfoActorState<GetTLogQueueInfoActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(370706174253031168UL, 8003024138511153152UL);
		ActorExecutionContextHelper __helper(static_cast<GetTLogQueueInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTLogQueueInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTLogQueueInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTLogQueueInfoActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTLogQueueInfoActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::pair<int64_t, int64_t>> getTLogQueueInfo( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::pair<int64_t, int64_t>>(new GetTLogQueueInfoActor(cx, dbInfo));
															#line 2519 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Returns a vector of blob worker interfaces which have been persisted under the system key space
															#line 2525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getBlobWorkers()
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetBlobWorkersActor>
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetBlobWorkersActorState {
															#line 2532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetBlobWorkersActorState(Database const& cx,bool const& use_system_priority = false,Version* const& grv = nullptr) 
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   grv(grv),
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tr(cx)
															#line 2545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getBlobWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetBlobWorkersActorState() 
	{
		fdb_probe_actor_destroy("getBlobWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 2560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBlobWorkersActorState();
		static_cast<GetBlobWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 242 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (use_system_priority)
															#line 2590 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 2594 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 245 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 246 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 2600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		try {
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(blobWorkerListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2606 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBlobWorkersActor*>(this)->actor_wait_state = 1;
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBlobWorkersActor, 0, RangeResult >*>(static_cast<GetBlobWorkersActor*>(this)));
															#line 2611 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetBlobWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetBlobWorkersActor*>(this)->actor_wait_state = 2;
															#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBlobWorkersActor, 1, Void >*>(static_cast<GetBlobWorkersActor*>(this)));
															#line 2640 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& blobWorkersList,int loopDepth) 
	{
															#line 249 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(!blobWorkersList.more && blobWorkersList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<BlobWorkerInterface> blobWorkers;
															#line 252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		blobWorkers.reserve(blobWorkersList.size());
															#line 253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < blobWorkersList.size();i++) {
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			blobWorkers.push_back(decodeBlobWorkerListValue(blobWorkersList[i].value));
															#line 2663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 256 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (grv)
															#line 2667 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			*grv = tr.getReadVersion().get();
															#line 2671 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetBlobWorkersActor*>(this)->SAV<std::vector<BlobWorkerInterface>>::futures) { (void)(blobWorkers); this->~GetBlobWorkersActorState(); static_cast<GetBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 2675 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetBlobWorkersActor*>(this)->SAV< std::vector<BlobWorkerInterface> >::value()) std::vector<BlobWorkerInterface>(blobWorkers);
		this->~GetBlobWorkersActorState();
		static_cast<GetBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && blobWorkersList,int loopDepth) 
	{
															#line 249 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(!blobWorkersList.more && blobWorkersList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<BlobWorkerInterface> blobWorkers;
															#line 252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		blobWorkers.reserve(blobWorkersList.size());
															#line 253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < blobWorkersList.size();i++) {
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			blobWorkers.push_back(decodeBlobWorkerListValue(blobWorkersList[i].value));
															#line 2695 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 256 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (grv)
															#line 2699 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			*grv = tr.getReadVersion().get();
															#line 2703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetBlobWorkersActor*>(this)->SAV<std::vector<BlobWorkerInterface>>::futures) { (void)(blobWorkers); this->~GetBlobWorkersActorState(); static_cast<GetBlobWorkersActor*>(this)->destroy(); return 0; }
															#line 2707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetBlobWorkersActor*>(this)->SAV< std::vector<BlobWorkerInterface> >::value()) std::vector<BlobWorkerInterface>(blobWorkers);
		this->~GetBlobWorkersActorState();
		static_cast<GetBlobWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& blobWorkersList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(blobWorkersList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && blobWorkersList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(blobWorkersList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBlobWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetBlobWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlobWorkersActor*>(this)->ActorCallback< GetBlobWorkersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlobWorkersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBlobWorkersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBlobWorkersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBlobWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBlobWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetBlobWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlobWorkersActor*>(this)->ActorCallback< GetBlobWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlobWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBlobWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBlobWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBlobWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool use_system_priority;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version* grv;
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Transaction tr;
															#line 2885 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getBlobWorkers()
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetBlobWorkersActor final : public Actor<std::vector<BlobWorkerInterface>>, public ActorCallback< GetBlobWorkersActor, 0, RangeResult >, public ActorCallback< GetBlobWorkersActor, 1, Void >, public FastAllocated<GetBlobWorkersActor>, public GetBlobWorkersActorState<GetBlobWorkersActor> {
															#line 2890 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetBlobWorkersActor>::operator new;
	using FastAllocated<GetBlobWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5608973631892879872UL, 2004382664468039680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BlobWorkerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBlobWorkersActor, 0, RangeResult >;
friend struct ActorCallback< GetBlobWorkersActor, 1, Void >;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetBlobWorkersActor(Database const& cx,bool const& use_system_priority = false,Version* const& grv = nullptr) 
															#line 2908 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::vector<BlobWorkerInterface>>(),
		   GetBlobWorkersActorState<GetBlobWorkersActor>(cx, use_system_priority, grv),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBlobWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16474624763701027840UL, 3601149781609006592UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBlobWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBlobWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBlobWorkersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBlobWorkersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::vector<BlobWorkerInterface>> getBlobWorkers( Database const& cx, bool const& use_system_priority = false, Version* const& grv = nullptr ) {
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::vector<BlobWorkerInterface>>(new GetBlobWorkersActor(cx, use_system_priority, grv));
															#line 2942 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 265 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 2947 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getBlobWorkerAffinity()
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetBlobWorkerAffinityActor>
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetBlobWorkerAffinityActorState {
															#line 2954 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetBlobWorkerAffinityActorState(Database const& cx,bool const& use_system_priority = false,Version* const& grv = nullptr) 
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   grv(grv),
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tr(cx)
															#line 2967 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this));

	}
	~GetBlobWorkerAffinityActorState() 
	{
		fdb_probe_actor_destroy("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 270 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 2982 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBlobWorkerAffinityActorState();
		static_cast<GetBlobWorkerAffinityActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (use_system_priority)
															#line 3012 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 272 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 3016 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 274 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 275 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 3022 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		try {
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(blobWorkerAffinityKeys, CLIENT_KNOBS->TOO_MANY);
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetBlobWorkerAffinityActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3028 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBlobWorkerAffinityActor*>(this)->actor_wait_state = 1;
															#line 277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBlobWorkerAffinityActor, 0, RangeResult >*>(static_cast<GetBlobWorkerAffinityActor*>(this)));
															#line 3033 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetBlobWorkerAffinityActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3057 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetBlobWorkerAffinityActor*>(this)->actor_wait_state = 2;
															#line 290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBlobWorkerAffinityActor, 1, Void >*>(static_cast<GetBlobWorkerAffinityActor*>(this)));
															#line 3062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& blobWorkerAffinity,int loopDepth) 
	{
															#line 279 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<std::pair<UID, UID>> affinities;
															#line 280 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		affinities.reserve(blobWorkerAffinity.size());
															#line 281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < blobWorkerAffinity.size();i++) {
															#line 282 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			affinities.push_back(std::make_pair(decodeBlobWorkerAffinityKey(blobWorkerAffinity[i].key), decodeBlobWorkerAffinityValue(blobWorkerAffinity[i].value)));
															#line 3083 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 285 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (grv)
															#line 3087 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			*grv = tr.getReadVersion().get();
															#line 3091 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 288 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetBlobWorkerAffinityActor*>(this)->SAV<std::vector<std::pair<UID, UID>>>::futures) { (void)(affinities); this->~GetBlobWorkerAffinityActorState(); static_cast<GetBlobWorkerAffinityActor*>(this)->destroy(); return 0; }
															#line 3095 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetBlobWorkerAffinityActor*>(this)->SAV< std::vector<std::pair<UID, UID>> >::value()) std::vector<std::pair<UID, UID>>(affinities);
		this->~GetBlobWorkerAffinityActorState();
		static_cast<GetBlobWorkerAffinityActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && blobWorkerAffinity,int loopDepth) 
	{
															#line 279 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<std::pair<UID, UID>> affinities;
															#line 280 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		affinities.reserve(blobWorkerAffinity.size());
															#line 281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < blobWorkerAffinity.size();i++) {
															#line 282 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			affinities.push_back(std::make_pair(decodeBlobWorkerAffinityKey(blobWorkerAffinity[i].key), decodeBlobWorkerAffinityValue(blobWorkerAffinity[i].value)));
															#line 3113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 285 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (grv)
															#line 3117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 286 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			*grv = tr.getReadVersion().get();
															#line 3121 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 288 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetBlobWorkerAffinityActor*>(this)->SAV<std::vector<std::pair<UID, UID>>>::futures) { (void)(affinities); this->~GetBlobWorkerAffinityActorState(); static_cast<GetBlobWorkerAffinityActor*>(this)->destroy(); return 0; }
															#line 3125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetBlobWorkerAffinityActor*>(this)->SAV< std::vector<std::pair<UID, UID>> >::value()) std::vector<std::pair<UID, UID>>(affinities);
		this->~GetBlobWorkerAffinityActorState();
		static_cast<GetBlobWorkerAffinityActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& blobWorkerAffinity,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(blobWorkerAffinity, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && blobWorkerAffinity,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(blobWorkerAffinity), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBlobWorkerAffinityActor*>(this)->actor_wait_state > 0) static_cast<GetBlobWorkerAffinityActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlobWorkerAffinityActor*>(this)->ActorCallback< GetBlobWorkerAffinityActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlobWorkerAffinityActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkerAffinityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBlobWorkerAffinityActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkerAffinityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBlobWorkerAffinityActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkerAffinityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBlobWorkerAffinityActor*>(this)->actor_wait_state > 0) static_cast<GetBlobWorkerAffinityActor*>(this)->actor_wait_state = 0;
		static_cast<GetBlobWorkerAffinityActor*>(this)->ActorCallback< GetBlobWorkerAffinityActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBlobWorkerAffinityActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkerAffinityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBlobWorkerAffinityActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkerAffinityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBlobWorkerAffinityActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkerAffinityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool use_system_priority;
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version* grv;
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Transaction tr;
															#line 3303 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getBlobWorkerAffinity()
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetBlobWorkerAffinityActor final : public Actor<std::vector<std::pair<UID, UID>>>, public ActorCallback< GetBlobWorkerAffinityActor, 0, RangeResult >, public ActorCallback< GetBlobWorkerAffinityActor, 1, Void >, public FastAllocated<GetBlobWorkerAffinityActor>, public GetBlobWorkerAffinityActorState<GetBlobWorkerAffinityActor> {
															#line 3308 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetBlobWorkerAffinityActor>::operator new;
	using FastAllocated<GetBlobWorkerAffinityActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16454597817060495616UL, 7781985872599377152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<UID, UID>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBlobWorkerAffinityActor, 0, RangeResult >;
friend struct ActorCallback< GetBlobWorkerAffinityActor, 1, Void >;
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetBlobWorkerAffinityActor(Database const& cx,bool const& use_system_priority = false,Version* const& grv = nullptr) 
															#line 3326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::vector<std::pair<UID, UID>>>(),
		   GetBlobWorkerAffinityActorState<GetBlobWorkerAffinityActor>(cx, use_system_priority, grv),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12828189064696375808UL, 16623033726554310656UL);
		ActorExecutionContextHelper __helper(static_cast<GetBlobWorkerAffinityActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBlobWorkerAffinity");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBlobWorkerAffinity", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBlobWorkerAffinityActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBlobWorkerAffinityActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::vector<std::pair<UID, UID>>> getBlobWorkerAffinity( Database const& cx, bool const& use_system_priority = false, Version* const& grv = nullptr ) {
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::vector<std::pair<UID, UID>>>(new GetBlobWorkerAffinityActor(cx, use_system_priority, grv));
															#line 3360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 3365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServers()
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetStorageServersActor>
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageServersActorState {
															#line 3372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageServersActorState(Database const& cx,bool const& use_system_priority = false) 
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   use_system_priority(use_system_priority),
															#line 296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tr(cx)
															#line 3383 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersActorState() 
	{
		fdb_probe_actor_destroy("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 3398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (use_system_priority)
															#line 3428 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 3432 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 3438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		try {
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3444 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServersActor*>(this)->actor_wait_state = 1;
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 0, RangeResult >*>(static_cast<GetStorageServersActor*>(this)));
															#line 3449 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3473 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetStorageServersActor*>(this)->actor_wait_state = 2;
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 1, Void >*>(static_cast<GetStorageServersActor*>(this)));
															#line 3478 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult const& serverList,int loopDepth) 
	{
															#line 305 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<StorageServerInterface> servers;
															#line 308 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		servers.reserve(serverList.size());
															#line 309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 3501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 311 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(servers); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 3505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(servers);
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && serverList,int loopDepth) 
	{
															#line 305 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(!serverList.more && serverList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::vector<StorageServerInterface> servers;
															#line 308 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		servers.reserve(serverList.size());
															#line 309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			servers.push_back(decodeServerListValue(serverList[i].value));
															#line 3525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 311 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<std::vector<StorageServerInterface>>::futures) { (void)(servers); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 3529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< std::vector<StorageServerInterface> >::value()) std::vector<StorageServerInterface>(servers);
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(serverList, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && serverList,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(serverList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool use_system_priority;
															#line 296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Transaction tr;
															#line 3705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getStorageServers()
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageServersActor final : public Actor<std::vector<StorageServerInterface>>, public ActorCallback< GetStorageServersActor, 0, RangeResult >, public ActorCallback< GetStorageServersActor, 1, Void >, public FastAllocated<GetStorageServersActor>, public GetStorageServersActorState<GetStorageServersActor> {
															#line 3710 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetStorageServersActor>::operator new;
	using FastAllocated<GetStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14621762247852545280UL, 9389957081654550016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<StorageServerInterface>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersActor, 0, RangeResult >;
friend struct ActorCallback< GetStorageServersActor, 1, Void >;
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageServersActor(Database const& cx,bool const& use_system_priority = false) 
															#line 3728 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::vector<StorageServerInterface>>(),
		   GetStorageServersActorState<GetStorageServersActor>(cx, use_system_priority),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(503193769027834112UL, 12559137560131112960UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::vector<StorageServerInterface>> getStorageServers( Database const& cx, bool const& use_system_priority = false ) {
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::vector<StorageServerInterface>>(new GetStorageServersActor(cx, use_system_priority));
															#line 3762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 3767 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageWorkers()
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetStorageWorkersActor>
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageWorkersActorState {
															#line 3774 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageWorkersActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,bool const& localOnly) 
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   localOnly(localOnly)
															#line 3785 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageWorkersActorState() 
	{
		fdb_probe_actor_destroy("getStorageWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = getStorageServers(cx);
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3802 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 1;
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*>(static_cast<GetStorageWorkersActor*>(this)));
															#line 3807 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageWorkersActorState();
		static_cast<GetStorageWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 321 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workersMap = std::map<NetworkAddress, WorkerInterface>();
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = getWorkers(dbInfo);
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3834 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 2;
															#line 322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*>(static_cast<GetStorageWorkersActor*>(this)));
															#line 3839 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& __servers,int loopDepth) 
	{
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		servers = __servers;
															#line 3848 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && __servers,int loopDepth) 
	{
		servers = std::move(__servers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageWorkersActor*>(this)->ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
															#line 324 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& worker : workers ) {
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 3929 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); return tr->get("usable_regions"_sr.withPrefix(configKeysPrefix)); });
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3935 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 3;
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*>(static_cast<GetStorageWorkersActor*>(this)));
															#line 3940 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
															#line 324 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& worker : workers ) {
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 3951 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Optional<Value>> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); return tr->get("usable_regions"_sr.withPrefix(configKeysPrefix)); });
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3957 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 3;
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*>(static_cast<GetStorageWorkersActor*>(this)));
															#line 3962 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> const& workers,int loopDepth) 
	{
		loopDepth = a_body1cont2(workers, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> && workers,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageWorkersActor*>(this)->ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Optional<Value> const& regionsValue,int loopDepth) 
	{
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int usableRegions = 1;
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (regionsValue.present())
															#line 4048 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 335 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			usableRegions = atoi(regionsValue.get().toString().c_str());
															#line 4052 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto masterDcId = dbInfo->get().master.locality.dcId();
															#line 339 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::pair<std::vector<WorkerInterface>, int> result;
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto& [workerInterfaces, failures] = result;
															#line 341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		failures = 0;
															#line 342 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& server : servers ) {
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(SevDebug, "DcIdInfo") .detail("ServerLocalityID", server.locality.dcId()) .detail("MasterDcID", masterDcId);
															#line 346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!localOnly || (usableRegions == 1 || server.locality.dcId() == masterDcId))
															#line 4068 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 347 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto itr = workersMap.find(server.address());
															#line 348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (itr == workersMap.end())
															#line 4074 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					TraceEvent(SevWarn, "GetStorageWorkers") .detail("Reason", "Could not find worker for storage server") .detail("SS", server.id());
															#line 352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					++failures;
															#line 4080 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				}
				else
				{
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					workerInterfaces.push_back(itr->second);
															#line 4086 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				}
			}
		}
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageWorkersActor*>(this)->SAV<std::pair<std::vector<WorkerInterface>, int>>::futures) { (void)(result); this->~GetStorageWorkersActorState(); static_cast<GetStorageWorkersActor*>(this)->destroy(); return 0; }
															#line 4092 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageWorkersActor*>(this)->SAV< std::pair<std::vector<WorkerInterface>, int> >::value()) std::pair<std::vector<WorkerInterface>, int>(result);
		this->~GetStorageWorkersActorState();
		static_cast<GetStorageWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<Value> && regionsValue,int loopDepth) 
	{
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int usableRegions = 1;
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (regionsValue.present())
															#line 4106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 335 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			usableRegions = atoi(regionsValue.get().toString().c_str());
															#line 4110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto masterDcId = dbInfo->get().master.locality.dcId();
															#line 339 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::pair<std::vector<WorkerInterface>, int> result;
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto& [workerInterfaces, failures] = result;
															#line 341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		failures = 0;
															#line 342 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( const auto& server : servers ) {
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(SevDebug, "DcIdInfo") .detail("ServerLocalityID", server.locality.dcId()) .detail("MasterDcID", masterDcId);
															#line 346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!localOnly || (usableRegions == 1 || server.locality.dcId() == masterDcId))
															#line 4126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 347 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto itr = workersMap.find(server.address());
															#line 348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (itr == workersMap.end())
															#line 4132 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					TraceEvent(SevWarn, "GetStorageWorkers") .detail("Reason", "Could not find worker for storage server") .detail("SS", server.id());
															#line 352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					++failures;
															#line 4138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				}
				else
				{
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					workerInterfaces.push_back(itr->second);
															#line 4144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				}
			}
		}
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageWorkersActor*>(this)->SAV<std::pair<std::vector<WorkerInterface>, int>>::futures) { (void)(result); this->~GetStorageWorkersActorState(); static_cast<GetStorageWorkersActor*>(this)->destroy(); return 0; }
															#line 4150 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageWorkersActor*>(this)->SAV< std::pair<std::vector<WorkerInterface>, int> >::value()) std::pair<std::vector<WorkerInterface>, int>(result);
		this->~GetStorageWorkersActorState();
		static_cast<GetStorageWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> const& regionsValue,int loopDepth) 
	{
		loopDepth = a_body1cont3(regionsValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<Value> && regionsValue,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(regionsValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetStorageWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageWorkersActor*>(this)->ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool localOnly;
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<StorageServerInterface> servers;
															#line 321 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::map<NetworkAddress, WorkerInterface> workersMap;
															#line 4243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getStorageWorkers()
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageWorkersActor final : public Actor<std::pair<std::vector<WorkerInterface>, int>>, public ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >, public ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >, public FastAllocated<GetStorageWorkersActor>, public GetStorageWorkersActorState<GetStorageWorkersActor> {
															#line 4248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetStorageWorkersActor>::operator new;
	using FastAllocated<GetStorageWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11648184141290571520UL, 15580160276292533248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<std::vector<WorkerInterface>, int>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >;
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageWorkersActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,bool const& localOnly) 
															#line 4267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<std::pair<std::vector<WorkerInterface>, int>>(),
		   GetStorageWorkersActorState<GetStorageWorkersActor>(cx, dbInfo, localOnly),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10929927552547220992UL, 12825001964226426112UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageWorkersActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageWorkersActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetStorageWorkersActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<std::pair<std::vector<WorkerInterface>, int>> getStorageWorkers( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, bool const& localOnly ) {
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<std::pair<std::vector<WorkerInterface>, int>>(new GetStorageWorkersActor(cx, dbInfo, localOnly));
															#line 4302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Helper function to extract he maximum SQ size of all provided messages. All futures in the
// messages vector have to be ready.
int64_t extractMaxQueueSize(const std::vector<Future<TraceEventFields>>& messages,
                            const std::vector<StorageServerInterface>& servers) {

	int64_t maxQueueSize = 0;
	UID maxQueueServer;

	for (int i = 0; i < messages.size(); i++) {
		try {
			auto queueSize = getQueueSize(messages[i].get());
			if (queueSize > maxQueueSize) {
				maxQueueSize = queueSize;
				maxQueueServer = servers[i].id();
			}
		} catch (Error& e) {
			TraceEvent("QuietDatabaseFailure")
			    .detail("Reason", "Failed to extract MaxStorageServerQueue")
			    .detail("SS", servers[i].id());
			for (auto& m : messages) {
				TraceEvent("Messages").detail("Info", m.get().toString());
			}
			throw;
		}
	}

	TraceEvent("QuietDatabaseGotMaxStorageServerQueueSize")
	    .detail("Stage", "MaxComputed")
	    .detail("Max", maxQueueSize)
	    .detail("MaxQueueServer", maxQueueServer);
	return maxQueueSize;
}

// Timeout wrapper when getting the storage metrics. This will do some additional tracing
															#line 4341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageMetricsTimeout()
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetStorageMetricsTimeoutActor>
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageMetricsTimeoutActorState {
															#line 4348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageMetricsTimeoutActorState(UID const& storage,WorkerInterface const& wi,Version const& version) 
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : storage(storage),
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   wi(wi),
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   version(version),
															#line 396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   retries(0)
															#line 4361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageMetricsTimeoutActorState() 
	{
		fdb_probe_actor_destroy("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 4376 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageMetricsTimeoutActorState();
		static_cast<GetStorageMetricsTimeoutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		++retries;
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		eventLogReply = wi.eventLogRequest.getReply(EventLogRequest(StringRef(storage.toString() + "/StorageMetrics")));
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		timeout = delay(30.0);
															#line 402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageMetrics = TraceEventFields();
															#line 404 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_0 = store(storageMetrics, eventLogReply);
															#line 403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeout;
															#line 4420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state = 1;
															#line 404 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*>(static_cast<GetStorageMetricsTimeoutActor*>(this)));
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >*>(static_cast<GetStorageMetricsTimeoutActor*>(this)));
															#line 4427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 426 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (retries > 30)
															#line 4436 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not fetch StorageMetrics x30") .detail("Storage", storage) .detail("Version", version);
															#line 431 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 4442 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 433 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 433 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4448 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state = 2;
															#line 433 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*>(static_cast<GetStorageMetricsTimeoutActor*>(this)));
															#line 4453 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		try {
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (version == invalidVersion || getDurableVersion(storageMetrics) >= static_cast<int64_t>(version))
															#line 4463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 408 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetStorageMetricsTimeoutActor*>(this)->SAV<TraceEventFields>::futures) { (void)(storageMetrics); this->~GetStorageMetricsTimeoutActorState(); static_cast<GetStorageMetricsTimeoutActor*>(this)->destroy(); return 0; }
															#line 4467 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetStorageMetricsTimeoutActor*>(this)->SAV< TraceEventFields >::value()) TraceEventFields(std::move(storageMetrics)); // state_var_RVO
				this->~GetStorageMetricsTimeoutActorState();
				static_cast<GetStorageMetricsTimeoutActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			loopDepth = a_body1loopBody1when1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		try {
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (version == invalidVersion || getDurableVersion(storageMetrics) >= static_cast<int64_t>(version))
															#line 4488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 408 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetStorageMetricsTimeoutActor*>(this)->SAV<TraceEventFields>::futures) { (void)(storageMetrics); this->~GetStorageMetricsTimeoutActorState(); static_cast<GetStorageMetricsTimeoutActor*>(this)->destroy(); return 0; }
															#line 4492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetStorageMetricsTimeoutActor*>(this)->SAV< TraceEventFields >::value()) TraceEventFields(std::move(storageMetrics)); // state_var_RVO
				this->~GetStorageMetricsTimeoutActorState();
				static_cast<GetStorageMetricsTimeoutActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			loopDepth = a_body1loopBody1when1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1when1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1when1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not fetch StorageMetrics") .detail("Storage", storage);
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 4514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not fetch StorageMetrics") .detail("Storage", storage);
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		return a_body1Catch1(timed_out(), std::max(0, loopDepth - 1));
															#line 4524 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state > 0) static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageMetricsTimeoutActor*>(this)->ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >::remove();
		static_cast<GetStorageMetricsTimeoutActor*>(this)->ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >::remove();

	}
	int a_body1loopBody1when1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 411 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure") .error(e) .detail("Reason", "Failed to extract DurableVersion from StorageMetrics") .detail("SSID", storage) .detail("StorageMetrics", storageMetrics.toString());
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4548 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1when1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1when1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state > 0) static_cast<GetStorageMetricsTimeoutActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageMetricsTimeoutActor*>(this)->ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	UID storage;
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface wi;
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version version;
															#line 396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int retries;
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<TraceEventFields> eventLogReply;
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<Void> timeout;
															#line 402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	TraceEventFields storageMetrics;
															#line 4786 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getStorageMetricsTimeout()
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageMetricsTimeoutActor final : public Actor<TraceEventFields>, public ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >, public ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >, public ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >, public FastAllocated<GetStorageMetricsTimeoutActor>, public GetStorageMetricsTimeoutActorState<GetStorageMetricsTimeoutActor> {
															#line 4791 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetStorageMetricsTimeoutActor>::operator new;
	using FastAllocated<GetStorageMetricsTimeoutActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4370861006013514496UL, 3059257575828539904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TraceEventFields>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >;
friend struct ActorCallback< GetStorageMetricsTimeoutActor, 1, Void >;
friend struct ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >;
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageMetricsTimeoutActor(UID const& storage,WorkerInterface const& wi,Version const& version) 
															#line 4810 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<TraceEventFields>(),
		   GetStorageMetricsTimeoutActorState<GetStorageMetricsTimeoutActor>(storage, wi, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7551662535136818944UL, 6468539700573326848UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageMetricsTimeoutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageMetricsTimeout");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageMetricsTimeout", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageMetricsTimeoutActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageMetricsTimeoutActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<TraceEventFields> getStorageMetricsTimeout( UID const& storage, WorkerInterface const& wi, Version const& version ) {
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<TraceEventFields>(new GetStorageMetricsTimeoutActor(storage, wi, version));
															#line 4844 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 436 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the maximum size of all the storage server queues
															#line 4850 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getMaxStorageServerQueueSize()
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetMaxStorageServerQueueSizeActor>
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetMaxStorageServerQueueSizeActorState {
															#line 4857 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetMaxStorageServerQueueSizeActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Version const& version) 
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   version(version)
															#line 4868 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this));

	}
	~GetMaxStorageServerQueueSizeActorState() 
	{
		fdb_probe_actor_destroy("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 442 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("MaxStorageServerQueueSize").detail("Stage", "ContactingStorageServers");
															#line 444 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			Future<std::vector<StorageServerInterface>> serversFuture = getStorageServers(cx);
															#line 445 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersFuture = getWorkers(dbInfo);
															#line 447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<std::vector<StorageServerInterface>> __when_expr_0 = serversFuture;
															#line 447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4891 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 1;
															#line 447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*>(static_cast<GetMaxStorageServerQueueSizeActor*>(this)));
															#line 4896 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetMaxStorageServerQueueSizeActorState();
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 448 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<std::vector<WorkerDetails>> __when_expr_1 = workersFuture;
															#line 448 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4921 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 2;
															#line 448 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*>(static_cast<GetMaxStorageServerQueueSizeActor*>(this)));
															#line 4926 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> const& __servers,int loopDepth) 
	{
															#line 447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		servers = __servers;
															#line 4935 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<StorageServerInterface> && __servers,int loopDepth) 
	{
		servers = std::move(__servers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state > 0) static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> const& value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*,std::vector<StorageServerInterface> && value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 450 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::map<NetworkAddress, WorkerInterface> workersMap;
															#line 451 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for( auto worker : workers ) {
															#line 452 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			workersMap[worker.interf.address()] = worker.interf;
															#line 5018 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 455 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		messages = std::vector<Future<TraceEventFields>>();
															#line 456 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		for(int i = 0;i < servers.size();i++) {
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			auto itr = workersMap.find(servers[i].address());
															#line 458 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (itr == workersMap.end())
															#line 5028 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("QuietDatabaseFailure") .detail("Reason", "Could not find worker for storage server") .detail("SS", servers[i].id());
															#line 462 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				return a_body1Catch1(attribute_not_found(), loopDepth);
															#line 5034 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 464 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			messages.push_back(getStorageMetricsTimeout(servers[i].id(), itr->second, version));
															#line 5038 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 467 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(messages);
															#line 467 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5044 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 3;
															#line 467 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*>(static_cast<GetMaxStorageServerQueueSizeActor*>(this)));
															#line 5049 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> const& __workers,int loopDepth) 
	{
															#line 448 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		workers = __workers;
															#line 5058 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<WorkerDetails> && __workers,int loopDepth) 
	{
		workers = std::move(__workers);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state > 0) static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("MaxStorageServerQueueSize").detail("Stage", "ComputingMax").detail("MessageCount", messages.size());
															#line 471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetMaxStorageServerQueueSizeActor*>(this)->SAV<int64_t>::futures) { (void)(extractMaxQueueSize(messages, servers)); this->~GetMaxStorageServerQueueSizeActorState(); static_cast<GetMaxStorageServerQueueSizeActor*>(this)->destroy(); return 0; }
															#line 5139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetMaxStorageServerQueueSizeActor*>(this)->SAV< int64_t >::value()) int64_t(extractMaxQueueSize(messages, servers));
		this->~GetMaxStorageServerQueueSizeActorState();
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("MaxStorageServerQueueSize").detail("Stage", "ComputingMax").detail("MessageCount", messages.size());
															#line 471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetMaxStorageServerQueueSizeActor*>(this)->SAV<int64_t>::futures) { (void)(extractMaxQueueSize(messages, servers)); this->~GetMaxStorageServerQueueSizeActorState(); static_cast<GetMaxStorageServerQueueSizeActor*>(this)->destroy(); return 0; }
															#line 5153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetMaxStorageServerQueueSizeActor*>(this)->SAV< int64_t >::value()) int64_t(extractMaxQueueSize(messages, servers));
		this->~GetMaxStorageServerQueueSizeActorState();
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state > 0) static_cast<GetMaxStorageServerQueueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetMaxStorageServerQueueSizeActor*>(this)->ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version version;
															#line 445 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<std::vector<WorkerDetails>> workersFuture;
															#line 447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<StorageServerInterface> servers;
															#line 448 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<WorkerDetails> workers;
															#line 455 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::vector<Future<TraceEventFields>> messages;
															#line 5250 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getMaxStorageServerQueueSize()
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetMaxStorageServerQueueSizeActor final : public Actor<int64_t>, public ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >, public ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >, public ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >, public FastAllocated<GetMaxStorageServerQueueSizeActor>, public GetMaxStorageServerQueueSizeActorState<GetMaxStorageServerQueueSizeActor> {
															#line 5255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetMaxStorageServerQueueSizeActor>::operator new;
	using FastAllocated<GetMaxStorageServerQueueSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3206124668149943808UL, 14037470705177020160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >;
friend struct ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >;
friend struct ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >;
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetMaxStorageServerQueueSizeActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Version const& version) 
															#line 5274 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetMaxStorageServerQueueSizeActorState<GetMaxStorageServerQueueSizeActor>(cx, dbInfo, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3846086542767416832UL, 5760051474831440384UL);
		ActorExecutionContextHelper __helper(static_cast<GetMaxStorageServerQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getMaxStorageServerQueueSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getMaxStorageServerQueueSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetMaxStorageServerQueueSizeActor, 0, std::vector<StorageServerInterface> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetMaxStorageServerQueueSizeActor, 1, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetMaxStorageServerQueueSizeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getMaxStorageServerQueueSize( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Version const& version ) {
															#line 438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetMaxStorageServerQueueSizeActor(cx, dbInfo, version));
															#line 5309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 473 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the size of the data distribution queue.  If reportInFlight is true, then data in flight is considered part of
// the queue
															#line 5316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataDistributionQueueSize()
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataDistributionQueueSizeActor>
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionQueueSizeActorState {
															#line 5323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionQueueSizeActorState(Database const& cx,WorkerInterface const& distributorWorker,bool const& reportInFlight) 
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker),
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   reportInFlight(reportInFlight)
															#line 5334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this));

	}
	~GetDataDistributionQueueSizeActorState() 
	{
		fdb_probe_actor_destroy("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 480 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("DataDistributionQueueSize").detail("Stage", "ContactingDataDistributor");
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<TraceEventFields> __when_expr_0 = timeoutError(distributorWorker.eventLogRequest.getReply(EventLogRequest("MovingData"_sr)), 1.0);
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetDataDistributionQueueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetDataDistributionQueueSizeActor*>(this)->actor_wait_state = 1;
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*>(static_cast<GetDataDistributionQueueSizeActor*>(this)));
															#line 5359 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataDistributionQueueSizeActorState();
		static_cast<GetDataDistributionQueueSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", distributorWorker.id()) .detail("Reason", "Failed to extract DataDistributionQueueSize");
															#line 498 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields const& movingDataMessage,int loopDepth) 
	{
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("DataDistributionQueueSize").detail("Stage", "GotString");
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t inQueue = boost::lexical_cast<int64_t>(movingDataMessage.getValue("InQueue"));
															#line 489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (reportInFlight)
															#line 5409 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 490 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			int64_t inFlight = boost::lexical_cast<int64_t>(movingDataMessage.getValue("InFlight"));
															#line 491 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			inQueue += inFlight;
															#line 5415 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 494 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionQueueSizeActor*>(this)->SAV<int64_t>::futures) { (void)(inQueue); this->~GetDataDistributionQueueSizeActorState(); static_cast<GetDataDistributionQueueSizeActor*>(this)->destroy(); return 0; }
															#line 5419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionQueueSizeActor*>(this)->SAV< int64_t >::value()) int64_t(inQueue);
		this->~GetDataDistributionQueueSizeActorState();
		static_cast<GetDataDistributionQueueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && movingDataMessage,int loopDepth) 
	{
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("DataDistributionQueueSize").detail("Stage", "GotString");
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t inQueue = boost::lexical_cast<int64_t>(movingDataMessage.getValue("InQueue"));
															#line 489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (reportInFlight)
															#line 5435 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 490 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			int64_t inFlight = boost::lexical_cast<int64_t>(movingDataMessage.getValue("InFlight"));
															#line 491 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			inQueue += inFlight;
															#line 5441 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
															#line 494 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionQueueSizeActor*>(this)->SAV<int64_t>::futures) { (void)(inQueue); this->~GetDataDistributionQueueSizeActorState(); static_cast<GetDataDistributionQueueSizeActor*>(this)->destroy(); return 0; }
															#line 5445 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionQueueSizeActor*>(this)->SAV< int64_t >::value()) int64_t(inQueue);
		this->~GetDataDistributionQueueSizeActorState();
		static_cast<GetDataDistributionQueueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TraceEventFields const& movingDataMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(movingDataMessage, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TraceEventFields && movingDataMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(movingDataMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataDistributionQueueSizeActor*>(this)->actor_wait_state > 0) static_cast<GetDataDistributionQueueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributionQueueSizeActor*>(this)->ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool reportInFlight;
															#line 5534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataDistributionQueueSize()
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionQueueSizeActor final : public Actor<int64_t>, public ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >, public FastAllocated<GetDataDistributionQueueSizeActor>, public GetDataDistributionQueueSizeActorState<GetDataDistributionQueueSizeActor> {
															#line 5539 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataDistributionQueueSizeActor>::operator new;
	using FastAllocated<GetDataDistributionQueueSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16633504669458880768UL, 13931061728545675520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >;
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionQueueSizeActor(Database const& cx,WorkerInterface const& distributorWorker,bool const& reportInFlight) 
															#line 5556 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDataDistributionQueueSizeActorState<GetDataDistributionQueueSizeActor>(cx, distributorWorker, reportInFlight),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3628305357356396544UL, 10461804314796803328UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataDistributionQueueSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataDistributionQueueSizeActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getDataDistributionQueueSize( Database const& cx, WorkerInterface const& distributorWorker, bool const& reportInFlight ) {
															#line 476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetDataDistributionQueueSizeActor(cx, distributorWorker, reportInFlight));
															#line 5589 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the size of the data distribution queue.  If reportInFlight is true, then data in flight is considered part of
// the queue Convenience method that first finds the master worker from a zookeeper interface
															#line 5596 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataDistributionQueueSize()
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataDistributionQueueSizeActor1>
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionQueueSizeActor1State {
															#line 5603 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionQueueSizeActor1State(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,bool const& reportInFlight) 
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   reportInFlight(reportInFlight)
															#line 5614 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this));

	}
	~GetDataDistributionQueueSizeActor1State() 
	{
		fdb_probe_actor_destroy("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_0 = getDataDistributorWorker(cx, dbInfo);
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5631 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 1;
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*>(static_cast<GetDataDistributionQueueSizeActor1*>(this)));
															#line 5636 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataDistributionQueueSizeActor1State();
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface const& distributorInterf,int loopDepth) 
	{
															#line 508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getDataDistributionQueueSize(cx, distributorInterf, reportInFlight);
															#line 508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 2;
															#line 508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*>(static_cast<GetDataDistributionQueueSizeActor1*>(this)));
															#line 5666 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface && distributorInterf,int loopDepth) 
	{
															#line 508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = getDataDistributionQueueSize(cx, distributorInterf, reportInFlight);
															#line 508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 2;
															#line 508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*>(static_cast<GetDataDistributionQueueSizeActor1*>(this)));
															#line 5682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(WorkerInterface const& distributorInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1(distributorInterf, loopDepth);

		return loopDepth;
	}
	int a_body1when1(WorkerInterface && distributorInterf,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(distributorInterf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state > 0) static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int64_t const& inQueue,int loopDepth) 
	{
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionQueueSizeActor1*>(this)->SAV<int64_t>::futures) { (void)(inQueue); this->~GetDataDistributionQueueSizeActor1State(); static_cast<GetDataDistributionQueueSizeActor1*>(this)->destroy(); return 0; }
															#line 5766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionQueueSizeActor1*>(this)->SAV< int64_t >::value()) int64_t(inQueue);
		this->~GetDataDistributionQueueSizeActor1State();
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t && inQueue,int loopDepth) 
	{
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionQueueSizeActor1*>(this)->SAV<int64_t>::futures) { (void)(inQueue); this->~GetDataDistributionQueueSizeActor1State(); static_cast<GetDataDistributionQueueSizeActor1*>(this)->destroy(); return 0; }
															#line 5778 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionQueueSizeActor1*>(this)->SAV< int64_t >::value()) int64_t(inQueue);
		this->~GetDataDistributionQueueSizeActor1State();
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& inQueue,int loopDepth) 
	{
		loopDepth = a_body1cont2(inQueue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && inQueue,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(inQueue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state > 0) static_cast<GetDataDistributionQueueSizeActor1*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributionQueueSizeActor1*>(this)->ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool reportInFlight;
															#line 5867 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataDistributionQueueSize()
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionQueueSizeActor1 final : public Actor<int64_t>, public ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >, public ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >, public FastAllocated<GetDataDistributionQueueSizeActor1>, public GetDataDistributionQueueSizeActor1State<GetDataDistributionQueueSizeActor1> {
															#line 5872 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataDistributionQueueSizeActor1>::operator new;
	using FastAllocated<GetDataDistributionQueueSizeActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16633504669458880768UL, 13931061728545675520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >;
friend struct ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >;
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionQueueSizeActor1(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,bool const& reportInFlight) 
															#line 5890 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetDataDistributionQueueSizeActor1State<GetDataDistributionQueueSizeActor1>(cx, dbInfo, reportInFlight),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7272709098130670336UL, 15142656947648547328UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionQueueSizeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataDistributionQueueSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataDistributionQueueSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataDistributionQueueSizeActor1, 0, WorkerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDataDistributionQueueSizeActor1, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getDataDistributionQueueSize( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, bool const& reportInFlight ) {
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetDataDistributionQueueSizeActor1(cx, dbInfo, reportInFlight));
															#line 5924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets if the number of process and machine teams does not exceed the maximum allowed number of teams
															#line 5930 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getTeamCollectionValid()
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetTeamCollectionValidActor>
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTeamCollectionValidActorState {
															#line 5937 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTeamCollectionValidActorState(Database const& cx,WorkerInterface const& dataDistributorWorker) 
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataDistributorWorker(dataDistributorWorker),
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   attempts(0),
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   ret(false)
															#line 5950 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getTeamCollectionValid", reinterpret_cast<unsigned long>(this));

	}
	~GetTeamCollectionValidActorState() 
	{
		fdb_probe_actor_destroy("getTeamCollectionValid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 5965 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTeamCollectionValidActorState();
		static_cast<GetTeamCollectionValidActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 518 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!g_network->isSimulated())
															#line 5996 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 519 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 6000 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(true);
				this->~GetTeamCollectionValidActorState();
				static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("GetTeamCollectionValid").detail("Stage", "ContactingMaster");
															#line 524 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<TraceEventFields> __when_expr_0 = timeoutError( dataDistributorWorker.eventLogRequest.getReply(EventLogRequest("TeamCollectionInfo"_sr)), 1.0);
															#line 524 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6012 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 1;
															#line 524 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*>(static_cast<GetTeamCollectionValidActor*>(this)));
															#line 6017 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 602 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6039 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 603 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6043 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", dataDistributorWorker.id()) .detail("Reason", "Failed to extract GetTeamCollectionValid information");
															#line 607 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			attempts++;
															#line 608 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (attempts > 10)
															#line 6051 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("QuietDatabaseNoTeamCollectionInfo", dataDistributorWorker.id()) .detail("Reason", "Had never called build team to build any team");
															#line 611 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 6057 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(true);
				this->~GetTeamCollectionValidActorState();
				static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 614 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(10.0);
															#line 614 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6067 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 3;
															#line 614 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor, 2, Void >*>(static_cast<GetTeamCollectionValidActor*>(this)));
															#line 6072 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(TraceEventFields const& teamCollectionInfoMessage,int loopDepth) 
	{
															#line 527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("GetTeamCollectionValid").detail("Stage", "GotString");
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		currentTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentServerTeams"));
															#line 531 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		desiredTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("DesiredTeams"));
															#line 533 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxTeams"));
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		currentMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentMachineTeams"));
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		healthyMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentHealthyMachineTeams"));
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		desiredMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("DesiredMachineTeams"));
															#line 540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxMachineTeams"));
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		minServerTeamsOnServer = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MinTeamsOnServer"));
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxServerTeamsOnServer = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxTeamsOnServer"));
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		minMachineTeamsOnMachine = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MinMachineTeamsOnMachine"));
															#line 549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxMachineTeamsOnMachine = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxMachineTeamsOnMachine"));
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if ((minMachineTeamsOnMachine <= 0 || minServerTeamsOnServer <= 0) && SERVER_KNOBS->TR_FLAG_REMOVE_MT_WITH_MOST_TEAMS)
															#line 6111 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			ret = false;
															#line 572 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (attempts++ < 10)
															#line 6117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 573 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(60);
															#line 573 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 2;
															#line 573 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor, 1, Void >*>(static_cast<GetTeamCollectionValidActor*>(this)));
															#line 6128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 6140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GetTeamCollectionValidActorState();
			static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(TraceEventFields && teamCollectionInfoMessage,int loopDepth) 
	{
															#line 527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("GetTeamCollectionValid").detail("Stage", "GotString");
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		currentTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentServerTeams"));
															#line 531 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		desiredTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("DesiredTeams"));
															#line 533 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxTeams"));
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		currentMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentMachineTeams"));
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		healthyMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("CurrentHealthyMachineTeams"));
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		desiredMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("DesiredMachineTeams"));
															#line 540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxMachineTeams = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxMachineTeams"));
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		minServerTeamsOnServer = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MinTeamsOnServer"));
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxServerTeamsOnServer = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxTeamsOnServer"));
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		minMachineTeamsOnMachine = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MinMachineTeamsOnMachine"));
															#line 549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxMachineTeamsOnMachine = boost::lexical_cast<int64_t>(teamCollectionInfoMessage.getValue("MaxMachineTeamsOnMachine"));
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if ((minMachineTeamsOnMachine <= 0 || minServerTeamsOnServer <= 0) && SERVER_KNOBS->TR_FLAG_REMOVE_MT_WITH_MOST_TEAMS)
															#line 6177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			ret = false;
															#line 572 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (attempts++ < 10)
															#line 6183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 573 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_1 = delay(60);
															#line 573 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
				static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 2;
															#line 573 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor, 1, Void >*>(static_cast<GetTeamCollectionValidActor*>(this)));
															#line 6194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont5(loopDepth);
			}
		}
		else
		{
															#line 598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 6206 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(true);
			this->~GetTeamCollectionValidActorState();
			static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(TraceEventFields const& teamCollectionInfoMessage,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(teamCollectionInfoMessage, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TraceEventFields && teamCollectionInfoMessage,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(teamCollectionInfoMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor*>(this)->ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 581 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("GetTeamCollectionValid") .detail("CurrentServerTeams", currentTeams) .detail("DesiredTeams", desiredTeams) .detail("MaxTeams", maxTeams) .detail("CurrentHealthyMachineTeams", healthyMachineTeams) .detail("DesiredMachineTeams", desiredMachineTeams) .detail("CurrentMachineTeams", currentMachineTeams) .detail("MaxMachineTeams", maxMachineTeams) .detail("MinTeamsOnServer", minServerTeamsOnServer) .detail("MaxTeamsOnServer", maxServerTeamsOnServer) .detail("MinMachineTeamsOnMachine", minMachineTeamsOnMachine) .detail("MaxMachineTeamsOnMachine", maxMachineTeamsOnMachine) .detail("DesiredTeamsPerServer", SERVER_KNOBS->DESIRED_TEAMS_PER_SERVER) .detail("MaxTeamsPerServer", SERVER_KNOBS->MAX_TEAMS_PER_SERVER) .detail("RemoveMTWithMostTeams", SERVER_KNOBS->TR_FLAG_REMOVE_MT_WITH_MOST_TEAMS);
															#line 596 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetTeamCollectionValidActor*>(this)->SAV<bool>::futures) { (void)(ret); this->~GetTeamCollectionValidActorState(); static_cast<GetTeamCollectionValidActor*>(this)->destroy(); return 0; }
															#line 6296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetTeamCollectionValidActor*>(this)->SAV< bool >::value()) bool(std::move(ret)); // state_var_RVO
		this->~GetTeamCollectionValidActorState();
		static_cast<GetTeamCollectionValidActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor*>(this)->ActorCallback< GetTeamCollectionValidActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor*>(this)->ActorCallback< GetTeamCollectionValidActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface dataDistributorWorker;
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int attempts;
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool ret;
															#line 529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t currentTeams;
															#line 531 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t desiredTeams;
															#line 533 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxTeams;
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t currentMachineTeams;
															#line 536 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t healthyMachineTeams;
															#line 538 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t desiredMachineTeams;
															#line 540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxMachineTeams;
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t minServerTeamsOnServer;
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxServerTeamsOnServer;
															#line 547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t minMachineTeamsOnMachine;
															#line 549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxMachineTeamsOnMachine;
															#line 6508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getTeamCollectionValid()
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTeamCollectionValidActor final : public Actor<bool>, public ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >, public ActorCallback< GetTeamCollectionValidActor, 1, Void >, public ActorCallback< GetTeamCollectionValidActor, 2, Void >, public FastAllocated<GetTeamCollectionValidActor>, public GetTeamCollectionValidActorState<GetTeamCollectionValidActor> {
															#line 6513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetTeamCollectionValidActor>::operator new;
	using FastAllocated<GetTeamCollectionValidActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5160831399085053952UL, 2078612847006629376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >;
friend struct ActorCallback< GetTeamCollectionValidActor, 1, Void >;
friend struct ActorCallback< GetTeamCollectionValidActor, 2, Void >;
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTeamCollectionValidActor(Database const& cx,WorkerInterface const& dataDistributorWorker) 
															#line 6532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<bool>(),
		   GetTeamCollectionValidActorState<GetTeamCollectionValidActor>(cx, dataDistributorWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13786627008753859072UL, 2126391119096204800UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTeamCollectionValid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<bool> getTeamCollectionValid( Database const& cx, WorkerInterface const& dataDistributorWorker ) {
															#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<bool>(new GetTeamCollectionValidActor(cx, dataDistributorWorker));
															#line 6567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 618 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets if the number of process and machine teams does not exceed the maximum allowed number of teams
// Convenience method that first finds the master worker from a zookeeper interface
															#line 6574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getTeamCollectionValid()
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetTeamCollectionValidActor1>
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTeamCollectionValidActor1State {
															#line 6581 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTeamCollectionValidActor1State(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 6590 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getTeamCollectionValid", reinterpret_cast<unsigned long>(this));

	}
	~GetTeamCollectionValidActor1State() 
	{
		fdb_probe_actor_destroy("getTeamCollectionValid", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_0 = getDataDistributorWorker(cx, dbInfo);
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6607 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 1;
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*>(static_cast<GetTeamCollectionValidActor1*>(this)));
															#line 6612 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTeamCollectionValidActor1State();
		static_cast<GetTeamCollectionValidActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface const& dataDistributorWorker,int loopDepth) 
	{
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<bool> __when_expr_1 = getTeamCollectionValid(cx, dataDistributorWorker);
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 2;
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor1, 1, bool >*>(static_cast<GetTeamCollectionValidActor1*>(this)));
															#line 6642 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(WorkerInterface && dataDistributorWorker,int loopDepth) 
	{
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<bool> __when_expr_1 = getTeamCollectionValid(cx, dataDistributorWorker);
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6653 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 2;
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetTeamCollectionValidActor1, 1, bool >*>(static_cast<GetTeamCollectionValidActor1*>(this)));
															#line 6658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(WorkerInterface const& dataDistributorWorker,int loopDepth) 
	{
		loopDepth = a_body1cont1(dataDistributorWorker, loopDepth);

		return loopDepth;
	}
	int a_body1when1(WorkerInterface && dataDistributorWorker,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(dataDistributorWorker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor1*>(this)->ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(bool const& valid,int loopDepth) 
	{
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetTeamCollectionValidActor1*>(this)->SAV<bool>::futures) { (void)(valid); this->~GetTeamCollectionValidActor1State(); static_cast<GetTeamCollectionValidActor1*>(this)->destroy(); return 0; }
															#line 6742 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetTeamCollectionValidActor1*>(this)->SAV< bool >::value()) bool(valid);
		this->~GetTeamCollectionValidActor1State();
		static_cast<GetTeamCollectionValidActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(bool && valid,int loopDepth) 
	{
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetTeamCollectionValidActor1*>(this)->SAV<bool>::futures) { (void)(valid); this->~GetTeamCollectionValidActor1State(); static_cast<GetTeamCollectionValidActor1*>(this)->destroy(); return 0; }
															#line 6754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetTeamCollectionValidActor1*>(this)->SAV< bool >::value()) bool(valid);
		this->~GetTeamCollectionValidActor1State();
		static_cast<GetTeamCollectionValidActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& valid,int loopDepth) 
	{
		loopDepth = a_body1cont2(valid, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && valid,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(valid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state > 0) static_cast<GetTeamCollectionValidActor1*>(this)->actor_wait_state = 0;
		static_cast<GetTeamCollectionValidActor1*>(this)->ActorCallback< GetTeamCollectionValidActor1, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor1, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetTeamCollectionValidActor1, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetTeamCollectionValidActor1, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 6841 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getTeamCollectionValid()
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetTeamCollectionValidActor1 final : public Actor<bool>, public ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >, public ActorCallback< GetTeamCollectionValidActor1, 1, bool >, public FastAllocated<GetTeamCollectionValidActor1>, public GetTeamCollectionValidActor1State<GetTeamCollectionValidActor1> {
															#line 6846 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetTeamCollectionValidActor1>::operator new;
	using FastAllocated<GetTeamCollectionValidActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5160831399085053952UL, 2078612847006629376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >;
friend struct ActorCallback< GetTeamCollectionValidActor1, 1, bool >;
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetTeamCollectionValidActor1(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 6864 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<bool>(),
		   GetTeamCollectionValidActor1State<GetTeamCollectionValidActor1>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1263504681258774016UL, 16594126347194509824UL);
		ActorExecutionContextHelper __helper(static_cast<GetTeamCollectionValidActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTeamCollectionValid");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTeamCollectionValid", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor1, 0, WorkerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetTeamCollectionValidActor1, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<bool> getTeamCollectionValid( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<bool>(new GetTeamCollectionValidActor1(cx, dbInfo));
															#line 6898 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Checks that data distribution is active
															#line 6904 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDataDistributionActive()
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDataDistributionActiveActor>
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionActiveActorState {
															#line 6911 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionActiveActorState(Database const& cx,WorkerInterface const& distributorWorker) 
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker)
															#line 6920 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDataDistributionActive", reinterpret_cast<unsigned long>(this));

	}
	~GetDataDistributionActiveActorState() 
	{
		fdb_probe_actor_destroy("getDataDistributionActive", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("DataDistributionActive").detail("Stage", "ContactingDataDistributor");
															#line 632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<TraceEventFields> __when_expr_0 = timeoutError(distributorWorker.eventLogRequest.getReply(EventLogRequest("DDTrackerStarting"_sr)), 1.0);
															#line 632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetDataDistributionActiveActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6940 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetDataDistributionActiveActor*>(this)->actor_wait_state = 1;
															#line 632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*>(static_cast<GetDataDistributionActiveActor*>(this)));
															#line 6945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDataDistributionActiveActorState();
		static_cast<GetDataDistributionActiveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", distributorWorker.id()) .detail("Reason", "Failed to extract DataDistributionActive");
															#line 639 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6977 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields const& activeMessage,int loopDepth) 
	{
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionActiveActor*>(this)->SAV<bool>::futures) { (void)(activeMessage.getValue("State") == "Active"); this->~GetDataDistributionActiveActorState(); static_cast<GetDataDistributionActiveActor*>(this)->destroy(); return 0; }
															#line 6991 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionActiveActor*>(this)->SAV< bool >::value()) bool(activeMessage.getValue("State") == "Active");
		this->~GetDataDistributionActiveActorState();
		static_cast<GetDataDistributionActiveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && activeMessage,int loopDepth) 
	{
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDataDistributionActiveActor*>(this)->SAV<bool>::futures) { (void)(activeMessage.getValue("State") == "Active"); this->~GetDataDistributionActiveActorState(); static_cast<GetDataDistributionActiveActor*>(this)->destroy(); return 0; }
															#line 7003 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDataDistributionActiveActor*>(this)->SAV< bool >::value()) bool(activeMessage.getValue("State") == "Active");
		this->~GetDataDistributionActiveActorState();
		static_cast<GetDataDistributionActiveActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TraceEventFields const& activeMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(activeMessage, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TraceEventFields && activeMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(activeMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDataDistributionActiveActor*>(this)->actor_wait_state > 0) static_cast<GetDataDistributionActiveActor*>(this)->actor_wait_state = 0;
		static_cast<GetDataDistributionActiveActor*>(this)->ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDataDistributionActive", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 7090 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDataDistributionActive()
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDataDistributionActiveActor final : public Actor<bool>, public ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >, public FastAllocated<GetDataDistributionActiveActor>, public GetDataDistributionActiveActorState<GetDataDistributionActiveActor> {
															#line 7095 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDataDistributionActiveActor>::operator new;
	using FastAllocated<GetDataDistributionActiveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14821255141931617280UL, 16054289816746733312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >;
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDataDistributionActiveActor(Database const& cx,WorkerInterface const& distributorWorker) 
															#line 7112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<bool>(),
		   GetDataDistributionActiveActorState<GetDataDistributionActiveActor>(cx, distributorWorker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDataDistributionActive", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(695917296241182976UL, 14234114386133646592UL);
		ActorExecutionContextHelper __helper(static_cast<GetDataDistributionActiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDataDistributionActive");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDataDistributionActive", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDataDistributionActiveActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<bool> getDataDistributionActive( Database const& cx, WorkerInterface const& distributorWorker ) {
															#line 628 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<bool>(new GetDataDistributionActiveActor(cx, distributorWorker));
															#line 7145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 642 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Checks to see if any storage servers are being recruited
															#line 7151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServersRecruiting()
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetStorageServersRecruitingActor>
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageServersRecruitingActorState {
															#line 7158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageServersRecruitingActorState(Database const& cx,WorkerInterface const& distributorWorker,UID const& distributorUID) 
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker),
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorUID(distributorUID)
															#line 7169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersRecruitingActorState() 
	{
		fdb_probe_actor_destroy("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 646 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("StorageServersRecruiting").detail("Stage", "ContactingDataDistributor");
															#line 647 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<TraceEventFields> __when_expr_0 = timeoutError(distributorWorker.eventLogRequest.getReply( EventLogRequest(StringRef("StorageServerRecruitment_" + distributorUID.toString()))), 1.0);
															#line 647 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<GetStorageServersRecruitingActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetStorageServersRecruitingActor*>(this)->actor_wait_state = 1;
															#line 647 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*>(static_cast<GetStorageServersRecruitingActor*>(this)));
															#line 7194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersRecruitingActorState();
		static_cast<GetStorageServersRecruitingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseFailure", distributorWorker.id()) .detail("Reason", "Failed to extract StorageServersRecruiting") .detail("DataDistributorID", distributorUID);
															#line 666 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 7226 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields const& recruitingMessage,int loopDepth) 
	{
															#line 652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("StorageServersRecruiting").detail("Message", recruitingMessage.toString());
															#line 654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (recruitingMessage.getValue("State") == "Recruiting")
															#line 7242 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			std::string tssValue;
															#line 657 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!recruitingMessage.tryGetValue("IsTSS", tssValue) || tssValue == "False")
															#line 7248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetStorageServersRecruitingActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetStorageServersRecruitingActorState(); static_cast<GetStorageServersRecruitingActor*>(this)->destroy(); return 0; }
															#line 7252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetStorageServersRecruitingActor*>(this)->SAV< bool >::value()) bool(true);
				this->~GetStorageServersRecruitingActorState();
				static_cast<GetStorageServersRecruitingActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageServersRecruitingActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetStorageServersRecruitingActorState(); static_cast<GetStorageServersRecruitingActor*>(this)->destroy(); return 0; }
															#line 7261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageServersRecruitingActor*>(this)->SAV< bool >::value()) bool(false);
		this->~GetStorageServersRecruitingActorState();
		static_cast<GetStorageServersRecruitingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TraceEventFields && recruitingMessage,int loopDepth) 
	{
															#line 652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("StorageServersRecruiting").detail("Message", recruitingMessage.toString());
															#line 654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (recruitingMessage.getValue("State") == "Recruiting")
															#line 7275 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			std::string tssValue;
															#line 657 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!recruitingMessage.tryGetValue("IsTSS", tssValue) || tssValue == "False")
															#line 7281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<GetStorageServersRecruitingActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetStorageServersRecruitingActorState(); static_cast<GetStorageServersRecruitingActor*>(this)->destroy(); return 0; }
															#line 7285 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<GetStorageServersRecruitingActor*>(this)->SAV< bool >::value()) bool(true);
				this->~GetStorageServersRecruitingActorState();
				static_cast<GetStorageServersRecruitingActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetStorageServersRecruitingActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetStorageServersRecruitingActorState(); static_cast<GetStorageServersRecruitingActor*>(this)->destroy(); return 0; }
															#line 7294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetStorageServersRecruitingActor*>(this)->SAV< bool >::value()) bool(false);
		this->~GetStorageServersRecruitingActorState();
		static_cast<GetStorageServersRecruitingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TraceEventFields const& recruitingMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(recruitingMessage, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TraceEventFields && recruitingMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(recruitingMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersRecruitingActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersRecruitingActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersRecruitingActor*>(this)->ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*,TraceEventFields const& value) 
	{
		fdb_probe_actor_enter("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersRecruitingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*,TraceEventFields && value) 
	{
		fdb_probe_actor_enter("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersRecruitingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersRecruitingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	UID distributorUID;
															#line 7383 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getStorageServersRecruiting()
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetStorageServersRecruitingActor final : public Actor<bool>, public ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >, public FastAllocated<GetStorageServersRecruitingActor>, public GetStorageServersRecruitingActorState<GetStorageServersRecruitingActor> {
															#line 7388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetStorageServersRecruitingActor>::operator new;
	using FastAllocated<GetStorageServersRecruitingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14933900011264008960UL, 15495457252905817088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >;
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetStorageServersRecruitingActor(Database const& cx,WorkerInterface const& distributorWorker,UID const& distributorUID) 
															#line 7405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<bool>(),
		   GetStorageServersRecruitingActorState<GetStorageServersRecruitingActor>(cx, distributorWorker, distributorUID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5963433431947749888UL, 6542897603703102976UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersRecruitingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServersRecruiting");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServersRecruiting", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersRecruitingActor, 0, TraceEventFields >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<bool> getStorageServersRecruiting( Database const& cx, WorkerInterface const& distributorWorker, UID const& distributorUID ) {
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<bool>(new GetStorageServersRecruitingActor(cx, distributorWorker, distributorUID));
															#line 7438 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 669 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Gets the difference between the expected version (based on the version
// epoch) and the actual version.
															#line 7445 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getVersionOffset()
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetVersionOffsetActor>
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetVersionOffsetActorState {
															#line 7452 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetVersionOffsetActorState(Database const& cx,WorkerInterface const& distributorWorker,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   distributorWorker(distributorWorker),
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 7463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersionOffset", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionOffsetActorState() 
	{
		fdb_probe_actor_destroy("getVersionOffset", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 675 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 7478 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionOffsetActorState();
		static_cast<GetVersionOffsetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 676 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr = Transaction(cx);
															#line 7508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		try {
															#line 678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("GetVersionOffset").detail("Stage", "ReadingVersionEpoch");
															#line 680 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 681 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 681 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7518 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 1;
															#line 681 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionOffsetActor, 0, Version >*>(static_cast<GetVersionOffsetActor*>(this)));
															#line 7523 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 3;
															#line 690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetVersionOffsetActor, 2, Void >*>(static_cast<GetVersionOffsetActor*>(this)));
															#line 7552 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Optional<Standalone<StringRef>>> __when_expr_1 = tr.get(versionEpochKey);
															#line 682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7569 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 2;
															#line 682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*>(static_cast<GetVersionOffsetActor*>(this)));
															#line 7574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __rv,int loopDepth) 
	{
															#line 681 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		rv = __rv;
															#line 7583 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __rv,int loopDepth) 
	{
		rv = std::move(__rv);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state > 0) static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionOffsetActor*>(this)->ActorCallback< GetVersionOffsetActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionOffsetActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
															#line 683 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!versionEpochValue.present())
															#line 7662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetVersionOffsetActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetVersionOffsetActorState(); static_cast<GetVersionOffsetActor*>(this)->destroy(); return 0; }
															#line 7666 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetVersionOffsetActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetVersionOffsetActorState();
			static_cast<GetVersionOffsetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 686 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochValue.get(), Unversioned());
															#line 687 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t versionOffset = abs(rv - (g_network->timer() * SERVER_KNOBS->VERSIONS_PER_SECOND - versionEpoch));
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetVersionOffsetActor*>(this)->SAV<int64_t>::futures) { (void)(versionOffset); this->~GetVersionOffsetActorState(); static_cast<GetVersionOffsetActor*>(this)->destroy(); return 0; }
															#line 7678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetVersionOffsetActor*>(this)->SAV< int64_t >::value()) int64_t(versionOffset);
		this->~GetVersionOffsetActorState();
		static_cast<GetVersionOffsetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
															#line 683 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!versionEpochValue.present())
															#line 7690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetVersionOffsetActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~GetVersionOffsetActorState(); static_cast<GetVersionOffsetActor*>(this)->destroy(); return 0; }
															#line 7694 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetVersionOffsetActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~GetVersionOffsetActorState();
			static_cast<GetVersionOffsetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 686 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t versionEpoch = BinaryReader::fromStringRef<int64_t>(versionEpochValue.get(), Unversioned());
															#line 687 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		int64_t versionOffset = abs(rv - (g_network->timer() * SERVER_KNOBS->VERSIONS_PER_SECOND - versionEpoch));
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetVersionOffsetActor*>(this)->SAV<int64_t>::futures) { (void)(versionOffset); this->~GetVersionOffsetActorState(); static_cast<GetVersionOffsetActor*>(this)->destroy(); return 0; }
															#line 7706 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetVersionOffsetActor*>(this)->SAV< int64_t >::value()) int64_t(versionOffset);
		this->~GetVersionOffsetActorState();
		static_cast<GetVersionOffsetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Standalone<StringRef>> const& versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(versionEpochValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Standalone<StringRef>> && versionEpochValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(versionEpochValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state > 0) static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionOffsetActor*>(this)->ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> const& value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*,Optional<Standalone<StringRef>> && value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetVersionOffsetActor*>(this)->actor_wait_state > 0) static_cast<GetVersionOffsetActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionOffsetActor*>(this)->ActorCallback< GetVersionOffsetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetVersionOffsetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetVersionOffsetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WorkerInterface distributorWorker;
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 676 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Transaction tr;
															#line 681 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version rv;
															#line 7886 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getVersionOffset()
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetVersionOffsetActor final : public Actor<int64_t>, public ActorCallback< GetVersionOffsetActor, 0, Version >, public ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >, public ActorCallback< GetVersionOffsetActor, 2, Void >, public FastAllocated<GetVersionOffsetActor>, public GetVersionOffsetActorState<GetVersionOffsetActor> {
															#line 7891 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetVersionOffsetActor>::operator new;
	using FastAllocated<GetVersionOffsetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(552323403763791360UL, 190987072814263552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionOffsetActor, 0, Version >;
friend struct ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >;
friend struct ActorCallback< GetVersionOffsetActor, 2, Void >;
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetVersionOffsetActor(Database const& cx,WorkerInterface const& distributorWorker,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 7910 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetVersionOffsetActorState<GetVersionOffsetActor>(cx, distributorWorker, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionOffset", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17604902736507671296UL, 2799015556771665408UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionOffsetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionOffset");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionOffset", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionOffsetActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionOffsetActor, 1, Optional<Standalone<StringRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetVersionOffsetActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<int64_t> getVersionOffset( Database const& cx, WorkerInterface const& distributorWorker, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<int64_t>(new GetVersionOffsetActor(cx, distributorWorker, dbInfo));
															#line 7945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 694 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Returns DC lag for simulation runs
															#line 7951 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via getDatacenterLag()
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class GetDatacenterLagActor>
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDatacenterLagActorState {
															#line 7958 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDatacenterLagActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo)
															#line 7967 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("getDatacenterLag", reinterpret_cast<unsigned long>(this));

	}
	~GetDatacenterLagActorState() 
	{
		fdb_probe_actor_destroy("getDatacenterLag", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 697 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 7982 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetDatacenterLagActorState();
		static_cast<GetDatacenterLagActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!g_network->isSimulated() || g_simulator->usableRegions == 1)
															#line 8012 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 699 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<GetDatacenterLagActor*>(this)->SAV<Version>::futures) { (void)(0); this->~GetDatacenterLagActorState(); static_cast<GetDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 8016 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<GetDatacenterLagActor*>(this)->SAV< Version >::value()) Version(0);
			this->~GetDatacenterLagActorState();
			static_cast<GetDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 702 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		primaryLog = Optional<TLogInterface>();
															#line 703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		remoteLog = Optional<TLogInterface>();
															#line 704 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (dbInfo->get().recoveryState >= RecoveryState::ALL_LOGS_RECRUITED)
															#line 8028 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 705 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			for( const auto& logset : dbInfo->get().logSystemConfig.tLogs ) {
															#line 706 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (logset.isLocal && logset.locality != tagLocalitySatellite)
															#line 8034 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					for( const auto& tlog : logset.tLogs ) {
															#line 708 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						if (tlog.present())
															#line 8040 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
						{
															#line 709 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
							primaryLog = tlog.interf();
															#line 8044 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
							break;
						}
					}
				}
															#line 714 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!logset.isLocal)
															#line 8051 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					for( const auto& tlog : logset.tLogs ) {
															#line 716 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						if (tlog.present())
															#line 8057 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
						{
															#line 717 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
							remoteLog = tlog.interf();
															#line 8061 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
							break;
						}
					}
				}
			}
		}
															#line 725 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!primaryLog.present() || !remoteLog.present())
															#line 8070 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 726 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_0 = dbInfo->onChange();
															#line 726 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<GetDatacenterLagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8076 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetDatacenterLagActor*>(this)->actor_wait_state = 1;
															#line 726 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetDatacenterLagActor, 0, Void >*>(static_cast<GetDatacenterLagActor*>(this)));
															#line 8081 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 730 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(primaryLog.present());
															#line 731 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(remoteLog.present());
															#line 733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		onChange = dbInfo->onChange();
															#line 734 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 8101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetDatacenterLagActor*>(this)->actor_wait_state > 0) static_cast<GetDatacenterLagActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatacenterLagActor*>(this)->ActorCallback< GetDatacenterLagActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatacenterLagActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetDatacenterLagActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetDatacenterLagActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 735 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		primaryMetrics = brokenPromiseToNever(primaryLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 737 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		remoteMetrics = brokenPromiseToNever(remoteLog.get().getQueuingMetrics.getReply(TLogQueuingMetricsRequest()));
															#line 740 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = (success(primaryMetrics) && success(remoteMetrics)) || onChange;
															#line 740 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<GetDatacenterLagActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetDatacenterLagActor*>(this)->actor_wait_state = 2;
															#line 740 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetDatacenterLagActor, 1, Void >*>(static_cast<GetDatacenterLagActor*>(this)));
															#line 8221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (onChange.isReady())
															#line 8243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("DCLag").detail("Primary", primaryMetrics.get().v).detail("Remote", remoteMetrics.get().v);
															#line 746 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(primaryMetrics.get().v >= 0 && remoteMetrics.get().v >= 0);
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDatacenterLagActor*>(this)->SAV<Version>::futures) { (void)(primaryMetrics.get().v - remoteMetrics.get().v); this->~GetDatacenterLagActorState(); static_cast<GetDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 8253 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDatacenterLagActor*>(this)->SAV< Version >::value()) Version(primaryMetrics.get().v - remoteMetrics.get().v);
		this->~GetDatacenterLagActorState();
		static_cast<GetDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (onChange.isReady())
															#line 8265 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("DCLag").detail("Primary", primaryMetrics.get().v).detail("Remote", remoteMetrics.get().v);
															#line 746 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		ASSERT(primaryMetrics.get().v >= 0 && remoteMetrics.get().v >= 0);
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<GetDatacenterLagActor*>(this)->SAV<Version>::futures) { (void)(primaryMetrics.get().v - remoteMetrics.get().v); this->~GetDatacenterLagActorState(); static_cast<GetDatacenterLagActor*>(this)->destroy(); return 0; }
															#line 8275 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<GetDatacenterLagActor*>(this)->SAV< Version >::value()) Version(primaryMetrics.get().v - remoteMetrics.get().v);
		this->~GetDatacenterLagActorState();
		static_cast<GetDatacenterLagActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetDatacenterLagActor*>(this)->actor_wait_state > 0) static_cast<GetDatacenterLagActor*>(this)->actor_wait_state = 0;
		static_cast<GetDatacenterLagActor*>(this)->ActorCallback< GetDatacenterLagActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetDatacenterLagActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetDatacenterLagActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetDatacenterLagActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 702 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Optional<TLogInterface> primaryLog;
															#line 703 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Optional<TLogInterface> remoteLog;
															#line 733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<Void> onChange;
															#line 735 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<TLogQueuingMetricsReply> primaryMetrics;
															#line 737 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<TLogQueuingMetricsReply> remoteMetrics;
															#line 8372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via getDatacenterLag()
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class GetDatacenterLagActor final : public Actor<Version>, public ActorCallback< GetDatacenterLagActor, 0, Void >, public ActorCallback< GetDatacenterLagActor, 1, Void >, public FastAllocated<GetDatacenterLagActor>, public GetDatacenterLagActorState<GetDatacenterLagActor> {
															#line 8377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<GetDatacenterLagActor>::operator new;
	using FastAllocated<GetDatacenterLagActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5395472441441428992UL, 15771944803684219136UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetDatacenterLagActor, 0, Void >;
friend struct ActorCallback< GetDatacenterLagActor, 1, Void >;
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	GetDatacenterLagActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 8395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Version>(),
		   GetDatacenterLagActorState<GetDatacenterLagActor>(cx, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDatacenterLag", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2452971605864480512UL, 1323858774840231424UL);
		ActorExecutionContextHelper __helper(static_cast<GetDatacenterLagActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDatacenterLag");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDatacenterLag", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetDatacenterLagActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetDatacenterLagActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Version> getDatacenterLag( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Version>(new GetDatacenterLagActor(cx, dbInfo));
															#line 8429 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 8434 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via repairDeadDatacenter()
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class RepairDeadDatacenterActor>
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class RepairDeadDatacenterActorState {
															#line 8441 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	RepairDeadDatacenterActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& context) 
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   context(context)
															#line 8452 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("repairDeadDatacenter", reinterpret_cast<unsigned long>(this));

	}
	~RepairDeadDatacenterActorState() 
	{
		fdb_probe_actor_destroy("repairDeadDatacenter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 755 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (g_network->isSimulated() && g_simulator->usableRegions > 1 && !g_simulator->quiesced)
															#line 8467 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 756 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				primaryDead = g_simulator->datacenterDead(g_simulator->primaryDcId);
															#line 757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				remoteDead = g_simulator->datacenterDead(g_simulator->remoteDcId);
															#line 761 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (primaryDead && remoteDead)
															#line 8475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					TraceEvent(SevWarnAlways, "CannotDisableFearlessConfiguration").log();
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					if (!static_cast<RepairDeadDatacenterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RepairDeadDatacenterActorState(); static_cast<RepairDeadDatacenterActor*>(this)->destroy(); return 0; }
															#line 8481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
					new (&static_cast<RepairDeadDatacenterActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~RepairDeadDatacenterActorState();
					static_cast<RepairDeadDatacenterActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 765 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (primaryDead || remoteDead)
															#line 8489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				{
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
					if (remoteDead)
															#line 8493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
					{
															#line 767 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						std::vector<AddressExclusion> servers = g_simulator->getAllAddressesInDCToExclude(g_simulator->remoteDcId);
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						TraceEvent(SevWarnAlways, "DisablingFearlessConfiguration") .detail("Location", context) .detail("Stage", "ExcludeServers") .detail("Servers", describe(servers));
															#line 773 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						StrictFuture<Void> __when_expr_0 = excludeServers(cx, servers, false);
															#line 773 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8503 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 1;
															#line 773 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RepairDeadDatacenterActor, 0, Void >*>(static_cast<RepairDeadDatacenterActor*>(this)));
															#line 8508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont4(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RepairDeadDatacenterActorState();
		static_cast<RepairDeadDatacenterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 796 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<RepairDeadDatacenterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RepairDeadDatacenterActorState(); static_cast<RepairDeadDatacenterActor*>(this)->destroy(); return 0; }
															#line 8546 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<RepairDeadDatacenterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RepairDeadDatacenterActorState();
		static_cast<RepairDeadDatacenterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
															#line 776 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent(SevWarnAlways, "DisablingFearlessConfiguration") .detail("Location", context) .detail("Stage", "Repopulate") .detail("RemoteDead", remoteDead) .detail("PrimaryDead", primaryDead);
															#line 781 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		g_simulator->usableRegions = 1;
															#line 783 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(ManagementAPI::changeConfig( cx.getReference(), (primaryDead ? g_simulator->disablePrimary : g_simulator->disableRemote) + " repopulate_anti_quorum=1", true));
															#line 783 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 2;
															#line 783 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RepairDeadDatacenterActor, 1, Void >*>(static_cast<RepairDeadDatacenterActor*>(this)));
															#line 8575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state > 0) static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 0;
		static_cast<RepairDeadDatacenterActor*>(this)->ActorCallback< RepairDeadDatacenterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RepairDeadDatacenterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 8671 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 8680 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state > 0) static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 0;
		static_cast<RepairDeadDatacenterActor*>(this)->ActorCallback< RepairDeadDatacenterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RepairDeadDatacenterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 790 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent(SevWarnAlways, "DisablingFearlessConfiguration") .detail("Location", context) .detail("Stage", "Usable_Regions");
															#line 793 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(ManagementAPI::changeConfig(cx.getReference(), "usable_regions=1", true));
															#line 793 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8768 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 4;
															#line 793 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RepairDeadDatacenterActor, 3, Void >*>(static_cast<RepairDeadDatacenterActor*>(this)));
															#line 8773 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 787 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!(dbInfo->get().recoveryState < RecoveryState::STORAGE_RECOVERED))
															#line 8789 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 788 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_2 = dbInfo->onChange();
															#line 788 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8797 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 3;
															#line 788 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RepairDeadDatacenterActor, 2, Void >*>(static_cast<RepairDeadDatacenterActor*>(this)));
															#line 8802 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state > 0) static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 0;
		static_cast<RepairDeadDatacenterActor*>(this)->ActorCallback< RepairDeadDatacenterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RepairDeadDatacenterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state > 0) static_cast<RepairDeadDatacenterActor*>(this)->actor_wait_state = 0;
		static_cast<RepairDeadDatacenterActor*>(this)->ActorCallback< RepairDeadDatacenterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RepairDeadDatacenterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RepairDeadDatacenterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::string context;
															#line 756 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool primaryDead;
															#line 757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool remoteDead;
															#line 9004 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via repairDeadDatacenter()
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class RepairDeadDatacenterActor final : public Actor<Void>, public ActorCallback< RepairDeadDatacenterActor, 0, Void >, public ActorCallback< RepairDeadDatacenterActor, 1, Void >, public ActorCallback< RepairDeadDatacenterActor, 2, Void >, public ActorCallback< RepairDeadDatacenterActor, 3, Void >, public FastAllocated<RepairDeadDatacenterActor>, public RepairDeadDatacenterActorState<RepairDeadDatacenterActor> {
															#line 9009 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<RepairDeadDatacenterActor>::operator new;
	using FastAllocated<RepairDeadDatacenterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18322747032000720128UL, 1107849334582466048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RepairDeadDatacenterActor, 0, Void >;
friend struct ActorCallback< RepairDeadDatacenterActor, 1, Void >;
friend struct ActorCallback< RepairDeadDatacenterActor, 2, Void >;
friend struct ActorCallback< RepairDeadDatacenterActor, 3, Void >;
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	RepairDeadDatacenterActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& context) 
															#line 9029 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   RepairDeadDatacenterActorState<RepairDeadDatacenterActor>(cx, dbInfo, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6159519692349520640UL, 14447699372185362944UL);
		ActorExecutionContextHelper __helper(static_cast<RepairDeadDatacenterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("repairDeadDatacenter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("repairDeadDatacenter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RepairDeadDatacenterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RepairDeadDatacenterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RepairDeadDatacenterActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RepairDeadDatacenterActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> repairDeadDatacenter( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, std::string const& context ) {
															#line 752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new RepairDeadDatacenterActor(cx, dbInfo, context));
															#line 9065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 798 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 9070 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via reconfigureAfter()
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class ReconfigureAfterActor>
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class ReconfigureAfterActorState {
															#line 9077 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ReconfigureAfterActorState(Database const& cx,double const& time,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& context) 
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   time(time),
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   context(context)
															#line 9090 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("reconfigureAfter", reinterpret_cast<unsigned long>(this));

	}
	~ReconfigureAfterActorState() 
	{
		fdb_probe_actor_destroy("reconfigureAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 803 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(time);
															#line 803 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9107 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 1;
															#line 803 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReconfigureAfterActor, 0, Void >*>(static_cast<ReconfigureAfterActor*>(this)));
															#line 9112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReconfigureAfterActorState();
		static_cast<ReconfigureAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = uncancellable(repairDeadDatacenter(cx, dbInfo, context));
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 2;
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReconfigureAfterActor, 1, Void >*>(static_cast<ReconfigureAfterActor*>(this)));
															#line 9142 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = uncancellable(repairDeadDatacenter(cx, dbInfo, context));
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 2;
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReconfigureAfterActor, 1, Void >*>(static_cast<ReconfigureAfterActor*>(this)));
															#line 9158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state > 0) static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ReconfigureAfterActor*>(this)->ActorCallback< ReconfigureAfterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconfigureAfterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReconfigureAfterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReconfigureAfterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 805 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<ReconfigureAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReconfigureAfterActorState(); static_cast<ReconfigureAfterActor*>(this)->destroy(); return 0; }
															#line 9242 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<ReconfigureAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReconfigureAfterActorState();
		static_cast<ReconfigureAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 805 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<ReconfigureAfterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReconfigureAfterActorState(); static_cast<ReconfigureAfterActor*>(this)->destroy(); return 0; }
															#line 9254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<ReconfigureAfterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReconfigureAfterActorState();
		static_cast<ReconfigureAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReconfigureAfterActor*>(this)->actor_wait_state > 0) static_cast<ReconfigureAfterActor*>(this)->actor_wait_state = 0;
		static_cast<ReconfigureAfterActor*>(this)->ActorCallback< ReconfigureAfterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReconfigureAfterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReconfigureAfterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReconfigureAfterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	double time;
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::string context;
															#line 9345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via reconfigureAfter()
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class ReconfigureAfterActor final : public Actor<Void>, public ActorCallback< ReconfigureAfterActor, 0, Void >, public ActorCallback< ReconfigureAfterActor, 1, Void >, public FastAllocated<ReconfigureAfterActor>, public ReconfigureAfterActorState<ReconfigureAfterActor> {
															#line 9350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<ReconfigureAfterActor>::operator new;
	using FastAllocated<ReconfigureAfterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10855813480317305344UL, 7149342048228153344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReconfigureAfterActor, 0, Void >;
friend struct ActorCallback< ReconfigureAfterActor, 1, Void >;
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ReconfigureAfterActor(Database const& cx,double const& time,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& context) 
															#line 9368 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   ReconfigureAfterActorState<ReconfigureAfterActor>(cx, time, dbInfo, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reconfigureAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(392835930889393664UL, 13442961960112630784UL);
		ActorExecutionContextHelper __helper(static_cast<ReconfigureAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reconfigureAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reconfigureAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReconfigureAfterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReconfigureAfterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> reconfigureAfter( Database const& cx, double const& time, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, std::string const& context ) {
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new ReconfigureAfterActor(cx, time, dbInfo, context));
															#line 9402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 807 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

struct QuietDatabaseChecker {
	ProcessEvents::Callback timeoutCallback = [this](StringRef name, std::any const& msg, Error const& e) {
		logFailure(name, std::any_cast<StringRef>(msg), e);
	};
	double start = now();
	double maxDDRunTime;
	ProcessEvents::Event timeoutEvent;
	std::vector<std::string> lastFailReasons;

	QuietDatabaseChecker(double maxDDRunTime)
	  : maxDDRunTime(maxDDRunTime), timeoutEvent({ "Timeout"_sr, "TracedTooManyLines"_sr }, timeoutCallback) {}

	void logFailure(StringRef name, StringRef msg, Error const& e) {
		std::string reasons = fmt::format("{}", fmt::join(lastFailReasons, ", "));
		TraceEvent(SevError, "QuietDatabaseFailure")
		    .error(e)
		    .detail("EventName", name)
		    .detail("EventMessage", msg)
		    .detail("Reasons", lastFailReasons)
		    .log();
	};

	struct Impl {
		double start;
		std::string const& phase;
		double maxDDRunTime;
		std::vector<std::string>& failReasons;

		Impl(double start, const std::string& phase, const double maxDDRunTime, std::vector<std::string>& failReasons)
		  : start(start), phase(phase), maxDDRunTime(maxDDRunTime), failReasons(failReasons) {}

		template <class T, class Comparison = std::less_equal<>>
		Impl& add(BaseTraceEvent& evt,
		          const char* name,
		          T value,
		          T expected,
		          Comparison const& cmp = std::less_equal<>()) {
			std::string k = fmt::format("{}Gate", name);
			evt.detail(name, value).detail(k.c_str(), expected);
			if (!cmp(value, expected)) {
				failReasons.push_back(name);
			}
			return *this;
		}

		bool success() {
			bool timedOut = now() - start > maxDDRunTime;
			if (!failReasons.empty()) {
				std::string traceMessage = fmt::format("QuietDatabase{}Fail", phase);
				std::string reasons = fmt::format("{}", fmt::join(failReasons, ", "));
				TraceEvent(timedOut ? SevError : SevWarnAlways, traceMessage.c_str())
				    .detail("Reasons", reasons)
				    .detail("FailedAfter", now() - start)
				    .detail("Timeout", maxDDRunTime);
				if (timedOut) {
					// this bool is just created to make the assertion more readable
					bool ddGotStuck = true;
					// This assertion is here to make the test fail more quickly. If quietDatabase takes this
					// long without completing, we can assume that the test will eventually time out. However,
					// time outs are more annoying to debug. This will hopefully be easier to track down.
					ASSERT(!ddGotStuck || !g_network->isSimulated());
				}
				return false;
			}
			return true;
		}
	};

	Impl startIteration(std::string const& phase) {
		lastFailReasons.clear();
		Impl res(start, phase, maxDDRunTime, lastFailReasons);
		return res;
	}
};

															#line 9482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via enableConsistencyScanInSim()
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class EnableConsistencyScanInSimActor>
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class EnableConsistencyScanInSimActorState {
															#line 9489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	EnableConsistencyScanInSimActorState(Database const& db) 
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : db(db),
															#line 884 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(db)),
															#line 885 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   cs()
															#line 9500 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this));

	}
	~EnableConsistencyScanInSimActorState() 
	{
		fdb_probe_actor_destroy("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 886 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!g_network->isSimulated())
															#line 9515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 887 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<EnableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EnableConsistencyScanInSimActorState(); static_cast<EnableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 9519 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<EnableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~EnableConsistencyScanInSimActorState();
				static_cast<EnableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 889 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("ConsistencyScan_SimEnable").log();
															#line 890 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			;
															#line 9529 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EnableConsistencyScanInSimActorState();
		static_cast<EnableConsistencyScanInSimActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 941 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<EnableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EnableConsistencyScanInSimActorState(); static_cast<EnableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 9552 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<EnableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EnableConsistencyScanInSimActorState();
		static_cast<EnableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 892 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			SystemDBWriteLockedNow(db.getReference())->setOptions(tr);
															#line 893 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<ConsistencyScanState::Config> __when_expr_0 = cs.config().getD(tr);
															#line 893 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9576 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 1;
															#line 893 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*>(static_cast<EnableConsistencyScanInSimActor*>(this)));
															#line 9581 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 937 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 937 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9618 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 3;
															#line 937 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*>(static_cast<EnableConsistencyScanInSimActor*>(this)));
															#line 9623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 896 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!config.enabled && g_simulator->consistencyScanState < ISimulator::SimConsistencyScanState::Enabled)
															#line 9638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 897 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!g_simulator->doInjectConsistencyScanCorruption.present())
															#line 9642 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 898 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				g_simulator->doInjectConsistencyScanCorruption = BUGGIFY_WITH_PROB(0.1);
															#line 899 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("ConsistencyScan_DoInjectCorruption") .detail("Val", g_simulator->doInjectConsistencyScanCorruption.get());
															#line 9648 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 903 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::DisabledStart, ISimulator::SimConsistencyScanState::Enabling);
															#line 905 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			config.enabled = true;
															#line 9654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		else
		{
															#line 907 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (config.enabled && g_simulator->restarted && g_simulator->consistencyScanState == ISimulator::SimConsistencyScanState::DisabledStart)
															#line 9660 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 909 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("ConsistencyScan_SimEnableAlreadyDoneFromRestart").log();
															#line 910 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::DisabledStart, ISimulator::SimConsistencyScanState::Enabling);
															#line 9666 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 913 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (BUGGIFY_WITH_PROB(0.5))
															#line 9670 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 914 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				config.minStartVersion = tr->getReadVersion().get();
															#line 9674 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
		}
															#line 918 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config.maxReadByteRate = deterministicRandom()->randomInt(1, 50e6);
															#line 919 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config.targetRoundTimeSeconds = deterministicRandom()->randomSkewedUInt32(1, 100);
															#line 920 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config.minRoundTimeSeconds = deterministicRandom()->randomSkewedUInt32(1, 100);
															#line 922 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (config.enabled)
															#line 9685 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 923 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			cs.config().set(tr, config);
															#line 924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9693 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 2;
															#line 924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*>(static_cast<EnableConsistencyScanInSimActor*>(this)));
															#line 9698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config const& __config,int loopDepth) 
	{
															#line 893 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config = __config;
															#line 9712 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConsistencyScanState::Config && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<EnableConsistencyScanInSimActor*>(this)->ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >::remove();

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config const& value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*,ConsistencyScanState::Config && value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*,Error err) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 926 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabling, ISimulator::SimConsistencyScanState::Enabled);
															#line 928 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("ConsistencyScan_SimEnabled") .detail("MaxReadByteRate", config.maxReadByteRate) .detail("TargetRoundTimeSeconds", config.targetRoundTimeSeconds) .detail("MinRoundTimeSeconds", config.minRoundTimeSeconds);
															#line 932 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		CODE_PROBE(true, "Consistency Scan enabled in simulation");
															#line 9801 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 926 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabling, ISimulator::SimConsistencyScanState::Enabled);
															#line 928 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("ConsistencyScan_SimEnabled") .detail("MaxReadByteRate", config.maxReadByteRate) .detail("TargetRoundTimeSeconds", config.targetRoundTimeSeconds) .detail("MinRoundTimeSeconds", config.minRoundTimeSeconds);
															#line 932 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		CODE_PROBE(true, "Consistency Scan enabled in simulation");
															#line 9814 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<EnableConsistencyScanInSimActor*>(this)->ActorCallback< EnableConsistencyScanInSimActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<EnableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<EnableConsistencyScanInSimActor*>(this)->ActorCallback< EnableConsistencyScanInSimActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database db;
															#line 884 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 885 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState cs;
															#line 893 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState::Config config;
															#line 9989 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via enableConsistencyScanInSim()
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class EnableConsistencyScanInSimActor final : public Actor<Void>, public ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >, public ActorCallback< EnableConsistencyScanInSimActor, 1, Void >, public ActorCallback< EnableConsistencyScanInSimActor, 2, Void >, public FastAllocated<EnableConsistencyScanInSimActor>, public EnableConsistencyScanInSimActorState<EnableConsistencyScanInSimActor> {
															#line 9994 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<EnableConsistencyScanInSimActor>::operator new;
	using FastAllocated<EnableConsistencyScanInSimActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17916048619772882176UL, 1013280538884451328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >;
friend struct ActorCallback< EnableConsistencyScanInSimActor, 1, Void >;
friend struct ActorCallback< EnableConsistencyScanInSimActor, 2, Void >;
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	EnableConsistencyScanInSimActor(Database const& db) 
															#line 10013 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   EnableConsistencyScanInSimActorState<EnableConsistencyScanInSimActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13916349905056491520UL, 10108342155947120896UL);
		ActorExecutionContextHelper __helper(static_cast<EnableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("enableConsistencyScanInSim");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("enableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EnableConsistencyScanInSimActor, 0, ConsistencyScanState::Config >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EnableConsistencyScanInSimActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< EnableConsistencyScanInSimActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> enableConsistencyScanInSim( Database const& db ) {
															#line 883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new EnableConsistencyScanInSimActor(db));
															#line 10048 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 943 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

															#line 10053 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via disableConsistencyScanInSim()
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class DisableConsistencyScanInSimActor>
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class DisableConsistencyScanInSimActorState {
															#line 10060 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	DisableConsistencyScanInSimActorState(Database const& db,bool const& waitForCompletion) 
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : db(db),
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   waitForCompletion(waitForCompletion),
															#line 945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(db)),
															#line 946 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   cs()
															#line 10073 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this));

	}
	~DisableConsistencyScanInSimActorState() 
	{
		fdb_probe_actor_destroy("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 947 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!g_network->isSimulated())
															#line 10088 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 948 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (!static_cast<DisableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DisableConsistencyScanInSimActorState(); static_cast<DisableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 10092 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				new (&static_cast<DisableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DisableConsistencyScanInSimActorState();
				static_cast<DisableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 951 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (waitForCompletion)
															#line 10100 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 952 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent("ConsistencyScan_SimDisableWaiting").log();
															#line 953 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				printf("Waiting for consistency scan to complete...\n");
															#line 954 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				;
															#line 10108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DisableConsistencyScanInSimActorState();
		static_cast<DisableConsistencyScanInSimActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 966 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("ConsistencyScan_SimDisable").log();
															#line 967 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 10138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 955 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		bool waitForCorruption = g_simulator->doInjectConsistencyScanCorruption.present() && g_simulator->doInjectConsistencyScanCorruption.get();
															#line 957 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (((waitForCorruption && g_simulator->consistencyScanState >= ISimulator::SimConsistencyScanState::Enabled_FoundCorruption) || (!waitForCorruption && g_simulator->consistencyScanState >= ISimulator::SimConsistencyScanState::Enabled)))
															#line 10162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 963 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 963 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 1;
															#line 963 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 10175 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1010 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Complete, ISimulator::SimConsistencyScanState::DisabledEnd);
															#line 1012 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		CODE_PROBE(true, "Consistency Scan disabled in simulation");
															#line 1013 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("ConsistencyScan_SimDisabled").log();
															#line 1014 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Consistency scan complete.\n");
															#line 1015 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<DisableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DisableConsistencyScanInSimActorState(); static_cast<DisableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 10292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<DisableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DisableConsistencyScanInSimActorState();
		static_cast<DisableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 969 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			SystemDBWriteLockedNow(db.getReference())->setOptions(tr);
															#line 970 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<ConsistencyScanState::Config> __when_expr_1 = cs.config().getD(tr);
															#line 970 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 2;
															#line 970 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 10321 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1006 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_6 = tr->onError(e);
															#line 1006 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 7;
															#line 1006 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 10363 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 971 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		skipDisable = false;
															#line 973 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (waitForCompletion)
															#line 10380 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 974 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<ConsistencyScanState::RoundStats> __when_expr_2 = cs.currentRoundStats().getD(tr);
															#line 974 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10386 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 3;
															#line 974 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 10391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ConsistencyScanState::Config const& __config,int loopDepth) 
	{
															#line 970 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		config = __config;
															#line 10405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ConsistencyScanState::Config && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*,ConsistencyScanState::Config const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*,ConsistencyScanState::Config && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 984 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (config.enabled)
															#line 10484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 986 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled, ISimulator::SimConsistencyScanState::Complete);
															#line 988 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			g_simulator->updateConsistencyScanState(ISimulator::SimConsistencyScanState::Enabled_FoundCorruption, ISimulator::SimConsistencyScanState::Complete);
															#line 990 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			config.enabled = false;
															#line 10492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		else
		{
															#line 992 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("ConsistencyScan_SimDisableAlreadyDisabled").log();
															#line 993 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			printf("Consistency scan already complete.\n");
															#line 994 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (!static_cast<DisableConsistencyScanInSimActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DisableConsistencyScanInSimActorState(); static_cast<DisableConsistencyScanInSimActor*>(this)->destroy(); return 0; }
															#line 10502 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			new (&static_cast<DisableConsistencyScanInSimActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DisableConsistencyScanInSimActorState();
			static_cast<DisableConsistencyScanInSimActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 997 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (skipDisable)
															#line 10510 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 998 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(2.0);
															#line 998 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 5;
															#line 998 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 10521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1001 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			cs.config().set(tr, config);
															#line 1002 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->commit();
															#line 1002 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont1loopBody1cont3when2(__when_expr_5.get(), loopDepth); };
			static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 6;
															#line 1002 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 10537 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 975 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<ConsistencyScanState::StatsHistoryMap::RangeResultType> __when_expr_3 = cs.roundStatsHistory().getRange(tr, {}, {}, 1, Snapshot::False, Reverse::False);
															#line 975 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 4;
															#line 975 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*>(static_cast<DisableConsistencyScanInSimActor*>(this)));
															#line 10554 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ConsistencyScanState::RoundStats const& __statsCurrentRound,int loopDepth) 
	{
															#line 974 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		statsCurrentRound = __statsCurrentRound;
															#line 10563 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(ConsistencyScanState::RoundStats && __statsCurrentRound,int loopDepth) 
	{
		statsCurrentRound = std::move(__statsCurrentRound);
		loopDepth = a_body1cont1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*,ConsistencyScanState::RoundStats const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*,ConsistencyScanState::RoundStats && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 977 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (olderStats.results.empty() && !statsCurrentRound.complete)
															#line 10642 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 978 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("ConsistencyScan_SimDisable_NoRoundsCompleted").log();
															#line 979 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			skipDisable = true;
															#line 10648 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(ConsistencyScanState::StatsHistoryMap::RangeResultType const& __olderStats,int loopDepth) 
	{
															#line 975 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		olderStats = __olderStats;
															#line 10658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(ConsistencyScanState::StatsHistoryMap::RangeResultType && __olderStats,int loopDepth) 
	{
		olderStats = std::move(__olderStats);
		loopDepth = a_body1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*,ConsistencyScanState::StatsHistoryMap::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*,ConsistencyScanState::StatsHistoryMap::RangeResultType && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
															#line 999 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr->reset();
															#line 10743 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
															#line 999 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tr->reset();
															#line 10752 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1cont12(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont12(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state > 0) static_cast<DisableConsistencyScanInSimActor*>(this)->actor_wait_state = 0;
		static_cast<DisableConsistencyScanInSimActor*>(this)->ActorCallback< DisableConsistencyScanInSimActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database db;
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool waitForCompletion;
															#line 945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 946 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState cs;
															#line 970 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState::Config config;
															#line 971 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	bool skipDisable;
															#line 974 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState::RoundStats statsCurrentRound;
															#line 975 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	ConsistencyScanState::StatsHistoryMap::RangeResultType olderStats;
															#line 11035 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via disableConsistencyScanInSim()
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class DisableConsistencyScanInSimActor final : public Actor<Void>, public ActorCallback< DisableConsistencyScanInSimActor, 0, Void >, public ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >, public ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >, public ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >, public ActorCallback< DisableConsistencyScanInSimActor, 4, Void >, public ActorCallback< DisableConsistencyScanInSimActor, 5, Void >, public ActorCallback< DisableConsistencyScanInSimActor, 6, Void >, public FastAllocated<DisableConsistencyScanInSimActor>, public DisableConsistencyScanInSimActorState<DisableConsistencyScanInSimActor> {
															#line 11040 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<DisableConsistencyScanInSimActor>::operator new;
	using FastAllocated<DisableConsistencyScanInSimActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10656444612749880832UL, 6568716131095803904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DisableConsistencyScanInSimActor, 0, Void >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 4, Void >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 5, Void >;
friend struct ActorCallback< DisableConsistencyScanInSimActor, 6, Void >;
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	DisableConsistencyScanInSimActor(Database const& db,bool const& waitForCompletion) 
															#line 11063 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   DisableConsistencyScanInSimActorState<DisableConsistencyScanInSimActor>(db, waitForCompletion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4193161891400256256UL, 3023070201654291200UL);
		ActorExecutionContextHelper __helper(static_cast<DisableConsistencyScanInSimActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("disableConsistencyScanInSim");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("disableConsistencyScanInSim", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 1, ConsistencyScanState::Config >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 2, ConsistencyScanState::RoundStats >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 3, ConsistencyScanState::StatsHistoryMap::RangeResultType >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DisableConsistencyScanInSimActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> disableConsistencyScanInSim( Database const& db, bool const& waitForCompletion ) {
															#line 944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new DisableConsistencyScanInSimActor(db, waitForCompletion));
															#line 11102 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 1017 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

// Waits until a database quiets down (no data in flight, small tlog queue, low SQ, no active data distribution). This
// requires the database to be available and healthy in order to succeed.
															#line 11109 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForQuietDatabase()
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
template <class WaitForQuietDatabaseActor>
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class WaitForQuietDatabaseActorState {
															#line 11116 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WaitForQuietDatabaseActorState(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& phase,int64_t const& dataInFlightGate = 2e6,int64_t const& maxTLogQueueGate = 5e6,int64_t const& maxStorageServerQueueGate = 5e6,int64_t const& maxDataDistributionQueueSize = 0,int64_t const& maxPoppedVersionLag = 30e6,int64_t const& maxVersionOffset = 1e6) 
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		 : cx(cx),
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dbInfo(dbInfo),
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   phase(phase),
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataInFlightGate(dataInFlightGate),
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxTLogQueueGate(maxTLogQueueGate),
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxStorageServerQueueGate(maxStorageServerQueueGate),
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxDataDistributionQueueSize(maxDataDistributionQueueSize),
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxPoppedVersionLag(maxPoppedVersionLag),
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxVersionOffset(maxVersionOffset),
															#line 1029 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   checker(isGeneralBuggifyEnabled() ? 4000.0 : 1500.0),
															#line 1030 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   reconfig(reconfigureAfter(cx, 100 + (deterministicRandom()->random01() * 100), dbInfo, "QuietDatabase")),
															#line 1032 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataInFlight(),
															#line 1033 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   tLogQueueInfo(),
															#line 1034 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataDistributionQueueSize(),
															#line 1035 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   teamCollectionValid(),
															#line 1036 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   storageQueueSize(),
															#line 1037 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dataDistributionActive(),
															#line 1038 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   storageServersRecruiting(),
															#line 1039 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   versionOffset(),
															#line 1040 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   dcLag(),
															#line 1041 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   maxDcLag(100e6),
															#line 1042 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		   traceMessage("QuietDatabase" + phase + "Begin")
															#line 11165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForQuietDatabase", reinterpret_cast<unsigned long>(this));

	}
	~WaitForQuietDatabaseActorState() 
	{
		fdb_probe_actor_destroy("waitForQuietDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1043 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(traceMessage.c_str()).log();
															#line 1046 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (g_network->isSimulated())
															#line 11182 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1047 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(5.0);
															#line 1047 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 1;
															#line 1047 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 0, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForQuietDatabaseActorState();
		static_cast<WaitForQuietDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1049 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseWaitingOnFullRecovery").detail("Phase", phase).log();
															#line 1050 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 11223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1057 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Set perpetual_storage_wiggle=0 ...\n");
															#line 1058 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Version> __when_expr_2 = setPerpetualStorageWiggle(cx, false, LockAware::True);
															#line 1058 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 3;
															#line 1058 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 2, Version >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1050 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!(dbInfo->get().recoveryState != RecoveryState::FULLY_RECOVERED))
															#line 11344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1051 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfo->onChange();
															#line 1051 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 2;
															#line 1051 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 1, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11357 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1059 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Set perpetual_storage_wiggle=0 Done.\n");
															#line 1061 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Disabling backup worker ...\n");
															#line 1062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_3 = disableBackupWorker(cx);
															#line 1062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11472 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 4;
															#line 1062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 3, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11477 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Version const& __version,int loopDepth) 
	{
															#line 1058 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		version = __version;
															#line 11486 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Version && __version,int loopDepth) 
	{
		version = std::move(__version);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1063 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Disabled backup worker.\n");
															#line 1065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_4 = disableConsistencyScanInSim(cx, false);
															#line 1065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11569 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 5;
															#line 1065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 4, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11574 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1063 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		printf("Disabled backup worker.\n");
															#line 1065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_4 = disableConsistencyScanInSim(cx, false);
															#line 1065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11587 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 5;
															#line 1065 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 4, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11592 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1068 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 1069 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 11678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1068 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 1069 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		;
															#line 11689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1175 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (!static_cast<WaitForQuietDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForQuietDatabaseActorState(); static_cast<WaitForQuietDatabaseActor*>(this)->destroy(); return 0; }
															#line 11773 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		new (&static_cast<WaitForQuietDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForQuietDatabaseActorState();
		static_cast<WaitForQuietDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
		try {
															#line 1071 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent("QuietDatabaseWaitingOnDataDistributor").log();
															#line 1072 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<WorkerInterface> __when_expr_5 = getDataDistributorWorker(cx, dbInfo);
															#line 1072 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11797 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont6loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont6loopBody1when1(__when_expr_5.get(), loopDepth); };
			static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 6;
															#line 1072 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11802 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont6loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1124 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent(("QuietDatabase" + phase + "Error").c_str()).errorUnsuppressed(e);
															#line 1125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (e.code() != error_code_actor_cancelled && e.code() != error_code_attribute_not_found && e.code() != error_code_timed_out)
															#line 11839 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1127 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent(("QuietDatabase" + phase + "Error").c_str()).error(e);
															#line 11843 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (e.code() != error_code_attribute_not_found && e.code() != error_code_timed_out)
															#line 11847 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1132 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 11851 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1134 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			auto evtType = "QuietDatabase" + phase + "Retry";
															#line 1135 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			TraceEvent evt(evtType.c_str());
															#line 1136 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			evt.error(e);
															#line 1137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			int notReadyCount = 0;
															#line 1138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (dataInFlight.isReady() && dataInFlight.isError())
															#line 11863 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "dataInFlight");
															#line 11869 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1142 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (tLogQueueInfo.isReady() && tLogQueueInfo.isError())
															#line 11873 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1143 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "tLogQueueInfo");
															#line 11879 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (dataDistributionQueueSize.isReady() && dataDistributionQueueSize.isError())
															#line 11883 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1148 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "dataDistributionQueueSize");
															#line 11889 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1150 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (teamCollectionValid.isReady() && teamCollectionValid.isError())
															#line 11893 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1152 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "teamCollectionValid");
															#line 11899 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (storageQueueSize.isReady() && storageQueueSize.isError())
															#line 11903 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "storageQueueSize");
															#line 11909 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1158 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (dataDistributionActive.isReady() && dataDistributionActive.isError())
															#line 11913 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1159 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "dataDistributionActive");
															#line 11919 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (storageServersRecruiting.isReady() && storageServersRecruiting.isError())
															#line 11923 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1163 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "storageServersRecruiting");
															#line 11929 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (versionOffset.isReady() && versionOffset.isError())
															#line 11933 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1167 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto key = "NotReady" + std::to_string(notReadyCount++);
															#line 1168 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				evt.detail(key.c_str(), "versionOffset");
															#line 11939 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			}
															#line 1170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_9 = delay(1.0);
															#line 1170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 10;
															#line 1170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 9, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11950 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(WorkerInterface const& distributorWorker,int loopDepth) 
	{
															#line 1073 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		UID distributorUID = dbInfo->get().distributor.get().id();
															#line 1074 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseGotDataDistributor", distributorUID) .detail("Locality", distributorWorker.locality.toString());
															#line 1077 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataInFlight = getDataInFlight(cx, distributorWorker);
															#line 1078 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tLogQueueInfo = getTLogQueueInfo(cx, dbInfo);
															#line 1079 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataDistributionQueueSize = getDataDistributionQueueSize(cx, distributorWorker, dataInFlightGate == 0);
															#line 1080 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		teamCollectionValid = getTeamCollectionValid(cx, distributorWorker);
															#line 1081 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageQueueSize = getMaxStorageServerQueueSize(cx, dbInfo, version);
															#line 1082 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataDistributionActive = getDataDistributionActive(cx, distributorWorker);
															#line 1083 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageServersRecruiting = getStorageServersRecruiting(cx, distributorWorker, distributorUID);
															#line 1084 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		versionOffset = getVersionOffset(cx, distributorWorker, dbInfo);
															#line 1085 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dcLag = getDatacenterLag(cx, dbInfo);
															#line 1087 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(dataInFlight) && success(tLogQueueInfo) && success(dataDistributionQueueSize) && success(teamCollectionValid) && success(storageQueueSize) && success(dataDistributionActive) && success(storageServersRecruiting) && success(versionOffset) && success(dcLag);
															#line 1087 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11989 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont6loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 7;
															#line 1087 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 6, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 11994 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(WorkerInterface && distributorWorker,int loopDepth) 
	{
															#line 1073 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		UID distributorUID = dbInfo->get().distributor.get().id();
															#line 1074 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent("QuietDatabaseGotDataDistributor", distributorUID) .detail("Locality", distributorWorker.locality.toString());
															#line 1077 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataInFlight = getDataInFlight(cx, distributorWorker);
															#line 1078 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		tLogQueueInfo = getTLogQueueInfo(cx, dbInfo);
															#line 1079 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataDistributionQueueSize = getDataDistributionQueueSize(cx, distributorWorker, dataInFlightGate == 0);
															#line 1080 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		teamCollectionValid = getTeamCollectionValid(cx, distributorWorker);
															#line 1081 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageQueueSize = getMaxStorageServerQueueSize(cx, dbInfo, version);
															#line 1082 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dataDistributionActive = getDataDistributionActive(cx, distributorWorker);
															#line 1083 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		storageServersRecruiting = getStorageServersRecruiting(cx, distributorWorker, distributorUID);
															#line 1084 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		versionOffset = getVersionOffset(cx, distributorWorker, dbInfo);
															#line 1085 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		dcLag = getDatacenterLag(cx, dbInfo);
															#line 1087 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(dataInFlight) && success(tLogQueueInfo) && success(dataDistributionQueueSize) && success(teamCollectionValid) && success(storageQueueSize) && success(dataDistributionActive) && success(storageServersRecruiting) && success(versionOffset) && success(dcLag);
															#line 1087 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12027 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont6loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 7;
															#line 1087 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 6, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 12032 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(WorkerInterface const& distributorWorker,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(distributorWorker, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1when1(WorkerInterface && distributorWorker,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(std::move(distributorWorker), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*,WorkerInterface const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*,WorkerInterface && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1091 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxVersionOffset += dbInfo->get().recoveryCount * SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT;
															#line 1093 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto check = checker.startIteration(phase);
															#line 1095 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::string evtType = "QuietDatabase" + phase;
															#line 1096 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent evt(evtType.c_str());
															#line 1097 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		check.add(evt, "DataInFlight", dataInFlight.get(), dataInFlightGate) .add(evt, "MaxTLogQueueSize", tLogQueueInfo.get().first, maxTLogQueueGate) .add(evt, "MaxTLogPoppedVersionLag", tLogQueueInfo.get().second, maxPoppedVersionLag) .add(evt, "DataDistributionQueueSize", dataDistributionQueueSize.get(), maxDataDistributionQueueSize) .add(evt, "TeamCollectionValid", teamCollectionValid.get(), true, std::equal_to<>()) .add(evt, "MaxStorageQueueSize", storageQueueSize.get(), maxStorageServerQueueGate) .add(evt, "DataDistributionActive", dataDistributionActive.get(), true, std::equal_to<>()) .add(evt, "StorageServersRecruiting", storageServersRecruiting.get(), false, std::equal_to<>()) .add(evt, "VersionOffset", versionOffset.get(), maxVersionOffset) .add(evt, "DatacenterLag", dcLag.get(), maxDcLag);
															#line 1108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		evt.detail("RecoveryCount", dbInfo->get().recoveryCount).detail("NumSuccesses", numSuccesses);
															#line 1109 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		evt.log();
															#line 1111 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (check.success())
															#line 12130 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 1112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (++numSuccesses == 3)
															#line 12134 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto msg = "QuietDatabase" + phase + "Done";
															#line 1114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent(msg.c_str()).log();
															#line 12140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 1117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_7 = delay(g_network->isSimulated() ? 2.0 : 30.0);
															#line 1117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont6loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont6loopBody1cont3when1(__when_expr_7.get(), loopDepth); };
				static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 8;
															#line 1117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 7, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 12154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
															#line 1120 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_8 = delay(1.0);
															#line 1120 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont6loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont6loopBody1cont3when2(__when_expr_8.get(), loopDepth); };
			static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 9;
															#line 1120 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 8, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 12169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1091 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		maxVersionOffset += dbInfo->get().recoveryCount * SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT;
															#line 1093 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		auto check = checker.startIteration(phase);
															#line 1095 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		std::string evtType = "QuietDatabase" + phase;
															#line 1096 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		TraceEvent evt(evtType.c_str());
															#line 1097 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		check.add(evt, "DataInFlight", dataInFlight.get(), dataInFlightGate) .add(evt, "MaxTLogQueueSize", tLogQueueInfo.get().first, maxTLogQueueGate) .add(evt, "MaxTLogPoppedVersionLag", tLogQueueInfo.get().second, maxPoppedVersionLag) .add(evt, "DataDistributionQueueSize", dataDistributionQueueSize.get(), maxDataDistributionQueueSize) .add(evt, "TeamCollectionValid", teamCollectionValid.get(), true, std::equal_to<>()) .add(evt, "MaxStorageQueueSize", storageQueueSize.get(), maxStorageServerQueueGate) .add(evt, "DataDistributionActive", dataDistributionActive.get(), true, std::equal_to<>()) .add(evt, "StorageServersRecruiting", storageServersRecruiting.get(), false, std::equal_to<>()) .add(evt, "VersionOffset", versionOffset.get(), maxVersionOffset) .add(evt, "DatacenterLag", dcLag.get(), maxDcLag);
															#line 1108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		evt.detail("RecoveryCount", dbInfo->get().recoveryCount).detail("NumSuccesses", numSuccesses);
															#line 1109 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		evt.log();
															#line 1111 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		if (check.success())
															#line 12193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		{
															#line 1112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (++numSuccesses == 3)
															#line 12197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			{
															#line 1113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				auto msg = "QuietDatabase" + phase + "Done";
															#line 1114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				TraceEvent(msg.c_str()).log();
															#line 12203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
			}
			else
			{
															#line 1117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				StrictFuture<Void> __when_expr_7 = delay(g_network->isSimulated() ? 2.0 : 30.0);
															#line 1117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12212 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont6loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont6loopBody1cont3when1(__when_expr_7.get(), loopDepth); };
				static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 8;
															#line 1117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 7, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 12217 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
				loopDepth = 0;
			}
		}
		else
		{
															#line 1120 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			StrictFuture<Void> __when_expr_8 = delay(1.0);
															#line 1120 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state < 0) return a_body1cont6loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 12227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont6loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont6loopBody1cont3when2(__when_expr_8.get(), loopDepth); };
			static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 9;
															#line 1120 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< WaitForQuietDatabaseActor, 8, Void >*>(static_cast<WaitForQuietDatabaseActor*>(this)));
															#line 12232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont6loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont6loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1121 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 12416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1121 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 12425 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1cont3when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1cont3when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont6loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont6loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont6loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 1171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 12522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 1171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
		numSuccesses = 0;
															#line 12531 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuietDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuietDatabaseActor*>(this)->ActorCallback< WaitForQuietDatabaseActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< WaitForQuietDatabaseActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont6loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< WaitForQuietDatabaseActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Database cx;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::string phase;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t dataInFlightGate;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxTLogQueueGate;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxStorageServerQueueGate;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxDataDistributionQueueSize;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxPoppedVersionLag;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int64_t maxVersionOffset;
															#line 1029 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	QuietDatabaseChecker checker;
															#line 1030 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<Void> reconfig;
															#line 1032 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<int64_t> dataInFlight;
															#line 1033 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<std::pair<int64_t, int64_t>> tLogQueueInfo;
															#line 1034 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<int64_t> dataDistributionQueueSize;
															#line 1035 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<bool> teamCollectionValid;
															#line 1036 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<int64_t> storageQueueSize;
															#line 1037 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<bool> dataDistributionActive;
															#line 1038 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<bool> storageServersRecruiting;
															#line 1039 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<int64_t> versionOffset;
															#line 1040 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Future<Version> dcLag;
															#line 1041 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version maxDcLag;
															#line 1042 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	std::string traceMessage;
															#line 1058 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	Version version;
															#line 1068 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	int numSuccesses;
															#line 12659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
};
// This generated class is to be used only via waitForQuietDatabase()
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
class WaitForQuietDatabaseActor final : public Actor<Void>, public ActorCallback< WaitForQuietDatabaseActor, 0, Void >, public ActorCallback< WaitForQuietDatabaseActor, 1, Void >, public ActorCallback< WaitForQuietDatabaseActor, 2, Version >, public ActorCallback< WaitForQuietDatabaseActor, 3, Void >, public ActorCallback< WaitForQuietDatabaseActor, 4, Void >, public ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >, public ActorCallback< WaitForQuietDatabaseActor, 6, Void >, public ActorCallback< WaitForQuietDatabaseActor, 7, Void >, public ActorCallback< WaitForQuietDatabaseActor, 8, Void >, public ActorCallback< WaitForQuietDatabaseActor, 9, Void >, public FastAllocated<WaitForQuietDatabaseActor>, public WaitForQuietDatabaseActorState<WaitForQuietDatabaseActor> {
															#line 12664 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
public:
	using FastAllocated<WaitForQuietDatabaseActor>::operator new;
	using FastAllocated<WaitForQuietDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18050457238779331840UL, 2129072938092521728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForQuietDatabaseActor, 0, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 1, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 2, Version >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 3, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 4, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 6, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 7, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 8, Void >;
friend struct ActorCallback< WaitForQuietDatabaseActor, 9, Void >;
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	WaitForQuietDatabaseActor(Database const& cx,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,std::string const& phase,int64_t const& dataInFlightGate = 2e6,int64_t const& maxTLogQueueGate = 5e6,int64_t const& maxStorageServerQueueGate = 5e6,int64_t const& maxDataDistributionQueueSize = 0,int64_t const& maxPoppedVersionLag = 30e6,int64_t const& maxVersionOffset = 1e6) 
															#line 12690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForQuietDatabaseActorState<WaitForQuietDatabaseActor>(cx, dbInfo, phase, dataInFlightGate, maxTLogQueueGate, maxStorageServerQueueGate, maxDataDistributionQueueSize, maxPoppedVersionLag, maxVersionOffset),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16870213735109939200UL, 17663630716451811840UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuietDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForQuietDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForQuietDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 5, WorkerInterface >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< WaitForQuietDatabaseActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
[[nodiscard]] Future<Void> waitForQuietDatabase( Database const& cx, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, std::string const& phase, int64_t const& dataInFlightGate = 2e6, int64_t const& maxTLogQueueGate = 5e6, int64_t const& maxStorageServerQueueGate = 5e6, int64_t const& maxDataDistributionQueueSize = 0, int64_t const& maxPoppedVersionLag = 30e6, int64_t const& maxVersionOffset = 1e6 ) {
															#line 1020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"
	return Future<Void>(new WaitForQuietDatabaseActor(cx, dbInfo, phase, dataInFlightGate, maxTLogQueueGate, maxStorageServerQueueGate, maxDataDistributionQueueSize, maxPoppedVersionLag, maxVersionOffset));
															#line 12732 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbserver/QuietDatabase.actor.g.cpp"
}

#line 1177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbserver/QuietDatabase.actor.cpp"

Future<Void> quietDatabase(Database const& cx,
                           Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,
                           std::string phase,
                           int64_t dataInFlightGate,
                           int64_t maxTLogQueueGate,
                           int64_t maxStorageServerQueueGate,
                           int64_t maxDataDistributionQueueSize,
                           int64_t maxPoppedVersionLag,
                           int64_t maxVersionOffset) {
	return waitForQuietDatabase(cx,
	                            dbInfo,
	                            phase,
	                            dataInFlightGate,
	                            maxTLogQueueGate,
	                            maxStorageServerQueueGate,
	                            maxDataDistributionQueueSize,
	                            maxPoppedVersionLag,
	                            maxVersionOffset);
}
