#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
/*
 * TenantSpecialKeys.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_TENANT_SPECIAL_KEYS_ACTOR_G_H)
#define FDBCLIENT_TENANT_SPECIAL_KEYS_ACTOR_G_H
#include "fdbclient/TenantSpecialKeys.actor.g.h"
#elif !defined(FDBCLIENT_TENANT_SPECIAL_KEYS_ACTOR_H)
#define FDBCLIENT_TENANT_SPECIAL_KEYS_ACTOR_H

#include "fdbclient/ActorLineageProfiler.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/SpecialKeySpace.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/Tuple.h"
#include "flow/Arena.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // This must be the last #include.

class TenantRangeImpl : public SpecialKeyRangeRWImpl {
private:
	static KeyRangeRef removePrefix(KeyRangeRef range, KeyRef prefix, KeyRef defaultEnd) {
		KeyRef begin = range.begin.removePrefix(prefix);
		KeyRef end;
		if (range.end.startsWith(prefix)) {
			end = range.end.removePrefix(prefix);
		} else {
			CODE_PROBE(true, "Tenant special keys remove prefix clamped to end", probe::decoration::rare);
			end = defaultEnd;
		}

		return KeyRangeRef(begin, end);
	}

	static KeyRef withTenantMapPrefix(KeyRef key, Arena& ar) {
		int keySize = SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin.size() +
		              submoduleRange.begin.size() + mapSubRange.begin.size() + key.size();

		KeyRef prefixedKey = makeString(keySize, ar);
		uint8_t* mutableKey = mutateString(prefixedKey);

		mutableKey = SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin.copyTo(mutableKey);
		mutableKey = submoduleRange.begin.copyTo(mutableKey);
		mutableKey = mapSubRange.begin.copyTo(mutableKey);

		key.copyTo(mutableKey);
		return prefixedKey;
	}

																#line 71 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via getTenantList()
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class GetTenantListActor>
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class GetTenantListActorState {
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	GetTenantListActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr,RangeResult* const& results,GetRangeLimits const& limitsHint) 
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : ryw(ryw),
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   kr(kr),
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   results(results),
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   limitsHint(limitsHint)
															#line 90 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("getTenantList", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantListActorState() 
	{
		fdb_probe_actor_destroy("getTenantList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			StrictFuture<std::vector<std::pair<TenantName, TenantMapEntry>>> __when_expr_0 = TenantAPI::listTenantMetadataTransaction(&ryw->getTransaction(), kr.begin, kr.end, limitsHint.rows);
															#line 73 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (static_cast<GetTenantListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 107 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantListActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantListActor, 0, std::vector<std::pair<TenantName, TenantMapEntry>> >*>(static_cast<GetTenantListActor*>(this)));
															#line 112 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantListActorState();
		static_cast<GetTenantListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TenantName, TenantMapEntry>> const& tenants,int loopDepth) 
	{
															#line 76 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto tenant : tenants ) {
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			std::string jsonString = tenant.second.toJson();
															#line 78 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			ValueRef tenantEntryBytes(results->arena(), jsonString);
															#line 79 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			results->push_back(results->arena(), KeyValueRef(withTenantMapPrefix(tenant.first, results->arena()), tenantEntryBytes));
															#line 141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<GetTenantListActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTenantListActorState(); static_cast<GetTenantListActor*>(this)->destroy(); return 0; }
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<GetTenantListActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTenantListActorState();
		static_cast<GetTenantListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TenantName, TenantMapEntry>> && tenants,int loopDepth) 
	{
															#line 76 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto tenant : tenants ) {
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			std::string jsonString = tenant.second.toJson();
															#line 78 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			ValueRef tenantEntryBytes(results->arena(), jsonString);
															#line 79 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			results->push_back(results->arena(), KeyValueRef(withTenantMapPrefix(tenant.first, results->arena()), tenantEntryBytes));
															#line 163 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<GetTenantListActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetTenantListActorState(); static_cast<GetTenantListActor*>(this)->destroy(); return 0; }
															#line 167 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<GetTenantListActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetTenantListActorState();
		static_cast<GetTenantListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TenantName, TenantMapEntry>> const& tenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenants, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TenantName, TenantMapEntry>> && tenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantListActor*>(this)->actor_wait_state > 0) static_cast<GetTenantListActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantListActor*>(this)->ActorCallback< GetTenantListActor, 0, std::vector<std::pair<TenantName, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantListActor, 0, std::vector<std::pair<TenantName, TenantMapEntry>> >*,std::vector<std::pair<TenantName, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("getTenantList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantListActor, 0, std::vector<std::pair<TenantName, TenantMapEntry>> >*,std::vector<std::pair<TenantName, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("getTenantList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantListActor, 0, std::vector<std::pair<TenantName, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantList", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	KeyRangeRef kr;
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	RangeResult* results;
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	GetRangeLimits limitsHint;
															#line 258 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via getTenantList()
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class GetTenantListActor final : public Actor<Void>, public ActorCallback< GetTenantListActor, 0, std::vector<std::pair<TenantName, TenantMapEntry>> >, public FastAllocated<GetTenantListActor>, public GetTenantListActorState<GetTenantListActor> {
															#line 263 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<GetTenantListActor>::operator new;
	using FastAllocated<GetTenantListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5517043453686187264UL, 15156773627303445248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantListActor, 0, std::vector<std::pair<TenantName, TenantMapEntry>> >;
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	GetTenantListActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr,RangeResult* const& results,GetRangeLimits const& limitsHint) 
															#line 280 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<Void>(),
		   GetTenantListActorState<GetTenantListActor>(ryw, kr, results, limitsHint),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1189576443889321728UL, 1285806307834110464UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantListActor, 0, std::vector<std::pair<TenantName, TenantMapEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<Void> getTenantList( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr, RangeResult* const& results, GetRangeLimits const& limitsHint ) {
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<Void>(new GetTenantListActor(ryw, kr, results, limitsHint));
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 85 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

																#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via getTenantRange()
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class GetTenantRangeActor>
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class GetTenantRangeActorState {
															#line 323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	GetTenantRangeActorState(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr,GetRangeLimits const& limitsHint) 
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : ryw(ryw),
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   kr(kr),
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   limitsHint(limitsHint),
															#line 89 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   results()
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("getTenantRange", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantRangeActorState() 
	{
		fdb_probe_actor_destroy("getTenantRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			kr = kr.removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin) .removePrefix(TenantRangeImpl::submoduleRange.begin);
															#line 94 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (kr.intersects(TenantRangeImpl::mapSubRange))
															#line 353 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 95 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				GetRangeLimits limits = limitsHint;
															#line 96 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				limits.decrement(results);
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				StrictFuture<Void> __when_expr_0 = getTenantList( ryw, removePrefix(kr & TenantRangeImpl::mapSubRange, TenantRangeImpl::mapSubRange.begin, "\xff"_sr), &results, limits);
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				if (static_cast<GetTenantRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 363 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetTenantRangeActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantRangeActor, 0, Void >*>(static_cast<GetTenantRangeActor*>(this)));
															#line 368 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantRangeActorState();
		static_cast<GetTenantRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 104 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<GetTenantRangeActor*>(this)->SAV<RangeResult>::futures) { (void)(results); this->~GetTenantRangeActorState(); static_cast<GetTenantRangeActor*>(this)->destroy(); return 0; }
															#line 396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<GetTenantRangeActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(results)); // state_var_RVO
		this->~GetTenantRangeActorState();
		static_cast<GetTenantRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantRangeActor*>(this)->actor_wait_state > 0) static_cast<GetTenantRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantRangeActor*>(this)->ActorCallback< GetTenantRangeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantRangeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getTenantRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantRangeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getTenantRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantRangeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	KeyRangeRef kr;
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	GetRangeLimits limitsHint;
															#line 89 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	RangeResult results;
															#line 499 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via getTenantRange()
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class GetTenantRangeActor final : public Actor<RangeResult>, public ActorCallback< GetTenantRangeActor, 0, Void >, public FastAllocated<GetTenantRangeActor>, public GetTenantRangeActorState<GetTenantRangeActor> {
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<GetTenantRangeActor>::operator new;
	using FastAllocated<GetTenantRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18138440724187894784UL, 6295740666511444224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantRangeActor, 0, Void >;
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	GetTenantRangeActor(ReadYourWritesTransaction* const& ryw,KeyRangeRef const& kr,GetRangeLimits const& limitsHint) 
															#line 521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<RangeResult>(),
		   GetTenantRangeActorState<GetTenantRangeActor>(ryw, kr, limitsHint),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8348593050258688512UL, 7183402805454896640UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantRangeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<RangeResult> getTenantRange( ReadYourWritesTransaction* const& ryw, KeyRangeRef const& kr, GetRangeLimits const& limitsHint ) {
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<RangeResult>(new GetTenantRangeActor(ryw, kr, limitsHint));
															#line 553 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

	// Returns true if the tenant was created, false if it already existed
																#line 559 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via createTenant()
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class CreateTenantActor>
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class CreateTenantActorState {
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	CreateTenantActorState(ReadYourWritesTransaction* const& ryw,TenantNameRef const& tenantName,std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> const& configMutations,int64_t const& tenantId,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : ryw(ryw),
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantName(tenantName),
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   configMutations(configMutations),
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantId(tenantId),
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantGroupNetTenantDelta(tenantGroupNetTenantDelta),
															#line 114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantEntry(tenantId, tenantName)
															#line 582 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("createTenant", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantActorState() 
	{
		fdb_probe_actor_destroy("createTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 116 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			for( auto const& [name, value] : configMutations ) {
															#line 117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				CODE_PROBE(true, "Special keys create tenant with configuration parameters");
															#line 118 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				tenantEntry.configure(name, value);
															#line 601 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
															#line 121 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (tenantEntry.tenantGroup.present())
															#line 605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 122 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				(*tenantGroupNetTenantDelta)[tenantEntry.tenantGroup.get()]++;
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
															#line 125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			StrictFuture<std::pair<Optional<TenantMapEntry>, bool>> __when_expr_0 = TenantAPI::createTenantTransaction(&ryw->getTransaction(), tenantEntry);
															#line 125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 615 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 1;
															#line 125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*>(static_cast<CreateTenantActor*>(this)));
															#line 620 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::pair<Optional<TenantMapEntry>, bool> const& entry,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<CreateTenantActor*>(this)->SAV<bool>::futures) { (void)(entry.second); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 643 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<CreateTenantActor*>(this)->SAV< bool >::value()) bool(entry.second);
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::pair<Optional<TenantMapEntry>, bool> && entry,int loopDepth) 
	{
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<CreateTenantActor*>(this)->SAV<bool>::futures) { (void)(entry.second); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<CreateTenantActor*>(this)->SAV< bool >::value()) bool(entry.second);
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::pair<Optional<TenantMapEntry>, bool> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<Optional<TenantMapEntry>, bool> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 0, std::pair<Optional<TenantMapEntry>, bool> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*,std::pair<Optional<TenantMapEntry>, bool> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*,std::pair<Optional<TenantMapEntry>, bool> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	TenantNameRef tenantName;
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> configMutations;
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	int64_t tenantId;
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::map<TenantGroupName, int>* tenantGroupNetTenantDelta;
															#line 114 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	TenantMapEntry tenantEntry;
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via createTenant()
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class CreateTenantActor final : public Actor<bool>, public ActorCallback< CreateTenantActor, 0, std::pair<Optional<TenantMapEntry>, bool> >, public FastAllocated<CreateTenantActor>, public CreateTenantActorState<CreateTenantActor> {
															#line 755 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<CreateTenantActor>::operator new;
	using FastAllocated<CreateTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10528390006180220672UL, 12044467222860840192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantActor, 0, std::pair<Optional<TenantMapEntry>, bool> >;
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	CreateTenantActor(ReadYourWritesTransaction* const& ryw,TenantNameRef const& tenantName,std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> const& configMutations,int64_t const& tenantId,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<bool>(),
		   CreateTenantActorState<CreateTenantActor>(ryw, tenantName, configMutations, tenantId, tenantGroupNetTenantDelta),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2480746510970185984UL, 428737674404862208UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantActor, 0, std::pair<Optional<TenantMapEntry>, bool> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<bool> createTenant( ReadYourWritesTransaction* const& ryw, TenantNameRef const& tenantName, std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> const& configMutations, int64_t const& tenantId, std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta ) {
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<bool>(new CreateTenantActor(ryw, tenantName, configMutations, tenantId, tenantGroupNetTenantDelta));
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 130 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

																#line 809 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via createTenants()
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class CreateTenantsActor>
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class CreateTenantsActorState {
															#line 815 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	CreateTenantsActorState(ReadYourWritesTransaction* const& ryw,std::map<TenantName, std::vector<std::pair<Standalone<StringRef>, Optional<Value>>>> const& tenants,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : ryw(ryw),
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenants(tenants),
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantGroupNetTenantDelta(tenantGroupNetTenantDelta),
															#line 135 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantCountFuture(TenantMetadata::tenantCount().getD(&ryw->getTransaction(), Snapshot::False, 0))
															#line 828 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("createTenants", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantsActorState() 
	{
		fdb_probe_actor_destroy("createTenants", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			StrictFuture<int64_t> __when_expr_0 = TenantAPI::getNextTenantId(&ryw->getTransaction());
															#line 137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (static_cast<CreateTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 845 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTenantsActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantsActor, 0, int64_t >*>(static_cast<CreateTenantsActor*>(this)));
															#line 850 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantsActorState();
		static_cast<CreateTenantsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t const& _nextId,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		nextId = _nextId;
															#line 139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		ASSERT(nextId >= 0);
															#line 141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		createFutures = std::vector<Future<bool>>();
															#line 142 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		int itrCount = 0;
															#line 143 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto const& [tenant, config] : tenants ) {
															#line 144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			createFutures.push_back(createTenant(ryw, tenant, config, nextId, tenantGroupNetTenantDelta));
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (++itrCount < tenants.size())
															#line 885 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				nextId = TenantAPI::computeNextTenantId(nextId, 1);
															#line 889 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
		}
															#line 150 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		TenantMetadata::lastTenantId().set(&ryw->getTransaction(), nextId);
															#line 151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(createFutures);
															#line 151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<CreateTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 898 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateTenantsActor*>(this)->actor_wait_state = 2;
															#line 151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantsActor, 1, Void >*>(static_cast<CreateTenantsActor*>(this)));
															#line 903 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t && _nextId,int loopDepth) 
	{
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		nextId = _nextId;
															#line 139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		ASSERT(nextId >= 0);
															#line 141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		createFutures = std::vector<Future<bool>>();
															#line 142 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		int itrCount = 0;
															#line 143 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto const& [tenant, config] : tenants ) {
															#line 144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			createFutures.push_back(createTenant(ryw, tenant, config, nextId, tenantGroupNetTenantDelta));
															#line 145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (++itrCount < tenants.size())
															#line 924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 146 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				nextId = TenantAPI::computeNextTenantId(nextId, 1);
															#line 928 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
		}
															#line 150 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		TenantMetadata::lastTenantId().set(&ryw->getTransaction(), nextId);
															#line 151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(createFutures);
															#line 151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<CreateTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 937 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateTenantsActor*>(this)->actor_wait_state = 2;
															#line 151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantsActor, 1, Void >*>(static_cast<CreateTenantsActor*>(this)));
															#line 942 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& _nextId,int loopDepth) 
	{
		loopDepth = a_body1cont1(_nextId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && _nextId,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_nextId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantsActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantsActor*>(this)->ActorCallback< CreateTenantsActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantsActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantsActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantsActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		numCreatedTenants = 0;
															#line 154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto f : createFutures ) {
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (f.get())
															#line 1030 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				++numCreatedTenants;
															#line 1034 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
		}
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		CODE_PROBE(numCreatedTenants > 1, "Special keys create multiple tenants simultaneously");
															#line 161 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		CODE_PROBE(numCreatedTenants < createFutures.size(), "Special keys some tenants not created");
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<int64_t> __when_expr_2 = tenantCountFuture;
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<CreateTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1045 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateTenantsActor*>(this)->actor_wait_state = 3;
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantsActor, 2, int64_t >*>(static_cast<CreateTenantsActor*>(this)));
															#line 1050 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		numCreatedTenants = 0;
															#line 154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto f : createFutures ) {
															#line 155 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (f.get())
															#line 1063 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				++numCreatedTenants;
															#line 1067 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
		}
															#line 160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		CODE_PROBE(numCreatedTenants > 1, "Special keys create multiple tenants simultaneously");
															#line 161 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		CODE_PROBE(numCreatedTenants < createFutures.size(), "Special keys some tenants not created");
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<int64_t> __when_expr_2 = tenantCountFuture;
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<CreateTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1078 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateTenantsActor*>(this)->actor_wait_state = 3;
															#line 164 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantsActor, 2, int64_t >*>(static_cast<CreateTenantsActor*>(this)));
															#line 1083 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTenantsActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantsActor*>(this)->ActorCallback< CreateTenantsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTenantsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTenantsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int64_t const& tenantCount,int loopDepth) 
	{
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (tenantCount + numCreatedTenants > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER)
															#line 1167 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			CODE_PROBE(true, "Special keys create tenants no capacity");
															#line 167 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 1173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<CreateTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantsActorState(); static_cast<CreateTenantsActor*>(this)->destroy(); return 0; }
															#line 1177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<CreateTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantsActorState();
		static_cast<CreateTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(int64_t && tenantCount,int loopDepth) 
	{
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (tenantCount + numCreatedTenants > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER)
															#line 1189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			CODE_PROBE(true, "Special keys create tenants no capacity");
															#line 167 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 1195 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<CreateTenantsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateTenantsActorState(); static_cast<CreateTenantsActor*>(this)->destroy(); return 0; }
															#line 1199 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<CreateTenantsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateTenantsActorState();
		static_cast<CreateTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& tenantCount,int loopDepth) 
	{
		loopDepth = a_body1cont5(tenantCount, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && tenantCount,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(tenantCount), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateTenantsActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantsActor*>(this)->ActorCallback< CreateTenantsActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantsActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateTenantsActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateTenantsActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::map<TenantName, std::vector<std::pair<Standalone<StringRef>, Optional<Value>>>> tenants;
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::map<TenantGroupName, int>* tenantGroupNetTenantDelta;
															#line 135 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	Future<int64_t> tenantCountFuture;
															#line 138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	int64_t nextId;
															#line 141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::vector<Future<bool>> createFutures;
															#line 153 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	int numCreatedTenants;
															#line 1296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via createTenants()
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class CreateTenantsActor final : public Actor<Void>, public ActorCallback< CreateTenantsActor, 0, int64_t >, public ActorCallback< CreateTenantsActor, 1, Void >, public ActorCallback< CreateTenantsActor, 2, int64_t >, public FastAllocated<CreateTenantsActor>, public CreateTenantsActorState<CreateTenantsActor> {
															#line 1301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<CreateTenantsActor>::operator new;
	using FastAllocated<CreateTenantsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13313483995490866432UL, 7731084603680487424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantsActor, 0, int64_t >;
friend struct ActorCallback< CreateTenantsActor, 1, Void >;
friend struct ActorCallback< CreateTenantsActor, 2, int64_t >;
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	CreateTenantsActor(ReadYourWritesTransaction* const& ryw,std::map<TenantName, std::vector<std::pair<Standalone<StringRef>, Optional<Value>>>> const& tenants,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 1320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<Void>(),
		   CreateTenantsActorState<CreateTenantsActor>(ryw, tenants, tenantGroupNetTenantDelta),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenants", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6555713481264031488UL, 1034817898882588416UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenants");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenants", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantsActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTenantsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateTenantsActor, 2, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<Void> createTenants( ReadYourWritesTransaction* const& ryw, std::map<TenantName, std::vector<std::pair<Standalone<StringRef>, Optional<Value>>>> const& tenants, std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta ) {
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<Void>(new CreateTenantsActor(ryw, tenants, tenantGroupNetTenantDelta));
															#line 1354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

																#line 1359 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via changeTenantConfig()
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class ChangeTenantConfigActor>
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class ChangeTenantConfigActorState {
															#line 1365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ChangeTenantConfigActorState(ReadYourWritesTransaction* const& ryw,TenantName const& tenantName,std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> const& configEntries,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : ryw(ryw),
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantName(tenantName),
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   configEntries(configEntries),
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantGroupNetTenantDelta(tenantGroupNetTenantDelta)
															#line 1378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("changeTenantConfig", reinterpret_cast<unsigned long>(this));

	}
	~ChangeTenantConfigActorState() 
	{
		fdb_probe_actor_destroy("changeTenantConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			StrictFuture<TenantMapEntry> __when_expr_0 = TenantAPI::getTenantTransaction(&ryw->getTransaction(), tenantName);
															#line 178 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state = 1;
															#line 178 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeTenantConfigActor, 0, TenantMapEntry >*>(static_cast<ChangeTenantConfigActor*>(this)));
															#line 1400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeTenantConfigActorState();
		static_cast<ChangeTenantConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TenantMapEntry const& originalEntry,int loopDepth) 
	{
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		TenantMapEntry updatedEntry = originalEntry;
															#line 180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto const& [name, value] : configEntries ) {
															#line 181 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			CODE_PROBE(true, "Special keys change tenant config");
															#line 182 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			updatedEntry.configure(name, value);
															#line 1429 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 185 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (originalEntry.tenantGroup != updatedEntry.tenantGroup)
															#line 1433 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (originalEntry.tenantGroup.present())
															#line 1437 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 187 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				(*tenantGroupNetTenantDelta)[originalEntry.tenantGroup.get()]--;
															#line 1441 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
															#line 189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (updatedEntry.tenantGroup.present())
															#line 1445 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				(*tenantGroupNetTenantDelta)[updatedEntry.tenantGroup.get()]++;
															#line 1449 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
		}
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<Void> __when_expr_1 = TenantAPI::configureTenantTransaction(&ryw->getTransaction(), originalEntry, updatedEntry);
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1456 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state = 2;
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeTenantConfigActor, 1, Void >*>(static_cast<ChangeTenantConfigActor*>(this)));
															#line 1461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TenantMapEntry && originalEntry,int loopDepth) 
	{
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		TenantMapEntry updatedEntry = originalEntry;
															#line 180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto const& [name, value] : configEntries ) {
															#line 181 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			CODE_PROBE(true, "Special keys change tenant config");
															#line 182 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			updatedEntry.configure(name, value);
															#line 1476 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 185 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (originalEntry.tenantGroup != updatedEntry.tenantGroup)
															#line 1480 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (originalEntry.tenantGroup.present())
															#line 1484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 187 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				(*tenantGroupNetTenantDelta)[originalEntry.tenantGroup.get()]--;
															#line 1488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
															#line 189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (updatedEntry.tenantGroup.present())
															#line 1492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				(*tenantGroupNetTenantDelta)[updatedEntry.tenantGroup.get()]++;
															#line 1496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
		}
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<Void> __when_expr_1 = TenantAPI::configureTenantTransaction(&ryw->getTransaction(), originalEntry, updatedEntry);
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1503 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state = 2;
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeTenantConfigActor, 1, Void >*>(static_cast<ChangeTenantConfigActor*>(this)));
															#line 1508 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry const& originalEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1(originalEntry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry && originalEntry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(originalEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeTenantConfigActor*>(this)->ActorCallback< ChangeTenantConfigActor, 0, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeTenantConfigActor, 0, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("changeTenantConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeTenantConfigActor, 0, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("changeTenantConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeTenantConfigActor, 0, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("changeTenantConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<ChangeTenantConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeTenantConfigActorState(); static_cast<ChangeTenantConfigActor*>(this)->destroy(); return 0; }
															#line 1592 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<ChangeTenantConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeTenantConfigActorState();
		static_cast<ChangeTenantConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<ChangeTenantConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeTenantConfigActorState(); static_cast<ChangeTenantConfigActor*>(this)->destroy(); return 0; }
															#line 1604 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<ChangeTenantConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeTenantConfigActorState();
		static_cast<ChangeTenantConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeTenantConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeTenantConfigActor*>(this)->ActorCallback< ChangeTenantConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeTenantConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeTenantConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeTenantConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeTenantConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeTenantConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeTenantConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeTenantConfig", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	TenantName tenantName;
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> configEntries;
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::map<TenantGroupName, int>* tenantGroupNetTenantDelta;
															#line 1695 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via changeTenantConfig()
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class ChangeTenantConfigActor final : public Actor<Void>, public ActorCallback< ChangeTenantConfigActor, 0, TenantMapEntry >, public ActorCallback< ChangeTenantConfigActor, 1, Void >, public FastAllocated<ChangeTenantConfigActor>, public ChangeTenantConfigActorState<ChangeTenantConfigActor> {
															#line 1700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<ChangeTenantConfigActor>::operator new;
	using FastAllocated<ChangeTenantConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10668757359930771712UL, 5233081766987203072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeTenantConfigActor, 0, TenantMapEntry >;
friend struct ActorCallback< ChangeTenantConfigActor, 1, Void >;
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ChangeTenantConfigActor(ReadYourWritesTransaction* const& ryw,TenantName const& tenantName,std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> const& configEntries,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 1718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<Void>(),
		   ChangeTenantConfigActorState<ChangeTenantConfigActor>(ryw, tenantName, configEntries, tenantGroupNetTenantDelta),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeTenantConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13482297832303556096UL, 10911990789913105664UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeTenantConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeTenantConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeTenantConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeTenantConfigActor, 0, TenantMapEntry >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeTenantConfigActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<Void> changeTenantConfig( ReadYourWritesTransaction* const& ryw, TenantName const& tenantName, std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> const& configEntries, std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta ) {
															#line 173 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<Void>(new ChangeTenantConfigActor(ryw, tenantName, configEntries, tenantGroupNetTenantDelta));
															#line 1751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

																#line 1756 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via deleteSingleTenant()
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class DeleteSingleTenantActor>
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class DeleteSingleTenantActorState {
															#line 1762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	DeleteSingleTenantActorState(ReadYourWritesTransaction* const& ryw,TenantName const& tenantName,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : ryw(ryw),
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantName(tenantName),
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantGroupNetTenantDelta(tenantGroupNetTenantDelta)
															#line 1773 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("deleteSingleTenant", reinterpret_cast<unsigned long>(this));

	}
	~DeleteSingleTenantActorState() 
	{
		fdb_probe_actor_destroy("deleteSingleTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			CODE_PROBE(true, "Special keys delete tenant");
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = TenantAPI::tryGetTenantTransaction(&ryw->getTransaction(), tenantName);
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (static_cast<DeleteSingleTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1792 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteSingleTenantActor*>(this)->actor_wait_state = 1;
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteSingleTenantActor, 0, Optional<TenantMapEntry> >*>(static_cast<DeleteSingleTenantActor*>(this)));
															#line 1797 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteSingleTenantActorState();
		static_cast<DeleteSingleTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (tenantEntry.present())
															#line 1820 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 206 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			StrictFuture<Void> __when_expr_1 = TenantAPI::deleteTenantTransaction(&ryw->getTransaction(), tenantEntry.get().id);
															#line 206 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (static_cast<DeleteSingleTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1826 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DeleteSingleTenantActor*>(this)->actor_wait_state = 2;
															#line 206 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteSingleTenantActor, 1, Void >*>(static_cast<DeleteSingleTenantActor*>(this)));
															#line 1831 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& __tenantEntry,int loopDepth) 
	{
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		tenantEntry = __tenantEntry;
															#line 1845 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteSingleTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteSingleTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteSingleTenantActor*>(this)->ActorCallback< DeleteSingleTenantActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteSingleTenantActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteSingleTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteSingleTenantActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteSingleTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteSingleTenantActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteSingleTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 212 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<DeleteSingleTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteSingleTenantActorState(); static_cast<DeleteSingleTenantActor*>(this)->destroy(); return 0; }
															#line 1924 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<DeleteSingleTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteSingleTenantActorState();
		static_cast<DeleteSingleTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (tenantEntry.get().tenantGroup.present())
															#line 1936 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 208 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			(*tenantGroupNetTenantDelta)[tenantEntry.get().tenantGroup.get()]--;
															#line 1940 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (tenantEntry.get().tenantGroup.present())
															#line 1950 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 208 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			(*tenantGroupNetTenantDelta)[tenantEntry.get().tenantGroup.get()]--;
															#line 1954 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteSingleTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteSingleTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteSingleTenantActor*>(this)->ActorCallback< DeleteSingleTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteSingleTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteSingleTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteSingleTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteSingleTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteSingleTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteSingleTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteSingleTenant", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	TenantName tenantName;
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::map<TenantGroupName, int>* tenantGroupNetTenantDelta;
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	Optional<TenantMapEntry> tenantEntry;
															#line 2043 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via deleteSingleTenant()
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class DeleteSingleTenantActor final : public Actor<Void>, public ActorCallback< DeleteSingleTenantActor, 0, Optional<TenantMapEntry> >, public ActorCallback< DeleteSingleTenantActor, 1, Void >, public FastAllocated<DeleteSingleTenantActor>, public DeleteSingleTenantActorState<DeleteSingleTenantActor> {
															#line 2048 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<DeleteSingleTenantActor>::operator new;
	using FastAllocated<DeleteSingleTenantActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14136907212175101184UL, 15627967454652005120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteSingleTenantActor, 0, Optional<TenantMapEntry> >;
friend struct ActorCallback< DeleteSingleTenantActor, 1, Void >;
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	DeleteSingleTenantActor(ReadYourWritesTransaction* const& ryw,TenantName const& tenantName,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 2066 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<Void>(),
		   DeleteSingleTenantActorState<DeleteSingleTenantActor>(ryw, tenantName, tenantGroupNetTenantDelta),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteSingleTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7274240575925827328UL, 14971077397750937600UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteSingleTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteSingleTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteSingleTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteSingleTenantActor, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteSingleTenantActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<Void> deleteSingleTenant( ReadYourWritesTransaction* const& ryw, TenantName const& tenantName, std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta ) {
															#line 198 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<Void>(new DeleteSingleTenantActor(ryw, tenantName, tenantGroupNetTenantDelta));
															#line 2099 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 214 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

																#line 2104 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via deleteTenantRange()
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class DeleteTenantRangeActor>
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class DeleteTenantRangeActorState {
															#line 2110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	DeleteTenantRangeActorState(ReadYourWritesTransaction* const& ryw,TenantName const& beginTenant,TenantName const& endTenant,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : ryw(ryw),
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   beginTenant(beginTenant),
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   endTenant(endTenant),
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantGroupNetTenantDelta(tenantGroupNetTenantDelta)
															#line 2123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("deleteTenantRange", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantRangeActorState() 
	{
		fdb_probe_actor_destroy("deleteTenantRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			StrictFuture<std::vector<std::pair<TenantName, int64_t>>> __when_expr_0 = TenantAPI::listTenantsTransaction(&ryw->getTransaction(), beginTenant, endTenant, CLIENT_KNOBS->TOO_MANY);
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (static_cast<DeleteTenantRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2140 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantRangeActor*>(this)->actor_wait_state = 1;
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantRangeActor, 0, std::vector<std::pair<TenantName, int64_t>> >*>(static_cast<DeleteTenantRangeActor*>(this)));
															#line 2145 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantRangeActorState();
		static_cast<DeleteTenantRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 222 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (tenants.size() == CLIENT_KNOBS->TOO_MANY)
															#line 2168 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			TraceEvent(SevWarn, "DeleteTenantRangeTooLange") .detail("BeginTenant", beginTenant) .detail("EndTenant", endTenant);
															#line 226 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "delete tenants", "too many tenants to range delete"));
															#line 228 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 2176 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		std::vector<Future<Void>> deleteFutures;
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto tenant : tenants ) {
															#line 233 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			deleteFutures.push_back(deleteSingleTenant(ryw, tenant.first, tenantGroupNetTenantDelta));
															#line 2184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 236 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		CODE_PROBE(deleteFutures.size() > 1, "Special keys delete multiple tenants simultaneously");
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(deleteFutures);
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<DeleteTenantRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2192 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteTenantRangeActor*>(this)->actor_wait_state = 2;
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantRangeActor, 1, Void >*>(static_cast<DeleteTenantRangeActor*>(this)));
															#line 2197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TenantName, int64_t>> const& __tenants,int loopDepth) 
	{
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		tenants = __tenants;
															#line 2206 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TenantName, int64_t>> && __tenants,int loopDepth) 
	{
		tenants = std::move(__tenants);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantRangeActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantRangeActor*>(this)->ActorCallback< DeleteTenantRangeActor, 0, std::vector<std::pair<TenantName, int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantRangeActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> const& value) 
	{
		fdb_probe_actor_enter("deleteTenantRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantRangeActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> && value) 
	{
		fdb_probe_actor_enter("deleteTenantRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantRangeActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 239 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<DeleteTenantRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantRangeActorState(); static_cast<DeleteTenantRangeActor*>(this)->destroy(); return 0; }
															#line 2285 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<DeleteTenantRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantRangeActorState();
		static_cast<DeleteTenantRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 239 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<DeleteTenantRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantRangeActorState(); static_cast<DeleteTenantRangeActor*>(this)->destroy(); return 0; }
															#line 2297 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<DeleteTenantRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantRangeActorState();
		static_cast<DeleteTenantRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteTenantRangeActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantRangeActor*>(this)->ActorCallback< DeleteTenantRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteTenantRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteTenantRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	TenantName beginTenant;
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	TenantName endTenant;
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::map<TenantGroupName, int>* tenantGroupNetTenantDelta;
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::vector<std::pair<TenantName, int64_t>> tenants;
															#line 2390 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via deleteTenantRange()
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class DeleteTenantRangeActor final : public Actor<Void>, public ActorCallback< DeleteTenantRangeActor, 0, std::vector<std::pair<TenantName, int64_t>> >, public ActorCallback< DeleteTenantRangeActor, 1, Void >, public FastAllocated<DeleteTenantRangeActor>, public DeleteTenantRangeActorState<DeleteTenantRangeActor> {
															#line 2395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<DeleteTenantRangeActor>::operator new;
	using FastAllocated<DeleteTenantRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3215381945432098048UL, 16455367464386947584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantRangeActor, 0, std::vector<std::pair<TenantName, int64_t>> >;
friend struct ActorCallback< DeleteTenantRangeActor, 1, Void >;
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	DeleteTenantRangeActor(ReadYourWritesTransaction* const& ryw,TenantName const& beginTenant,TenantName const& endTenant,std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta) 
															#line 2413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<Void>(),
		   DeleteTenantRangeActorState<DeleteTenantRangeActor>(ryw, beginTenant, endTenant, tenantGroupNetTenantDelta),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenantRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2323746150687586304UL, 8570656544130536704UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenantRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenantRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantRangeActor, 0, std::vector<std::pair<TenantName, int64_t>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteTenantRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<Void> deleteTenantRange( ReadYourWritesTransaction* const& ryw, TenantName const& beginTenant, TenantName const& endTenant, std::map<TenantGroupName, int>* const& tenantGroupNetTenantDelta ) {
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<Void>(new DeleteTenantRangeActor(ryw, beginTenant, endTenant, tenantGroupNetTenantDelta));
															#line 2446 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

	// Check if the number of tenants in the tenant group is equal to the net reduction in the number of tenants.
	// If it is, then we can delete the tenant group.
																#line 2453 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via checkAndRemoveTenantGroup()
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class CheckAndRemoveTenantGroupActor>
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class CheckAndRemoveTenantGroupActorState {
															#line 2459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	CheckAndRemoveTenantGroupActorState(ReadYourWritesTransaction* const& ryw,TenantGroupName const& tenantGroup,int const& tenantDelta) 
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : ryw(ryw),
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantGroup(tenantGroup),
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantDelta(tenantDelta)
															#line 2470 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	~CheckAndRemoveTenantGroupActorState() 
	{
		fdb_probe_actor_destroy("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			ASSERT(tenantDelta < 0);
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			removedTenants = -tenantDelta;
															#line 249 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			StrictFuture<KeyBackedSet<Tuple>::RangeResultType> __when_expr_0 = TenantMetadata::tenantGroupTenantIndex().getRange(&ryw->getTransaction(), Tuple::makeTuple(tenantGroup), Tuple::makeTuple(keyAfter(tenantGroup)), removedTenants + 1);
															#line 249 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (static_cast<CheckAndRemoveTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2491 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAndRemoveTenantGroupActor*>(this)->actor_wait_state = 1;
															#line 249 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAndRemoveTenantGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*>(static_cast<CheckAndRemoveTenantGroupActor*>(this)));
															#line 2496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAndRemoveTenantGroupActorState();
		static_cast<CheckAndRemoveTenantGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedSet<Tuple>::RangeResultType const& tenantsInGroup,int loopDepth) 
	{
															#line 255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		ASSERT(tenantsInGroup.results.size() >= removedTenants);
															#line 256 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (tenantsInGroup.results.size() == removedTenants)
															#line 2521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			CODE_PROBE(true, "Special keys tenant modifications removed tenant");
															#line 258 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			TenantMetadata::tenantGroupMap().erase(&ryw->getTransaction(), tenantGroup);
															#line 2527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<CheckAndRemoveTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckAndRemoveTenantGroupActorState(); static_cast<CheckAndRemoveTenantGroupActor*>(this)->destroy(); return 0; }
															#line 2531 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<CheckAndRemoveTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckAndRemoveTenantGroupActorState();
		static_cast<CheckAndRemoveTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedSet<Tuple>::RangeResultType && tenantsInGroup,int loopDepth) 
	{
															#line 255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		ASSERT(tenantsInGroup.results.size() >= removedTenants);
															#line 256 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (tenantsInGroup.results.size() == removedTenants)
															#line 2545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			CODE_PROBE(true, "Special keys tenant modifications removed tenant");
															#line 258 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			TenantMetadata::tenantGroupMap().erase(&ryw->getTransaction(), tenantGroup);
															#line 2551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<CheckAndRemoveTenantGroupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckAndRemoveTenantGroupActorState(); static_cast<CheckAndRemoveTenantGroupActor*>(this)->destroy(); return 0; }
															#line 2555 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<CheckAndRemoveTenantGroupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckAndRemoveTenantGroupActorState();
		static_cast<CheckAndRemoveTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType const& tenantsInGroup,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantsInGroup, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType && tenantsInGroup,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantsInGroup), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAndRemoveTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<CheckAndRemoveTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAndRemoveTenantGroupActor*>(this)->ActorCallback< CheckAndRemoveTenantGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAndRemoveTenantGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAndRemoveTenantGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAndRemoveTenantGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	TenantGroupName tenantGroup;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	int tenantDelta;
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	int removedTenants;
															#line 2646 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via checkAndRemoveTenantGroup()
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class CheckAndRemoveTenantGroupActor final : public Actor<Void>, public ActorCallback< CheckAndRemoveTenantGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >, public FastAllocated<CheckAndRemoveTenantGroupActor>, public CheckAndRemoveTenantGroupActorState<CheckAndRemoveTenantGroupActor> {
															#line 2651 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<CheckAndRemoveTenantGroupActor>::operator new;
	using FastAllocated<CheckAndRemoveTenantGroupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12017151954141798656UL, 195025748054178560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAndRemoveTenantGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	CheckAndRemoveTenantGroupActor(ReadYourWritesTransaction* const& ryw,TenantGroupName const& tenantGroup,int const& tenantDelta) 
															#line 2668 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<Void>(),
		   CheckAndRemoveTenantGroupActorState<CheckAndRemoveTenantGroupActor>(ryw, tenantGroup, tenantDelta),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7510537332272824832UL, 8794843883172138240UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAndRemoveTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAndRemoveTenantGroup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAndRemoveTenantGroup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAndRemoveTenantGroupActor, 0, KeyBackedSet<Tuple>::RangeResultType >*)0, actor_cancelled()); break;
		}

	}
};
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<Void> checkAndRemoveTenantGroup( ReadYourWritesTransaction* const& ryw, TenantGroupName const& tenantGroup, int const& tenantDelta ) {
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<Void>(new CheckAndRemoveTenantGroupActor(ryw, tenantGroup, tenantDelta));
															#line 2700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 263 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

public:
	const inline static KeyRangeRef submoduleRange = KeyRangeRef("tenant/"_sr, "tenant0"_sr);
	const inline static KeyRangeRef mapSubRange = KeyRangeRef("map/"_sr, "map0"_sr);
	const inline static KeyRangeRef configureSubRange = KeyRangeRef("configure/"_sr, "configure0"_sr);
	const inline static KeyRangeRef renameSubRange = KeyRangeRef("rename/"_sr, "rename0"_sr);

	explicit TenantRangeImpl(KeyRangeRef kr) : SpecialKeyRangeRWImpl(kr) {}

	Future<RangeResult> getRange(ReadYourWritesTransaction* ryw,
	                             KeyRangeRef kr,
	                             GetRangeLimits limitsHint) const override {
		return getTenantRange(ryw, kr, limitsHint);
	}

																#line 2719 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
// This generated class is to be used only via commitImpl()
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
template <class CommitImplActor>
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class CommitImplActorState {
															#line 2725 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	CommitImplActorState(TenantRangeImpl* const& self,ReadYourWritesTransaction* const& ryw) 
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		 : self(self),
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   ryw(ryw),
															#line 279 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantManagementFutures(),
															#line 287 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   tenantGroupNetTenantDelta(),
															#line 289 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   ranges(ryw->getSpecialKeySpaceWriteMap().containedRanges(self->range)),
															#line 292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   mapMutations(),
															#line 293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   configMutations(),
															#line 294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   renameSet(),
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		   renameMutations()
															#line 2748 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
	{
		fdb_probe_actor_create("commitImpl", reinterpret_cast<unsigned long>(this));

	}
	~CommitImplActorState() 
	{
		fdb_probe_actor_destroy("commitImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 297 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			tenantManagementFutures.push_back(TenantAPI::checkTenantMode(&ryw->getTransaction(), ClusterType::STANDALONE));
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			RangeForbody1Iterator0 = std::begin(ranges);
															#line 2765 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitImplActorState();
		static_cast<CommitImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		std::map<TenantName, std::vector<std::pair<Standalone<StringRef>, Optional<Value>>>> tenantsToCreate;
															#line 347 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto mapMutation : mapMutations ) {
															#line 348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			TenantNameRef tenantName = mapMutation.first.begin;
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			auto set_iter = renameSet.lower_bound(tenantName);
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (set_iter != renameSet.end() && mapMutation.first.contains(*set_iter))
															#line 2796 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				CODE_PROBE(true, "Special keys tenant rename conflicts with tenant creation/deletion", probe::decoration::rare);
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "rename tenant", "tenant rename conflict"));
															#line 356 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 2804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (mapMutation.second.present())
															#line 2808 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 359 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				std::vector<std::pair<Standalone<StringRef>, Optional<Value>>> createMutations;
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				auto itr = configMutations.find(tenantName);
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				if (itr != configMutations.end())
															#line 2816 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				{
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					createMutations = itr->second;
															#line 363 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					configMutations.erase(itr);
															#line 2822 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				}
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				tenantsToCreate[tenantName] = createMutations;
															#line 2826 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
			else
			{
															#line 368 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				if (mapMutation.first.singleKeyRange())
															#line 2832 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				{
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					CODE_PROBE(true, "Special keys single key tenant deletion");
															#line 370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					tenantManagementFutures.push_back(deleteSingleTenant(ryw, tenantName, &tenantGroupNetTenantDelta));
															#line 373 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					configMutations.erase(tenantName);
															#line 2840 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				}
				else
				{
															#line 375 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					tenantManagementFutures.push_back( deleteTenantRange(ryw, tenantName, mapMutation.first.end, &tenantGroupNetTenantDelta));
															#line 379 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					configMutations.erase(configMutations.lower_bound(tenantName), configMutations.lower_bound(mapMutation.first.end));
															#line 2848 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				}
			}
		}
															#line 385 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		CODE_PROBE(!mapMutations.empty() && !configMutations.empty(), "Special keys simultaneous tenant create/delete and config changes", probe::decoration::rare);
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!tenantsToCreate.empty())
															#line 2856 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 390 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			tenantManagementFutures.push_back(createTenants(ryw, tenantsToCreate, &tenantGroupNetTenantDelta));
															#line 2860 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 392 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto configMutation : configMutations ) {
															#line 393 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (renameSet.count(configMutation.first))
															#line 2866 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				CODE_PROBE(true, "Special keys tenant rename conflicts with tenant configuration change", probe::decoration::rare);
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "rename tenant", "tenant rename conflict"));
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				return a_body1Catch1(special_keys_api_failure(), loopDepth);
															#line 2874 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			tenantManagementFutures.push_back( changeTenantConfig(ryw, configMutation.first, configMutation.second, &tenantGroupNetTenantDelta));
															#line 2878 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto renameMutation : renameMutations ) {
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			tenantManagementFutures.push_back(TenantAPI::renameTenantTransaction( &ryw->getTransaction(), renameMutation.first, renameMutation.second));
															#line 2884 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
															#line 410 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<Void> __when_expr_0 = waitForAll(tenantManagementFutures);
															#line 410 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<CommitImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2890 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1cont1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CommitImplActor*>(this)->actor_wait_state = 1;
															#line 410 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitImplActor, 0, Void >*>(static_cast<CommitImplActor*>(this)));
															#line 2895 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!(RangeForbody1Iterator0 != std::end(ranges)))
															#line 2911 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		auto range = *RangeForbody1Iterator0;
															#line 2917 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		{
															#line 300 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (!range.value().first)
															#line 2921 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
				return a_body1continue1(loopDepth); // continue
			}
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			adjustedRange = range.range() .removePrefix(SpecialKeySpace::getModuleRange(SpecialKeySpace::MODULE::MANAGEMENT).begin) .removePrefix(submoduleRange.begin);
															#line 309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (mapSubRange.intersects(adjustedRange))
															#line 2929 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				adjustedRange = mapSubRange & adjustedRange;
															#line 311 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				adjustedRange = removePrefix(adjustedRange, mapSubRange.begin, "\xff"_sr);
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				mapMutations.push_back(std::make_pair(adjustedRange, range.value().second));
															#line 2937 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
			else
			{
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				if (configureSubRange.intersects(adjustedRange) && adjustedRange.singleKeyRange())
															#line 2944 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
				{
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					StringRef configTupleStr = adjustedRange.begin.removePrefix(configureSubRange.begin);
															#line 2948 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
					try {
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						Tuple tuple = Tuple::unpack(configTupleStr);
															#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						if (tuple.size() != 2)
															#line 2954 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
						{
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
							return a_body1loopBody1Catch1(invalid_tuple_index(), loopDepth);
															#line 2958 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
						}
															#line 320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						configMutations[tuple.getString(0)].push_back( std::make_pair(tuple.getString(1), range.value().second));
															#line 2962 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
						loopDepth = a_body1loopBody1cont10(loopDepth);
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
															#line 329 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
					if (renameSubRange.intersects(adjustedRange))
															#line 2975 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
					{
															#line 330 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						StringRef oldName = adjustedRange.begin.removePrefix(renameSubRange.begin);
															#line 331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						StringRef newName = range.value().second.get();
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						if (renameSet.count(oldName) || renameSet.count(newName) || oldName == newName)
															#line 2983 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
						{
															#line 335 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
							CODE_PROBE(true, "Special keys tenant rename conflict");
															#line 336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
							ryw->setSpecialKeySpaceErrorMsg( ManagementAPIError::toJsonString(false, "rename tenant", "tenant rename conflict"));
															#line 338 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
							return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 2991 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
						}
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						renameSet.insert(oldName);
															#line 341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						renameSet.insert(newName);
															#line 342 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
						renameMutations.push_back(std::make_pair(oldName, newName));
															#line 2999 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
					}
					loopDepth = a_body1loopBody1cont6(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1continue1(int loopDepth) 
	{
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		++RangeForbody1Iterator0;
															#line 3025 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		++RangeForbody1Iterator0;
															#line 3034 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 323 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			CODE_PROBE(true, "Special keys invalid tenant configuration key");
															#line 324 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			TraceEvent(SevWarn, "InvalidTenantConfigurationKey").error(e).detail("Key", adjustedRange.begin);
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			ryw->setSpecialKeySpaceErrorMsg(ManagementAPIError::toJsonString( false, "configure tenant", "invalid tenant configuration key"));
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			return a_body1Catch1(special_keys_api_failure(), std::max(0, loopDepth - 1));
															#line 3068 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 412 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		tenantGroupUpdateFutures = std::vector<Future<Void>>();
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto [tenantGroup, count] : tenantGroupNetTenantDelta ) {
															#line 414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (count < 0)
															#line 3099 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 415 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				tenantGroupUpdateFutures.push_back(checkAndRemoveTenantGroup(ryw, tenantGroup, count));
															#line 3103 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
		}
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(tenantGroupUpdateFutures);
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<CommitImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitImplActor*>(this)->actor_wait_state = 2;
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitImplActor, 1, Void >*>(static_cast<CommitImplActor*>(this)));
															#line 3115 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 412 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		tenantGroupUpdateFutures = std::vector<Future<Void>>();
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		for( auto [tenantGroup, count] : tenantGroupNetTenantDelta ) {
															#line 414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
			if (count < 0)
															#line 3128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			{
															#line 415 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
				tenantGroupUpdateFutures.push_back(checkAndRemoveTenantGroup(ryw, tenantGroup, count));
															#line 3132 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
			}
		}
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(tenantGroupUpdateFutures);
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (static_cast<CommitImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CommitImplActor*>(this)->actor_wait_state = 2;
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CommitImplActor, 1, Void >*>(static_cast<CommitImplActor*>(this)));
															#line 3144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitImplActor*>(this)->actor_wait_state > 0) static_cast<CommitImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitImplActor*>(this)->ActorCallback< CommitImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
															#line 420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<CommitImplActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~CommitImplActorState(); static_cast<CommitImplActor*>(this)->destroy(); return 0; }
															#line 3228 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<CommitImplActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~CommitImplActorState();
		static_cast<CommitImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
															#line 420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
		if (!static_cast<CommitImplActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~CommitImplActorState(); static_cast<CommitImplActor*>(this)->destroy(); return 0; }
															#line 3240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		new (&static_cast<CommitImplActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~CommitImplActorState();
		static_cast<CommitImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CommitImplActor*>(this)->actor_wait_state > 0) static_cast<CommitImplActor*>(this)->actor_wait_state = 0;
		static_cast<CommitImplActor*>(this)->ActorCallback< CommitImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CommitImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CommitImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	TenantRangeImpl* self;
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	ReadYourWritesTransaction* ryw;
															#line 279 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::vector<Future<Void>> tenantManagementFutures;
															#line 287 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::map<TenantGroupName, int> tenantGroupNetTenantDelta;
															#line 289 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	KeyRangeMap<std::pair<bool, Optional<Value>>>::Ranges ranges;
															#line 292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::vector<std::pair<KeyRangeRef, Optional<Value>>> mapMutations;
															#line 293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::map<TenantName, std::vector<std::pair<Standalone<StringRef>, Optional<Value>>>> configMutations;
															#line 294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::set<TenantName> renameSet;
															#line 295 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::vector<std::pair<TenantName, TenantName>> renameMutations;
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	decltype(std::begin(std::declval<KeyRangeMap<std::pair<bool, Optional<Value>>>::Ranges>())) RangeForbody1Iterator0;
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	KeyRangeRef adjustedRange;
															#line 412 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	std::vector<Future<Void>> tenantGroupUpdateFutures;
															#line 3347 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
};
// This generated class is to be used only via commitImpl()
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
class CommitImplActor final : public Actor<Optional<std::string>>, public ActorCallback< CommitImplActor, 0, Void >, public ActorCallback< CommitImplActor, 1, Void >, public FastAllocated<CommitImplActor>, public CommitImplActorState<CommitImplActor> {
															#line 3352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
public:
	using FastAllocated<CommitImplActor>::operator new;
	using FastAllocated<CommitImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14052055470040960000UL, 5012916134291490816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitImplActor, 0, Void >;
friend struct ActorCallback< CommitImplActor, 1, Void >;
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	CommitImplActor(TenantRangeImpl* const& self,ReadYourWritesTransaction* const& ryw) 
															#line 3370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
		 : Actor<Optional<std::string>>(),
		   CommitImplActorState<CommitImplActor>(self, ryw),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12584904867932912128UL, 14410163751793702912UL);
		ActorExecutionContextHelper __helper(static_cast<CommitImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CommitImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
[[nodiscard]] static Future<Optional<std::string>> commitImpl( TenantRangeImpl* const& self, ReadYourWritesTransaction* const& ryw ) {
															#line 278 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"
	return Future<Optional<std::string>>(new CommitImplActor(self, ryw));
															#line 3403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantSpecialKeys.actor.g.h"
}

#line 422 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantSpecialKeys.actor.h"

	Future<Optional<std::string>> commit(ReadYourWritesTransaction* ryw) override { return commitImpl(this, ryw); }
};

#include "flow/unactorcompiler.h"
#endif