#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
/*
 * S3Client.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <string>
#include <vector>
#include <unordered_set>
#include <algorithm>

#ifdef _WIN32
#include <io.h>
#endif

#include "fdbclient/S3Client.actor.h"
#include "flow/IAsyncFile.h"
#include "flow/Trace.h"
#include "flow/Traceable.h"
#include "flow/flow.h"
#include "flow/xxhash.h"
#include "flow/Error.h"
#include "rapidxml/rapidxml.hpp"

#include "flow/actorcompiler.h" // has to be last include

#define S3_CHECKSUM_TAG_NAME "xxhash64"

typedef XXH64_state_t XXHashState;

// State for a part of a multipart upload.
struct PartState {
	int partNumber = 0;
	std::string etag;
	int64_t offset = 0;
	int64_t size = 0;
	std::string md5;
	bool completed = false;

	PartState() = default; // Add explicit default constructor

	PartState(int pNum, int64_t off, int64_t sz, std::string m = "")
	  : partNumber(pNum), offset(off), size(sz), md5(m) {}
};

// Config for a part of a multipart upload.
struct PartConfig {
	// Let this be the minimum configured part size.
	int64_t partSizeBytes = CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE;
	// Retry delay for multipart uploads
	int retryDelayMs = CLIENT_KNOBS->BLOBSTORE_MULTIPART_RETRY_DELAY_MS;
};

// Calculate hash of a file.
// Uses xxhash library because it's fast (supposedly) and used elsewhere in fdb.
// If size is -1, the function will determine the file size automatically.
// Returns a hex string representation of the xxhash64 checksum.
															#line 74 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via calculateFileChecksum()
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CalculateFileChecksumActor>
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CalculateFileChecksumActorState {
															#line 81 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CalculateFileChecksumActorState(Reference<IAsyncFile> const& file,int64_t const& size) 
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : file(file),
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   size(size),
															#line 73 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   pos(0),
															#line 74 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   hashState(XXH64_createState()),
															#line 75 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   buffer(65536),
															#line 76 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   readSize()
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("calculateFileChecksum", reinterpret_cast<unsigned long>(this));

	}
	~CalculateFileChecksumActorState() 
	{
		fdb_probe_actor_destroy("calculateFileChecksum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_reset(hashState, 0);
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			try {
															#line 81 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (size == -1)
															#line 117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					StrictFuture<int64_t> __when_expr_0 = file->size();
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 123 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CalculateFileChecksumActor, 0, int64_t >*>(static_cast<CalculateFileChecksumActor*>(this)));
															#line 128 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CalculateFileChecksumActorState();
		static_cast<CalculateFileChecksumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 165 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 179 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t const& s,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = s;
															#line 188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t && s,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = s;
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t const& s,int loopDepth) 
	{
		loopDepth = a_body1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && s,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state > 0) static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<CalculateFileChecksumActor*>(this)->ActorCallback< CalculateFileChecksumActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 102 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 103 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CalculateFileChecksumActor*>(this)->SAV<std::string>::futures) { (void)(format("%016llx", hash)); this->~CalculateFileChecksumActorState(); static_cast<CalculateFileChecksumActor*>(this)->destroy(); return 0; }
															#line 285 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CalculateFileChecksumActor*>(this)->SAV< std::string >::value()) std::string(format("%016llx", hash));
		this->~CalculateFileChecksumActorState();
		static_cast<CalculateFileChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(pos < size))
															#line 304 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 87 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		readSize = std::min<int64_t>(buffer.size(), size - pos);
															#line 88 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int> __when_expr_1 = file->read(buffer.data(), readSize, pos);
															#line 88 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 2;
															#line 88 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CalculateFileChecksumActor, 1, int >*>(static_cast<CalculateFileChecksumActor*>(this)));
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 89 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != readSize)
															#line 341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 90 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCalculateChecksumReadError") .detail("Expected", readSize) .detail("Actual", bytesRead) .detail("Position", pos);
															#line 95 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, buffer.data(), bytesRead);
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pos += bytesRead;
															#line 355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 89 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != readSize)
															#line 364 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 90 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCalculateChecksumReadError") .detail("Expected", readSize) .detail("Actual", bytesRead) .detail("Position", pos);
															#line 95 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, buffer.data(), bytesRead);
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pos += bytesRead;
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state > 0) static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<CalculateFileChecksumActor*>(this)->ActorCallback< CalculateFileChecksumActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CalculateFileChecksumActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t size;
															#line 73 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t pos;
															#line 74 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	XXH64_state_t* hashState;
															#line 75 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<uint8_t> buffer;
															#line 76 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int readSize;
															#line 470 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via calculateFileChecksum()
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CalculateFileChecksumActor final : public Actor<std::string>, public ActorCallback< CalculateFileChecksumActor, 0, int64_t >, public ActorCallback< CalculateFileChecksumActor, 1, int >, public FastAllocated<CalculateFileChecksumActor>, public CalculateFileChecksumActorState<CalculateFileChecksumActor> {
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CalculateFileChecksumActor>::operator new;
	using FastAllocated<CalculateFileChecksumActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11720435171316710400UL, 12023564104214900480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CalculateFileChecksumActor, 0, int64_t >;
friend struct ActorCallback< CalculateFileChecksumActor, 1, int >;
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CalculateFileChecksumActor(Reference<IAsyncFile> const& file,int64_t const& size) 
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<std::string>(),
		   CalculateFileChecksumActorState<CalculateFileChecksumActor>(file, size),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12128180428655768320UL, 2149007350426683136UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("calculateFileChecksum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CalculateFileChecksumActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CalculateFileChecksumActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<std::string> calculateFileChecksum( Reference<IAsyncFile> const& file, int64_t const& size ) {
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<std::string>(new CalculateFileChecksumActor(file, size));
															#line 527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 109 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Get the endpoint for the given s3url.
// Populates parameters and resource with parse of s3url.
Reference<S3BlobStoreEndpoint> getEndpoint(const std::string& s3url,
                                           std::string& resource,
                                           S3BlobStoreEndpoint::ParametersT& parameters) {
	try {
		std::string error;
		Optional<std::string> proxy;
		auto res = g_network->global(INetwork::enProxy);
		if (res) {
			proxy = *static_cast<Optional<std::string>*>(res);
		}
		Reference<S3BlobStoreEndpoint> endpoint =
		    S3BlobStoreEndpoint::fromString(s3url, proxy, &resource, &error, &parameters);

		if (!endpoint) {
			TraceEvent(SevError, "S3ClientGetEndpointNullEndpoint").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		// Let empty resource path be valid - it means list root of bucket

		// Validate bucket parameter exists
		if (parameters.find("bucket") == parameters.end()) {
			TraceEvent(SevError, "S3ClientGetEndpointMissingBucket").detail("URL", s3url);
			throw backup_invalid_url();
		}

		// Validate resource path characters
		for (char c : resource) {
			if (!isalnum(c) && c != '_' && c != '-' && c != '.' && c != '/') {
				TraceEvent(SevError, "S3ClientGetEndpointIllegalCharacter")
				    .detail("URL", s3url)
				    .detail("Character", std::string(1, c));
				throw backup_invalid_url();
			}
		}

		if (!error.empty()) {
			TraceEvent(SevError, "S3ClientGetEndpointError").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		return endpoint;

	} catch (Error& e) {
		TraceEvent(SevError, "S3ClientGetEndpointFailed").detail("URL", s3url).detail("Error", e.what());
		throw;
	}
}

// Upload a part of a multipart upload with retry logic.
															#line 584 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via uploadPart()
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class UploadPartActor>
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class UploadPartActorState {
															#line 591 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UploadPartActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& uploadID,PartState const& part,std::string const& partData,int const& retryDelayMs) 
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadID(uploadID),
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(part),
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partData(partData),
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   retryDelayMs(retryDelayMs),
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resultPart(part),
															#line 171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   packets()
															#line 616 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("uploadPart", reinterpret_cast<unsigned long>(this));

	}
	~UploadPartActorState() 
	{
		fdb_probe_actor_destroy("uploadPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 172 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientUploadPartStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 631 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			try {
															#line 180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				PacketWriter pw(packets.getWriteBuffer(partData.size()), nullptr, Unversioned());
															#line 181 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				pw.serializeBytes(partData);
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<std::string> __when_expr_0 = endpoint->uploadPart( bucket, objectName, uploadID, resultPart.partNumber, &packets, partData.size(), resultPart.md5);
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UploadPartActor*>(this)->actor_wait_state = 1;
															#line 183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 0, std::string >*>(static_cast<UploadPartActor*>(this)));
															#line 646 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientUploadPartError") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("ErrorCode", e.code());
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::string const& etag,int loopDepth) 
	{
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.etag = etag;
															#line 187 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientUploadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Duration", now() - startTime) .detail("Size", resultPart.size);
															#line 195 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<UploadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~UploadPartActorState(); static_cast<UploadPartActor*>(this)->destroy(); return 0; }
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<UploadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::string && etag,int loopDepth) 
	{
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.etag = etag;
															#line 187 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientUploadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Duration", now() - startTime) .detail("Size", resultPart.size);
															#line 195 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<UploadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~UploadPartActorState(); static_cast<UploadPartActor*>(this)->destroy(); return 0; }
															#line 716 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<UploadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& etag,int loopDepth) 
	{
		loopDepth = a_body1cont2(etag, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && etag,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(etag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string uploadID;
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string partData;
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int retryDelayMs;
															#line 169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 170 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState resultPart;
															#line 171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UnsentPacketQueue packets;
															#line 819 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via uploadPart()
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class UploadPartActor final : public Actor<PartState>, public ActorCallback< UploadPartActor, 0, std::string >, public FastAllocated<UploadPartActor>, public UploadPartActorState<UploadPartActor> {
															#line 824 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<UploadPartActor>::operator new;
	using FastAllocated<UploadPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14699012578820540672UL, 1999799517813311488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<PartState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UploadPartActor, 0, std::string >;
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UploadPartActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& uploadID,PartState const& part,std::string const& partData,int const& retryDelayMs) 
															#line 841 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<PartState>(),
		   UploadPartActorState<UploadPartActor>(endpoint, bucket, objectName, uploadID, part, partData, retryDelayMs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8500122340480301312UL, 500718127134435072UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uploadPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UploadPartActor, 0, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<PartState> uploadPart( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& uploadID, PartState const& part, std::string const& partData, int const& retryDelayMs ) {
															#line 162 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<PartState>(new UploadPartActor(endpoint, bucket, objectName, uploadID, part, partData, retryDelayMs));
															#line 874 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Copy filepath to bucket at resource in s3.
															#line 880 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpFile()
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpFileActor>
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActorState {
															#line 887 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath),
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 212 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(),
															#line 214 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadID(),
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadFutures(),
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   parts(),
															#line 217 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partDatas(),
															#line 218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   size(fileSize(filepath))
															#line 916 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpFileActorState() 
	{
		fdb_probe_actor_destroy("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileStart") .detail("Filepath", filepath) .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size);
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open(filepath, IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED, 0);
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 936 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CopyUpFileActor*>(this)->actor_wait_state = 1;
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 941 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			err = e;
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyUpFileError") .detail("Filepath", filepath) .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("Error", err.what());
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			file = Reference<IAsyncFile>();
															#line 975 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			try {
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<Void> __when_expr_7 = endpoint->abortMultiPartUpload(bucket, objectName, uploadID);
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2Catch1(actor_cancelled(), loopDepth);
															#line 981 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_7.get(), loopDepth); };
				static_cast<CopyUpFileActor*>(this)->actor_wait_state = 8;
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 7, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 986 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = calculateFileChecksum(file, size);
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1011 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 2;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 1, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1016 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = calculateFileChecksum(file, size);
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1029 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 2;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 1, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1034 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont2(f, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = endpoint->beginMultiPartUpload(bucket, objectName);
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1120 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 3;
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 2, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1125 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::string const& __checksum,int loopDepth) 
	{
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		checksum = __checksum;
															#line 1134 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::string && __checksum,int loopDepth) 
	{
		checksum = std::move(__checksum);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(std::string const& id,int loopDepth) 
	{
															#line 241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = id;
															#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 1219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(std::string && id,int loopDepth) 
	{
															#line 241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = id;
															#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 1234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(std::string const& id,int loopDepth) 
	{
		loopDepth = a_body1cont4(id, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(std::string && id,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(id), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 280 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::vector<PartState>> __when_expr_4 = getAll(uploadFutures);
															#line 280 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1320 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 5;
															#line 280 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 4, std::vector<PartState> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(offset < size))
															#line 1341 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partSize = std::min(config.partSizeBytes, size - offset);
															#line 251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partDatas.emplace_back();
															#line 252 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partDatas.back().resize(partSize);
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int> __when_expr_3 = file->read(&partDatas.back()[0], partSize, offset);
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 4;
															#line 254 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 3, int >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != partSize)
															#line 1382 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 256 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCopyUpFileReadError") .detail("Expected", partSize) .detail("Actual", bytesRead) .detail("Offset", offset) .detail("FilePath", filepath);
															#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 1388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 264 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string md5 = HTTP::computeMD5Sum(partDatas.back());
															#line 265 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part = PartState();
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part.partNumber = partNumber;
															#line 267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part.offset = offset;
															#line 268 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part.size = partSize;
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part.md5 = md5;
															#line 270 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.push_back(part);
															#line 272 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadFutures.push_back( uploadPart(endpoint, bucket, objectName, uploadID, part, partDatas.back(), config.retryDelayMs));
															#line 275 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset += partSize;
															#line 276 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber++;
															#line 1410 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 255 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != partSize)
															#line 1419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 256 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCopyUpFileReadError") .detail("Expected", partSize) .detail("Actual", bytesRead) .detail("Offset", offset) .detail("FilePath", filepath);
															#line 261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 1425 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 264 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string md5 = HTTP::computeMD5Sum(partDatas.back());
															#line 265 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part = PartState();
															#line 266 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part.partNumber = partNumber;
															#line 267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part.offset = offset;
															#line 268 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part.size = partSize;
															#line 269 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		part.md5 = md5;
															#line 270 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.push_back(part);
															#line 272 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadFutures.push_back( uploadPart(endpoint, bucket, objectName, uploadID, part, partDatas.back(), config.retryDelayMs));
															#line 275 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset += partSize;
															#line 276 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber++;
															#line 1447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6(std::vector<PartState> const& p,int loopDepth) 
	{
															#line 281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts = p;
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadFutures.clear();
															#line 287 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::map<int, std::string> etagMap;
															#line 291 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 1541 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyUpFilePartNotCompleted") .detail("PartNumber", part.partNumber) .detail("Offset", part.offset) .detail("Size", part.size);
															#line 297 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch2(operation_failed(), loopDepth);
															#line 1547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			etagMap[part.partNumber] = part.etag;
															#line 1551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = endpoint->finishMultiPartUpload(bucket, objectName, uploadID, etagMap);
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1557 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 6;
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 5, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1562 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(std::vector<PartState> && p,int loopDepth) 
	{
															#line 281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts = p;
															#line 284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadFutures.clear();
															#line 287 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 290 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::map<int, std::string> etagMap;
															#line 291 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 1581 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyUpFilePartNotCompleted") .detail("PartNumber", part.partNumber) .detail("Offset", part.offset) .detail("Size", part.size);
															#line 297 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch2(operation_failed(), loopDepth);
															#line 1587 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			etagMap[part.partNumber] = part.etag;
															#line 1591 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = endpoint->finishMultiPartUpload(bucket, objectName, uploadID, etagMap);
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1597 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 6;
															#line 302 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 5, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1602 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<PartState> const& p,int loopDepth) 
	{
		loopDepth = a_body1cont6(p, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(std::vector<PartState> && p,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(p), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 4, std::vector<PartState> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 4, std::vector<PartState> >*,std::vector<PartState> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 4, std::vector<PartState> >*,std::vector<PartState> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 4, std::vector<PartState> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.clear();
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partDatas.clear();
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		tags = std::map<std::string, std::string>();
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		tags[S3_CHECKSUM_TAG_NAME] = checksum;
															#line 315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_6 = endpoint->putObjectTags(bucket, objectName, tags);
															#line 315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 7;
															#line 315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 6, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1701 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.clear();
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partDatas.clear();
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		tags = std::map<std::string, std::string>();
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		tags[S3_CHECKSUM_TAG_NAME] = checksum;
															#line 315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_6 = endpoint->putObjectTags(bucket, objectName, tags);
															#line 315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1720 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 7;
															#line 315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 6, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 1725 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3PerfEventSev(), "S3ClientCopyUpFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size) .detail("Parts", parts.size()) .detail("Checksum", checksum) .detail("Duration", now() - startTime);
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActorState(); static_cast<CopyUpFileActor*>(this)->destroy(); return 0; }
															#line 1811 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3PerfEventSev(), "S3ClientCopyUpFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size) .detail("Parts", parts.size()) .detail("Checksum", checksum) .detail("Duration", now() - startTime);
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActorState(); static_cast<CopyUpFileActor*>(this)->destroy(); return 0; }
															#line 1825 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 1912 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2Catch1(const Error& abortError,int loopDepth=0) 
	{
		try {
															#line 340 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyUpFileAbortError") .error(abortError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("OriginalError", err.what());
															#line 1921 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1Catch2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1Catch2cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1Catch2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 212 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 214 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string uploadID;
															#line 215 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<Future<PartState>> uploadFutures;
															#line 216 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<PartState> parts;
															#line 217 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<std::string> partDatas;
															#line 218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t size;
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string checksum;
															#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t offset;
															#line 244 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int partNumber;
															#line 248 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t partSize;
															#line 265 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 327 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Error err;
															#line 2070 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpFile()
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor final : public Actor<Void>, public ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< CopyUpFileActor, 1, std::string >, public ActorCallback< CopyUpFileActor, 2, std::string >, public ActorCallback< CopyUpFileActor, 3, int >, public ActorCallback< CopyUpFileActor, 4, std::vector<PartState> >, public ActorCallback< CopyUpFileActor, 5, Void >, public ActorCallback< CopyUpFileActor, 6, Void >, public ActorCallback< CopyUpFileActor, 7, Void >, public FastAllocated<CopyUpFileActor>, public CopyUpFileActorState<CopyUpFileActor> {
															#line 2075 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpFileActor>::operator new;
	using FastAllocated<CopyUpFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2969889753279269888UL, 5917432131435729152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< CopyUpFileActor, 1, std::string >;
friend struct ActorCallback< CopyUpFileActor, 2, std::string >;
friend struct ActorCallback< CopyUpFileActor, 3, int >;
friend struct ActorCallback< CopyUpFileActor, 4, std::vector<PartState> >;
friend struct ActorCallback< CopyUpFileActor, 5, Void >;
friend struct ActorCallback< CopyUpFileActor, 6, Void >;
friend struct ActorCallback< CopyUpFileActor, 7, Void >;
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 2099 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpFileActorState<CopyUpFileActor>(endpoint, bucket, objectName, filepath, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5029125091406905600UL, 16817405566823635200UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyUpFileActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyUpFileActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyUpFileActor, 3, int >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyUpFileActor, 4, std::vector<PartState> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CopyUpFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CopyUpFileActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CopyUpFileActor, 7, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> copyUpFile( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& filepath, PartConfig const& config = PartConfig() ) {
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpFileActor(endpoint, bucket, objectName, filepath, config));
															#line 2139 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 2144 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpFile()
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpFileActor1>
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor1State {
															#line 2151 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor1State(std::string const& filepath,std::string const& s3url) 
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : filepath(filepath),
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   s3url(s3url)
															#line 2160 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpFileActor1State() 
	{
		fdb_probe_actor_destroy("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string resource;
															#line 352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 353 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(endpoint, parameters["bucket"], resource, filepath);
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2183 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpFileActor1*>(this)->actor_wait_state = 1;
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor1, 0, Void >*>(static_cast<CopyUpFileActor1*>(this)));
															#line 2188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActor1State(); static_cast<CopyUpFileActor1*>(this)->destroy(); return 0; }
															#line 2211 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActor1State(); static_cast<CopyUpFileActor1*>(this)->destroy(); return 0; }
															#line 2223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpFileActor1*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor1*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor1*>(this)->ActorCallback< CopyUpFileActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 2310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpFile()
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor1 final : public Actor<Void>, public ActorCallback< CopyUpFileActor1, 0, Void >, public FastAllocated<CopyUpFileActor1>, public CopyUpFileActor1State<CopyUpFileActor1> {
															#line 2315 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpFileActor1>::operator new;
	using FastAllocated<CopyUpFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2969889753279269888UL, 5917432131435729152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpFileActor1, 0, Void >;
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor1(std::string const& filepath,std::string const& s3url) 
															#line 2332 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpFileActor1State<CopyUpFileActor1>(filepath, s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(794650894807017472UL, 16661816041386160896UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpFileActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpFile( std::string const& filepath, std::string const& s3url ) {
															#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpFileActor1(filepath, s3url));
															#line 2365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 357 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 2370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpDirectory()
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpDirectoryActor>
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpDirectoryActorState {
															#line 2377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpDirectoryActorState(std::string const& dirpath,std::string const& s3url) 
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : dirpath(dirpath),
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   s3url(s3url),
															#line 359 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 2388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpDirectory", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpDirectoryActorState() 
	{
		fdb_probe_actor_destroy("copyUpDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 363 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			files = std::vector<std::string>();
															#line 364 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::findFilesRecursively(dirpath, files);
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientUploadDirStart") .detail("Filecount", files.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			RangeForbody1Iterator0 = std::begin(files);
															#line 2415 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpDirectoryActorState();
		static_cast<CopyUpDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 374 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientUploadDirEnd").detail("Bucket", bucket).detail("Resource", resource);
															#line 375 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpDirectoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpDirectoryActorState(); static_cast<CopyUpDirectoryActor*>(this)->destroy(); return 0; }
															#line 2440 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpDirectoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpDirectoryActorState();
		static_cast<CopyUpDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(RangeForbody1Iterator0 != std::end(files)))
															#line 2459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		const auto& file = *RangeForbody1Iterator0;
															#line 2465 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string filepath = file;
															#line 371 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string s3path = resource + "/" + file.substr(dirpath.size() + 1);
															#line 372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(endpoint, bucket, s3path, filepath);
															#line 372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state = 1;
															#line 372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpDirectoryActor, 0, Void >*>(static_cast<CopyUpDirectoryActor*>(this)));
															#line 2480 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		++RangeForbody1Iterator0;
															#line 2503 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpDirectoryActor*>(this)->ActorCallback< CopyUpDirectoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string dirpath;
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 359 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 363 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<std::string> files;
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	decltype(std::begin(std::declval<std::vector<std::string>>())) RangeForbody1Iterator0;
															#line 2609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpDirectory()
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpDirectoryActor final : public Actor<Void>, public ActorCallback< CopyUpDirectoryActor, 0, Void >, public FastAllocated<CopyUpDirectoryActor>, public CopyUpDirectoryActorState<CopyUpDirectoryActor> {
															#line 2614 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpDirectoryActor>::operator new;
	using FastAllocated<CopyUpDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(281474810058466560UL, 16017259509498091520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpDirectoryActor, 0, Void >;
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpDirectoryActor(std::string const& dirpath,std::string const& s3url) 
															#line 2631 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpDirectoryActorState<CopyUpDirectoryActor>(dirpath, s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11526468938747652608UL, 2529043041251822336UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpDirectoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpDirectory( std::string const& dirpath, std::string const& s3url ) {
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpDirectoryActor(dirpath, s3url));
															#line 2664 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 2669 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpBulkDumpFileSet()
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpBulkDumpFileSetActor>
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpBulkDumpFileSetActorState {
															#line 2676 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpBulkDumpFileSetActorState(std::string const& s3url,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet) 
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   sourceFileSet(sourceFileSet),
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   destinationFileSet(destinationFileSet),
															#line 381 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 2689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpBulkDumpFileSetActorState() 
	{
		fdb_probe_actor_destroy("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 382 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 383 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 384 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 385 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpBulkDumpFileSetStart") .detail("Bucket", bucket) .detail("SourceFileSet", sourceFileSet.toString()) .detail("DestinationFileSet", destinationFileSet.toString());
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			pNumDeleted = 0;
															#line 390 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			pBytesDeleted = 0;
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			batch_dir = joinPath(getPath(s3url), destinationFileSet.getRelativePath());
															#line 393 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<bool> __when_expr_0 = endpoint->bucketExists(bucket);
															#line 393 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2720 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 1;
															#line 393 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 2725 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpBulkDumpFileSetActorState();
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& exists,int loopDepth) 
	{
															#line 394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (exists)
															#line 2748 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = endpoint->deleteRecursively(bucket, batch_dir, &pNumDeleted, &pBytesDeleted);
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2754 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 2759 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && exists,int loopDepth) 
	{
															#line 394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (exists)
															#line 2773 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = endpoint->deleteRecursively(bucket, batch_dir, &pNumDeleted, &pBytesDeleted);
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2779 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 395 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 2784 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont1(exists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto destinationManifestPath = joinPath(batch_dir, destinationFileSet.getManifestFileName());
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = copyUpFile(endpoint, bucket, destinationManifestPath, sourceFileSet.getManifestFileFullPath());
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2877 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 3;
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 2882 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasDataFile())
															#line 2978 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationDataPath = joinPath(batch_dir, destinationFileSet.getDataFileName());
															#line 402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_3 = copyUpFile(endpoint, bucket, destinationDataPath, sourceFileSet.getDataFileFullPath());
															#line 402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2986 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 4;
															#line 402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 2991 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasDataFile())
															#line 3005 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationDataPath = joinPath(batch_dir, destinationFileSet.getDataFileName());
															#line 402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_3 = copyUpFile(endpoint, bucket, destinationDataPath, sourceFileSet.getDataFileFullPath());
															#line 402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3013 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 4;
															#line 402 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 3018 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 404 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasByteSampleFile())
															#line 3107 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			ASSERT(sourceFileSet.hasDataFile());
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationByteSamplePath = joinPath(batch_dir, destinationFileSet.getByteSampleFileName());
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_4 = copyUpFile(endpoint, bucket, destinationByteSamplePath, sourceFileSet.getBytesSampleFileFullPath());
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3117 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 5;
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 3122 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 409 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpBulkDumpFileSetEnd") .detail("BatchDir", batch_dir) .detail("NumDeleted", pNumDeleted) .detail("BytesDeleted", pBytesDeleted);
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpBulkDumpFileSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpBulkDumpFileSetActorState(); static_cast<CopyUpBulkDumpFileSetActor*>(this)->destroy(); return 0; }
															#line 3225 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpBulkDumpFileSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpBulkDumpFileSetActorState();
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	BulkLoadFileSet sourceFileSet;
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	BulkLoadFileSet destinationFileSet;
															#line 381 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 383 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 384 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int pNumDeleted;
															#line 390 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t pBytesDeleted;
															#line 391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string batch_dir;
															#line 3338 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpBulkDumpFileSet()
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpBulkDumpFileSetActor final : public Actor<Void>, public ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >, public ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >, public FastAllocated<CopyUpBulkDumpFileSetActor>, public CopyUpBulkDumpFileSetActorState<CopyUpBulkDumpFileSetActor> {
															#line 3343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpBulkDumpFileSetActor>::operator new;
	using FastAllocated<CopyUpBulkDumpFileSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15828965591262215424UL, 2454970417351678464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >;
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpBulkDumpFileSetActor(std::string const& s3url,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet) 
															#line 3364 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpBulkDumpFileSetActorState<CopyUpBulkDumpFileSetActor>(s3url, sourceFileSet, destinationFileSet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(469867549170568960UL, 8064918125250259712UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpBulkDumpFileSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpBulkDumpFileSet( std::string const& s3url, BulkLoadFileSet const& sourceFileSet, BulkLoadFileSet const& destinationFileSet ) {
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpBulkDumpFileSetActor(s3url, sourceFileSet, destinationFileSet));
															#line 3401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 415 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 3406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via downloadPartWithRetry()
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class DownloadPartWithRetryActor>
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DownloadPartWithRetryActorState {
															#line 3413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DownloadPartWithRetryActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,Reference<IAsyncFile> const& file,PartState const& part,int const& retryDelayMs) 
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(file),
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(part),
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   retryDelayMs(retryDelayMs),
															#line 422 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   buffer(),
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resultPart(part)
															#line 3434 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("downloadPartWithRetry", reinterpret_cast<unsigned long>(this));

	}
	~DownloadPartWithRetryActorState() 
	{
		fdb_probe_actor_destroy("downloadPartWithRetry", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 426 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevDebug, "S3ClientDownloadPartStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 433 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				buffer.resize(resultPart.size);
															#line 436 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (resultPart.offset < 0 || resultPart.size <= 0)
															#line 3454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 437 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					TraceEvent(SevError, "S3ClientDownloadPartInvalidRange") .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 440 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					return a_body1Catch2(operation_failed(), loopDepth);
															#line 3460 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<int> __when_expr_0 = endpoint->readObject(bucket, objectName, buffer.data(), resultPart.size, resultPart.offset);
															#line 443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state = 1;
															#line 443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DownloadPartWithRetryActor, 0, int >*>(static_cast<DownloadPartWithRetryActor*>(this)));
															#line 3471 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DownloadPartWithRetryActorState();
		static_cast<DownloadPartWithRetryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 477 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientDownloadPartError") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Error", e.what()) .detail("PartNumber", part.partNumber);
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 3503 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int const& bytesRead,int loopDepth) 
	{
															#line 446 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != resultPart.size)
															#line 3517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartSizeMismatch") .detail("Expected", resultPart.size) .detail("Actual", bytesRead) .detail("Offset", resultPart.offset) .detail("FilePath", file->getFilename());
															#line 452 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), loopDepth);
															#line 3523 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 456 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!resultPart.md5.empty())
															#line 3527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string calculatedMD5 = HTTP::computeMD5Sum(std::string((char*)buffer.data(), bytesRead));
															#line 458 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (resultPart.md5 != calculatedMD5)
															#line 3533 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientDownloadPartMD5Mismatch") .detail("Expected", resultPart.md5) .detail("Calculated", calculatedMD5);
															#line 462 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch2(checksum_failed(), loopDepth);
															#line 3539 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->write(buffer.data(), bytesRead, resultPart.offset);
															#line 466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3546 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state = 2;
															#line 466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadPartWithRetryActor, 1, Void >*>(static_cast<DownloadPartWithRetryActor*>(this)));
															#line 3551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int && bytesRead,int loopDepth) 
	{
															#line 446 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != resultPart.size)
															#line 3560 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 447 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartSizeMismatch") .detail("Expected", resultPart.size) .detail("Actual", bytesRead) .detail("Offset", resultPart.offset) .detail("FilePath", file->getFilename());
															#line 452 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), loopDepth);
															#line 3566 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 456 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!resultPart.md5.empty())
															#line 3570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string calculatedMD5 = HTTP::computeMD5Sum(std::string((char*)buffer.data(), bytesRead));
															#line 458 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (resultPart.md5 != calculatedMD5)
															#line 3576 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientDownloadPartMD5Mismatch") .detail("Expected", resultPart.md5) .detail("Calculated", calculatedMD5);
															#line 462 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch2(checksum_failed(), loopDepth);
															#line 3582 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->write(buffer.data(), bytesRead, resultPart.offset);
															#line 466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3589 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state = 2;
															#line 466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadPartWithRetryActor, 1, Void >*>(static_cast<DownloadPartWithRetryActor*>(this)));
															#line 3594 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartWithRetryActor*>(this)->ActorCallback< DownloadPartWithRetryActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartWithRetryActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartWithRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DownloadPartWithRetryActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartWithRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DownloadPartWithRetryActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartWithRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 468 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientDownloadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DownloadPartWithRetryActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~DownloadPartWithRetryActorState(); static_cast<DownloadPartWithRetryActor*>(this)->destroy(); return 0; }
															#line 3682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DownloadPartWithRetryActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~DownloadPartWithRetryActorState();
		static_cast<DownloadPartWithRetryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 468 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientDownloadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DownloadPartWithRetryActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~DownloadPartWithRetryActorState(); static_cast<DownloadPartWithRetryActor*>(this)->destroy(); return 0; }
															#line 3698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DownloadPartWithRetryActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~DownloadPartWithRetryActorState();
		static_cast<DownloadPartWithRetryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartWithRetryActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartWithRetryActor*>(this)->ActorCallback< DownloadPartWithRetryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartWithRetryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartWithRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DownloadPartWithRetryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartWithRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DownloadPartWithRetryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartWithRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int retryDelayMs;
															#line 422 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<uint8_t> buffer;
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState resultPart;
															#line 3797 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via downloadPartWithRetry()
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DownloadPartWithRetryActor final : public Actor<PartState>, public ActorCallback< DownloadPartWithRetryActor, 0, int >, public ActorCallback< DownloadPartWithRetryActor, 1, Void >, public FastAllocated<DownloadPartWithRetryActor>, public DownloadPartWithRetryActorState<DownloadPartWithRetryActor> {
															#line 3802 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<DownloadPartWithRetryActor>::operator new;
	using FastAllocated<DownloadPartWithRetryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8475433936833860608UL, 3854902968248615168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<PartState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DownloadPartWithRetryActor, 0, int >;
friend struct ActorCallback< DownloadPartWithRetryActor, 1, Void >;
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DownloadPartWithRetryActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,Reference<IAsyncFile> const& file,PartState const& part,int const& retryDelayMs) 
															#line 3820 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<PartState>(),
		   DownloadPartWithRetryActorState<DownloadPartWithRetryActor>(endpoint, bucket, objectName, file, part, retryDelayMs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6804872472507090432UL, 12272566931267049472UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartWithRetryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("downloadPartWithRetry");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("downloadPartWithRetry", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DownloadPartWithRetryActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DownloadPartWithRetryActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<PartState> downloadPartWithRetry( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, Reference<IAsyncFile> const& file, PartState const& part, int const& retryDelayMs ) {
															#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<PartState>(new DownloadPartWithRetryActor(endpoint, bucket, objectName, file, part, retryDelayMs));
															#line 3854 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Copy down file from s3 to filepath.
															#line 3860 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownFile()
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownFileActor>
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActorState {
															#line 3867 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath),
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(),
															#line 494 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   downloadFutures(),
															#line 495 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   parts(),
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   fileSize(0),
															#line 497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   offset(0),
															#line 498 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partNumber(1),
															#line 499 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partSize(),
															#line 500 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   tags(),
															#line 501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   expectedChecksum()
															#line 3902 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownFileActorState() 
	{
		fdb_probe_actor_destroy("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 504 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(s3VerboseEventSev(), "S3ClientCopyDownFileStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath);
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<int64_t> __when_expr_0 = endpoint->objectSize(bucket, objectName);
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3922 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CopyDownFileActor*>(this)->actor_wait_state = 1;
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 0, int64_t >*>(static_cast<CopyDownFileActor*>(this)));
															#line 3927 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownFileActorState();
		static_cast<CopyDownFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			err = e;
															#line 599 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileError") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("Error", err.what()) .detail("FilePath", filepath) .detail("FileSize", fileSize);
															#line 607 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (file)
															#line 3961 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
				try {
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					StrictFuture<Void> __when_expr_8 = file->sync();
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2Catch1(actor_cancelled(), loopDepth);
															#line 3968 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_8.get(), loopDepth); };
					static_cast<CopyDownFileActor*>(this)->actor_wait_state = 9;
															#line 609 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 8, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 3973 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1Catch2cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int64_t const& s,int loopDepth) 
	{
															#line 510 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s <= 0)
															#line 3999 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileEmptyFile") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(file_not_found(), loopDepth);
															#line 4005 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fileSize = s;
															#line 519 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string dirPath = filepath.substr(0, filepath.find_last_of("/"));
															#line 520 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!dirPath.empty())
															#line 4013 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::createDirectory(dirPath);
															#line 4017 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		int numParts = (fileSize + config.partSizeBytes - 1) / config.partSizeBytes;
															#line 526 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.reserve(numParts);
															#line 527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		downloadFutures.reserve(numParts);
															#line 528 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED, 0644);
															#line 528 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4029 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 2;
															#line 528 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4034 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(int64_t && s,int loopDepth) 
	{
															#line 510 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s <= 0)
															#line 4043 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileEmptyFile") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(file_not_found(), loopDepth);
															#line 4049 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fileSize = s;
															#line 519 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string dirPath = filepath.substr(0, filepath.find_last_of("/"));
															#line 520 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!dirPath.empty())
															#line 4057 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::createDirectory(dirPath);
															#line 4061 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 525 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		int numParts = (fileSize + config.partSizeBytes - 1) / config.partSizeBytes;
															#line 526 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.reserve(numParts);
															#line 527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		downloadFutures.reserve(numParts);
															#line 528 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED, 0644);
															#line 528 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4073 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 2;
															#line 528 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4078 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& s,int loopDepth) 
	{
		loopDepth = a_body1cont2(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && s,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 530 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(fileSize);
															#line 532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4166 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 3;
															#line 532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 2, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4171 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 530 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(fileSize);
															#line 532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 3;
															#line 532 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 2, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont3(f, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(;offset < fileSize;) {
															#line 535 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partSize = std::min(config.partSizeBytes, fileSize - offset);
															#line 537 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts.emplace_back(partNumber, offset, partSize, "");
															#line 539 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			downloadFutures.push_back( downloadPartWithRetry(endpoint, bucket, objectName, file, parts.back(), config.retryDelayMs));
															#line 542 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			offset += partSize;
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partNumber++;
															#line 4283 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::vector<PartState>> __when_expr_3 = getAll(downloadFutures);
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4289 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 4;
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4294 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 534 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(;offset < fileSize;) {
															#line 535 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partSize = std::min(config.partSizeBytes, fileSize - offset);
															#line 537 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts.emplace_back(partNumber, offset, partSize, "");
															#line 539 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			downloadFutures.push_back( downloadPartWithRetry(endpoint, bucket, objectName, file, parts.back(), config.retryDelayMs));
															#line 542 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			offset += partSize;
															#line 543 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partNumber++;
															#line 4313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::vector<PartState>> __when_expr_3 = getAll(downloadFutures);
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 4;
															#line 545 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4324 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(std::vector<PartState> const& completedParts,int loopDepth) 
	{
															#line 548 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		downloadFutures.clear();
															#line 551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : completedParts ) {
															#line 552 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 4412 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 553 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevError, "S3ClientCopyDownFilePartNotCompleted").detail("PartNumber", part.partNumber);
															#line 554 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch2(operation_failed(), loopDepth);
															#line 4418 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 559 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_4 = file->truncate(fileSize);
															#line 559 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4425 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 5;
															#line 559 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 4, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4430 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(std::vector<PartState> && completedParts,int loopDepth) 
	{
															#line 548 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		downloadFutures.clear();
															#line 551 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : completedParts ) {
															#line 552 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 4443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 553 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevError, "S3ClientCopyDownFilePartNotCompleted").detail("PartNumber", part.partNumber);
															#line 554 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch2(operation_failed(), loopDepth);
															#line 4449 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 559 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_4 = file->truncate(fileSize);
															#line 559 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4456 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 5;
															#line 559 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 4, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(std::vector<PartState> const& completedParts,int loopDepth) 
	{
		loopDepth = a_body1cont7(completedParts, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(std::vector<PartState> && completedParts,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(completedParts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >*,std::vector<PartState> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >*,std::vector<PartState> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = file->sync();
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 6;
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 5, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4552 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = file->sync();
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4563 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont9when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 6;
															#line 561 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 5, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::map<std::string, std::string>> __when_expr_6 = endpoint->getObjectTags(bucket, objectName);
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont12when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 7;
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::map<std::string, std::string>> __when_expr_6 = endpoint->getObjectTags(bucket, objectName);
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4670 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont12when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 7;
															#line 564 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4675 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont1(std::map<std::string, std::string> const& t,int loopDepth) 
	{
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		tags = t;
															#line 566 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto it = tags.find(S3_CHECKSUM_TAG_NAME);
															#line 567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (it != tags.end())
															#line 4763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			expectedChecksum = it->second;
															#line 569 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!expectedChecksum.empty())
															#line 4769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<std::string> __when_expr_7 = calculateFileChecksum(file);
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4775 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_7.get(), loopDepth); };
				static_cast<CopyDownFileActor*>(this)->actor_wait_state = 8;
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 7, std::string >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4780 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont12cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1(std::map<std::string, std::string> && t,int loopDepth) 
	{
															#line 565 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		tags = t;
															#line 566 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto it = tags.find(S3_CHECKSUM_TAG_NAME);
															#line 567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (it != tags.end())
															#line 4803 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 568 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			expectedChecksum = it->second;
															#line 569 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!expectedChecksum.empty())
															#line 4809 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<std::string> __when_expr_7 = calculateFileChecksum(file);
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4815 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_7.get(), loopDepth); };
				static_cast<CopyDownFileActor*>(this)->actor_wait_state = 8;
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 7, std::string >*>(static_cast<CopyDownFileActor*>(this)));
															#line 4820 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont12cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12when1(std::map<std::string, std::string> const& t,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(std::map<std::string, std::string> && t,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >*,std::map<std::string, std::string> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >*,std::map<std::string, std::string> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 586 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 588 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyDownFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", fileSize) .detail("Duration", now() - startTime) .detail("Checksum", expectedChecksum) .detail("Parts", parts.size());
															#line 596 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActorState(); static_cast<CopyDownFileActor*>(this)->destroy(); return 0; }
															#line 4918 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActorState();
		static_cast<CopyDownFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont3(int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont4(int loopDepth) 
	{
															#line 571 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (actualChecksum != expectedChecksum)
															#line 4936 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 572 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCopyDownFileChecksumMismatch") .detail("Expected", expectedChecksum) .detail("Calculated", actualChecksum) .detail("FileSize", fileSize) .detail("FilePath", filepath);
															#line 580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(checksum_failed(), loopDepth);
															#line 4942 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		loopDepth = a_body1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(std::string const& __actualChecksum,int loopDepth) 
	{
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		actualChecksum = __actualChecksum;
															#line 4952 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(std::string && __actualChecksum,int loopDepth) 
	{
		actualChecksum = std::move(__actualChecksum);
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 7, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 7, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 7, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 7, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1Catch2cont1(int loopDepth) 
	{
															#line 618 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 5031 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2cont2(int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 613 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileCleanupError") .detail("FilePath", filepath) .detail("Error", e.what());
															#line 5046 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1Catch2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont3(Void const& _,int loopDepth) 
	{
															#line 610 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 611 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		IAsyncFileSystem::filesystem()->deleteFile(filepath, false);
															#line 5063 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1Catch2cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont3(Void && _,int loopDepth) 
	{
															#line 610 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 611 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		IAsyncFileSystem::filesystem()->deleteFile(filepath, false);
															#line 5074 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1Catch2cont5(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2Catch1(error, 0);
		} catch (...) {
			a_body1Catch2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1Catch2cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1Catch2cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 492 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 493 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 494 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<Future<PartState>> downloadFutures;
															#line 495 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<PartState> parts;
															#line 496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t fileSize;
															#line 497 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t offset;
															#line 498 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int partNumber;
															#line 499 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t partSize;
															#line 500 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string expectedChecksum;
															#line 570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string actualChecksum;
															#line 598 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Error err;
															#line 5201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownFile()
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor final : public Actor<Void>, public ActorCallback< CopyDownFileActor, 0, int64_t >, public ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< CopyDownFileActor, 2, Void >, public ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >, public ActorCallback< CopyDownFileActor, 4, Void >, public ActorCallback< CopyDownFileActor, 5, Void >, public ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >, public ActorCallback< CopyDownFileActor, 7, std::string >, public ActorCallback< CopyDownFileActor, 8, Void >, public FastAllocated<CopyDownFileActor>, public CopyDownFileActorState<CopyDownFileActor> {
															#line 5206 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownFileActor>::operator new;
	using FastAllocated<CopyDownFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13798614002670767360UL, 17944604262940443392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownFileActor, 0, int64_t >;
friend struct ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< CopyDownFileActor, 2, Void >;
friend struct ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >;
friend struct ActorCallback< CopyDownFileActor, 4, Void >;
friend struct ActorCallback< CopyDownFileActor, 5, Void >;
friend struct ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >;
friend struct ActorCallback< CopyDownFileActor, 7, std::string >;
friend struct ActorCallback< CopyDownFileActor, 8, Void >;
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 5231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownFileActorState<CopyDownFileActor>(endpoint, bucket, objectName, filepath, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7359276511881238784UL, 3382961653916387328UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownFileActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyDownFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyDownFileActor, 3, std::vector<PartState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyDownFileActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CopyDownFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CopyDownFileActor, 6, std::map<std::string, std::string> >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CopyDownFileActor, 7, std::string >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CopyDownFileActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> copyDownFile( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& filepath, PartConfig const& config = PartConfig() ) {
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownFileActor(endpoint, bucket, objectName, filepath, config));
															#line 5272 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 621 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5277 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownFile()
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownFileActor1>
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor1State {
															#line 5284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor1State(std::string const& s3url,std::string const& filepath) 
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath)
															#line 5293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownFileActor1State() 
	{
		fdb_probe_actor_destroy("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 623 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string resource;
															#line 624 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 625 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyDownFile(endpoint, parameters["bucket"], resource, filepath);
															#line 626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownFileActor1*>(this)->actor_wait_state = 1;
															#line 626 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor1, 0, Void >*>(static_cast<CopyDownFileActor1*>(this)));
															#line 5321 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActor1State(); static_cast<CopyDownFileActor1*>(this)->destroy(); return 0; }
															#line 5344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 627 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActor1State(); static_cast<CopyDownFileActor1*>(this)->destroy(); return 0; }
															#line 5356 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownFileActor1*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor1*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor1*>(this)->ActorCallback< CopyDownFileActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 5443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownFile()
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor1 final : public Actor<Void>, public ActorCallback< CopyDownFileActor1, 0, Void >, public FastAllocated<CopyDownFileActor1>, public CopyDownFileActor1State<CopyDownFileActor1> {
															#line 5448 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownFileActor1>::operator new;
	using FastAllocated<CopyDownFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13798614002670767360UL, 17944604262940443392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownFileActor1, 0, Void >;
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor1(std::string const& s3url,std::string const& filepath) 
															#line 5465 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownFileActor1State<CopyDownFileActor1>(s3url, filepath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17010639406587595520UL, 2888716185831900672UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownFileActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyDownFile( std::string const& s3url, std::string const& filepath ) {
															#line 622 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownFileActor1(s3url, filepath));
															#line 5498 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 629 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5503 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownDirectory()
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownDirectoryActor>
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownDirectoryActorState {
															#line 5510 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownDirectoryActorState(std::string const& s3url,std::string const& dirpath) 
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   dirpath(dirpath),
															#line 631 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 5521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownDirectory", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownDirectoryActorState() 
	{
		fdb_probe_actor_destroy("copyDownDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 633 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_0 = endpoint->listObjects(bucket, resource);
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5544 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 1;
															#line 635 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*>(static_cast<CopyDownDirectoryActor*>(this)));
															#line 5549 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownDirectoryActorState();
		static_cast<CopyDownDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(S3BlobStoreEndpoint::ListResult const& items,int loopDepth) 
	{
															#line 636 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		objects = items.objects;
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryStart") .detail("Filecount", objects.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(objects);
															#line 5576 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(S3BlobStoreEndpoint::ListResult && items,int loopDepth) 
	{
															#line 636 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		objects = items.objects;
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryStart") .detail("Filecount", objects.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(objects);
															#line 5589 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(S3BlobStoreEndpoint::ListResult const& items,int loopDepth) 
	{
		loopDepth = a_body1cont1(items, loopDepth);

		return loopDepth;
	}
	int a_body1when1(S3BlobStoreEndpoint::ListResult && items,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(items), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownDirectoryActor*>(this)->ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult const& value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult && value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 646 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryEnd").detail("Bucket", bucket).detail("Resource", resource);
															#line 647 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownDirectoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownDirectoryActorState(); static_cast<CopyDownDirectoryActor*>(this)->destroy(); return 0; }
															#line 5675 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownDirectoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownDirectoryActorState();
		static_cast<CopyDownDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(objects)))
															#line 5694 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		const auto& object = *RangeForbody1cont1Iterator0;
															#line 5700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 642 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string filepath = dirpath + "/" + object.name.substr(resource.size());
															#line 643 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string s3path = object.name;
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyDownFile(endpoint, bucket, s3path, filepath);
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5710 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 2;
															#line 644 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownDirectoryActor, 1, Void >*>(static_cast<CopyDownDirectoryActor*>(this)));
															#line 5715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 5738 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownDirectoryActor*>(this)->ActorCallback< CopyDownDirectoryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string dirpath;
															#line 631 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 633 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 634 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 636 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<S3BlobStoreEndpoint::ObjectInfo> objects;
															#line 641 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	decltype(std::begin(std::declval<std::vector<S3BlobStoreEndpoint::ObjectInfo>>())) RangeForbody1cont1Iterator0;
															#line 5844 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownDirectory()
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownDirectoryActor final : public Actor<Void>, public ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >, public ActorCallback< CopyDownDirectoryActor, 1, Void >, public FastAllocated<CopyDownDirectoryActor>, public CopyDownDirectoryActorState<CopyDownDirectoryActor> {
															#line 5849 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownDirectoryActor>::operator new;
	using FastAllocated<CopyDownDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(653284036168007680UL, 5659443786549780992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >;
friend struct ActorCallback< CopyDownDirectoryActor, 1, Void >;
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownDirectoryActor(std::string const& s3url,std::string const& dirpath) 
															#line 5867 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownDirectoryActorState<CopyDownDirectoryActor>(s3url, dirpath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10236592472061799424UL, 16660351427764155904UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyDownDirectoryActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyDownDirectory( std::string const& s3url, std::string const& dirpath ) {
															#line 630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownDirectoryActor(s3url, dirpath));
															#line 5901 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 649 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5906 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteResource()
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class DeleteResourceActor>
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DeleteResourceActorState {
															#line 5913 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DeleteResourceActorState(std::string const& s3url) 
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 651 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 5922 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteResource", reinterpret_cast<unsigned long>(this));

	}
	~DeleteResourceActorState() 
	{
		fdb_probe_actor_destroy("deleteResource", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 653 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = endpoint->deleteRecursively(bucket, resource);
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<DeleteResourceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteResourceActor*>(this)->actor_wait_state = 1;
															#line 655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteResourceActor, 0, Void >*>(static_cast<DeleteResourceActor*>(this)));
															#line 5950 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DeleteResourceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteResourceActorState(); static_cast<DeleteResourceActor*>(this)->destroy(); return 0; }
															#line 5973 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DeleteResourceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 656 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DeleteResourceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteResourceActorState(); static_cast<DeleteResourceActor*>(this)->destroy(); return 0; }
															#line 5985 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DeleteResourceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteResourceActor*>(this)->actor_wait_state > 0) static_cast<DeleteResourceActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteResourceActor*>(this)->ActorCallback< DeleteResourceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteResourceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteResourceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteResourceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 651 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 654 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 6074 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via deleteResource()
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DeleteResourceActor final : public Actor<Void>, public ActorCallback< DeleteResourceActor, 0, Void >, public FastAllocated<DeleteResourceActor>, public DeleteResourceActorState<DeleteResourceActor> {
															#line 6079 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<DeleteResourceActor>::operator new;
	using FastAllocated<DeleteResourceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16623430336612763904UL, 13022312959862636800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteResourceActor, 0, Void >;
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DeleteResourceActor(std::string const& s3url) 
															#line 6096 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteResourceActorState<DeleteResourceActor>(s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14827851668417892864UL, 17501710632754782464UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteResource");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteResourceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> deleteResource( std::string const& s3url ) {
															#line 650 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new DeleteResourceActor(s3url));
															#line 6129 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 658 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 6134 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via listFiles()
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ListFilesActor>
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFilesActorState {
															#line 6141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFilesActorState(std::string const& s3url,int const& maxDepth) 
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxDepth(maxDepth)
															#line 6150 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("listFiles", reinterpret_cast<unsigned long>(this));

	}
	~ListFilesActorState() 
	{
		fdb_probe_actor_destroy("listFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				resource = std::string();
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				error = std::string();
															#line 663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				parameters = S3BlobStoreEndpoint::ParametersT();
															#line 664 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				bstore = getEndpoint(s3url, resource, parameters);
															#line 666 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!bstore)
															#line 6174 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 667 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					TraceEvent(SevError, "S3ClientListingFailed").detail("Error", error);
															#line 668 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					return a_body1Catch2(backup_invalid_url(), loopDepth);
															#line 6180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				bucket = parameters["bucket"];
															#line 675 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<bool> __when_expr_0 = bstore->bucketExists(bucket);
															#line 675 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6188 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListFilesActor*>(this)->actor_wait_state = 1;
															#line 675 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 0, bool >*>(static_cast<ListFilesActor*>(this)));
															#line 6193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListFilesActorState();
		static_cast<ListFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 760 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ListFilesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListFilesActorState(); static_cast<ListFilesActor*>(this)->destroy(); return 0; }
															#line 6222 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ListFilesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListFilesActorState();
		static_cast<ListFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 738 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientListFilesError").detail("URL", s3url).detail("Error", e.what());
															#line 739 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() == error_code_backup_invalid_url)
															#line 6237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 740 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				std::cerr << "ERROR: Invalid blobstore URL: " << s3url << std::endl;
															#line 6241 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
			else
			{
															#line 741 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (e.code() == error_code_backup_auth_missing)
															#line 6247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 742 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::cerr << "ERROR: Authentication information missing from URL" << std::endl;
															#line 6251 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
				else
				{
															#line 743 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (e.code() == error_code_backup_auth_unreadable)
															#line 6257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 744 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						std::cerr << "ERROR: Could not read authentication information" << std::endl;
															#line 6261 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
					else
					{
															#line 745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (e.code() == error_code_http_request_failed)
															#line 6267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						{
															#line 747 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
							if (e.what() && strstr(e.what(), "NoSuchBucket") != nullptr)
															#line 6271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
							{
															#line 748 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
								std::cerr << "ERROR: Bucket does not exist" << std::endl;
															#line 6275 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
							}
							else
							{
															#line 749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
								if (e.what() && strstr(e.what(), "NoSuchKey") != nullptr)
															#line 6281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								{
															#line 750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									std::cerr << "ERROR: Resource does not exist in bucket" << std::endl;
															#line 751 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									return a_body1Catch1(resource_not_found(), loopDepth);
															#line 6287 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								}
								else
								{
															#line 753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									std::cerr << "ERROR: HTTP request to blobstore failed" << std::endl;
															#line 6293 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								}
							}
						}
						else
						{
															#line 756 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
							std::cerr << "ERROR: " << e.what() << std::endl;
															#line 6301 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						}
					}
				}
			}
															#line 758 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6308 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool const& exists,int loopDepth) 
	{
															#line 676 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!exists)
															#line 6322 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cerr << "ERROR: Bucket '" << bucket << "' does not exist" << std::endl;
															#line 678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(http_request_failed(), loopDepth);
															#line 6328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delimiter = Optional<char>();
															#line 683 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (maxDepth <= 1)
															#line 6334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			delimiter = Optional<char>('/');
															#line 6338 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_1 = bstore->listObjects(bucket, resource, delimiter, maxDepth > 1);
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFilesActor*>(this)->actor_wait_state = 2;
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*>(static_cast<ListFilesActor*>(this)));
															#line 6349 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(bool && exists,int loopDepth) 
	{
															#line 676 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!exists)
															#line 6358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cerr << "ERROR: Bucket '" << bucket << "' does not exist" << std::endl;
															#line 678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(http_request_failed(), loopDepth);
															#line 6364 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delimiter = Optional<char>();
															#line 683 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (maxDepth <= 1)
															#line 6370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 684 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			delimiter = Optional<char>('/');
															#line 6374 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_1 = bstore->listObjects(bucket, resource, delimiter, maxDepth > 1);
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6380 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFilesActor*>(this)->actor_wait_state = 2;
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*>(static_cast<ListFilesActor*>(this)));
															#line 6385 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont2(exists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListFilesActor*>(this)->actor_wait_state > 0) static_cast<ListFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListFilesActor*>(this)->ActorCallback< ListFilesActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListFilesActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 692 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::cout << "Contents of " << s3url << ":" << std::endl;
															#line 695 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::set<std::string> directories;
															#line 698 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto formatSize = [](int64_t size) -> std::string { const char* units[] = { "B", "KB", "MB", "GB", "TB", "PB" }; int unit = 0; double value = static_cast<double>(size); while (value >= 1024.0 && unit < 5) { value /= 1024.0; unit++; } char buffer[32]; snprintf(buffer, sizeof(buffer), "%.2f %s", value, units[unit]); return std::string(buffer); };
															#line 712 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& prefix : result.commonPrefixes ) {
															#line 713 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string dirName = prefix;
															#line 715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!dirName.empty() && dirName.back() == '/')
															#line 6479 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 716 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				dirName.pop_back();
															#line 6483 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 718 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			directories.insert(dirName);
															#line 719 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cout << "  " << dirName << "/" << std::endl;
															#line 6489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 723 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& object : result.objects ) {
															#line 724 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string objectName = object.name;
															#line 726 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bool skip = false;
															#line 727 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for( const auto& dir : directories ) {
															#line 728 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (objectName.find(dir + "/") == 0)
															#line 6501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 729 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					skip = true;
															#line 6505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					break;
				}
			}
															#line 733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!skip)
															#line 6511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 734 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				std::cout << " " << objectName << " " << formatSize(object.size) << std::endl;
															#line 6515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(S3BlobStoreEndpoint::ListResult const& __result,int loopDepth) 
	{
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		result = __result;
															#line 6526 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(S3BlobStoreEndpoint::ListResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListFilesActor*>(this)->actor_wait_state > 0) static_cast<ListFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListFilesActor*>(this)->ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >::remove();

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult const& value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult && value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxDepth;
															#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 662 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string error;
															#line 663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	S3BlobStoreEndpoint::ParametersT parameters;
															#line 664 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> bstore;
															#line 672 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Optional<char> delimiter;
															#line 688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	S3BlobStoreEndpoint::ListResult result;
															#line 6632 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via listFiles()
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFilesActor final : public Actor<Void>, public ActorCallback< ListFilesActor, 0, bool >, public ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >, public FastAllocated<ListFilesActor>, public ListFilesActorState<ListFilesActor> {
															#line 6637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<ListFilesActor>::operator new;
	using FastAllocated<ListFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9618189297693198080UL, 4620243372806453760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListFilesActor, 0, bool >;
friend struct ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >;
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFilesActor(std::string const& s3url,int const& maxDepth) 
															#line 6655 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   ListFilesActorState<ListFilesActor>(s3url, maxDepth),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7548829570599198464UL, 17955669203805414144UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListFilesActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> listFiles( std::string const& s3url, int const& maxDepth ) {
															#line 659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new ListFilesActor(s3url, maxDepth));
															#line 6689 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 762 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 6694 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via listFiles_impl()
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ListFiles_implActor>
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFiles_implActorState {
															#line 6701 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFiles_implActorState(Reference<S3BlobStoreEndpoint> const& bstore,std::string const& bucket,std::string const& path) 
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : bstore(bstore),
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   path(path)
															#line 6712 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("listFiles_impl", reinterpret_cast<unsigned long>(this));

	}
	~ListFiles_implActorState() 
	{
		fdb_probe_actor_destroy("listFiles_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = bstore->requestRateRead->getAllowance(1);
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6729 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListFiles_implActor*>(this)->actor_wait_state = 1;
															#line 766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 0, Void >*>(static_cast<ListFiles_implActor*>(this)));
															#line 6734 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListFiles_implActorState();
		static_cast<ListFiles_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 768 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resource = bstore->constructResourcePath(bucket, path);
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		headers = HTTP::Headers();
															#line 770 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fullResource = resource + "?list-type=2&prefix=" + path;
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = bstore->doRequest("GET", fullResource, headers, nullptr, 0, { 200, 404 });
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6765 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFiles_implActor*>(this)->actor_wait_state = 2;
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<ListFiles_implActor*>(this)));
															#line 6770 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 768 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resource = bstore->constructResourcePath(bucket, path);
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		headers = HTTP::Headers();
															#line 770 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fullResource = resource + "?list-type=2&prefix=" + path;
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = bstore->doRequest("GET", fullResource, headers, nullptr, 0, { 200, 404 });
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6787 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFiles_implActor*>(this)->actor_wait_state = 2;
															#line 772 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<ListFiles_implActor*>(this)));
															#line 6792 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state > 0) static_cast<ListFiles_implActor*>(this)->actor_wait_state = 0;
		static_cast<ListFiles_implActor*>(this)->ActorCallback< ListFiles_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListFiles_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Reference<HTTP::IncomingResponse> const& r,int loopDepth) 
	{
															#line 775 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (r->code == 404)
															#line 6876 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 776 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesNotFound").detail("Bucket", bucket).detail("Path", path);
															#line 777 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 6882 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		try {
															#line 781 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_document<> doc;
															#line 782 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string content = r->data.content;
															#line 783 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			doc.parse<0>((char*)content.c_str());
															#line 785 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* result = doc.first_node();
															#line 786 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (result == nullptr || strcmp(result->name(), "ListBucketResult") != 0)
															#line 6895 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 787 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientListFilesInvalidResponse") .detail("NodeName", result ? result->name() : "null");
															#line 789 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 6901 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 792 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::vector<std::string> files;
															#line 793 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* n = result->first_node();
															#line 794 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for(;n != nullptr;) {
															#line 795 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				const char* name = n->name();
															#line 796 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (strcmp(name, "Contents") == 0)
															#line 6913 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 797 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					rapidxml::xml_node<>* key = n->first_node("Key");
															#line 798 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (key == nullptr)
															#line 6919 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						TraceEvent(SevWarn, "S3ClientListFilesMissingKey").detail("NodeName", name);
															#line 800 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 6925 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 802 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::string file = key->value();
															#line 803 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (file.size() > path.size() && file.substr(0, path.size()) == path)
															#line 6931 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						file = file.substr(path.size());
															#line 6935 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 806 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					files.push_back(file);
															#line 6939 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 808 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				n = n->next_sibling();
															#line 6943 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 811 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ListFiles_implActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(files); this->~ListFiles_implActorState(); static_cast<ListFiles_implActor*>(this)->destroy(); return 0; }
															#line 6947 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			new (&static_cast<ListFiles_implActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(files);
			this->~ListFiles_implActorState();
			static_cast<ListFiles_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<HTTP::IncomingResponse> && r,int loopDepth) 
	{
															#line 775 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (r->code == 404)
															#line 6965 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 776 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesNotFound").detail("Bucket", bucket).detail("Path", path);
															#line 777 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 6971 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		try {
															#line 781 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_document<> doc;
															#line 782 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string content = r->data.content;
															#line 783 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			doc.parse<0>((char*)content.c_str());
															#line 785 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* result = doc.first_node();
															#line 786 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (result == nullptr || strcmp(result->name(), "ListBucketResult") != 0)
															#line 6984 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 787 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientListFilesInvalidResponse") .detail("NodeName", result ? result->name() : "null");
															#line 789 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 6990 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 792 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::vector<std::string> files;
															#line 793 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* n = result->first_node();
															#line 794 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for(;n != nullptr;) {
															#line 795 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				const char* name = n->name();
															#line 796 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (strcmp(name, "Contents") == 0)
															#line 7002 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 797 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					rapidxml::xml_node<>* key = n->first_node("Key");
															#line 798 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (key == nullptr)
															#line 7008 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 799 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						TraceEvent(SevWarn, "S3ClientListFilesMissingKey").detail("NodeName", name);
															#line 800 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 7014 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 802 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::string file = key->value();
															#line 803 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (file.size() > path.size() && file.substr(0, path.size()) == path)
															#line 7020 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 804 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						file = file.substr(path.size());
															#line 7024 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 806 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					files.push_back(file);
															#line 7028 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 808 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				n = n->next_sibling();
															#line 7032 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 811 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ListFiles_implActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(files); this->~ListFiles_implActorState(); static_cast<ListFiles_implActor*>(this)->destroy(); return 0; }
															#line 7036 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			new (&static_cast<ListFiles_implActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(files);
			this->~ListFiles_implActorState();
			static_cast<ListFiles_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Reference<HTTP::IncomingResponse> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont2(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<HTTP::IncomingResponse> && r,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state > 0) static_cast<ListFiles_implActor*>(this)->actor_wait_state = 0;
		static_cast<ListFiles_implActor*>(this)->ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 813 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesError").error(e).detail("Bucket", bucket).detail("Path", path);
															#line 814 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 7132 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> bstore;
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string path;
															#line 768 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	HTTP::Headers headers;
															#line 770 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string fullResource;
															#line 7154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via listFiles_impl()
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFiles_implActor final : public Actor<std::vector<std::string>>, public ActorCallback< ListFiles_implActor, 0, Void >, public ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >, public FastAllocated<ListFiles_implActor>, public ListFiles_implActorState<ListFiles_implActor> {
															#line 7159 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<ListFiles_implActor>::operator new;
	using FastAllocated<ListFiles_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2470634655405312UL, 16144764242979777536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListFiles_implActor, 0, Void >;
friend struct ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >;
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFiles_implActor(Reference<S3BlobStoreEndpoint> const& bstore,std::string const& bucket,std::string const& path) 
															#line 7177 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<std::vector<std::string>>(),
		   ListFiles_implActorState<ListFiles_implActor>(bstore, bucket, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14489544770152881408UL, 3479841887926592000UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listFiles_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListFiles_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<std::vector<std::string>> listFiles_impl( Reference<S3BlobStoreEndpoint> const& bstore, std::string const& bucket, std::string const& path ) {
															#line 763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<std::vector<std::string>>(new ListFiles_implActor(bstore, bucket, path));
															#line 7211 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 817 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
