#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
/*
* tutorial.actor.cpp

*
* This source file is part of the FoundationDB open source project
*
* Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "fmt/format.h"
#include "flow/flow.h"
#include "flow/Platform.h"
#include "flow/DeterministicRandom.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/TLSConfig.actor.h"
#include <functional>
#include <unordered_map>
#include <memory>
#include <iostream>
#include "flow/actorcompiler.h"

NetworkAddress serverAddress;

enum TutorialWellKnownEndpoints {
	WLTOKEN_SIMPLE_KV_SERVER = WLTOKEN_FIRST_AVAILABLE,
	WLTOKEN_ECHO_SERVER,
	WLTOKEN_COUNT_IN_TUTORIAL
};

// this is a simple actor that will report how long
// it is already running once a second.
															#line 47 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via simpleTimer()
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class SimpleTimerActor>
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class SimpleTimerActorState {
															#line 54 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleTimerActorState() 
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 54 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : start_time(g_network->now())
															#line 61 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("simpleTimer", reinterpret_cast<unsigned long>(this));

	}
	~SimpleTimerActorState() 
	{
		fdb_probe_actor_destroy("simpleTimer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 55 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 76 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SimpleTimerActorState();
		static_cast<SimpleTimerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<SimpleTimerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 108 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SimpleTimerActor*>(this)->actor_wait_state = 1;
															#line 56 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SimpleTimerActor, 0, Void >*>(static_cast<SimpleTimerActor*>(this)));
															#line 113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Time: %.2f\n", g_network->now() - start_time);
															#line 122 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Time: %.2f\n", g_network->now() - start_time);
															#line 131 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SimpleTimerActor*>(this)->actor_wait_state > 0) static_cast<SimpleTimerActor*>(this)->actor_wait_state = 0;
		static_cast<SimpleTimerActor*>(this)->ActorCallback< SimpleTimerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SimpleTimerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("simpleTimer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTimerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTimer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SimpleTimerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("simpleTimer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTimerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTimer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SimpleTimerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("simpleTimer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTimerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("simpleTimer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 54 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	double start_time;
															#line 213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via simpleTimer()
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class SimpleTimerActor final : public Actor<Void>, public ActorCallback< SimpleTimerActor, 0, Void >, public FastAllocated<SimpleTimerActor>, public SimpleTimerActorState<SimpleTimerActor> {
															#line 218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<SimpleTimerActor>::operator new;
	using FastAllocated<SimpleTimerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1412740912020478464UL, 15850986857801045248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SimpleTimerActor, 0, Void >;
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleTimerActor() 
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   SimpleTimerActorState<SimpleTimerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("simpleTimer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4019984202861845248UL, 8014861850264975872UL);
		ActorExecutionContextHelper __helper(static_cast<SimpleTimerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("simpleTimer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("simpleTimer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SimpleTimerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> simpleTimer(  ) {
															#line 45 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new SimpleTimerActor());
															#line 268 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 60 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

// A actor that demonstrates how choose-when blocks work.
															#line 274 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via someFuture()
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class SomeFutureActor>
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class SomeFutureActorState {
															#line 281 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SomeFutureActorState(Future<int> const& ready) 
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : ready(ready)
															#line 288 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("someFuture", reinterpret_cast<unsigned long>(this));

	}
	~SomeFutureActorState() 
	{
		fdb_probe_actor_destroy("someFuture", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 64 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 303 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SomeFutureActorState();
		static_cast<SomeFutureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 65 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.5);
															#line 64 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 335 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 68 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<int> __when_expr_1 = ready;
															#line 339 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<SomeFutureActor*>(this)->actor_wait_state = 1;
															#line 65 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SomeFutureActor, 0, Void >*>(static_cast<SomeFutureActor*>(this)));
															#line 68 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SomeFutureActor, 1, int >*>(static_cast<SomeFutureActor*>(this)));
															#line 346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 66 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Still waiting...\n";
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 66 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Still waiting...\n";
															#line 370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(int const& r,int loopDepth) 
	{
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Ready %d\n", r);
															#line 70 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(double(r));
															#line 70 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 383 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SomeFutureActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SomeFutureActor, 2, Void >*>(static_cast<SomeFutureActor*>(this)));
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(int && r,int loopDepth) 
	{
															#line 69 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Ready %d\n", r);
															#line 70 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(double(r));
															#line 70 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<SomeFutureActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SomeFutureActor, 2, Void >*>(static_cast<SomeFutureActor*>(this)));
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state > 0) static_cast<SomeFutureActor*>(this)->actor_wait_state = 0;
		static_cast<SomeFutureActor*>(this)->ActorCallback< SomeFutureActor, 0, Void >::remove();
		static_cast<SomeFutureActor*>(this)->ActorCallback< SomeFutureActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SomeFutureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(Void const& _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Done\n";
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<SomeFutureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SomeFutureActorState(); static_cast<SomeFutureActor*>(this)->destroy(); return 0; }
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<SomeFutureActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SomeFutureActorState();
		static_cast<SomeFutureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(Void && _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Done\n";
															#line 72 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<SomeFutureActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SomeFutureActorState(); static_cast<SomeFutureActor*>(this)->destroy(); return 0; }
															#line 495 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<SomeFutureActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SomeFutureActorState();
		static_cast<SomeFutureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SomeFutureActor*>(this)->actor_wait_state > 0) static_cast<SomeFutureActor*>(this)->actor_wait_state = 0;
		static_cast<SomeFutureActor*>(this)->ActorCallback< SomeFutureActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SomeFutureActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SomeFutureActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SomeFutureActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<int> ready;
															#line 637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via someFuture()
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class SomeFutureActor final : public Actor<Void>, public ActorCallback< SomeFutureActor, 0, Void >, public ActorCallback< SomeFutureActor, 1, int >, public ActorCallback< SomeFutureActor, 2, Void >, public FastAllocated<SomeFutureActor>, public SomeFutureActorState<SomeFutureActor> {
															#line 642 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<SomeFutureActor>::operator new;
	using FastAllocated<SomeFutureActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9150981279325976064UL, 3087763526117388288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SomeFutureActor, 0, Void >;
friend struct ActorCallback< SomeFutureActor, 1, int >;
friend struct ActorCallback< SomeFutureActor, 2, Void >;
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SomeFutureActor(Future<int> const& ready) 
															#line 661 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   SomeFutureActorState<SomeFutureActor>(ready),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("someFuture", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14912416791482710528UL, 18035307320785303296UL);
		ActorExecutionContextHelper __helper(static_cast<SomeFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("someFuture");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("someFuture", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SomeFutureActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SomeFutureActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> someFuture( Future<int> const& ready ) {
															#line 62 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new SomeFutureActor(ready));
															#line 695 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 76 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via promiseDemo()
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class PromiseDemoActor>
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class PromiseDemoActorState {
															#line 707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	PromiseDemoActorState() 
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 78 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : promise(),
															#line 79 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   f(someFuture(promise.getFuture()))
															#line 716 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("promiseDemo", reinterpret_cast<unsigned long>(this));

	}
	~PromiseDemoActorState() 
	{
		fdb_probe_actor_destroy("promiseDemo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(3.0);
															#line 80 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<PromiseDemoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 733 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PromiseDemoActor*>(this)->actor_wait_state = 1;
															#line 80 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PromiseDemoActor, 0, Void >*>(static_cast<PromiseDemoActor*>(this)));
															#line 738 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PromiseDemoActorState();
		static_cast<PromiseDemoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		promise.send(2);
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f;
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<PromiseDemoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 765 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PromiseDemoActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PromiseDemoActor, 1, Void >*>(static_cast<PromiseDemoActor*>(this)));
															#line 770 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		promise.send(2);
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f;
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<PromiseDemoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 783 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<PromiseDemoActor*>(this)->actor_wait_state = 2;
															#line 82 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PromiseDemoActor, 1, Void >*>(static_cast<PromiseDemoActor*>(this)));
															#line 788 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PromiseDemoActor*>(this)->actor_wait_state > 0) static_cast<PromiseDemoActor*>(this)->actor_wait_state = 0;
		static_cast<PromiseDemoActor*>(this)->ActorCallback< PromiseDemoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PromiseDemoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PromiseDemoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PromiseDemoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<PromiseDemoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PromiseDemoActorState(); static_cast<PromiseDemoActor*>(this)->destroy(); return 0; }
															#line 872 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<PromiseDemoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PromiseDemoActorState();
		static_cast<PromiseDemoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<PromiseDemoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PromiseDemoActorState(); static_cast<PromiseDemoActor*>(this)->destroy(); return 0; }
															#line 884 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<PromiseDemoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PromiseDemoActorState();
		static_cast<PromiseDemoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PromiseDemoActor*>(this)->actor_wait_state > 0) static_cast<PromiseDemoActor*>(this)->actor_wait_state = 0;
		static_cast<PromiseDemoActor*>(this)->ActorCallback< PromiseDemoActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PromiseDemoActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PromiseDemoActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PromiseDemoActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 78 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Promise<int> promise;
															#line 79 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> f;
															#line 971 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via promiseDemo()
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class PromiseDemoActor final : public Actor<Void>, public ActorCallback< PromiseDemoActor, 0, Void >, public ActorCallback< PromiseDemoActor, 1, Void >, public FastAllocated<PromiseDemoActor>, public PromiseDemoActorState<PromiseDemoActor> {
															#line 976 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<PromiseDemoActor>::operator new;
	using FastAllocated<PromiseDemoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2215586395414240512UL, 13872844197038322688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PromiseDemoActor, 0, Void >;
friend struct ActorCallback< PromiseDemoActor, 1, Void >;
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	PromiseDemoActor() 
															#line 994 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   PromiseDemoActorState<PromiseDemoActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("promiseDemo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11135284205190497024UL, 16902754515898800128UL);
		ActorExecutionContextHelper __helper(static_cast<PromiseDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("promiseDemo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("promiseDemo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PromiseDemoActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PromiseDemoActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> promiseDemo(  ) {
															#line 77 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new PromiseDemoActor());
															#line 1028 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 85 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 1033 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via eventLoop()
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class EventLoopActor>
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EventLoopActorState {
															#line 1040 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EventLoopActorState(AsyncTrigger* const& trigger) 
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : trigger(trigger)
															#line 1047 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("eventLoop", reinterpret_cast<unsigned long>(this));

	}
	~EventLoopActorState() 
	{
		fdb_probe_actor_destroy("eventLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 1062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EventLoopActorState();
		static_cast<EventLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 88 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0.5);
															#line 87 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EventLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1094 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = trigger->onTrigger();
															#line 1098 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<EventLoopActor*>(this)->actor_wait_state = 1;
															#line 88 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EventLoopActor, 0, Void >*>(static_cast<EventLoopActor*>(this)));
															#line 91 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EventLoopActor, 1, Void >*>(static_cast<EventLoopActor*>(this)));
															#line 1105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Still waiting...\n";
															#line 1120 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Still waiting...\n";
															#line 1129 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Triggered!\n";
															#line 1138 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 92 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Triggered!\n";
															#line 1147 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EventLoopActor*>(this)->actor_wait_state > 0) static_cast<EventLoopActor*>(this)->actor_wait_state = 0;
		static_cast<EventLoopActor*>(this)->ActorCallback< EventLoopActor, 0, Void >::remove();
		static_cast<EventLoopActor*>(this)->ActorCallback< EventLoopActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EventLoopActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EventLoopActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EventLoopActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EventLoopActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EventLoopActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EventLoopActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	AsyncTrigger* trigger;
															#line 1275 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via eventLoop()
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EventLoopActor final : public Actor<Void>, public ActorCallback< EventLoopActor, 0, Void >, public ActorCallback< EventLoopActor, 1, Void >, public FastAllocated<EventLoopActor>, public EventLoopActorState<EventLoopActor> {
															#line 1280 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<EventLoopActor>::operator new;
	using FastAllocated<EventLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2960605389724524032UL, 15438090903233078016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EventLoopActor, 0, Void >;
friend struct ActorCallback< EventLoopActor, 1, Void >;
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EventLoopActor(AsyncTrigger* const& trigger) 
															#line 1298 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   EventLoopActorState<EventLoopActor>(trigger),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("eventLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9392263333227398400UL, 3043736473295405824UL);
		ActorExecutionContextHelper __helper(static_cast<EventLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("eventLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("eventLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EventLoopActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> eventLoop( AsyncTrigger* const& trigger ) {
															#line 86 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new EventLoopActor(trigger));
															#line 1331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 96 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 1336 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via triggerDemo()
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class TriggerDemoActor>
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class TriggerDemoActorState {
															#line 1343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	TriggerDemoActorState() 
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : runs(1),
															#line 99 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   trigger(),
															#line 100 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   triggerLoop(eventLoop(&trigger))
															#line 1354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("triggerDemo", reinterpret_cast<unsigned long>(this));

	}
	~TriggerDemoActorState() 
	{
		fdb_probe_actor_destroy("triggerDemo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 1369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerDemoActorState();
		static_cast<TriggerDemoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 106 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Done.";
															#line 107 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<TriggerDemoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TriggerDemoActorState(); static_cast<TriggerDemoActor*>(this)->destroy(); return 0; }
															#line 1394 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<TriggerDemoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TriggerDemoActorState();
		static_cast<TriggerDemoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!(++runs < 10))
															#line 1413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 102 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 102 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<TriggerDemoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1421 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TriggerDemoActor*>(this)->actor_wait_state = 1;
															#line 102 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerDemoActor, 0, Void >*>(static_cast<TriggerDemoActor*>(this)));
															#line 1426 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "trigger..";
															#line 104 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		trigger.trigger();
															#line 1450 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "trigger..";
															#line 104 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		trigger.trigger();
															#line 1461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerDemoActor*>(this)->actor_wait_state > 0) static_cast<TriggerDemoActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerDemoActor*>(this)->ActorCallback< TriggerDemoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerDemoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerDemoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerDemo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerDemoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerDemo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerDemo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 98 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int runs;
															#line 99 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	AsyncTrigger trigger;
															#line 100 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> triggerLoop;
															#line 1547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via triggerDemo()
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class TriggerDemoActor final : public Actor<Void>, public ActorCallback< TriggerDemoActor, 0, Void >, public FastAllocated<TriggerDemoActor>, public TriggerDemoActorState<TriggerDemoActor> {
															#line 1552 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<TriggerDemoActor>::operator new;
	using FastAllocated<TriggerDemoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7212952029583400448UL, 13616198605307153664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerDemoActor, 0, Void >;
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	TriggerDemoActor() 
															#line 1569 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   TriggerDemoActorState<TriggerDemoActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerDemo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17053554698876546816UL, 16478459148624512768UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerDemoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerDemo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerDemo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerDemoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> triggerDemo(  ) {
															#line 97 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new TriggerDemoActor());
															#line 1602 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 109 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

struct EchoServerInterface {
	constexpr static FileIdentifier file_identifier = 3152015;
	RequestStream<struct GetInterfaceRequest> getInterface;
	RequestStream<struct EchoRequest> echo;
	RequestStream<struct ReverseRequest> reverse;
	RequestStream<struct StreamRequest> stream;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, echo, reverse, stream);
	}
};

struct GetInterfaceRequest {
	constexpr static FileIdentifier file_identifier = 12004156;
	ReplyPromise<EchoServerInterface> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct EchoRequest {
	constexpr static FileIdentifier file_identifier = 10624019;
	std::string message;
	// this variable has to be called reply!
	ReplyPromise<std::string> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, message, reply);
	}
};

struct ReverseRequest {
	constexpr static FileIdentifier file_identifier = 10765955;
	std::string message;
	// this variable has to be called reply!
	ReplyPromise<std::string> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, message, reply);
	}
};

struct StreamReply : ReplyPromiseStreamReply {
	constexpr static FileIdentifier file_identifier = 440804;

	int index = 0;
	StreamReply() = default;
	explicit StreamReply(int index) : index(index) {}

	size_t expectedSize() const { return 2e6; }

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, ReplyPromiseStreamReply::acknowledgeToken, ReplyPromiseStreamReply::sequence, index);
	}
};

struct StreamRequest {
	constexpr static FileIdentifier file_identifier = 5410805;
	ReplyPromiseStream<StreamReply> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

uint64_t tokenCounter = 1;

															#line 1681 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via echoServer()
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class EchoServerActor>
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EchoServerActorState {
															#line 1688 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoServerActorState() 
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 185 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : echoServer()
															#line 1695 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("echoServer", reinterpret_cast<unsigned long>(this));

	}
	~EchoServerActorState() 
	{
		fdb_probe_actor_destroy("echoServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 186 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			echoServer.getInterface.makeWellKnownEndpoint(WLTOKEN_ECHO_SERVER, TaskPriority::DefaultEndpoint);
															#line 187 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 1712 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EchoServerActorState();
		static_cast<EchoServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			FutureStream<GetInterfaceRequest> __when_expr_0 = echoServer.getInterface.getFuture();
															#line 189 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<EchoServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1745 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			FutureStream<EchoRequest> __when_expr_1 = echoServer.echo.getFuture();
															#line 1749 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			FutureStream<ReverseRequest> __when_expr_2 = echoServer.reverse.getFuture();
															#line 1753 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 199 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			FutureStream<StreamRequest> __when_expr_3 = echoServer.stream.getFuture();
															#line 1757 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
			static_cast<EchoServerActor*>(this)->actor_wait_state = 1;
															#line 190 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 193 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 1, EchoRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 2, ReverseRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 199 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 3, StreamRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 1768 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 211 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (e.code() != error_code_operation_obsolete)
															#line 1790 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			{
															#line 212 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
				fprintf(stderr, "Error: %s\n", e.what());
															#line 213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1796 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest const& req,int loopDepth) 
	{
															#line 191 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(echoServer);
															#line 1818 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest && req,int loopDepth) 
	{
															#line 191 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(echoServer);
															#line 1827 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(EchoRequest const& req,int loopDepth) 
	{
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(req.message);
															#line 1836 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(EchoRequest && req,int loopDepth) 
	{
															#line 194 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(req.message);
															#line 1845 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(ReverseRequest const& req,int loopDepth) 
	{
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(std::string(req.message.rbegin(), req.message.rend()));
															#line 1854 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(ReverseRequest && req,int loopDepth) 
	{
															#line 197 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(std::string(req.message.rbegin(), req.message.rend()));
															#line 1863 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(StreamRequest const& __req,int loopDepth) 
	{
															#line 199 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req = __req;
															#line 200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.setByteLimit(1024);
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		i = 0;
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		;
															#line 1878 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1when4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(StreamRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.setByteLimit(1024);
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		i = 0;
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		;
															#line 1892 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1when4loopHead1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EchoServerActor*>(this)->actor_wait_state > 0) static_cast<EchoServerActor*>(this)->actor_wait_state = 0;
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >::remove();
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 1, EchoRequest >::remove();
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 2, ReverseRequest >::remove();
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 3, StreamRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,GetInterfaceRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,GetInterfaceRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,EchoRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,EchoRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 2, ReverseRequest >*,ReverseRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 2, ReverseRequest >*,ReverseRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 2, ReverseRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1when4cont1(int loopDepth) 
	{
															#line 207 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.sendError(end_of_stream());
															#line 2081 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1(int loopDepth) 
	{
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!(i < 100))
															#line 2097 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
			return a_body1loopBody1when4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_4 = req.reply.onReady();
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2105 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<EchoServerActor*>(this)->actor_wait_state = 2;
															#line 203 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< EchoServerActor, 4, Void >*>(static_cast<EchoServerActor*>(this)));
															#line 2110 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when4break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Send " << i << std::endl;
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(StreamReply{ i });
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++i;
															#line 2136 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 204 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Send " << i << std::endl;
															#line 205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(StreamReply{ i });
															#line 202 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++i;
															#line 2149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when4loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EchoServerActor*>(this)->actor_wait_state > 0) static_cast<EchoServerActor*>(this)->actor_wait_state = 0;
		static_cast<EchoServerActor*>(this)->ActorCallback< EchoServerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EchoServerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< EchoServerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< EchoServerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 3, StreamRequest >*,StreamRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 3, StreamRequest >*,StreamRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 3, StreamRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 185 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoServerInterface echoServer;
															#line 199 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	StreamRequest req;
															#line 201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int i;
															#line 2305 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via echoServer()
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EchoServerActor final : public Actor<Void>, public ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >, public ActorSingleCallback< EchoServerActor, 1, EchoRequest >, public ActorSingleCallback< EchoServerActor, 2, ReverseRequest >, public ActorSingleCallback< EchoServerActor, 3, StreamRequest >, public ActorCallback< EchoServerActor, 4, Void >, public FastAllocated<EchoServerActor>, public EchoServerActorState<EchoServerActor> {
															#line 2310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<EchoServerActor>::operator new;
	using FastAllocated<EchoServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8167411055121700608UL, 5090702480851817984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >;
friend struct ActorSingleCallback< EchoServerActor, 1, EchoRequest >;
friend struct ActorSingleCallback< EchoServerActor, 2, ReverseRequest >;
friend struct ActorSingleCallback< EchoServerActor, 3, StreamRequest >;
friend struct ActorCallback< EchoServerActor, 4, Void >;
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoServerActor() 
															#line 2331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   EchoServerActorState<EchoServerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7060032109465747968UL, 10021521862504165120UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("echoServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EchoServerActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> echoServer(  ) {
															#line 184 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new EchoServerActor());
															#line 2365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 218 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 2370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via echoClient()
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class EchoClientActor>
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EchoClientActorState {
															#line 2377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoClientActorState() 
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : server()
															#line 2384 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("echoClient", reinterpret_cast<unsigned long>(this));

	}
	~EchoClientActorState() 
	{
		fdb_probe_actor_destroy("echoClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 221 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			server.getInterface = RequestStream<GetInterfaceRequest>(Endpoint::wellKnown({ serverAddress }, WLTOKEN_ECHO_SERVER));
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<EchoServerInterface> __when_expr_0 = server.getInterface.getReply(GetInterfaceRequest());
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EchoClientActor*>(this)->actor_wait_state = 1;
															#line 223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 0, EchoServerInterface >*>(static_cast<EchoClientActor*>(this)));
															#line 2408 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EchoClientActorState();
		static_cast<EchoClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(EchoServerInterface const& s,int loopDepth) 
	{
															#line 224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		server = s;
															#line 225 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		EchoRequest echoRequest;
															#line 226 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		echoRequest.message = "Hello World";
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = server.echo.getReply(echoRequest);
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2439 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 1, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 2444 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(EchoServerInterface && s,int loopDepth) 
	{
															#line 224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		server = s;
															#line 225 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		EchoRequest echoRequest;
															#line 226 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		echoRequest.message = "Hello World";
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = server.echo.getReply(echoRequest);
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 2;
															#line 227 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 1, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 2466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(EchoServerInterface const& s,int loopDepth) 
	{
		loopDepth = a_body1cont1(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EchoServerInterface && s,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorCallback< EchoClientActor, 0, EchoServerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,EchoServerInterface const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,EchoServerInterface && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::string const& echoMessage,int loopDepth) 
	{
															#line 228 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Sent %s to echo, received %s\n", "Hello World", echoMessage.c_str());
															#line 229 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ReverseRequest reverseRequest;
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		reverseRequest.message = "Hello World";
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = server.reverse.getReply(reverseRequest);
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2558 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 3;
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 2, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 2563 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::string && echoMessage,int loopDepth) 
	{
															#line 228 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Sent %s to echo, received %s\n", "Hello World", echoMessage.c_str());
															#line 229 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ReverseRequest reverseRequest;
															#line 230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		reverseRequest.message = "Hello World";
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = server.reverse.getReply(reverseRequest);
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2580 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 3;
															#line 231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 2, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 2585 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::string const& echoMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(echoMessage, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::string && echoMessage,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(echoMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorCallback< EchoClientActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EchoClientActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::string const& reverseString,int loopDepth) 
	{
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Sent %s to reverse, received %s\n", "Hello World", reverseString.c_str());
															#line 234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		stream = server.stream.getReplyStream(StreamRequest{});
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		j = 0;
															#line 2673 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 2677 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1cont3loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(std::string && reverseString,int loopDepth) 
	{
															#line 232 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Sent %s to reverse, received %s\n", "Hello World", reverseString.c_str());
															#line 234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		stream = server.stream.getReplyStream(StreamRequest{});
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		j = 0;
															#line 2696 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 237 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 2700 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1cont3loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(std::string const& reverseString,int loopDepth) 
	{
		loopDepth = a_body1cont3(reverseString, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::string && reverseString,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(reverseString), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorCallback< EchoClientActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< EchoClientActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 245 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<EchoClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EchoClientActorState(); static_cast<EchoClientActor*>(this)->destroy(); return 0; }
															#line 2790 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<EchoClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EchoClientActorState();
		static_cast<EchoClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 243 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			ASSERT(e.code() == error_code_end_of_stream || e.code() == error_code_connection_failed);
															#line 2803 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		FutureStream<StreamReply> __when_expr_3 = stream.getFuture();
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2827 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.pop(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 4;
															#line 238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< EchoClientActor, 3, StreamReply >*>(static_cast<EchoClientActor*>(this)));
															#line 2832 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(StreamReply const& rep,int loopDepth) 
	{
															#line 239 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Rep: " << rep.index << std::endl;
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ASSERT(rep.index == j++);
															#line 2843 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(StreamReply && rep,int loopDepth) 
	{
															#line 239 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Rep: " << rep.index << std::endl;
															#line 240 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ASSERT(rep.index == j++);
															#line 2854 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(StreamReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(StreamReply && rep,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorSingleCallback< EchoClientActor, 3, StreamReply >::remove();

	}
	void a_callback_fire(ActorSingleCallback< EchoClientActor, 3, StreamReply >*,StreamReply const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< EchoClientActor, 3, StreamReply >*,StreamReply && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< EchoClientActor, 3, StreamReply >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 220 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoServerInterface server;
															#line 234 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ReplyPromiseStream<StreamReply> stream;
															#line 235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int j;
															#line 2940 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via echoClient()
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class EchoClientActor final : public Actor<Void>, public ActorCallback< EchoClientActor, 0, EchoServerInterface >, public ActorCallback< EchoClientActor, 1, std::string >, public ActorCallback< EchoClientActor, 2, std::string >, public ActorSingleCallback< EchoClientActor, 3, StreamReply >, public FastAllocated<EchoClientActor>, public EchoClientActorState<EchoClientActor> {
															#line 2945 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<EchoClientActor>::operator new;
	using FastAllocated<EchoClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7414914782102326528UL, 14752222905430493696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EchoClientActor, 0, EchoServerInterface >;
friend struct ActorCallback< EchoClientActor, 1, std::string >;
friend struct ActorCallback< EchoClientActor, 2, std::string >;
friend struct ActorSingleCallback< EchoClientActor, 3, StreamReply >;
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	EchoClientActor() 
															#line 2965 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   EchoClientActorState<EchoClientActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9930685301966915072UL, 10766244735779810048UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("echoClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EchoClientActor, 0, EchoServerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EchoClientActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< EchoClientActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorSingleCallback< EchoClientActor, 3, StreamReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> echoClient(  ) {
															#line 219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new EchoClientActor());
															#line 3001 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 247 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

struct SimpleKeyValueStoreInterface {
	constexpr static FileIdentifier file_identifier = 8226647;
	RequestStream<struct GetKVInterface> connect;
	RequestStream<struct GetRequest> get;
	RequestStream<struct SetRequest> set;
	RequestStream<struct ClearRequest> clear;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, connect, get, set, clear);
	}
};

struct GetKVInterface {
	constexpr static FileIdentifier file_identifier = 8062308;
	ReplyPromise<SimpleKeyValueStoreInterface> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct GetRequest {
	constexpr static FileIdentifier file_identifier = 6983506;
	std::string key;
	ReplyPromise<std::string> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, key, reply);
	}
};

struct SetRequest {
	constexpr static FileIdentifier file_identifier = 7554186;
	std::string key;
	std::string value;
	ReplyPromise<Void> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, key, value, reply);
	}
};

struct ClearRequest {
	constexpr static FileIdentifier file_identifier = 8500026;
	std::string from;
	std::string to;
	ReplyPromise<Void> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, from, to, reply);
	}
};

															#line 3064 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via kvStoreServer()
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class KvStoreServerActor>
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvStoreServerActorState {
															#line 3071 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvStoreServerActorState() 
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : inf(),
															#line 308 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   store()
															#line 3080 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("kvStoreServer", reinterpret_cast<unsigned long>(this));

	}
	~KvStoreServerActorState() 
	{
		fdb_probe_actor_destroy("kvStoreServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 309 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			inf.connect.makeWellKnownEndpoint(WLTOKEN_SIMPLE_KV_SERVER, TaskPriority::DefaultEndpoint);
															#line 310 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 3097 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KvStoreServerActorState();
		static_cast<KvStoreServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		FutureStream<GetKVInterface> __when_expr_0 = inf.connect.getFuture();
															#line 311 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvStoreServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3129 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		FutureStream<GetRequest> __when_expr_1 = inf.get.getFuture();
															#line 3133 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 324 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		FutureStream<SetRequest> __when_expr_2 = inf.set.getFuture();
															#line 3137 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.pop(), loopDepth); };
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		FutureStream<ClearRequest> __when_expr_3 = inf.clear.getFuture();
															#line 3141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.pop(), loopDepth); };
		static_cast<KvStoreServerActor*>(this)->actor_wait_state = 1;
															#line 312 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*>(static_cast<KvStoreServerActor*>(this)));
															#line 316 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< KvStoreServerActor, 1, GetRequest >*>(static_cast<KvStoreServerActor*>(this)));
															#line 324 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< KvStoreServerActor, 2, SetRequest >*>(static_cast<KvStoreServerActor*>(this)));
															#line 328 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >*>(static_cast<KvStoreServerActor*>(this)));
															#line 3152 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKVInterface const& req,int loopDepth) 
	{
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Received connection attempt\n";
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(inf);
															#line 3169 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetKVInterface && req,int loopDepth) 
	{
															#line 313 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Received connection attempt\n";
															#line 314 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(inf);
															#line 3180 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetRequest const& req,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto iter = store.find(req.key);
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (iter == store.end())
															#line 3191 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			req.reply.sendError(io_error());
															#line 3195 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		else
		{
															#line 321 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			req.reply.send(iter->second);
															#line 3201 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(GetRequest && req,int loopDepth) 
	{
															#line 317 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto iter = store.find(req.key);
															#line 318 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (iter == store.end())
															#line 3213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 319 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			req.reply.sendError(io_error());
															#line 3217 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		else
		{
															#line 321 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			req.reply.send(iter->second);
															#line 3223 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(SetRequest const& req,int loopDepth) 
	{
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		store[req.key] = req.value;
															#line 326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(Void());
															#line 3235 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(SetRequest && req,int loopDepth) 
	{
															#line 325 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		store[req.key] = req.value;
															#line 326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(Void());
															#line 3246 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ClearRequest const& req,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto from = store.lower_bound(req.from);
															#line 330 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto to = store.lower_bound(req.to);
															#line 331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for(;from != store.end() && from != to;) {
															#line 332 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto next = from;
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			++next;
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			store.erase(from);
															#line 335 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			from = next;
															#line 3267 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(Void());
															#line 3271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(ClearRequest && req,int loopDepth) 
	{
															#line 329 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto from = store.lower_bound(req.from);
															#line 330 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto to = store.lower_bound(req.to);
															#line 331 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for(;from != store.end() && from != to;) {
															#line 332 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto next = from;
															#line 333 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			++next;
															#line 334 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			store.erase(from);
															#line 335 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			from = next;
															#line 3292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		req.reply.send(Void());
															#line 3296 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KvStoreServerActor*>(this)->actor_wait_state > 0) static_cast<KvStoreServerActor*>(this)->actor_wait_state = 0;
		static_cast<KvStoreServerActor*>(this)->ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >::remove();
		static_cast<KvStoreServerActor*>(this)->ActorSingleCallback< KvStoreServerActor, 1, GetRequest >::remove();
		static_cast<KvStoreServerActor*>(this)->ActorSingleCallback< KvStoreServerActor, 2, SetRequest >::remove();
		static_cast<KvStoreServerActor*>(this)->ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*,GetKVInterface const& value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*,GetKVInterface && value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*,Error err) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 1, GetRequest >*,GetRequest const& value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 1, GetRequest >*,GetRequest && value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< KvStoreServerActor, 1, GetRequest >*,Error err) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 2, SetRequest >*,SetRequest const& value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 2, SetRequest >*,SetRequest && value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< KvStoreServerActor, 2, SetRequest >*,Error err) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >*,ClearRequest const& value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >*,ClearRequest && value) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >*,Error err) 
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 307 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleKeyValueStoreInterface inf;
															#line 308 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	std::map<std::string, std::string> store;
															#line 3542 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via kvStoreServer()
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvStoreServerActor final : public Actor<Void>, public ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >, public ActorSingleCallback< KvStoreServerActor, 1, GetRequest >, public ActorSingleCallback< KvStoreServerActor, 2, SetRequest >, public ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >, public FastAllocated<KvStoreServerActor>, public KvStoreServerActorState<KvStoreServerActor> {
															#line 3547 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<KvStoreServerActor>::operator new;
	using FastAllocated<KvStoreServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16140014019428083968UL, 17143453602119095552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >;
friend struct ActorSingleCallback< KvStoreServerActor, 1, GetRequest >;
friend struct ActorSingleCallback< KvStoreServerActor, 2, SetRequest >;
friend struct ActorSingleCallback< KvStoreServerActor, 3, ClearRequest >;
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvStoreServerActor() 
															#line 3567 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   KvStoreServerActorState<KvStoreServerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("kvStoreServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5912263144271601152UL, 1978734525476857856UL);
		ActorExecutionContextHelper __helper(static_cast<KvStoreServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("kvStoreServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("kvStoreServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< KvStoreServerActor, 0, GetKVInterface >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> kvStoreServer(  ) {
															#line 306 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new KvStoreServerActor());
															#line 3600 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 342 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 3605 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via connect()
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class ConnectActor>
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class ConnectActorState {
															#line 3612 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ConnectActorState() 
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	{
															#line 3618 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		fdb_probe_actor_create("connect", reinterpret_cast<unsigned long>(this));

	}
	~ConnectActorState() 
	{
		fdb_probe_actor_destroy("connect", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 344 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			std::cout << format("%llu: Connect...\n", uint64_t(g_network->now()));
															#line 345 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			auto reqStream = RequestStream<GetKVInterface>(Endpoint::wellKnown({ serverAddress }, WLTOKEN_SIMPLE_KV_SERVER));
															#line 346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<SimpleKeyValueStoreInterface> __when_expr_0 = reqStream.getReply(GetKVInterface());
															#line 346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<ConnectActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3638 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConnectActor*>(this)->actor_wait_state = 1;
															#line 346 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*>(static_cast<ConnectActor*>(this)));
															#line 3643 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConnectActorState();
		static_cast<ConnectActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(SimpleKeyValueStoreInterface const& result,int loopDepth) 
	{
															#line 347 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("%llu: done..\n", uint64_t(g_network->now()));
															#line 348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<ConnectActor*>(this)->SAV<SimpleKeyValueStoreInterface>::futures) { (void)(result); this->~ConnectActorState(); static_cast<ConnectActor*>(this)->destroy(); return 0; }
															#line 3668 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<ConnectActor*>(this)->SAV< SimpleKeyValueStoreInterface >::value()) SimpleKeyValueStoreInterface(result);
		this->~ConnectActorState();
		static_cast<ConnectActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(SimpleKeyValueStoreInterface && result,int loopDepth) 
	{
															#line 347 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("%llu: done..\n", uint64_t(g_network->now()));
															#line 348 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<ConnectActor*>(this)->SAV<SimpleKeyValueStoreInterface>::futures) { (void)(result); this->~ConnectActorState(); static_cast<ConnectActor*>(this)->destroy(); return 0; }
															#line 3682 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<ConnectActor*>(this)->SAV< SimpleKeyValueStoreInterface >::value()) SimpleKeyValueStoreInterface(result);
		this->~ConnectActorState();
		static_cast<ConnectActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConnectActor*>(this)->actor_wait_state > 0) static_cast<ConnectActor*>(this)->actor_wait_state = 0;
		static_cast<ConnectActor*>(this)->ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >::remove();

	}
	void a_callback_fire(ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface const& value) 
	{
		fdb_probe_actor_enter("connect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface && value) 
	{
		fdb_probe_actor_enter("connect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*,Error err) 
	{
		fdb_probe_actor_enter("connect", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("connect", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via connect()
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class ConnectActor final : public Actor<SimpleKeyValueStoreInterface>, public ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >, public FastAllocated<ConnectActor>, public ConnectActorState<ConnectActor> {
															#line 3769 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<ConnectActor>::operator new;
	using FastAllocated<ConnectActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8864767337444820736UL, 8073487863512328192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<SimpleKeyValueStoreInterface>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >;
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ConnectActor() 
															#line 3786 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<SimpleKeyValueStoreInterface>(),
		   ConnectActorState<ConnectActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("connect", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6918112119896711168UL, 6671612149293629184UL);
		ActorExecutionContextHelper __helper(static_cast<ConnectActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("connect");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("connect", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConnectActor, 0, SimpleKeyValueStoreInterface >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<SimpleKeyValueStoreInterface> connect(  ) {
															#line 343 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<SimpleKeyValueStoreInterface>(new ConnectActor());
															#line 3819 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 350 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 3824 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via kvSimpleClient()
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class KvSimpleClientActor>
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvSimpleClientActorState {
															#line 3831 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvSimpleClientActorState() 
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	{
															#line 3837 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		fdb_probe_actor_create("kvSimpleClient", reinterpret_cast<unsigned long>(this));

	}
	~KvSimpleClientActorState() 
	{
		fdb_probe_actor_destroy("kvSimpleClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<SimpleKeyValueStoreInterface> __when_expr_0 = connect();
															#line 352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3853 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 1;
															#line 352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*>(static_cast<KvSimpleClientActor*>(this)));
															#line 3858 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KvSimpleClientActorState();
		static_cast<KvSimpleClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 353 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("Set %s -> %s\n", "foo", "bar");
															#line 354 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		SetRequest setRequest;
															#line 355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		setRequest.key = "foo";
															#line 356 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		setRequest.value = "bar";
															#line 357 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = server.set.getReply(setRequest);
															#line 357 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3891 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 2;
															#line 357 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KvSimpleClientActor, 1, Void >*>(static_cast<KvSimpleClientActor*>(this)));
															#line 3896 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface const& __server,int loopDepth) 
	{
															#line 352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		server = __server;
															#line 3905 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface && __server,int loopDepth) 
	{
		server = std::move(__server);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state > 0) static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvSimpleClientActor*>(this)->ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >::remove();

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface const& value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface && value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*,Error err) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		GetRequest getRequest;
															#line 359 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		getRequest.key = "foo";
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = server.get.getReply(getRequest);
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3990 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 3;
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KvSimpleClientActor, 2, std::string >*>(static_cast<KvSimpleClientActor*>(this)));
															#line 3995 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 358 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		GetRequest getRequest;
															#line 359 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		getRequest.key = "foo";
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = server.get.getReply(getRequest);
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4010 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 3;
															#line 360 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KvSimpleClientActor, 2, std::string >*>(static_cast<KvSimpleClientActor*>(this)));
															#line 4015 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state > 0) static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvSimpleClientActor*>(this)->ActorCallback< KvSimpleClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KvSimpleClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(std::string const& value,int loopDepth) 
	{
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("get(%s) -> %s\n", "foo", value.c_str());
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<KvSimpleClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KvSimpleClientActorState(); static_cast<KvSimpleClientActor*>(this)->destroy(); return 0; }
															#line 4101 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<KvSimpleClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KvSimpleClientActorState();
		static_cast<KvSimpleClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(std::string && value,int loopDepth) 
	{
															#line 361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("get(%s) -> %s\n", "foo", value.c_str());
															#line 362 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<KvSimpleClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KvSimpleClientActorState(); static_cast<KvSimpleClientActor*>(this)->destroy(); return 0; }
															#line 4115 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<KvSimpleClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KvSimpleClientActorState();
		static_cast<KvSimpleClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::string const& value,int loopDepth) 
	{
		loopDepth = a_body1cont3(value, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::string && value,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<KvSimpleClientActor*>(this)->actor_wait_state > 0) static_cast<KvSimpleClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvSimpleClientActor*>(this)->ActorCallback< KvSimpleClientActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< KvSimpleClientActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< KvSimpleClientActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 352 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleKeyValueStoreInterface server;
															#line 4200 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via kvSimpleClient()
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvSimpleClientActor final : public Actor<Void>, public ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >, public ActorCallback< KvSimpleClientActor, 1, Void >, public ActorCallback< KvSimpleClientActor, 2, std::string >, public FastAllocated<KvSimpleClientActor>, public KvSimpleClientActorState<KvSimpleClientActor> {
															#line 4205 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<KvSimpleClientActor>::operator new;
	using FastAllocated<KvSimpleClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3889459947167639808UL, 15979626541146390528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >;
friend struct ActorCallback< KvSimpleClientActor, 1, Void >;
friend struct ActorCallback< KvSimpleClientActor, 2, std::string >;
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvSimpleClientActor() 
															#line 4224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   KvSimpleClientActorState<KvSimpleClientActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("kvSimpleClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8014170538980641792UL, 9511851362767628032UL);
		ActorExecutionContextHelper __helper(static_cast<KvSimpleClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("kvSimpleClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("kvSimpleClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KvSimpleClientActor, 0, SimpleKeyValueStoreInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KvSimpleClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< KvSimpleClientActor, 2, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> kvSimpleClient(  ) {
															#line 351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new KvSimpleClientActor());
															#line 4259 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 364 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 4264 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via kvClient()
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class KvClientActor>
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvClientActorState {
															#line 4271 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvClientActorState(SimpleKeyValueStoreInterface const& server,std::shared_ptr<uint64_t> const& ops) 
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : server(server),
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   ops(ops),
															#line 366 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   timeout(delay(20)),
															#line 367 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   rangeSize(2 << 12)
															#line 4284 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("kvClient", reinterpret_cast<unsigned long>(this));

	}
	~KvClientActorState() 
	{
		fdb_probe_actor_destroy("kvClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 368 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 4299 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KvClientActorState();
		static_cast<KvClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 369 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		SetRequest setRequest;
															#line 370 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		setRequest.key = std::to_string(deterministicRandom()->randomInt(0, rangeSize));
															#line 371 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		setRequest.value = "foo";
															#line 372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = server.set.getReply(setRequest);
															#line 372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<KvClientActor*>(this)->actor_wait_state = 1;
															#line 372 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KvClientActor, 0, Void >*>(static_cast<KvClientActor*>(this)));
															#line 4342 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 373 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 4351 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 375 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			GetRequest getRequest;
															#line 376 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			getRequest.key = std::to_string(deterministicRandom()->randomInt(0, rangeSize));
															#line 377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = server.get.getReply(getRequest);
															#line 377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<KvClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4361 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<KvClientActor*>(this)->actor_wait_state = 2;
															#line 377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KvClientActor, 1, std::string >*>(static_cast<KvClientActor*>(this)));
															#line 4366 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 373 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 4381 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 375 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			GetRequest getRequest;
															#line 376 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			getRequest.key = std::to_string(deterministicRandom()->randomInt(0, rangeSize));
															#line 377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = server.get.getReply(getRequest);
															#line 377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<KvClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4391 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<KvClientActor*>(this)->actor_wait_state = 2;
															#line 377 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KvClientActor, 1, std::string >*>(static_cast<KvClientActor*>(this)));
															#line 4396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KvClientActor*>(this)->actor_wait_state > 0) static_cast<KvClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvClientActor*>(this)->ActorCallback< KvClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KvClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KvClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KvClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 384 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		int from = deterministicRandom()->randomInt(0, rangeSize);
															#line 385 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		ClearRequest clearRequest;
															#line 386 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		clearRequest.from = std::to_string(from);
															#line 387 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		clearRequest.to = std::to_string(from + 100);
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = server.clear.getReply(clearRequest);
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<KvClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4496 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<KvClientActor*>(this)->actor_wait_state = 3;
															#line 388 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KvClientActor, 2, Void >*>(static_cast<KvClientActor*>(this)));
															#line 4501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 380 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (e.code() != error_code_io_error)
															#line 4511 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			{
															#line 381 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 4515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string const& _,int loopDepth) 
	{
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 4531 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && _,int loopDepth) 
	{
															#line 378 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 4540 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(std::string && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KvClientActor*>(this)->actor_wait_state > 0) static_cast<KvClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvClientActor*>(this)->ActorCallback< KvClientActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< KvClientActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KvClientActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KvClientActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 390 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (timeout.isReady())
															#line 4639 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 392 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (!static_cast<KvClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KvClientActorState(); static_cast<KvClientActor*>(this)->destroy(); return 0; }
															#line 4643 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			new (&static_cast<KvClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~KvClientActorState();
			static_cast<KvClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		++(*ops);
															#line 390 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (timeout.isReady())
															#line 4659 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 392 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (!static_cast<KvClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KvClientActorState(); static_cast<KvClientActor*>(this)->destroy(); return 0; }
															#line 4663 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			new (&static_cast<KvClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~KvClientActorState();
			static_cast<KvClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<KvClientActor*>(this)->actor_wait_state > 0) static_cast<KvClientActor*>(this)->actor_wait_state = 0;
		static_cast<KvClientActor*>(this)->ActorCallback< KvClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KvClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< KvClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< KvClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	SimpleKeyValueStoreInterface server;
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	std::shared_ptr<uint64_t> ops;
															#line 366 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> timeout;
															#line 367 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int rangeSize;
															#line 4756 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via kvClient()
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class KvClientActor final : public Actor<Void>, public ActorCallback< KvClientActor, 0, Void >, public ActorCallback< KvClientActor, 1, std::string >, public ActorCallback< KvClientActor, 2, Void >, public FastAllocated<KvClientActor>, public KvClientActorState<KvClientActor> {
															#line 4761 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<KvClientActor>::operator new;
	using FastAllocated<KvClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3875550809591985152UL, 6267230549600881408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KvClientActor, 0, Void >;
friend struct ActorCallback< KvClientActor, 1, std::string >;
friend struct ActorCallback< KvClientActor, 2, Void >;
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KvClientActor(SimpleKeyValueStoreInterface const& server,std::shared_ptr<uint64_t> const& ops) 
															#line 4780 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   KvClientActorState<KvClientActor>(server, ops),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("kvClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13424801593058757120UL, 15667845603933868800UL);
		ActorExecutionContextHelper __helper(static_cast<KvClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("kvClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("kvClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KvClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KvClientActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< KvClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> kvClient( SimpleKeyValueStoreInterface const& server, std::shared_ptr<uint64_t> const& ops ) {
															#line 365 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new KvClientActor(server, ops));
															#line 4815 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 4820 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via throughputMeasurement()
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class ThroughputMeasurementActor>
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class ThroughputMeasurementActorState {
															#line 4827 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ThroughputMeasurementActorState(std::shared_ptr<uint64_t> const& operations) 
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : operations(operations)
															#line 4834 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("throughputMeasurement", reinterpret_cast<unsigned long>(this));

	}
	~ThroughputMeasurementActorState() 
	{
		fdb_probe_actor_destroy("throughputMeasurement", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 398 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 4849 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ThroughputMeasurementActorState();
		static_cast<ThroughputMeasurementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<ThroughputMeasurementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4881 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ThroughputMeasurementActor*>(this)->actor_wait_state = 1;
															#line 399 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ThroughputMeasurementActor, 0, Void >*>(static_cast<ThroughputMeasurementActor*>(this)));
															#line 4886 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("%llu op/s\n", *operations);
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		*operations = 0;
															#line 4897 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 400 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << format("%llu op/s\n", *operations);
															#line 401 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		*operations = 0;
															#line 4908 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ThroughputMeasurementActor*>(this)->actor_wait_state > 0) static_cast<ThroughputMeasurementActor*>(this)->actor_wait_state = 0;
		static_cast<ThroughputMeasurementActor*>(this)->ActorCallback< ThroughputMeasurementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ThroughputMeasurementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputMeasurementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ThroughputMeasurementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputMeasurementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ThroughputMeasurementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputMeasurementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("throughputMeasurement", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	std::shared_ptr<uint64_t> operations;
															#line 4990 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via throughputMeasurement()
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class ThroughputMeasurementActor final : public Actor<Void>, public ActorCallback< ThroughputMeasurementActor, 0, Void >, public FastAllocated<ThroughputMeasurementActor>, public ThroughputMeasurementActorState<ThroughputMeasurementActor> {
															#line 4995 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<ThroughputMeasurementActor>::operator new;
	using FastAllocated<ThroughputMeasurementActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9930775232620592896UL, 17525841838531358208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ThroughputMeasurementActor, 0, Void >;
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ThroughputMeasurementActor(std::shared_ptr<uint64_t> const& operations) 
															#line 5012 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   ThroughputMeasurementActorState<ThroughputMeasurementActor>(operations),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("throughputMeasurement", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9055920685224049152UL, 13522355584684806144UL);
		ActorExecutionContextHelper __helper(static_cast<ThroughputMeasurementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("throughputMeasurement");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("throughputMeasurement", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ThroughputMeasurementActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> throughputMeasurement( std::shared_ptr<uint64_t> const& operations ) {
															#line 397 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new ThroughputMeasurementActor(operations));
															#line 5045 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 404 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 5050 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via multipleClients()
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class MultipleClientsActor>
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class MultipleClientsActorState {
															#line 5057 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	MultipleClientsActorState() 
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	{
															#line 5063 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		fdb_probe_actor_create("multipleClients", reinterpret_cast<unsigned long>(this));

	}
	~MultipleClientsActorState() 
	{
		fdb_probe_actor_destroy("multipleClients", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<SimpleKeyValueStoreInterface> __when_expr_0 = connect();
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<MultipleClientsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5079 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MultipleClientsActor*>(this)->actor_wait_state = 1;
															#line 406 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*>(static_cast<MultipleClientsActor*>(this)));
															#line 5084 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MultipleClientsActorState();
		static_cast<MultipleClientsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(SimpleKeyValueStoreInterface const& server,int loopDepth) 
	{
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto ops = std::make_shared<uint64_t>(0);
															#line 408 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::vector<Future<Void>> clients(100);
															#line 409 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for( auto& f : clients ) {
															#line 410 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			f = kvClient(server, ops);
															#line 5113 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 412 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto done = waitForAll(clients);
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = done || throughputMeasurement(ops);
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<MultipleClientsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5121 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MultipleClientsActor*>(this)->actor_wait_state = 2;
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MultipleClientsActor, 1, Void >*>(static_cast<MultipleClientsActor*>(this)));
															#line 5126 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(SimpleKeyValueStoreInterface && server,int loopDepth) 
	{
															#line 407 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto ops = std::make_shared<uint64_t>(0);
															#line 408 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::vector<Future<Void>> clients(100);
															#line 409 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for( auto& f : clients ) {
															#line 410 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			f = kvClient(server, ops);
															#line 5141 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 412 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		auto done = waitForAll(clients);
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_1 = done || throughputMeasurement(ops);
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<MultipleClientsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MultipleClientsActor*>(this)->actor_wait_state = 2;
															#line 413 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MultipleClientsActor, 1, Void >*>(static_cast<MultipleClientsActor*>(this)));
															#line 5154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface const& server,int loopDepth) 
	{
		loopDepth = a_body1cont1(server, loopDepth);

		return loopDepth;
	}
	int a_body1when1(SimpleKeyValueStoreInterface && server,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(server), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MultipleClientsActor*>(this)->actor_wait_state > 0) static_cast<MultipleClientsActor*>(this)->actor_wait_state = 0;
		static_cast<MultipleClientsActor*>(this)->ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >::remove();

	}
	void a_callback_fire(ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface const& value) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*,SimpleKeyValueStoreInterface && value) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*,Error err) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<MultipleClientsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MultipleClientsActorState(); static_cast<MultipleClientsActor*>(this)->destroy(); return 0; }
															#line 5238 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<MultipleClientsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MultipleClientsActorState();
		static_cast<MultipleClientsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 414 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<MultipleClientsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MultipleClientsActorState(); static_cast<MultipleClientsActor*>(this)->destroy(); return 0; }
															#line 5250 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<MultipleClientsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MultipleClientsActorState();
		static_cast<MultipleClientsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MultipleClientsActor*>(this)->actor_wait_state > 0) static_cast<MultipleClientsActor*>(this)->actor_wait_state = 0;
		static_cast<MultipleClientsActor*>(this)->ActorCallback< MultipleClientsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MultipleClientsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MultipleClientsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MultipleClientsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), 1);

	}
};
// This generated class is to be used only via multipleClients()
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class MultipleClientsActor final : public Actor<Void>, public ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >, public ActorCallback< MultipleClientsActor, 1, Void >, public FastAllocated<MultipleClientsActor>, public MultipleClientsActorState<MultipleClientsActor> {
															#line 5337 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<MultipleClientsActor>::operator new;
	using FastAllocated<MultipleClientsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16523859997074084608UL, 5401269047387769344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >;
friend struct ActorCallback< MultipleClientsActor, 1, Void >;
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	MultipleClientsActor() 
															#line 5355 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   MultipleClientsActorState<MultipleClientsActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("multipleClients", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5890172071585402880UL, 17513529943277648384UL);
		ActorExecutionContextHelper __helper(static_cast<MultipleClientsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("multipleClients");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("multipleClients", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MultipleClientsActor, 0, SimpleKeyValueStoreInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MultipleClientsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> multipleClients(  ) {
															#line 405 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new MultipleClientsActor());
															#line 5389 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 416 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

std::string clusterFile = "fdb.cluster";

															#line 5396 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via logThroughput()
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class LogThroughputActor>
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class LogThroughputActorState {
															#line 5403 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	LogThroughputActorState(int64_t* const& v,Key* const& next) 
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : v(v),
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   next(next)
															#line 5412 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("logThroughput", reinterpret_cast<unsigned long>(this));

	}
	~LogThroughputActorState() 
	{
		fdb_probe_actor_destroy("logThroughput", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 420 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 5427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LogThroughputActorState();
		static_cast<LogThroughputActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 421 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		last = *v;
															#line 422 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1);
															#line 422 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<LogThroughputActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LogThroughputActor*>(this)->actor_wait_state = 1;
															#line 422 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LogThroughputActor, 0, Void >*>(static_cast<LogThroughputActor*>(this)));
															#line 5466 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		fmt::print("throughput: {} bytes/s, next: {}\n", *v - last, printable(*next).c_str());
															#line 5475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 423 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		fmt::print("throughput: {} bytes/s, next: {}\n", *v - last, printable(*next).c_str());
															#line 5484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LogThroughputActor*>(this)->actor_wait_state > 0) static_cast<LogThroughputActor*>(this)->actor_wait_state = 0;
		static_cast<LogThroughputActor*>(this)->ActorCallback< LogThroughputActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LogThroughputActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LogThroughputActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LogThroughputActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int64_t* v;
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key* next;
															#line 421 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int64_t last;
															#line 5570 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via logThroughput()
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class LogThroughputActor final : public Actor<Void>, public ActorCallback< LogThroughputActor, 0, Void >, public FastAllocated<LogThroughputActor>, public LogThroughputActorState<LogThroughputActor> {
															#line 5575 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<LogThroughputActor>::operator new;
	using FastAllocated<LogThroughputActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14950306892764317440UL, 16129659811842711296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LogThroughputActor, 0, Void >;
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	LogThroughputActor(int64_t* const& v,Key* const& next) 
															#line 5592 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   LogThroughputActorState<LogThroughputActor>(v, next),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logThroughput", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2415456824429687552UL, 17289377887960322816UL);
		ActorExecutionContextHelper __helper(static_cast<LogThroughputActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logThroughput");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logThroughput", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LogThroughputActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> logThroughput( int64_t* const& v, Key* const& next ) {
															#line 419 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new LogThroughputActor(v, next));
															#line 5625 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 426 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 5630 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via fdbClientStream()
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class FdbClientStreamActor>
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientStreamActorState {
															#line 5637 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientStreamActorState() 
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 428 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : db(Database::createDatabase(clusterFile, 300)),
															#line 429 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   tx(db),
															#line 430 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   next(),
															#line 431 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   bytes(0),
															#line 432 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   logFuture(logThroughput(&bytes, &next))
															#line 5652 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbClientStream", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientStreamActorState() 
	{
		fdb_probe_actor_destroy("fdbClientStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 433 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 5667 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientStreamActorState();
		static_cast<FdbClientStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 454 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<FdbClientStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FdbClientStreamActorState(); static_cast<FdbClientStreamActor*>(this)->destroy(); return 0; }
															#line 5690 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<FdbClientStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FdbClientStreamActorState();
		static_cast<FdbClientStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 434 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		results = PromiseStream<Standalone<RangeResultRef>>();
															#line 5709 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		try {
															#line 436 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			stream = tx.getRangeStream(results, KeySelector(firstGreaterOrEqual(next), next.arena()), KeySelector(firstGreaterOrEqual(normalKeys.end)), GetRangeLimits());
															#line 440 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 5715 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 448 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 5750 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 451 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx.onError(e);
															#line 451 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5758 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 2;
															#line 451 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientStreamActor, 1, Void >*>(static_cast<FdbClientStreamActor*>(this)));
															#line 5763 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 441 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		FutureStream<Standalone<RangeResultRef>> __when_expr_0 = results.getFuture();
															#line 441 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5787 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 1;
															#line 441 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*>(static_cast<FdbClientStreamActor*>(this)));
															#line 5792 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
															#line 442 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (range.size())
															#line 5801 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			bytes += range.expectedSize();
															#line 444 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			next = keyAfter(range.back().key);
															#line 5807 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
															#line 442 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (range.size())
															#line 5817 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
															#line 443 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			bytes += range.expectedSize();
															#line 444 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			next = keyAfter(range.back().key);
															#line 5823 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state > 0) static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientStreamActor*>(this)->ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientStreamActor*>(this)->actor_wait_state > 0) static_cast<FdbClientStreamActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientStreamActor*>(this)->ActorCallback< FdbClientStreamActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientStreamActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientStreamActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientStreamActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 428 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Database db;
															#line 429 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Transaction tx;
															#line 430 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key next;
															#line 431 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int64_t bytes;
															#line 432 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> logFuture;
															#line 434 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	PromiseStream<Standalone<RangeResultRef>> results;
															#line 436 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> stream;
															#line 6005 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via fdbClientStream()
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientStreamActor final : public Actor<Void>, public ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >, public ActorCallback< FdbClientStreamActor, 1, Void >, public FastAllocated<FdbClientStreamActor>, public FdbClientStreamActorState<FdbClientStreamActor> {
															#line 6010 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<FdbClientStreamActor>::operator new;
	using FastAllocated<FdbClientStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16008400518480467456UL, 1097207169325405952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >;
friend struct ActorCallback< FdbClientStreamActor, 1, Void >;
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientStreamActor() 
															#line 6028 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientStreamActorState<FdbClientStreamActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClientStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11970803611283168000UL, 3665065125492980736UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClientStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClientStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< FdbClientStreamActor, 0, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientStreamActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> fdbClientStream(  ) {
															#line 427 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new FdbClientStreamActor());
															#line 6062 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 456 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 6067 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via fdbClientGetRange()
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class FdbClientGetRangeActor>
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientGetRangeActorState {
															#line 6074 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientGetRangeActorState() 
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 458 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : db(Database::createDatabase(clusterFile, 300)),
															#line 459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   tx(db),
															#line 460 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   next(),
															#line 461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   bytes(0),
															#line 462 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   logFuture(logThroughput(&bytes, &next))
															#line 6089 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbClientGetRange", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientGetRangeActorState() 
	{
		fdb_probe_actor_destroy("fdbClientGetRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 463 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 6104 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientGetRangeActorState();
		static_cast<FdbClientGetRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 478 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!static_cast<FdbClientGetRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FdbClientGetRangeActorState(); static_cast<FdbClientGetRangeActor*>(this)->destroy(); return 0; }
															#line 6127 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		new (&static_cast<FdbClientGetRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FdbClientGetRangeActorState();
		static_cast<FdbClientGetRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 465 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Standalone<RangeResultRef>> __when_expr_0 = tx.getRange(KeySelector(firstGreaterOrEqual(next), next.arena()), KeySelector(firstGreaterOrEqual(normalKeys.end)), GetRangeLimits(GetRangeLimits::ROW_LIMIT_UNLIMITED, CLIENT_KNOBS->REPLY_BYTE_LIMIT));
															#line 465 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6149 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 1;
															#line 465 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*>(static_cast<FdbClientGetRangeActor*>(this)));
															#line 6154 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx.onError(e);
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6191 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 2;
															#line 475 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientGetRangeActor, 1, Void >*>(static_cast<FdbClientGetRangeActor*>(this)));
															#line 6196 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		bytes += range.expectedSize();
															#line 470 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!range.more)
															#line 6213 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 473 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		next = keyAfter(range.back().key);
															#line 6219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<RangeResultRef> && range,int loopDepth) 
	{
															#line 469 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		bytes += range.expectedSize();
															#line 470 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (!range.more)
															#line 6230 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 473 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		next = keyAfter(range.back().key);
															#line 6236 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<RangeResultRef> const& range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(range, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<RangeResultRef> && range,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientGetRangeActor*>(this)->ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Standalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state > 0) static_cast<FdbClientGetRangeActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientGetRangeActor*>(this)->ActorCallback< FdbClientGetRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientGetRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 458 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Database db;
															#line 459 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Transaction tx;
															#line 460 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key next;
															#line 461 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int64_t bytes;
															#line 462 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Future<Void> logFuture;
															#line 6426 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via fdbClientGetRange()
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientGetRangeActor final : public Actor<Void>, public ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >, public ActorCallback< FdbClientGetRangeActor, 1, Void >, public FastAllocated<FdbClientGetRangeActor>, public FdbClientGetRangeActorState<FdbClientGetRangeActor> {
															#line 6431 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<FdbClientGetRangeActor>::operator new;
	using FastAllocated<FdbClientGetRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15928529807865487104UL, 7864932071263712000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >;
friend struct ActorCallback< FdbClientGetRangeActor, 1, Void >;
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientGetRangeActor() 
															#line 6449 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientGetRangeActorState<FdbClientGetRangeActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClientGetRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(431275374245541632UL, 2355442063886276352UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientGetRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClientGetRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClientGetRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FdbClientGetRangeActor, 0, Standalone<RangeResultRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientGetRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> fdbClientGetRange(  ) {
															#line 457 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new FdbClientGetRangeActor());
															#line 6483 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 480 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 6488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via fdbClient()
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class FdbClientActor>
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientActorState {
															#line 6495 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientActorState() 
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	{
															#line 6501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		fdb_probe_actor_create("fdbClient", reinterpret_cast<unsigned long>(this));

	}
	~FdbClientActorState() 
	{
		fdb_probe_actor_destroy("fdbClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(30);
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FdbClientActor*>(this)->actor_wait_state = 1;
															#line 482 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 0, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6522 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbClientActorState();
		static_cast<FdbClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 483 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		db = Database::createDatabase(clusterFile, 300);
															#line 484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		tx = Transaction(db);
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		keyPrefix = "/tut/";
															#line 486 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		startKey = Key();
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		endKey = "/tut0"_sr;
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		beginIdx = 0;
															#line 489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		;
															#line 6557 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 483 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		db = Database::createDatabase(clusterFile, 300);
															#line 484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		tx = Transaction(db);
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		keyPrefix = "/tut/";
															#line 486 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		startKey = Key();
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		endKey = "/tut0"_sr;
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		beginIdx = 0;
															#line 489 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		;
															#line 6578 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 491 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			tx.reset();
															#line 498 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			beginIdx = deterministicRandom()->randomInt(0, 1e8 - 100);
															#line 499 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			startKey = keyPrefix + std::to_string(beginIdx);
															#line 500 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tx.getRange(KeyRangeRef(startKey, endKey), 100);
															#line 500 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6678 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbClientActor*>(this)->actor_wait_state = 2;
															#line 500 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 1, RangeResult >*>(static_cast<FdbClientActor*>(this)));
															#line 6683 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tx.onError(e);
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6707 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<FdbClientActor*>(this)->actor_wait_state = 5;
															#line 509 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 4, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6712 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult const& range,int loopDepth) 
	{
															#line 501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for(int i = 0;i < 10;++i) {
															#line 502 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			Key k = Key(keyPrefix + std::to_string(beginIdx + deterministicRandom()->randomInt(0, 100)));
															#line 503 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			tx.set(k, "foo"_sr);
															#line 6731 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tx.commit();
															#line 505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6737 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FdbClientActor*>(this)->actor_wait_state = 3;
															#line 505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 2, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6742 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult && range,int loopDepth) 
	{
															#line 501 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		for(int i = 0;i < 10;++i) {
															#line 502 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			Key k = Key(keyPrefix + std::to_string(beginIdx + deterministicRandom()->randomInt(0, 100)));
															#line 503 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			tx.set(k, "foo"_sr);
															#line 6755 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		}
															#line 505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tx.commit();
															#line 505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6761 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<FdbClientActor*>(this)->actor_wait_state = 3;
															#line 505 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 2, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6766 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& range,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(range, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && range,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(range), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 506 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Committed\n";
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6854 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FdbClientActor*>(this)->actor_wait_state = 4;
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 3, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6859 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 506 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		std::cout << "Committed\n";
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(2.0);
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		if (static_cast<FdbClientActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6872 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FdbClientActor*>(this)->actor_wait_state = 4;
															#line 507 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FdbClientActor, 3, Void >*>(static_cast<FdbClientActor*>(this)));
															#line 6877 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FdbClientActor*>(this)->actor_wait_state > 0) static_cast<FdbClientActor*>(this)->actor_wait_state = 0;
		static_cast<FdbClientActor*>(this)->ActorCallback< FdbClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FdbClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FdbClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 483 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Database db;
															#line 484 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Transaction tx;
															#line 485 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	std::string keyPrefix;
															#line 486 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key startKey;
															#line 487 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	KeyRef endKey;
															#line 488 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	int beginIdx;
															#line 7156 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via fdbClient()
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbClientActor final : public Actor<Void>, public ActorCallback< FdbClientActor, 0, Void >, public ActorCallback< FdbClientActor, 1, RangeResult >, public ActorCallback< FdbClientActor, 2, Void >, public ActorCallback< FdbClientActor, 3, Void >, public ActorCallback< FdbClientActor, 4, Void >, public FastAllocated<FdbClientActor>, public FdbClientActorState<FdbClientActor> {
															#line 7161 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<FdbClientActor>::operator new;
	using FastAllocated<FdbClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16785011393671003392UL, 15702251380179154176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FdbClientActor, 0, Void >;
friend struct ActorCallback< FdbClientActor, 1, RangeResult >;
friend struct ActorCallback< FdbClientActor, 2, Void >;
friend struct ActorCallback< FdbClientActor, 3, Void >;
friend struct ActorCallback< FdbClientActor, 4, Void >;
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbClientActor() 
															#line 7182 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   FdbClientActorState<FdbClientActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6395279393086184448UL, 2376111731338970624UL);
		ActorExecutionContextHelper __helper(static_cast<FdbClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FdbClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbClientActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FdbClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FdbClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FdbClientActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> fdbClient(  ) {
															#line 481 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new FdbClientActor());
															#line 7219 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 513 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

															#line 7224 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
namespace {
// This generated class is to be used only via fdbStatusStresser()
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
template <class FdbStatusStresserActor>
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbStatusStresserActorState {
															#line 7231 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbStatusStresserActorState() 
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		 : db(Database::createDatabase(clusterFile, 300)),
															#line 516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   tx(db),
															#line 517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
		   statusJson(std::string("\xff\xff/status/json"))
															#line 7242 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
	{
		fdb_probe_actor_create("fdbStatusStresser", reinterpret_cast<unsigned long>(this));

	}
	~FdbStatusStresserActorState() 
	{
		fdb_probe_actor_destroy("fdbStatusStresser", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 518 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			;
															#line 7257 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FdbStatusStresserActorState();
		static_cast<FdbStatusStresserActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 520 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			tx.reset();
															#line 521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tx.get(statusJson);
															#line 521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbStatusStresserActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7292 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FdbStatusStresserActor*>(this)->actor_wait_state = 1;
															#line 521 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*>(static_cast<FdbStatusStresserActor*>(this)));
															#line 7297 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 523 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tx.onError(e);
															#line 523 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			if (static_cast<FdbStatusStresserActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7321 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FdbStatusStresserActor*>(this)->actor_wait_state = 2;
															#line 523 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FdbStatusStresserActor, 1, Void >*>(static_cast<FdbStatusStresserActor*>(this)));
															#line 7326 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FdbStatusStresserActor*>(this)->actor_wait_state > 0) static_cast<FdbStatusStresserActor*>(this)->actor_wait_state = 0;
		static_cast<FdbStatusStresserActor*>(this)->ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FdbStatusStresserActor*>(this)->actor_wait_state > 0) static_cast<FdbStatusStresserActor*>(this)->actor_wait_state = 0;
		static_cast<FdbStatusStresserActor*>(this)->ActorCallback< FdbStatusStresserActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FdbStatusStresserActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FdbStatusStresserActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FdbStatusStresserActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 515 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Database db;
															#line 516 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	ReadYourWritesTransaction tx;
															#line 517 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	Key statusJson;
															#line 7530 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
};
// This generated class is to be used only via fdbStatusStresser()
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
class FdbStatusStresserActor final : public Actor<Void>, public ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >, public ActorCallback< FdbStatusStresserActor, 1, Void >, public FastAllocated<FdbStatusStresserActor>, public FdbStatusStresserActorState<FdbStatusStresserActor> {
															#line 7535 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
public:
	using FastAllocated<FdbStatusStresserActor>::operator new;
	using FastAllocated<FdbStatusStresserActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16638605735200293632UL, 10330489960706940160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >;
friend struct ActorCallback< FdbStatusStresserActor, 1, Void >;
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	FdbStatusStresserActor() 
															#line 7553 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
		 : Actor<Void>(),
		   FdbStatusStresserActorState<FdbStatusStresserActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fdbStatusStresser", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16978208003529881600UL, 843934910172209664UL);
		ActorExecutionContextHelper __helper(static_cast<FdbStatusStresserActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fdbStatusStresser");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fdbStatusStresser", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FdbStatusStresserActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FdbStatusStresserActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
[[nodiscard]] Future<Void> fdbStatusStresser(  ) {
															#line 514 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"
	return Future<Void>(new FdbStatusStresserActor());
															#line 7587 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/build_output/documentation/tutorial/tutorial.actor.g.cpp"
}

#line 527 "/codebuild/output/src2347226878/src/github.com/apple/foundationdb/documentation/tutorial/tutorial.actor.cpp"

std::unordered_map<std::string, std::function<Future<Void>()>> actors = {
	{ "timer", &simpleTimer }, // ./tutorial timer
	{ "promiseDemo", &promiseDemo }, // ./tutorial promiseDemo
	{ "triggerDemo", &triggerDemo }, // ./tutorial triggerDemo
	{ "echoServer", &echoServer }, // ./tutorial -p 6666 echoServer
	{ "echoClient", &echoClient }, // ./tutorial -s 127.0.0.1:6666 echoClient
	{ "kvStoreServer", &kvStoreServer }, // ./tutorial -p 6666 kvStoreServer
	{ "kvSimpleClient", &kvSimpleClient }, // ./tutorial -s 127.0.0.1:6666 kvSimpleClient
	{ "multipleClients", &multipleClients }, // ./tutorial -s 127.0.0.1:6666 multipleClients
	{ "fdbClientStream", &fdbClientStream }, // ./tutorial -C $CLUSTER_FILE_PATH fdbClientStream
	{ "fdbClientGetRange", &fdbClientGetRange }, // ./tutorial -C $CLUSTER_FILE_PATH fdbClientGetRange
	{ "fdbClient", &fdbClient }, // ./tutorial -C $CLUSTER_FILE_PATH fdbClient
	{ "fdbStatusStresser", &fdbStatusStresser }
}; // ./tutorial -C $CLUSTER_FILE_PATH fdbStatusStresser

int main(int argc, char* argv[]) {
	bool isServer = false;
	std::string port;
	std::vector<std::function<Future<Void>()>> toRun;
	// parse arguments
	for (int i = 1; i < argc; ++i) {
		std::string arg(argv[i]);
		if (arg == "-p") {
			isServer = true;
			if (i + 1 >= argc) {
				std::cout << "Expecting an argument after -p\n";
				return 1;
			}
			port = std::string(argv[++i]);
			continue;
		} else if (arg == "-s") {
			if (i + 1 >= argc) {
				std::cout << "Expecting an argument after -s\n";
				return 1;
			}
			serverAddress = NetworkAddress::parse(argv[++i]);
			continue;
		} else if (arg == "-C") {
			clusterFile = argv[++i];
			std::cout << "Using cluster file " << clusterFile << std::endl;
			continue;
		}
		auto actor = actors.find(arg);
		if (actor == actors.end()) {
			std::cout << format("Error: actor %s does not exist\n", arg.c_str());
			return 1;
		}
		toRun.push_back(actor->second);
	}
	platformInit();
	g_network = newNet2(TLSConfig(), false, true);
	FlowTransport::createInstance(!isServer, 0, WLTOKEN_COUNT_IN_TUTORIAL);
	NetworkAddress publicAddress = NetworkAddress::parse("0.0.0.0:0");
	if (isServer) {
		publicAddress = NetworkAddress::parse("0.0.0.0:" + port);
	}
	// openTraceFile(publicAddress, TRACE_DEFAULT_ROLL_SIZE,
	//              TRACE_DEFAULT_MAX_LOGS_SIZE);
	try {
		if (isServer) {
			auto listenError = FlowTransport::transport().bind(publicAddress, publicAddress);
			if (listenError.isError()) {
				listenError.get();
			}
		}
	} catch (Error& e) {
		std::cout << format("Error while binding to address (%d): %s\n", e.code(), e.what());
	}
	// now we start the actors
	std::vector<Future<Void>> all;
	all.reserve(toRun.size());
	for (auto& f : toRun) {
		all.emplace_back(f());
	}
	auto f = stopAfter(waitForAll(all));
	g_network->run();
	return 0;
}
