/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.TransactionContext;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.Versionstamp;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class TupleTest {
    private static final byte FF = -1;

    public static void main(String[] stringArray) throws NoSuchFieldException {
        try {
            FDB fDB = FDB.selectAPIVersion((int)740);
            try (Database database = fDB.open();){
                TupleTest.runTests(1000, (TransactionContext)database);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void incompleteVersionstamps300() {
        byte[] byArray;
        if (FDB.instance().getAPIVersion() >= 520) {
            throw new IllegalStateException("cannot run test with API version " + FDB.instance().getAPIVersion());
        }
        Tuple tuple = Tuple.from((Object[])new Object[]{Versionstamp.complete((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}), new byte[0]});
        Tuple tuple2 = Tuple.from((Object[])new Object[]{Versionstamp.incomplete()});
        if (tuple.equals((Object)tuple2)) {
            throw new RuntimeException("tuples " + tuple + " and " + tuple2 + " compared equal");
        }
        byte[] byArray2 = tuple.pack();
        if (!Arrays.equals(byArray2, byArray = tuple2.packWithVersionstamp())) {
            throw new RuntimeException("tuples " + tuple + " and " + tuple2 + " did not have matching representations");
        }
        if (tuple.equals((Object)tuple2)) {
            throw new RuntimeException("tuples " + tuple + " and " + tuple2 + " compared equal with memoized packed representations");
        }
        Tuple tuple3 = Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)1)});
        if (tuple3.getPackedSize() != 15) {
            throw new RuntimeException("incomplete versionstamp has incorrect packed size " + tuple3.getPackedSize());
        }
        byte[] byArray3 = tuple3.packWithVersionstamp();
        if (ByteBuffer.wrap(byArray3, byArray3.length - 2, 2).order(ByteOrder.LITTLE_ENDIAN).getShort() != 1) {
            throw new RuntimeException("incomplete versionstamp has incorrect position");
        }
        if (!Tuple.fromBytes((byte[])byArray3, (int)0, (int)(byArray3.length - 2)).equals((Object)Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)1)}))) {
            throw new RuntimeException("unpacked bytes did not match");
        }
        Subspace subspace = new Subspace(Tuple.from((Object[])new Object[]{"prefix"}));
        byte[] byArray4 = subspace.packWithVersionstamp(tuple3);
        if (ByteBuffer.wrap(byArray4, byArray4.length - 2, 2).order(ByteOrder.LITTLE_ENDIAN).getShort() != 1 + subspace.getKey().length) {
            throw new RuntimeException("incomplete versionstamp has incorrect position with prefix");
        }
        if (!Tuple.fromBytes((byte[])byArray4, (int)0, (int)(byArray4.length - 2)).equals((Object)Tuple.from((Object[])new Object[]{"prefix", Versionstamp.incomplete((int)1)}))) {
            throw new RuntimeException("unpacked bytes with subspace did not match");
        }
        Tuple tuple4 = Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)2)});
        byte[] byArray5 = tuple4.packWithVersionstamp();
        if (ByteBuffer.wrap(byArray5, byArray5.length - 2, 2).order(ByteOrder.LITTLE_ENDIAN).getShort() != 1) {
            throw new RuntimeException("incomplete versionstamp has incorrect position with prefix");
        }
        byte[] byArray6 = tuple4.packWithVersionstamp(new byte[65534]);
        if (!Arrays.equals(Arrays.copyOfRange(byArray5, 0, 13), Arrays.copyOfRange(byArray6, 65534, 65547))) {
            throw new RuntimeException("area before versionstamp offset did not match");
        }
        if ((ByteBuffer.wrap(byArray6, byArray6.length - 2, 2).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF) != 65535) {
            throw new RuntimeException("incomplete versionstamp has incorrect position with prefix");
        }
        try {
            tuple4.packWithVersionstamp(new byte[65535]);
            throw new RuntimeException("able to pack versionstamp with offset that is too large");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Tuple.from((Object[])new Object[]{Versionstamp.incomplete((int)3)}).packWithVersionstamp(new byte[65535]);
                throw new RuntimeException("able to pack versionstamp with offset that is too large");
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return;
            }
        }
    }

    private static void runTests(int n, TransactionContext transactionContext) {
        System.out.println("Running tests...");
        long l = System.currentTimeMillis();
        try {
            transactionContext.run(transaction -> {
                Tuple tuple = new Tuple();
                tuple.add(100230045000L);
                tuple.add("Hello!");
                tuple.add("foo".getBytes());
                return null;
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        System.out.println(" Transactions:    " + n);
        System.out.println(" Total Time:      " + d);
        System.out.println(" Gets+Sets / sec: " + (double)n / d);
        System.exit(0);
    }

    private TupleTest() {
    }
}

