/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.DatabaseOptions;
import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FakeFDBTransaction;
import com.apple.foundationdb.KeyRangeArrayResult;
import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.Tenant;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncIterable;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class RangeQueryTest {
    private static Executor EXECUTOR = new Executor(){

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    };

    RangeQueryTest() {
    }

    private static Database makeFakeDatabase(final List<Map.Entry<byte[], byte[]>> list) {
        return new Database(){
            private long txnCounter = 3L;

            public Transaction createTransaction() {
                long l = this.txnCounter++;
                return new FakeFDBTransaction(list, l, (Database)this, EXECUTOR);
            }

            protected void finalize() throws Throwable {
            }

            public void close() {
            }

            public Executor getExecutor() {
                throw new UnsupportedOperationException("Unimplemented method 'getExecutor'");
            }

            public Tenant openTenant(Tuple tuple) {
                throw new UnsupportedOperationException("Unimplemented method 'openTenant'");
            }

            public Tenant openTenant(byte[] byArray, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'openTenant'");
            }

            public Tenant openTenant(Tuple tuple, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'openTenant'");
            }

            public Tenant openTenant(byte[] byArray, Executor executor, EventKeeper eventKeeper) {
                throw new UnsupportedOperationException("Unimplemented method 'openTenant'");
            }

            public Tenant openTenant(Tuple tuple, Executor executor, EventKeeper eventKeeper) {
                throw new UnsupportedOperationException("Unimplemented method 'openTenant'");
            }

            public Transaction createTransaction(Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'createTransaction'");
            }

            public Transaction createTransaction(Executor executor, EventKeeper eventKeeper) {
                throw new UnsupportedOperationException("Unimplemented method 'createTransaction'");
            }

            public DatabaseOptions options() {
                throw new UnsupportedOperationException("Unimplemented method 'options'");
            }

            public double getMainThreadBusyness() {
                throw new UnsupportedOperationException("Unimplemented method 'getMainThreadBusyness'");
            }

            public CompletableFuture<byte[]> purgeBlobGranules(byte[] byArray, byte[] byArray2, long l, boolean bl, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'purgeBlobGranules'");
            }

            public CompletableFuture<Void> waitPurgeGranulesComplete(byte[] byArray, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'waitPurgeGranulesComplete'");
            }

            public CompletableFuture<Boolean> blobbifyRange(byte[] byArray, byte[] byArray2, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'blobbifyRange'");
            }

            public CompletableFuture<Boolean> blobbifyRangeBlocking(byte[] byArray, byte[] byArray2, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'blobbifyRangeBlocking'");
            }

            public CompletableFuture<Boolean> unblobbifyRange(byte[] byArray, byte[] byArray2, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'unblobbifyRange'");
            }

            public CompletableFuture<KeyRangeArrayResult> listBlobbifiedRanges(byte[] byArray, byte[] byArray2, int n, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'listBlobbifiedRanges'");
            }

            public CompletableFuture<Long> verifyBlobRange(byte[] byArray, byte[] byArray2, long l, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'verifyBlobRange'");
            }

            public CompletableFuture<Boolean> flushBlobRange(byte[] byArray, byte[] byArray2, boolean bl, long l, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'flushBlobRange'");
            }

            public <T> T read(Function<? super ReadTransaction, T> function, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'read'");
            }

            public <T> CompletableFuture<T> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<T>> function, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'readAsync'");
            }

            public <T> T run(Function<? super Transaction, T> function, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'run'");
            }

            public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> function, Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'runAsync'");
            }

            public CompletableFuture<byte[]> getClientStatus(Executor executor) {
                throw new UnsupportedOperationException("Unimplemented method 'getClientStatus'");
            }
        };
    }

    @ParameterizedTest
    @EnumSource(value=StreamingMode.class)
    void testRangeScansWorkWithoutRowLimit(StreamingMode streamingMode) throws Exception {
        ArrayList<Map.Entry<byte[], byte[]>> arrayList = new ArrayList<Map.Entry<byte[], byte[]>>();
        for (int i = 0; i < 10; ++i) {
            arrayList.add(new AbstractMap.SimpleEntry<byte[], byte[]>(("apple" + i).getBytes(), ("crunchy" + i).getBytes()));
        }
        try (Database database = RangeQueryTest.makeFakeDatabase(arrayList);
             Transaction transaction = database.createTransaction();){
            byte[] byArray = (byte[])transaction.get("apple4".getBytes()).join();
            Assertions.assertNotNull((Object)byArray, (String)"Missing entry for 'apple4'!");
            Assertions.assertArrayEquals((byte[])byArray, (byte[])"crunchy4".getBytes(), (String)"incorrect entry for 'apple4'~");
            AsyncIterable asyncIterable = transaction.getRange("a".getBytes(), "b".getBytes(), 0, false, streamingMode);
            List list = (List)asyncIterable.asList().join();
            for (Map.Entry entry : arrayList) {
                boolean bl = false;
                for (KeyValue keyValue : list) {
                    if (ByteArrayUtil.compareTo((byte[])((byte[])entry.getKey()), (int)0, (int)((byte[])entry.getKey()).length, (byte[])keyValue.getKey(), (int)0, (int)keyValue.getKey().length) != 0) continue;
                    String string = String.format("Incorrect value for key '%s'; Expected: <%s>, Actual: <%s>", new String((byte[])entry.getKey()), new String((byte[])entry.getValue()), new String(keyValue.getValue()));
                    Assertions.assertEquals((int)0, (int)ByteArrayUtil.compareTo((byte[])((byte[])entry.getValue()), (int)0, (int)((byte[])entry.getValue()).length, (byte[])keyValue.getValue(), (int)0, (int)keyValue.getValue().length), (String)string);
                    bl = true;
                    break;
                }
                Assertions.assertTrue((boolean)bl, (String)("Did not find key '" + new String((byte[])entry.getKey()) + "'"));
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=StreamingMode.class)
    void testRangeScansWorkWithRowLimit(StreamingMode streamingMode) throws Exception {
        ArrayList<Map.Entry<byte[], byte[]>> arrayList = new ArrayList<Map.Entry<byte[], byte[]>>();
        for (int i = 0; i < 10; ++i) {
            arrayList.add(new AbstractMap.SimpleEntry<byte[], byte[]>(("apple" + i).getBytes(), ("crunchy" + i).getBytes()));
        }
        try (Database database = RangeQueryTest.makeFakeDatabase(arrayList);
             Transaction transaction = database.createTransaction();){
            byte[] byArray = (byte[])transaction.get("apple4".getBytes()).join();
            Assertions.assertNotNull((Object)byArray, (String)"Missing entry for 'apple4'!");
            Assertions.assertArrayEquals((byte[])byArray, (byte[])"crunchy4".getBytes(), (String)"incorrect entry for 'apple4'~");
            int n = 3;
            AsyncIterable asyncIterable = transaction.getRange("a".getBytes(), "b".getBytes(), n, false, streamingMode);
            List list = (List)asyncIterable.asList().join();
            Assertions.assertEquals((int)n, (int)list.size(), (String)"incorrect number of kvs returned!");
            int n2 = 0;
            for (Map.Entry entry : arrayList) {
                boolean bl = false;
                for (KeyValue keyValue : list) {
                    if (ByteArrayUtil.compareTo((byte[])((byte[])entry.getKey()), (int)0, (int)((byte[])entry.getKey()).length, (byte[])keyValue.getKey(), (int)0, (int)keyValue.getKey().length) != 0) continue;
                    String string = String.format("Incorrect value for key '%s'; Expected: <%s>, Actual: <%s>", new String((byte[])entry.getKey()), new String((byte[])entry.getValue()), new String(keyValue.getValue()));
                    Assertions.assertEquals((int)0, (int)ByteArrayUtil.compareTo((byte[])((byte[])entry.getValue()), (int)0, (int)((byte[])entry.getValue()).length, (byte[])keyValue.getValue(), (int)0, (int)keyValue.getValue().length), (String)string);
                    bl = true;
                    break;
                }
                Assertions.assertTrue((boolean)bl, (String)("Did not find key '" + new String((byte[])entry.getKey()) + "'"));
                if (++n2 != n) continue;
                break;
            }
            Assertions.assertEquals((int)1, (int)((FakeFDBTransaction)transaction).getNumRangeCalls(), (String)"Did not do the correct number of range requests");
        }
    }

    @ParameterizedTest
    @EnumSource(value=StreamingMode.class)
    void testRangeScansWorkWithoutRowLimitReversed(StreamingMode streamingMode) throws Exception {
        ArrayList<Map.Entry<byte[], byte[]>> arrayList = new ArrayList<Map.Entry<byte[], byte[]>>();
        for (int i = 0; i < 10; ++i) {
            arrayList.add(new AbstractMap.SimpleEntry<byte[], byte[]>(("apple" + i).getBytes(), ("crunchy" + i).getBytes()));
        }
        try (Database database = RangeQueryTest.makeFakeDatabase(arrayList);
             Transaction transaction = database.createTransaction();){
            byte[] byArray = (byte[])transaction.get("apple4".getBytes()).join();
            Assertions.assertNotNull((Object)byArray, (String)"Missing entry for 'apple4'!");
            Assertions.assertArrayEquals((byte[])byArray, (byte[])"crunchy4".getBytes(), (String)"incorrect entry for 'apple4'~");
            AsyncIterable asyncIterable = transaction.getRange("a".getBytes(), "b".getBytes(), 0, true, streamingMode);
            List list = (List)asyncIterable.asList().join();
            for (Map.Entry entry : arrayList) {
                boolean bl = false;
                for (KeyValue keyValue : list) {
                    if (ByteArrayUtil.compareTo((byte[])((byte[])entry.getKey()), (int)0, (int)((byte[])entry.getKey()).length, (byte[])keyValue.getKey(), (int)0, (int)keyValue.getKey().length) != 0) continue;
                    String string = String.format("Incorrect value for key '%s'; Expected: <%s>, Actual: <%s>", new String((byte[])entry.getKey()), new String((byte[])entry.getValue()), new String(keyValue.getValue()));
                    Assertions.assertEquals((int)0, (int)ByteArrayUtil.compareTo((byte[])((byte[])entry.getValue()), (int)0, (int)((byte[])entry.getValue()).length, (byte[])keyValue.getValue(), (int)0, (int)keyValue.getValue().length), (String)string);
                    bl = true;
                    break;
                }
                Assertions.assertTrue((boolean)bl, (String)("Did not find key '" + new String((byte[])entry.getKey()) + "'"));
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=StreamingMode.class)
    void testRangeScansWorkWithRowLimitReversed(StreamingMode streamingMode) throws Exception {
        TreeMap<byte[], byte[]> treeMap = new TreeMap<byte[], byte[]>(ByteArrayUtil.comparator());
        for (int i = 0; i < 10; ++i) {
            treeMap.put(("apple" + i).getBytes(), ("crunchy" + i).getBytes());
        }
        try (Database database = RangeQueryTest.makeFakeDatabase(new ArrayList<Map.Entry<byte[], byte[]>>(treeMap.entrySet()));
             Transaction transaction = database.createTransaction();){
            byte[] byArray = (byte[])transaction.get("apple4".getBytes()).join();
            Assertions.assertNotNull((Object)byArray, (String)"Missing entry for 'apple4'!");
            Assertions.assertArrayEquals((byte[])byArray, (byte[])"crunchy4".getBytes(), (String)"incorrect entry for 'apple4'~");
            int n = 3;
            AsyncIterable asyncIterable = transaction.getRange("a".getBytes(), "b".getBytes(), n, true, streamingMode);
            List list = (List)asyncIterable.asList().join();
            Assertions.assertEquals((int)n, (int)list.size(), (String)"incorrect number of kvs returned!");
            int n2 = 0;
            for (Map.Entry entry : treeMap.descendingMap().entrySet()) {
                boolean bl = false;
                for (KeyValue keyValue : list) {
                    if (ByteArrayUtil.compareTo((byte[])((byte[])entry.getKey()), (int)0, (int)((byte[])entry.getKey()).length, (byte[])keyValue.getKey(), (int)0, (int)keyValue.getKey().length) != 0) continue;
                    String string = String.format("Incorrect value for key '%s'; Expected: <%s>, Actual: <%s>", new String((byte[])entry.getKey()), new String((byte[])entry.getValue()), new String(keyValue.getValue()));
                    Assertions.assertEquals((int)0, (int)ByteArrayUtil.compareTo((byte[])((byte[])entry.getValue()), (int)0, (int)((byte[])entry.getValue()).length, (byte[])keyValue.getValue(), (int)0, (int)keyValue.getValue().length), (String)string);
                    bl = true;
                    break;
                }
                Assertions.assertTrue((boolean)bl, (String)("Did not find key '" + new String((byte[])entry.getKey()) + "'"));
                if (++n2 != n) continue;
                break;
            }
            Assertions.assertEquals((int)1, (int)((FakeFDBTransaction)transaction).getNumRangeCalls(), (String)"Did not do the correct number of range requests");
        }
    }
}

