/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class ContinuousSample<T extends Number> {
    private Random random = new Random();
    private int sampleSize;
    private long populationSize;
    private boolean sorted;
    private List<T> samples;
    private T min;
    private T max;

    public ContinuousSample(int n) {
        this.sampleSize = n;
        this.samples = new ArrayList<T>(n);
        this.populationSize = 0L;
        this.sorted = true;
    }

    public ContinuousSample<T> addSample(T t) {
        if (this.populationSize == 0L) {
            this.max = t;
            this.min = this.max;
        }
        ++this.populationSize;
        this.sorted = false;
        if (this.populationSize <= (long)this.sampleSize) {
            this.samples.add(t);
        } else if (this.random.nextDouble() < (double)this.sampleSize / (double)this.populationSize) {
            this.samples.add(this.random.nextInt(this.sampleSize), t);
        }
        this.max = ((Comparable)t).compareTo(this.max) > 0 ? t : this.max;
        this.min = ((Comparable)t).compareTo(this.min) < 0 ? t : this.min;
        return this;
    }

    public double mean() {
        if (this.samples.size() == 0) {
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.samples.size(); ++i) {
            d += ((Number)this.samples.get(i)).doubleValue();
        }
        return d / (double)this.samples.size();
    }

    public T median() {
        return this.percentile(0.5);
    }

    public T percentile(double d) {
        if (this.samples.size() == 0 || d < 0.0 || d > 1.0) {
            return null;
        }
        this.sort();
        int n = (int)Math.floor((double)(this.samples.size() - 1) * d);
        return (T)((Number)this.samples.get(n));
    }

    public T min() {
        return this.min;
    }

    public T max() {
        return this.max;
    }

    public String toString() {
        return String.format("Mean: %.2f, Median: %.2f, 90%%: %.2f, 98%%: %.2f", this.mean(), this.median(), this.percentile(0.9), this.percentile(0.98));
    }

    private void sort() {
        if (!this.sorted && this.samples.size() > 1) {
            Collections.sort(this.samples);
        }
        this.sorted = true;
    }
}

