#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
/*
 * DecommissionMetacluster.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_DECOMMISSIONMETACLUSTER_ACTOR_G_H)
#define METACLUSTER_DECOMMISSIONMETACLUSTER_ACTOR_G_H
#include "metacluster/DecommissionMetacluster.actor.g.h"
#elif !defined(METACLUSTER_DECOMMISSIONMETACLUSTER_ACTOR_H)
#define METACLUSTER_DECOMMISSIONMETACLUSTER_ACTOR_H

#include "fdbclient/TenantManagement.actor.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterInternal.actor.h"
#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

															#line 41 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
// This generated class is to be used only via decommissionMetacluster()
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
template <class DB, class DecommissionMetaclusterActor>
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
class DecommissionMetaclusterActorState {
															#line 47 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
public:
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
	DecommissionMetaclusterActorState(Reference<DB> const& db) 
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		 : db(db),
															#line 41 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		   tr(db->createTransaction()),
															#line 42 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		   firstTry(true)
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
	{
		fdb_probe_actor_create("decommissionMetacluster", reinterpret_cast<unsigned long>(this));

	}
	~DecommissionMetaclusterActorState() 
	{
		fdb_probe_actor_destroy("decommissionMetacluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			;
															#line 73 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DecommissionMetaclusterActorState();
		static_cast<DecommissionMetaclusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 79 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		if (!static_cast<DecommissionMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DecommissionMetaclusterActorState(); static_cast<DecommissionMetaclusterActor*>(this)->destroy(); return 0; }
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		new (&static_cast<DecommissionMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DecommissionMetaclusterActorState();
		static_cast<DecommissionMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 46 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 48 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			StrictFuture<ClusterType> __when_expr_0 = TenantAPI::getClusterType(tr);
															#line 48 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 1;
															#line 48 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DecommissionMetaclusterActor, 0, ClusterType >*>(static_cast<DecommissionMetaclusterActor*>(this)));
															#line 125 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 74 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			CODE_PROBE(e.code() == error_code_cluster_not_empty, "Decommission non-empty metacluster");
															#line 75 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 75 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 164 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 4;
															#line 75 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DecommissionMetaclusterActor, 3, Void >*>(static_cast<DecommissionMetaclusterActor*>(this)));
															#line 169 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(ClusterType const& clusterType,int loopDepth) 
	{
															#line 49 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		if (clusterType != ClusterType::METACLUSTER_MANAGEMENT)
															#line 184 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		{
															#line 50 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			if (firstTry)
															#line 188 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			{
															#line 51 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
				CODE_PROBE(true, "Decommission non-metacluster");
															#line 52 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
				return a_body1loopBody1Catch1(invalid_metacluster_operation(), loopDepth);
															#line 194 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			}
			else
			{
															#line 54 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
				CODE_PROBE(true, "Decommission retrying after success");
															#line 55 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
				if (!static_cast<DecommissionMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DecommissionMetaclusterActorState(); static_cast<DecommissionMetaclusterActor*>(this)->destroy(); return 0; }
															#line 202 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
				new (&static_cast<DecommissionMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DecommissionMetaclusterActorState();
				static_cast<DecommissionMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 61 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().tenantCount.clear(tr);
															#line 62 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().lastTenantId.clear(tr);
															#line 63 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().tenantTombstones.clear(tr);
															#line 64 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().tombstoneCleanupData.clear(tr);
															#line 65 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.clear(tr);
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		StrictFuture<Void> __when_expr_1 = internal::managementClusterCheckEmpty(tr);
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 223 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecommissionMetaclusterActor, 1, Void >*>(static_cast<DecommissionMetaclusterActor*>(this)));
															#line 228 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(ClusterType && clusterType,int loopDepth) 
	{
															#line 49 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		if (clusterType != ClusterType::METACLUSTER_MANAGEMENT)
															#line 237 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		{
															#line 50 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
			if (firstTry)
															#line 241 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			{
															#line 51 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
				CODE_PROBE(true, "Decommission non-metacluster");
															#line 52 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
				return a_body1loopBody1Catch1(invalid_metacluster_operation(), loopDepth);
															#line 247 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
			}
			else
			{
															#line 54 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
				CODE_PROBE(true, "Decommission retrying after success");
															#line 55 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
				if (!static_cast<DecommissionMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DecommissionMetaclusterActorState(); static_cast<DecommissionMetaclusterActor*>(this)->destroy(); return 0; }
															#line 255 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
				new (&static_cast<DecommissionMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~DecommissionMetaclusterActorState();
				static_cast<DecommissionMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 61 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().tenantCount.clear(tr);
															#line 62 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().lastTenantId.clear(tr);
															#line 63 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().tenantTombstones.clear(tr);
															#line 64 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().tombstoneCleanupData.clear(tr);
															#line 65 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::management::tenantMetadata().lastTenantModification.clear(tr);
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		StrictFuture<Void> __when_expr_1 = internal::managementClusterCheckEmpty(tr);
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 276 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DecommissionMetaclusterActor, 1, Void >*>(static_cast<DecommissionMetaclusterActor*>(this)));
															#line 281 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType const& clusterType,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(clusterType, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ClusterType && clusterType,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(clusterType), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DecommissionMetaclusterActor*>(this)->ActorCallback< DecommissionMetaclusterActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DecommissionMetaclusterActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::metaclusterRegistration().clear(tr);
															#line 70 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		firstTry = false;
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		StrictFuture<Void> __when_expr_2 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 371 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DecommissionMetaclusterActor, 2, Void >*>(static_cast<DecommissionMetaclusterActor*>(this)));
															#line 376 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		metadata::metaclusterRegistration().clear(tr);
															#line 70 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		firstTry = false;
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		StrictFuture<Void> __when_expr_2 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 391 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DecommissionMetaclusterActor, 2, Void >*>(static_cast<DecommissionMetaclusterActor*>(this)));
															#line 396 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DecommissionMetaclusterActor*>(this)->ActorCallback< DecommissionMetaclusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DecommissionMetaclusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DecommissionMetaclusterActor*>(this)->ActorCallback< DecommissionMetaclusterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DecommissionMetaclusterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DecommissionMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DecommissionMetaclusterActor*>(this)->ActorCallback< DecommissionMetaclusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DecommissionMetaclusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DecommissionMetaclusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
	Reference<DB> db;
															#line 41 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 42 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
	bool firstTry;
															#line 656 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
};
// This generated class is to be used only via decommissionMetacluster()
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
template <class DB>
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
class DecommissionMetaclusterActor final : public Actor<Void>, public ActorCallback< DecommissionMetaclusterActor<DB>, 0, ClusterType >, public ActorCallback< DecommissionMetaclusterActor<DB>, 1, Void >, public ActorCallback< DecommissionMetaclusterActor<DB>, 2, Void >, public ActorCallback< DecommissionMetaclusterActor<DB>, 3, Void >, public FastAllocated<DecommissionMetaclusterActor<DB>>, public DecommissionMetaclusterActorState<DB, DecommissionMetaclusterActor<DB>> {
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
public:
	using FastAllocated<DecommissionMetaclusterActor<DB>>::operator new;
	using FastAllocated<DecommissionMetaclusterActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3219461138593894144UL, 8426840437402891776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DecommissionMetaclusterActor<DB>, 0, ClusterType >;
friend struct ActorCallback< DecommissionMetaclusterActor<DB>, 1, Void >;
friend struct ActorCallback< DecommissionMetaclusterActor<DB>, 2, Void >;
friend struct ActorCallback< DecommissionMetaclusterActor<DB>, 3, Void >;
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
	DecommissionMetaclusterActor(Reference<DB> const& db) 
															#line 683 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
		 : Actor<Void>(),
		   DecommissionMetaclusterActorState<DB, DecommissionMetaclusterActor<DB>>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("decommissionMetacluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13487502973662777088UL, 11711500406943873536UL);
		ActorExecutionContextHelper __helper(static_cast<DecommissionMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("decommissionMetacluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("decommissionMetacluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DecommissionMetaclusterActor<DB>, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DecommissionMetaclusterActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DecommissionMetaclusterActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DecommissionMetaclusterActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
template <class DB>
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
[[nodiscard]] Future<Void> decommissionMetacluster( Reference<DB> const& db ) {
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"
	return Future<Void>(new DecommissionMetaclusterActor<DB>(db));
															#line 720 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/DecommissionMetacluster.actor.g.h"
}

#line 81 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/metacluster/include/metacluster/DecommissionMetacluster.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif