#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
/*
 * AtomicSwitchover.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// A workload which test the correctness of backup and restore process
struct AtomicSwitchoverWorkload : TestWorkload {
	static constexpr auto NAME = "AtomicSwitchover";
	double switch1delay, switch2delay, stopDelay;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	Database extraDB;

	AtomicSwitchoverWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {

		switch1delay = getOption(options, "switch1delay"_sr, 50.0);
		switch2delay = getOption(options, "switch2delay"_sr, 50.0);
		stopDelay = getOption(options, "stopDelay"_sr, 50.0);

		addDefaultBackupRanges(backupRanges);

		ASSERT(g_simulator->extraDatabases.size() == 1);
		extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0], wcx.defaultTenant);
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _setup(cx, this);
	}

																#line 55 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
template <class _setupActor>
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
class _setupActorState {
															#line 61 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
public:
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	_setupActorState(Database const& cx,AtomicSwitchoverWorkload* const& self) 
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		 : cx(cx),
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   self(self),
															#line 54 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   backupAgent(cx)
															#line 72 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 56 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				TraceEvent("AS_Submit1").log();
															#line 57 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.submitBackup(self->extraDB, BackupAgentBase::getDefaultTag(), self->backupRanges, StopWhenDone::False, StringRef(), StringRef(), LockDB::True);
															#line 57 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 92 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 57 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 97 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 69 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 66 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			if (e.code() != error_code_backup_duplicate)
															#line 139 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			{
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 143 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Submit2").log();
															#line 159 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Submit2").log();
															#line 168 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Database cx;
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	AtomicSwitchoverWorkload* self;
															#line 54 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 267 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 272 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10302997122562870016UL, 11418408341795428608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	_setupActor(Database const& cx,AtomicSwitchoverWorkload* const& self) 
															#line 289 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, AtomicSwitchoverWorkload* const& self ) {
															#line 53 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 321 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
}

#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 336 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
// This generated class is to be used only via diffRanges()
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
template <class DiffRangesActor>
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
class DiffRangesActorState {
															#line 342 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	DiffRangesActorState(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		 : ranges(ranges),
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   backupPrefix(backupPrefix),
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   src(src),
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   dest(dest),
															#line 86 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   rangeIndex()
															#line 357 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
	{
		fdb_probe_actor_create("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	~DiffRangesActorState() 
	{
		fdb_probe_actor_destroy("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			rangeIndex = 0;
															#line 372 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 163 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (!static_cast<DiffRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiffRangesActorState(); static_cast<DiffRangesActor*>(this)->destroy(); return 0; }
															#line 395 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		new (&static_cast<DiffRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 87 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (!(rangeIndex < ranges.size()))
															#line 414 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 88 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		range = ranges[rangeIndex];
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		begin = range.begin;
															#line 90 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		;
															#line 424 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 87 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		++rangeIndex;
															#line 446 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		tr = Transaction(src);
															#line 92 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		tr2 = Transaction(dest);
															#line 464 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		try {
															#line 94 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			;
															#line 468 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 158 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 158 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 505 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DiffRangesActor*>(this)->actor_wait_state = 2;
															#line 158 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 1, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 510 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 95 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		srcFuture = tr.getRange(KeyRangeRef(begin, range.end), 1000);
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		bkpFuture = tr2.getRange(KeyRangeRef(begin, range.end).withPrefix(backupPrefix), 1000);
															#line 98 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(srcFuture) && success(bkpFuture);
															#line 98 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 544 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DiffRangesActor*>(this)->actor_wait_state = 1;
															#line 98 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 0, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 549 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 101 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 104 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 105 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 579 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			{
															#line 106 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 583 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			}
			else
			{
															#line 111 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				if (src->key != bkpKey)
															#line 589 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				{
															#line 112 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 593 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				}
				else
				{
															#line 117 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
					if (src->value != bkp->value)
															#line 599 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
					{
															#line 118 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 603 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
					}
				}
			}
															#line 124 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 125 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			if (src->key == bkpKey)
															#line 611 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			{
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				++src;
															#line 127 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				++bkp;
															#line 617 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			}
			else
			{
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				if (src->key < bkpKey)
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				{
															#line 129 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
					++src;
															#line 627 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				}
				else
				{
															#line 131 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
					++bkp;
															#line 633 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				}
			}
		}
															#line 134 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 135 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 138 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			begin = src->key;
															#line 139 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			++src;
															#line 645 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		}
															#line 141 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 142 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 145 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			begin = bkp->key;
															#line 146 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			++bkp;
															#line 655 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		}
															#line 149 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 659 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 153 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		begin = keyAfter(begin);
															#line 665 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 101 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 104 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 105 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 682 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			{
															#line 106 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 686 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			}
			else
			{
															#line 111 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				if (src->key != bkpKey)
															#line 692 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				{
															#line 112 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 696 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				}
				else
				{
															#line 117 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
					if (src->value != bkp->value)
															#line 702 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
					{
															#line 118 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 706 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
					}
				}
			}
															#line 124 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 125 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			if (src->key == bkpKey)
															#line 714 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			{
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				++src;
															#line 127 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				++bkp;
															#line 720 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			}
			else
			{
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
				if (src->key < bkpKey)
															#line 726 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				{
															#line 129 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
					++src;
															#line 730 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				}
				else
				{
															#line 131 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
					++bkp;
															#line 736 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
				}
			}
		}
															#line 134 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 135 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 138 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			begin = src->key;
															#line 139 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			++src;
															#line 748 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		}
															#line 141 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 142 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 145 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			begin = bkp->key;
															#line 146 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			++bkp;
															#line 758 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		}
															#line 149 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 762 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 153 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		begin = keyAfter(begin);
															#line 768 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	StringRef backupPrefix;
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Database src;
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Database dest;
															#line 86 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	int rangeIndex;
															#line 88 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	KeyRangeRef range;
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Key begin;
															#line 91 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Transaction tr;
															#line 92 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Transaction tr2;
															#line 95 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Future<RangeResult> srcFuture;
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Future<RangeResult> bkpFuture;
															#line 957 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
};
// This generated class is to be used only via diffRanges()
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
class DiffRangesActor final : public Actor<Void>, public ActorCallback< DiffRangesActor, 0, Void >, public ActorCallback< DiffRangesActor, 1, Void >, public FastAllocated<DiffRangesActor>, public DiffRangesActorState<DiffRangesActor> {
															#line 962 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
public:
	using FastAllocated<DiffRangesActor>::operator new;
	using FastAllocated<DiffRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15311198881289459968UL, 9115370583622122496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiffRangesActor, 0, Void >;
friend struct ActorCallback< DiffRangesActor, 1, Void >;
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	DiffRangesActor(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 980 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		 : Actor<Void>(),
		   DiffRangesActorState<DiffRangesActor>(ranges, backupPrefix, src, dest),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14464715535444249600UL, 3030925669057132800UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("diffRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiffRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DiffRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
[[nodiscard]] static Future<Void> diffRanges( Standalone<VectorRef<KeyRangeRef>> const& ranges, StringRef const& backupPrefix, Database const& src, Database const& dest ) {
															#line 82 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	return Future<Void>(new DiffRangesActor(ranges, backupPrefix, src, dest));
															#line 1013 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
}

#line 165 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"

																#line 1018 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
template <class _startActor>
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
class _startActorState {
															#line 1024 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
public:
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	_startActorState(Database const& cx,AtomicSwitchoverWorkload* const& self) 
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		 : cx(cx),
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   self(self),
															#line 167 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   backupAgent(cx),
															#line 168 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		   restoreTool(self->extraDB)
															#line 1037 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 170 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			TraceEvent("AS_Wait1").log();
															#line 171 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(backupAgent.waitBackup(self->extraDB, BackupAgentBase::getDefaultTag(), StopWhenDone::False));
															#line 171 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1056 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 171 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1061 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 172 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Ready1").log();
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(deterministicRandom()->random01() * self->switch1delay);
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1088 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1093 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 172 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Ready1").log();
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(deterministicRandom()->random01() * self->switch1delay);
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1106 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1111 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 174 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Switch1").log();
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent.atomicSwitchover( self->extraDB, BackupAgentBase::getDefaultTag(), self->backupRanges, StringRef(), StringRef());
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1199 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1204 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 174 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Switch1").log();
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent.atomicSwitchover( self->extraDB, BackupAgentBase::getDefaultTag(), self->backupRanges, StringRef(), StringRef());
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1217 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1222 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Wait2").log();
															#line 178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(restoreTool.waitBackup(cx, BackupAgentBase::getDefaultTag(), StopWhenDone::False));
															#line 178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1310 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1315 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Wait2").log();
															#line 178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_3 = success(restoreTool.waitBackup(cx, BackupAgentBase::getDefaultTag(), StopWhenDone::False));
															#line 178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1328 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1333 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 179 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Ready2").log();
															#line 180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(deterministicRandom()->random01() * self->switch2delay);
															#line 180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1421 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1426 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 179 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Ready2").log();
															#line 180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(deterministicRandom()->random01() * self->switch2delay);
															#line 180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1439 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1444 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 181 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Switch2").log();
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_5 = restoreTool.atomicSwitchover( cx, BackupAgentBase::getDefaultTag(), self->backupRanges, StringRef(), StringRef());
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1532 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1537 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 181 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Switch2").log();
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_5 = restoreTool.atomicSwitchover( cx, BackupAgentBase::getDefaultTag(), self->backupRanges, StringRef(), StringRef());
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1550 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1555 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Wait3").log();
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(backupAgent.waitBackup(self->extraDB, BackupAgentBase::getDefaultTag(), StopWhenDone::False));
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1643 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1648 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Wait3").log();
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(backupAgent.waitBackup(self->extraDB, BackupAgentBase::getDefaultTag(), StopWhenDone::False));
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1661 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont6when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1666 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 186 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Ready3").log();
															#line 187 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_7 = delay(deterministicRandom()->random01() * self->stopDelay);
															#line 187 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1754 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 187 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 1759 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 186 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Ready3").log();
															#line 187 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_7 = delay(deterministicRandom()->random01() * self->stopDelay);
															#line 187 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1772 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont7when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 187 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 1777 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 188 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Abort").log();
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_8 = backupAgent.abortBackup(self->extraDB, BackupAgentBase::getDefaultTag());
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1865 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 1870 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 188 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Abort").log();
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		StrictFuture<Void> __when_expr_8 = backupAgent.abortBackup(self->extraDB, BackupAgentBase::getDefaultTag());
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1883 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 1888 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Done").log();
															#line 193 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB)
															#line 1974 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		{
															#line 194 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 1978 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		}
															#line 197 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1982 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 190 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		TraceEvent("AS_Done").log();
															#line 193 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB)
															#line 1996 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		{
															#line 194 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 2000 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		}
															#line 197 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2004 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	Database cx;
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	AtomicSwitchoverWorkload* self;
															#line 167 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 168 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	DatabaseBackupAgent restoreTool;
															#line 2095 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16513071148724218624UL, 1759388822822310400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	_startActor(Database const& cx,AtomicSwitchoverWorkload* const& self) 
															#line 2125 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, AtomicSwitchoverWorkload* const& self ) {
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 2165 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/AtomicSwitchover.actor.g.cpp"
}

#line 199 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/workloads/AtomicSwitchover.actor.cpp"
};

WorkloadFactory<AtomicSwitchoverWorkload> AtomicSwitchoverWorkloadFactory;
