#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
/*
 * masterserver.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <iterator>

#include "fdbrpc/sim_validation.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h" // copy constructors for ServerCoordinators class
#include "fdbserver/Knobs.h"
#include "fdbserver/MasterInterface.h"
#include "fdbserver/ResolutionBalancer.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "flow/ActorCollection.h"
#include "flow/Trace.h"
#include "flow/swift_support.h"
#include "fdbclient/VersionVector.h"
#include "fdbserver/MasterData.actor.h"

#ifdef WITH_SWIFT
#include "SwiftModules/FDBServer"
#endif

#include "flow/actorcompiler.h" // This must be the last #include.

// Instantiate MasterInterface related templates
template class ReplyPromise<MasterInterface>;
template struct NetSAV<MasterInterface>;

// Instantiate ServerDBInfo related templates
template class GetEncryptCipherKeys<struct ServerDBInfo>;

void updateLiveCommittedVersion(Reference<MasterData> self, ReportRawCommittedVersionRequest req);

Version figureVersionCxx(Version current,
                         double now,
                         Version reference,
                         int64_t toAdd,
                         double maxVersionRateModifier,
                         int64_t maxVersionRateOffset) {
	// Versions should roughly follow wall-clock time, based on the
	// system clock of the current machine and an FDB-specific epoch.
	// Calculate the expected version and determine whether we need to
	// hand out versions faster or slower to stay in sync with the
	// clock.
	Version expected = now * SERVER_KNOBS->VERSIONS_PER_SECOND - reference;

	// Attempt to jump directly to the expected version. But make
	// sure that versions are still being handed out at a rate
	// around VERSIONS_PER_SECOND. This rate is scaled depending on
	// how far off the calculated version is from the expected
	// version.
	int64_t maxOffset = std::min(static_cast<int64_t>(toAdd * maxVersionRateModifier), maxVersionRateOffset);
	return std::clamp(expected, current + toAdd - maxOffset, current + toAdd + maxOffset);
}

#ifdef WITH_SWIFT
Version figureVersion(Version current,
                      double now,
                      Version reference,
                      int64_t toAdd,
                      double maxVersionRateModifier,
                      int64_t maxVersionRateOffset) {
	auto impl = SERVER_KNOBS->FLOW_WITH_SWIFT ? fdbserver_swift::figureVersion : figureVersionCxx;
	return impl(current, now, reference, toAdd, maxVersionRateModifier, maxVersionRateOffset);
}
#else
Version figureVersion(Version current,
                      double now,
                      Version reference,
                      int64_t toAdd,
                      double maxVersionRateModifier,
                      int64_t maxVersionRateOffset) {
	return figureVersionCxx(current, now, reference, toAdd, maxVersionRateModifier, maxVersionRateOffset);
}
#endif

#ifdef WITH_SWIFT
															#line 98 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForPrev()
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class WaitForPrevActor>
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class WaitForPrevActorState {
															#line 105 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	WaitForPrevActorState(Reference<MasterData> const& self,ReportRawCommittedVersionRequest const& req) 
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req)
															#line 114 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForPrev", reinterpret_cast<unsigned long>(this));

	}
	~WaitForPrevActorState() 
	{
		fdb_probe_actor_destroy("waitForPrev", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 129 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 98 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				auto future = self->swiftImpl->waitForPrev(self.getPtr(), req);
															#line 99 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = future;
															#line 99 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<WaitForPrevActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 137 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitForPrevActor*>(this)->actor_wait_state = 1;
															#line 99 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForPrevActor, 0, Void >*>(static_cast<WaitForPrevActor*>(this)));
															#line 142 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 101 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				startTime = now();
															#line 102 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = self->liveCommittedVersion.whenAtLeast(req.prevVersion.get());
															#line 102 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<WaitForPrevActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 153 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<WaitForPrevActor*>(this)->actor_wait_state = 2;
															#line 102 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForPrevActor, 1, Void >*>(static_cast<WaitForPrevActor*>(this)));
															#line 158 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForPrevActorState();
		static_cast<WaitForPrevActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 110 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<WaitForPrevActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPrevActorState(); static_cast<WaitForPrevActor*>(this)->destroy(); return 0; }
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<WaitForPrevActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForPrevActorState();
		static_cast<WaitForPrevActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForPrevActor*>(this)->actor_wait_state > 0) static_cast<WaitForPrevActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForPrevActor*>(this)->ActorCallback< WaitForPrevActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForPrevActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		double latency = now() - startTime;
															#line 104 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->waitForPrevLatencies->addMeasurement(latency);
															#line 105 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->waitForPrevCommitRequests;
															#line 106 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		updateLiveCommittedVersion(self, req);
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 289 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		double latency = now() - startTime;
															#line 104 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->waitForPrevLatencies->addMeasurement(latency);
															#line 105 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->waitForPrevCommitRequests;
															#line 106 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		updateLiveCommittedVersion(self, req);
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 306 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForPrevActor*>(this)->actor_wait_state > 0) static_cast<WaitForPrevActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForPrevActor*>(this)->ActorCallback< WaitForPrevActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForPrevActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ReportRawCommittedVersionRequest req;
															#line 101 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	double startTime;
															#line 392 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via waitForPrev()
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class WaitForPrevActor final : public Actor<Void>, public ActorCallback< WaitForPrevActor, 0, Void >, public ActorCallback< WaitForPrevActor, 1, Void >, public FastAllocated<WaitForPrevActor>, public WaitForPrevActorState<WaitForPrevActor> {
															#line 397 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<WaitForPrevActor>::operator new;
	using FastAllocated<WaitForPrevActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(708087287782775808UL, 606382012811205120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForPrevActor, 0, Void >;
friend struct ActorCallback< WaitForPrevActor, 1, Void >;
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	WaitForPrevActor(Reference<MasterData> const& self,ReportRawCommittedVersionRequest const& req) 
															#line 415 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForPrevActorState<WaitForPrevActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13368293736754969600UL, 18390976060860084480UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForPrev");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForPrevActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForPrevActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> waitForPrev( Reference<MasterData> const& self, ReportRawCommittedVersionRequest const& req ) {
															#line 96 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new WaitForPrevActor(self, req));
															#line 449 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 112 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 454 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via waitForPrev()
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class WaitForPrevActor1>
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class WaitForPrevActor1State {
															#line 461 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	WaitForPrevActor1State(Reference<MasterData> const& self,ReportRawCommittedVersionRequest const& req) 
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req),
															#line 114 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   startTime(now())
															#line 472 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("waitForPrev", reinterpret_cast<unsigned long>(this));

	}
	~WaitForPrevActor1State() 
	{
		fdb_probe_actor_destroy("waitForPrev", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 115 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->liveCommittedVersion.whenAtLeast(req.prevVersion.get());
															#line 115 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<WaitForPrevActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 489 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForPrevActor1*>(this)->actor_wait_state = 1;
															#line 115 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForPrevActor1, 0, Void >*>(static_cast<WaitForPrevActor1*>(this)));
															#line 494 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForPrevActor1State();
		static_cast<WaitForPrevActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->waitForPrevLatencies->addMeasurement(now() - startTime);
															#line 117 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->waitForPrevCommitRequests;
															#line 118 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		updateLiveCommittedVersion(self, req);
															#line 119 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 121 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<WaitForPrevActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPrevActor1State(); static_cast<WaitForPrevActor1*>(this)->destroy(); return 0; }
															#line 525 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<WaitForPrevActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForPrevActor1State();
		static_cast<WaitForPrevActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->waitForPrevLatencies->addMeasurement(now() - startTime);
															#line 117 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->waitForPrevCommitRequests;
															#line 118 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		updateLiveCommittedVersion(self, req);
															#line 119 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 121 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<WaitForPrevActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForPrevActor1State(); static_cast<WaitForPrevActor1*>(this)->destroy(); return 0; }
															#line 545 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<WaitForPrevActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForPrevActor1State();
		static_cast<WaitForPrevActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForPrevActor1*>(this)->actor_wait_state > 0) static_cast<WaitForPrevActor1*>(this)->actor_wait_state = 0;
		static_cast<WaitForPrevActor1*>(this)->ActorCallback< WaitForPrevActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForPrevActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForPrevActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ReportRawCommittedVersionRequest req;
															#line 114 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	double startTime;
															#line 634 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via waitForPrev()
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class WaitForPrevActor1 final : public Actor<Void>, public ActorCallback< WaitForPrevActor1, 0, Void >, public FastAllocated<WaitForPrevActor1>, public WaitForPrevActor1State<WaitForPrevActor1> {
															#line 639 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<WaitForPrevActor1>::operator new;
	using FastAllocated<WaitForPrevActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(708087287782775808UL, 606382012811205120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForPrevActor1, 0, Void >;
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	WaitForPrevActor1(Reference<MasterData> const& self,ReportRawCommittedVersionRequest const& req) 
															#line 656 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   WaitForPrevActor1State<WaitForPrevActor1>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForPrev", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4684891747435901440UL, 10234393282114369280UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForPrevActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForPrev");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForPrev", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForPrevActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> waitForPrev( Reference<MasterData> const& self, ReportRawCommittedVersionRequest const& req ) {
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new WaitForPrevActor1(self, req));
															#line 689 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 123 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

#ifdef WITH_SWIFT
															#line 696 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via getVersionSwift()
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class GetVersionSwiftActor>
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionSwiftActorState {
															#line 703 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionSwiftActorState(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req)
															#line 712 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersionSwift", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionSwiftActorState() 
	{
		fdb_probe_actor_destroy("getVersionSwift", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			auto future = self->swiftImpl->getVersion(self.getPtr(), req);
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = future;
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<GetVersionSwiftActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 731 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionSwiftActor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionSwiftActor, 0, Void >*>(static_cast<GetVersionSwiftActor*>(this)));
															#line 736 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionSwiftActorState();
		static_cast<GetVersionSwiftActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionSwiftActorState(); static_cast<GetVersionSwiftActor*>(this)->destroy(); return 0; }
															#line 759 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionSwiftActorState();
		static_cast<GetVersionSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionSwiftActorState(); static_cast<GetVersionSwiftActor*>(this)->destroy(); return 0; }
															#line 771 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionSwiftActorState();
		static_cast<GetVersionSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionSwiftActor*>(this)->actor_wait_state > 0) static_cast<GetVersionSwiftActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionSwiftActor*>(this)->ActorCallback< GetVersionSwiftActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionSwiftActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionSwiftActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionSwiftActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetCommitVersionRequest req;
															#line 858 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via getVersionSwift()
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionSwiftActor final : public Actor<Void>, public ActorCallback< GetVersionSwiftActor, 0, Void >, public FastAllocated<GetVersionSwiftActor>, public GetVersionSwiftActorState<GetVersionSwiftActor> {
															#line 863 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<GetVersionSwiftActor>::operator new;
	using FastAllocated<GetVersionSwiftActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9430834536318918912UL, 14857571926415398144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionSwiftActor, 0, Void >;
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionSwiftActor(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 880 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   GetVersionSwiftActorState<GetVersionSwiftActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionSwift", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8158956951726960384UL, 10829688634296044544UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionSwift");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionSwift", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionSwiftActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> getVersionSwift( Reference<MasterData> const& self, GetCommitVersionRequest const& req ) {
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new GetVersionSwiftActor(self, req));
															#line 913 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 131 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

															#line 919 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via getVersionCxx()
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class GetVersionCxxActor>
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionCxxActorState {
															#line 926 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionCxxActorState(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req),
															#line 134 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   span("M:getVersion"_loc, req.spanContext),
															#line 135 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   proxyItr(self->lastCommitProxyVersionReplies.find(req.requestingProxy))
															#line 939 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersionCxx", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionCxxActorState() 
	{
		fdb_probe_actor_destroy("getVersionCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 138 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			++self->getCommitVersionRequests;
															#line 140 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (proxyItr == self->lastCommitProxyVersionReplies.end())
															#line 956 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 142 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(Never());
															#line 143 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (!static_cast<GetVersionCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionCxxActorState(); static_cast<GetVersionCxxActor*>(this)->destroy(); return 0; }
															#line 962 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				new (&static_cast<GetVersionCxxActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetVersionCxxActorState();
				static_cast<GetVersionCxxActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 146 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(proxyItr->second.latestRequestNum.get() < req.requestNum - 1, "Commit version request queued up", probe::decoration::rare);
															#line 149 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = proxyItr->second.latestRequestNum.whenAtLeast(req.requestNum - 1);
															#line 149 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<GetVersionCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 974 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionCxxActor*>(this)->actor_wait_state = 1;
															#line 149 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionCxxActor, 0, Void >*>(static_cast<GetVersionCxxActor*>(this)));
															#line 979 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionCxxActorState();
		static_cast<GetVersionCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto itr = proxyItr->second.replies.find(req.requestNum);
															#line 152 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (itr != proxyItr->second.replies.end())
															#line 1004 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 153 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(true, "Duplicate request for sequence");
															#line 154 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			req.reply.send(itr->second);
															#line 1010 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
		else
		{
															#line 155 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (req.requestNum <= proxyItr->second.latestRequestNum.get())
															#line 1016 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 156 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				CODE_PROBE(true, "Old request for previously acknowledged sequence - may be impossible with current FlowTransport", probe::decoration::rare);
															#line 159 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(req.requestNum < proxyItr->second.latestRequestNum.get());
															#line 161 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(Never());
															#line 1024 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			}
			else
			{
															#line 163 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				GetCommitVersionReply rep;
															#line 165 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (self->version == invalidVersion)
															#line 1032 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				{
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->lastVersionTime = now();
															#line 167 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->version = self->recoveryTransactionVersion;
															#line 168 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					rep.prevVersion = self->lastEpochEnd;
															#line 1040 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				}
				else
				{
															#line 171 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					double t1 = now();
															#line 172 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					if (BUGGIFY)
															#line 1048 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					{
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						t1 = self->lastVersionTime;
															#line 1052 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					}
															#line 176 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					Version toAdd = std::max<Version>(1, std::min<Version>(SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS, SERVER_KNOBS->VERSIONS_PER_SECOND * (t1 - self->lastVersionTime)));
															#line 181 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					rep.prevVersion = self->version;
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					if (self->referenceVersion.present())
															#line 1060 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					{
															#line 183 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						self->version = figureVersion(self->version, g_network->timer(), self->referenceVersion.get(), toAdd, SERVER_KNOBS->MAX_VERSION_RATE_MODIFIER, SERVER_KNOBS->MAX_VERSION_RATE_OFFSET);
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						ASSERT_GT(self->version, rep.prevVersion);
															#line 1066 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					}
					else
					{
															#line 191 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						self->version = self->version + toAdd;
															#line 1072 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					}
															#line 194 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					CODE_PROBE(self->version - rep.prevVersion == 1, "Minimum possible version gap");
															#line 196 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					bool maxVersionGap = self->version - rep.prevVersion == SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS;
															#line 197 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					CODE_PROBE(maxVersionGap, "Maximum possible version gap");
															#line 198 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->lastVersionTime = t1;
															#line 200 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->resolutionBalancer.setChangesInReply(req.requestingProxy, rep);
															#line 1084 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				}
															#line 203 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				rep.version = self->version;
															#line 204 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				rep.requestNum = req.requestNum;
															#line 206 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.replies.erase(proxyItr->second.replies.begin(), proxyItr->second.replies.upper_bound(req.mostRecentProcessedRequestNum));
															#line 208 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.replies[req.requestNum] = rep;
															#line 209 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(rep.prevVersion >= 0);
															#line 211 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(rep);
															#line 213 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(proxyItr->second.latestRequestNum.get() == req.requestNum - 1);
															#line 214 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.latestRequestNum.set(req.requestNum);
															#line 1102 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			}
		}
															#line 217 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionCxxActorState(); static_cast<GetVersionCxxActor*>(this)->destroy(); return 0; }
															#line 1107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionCxxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionCxxActorState();
		static_cast<GetVersionCxxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 151 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto itr = proxyItr->second.replies.find(req.requestNum);
															#line 152 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (itr != proxyItr->second.replies.end())
															#line 1121 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 153 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(true, "Duplicate request for sequence");
															#line 154 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			req.reply.send(itr->second);
															#line 1127 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
		else
		{
															#line 155 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (req.requestNum <= proxyItr->second.latestRequestNum.get())
															#line 1133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 156 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				CODE_PROBE(true, "Old request for previously acknowledged sequence - may be impossible with current FlowTransport", probe::decoration::rare);
															#line 159 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(req.requestNum < proxyItr->second.latestRequestNum.get());
															#line 161 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(Never());
															#line 1141 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			}
			else
			{
															#line 163 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				GetCommitVersionReply rep;
															#line 165 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (self->version == invalidVersion)
															#line 1149 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				{
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->lastVersionTime = now();
															#line 167 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->version = self->recoveryTransactionVersion;
															#line 168 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					rep.prevVersion = self->lastEpochEnd;
															#line 1157 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				}
				else
				{
															#line 171 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					double t1 = now();
															#line 172 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					if (BUGGIFY)
															#line 1165 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					{
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						t1 = self->lastVersionTime;
															#line 1169 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					}
															#line 176 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					Version toAdd = std::max<Version>(1, std::min<Version>(SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS, SERVER_KNOBS->VERSIONS_PER_SECOND * (t1 - self->lastVersionTime)));
															#line 181 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					rep.prevVersion = self->version;
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					if (self->referenceVersion.present())
															#line 1177 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					{
															#line 183 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						self->version = figureVersion(self->version, g_network->timer(), self->referenceVersion.get(), toAdd, SERVER_KNOBS->MAX_VERSION_RATE_MODIFIER, SERVER_KNOBS->MAX_VERSION_RATE_OFFSET);
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						ASSERT_GT(self->version, rep.prevVersion);
															#line 1183 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					}
					else
					{
															#line 191 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
						self->version = self->version + toAdd;
															#line 1189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
					}
															#line 194 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					CODE_PROBE(self->version - rep.prevVersion == 1, "Minimum possible version gap");
															#line 196 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					bool maxVersionGap = self->version - rep.prevVersion == SERVER_KNOBS->MAX_READ_TRANSACTION_LIFE_VERSIONS;
															#line 197 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					CODE_PROBE(maxVersionGap, "Maximum possible version gap");
															#line 198 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->lastVersionTime = t1;
															#line 200 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
					self->resolutionBalancer.setChangesInReply(req.requestingProxy, rep);
															#line 1201 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				}
															#line 203 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				rep.version = self->version;
															#line 204 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				rep.requestNum = req.requestNum;
															#line 206 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.replies.erase(proxyItr->second.replies.begin(), proxyItr->second.replies.upper_bound(req.mostRecentProcessedRequestNum));
															#line 208 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.replies[req.requestNum] = rep;
															#line 209 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(rep.prevVersion >= 0);
															#line 211 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				req.reply.send(rep);
															#line 213 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				ASSERT(proxyItr->second.latestRequestNum.get() == req.requestNum - 1);
															#line 214 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				proxyItr->second.latestRequestNum.set(req.requestNum);
															#line 1219 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			}
		}
															#line 217 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionCxxActorState(); static_cast<GetVersionCxxActor*>(this)->destroy(); return 0; }
															#line 1224 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionCxxActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionCxxActorState();
		static_cast<GetVersionCxxActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionCxxActor*>(this)->actor_wait_state > 0) static_cast<GetVersionCxxActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionCxxActor*>(this)->ActorCallback< GetVersionCxxActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionCxxActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionCxxActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionCxxActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetCommitVersionRequest req;
															#line 134 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Span span;
															#line 135 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	std::map<UID, CommitProxyVersionReplies>::iterator proxyItr;
															#line 1315 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via getVersionCxx()
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionCxxActor final : public Actor<Void>, public ActorCallback< GetVersionCxxActor, 0, Void >, public FastAllocated<GetVersionCxxActor>, public GetVersionCxxActorState<GetVersionCxxActor> {
															#line 1320 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<GetVersionCxxActor>::operator new;
	using FastAllocated<GetVersionCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17036264149470434560UL, 2397841653362368000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionCxxActor, 0, Void >;
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionCxxActor(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 1337 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   GetVersionCxxActorState<GetVersionCxxActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersionCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1319049914498069504UL, 7493486619572726528UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersionCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersionCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionCxxActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> getVersionCxx( Reference<MasterData> const& self, GetCommitVersionRequest const& req ) {
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new GetVersionCxxActor(self, req));
															#line 1370 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 219 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 1376 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via getVersion()
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class GetVersionActor>
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionActorState {
															#line 1383 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionActorState(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req)
															#line 1392 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionActorState() 
	{
		fdb_probe_actor_destroy("getVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 222 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 1407 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 223 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = getVersionSwift(self, req);
															#line 223 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1413 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetVersionActor*>(this)->actor_wait_state = 1;
															#line 223 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 0, Void >*>(static_cast<GetVersionActor*>(this)));
															#line 1418 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 226 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = getVersionCxx(self, req);
															#line 226 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<GetVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1427 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<GetVersionActor*>(this)->actor_wait_state = 2;
															#line 226 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor, 1, Void >*>(static_cast<GetVersionActor*>(this)));
															#line 1432 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 1456 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 1468 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 1555 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 227 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActorState(); static_cast<GetVersionActor*>(this)->destroy(); return 0; }
															#line 1567 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActorState();
		static_cast<GetVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetVersionActor*>(this)->actor_wait_state > 0) static_cast<GetVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor*>(this)->ActorCallback< GetVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetCommitVersionRequest req;
															#line 1654 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via getVersion()
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionActor final : public Actor<Void>, public ActorCallback< GetVersionActor, 0, Void >, public ActorCallback< GetVersionActor, 1, Void >, public FastAllocated<GetVersionActor>, public GetVersionActorState<GetVersionActor> {
															#line 1659 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<GetVersionActor>::operator new;
	using FastAllocated<GetVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15005121923337876224UL, 18302195384238781952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionActor, 0, Void >;
friend struct ActorCallback< GetVersionActor, 1, Void >;
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionActor(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 1677 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   GetVersionActorState<GetVersionActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4509831120537103360UL, 13615306933804954880UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> getVersion( Reference<MasterData> const& self, GetCommitVersionRequest const& req ) {
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new GetVersionActor(self, req));
															#line 1711 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 230 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 1716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via getVersion()
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class GetVersionActor1>
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionActor1State {
															#line 1723 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionActor1State(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   req(req)
															#line 1732 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("getVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetVersionActor1State() 
	{
		fdb_probe_actor_destroy("getVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 232 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getVersionCxx(self, req);
															#line 232 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<GetVersionActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1749 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetVersionActor1*>(this)->actor_wait_state = 1;
															#line 232 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetVersionActor1, 0, Void >*>(static_cast<GetVersionActor1*>(this)));
															#line 1754 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetVersionActor1State();
		static_cast<GetVersionActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActor1State(); static_cast<GetVersionActor1*>(this)->destroy(); return 0; }
															#line 1777 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActor1State();
		static_cast<GetVersionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 233 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<GetVersionActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetVersionActor1State(); static_cast<GetVersionActor1*>(this)->destroy(); return 0; }
															#line 1789 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<GetVersionActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetVersionActor1State();
		static_cast<GetVersionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetVersionActor1*>(this)->actor_wait_state > 0) static_cast<GetVersionActor1*>(this)->actor_wait_state = 0;
		static_cast<GetVersionActor1*>(this)->ActorCallback< GetVersionActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetVersionActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetVersionActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetVersionActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetCommitVersionRequest req;
															#line 1876 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via getVersion()
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class GetVersionActor1 final : public Actor<Void>, public ActorCallback< GetVersionActor1, 0, Void >, public FastAllocated<GetVersionActor1>, public GetVersionActor1State<GetVersionActor1> {
															#line 1881 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<GetVersionActor1>::operator new;
	using FastAllocated<GetVersionActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15005121923337876224UL, 18302195384238781952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetVersionActor1, 0, Void >;
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	GetVersionActor1(Reference<MasterData> const& self,GetCommitVersionRequest const& req) 
															#line 1898 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   GetVersionActor1State<GetVersionActor1>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14516526064345610496UL, 7985422690004399616UL);
		ActorExecutionContextHelper __helper(static_cast<GetVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetVersionActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> getVersion( Reference<MasterData> const& self, GetCommitVersionRequest const& req ) {
															#line 231 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new GetVersionActor1(self, req));
															#line 1931 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 235 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

CounterValue::CounterValue(std::string const& name, CounterCollection& collection)
  : value(std::make_shared<Counter>(name, collection)) {}

void CounterValue::operator+=(Value delta) {
	value->operator+=(delta);
}

void CounterValue::operator++() {
	value->operator++();
}
void CounterValue::clear() {
	value->clear();
}

MasterData::MasterData(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,
                       MasterInterface const& myInterface,
                       ServerCoordinators const& coordinators,
                       ClusterControllerFullInterface const& clusterController,
                       Standalone<StringRef> const& dbId,
                       PromiseStream<Future<Void>> addActor,
                       bool forceRecovery)
  : dbgid(myInterface.id()), lastEpochEnd(invalidVersion), recoveryTransactionVersion(invalidVersion),
    liveCommittedVersion(invalidVersion), databaseLocked(false), minKnownCommittedVersion(invalidVersion),
    coordinators(coordinators), version(invalidVersion), lastVersionTime(0), myInterface(myInterface),
    resolutionBalancer(&version), forceRecovery(forceRecovery), cc("Master", dbgid.toString()),
    getCommitVersionRequests("GetCommitVersionRequests", cc),
    getLiveCommittedVersionRequests("GetLiveCommittedVersionRequests", cc),
    reportLiveCommittedVersionRequests("ReportLiveCommittedVersionRequests", cc),
    waitForPrevCommitRequests("WaitForPrevCommitRequests", cc),
    nonWaitForPrevCommitRequests("NonWaitForPrevCommitRequests", cc), addActor(addActor) {
	logger = cc.traceCounters("MasterMetrics", dbgid, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "MasterMetrics");
	if (forceRecovery && !myInterface.locality.dcId().present()) {
		TraceEvent(SevError, "ForcedRecoveryRequiresDcID").log();
		forceRecovery = false;
	}
	balancer = resolutionBalancer.resolutionBalancing();
	locality = tagLocalityInvalid;

	if (SERVER_KNOBS->ENABLE_VERSION_VECTOR) {
		versionVectorTagUpdates = std::make_unique<LatencySample>("VersionVectorTagUpdates",
		                                                          dbgid,
		                                                          SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                          SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
		versionVectorSizeOnCVReply = std::make_unique<LatencySample>("VersionVectorSizeOnCVReply",
		                                                             dbgid,
		                                                             SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                             SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
		waitForPrevLatencies = std::make_unique<LatencySample>("WaitForPrevLatencies",
		                                                       dbgid,
		                                                       SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
		                                                       SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
	}

#ifdef WITH_SWIFT
	using namespace fdbserver_swift;
	// FIXME(swift): can we make a cleaner init?
	swiftImpl.reset(new MasterDataActor((const MasterDataActor&)MasterDataActor::init()));
#endif
}

#ifdef WITH_SWIFT
void MasterData::setSwiftImpl(fdbserver_swift::MasterDataActor* impl) {
	swiftImpl.reset(impl);
}
#endif

MasterData::~MasterData() {}

															#line 2005 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via provideVersionsCxx()
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ProvideVersionsCxxActor>
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsCxxActorState {
															#line 2012 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsCxxActorState(Reference<MasterData> const& self) 
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self),
															#line 306 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   versionActors(false)
															#line 2021 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("provideVersionsCxx", reinterpret_cast<unsigned long>(this));

	}
	~ProvideVersionsCxxActorState() 
	{
		fdb_probe_actor_destroy("provideVersionsCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 308 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 2036 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvideVersionsCxxActorState();
		static_cast<ProvideVersionsCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 309 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto __when_expr_0 = self->myInterface.getCommitVersion.getFuture();
															#line 2066 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetCommitVersionRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetCommitVersionRequest>>::value, "invalid type");
															#line 308 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<ProvideVersionsCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2070 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 312 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = versionActors.getResult();
															#line 2074 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ProvideVersionsCxxActor*>(this)->actor_wait_state = 1;
															#line 309 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*>(static_cast<ProvideVersionsCxxActor*>(this)));
															#line 312 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsCxxActor, 1, Void >*>(static_cast<ProvideVersionsCxxActor*>(this)));
															#line 2081 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetCommitVersionRequest const& req,int loopDepth) 
	{
															#line 310 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		versionActors.add(getVersion(self, req));
															#line 2096 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetCommitVersionRequest && req,int loopDepth) 
	{
															#line 310 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		versionActors.add(getVersion(self, req));
															#line 2105 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvideVersionsCxxActor*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsCxxActor*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsCxxActor*>(this)->ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >::remove();
		static_cast<ProvideVersionsCxxActor*>(this)->ActorCallback< ProvideVersionsCxxActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*,GetCommitVersionRequest const& value) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*,GetCommitVersionRequest && value) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsCxxActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsCxxActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProvideVersionsCxxActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 306 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ActorCollection versionActors;
															#line 2247 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via provideVersionsCxx()
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsCxxActor final : public Actor<Void>, public ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >, public ActorCallback< ProvideVersionsCxxActor, 1, Void >, public FastAllocated<ProvideVersionsCxxActor>, public ProvideVersionsCxxActorState<ProvideVersionsCxxActor> {
															#line 2252 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<ProvideVersionsCxxActor>::operator new;
	using FastAllocated<ProvideVersionsCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13418182724187540736UL, 5860926878799929856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >;
friend struct ActorCallback< ProvideVersionsCxxActor, 1, Void >;
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsCxxActor(Reference<MasterData> const& self) 
															#line 2270 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   ProvideVersionsCxxActorState<ProvideVersionsCxxActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provideVersionsCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15042829988053588992UL, 14722448576569397504UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provideVersionsCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provideVersionsCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ProvideVersionsCxxActor, 0, GetCommitVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> provideVersionsCxx( Reference<MasterData> const& self ) {
															#line 305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ProvideVersionsCxxActor(self));
															#line 2303 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 315 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 2309 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via provideVersionsSwift()
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ProvideVersionsSwiftActor>
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsSwiftActorState {
															#line 2316 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsSwiftActorState(Reference<MasterData> const& self) 
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 2323 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("provideVersionsSwift", reinterpret_cast<unsigned long>(this));

	}
	~ProvideVersionsSwiftActorState() 
	{
		fdb_probe_actor_destroy("provideVersionsSwift", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 318 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			auto future = self->swiftImpl->provideVersions(self.getPtr());
															#line 319 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = future;
															#line 319 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<ProvideVersionsSwiftActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2342 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProvideVersionsSwiftActor*>(this)->actor_wait_state = 1;
															#line 319 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsSwiftActor, 0, Void >*>(static_cast<ProvideVersionsSwiftActor*>(this)));
															#line 2347 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvideVersionsSwiftActorState();
		static_cast<ProvideVersionsSwiftActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 320 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsSwiftActorState(); static_cast<ProvideVersionsSwiftActor*>(this)->destroy(); return 0; }
															#line 2370 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ProvideVersionsSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsSwiftActorState();
		static_cast<ProvideVersionsSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 320 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsSwiftActorState(); static_cast<ProvideVersionsSwiftActor*>(this)->destroy(); return 0; }
															#line 2382 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ProvideVersionsSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsSwiftActorState();
		static_cast<ProvideVersionsSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvideVersionsSwiftActor*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsSwiftActor*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsSwiftActor*>(this)->ActorCallback< ProvideVersionsSwiftActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvideVersionsSwiftActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsSwiftActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProvideVersionsSwiftActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersionsSwift", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 2467 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via provideVersionsSwift()
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsSwiftActor final : public Actor<Void>, public ActorCallback< ProvideVersionsSwiftActor, 0, Void >, public FastAllocated<ProvideVersionsSwiftActor>, public ProvideVersionsSwiftActorState<ProvideVersionsSwiftActor> {
															#line 2472 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<ProvideVersionsSwiftActor>::operator new;
	using FastAllocated<ProvideVersionsSwiftActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11423432369487708928UL, 16893126044008177664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProvideVersionsSwiftActor, 0, Void >;
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsSwiftActor(Reference<MasterData> const& self) 
															#line 2489 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   ProvideVersionsSwiftActorState<ProvideVersionsSwiftActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provideVersionsSwift", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9847266601800460544UL, 9650020213108001536UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provideVersionsSwift");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provideVersionsSwift", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProvideVersionsSwiftActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> provideVersionsSwift( Reference<MasterData> const& self ) {
															#line 317 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ProvideVersionsSwiftActor(self));
															#line 2522 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 322 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

#ifdef WITH_SWIFT
															#line 2529 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via provideVersions()
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ProvideVersionsActor>
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsActorState {
															#line 2536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsActorState(Reference<MasterData> const& self) 
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 2543 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("provideVersions", reinterpret_cast<unsigned long>(this));

	}
	~ProvideVersionsActorState() 
	{
		fdb_probe_actor_destroy("provideVersions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 326 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 2558 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 327 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = provideVersionsSwift(self);
															#line 327 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<ProvideVersionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2564 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ProvideVersionsActor*>(this)->actor_wait_state = 1;
															#line 327 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsActor, 0, Void >*>(static_cast<ProvideVersionsActor*>(this)));
															#line 2569 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 329 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = provideVersionsCxx(self);
															#line 329 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<ProvideVersionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2578 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<ProvideVersionsActor*>(this)->actor_wait_state = 2;
															#line 329 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsActor, 1, Void >*>(static_cast<ProvideVersionsActor*>(this)));
															#line 2583 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvideVersionsActorState();
		static_cast<ProvideVersionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 332 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsActorState(); static_cast<ProvideVersionsActor*>(this)->destroy(); return 0; }
															#line 2607 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ProvideVersionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsActorState();
		static_cast<ProvideVersionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvideVersionsActor*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsActor*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsActor*>(this)->ActorCallback< ProvideVersionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProvideVersionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProvideVersionsActor*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsActor*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsActor*>(this)->ActorCallback< ProvideVersionsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProvideVersionsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 2791 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via provideVersions()
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsActor final : public Actor<Void>, public ActorCallback< ProvideVersionsActor, 0, Void >, public ActorCallback< ProvideVersionsActor, 1, Void >, public FastAllocated<ProvideVersionsActor>, public ProvideVersionsActorState<ProvideVersionsActor> {
															#line 2796 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<ProvideVersionsActor>::operator new;
	using FastAllocated<ProvideVersionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1930816149972452352UL, 12956624710925504256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProvideVersionsActor, 0, Void >;
friend struct ActorCallback< ProvideVersionsActor, 1, Void >;
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsActor(Reference<MasterData> const& self) 
															#line 2814 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   ProvideVersionsActorState<ProvideVersionsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18210927288071320832UL, 6774768627665853952UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provideVersions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProvideVersionsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProvideVersionsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> provideVersions( Reference<MasterData> const& self ) {
															#line 325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ProvideVersionsActor(self));
															#line 2848 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 334 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 2853 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via provideVersions()
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ProvideVersionsActor1>
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsActor1State {
															#line 2860 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsActor1State(Reference<MasterData> const& self) 
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 2867 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("provideVersions", reinterpret_cast<unsigned long>(this));

	}
	~ProvideVersionsActor1State() 
	{
		fdb_probe_actor_destroy("provideVersions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 336 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = provideVersionsCxx(self);
															#line 336 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<ProvideVersionsActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2884 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProvideVersionsActor1*>(this)->actor_wait_state = 1;
															#line 336 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProvideVersionsActor1, 0, Void >*>(static_cast<ProvideVersionsActor1*>(this)));
															#line 2889 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProvideVersionsActor1State();
		static_cast<ProvideVersionsActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsActor1State(); static_cast<ProvideVersionsActor1*>(this)->destroy(); return 0; }
															#line 2912 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ProvideVersionsActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsActor1State();
		static_cast<ProvideVersionsActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ProvideVersionsActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProvideVersionsActor1State(); static_cast<ProvideVersionsActor1*>(this)->destroy(); return 0; }
															#line 2924 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ProvideVersionsActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProvideVersionsActor1State();
		static_cast<ProvideVersionsActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProvideVersionsActor1*>(this)->actor_wait_state > 0) static_cast<ProvideVersionsActor1*>(this)->actor_wait_state = 0;
		static_cast<ProvideVersionsActor1*>(this)->ActorCallback< ProvideVersionsActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProvideVersionsActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProvideVersionsActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 3009 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via provideVersions()
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ProvideVersionsActor1 final : public Actor<Void>, public ActorCallback< ProvideVersionsActor1, 0, Void >, public FastAllocated<ProvideVersionsActor1>, public ProvideVersionsActor1State<ProvideVersionsActor1> {
															#line 3014 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<ProvideVersionsActor1>::operator new;
	using FastAllocated<ProvideVersionsActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1930816149972452352UL, 12956624710925504256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProvideVersionsActor1, 0, Void >;
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ProvideVersionsActor1(Reference<MasterData> const& self) 
															#line 3031 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   ProvideVersionsActor1State<ProvideVersionsActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("provideVersions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12118823315806273792UL, 3214504062547193344UL);
		ActorExecutionContextHelper __helper(static_cast<ProvideVersionsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("provideVersions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("provideVersions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProvideVersionsActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> provideVersions( Reference<MasterData> const& self ) {
															#line 335 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ProvideVersionsActor1(self));
															#line 3064 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 339 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

#ifdef WITH_SWIFT
void updateLiveCommittedVersionSwift(Reference<MasterData> self, ReportRawCommittedVersionRequest req) {
	fdbserver_swift::updateLiveCommittedVersion(self.getPtr(), req);
}
#endif

void updateLiveCommittedVersionCxx(Reference<MasterData> self, ReportRawCommittedVersionRequest req) {
	self->minKnownCommittedVersion = std::max(self->minKnownCommittedVersion, req.minKnownCommittedVersion);

	if (req.version > self->liveCommittedVersion.get()) {
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR && req.writtenTags.present()) {
			// TraceEvent("Received ReportRawCommittedVersionRequest").detail("Version",req.version);
			int8_t primaryLocality =
			    SERVER_KNOBS->ENABLE_VERSION_VECTOR_HA_OPTIMIZATION ? self->locality : tagLocalityInvalid;
			self->ssVersionVector.setVersion(req.writtenTags.get(), req.version, primaryLocality);
			self->versionVectorTagUpdates->addMeasurement(req.writtenTags.get().size());
		}
		auto curTime = now();
		// add debug here to change liveCommittedVersion to time bound of now()
		debug_advanceVersionTimestamp(self->liveCommittedVersion.get(), curTime + CLIENT_KNOBS->MAX_VERSION_CACHE_LAG);
		// also add req.version but with no time bound
		debug_advanceVersionTimestamp(req.version, std::numeric_limits<double>::max());
		self->databaseLocked = req.locked;
		self->proxyMetadataVersion = req.metadataVersion;
		// Note the set call switches context to any waiters on liveCommittedVersion before continuing.
		self->liveCommittedVersion.set(req.version);
	}
	++self->reportLiveCommittedVersionRequests;
}

#ifdef WITH_SWIFT
void updateLiveCommittedVersion(Reference<MasterData> self, ReportRawCommittedVersionRequest req) {
	if (SERVER_KNOBS->FLOW_WITH_SWIFT) {
		return updateLiveCommittedVersionSwift(self, req);
	} else {
		return updateLiveCommittedVersionCxx(self, req);
	}
}
#else
void updateLiveCommittedVersion(Reference<MasterData> self, ReportRawCommittedVersionRequest req) {
	return updateLiveCommittedVersionCxx(self, req);
}
#endif

#ifdef WITH_SWIFT
															#line 3115 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via serveLiveCommittedVersionSwift()
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ServeLiveCommittedVersionSwiftActor>
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionSwiftActorState {
															#line 3122 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionSwiftActorState(Reference<MasterData> const& self) 
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 3129 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this));

	}
	~ServeLiveCommittedVersionSwiftActorState() 
	{
		fdb_probe_actor_destroy("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 387 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			auto future = self->swiftImpl->serveLiveCommittedVersion(self.getPtr());
															#line 388 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = future;
															#line 388 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3148 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->actor_wait_state = 1;
															#line 388 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*>(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)));
															#line 3153 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeLiveCommittedVersionSwiftActorState();
		static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 389 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionSwiftActorState(); static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->destroy(); return 0; }
															#line 3176 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionSwiftActorState();
		static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 389 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionSwiftActorState(); static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->destroy(); return 0; }
															#line 3188 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionSwiftActorState();
		static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 3273 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via serveLiveCommittedVersionSwift()
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionSwiftActor final : public Actor<Void>, public ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >, public FastAllocated<ServeLiveCommittedVersionSwiftActor>, public ServeLiveCommittedVersionSwiftActorState<ServeLiveCommittedVersionSwiftActor> {
															#line 3278 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<ServeLiveCommittedVersionSwiftActor>::operator new;
	using FastAllocated<ServeLiveCommittedVersionSwiftActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13819364629701809664UL, 3462773953044604416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >;
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionSwiftActor(Reference<MasterData> const& self) 
															#line 3295 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   ServeLiveCommittedVersionSwiftActorState<ServeLiveCommittedVersionSwiftActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5620024424280020480UL, 12154023526707530752UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveLiveCommittedVersionSwift");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveLiveCommittedVersionSwift", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServeLiveCommittedVersionSwiftActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> serveLiveCommittedVersionSwift( Reference<MasterData> const& self ) {
															#line 386 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ServeLiveCommittedVersionSwiftActor(self));
															#line 3328 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 391 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

															#line 3334 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via serveLiveCommittedVersionCxx()
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ServeLiveCommittedVersionCxxActor>
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionCxxActorState {
															#line 3341 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionCxxActorState(Reference<MasterData> const& self) 
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 3348 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this));

	}
	~ServeLiveCommittedVersionCxxActorState() 
	{
		fdb_probe_actor_destroy("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 394 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 3363 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeLiveCommittedVersionCxxActorState();
		static_cast<ServeLiveCommittedVersionCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 396 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto __when_expr_0 = self->myInterface.getLiveCommittedVersion.getFuture();
															#line 3393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetRawCommittedVersionRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetRawCommittedVersionRequest>>::value, "invalid type");
															#line 395 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<ServeLiveCommittedVersionCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3397 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 417 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto __when_expr_1 = self->myInterface.reportLiveCommittedVersion.getFuture();
															#line 3401 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<ReportRawCommittedVersionRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<ReportRawCommittedVersionRequest>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<ServeLiveCommittedVersionCxxActor*>(this)->actor_wait_state = 1;
															#line 396 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*>(static_cast<ServeLiveCommittedVersionCxxActor*>(this)));
															#line 417 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >*>(static_cast<ServeLiveCommittedVersionCxxActor*>(this)));
															#line 3409 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetRawCommittedVersionRequest const& req,int loopDepth) 
	{
															#line 397 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.debugID.present())
															#line 3424 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 398 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "MasterServer.serveLiveCommittedVersion.GetRawCommittedVersion");
															#line 3428 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
															#line 402 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (self->liveCommittedVersion.get() == invalidVersion)
															#line 3432 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 403 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->liveCommittedVersion.set(self->recoveryTransactionVersion);
															#line 3436 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
															#line 405 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->getLiveCommittedVersionRequests;
															#line 406 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		GetRawCommittedVersionReply reply;
															#line 407 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.version = self->liveCommittedVersion.get();
															#line 408 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.locked = self->databaseLocked;
															#line 409 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.metadataVersion = self->proxyMetadataVersion;
															#line 410 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.minKnownCommittedVersion = self->minKnownCommittedVersion;
															#line 411 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 3452 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 412 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->ssVersionVector.getDelta(req.maxVersion, reply.ssVersionVectorDelta);
															#line 413 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->versionVectorSizeOnCVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 3458 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
															#line 415 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(reply);
															#line 3462 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetRawCommittedVersionRequest && req,int loopDepth) 
	{
															#line 397 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.debugID.present())
															#line 3471 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 398 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "MasterServer.serveLiveCommittedVersion.GetRawCommittedVersion");
															#line 3475 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
															#line 402 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (self->liveCommittedVersion.get() == invalidVersion)
															#line 3479 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 403 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->liveCommittedVersion.set(self->recoveryTransactionVersion);
															#line 3483 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
															#line 405 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		++self->getLiveCommittedVersionRequests;
															#line 406 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		GetRawCommittedVersionReply reply;
															#line 407 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.version = self->liveCommittedVersion.get();
															#line 408 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.locked = self->databaseLocked;
															#line 409 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.metadataVersion = self->proxyMetadataVersion;
															#line 410 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		reply.minKnownCommittedVersion = self->minKnownCommittedVersion;
															#line 411 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 3499 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 412 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->ssVersionVector.getDelta(req.maxVersion, reply.ssVersionVectorDelta);
															#line 413 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->versionVectorSizeOnCVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 3505 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
															#line 415 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(reply);
															#line 3509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ReportRawCommittedVersionRequest const& req,int loopDepth) 
	{
															#line 419 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR && req.prevVersion.present() && (self->liveCommittedVersion.get() != invalidVersion) && (self->liveCommittedVersion.get() < req.prevVersion.get()))
															#line 3518 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 422 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->addActor.send(waitForPrev(self, req));
															#line 3522 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
		else
		{
															#line 424 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			updateLiveCommittedVersion(self, req);
															#line 425 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			++self->nonWaitForPrevCommitRequests;
															#line 426 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			req.reply.send(Void());
															#line 3532 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ReportRawCommittedVersionRequest && req,int loopDepth) 
	{
															#line 419 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR && req.prevVersion.present() && (self->liveCommittedVersion.get() != invalidVersion) && (self->liveCommittedVersion.get() < req.prevVersion.get()))
															#line 3542 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 422 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->addActor.send(waitForPrev(self, req));
															#line 3546 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
		else
		{
															#line 424 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			updateLiveCommittedVersion(self, req);
															#line 425 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			++self->nonWaitForPrevCommitRequests;
															#line 426 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			req.reply.send(Void());
															#line 3556 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeLiveCommittedVersionCxxActor*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionCxxActor*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionCxxActor*>(this)->ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >::remove();
		static_cast<ServeLiveCommittedVersionCxxActor*>(this)->ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*,GetRawCommittedVersionRequest const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*,GetRawCommittedVersionRequest && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >*,ReportRawCommittedVersionRequest const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >*,ReportRawCommittedVersionRequest && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 3685 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via serveLiveCommittedVersionCxx()
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionCxxActor final : public Actor<Void>, public ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >, public ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >, public FastAllocated<ServeLiveCommittedVersionCxxActor>, public ServeLiveCommittedVersionCxxActorState<ServeLiveCommittedVersionCxxActor> {
															#line 3690 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<ServeLiveCommittedVersionCxxActor>::operator new;
	using FastAllocated<ServeLiveCommittedVersionCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11910074802412991744UL, 11930403563299484160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >;
friend struct ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 1, ReportRawCommittedVersionRequest >;
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionCxxActor(Reference<MasterData> const& self) 
															#line 3708 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   ServeLiveCommittedVersionCxxActorState<ServeLiveCommittedVersionCxxActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7338616132591428096UL, 5154268329048877824UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveLiveCommittedVersionCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveLiveCommittedVersionCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ServeLiveCommittedVersionCxxActor, 0, GetRawCommittedVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> serveLiveCommittedVersionCxx( Reference<MasterData> const& self ) {
															#line 393 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ServeLiveCommittedVersionCxxActor(self));
															#line 3741 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 432 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 3747 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via serveLiveCommittedVersion()
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ServeLiveCommittedVersionActor>
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionActorState {
															#line 3754 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionActorState(Reference<MasterData> const& self) 
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 3761 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~ServeLiveCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 435 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 3776 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 436 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = serveLiveCommittedVersionSwift(self);
															#line 436 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3782 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 436 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*>(static_cast<ServeLiveCommittedVersionActor*>(this)));
															#line 3787 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 438 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = serveLiveCommittedVersionCxx(self);
															#line 438 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3796 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 438 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*>(static_cast<ServeLiveCommittedVersionActor*>(this)));
															#line 3801 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeLiveCommittedVersionActorState();
		static_cast<ServeLiveCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 440 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionActorState(); static_cast<ServeLiveCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 3825 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ServeLiveCommittedVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionActorState();
		static_cast<ServeLiveCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionActor*>(this)->ActorCallback< ServeLiveCommittedVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionActor*>(this)->ActorCallback< ServeLiveCommittedVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 4009 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via serveLiveCommittedVersion()
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionActor final : public Actor<Void>, public ActorCallback< ServeLiveCommittedVersionActor, 0, Void >, public ActorCallback< ServeLiveCommittedVersionActor, 1, Void >, public FastAllocated<ServeLiveCommittedVersionActor>, public ServeLiveCommittedVersionActorState<ServeLiveCommittedVersionActor> {
															#line 4014 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<ServeLiveCommittedVersionActor>::operator new;
	using FastAllocated<ServeLiveCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(458615725206322176UL, 12665167622272231168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServeLiveCommittedVersionActor, 0, Void >;
friend struct ActorCallback< ServeLiveCommittedVersionActor, 1, Void >;
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionActor(Reference<MasterData> const& self) 
															#line 4032 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   ServeLiveCommittedVersionActorState<ServeLiveCommittedVersionActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15907572454473595904UL, 10660248522553885184UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveLiveCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServeLiveCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServeLiveCommittedVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> serveLiveCommittedVersion( Reference<MasterData> const& self ) {
															#line 434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ServeLiveCommittedVersionActor(self));
															#line 4066 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 442 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 4071 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via serveLiveCommittedVersion()
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class ServeLiveCommittedVersionActor1>
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionActor1State {
															#line 4078 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionActor1State(Reference<MasterData> const& self) 
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 4085 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~ServeLiveCommittedVersionActor1State() 
	{
		fdb_probe_actor_destroy("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 444 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = serveLiveCommittedVersionCxx(self);
															#line 444 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<ServeLiveCommittedVersionActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4102 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ServeLiveCommittedVersionActor1*>(this)->actor_wait_state = 1;
															#line 444 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*>(static_cast<ServeLiveCommittedVersionActor1*>(this)));
															#line 4107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServeLiveCommittedVersionActor1State();
		static_cast<ServeLiveCommittedVersionActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 445 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionActor1State(); static_cast<ServeLiveCommittedVersionActor1*>(this)->destroy(); return 0; }
															#line 4130 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ServeLiveCommittedVersionActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionActor1State();
		static_cast<ServeLiveCommittedVersionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 445 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<ServeLiveCommittedVersionActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServeLiveCommittedVersionActor1State(); static_cast<ServeLiveCommittedVersionActor1*>(this)->destroy(); return 0; }
															#line 4142 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<ServeLiveCommittedVersionActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServeLiveCommittedVersionActor1State();
		static_cast<ServeLiveCommittedVersionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServeLiveCommittedVersionActor1*>(this)->actor_wait_state > 0) static_cast<ServeLiveCommittedVersionActor1*>(this)->actor_wait_state = 0;
		static_cast<ServeLiveCommittedVersionActor1*>(this)->ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 4227 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via serveLiveCommittedVersion()
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class ServeLiveCommittedVersionActor1 final : public Actor<Void>, public ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >, public FastAllocated<ServeLiveCommittedVersionActor1>, public ServeLiveCommittedVersionActor1State<ServeLiveCommittedVersionActor1> {
															#line 4232 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<ServeLiveCommittedVersionActor1>::operator new;
	using FastAllocated<ServeLiveCommittedVersionActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(458615725206322176UL, 12665167622272231168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >;
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServeLiveCommittedVersionActor1(Reference<MasterData> const& self) 
															#line 4249 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   ServeLiveCommittedVersionActor1State<ServeLiveCommittedVersionActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8890806443078151168UL, 14214187738504197120UL);
		ActorExecutionContextHelper __helper(static_cast<ServeLiveCommittedVersionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serveLiveCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serveLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServeLiveCommittedVersionActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> serveLiveCommittedVersion( Reference<MasterData> const& self ) {
															#line 443 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new ServeLiveCommittedVersionActor1(self));
															#line 4282 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 447 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

#ifdef WITH_SWIFT
															#line 4289 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via updateRecoveryDataSwift()
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class UpdateRecoveryDataSwiftActor>
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataSwiftActorState {
															#line 4296 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataSwiftActorState(Reference<MasterData> const& self) 
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 4303 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRecoveryDataSwiftActorState() 
	{
		fdb_probe_actor_destroy("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 451 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			auto future = self->swiftImpl->serveUpdateRecoveryData(self.getPtr());
															#line 452 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = future;
															#line 452 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<UpdateRecoveryDataSwiftActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4322 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRecoveryDataSwiftActor*>(this)->actor_wait_state = 1;
															#line 452 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*>(static_cast<UpdateRecoveryDataSwiftActor*>(this)));
															#line 4327 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRecoveryDataSwiftActorState();
		static_cast<UpdateRecoveryDataSwiftActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 453 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataSwiftActorState(); static_cast<UpdateRecoveryDataSwiftActor*>(this)->destroy(); return 0; }
															#line 4350 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<UpdateRecoveryDataSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataSwiftActorState();
		static_cast<UpdateRecoveryDataSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 453 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataSwiftActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataSwiftActorState(); static_cast<UpdateRecoveryDataSwiftActor*>(this)->destroy(); return 0; }
															#line 4362 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<UpdateRecoveryDataSwiftActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataSwiftActorState();
		static_cast<UpdateRecoveryDataSwiftActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRecoveryDataSwiftActor*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataSwiftActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataSwiftActor*>(this)->ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 4447 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via updateRecoveryDataSwift()
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataSwiftActor final : public Actor<Void>, public ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >, public FastAllocated<UpdateRecoveryDataSwiftActor>, public UpdateRecoveryDataSwiftActorState<UpdateRecoveryDataSwiftActor> {
															#line 4452 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<UpdateRecoveryDataSwiftActor>::operator new;
	using FastAllocated<UpdateRecoveryDataSwiftActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11797359446377837568UL, 6219333036252981504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >;
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataSwiftActor(Reference<MasterData> const& self) 
															#line 4469 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateRecoveryDataSwiftActorState<UpdateRecoveryDataSwiftActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11356062266753340160UL, 9640252687396583936UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataSwiftActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRecoveryDataSwift");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRecoveryDataSwift", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRecoveryDataSwiftActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> updateRecoveryDataSwift( Reference<MasterData> const& self ) {
															#line 450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new UpdateRecoveryDataSwiftActor(self));
															#line 4502 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 455 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

															#line 4508 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via updateRecoveryDataCxx()
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class UpdateRecoveryDataCxxActor>
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataCxxActorState {
															#line 4515 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataCxxActorState(Reference<MasterData> const& self) 
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 4522 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRecoveryDataCxxActorState() 
	{
		fdb_probe_actor_destroy("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 458 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 4537 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRecoveryDataCxxActorState();
		static_cast<UpdateRecoveryDataCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 459 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		auto __when_expr_0 = self->myInterface.updateRecoveryData.getFuture();
															#line 4567 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<UpdateRecoveryDataRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<UpdateRecoveryDataRequest>>::value, "invalid type");
															#line 459 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<UpdateRecoveryDataCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4571 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<UpdateRecoveryDataCxxActor*>(this)->actor_wait_state = 1;
															#line 459 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*>(static_cast<UpdateRecoveryDataCxxActor*>(this)));
															#line 4576 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(UpdateRecoveryDataRequest const& req,int loopDepth) 
	{
															#line 460 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		TraceEvent("UpdateRecoveryData", self->dbgid) .detail("ReceivedRecoveryTxnVersion", req.recoveryTransactionVersion) .detail("ReceivedLastEpochEnd", req.lastEpochEnd) .detail("CurrentRecoveryTxnVersion", self->recoveryTransactionVersion) .detail("CurrentLastEpochEnd", self->lastEpochEnd) .detail("NumCommitProxies", req.commitProxies.size()) .detail("VersionEpoch", req.versionEpoch) .detail("PrimaryLocality", req.primaryLocality);
															#line 469 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->recoveryTransactionVersion = req.recoveryTransactionVersion;
															#line 470 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->lastEpochEnd = req.lastEpochEnd;
															#line 472 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.commitProxies.size() > 0)
															#line 4591 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 473 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->lastCommitProxyVersionReplies.clear();
															#line 475 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			for( auto& p : req.commitProxies ) {
															#line 476 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self->lastCommitProxyVersionReplies[p.id()] = CommitProxyVersionReplies();
															#line 4599 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			}
		}
															#line 479 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.versionEpoch.present())
															#line 4604 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 480 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->referenceVersion = req.versionEpoch.get();
															#line 4608 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
		else
		{
															#line 481 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (BUGGIFY)
															#line 4614 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 487 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self->referenceVersion = deterministicRandom()->randomInt64(-1e6, 0);
															#line 4618 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			}
		}
															#line 490 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->resolutionBalancer.setCommitProxies(req.commitProxies);
															#line 491 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->resolutionBalancer.setResolvers(req.resolvers);
															#line 493 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->locality = req.primaryLocality;
															#line 495 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 4629 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(UpdateRecoveryDataRequest && req,int loopDepth) 
	{
															#line 460 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		TraceEvent("UpdateRecoveryData", self->dbgid) .detail("ReceivedRecoveryTxnVersion", req.recoveryTransactionVersion) .detail("ReceivedLastEpochEnd", req.lastEpochEnd) .detail("CurrentRecoveryTxnVersion", self->recoveryTransactionVersion) .detail("CurrentLastEpochEnd", self->lastEpochEnd) .detail("NumCommitProxies", req.commitProxies.size()) .detail("VersionEpoch", req.versionEpoch) .detail("PrimaryLocality", req.primaryLocality);
															#line 469 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->recoveryTransactionVersion = req.recoveryTransactionVersion;
															#line 470 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->lastEpochEnd = req.lastEpochEnd;
															#line 472 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.commitProxies.size() > 0)
															#line 4644 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 473 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->lastCommitProxyVersionReplies.clear();
															#line 475 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			for( auto& p : req.commitProxies ) {
															#line 476 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self->lastCommitProxyVersionReplies[p.id()] = CommitProxyVersionReplies();
															#line 4652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			}
		}
															#line 479 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (req.versionEpoch.present())
															#line 4657 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 480 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			self->referenceVersion = req.versionEpoch.get();
															#line 4661 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
		else
		{
															#line 481 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (BUGGIFY)
															#line 4667 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 487 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self->referenceVersion = deterministicRandom()->randomInt64(-1e6, 0);
															#line 4671 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			}
		}
															#line 490 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->resolutionBalancer.setCommitProxies(req.commitProxies);
															#line 491 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->resolutionBalancer.setResolvers(req.resolvers);
															#line 493 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self->locality = req.primaryLocality;
															#line 495 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		req.reply.send(Void());
															#line 4682 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(UpdateRecoveryDataRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(UpdateRecoveryDataRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRecoveryDataCxxActor*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataCxxActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataCxxActor*>(this)->ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*,UpdateRecoveryDataRequest const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*,UpdateRecoveryDataRequest && value) 
	{
		fdb_probe_actor_enter("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 4764 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via updateRecoveryDataCxx()
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataCxxActor final : public Actor<Void>, public ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >, public FastAllocated<UpdateRecoveryDataCxxActor>, public UpdateRecoveryDataCxxActorState<UpdateRecoveryDataCxxActor> {
															#line 4769 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<UpdateRecoveryDataCxxActor>::operator new;
	using FastAllocated<UpdateRecoveryDataCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17745550092854445312UL, 18399613421214162688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >;
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataCxxActor(Reference<MasterData> const& self) 
															#line 4786 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateRecoveryDataCxxActorState<UpdateRecoveryDataCxxActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8530993395171811328UL, 9217547638281496832UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRecoveryDataCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRecoveryDataCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< UpdateRecoveryDataCxxActor, 0, UpdateRecoveryDataRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> updateRecoveryDataCxx( Reference<MasterData> const& self ) {
															#line 457 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new UpdateRecoveryDataCxxActor(self));
															#line 4819 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 498 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 4825 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via updateRecoveryData()
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class UpdateRecoveryDataActor>
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataActorState {
															#line 4832 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataActorState(Reference<MasterData> const& self) 
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 4839 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("updateRecoveryData", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRecoveryDataActorState() 
	{
		fdb_probe_actor_destroy("updateRecoveryData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 501 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 4854 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 502 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = updateRecoveryDataSwift(self);
															#line 502 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4860 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state = 1;
															#line 502 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRecoveryDataActor, 0, Void >*>(static_cast<UpdateRecoveryDataActor*>(this)));
															#line 4865 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 504 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = updateRecoveryDataCxx(self);
															#line 504 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4874 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state = 2;
															#line 504 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateRecoveryDataActor, 1, Void >*>(static_cast<UpdateRecoveryDataActor*>(this)));
															#line 4879 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRecoveryDataActorState();
		static_cast<UpdateRecoveryDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 506 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataActorState(); static_cast<UpdateRecoveryDataActor*>(this)->destroy(); return 0; }
															#line 4903 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<UpdateRecoveryDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataActorState();
		static_cast<UpdateRecoveryDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataActor*>(this)->ActorCallback< UpdateRecoveryDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRecoveryDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataActor*>(this)->ActorCallback< UpdateRecoveryDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateRecoveryDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 5087 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via updateRecoveryData()
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataActor final : public Actor<Void>, public ActorCallback< UpdateRecoveryDataActor, 0, Void >, public ActorCallback< UpdateRecoveryDataActor, 1, Void >, public FastAllocated<UpdateRecoveryDataActor>, public UpdateRecoveryDataActorState<UpdateRecoveryDataActor> {
															#line 5092 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<UpdateRecoveryDataActor>::operator new;
	using FastAllocated<UpdateRecoveryDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3025200859711284736UL, 3342276855344494848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRecoveryDataActor, 0, Void >;
friend struct ActorCallback< UpdateRecoveryDataActor, 1, Void >;
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataActor(Reference<MasterData> const& self) 
															#line 5110 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateRecoveryDataActorState<UpdateRecoveryDataActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14468069868482539264UL, 12417538139821103360UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRecoveryData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRecoveryDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateRecoveryDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> updateRecoveryData( Reference<MasterData> const& self ) {
															#line 500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new UpdateRecoveryDataActor(self));
															#line 5144 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 508 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 5149 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via updateRecoveryData()
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class UpdateRecoveryDataActor1>
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataActor1State {
															#line 5156 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataActor1State(Reference<MasterData> const& self) 
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : self(self)
															#line 5163 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("updateRecoveryData", reinterpret_cast<unsigned long>(this));

	}
	~UpdateRecoveryDataActor1State() 
	{
		fdb_probe_actor_destroy("updateRecoveryData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 510 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateRecoveryDataCxx(self);
															#line 510 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<UpdateRecoveryDataActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateRecoveryDataActor1*>(this)->actor_wait_state = 1;
															#line 510 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateRecoveryDataActor1, 0, Void >*>(static_cast<UpdateRecoveryDataActor1*>(this)));
															#line 5185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateRecoveryDataActor1State();
		static_cast<UpdateRecoveryDataActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 511 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataActor1State(); static_cast<UpdateRecoveryDataActor1*>(this)->destroy(); return 0; }
															#line 5208 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<UpdateRecoveryDataActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataActor1State();
		static_cast<UpdateRecoveryDataActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 511 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<UpdateRecoveryDataActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateRecoveryDataActor1State(); static_cast<UpdateRecoveryDataActor1*>(this)->destroy(); return 0; }
															#line 5220 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<UpdateRecoveryDataActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateRecoveryDataActor1State();
		static_cast<UpdateRecoveryDataActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateRecoveryDataActor1*>(this)->actor_wait_state > 0) static_cast<UpdateRecoveryDataActor1*>(this)->actor_wait_state = 0;
		static_cast<UpdateRecoveryDataActor1*>(this)->ActorCallback< UpdateRecoveryDataActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateRecoveryDataActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateRecoveryDataActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 5305 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via updateRecoveryData()
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class UpdateRecoveryDataActor1 final : public Actor<Void>, public ActorCallback< UpdateRecoveryDataActor1, 0, Void >, public FastAllocated<UpdateRecoveryDataActor1>, public UpdateRecoveryDataActor1State<UpdateRecoveryDataActor1> {
															#line 5310 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<UpdateRecoveryDataActor1>::operator new;
	using FastAllocated<UpdateRecoveryDataActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3025200859711284736UL, 3342276855344494848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateRecoveryDataActor1, 0, Void >;
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UpdateRecoveryDataActor1(Reference<MasterData> const& self) 
															#line 5327 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateRecoveryDataActor1State<UpdateRecoveryDataActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateRecoveryData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13647694284020221440UL, 17007669884596067840UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateRecoveryDataActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateRecoveryData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateRecoveryData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateRecoveryDataActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> updateRecoveryData( Reference<MasterData> const& self ) {
															#line 509 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new UpdateRecoveryDataActor1(self));
															#line 5360 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 513 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

static std::set<int> const& normalMasterErrors() {
	static std::set<int> s;
	if (s.empty()) {
		s.insert(error_code_tlog_stopped);
		s.insert(error_code_tlog_failed);
		s.insert(error_code_commit_proxy_failed);
		s.insert(error_code_grv_proxy_failed);
		s.insert(error_code_resolver_failed);
		s.insert(error_code_backup_worker_failed);
		s.insert(error_code_recruitment_failed);
		s.insert(error_code_no_more_servers);
		s.insert(error_code_cluster_recovery_failed);
		s.insert(error_code_coordinated_state_conflict);
		s.insert(error_code_master_max_versions_in_flight);
		s.insert(error_code_worker_removed);
		s.insert(error_code_new_coordinators_timed_out);
		s.insert(error_code_broken_promise);
	}
	return s;
}

															#line 5387 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via masterServerCxx()
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class MasterServerCxxActor>
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerCxxActorState {
															#line 5394 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerCxxActorState(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : mi(mi),
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   db(db),
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccInterface(ccInterface),
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   coordinators(coordinators),
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   lifetime(lifetime),
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   forceRecovery(forceRecovery),
															#line 542 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccTimeout(delay(SERVER_KNOBS->CC_INTERFACE_TIMEOUT))
															#line 5413 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("masterServerCxx", reinterpret_cast<unsigned long>(this));

	}
	~MasterServerCxxActorState() 
	{
		fdb_probe_actor_destroy("masterServerCxx", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 543 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 5428 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MasterServerCxxActorState();
		static_cast<MasterServerCxxActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 554 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		onDBChange = Void();
															#line 555 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = onDBChange;
															#line 555 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5455 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 2;
															#line 555 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 1, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5460 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 543 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!(!ccInterface->get().present() || db->get().clusterInterface != ccInterface->get().get()))
															#line 5476 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 544 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_0 = ccInterface->onChange() || db->onChange() || ccTimeout;
															#line 544 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5484 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 1;
															#line 544 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 0, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5489 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 545 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (ccTimeout.isReady())
															#line 5511 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 546 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "Timeout") .detail("CCInterface", ccInterface->get().present() ? ccInterface->get().get().id() : UID()) .detail("DBInfoInterface", db->get().clusterInterface.id());
															#line 550 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerCxxActorState(); static_cast<MasterServerCxxActor*>(this)->destroy(); return 0; }
															#line 5517 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<MasterServerCxxActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerCxxActorState();
			static_cast<MasterServerCxxActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 545 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (ccTimeout.isReady())
															#line 5531 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 546 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "Timeout") .detail("CCInterface", ccInterface->get().present() ? ccInterface->get().get().id() : UID()) .detail("DBInfoInterface", db->get().clusterInterface.id());
															#line 550 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerCxxActorState(); static_cast<MasterServerCxxActor*>(this)->destroy(); return 0; }
															#line 5537 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<MasterServerCxxActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerCxxActorState();
			static_cast<MasterServerCxxActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 556 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor = PromiseStream<Future<Void>>();
															#line 557 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self = Reference<MasterData>(new MasterData(db, mi, coordinators, db->get().clusterInterface, ""_sr, addActor, forceRecovery));
															#line 559 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		collection = actorCollection(addActor.getFuture());
															#line 561 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(traceRole(Role::MASTER, mi.id()));
															#line 562 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(provideVersions(self));
															#line 563 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(serveLiveCommittedVersion(self));
															#line 564 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(updateRecoveryDataCxx(self));
															#line 566 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE(!lifetime.isStillValid(db->get().masterLifetime, mi.id() == db->get().master.id()), "Master born doomed");
															#line 568 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		TraceEvent("MasterLifetime", self->dbgid).detail("LifetimeToken", lifetime.toString());
															#line 5642 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		try {
															#line 571 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 5646 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 556 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor = PromiseStream<Future<Void>>();
															#line 557 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		self = Reference<MasterData>(new MasterData(db, mi, coordinators, db->get().clusterInterface, ""_sr, addActor, forceRecovery));
															#line 559 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		collection = actorCollection(addActor.getFuture());
															#line 561 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(traceRole(Role::MASTER, mi.id()));
															#line 562 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(provideVersions(self));
															#line 563 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(serveLiveCommittedVersion(self));
															#line 564 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		addActor.send(updateRecoveryDataCxx(self));
															#line 566 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE(!lifetime.isStillValid(db->get().masterLifetime, mi.id() == db->get().master.id()), "Master born doomed");
															#line 568 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		TraceEvent("MasterLifetime", self->dbgid).detail("LifetimeToken", lifetime.toString());
															#line 5677 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		try {
															#line 571 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 5681 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = a_body1cont2loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 591 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			err = e;
															#line 592 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 5774 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 593 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_5 = delay(0.0);
															#line 593 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5780 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 5;
															#line 593 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 5, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5785 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 572 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onDBChange;
															#line 571 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5814 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 585 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_3 = collection;
															#line 5818 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_3.get(), loopDepth); };
		static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 3;
															#line 572 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 2, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 585 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 3, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5825 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 573 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		onDBChange = db->onChange();
															#line 574 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!lifetime.isStillValid(db->get().masterLifetime, mi.id() == db->get().master.id()))
															#line 5842 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 575 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "LifetimeToken") .detail("MyToken", lifetime.toString()) .detail("CurrentToken", db->get().masterLifetime.toString());
															#line 579 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(true, "Master replaced, dying");
															#line 580 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (BUGGIFY)
															#line 5850 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 581 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(5);
															#line 581 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5856 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1when1(__when_expr_4.get(), loopDepth); };
				static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 4;
															#line 581 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 4, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5861 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1when1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2loopBody1when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
															#line 573 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		onDBChange = db->onChange();
															#line 574 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!lifetime.isStillValid(db->get().masterLifetime, mi.id() == db->get().master.id()))
															#line 5882 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 575 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "LifetimeToken") .detail("MyToken", lifetime.toString()) .detail("CurrentToken", db->get().masterLifetime.toString());
															#line 579 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			CODE_PROBE(true, "Master replaced, dying");
															#line 580 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (BUGGIFY)
															#line 5890 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 581 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(5);
															#line 581 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5896 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1when1(__when_expr_4.get(), loopDepth); };
				static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 4;
															#line 581 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MasterServerCxxActor, 4, Void >*>(static_cast<MasterServerCxxActor*>(this)));
															#line 5901 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1when1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2loopBody1when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 586 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		ASSERT(false);
															#line 587 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		return a_body1cont2Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5922 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
															#line 586 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		ASSERT(false);
															#line 587 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		return a_body1cont2Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5932 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 2, Void >::remove();
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 3, Void >::remove();

	}
	int a_body1cont2loopBody1when1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1cont2(int loopDepth) 
	{
															#line 582 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		return a_body1cont2Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 5953 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2loopBody1when1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1when1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2Catch1cont1(int loopDepth) 
	{
															#line 595 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		for(;!addActor.isEmpty();) {
															#line 596 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			addActor.getFuture().pop();
															#line 6164 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		}
															#line 599 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE( err.code() == error_code_tlog_failed, "Master: terminated due to tLog failure", probe::decoration::rare);
															#line 601 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE(err.code() == error_code_commit_proxy_failed, "Master: terminated due to commit proxy failure", probe::decoration::rare);
															#line 604 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE(err.code() == error_code_grv_proxy_failed, "Master: terminated due to GRV proxy failure", probe::decoration::rare);
															#line 607 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE(err.code() == error_code_resolver_failed, "Master: terminated due to resolver failure", probe::decoration::rare);
															#line 610 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		CODE_PROBE(err.code() == error_code_backup_worker_failed, "Master: terminated due to backup worker failure", probe::decoration::rare);
															#line 614 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (normalMasterErrors().contains(err.code()))
															#line 6178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 615 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()).error(err);
															#line 616 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerCxxActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerCxxActorState(); static_cast<MasterServerCxxActor*>(this)->destroy(); return 0; }
															#line 6184 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<MasterServerCxxActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerCxxActorState();
			static_cast<MasterServerCxxActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 618 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 6192 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MasterServerCxxActor*>(this)->actor_wait_state > 0) static_cast<MasterServerCxxActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerCxxActor*>(this)->ActorCallback< MasterServerCxxActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MasterServerCxxActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MasterServerCxxActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterInterface mi;
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServerCoordinators coordinators;
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	LifetimeToken lifetime;
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	bool forceRecovery;
															#line 542 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> ccTimeout;
															#line 554 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> onDBChange;
															#line 556 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 557 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 559 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> collection;
															#line 591 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Error err;
															#line 6307 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via masterServerCxx()
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerCxxActor final : public Actor<Void>, public ActorCallback< MasterServerCxxActor, 0, Void >, public ActorCallback< MasterServerCxxActor, 1, Void >, public ActorCallback< MasterServerCxxActor, 2, Void >, public ActorCallback< MasterServerCxxActor, 4, Void >, public ActorCallback< MasterServerCxxActor, 3, Void >, public ActorCallback< MasterServerCxxActor, 5, Void >, public FastAllocated<MasterServerCxxActor>, public MasterServerCxxActorState<MasterServerCxxActor> {
															#line 6312 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<MasterServerCxxActor>::operator new;
	using FastAllocated<MasterServerCxxActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8936785229538742528UL, 10799993449199076864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MasterServerCxxActor, 0, Void >;
friend struct ActorCallback< MasterServerCxxActor, 1, Void >;
friend struct ActorCallback< MasterServerCxxActor, 2, Void >;
friend struct ActorCallback< MasterServerCxxActor, 4, Void >;
friend struct ActorCallback< MasterServerCxxActor, 3, Void >;
friend struct ActorCallback< MasterServerCxxActor, 5, Void >;
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerCxxActor(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 6334 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   MasterServerCxxActorState<MasterServerCxxActor>(mi, db, ccInterface, coordinators, lifetime, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("masterServerCxx", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12553048010944550144UL, 1771433832172964864UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerCxxActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("masterServerCxx");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("masterServerCxx", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MasterServerCxxActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MasterServerCxxActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MasterServerCxxActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MasterServerCxxActor, 4, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MasterServerCxxActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> masterServerCxx( MasterInterface const& mi, Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, ServerCoordinators const& coordinators, LifetimeToken const& lifetime, bool const& forceRecovery ) {
															#line 536 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new MasterServerCxxActor(mi, db, ccInterface, coordinators, lifetime, forceRecovery));
															#line 6371 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 621 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

#ifdef WITH_SWIFT
															#line 6377 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via masterServerImpl()
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class MasterServerImplActor>
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerImplActorState {
															#line 6384 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerImplActorState(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : mi(mi),
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   db(db),
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccInterface(ccInterface),
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   coordinators(coordinators),
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   lifetime(lifetime),
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   forceRecovery(forceRecovery)
															#line 6401 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("masterServerImpl", reinterpret_cast<unsigned long>(this));

	}
	~MasterServerImplActorState() 
	{
		fdb_probe_actor_destroy("masterServerImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 629 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (SERVER_KNOBS->FLOW_WITH_SWIFT)
															#line 6416 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			{
															#line 630 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				auto promise = Promise<Void>();
															#line 631 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				addActor = PromiseStream<Future<Void>>();
															#line 632 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				self = Reference<MasterData>(new MasterData(db, mi, coordinators, db->get().clusterInterface, ""_sr, addActor, forceRecovery));
															#line 634 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				fdbserver_swift::masterServerSwift( mi, const_cast<AsyncVar<ServerDBInfo>*>(db.getPtr()), const_cast<AsyncVar<Optional<ClusterControllerFullInterface>>*>(ccInterface.getPtr()), coordinators, lifetime, forceRecovery, self.getPtr(), promise);
															#line 643 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				Future<Void> f = promise.getFuture();
															#line 644 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_0 = f;
															#line 644 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6432 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MasterServerImplActor*>(this)->actor_wait_state = 1;
															#line 644 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MasterServerImplActor, 0, Void >*>(static_cast<MasterServerImplActor*>(this)));
															#line 6437 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 647 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				StrictFuture<Void> __when_expr_1 = masterServerCxx(mi, db, ccInterface, coordinators, lifetime, forceRecovery);
															#line 647 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				if (static_cast<MasterServerImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6446 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<MasterServerImplActor*>(this)->actor_wait_state = 2;
															#line 647 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MasterServerImplActor, 1, Void >*>(static_cast<MasterServerImplActor*>(this)));
															#line 6451 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 645 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActorState(); static_cast<MasterServerImplActor*>(this)->destroy(); return 0; }
															#line 6475 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<MasterServerImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 645 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActorState(); static_cast<MasterServerImplActor*>(this)->destroy(); return 0; }
															#line 6487 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<MasterServerImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MasterServerImplActor*>(this)->actor_wait_state > 0) static_cast<MasterServerImplActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerImplActor*>(this)->ActorCallback< MasterServerImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MasterServerImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 648 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActorState(); static_cast<MasterServerImplActor*>(this)->destroy(); return 0; }
															#line 6574 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<MasterServerImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 648 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActorState(); static_cast<MasterServerImplActor*>(this)->destroy(); return 0; }
															#line 6586 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<MasterServerImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActorState();
		static_cast<MasterServerImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MasterServerImplActor*>(this)->actor_wait_state > 0) static_cast<MasterServerImplActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerImplActor*>(this)->ActorCallback< MasterServerImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MasterServerImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterInterface mi;
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServerCoordinators coordinators;
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	LifetimeToken lifetime;
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	bool forceRecovery;
															#line 631 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 632 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<MasterData> self;
															#line 6685 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via masterServerImpl()
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerImplActor final : public Actor<Void>, public ActorCallback< MasterServerImplActor, 0, Void >, public ActorCallback< MasterServerImplActor, 1, Void >, public FastAllocated<MasterServerImplActor>, public MasterServerImplActorState<MasterServerImplActor> {
															#line 6690 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<MasterServerImplActor>::operator new;
	using FastAllocated<MasterServerImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12007119246402093568UL, 5218207728896595456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MasterServerImplActor, 0, Void >;
friend struct ActorCallback< MasterServerImplActor, 1, Void >;
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerImplActor(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 6708 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   MasterServerImplActorState<MasterServerImplActor>(mi, db, ccInterface, coordinators, lifetime, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7489675442780390912UL, 14990147009436098560UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("masterServerImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MasterServerImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MasterServerImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> masterServerImpl( MasterInterface const& mi, Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, ServerCoordinators const& coordinators, LifetimeToken const& lifetime, bool const& forceRecovery ) {
															#line 623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new MasterServerImplActor(mi, db, ccInterface, coordinators, lifetime, forceRecovery));
															#line 6742 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 651 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#else
															#line 6747 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via masterServerImpl()
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class MasterServerImplActor1>
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerImplActor1State {
															#line 6754 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerImplActor1State(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : mi(mi),
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   db(db),
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccInterface(ccInterface),
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   coordinators(coordinators),
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   lifetime(lifetime),
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   forceRecovery(forceRecovery)
															#line 6771 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("masterServerImpl", reinterpret_cast<unsigned long>(this));

	}
	~MasterServerImplActor1State() 
	{
		fdb_probe_actor_destroy("masterServerImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 658 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			StrictFuture<Void> __when_expr_0 = masterServerCxx(mi, db, ccInterface, coordinators, lifetime, forceRecovery);
															#line 658 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (static_cast<MasterServerImplActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6788 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MasterServerImplActor1*>(this)->actor_wait_state = 1;
															#line 658 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MasterServerImplActor1, 0, Void >*>(static_cast<MasterServerImplActor1*>(this)));
															#line 6793 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MasterServerImplActor1State();
		static_cast<MasterServerImplActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 659 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActor1State(); static_cast<MasterServerImplActor1*>(this)->destroy(); return 0; }
															#line 6816 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<MasterServerImplActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActor1State();
		static_cast<MasterServerImplActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 659 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerImplActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerImplActor1State(); static_cast<MasterServerImplActor1*>(this)->destroy(); return 0; }
															#line 6828 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<MasterServerImplActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerImplActor1State();
		static_cast<MasterServerImplActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MasterServerImplActor1*>(this)->actor_wait_state > 0) static_cast<MasterServerImplActor1*>(this)->actor_wait_state = 0;
		static_cast<MasterServerImplActor1*>(this)->ActorCallback< MasterServerImplActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MasterServerImplActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MasterServerImplActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterInterface mi;
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServerCoordinators coordinators;
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	LifetimeToken lifetime;
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	bool forceRecovery;
															#line 6923 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via masterServerImpl()
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerImplActor1 final : public Actor<Void>, public ActorCallback< MasterServerImplActor1, 0, Void >, public FastAllocated<MasterServerImplActor1>, public MasterServerImplActor1State<MasterServerImplActor1> {
															#line 6928 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<MasterServerImplActor1>::operator new;
	using FastAllocated<MasterServerImplActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12007119246402093568UL, 5218207728896595456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MasterServerImplActor1, 0, Void >;
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerImplActor1(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 6945 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   MasterServerImplActor1State<MasterServerImplActor1>(mi, db, ccInterface, coordinators, lifetime, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("masterServerImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5307128214695394048UL, 3350264534321644288UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerImplActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("masterServerImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("masterServerImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MasterServerImplActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> masterServerImpl( MasterInterface const& mi, Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, ServerCoordinators const& coordinators, LifetimeToken const& lifetime, bool const& forceRecovery ) {
															#line 652 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new MasterServerImplActor1(mi, db, ccInterface, coordinators, lifetime, forceRecovery));
															#line 6978 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 661 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
#endif

															#line 6984 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via masterServer()
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class MasterServerActor>
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerActorState {
															#line 6991 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerActorState(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : mi(mi),
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   db(db),
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccInterface(ccInterface),
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   coordinators(coordinators),
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   lifetime(lifetime),
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   forceRecovery(forceRecovery),
															#line 670 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		   ccTimeout(delay(SERVER_KNOBS->CC_INTERFACE_TIMEOUT))
															#line 7010 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("masterServer", reinterpret_cast<unsigned long>(this));

	}
	~MasterServerActorState() 
	{
		fdb_probe_actor_destroy("masterServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 671 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			;
															#line 7025 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MasterServerActorState();
		static_cast<MasterServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 682 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		onDBChange = Void();
															#line 683 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_1 = onDBChange;
															#line 683 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7052 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MasterServerActor*>(this)->actor_wait_state = 2;
															#line 683 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MasterServerActor, 1, Void >*>(static_cast<MasterServerActor*>(this)));
															#line 7057 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 671 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!(!ccInterface->get().present() || db->get().clusterInterface != ccInterface->get().get()))
															#line 7073 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 672 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_0 = ccInterface->onChange() || db->onChange() || ccTimeout;
															#line 672 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7081 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MasterServerActor*>(this)->actor_wait_state = 1;
															#line 672 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MasterServerActor, 0, Void >*>(static_cast<MasterServerActor*>(this)));
															#line 7086 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 673 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (ccTimeout.isReady())
															#line 7108 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 674 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "Timeout") .detail("CCInterface", ccInterface->get().present() ? ccInterface->get().get().id() : UID()) .detail("DBInfoInterface", db->get().clusterInterface.id());
															#line 678 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerActorState(); static_cast<MasterServerActor*>(this)->destroy(); return 0; }
															#line 7114 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<MasterServerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerActorState();
			static_cast<MasterServerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 673 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (ccTimeout.isReady())
															#line 7128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		{
															#line 674 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			TraceEvent("MasterTerminated", mi.id()) .detail("Reason", "Timeout") .detail("CCInterface", ccInterface->get().present() ? ccInterface->get().get().id() : UID()) .detail("DBInfoInterface", db->get().clusterInterface.id());
															#line 678 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<MasterServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerActorState(); static_cast<MasterServerActor*>(this)->destroy(); return 0; }
															#line 7134 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<MasterServerActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MasterServerActorState();
			static_cast<MasterServerActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MasterServerActor*>(this)->actor_wait_state > 0) static_cast<MasterServerActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerActor*>(this)->ActorCallback< MasterServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MasterServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 684 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = masterServerImpl(mi, db, ccInterface, coordinators, lifetime, forceRecovery);
															#line 684 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7225 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MasterServerActor*>(this)->actor_wait_state = 3;
															#line 684 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MasterServerActor, 2, Void >*>(static_cast<MasterServerActor*>(this)));
															#line 7230 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 684 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		StrictFuture<Void> __when_expr_2 = masterServerImpl(mi, db, ccInterface, coordinators, lifetime, forceRecovery);
															#line 684 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (static_cast<MasterServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7241 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MasterServerActor*>(this)->actor_wait_state = 3;
															#line 684 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MasterServerActor, 2, Void >*>(static_cast<MasterServerActor*>(this)));
															#line 7246 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MasterServerActor*>(this)->actor_wait_state > 0) static_cast<MasterServerActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerActor*>(this)->ActorCallback< MasterServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MasterServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 685 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerActorState(); static_cast<MasterServerActor*>(this)->destroy(); return 0; }
															#line 7330 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<MasterServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerActorState();
		static_cast<MasterServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 685 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		if (!static_cast<MasterServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MasterServerActorState(); static_cast<MasterServerActor*>(this)->destroy(); return 0; }
															#line 7342 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		new (&static_cast<MasterServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MasterServerActorState();
		static_cast<MasterServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MasterServerActor*>(this)->actor_wait_state > 0) static_cast<MasterServerActor*>(this)->actor_wait_state = 0;
		static_cast<MasterServerActor*>(this)->ActorCallback< MasterServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MasterServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MasterServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterInterface mi;
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	ServerCoordinators coordinators;
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	LifetimeToken lifetime;
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	bool forceRecovery;
															#line 670 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> ccTimeout;
															#line 682 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	Future<Void> onDBChange;
															#line 7441 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via masterServer()
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class MasterServerActor final : public Actor<Void>, public ActorCallback< MasterServerActor, 0, Void >, public ActorCallback< MasterServerActor, 1, Void >, public ActorCallback< MasterServerActor, 2, Void >, public FastAllocated<MasterServerActor>, public MasterServerActorState<MasterServerActor> {
															#line 7446 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<MasterServerActor>::operator new;
	using FastAllocated<MasterServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5215381952330266112UL, 6948280913162817280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MasterServerActor, 0, Void >;
friend struct ActorCallback< MasterServerActor, 1, Void >;
friend struct ActorCallback< MasterServerActor, 2, Void >;
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	MasterServerActor(MasterInterface const& mi,Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,ServerCoordinators const& coordinators,LifetimeToken const& lifetime,bool const& forceRecovery) 
															#line 7465 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   MasterServerActorState<MasterServerActor>(mi, db, ccInterface, coordinators, lifetime, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("masterServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8935799279357725440UL, 15598559655778800384UL);
		ActorExecutionContextHelper __helper(static_cast<MasterServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("masterServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("masterServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MasterServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MasterServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MasterServerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
[[nodiscard]] Future<Void> masterServer( MasterInterface const& mi, Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, ServerCoordinators const& coordinators, LifetimeToken const& lifetime, bool const& forceRecovery ) {
															#line 663 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new MasterServerActor(mi, db, ccInterface, coordinators, lifetime, forceRecovery));
															#line 7500 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}

#line 687 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7505 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase688()
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase688Actor>
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase688ActorState {
															#line 7512 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase688ActorState(UnitTestParameters const& params) 
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7519 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase688", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase688ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase688", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 689 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ( figureVersion(0, 1.0, 0, 1e6, SERVER_KNOBS->MAX_VERSION_RATE_MODIFIER, SERVER_KNOBS->MAX_VERSION_RATE_OFFSET), 1e6);
															#line 692 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 1.5, 0, 100, 0.1, 1e6), 1000110);
															#line 693 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 1.5, 0, 550000, 0.1, 1e6), 1500000);
															#line 694 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase688Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase688ActorState(); static_cast<FlowTestCase688Actor*>(this)->destroy(); return 0; }
															#line 7540 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<FlowTestCase688Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase688ActorState();
			static_cast<FlowTestCase688Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase688ActorState();
		static_cast<FlowTestCase688Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 7564 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase688()
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase688Actor final : public Actor<Void>, public FastAllocated<FlowTestCase688Actor>, public FlowTestCase688ActorState<FlowTestCase688Actor> {
															#line 7569 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase688Actor>::operator new;
	using FastAllocated<FlowTestCase688Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(974626100069886208UL, 5686151349914144000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase688Actor(UnitTestParameters const& params) 
															#line 7585 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase688ActorState<FlowTestCase688Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase688", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4809578758301895168UL, 15566773527449175552UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase688Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase688");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase688", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase688( UnitTestParameters const& params ) {
															#line 688 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase688Actor(params));
															#line 7617 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase688, "/fdbserver/MasterServer/FigureVersion/Simple")

#line 696 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7623 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase697()
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase697Actor>
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase697ActorState {
															#line 7630 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase697ActorState(UnitTestParameters const& params) 
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7637 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase697", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase697ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase697", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 699 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 2.0, 0, 1, 0.0001, 1e6), 1000001);
															#line 700 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 0.0, 0, 1, 0.1, 1e6), 1000001);
															#line 701 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase697Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase697ActorState(); static_cast<FlowTestCase697Actor*>(this)->destroy(); return 0; }
															#line 7656 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<FlowTestCase697Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase697ActorState();
			static_cast<FlowTestCase697Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase697ActorState();
		static_cast<FlowTestCase697Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 7680 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase697()
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase697Actor final : public Actor<Void>, public FastAllocated<FlowTestCase697Actor>, public FlowTestCase697ActorState<FlowTestCase697Actor> {
															#line 7685 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase697Actor>::operator new;
	using FastAllocated<FlowTestCase697Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3060480388968983808UL, 12425469971725947648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase697Actor(UnitTestParameters const& params) 
															#line 7701 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase697ActorState<FlowTestCase697Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase697", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5629460012882567424UL, 6444844894057364224UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase697Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase697");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase697", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase697( UnitTestParameters const& params ) {
															#line 697 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase697Actor(params));
															#line 7733 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase697, "/fdbserver/MasterServer/FigureVersion/Small")

#line 703 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7739 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase704()
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase704Actor>
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase704ActorState {
															#line 7746 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase704ActorState(UnitTestParameters const& params) 
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7753 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase704", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase704ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase704", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 705 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 10.0, 0, 5e6, 0.1, 1e6), 6500000);
															#line 706 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 20.0, 0, 15e6, 0.1, 1e6), 17e6);
															#line 707 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase704Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase704ActorState(); static_cast<FlowTestCase704Actor*>(this)->destroy(); return 0; }
															#line 7772 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<FlowTestCase704Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase704ActorState();
			static_cast<FlowTestCase704Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase704ActorState();
		static_cast<FlowTestCase704Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 7796 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase704()
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase704Actor final : public Actor<Void>, public FastAllocated<FlowTestCase704Actor>, public FlowTestCase704ActorState<FlowTestCase704Actor> {
															#line 7801 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase704Actor>::operator new;
	using FastAllocated<FlowTestCase704Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(879840567399041024UL, 16229224788651132416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase704Actor(UnitTestParameters const& params) 
															#line 7817 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase704ActorState<FlowTestCase704Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase704", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16030608593731675648UL, 4844472447775959808UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase704Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase704");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase704", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase704( UnitTestParameters const& params ) {
															#line 704 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase704Actor(params));
															#line 7849 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase704, "/fdbserver/MasterServer/FigureVersion/MaxOffset")

#line 709 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7855 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase710()
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase710Actor>
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase710ActorState {
															#line 7862 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase710ActorState(UnitTestParameters const& params) 
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7869 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase710", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase710ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase710", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 711 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 3.0, 1e6, 1e6, 0.1, 1e6), 2e6);
															#line 712 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(1e6, 3.0, 1e6, 100, 0.1, 1e6), 1000110);
															#line 713 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase710Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase710ActorState(); static_cast<FlowTestCase710Actor*>(this)->destroy(); return 0; }
															#line 7888 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<FlowTestCase710Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase710ActorState();
			static_cast<FlowTestCase710Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase710ActorState();
		static_cast<FlowTestCase710Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 7912 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase710()
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase710Actor final : public Actor<Void>, public FastAllocated<FlowTestCase710Actor>, public FlowTestCase710ActorState<FlowTestCase710Actor> {
															#line 7917 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase710Actor>::operator new;
	using FastAllocated<FlowTestCase710Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17224705461389860352UL, 14392254694159990016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase710Actor(UnitTestParameters const& params) 
															#line 7933 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase710ActorState<FlowTestCase710Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase710", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15754981172551286784UL, 8976077587038495488UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase710Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase710");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase710", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase710( UnitTestParameters const& params ) {
															#line 710 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase710Actor(params));
															#line 7965 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase710, "/fdbserver/MasterServer/FigureVersion/PositiveReferenceVersion")

#line 715 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"

															#line 7971 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase716()
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
template <class FlowTestCase716Actor>
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase716ActorState {
															#line 7978 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase716ActorState(UnitTestParameters const& params) 
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
		 : params(params)
															#line 7985 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase716", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase716ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase716", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 717 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(0, 2.0, -1e6, 3e6, 0.1, 1e6), 3e6);
															#line 718 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			ASSERT_EQ(figureVersion(0, 2.0, -1e6, 5e5, 0.1, 1e6), 550000);
															#line 719 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
			if (!static_cast<FlowTestCase716Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase716ActorState(); static_cast<FlowTestCase716Actor*>(this)->destroy(); return 0; }
															#line 8004 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
			new (&static_cast<FlowTestCase716Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase716ActorState();
			static_cast<FlowTestCase716Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase716ActorState();
		static_cast<FlowTestCase716Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	UnitTestParameters params;
															#line 8028 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase716()
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
class FlowTestCase716Actor final : public Actor<Void>, public FastAllocated<FlowTestCase716Actor>, public FlowTestCase716ActorState<FlowTestCase716Actor> {
															#line 8033 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase716Actor>::operator new;
	using FastAllocated<FlowTestCase716Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8992491895718363392UL, 10091285602214758144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	FlowTestCase716Actor(UnitTestParameters const& params) 
															#line 8049 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase716ActorState<FlowTestCase716Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase716", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18349594747525548800UL, 15542559926174985728UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase716Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase716");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase716", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
static Future<Void> flowTestCase716( UnitTestParameters const& params ) {
															#line 716 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
	return Future<Void>(new FlowTestCase716Actor(params));
															#line 8081 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/masterserver.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase716, "/fdbserver/MasterServer/FigureVersion/NegativeReferenceVersion")

#line 721 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/masterserver.actor.cpp"
