#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
/*
 * LeaderElection.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/Locality.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/Knobs.h"
#include "fdbclient/MonitorLeader.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Keep trying to become a leader by submitting itself to all coordinators.
// Monitor the health of all coordinators at the same time.
															#line 32 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
namespace {
// This generated class is to be used only via submitCandidacy()
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
template <class SubmitCandidacyActor>
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
class SubmitCandidacyActorState {
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
public:
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	SubmitCandidacyActorState(Key const& key,LeaderElectionRegInterface const& coord,LeaderInfo const& myInfo,UID const& prevChangeID,AsyncTrigger* const& nomineeChange,Optional<LeaderInfo>* const& nominee) 
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		 : key(key),
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   coord(coord),
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   myInfo(myInfo),
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   prevChangeID(prevChangeID),
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   nomineeChange(nomineeChange),
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   nominee(nominee)
															#line 56 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
	{
		fdb_probe_actor_create("submitCandidacy", reinterpret_cast<unsigned long>(this));

	}
	~SubmitCandidacyActorState() 
	{
		fdb_probe_actor_destroy("submitCandidacy", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 36 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			;
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SubmitCandidacyActorState();
		static_cast<SubmitCandidacyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 37 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		li = Optional<LeaderInfo>();
															#line 38 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (coord.hostname.present())
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store( li, retryGetReplyFromHostname( CandidacyRequest(key, myInfo, nominee->present() ? nominee->get().changeID : UID(), prevChangeID), coord.hostname.get(), WLTOKEN_LEADERELECTIONREG_CANDIDACY, TaskPriority::CoordinationReply));
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 109 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 1;
															#line 39 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SubmitCandidacyActor, 0, Void >*>(static_cast<SubmitCandidacyActor*>(this)));
															#line 114 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 47 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store( li, retryBrokenPromise( coord.candidacy, CandidacyRequest(key, myInfo, nominee->present() ? nominee->get().changeID : UID(), prevChangeID), TaskPriority::CoordinationReply));
															#line 47 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 123 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 2;
															#line 47 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitCandidacyActor, 1, Void >*>(static_cast<SubmitCandidacyActor*>(this)));
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 55 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_2 = Future<Void>(Void());
															#line 55 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 140 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 3;
															#line 55 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SubmitCandidacyActor, 2, Void >*>(static_cast<SubmitCandidacyActor*>(this)));
															#line 145 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state > 0) static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitCandidacyActor*>(this)->ActorCallback< SubmitCandidacyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitCandidacyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SubmitCandidacyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SubmitCandidacyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state > 0) static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitCandidacyActor*>(this)->ActorCallback< SubmitCandidacyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitCandidacyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SubmitCandidacyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SubmitCandidacyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (li != *nominee)
															#line 328 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			*nominee = li;
															#line 59 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			nomineeChange->trigger();
															#line 61 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (li.present() && li.get().forward)
															#line 336 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			{
															#line 62 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				StrictFuture<Void> __when_expr_3 = Future<Void>(Never());
															#line 62 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 342 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
				static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 4;
															#line 62 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SubmitCandidacyActor, 3, Void >*>(static_cast<SubmitCandidacyActor*>(this)));
															#line 347 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 57 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (li != *nominee)
															#line 366 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			*nominee = li;
															#line 59 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			nomineeChange->trigger();
															#line 61 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (li.present() && li.get().forward)
															#line 374 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			{
															#line 62 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				StrictFuture<Void> __when_expr_3 = Future<Void>(Never());
															#line 62 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 380 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
				static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 4;
															#line 62 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SubmitCandidacyActor, 3, Void >*>(static_cast<SubmitCandidacyActor*>(this)));
															#line 385 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state > 0) static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitCandidacyActor*>(this)->ActorCallback< SubmitCandidacyActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitCandidacyActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SubmitCandidacyActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SubmitCandidacyActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SubmitCandidacyActor*>(this)->actor_wait_state > 0) static_cast<SubmitCandidacyActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitCandidacyActor*>(this)->ActorCallback< SubmitCandidacyActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitCandidacyActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SubmitCandidacyActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SubmitCandidacyActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Key key;
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	LeaderElectionRegInterface coord;
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	LeaderInfo myInfo;
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	UID prevChangeID;
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	AsyncTrigger* nomineeChange;
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Optional<LeaderInfo>* nominee;
															#line 37 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Optional<LeaderInfo> li;
															#line 588 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
};
// This generated class is to be used only via submitCandidacy()
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
class SubmitCandidacyActor final : public Actor<Void>, public ActorCallback< SubmitCandidacyActor, 0, Void >, public ActorCallback< SubmitCandidacyActor, 1, Void >, public ActorCallback< SubmitCandidacyActor, 2, Void >, public ActorCallback< SubmitCandidacyActor, 3, Void >, public FastAllocated<SubmitCandidacyActor>, public SubmitCandidacyActorState<SubmitCandidacyActor> {
															#line 593 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
public:
	using FastAllocated<SubmitCandidacyActor>::operator new;
	using FastAllocated<SubmitCandidacyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(313292745965251840UL, 11941688399043977472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SubmitCandidacyActor, 0, Void >;
friend struct ActorCallback< SubmitCandidacyActor, 1, Void >;
friend struct ActorCallback< SubmitCandidacyActor, 2, Void >;
friend struct ActorCallback< SubmitCandidacyActor, 3, Void >;
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	SubmitCandidacyActor(Key const& key,LeaderElectionRegInterface const& coord,LeaderInfo const& myInfo,UID const& prevChangeID,AsyncTrigger* const& nomineeChange,Optional<LeaderInfo>* const& nominee) 
															#line 613 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		 : Actor<Void>(),
		   SubmitCandidacyActorState<SubmitCandidacyActor>(key, coord, myInfo, prevChangeID, nomineeChange, nominee),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("submitCandidacy", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9165188372898396416UL, 8264335575660447744UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitCandidacyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("submitCandidacy");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("submitCandidacy", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SubmitCandidacyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SubmitCandidacyActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SubmitCandidacyActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SubmitCandidacyActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
[[nodiscard]] Future<Void> submitCandidacy( Key const& key, LeaderElectionRegInterface const& coord, LeaderInfo const& myInfo, UID const& prevChangeID, AsyncTrigger* const& nomineeChange, Optional<LeaderInfo>* const& nominee ) {
															#line 30 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	return Future<Void>(new SubmitCandidacyActor(key, coord, myInfo, prevChangeID, nomineeChange, nominee));
															#line 649 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
}

#line 66 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"

															#line 654 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
namespace {
// This generated class is to be used only via buggifyDelayedAsyncVar()
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
template <class T, class BuggifyDelayedAsyncVarActor>
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
class BuggifyDelayedAsyncVarActorState {
															#line 661 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
public:
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	BuggifyDelayedAsyncVarActorState(Reference<AsyncVar<T>> const& in,Reference<AsyncVar<T>> const& out) 
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		 : in(in),
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   out(out)
															#line 670 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
	{
		fdb_probe_actor_create("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this));

	}
	~BuggifyDelayedAsyncVarActorState() 
	{
		fdb_probe_actor_destroy("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 70 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				;
															#line 686 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BuggifyDelayedAsyncVarActorState();
		static_cast<BuggifyDelayedAsyncVarActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			out->set(in->get());
															#line 77 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 718 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->BUGGIFIED_EVENTUAL_CONSISTENCY * deterministicRandom()->random01());
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 741 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state = 1;
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BuggifyDelayedAsyncVarActor, 0, Void >*>(static_cast<BuggifyDelayedAsyncVarActor*>(this)));
															#line 746 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		out->set(in->get());
															#line 73 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = in->onChange();
															#line 73 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 759 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BuggifyDelayedAsyncVarActor, 1, Void >*>(static_cast<BuggifyDelayedAsyncVarActor*>(this)));
															#line 764 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		out->set(in->get());
															#line 73 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_1 = in->onChange();
															#line 73 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 777 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BuggifyDelayedAsyncVarActor, 1, Void >*>(static_cast<BuggifyDelayedAsyncVarActor*>(this)));
															#line 782 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state > 0) static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state = 0;
		static_cast<BuggifyDelayedAsyncVarActor*>(this)->ActorCallback< BuggifyDelayedAsyncVarActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BuggifyDelayedAsyncVarActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuggifyDelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BuggifyDelayedAsyncVarActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuggifyDelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BuggifyDelayedAsyncVarActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuggifyDelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state > 0) static_cast<BuggifyDelayedAsyncVarActor*>(this)->actor_wait_state = 0;
		static_cast<BuggifyDelayedAsyncVarActor*>(this)->ActorCallback< BuggifyDelayedAsyncVarActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BuggifyDelayedAsyncVarActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuggifyDelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BuggifyDelayedAsyncVarActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuggifyDelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BuggifyDelayedAsyncVarActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuggifyDelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Reference<AsyncVar<T>> in;
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Reference<AsyncVar<T>> out;
															#line 953 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
};
// This generated class is to be used only via buggifyDelayedAsyncVar()
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
template <class T>
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
class BuggifyDelayedAsyncVarActor final : public Actor<Void>, public ActorCallback< BuggifyDelayedAsyncVarActor<T>, 0, Void >, public ActorCallback< BuggifyDelayedAsyncVarActor<T>, 1, Void >, public FastAllocated<BuggifyDelayedAsyncVarActor<T>>, public BuggifyDelayedAsyncVarActorState<T, BuggifyDelayedAsyncVarActor<T>> {
															#line 960 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
public:
	using FastAllocated<BuggifyDelayedAsyncVarActor<T>>::operator new;
	using FastAllocated<BuggifyDelayedAsyncVarActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(281715241171301888UL, 4307897148675441664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BuggifyDelayedAsyncVarActor<T>, 0, Void >;
friend struct ActorCallback< BuggifyDelayedAsyncVarActor<T>, 1, Void >;
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	BuggifyDelayedAsyncVarActor(Reference<AsyncVar<T>> const& in,Reference<AsyncVar<T>> const& out) 
															#line 978 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		 : Actor<Void>(),
		   BuggifyDelayedAsyncVarActorState<T, BuggifyDelayedAsyncVarActor<T>>(in, out),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9880497529410750976UL, 2398884987112718592UL);
		ActorExecutionContextHelper __helper(static_cast<BuggifyDelayedAsyncVarActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("buggifyDelayedAsyncVar");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("buggifyDelayedAsyncVar", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BuggifyDelayedAsyncVarActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BuggifyDelayedAsyncVarActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
template <class T>
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
[[nodiscard]] Future<Void> buggifyDelayedAsyncVar( Reference<AsyncVar<T>> const& in, Reference<AsyncVar<T>> const& out ) {
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	return Future<Void>(new BuggifyDelayedAsyncVarActor<T>(in, out));
															#line 1014 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
}

#line 80 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"

template <class T>
Future<Void> buggifyDelayedAsyncVar(Reference<AsyncVar<T>>& var) {
	auto in = makeReference<AsyncVar<T>>();
	auto f = buggifyDelayedAsyncVar(in, var);
	var = in;
	return f;
}

															#line 1027 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
namespace {
// This generated class is to be used only via changeLeaderCoordinators()
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
template <class ChangeLeaderCoordinatorsActor>
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
class ChangeLeaderCoordinatorsActorState {
															#line 1034 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
public:
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	ChangeLeaderCoordinatorsActorState(ServerCoordinators const& coordinators,Value const& forwardingInfo) 
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		 : coordinators(coordinators),
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   forwardingInfo(forwardingInfo)
															#line 1043 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
	{
		fdb_probe_actor_create("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this));

	}
	~ChangeLeaderCoordinatorsActorState() 
	{
		fdb_probe_actor_destroy("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 90 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			std::vector<Future<Void>> forwardRequests;
															#line 91 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			forwardRequests.reserve(coordinators.leaderElectionServers.size());
															#line 92 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			for(int i = 0;i < coordinators.leaderElectionServers.size();i++) {
															#line 93 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				if (coordinators.leaderElectionServers[i].hostname.present())
															#line 1064 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				{
															#line 94 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					forwardRequests.push_back(retryGetReplyFromHostname(ForwardRequest(coordinators.clusterKey, forwardingInfo), coordinators.leaderElectionServers[i].hostname.get(), WLTOKEN_LEADERELECTIONREG_FORWARD));
															#line 1068 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				}
				else
				{
															#line 98 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					forwardRequests.push_back(retryBrokenPromise(coordinators.leaderElectionServers[i].forward, ForwardRequest(coordinators.clusterKey, forwardingInfo)));
															#line 1074 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				}
			}
															#line 102 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			int quorum_size = forwardRequests.size() / 2 + 1;
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			StrictFuture<Void> __when_expr_0 = quorum(forwardRequests, quorum_size);
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (static_cast<ChangeLeaderCoordinatorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1083 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeLeaderCoordinatorsActor*>(this)->actor_wait_state = 1;
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeLeaderCoordinatorsActor, 0, Void >*>(static_cast<ChangeLeaderCoordinatorsActor*>(this)));
															#line 1088 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeLeaderCoordinatorsActorState();
		static_cast<ChangeLeaderCoordinatorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (!static_cast<ChangeLeaderCoordinatorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeLeaderCoordinatorsActorState(); static_cast<ChangeLeaderCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 1111 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		new (&static_cast<ChangeLeaderCoordinatorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeLeaderCoordinatorsActorState();
		static_cast<ChangeLeaderCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (!static_cast<ChangeLeaderCoordinatorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeLeaderCoordinatorsActorState(); static_cast<ChangeLeaderCoordinatorsActor*>(this)->destroy(); return 0; }
															#line 1123 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		new (&static_cast<ChangeLeaderCoordinatorsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeLeaderCoordinatorsActorState();
		static_cast<ChangeLeaderCoordinatorsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeLeaderCoordinatorsActor*>(this)->actor_wait_state > 0) static_cast<ChangeLeaderCoordinatorsActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLeaderCoordinatorsActor*>(this)->ActorCallback< ChangeLeaderCoordinatorsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLeaderCoordinatorsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLeaderCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeLeaderCoordinatorsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLeaderCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeLeaderCoordinatorsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLeaderCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	ServerCoordinators coordinators;
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Value forwardingInfo;
															#line 1210 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
};
// This generated class is to be used only via changeLeaderCoordinators()
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
class ChangeLeaderCoordinatorsActor final : public Actor<Void>, public ActorCallback< ChangeLeaderCoordinatorsActor, 0, Void >, public FastAllocated<ChangeLeaderCoordinatorsActor>, public ChangeLeaderCoordinatorsActorState<ChangeLeaderCoordinatorsActor> {
															#line 1215 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
public:
	using FastAllocated<ChangeLeaderCoordinatorsActor>::operator new;
	using FastAllocated<ChangeLeaderCoordinatorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6254382395380329216UL, 7001760915640688640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeLeaderCoordinatorsActor, 0, Void >;
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	ChangeLeaderCoordinatorsActor(ServerCoordinators const& coordinators,Value const& forwardingInfo) 
															#line 1232 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeLeaderCoordinatorsActorState<ChangeLeaderCoordinatorsActor>(coordinators, forwardingInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(371468786727596288UL, 10854447875325431552UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLeaderCoordinatorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeLeaderCoordinators");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeLeaderCoordinators", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeLeaderCoordinatorsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
[[nodiscard]] Future<Void> changeLeaderCoordinators( ServerCoordinators const& coordinators, Value const& forwardingInfo ) {
															#line 89 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	return Future<Void>(new ChangeLeaderCoordinatorsActor(coordinators, forwardingInfo));
															#line 1265 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
}

#line 106 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"

															#line 1270 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
namespace {
// This generated class is to be used only via tryBecomeLeaderInternal()
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
template <class TryBecomeLeaderInternalActor>
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
class TryBecomeLeaderInternalActorState {
															#line 1277 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
public:
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	TryBecomeLeaderInternalActorState(ServerCoordinators const& coordinators,Value const& proposedSerializedInterface,Reference<AsyncVar<Value>> const& outSerializedLeader,bool const& hasConnected,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo) 
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		 : coordinators(coordinators),
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   proposedSerializedInterface(proposedSerializedInterface),
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   outSerializedLeader(outSerializedLeader),
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   hasConnected(hasConnected),
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 112 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   nomineeChange(),
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   nominees(),
															#line 114 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   myInfo(),
															#line 115 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   candidacies(),
															#line 116 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   iAmLeader(false),
															#line 117 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		   prevChangeID()
															#line 1304 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
	{
		fdb_probe_actor_create("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this));

	}
	~TryBecomeLeaderInternalActorState() 
	{
		fdb_probe_actor_destroy("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 119 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (asyncPriorityInfo->get().dcFitness == ClusterControllerPriorityInfo::FitnessBad || asyncPriorityInfo->get().dcFitness == ClusterControllerPriorityInfo::FitnessRemote || asyncPriorityInfo->get().dcFitness == ClusterControllerPriorityInfo::FitnessNotPreferred || asyncPriorityInfo->get().isExcluded)
															#line 1319 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			{
															#line 123 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WAIT_FOR_GOOD_REMOTE_RECRUITMENT_DELAY);
															#line 123 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1325 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 0, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 1330 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 124 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				if (asyncPriorityInfo->get().processClassFitness > ProcessClass::UnsetFit)
															#line 1337 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				{
															#line 125 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->WAIT_FOR_GOOD_RECRUITMENT_DELAY);
															#line 125 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1343 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 2;
															#line 125 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 1, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 1348 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryBecomeLeaderInternalActorState();
		static_cast<TryBecomeLeaderInternalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		nominees.resize(coordinators.leaderElectionServers.size());
															#line 130 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		myInfo.serializedInfo = proposedSerializedInterface;
															#line 131 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		outSerializedLeader->set(Value());
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		buggifyDelay = (SERVER_KNOBS->BUGGIFY_ALL_COORDINATION || BUGGIFY) ? buggifyDelayedAsyncVar(outSerializedLeader) : Void();
															#line 136 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		;
															#line 1385 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state > 0) static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 0;
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state > 0) static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 0;
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 232 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		ASSERT(iAmLeader && outSerializedLeader->get() == proposedSerializedInterface);
															#line 234 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		;
															#line 1576 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 136 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (!(!iAmLeader))
															#line 1592 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 137 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		badCandidateTimeout = Future<Void>();
															#line 139 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		myInfo.changeID = deterministicRandom()->randomUniqueID();
															#line 140 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		prevChangeID = myInfo.changeID;
															#line 141 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		myInfo.updateChangeID(asyncPriorityInfo->get());
															#line 143 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		std::vector<Future<Void>> cand;
															#line 144 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		cand.reserve(coordinators.leaderElectionServers.size());
															#line 145 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		for(int i = 0;i < coordinators.leaderElectionServers.size();i++) {
															#line 146 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			cand.push_back(submitCandidacy(coordinators.clusterKey, coordinators.leaderElectionServers[i], myInfo, prevChangeID, &nomineeChange, &nominees[i]));
															#line 1612 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		}
															#line 153 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		candidacies = waitForAll(cand);
															#line 155 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		;
															#line 1618 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 229 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		candidacies.cancel();
															#line 1640 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 156 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		leader = getLeader(nominees);
															#line 157 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (leader.present() && leader.get().first.forward)
															#line 1658 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 165 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			StrictFuture<Void> __when_expr_2 = changeLeaderCoordinators(coordinators, leader.get().first.serializedInfo);
															#line 164 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1664 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(20);
															#line 1668 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when2(__when_expr_3.get(), loopDepth); };
			static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 3;
															#line 165 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 2, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 3, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 1675 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 183 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (leader.present() && leader.get().second)
															#line 1702 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 184 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			hasConnected = true;
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			coordinators.ccr->notifyConnected();
															#line 1708 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		}
															#line 188 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (leader.present() && leader.get().second && leader.get().first.equalInternalId(myInfo))
															#line 1712 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 189 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			TraceEvent("BecomingLeader", myInfo.changeID).log();
															#line 190 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			ASSERT(leader.get().first.serializedInfo == proposedSerializedInterface);
															#line 191 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			outSerializedLeader->set(leader.get().first.serializedInfo);
															#line 192 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			iAmLeader = true;
															#line 1722 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 195 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (leader.present())
															#line 1727 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 196 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			TraceEvent("LeaderChanged", myInfo.changeID).detail("ToID", leader.get().first.changeID);
															#line 197 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (leader.get().first.serializedInfo != proposedSerializedInterface)
															#line 1733 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			{
															#line 200 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				outSerializedLeader->set(leader.get().first.serializedInfo);
															#line 1737 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			}
		}
															#line 206 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if ((!leader.present() || !leader.get().second) && std::find(nominees.begin(), nominees.end(), myInfo) != nominees.end())
															#line 1742 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 208 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (!badCandidateTimeout.isValid())
															#line 1746 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			{
															#line 209 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				badCandidateTimeout = delay(SERVER_KNOBS->POLLING_FREQUENCY * 2, TaskPriority::CoordinationReply);
															#line 1750 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			}
		}
		else
		{
															#line 211 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			badCandidateTimeout = Future<Void>();
															#line 1757 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		}
															#line 214 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_5 = nomineeChange.onTrigger();
															#line 213 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1763 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
															#line 215 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_6 = badCandidateTimeout.isValid() ? badCandidateTimeout : Never();
															#line 1767 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1cont1when2(__when_expr_6.get(), loopDepth); };
															#line 220 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_7 = candidacies;
															#line 1771 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1cont1when3(__when_expr_7.get(), loopDepth); };
															#line 223 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_8 = asyncPriorityInfo->onChange();
															#line 1775 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1cont1when4(__when_expr_8.get(), loopDepth); };
		static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 5;
															#line 214 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 5, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 215 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 6, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 220 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 7, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 223 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 8, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 1786 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 169 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (!hasConnected)
															#line 1795 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 170 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			TraceEvent(SevWarnAlways, "IncorrectClusterFileContentsAtConnection") .detail("ClusterFile", coordinators.ccr->toString()) .detail("StoredConnectionString", coordinators.ccr->getConnectionString().toString()) .detail("CurrentConnectionString", leader.get().first.serializedInfo.toString());
															#line 1799 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		}
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_4 = coordinators.ccr->setAndPersistConnectionString( ClusterConnectionString(leader.get().first.serializedInfo.toString()));
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1805 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 4;
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 4, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 1810 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state > 0) static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 0;
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 2, Void >::remove();
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		TraceEvent("LeaderForwarding") .detail("ConnStr", coordinators.ccr->getConnectionString().toString()) .trackLatest("LeaderForwarding");
															#line 180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		return a_body1Catch1(coordinators_changed(), std::max(0, loopDepth - 2));
															#line 1966 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		TraceEvent("LeaderForwarding") .detail("ConnStr", coordinators.ccr->getConnectionString().toString()) .trackLatest("LeaderForwarding");
															#line 180 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		return a_body1Catch1(coordinators_changed(), std::max(0, loopDepth - 2));
															#line 1976 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state > 0) static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 0;
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1loopBody1cont6(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		CODE_PROBE(true, "Bad candidate timeout");
															#line 217 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		TraceEvent("LeaderBadCandidateTimeout", myInfo.changeID).log();
															#line 2079 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when2(Void && _,int loopDepth) 
	{
															#line 216 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		CODE_PROBE(true, "Bad candidate timeout");
															#line 217 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		TraceEvent("LeaderBadCandidateTimeout", myInfo.changeID).log();
															#line 2090 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		ASSERT(false);
															#line 2099 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when3(Void && _,int loopDepth) 
	{
															#line 221 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		ASSERT(false);
															#line 2108 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when4(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1when4(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state > 0) static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 0;
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 5, Void >::remove();
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 6, Void >::remove();
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 7, Void >::remove();
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1loopBody1cont1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 296 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (SERVER_KNOBS->BUGGIFY_ALL_COORDINATION || BUGGIFY)
															#line 2366 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 297 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			StrictFuture<Void> __when_expr_14 = delay(SERVER_KNOBS->BUGGIFIED_EVENTUAL_CONSISTENCY * deterministicRandom()->random01());
															#line 297 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2372 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont6when1(__when_expr_14.get(), loopDepth); };
			static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 8;
															#line 297 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 14, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 2377 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 235 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		prevChangeID = myInfo.changeID;
															#line 236 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		myInfo.updateChangeID(asyncPriorityInfo->get());
															#line 237 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (myInfo.changeID != prevChangeID)
															#line 2402 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		{
															#line 238 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			TraceEvent("ChangeLeaderChangeID") .detail("PrevChangeID", prevChangeID) .detail("NewChangeID", myInfo.changeID);
															#line 2406 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		}
															#line 243 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		true_heartbeats = std::vector<Future<Void>>();
															#line 244 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		false_heartbeats = std::vector<Future<Void>>();
															#line 245 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		for(int i = 0;i < coordinators.leaderElectionServers.size();i++) {
															#line 246 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			Future<LeaderHeartbeatReply> hb;
															#line 247 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (coordinators.leaderElectionServers[i].hostname.present())
															#line 2418 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			{
															#line 248 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				hb = retryGetReplyFromHostname(LeaderHeartbeatRequest(coordinators.clusterKey, myInfo, prevChangeID), coordinators.leaderElectionServers[i].hostname.get(), WLTOKEN_LEADERELECTIONREG_LEADERHEARTBEAT, TaskPriority::CoordinationReply);
															#line 2422 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			}
			else
			{
															#line 253 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				hb = retryBrokenPromise(coordinators.leaderElectionServers[i].leaderHeartbeat, LeaderHeartbeatRequest(coordinators.clusterKey, myInfo, prevChangeID), TaskPriority::CoordinationReply);
															#line 2428 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			}
															#line 257 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			true_heartbeats.push_back(onEqual(hb, LeaderHeartbeatReply{ true }));
															#line 258 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			false_heartbeats.push_back(onEqual(hb, LeaderHeartbeatReply{ false }));
															#line 2434 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		}
															#line 261 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		rate = delay(SERVER_KNOBS->HEARTBEAT_FREQUENCY, TaskPriority::CoordinationReply) || asyncPriorityInfo->onChange();
															#line 265 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_9 = quorum(true_heartbeats, true_heartbeats.size() / 2 + 1);
															#line 264 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2442 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when1(__when_expr_9.get(), loopDepth); };
															#line 268 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_10 = quorum(false_heartbeats, false_heartbeats.size() / 2 + 1);
															#line 2446 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when2(__when_expr_10.get(), loopDepth); };
															#line 272 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_11 = delay(SERVER_KNOBS->POLLING_FREQUENCY);
															#line 2450 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when3(__when_expr_11.get(), loopDepth); };
															#line 290 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_12 = asyncPriorityInfo->onChange();
															#line 2454 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when4(__when_expr_12.get(), loopDepth); };
		static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 6;
															#line 265 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 9, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 268 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 10, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 272 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 11, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 290 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 12, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 2465 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(int loopDepth) 
	{
															#line 293 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		StrictFuture<Void> __when_expr_13 = rate;
															#line 293 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2489 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont1when1(__when_expr_13.get(), loopDepth); };
		static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 7;
															#line 293 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< TryBecomeLeaderInternalActor, 13, Void >*>(static_cast<TryBecomeLeaderInternalActor*>(this)));
															#line 2494 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 269 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		TraceEvent("ReplacedAsLeader", myInfo.changeID).log();
															#line 2515 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont5loopBody1when2(Void && _,int loopDepth) 
	{
															#line 269 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		TraceEvent("ReplacedAsLeader", myInfo.changeID).log();
															#line 2524 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont5loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 273 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		for(int i = 0;i < coordinators.leaderElectionServers.size();++i) {
															#line 274 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (true_heartbeats[i].isReady())
															#line 2535 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				TraceEvent("LeaderTrueHeartbeat", myInfo.changeID) .detail("Coordinator", coordinators.leaderElectionServers[i].candidacy.getEndpoint().getPrimaryAddress());
															#line 2539 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			}
			else
			{
															#line 278 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				if (false_heartbeats[i].isReady())
															#line 2545 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				{
															#line 279 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					TraceEvent("LeaderFalseHeartbeat", myInfo.changeID) .detail("Coordinator", coordinators.leaderElectionServers[i].candidacy.getEndpoint().getPrimaryAddress());
															#line 2549 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				}
				else
				{
															#line 283 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					TraceEvent("LeaderNoHeartbeat", myInfo.changeID) .detail("Coordinator", coordinators.leaderElectionServers[i].candidacy.getEndpoint().getPrimaryAddress());
															#line 2555 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				}
			}
		}
															#line 287 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		TraceEvent("ReleasingLeadership", myInfo.changeID).log();
															#line 2561 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont5loopBody1when3(Void && _,int loopDepth) 
	{
															#line 273 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		for(int i = 0;i < coordinators.leaderElectionServers.size();++i) {
															#line 274 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
			if (true_heartbeats[i].isReady())
															#line 2572 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			{
															#line 275 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				TraceEvent("LeaderTrueHeartbeat", myInfo.changeID) .detail("Coordinator", coordinators.leaderElectionServers[i].candidacy.getEndpoint().getPrimaryAddress());
															#line 2576 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
			}
			else
			{
															#line 278 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
				if (false_heartbeats[i].isReady())
															#line 2582 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				{
															#line 279 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					TraceEvent("LeaderFalseHeartbeat", myInfo.changeID) .detail("Coordinator", coordinators.leaderElectionServers[i].candidacy.getEndpoint().getPrimaryAddress());
															#line 2586 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				}
				else
				{
															#line 283 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
					TraceEvent("LeaderNoHeartbeat", myInfo.changeID) .detail("Coordinator", coordinators.leaderElectionServers[i].candidacy.getEndpoint().getPrimaryAddress());
															#line 2592 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
				}
			}
		}
															#line 287 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		TraceEvent("ReleasingLeadership", myInfo.changeID).log();
															#line 2598 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont5loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state > 0) static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 0;
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 9, Void >::remove();
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 10, Void >::remove();
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 11, Void >::remove();
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont5loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state > 0) static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 0;
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 299 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
		if (!static_cast<TryBecomeLeaderInternalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TryBecomeLeaderInternalActorState(); static_cast<TryBecomeLeaderInternalActor*>(this)->destroy(); return 0; }
															#line 2943 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		new (&static_cast<TryBecomeLeaderInternalActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TryBecomeLeaderInternalActorState();
		static_cast<TryBecomeLeaderInternalActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state > 0) static_cast<TryBecomeLeaderInternalActor*>(this)->actor_wait_state = 0;
		static_cast<TryBecomeLeaderInternalActor*>(this)->ActorCallback< TryBecomeLeaderInternalActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< TryBecomeLeaderInternalActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< TryBecomeLeaderInternalActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	ServerCoordinators coordinators;
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Value proposedSerializedInterface;
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Reference<AsyncVar<Value>> outSerializedLeader;
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	bool hasConnected;
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 112 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	AsyncTrigger nomineeChange;
															#line 113 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	std::vector<Optional<LeaderInfo>> nominees;
															#line 114 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	LeaderInfo myInfo;
															#line 115 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Future<Void> candidacies;
															#line 116 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	bool iAmLeader;
															#line 117 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	UID prevChangeID;
															#line 133 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Future<Void> buggifyDelay;
															#line 137 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Future<Void> badCandidateTimeout;
															#line 156 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Optional<std::pair<LeaderInfo, bool>> leader;
															#line 243 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	std::vector<Future<Void>> true_heartbeats;
															#line 244 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	std::vector<Future<Void>> false_heartbeats;
															#line 261 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	Future<Void> rate;
															#line 3072 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
};
// This generated class is to be used only via tryBecomeLeaderInternal()
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
class TryBecomeLeaderInternalActor final : public Actor<Void>, public ActorCallback< TryBecomeLeaderInternalActor, 0, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 1, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 2, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 3, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 4, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 5, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 6, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 7, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 8, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 9, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 10, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 11, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 12, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 13, Void >, public ActorCallback< TryBecomeLeaderInternalActor, 14, Void >, public FastAllocated<TryBecomeLeaderInternalActor>, public TryBecomeLeaderInternalActorState<TryBecomeLeaderInternalActor> {
															#line 3077 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
public:
	using FastAllocated<TryBecomeLeaderInternalActor>::operator new;
	using FastAllocated<TryBecomeLeaderInternalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(846201069425733888UL, 6462280620134493952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryBecomeLeaderInternalActor, 0, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 1, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 2, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 3, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 4, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 5, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 6, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 7, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 8, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 9, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 10, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 11, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 12, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 13, Void >;
friend struct ActorCallback< TryBecomeLeaderInternalActor, 14, Void >;
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	TryBecomeLeaderInternalActor(ServerCoordinators const& coordinators,Value const& proposedSerializedInterface,Reference<AsyncVar<Value>> const& outSerializedLeader,bool const& hasConnected,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo) 
															#line 3108 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
		 : Actor<Void>(),
		   TryBecomeLeaderInternalActorState<TryBecomeLeaderInternalActor>(coordinators, proposedSerializedInterface, outSerializedLeader, hasConnected, asyncPriorityInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17752123018324818176UL, 10998112715155683840UL);
		ActorExecutionContextHelper __helper(static_cast<TryBecomeLeaderInternalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryBecomeLeaderInternal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryBecomeLeaderInternal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryBecomeLeaderInternalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryBecomeLeaderInternalActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TryBecomeLeaderInternalActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TryBecomeLeaderInternalActor, 4, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TryBecomeLeaderInternalActor, 5, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< TryBecomeLeaderInternalActor, 9, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< TryBecomeLeaderInternalActor, 13, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< TryBecomeLeaderInternalActor, 14, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
[[nodiscard]] Future<Void> tryBecomeLeaderInternal( ServerCoordinators const& coordinators, Value const& proposedSerializedInterface, Reference<AsyncVar<Value>> const& outSerializedLeader, bool const& hasConnected, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo ) {
															#line 107 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
	return Future<Void>(new TryBecomeLeaderInternalActor(coordinators, proposedSerializedInterface, outSerializedLeader, hasConnected, asyncPriorityInfo));
															#line 3148 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbserver/LeaderElection.actor.g.cpp"
}

#line 301 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbserver/LeaderElection.actor.cpp"
