#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
/*
 * Util.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/Schemas.h"
#include "fdbclient/Status.h"

#include "flow/Arena.h"

#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

bool tokencmp(StringRef token, const char* command) {
	if (token.size() != strlen(command))
		return false;

	return !memcmp(token.begin(), command, token.size());
}

void printUsage(StringRef command) {
	const auto& helpMap = CommandFactory::commands();
	auto i = helpMap.find(command.toString());
	if (i != helpMap.end())
		printf("Usage: %s\n", i->second.usage.c_str());
	else
		fprintf(stderr, "ERROR: Unknown command `%s'\n", command.toString().c_str());
}

void printLongDesc(StringRef command) {
	const auto& helpMap = CommandFactory::commands();
	auto i = helpMap.find(command.toString());
	if (i != helpMap.end())
		printf("%s\n", i->second.long_desc.c_str());
	else
		fprintf(stderr, "ERROR: Unknown command `%s'\n", command.toString().c_str());
}

															#line 60 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
// This generated class is to be used only via getSpecialKeysFailureErrorMessage()
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
template <class GetSpecialKeysFailureErrorMessageActor>
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
class GetSpecialKeysFailureErrorMessageActorState {
															#line 66 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
public:
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	GetSpecialKeysFailureErrorMessageActorState(Reference<ITransaction> const& tr) 
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		 : tr(tr),
															#line 60 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		   errorMsgF(tr->get(fdb_cli::errorMsgSpecialKey))
															#line 75 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
	{
		fdb_probe_actor_create("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this));

	}
	~GetSpecialKeysFailureErrorMessageActorState() 
	{
		fdb_probe_actor_destroy("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = safeThreadFutureToFuture(errorMsgF);
															#line 61 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 92 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->actor_wait_state = 1;
															#line 61 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetSpecialKeysFailureErrorMessageActor, 0, Optional<Value> >*>(static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)));
															#line 97 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetSpecialKeysFailureErrorMessageActorState();
		static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& errorMsg,int loopDepth) 
	{
															#line 63 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(errorMsg.present());
															#line 65 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 68 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		std::string errorStr;
															#line 69 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		if (!static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->SAV<std::string>::futures) { (void)(valueObj["message"].get_str()); this->~GetSpecialKeysFailureErrorMessageActorState(); static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->destroy(); return 0; }
															#line 130 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		new (&static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->SAV< std::string >::value()) std::string(valueObj["message"].get_str());
		this->~GetSpecialKeysFailureErrorMessageActorState();
		static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && errorMsg,int loopDepth) 
	{
															#line 63 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(errorMsg.present());
															#line 65 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		auto valueObj = readJSONStrictly(errorMsg.get().toString()).get_obj();
															#line 67 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		auto schema = readJSONStrictly(JSONSchemas::managementApiErrorSchema.toString()).get_obj();
															#line 68 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		std::string errorStr;
															#line 69 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(schemaMatch(schema, valueObj, errorStr, SevError, true));
															#line 71 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		if (!static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->SAV<std::string>::futures) { (void)(valueObj["message"].get_str()); this->~GetSpecialKeysFailureErrorMessageActorState(); static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->destroy(); return 0; }
															#line 152 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		new (&static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->SAV< std::string >::value()) std::string(valueObj["message"].get_str());
		this->~GetSpecialKeysFailureErrorMessageActorState();
		static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont1(errorMsg, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && errorMsg,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(errorMsg), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->actor_wait_state > 0) static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->actor_wait_state = 0;
		static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->ActorCallback< GetSpecialKeysFailureErrorMessageActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetSpecialKeysFailureErrorMessageActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetSpecialKeysFailureErrorMessageActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetSpecialKeysFailureErrorMessageActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	Reference<ITransaction> tr;
															#line 60 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	ThreadFuture<Optional<Value>> errorMsgF;
															#line 239 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
};
// This generated class is to be used only via getSpecialKeysFailureErrorMessage()
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
class GetSpecialKeysFailureErrorMessageActor final : public Actor<std::string>, public ActorCallback< GetSpecialKeysFailureErrorMessageActor, 0, Optional<Value> >, public FastAllocated<GetSpecialKeysFailureErrorMessageActor>, public GetSpecialKeysFailureErrorMessageActorState<GetSpecialKeysFailureErrorMessageActor> {
															#line 244 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
public:
	using FastAllocated<GetSpecialKeysFailureErrorMessageActor>::operator new;
	using FastAllocated<GetSpecialKeysFailureErrorMessageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(622638718336177920UL, 15390012585065417728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetSpecialKeysFailureErrorMessageActor, 0, Optional<Value> >;
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	GetSpecialKeysFailureErrorMessageActor(Reference<ITransaction> const& tr) 
															#line 261 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		 : Actor<std::string>(),
		   GetSpecialKeysFailureErrorMessageActorState<GetSpecialKeysFailureErrorMessageActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8633415147322027008UL, 14796903721965383168UL);
		ActorExecutionContextHelper __helper(static_cast<GetSpecialKeysFailureErrorMessageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getSpecialKeysFailureErrorMessage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getSpecialKeysFailureErrorMessage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetSpecialKeysFailureErrorMessageActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
[[nodiscard]] Future<std::string> getSpecialKeysFailureErrorMessage( Reference<ITransaction> const& tr ) {
															#line 58 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	return Future<std::string>(new GetSpecialKeysFailureErrorMessageActor(tr));
															#line 293 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
}

#line 73 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"

void addInterfacesFromKVs(RangeResult& kvs,
                          std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* address_interface) {
	for (const auto& kv : kvs) {
		ClientWorkerInterface workerInterf;
		try {
			// the interface is back-ward compatible, thus if parsing failed, it needs to upgrade cli version
			workerInterf = BinaryReader::fromStringRef<ClientWorkerInterface>(kv.value, IncludeVersion());
		} catch (Error& e) {
			fprintf(stderr, "Error: %s; CLI version is too old, please update to use a newer version\n", e.what());
			return;
		}
		ClientLeaderRegInterface leaderInterf(workerInterf.address());
		StringRef ip_port = (kv.key.endsWith(":tls"_sr) ? kv.key.removeSuffix(":tls"_sr) : kv.key)
		                        .removePrefix("\xff\xff/worker_interfaces/"_sr);
		(*address_interface)[ip_port] = std::make_pair(kv.value, leaderInterf);

		if (workerInterf.reboot.getEndpoint().addresses.secondaryAddress.present()) {
			Key full_ip_port2 =
			    StringRef(workerInterf.reboot.getEndpoint().addresses.secondaryAddress.get().toString());
			StringRef ip_port2 =
			    full_ip_port2.endsWith(":tls"_sr) ? full_ip_port2.removeSuffix(":tls"_sr) : full_ip_port2;
			(*address_interface)[ip_port2] = std::make_pair(kv.value, leaderInterf);
		}
	}
}

															#line 324 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
// This generated class is to be used only via getWorkerInterfaces()
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
template <class GetWorkerInterfacesActor>
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
class GetWorkerInterfacesActorState {
															#line 330 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
public:
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	GetWorkerInterfacesActorState(Reference<ITransaction> const& tr,std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface,bool const& verify) 
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		 : tr(tr),
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		   address_interface(address_interface),
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		   verify(verify)
															#line 341 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
	{
		fdb_probe_actor_create("getWorkerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkerInterfacesActorState() 
	{
		fdb_probe_actor_destroy("getWorkerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 103 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (verify)
															#line 356 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			{
															#line 104 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
				tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 105 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
				tr->set(workerInterfacesVerifyOptionSpecialKey, ValueRef());
															#line 362 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			}
															#line 108 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			kvsFuture = tr->getRange( KeyRangeRef("\xff\xff/worker_interfaces/"_sr, "\xff\xff/worker_interfaces0"_sr), CLIENT_KNOBS->TOO_MANY);
															#line 110 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(kvsFuture);
															#line 110 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (static_cast<GetWorkerInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 370 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetWorkerInterfacesActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkerInterfacesActor, 0, RangeResult >*>(static_cast<GetWorkerInterfacesActor*>(this)));
															#line 375 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkerInterfacesActorState();
		static_cast<GetWorkerInterfacesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 111 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(!kvs.more);
															#line 112 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		if (verify)
															#line 400 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		{
															#line 114 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			tr->clear(workerInterfacesVerifyOptionSpecialKey);
															#line 404 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		}
															#line 116 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		addInterfacesFromKVs(kvs, address_interface);
															#line 117 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		if (!static_cast<GetWorkerInterfacesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetWorkerInterfacesActorState(); static_cast<GetWorkerInterfacesActor*>(this)->destroy(); return 0; }
															#line 410 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		new (&static_cast<GetWorkerInterfacesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetWorkerInterfacesActorState();
		static_cast<GetWorkerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __kvs,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		kvs = __kvs;
															#line 422 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __kvs,int loopDepth) 
	{
		kvs = std::move(__kvs);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkerInterfacesActor*>(this)->actor_wait_state > 0) static_cast<GetWorkerInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkerInterfacesActor*>(this)->ActorCallback< GetWorkerInterfacesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkerInterfacesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getWorkerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkerInterfacesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getWorkerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkerInterfacesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	Reference<ITransaction> tr;
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* address_interface;
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	bool verify;
															#line 108 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	ThreadFuture<RangeResult> kvsFuture;
															#line 110 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	RangeResult kvs;
															#line 507 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
};
// This generated class is to be used only via getWorkerInterfaces()
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
class GetWorkerInterfacesActor final : public Actor<Void>, public ActorCallback< GetWorkerInterfacesActor, 0, RangeResult >, public FastAllocated<GetWorkerInterfacesActor>, public GetWorkerInterfacesActorState<GetWorkerInterfacesActor> {
															#line 512 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
public:
	using FastAllocated<GetWorkerInterfacesActor>::operator new;
	using FastAllocated<GetWorkerInterfacesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13330551264196215040UL, 12527589405285888000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkerInterfacesActor, 0, RangeResult >;
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	GetWorkerInterfacesActor(Reference<ITransaction> const& tr,std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface,bool const& verify) 
															#line 529 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		 : Actor<Void>(),
		   GetWorkerInterfacesActorState<GetWorkerInterfacesActor>(tr, address_interface, verify),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkerInterfaces", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4477992726391842048UL, 11494990287688975360UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkerInterfaces");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkerInterfaces", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkerInterfacesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
[[nodiscard]] Future<Void> getWorkerInterfaces( Reference<ITransaction> const& tr, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface, bool const& verify ) {
															#line 100 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	return Future<Void>(new GetWorkerInterfacesActor(tr, address_interface, verify));
															#line 561 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
}

#line 119 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"

															#line 566 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
// This generated class is to be used only via getWorkers()
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
template <class GetWorkersActor>
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
class GetWorkersActorState {
															#line 572 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
public:
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	GetWorkersActorState(Reference<IDatabase> const& db,std::vector<ProcessData>* const& workers) 
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		 : db(db),
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		   workers(workers),
															#line 121 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		   tr(db->createTransaction())
															#line 583 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
	{
		fdb_probe_actor_create("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	~GetWorkersActorState() 
	{
		fdb_probe_actor_destroy("getWorkers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			;
															#line 598 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 124 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 125 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 126 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 127 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			processClasses = tr->getRange(processClassKeys, CLIENT_KNOBS->TOO_MANY);
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			processData = tr->getRange(workerListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 130 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(safeThreadFutureToFuture(processClasses)) && success(safeThreadFutureToFuture(processData));
															#line 130 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (static_cast<GetWorkersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 641 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetWorkersActor*>(this)->actor_wait_state = 1;
															#line 130 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 0, Void >*>(static_cast<GetWorkersActor*>(this)));
															#line 646 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			TraceEvent(SevWarn, "GetWorkersError").error(e);
															#line 161 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 161 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (static_cast<GetWorkersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 672 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetWorkersActor*>(this)->actor_wait_state = 2;
															#line 161 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetWorkersActor, 1, Void >*>(static_cast<GetWorkersActor*>(this)));
															#line 677 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(!processClasses.get().more && processClasses.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 132 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(!processData.get().more && processData.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 134 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		id_class = std::map<Optional<Standalone<StringRef>>, ProcessClass>();
															#line 135 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		i = int();
															#line 136 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		i = 0;
															#line 700 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(!processClasses.get().more && processClasses.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 132 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(!processData.get().more && processData.get().size() < CLIENT_KNOBS->TOO_MANY);
															#line 134 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		id_class = std::map<Optional<Standalone<StringRef>>, ProcessClass>();
															#line 135 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		i = int();
															#line 136 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		i = 0;
															#line 717 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 146 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		for(i = 0;i < processData.get().size();i++) {
															#line 147 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			ProcessData data = decodeWorkerListValue(processData.get()[i].value);
															#line 148 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			ProcessClass processClass = id_class[data.locality.processId()];
															#line 150 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (processClass.classSource() == ProcessClass::DBSource || data.processClass.classType() == ProcessClass::UnsetClass)
															#line 807 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			{
															#line 152 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
				data.processClass = processClass;
															#line 811 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			}
															#line 154 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (data.processClass.classType() != ProcessClass::TesterClass)
															#line 815 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			{
															#line 155 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
				workers->push_back(data);
															#line 819 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			}
		}
															#line 158 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		if (!static_cast<GetWorkersActor*>(this)->SAV<bool>::futures) { (void)(true); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 824 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		new (&static_cast<GetWorkersActor*>(this)->SAV< bool >::value()) bool(true);
		this->~GetWorkersActorState();
		static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 136 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		if (!(i < processClasses.get().size()))
															#line 843 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 138 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			id_class[decodeProcessClassKey(processClasses.get()[i].key)] = decodeProcessClassValue(processClasses.get()[i].value);
															#line 850 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 136 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		i++;
															#line 878 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 141 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			fprintf(stderr, "Error: %s; Client version is too old, please use a newer version\n", e.what());
															#line 142 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (!static_cast<GetWorkersActor*>(this)->SAV<bool>::futures) { (void)(false); this->~GetWorkersActorState(); static_cast<GetWorkersActor*>(this)->destroy(); return 0; }
															#line 890 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			new (&static_cast<GetWorkersActor*>(this)->SAV< bool >::value()) bool(false);
			this->~GetWorkersActorState();
			static_cast<GetWorkersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetWorkersActor*>(this)->actor_wait_state > 0) static_cast<GetWorkersActor*>(this)->actor_wait_state = 0;
		static_cast<GetWorkersActor*>(this)->ActorCallback< GetWorkersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetWorkersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetWorkersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	Reference<IDatabase> db;
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	std::vector<ProcessData>* workers;
															#line 121 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	Reference<ITransaction> tr;
															#line 127 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	ThreadFuture<RangeResult> processClasses;
															#line 128 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	ThreadFuture<RangeResult> processData;
															#line 134 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	std::map<Optional<Standalone<StringRef>>, ProcessClass> id_class;
															#line 135 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	int i;
															#line 1018 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
};
// This generated class is to be used only via getWorkers()
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
class GetWorkersActor final : public Actor<bool>, public ActorCallback< GetWorkersActor, 0, Void >, public ActorCallback< GetWorkersActor, 1, Void >, public FastAllocated<GetWorkersActor>, public GetWorkersActorState<GetWorkersActor> {
															#line 1023 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
public:
	using FastAllocated<GetWorkersActor>::operator new;
	using FastAllocated<GetWorkersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(457174503180482304UL, 3157114456814917888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetWorkersActor, 0, Void >;
friend struct ActorCallback< GetWorkersActor, 1, Void >;
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	GetWorkersActor(Reference<IDatabase> const& db,std::vector<ProcessData>* const& workers) 
															#line 1041 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		 : Actor<bool>(),
		   GetWorkersActorState<GetWorkersActor>(db, workers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getWorkers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14779239272732970240UL, 16642038601798370048UL);
		ActorExecutionContextHelper __helper(static_cast<GetWorkersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getWorkers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getWorkers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetWorkersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetWorkersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
[[nodiscard]] Future<bool> getWorkers( Reference<IDatabase> const& db, std::vector<ProcessData>* const& workers ) {
															#line 120 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	return Future<bool>(new GetWorkersActor(db, workers));
															#line 1074 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
}

#line 165 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"

															#line 1079 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
// This generated class is to be used only via getStorageServerInterfaces()
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
template <class GetStorageServerInterfacesActor>
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
class GetStorageServerInterfacesActorState {
															#line 1085 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
public:
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	GetStorageServerInterfacesActorState(Reference<IDatabase> const& db,std::map<std::string, StorageServerInterface>* const& interfaces) 
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		 : db(db),
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		   interfaces(interfaces),
															#line 168 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		   tr(db->createTransaction())
															#line 1096 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServerInterfacesActorState() 
	{
		fdb_probe_actor_destroy("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 169 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			;
															#line 1111 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServerInterfacesActorState();
		static_cast<GetStorageServerInterfacesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 170 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		interfaces->clear();
															#line 1141 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		try {
															#line 172 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 173 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 174 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			serverListF = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 176 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(safeThreadFutureToFuture(serverListF));
															#line 176 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (static_cast<GetStorageServerInterfacesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1155 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetStorageServerInterfacesActor*>(this)->actor_wait_state = 1;
															#line 176 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerInterfacesActor, 0, Void >*>(static_cast<GetStorageServerInterfacesActor*>(this)));
															#line 1160 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 187 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			TraceEvent(SevWarn, "GetStorageServerInterfacesError").error(e);
															#line 188 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 188 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			if (static_cast<GetStorageServerInterfacesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1186 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetStorageServerInterfacesActor*>(this)->actor_wait_state = 2;
															#line 188 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetStorageServerInterfacesActor, 1, Void >*>(static_cast<GetStorageServerInterfacesActor*>(this)));
															#line 1191 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(!serverListF.get().more);
															#line 178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT_LT(serverListF.get().size(), CLIENT_KNOBS->TOO_MANY);
															#line 179 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		RangeResult serverList = serverListF.get();
															#line 181 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			auto ssi = decodeServerListValue(serverList[i].value);
															#line 183 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			(*interfaces)[ssi.address().toString()] = ssi;
															#line 1216 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		}
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		if (!static_cast<GetStorageServerInterfacesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetStorageServerInterfacesActorState(); static_cast<GetStorageServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 1220 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		new (&static_cast<GetStorageServerInterfacesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetStorageServerInterfacesActorState();
		static_cast<GetStorageServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT(!serverListF.get().more);
															#line 178 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		ASSERT_LT(serverListF.get().size(), CLIENT_KNOBS->TOO_MANY);
															#line 179 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		RangeResult serverList = serverListF.get();
															#line 181 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 182 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			auto ssi = decodeServerListValue(serverList[i].value);
															#line 183 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
			(*interfaces)[ssi.address().toString()] = ssi;
															#line 1242 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		}
															#line 185 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
		if (!static_cast<GetStorageServerInterfacesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetStorageServerInterfacesActorState(); static_cast<GetStorageServerInterfacesActor*>(this)->destroy(); return 0; }
															#line 1246 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		new (&static_cast<GetStorageServerInterfacesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetStorageServerInterfacesActorState();
		static_cast<GetStorageServerInterfacesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServerInterfacesActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServerInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServerInterfacesActor*>(this)->ActorCallback< GetStorageServerInterfacesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServerInterfacesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServerInterfacesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServerInterfacesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetStorageServerInterfacesActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServerInterfacesActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServerInterfacesActor*>(this)->ActorCallback< GetStorageServerInterfacesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServerInterfacesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetStorageServerInterfacesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetStorageServerInterfacesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	Reference<IDatabase> db;
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	std::map<std::string, StorageServerInterface>* interfaces;
															#line 168 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	Reference<ITransaction> tr;
															#line 175 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	ThreadFuture<RangeResult> serverListF;
															#line 1424 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
};
// This generated class is to be used only via getStorageServerInterfaces()
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
class GetStorageServerInterfacesActor final : public Actor<Void>, public ActorCallback< GetStorageServerInterfacesActor, 0, Void >, public ActorCallback< GetStorageServerInterfacesActor, 1, Void >, public FastAllocated<GetStorageServerInterfacesActor>, public GetStorageServerInterfacesActorState<GetStorageServerInterfacesActor> {
															#line 1429 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
public:
	using FastAllocated<GetStorageServerInterfacesActor>::operator new;
	using FastAllocated<GetStorageServerInterfacesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9384352565896529152UL, 11485727236298985472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServerInterfacesActor, 0, Void >;
friend struct ActorCallback< GetStorageServerInterfacesActor, 1, Void >;
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	GetStorageServerInterfacesActor(Reference<IDatabase> const& db,std::map<std::string, StorageServerInterface>* const& interfaces) 
															#line 1447 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
		 : Actor<Void>(),
		   GetStorageServerInterfacesActorState<GetStorageServerInterfacesActor>(db, interfaces),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1631754132305616128UL, 17605230646049563136UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServerInterfacesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServerInterfaces");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServerInterfaces", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServerInterfacesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetStorageServerInterfacesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
[[nodiscard]] Future<Void> getStorageServerInterfaces( Reference<IDatabase> const& db, std::map<std::string, StorageServerInterface>* const& interfaces ) {
															#line 166 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"
	return Future<Void>(new GetStorageServerInterfacesActor(db, interfaces));
															#line 1480 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/build_output/fdbcli/Util.actor.g.cpp"
}

#line 192 "/codebuild/output/src1526309592/src/github.com/apple/foundationdb/fdbcli/Util.actor.cpp"

} // namespace fdb_cli
