#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
/*
 * SnapTest.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/SimpleIni.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/Status.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h"

struct SnapTestWorkload : TestWorkload {
	static constexpr auto NAME = "SnapTest";

public: // variables
	int numSnaps; // num of snapshots to be taken
	              // FIXME: currently validation works on numSnap = 1
	double maxSnapDelay; // max delay before which a snapshot will be taken
	int testID; // test id
	UID snapUID; // UID used for snap name
	std::string restartInfoLocation; // file location to store the snap restore info
	int maxRetryCntToRetrieveMessage; // number of retires to do trackLatest
	bool skipCheck = false; // disable check if the exec fails
	int retryLimit; // -1 if no limit
	bool snapSucceeded = false; // When taking snapshot, tracks snapshot success
	bool attemptDuplicateSnapshot = false;

public: // ctor & dtor
	SnapTestWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), numSnaps(0), maxSnapDelay(0.0), testID(0), snapUID() {
		TraceEvent("SnapTestWorkloadConstructor").log();
		std::string workloadName = "SnapTest";
		maxRetryCntToRetrieveMessage = 10;

		numSnaps = getOption(options, "numSnaps"_sr, 0);
		maxSnapDelay = getOption(options, "maxSnapDelay"_sr, 25.0);
		testID = getOption(options, "testID"_sr, 0);
		restartInfoLocation = getOption(options, "restartInfoLocation"_sr, "simfdb/restartInfo.ini"_sr).toString();
		// default behavior is to retry until success
		retryLimit = getOption(options, "retryLimit"_sr, -1);
		g_simulator->allowLogSetKills = false;
		{
			double duplicateSnapshotProbability = getOption(options, "duplicateSnapshotProbability"_sr, 0.1);
			if (deterministicRandom()->random01() < duplicateSnapshotProbability) {
				attemptDuplicateSnapshot = true;
			}
		}
	}

public: // workload functions
	Future<Void> setup(Database const& cx) override {
		TraceEvent("SnapTestWorkloadSetup").log();
		return Void();
	}
	Future<Void> start(Database const& cx) override {
		TraceEvent("SnapTestWorkloadStart").log();
		if (clientId == 0) {
			return _start(cx, this);
		}
		return Void();
	}

	Future<bool> check(Database const& cx) override {
		TraceEvent("SnapTestWorkloadCheck").detail("ClientID", clientId).detail("TestID", testID);
		if (clientId != 0) {
			return true;
		}
		if (testID == 1) {
			return snapSucceeded;
		}
		return true;
	}

	void getMetrics(std::vector<PerfMetric>& m) override { TraceEvent("SnapTestWorkloadGetMetrics"); }

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		// Data movement is not allowed while taking snapshot
		// FIXME: the data movement should be delayed while taking snapshots, the workload at present doesn't know the
		// DD is disabled by the snapshot
		out.insert("RandomMoveKeys");

		// A combination of this workload only doing snapshot once and attrition fault injection means that it's
		// possible that not all ss/tlog/coordinator data gets snapshotted. This workload does retry on snapshot errors
		// but note that the absence of machines is not considered an error from snapshot request point of view.
		// Since snapshot restart tests rely on snapshot data, attrition fault injection is disabled for this workload.
		out.insert("Attrition");
	}

																#line 114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
// This generated class is to be used only via _create_keys()
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
template <class _create_keysActor>
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
class _create_keysActorState {
															#line 120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
public:
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	_create_keysActorState(Database const& cx,std::string const& prefix,bool const& even = true) 
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		 : cx(cx),
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		   prefix(prefix),
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		   even(even),
															#line 113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		   tr(cx),
															#line 114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		   keys()
															#line 135 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
	{
		fdb_probe_actor_create("_create_keys", reinterpret_cast<unsigned long>(this));

	}
	~_create_keysActorState() 
	{
		fdb_probe_actor_destroy("_create_keys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 116 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			keys.reserve(1000);
															#line 117 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			for(int i = 0;i < 1000;i++) {
															#line 118 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				keys.push_back(deterministicRandom()->randomInt64(0, INT64_MAX - 2));
															#line 154 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			}
															#line 121 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			tr.reset();
															#line 122 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			;
															#line 160 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_create_keysActorState();
		static_cast<_create_keysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 146 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (!static_cast<_create_keysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_create_keysActorState(); static_cast<_create_keysActor*>(this)->destroy(); return 0; }
															#line 183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		new (&static_cast<_create_keysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_create_keysActorState();
		static_cast<_create_keysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 124 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			for( auto id : keys ) {
															#line 125 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				if (even)
															#line 205 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				{
															#line 126 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					if (id % 2 != 0)
															#line 209 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
					{
															#line 127 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
						id++;
															#line 213 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
					}
				}
				else
				{
															#line 130 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					if (id % 2 == 0)
															#line 220 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
					{
															#line 131 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
						id++;
															#line 224 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
					}
				}
															#line 134 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				std::string Key1 = prefix + std::to_string(id);
															#line 135 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				Key key1Ref(Key1);
															#line 136 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				std::string Val1 = std::to_string(id);
															#line 137 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				Value val1Ref(Val1);
															#line 138 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				tr.set(key1Ref, val1Ref, AddConflictRange::False);
															#line 237 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			}
															#line 140 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 140 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (static_cast<_create_keysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 243 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_create_keysActor*>(this)->actor_wait_state = 1;
															#line 140 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _create_keysActor, 0, Void >*>(static_cast<_create_keysActor*>(this)));
															#line 248 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 143 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 143 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (static_cast<_create_keysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 285 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_create_keysActor*>(this)->actor_wait_state = 2;
															#line 143 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _create_keysActor, 1, Void >*>(static_cast<_create_keysActor*>(this)));
															#line 290 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_create_keysActor*>(this)->actor_wait_state > 0) static_cast<_create_keysActor*>(this)->actor_wait_state = 0;
		static_cast<_create_keysActor*>(this)->ActorCallback< _create_keysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _create_keysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_create_keys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_create_keysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_create_keys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _create_keysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_create_keys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_create_keysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_create_keys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _create_keysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_create_keys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_create_keysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_create_keys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_create_keysActor*>(this)->actor_wait_state > 0) static_cast<_create_keysActor*>(this)->actor_wait_state = 0;
		static_cast<_create_keysActor*>(this)->ActorCallback< _create_keysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _create_keysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_create_keys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_create_keysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_create_keys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _create_keysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_create_keys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_create_keysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_create_keys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _create_keysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_create_keys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_create_keysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_create_keys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	Database cx;
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	std::string prefix;
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	bool even;
															#line 113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	Transaction tr;
															#line 114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	std::vector<int64_t> keys;
															#line 485 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
};
// This generated class is to be used only via _create_keys()
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
class _create_keysActor final : public Actor<Void>, public ActorCallback< _create_keysActor, 0, Void >, public ActorCallback< _create_keysActor, 1, Void >, public FastAllocated<_create_keysActor>, public _create_keysActorState<_create_keysActor> {
															#line 490 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
public:
	using FastAllocated<_create_keysActor>::operator new;
	using FastAllocated<_create_keysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5056993333027214336UL, 9214793089465855232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _create_keysActor, 0, Void >;
friend struct ActorCallback< _create_keysActor, 1, Void >;
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	_create_keysActor(Database const& cx,std::string const& prefix,bool const& even = true) 
															#line 508 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		 : Actor<Void>(),
		   _create_keysActorState<_create_keysActor>(cx, prefix, even),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_create_keys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6921122834450774784UL, 12417372639557604864UL);
		ActorExecutionContextHelper __helper(static_cast<_create_keysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_create_keys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_create_keys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _create_keysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _create_keysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
[[nodiscard]] Future<Void> _create_keys( Database const& cx, std::string const& prefix, bool const& even = true ) {
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	return Future<Void>(new _create_keysActor(cx, prefix, even));
															#line 541 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
}

#line 148 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"

																#line 546 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
template <class _startActor>
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
class _startActorState {
															#line 552 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
public:
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	_startActorState(Database const& cx,SnapTestWorkload* const& self) 
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		 : cx(cx),
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		   self(self),
															#line 150 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		   tr(cx),
															#line 151 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		   snapFailed(false),
															#line 152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		   duplicateSnapStatus()
															#line 567 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 154 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (self->testID == 0)
															#line 582 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			{
															#line 156 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->_create_keys(cx, "snapKey");
															#line 156 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 588 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 593 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 157 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				if (self->testID == 1)
															#line 600 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				{
															#line 159 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					toDelay = fmod(deterministicRandom()->randomUInt32(), self->maxSnapDelay);
															#line 160 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					TraceEvent("ToDelay").detail("Value", toDelay);
															#line 161 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					ASSERT(toDelay < self->maxSnapDelay);
															#line 162 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					StrictFuture<Void> __when_expr_1 = delay(toDelay);
															#line 162 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 162 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 617 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 212 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					if (self->testID == 2)
															#line 624 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
					{
															#line 214 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
						StrictFuture<Void> __when_expr_6 = self->_create_keys(cx, "snapKey", false );
															#line 214 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 630 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
						if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1when3(__when_expr_6.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 214 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
						__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 635 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 215 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
						if (self->testID == 3)
															#line 642 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
						{
															#line 216 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							CSimpleIni ini;
															#line 217 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							ini.SetUnicode();
															#line 218 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							ini.LoadFile(self->restartInfoLocation.c_str());
															#line 219 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							bool backupFailed = atoi(ini.GetValue("RESTORE", "BackupFailed"));
															#line 220 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							if (backupFailed)
															#line 654 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
							{
															#line 222 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
								TraceEvent(SevWarnAlways, "BackupFailedSkippingRestoreCheck").log();
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
								if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 660 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
								new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
								this->~_startActorState();
								static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 225 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							begin = firstGreaterOrEqual(normalKeys.begin);
															#line 226 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							end = firstGreaterOrEqual(normalKeys.end);
															#line 227 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							cnt = 0;
															#line 232 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							tr.reset();
															#line 233 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							;
															#line 676 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
							loopDepth = a_body1loopHead1(loopDepth);
						}
						else
						{
															#line 265 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
							if (self->testID == 4)
															#line 683 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
							{
															#line 268 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
								testedFailure = false;
															#line 269 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
								snapFailed = false;
															#line 270 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
								;
															#line 691 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
								loopDepth = a_body1loopHead2(loopDepth);
							}
							else
							{
								loopDepth = a_body1cont12(loopDepth);
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 290 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(0.0);
															#line 290 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 725 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont1when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 290 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 730 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		retry = 0;
															#line 165 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		;
															#line 834 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 164 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		retry = 0;
															#line 165 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		;
															#line 845 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 201 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		CSimpleIni ini;
															#line 202 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		ini.SetUnicode();
															#line 203 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		ini.LoadFile(self->restartInfoLocation.c_str());
															#line 204 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		std::string uidStr = self->snapUID.toString();
															#line 205 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		ini.SetValue("RESTORE", "RestoreSnapUID", uidStr.c_str());
															#line 206 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		ini.SetValue("RESTORE", "BackupFailed", format("%d", snapFailed).c_str());
															#line 207 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		ini.SaveFile(self->restartInfoLocation.c_str());
															#line 209 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		auto const severity = snapFailed ? SevError : SevInfo;
															#line 210 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		TraceEvent(severity, "SnapshotCreateStatus").detail("Status", !snapFailed ? "Success" : "Failure");
															#line 211 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		self->snapSucceeded = !snapFailed;
															#line 947 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 166 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		self->snapUID = deterministicRandom()->randomUniqueID();
															#line 963 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		try {
															#line 168 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			snapCmdRef = "/bin/snap_create.sh"_sr;
															#line 170 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			status = snapCreate(cx, snapCmdRef, self->snapUID);
															#line 171 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (self->attemptDuplicateSnapshot)
															#line 971 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			{
															#line 172 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				StrictFuture<Void> __when_expr_2 = delay(deterministicRandom()->random01());
															#line 172 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 977 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont4loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 172 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 982 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont4loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont4loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 187 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			TraceEvent("SnapTestCreateError") .error(e) .detail("SnapUID", self->snapUID) .detail("Duplicate", self->attemptDuplicateSnapshot);
															#line 191 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			++retry;
															#line 193 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (self->retryLimit != -1 && retry > self->retryLimit)
															#line 1026 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			{
															#line 194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				snapFailed = true;
															#line 1030 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 198 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StrictFuture<Void> __when_expr_5 = delay(retry * SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP);
															#line 198 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1037 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 198 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1042 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2(int loopDepth) 
	{
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_3 = errorOr(status);
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1059 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont4loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, ErrorOr<Void> >*>(static_cast<_startActor*>(this)));
															#line 1064 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		duplicateSnapStatus = snapCreate(cx, snapCmdRef, self->snapUID);
															#line 1073 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		duplicateSnapStatus = snapCreate(cx, snapCmdRef, self->snapUID);
															#line 1082 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4loopBody1cont5(ErrorOr<Void> const& statusErr,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (statusErr.isError() && statusErr.getError().code() != error_code_duplicate_snapshot_request)
															#line 1166 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		{
															#line 179 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			return a_body1cont4loopBody1Catch1(statusErr.getError(), loopDepth);
															#line 1170 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		}
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (self->attemptDuplicateSnapshot)
															#line 1174 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		{
															#line 183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StrictFuture<Void> __when_expr_4 = duplicateSnapStatus;
															#line 183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1180 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont4loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1185 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont5(ErrorOr<Void> && statusErr,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (statusErr.isError() && statusErr.getError().code() != error_code_duplicate_snapshot_request)
															#line 1199 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		{
															#line 179 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			return a_body1cont4loopBody1Catch1(statusErr.getError(), loopDepth);
															#line 1203 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		}
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (self->attemptDuplicateSnapshot)
															#line 1207 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		{
															#line 183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StrictFuture<Void> __when_expr_4 = duplicateSnapStatus;
															#line 183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1213 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont4loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1218 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(ErrorOr<Void> const& statusErr,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(statusErr, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont2when1(ErrorOr<Void> && statusErr,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont5(std::move(statusErr), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont4loopBody1cont6(int loopDepth) 
	{
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
															#line 261 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (cnt != 1000)
															#line 1586 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		{
															#line 262 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			TraceEvent(SevError, "SnapTestVerifyCntValue").detail("Value", cnt);
															#line 263 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			return a_body1Catch1(operation_failed(), loopDepth);
															#line 1592 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		}
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr.getRange(begin, end, 1000);
															#line 235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_7.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 1617 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 258 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr.onError(e);
															#line 258 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1654 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 258 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 1659 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& kvRange,int loopDepth) 
	{
															#line 236 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (!kvRange.more && kvRange.size() == 0)
															#line 1674 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		{
															#line 237 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			TraceEvent("SnapTestNoMoreEntries").log();
															#line 1678 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 241 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		for(int i = 0;i < kvRange.size();i++) {
															#line 242 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (kvRange[i].key.startsWith("snapKey"_sr))
															#line 1685 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			{
															#line 243 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				std::string tmp1 = kvRange[i].key.substr(7).toString();
															#line 244 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				int64_t id = strtol(tmp1.c_str(), nullptr, 0);
															#line 245 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				if (id % 2 != 0)
															#line 1693 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				{
															#line 246 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 1697 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				}
															#line 248 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				++cnt;
															#line 249 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				std::string tmp2 = kvRange[i].value.toString();
															#line 250 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				int64_t value = strtol(tmp2.c_str(), nullptr, 0);
															#line 251 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				if (id != value)
															#line 1707 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				{
															#line 252 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 1711 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				}
			}
		}
															#line 256 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		begin = firstGreaterThan(kvRange.end()[-1].key);
															#line 1717 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && kvRange,int loopDepth) 
	{
															#line 236 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (!kvRange.more && kvRange.size() == 0)
															#line 1726 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		{
															#line 237 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			TraceEvent("SnapTestNoMoreEntries").log();
															#line 1730 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 241 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		for(int i = 0;i < kvRange.size();i++) {
															#line 242 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (kvRange[i].key.startsWith("snapKey"_sr))
															#line 1737 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			{
															#line 243 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				std::string tmp1 = kvRange[i].key.substr(7).toString();
															#line 244 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				int64_t id = strtol(tmp1.c_str(), nullptr, 0);
															#line 245 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				if (id % 2 != 0)
															#line 1745 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				{
															#line 246 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 1749 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				}
															#line 248 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				++cnt;
															#line 249 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				std::string tmp2 = kvRange[i].value.toString();
															#line 250 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				int64_t value = strtol(tmp2.c_str(), nullptr, 0);
															#line 251 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				if (id != value)
															#line 1759 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				{
															#line 252 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
					return a_body1loopBody1Catch1(operation_failed(), loopDepth);
															#line 1763 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				}
			}
		}
															#line 256 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		begin = firstGreaterThan(kvRange.end()[-1].key);
															#line 1769 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& kvRange,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(kvRange, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && kvRange,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(kvRange), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12(int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 288 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		ASSERT(testedFailure || snapFailed);
															#line 1959 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2(int loopDepth) 
	{
															#line 271 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		self->snapUID = deterministicRandom()->randomUniqueID();
															#line 1975 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		try {
															#line 273 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StringRef snapCmdRef = "/bin/snap_create1.sh"_sr;
															#line 274 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			Future<Void> status = snapCreate(cx, snapCmdRef, self->snapUID);
															#line 275 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			StrictFuture<Void> __when_expr_9 = status;
															#line 275 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 1985 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1loopBody2when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 275 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 1990 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break2(int loopDepth) 
	{
		try {
			return a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody2cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 278 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (e.code() == error_code_snap_not_fully_recovered_unsupported)
															#line 2025 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			{
															#line 279 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				snapFailed = true;
															#line 2029 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				return a_body1break2(loopDepth==0?0:loopDepth-1); // break
			}
															#line 282 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
			if (e.code() == error_code_snap_path_not_whitelisted)
															#line 2034 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
			{
															#line 283 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
				testedFailure = true;
															#line 2038 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
				return a_body1break2(loopDepth==0?0:loopDepth-1); // break
			}
			loopDepth = a_body1loopBody2cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody2cont2(Void const& _,int loopDepth) 
	{
		return a_body1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody2cont2(Void && _,int loopDepth) 
	{
		return a_body1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody2cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
															#line 291 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2142 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
															#line 291 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2154 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	Database cx;
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	SnapTestWorkload* self;
															#line 150 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	Transaction tr;
															#line 151 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	bool snapFailed;
															#line 152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	Future<Void> duplicateSnapStatus;
															#line 159 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	double toDelay;
															#line 164 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	int retry;
															#line 168 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	StringRef snapCmdRef;
															#line 170 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	Future<Void> status;
															#line 225 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	KeySelector begin;
															#line 226 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	KeySelector end;
															#line 227 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	int cnt;
															#line 268 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	bool testedFailure;
															#line 2263 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, ErrorOr<Void> >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, RangeResult >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2268 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16537689094130309120UL, 2804835058077240576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, ErrorOr<Void> >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, RangeResult >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	_startActor(Database const& cx,SnapTestWorkload* const& self) 
															#line 2295 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, SnapTestWorkload* const& self ) {
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 2337 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SnapTest.actor.g.cpp"
}

#line 293 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/SnapTest.actor.cpp"
};

WorkloadFactory<SnapTestWorkload> SnapTestWorkloadFactory;
