#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
/*
 * HTTPKeyValueStore.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/Util.h"
#include "flow/serialize.h"
#include "fdbrpc/HTTP.h"
#include "fdbserver/workloads/workloads.actor.h"
#include <cstring>
#include <limits>

#include "flow/actorcompiler.h" // This must be the last #include.

/*
 * Implements a basic put/get key-value store over HTTP to test the http client and simulated server code.
 */

#define DEBUG_HTTPKV false

static const int maxClients = 100;

struct SimHTTPKVStore : NonCopyable, ReferenceCounted<SimHTTPKVStore> {
	std::unordered_map<std::string, std::string> data;

	int64_t lastClientSeqnos[maxClients];

	SimHTTPKVStore() {
		for (int i = 0; i < maxClients; i++) {
			lastClientSeqnos[i] = 0;
		}
	}

	bool checkClientSeqno(int clientId, int64_t seqNo) {
		ASSERT(clientId < maxClients);
		if (seqNo < lastClientSeqnos[clientId]) {
			if (DEBUG_HTTPKV) {
				fmt::print("Client {0} SeqNo {1} < {2}\n", clientId, seqNo, lastClientSeqnos[clientId]);
			}
			// out of order retransmit, ignore
			return false;
		}
		lastClientSeqnos[clientId] = seqNo;
		return true;
	}
};

void httpKVProcessPut(Reference<SimHTTPKVStore> kvStore,
                      std::string& key,
                      Reference<HTTP::IncomingRequest> req,
                      Reference<HTTP::OutgoingResponse> response) {
	// content is value to put in kv store
	kvStore->data[key] = req->data.content;

	if (DEBUG_HTTPKV) {
		fmt::print("KV:put {0} = {1}\n", key, req->data.content);
	}

	response->code = 200;
	response->data.contentLen = 0;
}

// content is empty for request, content for response is the value for the key
void httpKVProcessGet(Reference<SimHTTPKVStore> kvStore,
                      std::string& key,
                      Reference<HTTP::IncomingRequest> req,
                      Reference<HTTP::OutgoingResponse> response) {

	auto it = kvStore->data.find(key);
	ASSERT(it != kvStore->data.end());

	if (DEBUG_HTTPKV) {
		fmt::print("KV:get {0} = {1}\n", key, it->second);
	}

	response->code = 200;

	response->data.headers["Content-MD5"] = HTTP::computeMD5Sum(it->second);

	PacketWriter pw(response->data.content->getWriteBuffer(it->second.size()), nullptr, Unversioned());
	pw.serializeBytes(it->second);
	response->data.contentLen = it->second.size();
}

// key header always exists for both put and get
															#line 106 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
namespace {
// This generated class is to be used only via httpKVRequestCallback()
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
template <class HttpKVRequestCallbackActor>
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class HttpKVRequestCallbackActorState {
															#line 113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HttpKVRequestCallbackActorState(Reference<SimHTTPKVStore> const& kvStore,Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		 : kvStore(kvStore),
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   req(req),
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   response(response)
															#line 124 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
	{
		fdb_probe_actor_create("httpKVRequestCallback", reinterpret_cast<unsigned long>(this));

	}
	~HttpKVRequestCallbackActorState() 
	{
		fdb_probe_actor_destroy("httpKVRequestCallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 107 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0);
															#line 107 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<HttpKVRequestCallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 141 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HttpKVRequestCallbackActor*>(this)->actor_wait_state = 1;
															#line 107 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HttpKVRequestCallbackActor, 0, Void >*>(static_cast<HttpKVRequestCallbackActor*>(this)));
															#line 146 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HttpKVRequestCallbackActorState();
		static_cast<HttpKVRequestCallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 109 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->verb == HTTP::HTTP_VERB_PUT || req->verb == HTTP::HTTP_VERB_GET);
															#line 110 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(req->resource, "/kv");
															#line 114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(req->data.headers.size(), 5);
															#line 115 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("Key"));
															#line 116 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("ClientID"));
															#line 117 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("UID"));
															#line 118 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("SeqNo"));
															#line 120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		int clientId = atoi(req->data.headers["ClientID"].c_str());
															#line 121 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		int seqNo = atoi(req->data.headers["SeqNo"].c_str());
															#line 123 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("Content-Length"));
															#line 124 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(req->data.headers["Content-Length"], std::to_string(req->data.content.size()));
															#line 125 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(req->data.contentLen, req->data.content.size());
															#line 127 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!kvStore->checkClientSeqno(clientId, seqNo))
															#line 193 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 128 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			CODE_PROBE(true, "kv store ignoring out of order retransmit");
															#line 129 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			return a_body1Catch1(http_request_failed(), loopDepth);
															#line 199 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 132 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		std::string key = req->data.headers["ClientID"] + ":" + req->data.headers["Key"];
															#line 135 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		response->data.headers["ClientID"] = req->data.headers["ClientID"];
															#line 136 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		response->data.headers["Key"] = req->data.headers["Key"];
															#line 137 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		response->data.headers["UID"] = req->data.headers["UID"];
															#line 140 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (req->verb == HTTP::HTTP_VERB_PUT)
															#line 211 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 141 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			httpKVProcessPut(kvStore, key, req, response);
															#line 215 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
		else
		{
															#line 143 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			httpKVProcessGet(kvStore, key, req, response);
															#line 221 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 146 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<HttpKVRequestCallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HttpKVRequestCallbackActorState(); static_cast<HttpKVRequestCallbackActor*>(this)->destroy(); return 0; }
															#line 225 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<HttpKVRequestCallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HttpKVRequestCallbackActorState();
		static_cast<HttpKVRequestCallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 109 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->verb == HTTP::HTTP_VERB_PUT || req->verb == HTTP::HTTP_VERB_GET);
															#line 110 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(req->resource, "/kv");
															#line 114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(req->data.headers.size(), 5);
															#line 115 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("Key"));
															#line 116 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("ClientID"));
															#line 117 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("UID"));
															#line 118 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("SeqNo"));
															#line 120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		int clientId = atoi(req->data.headers["ClientID"].c_str());
															#line 121 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		int seqNo = atoi(req->data.headers["SeqNo"].c_str());
															#line 123 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(req->data.headers.contains("Content-Length"));
															#line 124 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(req->data.headers["Content-Length"], std::to_string(req->data.content.size()));
															#line 125 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(req->data.contentLen, req->data.content.size());
															#line 127 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!kvStore->checkClientSeqno(clientId, seqNo))
															#line 261 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 128 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			CODE_PROBE(true, "kv store ignoring out of order retransmit");
															#line 129 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			return a_body1Catch1(http_request_failed(), loopDepth);
															#line 267 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 132 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		std::string key = req->data.headers["ClientID"] + ":" + req->data.headers["Key"];
															#line 135 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		response->data.headers["ClientID"] = req->data.headers["ClientID"];
															#line 136 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		response->data.headers["Key"] = req->data.headers["Key"];
															#line 137 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		response->data.headers["UID"] = req->data.headers["UID"];
															#line 140 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (req->verb == HTTP::HTTP_VERB_PUT)
															#line 279 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 141 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			httpKVProcessPut(kvStore, key, req, response);
															#line 283 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
		else
		{
															#line 143 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			httpKVProcessGet(kvStore, key, req, response);
															#line 289 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 146 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<HttpKVRequestCallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HttpKVRequestCallbackActorState(); static_cast<HttpKVRequestCallbackActor*>(this)->destroy(); return 0; }
															#line 293 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<HttpKVRequestCallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~HttpKVRequestCallbackActorState();
		static_cast<HttpKVRequestCallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HttpKVRequestCallbackActor*>(this)->actor_wait_state > 0) static_cast<HttpKVRequestCallbackActor*>(this)->actor_wait_state = 0;
		static_cast<HttpKVRequestCallbackActor*>(this)->ActorCallback< HttpKVRequestCallbackActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HttpKVRequestCallbackActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("httpKVRequestCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKVRequestCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKVRequestCallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HttpKVRequestCallbackActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("httpKVRequestCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKVRequestCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKVRequestCallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HttpKVRequestCallbackActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("httpKVRequestCallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKVRequestCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKVRequestCallback", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	Reference<SimHTTPKVStore> kvStore;
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	Reference<HTTP::IncomingRequest> req;
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	Reference<HTTP::OutgoingResponse> response;
															#line 382 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
};
// This generated class is to be used only via httpKVRequestCallback()
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class HttpKVRequestCallbackActor final : public Actor<Void>, public ActorCallback< HttpKVRequestCallbackActor, 0, Void >, public FastAllocated<HttpKVRequestCallbackActor>, public HttpKVRequestCallbackActorState<HttpKVRequestCallbackActor> {
															#line 387 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
	using FastAllocated<HttpKVRequestCallbackActor>::operator new;
	using FastAllocated<HttpKVRequestCallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12192376762187382016UL, 11942327079232378624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HttpKVRequestCallbackActor, 0, Void >;
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HttpKVRequestCallbackActor(Reference<SimHTTPKVStore> const& kvStore,Reference<HTTP::IncomingRequest> const& req,Reference<HTTP::OutgoingResponse> const& response) 
															#line 404 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		 : Actor<Void>(),
		   HttpKVRequestCallbackActorState<HttpKVRequestCallbackActor>(kvStore, req, response),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("httpKVRequestCallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5927508170041861632UL, 8716278188940754432UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKVRequestCallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("httpKVRequestCallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("httpKVRequestCallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HttpKVRequestCallbackActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
[[nodiscard]] Future<Void> httpKVRequestCallback( Reference<SimHTTPKVStore> const& kvStore, Reference<HTTP::IncomingRequest> const& req, Reference<HTTP::OutgoingResponse> const& response ) {
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	return Future<Void>(new HttpKVRequestCallbackActor(kvStore, req, response));
															#line 437 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
}

#line 148 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"

static Reference<SimHTTPKVStore> globalKVStore = Reference<SimHTTPKVStore>();

struct KeyValueRequestHandler : HTTP::IRequestHandler, ReferenceCounted<KeyValueRequestHandler> {

	// global kv store for all request handler instances during simulation
	Reference<SimHTTPKVStore> myKVStore;

	KeyValueRequestHandler() {}

	Future<Void> handleRequest(Reference<HTTP::IncomingRequest> req,
	                           Reference<HTTP::OutgoingResponse> response) override {
		return httpKVRequestCallback(myKVStore, req, response);
	}

	Future<Void> init() override {
		if (!globalKVStore) {
			globalKVStore = makeReference<SimHTTPKVStore>();
		}
		myKVStore = globalKVStore;
		return Void();
	}

	Reference<HTTP::IRequestHandler> clone() override { return makeReference<KeyValueRequestHandler>(); }

	void addref() override { ReferenceCounted<KeyValueRequestHandler>::addref(); }
	void delref() override { ReferenceCounted<KeyValueRequestHandler>::delref(); }
};

struct HTTPKeyValueStoreWorkload : TestWorkload {
	static constexpr auto NAME = "HTTPKeyValueStore";
	double testDuration;
	int nodeCount;
	int opsPerSecond;
	Future<Void> client;
	int64_t nextSeqNo = 1;
	bool manualResolve;

	// handle race where test phase killed put in progress
	Optional<std::pair<std::string, std::string>> activePut;

	// client's view of the correct key-value state of the data
	std::unordered_map<std::string, std::string> myData;

	// client's connection it reuses between request attempts
	Reference<IConnection> conn;

	std::string hostname = "httpkvstore";
	std::string service = "80";

	PerfIntCounter getCount, putCount, connectCount, failedConnectCount;

	HTTPKeyValueStoreWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), putCount("PutCount"), getCount("GetCount"), connectCount("ConnectCount"),
	    failedConnectCount("FailedConnectCount") {
		testDuration = getOption(options, "testDuration"_sr, 30.0);
		nodeCount = getOption(options, "nodeCount"_sr, 100);
		opsPerSecond = getOption(options, "nodeCount"_sr, 100);
		manualResolve = getOption(options, "manualResolve"_sr, sharedRandomNumber % 2);
		// it's important that we select this on a test-by-test basis and not a connection-by-connection basis as if one
		// approach works but another doesn't, it would be hidden
		sharedRandomNumber /= 2;
	}

	std::string getKey(int i) {
		// FIXME: larger/more random keys?
		return std::to_string(i);
	}

	std::string randomValue() {
		// FIXME: larger/more random values?
		return deterministicRandom()->randomUniqueID().toString();
	}

	// handles retrying on timeout and reinitializing connection like other users of HTTP (S3BlobStore, RestClient)
																#line 516 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
// This generated class is to be used only via doKVRequest()
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
template <class DoKVRequestActor>
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class DoKVRequestActorState {
															#line 522 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	DoKVRequestActorState(HTTPKeyValueStoreWorkload* const& self,std::string const& key,Optional<std::string> const& value) 
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		 : self(self),
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   key(key),
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   value(value),
															#line 226 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   content(),
															#line 227 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   seqNo(self->nextSeqNo)
															#line 537 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
	{
		fdb_probe_actor_create("doKVRequest", reinterpret_cast<unsigned long>(this));

	}
	~DoKVRequestActorState() 
	{
		fdb_probe_actor_destroy("doKVRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 228 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			++self->nextSeqNo;
															#line 229 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			;
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoKVRequestActorState();
		static_cast<DoKVRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 231 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			;
															#line 585 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 303 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			{
															#line 304 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 611 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			}
															#line 306 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (DEBUG_HTTPKV)
															#line 615 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			{
															#line 307 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				fmt::print("REQ: ERROR: {0}\n", e.name());
															#line 619 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			}
															#line 309 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (self->conn)
															#line 623 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			{
															#line 310 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				self->conn->close();
															#line 311 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				self->conn.clear();
															#line 629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			}
															#line 313 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (e.code() != error_code_timed_out && e.code() != error_code_connection_failed && e.code() != error_code_lookup_failed)
															#line 633 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			{
															#line 315 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 637 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			}
															#line 320 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_6 = delay(0.1);
															#line 320 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<DoKVRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 643 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
			static_cast<DoKVRequestActor*>(this)->actor_wait_state = 7;
															#line 320 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoKVRequestActor, 6, Void >*>(static_cast<DoKVRequestActor*>(this)));
															#line 648 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 259 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		content.discardAll();
															#line 260 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		req = makeReference<HTTP::OutgoingRequest>();
															#line 261 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		requestID = deterministicRandom()->randomUniqueID();
															#line 262 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		req->data.content = &content;
															#line 263 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		req->data.contentLen = 0;
															#line 264 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		req->resource = "/kv";
															#line 265 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		req->data.headers["Key"] = key;
															#line 266 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		req->data.headers["ClientID"] = std::to_string(self->clientId);
															#line 267 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		req->data.headers["UID"] = requestID.toString();
															#line 268 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		req->data.headers["SeqNo"] = std::to_string(seqNo);
															#line 270 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (value.present())
															#line 683 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 272 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			req->verb = HTTP::HTTP_VERB_PUT;
															#line 273 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			PacketWriter pw(req->data.content->getWriteBuffer(value.get().size()), nullptr, Unversioned());
															#line 274 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			pw.serializeBytes(value.get());
															#line 275 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			req->data.contentLen = value.get().size();
															#line 693 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
		else
		{
															#line 278 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			req->verb = HTTP::HTTP_VERB_GET;
															#line 699 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 281 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		sendReceiveRate = makeReference<Unlimited>();
															#line 282 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		bytes_sent = 0;
															#line 283 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_5 = timeoutError(HTTP::doRequest(self->conn, req, sendReceiveRate, &bytes_sent, sendReceiveRate), 5.0);
															#line 283 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 709 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<DoKVRequestActor*>(this)->actor_wait_state = 6;
															#line 283 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoKVRequestActor, 5, Reference<HTTP::IncomingResponse> >*>(static_cast<DoKVRequestActor*>(this)));
															#line 714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 231 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!(!self->conn))
															#line 730 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 234 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (self->manualResolve)
															#line 736 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<std::vector<NetworkAddress>> __when_expr_0 = INetworkConnections::net()->resolveTCPEndpoint(self->hostname, self->service);
															#line 235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<DoKVRequestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 742 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoKVRequestActor*>(this)->actor_wait_state = 1;
															#line 235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoKVRequestActor, 0, std::vector<NetworkAddress> >*>(static_cast<DoKVRequestActor*>(this)));
															#line 747 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 245 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store( self->conn, timeoutError(INetworkConnections::net()->connect(self->hostname, self->service, false), FLOW_KNOBS->CONNECTION_MONITOR_TIMEOUT));
															#line 245 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<DoKVRequestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 756 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<DoKVRequestActor*>(this)->actor_wait_state = 3;
															#line 245 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoKVRequestActor, 2, Void >*>(static_cast<DoKVRequestActor*>(this)));
															#line 761 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 250 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (self->conn.isValid())
															#line 784 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 251 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->conn->connectHandshake();
															#line 251 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<DoKVRequestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 790 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DoKVRequestActor*>(this)->actor_wait_state = 4;
															#line 251 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoKVRequestActor, 3, Void >*>(static_cast<DoKVRequestActor*>(this)));
															#line 795 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 254 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(0.1);
															#line 254 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<DoKVRequestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 804 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont1when2(__when_expr_4.get(), loopDepth); };
			static_cast<DoKVRequestActor*>(this)->actor_wait_state = 5;
															#line 254 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoKVRequestActor, 4, Void >*>(static_cast<DoKVRequestActor*>(this)));
															#line 809 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 237 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(!addrs.empty());
															#line 238 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		int idx = deterministicRandom()->randomInt(0, addrs.size());
															#line 239 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(self->conn, timeoutError(INetworkConnections::net()->connect( addrs[idx].ip.toString(), std::to_string(addrs[idx].port), false), FLOW_KNOBS->CONNECTION_MONITOR_TIMEOUT));
															#line 239 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 825 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoKVRequestActor*>(this)->actor_wait_state = 2;
															#line 239 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoKVRequestActor, 1, Void >*>(static_cast<DoKVRequestActor*>(this)));
															#line 830 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<NetworkAddress> const& __addrs,int loopDepth) 
	{
															#line 235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		addrs = __addrs;
															#line 839 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<NetworkAddress> && __addrs,int loopDepth) 
	{
		addrs = std::move(__addrs);
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKVRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKVRequestActor*>(this)->ActorCallback< DoKVRequestActor, 0, std::vector<NetworkAddress> >::remove();

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> const& value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 0, std::vector<NetworkAddress> >*,std::vector<NetworkAddress> && value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoKVRequestActor, 0, std::vector<NetworkAddress> >*,Error err) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKVRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKVRequestActor*>(this)->ActorCallback< DoKVRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoKVRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKVRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKVRequestActor*>(this)->ActorCallback< DoKVRequestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoKVRequestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont6(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 252 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		++self->connectCount;
															#line 1098 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 252 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		++self->connectCount;
															#line 1107 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKVRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKVRequestActor*>(this)->ActorCallback< DoKVRequestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoKVRequestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 255 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		++self->failedConnectCount;
															#line 1191 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 255 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		++self->failedConnectCount;
															#line 1200 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKVRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKVRequestActor*>(this)->ActorCallback< DoKVRequestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoKVRequestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont3(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
															#line 287 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (BUGGIFY_WITH_PROB(0.1))
															#line 1284 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 288 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			ASSERT(self->conn.isValid());
															#line 289 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			self->conn->close();
															#line 290 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			self->conn.clear();
															#line 1292 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 293 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(response->code, 200);
															#line 294 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(response->data.headers.contains("ClientID"));
															#line 295 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(response->data.headers["ClientID"], std::to_string(self->clientId));
															#line 296 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(response->data.headers.contains("Key"));
															#line 297 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(response->data.headers["Key"], key);
															#line 298 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(response->data.headers.contains("UID"));
															#line 299 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(response->data.headers["UID"], requestID.toString());
															#line 301 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<DoKVRequestActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoKVRequestActorState(); static_cast<DoKVRequestActor*>(this)->destroy(); return 0; }
															#line 1310 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<DoKVRequestActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoKVRequestActorState();
		static_cast<DoKVRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
															#line 287 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (BUGGIFY_WITH_PROB(0.1))
															#line 1322 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 288 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			ASSERT(self->conn.isValid());
															#line 289 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			self->conn->close();
															#line 290 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			self->conn.clear();
															#line 1330 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 293 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(response->code, 200);
															#line 294 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(response->data.headers.contains("ClientID"));
															#line 295 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(response->data.headers["ClientID"], std::to_string(self->clientId));
															#line 296 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(response->data.headers.contains("Key"));
															#line 297 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(response->data.headers["Key"], key);
															#line 298 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT(response->data.headers.contains("UID"));
															#line 299 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		ASSERT_EQ(response->data.headers["UID"], requestID.toString());
															#line 301 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<DoKVRequestActor*>(this)->SAV<Reference<HTTP::IncomingResponse>>::futures) { (void)(response); this->~DoKVRequestActorState(); static_cast<DoKVRequestActor*>(this)->destroy(); return 0; }
															#line 1348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<DoKVRequestActor*>(this)->SAV< Reference<HTTP::IncomingResponse> >::value()) Reference<HTTP::IncomingResponse>(response);
		this->~DoKVRequestActorState();
		static_cast<DoKVRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(response, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKVRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKVRequestActor*>(this)->ActorCallback< DoKVRequestActor, 5, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 5, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 5, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoKVRequestActor, 5, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoKVRequestActor*>(this)->actor_wait_state > 0) static_cast<DoKVRequestActor*>(this)->actor_wait_state = 0;
		static_cast<DoKVRequestActor*>(this)->ActorCallback< DoKVRequestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoKVRequestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoKVRequestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HTTPKeyValueStoreWorkload* self;
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	std::string key;
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	Optional<std::string> value;
															#line 226 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	UnsentPacketQueue content;
															#line 227 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	int seqNo;
															#line 235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	std::vector<NetworkAddress> addrs;
															#line 260 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	Reference<HTTP::OutgoingRequest> req;
															#line 261 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	UID requestID;
															#line 281 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	Reference<IRateControl> sendReceiveRate;
															#line 282 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	int64_t bytes_sent;
															#line 1538 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
};
// This generated class is to be used only via doKVRequest()
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class DoKVRequestActor final : public Actor<Reference<HTTP::IncomingResponse>>, public ActorCallback< DoKVRequestActor, 0, std::vector<NetworkAddress> >, public ActorCallback< DoKVRequestActor, 1, Void >, public ActorCallback< DoKVRequestActor, 2, Void >, public ActorCallback< DoKVRequestActor, 3, Void >, public ActorCallback< DoKVRequestActor, 4, Void >, public ActorCallback< DoKVRequestActor, 5, Reference<HTTP::IncomingResponse> >, public ActorCallback< DoKVRequestActor, 6, Void >, public FastAllocated<DoKVRequestActor>, public DoKVRequestActorState<DoKVRequestActor> {
															#line 1543 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
	using FastAllocated<DoKVRequestActor>::operator new;
	using FastAllocated<DoKVRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9276453775827064576UL, 8449417810384542976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<HTTP::IncomingResponse>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoKVRequestActor, 0, std::vector<NetworkAddress> >;
friend struct ActorCallback< DoKVRequestActor, 1, Void >;
friend struct ActorCallback< DoKVRequestActor, 2, Void >;
friend struct ActorCallback< DoKVRequestActor, 3, Void >;
friend struct ActorCallback< DoKVRequestActor, 4, Void >;
friend struct ActorCallback< DoKVRequestActor, 5, Reference<HTTP::IncomingResponse> >;
friend struct ActorCallback< DoKVRequestActor, 6, Void >;
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	DoKVRequestActor(HTTPKeyValueStoreWorkload* const& self,std::string const& key,Optional<std::string> const& value) 
															#line 1566 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		 : Actor<Reference<HTTP::IncomingResponse>>(),
		   DoKVRequestActorState<DoKVRequestActor>(self, key, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doKVRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12823810989261156608UL, 13583643043459458816UL);
		ActorExecutionContextHelper __helper(static_cast<DoKVRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doKVRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doKVRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoKVRequestActor, 0, std::vector<NetworkAddress> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoKVRequestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoKVRequestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoKVRequestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoKVRequestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoKVRequestActor, 5, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoKVRequestActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
[[nodiscard]] Future<Reference<HTTP::IncomingResponse>> doKVRequest( HTTPKeyValueStoreWorkload* const& self, std::string const& key, Optional<std::string> const& value ) {
															#line 223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	return Future<Reference<HTTP::IncomingResponse>>(new DoKVRequestActor(self, key, value));
															#line 1604 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
}

#line 324 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"

																#line 1609 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
// This generated class is to be used only via put()
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
template <class PutActor>
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class PutActorState {
															#line 1615 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	PutActorState(HTTPKeyValueStoreWorkload* const& self,std::string const& key,std::string const& value) 
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		 : self(self),
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   key(key),
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   value(value)
															#line 1626 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
	{
		fdb_probe_actor_create("put", reinterpret_cast<unsigned long>(this));

	}
	~PutActorState() 
	{
		fdb_probe_actor_destroy("put", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 327 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			std::pair<std::string, std::string> active = { key, value };
															#line 328 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			self->activePut = active;
															#line 330 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (DEBUG_HTTPKV)
															#line 1645 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			{
															#line 331 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				fmt::print("CL:put {0}:{1} = {2}\n", self->clientId, key, value);
															#line 1649 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			}
															#line 334 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_0 = self->doKVRequest(self, key, value);
															#line 334 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<PutActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1655 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PutActor*>(this)->actor_wait_state = 1;
															#line 334 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PutActor, 0, Reference<HTTP::IncomingResponse> >*>(static_cast<PutActor*>(this)));
															#line 1660 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PutActorState();
		static_cast<PutActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
															#line 336 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (DEBUG_HTTPKV)
															#line 1683 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 337 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			fmt::print("CL:put {0}:{1} = {2} DONE\n", self->clientId, key, value);
															#line 1687 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 341 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		self->activePut.reset();
															#line 342 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		self->myData[key] = value;
															#line 343 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		++self->putCount;
															#line 345 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<PutActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PutActorState(); static_cast<PutActor*>(this)->destroy(); return 0; }
															#line 1697 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<PutActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PutActorState();
		static_cast<PutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
															#line 336 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (DEBUG_HTTPKV)
															#line 1709 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 337 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			fmt::print("CL:put {0}:{1} = {2} DONE\n", self->clientId, key, value);
															#line 1713 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 341 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		self->activePut.reset();
															#line 342 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		self->myData[key] = value;
															#line 343 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		++self->putCount;
															#line 345 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<PutActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PutActorState(); static_cast<PutActor*>(this)->destroy(); return 0; }
															#line 1723 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<PutActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PutActorState();
		static_cast<PutActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
		loopDepth = a_body1cont1(response, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PutActor*>(this)->actor_wait_state > 0) static_cast<PutActor*>(this)->actor_wait_state = 0;
		static_cast<PutActor*>(this)->ActorCallback< PutActor, 0, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< PutActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("put", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("put", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PutActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("put", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("put", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PutActor, 0, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("put", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("put", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HTTPKeyValueStoreWorkload* self;
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	std::string key;
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	std::string value;
															#line 1812 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
};
// This generated class is to be used only via put()
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class PutActor final : public Actor<Void>, public ActorCallback< PutActor, 0, Reference<HTTP::IncomingResponse> >, public FastAllocated<PutActor>, public PutActorState<PutActor> {
															#line 1817 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
	using FastAllocated<PutActor>::operator new;
	using FastAllocated<PutActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10983621846427036672UL, 4572818857134243840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PutActor, 0, Reference<HTTP::IncomingResponse> >;
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	PutActor(HTTPKeyValueStoreWorkload* const& self,std::string const& key,std::string const& value) 
															#line 1834 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		 : Actor<Void>(),
		   PutActorState<PutActor>(self, key, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("put", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7717282083008667136UL, 9439217302305690368UL);
		ActorExecutionContextHelper __helper(static_cast<PutActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("put");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("put", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PutActor, 0, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
[[nodiscard]] Future<Void> put( HTTPKeyValueStoreWorkload* const& self, std::string const& key, std::string const& value ) {
															#line 325 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	return Future<Void>(new PutActor(self, key, value));
															#line 1866 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
}

#line 347 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"

																#line 1871 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
// This generated class is to be used only via get()
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
template <class GetActor>
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class GetActorState {
															#line 1877 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	GetActorState(HTTPKeyValueStoreWorkload* const& self,std::string const& key,bool const& checkActive) 
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		 : self(self),
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   key(key),
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		   checkActive(checkActive)
															#line 1888 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
	{
		fdb_probe_actor_create("get", reinterpret_cast<unsigned long>(this));

	}
	~GetActorState() 
	{
		fdb_probe_actor_destroy("get", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 350 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (DEBUG_HTTPKV)
															#line 1903 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			{
															#line 351 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				fmt::print("CL:get {0}:{1}\n", self->clientId, key);
															#line 1907 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			}
															#line 354 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_0 = self->doKVRequest(self, key, {});
															#line 354 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<GetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1913 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetActor*>(this)->actor_wait_state = 1;
															#line 354 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetActor, 0, Reference<HTTP::IncomingResponse> >*>(static_cast<GetActor*>(this)));
															#line 1918 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetActorState();
		static_cast<GetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
															#line 356 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (DEBUG_HTTPKV)
															#line 1941 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 357 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			fmt::print("CL:get {0}:{1} = {2} DONE\n", self->clientId, key, response->data.content);
															#line 1945 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 360 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!checkActive || !self->activePut.present())
															#line 1949 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 361 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			ASSERT_EQ(response->data.content, self->myData[key]);
															#line 1953 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
		else
		{
															#line 363 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			bool contentCorrect = response->data.content == self->myData[key];
															#line 364 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			bool inFlightCorrect = self->activePut.get().first == key && self->activePut.get().second == response->data.content;
															#line 366 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			ASSERT(contentCorrect || inFlightCorrect);
															#line 1963 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 368 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		++self->getCount;
															#line 370 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<GetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 1969 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<GetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetActorState();
		static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
															#line 356 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (DEBUG_HTTPKV)
															#line 1981 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 357 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			fmt::print("CL:get {0}:{1} = {2} DONE\n", self->clientId, key, response->data.content);
															#line 1985 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 360 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!checkActive || !self->activePut.present())
															#line 1989 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 361 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			ASSERT_EQ(response->data.content, self->myData[key]);
															#line 1993 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
		else
		{
															#line 363 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			bool contentCorrect = response->data.content == self->myData[key];
															#line 364 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			bool inFlightCorrect = self->activePut.get().first == key && self->activePut.get().second == response->data.content;
															#line 366 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			ASSERT(contentCorrect || inFlightCorrect);
															#line 2003 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 368 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		++self->getCount;
															#line 370 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<GetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 2009 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<GetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetActorState();
		static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> const& response,int loopDepth) 
	{
		loopDepth = a_body1cont1(response, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<HTTP::IncomingResponse> && response,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(response), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetActor*>(this)->actor_wait_state > 0) static_cast<GetActor*>(this)->actor_wait_state = 0;
		static_cast<GetActor*>(this)->ActorCallback< GetActor, 0, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< GetActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetActor, 0, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetActor, 0, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HTTPKeyValueStoreWorkload* self;
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	std::string key;
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	bool checkActive;
															#line 2098 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
};
// This generated class is to be used only via get()
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class GetActor final : public Actor<Void>, public ActorCallback< GetActor, 0, Reference<HTTP::IncomingResponse> >, public FastAllocated<GetActor>, public GetActorState<GetActor> {
															#line 2103 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
	using FastAllocated<GetActor>::operator new;
	using FastAllocated<GetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12417059946375469568UL, 8599234632014072832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetActor, 0, Reference<HTTP::IncomingResponse> >;
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	GetActor(HTTPKeyValueStoreWorkload* const& self,std::string const& key,bool const& checkActive) 
															#line 2120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		 : Actor<Void>(),
		   GetActorState<GetActor>(self, key, checkActive),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13305627610698362112UL, 12413557174276224768UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("get");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetActor, 0, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
[[nodiscard]] Future<Void> get( HTTPKeyValueStoreWorkload* const& self, std::string const& key, bool const& checkActive ) {
															#line 348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	return Future<Void>(new GetActor(self, key, checkActive));
															#line 2152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
}

#line 372 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"

	Future<Void> setup(Database const& cx) override { return _setup(this); }

																#line 2159 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
template <class _setupActor>
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class _setupActorState {
															#line 2165 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	_setupActorState(HTTPKeyValueStoreWorkload* const& self) 
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		 : self(self)
															#line 2172 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 376 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			ASSERT(g_network->isSimulated());
															#line 377 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (self->clientId == 0)
															#line 2189 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			{
															#line 378 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				TraceEvent("SimHTTPKeyValueStoreRegistering");
															#line 379 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				if (DEBUG_HTTPKV)
															#line 2195 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
				{
															#line 380 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
					fmt::print("Registering sim http kv server\n");
															#line 2199 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
				}
															#line 382 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				StrictFuture<Void> __when_expr_0 = g_simulator->registerSimHTTPServer( self->hostname, self->service, makeReference<KeyValueRequestHandler>());
															#line 382 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2205 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 382 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 2210 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 390 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		TraceEvent("SimHTTPKeyValueStoreLoading");
															#line 392 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		i = int();
															#line 393 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		i = 0;
															#line 2242 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 384 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (DEBUG_HTTPKV)
															#line 2251 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 385 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			fmt::print("Registered sim http kv server\n");
															#line 2255 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 387 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		TraceEvent("SimHTTPKeyValueStoreRegistered");
															#line 2259 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 384 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (DEBUG_HTTPKV)
															#line 2268 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 385 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			fmt::print("Registered sim http kv server\n");
															#line 2272 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 387 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		TraceEvent("SimHTTPKeyValueStoreRegistered");
															#line 2276 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 397 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		TraceEvent("SimHTTPKeyValueStoreLoaded");
															#line 399 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 2362 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 393 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!(i < self->nodeCount))
															#line 2381 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 394 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->put(self, self->getKey(i), self->randomValue());
															#line 394 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2389 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 394 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 2394 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 393 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		i++;
															#line 2416 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 393 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		i++;
															#line 2425 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HTTPKeyValueStoreWorkload* self;
															#line 392 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	int i;
															#line 2509 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 2514 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14259780210649384960UL, 15541272017224216832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	_setupActor(HTTPKeyValueStoreWorkload* const& self) 
															#line 2532 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
[[nodiscard]] Future<Void> _setup( HTTPKeyValueStoreWorkload* const& self ) {
															#line 375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	return Future<Void>(new _setupActor(self));
															#line 2565 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
}

#line 401 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"

	Future<Void> start(Database const& cx) override {
		client = httpKeyValueClient(this);
		return delay(testDuration);
	}

	Future<bool> check(Database const& cx) override {
		// cancel workload client first
		client = Future<Void>(Void());
		return _check(this);
	}

																#line 2581 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
template <class _checkActor>
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class _checkActorState {
															#line 2587 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	_checkActorState(HTTPKeyValueStoreWorkload* const& self) 
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		 : self(self)
															#line 2594 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 415 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (self->conn)
															#line 2609 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			{
															#line 416 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				self->conn->close();
															#line 417 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
				self->conn.clear();
															#line 2615 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			}
															#line 420 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			TraceEvent("SimHTTPKeyValueStoreWorkloadChecking");
															#line 421 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			i = int();
															#line 422 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			i = 0;
															#line 2623 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 426 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		TraceEvent("SimHTTPKeyValueStoreWorkloadChecked");
															#line 428 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (self->conn)
															#line 2648 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 429 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			self->conn->close();
															#line 430 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			self->conn.clear();
															#line 2654 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		}
															#line 433 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 2658 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 422 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (!(i < self->nodeCount))
															#line 2677 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 423 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->get(self, self->getKey(i), true);
															#line 423 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2685 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 423 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 2690 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 422 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		i++;
															#line 2712 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 422 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		i++;
															#line 2721 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HTTPKeyValueStoreWorkload* self;
															#line 421 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	int i;
															#line 2805 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 2810 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3863329818344949248UL, 2947973436114818048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	_checkActor(HTTPKeyValueStoreWorkload* const& self) 
															#line 2827 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
[[nodiscard]] Future<bool> _check( HTTPKeyValueStoreWorkload* const& self ) {
															#line 413 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	return Future<bool>(new _checkActor(self));
															#line 2859 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
}

#line 435 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(getCount.getMetric());
		m.push_back(putCount.getMetric());
		m.push_back(connectCount.getMetric());
		m.push_back(failedConnectCount.getMetric());
	}

																#line 2871 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
// This generated class is to be used only via httpKeyValueClient()
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
template <class HttpKeyValueClientActor>
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class HttpKeyValueClientActorState {
															#line 2877 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HttpKeyValueClientActorState(HTTPKeyValueStoreWorkload* const& self) 
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		 : self(self)
															#line 2884 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
	{
		fdb_probe_actor_create("httpKeyValueClient", reinterpret_cast<unsigned long>(this));

	}
	~HttpKeyValueClientActorState() 
	{
		fdb_probe_actor_destroy("httpKeyValueClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 444 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			TraceEvent("SimHTTPKeyValueStoreWorkloadStarting");
															#line 445 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			last = now();
															#line 446 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			;
															#line 2903 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HttpKeyValueClientActorState();
		static_cast<HttpKeyValueClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 447 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		waitNextOp = poisson(&last, 1.0 / self->opsPerSecond);
															#line 449 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		int key = deterministicRandom()->randomInt(0, self->nodeCount);
															#line 451 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 2937 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		{
															#line 452 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->put(self, self->getKey(key), self->randomValue());
															#line 452 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2943 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state = 1;
															#line 452 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HttpKeyValueClientActor, 0, Void >*>(static_cast<HttpKeyValueClientActor*>(this)));
															#line 2948 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 454 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->get(self, self->getKey(key), false);
															#line 454 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			if (static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2957 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state = 2;
															#line 454 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HttpKeyValueClientActor, 1, Void >*>(static_cast<HttpKeyValueClientActor*>(this)));
															#line 2962 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 457 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitNextOp;
															#line 457 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		if (static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2974 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state = 3;
															#line 457 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HttpKeyValueClientActor, 2, Void >*>(static_cast<HttpKeyValueClientActor*>(this)));
															#line 2979 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state > 0) static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state = 0;
		static_cast<HttpKeyValueClientActor*>(this)->ActorCallback< HttpKeyValueClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HttpKeyValueClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HttpKeyValueClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HttpKeyValueClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state > 0) static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state = 0;
		static_cast<HttpKeyValueClientActor*>(this)->ActorCallback< HttpKeyValueClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HttpKeyValueClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HttpKeyValueClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HttpKeyValueClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state > 0) static_cast<HttpKeyValueClientActor*>(this)->actor_wait_state = 0;
		static_cast<HttpKeyValueClientActor*>(this)->ActorCallback< HttpKeyValueClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HttpKeyValueClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HttpKeyValueClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HttpKeyValueClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HTTPKeyValueStoreWorkload* self;
															#line 445 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	double last;
															#line 447 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	Future<Void> waitNextOp;
															#line 3251 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
};
// This generated class is to be used only via httpKeyValueClient()
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
class HttpKeyValueClientActor final : public Actor<Void>, public ActorCallback< HttpKeyValueClientActor, 0, Void >, public ActorCallback< HttpKeyValueClientActor, 1, Void >, public ActorCallback< HttpKeyValueClientActor, 2, Void >, public FastAllocated<HttpKeyValueClientActor>, public HttpKeyValueClientActorState<HttpKeyValueClientActor> {
															#line 3256 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
public:
	using FastAllocated<HttpKeyValueClientActor>::operator new;
	using FastAllocated<HttpKeyValueClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7964902824952077312UL, 18328904004260818944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HttpKeyValueClientActor, 0, Void >;
friend struct ActorCallback< HttpKeyValueClientActor, 1, Void >;
friend struct ActorCallback< HttpKeyValueClientActor, 2, Void >;
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	HttpKeyValueClientActor(HTTPKeyValueStoreWorkload* const& self) 
															#line 3275 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
		 : Actor<Void>(),
		   HttpKeyValueClientActorState<HttpKeyValueClientActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("httpKeyValueClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10840502629977297664UL, 16890802419594418688UL);
		ActorExecutionContextHelper __helper(static_cast<HttpKeyValueClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("httpKeyValueClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("httpKeyValueClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HttpKeyValueClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HttpKeyValueClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HttpKeyValueClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
[[nodiscard]] Future<Void> httpKeyValueClient( HTTPKeyValueStoreWorkload* const& self ) {
															#line 443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
	return Future<Void>(new HttpKeyValueClientActor(self));
															#line 3309 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HTTPKeyValueStore.actor.g.cpp"
}

#line 460 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/workloads/HTTPKeyValueStore.actor.cpp"
};

WorkloadFactory<HTTPKeyValueStoreWorkload> HTTPKeyValueStoreWorkloadFactory;