#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
/*
 * ExclusionTracker.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(EXCLUSION_TRACKER_ACTOR_G_H)
#define EXCLUSION_TRACKER_ACTOR_G_H
#include "fdbserver/ExclusionTracker.actor.g.h"
#elif !defined(EXCLUSION_TRACKER_ACTOR_H)
#define EXCLUSION_TRACKER_ACTOR_H

#include <set>
#include "flow/flow.h"
#include "flow/Trace.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct ExclusionTracker {
	std::set<AddressExclusion> excluded;
	std::set<AddressExclusion> failed;

	AsyncTrigger changed;

	Database db;
	Future<Void> trackerFuture;

	ExclusionTracker() {}
	ExclusionTracker(Database db) : db(db) { trackerFuture = tracker(this); }

	bool isFailedOrExcluded(NetworkAddress addr) {
		AddressExclusion addrExclusion(addr.ip, addr.port);
		return excluded.contains(addrExclusion) || failed.contains(addrExclusion);
	}

	// Note the tracker is intended to be used by the Data Distributor. The tracker will check for excluded localities
	// based on the server list, the server list only includes storage processes.
																#line 59 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
// This generated class is to be used only via tracker()
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
template <class TrackerActor>
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
class TrackerActorState {
															#line 65 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
public:
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	TrackerActorState(ExclusionTracker* const& self) 
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		 : self(self),
															#line 59 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		   tr(self->db)
															#line 74 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
	{
		fdb_probe_actor_create("tracker", reinterpret_cast<unsigned long>(this));

	}
	~TrackerActorState() 
	{
		fdb_probe_actor_destroy("tracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			;
															#line 89 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackerActorState();
		static_cast<TrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 62 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 63 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 64 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 65 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			fresultsExclude = tr.getRange(excludedServersKeys, CLIENT_KNOBS->TOO_MANY);
															#line 66 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			fresultsFailed = tr.getRange(failedServersKeys, CLIENT_KNOBS->TOO_MANY);
															#line 67 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			flocalitiesExclude = tr.getRange(excludedLocalityKeys, CLIENT_KNOBS->TOO_MANY);
															#line 69 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			flocalitiesFailed = tr.getRange(failedLocalityKeys, CLIENT_KNOBS->TOO_MANY);
															#line 70 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			fServerList = tr.getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 72 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			StrictFuture<Void> __when_expr_0 = success(fresultsExclude) && success(fresultsFailed) && success(flocalitiesExclude) && success(flocalitiesFailed);
															#line 72 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 138 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackerActor*>(this)->actor_wait_state = 1;
															#line 72 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 0, Void >*>(static_cast<TrackerActor*>(this)));
															#line 143 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 184 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			TraceEvent("ExclusionTrackerError").error(e);
															#line 185 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 185 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 169 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<TrackerActor*>(this)->actor_wait_state = 5;
															#line 185 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 4, Void >*>(static_cast<TrackerActor*>(this)));
															#line 174 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		excludedResults = fresultsExclude.get();
															#line 76 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!excludedResults.more && excludedResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 78 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		failedResults = fresultsFailed.get();
															#line 79 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!failedResults.more && failedResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 81 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		excludedLocalityResults = flocalitiesExclude.get();
															#line 82 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!excludedLocalityResults.more && excludedLocalityResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 84 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		failedLocalityResults = flocalitiesFailed.get();
															#line 85 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!failedLocalityResults.more && failedLocalityResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 87 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		newExcluded = std::set<AddressExclusion>();
															#line 88 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		newFailed = std::set<AddressExclusion>();
															#line 89 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : excludedResults ) {
															#line 90 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			AddressExclusion addr = decodeExcludedServersKey(r.key);
															#line 91 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (addr.isValid())
															#line 213 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 92 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newExcluded.insert(addr);
															#line 217 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 95 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : failedResults ) {
															#line 96 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			AddressExclusion addr = decodeFailedServersKey(r.key);
															#line 97 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (addr.isValid())
															#line 226 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 98 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newFailed.insert(addr);
															#line 230 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_1 = success(fServerList);
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 237 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 2;
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 1, Void >*>(static_cast<TrackerActor*>(this)));
															#line 242 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 75 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		excludedResults = fresultsExclude.get();
															#line 76 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!excludedResults.more && excludedResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 78 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		failedResults = fresultsFailed.get();
															#line 79 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!failedResults.more && failedResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 81 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		excludedLocalityResults = flocalitiesExclude.get();
															#line 82 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!excludedLocalityResults.more && excludedLocalityResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 84 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		failedLocalityResults = flocalitiesFailed.get();
															#line 85 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		ASSERT(!failedLocalityResults.more && failedLocalityResults.size() < CLIENT_KNOBS->TOO_MANY);
															#line 87 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		newExcluded = std::set<AddressExclusion>();
															#line 88 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		newFailed = std::set<AddressExclusion>();
															#line 89 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : excludedResults ) {
															#line 90 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			AddressExclusion addr = decodeExcludedServersKey(r.key);
															#line 91 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (addr.isValid())
															#line 275 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 92 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newExcluded.insert(addr);
															#line 279 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 95 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( const auto& r : failedResults ) {
															#line 96 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			AddressExclusion addr = decodeFailedServersKey(r.key);
															#line 97 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			if (addr.isValid())
															#line 288 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			{
															#line 98 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newFailed.insert(addr);
															#line 292 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
			}
		}
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_1 = success(fServerList);
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 299 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 2;
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 1, Void >*>(static_cast<TrackerActor*>(this)));
															#line 304 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 107 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		decodedExcludedLocalities = std::vector<std::pair<std::string, std::string>>();
															#line 108 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( auto& excludedLocality : excludedLocalityResults ) {
															#line 109 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			decodedExcludedLocalities.push_back( decodeLocality(decodeExcludedLocalityKey(excludedLocality.key)));
															#line 392 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		decodedFailedLocalities = std::vector<std::pair<std::string, std::string>>();
															#line 114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( auto& failedLocality : failedLocalityResults ) {
															#line 115 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			decodedFailedLocalities.push_back(decodeLocality(decodeFailedLocalityKey(failedLocality.key)));
															#line 400 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 118 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		serverList = fServerList.get();
															#line 119 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( auto& s : serverList ) {
															#line 120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			auto decodedServer = decodeServerListValue(s.value);
															#line 122 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			for( auto& excludedLocality : decodedExcludedLocalities ) {
															#line 123 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (!decodedServer.locality.isPresent(excludedLocality.first))
															#line 412 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
					continue;
				}
															#line 127 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (decodedServer.locality.get(excludedLocality.first) != excludedLocality.second)
															#line 418 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
					continue;
				}
															#line 131 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				auto addresses = decodedServer.getKeyValues.getEndpoint().addresses;
															#line 132 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newExcluded.insert(AddressExclusion(addresses.address.ip, addresses.address.port));
															#line 133 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (addresses.secondaryAddress.present())
															#line 428 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
															#line 134 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
					auto secondaryAddress = addresses.secondaryAddress.get();
															#line 135 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
					newExcluded.insert(AddressExclusion(secondaryAddress.ip, secondaryAddress.port));
															#line 434 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				}
			}
															#line 140 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			for( auto& failedLocality : decodedFailedLocalities ) {
															#line 141 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (!decodedServer.locality.isPresent(failedLocality.first))
															#line 441 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
					continue;
				}
															#line 145 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (decodedServer.locality.get(failedLocality.first) != failedLocality.second)
															#line 447 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
					continue;
				}
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				auto addresses = decodedServer.getKeyValues.getEndpoint().addresses;
															#line 150 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newFailed.insert(AddressExclusion(addresses.address.ip, addresses.address.port));
															#line 151 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (addresses.secondaryAddress.present())
															#line 457 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
															#line 152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
					auto secondaryAddress = addresses.secondaryAddress.get();
															#line 153 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
					newFailed.insert(AddressExclusion(secondaryAddress.ip, secondaryAddress.port));
															#line 463 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				}
			}
		}
															#line 158 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		bool foundChange = false;
															#line 159 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (self->excluded != newExcluded)
															#line 471 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 160 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->excluded = newExcluded;
															#line 161 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			foundChange = true;
															#line 477 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 163 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (self->failed != newFailed)
															#line 481 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 164 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->failed = newFailed;
															#line 165 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			foundChange = true;
															#line 487 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 168 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (foundChange)
															#line 491 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 169 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->changed.trigger();
															#line 495 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 172 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		watchFuture = tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 503 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 3;
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 2, Void >*>(static_cast<TrackerActor*>(this)));
															#line 508 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 107 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		decodedExcludedLocalities = std::vector<std::pair<std::string, std::string>>();
															#line 108 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( auto& excludedLocality : excludedLocalityResults ) {
															#line 109 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			decodedExcludedLocalities.push_back( decodeLocality(decodeExcludedLocalityKey(excludedLocality.key)));
															#line 521 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		decodedFailedLocalities = std::vector<std::pair<std::string, std::string>>();
															#line 114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( auto& failedLocality : failedLocalityResults ) {
															#line 115 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			decodedFailedLocalities.push_back(decodeLocality(decodeFailedLocalityKey(failedLocality.key)));
															#line 529 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 118 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		serverList = fServerList.get();
															#line 119 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		for( auto& s : serverList ) {
															#line 120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			auto decodedServer = decodeServerListValue(s.value);
															#line 122 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			for( auto& excludedLocality : decodedExcludedLocalities ) {
															#line 123 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (!decodedServer.locality.isPresent(excludedLocality.first))
															#line 541 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
					continue;
				}
															#line 127 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (decodedServer.locality.get(excludedLocality.first) != excludedLocality.second)
															#line 547 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
					continue;
				}
															#line 131 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				auto addresses = decodedServer.getKeyValues.getEndpoint().addresses;
															#line 132 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newExcluded.insert(AddressExclusion(addresses.address.ip, addresses.address.port));
															#line 133 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (addresses.secondaryAddress.present())
															#line 557 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
															#line 134 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
					auto secondaryAddress = addresses.secondaryAddress.get();
															#line 135 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
					newExcluded.insert(AddressExclusion(secondaryAddress.ip, secondaryAddress.port));
															#line 563 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				}
			}
															#line 140 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			for( auto& failedLocality : decodedFailedLocalities ) {
															#line 141 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (!decodedServer.locality.isPresent(failedLocality.first))
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
					continue;
				}
															#line 145 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (decodedServer.locality.get(failedLocality.first) != failedLocality.second)
															#line 576 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
					continue;
				}
															#line 149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				auto addresses = decodedServer.getKeyValues.getEndpoint().addresses;
															#line 150 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				newFailed.insert(AddressExclusion(addresses.address.ip, addresses.address.port));
															#line 151 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
				if (addresses.secondaryAddress.present())
															#line 586 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				{
															#line 152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
					auto secondaryAddress = addresses.secondaryAddress.get();
															#line 153 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
					newFailed.insert(AddressExclusion(secondaryAddress.ip, secondaryAddress.port));
															#line 592 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
				}
			}
		}
															#line 158 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		bool foundChange = false;
															#line 159 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (self->excluded != newExcluded)
															#line 600 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 160 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->excluded = newExcluded;
															#line 161 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			foundChange = true;
															#line 606 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 163 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (self->failed != newFailed)
															#line 610 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 164 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->failed = newFailed;
															#line 165 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			foundChange = true;
															#line 616 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 168 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (foundChange)
															#line 620 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 169 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			self->changed.trigger();
															#line 624 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 172 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		watchFuture = tr.watch(excludedServersVersionKey) || tr.watch(failedServersVersionKey) || tr.watch(excludedLocalityVersionKey) || tr.watch(failedLocalityVersionKey);
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 632 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 3;
															#line 175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 2, Void >*>(static_cast<TrackerActor*>(this)));
															#line 637 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (excludedLocalityResults.size() > 0 || failedLocalityResults.size() > 0)
															#line 721 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 179 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			watchFuture = watchFuture || delay(10.0);
															#line 725 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 731 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 4;
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 3, Void >*>(static_cast<TrackerActor*>(this)));
															#line 736 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 176 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (excludedLocalityResults.size() > 0 || failedLocalityResults.size() > 0)
															#line 745 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		{
															#line 179 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
			watchFuture = watchFuture || delay(10.0);
															#line 749 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		}
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		if (static_cast<TrackerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 755 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_3.get(), loopDepth); };
		static_cast<TrackerActor*>(this)->actor_wait_state = 4;
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TrackerActor, 3, Void >*>(static_cast<TrackerActor*>(this)));
															#line 760 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TrackerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont23(Void const& _,int loopDepth) 
	{
															#line 182 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		tr.reset();
															#line 844 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = a_body1loopBody1cont23cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont23(Void && _,int loopDepth) 
	{
															#line 182 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
		tr.reset();
															#line 853 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		loopDepth = a_body1loopBody1cont23cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont23(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TrackerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont23cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<TrackerActor*>(this)->actor_wait_state > 0) static_cast<TrackerActor*>(this)->actor_wait_state = 0;
		static_cast<TrackerActor*>(this)->ActorCallback< TrackerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< TrackerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< TrackerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	ExclusionTracker* self;
															#line 59 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	ReadYourWritesTransaction tr;
															#line 65 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> fresultsExclude;
															#line 66 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> fresultsFailed;
															#line 67 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> flocalitiesExclude;
															#line 69 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> flocalitiesFailed;
															#line 70 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<RangeResult> fServerList;
															#line 75 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult excludedResults;
															#line 78 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult failedResults;
															#line 81 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult excludedLocalityResults;
															#line 84 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult failedLocalityResults;
															#line 87 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	std::set<AddressExclusion> newExcluded;
															#line 88 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	std::set<AddressExclusion> newFailed;
															#line 107 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	std::vector<std::pair<std::string, std::string>> decodedExcludedLocalities;
															#line 113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	std::vector<std::pair<std::string, std::string>> decodedFailedLocalities;
															#line 118 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	RangeResult serverList;
															#line 172 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	Future<Void> watchFuture;
															#line 1067 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
};
// This generated class is to be used only via tracker()
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
class TrackerActor final : public Actor<Void>, public ActorCallback< TrackerActor, 0, Void >, public ActorCallback< TrackerActor, 1, Void >, public ActorCallback< TrackerActor, 2, Void >, public ActorCallback< TrackerActor, 3, Void >, public ActorCallback< TrackerActor, 4, Void >, public FastAllocated<TrackerActor>, public TrackerActorState<TrackerActor> {
															#line 1072 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
public:
	using FastAllocated<TrackerActor>::operator new;
	using FastAllocated<TrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15115396544921661952UL, 12829644509991431424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackerActor, 0, Void >;
friend struct ActorCallback< TrackerActor, 1, Void >;
friend struct ActorCallback< TrackerActor, 2, Void >;
friend struct ActorCallback< TrackerActor, 3, Void >;
friend struct ActorCallback< TrackerActor, 4, Void >;
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	TrackerActor(ExclusionTracker* const& self) 
															#line 1093 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
		 : Actor<Void>(),
		   TrackerActorState<TrackerActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16871199721278967296UL, 2007396679958793216UL);
		ActorExecutionContextHelper __helper(static_cast<TrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TrackerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TrackerActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< TrackerActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
[[nodiscard]] static Future<Void> tracker( ExclusionTracker* const& self ) {
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
	return Future<Void>(new TrackerActor(self));
															#line 1129 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ExclusionTracker.actor.g.h"
}

#line 189 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ExclusionTracker.actor.h"
};

#include "flow/unactorcompiler.h"
#endif
