#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
/*
 * TagPartitionedLogSystem.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TagPartitionedLogSystem.actor.h"

#include <boost/dynamic_bitset.hpp>
#include <utility>

#include "fdbrpc/ReplicationUtils.h"
#include "fdbserver/WaitFailure.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 33 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
namespace {
// This generated class is to be used only via minVersionWhenReady()
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class MinVersionWhenReadyActor>
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class MinVersionWhenReadyActorState {
															#line 40 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	MinVersionWhenReadyActorState(Future<Void> const& f,std::vector<std::pair<UID, Future<TLogCommitReply>>> const& replies) 
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : f(f),
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   replies(replies)
															#line 49 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("minVersionWhenReady", reinterpret_cast<unsigned long>(this));

	}
	~MinVersionWhenReadyActorState() 
	{
		fdb_probe_actor_destroy("minVersionWhenReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 34 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = f;
															#line 34 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (static_cast<MinVersionWhenReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 67 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<MinVersionWhenReadyActor*>(this)->actor_wait_state = 1;
															#line 34 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MinVersionWhenReadyActor, 0, Void >*>(static_cast<MinVersionWhenReadyActor*>(this)));
															#line 72 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MinVersionWhenReadyActorState();
		static_cast<MinVersionWhenReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& err,int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (err.code() == error_code_operation_cancelled)
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 44 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "TLogPushCancelled");
															#line 45 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				int index = 0;
															#line 46 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( const auto& [tlogID, reply] : replies ) {
															#line 47 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (reply.isReady())
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
						continue;
					}
															#line 50 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					std::string message;
															#line 51 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (reply.isError())
															#line 120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 53 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						message = format("TLogPushRespondError%04d", index++);
															#line 124 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
					else
					{
															#line 55 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						message = format("TLogPushNoResponse%04d", index++);
															#line 130 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, message.c_str()) .detail("TLogID", tlogID);
															#line 134 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 61 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			return a_body1Catch1(err, loopDepth);
															#line 139 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version minVersion = std::numeric_limits<Version>::max();
															#line 36 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( const auto& [_tlogID, reply] : replies ) {
															#line 37 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (reply.isReady() && !reply.isError())
															#line 157 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 38 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				minVersion = std::min(minVersion, reply.get().version);
															#line 161 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 41 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<MinVersionWhenReadyActor*>(this)->SAV<Version>::futures) { (void)(minVersion); this->~MinVersionWhenReadyActorState(); static_cast<MinVersionWhenReadyActor*>(this)->destroy(); return 0; }
															#line 166 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<MinVersionWhenReadyActor*>(this)->SAV< Version >::value()) Version(minVersion);
		this->~MinVersionWhenReadyActorState();
		static_cast<MinVersionWhenReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version minVersion = std::numeric_limits<Version>::max();
															#line 36 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( const auto& [_tlogID, reply] : replies ) {
															#line 37 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (reply.isReady() && !reply.isError())
															#line 182 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 38 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				minVersion = std::min(minVersion, reply.get().version);
															#line 186 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 41 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<MinVersionWhenReadyActor*>(this)->SAV<Version>::futures) { (void)(minVersion); this->~MinVersionWhenReadyActorState(); static_cast<MinVersionWhenReadyActor*>(this)->destroy(); return 0; }
															#line 191 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<MinVersionWhenReadyActor*>(this)->SAV< Version >::value()) Version(minVersion);
		this->~MinVersionWhenReadyActorState();
		static_cast<MinVersionWhenReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MinVersionWhenReadyActor*>(this)->actor_wait_state > 0) static_cast<MinVersionWhenReadyActor*>(this)->actor_wait_state = 0;
		static_cast<MinVersionWhenReadyActor*>(this)->ActorCallback< MinVersionWhenReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MinVersionWhenReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("minVersionWhenReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MinVersionWhenReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("minVersionWhenReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MinVersionWhenReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("minVersionWhenReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MinVersionWhenReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("minVersionWhenReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MinVersionWhenReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("minVersionWhenReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MinVersionWhenReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("minVersionWhenReady", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<Void> f;
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<std::pair<UID, Future<TLogCommitReply>>> replies;
															#line 278 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via minVersionWhenReady()
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class MinVersionWhenReadyActor final : public Actor<Version>, public ActorCallback< MinVersionWhenReadyActor, 0, Void >, public FastAllocated<MinVersionWhenReadyActor>, public MinVersionWhenReadyActorState<MinVersionWhenReadyActor> {
															#line 283 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<MinVersionWhenReadyActor>::operator new;
	using FastAllocated<MinVersionWhenReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13553746639014249216UL, 13644858290074411776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MinVersionWhenReadyActor, 0, Void >;
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	MinVersionWhenReadyActor(Future<Void> const& f,std::vector<std::pair<UID, Future<TLogCommitReply>>> const& replies) 
															#line 300 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Version>(),
		   MinVersionWhenReadyActorState<MinVersionWhenReadyActor>(f, replies),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("minVersionWhenReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15255705688928202496UL, 7004582222134066944UL);
		ActorExecutionContextHelper __helper(static_cast<MinVersionWhenReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("minVersionWhenReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("minVersionWhenReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MinVersionWhenReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Version> minVersionWhenReady( Future<Void> const& f, std::vector<std::pair<UID, Future<TLogCommitReply>>> const& replies ) {
															#line 31 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Version>(new MinVersionWhenReadyActor(f, replies));
															#line 333 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 64 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

LogSet::LogSet(const TLogSet& tLogSet)
  : tLogWriteAntiQuorum(tLogSet.tLogWriteAntiQuorum), tLogReplicationFactor(tLogSet.tLogReplicationFactor),
    tLogLocalities(tLogSet.tLogLocalities), tLogVersion(tLogSet.tLogVersion), tLogPolicy(tLogSet.tLogPolicy),
    isLocal(tLogSet.isLocal), locality(tLogSet.locality), startVersion(tLogSet.startVersion),
    satelliteTagLocations(tLogSet.satelliteTagLocations) {
	for (const auto& log : tLogSet.tLogs) {
		logServers.push_back(makeReference<AsyncVar<OptionalInterface<TLogInterface>>>(log));
	}
	for (const auto& log : tLogSet.logRouters) {
		logRouters.push_back(makeReference<AsyncVar<OptionalInterface<TLogInterface>>>(log));
	}
	for (const auto& log : tLogSet.backupWorkers) {
		backupWorkers.push_back(makeReference<AsyncVar<OptionalInterface<BackupInterface>>>(log));
	}
	filterLocalityDataForPolicy(tLogPolicy, &tLogLocalities);
	updateLocalitySet(tLogLocalities);
}

LogSet::LogSet(const CoreTLogSet& coreSet)
  : tLogWriteAntiQuorum(coreSet.tLogWriteAntiQuorum), tLogReplicationFactor(coreSet.tLogReplicationFactor),
    tLogLocalities(coreSet.tLogLocalities), tLogVersion(coreSet.tLogVersion), tLogPolicy(coreSet.tLogPolicy),
    isLocal(coreSet.isLocal), locality(coreSet.locality), startVersion(coreSet.startVersion),
    satelliteTagLocations(coreSet.satelliteTagLocations) {
	for (const auto& log : coreSet.tLogs) {
		logServers.push_back(
		    makeReference<AsyncVar<OptionalInterface<TLogInterface>>>(OptionalInterface<TLogInterface>(log)));
	}
	// Do NOT recover coreSet.backupWorkers, because master will recruit new ones.
	filterLocalityDataForPolicy(tLogPolicy, &tLogLocalities);
	updateLocalitySet(tLogLocalities);
}

TLogSet::TLogSet(const LogSet& rhs)
  : tLogWriteAntiQuorum(rhs.tLogWriteAntiQuorum), tLogReplicationFactor(rhs.tLogReplicationFactor),
    tLogLocalities(rhs.tLogLocalities), tLogVersion(rhs.tLogVersion), tLogPolicy(rhs.tLogPolicy), isLocal(rhs.isLocal),
    locality(rhs.locality), startVersion(rhs.startVersion), satelliteTagLocations(rhs.satelliteTagLocations) {
	for (const auto& tlog : rhs.logServers) {
		tLogs.push_back(tlog->get());
	}
	for (const auto& logRouter : rhs.logRouters) {
		logRouters.push_back(logRouter->get());
	}
	for (const auto& worker : rhs.backupWorkers) {
		backupWorkers.push_back(worker->get());
	}
}

OldTLogConf::OldTLogConf(const OldLogData& oldLogData)
  : epochBegin(oldLogData.epochBegin), epochEnd(oldLogData.epochEnd), recoverAt(oldLogData.recoverAt),
    logRouterTags(oldLogData.logRouterTags), txsTags(oldLogData.txsTags), pseudoLocalities(oldLogData.pseudoLocalities),
    epoch(oldLogData.epoch) {
	for (const Reference<LogSet>& logSet : oldLogData.tLogs) {
		tLogs.emplace_back(*logSet);
	}
}

CoreTLogSet::CoreTLogSet(const LogSet& logset)
  : tLogWriteAntiQuorum(logset.tLogWriteAntiQuorum), tLogReplicationFactor(logset.tLogReplicationFactor),
    tLogLocalities(logset.tLogLocalities), tLogPolicy(logset.tLogPolicy), isLocal(logset.isLocal),
    locality(logset.locality), startVersion(logset.startVersion), satelliteTagLocations(logset.satelliteTagLocations),
    tLogVersion(logset.tLogVersion) {
	for (const auto& log : logset.logServers) {
		tLogs.push_back(log->get().id());
	}
	// Do NOT store logset.backupWorkers, because master will recruit new ones.
}

OldTLogCoreData::OldTLogCoreData(const OldLogData& oldData)
  : logRouterTags(oldData.logRouterTags), txsTags(oldData.txsTags), epochBegin(oldData.epochBegin),
    epochEnd(oldData.epochEnd), recoverAt(oldData.recoverAt), pseudoLocalities(oldData.pseudoLocalities),
    epoch(oldData.epoch) {
	for (const Reference<LogSet>& logSet : oldData.tLogs) {
		if (logSet->logServers.size()) {
			tLogs.emplace_back(*logSet);
		}
	}
}

Future<Void> ILogSystem::recoverAndEndEpoch(Reference<AsyncVar<Reference<ILogSystem>>> const& outLogSystem,
                                            UID const& dbgid,
                                            DBCoreState const& oldState,
                                            FutureStream<TLogRejoinRequest> const& rejoins,
                                            LocalityData const& locality,
                                            bool* forceRecovery) {
	return TagPartitionedLogSystem::recoverAndEndEpoch(outLogSystem, dbgid, oldState, rejoins, locality, forceRecovery);
}

Reference<ILogSystem> ILogSystem::fromLogSystemConfig(UID const& dbgid,
                                                      struct LocalityData const& locality,
                                                      struct LogSystemConfig const& conf,
                                                      bool excludeRemote,
                                                      bool useRecoveredAt,
                                                      Optional<PromiseStream<Future<Void>>> addActor) {
	if (conf.logSystemType == LogSystemType::empty)
		return Reference<ILogSystem>();
	else if (conf.logSystemType == LogSystemType::tagPartitioned)
		return TagPartitionedLogSystem::fromLogSystemConfig(
		    dbgid, locality, conf, excludeRemote, useRecoveredAt, addActor);
	else
		throw internal_error();
}

Reference<ILogSystem> ILogSystem::fromOldLogSystemConfig(UID const& dbgid,
                                                         struct LocalityData const& locality,
                                                         struct LogSystemConfig const& conf) {
	if (conf.logSystemType == LogSystemType::empty)
		return Reference<ILogSystem>();
	else if (conf.logSystemType == LogSystemType::tagPartitioned)
		return TagPartitionedLogSystem::fromOldLogSystemConfig(dbgid, locality, conf);
	else
		throw internal_error();
}

Reference<ILogSystem> ILogSystem::fromServerDBInfo(UID const& dbgid,
                                                   ServerDBInfo const& dbInfo,
                                                   bool useRecoveredAt,
                                                   Optional<PromiseStream<Future<Void>>> addActor) {
	return fromLogSystemConfig(dbgid, dbInfo.myLocality, dbInfo.logSystemConfig, false, useRecoveredAt, addActor);
}

void TagPartitionedLogSystem::stopRejoins() {
	rejoins = Future<Void>();
}

void TagPartitionedLogSystem::addref() {
	ReferenceCounted<TagPartitionedLogSystem>::addref();
}

void TagPartitionedLogSystem::delref() {
	ReferenceCounted<TagPartitionedLogSystem>::delref();
}

std::string TagPartitionedLogSystem::describe() const {
	std::string result;
	for (int i = 0; i < tLogs.size(); i++) {
		result += format("%d: ", i);
		for (int j = 0; j < tLogs[i]->logServers.size(); j++) {
			result +=
			    tLogs[i]->logServers[j]->get().id().toString() + ((j == tLogs[i]->logServers.size() - 1) ? " " : ", ");
		}
	}
	return result;
}

UID TagPartitionedLogSystem::getDebugID() const {
	return dbgid;
}

void TagPartitionedLogSystem::addPseudoLocality(int8_t locality) {
	ASSERT(locality < 0);
	pseudoLocalities.insert(locality);
	for (uint16_t i = 0; i < logRouterTags; i++) {
		pseudoLocalityPopVersion[Tag(locality, i)] = 0;
	}
}

Tag TagPartitionedLogSystem::getPseudoPopTag(Tag tag, ProcessClass::ClassType type) const {
	switch (type) {
	case ProcessClass::LogRouterClass:
		if (tag.locality == tagLocalityLogRouter) {
			ASSERT(pseudoLocalities.contains(tagLocalityLogRouterMapped));
			tag.locality = tagLocalityLogRouterMapped;
		}
		break;

	case ProcessClass::BackupClass:
		if (tag.locality == tagLocalityLogRouter) {
			ASSERT(pseudoLocalities.contains(tagLocalityBackup));
			tag.locality = tagLocalityBackup;
		}
		break;

	default: // This should be an error at caller site.
		break;
	}
	return tag;
}

bool TagPartitionedLogSystem::hasPseudoLocality(int8_t locality) const {
	return pseudoLocalities.contains(locality);
}

Version TagPartitionedLogSystem::popPseudoLocalityTag(Tag tag, Version upTo) {
	ASSERT(isPseudoLocality(tag.locality) && hasPseudoLocality(tag.locality));

	Version& localityVersion = pseudoLocalityPopVersion[tag];
	localityVersion = std::max(localityVersion, upTo);
	Version minVersion = localityVersion;
	// Why do we need to use the minimum popped version among all tags? Reason: for example,
	// 2 pseudo tags pop 100 or 150, respectively. It's only safe to pop min(100, 150),
	// because [101,150) is needed by another pseudo tag.
	for (const int8_t locality : pseudoLocalities) {
		minVersion = std::min(minVersion, pseudoLocalityPopVersion[Tag(locality, tag.id)]);
	}
	// TraceEvent("TLogPopPseudoTag", dbgid).detail("Tag", tag).detail("Version", upTo).detail("PopVersion", minVersion);
	return minVersion;
}

Future<Void> TagPartitionedLogSystem::recoverAndEndEpoch(Reference<AsyncVar<Reference<ILogSystem>>> const& outLogSystem,
                                                         UID const& dbgid,
                                                         DBCoreState const& oldState,
                                                         FutureStream<TLogRejoinRequest> const& rejoins,
                                                         LocalityData const& locality,
                                                         bool* forceRecovery) {
	return epochEnd(outLogSystem, dbgid, oldState, rejoins, locality, forceRecovery);
}

Reference<ILogSystem> TagPartitionedLogSystem::fromLogSystemConfig(UID const& dbgid,
                                                                   LocalityData const& locality,
                                                                   LogSystemConfig const& lsConf,
                                                                   bool excludeRemote,
                                                                   bool useRecoveredAt,
                                                                   Optional<PromiseStream<Future<Void>>> addActor) {
	ASSERT(lsConf.logSystemType == LogSystemType::tagPartitioned ||
	       (lsConf.logSystemType == LogSystemType::empty && !lsConf.tLogs.size()));
	// ASSERT(lsConf.epoch == epoch);  //< FIXME
	auto logSystem = makeReference<TagPartitionedLogSystem>(dbgid, locality, lsConf.epoch, addActor);

	logSystem->tLogs.reserve(lsConf.tLogs.size());
	logSystem->expectedLogSets = lsConf.expectedLogSets;
	logSystem->logRouterTags = lsConf.logRouterTags;
	logSystem->txsTags = lsConf.txsTags;
	logSystem->recruitmentID = lsConf.recruitmentID;
	logSystem->stopped = lsConf.stopped;
	if (useRecoveredAt) {
		logSystem->recoveredAt = lsConf.recoveredAt;
	}
	logSystem->pseudoLocalities = lsConf.pseudoLocalities;
	for (const TLogSet& tLogSet : lsConf.tLogs) {
		if (!excludeRemote || tLogSet.isLocal) {
			logSystem->tLogs.push_back(makeReference<LogSet>(tLogSet));
		}
	}

	for (const auto& oldTlogConf : lsConf.oldTLogs) {
		logSystem->oldLogData.emplace_back(oldTlogConf);
		//TraceEvent("BWFromLSConf")
		//    .detail("Epoch", logSystem->oldLogData.back().epoch)
		//    .detail("Version", logSystem->oldLogData.back().epochEnd);
	}

	logSystem->logSystemType = lsConf.logSystemType;
	logSystem->oldestBackupEpoch = lsConf.oldestBackupEpoch;
	logSystem->knownLockedTLogIds = lsConf.knownLockedTLogIds;
	return logSystem;
}

Reference<ILogSystem> TagPartitionedLogSystem::fromOldLogSystemConfig(UID const& dbgid,
                                                                      LocalityData const& locality,
                                                                      LogSystemConfig const& lsConf) {
	ASSERT(lsConf.logSystemType == LogSystemType::tagPartitioned ||
	       (lsConf.logSystemType == LogSystemType::empty && !lsConf.tLogs.size()));
	// ASSERT(lsConf.epoch == epoch);  //< FIXME
	const LogEpoch e = lsConf.oldTLogs.size() > 0 ? lsConf.oldTLogs[0].epoch : 0;
	auto logSystem = makeReference<TagPartitionedLogSystem>(dbgid, locality, e);

	if (lsConf.oldTLogs.size()) {
		for (const TLogSet& tLogSet : lsConf.oldTLogs[0].tLogs) {
			logSystem->tLogs.push_back(makeReference<LogSet>(tLogSet));
		}
		logSystem->logRouterTags = lsConf.oldTLogs[0].logRouterTags;
		logSystem->txsTags = lsConf.oldTLogs[0].txsTags;
		// logSystem->epochEnd = lsConf.oldTLogs[0].epochEnd;

		for (int i = 1; i < lsConf.oldTLogs.size(); i++) {
			logSystem->oldLogData.emplace_back(lsConf.oldTLogs[i]);
		}
	}
	logSystem->logSystemType = lsConf.logSystemType;
	logSystem->stopped = true;
	logSystem->pseudoLocalities = lsConf.pseudoLocalities;

	return logSystem;
}

void TagPartitionedLogSystem::purgeOldRecoveredGenerationsCoreState(DBCoreState& newState) {
	Version oldestGenerationRecoverAtVersion = std::min(recoveredVersion->get(), remoteRecoveredVersion->get());
	TraceEvent("ToCoreStateOldestGenerationRecoverAtVersion")
	    .detail("RecoveredVersion", recoveredVersion->get())
	    .detail("RemoteRecoveredVersion", remoteRecoveredVersion->get())
	    .detail("OldestBackupEpoch", oldestBackupEpoch);
	for (int i = 0; i < newState.oldTLogData.size(); ++i) {
		const auto& oldData = newState.oldTLogData[i];
		// Remove earlier generation that TLog data are
		//  - consumed by all storage servers
		//  - no longer used by backup workers
		if (oldData.recoverAt < oldestGenerationRecoverAtVersion && oldData.epoch < oldestBackupEpoch) {
			if (g_network->isSimulated()) {
				ASSERT(oldLogData.size() == newState.oldTLogData.size());
				for (int j = 0; j < oldLogData.size(); ++j) {
					TraceEvent("AllOldGenerations")
					    .detail("Index", j)
					    .detail("Purge", i + 1)
					    .detail("Begin", oldLogData[j].epochBegin)
					    .detail("RecoverAt", oldLogData[j].recoverAt);
				}
				for (int j = i + 1; j < newState.oldTLogData.size(); ++j) {
					ASSERT(newState.oldTLogData[j].recoverAt < oldestGenerationRecoverAtVersion);
					ASSERT(oldLogData[i].tLogs[0]->backupWorkers.size() == 0 ||
					       newState.oldTLogData[j].epoch < oldestBackupEpoch);
				}
			}
			for (int j = i; j < newState.oldTLogData.size(); ++j) {
				TraceEvent("PurgeOldTLogGenerationCoreState", dbgid)
				    .detail("Begin", newState.oldTLogData[j].epochBegin)
				    .detail("End", newState.oldTLogData[j].epochEnd)
				    .detail("Epoch", newState.oldTLogData[j].epoch)
				    .detail("RecoverAt", newState.oldTLogData[j].recoverAt)
				    .detail("Index", j);
			}
			newState.oldTLogData.resize(i);
			break;
		}
	}
}

void TagPartitionedLogSystem::purgeOldRecoveredGenerationsInMemory(const DBCoreState& newState) {
	auto generations = newState.oldTLogData.size();
	if (generations < oldLogData.size()) {
		TraceEvent("PurgeOldTLogGenerationsInMemory", dbgid)
		    .detail("OldGenerations", oldLogData.size())
		    .detail("NewGenerations", generations);
		oldLogData.resize(generations);
	}
}

void TagPartitionedLogSystem::toCoreState(DBCoreState& newState) const {
	if (recoveryComplete.isValid() && recoveryComplete.isError())
		throw recoveryComplete.getError();

	if (remoteRecoveryComplete.isValid() && remoteRecoveryComplete.isError())
		throw remoteRecoveryComplete.getError();

	newState.tLogs.clear();
	newState.logRouterTags = logRouterTags;
	newState.txsTags = txsTags;
	newState.pseudoLocalities = pseudoLocalities;
	for (const auto& t : tLogs) {
		if (t->logServers.size()) {
			newState.tLogs.emplace_back(*t);
			newState.tLogs.back().tLogLocalities.clear();
			for (const auto& log : t->logServers) {
				newState.tLogs.back().tLogLocalities.push_back(log->get().interf().filteredLocality);
			}
		}
	}

	newState.oldTLogData.clear();
	if (!recoveryComplete.isValid() || !recoveryComplete.isReady() ||
	    (repopulateRegionAntiQuorum == 0 && (!remoteRecoveryComplete.isValid() || !remoteRecoveryComplete.isReady())) ||
	    epoch != oldestBackupEpoch) {
		for (const auto& oldData : oldLogData) {
			newState.oldTLogData.emplace_back(oldData);
			TraceEvent("BWToCore")
			    .detail("Epoch", newState.oldTLogData.back().epoch)
			    .detail("TotalTags", newState.oldTLogData.back().logRouterTags)
			    .detail("BeginVersion", newState.oldTLogData.back().epochBegin)
			    .detail("EndVersion", newState.oldTLogData.back().epochEnd);
		}
	}

	newState.logSystemType = logSystemType;
}

bool TagPartitionedLogSystem::remoteStorageRecovered() const {
	return remoteRecoveryComplete.isValid() && remoteRecoveryComplete.isReady();
}

Future<Void> TagPartitionedLogSystem::onCoreStateChanged() const {
	std::vector<Future<Void>> changes;
	changes.push_back(Never());
	if (recoveryComplete.isValid() && !recoveryComplete.isReady()) {
		changes.push_back(recoveryComplete);
	}
	if (remoteRecovery.isValid() && !remoteRecovery.isReady()) {
		changes.push_back(remoteRecovery);
	}
	if (remoteRecoveryComplete.isValid() && !remoteRecoveryComplete.isReady()) {
		changes.push_back(remoteRecoveryComplete);
	}
	changes.push_back(backupWorkerChanged.onTrigger()); // changes to oldestBackupEpoch
	changes.push_back(recoveredVersion->onChange());
	changes.push_back(remoteRecoveredVersion->onChange());
	return waitForAny(changes);
}

void TagPartitionedLogSystem::coreStateWritten(DBCoreState const& newState) {
	if (!newState.oldTLogData.size()) {
		recoveryCompleteWrittenToCoreState.set(true);
	}
	for (auto& t : newState.tLogs) {
		if (!t.isLocal) {
			TraceEvent("RemoteLogsWritten", dbgid).log();
			remoteLogsWrittenToCoreState = true;
			break;
		}
	}
}

Future<Void> TagPartitionedLogSystem::onError() const {
	return onError_internal(this);
}

															#line 741 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via onError_internal()
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_OnError_internalActor>
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_OnError_internalActorState {
															#line 747 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_OnError_internalActorState(TagPartitionedLogSystem const* const& self) 
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : self(self)
															#line 754 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("onError_internal", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_OnError_internalActorState() 
	{
		fdb_probe_actor_destroy("onError_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 470 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 769 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_OnError_internalActorState();
		static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 471 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Future<Void>> failed;
															#line 472 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Future<Void>> backupFailed(1, Never());
															#line 473 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Future<Void>> changes;
															#line 475 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( auto& it : self->tLogs ) {
															#line 476 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& t : it->logServers ) {
															#line 477 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (t->get().present())
															#line 809 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 478 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					failed.push_back( waitFailureClient(t->get().interf().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 813 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
				else
				{
															#line 484 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					changes.push_back(t->onChange());
															#line 819 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 487 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& t : it->logRouters ) {
															#line 488 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (t->get().present())
															#line 826 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 489 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					failed.push_back( waitFailureClient(t->get().interf().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 830 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
				else
				{
															#line 495 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					changes.push_back(t->onChange());
															#line 836 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 498 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( const auto& worker : it->backupWorkers ) {
															#line 499 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (worker->get().present())
															#line 843 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 500 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					backupFailed.push_back( waitFailureClient(worker->get().interf().waitFailure, SERVER_KNOBS->BACKUP_TIMEOUT, -SERVER_KNOBS->BACKUP_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 847 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
				else
				{
															#line 506 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					changes.push_back(worker->onChange());
															#line 853 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 511 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!self->recoveryCompleteWrittenToCoreState.get())
															#line 859 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 512 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& old : self->oldLogData ) {
															#line 513 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& it : old.tLogs ) {
															#line 514 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for( auto& t : it->logRouters ) {
															#line 515 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						if (t->get().present())
															#line 869 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						{
															#line 516 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							failed.push_back(waitFailureClient(t->get().interf().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 873 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
						else
						{
															#line 522 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							changes.push_back(t->onChange());
															#line 879 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
					}
				}
															#line 527 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( const auto& worker : old.tLogs[0]->backupWorkers ) {
															#line 528 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (worker->get().present())
															#line 887 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 529 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						backupFailed.push_back(waitFailureClient(worker->get().interf().waitFailure, SERVER_KNOBS->BACKUP_TIMEOUT, -SERVER_KNOBS->BACKUP_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 891 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
					else
					{
															#line 535 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						changes.push_back(worker->onChange());
															#line 897 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
				}
			}
		}
															#line 541 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (self->hasRemoteServers && (!self->remoteRecovery.isReady() || self->remoteRecovery.isError()))
															#line 904 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 542 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			changes.push_back(self->remoteRecovery);
															#line 908 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 545 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		changes.push_back(self->recoveryCompleteWrittenToCoreState.onChange());
															#line 546 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		changes.push_back(self->backupWorkerChanged.onTrigger());
															#line 548 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		ASSERT(failed.size() >= 1);
															#line 549 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_0 = quorum(changes, 1) || tagError<Void>(quorum(failed, 1), tlog_failed()) || tagError<Void>(quorum(backupFailed, 1), backup_worker_failed());
															#line 549 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 920 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->actor_wait_state = 1;
															#line 549 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_OnError_internalActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)));
															#line 925 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->ActorCallback< TagPartitionedLogSystem_OnError_internalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_OnError_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onError_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onError_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_OnError_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onError_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onError_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_OnError_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onError_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onError_internal", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem const* self;
															#line 1019 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via onError_internal()
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_OnError_internalActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_OnError_internalActor, 0, Void >, public FastAllocated<TagPartitionedLogSystem_OnError_internalActor>, public TagPartitionedLogSystem_OnError_internalActorState<TagPartitionedLogSystem_OnError_internalActor> {
															#line 1024 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_OnError_internalActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_OnError_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6877407722212094464UL, 11805451314132675584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_OnError_internalActor, 0, Void >;
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_OnError_internalActor(TagPartitionedLogSystem const* const& self) 
															#line 1041 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_OnError_internalActorState<TagPartitionedLogSystem_OnError_internalActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onError_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9294315859586498816UL, 9113220301683633920UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_OnError_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onError_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onError_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_OnError_internalActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::onError_internal( TagPartitionedLogSystem const* const& self ) {
															#line 468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_OnError_internalActor(self));
															#line 1073 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 553 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 1078 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via pushResetChecker()
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_PushResetCheckerActor>
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_PushResetCheckerActorState {
															#line 1084 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_PushResetCheckerActorState(Reference<ConnectionResetInfo> const& self,NetworkAddress const& addr) 
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : self(self),
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   addr(addr)
															#line 1093 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("pushResetChecker", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_PushResetCheckerActorState() 
	{
		fdb_probe_actor_destroy("pushResetChecker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 555 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->slowReplies = 0;
															#line 556 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->fastReplies = 0;
															#line 557 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->PUSH_STATS_INTERVAL);
															#line 557 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->actor_wait_state = 1;
															#line 557 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_PushResetCheckerActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)));
															#line 1119 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_PushResetCheckerActorState();
		static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("SlowPushStats") .detail("PeerAddress", addr) .detail("SlowReplies", self->slowReplies) .detail("FastReplies", self->fastReplies);
															#line 562 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (self->slowReplies >= SERVER_KNOBS->PUSH_STATS_SLOW_AMOUNT && self->slowReplies / double(self->slowReplies + self->fastReplies) >= SERVER_KNOBS->PUSH_STATS_SLOW_RATIO)
															#line 1144 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 564 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			FlowTransport::transport().resetConnection(addr);
															#line 565 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->lastReset = now();
															#line 1150 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 567 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_PushResetCheckerActorState(); static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->destroy(); return 0; }
															#line 1154 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagPartitionedLogSystem_PushResetCheckerActorState();
		static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("SlowPushStats") .detail("PeerAddress", addr) .detail("SlowReplies", self->slowReplies) .detail("FastReplies", self->fastReplies);
															#line 562 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (self->slowReplies >= SERVER_KNOBS->PUSH_STATS_SLOW_AMOUNT && self->slowReplies / double(self->slowReplies + self->fastReplies) >= SERVER_KNOBS->PUSH_STATS_SLOW_RATIO)
															#line 1168 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 564 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			FlowTransport::transport().resetConnection(addr);
															#line 565 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->lastReset = now();
															#line 1174 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 567 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_PushResetCheckerActorState(); static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->destroy(); return 0; }
															#line 1178 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagPartitionedLogSystem_PushResetCheckerActorState();
		static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->ActorCallback< TagPartitionedLogSystem_PushResetCheckerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_PushResetCheckerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pushResetChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushResetChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_PushResetCheckerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pushResetChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushResetChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_PushResetCheckerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pushResetChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushResetChecker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<ConnectionResetInfo> self;
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	NetworkAddress addr;
															#line 1265 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via pushResetChecker()
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_PushResetCheckerActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_PushResetCheckerActor, 0, Void >, public FastAllocated<TagPartitionedLogSystem_PushResetCheckerActor>, public TagPartitionedLogSystem_PushResetCheckerActorState<TagPartitionedLogSystem_PushResetCheckerActor> {
															#line 1270 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_PushResetCheckerActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_PushResetCheckerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9899042723585394944UL, 15508860758494584064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_PushResetCheckerActor, 0, Void >;
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_PushResetCheckerActor(Reference<ConnectionResetInfo> const& self,NetworkAddress const& addr) 
															#line 1287 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_PushResetCheckerActorState<TagPartitionedLogSystem_PushResetCheckerActor>(self, addr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pushResetChecker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7316871427959440384UL, 10241316741375789824UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PushResetCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pushResetChecker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pushResetChecker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_PushResetCheckerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::pushResetChecker( Reference<ConnectionResetInfo> const& self, NetworkAddress const& addr ) {
															#line 554 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_PushResetCheckerActor(self, addr));
															#line 1319 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 569 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 1324 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via recordPushMetrics()
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_RecordPushMetricsActor>
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_RecordPushMetricsActorState {
															#line 1330 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_RecordPushMetricsActorState(Reference<ConnectionResetInfo> const& self,Reference<Histogram> const& dist,NetworkAddress const& addr,Future<TLogCommitReply> const& in) 
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : self(self),
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   dist(dist),
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   addr(addr),
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   in(in),
															#line 574 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   startTime(now())
															#line 1345 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("recordPushMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_RecordPushMetricsActorState() 
	{
		fdb_probe_actor_destroy("recordPushMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 575 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<TLogCommitReply> __when_expr_0 = in;
															#line 575 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1362 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->actor_wait_state = 1;
															#line 575 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_RecordPushMetricsActor, 0, TLogCommitReply >*>(static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)));
															#line 1367 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_RecordPushMetricsActorState();
		static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(TLogCommitReply const& t,int loopDepth) 
	{
															#line 576 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (now() - self->lastReset > SERVER_KNOBS->PUSH_RESET_INTERVAL)
															#line 1390 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 577 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (now() - startTime > SERVER_KNOBS->PUSH_MAX_LATENCY)
															#line 1394 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 578 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (self->resetCheck.isReady())
															#line 1398 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 579 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					self->resetCheck = TagPartitionedLogSystem::pushResetChecker(self, addr);
															#line 1402 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 581 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				self->slowReplies++;
															#line 1406 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
			else
			{
															#line 583 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				self->fastReplies++;
															#line 1412 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 586 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		dist->sampleSeconds(now() - startTime);
															#line 587 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->SAV<TLogCommitReply>::futures) { (void)(t); this->~TagPartitionedLogSystem_RecordPushMetricsActorState(); static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->destroy(); return 0; }
															#line 1419 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->SAV< TLogCommitReply >::value()) TLogCommitReply(t);
		this->~TagPartitionedLogSystem_RecordPushMetricsActorState();
		static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(TLogCommitReply && t,int loopDepth) 
	{
															#line 576 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (now() - self->lastReset > SERVER_KNOBS->PUSH_RESET_INTERVAL)
															#line 1431 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 577 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (now() - startTime > SERVER_KNOBS->PUSH_MAX_LATENCY)
															#line 1435 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 578 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (self->resetCheck.isReady())
															#line 1439 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 579 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					self->resetCheck = TagPartitionedLogSystem::pushResetChecker(self, addr);
															#line 1443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 581 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				self->slowReplies++;
															#line 1447 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
			else
			{
															#line 583 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				self->fastReplies++;
															#line 1453 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 586 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		dist->sampleSeconds(now() - startTime);
															#line 587 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->SAV<TLogCommitReply>::futures) { (void)(t); this->~TagPartitionedLogSystem_RecordPushMetricsActorState(); static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->destroy(); return 0; }
															#line 1460 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->SAV< TLogCommitReply >::value()) TLogCommitReply(t);
		this->~TagPartitionedLogSystem_RecordPushMetricsActorState();
		static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TLogCommitReply const& t,int loopDepth) 
	{
		loopDepth = a_body1cont1(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TLogCommitReply && t,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->ActorCallback< TagPartitionedLogSystem_RecordPushMetricsActor, 0, TLogCommitReply >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_RecordPushMetricsActor, 0, TLogCommitReply >*,TLogCommitReply const& value) 
	{
		fdb_probe_actor_enter("recordPushMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordPushMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_RecordPushMetricsActor, 0, TLogCommitReply >*,TLogCommitReply && value) 
	{
		fdb_probe_actor_enter("recordPushMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordPushMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_RecordPushMetricsActor, 0, TLogCommitReply >*,Error err) 
	{
		fdb_probe_actor_enter("recordPushMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordPushMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<ConnectionResetInfo> self;
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<Histogram> dist;
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	NetworkAddress addr;
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<TLogCommitReply> in;
															#line 574 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	double startTime;
															#line 1553 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via recordPushMetrics()
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_RecordPushMetricsActor final : public Actor<TLogCommitReply>, public ActorCallback< TagPartitionedLogSystem_RecordPushMetricsActor, 0, TLogCommitReply >, public FastAllocated<TagPartitionedLogSystem_RecordPushMetricsActor>, public TagPartitionedLogSystem_RecordPushMetricsActorState<TagPartitionedLogSystem_RecordPushMetricsActor> {
															#line 1558 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_RecordPushMetricsActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_RecordPushMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6299407744978870784UL, 13343927282008142080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TLogCommitReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_RecordPushMetricsActor, 0, TLogCommitReply >;
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_RecordPushMetricsActor(Reference<ConnectionResetInfo> const& self,Reference<Histogram> const& dist,NetworkAddress const& addr,Future<TLogCommitReply> const& in) 
															#line 1575 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<TLogCommitReply>(),
		   TagPartitionedLogSystem_RecordPushMetricsActorState<TagPartitionedLogSystem_RecordPushMetricsActor>(self, dist, addr, in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recordPushMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6077784369710922752UL, 17263650992350452224UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecordPushMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recordPushMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recordPushMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_RecordPushMetricsActor, 0, TLogCommitReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<TLogCommitReply> TagPartitionedLogSystem::recordPushMetrics( Reference<ConnectionResetInfo> const& self, Reference<Histogram> const& dist, NetworkAddress const& addr, Future<TLogCommitReply> const& in ) {
															#line 570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<TLogCommitReply>(new TagPartitionedLogSystem_RecordPushMetricsActor(self, dist, addr, in));
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 589 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

Future<Version> TagPartitionedLogSystem::push(const ILogSystem::PushVersionSet& versionSet,
                                              LogPushData& data,
                                              SpanContext const& spanContext,
                                              Optional<UID> debugID,
                                              Optional<std::unordered_map<uint16_t, Version>> tpcvMap) {
	// FIXME: Randomize request order as in LegacyLogSystem?
	Version prevVersion = versionSet.prevVersion; // this might be updated when version vector unicast is enabled
	Version seqPrevVersion = versionSet.prevVersion; // a copy of the prevVersion provided by the sequencer

	std::unordered_map<uint8_t, uint16_t> tLogCount;
	std::unordered_map<uint8_t, std::vector<uint16_t>> tLogLocIds;
	if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST) {
		uint16_t location = 0;
		uint8_t logGroupLocal = 0;
		const auto& tpcvMapRef = tpcvMap.get();
		for (const auto& it : tLogs) {
			if (!it->isLocal) {
				continue;
			}
			for (size_t loc = 0; loc < it->logServers.size(); loc++) {
				if (tpcvMapRef.contains(location)) {
					tLogCount[logGroupLocal]++;
					tLogLocIds[logGroupLocal].push_back(location);
				}
				location++;
			}
			logGroupLocal++;
		}
	}

	uint16_t location = 0;
	uint8_t logGroupLocal = 0;
	std::vector<Future<Void>> quorumResults;
	std::vector<std::pair<UID, Future<TLogCommitReply>>> allReplies;
	const Span span("TPLS:push"_loc, spanContext);
	for (auto& it : tLogs) {
		if (!it->isLocal) {
			// Remote TLogs should read from LogRouter
			continue;
		}
		if (it->logServers.size() == 0) {
			// Empty TLog set
			continue;
		}

		if (it->connectionResetTrackers.size() == 0) {
			for (int i = 0; i < it->logServers.size(); i++) {
				it->connectionResetTrackers.push_back(makeReference<ConnectionResetInfo>());
			}
		}
		if (it->tlogPushDistTrackers.empty()) {
			for (int i = 0; i < it->logServers.size(); i++) {
				it->tlogPushDistTrackers.push_back(
				    Histogram::getHistogram("ToTlog_" + it->logServers[i]->get().interf().uniqueID.toString(),
				                            it->logServers[i]->get().interf().address().toString(),
				                            Histogram::Unit::milliseconds));
			}
		}

		std::vector<Future<Void>> tLogCommitResults;
		for (size_t loc = 0; loc < it->logServers.size(); loc++) {
			Standalone<StringRef> msg = data.getMessages(location);
			data.recordEmptyMessage(location, msg);
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST) {
				if (tpcvMap.get().contains(location)) {
					prevVersion = tpcvMap.get()[location];
				} else {
					ASSERT(!msg.size());
					location++;
					continue;
				}
			}

			const auto& interface = it->logServers[loc]->get().interf();
			const auto request = TLogCommitRequest(spanContext,
			                                       msg.arena(),
			                                       prevVersion,
			                                       versionSet.version,
			                                       versionSet.knownCommittedVersion,
			                                       versionSet.minKnownCommittedVersion,
			                                       seqPrevVersion,
			                                       msg,
			                                       tLogCount[logGroupLocal],
			                                       tLogLocIds[logGroupLocal],
			                                       debugID);
			auto tLogReply = recordPushMetrics(it->connectionResetTrackers[loc],
			                                   it->tlogPushDistTrackers[loc],
			                                   interface.address(),
			                                   interface.commit.getReply(request, TaskPriority::ProxyTLogCommitReply));

			allReplies.emplace_back(interface.id(), tLogReply);
			Future<Void> commitSuccess = success(tLogReply);
			addActor.get().send(commitSuccess);
			tLogCommitResults.push_back(commitSuccess);
			location++;
		}
		quorumResults.push_back(quorum(tLogCommitResults, tLogCommitResults.size() - it->tLogWriteAntiQuorum));
		logGroupLocal++;
	}

	return minVersionWhenReady(waitForAll(quorumResults), allReplies);
}

// Version vector/unicast specific: If the best server is not known to have been locked/stopped
// then is not guaranteed to have received all versions that are relevant to a tag(s) that it is
// buddy of, hence do not treat such a server as the best server. Note that this reset logic gets
// invoked only in the context of peeks that get done during recovery, and the best server should
// always be available for peeking after recovery is done.
void TagPartitionedLogSystem::resetBestServerIfNotLocked(
    int bestSet,
    int& bestServer,
    Optional<Version> end,
    const Optional<std::map<uint8_t, std::vector<uint16_t>>>& knownLockedTLogIds) {
	ASSERT(SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST);
	if (bestSet >= 0 && bestServer >= 0 && end.present() && end.get() != std::numeric_limits<Version>::max()) {
		ASSERT_WE_THINK(knownLockedTLogIds.present() && !knownLockedTLogIds.get().empty());
		ASSERT_WE_THINK(knownLockedTLogIds.get().contains(bestSet));
		if (std::find(knownLockedTLogIds.get().at(bestSet).begin(),
		              knownLockedTLogIds.get().at(bestSet).end(),
		              bestServer) == knownLockedTLogIds.get().at(bestSet).end()) {
			bestServer = -1;
			return;
		}
	}
}

Reference<ILogSystem::IPeekCursor> TagPartitionedLogSystem::peekAll(UID dbgid,
                                                                    Version begin,
                                                                    Version end,
                                                                    Tag tag,
                                                                    bool parallelGetMore) {
	int bestSet = 0;
	std::vector<Reference<LogSet>> localSets;
	Version lastBegin = 0;
	bool foundSpecial = false;
	int logIdx = 0;
	int bestSetIdx = 0;
	for (auto& log : tLogs) {
		if (log->locality == tagLocalitySpecial) {
			foundSpecial = true;
		}
		if (log->isLocal && log->logServers.size() &&
		    (log->locality == tagLocalitySpecial || log->locality == tag.locality || tag.locality == tagLocalityTxs ||
		     tag.locality == tagLocalityLogRouter)) {
			lastBegin = std::max(lastBegin, log->startVersion);
			localSets.push_back(log);
			if (log->locality != tagLocalitySatellite) {
				bestSet = localSets.size() - 1;
				bestSetIdx = logIdx;
			}
		}
		logIdx++;
	}

	if (!localSets.size()) {
		lastBegin = end;
	}

	if (begin >= lastBegin && localSets.size()) {
		TraceEvent("TLogPeekAllCurrentOnly", dbgid)
		    .detail("Tag", tag.toString())
		    .detail("Begin", begin)
		    .detail("End", end)
		    .detail("BestLogs", localSets[bestSet]->logServerString());
		int bestServer = localSets[bestSet]->bestLocationFor(tag);
		Optional<std::vector<uint16_t>> bestKnownLockedTLogIds;
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST) {
			resetBestServerIfNotLocked(bestSetIdx, bestServer, end, knownLockedTLogIds);
			ASSERT_WE_THINK(knownLockedTLogIds.contains(bestSetIdx));
			bestKnownLockedTLogIds = knownLockedTLogIds[bestSetIdx];
		}
		return makeReference<ILogSystem::SetPeekCursor>(
		    localSets, bestSet, bestServer, tag, begin, end, parallelGetMore, bestKnownLockedTLogIds);
	} else {
		std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
		std::vector<LogMessageVersion> epochEnds;

		if (lastBegin < end && localSets.size()) {
			TraceEvent("TLogPeekAllAddingCurrent", dbgid)
			    .detail("Tag", tag.toString())
			    .detail("Begin", begin)
			    .detail("End", end)
			    .detail("BestLogs", localSets[bestSet]->logServerString());
			int bestServer = localSets[bestSet]->bestLocationFor(tag);
			Optional<std::vector<uint16_t>> bestKnownLockedTLogIds;
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST) {
				resetBestServerIfNotLocked(bestSetIdx, bestServer, end, knownLockedTLogIds);
				ASSERT_WE_THINK(knownLockedTLogIds.contains(bestSetIdx));
				bestKnownLockedTLogIds = knownLockedTLogIds[bestSetIdx];
			}
			cursors.push_back(makeReference<ILogSystem::SetPeekCursor>(
			    localSets, bestSet, bestServer, tag, lastBegin, end, parallelGetMore, bestKnownLockedTLogIds));
		}
		for (int i = 0; begin < lastBegin; i++) {
			if (i == oldLogData.size()) {
				if (tag.locality == tagLocalityTxs) {
					break;
				}
				TraceEvent("TLogPeekAllDead", dbgid)
				    .detail("Tag", tag.toString())
				    .detail("Begin", begin)
				    .detail("End", end)
				    .detail("LastBegin", lastBegin)
				    .detail("OldLogDataSize", oldLogData.size());
				return makeReference<ILogSystem::ServerPeekCursor>(
				    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(), tag, begin, getPeekEnd(), false, false);
			}

			int bestOldSet = 0;
			std::vector<Reference<LogSet>> localOldSets;
			Version thisBegin = begin;
			bool thisSpecial = false;
			for (auto& log : oldLogData[i].tLogs) {
				if (log->locality == tagLocalitySpecial) {
					thisSpecial = true;
				}
				if (log->isLocal && log->logServers.size() &&
				    (log->locality == tagLocalitySpecial || log->locality == tag.locality ||
				     tag.locality == tagLocalityTxs || tag.locality == tagLocalityLogRouter)) {
					thisBegin = std::max(thisBegin, log->startVersion);
					localOldSets.push_back(log);
					if (log->locality != tagLocalitySatellite) {
						bestOldSet = localOldSets.size() - 1;
					}
				}
			}

			if (!localOldSets.size()) {
				TraceEvent("TLogPeekAllNoLocalSets", dbgid)
				    .detail("Tag", tag.toString())
				    .detail("Begin", begin)
				    .detail("End", end)
				    .detail("LastBegin", lastBegin);
				if (!cursors.size() && !foundSpecial) {
					continue;
				}
				return makeReference<ILogSystem::ServerPeekCursor>(
				    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(), tag, begin, getPeekEnd(), false, false);
			}
			if (thisSpecial) {
				foundSpecial = true;
			}

			if (thisBegin < lastBegin) {
				if (thisBegin < end) {
					TraceEvent("TLogPeekAllAddingOld", dbgid)
					    .detail("Tag", tag.toString())
					    .detail("Begin", begin)
					    .detail("End", end)
					    .detail("BestLogs", localOldSets[bestOldSet]->logServerString())
					    .detail("LastBegin", lastBegin)
					    .detail("ThisBegin", thisBegin);
					cursors.push_back(
					    makeReference<ILogSystem::SetPeekCursor>(localOldSets,
					                                             bestOldSet,
					                                             localOldSets[bestOldSet]->bestLocationFor(tag),
					                                             tag,
					                                             thisBegin,
					                                             std::min(lastBegin, end),
					                                             parallelGetMore));
					epochEnds.push_back(LogMessageVersion(std::min(lastBegin, end)));
				}
				lastBegin = thisBegin;
			}
		}

		return makeReference<ILogSystem::MultiCursor>(cursors, epochEnds);
	}
}

Reference<ILogSystem::IPeekCursor> TagPartitionedLogSystem::peekRemote(UID dbgid,
                                                                       Version begin,
                                                                       Optional<Version> end,
                                                                       Tag tag,
                                                                       bool parallelGetMore) {
	int bestSet = -1;
	Version lastBegin = recoveredAt.present() ? recoveredAt.get() + 1 : 0;
	for (int t = 0; t < tLogs.size(); t++) {
		if (tLogs[t]->isLocal) {
			lastBegin = std::max(lastBegin, tLogs[t]->startVersion);
		}

		if (tLogs[t]->logRouters.size()) {
			ASSERT(bestSet == -1);
			bestSet = t;
		}
	}
	if (bestSet == -1) {
		TraceEvent("TLogPeekRemoteNoBestSet", dbgid)
		    .detail("Tag", tag.toString())
		    .detail("Begin", begin)
		    .detail("End", end.present() ? end.get() : getPeekEnd());
		return makeReference<ILogSystem::ServerPeekCursor>(
		    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(), tag, begin, getPeekEnd(), false, parallelGetMore);
	}
	if (begin >= lastBegin) {
		TraceEvent("TLogPeekRemoteBestOnly", dbgid)
		    .detail("Tag", tag.toString())
		    .detail("Begin", begin)
		    .detail("End", end.present() ? end.get() : getPeekEnd())
		    .detail("BestSet", bestSet)
		    .detail("BestSetStart", lastBegin)
		    .detail("LogRouterIds", tLogs[bestSet]->logRouterString());
		return makeReference<ILogSystem::BufferedCursor>(
		    tLogs[bestSet]->logRouters, tag, begin, end.present() ? end.get() + 1 : getPeekEnd(), parallelGetMore);
	} else {
		std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
		std::vector<LogMessageVersion> epochEnds;
		TraceEvent("TLogPeekRemoteAddingBest", dbgid)
		    .detail("Tag", tag.toString())
		    .detail("Begin", begin)
		    .detail("End", end.present() ? end.get() : getPeekEnd())
		    .detail("BestSet", bestSet)
		    .detail("BestSetStart", lastBegin)
		    .detail("LogRouterIds", tLogs[bestSet]->logRouterString());
		cursors.push_back(makeReference<ILogSystem::BufferedCursor>(
		    tLogs[bestSet]->logRouters, tag, lastBegin, end.present() ? end.get() + 1 : getPeekEnd(), parallelGetMore));
		int i = 0;
		while (begin < lastBegin) {
			if (i == oldLogData.size()) {
				TraceEvent("TLogPeekRemoteDead", dbgid)
				    .detail("Tag", tag.toString())
				    .detail("Begin", begin)
				    .detail("End", end.present() ? end.get() : getPeekEnd())
				    .detail("LastBegin", lastBegin)
				    .detail("OldLogDataSize", oldLogData.size());
				return makeReference<ILogSystem::ServerPeekCursor>(
				    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(),
				    tag,
				    begin,
				    getPeekEnd(),
				    false,
				    parallelGetMore);
			}

			int bestOldSet = -1;
			Version thisBegin = begin;
			for (int t = 0; t < oldLogData[i].tLogs.size(); t++) {
				if (oldLogData[i].tLogs[t]->isLocal) {
					thisBegin = std::max(thisBegin, oldLogData[i].tLogs[t]->startVersion);
				}

				if (oldLogData[i].tLogs[t]->logRouters.size()) {
					ASSERT(bestOldSet == -1);
					bestOldSet = t;
				}
			}
			if (bestOldSet == -1) {
				TraceEvent("TLogPeekRemoteNoOldBestSet", dbgid)
				    .detail("Tag", tag.toString())
				    .detail("Begin", begin)
				    .detail("End", end.present() ? end.get() : getPeekEnd());
				return makeReference<ILogSystem::ServerPeekCursor>(
				    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(),
				    tag,
				    begin,
				    getPeekEnd(),
				    false,
				    parallelGetMore);
			}

			if (thisBegin < lastBegin) {
				TraceEvent("TLogPeekRemoteAddingOldBest", dbgid)
				    .detail("Tag", tag.toString())
				    .detail("Begin", begin)
				    .detail("End", end.present() ? end.get() : getPeekEnd())
				    .detail("BestOldSet", bestOldSet)
				    .detail("LogRouterIds", oldLogData[i].tLogs[bestOldSet]->logRouterString())
				    .detail("LastBegin", lastBegin)
				    .detail("ThisBegin", thisBegin)
				    .detail("BestStartVer", oldLogData[i].tLogs[bestOldSet]->startVersion);
				cursors.push_back(makeReference<ILogSystem::BufferedCursor>(
				    oldLogData[i].tLogs[bestOldSet]->logRouters, tag, thisBegin, lastBegin, parallelGetMore));
				epochEnds.emplace_back(lastBegin);
				lastBegin = thisBegin;
			}
			i++;
		}

		return makeReference<ILogSystem::MultiCursor>(cursors, epochEnds);
	}
}

Reference<ILogSystem::IPeekCursor> TagPartitionedLogSystem::peek(UID dbgid,
                                                                 Version begin,
                                                                 Optional<Version> end,
                                                                 Tag tag,
                                                                 bool parallelGetMore) {
	if (!tLogs.size()) {
		TraceEvent("TLogPeekNoLogSets", dbgid).detail("Tag", tag.toString()).detail("Begin", begin);
		return makeReference<ILogSystem::ServerPeekCursor>(
		    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(), tag, begin, getPeekEnd(), false, false);
	}

	if (tag.locality == tagLocalityRemoteLog) {
		return peekRemote(dbgid, begin, end, tag, parallelGetMore);
	} else {
		return peekAll(dbgid, begin, end.present() ? end.get() + 1 : getPeekEnd(), tag, parallelGetMore);
	}
}

Reference<ILogSystem::IPeekCursor> TagPartitionedLogSystem::peek(UID dbgid,
                                                                 Version begin,
                                                                 Optional<Version> end,
                                                                 std::vector<Tag> tags,
                                                                 bool parallelGetMore) {
	if (tags.empty()) {
		TraceEvent("TLogPeekNoTags", dbgid).detail("Begin", begin);
		return makeReference<ILogSystem::ServerPeekCursor>(
		    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(), invalidTag, begin, getPeekEnd(), false, false);
	}

	if (tags.size() == 1) {
		return peek(dbgid, begin, end, tags[0], parallelGetMore);
	}

	std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
	cursors.reserve(tags.size());
	for (auto tag : tags) {
		cursors.push_back(peek(dbgid, begin, end, tag, parallelGetMore));
	}
	return makeReference<ILogSystem::BufferedCursor>(
	    cursors, begin, end.present() ? end.get() + 1 : getPeekEnd(), true, false);
}

Reference<ILogSystem::IPeekCursor> TagPartitionedLogSystem::peekLocal(UID dbgid,
                                                                      Tag tag,
                                                                      Version begin,
                                                                      Version end,
                                                                      bool useMergePeekCursors,
                                                                      int8_t peekLocality) {
	if (tag.locality >= 0 || tag.locality == tagLocalitySpecial) {
		peekLocality = tag.locality;
	}
	ASSERT(peekLocality >= 0 || tag.locality == tagLocalitySpecial);

	int bestSet = -1;
	bool foundSpecial = false;
	int logCount = 0;
	for (int t = 0; t < tLogs.size(); t++) {
		if (tLogs[t]->logServers.size() && tLogs[t]->locality != tagLocalitySatellite) {
			logCount++;
		}
		if (tLogs[t]->logServers.size() && (tLogs[t]->locality == tagLocalitySpecial ||
		                                    tLogs[t]->locality == peekLocality || peekLocality == tagLocalitySpecial)) {
			if (tLogs[t]->locality == tagLocalitySpecial) {
				foundSpecial = true;
			}
			bestSet = t;
			break;
		}
	}
	if (bestSet == -1) {
		TraceEvent("TLogPeekLocalNoBestSet", dbgid)
		    .detail("Tag", tag.toString())
		    .detail("Begin", begin)
		    .detail("End", end)
		    .detail("LogCount", logCount);
		if (useMergePeekCursors || logCount > 1) {
			throw worker_removed();
		} else {
			return makeReference<ILogSystem::ServerPeekCursor>(
			    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(), tag, begin, getPeekEnd(), false, false);
		}
	}

	if (begin >= tLogs[bestSet]->startVersion) {
		TraceEvent("TLogPeekLocalBestOnly", dbgid)
		    .detail("Tag", tag.toString())
		    .detail("Begin", begin)
		    .detail("End", end)
		    .detail("BestSet", bestSet)
		    .detail("BestSetStart", tLogs[bestSet]->startVersion)
		    .detail("LogId", tLogs[bestSet]->logServers[tLogs[bestSet]->bestLocationFor(tag)]->get().id());
		if (useMergePeekCursors) {
			int bestServer = tLogs[bestSet]->bestLocationFor(tag);
			Optional<std::vector<uint16_t>> bestKnownLockedTLogIds;
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST) {
				resetBestServerIfNotLocked(bestSet, bestServer, end, knownLockedTLogIds);
				ASSERT_WE_THINK(knownLockedTLogIds.contains(bestSet));
				bestKnownLockedTLogIds = knownLockedTLogIds[bestSet];
			}
			return makeReference<ILogSystem::MergedPeekCursor>(tLogs[bestSet]->logServers,
			                                                   bestServer,
			                                                   tLogs[bestSet]->logServers.size() + 1 -
			                                                       tLogs[bestSet]->tLogReplicationFactor,
			                                                   tag,
			                                                   begin,
			                                                   end,
			                                                   true,
			                                                   tLogs[bestSet]->tLogLocalities,
			                                                   tLogs[bestSet]->tLogPolicy,
			                                                   tLogs[bestSet]->tLogReplicationFactor,
			                                                   bestKnownLockedTLogIds);
		} else {
			return makeReference<ILogSystem::ServerPeekCursor>(
			    tLogs[bestSet]->logServers[tLogs[bestSet]->bestLocationFor(tag)], tag, begin, end, false, false);
		}
	} else {
		std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
		std::vector<LogMessageVersion> epochEnds;

		if (tLogs[bestSet]->startVersion < end) {
			TraceEvent("TLogPeekLocalAddingBest", dbgid)
			    .detail("Tag", tag.toString())
			    .detail("Begin", begin)
			    .detail("End", end)
			    .detail("BestSet", bestSet)
			    .detail("BestSetStart", tLogs[bestSet]->startVersion)
			    .detail("LogId", tLogs[bestSet]->logServers[tLogs[bestSet]->bestLocationFor(tag)]->get().id());
			if (useMergePeekCursors) {
				int bestServer = tLogs[bestSet]->bestLocationFor(tag);
				Optional<std::vector<uint16_t>> bestKnownLockedTLogIds;
				if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST) {
					resetBestServerIfNotLocked(bestSet, bestServer, end, knownLockedTLogIds);
					ASSERT_WE_THINK(knownLockedTLogIds.contains(bestSet));
					bestKnownLockedTLogIds = knownLockedTLogIds[bestSet];
				}
				cursors.push_back(makeReference<ILogSystem::MergedPeekCursor>(tLogs[bestSet]->logServers,
				                                                              bestServer,
				                                                              tLogs[bestSet]->logServers.size() + 1 -
				                                                                  tLogs[bestSet]->tLogReplicationFactor,
				                                                              tag,
				                                                              tLogs[bestSet]->startVersion,
				                                                              end,
				                                                              true,
				                                                              tLogs[bestSet]->tLogLocalities,
				                                                              tLogs[bestSet]->tLogPolicy,
				                                                              tLogs[bestSet]->tLogReplicationFactor,
				                                                              bestKnownLockedTLogIds));
			} else {
				cursors.push_back(makeReference<ILogSystem::ServerPeekCursor>(
				    tLogs[bestSet]->logServers[tLogs[bestSet]->bestLocationFor(tag)],
				    tag,
				    tLogs[bestSet]->startVersion,
				    end,
				    false,
				    false));
			}
		}
		Version lastBegin = tLogs[bestSet]->startVersion;
		for (int i = 0; begin < lastBegin; i++) {
			if (i == oldLogData.size()) {
				if (tag.locality == tagLocalityTxs && cursors.size()) {
					break;
				}
				TraceEvent("TLogPeekLocalDead", dbgid)
				    .detail("Tag", tag.toString())
				    .detail("Begin", begin)
				    .detail("End", end)
				    .detail("LastBegin", lastBegin)
				    .detail("OldLogDataSize", oldLogData.size());
				throw worker_removed();
			}

			int bestOldSet = -1;
			logCount = 0;
			bool nextFoundSpecial = false;
			for (int t = 0; t < oldLogData[i].tLogs.size(); t++) {
				if (oldLogData[i].tLogs[t]->logServers.size() &&
				    oldLogData[i].tLogs[t]->locality != tagLocalitySatellite) {
					logCount++;
				}
				if (oldLogData[i].tLogs[t]->logServers.size() &&
				    (oldLogData[i].tLogs[t]->locality == tagLocalitySpecial ||
				     oldLogData[i].tLogs[t]->locality == peekLocality || peekLocality == tagLocalitySpecial)) {
					if (oldLogData[i].tLogs[t]->locality == tagLocalitySpecial) {
						nextFoundSpecial = true;
					}
					if (foundSpecial && !oldLogData[i].tLogs[t]->isLocal) {
						TraceEvent("TLogPeekLocalRemoteBeforeSpecial", dbgid)
						    .detail("Tag", tag.toString())
						    .detail("Begin", begin)
						    .detail("End", end)
						    .detail("LastBegin", lastBegin)
						    .detail("OldLogDataSize", oldLogData.size())
						    .detail("Idx", i);
						throw worker_removed();
					}
					bestOldSet = t;
					break;
				}
			}

			if (bestOldSet == -1) {
				TraceEvent("TLogPeekLocalNoBestSet", dbgid)
				    .detail("Tag", tag.toString())
				    .detail("Begin", begin)
				    .detail("End", end)
				    .detail("LastBegin", lastBegin)
				    .detail("OldLogDataSize", oldLogData.size())
				    .detail("Idx", i)
				    .detail("LogRouterTags", oldLogData[i].logRouterTags)
				    .detail("LogCount", logCount)
				    .detail("FoundSpecial", foundSpecial);
				if (oldLogData[i].logRouterTags == 0 || logCount > 1 || foundSpecial) {
					throw worker_removed();
				}
				continue;
			}

			foundSpecial = nextFoundSpecial;

			Version thisBegin = std::max(oldLogData[i].tLogs[bestOldSet]->startVersion, begin);
			if (thisBegin < lastBegin) {
				if (thisBegin < end) {
					TraceEvent("TLogPeekLocalAddingOldBest", dbgid)
					    .detail("Tag", tag.toString())
					    .detail("Begin", begin)
					    .detail("End", end)
					    .detail("BestOldSet", bestOldSet)
					    .detail("LogServers", oldLogData[i].tLogs[bestOldSet]->logServerString())
					    .detail("ThisBegin", thisBegin)
					    .detail("LastBegin", lastBegin);
					// detail("LogId",
					// oldLogData[i].tLogs[bestOldSet]->logServers[tLogs[bestOldSet]->bestLocationFor( tag
					// )]->get().id());
					cursors.push_back(makeReference<ILogSystem::MergedPeekCursor>(
					    oldLogData[i].tLogs[bestOldSet]->logServers,
					    oldLogData[i].tLogs[bestOldSet]->bestLocationFor(tag),
					    oldLogData[i].tLogs[bestOldSet]->logServers.size() + 1 -
					        oldLogData[i].tLogs[bestOldSet]->tLogReplicationFactor,
					    tag,
					    thisBegin,
					    std::min(lastBegin, end),
					    useMergePeekCursors,
					    oldLogData[i].tLogs[bestOldSet]->tLogLocalities,
					    oldLogData[i].tLogs[bestOldSet]->tLogPolicy,
					    oldLogData[i].tLogs[bestOldSet]->tLogReplicationFactor));
					epochEnds.emplace_back(std::min(lastBegin, end));
				}
				lastBegin = thisBegin;
			}
		}

		return makeReference<ILogSystem::MultiCursor>(cursors, epochEnds);
	}
}

Reference<ILogSystem::IPeekCursor> TagPartitionedLogSystem::peekTxs(UID dbgid,
                                                                    Version begin,
                                                                    int8_t peekLocality,
                                                                    Version localEnd,
                                                                    bool canDiscardPopped) {
	Version end = getEnd();
	if (!tLogs.size()) {
		TraceEvent("TLogPeekTxsNoLogs", dbgid).log();
		return makeReference<ILogSystem::ServerPeekCursor>(
		    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(), invalidTag, begin, end, false, false);
	}
	TraceEvent("TLogPeekTxs", dbgid)
	    .detail("Begin", begin)
	    .detail("End", end)
	    .detail("LocalEnd", localEnd)
	    .detail("PeekLocality", peekLocality)
	    .detail("CanDiscardPopped", canDiscardPopped);

	int maxTxsTags = txsTags;
	for (auto& it : oldLogData) {
		maxTxsTags = std::max<int>(maxTxsTags, it.txsTags);
	}

	if (peekLocality < 0 || localEnd == invalidVersion || localEnd <= begin) {
		std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
		cursors.reserve(maxTxsTags);
		for (int i = 0; i < maxTxsTags; i++) {
			cursors.push_back(peekAll(dbgid, begin, end, Tag(tagLocalityTxs, i), true));
		}

		return makeReference<ILogSystem::BufferedCursor>(cursors, begin, end, false, canDiscardPopped);
	}

	try {
		if (localEnd >= end) {
			std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
			cursors.reserve(maxTxsTags);
			for (int i = 0; i < maxTxsTags; i++) {
				cursors.push_back(peekLocal(dbgid, Tag(tagLocalityTxs, i), begin, end, true, peekLocality));
			}

			return makeReference<ILogSystem::BufferedCursor>(cursors, begin, end, false, canDiscardPopped);
		}

		std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
		std::vector<LogMessageVersion> epochEnds;

		cursors.resize(2);

		std::vector<Reference<ILogSystem::IPeekCursor>> localCursors;
		std::vector<Reference<ILogSystem::IPeekCursor>> allCursors;
		for (int i = 0; i < maxTxsTags; i++) {
			localCursors.push_back(peekLocal(dbgid, Tag(tagLocalityTxs, i), begin, localEnd, true, peekLocality));
			allCursors.push_back(peekAll(dbgid, localEnd, end, Tag(tagLocalityTxs, i), true));
		}

		cursors[1] = makeReference<ILogSystem::BufferedCursor>(localCursors, begin, localEnd, false, canDiscardPopped);
		cursors[0] = makeReference<ILogSystem::BufferedCursor>(allCursors, localEnd, end, false, false);
		epochEnds.emplace_back(localEnd);

		return makeReference<ILogSystem::MultiCursor>(cursors, epochEnds);
	} catch (Error& e) {
		if (e.code() == error_code_worker_removed) {
			std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
			cursors.reserve(maxTxsTags);
			for (int i = 0; i < maxTxsTags; i++) {
				cursors.push_back(peekAll(dbgid, begin, end, Tag(tagLocalityTxs, i), true));
			}

			return makeReference<ILogSystem::BufferedCursor>(cursors, begin, end, false, canDiscardPopped);
		}
		throw;
	}
}

Reference<ILogSystem::IPeekCursor> TagPartitionedLogSystem::peekSingle(UID dbgid,
                                                                       Version begin,
                                                                       Tag tag,
                                                                       std::vector<std::pair<Version, Tag>> history) {
	while (history.size() && begin >= history.back().first) {
		history.pop_back();
	}

	if (history.size() == 0) {
		TraceEvent("TLogPeekSingleNoHistory", dbgid).detail("Tag", tag.toString()).detail("Begin", begin);
		return peekLocal(dbgid, tag, begin, getPeekEnd(), false);
	} else {
		std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
		std::vector<LogMessageVersion> epochEnds;

		TraceEvent("TLogPeekSingleAddingLocal", dbgid).detail("Tag", tag.toString()).detail("Begin", history[0].first);
		cursors.push_back(peekLocal(dbgid, tag, history[0].first, getPeekEnd(), false));

		for (int i = 0; i < history.size(); i++) {
			TraceEvent("TLogPeekSingleAddingOld", dbgid)
			    .detail("Tag", tag.toString())
			    .detail("HistoryTag", history[i].second.toString())
			    .detail("Begin", i + 1 == history.size() ? begin : std::max(history[i + 1].first, begin))
			    .detail("End", history[i].first);
			cursors.push_back(peekLocal(dbgid,
			                            history[i].second,
			                            i + 1 == history.size() ? begin : std::max(history[i + 1].first, begin),
			                            history[i].first,
			                            false));
			epochEnds.emplace_back(history[i].first);
		}

		return makeReference<ILogSystem::MultiCursor>(cursors, epochEnds);
	}
}

Reference<ILogSystem::IPeekCursor> TagPartitionedLogSystem::peekLogRouter(
    UID dbgid,
    Version begin,
    Tag tag,
    bool useSatellite,
    Optional<Version> end,
    const Optional<std::map<uint8_t, std::vector<uint16_t>>>& knownStoppedTLogIds) {
	bool found = false;
	if (!end.present()) {
		end = std::numeric_limits<Version>::max();
	} else {
		end = end.get() + 1; // The last version is exclusive to the cursor's desired range
	}

	for (const auto& log : tLogs) {
		found = log->hasLogRouter(dbgid) || log->hasBackupWorker(dbgid);
		if (found) {
			break;
		}
	}
	if (found) {
		if (stopped) {
			std::vector<Reference<LogSet>> localSets;
			// indexes into "localSets"
			int bestPrimarySet = 0;
			int bestSatelliteSet = -1;
			// indexes into "tLogs"
			int logIdx = 0;
			int bestPrimarySetIdx = -1;
			int bestSatelliteSetIdx = -1;
			for (auto& log : tLogs) {
				if (log->isLocal && log->logServers.size()) {
					TraceEvent("TLogPeekLogRouterLocalSet", dbgid)
					    .detail("Tag", tag.toString())
					    .detail("Begin", begin)
					    .detail("LogServers", log->logServerString());
					localSets.push_back(log);
					if (log->locality == tagLocalitySatellite) {
						bestSatelliteSet = localSets.size() - 1;
						bestSatelliteSetIdx = logIdx;
					} else {
						bestPrimarySet = localSets.size() - 1;
						bestPrimarySetIdx = logIdx;
					}
				}
				logIdx++;
			}
			int bestSet = bestPrimarySet;
			int bestSetIdx = bestPrimarySetIdx;
			if (useSatellite && bestSatelliteSet != -1 && tLogs[bestSatelliteSet]->tLogVersion >= TLogVersion::V4) {
				bestSet = bestSatelliteSet;
				bestSetIdx = bestSatelliteSetIdx;
			}

			int bestServer = localSets[bestSet]->bestLocationFor(tag);
			Optional<std::vector<uint16_t>> bestKnownStoppedTLogIds;
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST) {
				resetBestServerIfNotLocked(bestSetIdx, bestServer, end, knownStoppedTLogIds);
				ASSERT_WE_THINK(!knownStoppedTLogIds.present() || knownStoppedTLogIds.get().contains(bestSetIdx));
				bestKnownStoppedTLogIds = knownStoppedTLogIds.get().at(bestSetIdx);
			}

			TraceEvent("TLogPeekLogRouterSets", dbgid).detail("Tag", tag.toString()).detail("Begin", begin);
			// FIXME: do this merge on one of the logs in the other data center to avoid sending multiple copies
			// across the WAN
			return makeReference<ILogSystem::SetPeekCursor>(
			    localSets, bestSet, bestServer, tag, begin, end.get(), true, bestKnownStoppedTLogIds);
		} else {
			int bestPrimarySet = -1;
			int bestSatelliteSet = -1;
			for (int i = 0; i < tLogs.size(); i++) {
				const auto& log = tLogs[i];
				if (log->logServers.size() && log->isLocal) {
					if (log->locality == tagLocalitySatellite) {
						bestSatelliteSet = i;
						break;
					} else {
						if (bestPrimarySet == -1)
							bestPrimarySet = i;
					}
				}
			}
			int bestSet = bestPrimarySet;
			if (useSatellite && bestSatelliteSet != -1 && tLogs[bestSatelliteSet]->tLogVersion >= TLogVersion::V4) {
				bestSet = bestSatelliteSet;
			}
			const auto& log = tLogs[bestSet];
			TraceEvent("TLogPeekLogRouterBestOnly", dbgid)
			    .detail("Tag", tag.toString())
			    .detail("Begin", begin)
			    .detail("LogId", log->logServers[log->bestLocationFor(tag)]->get().id());
			return makeReference<ILogSystem::ServerPeekCursor>(
			    log->logServers[log->bestLocationFor(tag)], tag, begin, end.get(), false, true);
		}
	}
	bool firstOld = true;
	for (const auto& old : oldLogData) {
		found = false;
		for (const auto& log : old.tLogs) {
			found = log->hasLogRouter(dbgid) || log->hasBackupWorker(dbgid);
			if (found) {
				break;
			}
		}
		if (found) {
			int bestPrimarySet = 0;
			int bestSatelliteSet = -1;
			std::vector<Reference<LogSet>> localSets;
			for (auto& log : old.tLogs) {
				if (log->isLocal && log->logServers.size()) {
					TraceEvent("TLogPeekLogRouterOldLocalSet", dbgid)
					    .detail("Tag", tag.toString())
					    .detail("Begin", begin)
					    .detail("LogServers", log->logServerString());
					localSets.push_back(log);
					if (log->locality == tagLocalitySatellite) {
						bestSatelliteSet = localSets.size() - 1;
					} else {
						bestPrimarySet = localSets.size() - 1;
					}
				}
			}
			int bestSet = bestPrimarySet;
			if (useSatellite && bestSatelliteSet != -1 && old.tLogs[bestSatelliteSet]->tLogVersion >= TLogVersion::V4) {
				bestSet = bestSatelliteSet;
			}

			TraceEvent("TLogPeekLogRouterOldSets", dbgid)
			    .detail("Tag", tag.toString())
			    .detail("Begin", begin)
			    .detail("OldEpoch", old.epochEnd)
			    .detail("RecoveredAt", recoveredAt.present() ? recoveredAt.get() : -1)
			    .detail("FirstOld", firstOld);
			// FIXME: do this merge on one of the logs in the other data center to avoid sending multiple copies
			// across the WAN
			return makeReference<ILogSystem::SetPeekCursor>(localSets,
			                                                bestSet,
			                                                localSets[bestSet]->bestLocationFor(tag),
			                                                tag,
			                                                begin,
			                                                firstOld && recoveredAt.present() ? recoveredAt.get() + 1
			                                                                                  : old.epochEnd,
			                                                true);
		}
		firstOld = false;
	}
	return makeReference<ILogSystem::ServerPeekCursor>(
	    Reference<AsyncVar<OptionalInterface<TLogInterface>>>(), tag, begin, end.get(), false, false);
}

Version TagPartitionedLogSystem::getKnownCommittedVersion() {
	Version result = invalidVersion;
	for (auto& it : lockResults) {
		auto durableVersionInfo = TagPartitionedLogSystem::getDurableVersion(dbgid, it);
		if (durableVersionInfo.present()) {
			result = std::max(result, durableVersionInfo.get().knownCommittedVersion);
		}
	}
	return result;
}

Future<Void> TagPartitionedLogSystem::onKnownCommittedVersionChange() {
	std::vector<Future<Void>> result;
	for (auto& it : lockResults) {
		result.push_back(TagPartitionedLogSystem::getDurableVersionChanged(it));
	}
	if (!result.size()) {
		return Never();
	}
	return waitForAny(result);
}

void TagPartitionedLogSystem::popLogRouter(Version upTo,
                                           Tag tag,
                                           Version durableKnownCommittedVersion,
                                           int8_t popLocality) {
	if (!upTo)
		return;

	Version lastGenerationStartVersion = TagPartitionedLogSystem::getMaxLocalStartVersion(tLogs);
	if (upTo >= lastGenerationStartVersion) {
		for (auto& t : tLogs) {
			if (t->locality == popLocality) {
				for (auto& log : t->logRouters) {
					Version prev = outstandingPops[std::make_pair(log->get().id(), tag)].first;
					if (prev < upTo) {
						outstandingPops[std::make_pair(log->get().id(), tag)] =
						    std::make_pair(upTo, durableKnownCommittedVersion);
					}
					if (prev == 0) {
						popActors.add(popFromLog(this,
						                         log,
						                         tag,
						                         /*delayBeforePop=*/0.0,
						                         /*popLogRouter=*/true)); // Fast pop time because log routers can only
						                                                  // hold 5 seconds of data.
					}
				}
			}
		}
	}

	Version nextGenerationStartVersion = lastGenerationStartVersion;
	for (const auto& old : oldLogData) {
		Version generationStartVersion = TagPartitionedLogSystem::getMaxLocalStartVersion(old.tLogs);
		if (generationStartVersion <= upTo) {
			for (auto& t : old.tLogs) {
				if (t->locality == popLocality) {
					for (auto& log : t->logRouters) {
						auto logRouterIdTagPair = std::make_pair(log->get().id(), tag);

						// We pop the log router only if the popped version is within this generation's version range.
						// That is between the current generation's start version and the next generation's start
						// version.
						if (logRouterLastPops.find(logRouterIdTagPair) == logRouterLastPops.end() ||
						    logRouterLastPops[logRouterIdTagPair] < nextGenerationStartVersion) {
							Version prev = outstandingPops[logRouterIdTagPair].first;
							if (prev < upTo) {
								outstandingPops[logRouterIdTagPair] =
								    std::make_pair(upTo, durableKnownCommittedVersion);
							}
							if (prev == 0) {
								popActors.add(
								    popFromLog(this, log, tag, /*delayBeforePop=*/0.0, /*popLogRouter=*/true));
							}
						}
					}
				}
			}
		}

		nextGenerationStartVersion = generationStartVersion;
	}
}

void TagPartitionedLogSystem::popTxs(Version upTo, int8_t popLocality) {
	for (int i = 0; i < txsTags; i++) {
		pop(upTo, Tag(tagLocalityTxs, i), 0, popLocality);
	}
}

void TagPartitionedLogSystem::pop(Version upTo, Tag tag, Version durableKnownCommittedVersion, int8_t popLocality) {
	if (upTo <= 0)
		return;
	if (tag.locality == tagLocalityRemoteLog) {
		popLogRouter(upTo, tag, durableKnownCommittedVersion, popLocality);
		return;
	}
	for (auto& t : tLogs) {
		if (t->locality == tagLocalitySpecial || t->locality == tag.locality ||
		    (tag.locality < 0 && ((popLocality == tagLocalityInvalid) == t->isLocal))) {
			for (auto& log : t->logServers) {
				Version prev = outstandingPops[std::make_pair(log->get().id(), tag)].first;
				if (prev < upTo) {
					// update pop version for popFromLog actor
					outstandingPops[std::make_pair(log->get().id(), tag)] =
					    std::make_pair(upTo, durableKnownCommittedVersion);
				}
				if (prev == 0) {
					// pop tag from log upto version defined in outstandingPops[].first
					popActors.add(popFromLog(this, log, tag, SERVER_KNOBS->POP_FROM_LOG_DELAY, /*popLogRouter=*/false));
				}
			}
		}
	}
}

															#line 2629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via popFromLog()
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_PopFromLogActor>
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_PopFromLogActorState {
															#line 2635 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_PopFromLogActorState(TagPartitionedLogSystem* const& self,Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& log,Tag const& tag,double const& delayBeforePop,bool const& popLogRouter) 
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : self(self),
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   log(log),
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   tag(tag),
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   delayBeforePop(delayBeforePop),
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   popLogRouter(popLogRouter),
															#line 1612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   last(0)
															#line 2652 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("popFromLog", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_PopFromLogActorState() 
	{
		fdb_probe_actor_destroy("popFromLog", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1613 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 2667 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_PopFromLogActorState();
		static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1614 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(delayBeforePop, TaskPriority::TLogPop);
															#line 1614 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2699 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state = 1;
															#line 1614 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)));
															#line 2704 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1617 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		to = self->outstandingPops[std::make_pair(log->get().id(), tag)];
															#line 1619 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (to.first <= last)
															#line 2715 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 1620 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->outstandingPops.erase(std::make_pair(log->get().id(), tag));
															#line 1621 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_PopFromLogActorState(); static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->destroy(); return 0; }
															#line 2721 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			new (&static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TagPartitionedLogSystem_PopFromLogActorState();
			static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		try {
															#line 1625 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!log->get().present())
															#line 2730 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 1626 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (!static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_PopFromLogActorState(); static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->destroy(); return 0; }
															#line 2734 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				new (&static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TagPartitionedLogSystem_PopFromLogActorState();
				static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1627 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = log->get().interf().popMessages.getReply(TLogPopRequest(to.first, to.second, tag), TaskPriority::TLogPop);
															#line 1627 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2744 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state = 2;
															#line 1627 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)));
															#line 2749 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1617 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		to = self->outstandingPops[std::make_pair(log->get().id(), tag)];
															#line 1619 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (to.first <= last)
															#line 2766 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 1620 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->outstandingPops.erase(std::make_pair(log->get().id(), tag));
															#line 1621 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_PopFromLogActorState(); static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->destroy(); return 0; }
															#line 2772 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			new (&static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TagPartitionedLogSystem_PopFromLogActorState();
			static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		try {
															#line 1625 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!log->get().present())
															#line 2781 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 1626 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (!static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_PopFromLogActorState(); static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->destroy(); return 0; }
															#line 2785 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				new (&static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TagPartitionedLogSystem_PopFromLogActorState();
				static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1627 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = log->get().interf().popMessages.getReply(TLogPopRequest(to.first, to.second, tag), TaskPriority::TLogPop);
															#line 1627 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2795 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state = 2;
															#line 1627 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)));
															#line 2800 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("popFromLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popFromLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("popFromLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popFromLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("popFromLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popFromLog", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1636 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2897 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 1637 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2901 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 1638 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent((e.code() == error_code_broken_promise) ? SevInfo : SevError, "LogPopError", self->dbgid) .error(e) .detail("Log", log->get().id());
															#line 1641 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_PopFromLogActorState(); static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->destroy(); return 0; }
															#line 2907 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			new (&static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TagPartitionedLogSystem_PopFromLogActorState();
			static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1630 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (popLogRouter)
															#line 2925 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 1631 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->logRouterLastPops[std::make_pair(log->get().id(), tag)] = to.first;
															#line 2929 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 1634 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		last = to.first;
															#line 2933 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1630 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (popLogRouter)
															#line 2942 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 1631 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->logRouterLastPops[std::make_pair(log->get().id(), tag)] = to.first;
															#line 2946 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 1634 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		last = to.first;
															#line 2950 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("popFromLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popFromLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("popFromLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popFromLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("popFromLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("popFromLog", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem* self;
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<AsyncVar<OptionalInterface<TLogInterface>>> log;
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Tag tag;
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	double delayBeforePop;
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	bool popLogRouter;
															#line 1612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Version last;
															#line 1617 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::pair<Version, Version> to;
															#line 3057 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via popFromLog()
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_PopFromLogActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 0, Void >, public ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >, public FastAllocated<TagPartitionedLogSystem_PopFromLogActor>, public TagPartitionedLogSystem_PopFromLogActorState<TagPartitionedLogSystem_PopFromLogActor> {
															#line 3062 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_PopFromLogActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_PopFromLogActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7199705889966298880UL, 11592317460544187648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 0, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >;
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_PopFromLogActor(TagPartitionedLogSystem* const& self,Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& log,Tag const& tag,double const& delayBeforePop,bool const& popLogRouter) 
															#line 3080 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_PopFromLogActorState<TagPartitionedLogSystem_PopFromLogActor>(self, log, tag, delayBeforePop, popLogRouter),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("popFromLog", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5741736573844489984UL, 4398161550353777152UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_PopFromLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("popFromLog");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("popFromLog", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_PopFromLogActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::popFromLog( TagPartitionedLogSystem* const& self, Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& log, Tag const& tag, double const& delayBeforePop, bool const& popLogRouter ) {
															#line 1607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_PopFromLogActor(self, log, tag, delayBeforePop, popLogRouter));
															#line 3113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 1646 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 3118 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via getPoppedFromTLog()
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_GetPoppedFromTLogActor>
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_GetPoppedFromTLogActorState {
															#line 3124 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_GetPoppedFromTLogActorState(Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& log,Tag const& tag) 
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : log(log),
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   tag(tag)
															#line 3133 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("getPoppedFromTLog", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_GetPoppedFromTLogActorState() 
	{
		fdb_probe_actor_destroy("getPoppedFromTLog", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1651 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 3148 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_GetPoppedFromTLogActorState();
		static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1653 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<TLogPeekReply> __when_expr_0 = log->get().present() ? brokenPromiseToNever(log->get().interf().peekMessages.getReply( TLogPeekRequest(-1, tag, false, false))) : Never();
															#line 1652 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3180 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 1660 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = log->onChange();
															#line 3184 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->actor_wait_state = 1;
															#line 1653 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 0, TLogPeekReply >*>(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)));
															#line 1660 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)));
															#line 3191 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogPeekReply const& rep,int loopDepth) 
	{
															#line 1657 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		ASSERT(rep.popped.present());
															#line 1658 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->SAV<Version>::futures) { (void)(rep.popped.get()); this->~TagPartitionedLogSystem_GetPoppedFromTLogActorState(); static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->destroy(); return 0; }
															#line 3208 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->SAV< Version >::value()) Version(rep.popped.get());
		this->~TagPartitionedLogSystem_GetPoppedFromTLogActorState();
		static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogPeekReply && rep,int loopDepth) 
	{
															#line 1657 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		ASSERT(rep.popped.present());
															#line 1658 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->SAV<Version>::futures) { (void)(rep.popped.get()); this->~TagPartitionedLogSystem_GetPoppedFromTLogActorState(); static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->destroy(); return 0; }
															#line 3222 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->SAV< Version >::value()) Version(rep.popped.get());
		this->~TagPartitionedLogSystem_GetPoppedFromTLogActorState();
		static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 0, TLogPeekReply >::remove();
		static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 0, TLogPeekReply >*,TLogPeekReply const& value) 
	{
		fdb_probe_actor_enter("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 0, TLogPeekReply >*,TLogPeekReply && value) 
	{
		fdb_probe_actor_enter("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 0, TLogPeekReply >*,Error err) 
	{
		fdb_probe_actor_enter("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<AsyncVar<OptionalInterface<TLogInterface>>> log;
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Tag tag;
															#line 3367 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via getPoppedFromTLog()
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_GetPoppedFromTLogActor final : public Actor<Version>, public ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 0, TLogPeekReply >, public ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 1, Void >, public FastAllocated<TagPartitionedLogSystem_GetPoppedFromTLogActor>, public TagPartitionedLogSystem_GetPoppedFromTLogActorState<TagPartitionedLogSystem_GetPoppedFromTLogActor> {
															#line 3372 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_GetPoppedFromTLogActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_GetPoppedFromTLogActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17408747655174579968UL, 17404135684776495872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 0, TLogPeekReply >;
friend struct ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 1, Void >;
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_GetPoppedFromTLogActor(Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& log,Tag const& tag) 
															#line 3390 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Version>(),
		   TagPartitionedLogSystem_GetPoppedFromTLogActorState<TagPartitionedLogSystem_GetPoppedFromTLogActor>(log, tag),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18222483751475266304UL, 1699573276908987648UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedFromTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getPoppedFromTLog");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getPoppedFromTLog", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_GetPoppedFromTLogActor, 0, TLogPeekReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Version> TagPartitionedLogSystem::getPoppedFromTLog( Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& log, Tag const& tag ) {
															#line 1647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Version>(new TagPartitionedLogSystem_GetPoppedFromTLogActor(log, tag));
															#line 3422 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 1664 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 3427 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via getPoppedTxs()
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_GetPoppedTxsActor>
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_GetPoppedTxsActorState {
															#line 3433 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_GetPoppedTxsActorState(TagPartitionedLogSystem* const& self) 
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : self(self),
															#line 1666 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   poppedFutures(),
															#line 1667 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   poppedReady()
															#line 3444 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("getPoppedTxs", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_GetPoppedTxsActorState() 
	{
		fdb_probe_actor_destroy("getPoppedTxs", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1668 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (self->tLogs.size())
															#line 3459 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 1669 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				poppedFutures.push_back(std::vector<Future<Version>>());
															#line 1670 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& it : self->tLogs ) {
															#line 1671 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for( auto& log : it->logServers ) {
															#line 1672 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						poppedFutures.back().push_back(TagPartitionedLogSystem::getPoppedFromTLog(log, Tag(tagLocalityTxs, 0)));
															#line 3469 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
				}
															#line 1675 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				poppedReady.push_back(waitForAny(poppedFutures.back()));
															#line 3474 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 1678 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& old : self->oldLogData ) {
															#line 1679 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (old.tLogs.size())
															#line 3480 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 1680 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					poppedFutures.push_back(std::vector<Future<Version>>());
															#line 1681 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for( auto& it : old.tLogs ) {
															#line 1682 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						for( auto& log : it->logServers ) {
															#line 1683 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							poppedFutures.back().push_back( TagPartitionedLogSystem::getPoppedFromTLog(log, Tag(tagLocalityTxs, 0)));
															#line 3490 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
					}
															#line 1687 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					poppedReady.push_back(waitForAny(poppedFutures.back()));
															#line 3495 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 1691 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			dbgid = self->dbgid;
															#line 1692 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			maxGetPoppedDuration = delay(SERVER_KNOBS->TXS_POPPED_MAX_DELAY);
															#line 1693 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(poppedReady) || maxGetPoppedDuration;
															#line 1693 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3506 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->actor_wait_state = 1;
															#line 1693 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_GetPoppedTxsActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)));
															#line 3511 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_GetPoppedTxsActorState();
		static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1695 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (maxGetPoppedDuration.isReady())
															#line 3534 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 1696 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "PoppedTxsNotReady", dbgid).log();
															#line 3538 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 1699 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version maxPopped = 1;
															#line 1700 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( auto& it : poppedFutures ) {
															#line 1701 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& v : it ) {
															#line 1702 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (v.isReady())
															#line 3548 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 1703 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					maxPopped = std::max(maxPopped, v.get());
															#line 3552 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 1707 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->SAV<Version>::futures) { (void)(maxPopped); this->~TagPartitionedLogSystem_GetPoppedTxsActorState(); static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->destroy(); return 0; }
															#line 3558 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->SAV< Version >::value()) Version(maxPopped);
		this->~TagPartitionedLogSystem_GetPoppedTxsActorState();
		static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1695 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (maxGetPoppedDuration.isReady())
															#line 3570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 1696 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "PoppedTxsNotReady", dbgid).log();
															#line 3574 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 1699 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version maxPopped = 1;
															#line 1700 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( auto& it : poppedFutures ) {
															#line 1701 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& v : it ) {
															#line 1702 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (v.isReady())
															#line 3584 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 1703 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					maxPopped = std::max(maxPopped, v.get());
															#line 3588 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 1707 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->SAV<Version>::futures) { (void)(maxPopped); this->~TagPartitionedLogSystem_GetPoppedTxsActorState(); static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->destroy(); return 0; }
															#line 3594 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->SAV< Version >::value()) Version(maxPopped);
		this->~TagPartitionedLogSystem_GetPoppedTxsActorState();
		static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->ActorCallback< TagPartitionedLogSystem_GetPoppedTxsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_GetPoppedTxsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getPoppedTxs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedTxs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_GetPoppedTxsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getPoppedTxs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedTxs", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_GetPoppedTxsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getPoppedTxs", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getPoppedTxs", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem* self;
															#line 1666 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<std::vector<Future<Version>>> poppedFutures;
															#line 1667 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<Void>> poppedReady;
															#line 1691 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	UID dbgid;
															#line 1692 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<Void> maxGetPoppedDuration;
															#line 3687 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via getPoppedTxs()
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_GetPoppedTxsActor final : public Actor<Version>, public ActorCallback< TagPartitionedLogSystem_GetPoppedTxsActor, 0, Void >, public FastAllocated<TagPartitionedLogSystem_GetPoppedTxsActor>, public TagPartitionedLogSystem_GetPoppedTxsActorState<TagPartitionedLogSystem_GetPoppedTxsActor> {
															#line 3692 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_GetPoppedTxsActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_GetPoppedTxsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11762407679433563904UL, 1014155151754609408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_GetPoppedTxsActor, 0, Void >;
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_GetPoppedTxsActor(TagPartitionedLogSystem* const& self) 
															#line 3709 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Version>(),
		   TagPartitionedLogSystem_GetPoppedTxsActorState<TagPartitionedLogSystem_GetPoppedTxsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getPoppedTxs", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9590233900403763968UL, 13662839203181325312UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetPoppedTxsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getPoppedTxs");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getPoppedTxs", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_GetPoppedTxsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Version> TagPartitionedLogSystem::getPoppedTxs( TagPartitionedLogSystem* const& self ) {
															#line 1665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Version>(new TagPartitionedLogSystem_GetPoppedTxsActor(self));
															#line 3741 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 1709 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

Future<Version> TagPartitionedLogSystem::getTxsPoppedVersion() {
	return getPoppedTxs(this);
}

															#line 3750 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via confirmEpochLive_internal()
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_ConfirmEpochLive_internalActor>
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_ConfirmEpochLive_internalActorState {
															#line 3756 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_ConfirmEpochLive_internalActorState(Reference<LogSet> const& logSet,Optional<UID> const& debugID) 
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : logSet(logSet),
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   debugID(debugID),
															#line 1715 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   alive()
															#line 3767 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_ConfirmEpochLive_internalActorState() 
	{
		fdb_probe_actor_destroy("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1716 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			int numPresent = 0;
															#line 1717 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& t : logSet->logServers ) {
															#line 1718 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (t->get().present())
															#line 3786 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 1719 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					alive.push_back(brokenPromiseToNever(t->get().interf().confirmRunning.getReply( TLogConfirmRunningRequest(debugID), TaskPriority::TLogConfirmRunningReply)));
															#line 1721 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					numPresent++;
															#line 3792 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
				else
				{
															#line 1723 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					alive.push_back(Never());
															#line 3798 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 1727 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = quorum(alive, std::min(logSet->tLogReplicationFactor, numPresent - logSet->tLogWriteAntiQuorum));
															#line 1727 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3805 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->actor_wait_state = 1;
															#line 1727 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)));
															#line 3810 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_ConfirmEpochLive_internalActorState();
		static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1729 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		aliveEntries = std::vector<LocalityEntry>();
															#line 1730 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		responded = std::vector<bool>(alive.size(), false);
															#line 1731 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		;
															#line 3837 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1729 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		aliveEntries = std::vector<LocalityEntry>();
															#line 1730 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		responded = std::vector<bool>(alive.size(), false);
															#line 1731 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		;
															#line 3850 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1732 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < alive.size();i++) {
															#line 1733 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!responded[i] && alive[i].isReady() && !alive[i].isError())
															#line 3943 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 1734 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				aliveEntries.push_back(logSet->logEntryArray[i]);
															#line 1735 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				responded[i] = true;
															#line 3949 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 1739 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (logSet->satisfiesPolicy(aliveEntries))
															#line 3954 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 1740 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_ConfirmEpochLive_internalActorState(); static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->destroy(); return 0; }
															#line 3958 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			new (&static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~TagPartitionedLogSystem_ConfirmEpochLive_internalActorState();
			static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1745 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Future<Void>> changes;
															#line 1746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < alive.size();i++) {
															#line 1747 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!alive[i].isReady())
															#line 3970 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 1748 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				changes.push_back(ready(alive[i]));
															#line 3974 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
			else
			{
															#line 1749 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (alive[i].isReady() && alive[i].isError() && alive[i].getError().code() == error_code_tlog_stopped)
															#line 3980 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 1752 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					this->~TagPartitionedLogSystem_ConfirmEpochLive_internalActorState();
															#line 3984 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->sendAndDelPromiseRef(Never());
					return 0;
				}
			}
		}
															#line 1755 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		ASSERT(changes.size() != 0);
															#line 1756 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAny(changes);
															#line 1756 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3996 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->actor_wait_state = 2;
															#line 1756 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)));
															#line 4001 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<LogSet> logSet;
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Optional<UID> debugID;
															#line 1715 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<Void>> alive;
															#line 1729 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<LocalityEntry> aliveEntries;
															#line 1730 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<bool> responded;
															#line 4103 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via confirmEpochLive_internal()
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_ConfirmEpochLive_internalActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 0, Void >, public ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 1, Void >, public FastAllocated<TagPartitionedLogSystem_ConfirmEpochLive_internalActor>, public TagPartitionedLogSystem_ConfirmEpochLive_internalActorState<TagPartitionedLogSystem_ConfirmEpochLive_internalActor> {
															#line 4108 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_ConfirmEpochLive_internalActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_ConfirmEpochLive_internalActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6818586104554226432UL, 6665121614099297280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 0, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 1, Void >;
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_ConfirmEpochLive_internalActor(Reference<LogSet> const& logSet,Optional<UID> const& debugID) 
															#line 4126 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_ConfirmEpochLive_internalActorState<TagPartitionedLogSystem_ConfirmEpochLive_internalActor>(logSet, debugID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7386980164351018752UL, 8668871310799357440UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_ConfirmEpochLive_internalActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("confirmEpochLive_internal");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("confirmEpochLive_internal", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_ConfirmEpochLive_internalActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::confirmEpochLive_internal( Reference<LogSet> const& logSet, Optional<UID> const& debugID ) {
															#line 1714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_ConfirmEpochLive_internalActor(logSet, debugID));
															#line 4159 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 1759 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

Future<Void> TagPartitionedLogSystem::confirmEpochLive(Optional<UID> debugID) {
	std::vector<Future<Void>> quorumResults;
	for (auto& it : tLogs) {
		if (it->isLocal && it->logServers.size()) {
			quorumResults.push_back(confirmEpochLive_internal(it, debugID));
		}
	}

	return waitForAll(quorumResults);
}

Future<Void> TagPartitionedLogSystem::endEpoch() {
	std::vector<Future<Void>> lockResults;
	for (auto& logSet : tLogs) {
		for (auto& log : logSet->logServers) {
			lockResults.push_back(success(lockTLog(dbgid, log)));
		}
	}
	return waitForAll(lockResults);
}

Future<Reference<ILogSystem>> TagPartitionedLogSystem::newEpoch(
    RecruitFromConfigurationReply const& recr,
    Future<RecruitRemoteFromConfigurationReply> const& fRemoteWorkers,
    DatabaseConfiguration const& config,
    LogEpoch recoveryCount,
    Version recoveryTransactionVersion,
    int8_t primaryLocality,
    int8_t remoteLocality,
    std::vector<Tag> const& allTags,
    Reference<AsyncVar<bool>> const& recruitmentStalled) {
	return newEpoch(Reference<TagPartitionedLogSystem>::addRef(this),
	                recr,
	                fRemoteWorkers,
	                config,
	                recoveryCount,
	                recoveryTransactionVersion,
	                primaryLocality,
	                remoteLocality,
	                allTags,
	                recruitmentStalled);
}

LogSystemType TagPartitionedLogSystem::getLogSystemType() const {
	return logSystemType;
}

LogSystemConfig TagPartitionedLogSystem::getLogSystemConfig() const {
	LogSystemConfig logSystemConfig(epoch);
	logSystemConfig.logSystemType = logSystemType;
	logSystemConfig.expectedLogSets = expectedLogSets;
	logSystemConfig.logRouterTags = logRouterTags;
	logSystemConfig.txsTags = txsTags;
	logSystemConfig.recruitmentID = recruitmentID;
	logSystemConfig.stopped = stopped;
	logSystemConfig.recoveredAt = recoveredAt;
	logSystemConfig.pseudoLocalities = pseudoLocalities;
	logSystemConfig.oldestBackupEpoch = oldestBackupEpoch;
	logSystemConfig.knownLockedTLogIds = knownLockedTLogIds;
	for (const Reference<LogSet>& logSet : tLogs) {
		if (logSet->isLocal || remoteLogsWrittenToCoreState) {
			logSystemConfig.tLogs.emplace_back(*logSet);
		}
	}

	if (!recoveryCompleteWrittenToCoreState.get()) {
		for (const auto& oldData : oldLogData) {
			logSystemConfig.oldTLogs.emplace_back(oldData);
		}
	}
	return logSystemConfig;
}

Standalone<StringRef> TagPartitionedLogSystem::getLogsValue() const {
	std::vector<std::pair<UID, NetworkAddress>> logs;
	std::vector<std::pair<UID, NetworkAddress>> oldLogs;
	for (auto& t : tLogs) {
		if (t->isLocal || remoteLogsWrittenToCoreState) {
			for (int i = 0; i < t->logServers.size(); i++) {
				logs.emplace_back(t->logServers[i]->get().id(),
				                  t->logServers[i]->get().present() ? t->logServers[i]->get().interf().address()
				                                                    : NetworkAddress());
			}
		}
	}
	if (!recoveryCompleteWrittenToCoreState.get()) {
		for (int i = 0; i < oldLogData.size(); i++) {
			for (auto& t : oldLogData[i].tLogs) {
				for (int j = 0; j < t->logServers.size(); j++) {
					oldLogs.emplace_back(t->logServers[j]->get().id(),
					                     t->logServers[j]->get().present() ? t->logServers[j]->get().interf().address()
					                                                       : NetworkAddress());
				}
			}
		}
	}
	return logsValue(logs, oldLogs);
}

Future<Void> TagPartitionedLogSystem::onLogSystemConfigChange() {
	std::vector<Future<Void>> changes;
	changes.push_back(logSystemConfigChanged.onTrigger());
	for (auto& t : tLogs) {
		for (int i = 0; i < t->logServers.size(); i++) {
			changes.push_back(t->logServers[i]->onChange());
		}
	}
	for (int i = 0; i < oldLogData.size(); i++) {
		for (auto& t : oldLogData[i].tLogs) {
			for (int j = 0; j < t->logServers.size(); j++) {
				changes.push_back(t->logServers[j]->onChange());
			}
		}
	}

	if (hasRemoteServers && !remoteRecovery.isReady()) {
		changes.push_back(remoteRecovery);
	}

	return waitForAny(changes);
}

Version TagPartitionedLogSystem::getEnd() const {
	ASSERT(recoverAt.present());
	return recoverAt.get() + 1;
}

Version TagPartitionedLogSystem::getPeekEnd() const {
	if (recoverAt.present())
		return getEnd();
	else
		return std::numeric_limits<Version>::max();
}

/**
 * This function identifies the locality sets corresponding to a provided list of
 * numeric locations (a subset of the tLogs), effectively creating a set of restricted
 * locality sets.
 *
 * "fromLocations" is a vector of unique numeric locations representing tLogs.
 * Returns a vector of Reference<LocalitySet> objects, where each LocalitySet is
 * restricted to the provided locations that fall within its range.
 */
std::vector<Reference<LocalitySet>> TagPartitionedLogSystem::getPushLocationsForTags(
    std::vector<int>& fromLocations) const {
	std::vector<Reference<LocalitySet>> restrictedLogSets;
	int locationOffset = 0;
	for (auto& log : tLogs) {
		if (!log->isLocal || !log->logServers.size()) {
			locationOffset += log->logServers.size();
			continue;
		}
		std::vector<LocalityEntry> e;
		for (int i : fromLocations) {
			// check if provided location falls within the local logSet's range
			if (i >= locationOffset && i < locationOffset + log->logServers.size()) {
				e.emplace_back(LocalityEntry(i - locationOffset));
			}
		}
		restrictedLogSets.push_back(log->logServerSet->restrict(e));
		locationOffset += log->logServers.size();
	}
	return restrictedLogSets;
}

void TagPartitionedLogSystem::getPushLocations(VectorRef<Tag> tags,
                                               std::vector<int>& locations,
                                               bool allLocations,
                                               Optional<std::vector<Reference<LocalitySet>>> fromLocations) const {
	int locationOffset = 0;
	int setIndex = 0;
	for (auto& logSet : tLogs) {
		if (logSet->isLocal && logSet->logServers.size()) {
			if (fromLocations.present()) {
				logSet->getPushLocations(tags, locations, locationOffset, allLocations, fromLocations.get()[setIndex]);
				setIndex++;
			} else {
				logSet->getPushLocations(tags, locations, locationOffset, allLocations);
			}
			locationOffset += logSet->logServers.size();
		}
	}
}

bool TagPartitionedLogSystem::hasRemoteLogs() const {
	return logRouterTags > 0 || pseudoLocalities.size() > 0;
}

Tag TagPartitionedLogSystem::getRandomRouterTag() const {
	return Tag(tagLocalityLogRouter, deterministicRandom()->randomInt(0, logRouterTags));
}

Tag TagPartitionedLogSystem::getRandomTxsTag() const {
	return Tag(tagLocalityTxs, deterministicRandom()->randomInt(0, txsTags));
}

TLogVersion TagPartitionedLogSystem::getTLogVersion() const {
	return tLogs[0]->tLogVersion;
}

int TagPartitionedLogSystem::getLogRouterTags() const {
	return logRouterTags;
}

Version TagPartitionedLogSystem::getBackupStartVersion() const {
	ASSERT(tLogs.size() > 0);
	return backupStartVersion;
}

std::map<LogEpoch, ILogSystem::EpochTagsVersionsInfo> TagPartitionedLogSystem::getOldEpochTagsVersionsInfo() const {
	std::map<LogEpoch, EpochTagsVersionsInfo> epochInfos;
	for (const auto& old : oldLogData) {
		epochInfos.insert(
		    { old.epoch, ILogSystem::EpochTagsVersionsInfo(old.logRouterTags, old.epochBegin, old.epochEnd) });
		TraceEvent("OldEpochTagsVersions", dbgid)
		    .detail("Epoch", old.epoch)
		    .detail("Tags", old.logRouterTags)
		    .detail("BeginVersion", old.epochBegin)
		    .detail("EndVersion", old.epochEnd);
	}
	return epochInfos;
}

inline Reference<LogSet> TagPartitionedLogSystem::getEpochLogSet(LogEpoch epoch) const {
	for (const auto& old : oldLogData) {
		if (epoch == old.epoch)
			return old.tLogs[0];
	}
	return Reference<LogSet>(nullptr);
}

void TagPartitionedLogSystem::setBackupWorkers(const std::vector<InitializeBackupReply>& replies) {
	ASSERT(tLogs.size() > 0);

	Reference<LogSet> logset = tLogs[0]; // Master recruits this epoch's worker first.
	LogEpoch logsetEpoch = this->epoch;
	oldestBackupEpoch = this->epoch;
	for (const auto& reply : replies) {
		if (removedBackupWorkers.contains(reply.interf.id())) {
			removedBackupWorkers.erase(reply.interf.id());
			continue;
		}
		auto worker = makeReference<AsyncVar<OptionalInterface<BackupInterface>>>(
		    OptionalInterface<BackupInterface>(reply.interf));
		if (reply.backupEpoch != logsetEpoch) {
			// find the logset from oldLogData
			logsetEpoch = reply.backupEpoch;
			oldestBackupEpoch = std::min(oldestBackupEpoch, logsetEpoch);
			logset = getEpochLogSet(logsetEpoch);
			ASSERT(logset.isValid());
		}
		logset->backupWorkers.push_back(worker);
		TraceEvent("AddBackupWorker", dbgid).detail("Epoch", logsetEpoch).detail("BackupWorkerID", reply.interf.id());
	}
	TraceEvent("SetOldestBackupEpoch", dbgid).detail("Epoch", oldestBackupEpoch);
	backupWorkerChanged.trigger();
}

bool TagPartitionedLogSystem::removeBackupWorker(const BackupWorkerDoneRequest& req) {
	bool removed = false;
	Reference<LogSet> logset = getEpochLogSet(req.backupEpoch);
	if (logset.isValid()) {
		for (auto it = logset->backupWorkers.begin(); it != logset->backupWorkers.end(); it++) {
			if (it->getPtr()->get().interf().id() == req.workerUID) {
				logset->backupWorkers.erase(it);
				removed = true;
				break;
			}
		}
	}

	if (removed) {
		oldestBackupEpoch = epoch;
		for (const auto& old : oldLogData) {
			if (old.epoch < oldestBackupEpoch && old.tLogs[0]->backupWorkers.size() > 0) {
				oldestBackupEpoch = old.epoch;
			}
		}
		backupWorkerChanged.trigger();
	} else {
		removedBackupWorkers.insert(req.workerUID);
	}

	TraceEvent("RemoveBackupWorker", dbgid)
	    .detail("Removed", removed)
	    .detail("BackupEpoch", req.backupEpoch)
	    .detail("WorkerID", req.workerUID)
	    .detail("OldestBackupEpoch", oldestBackupEpoch);
	return removed;
}

LogEpoch TagPartitionedLogSystem::getOldestBackupEpoch() const {
	return oldestBackupEpoch;
}

void TagPartitionedLogSystem::setOldestBackupEpoch(LogEpoch epoch) {
	oldestBackupEpoch = epoch;
	backupWorkerChanged.trigger();
}

															#line 4464 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via monitorLog()
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_MonitorLogActor>
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_MonitorLogActorState {
															#line 4470 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_MonitorLogActorState(Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& logServer,Reference<AsyncVar<bool>> const& failed) 
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : logServer(logServer),
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   failed(failed),
															#line 2062 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   waitFailure()
															#line 4481 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorLog", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_MonitorLogActorState() 
	{
		fdb_probe_actor_destroy("monitorLog", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2063 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 4496 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_MonitorLogActorState();
		static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2064 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (logServer->get().present())
															#line 4526 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2065 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			waitFailure = waitFailureTracker(logServer->get().interf().waitFailure, failed);
															#line 4530 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		else
		{
															#line 2067 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			failed->set(true);
															#line 4536 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 2068 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_0 = logServer->onChange();
															#line 2068 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4542 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->actor_wait_state = 1;
															#line 2068 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_MonitorLogActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)));
															#line 4547 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->ActorCallback< TagPartitionedLogSystem_MonitorLogActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_MonitorLogActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_MonitorLogActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_MonitorLogActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorLog", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<AsyncVar<OptionalInterface<TLogInterface>>> logServer;
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<AsyncVar<bool>> failed;
															#line 2062 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<Void> waitFailure;
															#line 4645 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via monitorLog()
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_MonitorLogActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_MonitorLogActor, 0, Void >, public FastAllocated<TagPartitionedLogSystem_MonitorLogActor>, public TagPartitionedLogSystem_MonitorLogActorState<TagPartitionedLogSystem_MonitorLogActor> {
															#line 4650 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_MonitorLogActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_MonitorLogActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8733396971715064064UL, 8441076363697078016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_MonitorLogActor, 0, Void >;
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_MonitorLogActor(Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& logServer,Reference<AsyncVar<bool>> const& failed) 
															#line 4667 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_MonitorLogActorState<TagPartitionedLogSystem_MonitorLogActor>(logServer, failed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorLog", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18381022980533210880UL, 18169834461851947264UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_MonitorLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorLog");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorLog", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_MonitorLogActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::monitorLog( Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& logServer, Reference<AsyncVar<bool>> const& failed ) {
															#line 2060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_MonitorLogActor(logServer, failed));
															#line 4699 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 2071 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

Optional<DurableVersionInfo> TagPartitionedLogSystem::getDurableVersion(UID dbgid,
                                                                        LogLockInfo lockInfo,
                                                                        std::vector<Reference<AsyncVar<bool>>> failed,
                                                                        Optional<Version> lastEnd) {

	Reference<LogSet> logSet = lockInfo.logSet;
	// To ensure consistent recovery, the number of servers NOT in the write quorum plus the number of servers NOT
	// in the read quorum have to be strictly less than the replication factor.  Otherwise there could be a replica
	// set consistent entirely of servers that are out of date due to not being in the write quorum or unavailable
	// due to not being in the read quorum. So with N = # of tlogs, W = antiquorum, R = required count, F =
	// replication factor, W + (N - R) < F, and optimally (N-W)+(N-R)=F-1.  Thus R=N+1-F+W.
	int requiredCount =
	    (int)logSet->logServers.size() + 1 - logSet->tLogReplicationFactor + logSet->tLogWriteAntiQuorum;
	ASSERT(requiredCount > 0 && requiredCount <= logSet->logServers.size());
	ASSERT(logSet->tLogReplicationFactor >= 1 && logSet->tLogReplicationFactor <= logSet->logServers.size());
	ASSERT(logSet->tLogWriteAntiQuorum >= 0 && logSet->tLogWriteAntiQuorum < logSet->logServers.size());

	std::vector<LocalityData> availableItems, badCombo;
	std::vector<TLogLockResult> results;
	std::string sServerState;
	LocalityGroup unResponsiveSet;
	std::vector<uint16_t> lockedTLogIds;
	lockedTLogIds.reserve(logSet->logServers.size());
	for (int t = 0; t < logSet->logServers.size(); t++) {
		if (lockInfo.replies[t].isReady() && !lockInfo.replies[t].isError() && (!failed.size() || !failed[t]->get())) {
			results.push_back(lockInfo.replies[t].get());
			availableItems.push_back(logSet->tLogLocalities[t]);
			sServerState += 'a';
			lockedTLogIds.push_back(t);
		} else {
			unResponsiveSet.add(logSet->tLogLocalities[t]);
			TraceEvent("GetDurableResultNoResponse").detail("TLog", logSet->logServers[t]->get().id());
			sServerState += 'f';
		}
	}

	// Check if the list of results is not larger than the anti quorum
	bool bTooManyFailures = (results.size() <= logSet->tLogWriteAntiQuorum);

	// Check if failed logs complete the policy
	bool failedLogsCompletePolicy = unResponsiveSet.validate(logSet->tLogPolicy);
	bTooManyFailures =
	    bTooManyFailures || ((unResponsiveSet.size() >= logSet->tLogReplicationFactor) && failedLogsCompletePolicy);

	// Check all combinations of the AntiQuorum within the failed
	if (!bTooManyFailures && (logSet->tLogWriteAntiQuorum) &&
	    (!validateAllCombinations(
	        badCombo, unResponsiveSet, logSet->tLogPolicy, availableItems, logSet->tLogWriteAntiQuorum, false))) {
		TraceEvent("EpochEndBadCombo", dbgid)
		    .detail("Required", requiredCount)
		    .detail("Present", results.size())
		    .detail("ServerState", sServerState);
		bTooManyFailures = true;
	}

	ASSERT(logSet->logServers.size() == lockInfo.replies.size());
	if (!bTooManyFailures) {
		std::sort(results.begin(), results.end(), [](const TLogLockResult& a, const TLogLockResult& b) -> bool {
			return a.end < b.end;
		});
		int absent = logSet->logServers.size() - results.size();
		int safe_range_begin = logSet->tLogWriteAntiQuorum;
		int new_safe_range_begin = std::min(logSet->tLogWriteAntiQuorum, (int)(results.size() - 1));
		int safe_range_end = std::max(logSet->tLogReplicationFactor - absent, 1);
		// The index (in "results" vector) of the recovery version that we will use in the check below
		// to decide whether to restart recovery not. In "main" we use the version at index
		// "(safe_range_end - 1)" - this is to minimize the chances of restarting the current recovery
		// process. With "version vector" we use the version at index "new_safe_range_begin" - this is
		// because choosing any other version may result in not copying the correct version range to the
		// log servers in the latest epoch and also will invalidate the changes that we made to the peek
		// logic in the context of version vector.
		int versionIndex =
		    (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST ? (safe_range_end - 1) : new_safe_range_begin);

		if (!lastEnd.present() ||
		    ((versionIndex >= 0) && (versionIndex < results.size()) && results[versionIndex].end < lastEnd.get())) {
			Version knownCommittedVersion = 0;
			for (int i = 0; i < results.size(); i++) {
				knownCommittedVersion = std::max(knownCommittedVersion, results[i].knownCommittedVersion);
			}

			if (knownCommittedVersion > results[new_safe_range_begin].end) {
				knownCommittedVersion = results[new_safe_range_begin].end;
			}

			TraceEvent("GetDurableResult", dbgid)
			    .detail("Required", requiredCount)
			    .detail("Present", results.size())
			    .detail("Anti", logSet->tLogWriteAntiQuorum)
			    .detail("ServerState", sServerState)
			    .detail("RecoveryVersion",
			            ((safe_range_end > 0) && (safe_range_end - 1 < results.size()))
			                ? results[safe_range_end - 1].end
			                : -1)
			    .detail("EndVersion", results[new_safe_range_begin].end)
			    .detail("SafeBegin", safe_range_begin)
			    .detail("SafeEnd", safe_range_end)
			    .detail("NewSafeBegin", new_safe_range_begin)
			    .detail("KnownCommittedVersion", knownCommittedVersion)
			    .detail("EpochEnd", lockInfo.epochEnd);

			// @note In "main" any version in the index range [safe_range_begin, safe_range_end) can be
			// picked as the recovery version. We pick the version at index "new_safe_range_begin" in order
			// to minimize the number of recovery restarts and also to minimize the amount of data we need
			// to copy during recovery. With "version vector" we pick the version "new_safe_range_begin"
			// as choosing any other version may result in not copying the correct version range to the
			// log servers in the latest epoch and also will invalidate the changes that we made to the
			// peek logic in the context of version vector.
			return DurableVersionInfo(knownCommittedVersion,
			                          results[new_safe_range_begin].end,
			                          results,
			                          failedLogsCompletePolicy,
			                          lockedTLogIds);
		}
	}
	TraceEvent("GetDurableResultWaiting", dbgid)
	    .detail("Required", requiredCount)
	    .detail("Present", results.size())
	    .detail("ServerState", sServerState);
	return Optional<DurableVersionInfo>();
}

															#line 4826 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via getDurableVersionChanged()
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_GetDurableVersionChangedActor>
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_GetDurableVersionChangedActorState {
															#line 4832 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_GetDurableVersionChangedActorState(LogLockInfo const& lockInfo,std::vector<Reference<AsyncVar<bool>>> const& failed) 
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : lockInfo(lockInfo),
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   failed(failed)
															#line 4841 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("getDurableVersionChanged", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_GetDurableVersionChangedActorState() 
	{
		fdb_probe_actor_destroy("getDurableVersionChanged", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2197 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			std::vector<Future<Void>> changes;
															#line 2198 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int j = 0;j < lockInfo.logSet->logServers.size();j++) {
															#line 2199 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (!lockInfo.replies[j].isReady())
															#line 4860 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2200 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					changes.push_back(ready(lockInfo.replies[j]));
															#line 4864 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
				else
				{
															#line 2202 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					changes.push_back(lockInfo.logSet->logServers[j]->onChange());
															#line 2203 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (failed.size())
															#line 4872 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 2204 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						changes.push_back(failed[j]->onChange());
															#line 4876 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
				}
			}
															#line 2208 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			ASSERT(changes.size());
															#line 2209 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAny(changes);
															#line 2209 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4886 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->actor_wait_state = 1;
															#line 2209 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_GetDurableVersionChangedActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)));
															#line 4891 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_GetDurableVersionChangedActorState();
		static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2210 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_GetDurableVersionChangedActorState(); static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->destroy(); return 0; }
															#line 4914 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagPartitionedLogSystem_GetDurableVersionChangedActorState();
		static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2210 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_GetDurableVersionChangedActorState(); static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->destroy(); return 0; }
															#line 4926 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagPartitionedLogSystem_GetDurableVersionChangedActorState();
		static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->ActorCallback< TagPartitionedLogSystem_GetDurableVersionChangedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_GetDurableVersionChangedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getDurableVersionChanged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDurableVersionChanged", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_GetDurableVersionChangedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getDurableVersionChanged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDurableVersionChanged", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_GetDurableVersionChangedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getDurableVersionChanged", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getDurableVersionChanged", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	LogLockInfo lockInfo;
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Reference<AsyncVar<bool>>> failed;
															#line 5013 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via getDurableVersionChanged()
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_GetDurableVersionChangedActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_GetDurableVersionChangedActor, 0, Void >, public FastAllocated<TagPartitionedLogSystem_GetDurableVersionChangedActor>, public TagPartitionedLogSystem_GetDurableVersionChangedActorState<TagPartitionedLogSystem_GetDurableVersionChangedActor> {
															#line 5018 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_GetDurableVersionChangedActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_GetDurableVersionChangedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16071181236997845760UL, 844022162751097344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_GetDurableVersionChangedActor, 0, Void >;
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_GetDurableVersionChangedActor(LogLockInfo const& lockInfo,std::vector<Reference<AsyncVar<bool>>> const& failed) 
															#line 5035 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_GetDurableVersionChangedActorState<TagPartitionedLogSystem_GetDurableVersionChangedActor>(lockInfo, failed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getDurableVersionChanged", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13364064207755064064UL, 17775341247779484160UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_GetDurableVersionChangedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getDurableVersionChanged");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getDurableVersionChanged", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_GetDurableVersionChangedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::getDurableVersionChanged( LogLockInfo const& lockInfo, std::vector<Reference<AsyncVar<bool>>> const& failed ) {
															#line 2194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_GetDurableVersionChangedActor(lockInfo, failed));
															#line 5067 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 2212 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

void getTLogLocIds(const std::vector<Reference<LogSet>>& tLogs,
                   const std::tuple<int, std::vector<TLogLockResult>, bool>& logGroupResults,
                   std::vector<uint16_t>& tLogLocIds,
                   uint16_t& maxTLogLocId) {
	// Initialization.
	tLogLocIds.clear();
	maxTLogLocId = 0;

	// Map the interfaces of all (local) tLogs to their corresponding locations in LogSets.
	std::map<UID, uint16_t> interfLocMap;
	uint16_t location = 0;
	for (auto& it : tLogs) {
		if (!it->isLocal) {
			continue;
		}
		for (uint16_t i = 0; i < it->logServers.size(); i++) {
			if (it->logServers[i]->get().present()) {
				interfLocMap[it->logServers[i]->get().interf().id()] = location;
			}
			location++;
		}
	}

	// Set maxTLogLocId.
	maxTLogLocId = location;

	// Find the locations of tLogs in "logGroupResults".
	for (auto& tLogResult : std::get<1>(logGroupResults)) {
		ASSERT(interfLocMap.find(tLogResult.logId) != interfLocMap.end());
		tLogLocIds.push_back(interfLocMap[tLogResult.logId]);
	}
}

Version findMaxKCV(const std::tuple<int, std::vector<TLogLockResult>, bool>& logGroupResults) {
	Version maxKCV = 0;
	for (auto& tLogResult : std::get<1>(logGroupResults)) {
		maxKCV = std::max(maxKCV, tLogResult.knownCommittedVersion);
	}
	return maxKCV;
}

void populateBitset(boost::dynamic_bitset<>& bs, const std::vector<uint16_t>& ids) {
	for (auto& id : ids) {
		ASSERT(id < bs.size());
		bs.set(id);
	}
}

// If ENABLE_VERSION_VECTOR_TLOG_UNICAST is set, one tLog's DV may advance beyond the min(DV) over all tLogs.
// This function finds the highest recoverable version for each tLog group over all log groups.
// All prior versions to the chosen RV must also be recoverable.
// TODO: unit tests to stress UNICAST
Optional<std::tuple<Version, Version>> getRecoverVersionUnicast(
    const std::vector<Reference<LogSet>>& logServers,
    const std::tuple<int, std::vector<TLogLockResult>, bool>& logGroupResults,
    Version minDV) {
	std::vector<uint16_t> tLogLocIds;
	uint16_t maxTLogLocId; // maximum possible id, not maximum of id's of available log servers
	getTLogLocIds(logServers, logGroupResults, tLogLocIds, maxTLogLocId);
	uint16_t bsSize = maxTLogLocId + 1; // bitset size, used below

	Version maxKCV = findMaxKCV(logGroupResults);

	// Summarize the information sent by various tLogs.
	// A bitset of available tLogs
	boost::dynamic_bitset<> availableTLogs(bsSize);
	// version -> tLogs (that are avaiable) that have received the version
	std::unordered_map<Version, boost::dynamic_bitset<>> versionAvailableTLogs;
	// version -> all tLogs that the version was sent to (by the commit proxy)
	std::map<Version, boost::dynamic_bitset<>> versionAllTLogs;
	// version -> prevVersion (that was given out by the sequencer) map
	std::map<Version, Version> prevVersionMap;
	uint16_t tLogIdx = 0;
	int replicationFactor = std::get<0>(logGroupResults);
	for (auto& tLogResult : std::get<1>(logGroupResults)) {
		uint16_t tLogLocId = tLogLocIds[tLogIdx++];
		availableTLogs.set(tLogLocId);
		if (tLogResult.unknownCommittedVersions.empty()) {
			continue;
		}
		for (auto& unknownCommittedVersion : tLogResult.unknownCommittedVersions) {
			Version k = unknownCommittedVersion.version;
			if (k > maxKCV) {
				if (versionAvailableTLogs[k].empty()) {
					versionAvailableTLogs[k].resize(bsSize);
				}
				versionAvailableTLogs[k].set(tLogLocId);
				prevVersionMap[k] = unknownCommittedVersion.prev;
				if (versionAllTLogs[k].empty()) {
					versionAllTLogs[k].resize(bsSize);
				}
				populateBitset(versionAllTLogs[k], unknownCommittedVersion.tLogLocIds);
			}
		}
	}
	ASSERT(availableTLogs.count() == (std::get<1>(logGroupResults)).size());

	if (versionAllTLogs.empty()) {
		return std::make_tuple(maxKCV, maxKCV);
	}

	// Compute recovery version.
	//
	// @note we think that the unicast recovery version should always greater than or
	// equal to "min(DV)" (= "minDV"). To be conservative we use "max(KCV)" (= "maxKCV")
	// as the default (starting) recovery version and later verify that the computed
	// recovery version is greater than or equal to "minDV".
	//
	// @note we are not using "min(KCV)" as the default recovery version because "known
	// committed version" can advance even after a log server is locked when unicast is
	// enabled and so all log servers may not preserve all committed versions, from
	// "min(KCV)" till the correct recovery version, in "unknownCommittedVersions" and
	// this may cause the recovery algorithm to not find the correct recovery version.
	//
	// @todo modify code to use "minDV" as the default (starting) recovery version.
	Version RV = maxKCV; // recovery version
	// @note we currently don't use "RVs", but we may use this information later (maybe for
	// doing error checking). Commenting out the RVs related code for now.
	// std::vector<Version> RVs(maxTLogLocId + 1, maxKCV); // recovery versions of various tLogs
	bool nonAvailableTLogsCompletePolicy = std::get<2>(logGroupResults);
	Version prevVersion = maxKCV;
	for (auto const& [version, tLogs] : versionAllTLogs) {
		if (prevVersion != prevVersionMap[version]) {
			break;
		}
		// This version is not recoverable if there is a log server (LS) such that:
		// - the commit proxy sent this version to LS (i.e., LS is present in "versionAllTLogs[version]")
		// - LS is available (i.e., LS is present in "availableTLogs")
		// - LS didn't receive this version (i.e., LS is not present in "versionAvailableTLogs[version]")
		if (((tLogs & availableTLogs) & ~versionAvailableTLogs[version]).any()) {
			break;
		}
		// If the commit proxy sent this version to "N" log servers then at least
		// (N - replicationFactor + 1) log servers must be available. Otherwise, the
		// unavailable log servers alone would not be sufficient to satisfy the
		// replication policy.
		//
		// @note This check is intentionally more restrictive than necessary.
		// Instead of verifying whether the unavailable log servers within the
		// specific set that received the version satisfy the replication policy,
		// we check whether the entire set of unavailable log servers meets the
		// policy.
		//
		// This approach is chosen because it is computationally more efficient.
		// Checking availability on a per-version basis would require constructing
		// a unique set of unavailable log servers for each version in the unavailable
		// version list, which would add significant overhead.
		if (!((versionAvailableTLogs[version].count() >= tLogs.count() - replicationFactor + 1) ||
		      !nonAvailableTLogsCompletePolicy)) {
			break;
		}
		// Update RV.
		RV = version;
		/*
		@note We currently don't use "RVs", but we may use this information later (maybe for doing
		error checking). Commenting out this code for now.
		Update recovery version vector.
		for (boost::dynamic_bitset<>::size_type id = 0; id < versionAvailableTLogs[version].size(); id++) {
		    if (versionAvailableTLogs[version][id]) {
		        RVs[id] = version;
		    }
		}
		*/
		// Update prevVersion.
		prevVersion = version;
	}
	ASSERT_WE_THINK(RV >= minDV && RV != std::numeric_limits<Version>::max());
	ASSERT_WE_THINK(RV >= maxKCV);
	return std::make_tuple(maxKCV, RV);
}

/**
 * Returns true if:
 *   for each <key, value> in "mapA":
 *     - "key" is present in "mapB"
 *     - each element in (the vector in) "mapA[key]" is present in (the vector in) "mapB[key]"
 * Assumes that the elements in the vectors in "mapA" and "mapB" are in sorted order.
 * @note This function extends the functionality of "std::includes()" to containers of
 * type "std::map<uint8_t, std::vector<uint16_t>>".
 */
static bool isSubset(const std::map<uint8_t, std::vector<uint16_t>>& mapA,
                     const std::map<uint8_t, std::vector<uint16_t>>& mapB) {
	for (const auto& [keyA, valueA] : mapA) {
		auto it = mapB.find(keyA);
		if (it == mapB.end()) {
			return false;
		}
		const auto& valueB = it->second;
		if (!std::includes(valueB.begin(), valueB.end(), valueA.begin(), valueA.end())) {
			return false;
		}
	}
	return true;
}

															#line 5267 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via epochEnd()
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_EpochEndActor>
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_EpochEndActorState {
															#line 5273 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_EpochEndActorState(Reference<AsyncVar<Reference<ILogSystem>>> const& outLogSystem,UID const& dbgid,DBCoreState const& prevState,FutureStream<TLogRejoinRequest> const& rejoinRequests,LocalityData const& locality,bool* const& forceRecovery) 
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : outLogSystem(outLogSystem),
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   dbgid(dbgid),
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   prevState(prevState),
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   rejoinRequests(rejoinRequests),
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   locality(locality),
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   forceRecovery(forceRecovery)
															#line 5290 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("epochEnd", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_EpochEndActorState() 
	{
		fdb_probe_actor_destroy("epochEnd", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2418 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!prevState.tLogs.size())
															#line 5305 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 2420 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				auto logSystem = makeReference<TagPartitionedLogSystem>(dbgid, locality, 0);
															#line 2421 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->logSystemType = prevState.logSystemType;
															#line 2422 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->recoverAt = 0;
															#line 2423 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->knownCommittedVersion = 0;
															#line 2424 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->stopped = true;
															#line 2425 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				outLogSystem->set(logSystem);
															#line 2426 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 2426 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5323 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state = 1;
															#line 2426 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_EpochEndActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)));
															#line 5328 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_EpochEndActorState();
		static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2430 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (*forceRecovery)
															#line 5356 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2431 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			DBCoreState modifiedState = prevState;
															#line 2433 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			int8_t primaryLocality = -1;
															#line 2434 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& coreSet : modifiedState.tLogs ) {
															#line 2435 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (coreSet.isLocal && coreSet.locality >= 0 && coreSet.tLogLocalities[0].dcId() != locality.dcId())
															#line 5366 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2436 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					primaryLocality = coreSet.locality;
															#line 5370 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					break;
				}
			}
															#line 2441 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			bool foundRemote = false;
															#line 2442 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			int8_t remoteLocality = -1;
															#line 2443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			int modifiedLogSets = 0;
															#line 2444 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			int removedLogSets = 0;
															#line 2445 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (primaryLocality >= 0)
															#line 5384 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 2446 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				auto copiedLogs = modifiedState.tLogs;
															#line 2447 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& coreSet : copiedLogs ) {
															#line 2448 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (coreSet.locality != primaryLocality && coreSet.locality >= 0)
															#line 5392 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 2449 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						foundRemote = true;
															#line 2450 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						remoteLocality = coreSet.locality;
															#line 2451 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						modifiedState.tLogs.clear();
															#line 2452 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						modifiedState.tLogs.push_back(coreSet);
															#line 2453 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						modifiedState.tLogs[0].isLocal = true;
															#line 2454 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						modifiedState.logRouterTags = 0;
															#line 2455 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						modifiedLogSets++;
															#line 5408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						break;
					}
				}
															#line 2460 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for(;!foundRemote && modifiedState.oldTLogData.size();) {
															#line 2461 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for( auto& coreSet : modifiedState.oldTLogData[0].tLogs ) {
															#line 2462 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						if (coreSet.locality != primaryLocality && coreSet.locality >= tagLocalitySpecial)
															#line 5418 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						{
															#line 2463 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							foundRemote = true;
															#line 2464 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							remoteLocality = coreSet.locality;
															#line 2465 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							modifiedState.tLogs.clear();
															#line 2466 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							modifiedState.tLogs.push_back(coreSet);
															#line 2467 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							modifiedState.tLogs[0].isLocal = true;
															#line 2468 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							modifiedState.logRouterTags = 0;
															#line 2469 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							modifiedState.txsTags = modifiedState.oldTLogData[0].txsTags;
															#line 2470 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							modifiedLogSets++;
															#line 5436 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
							break;
						}
					}
															#line 2474 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					modifiedState.oldTLogData.erase(modifiedState.oldTLogData.begin());
															#line 2475 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					removedLogSets++;
															#line 5444 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 2478 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (foundRemote)
															#line 5448 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2479 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for(int i = 0;i < modifiedState.oldTLogData.size();i++) {
															#line 2480 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						bool found = false;
															#line 2481 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						auto copiedLogs = modifiedState.oldTLogData[i].tLogs;
															#line 2482 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						for( auto& coreSet : copiedLogs ) {
															#line 2483 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							if (coreSet.locality == remoteLocality || coreSet.locality == tagLocalitySpecial)
															#line 5460 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
							{
															#line 2484 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
								found = true;
															#line 2485 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
								if (!coreSet.isLocal || copiedLogs.size() > 1)
															#line 5466 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
								{
															#line 2486 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
									modifiedState.oldTLogData[i].tLogs.clear();
															#line 2487 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
									modifiedState.oldTLogData[i].tLogs.push_back(coreSet);
															#line 2488 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
									modifiedState.oldTLogData[i].tLogs[0].isLocal = true;
															#line 2489 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
									modifiedState.oldTLogData[i].logRouterTags = 0;
															#line 2490 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
									modifiedState.oldTLogData[i].epochBegin = modifiedState.oldTLogData[i].tLogs[0].startVersion;
															#line 2492 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
									modifiedState.oldTLogData[i].epochEnd = (i == 0 ? modifiedState.tLogs[0].startVersion : modifiedState.oldTLogData[i - 1].tLogs[0].startVersion);
															#line 2495 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
									modifiedLogSets++;
															#line 5482 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
								}
								break;
							}
						}
															#line 2500 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						if (!found)
															#line 5489 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						{
															#line 2501 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							modifiedState.oldTLogData.erase(modifiedState.oldTLogData.begin() + i);
															#line 2502 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							removedLogSets++;
															#line 2503 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							i--;
															#line 5497 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
					}
															#line 2506 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					prevState = modifiedState;
															#line 5502 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
				else
				{
															#line 2508 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					*forceRecovery = false;
															#line 5508 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
			else
			{
															#line 2511 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				*forceRecovery = false;
															#line 5515 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 2513 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "ForcedRecovery", dbgid) .detail("PrimaryLocality", primaryLocality) .detail("RemoteLocality", remoteLocality) .detail("FoundRemote", foundRemote) .detail("ForceRecovery", *forceRecovery) .detail("Modified", modifiedLogSets) .detail("Removed", removedLogSets);
															#line 2520 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int i = 0;i < prevState.tLogs.size();i++) {
															#line 2521 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TraceEvent("ForcedRecoveryTLogs", dbgid) .detail("I", i) .detail("Log", ::describe(prevState.tLogs[i].tLogs)) .detail("Loc", prevState.tLogs[i].locality) .detail("Txs", prevState.txsTags);
															#line 5523 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 2527 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int i = 0;i < prevState.oldTLogData.size();i++) {
															#line 2528 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for(int j = 0;j < prevState.oldTLogData[i].tLogs.size();j++) {
															#line 2529 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					TraceEvent("ForcedRecoveryTLogs", dbgid) .detail("I", i) .detail("J", j) .detail("Log", ::describe(prevState.oldTLogData[i].tLogs[j].tLogs)) .detail("Loc", prevState.oldTLogData[i].tLogs[j].locality) .detail("Txs", prevState.oldTLogData[i].txsTags);
															#line 5531 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 2539 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		CODE_PROBE(true, "Master recovery from pre-existing database");
															#line 2543 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lockResults = std::vector<LogLockInfo>();
															#line 2544 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		allLogServers = std::vector<std::pair<Reference<AsyncVar<OptionalInterface<TLogInterface>>>, Reference<IReplicationPolicy>>>();
															#line 2546 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logServers = std::vector<Reference<LogSet>>();
															#line 2547 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		oldLogData = std::vector<OldLogData>();
															#line 2548 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logFailed = std::vector<std::vector<Reference<AsyncVar<bool>>>>();
															#line 2549 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		failureTrackers = std::vector<Future<Void>>();
															#line 2551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( const CoreTLogSet& coreSet : prevState.tLogs ) {
															#line 2552 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logServers.push_back(makeReference<LogSet>(coreSet));
															#line 2553 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			std::vector<Reference<AsyncVar<bool>>> failed;
															#line 2555 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( const auto& logVar : logServers.back()->logServers ) {
															#line 2556 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				allLogServers.emplace_back(logVar, coreSet.tLogPolicy);
															#line 2557 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				failed.push_back(makeReference<AsyncVar<bool>>());
															#line 2558 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				failureTrackers.push_back(TagPartitionedLogSystem::monitorLog(logVar, failed.back()));
															#line 5563 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 2560 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logFailed.push_back(failed);
															#line 5567 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 2563 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( const auto& oldTlogData : prevState.oldTLogData ) {
															#line 2564 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			oldLogData.emplace_back(oldTlogData);
															#line 2566 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( const auto& logSet : oldLogData.back().tLogs ) {
															#line 2567 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( const auto& logVar : logSet->logServers ) {
															#line 2568 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					allLogServers.emplace_back(logVar, logSet->tLogPolicy);
															#line 5579 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 2572 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		rejoins = TagPartitionedLogSystem::trackRejoins(dbgid, allLogServers, rejoinRequests);
															#line 2574 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lockResults.resize(logServers.size());
															#line 2575 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::set<int8_t> lockedLocalities;
															#line 2576 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		bool foundSpecial = false;
															#line 2577 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logServers.size();i++) {
															#line 2578 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (logServers[i]->locality == tagLocalitySpecial)
															#line 5595 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 2579 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				foundSpecial = true;
															#line 5599 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 2581 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lockedLocalities.insert(logServers[i]->locality);
															#line 2582 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lockResults[i].isCurrent = true;
															#line 2583 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lockResults[i].logSet = logServers[i];
															#line 2584 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int t = 0;t < logServers[i]->logServers.size();t++) {
															#line 2585 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				lockResults[i].replies.push_back(TagPartitionedLogSystem::lockTLog(dbgid, logServers[i]->logServers[t]));
															#line 5611 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 2589 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( auto& old : oldLogData ) {
															#line 2590 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (foundSpecial)
															#line 5618 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
				break;
			}
															#line 2593 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& log : old.tLogs ) {
															#line 2594 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (log->locality == tagLocalitySpecial)
															#line 5626 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2595 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					foundSpecial = true;
															#line 5630 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					break;
				}
															#line 2598 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (!lockedLocalities.contains(log->locality))
															#line 5635 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2599 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					TraceEvent("EpochEndLockExtra").detail("Locality", log->locality);
															#line 2600 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					CODE_PROBE(true, "locking old generations for version information");
															#line 2601 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					lockedLocalities.insert(log->locality);
															#line 2602 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					LogLockInfo lockResult;
															#line 2603 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					lockResult.epochEnd = old.epochEnd;
															#line 2604 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					lockResult.logSet = log;
															#line 2605 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for(int t = 0;t < log->logServers.size();t++) {
															#line 2606 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						lockResult.replies.push_back(TagPartitionedLogSystem::lockTLog(dbgid, log->logServers[t]));
															#line 5653 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
															#line 2608 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					lockResults.push_back(lockResult);
															#line 5657 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 2612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (*forceRecovery)
															#line 5663 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2613 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			allLockResults = std::vector<LogLockInfo>();
															#line 2614 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			ASSERT(lockResults.size() == 1);
															#line 2615 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			allLockResults.push_back(lockResults[0]);
															#line 2616 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& old : oldLogData ) {
															#line 2617 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				ASSERT(old.tLogs.size() == 1);
															#line 2618 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				LogLockInfo lockResult;
															#line 2619 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				lockResult.epochEnd = old.epochEnd;
															#line 2620 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				lockResult.logSet = old.tLogs[0];
															#line 2621 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for(int t = 0;t < old.tLogs[0]->logServers.size();t++) {
															#line 2622 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					lockResult.replies.push_back(TagPartitionedLogSystem::lockTLog(dbgid, old.tLogs[0]->logServers[t]));
															#line 5685 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 2624 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				allLockResults.push_back(lockResult);
															#line 5689 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 2626 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lockNum = 0;
															#line 2627 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			maxRecoveryVersion = 0;
															#line 2628 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			maxRecoveryIndex = 0;
															#line 2629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 5699 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2427 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 5713 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2427 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 5721 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->ActorCallback< TagPartitionedLogSystem_EpochEndActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2662 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lastEnd = Optional<Version>();
															#line 2663 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		knownCommittedVersion = 0;
															#line 2664 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lastKnownLockedTLogIds = std::map<uint8_t, std::vector<uint16_t>>();
															#line 2665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		knownLockedTLogIdsChanged = false;
															#line 2666 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		;
															#line 5812 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont39(int loopDepth) 
	{
															#line 2645 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (maxRecoveryIndex > 0)
															#line 5821 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2646 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logServers = oldLogData[maxRecoveryIndex - 1].tLogs;
															#line 2647 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			prevState.txsTags = oldLogData[maxRecoveryIndex - 1].txsTags;
															#line 2648 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lockResults[0] = allLockResults[maxRecoveryIndex];
															#line 2649 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lockResults[0].isCurrent = true;
															#line 2651 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			std::vector<Reference<AsyncVar<bool>>> failed;
															#line 2652 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& log : logServers[0]->logServers ) {
															#line 2653 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				failed.push_back(makeReference<AsyncVar<bool>>());
															#line 2654 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				failureTrackers.push_back(TagPartitionedLogSystem::monitorLog(log, failed.back()));
															#line 5839 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 2656 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			ASSERT(logFailed.size() == 1);
															#line 2657 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logFailed[0] = failed;
															#line 2658 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			oldLogData.erase(oldLogData.begin(), oldLogData.begin() + maxRecoveryIndex);
															#line 5847 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!(lockNum < allLockResults.size()))
															#line 5864 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2631 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		auto durableVersionInfo = TagPartitionedLogSystem::getDurableVersion(dbgid, allLockResults[lockNum]);
															#line 2632 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (durableVersionInfo.present())
															#line 5872 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2633 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (durableVersionInfo.get().minimumDurableVersion > maxRecoveryVersion)
															#line 5876 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 2634 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TraceEvent("HigherRecoveryVersion", dbgid) .detail("Idx", lockNum) .detail("Ver", durableVersionInfo.get().minimumDurableVersion);
															#line 2637 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				maxRecoveryVersion = durableVersionInfo.get().minimumDurableVersion;
															#line 2638 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				maxRecoveryIndex = lockNum;
															#line 5884 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 2640 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lockNum++;
															#line 5888 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 2642 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = TagPartitionedLogSystem::getDurableVersionChanged(allLockResults[lockNum]);
															#line 2642 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5897 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state = 2;
															#line 2642 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_EpochEndActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)));
															#line 5902 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont39(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->ActorCallback< TagPartitionedLogSystem_EpochEndActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 2667 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version minEnd = std::numeric_limits<Version>::max();
															#line 2668 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version minDV = std::numeric_limits<Version>::max();
															#line 2669 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version maxEnd = 0;
															#line 2670 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		changes = std::vector<Future<Void>>();
															#line 2671 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logGroupResults = std::vector<std::tuple<int, std::vector<TLogLockResult>, bool>>();
															#line 2672 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		currentKnownLockedTLogIds = std::map<uint8_t, std::vector<uint16_t>>();
															#line 2673 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int log = 0;log < logServers.size();log++) {
															#line 2674 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!logServers[log]->isLocal)
															#line 6039 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
				continue;
			}
															#line 2677 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			auto durableVersionInfo = TagPartitionedLogSystem::getDurableVersion(dbgid, lockResults[log], logFailed[log], lastEnd);
															#line 2679 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (durableVersionInfo.present())
															#line 6047 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 2680 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logGroupResults.emplace_back(logServers[log]->tLogReplicationFactor, durableVersionInfo.get().lockResults, durableVersionInfo.get().policyResult);
															#line 2683 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				currentKnownLockedTLogIds[log] = std::move(durableVersionInfo.get().knownLockedTLogIds);
															#line 2684 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				minDV = std::min(minDV, durableVersionInfo.get().minimumDurableVersion);
															#line 2685 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (!SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST)
															#line 6057 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2686 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					knownCommittedVersion = std::max(knownCommittedVersion, durableVersionInfo.get().knownCommittedVersion);
															#line 2688 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					maxEnd = std::max(maxEnd, durableVersionInfo.get().minimumDurableVersion);
															#line 2689 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					minEnd = std::min(minEnd, durableVersionInfo.get().minimumDurableVersion);
															#line 6065 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
				else
				{
															#line 2691 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					auto unicastVersions = getRecoverVersionUnicast(logServers, logGroupResults.back(), minDV);
															#line 2692 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					knownCommittedVersion = std::max(knownCommittedVersion, std::get<0>(unicastVersions.get()));
															#line 2693 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					maxEnd = std::max(maxEnd, std::get<1>(unicastVersions.get()));
															#line 2694 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					minEnd = std::min(minEnd, std::get<1>(unicastVersions.get()));
															#line 6077 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 2697 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			changes.push_back(TagPartitionedLogSystem::getDurableVersionChanged(lockResults[log], logFailed[log]));
															#line 6082 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 2699 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR_TLOG_UNICAST && maxEnd > 0 && lastEnd.present() && maxEnd >= lastEnd.get())
															#line 6086 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2703 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			knownLockedTLogIdsChanged = !isSubset(lastKnownLockedTLogIds, currentKnownLockedTLogIds);
															#line 2704 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (knownLockedTLogIdsChanged)
															#line 6092 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 2706 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TraceEvent("KnownLockedTLogIdsChanged") .detail("LastKnownLockedTLogIdCount", lastKnownLockedTLogIds.size()) .detail("CurrentKnownLockedTLogIdCount", currentKnownLockedTLogIds.size());
															#line 6096 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 2711 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (maxEnd > 0 && (!lastEnd.present() || maxEnd < lastEnd.get() || knownLockedTLogIdsChanged))
															#line 6101 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2712 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			CODE_PROBE(lastEnd.present(), "Restarting recovery at an earlier point");
															#line 2714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem = makeReference<TagPartitionedLogSystem>(dbgid, locality, prevState.recoveryCount);
															#line 2717 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->recoverAt = minEnd;
															#line 2718 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastEnd = minEnd;
															#line 2719 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs = logServers;
															#line 2720 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->logRouterTags = prevState.logRouterTags;
															#line 2721 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->txsTags = prevState.txsTags;
															#line 2722 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->oldLogData = oldLogData;
															#line 2723 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->logSystemType = prevState.logSystemType;
															#line 2724 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->rejoins = rejoins;
															#line 2725 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->lockResults = lockResults;
															#line 2726 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->knownLockedTLogIds = currentKnownLockedTLogIds;
															#line 2727 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastKnownLockedTLogIds = std::move(currentKnownLockedTLogIds);
															#line 2728 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			currentKnownLockedTLogIds.clear();
															#line 2729 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (knownCommittedVersion > minEnd)
															#line 6133 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 2730 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				knownCommittedVersion = minEnd;
															#line 6137 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 2732 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->knownCommittedVersion = knownCommittedVersion;
															#line 2733 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent(SevDebug, "FinalRecoveryVersionInfo") .detail("KCV", knownCommittedVersion) .detail("MinEnd", minEnd);
															#line 2736 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteLogsWrittenToCoreState = true;
															#line 2737 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->stopped = true;
															#line 2738 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->pseudoLocalities = prevState.pseudoLocalities;
															#line 2739 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			outLogSystem->set(logSystem);
															#line 6151 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 2742 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAny(changes);
															#line 2742 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6157 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state = 3;
															#line 2742 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_EpochEndActor, 2, Void >*>(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)));
															#line 6162 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->ActorCallback< TagPartitionedLogSystem_EpochEndActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_EpochEndActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<AsyncVar<Reference<ILogSystem>>> outLogSystem;
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	UID dbgid;
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	DBCoreState prevState;
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	FutureStream<TLogRejoinRequest> rejoinRequests;
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	LocalityData locality;
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	bool* forceRecovery;
															#line 2543 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<LogLockInfo> lockResults;
															#line 2544 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<std::pair<Reference<AsyncVar<OptionalInterface<TLogInterface>>>, Reference<IReplicationPolicy>>> allLogServers;
															#line 2546 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Reference<LogSet>> logServers;
															#line 2547 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<OldLogData> oldLogData;
															#line 2548 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<std::vector<Reference<AsyncVar<bool>>>> logFailed;
															#line 2549 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<Void>> failureTrackers;
															#line 2572 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<Void> rejoins;
															#line 2613 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<LogLockInfo> allLockResults;
															#line 2626 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int lockNum;
															#line 2627 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Version maxRecoveryVersion;
															#line 2628 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int maxRecoveryIndex;
															#line 2662 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Optional<Version> lastEnd;
															#line 2663 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Version knownCommittedVersion;
															#line 2664 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::map<uint8_t, std::vector<uint16_t>> lastKnownLockedTLogIds;
															#line 2665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	bool knownLockedTLogIdsChanged;
															#line 2670 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<Void>> changes;
															#line 2671 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<std::tuple<int, std::vector<TLogLockResult>, bool>> logGroupResults;
															#line 2672 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::map<uint8_t, std::vector<uint16_t>> currentKnownLockedTLogIds;
															#line 2714 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<TagPartitionedLogSystem> logSystem;
															#line 6304 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via epochEnd()
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_EpochEndActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_EpochEndActor, 0, Void >, public ActorCallback< TagPartitionedLogSystem_EpochEndActor, 1, Void >, public ActorCallback< TagPartitionedLogSystem_EpochEndActor, 2, Void >, public FastAllocated<TagPartitionedLogSystem_EpochEndActor>, public TagPartitionedLogSystem_EpochEndActorState<TagPartitionedLogSystem_EpochEndActor> {
															#line 6309 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_EpochEndActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_EpochEndActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1932934232142242048UL, 9569463578208975360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_EpochEndActor, 0, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_EpochEndActor, 1, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_EpochEndActor, 2, Void >;
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_EpochEndActor(Reference<AsyncVar<Reference<ILogSystem>>> const& outLogSystem,UID const& dbgid,DBCoreState const& prevState,FutureStream<TLogRejoinRequest> const& rejoinRequests,LocalityData const& locality,bool* const& forceRecovery) 
															#line 6328 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_EpochEndActorState<TagPartitionedLogSystem_EpochEndActor>(outLogSystem, dbgid, prevState, rejoinRequests, locality, forceRecovery),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("epochEnd", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11081320092160990208UL, 7378553252914235392UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_EpochEndActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("epochEnd");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("epochEnd", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_EpochEndActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_EpochEndActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_EpochEndActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::epochEnd( Reference<AsyncVar<Reference<ILogSystem>>> const& outLogSystem, UID const& dbgid, DBCoreState const& prevState, FutureStream<TLogRejoinRequest> const& rejoinRequests, LocalityData const& locality, bool* const& forceRecovery ) {
															#line 2408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_EpochEndActor(outLogSystem, dbgid, prevState, rejoinRequests, locality, forceRecovery));
															#line 6362 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 2745 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 6367 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via recruitOldLogRouters()
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_RecruitOldLogRoutersActor>
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_RecruitOldLogRoutersActorState {
															#line 6373 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_RecruitOldLogRoutersActorState(TagPartitionedLogSystem* const& self,std::vector<WorkerInterface> const& workers,LogEpoch const& recoveryCount,int8_t const& locality,Version const& startVersion,std::vector<LocalityData> const& tLogLocalities,Reference<IReplicationPolicy> const& tLogPolicy,bool const& forRemote) 
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : self(self),
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   workers(workers),
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   locality(locality),
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   startVersion(startVersion),
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   tLogLocalities(tLogLocalities),
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   tLogPolicy(tLogPolicy),
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   forRemote(forRemote),
															#line 2754 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   logRouterInitializationReplies(),
															#line 2755 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   allReplies()
															#line 6398 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("recruitOldLogRouters", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_RecruitOldLogRoutersActorState() 
	{
		fdb_probe_actor_destroy("recruitOldLogRouters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2756 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			int nextRouter = 0;
															#line 2757 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastStart = std::numeric_limits<Version>::max();
															#line 2759 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!forRemote)
															#line 6417 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 2760 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				Version maxStart = TagPartitionedLogSystem::getMaxLocalStartVersion(self->tLogs);
															#line 2762 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				lastStart = std::max(startVersion, maxStart);
															#line 2763 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (self->logRouterTags == 0)
															#line 6425 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2764 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					ASSERT_WE_THINK(false);
															#line 2765 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					self->logSystemConfigChanged.trigger();
															#line 2766 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (!static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_RecruitOldLogRoutersActorState(); static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->destroy(); return 0; }
															#line 6433 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					new (&static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~TagPartitionedLogSystem_RecruitOldLogRoutersActorState();
					static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2769 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				bool found = false;
															#line 2770 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& tLogs : self->tLogs ) {
															#line 2771 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (tLogs->locality == locality)
															#line 6445 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 2772 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						found = true;
															#line 6449 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
															#line 2775 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					tLogs->logRouters.clear();
															#line 6453 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 2778 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (!found)
															#line 6457 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2779 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					TraceEvent("RecruitingOldLogRoutersAddingLocality") .detail("Locality", locality) .detail("LastStart", lastStart);
															#line 2782 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					auto newLogSet = makeReference<LogSet>();
															#line 2783 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					newLogSet->locality = locality;
															#line 2784 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					newLogSet->startVersion = lastStart;
															#line 2785 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					newLogSet->isLocal = false;
															#line 2786 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					self->tLogs.push_back(newLogSet);
															#line 6471 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 2789 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& tLogs : self->tLogs ) {
															#line 2791 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (tLogs->locality == locality)
															#line 6477 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 2792 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						logRouterInitializationReplies.emplace_back();
															#line 2793 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						TraceEvent("LogRouterInitReqSent1") .detail("Locality", locality) .detail("LogRouterTags", self->logRouterTags);
															#line 2796 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						for(int i = 0;i < self->logRouterTags;i++) {
															#line 2797 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							InitializeLogRouterRequest req;
															#line 2798 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.recoveryCount = recoveryCount;
															#line 2799 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.routerTag = Tag(tagLocalityLogRouter, i);
															#line 2800 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.startVersion = lastStart;
															#line 2801 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.tLogLocalities = tLogLocalities;
															#line 2802 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.tLogPolicy = tLogPolicy;
															#line 2803 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.locality = locality;
															#line 2804 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.recoverAt = self->recoverAt.get();
															#line 2805 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.knownLockedTLogIds = self->knownLockedTLogIds;
															#line 2806 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.allowDropInSim = !forRemote;
															#line 2807 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							auto reply = transformErrors( throwErrorOr(workers[nextRouter].logRouter.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed());
															#line 2811 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							logRouterInitializationReplies.back().push_back(reply);
															#line 2812 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							allReplies.push_back(reply);
															#line 2813 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							nextRouter = (nextRouter + 1) % workers.size();
															#line 6513 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
					}
				}
			}
															#line 2819 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& old : self->oldLogData ) {
															#line 2820 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				Version maxStart = TagPartitionedLogSystem::getMaxLocalStartVersion(old.tLogs);
															#line 2822 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (old.logRouterTags == 0 || maxStart >= lastStart)
															#line 6524 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
					break;
				}
															#line 2825 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				lastStart = std::max(startVersion, maxStart);
															#line 2826 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				bool found = false;
															#line 2827 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& tLogs : old.tLogs ) {
															#line 2828 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (tLogs->locality == locality)
															#line 6536 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 2829 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						found = true;
															#line 6540 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
															#line 2831 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					tLogs->logRouters.clear();
															#line 6544 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 2834 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (!found)
															#line 6548 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2835 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					TraceEvent("RecruitingOldLogRoutersAddingLocality") .detail("Locality", locality) .detail("LastStart", lastStart);
															#line 2838 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					auto newLogSet = makeReference<LogSet>();
															#line 2839 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					newLogSet->locality = locality;
															#line 2840 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					newLogSet->startVersion = lastStart;
															#line 2841 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					old.tLogs.push_back(newLogSet);
															#line 6560 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 2844 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& tLogs : old.tLogs ) {
															#line 2846 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (tLogs->locality == locality)
															#line 6566 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 2847 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						logRouterInitializationReplies.emplace_back();
															#line 2848 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						TraceEvent("LogRouterInitReqSent2") .detail("Locality", locality) .detail("LogRouterTags", old.logRouterTags);
															#line 2851 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						for(int i = 0;i < old.logRouterTags;i++) {
															#line 2852 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							InitializeLogRouterRequest req;
															#line 2853 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.recoveryCount = recoveryCount;
															#line 2854 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.routerTag = Tag(tagLocalityLogRouter, i);
															#line 2855 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.startVersion = lastStart;
															#line 2856 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.tLogLocalities = tLogLocalities;
															#line 2857 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.tLogPolicy = tLogPolicy;
															#line 2858 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.locality = locality;
															#line 2859 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.recoverAt = old.recoverAt;
															#line 2860 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							req.allowDropInSim = !forRemote;
															#line 2861 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							auto reply = transformErrors( throwErrorOr(workers[nextRouter].logRouter.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed());
															#line 2865 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							logRouterInitializationReplies.back().push_back(reply);
															#line 2866 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							allReplies.push_back(reply);
															#line 2867 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							nextRouter = (nextRouter + 1) % workers.size();
															#line 6600 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
					}
				}
			}
															#line 2873 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_0 = traceAfter(waitForAll(allReplies), "AllLogRouterRepliesReceived");
															#line 2873 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6609 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state = 1;
															#line 2873 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)));
															#line 6614 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_RecruitOldLogRoutersActorState();
		static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2875 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		int nextReplies = 0;
															#line 2876 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lastStart = std::numeric_limits<Version>::max();
															#line 2877 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Future<Void>> failed;
															#line 2879 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!forRemote)
															#line 6643 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2880 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			Version maxStart = TagPartitionedLogSystem::getMaxLocalStartVersion(self->tLogs);
															#line 2882 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastStart = std::max(startVersion, maxStart);
															#line 2883 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& tLogs : self->tLogs ) {
															#line 2884 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (tLogs->locality == locality)
															#line 6653 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2885 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for(int i = 0;i < logRouterInitializationReplies[nextReplies].size();i++) {
															#line 2886 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						tLogs->logRouters.push_back(makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(logRouterInitializationReplies[nextReplies][i].get())));
															#line 2888 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						failed.push_back( waitFailureClient(logRouterInitializationReplies[nextReplies][i].get().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 6661 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
															#line 2894 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					nextReplies++;
															#line 6665 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 2899 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( auto& old : self->oldLogData ) {
															#line 2900 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			Version maxStart = TagPartitionedLogSystem::getMaxLocalStartVersion(old.tLogs);
															#line 2901 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (old.logRouterTags == 0 || maxStart >= lastStart)
															#line 6675 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
				break;
			}
															#line 2904 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastStart = std::max(startVersion, maxStart);
															#line 2905 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& tLogs : old.tLogs ) {
															#line 2906 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (tLogs->locality == locality)
															#line 6685 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2907 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for(int i = 0;i < logRouterInitializationReplies[nextReplies].size();i++) {
															#line 2908 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						tLogs->logRouters.push_back(makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(logRouterInitializationReplies[nextReplies][i].get())));
															#line 2910 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						if (!forRemote)
															#line 6693 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						{
															#line 2911 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							failed.push_back(waitFailureClient( logRouterInitializationReplies[nextReplies][i].get().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 6697 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
					}
															#line 2918 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					nextReplies++;
															#line 6702 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 2923 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!forRemote)
															#line 6708 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2924 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->logSystemConfigChanged.trigger();
															#line 2925 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = failed.size() ? tagError<Void>(quorum(failed, 1), tlog_failed()) : Future<Void>(Never());
															#line 2925 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6716 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state = 2;
															#line 2925 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)));
															#line 6721 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont18(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2875 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		int nextReplies = 0;
															#line 2876 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lastStart = std::numeric_limits<Version>::max();
															#line 2877 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Future<Void>> failed;
															#line 2879 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!forRemote)
															#line 6741 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2880 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			Version maxStart = TagPartitionedLogSystem::getMaxLocalStartVersion(self->tLogs);
															#line 2882 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastStart = std::max(startVersion, maxStart);
															#line 2883 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& tLogs : self->tLogs ) {
															#line 2884 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (tLogs->locality == locality)
															#line 6751 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2885 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for(int i = 0;i < logRouterInitializationReplies[nextReplies].size();i++) {
															#line 2886 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						tLogs->logRouters.push_back(makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(logRouterInitializationReplies[nextReplies][i].get())));
															#line 2888 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						failed.push_back( waitFailureClient(logRouterInitializationReplies[nextReplies][i].get().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 6759 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
															#line 2894 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					nextReplies++;
															#line 6763 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 2899 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( auto& old : self->oldLogData ) {
															#line 2900 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			Version maxStart = TagPartitionedLogSystem::getMaxLocalStartVersion(old.tLogs);
															#line 2901 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (old.logRouterTags == 0 || maxStart >= lastStart)
															#line 6773 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
				break;
			}
															#line 2904 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastStart = std::max(startVersion, maxStart);
															#line 2905 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& tLogs : old.tLogs ) {
															#line 2906 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (tLogs->locality == locality)
															#line 6783 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 2907 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for(int i = 0;i < logRouterInitializationReplies[nextReplies].size();i++) {
															#line 2908 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						tLogs->logRouters.push_back(makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(logRouterInitializationReplies[nextReplies][i].get())));
															#line 2910 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						if (!forRemote)
															#line 6791 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						{
															#line 2911 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							failed.push_back(waitFailureClient( logRouterInitializationReplies[nextReplies][i].get().waitFailure, SERVER_KNOBS->TLOG_TIMEOUT, -SERVER_KNOBS->TLOG_TIMEOUT / SERVER_KNOBS->SECONDS_BEFORE_NO_FAILURE_DELAY, true));
															#line 6795 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
					}
															#line 2918 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					nextReplies++;
															#line 6800 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
		}
															#line 2923 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!forRemote)
															#line 6806 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2924 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			self->logSystemConfigChanged.trigger();
															#line 2925 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = failed.size() ? tagError<Void>(quorum(failed, 1), tlog_failed()) : Future<Void>(Never());
															#line 2925 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6814 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state = 2;
															#line 2925 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)));
															#line 6819 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont18(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont18(int loopDepth) 
	{
															#line 2928 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_RecruitOldLogRoutersActorState(); static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->destroy(); return 0; }
															#line 6908 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagPartitionedLogSystem_RecruitOldLogRoutersActorState();
		static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont29(Void const& _,int loopDepth) 
	{
															#line 2926 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 6920 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont29(Void && _,int loopDepth) 
	{
															#line 2926 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 6928 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont29(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont29(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem* self;
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<WorkerInterface> workers;
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	LogEpoch recoveryCount;
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int8_t locality;
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Version startVersion;
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<LocalityData> tLogLocalities;
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<IReplicationPolicy> tLogPolicy;
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	bool forRemote;
															#line 2754 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<std::vector<Future<TLogInterface>>> logRouterInitializationReplies;
															#line 2755 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<TLogInterface>> allReplies;
															#line 2757 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Version lastStart;
															#line 7029 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via recruitOldLogRouters()
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_RecruitOldLogRoutersActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 0, Void >, public ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >, public FastAllocated<TagPartitionedLogSystem_RecruitOldLogRoutersActor>, public TagPartitionedLogSystem_RecruitOldLogRoutersActorState<TagPartitionedLogSystem_RecruitOldLogRoutersActor> {
															#line 7034 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_RecruitOldLogRoutersActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_RecruitOldLogRoutersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11937135046144952832UL, 9417907141752964096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 0, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >;
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_RecruitOldLogRoutersActor(TagPartitionedLogSystem* const& self,std::vector<WorkerInterface> const& workers,LogEpoch const& recoveryCount,int8_t const& locality,Version const& startVersion,std::vector<LocalityData> const& tLogLocalities,Reference<IReplicationPolicy> const& tLogPolicy,bool const& forRemote) 
															#line 7052 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_RecruitOldLogRoutersActorState<TagPartitionedLogSystem_RecruitOldLogRoutersActor>(self, workers, recoveryCount, locality, startVersion, tLogLocalities, tLogPolicy, forRemote),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17256760151717580288UL, 10806901244344398592UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_RecruitOldLogRoutersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitOldLogRouters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitOldLogRouters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_RecruitOldLogRoutersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::recruitOldLogRouters( TagPartitionedLogSystem* const& self, std::vector<WorkerInterface> const& workers, LogEpoch const& recoveryCount, int8_t const& locality, Version const& startVersion, std::vector<LocalityData> const& tLogLocalities, Reference<IReplicationPolicy> const& tLogPolicy, bool const& forRemote ) {
															#line 2746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_RecruitOldLogRoutersActor(self, workers, recoveryCount, locality, startVersion, tLogLocalities, tLogPolicy, forRemote));
															#line 7085 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 2930 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

Version TagPartitionedLogSystem::getMaxLocalStartVersion(const std::vector<Reference<LogSet>>& tLogs) {
	Version maxStart = 0;
	for (const auto& logSet : tLogs) {
		if (logSet->isLocal) {
			maxStart = std::max(maxStart, logSet->startVersion);
		}
	}
	return maxStart;
}

std::vector<Tag> TagPartitionedLogSystem::getLocalTags(int8_t locality, const std::vector<Tag>& allTags) {
	std::vector<Tag> localTags;
	for (const auto& tag : allTags) {
		if (locality == tagLocalitySpecial || locality == tag.locality || tag.locality < 0) {
			localTags.push_back(tag);
		}
	}
	return localTags;
}

															#line 7110 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via newRemoteEpoch()
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_NewRemoteEpochActor>
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_NewRemoteEpochActorState {
															#line 7116 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_NewRemoteEpochActorState(TagPartitionedLogSystem* const& self,Reference<TagPartitionedLogSystem> const& oldLogSystem,Future<RecruitRemoteFromConfigurationReply> const& fRemoteWorkers,DatabaseConfiguration const& configuration,LogEpoch const& recoveryCount,Version const& recoveryTransactionVersion,int8_t const& remoteLocality,std::vector<Tag> const& allTags,std::vector<Version> const& oldGenerationRecoverAtVersions) 
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : self(self),
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   oldLogSystem(oldLogSystem),
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   fRemoteWorkers(fRemoteWorkers),
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   configuration(configuration),
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   recoveryTransactionVersion(recoveryTransactionVersion),
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   remoteLocality(remoteLocality),
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   allTags(allTags),
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   oldGenerationRecoverAtVersions(oldGenerationRecoverAtVersions)
															#line 7139 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("newRemoteEpoch", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_NewRemoteEpochActorState() 
	{
		fdb_probe_actor_destroy("newRemoteEpoch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2960 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("RemoteLogRecruitment_WaitingForWorkers").log();
															#line 2961 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<RecruitRemoteFromConfigurationReply> __when_expr_0 = fRemoteWorkers;
															#line 2961 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7158 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state = 1;
															#line 2961 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 0, RecruitRemoteFromConfigurationReply >*>(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)));
															#line 7163 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_NewRemoteEpochActorState();
		static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2962 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("RecruitedRemoteLogWorkers") .detail("TLogs", remoteWorkers.remoteTLogs.size()) .detail("LogRouter", remoteWorkers.logRouters.size());
															#line 2966 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet = Reference<LogSet>(new LogSet());
															#line 2967 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->tLogReplicationFactor = configuration.getRemoteTLogReplicationFactor();
															#line 2968 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->tLogVersion = configuration.tLogVersion;
															#line 2969 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->tLogPolicy = configuration.getRemoteTLogPolicy();
															#line 2970 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->isLocal = false;
															#line 2971 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->locality = remoteLocality;
															#line 2973 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->startVersion = oldLogSystem->knownCommittedVersion + 1;
															#line 2974 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lockNum = 0;
															#line 2975 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		;
															#line 7204 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RecruitRemoteFromConfigurationReply const& __remoteWorkers,int loopDepth) 
	{
															#line 2961 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		remoteWorkers = __remoteWorkers;
															#line 7213 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RecruitRemoteFromConfigurationReply && __remoteWorkers,int loopDepth) 
	{
		remoteWorkers = std::move(__remoteWorkers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 0, RecruitRemoteFromConfigurationReply >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 0, RecruitRemoteFromConfigurationReply >*,RecruitRemoteFromConfigurationReply const& value) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 0, RecruitRemoteFromConfigurationReply >*,RecruitRemoteFromConfigurationReply && value) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 0, RecruitRemoteFromConfigurationReply >*,Error err) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2994 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<LocalityData> localities;
															#line 2995 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		localities.resize(remoteWorkers.remoteTLogs.size());
															#line 2996 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < remoteWorkers.remoteTLogs.size();i++) {
															#line 2997 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			localities[i] = remoteWorkers.remoteTLogs[i].locality;
															#line 7298 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3000 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		oldRouterRecruitment = Void();
															#line 3001 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (logSet->startVersion < oldLogSystem->knownCommittedVersion + 1)
															#line 7304 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3002 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			ASSERT(oldLogSystem->logRouterTags > 0);
															#line 3003 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			oldRouterRecruitment = TagPartitionedLogSystem::recruitOldLogRouters(self, remoteWorkers.logRouters, recoveryCount, remoteLocality, logSet->startVersion, localities, logSet->tLogPolicy, true);
															#line 7310 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3013 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logRouterInitializationReplies = std::vector<Future<TLogInterface>>();
															#line 3014 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		const Version startVersion = oldLogSystem->logRouterTags == 0 ? oldLogSystem->recoverAt.get() + 1 : std::max(self->tLogs[0]->startVersion, logSet->startVersion);
															#line 3017 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("LogRouterInitReqSent3").detail("Locality", remoteLocality).detail("LogRouterTags", self->logRouterTags);
															#line 3018 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < self->logRouterTags;i++) {
															#line 3019 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			InitializeLogRouterRequest req;
															#line 3020 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recoveryCount = recoveryCount;
															#line 3021 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.routerTag = Tag(tagLocalityLogRouter, i);
															#line 3022 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.startVersion = startVersion;
															#line 3023 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.tLogLocalities = localities;
															#line 3024 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.tLogPolicy = logSet->tLogPolicy;
															#line 3025 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.locality = remoteLocality;
															#line 3026 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.allowDropInSim = false;
															#line 3027 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("RemoteTLogRouterReplies", self->dbgid) .detail("WorkerID", remoteWorkers.logRouters[i % remoteWorkers.logRouters.size()].id());
															#line 3029 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logRouterInitializationReplies.push_back(transformErrors( throwErrorOr( remoteWorkers.logRouters[i % remoteWorkers.logRouters.size()].logRouter.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 7340 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3036 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Tag> localTags = TagPartitionedLogSystem::getLocalTags(remoteLocality, allTags);
															#line 3037 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		LogSystemConfig oldLogSystemConfig = oldLogSystem->getLogSystemConfig();
															#line 3039 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->tLogLocalities.resize(remoteWorkers.remoteTLogs.size());
															#line 3040 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->logServers.resize( remoteWorkers.remoteTLogs .size());
															#line 3043 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSet->updateLocalitySet(localities);
															#line 3045 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		remoteTLogInitializationReplies = std::vector<Future<TLogInterface>>();
															#line 3046 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<InitializeTLogRequest> remoteTLogReqs(remoteWorkers.remoteTLogs.size());
															#line 3047 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		allRemoteTLogServers = std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>>();
															#line 3049 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (oldLogSystem->logRouterTags == 0)
															#line 7360 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3050 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			std::vector<int> locations;
															#line 3051 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( Tag tag : localTags ) {
															#line 3052 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				locations.clear();
															#line 3053 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSet->getPushLocations(VectorRef<Tag>(&tag, 1), locations, 0);
															#line 3054 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( int loc : locations ) {
															#line 3055 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					remoteTLogReqs[loc].recoverTags.push_back(tag);
															#line 7374 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 3059 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (oldLogSystem->tLogs.size())
															#line 7379 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3060 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				int maxTxsTags = oldLogSystem->txsTags;
															#line 3061 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& it : oldLogSystem->oldLogData ) {
															#line 3062 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					maxTxsTags = std::max<int>(maxTxsTags, it.txsTags);
															#line 7387 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 3064 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for(int i = 0;i < maxTxsTags;i++) {
															#line 3065 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					Tag tag = Tag(tagLocalityTxs, i);
															#line 3066 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					Tag pushTag = Tag(tagLocalityTxs, i % self->txsTags);
															#line 3067 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					locations.clear();
															#line 3068 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSet->getPushLocations(VectorRef<Tag>(&pushTag, 1), locations, 0);
															#line 3069 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for( int loc : locations ) {
															#line 3070 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						remoteTLogReqs[loc].recoverTags.push_back(tag);
															#line 7403 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
				}
			}
		}
															#line 3076 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (oldLogSystem->tLogs.size())
															#line 7410 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3077 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int i = 0;i < self->txsTags;i++) {
															#line 3078 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				localTags.push_back(Tag(tagLocalityTxs, i));
															#line 7416 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 3082 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < remoteWorkers.remoteTLogs.size();i++) {
															#line 3083 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			InitializeTLogRequest& req = remoteTLogReqs[i];
															#line 3084 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recruitmentID = self->recruitmentID;
															#line 3085 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.logVersion = configuration.tLogVersion;
															#line 3086 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.storeType = configuration.tLogDataStoreType;
															#line 3087 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.spillType = configuration.tLogSpillType;
															#line 3088 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recoverFrom = oldLogSystemConfig;
															#line 3089 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recoverAt = oldLogSystem->recoverAt.get();
															#line 3090 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.knownCommittedVersion = oldLogSystem->knownCommittedVersion;
															#line 3091 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.epoch = recoveryCount;
															#line 3092 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.remoteTag = Tag(tagLocalityRemoteLog, i);
															#line 3093 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.locality = remoteLocality;
															#line 3094 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.isPrimary = false;
															#line 3095 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.allTags = localTags;
															#line 3096 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.startVersion = logSet->startVersion;
															#line 3097 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.logRouterTags = 0;
															#line 3098 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.txsTags = self->txsTags;
															#line 3099 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recoveryTransactionVersion = recoveryTransactionVersion;
															#line 3100 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.oldGenerationRecoverAtVersions = oldGenerationRecoverAtVersions;
															#line 7457 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3103 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		remoteTLogInitializationReplies.reserve(remoteWorkers.remoteTLogs.size());
															#line 3104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < remoteWorkers.remoteTLogs.size();i++) {
															#line 3105 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("RemoteTLogInitReqSent", self->dbgid).detail("WorkerID", remoteWorkers.remoteTLogs[i].id());
															#line 3106 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			remoteTLogInitializationReplies.push_back(transformErrors( throwErrorOr(remoteWorkers.remoteTLogs[i].tLog.getReplyUnlessFailedFor( remoteTLogReqs[i], SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 7467 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("RemoteLogRecruitment_InitializingRemoteLogs") .detail("StartVersion", logSet->startVersion) .detail("LocalStart", self->tLogs[0]->startVersion) .detail("LogRouterTags", self->logRouterTags);
															#line 3116 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = traceAfter(waitForAll(remoteTLogInitializationReplies), "RemoteTLogInitializationRepliesReceived") && traceAfter(waitForAll(logRouterInitializationReplies), "LogRouterInitializationRepliesReceived") && traceAfter(oldRouterRecruitment, "OldRouterRecruitmentFinished");
															#line 3116 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7475 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state = 3;
															#line 3116 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 2, Void >*>(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)));
															#line 7480 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2975 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!(lockNum < oldLogSystem->lockResults.size()))
															#line 7496 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2976 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (oldLogSystem->lockResults[lockNum].logSet->locality == remoteLocality)
															#line 7502 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2978 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 7506 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2991 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lockNum++;
															#line 7533 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 2979 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		auto durableVersionInfo = TagPartitionedLogSystem::getDurableVersion(self->dbgid, oldLogSystem->lockResults[lockNum]);
															#line 2981 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (durableVersionInfo.present())
															#line 7557 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 2982 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSet->startVersion = std::min(std::min(durableVersionInfo.get().knownCommittedVersion + 1, oldLogSystem->lockResults[lockNum].epochEnd), logSet->startVersion);
															#line 7561 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2987 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = TagPartitionedLogSystem::getDurableVersionChanged(oldLogSystem->lockResults[lockNum]);
															#line 2987 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 7568 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state = 2;
															#line 2987 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)));
															#line 7573 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 3120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logRouterInitializationReplies.size();i++) {
															#line 3121 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSet->logRouters.push_back(makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(logRouterInitializationReplies[i].get())));
															#line 7684 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3125 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < remoteTLogInitializationReplies.size();i++) {
															#line 3126 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSet->logServers[i] = makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(remoteTLogInitializationReplies[i].get()));
															#line 3128 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSet->tLogLocalities[i] = remoteWorkers.remoteTLogs[i].locality;
															#line 7692 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3130 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		filterLocalityDataForPolicy(logSet->tLogPolicy, &logSet->tLogLocalities);
															#line 3132 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Future<Void>> recoveryComplete;
															#line 3133 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		recoveryComplete.reserve(logSet->logServers.size());
															#line 3134 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logSet->logServers.size();i++) {
															#line 3135 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			recoveryComplete.push_back( transformErrors(throwErrorOr(logSet->logServers[i]->get().interf().recoveryFinished.getReplyUnlessFailedFor( TLogRecoveryFinishedRequest(), SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 3141 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			allRemoteTLogServers.push_back(logSet->logServers[i]);
															#line 7706 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3144 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		self->remoteRecoveryComplete = waitForAll(recoveryComplete);
															#line 3145 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		self->remoteTrackTLogRecovery = TagPartitionedLogSystem::trackTLogRecoveryActor(allRemoteTLogServers, self->remoteRecoveredVersion);
															#line 3147 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		self->tLogs.push_back(logSet);
															#line 3148 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("RemoteLogRecruitment_CompletingRecovery").log();
															#line 3149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_NewRemoteEpochActorState(); static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->destroy(); return 0; }
															#line 7718 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagPartitionedLogSystem_NewRemoteEpochActorState();
		static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 3120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logRouterInitializationReplies.size();i++) {
															#line 3121 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSet->logRouters.push_back(makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(logRouterInitializationReplies[i].get())));
															#line 7732 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3125 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < remoteTLogInitializationReplies.size();i++) {
															#line 3126 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSet->logServers[i] = makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(remoteTLogInitializationReplies[i].get()));
															#line 3128 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSet->tLogLocalities[i] = remoteWorkers.remoteTLogs[i].locality;
															#line 7740 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3130 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		filterLocalityDataForPolicy(logSet->tLogPolicy, &logSet->tLogLocalities);
															#line 3132 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Future<Void>> recoveryComplete;
															#line 3133 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		recoveryComplete.reserve(logSet->logServers.size());
															#line 3134 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logSet->logServers.size();i++) {
															#line 3135 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			recoveryComplete.push_back( transformErrors(throwErrorOr(logSet->logServers[i]->get().interf().recoveryFinished.getReplyUnlessFailedFor( TLogRecoveryFinishedRequest(), SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 3141 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			allRemoteTLogServers.push_back(logSet->logServers[i]);
															#line 7754 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3144 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		self->remoteRecoveryComplete = waitForAll(recoveryComplete);
															#line 3145 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		self->remoteTrackTLogRecovery = TagPartitionedLogSystem::trackTLogRecoveryActor(allRemoteTLogServers, self->remoteRecoveredVersion);
															#line 3147 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		self->tLogs.push_back(logSet);
															#line 3148 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("RemoteLogRecruitment_CompletingRecovery").log();
															#line 3149 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TagPartitionedLogSystem_NewRemoteEpochActorState(); static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->destroy(); return 0; }
															#line 7766 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TagPartitionedLogSystem_NewRemoteEpochActorState();
		static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem* self;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<TagPartitionedLogSystem> oldLogSystem;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<RecruitRemoteFromConfigurationReply> fRemoteWorkers;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	DatabaseConfiguration configuration;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	LogEpoch recoveryCount;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Version recoveryTransactionVersion;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int8_t remoteLocality;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Tag> allTags;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Version> oldGenerationRecoverAtVersions;
															#line 2961 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	RecruitRemoteFromConfigurationReply remoteWorkers;
															#line 2966 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<LogSet> logSet;
															#line 2974 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int lockNum;
															#line 3000 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<Void> oldRouterRecruitment;
															#line 3013 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<TLogInterface>> logRouterInitializationReplies;
															#line 3045 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<TLogInterface>> remoteTLogInitializationReplies;
															#line 3047 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>> allRemoteTLogServers;
															#line 7881 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via newRemoteEpoch()
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_NewRemoteEpochActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 0, RecruitRemoteFromConfigurationReply >, public ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 1, Void >, public ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 2, Void >, public FastAllocated<TagPartitionedLogSystem_NewRemoteEpochActor>, public TagPartitionedLogSystem_NewRemoteEpochActorState<TagPartitionedLogSystem_NewRemoteEpochActor> {
															#line 7886 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_NewRemoteEpochActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_NewRemoteEpochActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3891182153705951488UL, 12841920610899877376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 0, RecruitRemoteFromConfigurationReply >;
friend struct ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 1, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 2, Void >;
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_NewRemoteEpochActor(TagPartitionedLogSystem* const& self,Reference<TagPartitionedLogSystem> const& oldLogSystem,Future<RecruitRemoteFromConfigurationReply> const& fRemoteWorkers,DatabaseConfiguration const& configuration,LogEpoch const& recoveryCount,Version const& recoveryTransactionVersion,int8_t const& remoteLocality,std::vector<Tag> const& allTags,std::vector<Version> const& oldGenerationRecoverAtVersions) 
															#line 7905 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_NewRemoteEpochActorState<TagPartitionedLogSystem_NewRemoteEpochActor>(self, oldLogSystem, fRemoteWorkers, configuration, recoveryCount, recoveryTransactionVersion, remoteLocality, allTags, oldGenerationRecoverAtVersions),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newRemoteEpoch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13896894606934614528UL, 882327589372944640UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewRemoteEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newRemoteEpoch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newRemoteEpoch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 0, RecruitRemoteFromConfigurationReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_NewRemoteEpochActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::newRemoteEpoch( TagPartitionedLogSystem* const& self, Reference<TagPartitionedLogSystem> const& oldLogSystem, Future<RecruitRemoteFromConfigurationReply> const& fRemoteWorkers, DatabaseConfiguration const& configuration, LogEpoch const& recoveryCount, Version const& recoveryTransactionVersion, int8_t const& remoteLocality, std::vector<Tag> const& allTags, std::vector<Version> const& oldGenerationRecoverAtVersions ) {
															#line 2951 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_NewRemoteEpochActor(self, oldLogSystem, fRemoteWorkers, configuration, recoveryCount, recoveryTransactionVersion, remoteLocality, allTags, oldGenerationRecoverAtVersions));
															#line 7939 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 3151 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 7944 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via newEpoch()
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_NewEpochActor>
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_NewEpochActorState {
															#line 7950 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_NewEpochActorState(Reference<TagPartitionedLogSystem> const& oldLogSystem,RecruitFromConfigurationReply const& recr,Future<RecruitRemoteFromConfigurationReply> const& fRemoteWorkers,DatabaseConfiguration const& configuration,LogEpoch const& recoveryCount,Version const& recoveryTransactionVersion,int8_t const& primaryLocality,int8_t const& remoteLocality,std::vector<Tag> const& allTags,Reference<AsyncVar<bool>> const& recruitmentStalled) 
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : oldLogSystem(oldLogSystem),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   recr(recr),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   fRemoteWorkers(fRemoteWorkers),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   configuration(configuration),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   recoveryTransactionVersion(recoveryTransactionVersion),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   primaryLocality(primaryLocality),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   remoteLocality(remoteLocality),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   allTags(allTags),
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   recruitmentStalled(recruitmentStalled),
															#line 3163 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   startTime(now()),
															#line 3164 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   logSystem(new TagPartitionedLogSystem(oldLogSystem->getDebugID(), oldLogSystem->locality, recoveryCount))
															#line 7979 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("newEpoch", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_NewEpochActorState() 
	{
		fdb_probe_actor_destroy("newEpoch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3166 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->logSystemType = LogSystemType::tagPartitioned;
															#line 3167 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->expectedLogSets = 1;
															#line 3168 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->recoveredAt = oldLogSystem->recoverAt;
															#line 3169 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->repopulateRegionAntiQuorum = configuration.repopulateRegionAntiQuorum;
															#line 3170 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->recruitmentID = deterministicRandom()->randomUniqueID();
															#line 3171 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->txsTags = configuration.tLogVersion >= TLogVersion::V4 ? recr.tLogs.size() : 0;
															#line 3172 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			oldLogSystem->recruitmentID = logSystem->recruitmentID;
															#line 3174 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (configuration.usableRegions > 1)
															#line 8008 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3175 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->logRouterTags = recr.tLogs.size() * std::max<int>(1, configuration.desiredLogRouterCount / std::max<int>(1, recr.tLogs.size()));
															#line 3178 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->expectedLogSets++;
															#line 3179 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->addPseudoLocality(tagLocalityLogRouterMapped);
															#line 3180 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TraceEvent e("AddPseudoLocality", logSystem->getDebugID());
															#line 3181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				e.detail("Locality1", "LogRouterMapped");
															#line 3182 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (configuration.backupWorkerEnabled)
															#line 8022 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 3183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->addPseudoLocality(tagLocalityBackup);
															#line 3184 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					e.detail("Locality2", "Backup");
															#line 8028 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
			else
			{
															#line 3186 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (configuration.backupWorkerEnabled)
															#line 8035 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 3188 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->logRouterTags = recr.tLogs.size() * std::max<int>(1, configuration.desiredLogRouterCount / std::max<int>(1, recr.tLogs.size()));
															#line 3191 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->addPseudoLocality(tagLocalityBackup);
															#line 3192 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					TraceEvent("AddPseudoLocality", logSystem->getDebugID()).detail("Locality", "Backup");
															#line 8043 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 3195 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs.push_back(makeReference<LogSet>());
															#line 3196 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->tLogVersion = configuration.tLogVersion;
															#line 3197 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->tLogWriteAntiQuorum = configuration.tLogWriteAntiQuorum;
															#line 3198 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->tLogReplicationFactor = configuration.tLogReplicationFactor;
															#line 3199 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->tLogPolicy = configuration.tLogPolicy;
															#line 3200 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->isLocal = true;
															#line 3201 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->locality = primaryLocality;
															#line 3203 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			region = configuration.getRegion(recr.dcId);
															#line 3205 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			maxTxsTags = oldLogSystem->txsTags;
															#line 3206 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( auto& it : oldLogSystem->oldLogData ) {
															#line 3207 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				maxTxsTags = std::max<int>(maxTxsTags, it.txsTags);
															#line 8068 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 3210 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (region.satelliteTLogReplicationFactor > 0 && configuration.usableRegions > 1)
															#line 8072 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3211 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs.push_back(makeReference<LogSet>());
															#line 3212 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (recr.satelliteFallback)
															#line 8078 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				{
															#line 3213 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->tLogWriteAntiQuorum = region.satelliteTLogWriteAntiQuorumFallback;
															#line 3214 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->tLogReplicationFactor = region.satelliteTLogReplicationFactorFallback;
															#line 3215 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->tLogPolicy = region.satelliteTLogPolicyFallback;
															#line 8086 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
				else
				{
															#line 3217 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->tLogWriteAntiQuorum = region.satelliteTLogWriteAntiQuorum;
															#line 3218 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->tLogReplicationFactor = region.satelliteTLogReplicationFactor;
															#line 3219 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->tLogPolicy = region.satelliteTLogPolicy;
															#line 8096 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 3221 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[1]->isLocal = true;
															#line 3222 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[1]->locality = tagLocalitySatellite;
															#line 3223 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[1]->tLogVersion = configuration.tLogVersion;
															#line 3224 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[1]->startVersion = oldLogSystem->knownCommittedVersion + 1;
															#line 3226 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[1]->tLogLocalities.resize(recr.satelliteTLogs.size());
															#line 3227 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for(int i = 0;i < recr.satelliteTLogs.size();i++) {
															#line 3228 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->tLogLocalities[i] = recr.satelliteTLogs[i].locality;
															#line 8112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
															#line 3230 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				filterLocalityDataForPolicy(logSystem->tLogs[1]->tLogPolicy, &logSystem->tLogs[1]->tLogLocalities);
															#line 3232 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[1]->logServers.resize( recr.satelliteTLogs .size());
															#line 3235 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[1]->updateLocalitySet(logSystem->tLogs[1]->tLogLocalities);
															#line 3236 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[1]->populateSatelliteTagLocations( logSystem->logRouterTags, oldLogSystem->logRouterTags, logSystem->txsTags, maxTxsTags);
															#line 3238 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->expectedLogSets++;
															#line 8124 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 3241 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (oldLogSystem->tLogs.size())
															#line 8128 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3242 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData.emplace_back();
															#line 3243 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData[0].tLogs = oldLogSystem->tLogs;
															#line 3244 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData[0].epochBegin = oldLogSystem->tLogs[0]->startVersion;
															#line 3245 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData[0].epochEnd = oldLogSystem->knownCommittedVersion + 1;
															#line 3246 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData[0].recoverAt = oldLogSystem->recoverAt.get();
															#line 3247 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData[0].logRouterTags = oldLogSystem->logRouterTags;
															#line 3248 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData[0].txsTags = oldLogSystem->txsTags;
															#line 3249 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData[0].pseudoLocalities = oldLogSystem->pseudoLocalities;
															#line 3250 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->oldLogData[0].epoch = oldLogSystem->epoch;
															#line 8148 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 3252 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->oldLogData.insert( logSystem->oldLogData.end(), oldLogSystem->oldLogData.begin(), oldLogSystem->oldLogData.end());
															#line 3255 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->startVersion = oldLogSystem->knownCommittedVersion + 1;
															#line 3256 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->backupStartVersion = oldLogSystem->knownCommittedVersion + 1;
															#line 3257 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lockNum = 0;
															#line 3258 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 8160 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_NewEpochActorState();
		static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3282 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<LocalityData> localities;
															#line 3283 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		localities.resize(recr.tLogs.size());
															#line 3284 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < recr.tLogs.size();i++) {
															#line 3285 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			localities[i] = recr.tLogs[i].locality;
															#line 8189 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3288 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		oldRouterRecruitment = Never();
															#line 3289 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("NewEpochStartVersion", oldLogSystem->getDebugID()) .detail("StartVersion", logSystem->tLogs[0]->startVersion) .detail("EpochEnd", oldLogSystem->knownCommittedVersion + 1) .detail("Locality", primaryLocality) .detail("OldLogRouterTags", oldLogSystem->logRouterTags);
															#line 3294 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (oldLogSystem->logRouterTags > 0 || logSystem->tLogs[0]->startVersion < oldLogSystem->knownCommittedVersion + 1)
															#line 8197 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3297 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			oldRouterRecruitment = TagPartitionedLogSystem::recruitOldLogRouters(oldLogSystem.getPtr(), recr.oldLogRouters, recoveryCount, primaryLocality, logSystem->tLogs[0]->startVersion, localities, logSystem->tLogs[0]->tLogPolicy, false);
															#line 3305 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (oldLogSystem->knownCommittedVersion - logSystem->tLogs[0]->startVersion > SERVER_KNOBS->MAX_RECOVERY_VERSIONS)
															#line 8203 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3308 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( auto& lockResult : oldLogSystem->lockResults ) {
															#line 3309 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					if (lockResult.logSet->locality == remoteLocality)
															#line 8209 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					{
															#line 3310 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						if (TagPartitionedLogSystem::getDurableVersion(logSystem->dbgid, lockResult).present())
															#line 8213 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						{
															#line 3311 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
							recruitmentStalled->set(true);
															#line 8217 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
						}
					}
				}
			}
		}
		else
		{
															#line 3317 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			oldLogSystem->logSystemConfigChanged.trigger();
															#line 8227 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3320 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<Tag> localTags = TagPartitionedLogSystem::getLocalTags(primaryLocality, allTags);
															#line 3321 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		oldLogSystemConfig = oldLogSystem->getLogSystemConfig();
															#line 3323 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		primaryTLogReplies = std::vector<Future<TLogInterface>>();
															#line 3324 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<InitializeTLogRequest> reqs(recr.tLogs.size());
															#line 3326 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSystem->tLogs[0]->tLogLocalities.resize(recr.tLogs.size());
															#line 3327 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSystem->tLogs[0]->logServers.resize( recr.tLogs.size());
															#line 3329 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSystem->tLogs[0]->updateLocalitySet(localities);
															#line 3331 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		std::vector<int> locations;
															#line 3332 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( Tag tag : localTags ) {
															#line 3333 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			locations.clear();
															#line 3334 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->getPushLocations(VectorRef<Tag>(&tag, 1), locations, 0);
															#line 3335 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( int loc : locations ) {
															#line 3336 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				reqs[loc].recoverTags.push_back(tag);
															#line 8255 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 3339 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < oldLogSystem->logRouterTags;i++) {
															#line 3340 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			Tag tag = Tag(tagLocalityLogRouter, i);
															#line 3341 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			reqs[logSystem->tLogs[0]->bestLocationFor(tag)].recoverTags.push_back(tag);
															#line 8264 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3344 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (oldLogSystem->tLogs.size())
															#line 8268 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3345 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int i = 0;i < maxTxsTags;i++) {
															#line 3346 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				Tag tag = Tag(tagLocalityTxs, i);
															#line 3347 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				Tag pushTag = Tag(tagLocalityTxs, i % logSystem->txsTags);
															#line 3348 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				locations.clear();
															#line 3349 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logSystem->tLogs[0]->getPushLocations(VectorRef<Tag>(&pushTag, 1), locations, 0);
															#line 3350 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for( int loc : locations ) {
															#line 3351 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					reqs[loc].recoverTags.push_back(tag);
															#line 8284 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 3354 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int i = 0;i < logSystem->txsTags;i++) {
															#line 3355 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				localTags.push_back(Tag(tagLocalityTxs, i));
															#line 8291 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
		}
															#line 3360 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		oldGenerationRecoverAtVersions = std::vector<Version>();
															#line 3361 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( const auto& oldLogGen : logSystem->oldLogData ) {
															#line 3362 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (oldLogGen.recoverAt <= 0)
															#line 8300 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3365 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				oldGenerationRecoverAtVersions.clear();
															#line 3366 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TraceEvent("DisableTrackingOldGenerationRecovery").log();
															#line 8306 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				break;
			}
															#line 3369 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			oldGenerationRecoverAtVersions.push_back(oldLogGen.recoverAt);
															#line 8311 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3372 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < recr.tLogs.size();i++) {
															#line 3373 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			InitializeTLogRequest& req = reqs[i];
															#line 3374 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recruitmentID = logSystem->recruitmentID;
															#line 3375 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.logVersion = configuration.tLogVersion;
															#line 3376 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.storeType = configuration.tLogDataStoreType;
															#line 3377 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.spillType = configuration.tLogSpillType;
															#line 3378 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recoverFrom = oldLogSystemConfig;
															#line 3379 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recoverAt = oldLogSystem->recoverAt.get();
															#line 3380 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.knownCommittedVersion = oldLogSystem->knownCommittedVersion;
															#line 3381 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.epoch = recoveryCount;
															#line 3382 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.locality = primaryLocality;
															#line 3383 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.remoteTag = Tag(tagLocalityRemoteLog, i);
															#line 3384 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.isPrimary = true;
															#line 3385 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.allTags = localTags;
															#line 3386 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.startVersion = logSystem->tLogs[0]->startVersion;
															#line 3387 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.logRouterTags = logSystem->logRouterTags;
															#line 3388 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.txsTags = logSystem->txsTags;
															#line 3389 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.recoveryTransactionVersion = recoveryTransactionVersion;
															#line 3390 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.oldGenerationRecoverAtVersions = oldGenerationRecoverAtVersions;
															#line 8351 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3393 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		primaryTLogReplies.reserve(recr.tLogs.size());
															#line 3394 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < recr.tLogs.size();i++) {
															#line 3395 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("PrimaryTLogInitReqSent", logSystem->getDebugID()).detail("WorkerID", recr.tLogs[i].id());
															#line 3396 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			primaryTLogReplies.push_back(transformErrors( throwErrorOr(recr.tLogs[i].tLog.getReplyUnlessFailedFor( reqs[i], SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 8361 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3402 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		recoveryComplete = std::vector<Future<Void>>();
															#line 3403 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		allTLogServers = std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>>();
															#line 3405 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (region.satelliteTLogReplicationFactor > 0 && configuration.usableRegions > 1)
															#line 8369 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3406 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			satelliteInitializationReplies = std::vector<Future<TLogInterface>>();
															#line 3407 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			std::vector<InitializeTLogRequest> sreqs(recr.satelliteTLogs.size());
															#line 3408 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			std::vector<Tag> satelliteTags;
															#line 3410 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (logSystem->logRouterTags)
															#line 8379 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3411 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for(int i = 0;i < oldLogSystem->logRouterTags;i++) {
															#line 3412 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					Tag tag = Tag(tagLocalityLogRouter, i);
															#line 3418 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					Tag pushLocation = Tag(tagLocalityLogRouter, i % logSystem->logRouterTags);
															#line 3419 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					locations.clear();
															#line 3420 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->getPushLocations(VectorRef<Tag>(&pushLocation, 1), locations, 0);
															#line 3421 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for( int loc : locations ) {
															#line 3422 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						sreqs[loc].recoverTags.push_back(tag);
															#line 8395 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
				}
			}
															#line 3426 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (oldLogSystem->tLogs.size())
															#line 8401 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3427 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for(int i = 0;i < maxTxsTags;i++) {
															#line 3428 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					Tag tag = Tag(tagLocalityTxs, i);
															#line 3429 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					Tag pushTag = Tag(tagLocalityTxs, i % logSystem->txsTags);
															#line 3430 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					locations.clear();
															#line 3431 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					logSystem->tLogs[1]->getPushLocations(VectorRef<Tag>(&pushTag, 1), locations, 0);
															#line 3432 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					for( int loc : locations ) {
															#line 3433 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
						sreqs[loc].recoverTags.push_back(tag);
															#line 8417 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
					}
				}
															#line 3436 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				for(int i = 0;i < logSystem->txsTags;i++) {
															#line 3437 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
					satelliteTags.push_back(Tag(tagLocalityTxs, i));
															#line 8424 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				}
			}
															#line 3441 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int i = 0;i < recr.satelliteTLogs.size();i++) {
															#line 3442 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				InitializeTLogRequest& req = sreqs[i];
															#line 3443 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.recruitmentID = logSystem->recruitmentID;
															#line 3444 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.logVersion = configuration.tLogVersion;
															#line 3445 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.storeType = configuration.tLogDataStoreType;
															#line 3446 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.spillType = configuration.tLogSpillType;
															#line 3447 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.recoverFrom = oldLogSystemConfig;
															#line 3448 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.recoverAt = oldLogSystem->recoverAt.get();
															#line 3449 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.knownCommittedVersion = oldLogSystem->knownCommittedVersion;
															#line 3450 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.epoch = recoveryCount;
															#line 3451 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.locality = tagLocalitySatellite;
															#line 3452 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.remoteTag = Tag();
															#line 3453 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.isPrimary = true;
															#line 3454 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.allTags = satelliteTags;
															#line 3455 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.startVersion = oldLogSystem->knownCommittedVersion + 1;
															#line 3456 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.logRouterTags = logSystem->logRouterTags;
															#line 3457 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.txsTags = logSystem->txsTags;
															#line 3458 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.recoveryTransactionVersion = recoveryTransactionVersion;
															#line 3459 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				req.oldGenerationRecoverAtVersions = oldGenerationRecoverAtVersions;
															#line 8465 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 3462 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			satelliteInitializationReplies.reserve(recr.satelliteTLogs.size());
															#line 3463 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(int i = 0;i < recr.satelliteTLogs.size();i++) {
															#line 3464 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TraceEvent("PrimarySatelliteTLogInitReqSent", logSystem->getDebugID()) .detail("WorkerID", recr.satelliteTLogs[i].id());
															#line 3466 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				satelliteInitializationReplies.push_back(transformErrors( throwErrorOr(recr.satelliteTLogs[i].tLog.getReplyUnlessFailedFor( sreqs[i], SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 8475 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 3472 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			StrictFuture<Void> __when_expr_1 = traceAfter(waitForAll(satelliteInitializationReplies), "SatelliteInitializationRepliesReceived") || traceAfter(oldRouterRecruitment, "OldRouterRecruitmentFinished");
															#line 3472 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8481 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 2;
															#line 3472 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_NewEpochActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)));
															#line 8486 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3258 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!(lockNum < oldLogSystem->lockResults.size()))
															#line 8507 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3259 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (oldLogSystem->lockResults[lockNum].logSet->locality == primaryLocality)
															#line 8513 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3260 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (oldLogSystem->lockResults[lockNum].isCurrent && oldLogSystem->lockResults[lockNum].logSet->isLocal)
															#line 8517 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 3263 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			stalledAfter = setAfter(recruitmentStalled, SERVER_KNOBS->MAX_RECOVERY_TIME, true);
															#line 3264 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 8525 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 3279 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		lockNum++;
															#line 8552 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 3276 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		stalledAfter.cancel();
															#line 8561 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 3265 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		auto durableVersionInfo = TagPartitionedLogSystem::getDurableVersion(logSystem->dbgid, oldLogSystem->lockResults[lockNum]);
															#line 3267 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (durableVersionInfo.present())
															#line 8579 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3268 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->startVersion = std::min(std::min(durableVersionInfo.get().knownCommittedVersion + 1, oldLogSystem->lockResults[lockNum].epochEnd), logSystem->tLogs[0]->startVersion);
															#line 8583 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 3274 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_0 = TagPartitionedLogSystem::getDurableVersionChanged(oldLogSystem->lockResults[lockNum]);
															#line 3274 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8590 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 1;
															#line 3274 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_NewEpochActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)));
															#line 8595 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->ActorCallback< TagPartitionedLogSystem_NewEpochActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 3493 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_2 = traceAfter(waitForAll(primaryTLogReplies), "PrimaryTLogRepliesReceived") || traceAfter(oldRouterRecruitment, "OldRouterRecruitmentFinished");
															#line 3493 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8706 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont12when1(__when_expr_2.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 3;
															#line 3493 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_NewEpochActor, 2, Void >*>(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)));
															#line 8711 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont31(Void const& _,int loopDepth) 
	{
															#line 3474 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("PrimarySatelliteTLogInitializationComplete", logSystem->getDebugID()).log();
															#line 3476 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < satelliteInitializationReplies.size();i++) {
															#line 3477 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[1]->logServers[i] = makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(satelliteInitializationReplies[i].get()));
															#line 8724 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3481 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logSystem->tLogs[1]->logServers.size();i++) {
															#line 3482 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			recoveryComplete.push_back(transformErrors( throwErrorOr( logSystem->tLogs[1]->logServers[i]->get().interf().recoveryFinished.getReplyUnlessFailedFor( TLogRecoveryFinishedRequest(), SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 3489 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			allTLogServers.push_back(logSystem->tLogs[1]->logServers[i]);
															#line 8732 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont31(Void && _,int loopDepth) 
	{
															#line 3474 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("PrimarySatelliteTLogInitializationComplete", logSystem->getDebugID()).log();
															#line 3476 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < satelliteInitializationReplies.size();i++) {
															#line 3477 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[1]->logServers[i] = makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(satelliteInitializationReplies[i].get()));
															#line 8746 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3481 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logSystem->tLogs[1]->logServers.size();i++) {
															#line 3482 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			recoveryComplete.push_back(transformErrors( throwErrorOr( logSystem->tLogs[1]->logServers[i]->get().interf().recoveryFinished.getReplyUnlessFailedFor( TLogRecoveryFinishedRequest(), SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 3489 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			allTLogServers.push_back(logSystem->tLogs[1]->logServers[i]);
															#line 8754 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont31(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont31(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->ActorCallback< TagPartitionedLogSystem_NewEpochActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 3495 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("PrimaryTLogInitializationComplete", logSystem->getDebugID()).log();
															#line 3497 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < primaryTLogReplies.size();i++) {
															#line 3498 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->logServers[i] = makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(primaryTLogReplies[i].get()));
															#line 3500 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->tLogLocalities[i] = recr.tLogs[i].locality;
															#line 8845 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3502 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		filterLocalityDataForPolicy(logSystem->tLogs[0]->tLogPolicy, &logSystem->tLogs[0]->tLogLocalities);
															#line 3506 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (BUGGIFY && now() - startTime < 300 && g_network->isSimulated() && g_simulator->speedUpSimulation)
															#line 8851 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3507 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			return a_body1Catch1(cluster_recovery_failed(), loopDepth);
															#line 8855 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3510 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logSystem->tLogs[0]->logServers.size();i++) {
															#line 3511 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			recoveryComplete.push_back(transformErrors( throwErrorOr(logSystem->tLogs[0]->logServers[i]->get().interf().recoveryFinished.getReplyUnlessFailedFor( TLogRecoveryFinishedRequest(), SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 3517 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			allTLogServers.push_back(logSystem->tLogs[0]->logServers[i]);
															#line 8863 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3519 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSystem->trackTLogRecovery = TagPartitionedLogSystem::trackTLogRecoveryActor(allTLogServers, logSystem->recoveredVersion);
															#line 3521 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSystem->recoveryComplete = waitForAll(recoveryComplete);
															#line 3523 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (configuration.usableRegions > 1)
															#line 8871 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3524 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->hasRemoteServers = true;
															#line 3525 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteRecovery = TagPartitionedLogSystem::newRemoteEpoch(logSystem.getPtr(), oldLogSystem, fRemoteWorkers, configuration, recoveryCount, recoveryTransactionVersion, remoteLocality, allTags, oldGenerationRecoverAtVersions);
															#line 3534 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (oldLogSystem->tLogs.size() > 0 && oldLogSystem->tLogs[0]->locality == tagLocalitySpecial)
															#line 8879 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3539 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				StrictFuture<Void> __when_expr_3 = logSystem->remoteRecovery;
															#line 3539 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8885 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_3.get(), loopDepth); };
				static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 4;
															#line 3539 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >*>(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)));
															#line 8890 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont12cont6(loopDepth);
			}
		}
		else
		{
															#line 3542 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->hasRemoteServers = false;
															#line 3543 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteRecovery = logSystem->recoveryComplete;
															#line 3544 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteRecoveryComplete = logSystem->recoveryComplete;
															#line 3545 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteRecoveredVersion->set(MAX_VERSION);
															#line 8908 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 3495 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("PrimaryTLogInitializationComplete", logSystem->getDebugID()).log();
															#line 3497 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < primaryTLogReplies.size();i++) {
															#line 3498 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->logServers[i] = makeReference<AsyncVar<OptionalInterface<TLogInterface>>>( OptionalInterface<TLogInterface>(primaryTLogReplies[i].get()));
															#line 3500 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->tLogs[0]->tLogLocalities[i] = recr.tLogs[i].locality;
															#line 8924 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3502 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		filterLocalityDataForPolicy(logSystem->tLogs[0]->tLogPolicy, &logSystem->tLogs[0]->tLogLocalities);
															#line 3506 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (BUGGIFY && now() - startTime < 300 && g_network->isSimulated() && g_simulator->speedUpSimulation)
															#line 8930 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3507 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			return a_body1Catch1(cluster_recovery_failed(), loopDepth);
															#line 8934 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3510 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logSystem->tLogs[0]->logServers.size();i++) {
															#line 3511 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			recoveryComplete.push_back(transformErrors( throwErrorOr(logSystem->tLogs[0]->logServers[i]->get().interf().recoveryFinished.getReplyUnlessFailedFor( TLogRecoveryFinishedRequest(), SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 3517 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			allTLogServers.push_back(logSystem->tLogs[0]->logServers[i]);
															#line 8942 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3519 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSystem->trackTLogRecovery = TagPartitionedLogSystem::trackTLogRecoveryActor(allTLogServers, logSystem->recoveredVersion);
															#line 3521 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		logSystem->recoveryComplete = waitForAll(recoveryComplete);
															#line 3523 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (configuration.usableRegions > 1)
															#line 8950 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3524 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->hasRemoteServers = true;
															#line 3525 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteRecovery = TagPartitionedLogSystem::newRemoteEpoch(logSystem.getPtr(), oldLogSystem, fRemoteWorkers, configuration, recoveryCount, recoveryTransactionVersion, remoteLocality, allTags, oldGenerationRecoverAtVersions);
															#line 3534 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (oldLogSystem->tLogs.size() > 0 && oldLogSystem->tLogs[0]->locality == tagLocalitySpecial)
															#line 8958 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3539 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				StrictFuture<Void> __when_expr_3 = logSystem->remoteRecovery;
															#line 3539 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8964 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_3.get(), loopDepth); };
				static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 4;
															#line 3539 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >*>(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)));
															#line 8969 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont12cont6(loopDepth);
			}
		}
		else
		{
															#line 3542 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->hasRemoteServers = false;
															#line 3543 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteRecovery = logSystem->recoveryComplete;
															#line 3544 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteRecoveryComplete = logSystem->recoveryComplete;
															#line 3545 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			logSystem->remoteRecoveredVersion->set(MAX_VERSION);
															#line 8987 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->ActorCallback< TagPartitionedLogSystem_NewEpochActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12cont2(int loopDepth) 
	{
															#line 3548 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->SAV<Reference<ILogSystem>>::futures) { (void)(logSystem); this->~TagPartitionedLogSystem_NewEpochActorState(); static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->destroy(); return 0; }
															#line 9072 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->SAV< Reference<ILogSystem> >::value()) Reference<ILogSystem>(std::move(logSystem)); // state_var_RVO
		this->~TagPartitionedLogSystem_NewEpochActorState();
		static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont6(int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<TagPartitionedLogSystem> oldLogSystem;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	RecruitFromConfigurationReply recr;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<RecruitRemoteFromConfigurationReply> fRemoteWorkers;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	DatabaseConfiguration configuration;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	LogEpoch recoveryCount;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Version recoveryTransactionVersion;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int8_t primaryLocality;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int8_t remoteLocality;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Tag> allTags;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<AsyncVar<bool>> recruitmentStalled;
															#line 3163 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	double startTime;
															#line 3164 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<TagPartitionedLogSystem> logSystem;
															#line 3203 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	RegionInfo region;
															#line 3205 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int maxTxsTags;
															#line 3257 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	int lockNum;
															#line 3263 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<Void> stalledAfter;
															#line 3288 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<Void> oldRouterRecruitment;
															#line 3321 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	LogSystemConfig oldLogSystemConfig;
															#line 3323 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<TLogInterface>> primaryTLogReplies;
															#line 3360 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Version> oldGenerationRecoverAtVersions;
															#line 3402 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<Void>> recoveryComplete;
															#line 3403 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>> allTLogServers;
															#line 3406 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<TLogInterface>> satelliteInitializationReplies;
															#line 9219 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via newEpoch()
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_NewEpochActor final : public Actor<Reference<ILogSystem>>, public ActorCallback< TagPartitionedLogSystem_NewEpochActor, 0, Void >, public ActorCallback< TagPartitionedLogSystem_NewEpochActor, 1, Void >, public ActorCallback< TagPartitionedLogSystem_NewEpochActor, 2, Void >, public ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >, public FastAllocated<TagPartitionedLogSystem_NewEpochActor>, public TagPartitionedLogSystem_NewEpochActorState<TagPartitionedLogSystem_NewEpochActor> {
															#line 9224 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_NewEpochActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_NewEpochActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3908140390978299136UL, 11912846409342035200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<ILogSystem>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_NewEpochActor, 0, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_NewEpochActor, 1, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_NewEpochActor, 2, Void >;
friend struct ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >;
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_NewEpochActor(Reference<TagPartitionedLogSystem> const& oldLogSystem,RecruitFromConfigurationReply const& recr,Future<RecruitRemoteFromConfigurationReply> const& fRemoteWorkers,DatabaseConfiguration const& configuration,LogEpoch const& recoveryCount,Version const& recoveryTransactionVersion,int8_t const& primaryLocality,int8_t const& remoteLocality,std::vector<Tag> const& allTags,Reference<AsyncVar<bool>> const& recruitmentStalled) 
															#line 9244 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Reference<ILogSystem>>(),
		   TagPartitionedLogSystem_NewEpochActorState<TagPartitionedLogSystem_NewEpochActor>(oldLogSystem, recr, fRemoteWorkers, configuration, recoveryCount, recoveryTransactionVersion, primaryLocality, remoteLocality, allTags, recruitmentStalled),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("newEpoch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(447478786350054144UL, 9754485379268421376UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_NewEpochActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("newEpoch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("newEpoch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_NewEpochActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_NewEpochActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_NewEpochActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_NewEpochActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Reference<ILogSystem>> TagPartitionedLogSystem::newEpoch( Reference<TagPartitionedLogSystem> const& oldLogSystem, RecruitFromConfigurationReply const& recr, Future<RecruitRemoteFromConfigurationReply> const& fRemoteWorkers, DatabaseConfiguration const& configuration, LogEpoch const& recoveryCount, Version const& recoveryTransactionVersion, int8_t const& primaryLocality, int8_t const& remoteLocality, std::vector<Tag> const& allTags, Reference<AsyncVar<bool>> const& recruitmentStalled ) {
															#line 3152 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Reference<ILogSystem>>(new TagPartitionedLogSystem_NewEpochActor(oldLogSystem, recr, fRemoteWorkers, configuration, recoveryCount, recoveryTransactionVersion, primaryLocality, remoteLocality, allTags, recruitmentStalled));
															#line 9279 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 3550 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 9284 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via trackRejoins()
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_TrackRejoinsActor>
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_TrackRejoinsActorState {
															#line 9290 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_TrackRejoinsActorState(UID const& dbgid,std::vector<std::pair<Reference<AsyncVar<OptionalInterface<TLogInterface>>>, Reference<IReplicationPolicy>>> const& logServers,FutureStream<struct TLogRejoinRequest> const& rejoinRequests) 
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : dbgid(dbgid),
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   logServers(logServers),
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   rejoinRequests(rejoinRequests),
															#line 3556 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   lastReply(),
															#line 3557 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   logsWaiting(),
															#line 3558 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   startTime(now()),
															#line 3559 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   warnTimeout(delay(SERVER_KNOBS->TLOG_SLOW_REJOIN_WARN_TIMEOUT_SECS))
															#line 9309 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("trackRejoins", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_TrackRejoinsActorState() 
	{
		fdb_probe_actor_destroy("trackRejoins", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3561 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for( const auto& log : logServers ) {
															#line 3562 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logsWaiting.insert(log.first->get().id());
															#line 9326 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
			try {
															#line 3566 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				;
															#line 9331 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_TrackRejoinsActorState();
		static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 3606 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			for(auto it = lastReply.begin();it != lastReply.end();++it) {
															#line 3607 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				it->second.send(TLogRejoinReply{ true });
															#line 9363 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 3608 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			return a_body1Catch1(__current_error, loopDepth);
															#line 9367 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3567 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		auto __when_expr_0 = rejoinRequests;
															#line 9388 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<TLogRejoinRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<TLogRejoinRequest>>::value, "invalid type");
															#line 3566 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9392 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 3596 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = warnTimeout;
															#line 9396 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->actor_wait_state = 1;
															#line 3567 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TagPartitionedLogSystem_TrackRejoinsActor, 0, TLogRejoinRequest >*>(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)));
															#line 3596 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_TrackRejoinsActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)));
															#line 9403 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogRejoinRequest const& req,int loopDepth) 
	{
															#line 3568 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		int pos = -1;
															#line 3569 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logServers.size();i++) {
															#line 3570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (logServers[i].first->get().id() == req.myInterface.id())
															#line 9422 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3571 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				pos = i;
															#line 3572 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logsWaiting.erase(logServers[i].first->get().id());
															#line 9428 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				break;
			}
		}
															#line 3576 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (pos != -1)
															#line 9434 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3577 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("TLogJoinedMe", dbgid) .detail("TLog", req.myInterface.id()) .detail("Address", req.myInterface.commit.getEndpoint().getPrimaryAddress().toString());
															#line 3580 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!logServers[pos].first->get().present() || req.myInterface.commit.getEndpoint() != logServers[pos].first->get().interf().commit.getEndpoint())
															#line 9440 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3583 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TLogInterface interf = req.myInterface;
															#line 3584 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				filterLocalityDataForPolicyDcAndProcess(logServers[pos].second, &interf.filteredLocality);
															#line 3585 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logServers[pos].first->setUnconditional(OptionalInterface<TLogInterface>(interf));
															#line 9448 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 3587 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastReply[req.myInterface.id()].send(TLogRejoinReply{ false });
															#line 3588 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastReply[req.myInterface.id()] = req.reply;
															#line 9454 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		else
		{
															#line 3590 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("TLogJoinedMeUnknown", dbgid) .detail("TLog", req.myInterface.id()) .detail("Address", req.myInterface.commit.getEndpoint().getPrimaryAddress().toString());
															#line 3593 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.reply.send(true);
															#line 9462 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogRejoinRequest && req,int loopDepth) 
	{
															#line 3568 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		int pos = -1;
															#line 3569 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < logServers.size();i++) {
															#line 3570 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (logServers[i].first->get().id() == req.myInterface.id())
															#line 9476 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3571 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				pos = i;
															#line 3572 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logsWaiting.erase(logServers[i].first->get().id());
															#line 9482 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				break;
			}
		}
															#line 3576 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (pos != -1)
															#line 9488 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		{
															#line 3577 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("TLogJoinedMe", dbgid) .detail("TLog", req.myInterface.id()) .detail("Address", req.myInterface.commit.getEndpoint().getPrimaryAddress().toString());
															#line 3580 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!logServers[pos].first->get().present() || req.myInterface.commit.getEndpoint() != logServers[pos].first->get().interf().commit.getEndpoint())
															#line 9494 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3583 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				TLogInterface interf = req.myInterface;
															#line 3584 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				filterLocalityDataForPolicyDcAndProcess(logServers[pos].second, &interf.filteredLocality);
															#line 3585 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				logServers[pos].first->setUnconditional(OptionalInterface<TLogInterface>(interf));
															#line 9502 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			}
															#line 3587 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastReply[req.myInterface.id()].send(TLogRejoinReply{ false });
															#line 3588 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			lastReply[req.myInterface.id()] = req.reply;
															#line 9508 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		else
		{
															#line 3590 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("TLogJoinedMeUnknown", dbgid) .detail("TLog", req.myInterface.id()) .detail("Address", req.myInterface.commit.getEndpoint().getPrimaryAddress().toString());
															#line 3593 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			req.reply.send(true);
															#line 9516 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 3597 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( const auto& logId : logsWaiting ) {
															#line 3598 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "TLogRejoinSlow", dbgid) .detail("Elapsed", startTime - now()) .detail("LogId", logId);
															#line 9528 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3602 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		warnTimeout = Never();
															#line 9532 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 3597 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for( const auto& logId : logsWaiting ) {
															#line 3598 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent(SevWarnAlways, "TLogRejoinSlow", dbgid) .detail("Elapsed", startTime - now()) .detail("LogId", logId);
															#line 9543 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3602 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		warnTimeout = Never();
															#line 9547 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->ActorSingleCallback< TagPartitionedLogSystem_TrackRejoinsActor, 0, TLogRejoinRequest >::remove();
		static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->ActorCallback< TagPartitionedLogSystem_TrackRejoinsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TagPartitionedLogSystem_TrackRejoinsActor, 0, TLogRejoinRequest >*,TLogRejoinRequest const& value) 
	{
		fdb_probe_actor_enter("trackRejoins", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRejoins", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TagPartitionedLogSystem_TrackRejoinsActor, 0, TLogRejoinRequest >*,TLogRejoinRequest && value) 
	{
		fdb_probe_actor_enter("trackRejoins", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRejoins", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TagPartitionedLogSystem_TrackRejoinsActor, 0, TLogRejoinRequest >*,Error err) 
	{
		fdb_probe_actor_enter("trackRejoins", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRejoins", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_TrackRejoinsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackRejoins", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRejoins", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_TrackRejoinsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackRejoins", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRejoins", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_TrackRejoinsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackRejoins", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackRejoins", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	UID dbgid;
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<std::pair<Reference<AsyncVar<OptionalInterface<TLogInterface>>>, Reference<IReplicationPolicy>>> logServers;
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	FutureStream<struct TLogRejoinRequest> rejoinRequests;
															#line 3556 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::map<UID, ReplyPromise<TLogRejoinReply>> lastReply;
															#line 3557 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::set<UID> logsWaiting;
															#line 3558 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	double startTime;
															#line 3559 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Future<Void> warnTimeout;
															#line 9687 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via trackRejoins()
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_TrackRejoinsActor final : public Actor<Void>, public ActorSingleCallback< TagPartitionedLogSystem_TrackRejoinsActor, 0, TLogRejoinRequest >, public ActorCallback< TagPartitionedLogSystem_TrackRejoinsActor, 1, Void >, public FastAllocated<TagPartitionedLogSystem_TrackRejoinsActor>, public TagPartitionedLogSystem_TrackRejoinsActorState<TagPartitionedLogSystem_TrackRejoinsActor> {
															#line 9692 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_TrackRejoinsActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_TrackRejoinsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18334839682637710848UL, 531395248399848960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TagPartitionedLogSystem_TrackRejoinsActor, 0, TLogRejoinRequest >;
friend struct ActorCallback< TagPartitionedLogSystem_TrackRejoinsActor, 1, Void >;
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_TrackRejoinsActor(UID const& dbgid,std::vector<std::pair<Reference<AsyncVar<OptionalInterface<TLogInterface>>>, Reference<IReplicationPolicy>>> const& logServers,FutureStream<struct TLogRejoinRequest> const& rejoinRequests) 
															#line 9710 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_TrackRejoinsActorState<TagPartitionedLogSystem_TrackRejoinsActor>(dbgid, logServers, rejoinRequests),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackRejoins", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12720455000144465152UL, 15941477666965444352UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackRejoinsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackRejoins");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackRejoins", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< TagPartitionedLogSystem_TrackRejoinsActor, 0, TLogRejoinRequest >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::trackRejoins( UID const& dbgid, std::vector<std::pair<Reference<AsyncVar<OptionalInterface<TLogInterface>>>, Reference<IReplicationPolicy>>> const& logServers, FutureStream<struct TLogRejoinRequest> const& rejoinRequests ) {
															#line 3551 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_TrackRejoinsActor(dbgid, logServers, rejoinRequests));
															#line 9742 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 3611 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 9747 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via lockTLog()
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_LockTLogActor>
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_LockTLogActorState {
															#line 9753 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_LockTLogActorState(UID const& myID,Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& tlog) 
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : myID(myID),
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   tlog(tlog)
															#line 9762 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("lockTLog", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_LockTLogActorState() 
	{
		fdb_probe_actor_destroy("lockTLog", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3615 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("TLogLockStarted", myID).detail("TLog", tlog->get().id()).detail("InfPresent", tlog->get().present());
															#line 3616 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 9779 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_LockTLogActorState();
		static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3618 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<TLogLockResult> __when_expr_0 = tlog->get().present() ? brokenPromiseToNever(tlog->get().interf().lock.getReply<TLogLockResult>()) : Never();
															#line 3617 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9811 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 3624 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tlog->onChange();
															#line 9815 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->actor_wait_state = 1;
															#line 3618 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_LockTLogActor, 0, TLogLockResult >*>(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)));
															#line 3624 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_LockTLogActor, 1, Void >*>(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)));
															#line 9822 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogLockResult const& data,int loopDepth) 
	{
															#line 3621 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("TLogLocked", myID).detail("TLog", tlog->get().id()).detail("End", data.end);
															#line 3622 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->SAV<TLogLockResult>::futures) { (void)(data); this->~TagPartitionedLogSystem_LockTLogActorState(); static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->destroy(); return 0; }
															#line 9839 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->SAV< TLogLockResult >::value()) TLogLockResult(data);
		this->~TagPartitionedLogSystem_LockTLogActorState();
		static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogLockResult && data,int loopDepth) 
	{
															#line 3621 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("TLogLocked", myID).detail("TLog", tlog->get().id()).detail("End", data.end);
															#line 3622 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (!static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->SAV<TLogLockResult>::futures) { (void)(data); this->~TagPartitionedLogSystem_LockTLogActorState(); static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->destroy(); return 0; }
															#line 9853 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		new (&static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->SAV< TLogLockResult >::value()) TLogLockResult(data);
		this->~TagPartitionedLogSystem_LockTLogActorState();
		static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->ActorCallback< TagPartitionedLogSystem_LockTLogActor, 0, TLogLockResult >::remove();
		static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->ActorCallback< TagPartitionedLogSystem_LockTLogActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_LockTLogActor, 0, TLogLockResult >*,TLogLockResult const& value) 
	{
		fdb_probe_actor_enter("lockTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_LockTLogActor, 0, TLogLockResult >*,TLogLockResult && value) 
	{
		fdb_probe_actor_enter("lockTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_LockTLogActor, 0, TLogLockResult >*,Error err) 
	{
		fdb_probe_actor_enter("lockTLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_LockTLogActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lockTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_LockTLogActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lockTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_LockTLogActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lockTLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lockTLog", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	UID myID;
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<AsyncVar<OptionalInterface<TLogInterface>>> tlog;
															#line 9998 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via lockTLog()
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_LockTLogActor final : public Actor<TLogLockResult>, public ActorCallback< TagPartitionedLogSystem_LockTLogActor, 0, TLogLockResult >, public ActorCallback< TagPartitionedLogSystem_LockTLogActor, 1, Void >, public FastAllocated<TagPartitionedLogSystem_LockTLogActor>, public TagPartitionedLogSystem_LockTLogActorState<TagPartitionedLogSystem_LockTLogActor> {
															#line 10003 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_LockTLogActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_LockTLogActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1057651333142858496UL, 16189291288747846400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TLogLockResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_LockTLogActor, 0, TLogLockResult >;
friend struct ActorCallback< TagPartitionedLogSystem_LockTLogActor, 1, Void >;
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_LockTLogActor(UID const& myID,Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& tlog) 
															#line 10021 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<TLogLockResult>(),
		   TagPartitionedLogSystem_LockTLogActorState<TagPartitionedLogSystem_LockTLogActor>(myID, tlog),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lockTLog", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1684940548165743104UL, 13388118572458788096UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_LockTLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lockTLog");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lockTLog", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_LockTLogActor, 0, TLogLockResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<TLogLockResult> TagPartitionedLogSystem::lockTLog( UID const& myID, Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& tlog ) {
															#line 3612 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<TLogLockResult>(new TagPartitionedLogSystem_LockTLogActor(myID, tlog));
															#line 10053 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 3628 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"

															#line 10058 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
// This generated class is to be used only via trackTLogRecoveryActor()
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
template <class TagPartitionedLogSystem_TrackTLogRecoveryActorActor>
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_TrackTLogRecoveryActorActorState {
															#line 10064 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_TrackTLogRecoveryActorActorState(std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>> const& tlogs,Reference<AsyncVar<Version>> const& recoveredVersion) 
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		 : tlogs(tlogs),
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		   recoveredVersion(recoveredVersion)
															#line 10073 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
	{
		fdb_probe_actor_create("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this));

	}
	~TagPartitionedLogSystem_TrackTLogRecoveryActorActorState() 
	{
		fdb_probe_actor_destroy("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3632 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			if (!SERVER_KNOBS->TRACK_TLOG_RECOVERY)
															#line 10088 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			{
															#line 3633 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
				this->~TagPartitionedLogSystem_TrackTLogRecoveryActorActorState();
															#line 10092 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
				static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 3636 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			individualTLogRecovery = std::vector<Future<TrackTLogRecoveryReply>>();
															#line 3637 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			;
															#line 10100 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TagPartitionedLogSystem_TrackTLogRecoveryActorActorState();
		static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 3638 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		individualTLogRecovery.clear();
															#line 3639 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		individualTLogRecovery.reserve(tlogs.size());
															#line 3640 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TrackTLogRecoveryRequest req(recoveredVersion->get());
															#line 3641 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < tlogs.size();++i) {
															#line 3642 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			TraceEvent("WaitingForTLogRecovery") .detail("Tlog", tlogs[i]->get().id()) .detail("PrevRecoveredVersion", recoveredVersion->get());
															#line 3645 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			individualTLogRecovery.push_back(transformErrors( throwErrorOr(tlogs[i]->get().interf().trackRecovery.getReplyUnlessFailedFor( req, SERVER_KNOBS->TLOG_TIMEOUT, SERVER_KNOBS->MASTER_FAILURE_SLOPE_DURING_RECOVERY)), cluster_recovery_failed()));
															#line 10140 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3651 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(individualTLogRecovery);
															#line 3651 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		if (static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10146 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->actor_wait_state = 1;
															#line 3651 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TagPartitionedLogSystem_TrackTLogRecoveryActorActor, 0, Void >*>(static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)));
															#line 10151 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 3653 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version currentRecoveredVersion = MAX_VERSION;
															#line 3654 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < individualTLogRecovery.size();++i) {
															#line 3655 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			currentRecoveredVersion = std::min(individualTLogRecovery[i].get().oldestUnrecoveredStartVersion, currentRecoveredVersion);
															#line 10164 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3659 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("TLogRecoveredVersion").detail("RecoveredVersion", currentRecoveredVersion);
															#line 3660 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		recoveredVersion->set(currentRecoveredVersion);
															#line 10170 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 3653 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		Version currentRecoveredVersion = MAX_VERSION;
															#line 3654 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		for(int i = 0;i < individualTLogRecovery.size();++i) {
															#line 3655 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
			currentRecoveredVersion = std::min(individualTLogRecovery[i].get().oldestUnrecoveredStartVersion, currentRecoveredVersion);
															#line 10183 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		}
															#line 3659 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		TraceEvent("TLogRecoveredVersion").detail("RecoveredVersion", currentRecoveredVersion);
															#line 3660 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
		recoveredVersion->set(currentRecoveredVersion);
															#line 10189 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->actor_wait_state > 0) static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->actor_wait_state = 0;
		static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->ActorCallback< TagPartitionedLogSystem_TrackTLogRecoveryActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_TrackTLogRecoveryActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TagPartitionedLogSystem_TrackTLogRecoveryActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TagPartitionedLogSystem_TrackTLogRecoveryActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>> tlogs;
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	Reference<AsyncVar<Version>> recoveredVersion;
															#line 3636 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	std::vector<Future<TrackTLogRecoveryReply>> individualTLogRecovery;
															#line 10275 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
};
// This generated class is to be used only via trackTLogRecoveryActor()
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
class TagPartitionedLogSystem_TrackTLogRecoveryActorActor final : public Actor<Void>, public ActorCallback< TagPartitionedLogSystem_TrackTLogRecoveryActorActor, 0, Void >, public FastAllocated<TagPartitionedLogSystem_TrackTLogRecoveryActorActor>, public TagPartitionedLogSystem_TrackTLogRecoveryActorActorState<TagPartitionedLogSystem_TrackTLogRecoveryActorActor> {
															#line 10280 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
public:
	using FastAllocated<TagPartitionedLogSystem_TrackTLogRecoveryActorActor>::operator new;
	using FastAllocated<TagPartitionedLogSystem_TrackTLogRecoveryActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16350442587960313600UL, 13914525553953235712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TagPartitionedLogSystem_TrackTLogRecoveryActorActor, 0, Void >;
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	TagPartitionedLogSystem_TrackTLogRecoveryActorActor(std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>> const& tlogs,Reference<AsyncVar<Version>> const& recoveredVersion) 
															#line 10297 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
		 : Actor<Void>(),
		   TagPartitionedLogSystem_TrackTLogRecoveryActorActorState<TagPartitionedLogSystem_TrackTLogRecoveryActorActor>(tlogs, recoveredVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14342608938806124800UL, 12579287080519309312UL);
		ActorExecutionContextHelper __helper(static_cast<TagPartitionedLogSystem_TrackTLogRecoveryActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackTLogRecoveryActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackTLogRecoveryActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TagPartitionedLogSystem_TrackTLogRecoveryActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
[[nodiscard]] Future<Void> TagPartitionedLogSystem::trackTLogRecoveryActor( std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>> const& tlogs, Reference<AsyncVar<Version>> const& recoveredVersion ) {
															#line 3629 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
	return Future<Void>(new TagPartitionedLogSystem_TrackTLogRecoveryActorActor(tlogs, recoveredVersion));
															#line 10329 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbserver/TagPartitionedLogSystem.actor.g.cpp"
}

#line 3663 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbserver/TagPartitionedLogSystem.actor.cpp"
