#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
/*
 * ExpensiveDataCheckCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/algorithm/string.hpp"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

// The command is used to send a data check request to the specified process
// The check request is accomplished by rebooting the process

															#line 41 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
// This generated class is to be used only via expensiveDataCheckCommandActor()
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
template <class ExpensiveDataCheckCommandActorActor>
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
class ExpensiveDataCheckCommandActorActorState {
															#line 47 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
public:
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	ExpensiveDataCheckCommandActorActorState(Reference<IDatabase> const& db,Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface) 
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		 : db(db),
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		   tr(tr),
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		   tokens(tokens),
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		   address_interface(address_interface),
															#line 44 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		   result(true),
															#line 45 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		   addressesStr()
															#line 64 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ExpensiveDataCheckCommandActorActorState() 
	{
		fdb_probe_actor_destroy("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 46 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 79 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
			{
															#line 48 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				address_interface->clear();
															#line 49 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = getWorkerInterfaces(tr, address_interface, true);
															#line 49 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				if (static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 87 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state = 1;
															#line 49 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExpensiveDataCheckCommandActorActor, 0, Void >*>(static_cast<ExpensiveDataCheckCommandActorActor*>(this)));
															#line 92 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExpensiveDataCheckCommandActorActorState();
		static_cast<ExpensiveDataCheckCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 51 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		if (tokens.size() == 1 || tokencmp(tokens[1], "list"))
															#line 120 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		{
															#line 52 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			if (address_interface->size() == 0)
															#line 124 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
			{
															#line 53 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				printf("\nNo addresses can be checked.\n");
															#line 128 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
			}
			else
			{
															#line 54 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				if (address_interface->size() == 1)
															#line 134 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
				{
															#line 55 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					printf("\nThe following address can be checked:\n");
															#line 138 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
				}
				else
				{
															#line 57 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					printf("\nThe following %zu addresses can be checked:\n", address_interface->size());
															#line 144 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
				}
			}
															#line 59 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			for( auto it : *address_interface ) {
															#line 60 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				printf("%s\n", printable(it.first).c_str());
															#line 151 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
			}
															#line 62 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			printf("\n");
															#line 155 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 63 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			if (tokencmp(tokens[1], "all"))
															#line 162 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
			{
															#line 64 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				if (address_interface->size() == 0)
															#line 166 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
				{
															#line 65 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					fprintf(stderr, "ERROR: no processes to check. You must run the `expensive_data_check’ " "command before running `expensive_data_check all’.\n");
															#line 170 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
					loopDepth = a_body1cont11(loopDepth);
				}
				else
				{
															#line 69 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					std::vector<std::string> addressesVec;
															#line 70 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					for( const auto& [address, _] : *address_interface ) {
															#line 71 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
						addressesVec.push_back(address.toString());
															#line 181 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
					}
															#line 73 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					addressesStr = boost::algorithm::join(addressesVec, ",");
															#line 75 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					StrictFuture<int64_t> __when_expr_1 = safeThreadFutureToFuture(db->rebootWorker(addressesStr, true, 0));
															#line 75 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					if (static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 189 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state = 2;
															#line 75 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExpensiveDataCheckCommandActorActor, 1, int64_t >*>(static_cast<ExpensiveDataCheckCommandActorActor*>(this)));
															#line 194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
					loopDepth = 0;
				}
			}
			else
			{
															#line 86 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				i = int();
															#line 87 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				for(i = 1;i < tokens.size();i++) {
															#line 88 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					if (!address_interface->count(tokens[i]))
															#line 206 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
					{
															#line 89 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
						fprintf(stderr, "ERROR: process `%s' not recognized.\n", printable(tokens[i]).c_str());
															#line 90 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
						result = false;
															#line 212 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
						break;
					}
				}
															#line 95 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
				if (result)
															#line 218 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
				{
															#line 96 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					std::vector<std::string> addressesVec;
															#line 97 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					for(i = 1;i < tokens.size();i++) {
															#line 98 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
						addressesVec.push_back(tokens[i].toString());
															#line 226 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
					}
															#line 100 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					addressesStr = boost::algorithm::join(addressesVec, ",");
															#line 101 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					StrictFuture<int64_t> __when_expr_2 = safeThreadFutureToFuture(db->rebootWorker(addressesStr, true, 0));
															#line 101 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					if (static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 234 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
					static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state = 3;
															#line 101 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExpensiveDataCheckCommandActorActor, 2, int64_t >*>(static_cast<ExpensiveDataCheckCommandActorActor*>(this)));
															#line 239 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont15(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExpensiveDataCheckCommandActorActor*>(this)->ActorCallback< ExpensiveDataCheckCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpensiveDataCheckCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExpensiveDataCheckCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExpensiveDataCheckCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		if (!static_cast<ExpensiveDataCheckCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~ExpensiveDataCheckCommandActorActorState(); static_cast<ExpensiveDataCheckCommandActorActor*>(this)->destroy(); return 0; }
															#line 342 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		new (&static_cast<ExpensiveDataCheckCommandActorActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~ExpensiveDataCheckCommandActorActorState();
		static_cast<ExpensiveDataCheckCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int64_t const& checkRequestsSent,int loopDepth) 
	{
															#line 76 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		if (!checkRequestsSent)
															#line 366 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		{
															#line 77 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			result = false;
															#line 78 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			fprintf(stderr, "ERROR: failed to send requests to check all processes, please run the `expensive_data_check’ " "command again to fetch latest addresses.\n");
															#line 372 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		}
		else
		{
															#line 82 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			printf("Attempted to kill and check %zu processes\n", address_interface->size());
															#line 378 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		}
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int64_t && checkRequestsSent,int loopDepth) 
	{
															#line 76 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		if (!checkRequestsSent)
															#line 388 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		{
															#line 77 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			result = false;
															#line 78 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			fprintf(stderr, "ERROR: failed to send requests to check all processes, please run the `expensive_data_check’ " "command again to fetch latest addresses.\n");
															#line 394 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		}
		else
		{
															#line 82 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			printf("Attempted to kill and check %zu processes\n", address_interface->size());
															#line 400 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		}
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& checkRequestsSent,int loopDepth) 
	{
		loopDepth = a_body1cont13(checkRequestsSent, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && checkRequestsSent,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(checkRequestsSent), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExpensiveDataCheckCommandActorActor*>(this)->ActorCallback< ExpensiveDataCheckCommandActorActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ExpensiveDataCheckCommandActorActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExpensiveDataCheckCommandActorActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExpensiveDataCheckCommandActorActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(int64_t const& checkRequestsSent,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		if (!checkRequestsSent)
															#line 491 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		{
															#line 103 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			result = false;
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			fprintf(stderr, "ERROR: failed to send requests to check processes `%s', please run the `expensive_data_check’ " "command again to fetch latest addresses.\n", addressesStr.c_str());
															#line 497 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		}
		else
		{
															#line 109 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			printf("Attempted to kill and check %zu processes\n", tokens.size() - 1);
															#line 503 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		}
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(int64_t && checkRequestsSent,int loopDepth) 
	{
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
		if (!checkRequestsSent)
															#line 513 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		{
															#line 103 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			result = false;
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			fprintf(stderr, "ERROR: failed to send requests to check processes `%s', please run the `expensive_data_check’ " "command again to fetch latest addresses.\n", addressesStr.c_str());
															#line 519 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		}
		else
		{
															#line 109 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
			printf("Attempted to kill and check %zu processes\n", tokens.size() - 1);
															#line 525 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		}
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(int64_t const& checkRequestsSent,int loopDepth) 
	{
		loopDepth = a_body1cont18(checkRequestsSent, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(int64_t && checkRequestsSent,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(checkRequestsSent), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ExpensiveDataCheckCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExpensiveDataCheckCommandActorActor*>(this)->ActorCallback< ExpensiveDataCheckCommandActorActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ExpensiveDataCheckCommandActorActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExpensiveDataCheckCommandActorActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExpensiveDataCheckCommandActorActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* address_interface;
															#line 44 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	bool result;
															#line 45 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	std::string addressesStr;
															#line 86 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	int i;
															#line 620 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
};
// This generated class is to be used only via expensiveDataCheckCommandActor()
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
class ExpensiveDataCheckCommandActorActor final : public Actor<bool>, public ActorCallback< ExpensiveDataCheckCommandActorActor, 0, Void >, public ActorCallback< ExpensiveDataCheckCommandActorActor, 1, int64_t >, public ActorCallback< ExpensiveDataCheckCommandActorActor, 2, int64_t >, public FastAllocated<ExpensiveDataCheckCommandActorActor>, public ExpensiveDataCheckCommandActorActorState<ExpensiveDataCheckCommandActorActor> {
															#line 625 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
public:
	using FastAllocated<ExpensiveDataCheckCommandActorActor>::operator new;
	using FastAllocated<ExpensiveDataCheckCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8386677567246278144UL, 14043749129326557696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExpensiveDataCheckCommandActorActor, 0, Void >;
friend struct ActorCallback< ExpensiveDataCheckCommandActorActor, 1, int64_t >;
friend struct ActorCallback< ExpensiveDataCheckCommandActorActor, 2, int64_t >;
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	ExpensiveDataCheckCommandActorActor(Reference<IDatabase> const& db,Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface) 
															#line 644 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
		 : Actor<bool>(),
		   ExpensiveDataCheckCommandActorActorState<ExpensiveDataCheckCommandActorActor>(db, tr, tokens, address_interface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7026428694956204544UL, 10573571774493521408UL);
		ActorExecutionContextHelper __helper(static_cast<ExpensiveDataCheckCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("expensiveDataCheckCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("expensiveDataCheckCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExpensiveDataCheckCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExpensiveDataCheckCommandActorActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExpensiveDataCheckCommandActorActor, 2, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
[[nodiscard]] Future<bool> expensiveDataCheckCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface ) {
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
	return Future<bool>(new ExpensiveDataCheckCommandActorActor(db, tr, tokens, address_interface));
															#line 678 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/ExpensiveDataCheckCommand.actor.g.cpp"
}

#line 115 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/ExpensiveDataCheckCommand.actor.cpp"
// hidden commands, no help text for now
CommandFactory expensiveDataCheckFactory("expensive_data_check");
} // namespace fdb_cli
