#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
/*
 * AuditStorageCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/IClientApi.h"

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/Audit.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 37 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
// This generated class is to be used only via auditStorageCommandActor()
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
template <class AuditStorageCommandActorActor>
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
class AuditStorageCommandActorActorState {
															#line 43 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
public:
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	AuditStorageCommandActorActorState(Reference<IClusterConnectionRecord> const& clusterFile,std::vector<StringRef> const& tokens) 
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		 : clusterFile(clusterFile),
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		   tokens(tokens)
															#line 52 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("auditStorageCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~AuditStorageCommandActorActorState() 
	{
		fdb_probe_actor_destroy("auditStorageCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
			if (tokens.size() < 2)
															#line 67 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
			{
															#line 38 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 39 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 73 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~AuditStorageCommandActorActorState();
				static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 42 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
			resAuditId = UID();
															#line 43 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
			if (tokencmp(tokens[1], "cancel"))
															#line 83 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
			{
															#line 44 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokens.size() != 4)
															#line 87 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				{
															#line 45 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 46 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 93 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~AuditStorageCommandActorActorState();
					static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 48 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				AuditType type = AuditType::Invalid;
															#line 49 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokencmp(tokens[2], "ha"))
															#line 103 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				{
															#line 50 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					type = AuditType::ValidateHA;
															#line 107 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				}
				else
				{
															#line 51 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (tokencmp(tokens[2], "replica"))
															#line 113 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					{
															#line 52 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						type = AuditType::ValidateReplica;
															#line 117 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					}
					else
					{
															#line 53 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						if (tokencmp(tokens[2], "locationmetadata"))
															#line 123 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
						{
															#line 54 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
							type = AuditType::ValidateLocationMetadata;
															#line 127 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
						}
						else
						{
															#line 55 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
							if (tokencmp(tokens[2], "ssshard"))
															#line 133 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
							{
															#line 56 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								type = AuditType::ValidateStorageServerShard;
															#line 137 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
							}
							else
							{
															#line 58 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								printUsage(tokens[0]);
															#line 59 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 145 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
								new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
								this->~AuditStorageCommandActorActorState();
								static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
						}
					}
				}
															#line 61 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				const UID auditId = UID::fromString(tokens[3].toString());
															#line 62 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				StrictFuture<UID> __when_expr_0 = cancelAuditStorage(clusterFile, type, auditId, 60);
															#line 62 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 160 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state = 1;
															#line 62 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCommandActorActor, 0, UID >*>(static_cast<AuditStorageCommandActorActor*>(this)));
															#line 165 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 66 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				AuditType type = AuditType::Invalid;
															#line 67 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokencmp(tokens[1], "ha"))
															#line 174 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				{
															#line 68 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					type = AuditType::ValidateHA;
															#line 178 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				}
				else
				{
															#line 69 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (tokencmp(tokens[1], "replica"))
															#line 184 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					{
															#line 70 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						type = AuditType::ValidateReplica;
															#line 188 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					}
					else
					{
															#line 71 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						if (tokencmp(tokens[1], "locationmetadata"))
															#line 194 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
						{
															#line 72 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
							type = AuditType::ValidateLocationMetadata;
															#line 198 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
						}
						else
						{
															#line 73 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
							if (tokencmp(tokens[1], "ssshard"))
															#line 204 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
							{
															#line 74 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								type = AuditType::ValidateStorageServerShard;
															#line 208 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
							}
							else
							{
															#line 76 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								printUsage(tokens[0]);
															#line 77 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 216 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
								new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
								this->~AuditStorageCommandActorActorState();
								static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
						}
					}
				}
															#line 80 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				Key begin = allKeys.begin, end = allKeys.end;
															#line 81 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokens.size() == 3)
															#line 229 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				{
															#line 82 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					begin = tokens[2];
															#line 233 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				}
				else
				{
															#line 83 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (tokens.size() == 4 || tokens.size() == 5)
															#line 239 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					{
															#line 84 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						begin = tokens[2];
															#line 85 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						end = tokens[3];
															#line 245 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					}
					else
					{
															#line 87 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 88 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 253 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
						new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
						this->~AuditStorageCommandActorActorState();
						static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 90 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (end > allKeys.end)
															#line 262 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				{
															#line 91 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 92 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 268 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~AuditStorageCommandActorActorState();
					static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 94 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (begin >= end)
															#line 276 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				{
															#line 95 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 96 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 282 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~AuditStorageCommandActorActorState();
					static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 99 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				KeyValueStoreType engineType = KeyValueStoreType::END;
															#line 100 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokens.size() == 5 && (type == AuditType::ValidateHA || type == AuditType::ValidateReplica))
															#line 292 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				{
															#line 101 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					engineType = KeyValueStoreType::fromString(tokens[4].toString());
															#line 102 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (engineType != KeyValueStoreType::SSD_BTREE_V2 && engineType != KeyValueStoreType::SSD_ROCKSDB_V1 && engineType != KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 298 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
					{
															#line 104 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 105 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 304 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
						new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
						this->~AuditStorageCommandActorActorState();
						static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 110 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				StrictFuture<UID> __when_expr_1 = auditStorage(clusterFile, KeyRangeRef(begin, end), type, engineType, 60);
															#line 110 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 315 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state = 2;
															#line 110 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCommandActorActor, 1, UID >*>(static_cast<AuditStorageCommandActorActor*>(this)));
															#line 320 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditStorageCommandActorActorState();
		static_cast<AuditStorageCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 114 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(resAuditId); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 344 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
		new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(std::move(resAuditId)); // state_var_RVO
		this->~AuditStorageCommandActorActorState();
		static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(UID const& cancelledAuditId,int loopDepth) 
	{
															#line 63 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		resAuditId = cancelledAuditId;
															#line 356 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && cancelledAuditId,int loopDepth) 
	{
															#line 63 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		resAuditId = cancelledAuditId;
															#line 365 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID const& cancelledAuditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(cancelledAuditId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID && cancelledAuditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(cancelledAuditId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCommandActorActor*>(this)->ActorCallback< AuditStorageCommandActorActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCommandActorActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditStorageCommandActorActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditStorageCommandActorActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont14(UID const& startedAuditId,int loopDepth) 
	{
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		resAuditId = startedAuditId;
															#line 449 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(UID && startedAuditId,int loopDepth) 
	{
															#line 112 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		resAuditId = startedAuditId;
															#line 458 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(UID const& startedAuditId,int loopDepth) 
	{
		loopDepth = a_body1cont14(startedAuditId, loopDepth);

		return loopDepth;
	}
	int a_body1when2(UID && startedAuditId,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(startedAuditId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCommandActorActor*>(this)->ActorCallback< AuditStorageCommandActorActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCommandActorActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditStorageCommandActorActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditStorageCommandActorActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	Reference<IClusterConnectionRecord> clusterFile;
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 42 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	UID resAuditId;
															#line 544 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
};
// This generated class is to be used only via auditStorageCommandActor()
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
class AuditStorageCommandActorActor final : public Actor<UID>, public ActorCallback< AuditStorageCommandActorActor, 0, UID >, public ActorCallback< AuditStorageCommandActorActor, 1, UID >, public FastAllocated<AuditStorageCommandActorActor>, public AuditStorageCommandActorActorState<AuditStorageCommandActorActor> {
															#line 549 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
public:
	using FastAllocated<AuditStorageCommandActorActor>::operator new;
	using FastAllocated<AuditStorageCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3559857794385576448UL, 18139066268021368064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditStorageCommandActorActor, 0, UID >;
friend struct ActorCallback< AuditStorageCommandActorActor, 1, UID >;
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	AuditStorageCommandActorActor(Reference<IClusterConnectionRecord> const& clusterFile,std::vector<StringRef> const& tokens) 
															#line 567 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
		 : Actor<UID>(),
		   AuditStorageCommandActorActorState<AuditStorageCommandActorActor>(clusterFile, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4733057652697692416UL, 1885724123785879040UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditStorageCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditStorageCommandActorActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditStorageCommandActorActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
[[nodiscard]] Future<UID> auditStorageCommandActor( Reference<IClusterConnectionRecord> const& clusterFile, std::vector<StringRef> const& tokens ) {
															#line 35 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	return Future<UID>(new AuditStorageCommandActorActor(clusterFile, tokens));
															#line 600 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp"
}

#line 116 "/codebuild/output/src3579944540/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"

CommandFactory auditStorageFactory(
    "audit_storage",
    CommandHelp("audit_storage <Type> [BeginKey EndKey] <EngineType>",
                "Start an audit storage",
                "Specify audit `Type' (only `ha' and `replica' and `locationmetadata' and "
                "`ssshard' `Type' are supported currently), and\n"
                "optionally a sub-range with `BeginKey' and `EndKey'.\n"
                "Specify audit `EngineType' when auditType is `ha' or `replica'\n"
                "(only `ssd-rocksdb-v1' and `ssd-sharded-rocksdb' and `ssd-2' are supported).\n"
                "If no EngineType is specified, every storage engine will be audited.\n"
                "For example, to audit the full key range: `audit_storage ha'\n"
                "To audit a sub-range only: `audit_storage ha \\xa \\xb'\n"
                "Returns an audit `ID'. See also `get_audit_status' command.\n"
                "Note that BeginKey should not equal to EndKey and EndKey is at most \\xff.\n"
                "To cancel an audit: audit_storage cancel <Type> [ID]"));
} // namespace fdb_cli
