/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class TestResult {
    private long id;
    private Map<String, Map<String, Object>> kpis;
    private List<Throwable> errors;

    public TestResult(Random random) {
        this.id = Math.abs(random.nextLong());
        this.kpis = new TreeMap<String, Map<String, Object>>();
        this.errors = new ArrayList<Throwable>();
    }

    public void addKpi(String string, Number number, String string2) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("value", number);
        treeMap.put("units", string2);
        this.kpis.put(string, treeMap);
    }

    public void addError(Throwable throwable) {
        this.errors.add(throwable);
    }

    public void save(String string) {
        String string2 = "javaresult-" + this.id + ".json";
        if (string.length() > 0) {
            string2 = string + "/" + string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append("\"kpis\": {");
        boolean bl = true;
        for (Map.Entry<String, Map<String, Object>> object : this.kpis.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"");
            stringBuilder.append(object.getKey());
            stringBuilder.append("\": {");
            boolean throwable = true;
            for (Map.Entry entry : object.getValue().entrySet()) {
                if (throwable) {
                    throwable = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("\"");
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append("\": ");
                Object v = entry.getValue();
                if (v instanceof String) {
                    stringBuilder.append("\"");
                    stringBuilder.append((String)v);
                    stringBuilder.append("\"");
                    continue;
                }
                stringBuilder.append(v.toString());
            }
            stringBuilder.append("}");
        }
        stringBuilder.append("}, ");
        stringBuilder.append("\"errors\":[");
        boolean bl3 = true;
        for (Throwable throwable : this.errors) {
            if (bl3) {
                bl3 = false;
            } else {
                stringBuilder.append(", ");
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(throwable.getClass().toString());
            stringBuilder2.append(": ");
            stringBuilder2.append(throwable.getMessage());
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                stringBuilder2.append("\n    ");
                stringBuilder2.append(stackTraceElement.toString());
            }
            stringBuilder.append('\"');
            stringBuilder.append(stringBuilder2.toString().replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n").replace("\f", "\\f").replace("\b", "\\b"));
            stringBuilder.append('\"');
        }
        stringBuilder.append("]");
        stringBuilder.append('}');
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));){
            bufferedWriter.write(stringBuilder.toString());
        }
        catch (IOException iOException) {
            System.out.println("Could not write results to file " + string2);
            throw new RuntimeException("Could not save results: " + iOException.getMessage(), iOException);
        }
    }
}

