#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
/*
 * SlowTaskWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>

#include "fmt/format.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/SignalSafeUnwind.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Stress test the slow task profiler or flow profiler
struct SlowTaskWorkload : TestWorkload {
	static constexpr auto NAME = "SlowTaskWorkload";

	SlowTaskWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {}

	Future<Void> start(Database const& cx) override {
		setupRunLoopProfiler();
		return go();
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 45 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
// This generated class is to be used only via go()
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
template <class GoActor>
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
class GoActorState {
															#line 51 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
public:
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
	GoActorState() 
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
	{
															#line 57 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
		fdb_probe_actor_create("go", reinterpret_cast<unsigned long>(this));

	}
	~GoActorState() 
	{
		fdb_probe_actor_destroy("go", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(1);
															#line 44 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			if (static_cast<GoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 73 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GoActor*>(this)->actor_wait_state = 1;
															#line 44 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GoActor, 0, Void >*>(static_cast<GoActor*>(this)));
															#line 78 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GoActorState();
		static_cast<GoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 45 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t phc = dl_iterate_phdr_calls;
															#line 46 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t startProfilesDisabled = getNumProfilesDisabled();
															#line 47 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t startProfilesOverflowed = getNumProfilesOverflowed();
															#line 48 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t startProfilesCaptured = getNumProfilesCaptured();
															#line 49 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t exc = 0;
															#line 50 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		fprintf(stderr, "Slow task starting\n");
															#line 51 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		for(int i = 0;i < 10;i++) {
															#line 52 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			fprintf(stderr, "  %d\n", i);
															#line 53 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			double end = timer() + 1;
															#line 54 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			for(;timer() < end;) {
															#line 55 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
				do_slow_exception_thing(&exc);
															#line 121 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
			}
		}
															#line 58 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		fmt::print(stderr, "Slow task complete: {0} exceptions; {1} calls to dl_iterate_phdr, {2}" " profiles disabled, {3} profiles overflowed, {4} profiles captured\n", exc, dl_iterate_phdr_calls - phc, getNumProfilesDisabled() - startProfilesDisabled, getNumProfilesOverflowed() - startProfilesOverflowed, getNumProfilesCaptured() - startProfilesCaptured);
															#line 67 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		if (!static_cast<GoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GoActorState(); static_cast<GoActor*>(this)->destroy(); return 0; }
															#line 128 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
		new (&static_cast<GoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GoActorState();
		static_cast<GoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 45 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t phc = dl_iterate_phdr_calls;
															#line 46 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t startProfilesDisabled = getNumProfilesDisabled();
															#line 47 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t startProfilesOverflowed = getNumProfilesOverflowed();
															#line 48 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t startProfilesCaptured = getNumProfilesCaptured();
															#line 49 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		int64_t exc = 0;
															#line 50 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		fprintf(stderr, "Slow task starting\n");
															#line 51 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		for(int i = 0;i < 10;i++) {
															#line 52 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			fprintf(stderr, "  %d\n", i);
															#line 53 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			double end = timer() + 1;
															#line 54 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
			for(;timer() < end;) {
															#line 55 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
				do_slow_exception_thing(&exc);
															#line 160 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
			}
		}
															#line 58 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		fmt::print(stderr, "Slow task complete: {0} exceptions; {1} calls to dl_iterate_phdr, {2}" " profiles disabled, {3} profiles overflowed, {4} profiles captured\n", exc, dl_iterate_phdr_calls - phc, getNumProfilesDisabled() - startProfilesDisabled, getNumProfilesOverflowed() - startProfilesOverflowed, getNumProfilesCaptured() - startProfilesCaptured);
															#line 67 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
		if (!static_cast<GoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GoActorState(); static_cast<GoActor*>(this)->destroy(); return 0; }
															#line 167 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
		new (&static_cast<GoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GoActorState();
		static_cast<GoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GoActor*>(this)->actor_wait_state > 0) static_cast<GoActor*>(this)->actor_wait_state = 0;
		static_cast<GoActor*>(this)->ActorCallback< GoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("go", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("go", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("go", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("go", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("go", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("go", reinterpret_cast<unsigned long>(this), 0);

	}
};
// This generated class is to be used only via go()
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
class GoActor final : public Actor<Void>, public ActorCallback< GoActor, 0, Void >, public FastAllocated<GoActor>, public GoActorState<GoActor> {
															#line 254 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
public:
	using FastAllocated<GoActor>::operator new;
	using FastAllocated<GoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17067761102655218688UL, 5287739667244136960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GoActor, 0, Void >;
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
	GoActor() 
															#line 271 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   GoActorState<GoActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("go", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9937340155987009024UL, 16845395648038552832UL);
		ActorExecutionContextHelper __helper(static_cast<GoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("go");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("go", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
[[nodiscard]] static Future<Void> go(  ) {
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"
	return Future<Void>(new GoActor());
															#line 303 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SlowTaskWorkload.actor.g.cpp"
}

#line 69 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/SlowTaskWorkload.actor.cpp"

	static void do_slow_exception_thing(int64_t* exc_count) {
		// Has to be a non-actor function so that actual exception unwinding occurs
		for (int j = 0; j < 1000; j++)
			try {
				throw success();
			} catch (Error&) {
				++*exc_count;
			}
	}
};

WorkloadFactory<SlowTaskWorkload> SlowTaskWorkloadFactory;
