#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
/*
 * BulkDumping.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BulkDumping.h"
#include "fdbclient/BulkLoading.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/MockS3Server.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/Platform.h"
#include "fdbrpc/simulator.h"
#include "flow/actorcompiler.h" // This must be the last #include.

const std::string simulationBulkDumpFolder = joinPath("simfdb", "bulkdump");

struct BulkDumping : TestWorkload {
	static constexpr auto NAME = "BulkDumpingWorkload";
	const bool enabled = true;
	bool pass = true;
	int cancelTimes = 0;
	int maxCancelTimes = 0;
	int bulkLoadTransportMethod = 1; // Default to CP method
	std::string jobRoot = "";

	// This workload is not compatible with following workload because they will race in changing the DD mode
	// This workload is not compatible with RandomRangeLock for the conflict in range lock
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomMoveKeys",
		             "DataLossRecovery",
		             "IDDTxnProcessorApiCorrectness",
		             "PerpetualWiggleStatsWorkload",
		             "PhysicalShardMove",
		             "StorageCorruption",
		             "StorageServerCheckpointRestoreTest",
		             "ValidateStorage",
		             "RandomRangeLock",
		             "BulkLoading" });
	}

	BulkDumping(WorkloadContext const& wcx)
	  : TestWorkload(wcx), enabled(true), pass(true), cancelTimes(0),
	    maxCancelTimes(getOption(options, "maxCancelTimes"_sr, deterministicRandom()->randomInt(0, 2))),
	    bulkLoadTransportMethod(getOption(options, "bulkLoadTransportMethod"_sr, 1)),
	    jobRoot(getOption(options, "jobRoot"_sr, ""_sr).toString()) {
		maxCancelTimes = 0; // TODO(BulkLoad): allow to cancel job when job ID randomly generated.
	}

	Future<Void> setup(Database const& cx) override { return _setup(this, cx); }

	Future<Void> start(Database const& cx) override { return _start(this, cx); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	Standalone<StringRef> getRandomStringRef() const {
		int stringLength = deterministicRandom()->randomInt(1, 10);
		Standalone<StringRef> stringBuffer = makeString(stringLength);
		deterministicRandom()->randomBytes(mutateString(stringBuffer), stringLength);
		return stringBuffer;
	}

	KeyRange getRandomRange(BulkDumping* self, KeyRange maxRange) const {
		loop {
			Standalone<StringRef> keyA = self->getRandomStringRef();
			Standalone<StringRef> keyB = self->getRandomStringRef();
			if (!maxRange.contains(keyA) || !maxRange.contains(keyB)) {
				continue;
			}
			KeyRange range = keyA < keyB ? KeyRangeRef(keyA, keyB) : KeyRangeRef(keyB, keyA);
			if (range.empty() || range.singleKeyRange()) {
				continue;
			}
			return range;
		}
	}

	std::map<Key, Value> generateOrderedKVS(BulkDumping* self, KeyRange maxRange, size_t count) {
		std::map<Key, Value> kvs; // ordered
		while (kvs.size() < count) {
			Key key = self->getRandomStringRef();
			if (!maxRange.contains(key)) {
				continue;
			}
			Value val = self->getRandomStringRef();
			auto res = kvs.insert({ key, val });
			if (!res.second) {
				continue;
			}
		}
		return kvs; // ordered
	}

																#line 117 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via setKeys()
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class SetKeysActor>
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class SetKeysActorState {
															#line 123 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	SetKeysActorState(Database const& cx,std::map<Key, Value> const& kvs) 
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   kvs(kvs),
															#line 116 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 134 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("setKeys", reinterpret_cast<unsigned long>(this));

	}
	~SetKeysActorState() 
	{
		fdb_probe_actor_destroy("setKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 149 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 119 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			for( const auto& [key, value] : kvs ) {
															#line 120 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				tr.set(key, value);
															#line 182 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 122 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 122 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 188 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 0, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 193 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 128 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 128 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<SetKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 217 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetKeysActor*>(this)->actor_wait_state = 2;
															#line 128 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetKeysActor, 1, Void >*>(static_cast<SetKeysActor*>(this)));
															#line 222 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoadSetKey") .detail("KeyCount", kvs.size()) .detail("Version", tr.getCommittedVersion());
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 239 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoadSetKey") .detail("KeyCount", kvs.size()) .detail("Version", tr.getCommittedVersion());
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<SetKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetKeysActorState(); static_cast<SetKeysActor*>(this)->destroy(); return 0; }
															#line 253 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<SetKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetKeysActorState();
		static_cast<SetKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetKeysActor*>(this)->actor_wait_state > 0) static_cast<SetKeysActor*>(this)->actor_wait_state = 0;
		static_cast<SetKeysActor*>(this)->ActorCallback< SetKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 116 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 429 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via setKeys()
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class SetKeysActor final : public Actor<Void>, public ActorCallback< SetKeysActor, 0, Void >, public ActorCallback< SetKeysActor, 1, Void >, public FastAllocated<SetKeysActor>, public SetKeysActorState<SetKeysActor> {
															#line 434 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<SetKeysActor>::operator new;
	using FastAllocated<SetKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6295752021685088768UL, 11314868333371534336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetKeysActor, 0, Void >;
friend struct ActorCallback< SetKeysActor, 1, Void >;
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	SetKeysActor(Database const& cx,std::map<Key, Value> const& kvs) 
															#line 452 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   SetKeysActorState<SetKeysActor>(cx, kvs),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13837835877790460416UL, 6372757415257859072UL);
		ActorExecutionContextHelper __helper(static_cast<SetKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> setKeys( Database const& cx, std::map<Key, Value> const& kvs ) {
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new SetKeysActor(cx, kvs));
															#line 485 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 132 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 490 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via waitUntilDumpJobComplete()
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class WaitUntilDumpJobCompleteActor>
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilDumpJobCompleteActorState {
															#line 496 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilDumpJobCompleteActorState(Database const& cx) 
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 134 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 505 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilDumpJobCompleteActorState() 
	{
		fdb_probe_actor_destroy("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 135 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 520 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilDumpJobCompleteActorState();
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 151 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilDumpJobCompleteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitUntilDumpJobCompleteActorState(); static_cast<WaitUntilDumpJobCompleteActor*>(this)->destroy(); return 0; }
															#line 543 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilDumpJobCompleteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitUntilDumpJobCompleteActorState();
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 137 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 138 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 139 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Optional<BulkDumpState>> __when_expr_0 = getSubmittedBulkDumpJob(&tr);
															#line 139 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 569 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 1;
															#line 139 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 574 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 149 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(30.0);
															#line 149 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 604 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 3;
															#line 149 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 609 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 144 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 619 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 145 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 623 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 147 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 147 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 629 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 2;
															#line 147 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*>(static_cast<WaitUntilDumpJobCompleteActor*>(this)));
															#line 634 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> const& aliveJob,int loopDepth) 
	{
															#line 140 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!aliveJob.present())
															#line 649 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<BulkDumpState> && aliveJob,int loopDepth) 
	{
															#line 140 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!aliveJob.present())
															#line 661 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> const& aliveJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(aliveJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkDumpState> && aliveJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(aliveJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Optional<BulkDumpState> && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilDumpJobCompleteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilDumpJobCompleteActor*>(this)->ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 134 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 935 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via waitUntilDumpJobComplete()
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilDumpJobCompleteActor final : public Actor<Void>, public ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >, public ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >, public ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >, public FastAllocated<WaitUntilDumpJobCompleteActor>, public WaitUntilDumpJobCompleteActorState<WaitUntilDumpJobCompleteActor> {
															#line 940 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<WaitUntilDumpJobCompleteActor>::operator new;
	using FastAllocated<WaitUntilDumpJobCompleteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2340033286369619712UL, 18302952661122148608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >;
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >;
friend struct ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >;
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilDumpJobCompleteActor(Database const& cx) 
															#line 959 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   WaitUntilDumpJobCompleteActorState<WaitUntilDumpJobCompleteActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14347013697826418176UL, 10344504171819541760UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilDumpJobCompleteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilDumpJobComplete");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilDumpJobComplete", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 0, Optional<BulkDumpState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitUntilDumpJobCompleteActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> waitUntilDumpJobComplete( Database const& cx ) {
															#line 133 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new WaitUntilDumpJobCompleteActor(cx));
															#line 993 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 153 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 998 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via clearDatabase()
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ClearDatabaseActor>
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearDatabaseActorState {
															#line 1004 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearDatabaseActorState(Database const& cx) 
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 155 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 1013 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClearDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1028 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 170 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ClearDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDatabaseActorState(); static_cast<ClearDatabaseActor*>(this)->destroy(); return 0; }
															#line 1051 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ClearDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 158 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 159 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 160 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(normalKeys);
															#line 161 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkDumpKeys);
															#line 162 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkLoadJobKeys);
															#line 163 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(bulkLoadTaskKeys);
															#line 164 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 164 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1085 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 1;
															#line 164 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 0, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 1090 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 167 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 167 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1127 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 2;
															#line 167 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 1, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 1132 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 155 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 1321 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via clearDatabase()
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearDatabaseActor final : public Actor<Void>, public ActorCallback< ClearDatabaseActor, 0, Void >, public ActorCallback< ClearDatabaseActor, 1, Void >, public FastAllocated<ClearDatabaseActor>, public ClearDatabaseActorState<ClearDatabaseActor> {
															#line 1326 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ClearDatabaseActor>::operator new;
	using FastAllocated<ClearDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5130868394098183680UL, 11069760029081015808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearDatabaseActor, 0, Void >;
friend struct ActorCallback< ClearDatabaseActor, 1, Void >;
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearDatabaseActor(Database const& cx) 
															#line 1344 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   ClearDatabaseActorState<ClearDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2535882093937434112UL, 5291521835449874944UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> clearDatabase( Database const& cx ) {
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new ClearDatabaseActor(cx));
															#line 1377 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 172 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 1382 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via clearRangeData()
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ClearRangeDataActor>
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearRangeDataActorState {
															#line 1388 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearRangeDataActorState(Database const& cx,KeyRange const& range) 
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   range(range),
															#line 174 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx)
															#line 1399 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("clearRangeData", reinterpret_cast<unsigned long>(this));

	}
	~ClearRangeDataActorState() 
	{
		fdb_probe_actor_destroy("clearRangeData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 175 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1414 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearRangeDataActorState();
		static_cast<ClearRangeDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 185 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ClearRangeDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearRangeDataActorState(); static_cast<ClearRangeDataActor*>(this)->destroy(); return 0; }
															#line 1437 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ClearRangeDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearRangeDataActorState();
		static_cast<ClearRangeDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 177 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 178 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.clear(range);
															#line 179 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 179 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearRangeDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1463 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearRangeDataActor*>(this)->actor_wait_state = 1;
															#line 179 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearRangeDataActor, 0, Void >*>(static_cast<ClearRangeDataActor*>(this)));
															#line 1468 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 182 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 182 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ClearRangeDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1505 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearRangeDataActor*>(this)->actor_wait_state = 2;
															#line 182 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearRangeDataActor, 1, Void >*>(static_cast<ClearRangeDataActor*>(this)));
															#line 1510 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearRangeDataActor*>(this)->actor_wait_state > 0) static_cast<ClearRangeDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearRangeDataActor*>(this)->ActorCallback< ClearRangeDataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearRangeDataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearRangeDataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearRangeDataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearRangeDataActor*>(this)->actor_wait_state > 0) static_cast<ClearRangeDataActor*>(this)->actor_wait_state = 0;
		static_cast<ClearRangeDataActor*>(this)->ActorCallback< ClearRangeDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearRangeDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearRangeDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearRangeDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange range;
															#line 174 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 1701 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via clearRangeData()
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ClearRangeDataActor final : public Actor<Void>, public ActorCallback< ClearRangeDataActor, 0, Void >, public ActorCallback< ClearRangeDataActor, 1, Void >, public FastAllocated<ClearRangeDataActor>, public ClearRangeDataActorState<ClearRangeDataActor> {
															#line 1706 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ClearRangeDataActor>::operator new;
	using FastAllocated<ClearRangeDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11936581583124600832UL, 8925193843708877056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearRangeDataActor, 0, Void >;
friend struct ActorCallback< ClearRangeDataActor, 1, Void >;
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ClearRangeDataActor(Database const& cx,KeyRange const& range) 
															#line 1724 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   ClearRangeDataActorState<ClearRangeDataActor>(cx, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearRangeData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18334867820139837184UL, 17574362521324748544UL);
		ActorExecutionContextHelper __helper(static_cast<ClearRangeDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearRangeData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearRangeData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearRangeDataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearRangeDataActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> clearRangeData( Database const& cx, KeyRange const& range ) {
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new ClearRangeDataActor(cx, range));
															#line 1757 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 187 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

	// Return error tasks
																#line 1763 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via validateAllBulkLoadTaskAcknowledgedOrError()
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState {
															#line 1769 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState(Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobRange(jobRange),
															#line 192 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   rangeResult(),
															#line 193 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   beginKey(jobRange.begin),
															#line 194 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   endKey(jobRange.end),
															#line 195 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx),
															#line 196 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   errorTasks()
															#line 1790 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this));

	}
	~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState() 
	{
		fdb_probe_actor_destroy("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "ValidateAllBulkLoadTaskAcknowledgedOrError") .detail("Job", jobId.toString()) .detail("Range", jobRange);
															#line 201 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 1807 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState();
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 239 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState(); static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->destroy(); return 0; }
															#line 1830 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::move(errorTasks)); // state_var_RVO
		this->~ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState();
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 201 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!(beginKey < endKey))
															#line 1849 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 203 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 205 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			rangeResult.clear();
															#line 206 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(rangeResult, krmGetRanges(&tr, bulkLoadTaskPrefix, KeyRangeRef(beginKey, endKey)));
															#line 206 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1864 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 1;
															#line 206 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*>(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)));
															#line 1869 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 236 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 236 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1906 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 2;
															#line 236 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*>(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)));
															#line 1911 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 208 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (rangeResult[i].value.empty())
															#line 1928 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 211 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 212 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 1936 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 215 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.getJobId() != jobId)
															#line 1942 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 216 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1loopBody1Catch1(bulkload_task_outdated(), loopDepth);
															#line 1946 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 218 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 1950 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 219 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevWarnAlways, "BulkDumpingWorkLoadBulkLoadTaskHasError") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 223 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				errorTasks.push_back(bulkLoadTaskState);
															#line 1956 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 225 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase != BulkLoadPhase::Acknowledged && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 1960 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 227 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevError, "BulkDumpingWorkLoadBulkLoadTaskWrongPhase") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 231 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(false);
															#line 1966 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
															#line 234 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		beginKey = rangeResult.back().key;
															#line 1971 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 207 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for(int i = 0;i < rangeResult.size() - 1;++i) {
															#line 208 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (rangeResult[i].value.empty())
															#line 1982 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 211 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			BulkLoadTaskState bulkLoadTaskState = decodeBulkLoadTaskState(rangeResult[i].value);
															#line 212 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (!bulkLoadTaskState.isValid())
															#line 1990 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
				continue;
			}
															#line 215 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.getJobId() != jobId)
															#line 1996 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 216 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				return a_body1loopBody1Catch1(bulkload_task_outdated(), loopDepth);
															#line 2000 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 218 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase == BulkLoadPhase::Error)
															#line 2004 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 219 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevWarnAlways, "BulkDumpingWorkLoadBulkLoadTaskHasError") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 223 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				errorTasks.push_back(bulkLoadTaskState);
															#line 2010 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 225 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (bulkLoadTaskState.phase != BulkLoadPhase::Acknowledged && bulkLoadTaskState.phase != BulkLoadPhase::Error)
															#line 2014 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 227 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				TraceEvent(SevError, "BulkDumpingWorkLoadBulkLoadTaskWrongPhase") .setMaxEventLength(-1) .setMaxFieldLength(-1) .detail("Task", bulkLoadTaskState.toString());
															#line 231 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(false);
															#line 2020 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
															#line 234 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		beginKey = rangeResult.back().key;
															#line 2025 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state > 0) static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state > 0) static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange jobRange;
															#line 192 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	RangeResult rangeResult;
															#line 193 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Key beginKey;
															#line 194 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Key endKey;
															#line 195 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 196 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<BulkLoadTaskState> errorTasks;
															#line 2221 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via validateAllBulkLoadTaskAcknowledgedOrError()
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateAllBulkLoadTaskAcknowledgedOrErrorActor final : public Actor<std::vector<BulkLoadTaskState>>, public ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >, public ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >, public FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>, public ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor> {
															#line 2226 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>::operator new;
	using FastAllocated<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15255354615251904768UL, 15817318264873692672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BulkLoadTaskState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >;
friend struct ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >;
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateAllBulkLoadTaskAcknowledgedOrErrorActor(Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 2244 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::vector<BulkLoadTaskState>>(),
		   ValidateAllBulkLoadTaskAcknowledgedOrErrorActorState<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor>(cx, jobId, jobRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11830555534422417920UL, 14829119776246766336UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateAllBulkLoadTaskAcknowledgedOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateAllBulkLoadTaskAcknowledgedOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateAllBulkLoadTaskAcknowledgedOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateAllBulkLoadTaskAcknowledgedOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::vector<BulkLoadTaskState>> validateAllBulkLoadTaskAcknowledgedOrError( Database const& cx, UID const& jobId, KeyRange const& jobRange ) {
															#line 189 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::vector<BulkLoadTaskState>>(new ValidateAllBulkLoadTaskAcknowledgedOrErrorActor(cx, jobId, jobRange));
															#line 2277 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 241 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 2282 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via waitUntilLoadJobCompleteOrError()
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class WaitUntilLoadJobCompleteOrErrorActor>
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilLoadJobCompleteOrErrorActorState {
															#line 2288 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilLoadJobCompleteOrErrorActorState(BulkDumping* const& self,Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : self(self),
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   cx(cx),
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobRange(jobRange)
															#line 2301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	~WaitUntilLoadJobCompleteOrErrorActorState() 
	{
		fdb_probe_actor_destroy("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 246 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 2316 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 247 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Optional<BulkLoadJobState>> __when_expr_0 = getRunningBulkLoadJob(cx);
															#line 247 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2348 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 1;
															#line 247 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2353 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> const& runningJob,int loopDepth) 
	{
															#line 248 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (runningJob.present())
															#line 2362 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 249 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(runningJob.get().getJobId() == jobId);
															#line 254 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (SERVER_KNOBS->BULKLOAD_SIM_FAILURE_INJECTION && self->cancelTimes < self->maxCancelTimes && deterministicRandom()->random01() < 0.1)
															#line 2368 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 256 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				StrictFuture<Void> __when_expr_1 = cancelBulkLoadJob(cx, jobId);
															#line 256 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2374 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 256 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2379 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<BulkLoadJobState> && runningJob,int loopDepth) 
	{
															#line 248 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (runningJob.present())
															#line 2398 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 249 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(runningJob.get().getJobId() == jobId);
															#line 254 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (SERVER_KNOBS->BULKLOAD_SIM_FAILURE_INJECTION && self->cancelTimes < self->maxCancelTimes && deterministicRandom()->random01() < 0.1)
															#line 2404 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 256 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				StrictFuture<Void> __when_expr_1 = cancelBulkLoadJob(cx, jobId);
															#line 256 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2410 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 2;
															#line 256 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2415 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> const& runningJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(runningJob, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<BulkLoadJobState> && runningJob,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(runningJob), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Optional<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 269 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_4 = self->validateAllBulkLoadTaskAcknowledgedOrError(cx, jobId, jobRange);
															#line 269 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2511 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 5;
															#line 269 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2516 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 266 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(10.0);
															#line 266 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2527 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 4;
															#line 266 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2532 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 257 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		self->cancelTimes++;
															#line 258 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Job Cancelled").detail("Job", jobId.toString());
															#line 259 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->clearRangeData(cx, jobRange);
															#line 259 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2547 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 3;
															#line 259 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2552 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 257 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		self->cancelTimes++;
															#line 258 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Job Cancelled").detail("Job", jobId.toString());
															#line 259 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->clearRangeData(cx, jobRange);
															#line 259 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2567 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 3;
															#line 259 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*>(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)));
															#line 2572 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Data Cleared") .detail("Job", jobId.toString()) .detail("JobRange", jobRange);
															#line 264 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(std::vector<BulkLoadTaskState>()); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2658 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::vector<BulkLoadTaskState>());
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 260 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Data Cleared") .detail("Job", jobId.toString()) .detail("JobRange", jobRange);
															#line 264 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(std::vector<BulkLoadTaskState>()); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2672 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(std::vector<BulkLoadTaskState>());
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont9(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
															#line 271 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2846 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(errorTasks);
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
															#line 271 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV<std::vector<BulkLoadTaskState>>::futures) { (void)(errorTasks); this->~WaitUntilLoadJobCompleteOrErrorActorState(); static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->destroy(); return 0; }
															#line 2858 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->SAV< std::vector<BulkLoadTaskState> >::value()) std::vector<BulkLoadTaskState>(errorTasks);
		this->~WaitUntilLoadJobCompleteOrErrorActorState();
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<BulkLoadTaskState> const& errorTasks,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(errorTasks, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::vector<BulkLoadTaskState> && errorTasks,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(errorTasks), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state > 0) static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumping* self;
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange jobRange;
															#line 2949 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via waitUntilLoadJobCompleteOrError()
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class WaitUntilLoadJobCompleteOrErrorActor final : public Actor<std::vector<BulkLoadTaskState>>, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >, public ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >, public FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>, public WaitUntilLoadJobCompleteOrErrorActorState<WaitUntilLoadJobCompleteOrErrorActor> {
															#line 2954 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>::operator new;
	using FastAllocated<WaitUntilLoadJobCompleteOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2321888650666840064UL, 14832486705699205888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BulkLoadTaskState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >;
friend struct ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >;
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	WaitUntilLoadJobCompleteOrErrorActor(BulkDumping* const& self,Database const& cx,UID const& jobId,KeyRange const& jobRange) 
															#line 2975 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::vector<BulkLoadTaskState>>(),
		   WaitUntilLoadJobCompleteOrErrorActorState<WaitUntilLoadJobCompleteOrErrorActor>(self, cx, jobId, jobRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16253690126426733056UL, 3412635736290458112UL);
		ActorExecutionContextHelper __helper(static_cast<WaitUntilLoadJobCompleteOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitUntilLoadJobCompleteOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitUntilLoadJobCompleteOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 0, Optional<BulkLoadJobState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< WaitUntilLoadJobCompleteOrErrorActor, 4, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::vector<BulkLoadTaskState>> waitUntilLoadJobCompleteOrError( BulkDumping* const& self, Database const& cx, UID const& jobId, KeyRange const& jobRange ) {
															#line 242 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::vector<BulkLoadTaskState>>(new WaitUntilLoadJobCompleteOrErrorActor(self, cx, jobId, jobRange));
															#line 3011 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 274 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 3016 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via validateBulkLoadJobHistory()
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class ValidateBulkLoadJobHistoryActor>
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateBulkLoadJobHistoryActorState {
															#line 3022 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateBulkLoadJobHistoryActorState(Database const& cx,UID const& jobId,bool const& hasError,bool const& bulkDumpRangeContainBulkLoadRange) 
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   jobId(jobId),
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   hasError(hasError),
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   bulkDumpRangeContainBulkLoadRange(bulkDumpRangeContainBulkLoadRange)
															#line 3035 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this));

	}
	~ValidateBulkLoadJobHistoryActorState() 
	{
		fdb_probe_actor_destroy("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<std::vector<BulkLoadJobState>> __when_expr_0 = getBulkLoadJobFromHistory(cx);
															#line 279 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3052 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state = 1;
															#line 279 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*>(static_cast<ValidateBulkLoadJobHistoryActor*>(this)));
															#line 3057 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> const& jobHistory,int loopDepth) 
	{
															#line 280 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		Optional<BulkLoadJobState> jobInHistory;
															#line 281 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& job : jobHistory ) {
															#line 282 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.isValid());
															#line 283 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.getJobId() == jobId);
															#line 284 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(!jobInHistory.present());
															#line 285 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			jobInHistory = job;
															#line 3090 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 287 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(jobInHistory.present());
															#line 288 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (hasError || !bulkDumpRangeContainBulkLoadRange)
															#line 3096 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 289 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Error);
															#line 290 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getErrorMessage().present());
															#line 291 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (jobInHistory.get().getErrorMessage().get().find( std::to_string(bulkload_dataset_not_cover_required_range().code())) != std::string::npos)
															#line 3104 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 293 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(!bulkDumpRangeContainBulkLoadRange);
															#line 3108 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
		else
		{
															#line 296 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Complete);
															#line 3115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 298 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateBulkLoadJobHistoryActorState(); static_cast<ValidateBulkLoadJobHistoryActor*>(this)->destroy(); return 0; }
															#line 3119 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BulkLoadJobState> && jobHistory,int loopDepth) 
	{
															#line 280 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		Optional<BulkLoadJobState> jobInHistory;
															#line 281 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& job : jobHistory ) {
															#line 282 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.isValid());
															#line 283 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(job.getJobId() == jobId);
															#line 284 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(!jobInHistory.present());
															#line 285 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			jobInHistory = job;
															#line 3141 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 287 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(jobInHistory.present());
															#line 288 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (hasError || !bulkDumpRangeContainBulkLoadRange)
															#line 3147 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 289 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Error);
															#line 290 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getErrorMessage().present());
															#line 291 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (jobInHistory.get().getErrorMessage().get().find( std::to_string(bulkload_dataset_not_cover_required_range().code())) != std::string::npos)
															#line 3155 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 293 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				ASSERT(!bulkDumpRangeContainBulkLoadRange);
															#line 3159 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
		}
		else
		{
															#line 296 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(jobInHistory.get().getPhase() == BulkLoadJobPhase::Complete);
															#line 3166 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 298 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateBulkLoadJobHistoryActorState(); static_cast<ValidateBulkLoadJobHistoryActor*>(this)->destroy(); return 0; }
															#line 3170 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<ValidateBulkLoadJobHistoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateBulkLoadJobHistoryActorState();
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> const& jobHistory,int loopDepth) 
	{
		loopDepth = a_body1cont1(jobHistory, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<BulkLoadJobState> && jobHistory,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(jobHistory), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state > 0) static_cast<ValidateBulkLoadJobHistoryActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateBulkLoadJobHistoryActor*>(this)->ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> const& value) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,std::vector<BulkLoadJobState> && value) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*,Error err) 
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID jobId;
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool hasError;
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool bulkDumpRangeContainBulkLoadRange;
															#line 3261 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via validateBulkLoadJobHistory()
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class ValidateBulkLoadJobHistoryActor final : public Actor<Void>, public ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >, public FastAllocated<ValidateBulkLoadJobHistoryActor>, public ValidateBulkLoadJobHistoryActorState<ValidateBulkLoadJobHistoryActor> {
															#line 3266 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<ValidateBulkLoadJobHistoryActor>::operator new;
	using FastAllocated<ValidateBulkLoadJobHistoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8791981157919203584UL, 13942584612018722816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >;
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	ValidateBulkLoadJobHistoryActor(Database const& cx,UID const& jobId,bool const& hasError,bool const& bulkDumpRangeContainBulkLoadRange) 
															#line 3283 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateBulkLoadJobHistoryActorState<ValidateBulkLoadJobHistoryActor>(cx, jobId, hasError, bulkDumpRangeContainBulkLoadRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2460049204226600192UL, 15679977865403206656UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateBulkLoadJobHistoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateBulkLoadJobHistory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateBulkLoadJobHistory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateBulkLoadJobHistoryActor, 0, std::vector<BulkLoadJobState> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> validateBulkLoadJobHistory( Database const& cx, UID const& jobId, bool const& hasError, bool const& bulkDumpRangeContainBulkLoadRange ) {
															#line 275 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new ValidateBulkLoadJobHistoryActor(cx, jobId, hasError, bulkDumpRangeContainBulkLoadRange));
															#line 3315 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 300 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 3320 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via getAllKVSFromDB()
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class GetAllKVSFromDBActor>
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class GetAllKVSFromDBActorState {
															#line 3326 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	GetAllKVSFromDBActorState(Database const& cx) 
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : cx(cx),
															#line 302 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   tr(cx),
															#line 303 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   kvs()
															#line 3337 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("getAllKVSFromDB", reinterpret_cast<unsigned long>(this));

	}
	~GetAllKVSFromDBActorState() 
	{
		fdb_probe_actor_destroy("getAllKVSFromDB", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 304 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			;
															#line 3352 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAllKVSFromDBActorState();
		static_cast<GetAllKVSFromDBActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 318 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<GetAllKVSFromDBActor*>(this)->SAV<std::map<Key, Value>>::futures) { (void)(kvs); this->~GetAllKVSFromDBActorState(); static_cast<GetAllKVSFromDBActor*>(this)->destroy(); return 0; }
															#line 3375 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<GetAllKVSFromDBActor*>(this)->SAV< std::map<Key, Value> >::value()) std::map<Key, Value>(std::move(kvs)); // state_var_RVO
		this->~GetAllKVSFromDBActorState();
		static_cast<GetAllKVSFromDBActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 306 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(normalKeys, CLIENT_KNOBS->TOO_MANY);
															#line 306 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3397 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 1;
															#line 306 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*>(static_cast<GetAllKVSFromDBActor*>(this)));
															#line 3402 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 315 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 315 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3439 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 2;
															#line 315 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAllKVSFromDBActor, 1, Void >*>(static_cast<GetAllKVSFromDBActor*>(this)));
															#line 3444 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& kvsRes,int loopDepth) 
	{
															#line 307 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(!kvsRes.more);
															#line 308 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		kvs.clear();
															#line 309 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( auto& kv : kvsRes ) {
															#line 310 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			auto res = kvs.insert({ kv.key, kv.value });
															#line 311 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(res.second);
															#line 3467 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && kvsRes,int loopDepth) 
	{
															#line 307 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(!kvsRes.more);
															#line 308 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		kvs.clear();
															#line 309 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( auto& kv : kvsRes ) {
															#line 310 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			auto res = kvs.insert({ kv.key, kv.value });
															#line 311 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			ASSERT(res.second);
															#line 3485 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& kvsRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(kvsRes, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && kvsRes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(kvsRes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllKVSFromDBActor*>(this)->ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state > 0) static_cast<GetAllKVSFromDBActor*>(this)->actor_wait_state = 0;
		static_cast<GetAllKVSFromDBActor*>(this)->ActorCallback< GetAllKVSFromDBActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAllKVSFromDBActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 302 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Transaction tr;
															#line 303 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 3659 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via getAllKVSFromDB()
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class GetAllKVSFromDBActor final : public Actor<std::map<Key, Value>>, public ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >, public ActorCallback< GetAllKVSFromDBActor, 1, Void >, public FastAllocated<GetAllKVSFromDBActor>, public GetAllKVSFromDBActorState<GetAllKVSFromDBActor> {
															#line 3664 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<GetAllKVSFromDBActor>::operator new;
	using FastAllocated<GetAllKVSFromDBActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17576279329217104384UL, 9432530073227442176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::map<Key, Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >;
friend struct ActorCallback< GetAllKVSFromDBActor, 1, Void >;
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	GetAllKVSFromDBActor(Database const& cx) 
															#line 3682 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<std::map<Key, Value>>(),
		   GetAllKVSFromDBActorState<GetAllKVSFromDBActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17382421922843443968UL, 2360388894854266368UL);
		ActorExecutionContextHelper __helper(static_cast<GetAllKVSFromDBActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAllKVSFromDB");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAllKVSFromDB", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAllKVSFromDBActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAllKVSFromDBActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<std::map<Key, Value>> getAllKVSFromDB( Database const& cx ) {
															#line 301 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<std::map<Key, Value>>(new GetAllKVSFromDBActor(cx));
															#line 3715 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 320 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

	bool keyContainedInRanges(const Key& key, const std::vector<KeyRange>& ranges) {
		for (const auto& range : ranges) {
			if (range.contains(key)) {
				return true;
			}
		}
		return false;
	}

	// kvs is the key value pairs generated initially in the database.
	// newKvs is the key value pairs loaded by the bulk loading job.
	// The workload first does bulkdump which only dumps the data within the bulkDumpJobRange.
	// The workload then does bulkload which loads the data within the bulkLoadJobRange.
	// The bulkLoadJob may be failed with unretryable error. So, some ranges (i.e. ignoreRanges) is not loaded.
	// This function compares the consistency between kvs and newKvs within bulkLoadJobRange and bulkDumpJobRange and
	// outside ignoreRanges. If a key in kvs is outside the bulkDumpJobRange, the newKvs should not contain the key.
	void processCheck(BulkDumping* self,
	                  std::map<Key, Value> kvs,
	                  std::map<Key, Value> newKvs,
	                  KeyRange bulkLoadJobRange,
	                  KeyRange bulkDumpJobRange,
	                  std::vector<KeyRange> ignoreRanges) {
		std::vector<KeyValue> kvsToCheck;
		std::vector<KeyValue> newKvsToCheck;
		std::unordered_set<Key> keyOutsideDumpData;
		for (const auto& [key, value] : kvs) {
			if (!bulkDumpJobRange.contains(key)) {
				keyOutsideDumpData.insert(key);
				continue; // kvs may contain keys outside the bulkDumpJobRange
			}
			if (self->keyContainedInRanges(key, ignoreRanges)) {
				continue;
			}
			if (!bulkLoadJobRange.contains(key)) {
				continue; // kvs may contain keys outside the bulkLoadJobRange
			}
			kvsToCheck.push_back(KeyValueRef(key, value));
		}
		for (const auto& [key, value] : newKvs) {
			// newKvs should not contain keys outside the bulkDumpJobRange
			ASSERT(keyOutsideDumpData.find(key) == keyOutsideDumpData.end() && bulkDumpJobRange.contains(key));
			if (self->keyContainedInRanges(key, ignoreRanges)) {
				continue;
			}
			// newKvs should not contain keys outside the bulkLoadJobRange nor bulkDumpJobRange
			ASSERT(bulkLoadJobRange.contains(key));
			ASSERT(bulkDumpJobRange.contains(key));
			newKvsToCheck.push_back(KeyValueRef(key, value));
		}
		if (kvsToCheck != newKvsToCheck) {
			TraceEvent(SevError, "BulkDumpingWorkLoadError")
			    .detail("KVS", kvsToCheck.size())
			    .detail("NewKVS", newKvsToCheck.size());
			ASSERT(false);
		}
	}

	// This workload does following:
	// (1) Generate 1000 key value pairs in normalKey space;
	// (2) Randomly select a key range from normalKey space;
	// (3) Submit a bulk dump job with the selected key range;
	// (4) Wait until the bulk dump job completes;
	// (5) Clear the database;
	// (6) Randomly select a key range from normalKey space;
	// (7) Submit a bulk load job with the selected key range;
	// (8) Wait until the bulk load job completes;
	// (9) Validate the loaded data in DB is same as the data in DB before dumping within the bulkdump job range and
	// bulkload job range. Note that the bulkload job can be unretriable error. In this case, we ignore the error range;
	// (10) Validate the bulk load job history.
																#line 3789 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class _startActor>
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _startActorState {
															#line 3795 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_startActorState(BulkDumping* const& self,Database const& cx) 
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : self(self),
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   cx(cx)
															#line 3804 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 391 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (self->clientId != 0)
															#line 3819 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 392 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3823 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_startActorState();
				static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 394 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (g_network->isSimulated())
															#line 3831 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 398 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				disableConnectionFailures("BulkDumping");
															#line 3835 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			}
															#line 401 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpJobRange = deterministicRandom()->coinflip() ? normalKeys : self->getRandomRange(self, normalKeys);
															#line 404 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = true;
															#line 409 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			kvs = self->generateOrderedKVS(self, normalKeys, 1000);
															#line 410 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->setKeys(cx, kvs);
															#line 410 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3847 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 410 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3852 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 413 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = registerRangeLockOwner(cx, rangeLockNameForBulkLoad, rangeLockNameForBulkLoad);
															#line 413 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3877 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 413 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3882 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 413 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_1 = registerRangeLockOwner(cx, rangeLockNameForBulkLoad, rangeLockNameForBulkLoad);
															#line 413 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3893 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 413 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3898 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 415 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 415 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3984 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 415 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 3989 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 415 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_2 = getAllRangeLockOwners(cx);
															#line 415 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4000 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 415 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 4005 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
															#line 416 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 419 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkDumpMode = 0;
															#line 420 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkDumpMode, setBulkDumpMode(cx, 1));
															#line 420 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4095 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 420 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4100 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
															#line 416 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwners.size() == 1 && lockOwners[0].getOwnerUniqueId() == rangeLockNameForBulkLoad);
															#line 419 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkDumpMode = 0;
															#line 420 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(oldBulkDumpMode, setBulkDumpMode(cx, 1));
															#line 420 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 420 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 4120 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<RangeLockOwner> const& lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont5(lockOwners, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(std::vector<RangeLockOwner> && lockOwners,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(lockOwners), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		dumpFolder = self->jobRoot.empty() ? simulationBulkDumpFolder : self->jobRoot;
															#line 422 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkDumpJob = createBulkDumpJob(bulkDumpJobRange, dumpFolder, BulkLoadType::SST, static_cast<BulkLoadTransportMethod>(self->bulkLoadTransportMethod));
															#line 427 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkDumpJob(cx, bulkDumpJob);
															#line 427 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4210 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 427 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 4215 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 421 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		dumpFolder = self->jobRoot.empty() ? simulationBulkDumpFolder : self->jobRoot;
															#line 422 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkDumpJob = createBulkDumpJob(bulkDumpJobRange, dumpFolder, BulkLoadType::SST, static_cast<BulkLoadTransportMethod>(self->bulkLoadTransportMethod));
															#line 427 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitBulkDumpJob(cx, bulkDumpJob);
															#line 427 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4230 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 427 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 4235 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 428 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Dump Job Submitted") .detail("TransportMethod", self->bulkLoadTransportMethod) .detail("JobRoot", dumpFolder) .detail("Job", bulkDumpJob.toString());
															#line 435 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->waitUntilDumpJobComplete(cx);
															#line 435 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4323 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 435 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 4328 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 428 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Dump Job Submitted") .detail("TransportMethod", self->bulkLoadTransportMethod) .detail("JobRoot", dumpFolder) .detail("Job", bulkDumpJob.toString());
															#line 435 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->waitUntilDumpJobComplete(cx);
															#line 435 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4341 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 435 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 4346 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 436 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Dump Job Complete").detail("Job", bulkDumpJob.toString());
															#line 439 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->clearDatabase(cx);
															#line 439 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4434 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 439 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 4439 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 436 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Dump Job Complete").detail("Job", bulkDumpJob.toString());
															#line 439 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->clearDatabase(cx);
															#line 439 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4452 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont8when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 439 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 4457 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 440 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Clear DB").detail("Job", bulkDumpJob.toString());
															#line 443 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkLoadMode = 0;
															#line 444 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 444 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4547 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 444 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4552 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 440 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad").detail("Phase", "Clear DB").detail("Job", bulkDumpJob.toString());
															#line 443 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldBulkLoadMode = 0;
															#line 444 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_7 = store(oldBulkLoadMode, setBulkLoadMode(cx, 1));
															#line 444 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4567 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 444 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 4572 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 445 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		;
															#line 4656 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 445 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		;
															#line 4665 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 513 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<std::pair<KeyRange, RangeLockState>>> __when_expr_14 = findExclusiveReadLockOnRange(cx, normalKeys, rangeLockNameForBulkLoad);
															#line 513 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4751 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 513 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*>(static_cast<_startActor*>(this)));
															#line 4756 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont10loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1(int loopDepth) 
	{
															#line 448 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		hasError = false;
															#line 449 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		oldCancelTimes = self->cancelTimes;
															#line 450 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkLoadJobRange = deterministicRandom()->coinflip() ? bulkDumpJob.getJobRange() : self->getRandomRange(self, deterministicRandom()->coinflip() ? normalKeys : bulkDumpJobRange);
															#line 454 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		dataSourceId = bulkDumpJob.getJobId();
															#line 455 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		dataSourceRoot = bulkDumpJob.getJobRoot();
															#line 456 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		bulkLoadJob = createBulkLoadJob(dataSourceId, bulkLoadJobRange, dataSourceRoot, static_cast<BulkLoadTransportMethod>(self->bulkLoadTransportMethod));
															#line 461 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_8 = submitBulkLoadJob(cx, bulkLoadJob);
															#line 461 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4786 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 461 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 4791 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10break1(int loopDepth) 
	{
		try {
			return a_body1cont10cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 462 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Load Job Submitted") .detail("JobId", dataSourceId) .detail("JobRange", bulkLoadJobRange) .detail("JobRoot", dataSourceRoot) .detail("TransportMethod", bulkLoadJob.getTransportMethod());
															#line 470 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorRanges = std::vector<KeyRange>();
															#line 471 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_9 = self->waitUntilLoadJobCompleteOrError(self, cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 471 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4819 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 471 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*>(static_cast<_startActor*>(this)));
															#line 4824 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 462 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Load Job Submitted") .detail("JobId", dataSourceId) .detail("JobRange", bulkLoadJobRange) .detail("JobRoot", dataSourceRoot) .detail("TransportMethod", bulkLoadJob.getTransportMethod());
															#line 470 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorRanges = std::vector<KeyRange>();
															#line 471 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<BulkLoadTaskState>> __when_expr_9 = self->waitUntilLoadJobCompleteOrError(self, cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 471 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4839 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont1when1(__when_expr_9.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 471 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*>(static_cast<_startActor*>(this)));
															#line 4844 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10loopBody1cont2(int loopDepth) 
	{
															#line 475 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(self->cancelTimes >= oldCancelTimes);
															#line 476 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (self->cancelTimes > oldCancelTimes)
															#line 4930 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 478 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			StrictFuture<Void> __when_expr_10 = delay(deterministicRandom()->random01() * 10.0);
															#line 478 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4936 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont2when1(__when_expr_10.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 478 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 4941 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1when1(std::vector<BulkLoadTaskState> const& __errorTasks,int loopDepth) 
	{
															#line 471 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		errorTasks = __errorTasks;
															#line 4955 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont10loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont1when1(std::vector<BulkLoadTaskState> && __errorTasks,int loopDepth) 
	{
		errorTasks = std::move(__errorTasks);
		loopDepth = a_body1cont10loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,std::vector<BulkLoadTaskState> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10loopBody1cont3(int loopDepth) 
	{
															#line 481 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		for( const auto& errorTask : errorTasks ) {
															#line 482 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			errorRanges.push_back(errorTask.getRange());
															#line 483 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			hasError = true;
															#line 5038 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 485 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkLoad") .detail("Phase", "Load Job Complete") .detail("BulkLoadJobId", dataSourceId) .detail("BulkLoadJobRange", bulkLoadJobRange) .detail("BulkLoadJobRoot", dataSourceRoot) .detail("BulkLoadTransportMethod", bulkLoadJob.getTransportMethod());
															#line 493 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::map<Key, Value>> __when_expr_11 = self->getAllKVSFromDB(cx);
															#line 493 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5046 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont3when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 493 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, std::map<Key, Value> >*>(static_cast<_startActor*>(this)));
															#line 5051 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont10loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont10loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont10loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont10loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10loopBody1cont6(std::map<Key, Value> const& newKvs,int loopDepth) 
	{
															#line 494 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (bulkDumpJobRange.contains(bulkLoadJobRange))
															#line 5147 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 495 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			self->processCheck(self, kvs, newKvs, bulkLoadJobRange, bulkDumpJobRange, errorRanges);
															#line 496 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = true;
															#line 5153 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		else
		{
															#line 498 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent(SevWarnAlways, "BulkDumpingWorkLoad") .detail("Phase", "SkippedCheck") .detail("BulkDumpJobRange", bulkDumpJobRange) .detail("BulkLoadJobRange", bulkLoadJobRange);
															#line 502 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = false;
															#line 5161 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 506 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_12 = acknowledgeAllErrorBulkLoadTasks(cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 506 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5167 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 506 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 5172 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont6(std::map<Key, Value> && newKvs,int loopDepth) 
	{
															#line 494 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (bulkDumpJobRange.contains(bulkLoadJobRange))
															#line 5181 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		{
															#line 495 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			self->processCheck(self, kvs, newKvs, bulkLoadJobRange, bulkDumpJobRange, errorRanges);
															#line 496 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = true;
															#line 5187 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
		else
		{
															#line 498 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			TraceEvent(SevWarnAlways, "BulkDumpingWorkLoad") .detail("Phase", "SkippedCheck") .detail("BulkDumpJobRange", bulkDumpJobRange) .detail("BulkLoadJobRange", bulkLoadJobRange);
															#line 502 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			bulkDumpRangeContainBulkLoadRange = false;
															#line 5195 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		}
															#line 506 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_12 = acknowledgeAllErrorBulkLoadTasks(cx, bulkLoadJob.getJobId(), bulkLoadJob.getJobRange());
															#line 506 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5201 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont6when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 506 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, Void >*>(static_cast<_startActor*>(this)));
															#line 5206 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3when1(std::map<Key, Value> const& newKvs,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont6(newKvs, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont3when1(std::map<Key, Value> && newKvs,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont6(std::move(newKvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, std::map<Key, Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, std::map<Key, Value> >*,std::map<Key, Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, std::map<Key, Value> >*,std::map<Key, Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, std::map<Key, Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 507 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_13 = self->validateBulkLoadJobHistory( cx, bulkLoadJob.getJobId(), hasError, bulkDumpRangeContainBulkLoadRange);
															#line 507 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5292 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont8when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 507 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5297 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 507 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_13 = self->validateBulkLoadJobHistory( cx, bulkLoadJob.getJobId(), hasError, bulkDumpRangeContainBulkLoadRange);
															#line 507 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5308 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont10loopBody1cont8when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 507 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 5313 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1cont10break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont10loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont2(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
															#line 515 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(res.empty());
															#line 517 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_15 = removeRangeLockOwner(cx, rangeLockNameForBulkLoad);
															#line 517 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5488 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_15.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 517 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5493 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
															#line 515 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(res.empty());
															#line 517 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<Void> __when_expr_15 = removeRangeLockOwner(cx, rangeLockNameForBulkLoad);
															#line 517 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5506 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_15.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 517 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 5511 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1when1(std::vector<std::pair<KeyRange, RangeLockState>> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(std::vector<std::pair<KeyRange, RangeLockState>> && res,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,std::vector<std::pair<KeyRange, RangeLockState>> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont3(Void const& _,int loopDepth) 
	{
															#line 519 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_16 = getAllRangeLockOwners(cx);
															#line 519 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5597 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 519 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 5602 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3(Void && _,int loopDepth) 
	{
															#line 519 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		StrictFuture<std::vector<RangeLockOwner>> __when_expr_16 = getAllRangeLockOwners(cx);
															#line 519 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5613 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_16.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 519 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*>(static_cast<_startActor*>(this)));
															#line 5618 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont4(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
															#line 520 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 522 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5704 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont4(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
															#line 520 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		ASSERT(lockOwnersAfterRemove.empty());
															#line 522 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5718 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont3when1(std::vector<RangeLockOwner> const& lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(lockOwnersAfterRemove, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(std::vector<RangeLockOwner> && lockOwnersAfterRemove,int loopDepth) 
	{
		loopDepth = a_body1cont10cont4(std::move(lockOwnersAfterRemove), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,std::vector<RangeLockOwner> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumping* self;
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 401 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange bulkDumpJobRange;
															#line 404 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool bulkDumpRangeContainBulkLoadRange;
															#line 409 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::map<Key, Value> kvs;
															#line 419 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldBulkDumpMode;
															#line 421 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::string dumpFolder;
															#line 422 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumpState bulkDumpJob;
															#line 443 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldBulkLoadMode;
															#line 448 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	bool hasError;
															#line 449 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	int oldCancelTimes;
															#line 450 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	KeyRange bulkLoadJobRange;
															#line 454 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	UID dataSourceId;
															#line 455 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::string dataSourceRoot;
															#line 456 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkLoadJobState bulkLoadJob;
															#line 470 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<KeyRange> errorRanges;
															#line 471 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	std::vector<BulkLoadTaskState> errorTasks;
															#line 5835 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, std::map<Key, Value> >, public ActorCallback< _startActor, 12, Void >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 5840 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11006236871205736704UL, 15890836993020076288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, std::map<Key, Value> >;
friend struct ActorCallback< _startActor, 12, Void >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >;
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_startActor(BulkDumping* const& self,Database const& cx) 
															#line 5873 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, std::vector<BulkLoadTaskState> >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, std::map<Key, Value> >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, Void >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, std::vector<std::pair<KeyRange, RangeLockState>> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, std::vector<RangeLockOwner> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> _start( BulkDumping* const& self, Database const& cx ) {
															#line 390 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 5921 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 524 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"

																#line 5926 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
template <class _setupActor>
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _setupActorState {
															#line 5932 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_setupActorState(BulkDumping* const& self,Database const& cx) 
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		 : self(self),
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		   cx(cx)
															#line 5941 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 527 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
			if (self->clientId == 0 && self->bulkLoadTransportMethod == 2)
															#line 5956 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
			{
															#line 529 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				bool useMockS3 = self->jobRoot.find("127.0.0.1") != std::string::npos || self->jobRoot.find("localhost") != std::string::npos || self->jobRoot.find("mock-s3-server") != std::string::npos;
															#line 533 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
				if (useMockS3 && g_network->isSimulated())
															#line 5962 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
				{
															#line 534 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
					TraceEvent("BulkDumpingWorkload") .detail("Phase", "Registering MockS3Server") .detail("JobRoot", self->jobRoot);
															#line 541 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
					StrictFuture<Void> __when_expr_0 = g_simulator->registerSimHTTPServer("127.0.0.1", "8080", makeReference<MockS3RequestHandler>());
															#line 541 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
					if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5970 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 541 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 5975 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 548 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 6008 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 543 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkload") .detail("Phase", "MockS3Server Registered") .detail("Address", "127.0.0.1:8080");
															#line 6026 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 543 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
		TraceEvent("BulkDumpingWorkload") .detail("Phase", "MockS3Server Registered") .detail("Address", "127.0.0.1:8080");
															#line 6035 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	BulkDumping* self;
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	Database cx;
															#line 6119 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 6124 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6065564927378229248UL, 10668299738960123392UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	_setupActor(BulkDumping* const& self,Database const& cx) 
															#line 6141 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
[[nodiscard]] Future<Void> _setup( BulkDumping* const& self, Database const& cx ) {
															#line 525 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 6173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BulkDumping.actor.g.cpp"
}

#line 550 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/workloads/BulkDumping.actor.cpp"
};

WorkloadFactory<BulkDumping> BulkDumpingFactory;