#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
/*
 * ClusterRecovery.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#include "flow/Trace.h"
#include <utility>

#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_CLUSTERRECOVERY_ACTOR_G_H)
#define FDBSERVER_CLUSTERRECOVERY_ACTOR_G_H
#include "fdbserver/ClusterRecovery.actor.g.h"
#elif !defined(FDBSERVER_CLUSTERRECOVERY_ACTOR_H)
#define FDBSERVER_CLUSTERRECOVERY_ACTOR_H

#include "fdbclient/DatabaseContext.h"
#include "fdbrpc/Replication.h"
#include "fdbrpc/ReplicationUtils.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h" // copy constructors for ServerCoordinators class
#include "fdbserver/ClusterController.actor.h"
#include "fdbserver/DBCoreState.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemConfig.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/MoveKeys.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/Error.h"
#include "flow/SystemMonitor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

class ClusterControllerData;

typedef enum {
	CLUSTER_RECOVERY_STATE_EVENT_NAME,
	CLUSTER_RECOVERY_COMMIT_TLOG_EVENT_NAME,
	CLUSTER_RECOVERY_DURATION_EVENT_NAME,
	CLUSTER_RECOVERY_GENERATION_EVENT_NAME,
	CLUSTER_RECOVERY_SS_RECRUITMENT_EVENT_NAME,
	CLUSTER_RECOVERY_INVALID_CONFIG_EVENT_NAME,
	CLUSTER_RECOVERY_RECOVERING_EVENT_NAME,
	CLUSTER_RECOVERY_RECOVERED_EVENT_NAME,
	CLUSTER_RECOVERY_SNAPSHOT_CHECK_EVENT_NAME,
	CLUSTER_RECOVERY_PAUSE_AGENT_BACKUP_EVENT_NAME,
	CLUSTER_RECOVERY_COMMIT_EVENT_NAME,
	CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME,
	CLUSTER_RECOVERY_METRICS_EVENT_NAME,
	CLUSTER_RECOVERY_LAST // Always the last entry
} ClusterRecoveryEventType;

															#line 73 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
[[nodiscard]] Future<Void> recoveryTerminateOnConflict( UID const& dbgid, Promise<Void> const& fullyRecovered, Future<Void> const& onConflict, Future<Void> const& switchedState );

#line 75 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
std::string& getRecoveryEventName(ClusterRecoveryEventType type);

class ReusableCoordinatedState : NonCopyable {
public:
	Promise<Void> fullyRecovered;
	DBCoreState prevDBState;
	DBCoreState myDBState;
	bool finalWriteStarted;
	Future<Void> previousWrite;

	ReusableCoordinatedState(ServerCoordinators const& coordinators,
	                         PromiseStream<Future<Void>> const& addActor,
	                         UID const& dbgid)
	  : finalWriteStarted(false), previousWrite(Void()), cstate(coordinators), coordinators(coordinators),
	    addActor(addActor), dbgid(dbgid) {}

	Future<Void> read() { return _read(this); }

	Future<Void> write(DBCoreState newState, bool finalWrite = false) {
		previousWrite = _write(this, newState, finalWrite);
		return previousWrite;
	}

	ServerCoordinators getCoordinators() const { return coordinators; }

	Future<Void> move(ClusterConnectionString const& nc) { return cstate.move(nc); }

private:
	MovableCoordinatedState cstate;
	ServerCoordinators coordinators;
	PromiseStream<Future<Void>> addActor;
	Promise<Void> switchedState;
	UID dbgid;

																#line 111 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
// This generated class is to be used only via _read()
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
template <class _readActor>
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
class _readActorState {
															#line 117 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
public:
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	_readActorState(ReusableCoordinatedState* const& self) 
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		 : self(self)
															#line 124 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
	{
		fdb_probe_actor_create("_read", reinterpret_cast<unsigned long>(this));

	}
	~_readActorState() 
	{
		fdb_probe_actor_destroy("_read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			StrictFuture<Value> __when_expr_0 = self->cstate.read();
															#line 110 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			if (static_cast<_readActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 141 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_readActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _readActor, 0, Value >*>(static_cast<_readActor*>(this)));
															#line 146 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_readActorState();
		static_cast<_readActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Value const& prevDBStateRaw,int loopDepth) 
	{
															#line 111 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		Future<Void> onConflict = recoveryTerminateOnConflict( self->dbgid, self->fullyRecovered, self->cstate.onConflict(), self->switchedState.getFuture());
															#line 113 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (onConflict.isReady() && onConflict.isError())
															#line 171 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 114 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			return a_body1Catch1(onConflict.getError(), loopDepth);
															#line 175 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
															#line 116 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		self->addActor.send(onConflict);
															#line 118 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (prevDBStateRaw.size())
															#line 181 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 119 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			self->prevDBState = BinaryReader::fromStringRef<DBCoreState>(prevDBStateRaw, IncludeVersion());
															#line 120 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			self->myDBState = self->prevDBState;
															#line 187 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
															#line 123 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (!static_cast<_readActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_readActorState(); static_cast<_readActor*>(this)->destroy(); return 0; }
															#line 191 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		new (&static_cast<_readActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_readActorState();
		static_cast<_readActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Value && prevDBStateRaw,int loopDepth) 
	{
															#line 111 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		Future<Void> onConflict = recoveryTerminateOnConflict( self->dbgid, self->fullyRecovered, self->cstate.onConflict(), self->switchedState.getFuture());
															#line 113 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (onConflict.isReady() && onConflict.isError())
															#line 205 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 114 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			return a_body1Catch1(onConflict.getError(), loopDepth);
															#line 209 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
															#line 116 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		self->addActor.send(onConflict);
															#line 118 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (prevDBStateRaw.size())
															#line 215 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 119 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			self->prevDBState = BinaryReader::fromStringRef<DBCoreState>(prevDBStateRaw, IncludeVersion());
															#line 120 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			self->myDBState = self->prevDBState;
															#line 221 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
															#line 123 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (!static_cast<_readActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_readActorState(); static_cast<_readActor*>(this)->destroy(); return 0; }
															#line 225 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		new (&static_cast<_readActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_readActorState();
		static_cast<_readActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Value const& prevDBStateRaw,int loopDepth) 
	{
		loopDepth = a_body1cont1(prevDBStateRaw, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Value && prevDBStateRaw,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(prevDBStateRaw), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_readActor*>(this)->actor_wait_state > 0) static_cast<_readActor*>(this)->actor_wait_state = 0;
		static_cast<_readActor*>(this)->ActorCallback< _readActor, 0, Value >::remove();

	}
	void a_callback_fire(ActorCallback< _readActor, 0, Value >*,Value const& value) 
	{
		fdb_probe_actor_enter("_read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_readActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _readActor, 0, Value >*,Value && value) 
	{
		fdb_probe_actor_enter("_read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_readActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _readActor, 0, Value >*,Error err) 
	{
		fdb_probe_actor_enter("_read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_readActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_read", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	ReusableCoordinatedState* self;
															#line 310 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
};
// This generated class is to be used only via _read()
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
class _readActor final : public Actor<Void>, public ActorCallback< _readActor, 0, Value >, public FastAllocated<_readActor>, public _readActorState<_readActor> {
															#line 315 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
public:
	using FastAllocated<_readActor>::operator new;
	using FastAllocated<_readActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6682233584674518016UL, 6045578758411751680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _readActor, 0, Value >;
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	_readActor(ReusableCoordinatedState* const& self) 
															#line 332 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		 : Actor<Void>(),
		   _readActorState<_readActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11743433206867511552UL, 4651902191675283456UL);
		ActorExecutionContextHelper __helper(static_cast<_readActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_read", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _readActor, 0, Value >*)0, actor_cancelled()); break;
		}

	}
};
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
[[nodiscard]] Future<Void> _read( ReusableCoordinatedState* const& self ) {
															#line 109 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	return Future<Void>(new _readActor(self));
															#line 364 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
}

#line 125 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"

																#line 369 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
// This generated class is to be used only via _write()
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
template <class _writeActor>
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
class _writeActorState {
															#line 375 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
public:
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	_writeActorState(ReusableCoordinatedState* const& self,DBCoreState const& newState,bool const& finalWrite) 
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		 : self(self),
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		   newState(newState),
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		   finalWrite(finalWrite)
															#line 386 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
	{
		fdb_probe_actor_create("_write", reinterpret_cast<unsigned long>(this));

	}
	~_writeActorState() 
	{
		fdb_probe_actor_destroy("_write", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			if (self->finalWriteStarted)
															#line 401 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
			{
															#line 128 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 128 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				if (static_cast<_writeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 407 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_writeActor*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _writeActor, 0, Void >*>(static_cast<_writeActor*>(this)));
															#line 412 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_writeActorState();
		static_cast<_writeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 131 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (finalWrite)
															#line 440 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 132 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			self->finalWriteStarted = true;
															#line 444 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
		try {
															#line 139 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			if (SERVER_KNOBS->RECORD_RECOVER_AT_IN_CSTATE)
															#line 449 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
			{
															#line 140 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				StrictFuture<Void> __when_expr_1 = self->cstate.setExclusive( BinaryWriter::toValue(newState, IncludeVersion(ProtocolVersion::withGcTxnGenerations())));
															#line 140 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				if (static_cast<_writeActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 455 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<_writeActor*>(this)->actor_wait_state = 2;
															#line 140 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _writeActor, 1, Void >*>(static_cast<_writeActor*>(this)));
															#line 460 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 143 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				StrictFuture<Void> __when_expr_2 = self->cstate.setExclusive( BinaryWriter::toValue(newState, IncludeVersion(ProtocolVersion::withEncryptionAtRest())));
															#line 143 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				if (static_cast<_writeActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 469 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
				static_cast<_writeActor*>(this)->actor_wait_state = 3;
															#line 143 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _writeActor, 2, Void >*>(static_cast<_writeActor*>(this)));
															#line 474 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_writeActor*>(this)->actor_wait_state > 0) static_cast<_writeActor*>(this)->actor_wait_state = 0;
		static_cast<_writeActor*>(this)->ActorCallback< _writeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _writeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _writeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _writeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 151 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		self->myDBState = newState;
															#line 153 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (!finalWrite)
															#line 579 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 154 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			self->switchedState.send(Void());
															#line 155 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			self->cstate = MovableCoordinatedState(self->coordinators);
															#line 156 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			StrictFuture<Value> __when_expr_3 = self->cstate.read();
															#line 156 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			if (static_cast<_writeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 589 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<_writeActor*>(this)->actor_wait_state = 4;
															#line 156 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _writeActor, 3, Value >*>(static_cast<_writeActor*>(this)));
															#line 594 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 170 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			self->fullyRecovered.send(Void());
															#line 601 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			CODE_PROBE(true, "Master displaced during writeMasterState");
															#line 148 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 614 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_writeActor*>(this)->actor_wait_state > 0) static_cast<_writeActor*>(this)->actor_wait_state = 0;
		static_cast<_writeActor*>(this)->ActorCallback< _writeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _writeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _writeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _writeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_writeActor*>(this)->actor_wait_state > 0) static_cast<_writeActor*>(this)->actor_wait_state = 0;
		static_cast<_writeActor*>(this)->ActorCallback< _writeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _writeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _writeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _writeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 173 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (!static_cast<_writeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_writeActorState(); static_cast<_writeActor*>(this)->destroy(); return 0; }
															#line 821 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		new (&static_cast<_writeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_writeActorState();
		static_cast<_writeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Value const& rereadDBStateRaw,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		DBCoreState readState;
															#line 158 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (rereadDBStateRaw.size())
															#line 835 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 159 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			readState = BinaryReader::fromStringRef<DBCoreState>(rereadDBStateRaw, IncludeVersion());
															#line 839 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
															#line 161 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (readState != newState)
															#line 843 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 162 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			TraceEvent("RecoveryTerminated", self->dbgid).detail("Reason", "CStateChanged");
															#line 163 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			CODE_PROBE(true, "Coordinated state changed between writing and reading, recovery restarting");
															#line 164 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 851 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
															#line 166 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		self->switchedState = Promise<Void>();
															#line 167 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		self->addActor.send(recoveryTerminateOnConflict( self->dbgid, self->fullyRecovered, self->cstate.onConflict(), self->switchedState.getFuture()));
															#line 857 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Value && rereadDBStateRaw,int loopDepth) 
	{
															#line 157 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		DBCoreState readState;
															#line 158 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (rereadDBStateRaw.size())
															#line 868 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 159 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			readState = BinaryReader::fromStringRef<DBCoreState>(rereadDBStateRaw, IncludeVersion());
															#line 872 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
															#line 161 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		if (readState != newState)
															#line 876 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		{
															#line 162 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			TraceEvent("RecoveryTerminated", self->dbgid).detail("Reason", "CStateChanged");
															#line 163 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			CODE_PROBE(true, "Coordinated state changed between writing and reading, recovery restarting");
															#line 164 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
			return a_body1Catch1(worker_removed(), loopDepth);
															#line 884 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		}
															#line 166 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		self->switchedState = Promise<Void>();
															#line 167 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
		self->addActor.send(recoveryTerminateOnConflict( self->dbgid, self->fullyRecovered, self->cstate.onConflict(), self->switchedState.getFuture()));
															#line 890 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Value const& rereadDBStateRaw,int loopDepth) 
	{
		loopDepth = a_body1cont10(rereadDBStateRaw, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Value && rereadDBStateRaw,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(rereadDBStateRaw), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_writeActor*>(this)->actor_wait_state > 0) static_cast<_writeActor*>(this)->actor_wait_state = 0;
		static_cast<_writeActor*>(this)->ActorCallback< _writeActor, 3, Value >::remove();

	}
	void a_callback_fire(ActorCallback< _writeActor, 3, Value >*,Value const& value) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _writeActor, 3, Value >*,Value && value) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _writeActor, 3, Value >*,Error err) 
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	ReusableCoordinatedState* self;
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	DBCoreState newState;
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	bool finalWrite;
															#line 976 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
};
// This generated class is to be used only via _write()
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
class _writeActor final : public Actor<Void>, public ActorCallback< _writeActor, 0, Void >, public ActorCallback< _writeActor, 1, Void >, public ActorCallback< _writeActor, 2, Void >, public ActorCallback< _writeActor, 3, Value >, public FastAllocated<_writeActor>, public _writeActorState<_writeActor> {
															#line 981 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
public:
	using FastAllocated<_writeActor>::operator new;
	using FastAllocated<_writeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1380243620467965184UL, 17020740621319327488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _writeActor, 0, Void >;
friend struct ActorCallback< _writeActor, 1, Void >;
friend struct ActorCallback< _writeActor, 2, Void >;
friend struct ActorCallback< _writeActor, 3, Value >;
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	_writeActor(ReusableCoordinatedState* const& self,DBCoreState const& newState,bool const& finalWrite) 
															#line 1001 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
		 : Actor<Void>(),
		   _writeActorState<_writeActor>(self, newState, finalWrite),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_write", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7366714684940189440UL, 115325792918598656UL);
		ActorExecutionContextHelper __helper(static_cast<_writeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_write");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_write", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _writeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _writeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _writeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _writeActor, 3, Value >*)0, actor_cancelled()); break;
		}

	}
};
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
[[nodiscard]] Future<Void> _write( ReusableCoordinatedState* const& self, DBCoreState const& newState, bool const& finalWrite ) {
															#line 126 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
	return Future<Void>(new _writeActor(self, newState, finalWrite));
															#line 1036 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
}

#line 175 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
};

struct ClusterRecoveryData : NonCopyable, ReferenceCounted<ClusterRecoveryData> {
	ClusterControllerData* controllerData;

	UID dbgid;

	AsyncTrigger registrationTrigger;
	Version lastEpochEnd, // The last version in the old epoch not (to be) rolled back in this recovery
	    recoveryTransactionVersion; // The first version in this epoch
	Optional<int64_t> versionEpoch; // The epoch which all versions are based off of
	double lastCommitTime;

	Version liveCommittedVersion; // The largest live committed version reported by commit proxies.
	bool databaseLocked;
	Optional<Value> proxyMetadataVersion;
	Version minKnownCommittedVersion;

	DatabaseConfiguration originalConfiguration;
	DatabaseConfiguration configuration;
	std::vector<Optional<Key>> primaryDcId;
	std::vector<Optional<Key>> remoteDcIds;
	bool hasConfiguration;

	ServerCoordinators coordinators;

	Reference<ILogSystem> logSystem;
	double lastVersionTime;
	LogSystemDiskQueueAdapter* txnStateLogAdapter;
	IKeyValueStore* txnStateStore;
	int64_t memoryLimit;
	std::map<Optional<Value>, int8_t> dcId_locality;
	std::vector<Tag> allTags;

	RecruitFromConfigurationReply primaryRecruitment;

	int8_t getNextLocality() {
		int8_t maxLocality = -1;
		for (auto it : dcId_locality) {
			maxLocality = std::max(maxLocality, it.second);
		}
		return maxLocality + 1;
	}

	std::vector<CommitProxyInterface> commitProxies;
	std::vector<CommitProxyInterface> provisionalCommitProxies;
	std::vector<GrvProxyInterface> grvProxies;
	std::vector<GrvProxyInterface> provisionalGrvProxies;
	std::vector<ResolverInterface> resolvers;

	std::map<UID, CommitProxyVersionReplies> lastCommitProxyVersionReplies;

	UID clusterId;
	Version initialClusterVersion = -1;
	Standalone<StringRef> dbId;

	MasterInterface masterInterface;
	LifetimeToken masterLifetime;
	const ClusterControllerFullInterface
	    clusterController; // If the cluster controller changes, this master will die, so this is immutable.

	ReusableCoordinatedState cstate;
	Promise<Void> recoveryReadyForCommits;
	Promise<Void> cstateUpdated;
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
	int64_t registrationCount; // Number of different MasterRegistrationRequests sent to clusterController

	RecoveryState recoveryState;

	PromiseStream<Future<Void>> addActor;
	Reference<AsyncVar<bool>> recruitmentStalled;
	bool forceRecovery;
	bool neverCreated;
	int8_t safeLocality;
	int8_t primaryLocality;

	std::vector<WorkerInterface> backupWorkers; // Recruited backup workers from cluster controller.

	CounterCollection cc;
	Counter changeCoordinatorsRequests;
	Counter getCommitVersionRequests;
	Counter backupWorkerDoneRequests;
	Counter getLiveCommittedVersionRequests;
	Counter reportLiveCommittedVersionRequests;

	Future<Void> logger;

	Reference<EventCacheHolder> metaclusterEventHolder;
	Reference<EventCacheHolder> swVersionCheckedEventHolder;
	Reference<EventCacheHolder> recoveredConfigEventHolder;
	Reference<EventCacheHolder> clusterRecoveryStateEventHolder;
	Reference<EventCacheHolder> clusterRecoveryGenerationsEventHolder;
	Reference<EventCacheHolder> clusterRecoveryDurationEventHolder;
	Reference<EventCacheHolder> clusterRecoveryAvailableEventHolder;

	ClusterRecoveryData(ClusterControllerData* controllerData,
	                    Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,
	                    MasterInterface const& masterInterface,
	                    LifetimeToken const& masterLifetimeToken,
	                    ServerCoordinators const& coordinators,
	                    ClusterControllerFullInterface const& clusterController,
	                    Standalone<StringRef> const& dbId,
	                    PromiseStream<Future<Void>> const& addActor,
	                    bool forceRecovery)

	  : controllerData(controllerData), dbgid(masterInterface.id()), lastEpochEnd(invalidVersion),
	    recoveryTransactionVersion(invalidVersion), lastCommitTime(0), liveCommittedVersion(invalidVersion),
	    databaseLocked(false), minKnownCommittedVersion(invalidVersion), hasConfiguration(false),
	    coordinators(coordinators), lastVersionTime(0), txnStateStore(nullptr), memoryLimit(2e9), dbId(dbId),
	    masterInterface(masterInterface), masterLifetime(masterLifetimeToken), clusterController(clusterController),
	    cstate(coordinators, addActor, dbgid), dbInfo(dbInfo), registrationCount(0), addActor(addActor),
	    recruitmentStalled(makeReference<AsyncVar<bool>>(false)), forceRecovery(forceRecovery), neverCreated(false),
	    safeLocality(tagLocalityInvalid), primaryLocality(tagLocalityInvalid),
	    cc("ClusterRecoveryData", dbgid.toString()), changeCoordinatorsRequests("ChangeCoordinatorsRequests", cc),
	    getCommitVersionRequests("GetCommitVersionRequests", cc),
	    backupWorkerDoneRequests("BackupWorkerDoneRequests", cc),
	    getLiveCommittedVersionRequests("GetLiveCommittedVersionRequests", cc),
	    reportLiveCommittedVersionRequests("ReportLiveCommittedVersionRequests", cc),
	    metaclusterEventHolder(makeReference<EventCacheHolder>("MetaclusterMetadata")),
	    swVersionCheckedEventHolder(makeReference<EventCacheHolder>("SWVersionCompatibilityChecked")),
	    recoveredConfigEventHolder(makeReference<EventCacheHolder>("RecoveredConfig")) {
		clusterRecoveryStateEventHolder = makeReference<EventCacheHolder>(
		    getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_STATE_EVENT_NAME));
		clusterRecoveryGenerationsEventHolder = makeReference<EventCacheHolder>(
		    getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_GENERATION_EVENT_NAME));
		clusterRecoveryDurationEventHolder = makeReference<EventCacheHolder>(
		    getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_DURATION_EVENT_NAME));
		clusterRecoveryAvailableEventHolder = makeReference<EventCacheHolder>(
		    getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_AVAILABLE_EVENT_NAME));
		logger = cc.traceCounters(getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_METRICS_EVENT_NAME),
		                          dbgid,
		                          SERVER_KNOBS->WORKER_LOGGING_INTERVAL,
		                          getRecoveryEventName(ClusterRecoveryEventType::CLUSTER_RECOVERY_METRICS_EVENT_NAME));
		if (forceRecovery && !controllerData->clusterControllerDcId.present()) {
			TraceEvent(SevError, "ForcedRecoveryRequiresDcID").log();
			forceRecovery = false;
		}
	}
	~ClusterRecoveryData() {
		if (txnStateStore)
			txnStateStore->close();
	}
};

															#line 1184 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
[[nodiscard]] Future<Void> recruitNewMaster( ClusterControllerData* const& cluster, ClusterControllerData::DBInfo* const& db, MasterInterface* const& newMaster );

#line 322 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
															#line 1188 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
[[nodiscard]] Future<Void> cleanupRecoveryActorCollection( Reference<ClusterRecoveryData> const& self, bool const& exThrown );

#line 323 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
															#line 1192 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/ClusterRecovery.actor.g.h"
[[nodiscard]] Future<Void> clusterRecoveryCore( Reference<ClusterRecoveryData> const& self );

#line 324 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/ClusterRecovery.actor.h"
bool isNormalClusterRecoveryError(const Error&);

#include "flow/unactorcompiler.h"

#endif
