#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
/*
 * fdb_flow.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdb_flow.h"

#include <cstdint>
#include <stdio.h>
#include <cinttypes>

#include "fmt/format.h"
#include "flow/DeterministicRandom.h"
#include "flow/SystemMonitor.h"
#include "flow/TLSConfig.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

using namespace FDB;

THREAD_FUNC networkThread(void* fdb) {
	((FDB::API*)fdb)->runNetwork();
	THREAD_RETURN;
}

															#line 42 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
namespace {
// This generated class is to be used only via _test()
															#line 40 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
template <class _testActor>
															#line 40 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
class _testActorState {
															#line 49 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
public:
															#line 40 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	_testActorState() 
															#line 40 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	{
															#line 55 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		fdb_probe_actor_create("_test", reinterpret_cast<unsigned long>(this));

	}
	~_testActorState() 
	{
		fdb_probe_actor_destroy("_test", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 41 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			API* fdb = FDB::API::selectAPIVersion(FDB_API_VERSION);
															#line 42 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			auto db = fdb->createDatabase();
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			tr = db->createTransaction();
															#line 47 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr->getReadVersion();
															#line 47 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			if (static_cast<_testActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 77 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_testActor*>(this)->actor_wait_state = 1;
															#line 47 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _testActor, 0, Version >*>(static_cast<_testActor*>(this)));
															#line 82 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_testActorState();
		static_cast<_testActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version const& ver,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		fmt::print("{}\n", ver);
															#line 50 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		versions = std::vector<Future<Version>>();
															#line 52 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		starttime = timer_monotonic();
															#line 53 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		i = int();
															#line 57 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		for(i = 0;i < 100000;i++) {
															#line 58 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			versions.push_back(tr->getReadVersion());
															#line 115 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		}
															#line 60 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		i = 0;
															#line 119 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Version && ver,int loopDepth) 
	{
															#line 48 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		fmt::print("{}\n", ver);
															#line 50 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		versions = std::vector<Future<Version>>();
															#line 52 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		starttime = timer_monotonic();
															#line 53 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		i = int();
															#line 57 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		for(i = 0;i < 100000;i++) {
															#line 58 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			versions.push_back(tr->getReadVersion());
															#line 138 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		}
															#line 60 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		i = 0;
															#line 142 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& ver,int loopDepth) 
	{
		loopDepth = a_body1cont1(ver, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && ver,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(ver), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_testActor*>(this)->actor_wait_state > 0) static_cast<_testActor*>(this)->actor_wait_state = 0;
		static_cast<_testActor*>(this)->ActorCallback< _testActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _testActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _testActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _testActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 64 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		printf("Elapsed: %lf\n", timer_monotonic() - starttime);
															#line 66 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		tr->set("foo"_sr, "bar"_sr);
															#line 68 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		StrictFuture<Optional<FDBStandalone<ValueRef>>> __when_expr_2 = tr->get("foo"_sr);
															#line 68 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (static_cast<_testActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 232 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_testActor*>(this)->actor_wait_state = 3;
															#line 68 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _testActor, 2, Optional<FDBStandalone<ValueRef>> >*>(static_cast<_testActor*>(this)));
															#line 237 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (!(i < 100000))
															#line 253 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 61 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		StrictFuture<Version> __when_expr_1 = versions[i];
															#line 61 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (static_cast<_testActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 261 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_testActor*>(this)->actor_wait_state = 2;
															#line 61 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _testActor, 1, Version >*>(static_cast<_testActor*>(this)));
															#line 266 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Version const& v,int loopDepth) 
	{
															#line 60 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		i++;
															#line 288 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Version && v,int loopDepth) 
	{
															#line 60 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		i++;
															#line 297 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_testActor*>(this)->actor_wait_state > 0) static_cast<_testActor*>(this)->actor_wait_state = 0;
		static_cast<_testActor*>(this)->ActorCallback< _testActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _testActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _testActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _testActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Optional<FDBStandalone<ValueRef>> const& v,int loopDepth) 
	{
															#line 69 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (v.present())
															#line 381 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		{
															#line 70 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			printf("%s\n", v.get().toString().c_str());
															#line 385 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		}
															#line 73 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_3 = tr->getRange(KeyRangeRef("a"_sr, "z"_sr), 100);
															#line 73 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (static_cast<_testActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 391 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_testActor*>(this)->actor_wait_state = 4;
															#line 73 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >*>(static_cast<_testActor*>(this)));
															#line 396 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<FDBStandalone<ValueRef>> && v,int loopDepth) 
	{
															#line 69 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (v.present())
															#line 405 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		{
															#line 70 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			printf("%s\n", v.get().toString().c_str());
															#line 409 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		}
															#line 73 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		StrictFuture<FDBStandalone<RangeResultRef>> __when_expr_3 = tr->getRange(KeyRangeRef("a"_sr, "z"_sr), 100);
															#line 73 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (static_cast<_testActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 415 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<_testActor*>(this)->actor_wait_state = 4;
															#line 73 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >*>(static_cast<_testActor*>(this)));
															#line 420 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<FDBStandalone<ValueRef>> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont4(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<FDBStandalone<ValueRef>> && v,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_testActor*>(this)->actor_wait_state > 0) static_cast<_testActor*>(this)->actor_wait_state = 0;
		static_cast<_testActor*>(this)->ActorCallback< _testActor, 2, Optional<FDBStandalone<ValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _testActor, 2, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> const& value) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _testActor, 2, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> && value) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _testActor, 2, Optional<FDBStandalone<ValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(FDBStandalone<RangeResultRef> const& r,int loopDepth) 
	{
															#line 75 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		for( auto kv : r ) {
															#line 76 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			printf("%s is %s\n", kv.key.toString().c_str(), kv.value.toString().c_str());
															#line 506 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		}
															#line 79 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		g_network->stop();
															#line 80 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (!static_cast<_testActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_testActorState(); static_cast<_testActor*>(this)->destroy(); return 0; }
															#line 512 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		new (&static_cast<_testActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_testActorState();
		static_cast<_testActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(FDBStandalone<RangeResultRef> && r,int loopDepth) 
	{
															#line 75 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		for( auto kv : r ) {
															#line 76 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			printf("%s is %s\n", kv.key.toString().c_str(), kv.value.toString().c_str());
															#line 526 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		}
															#line 79 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		g_network->stop();
															#line 80 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (!static_cast<_testActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_testActorState(); static_cast<_testActor*>(this)->destroy(); return 0; }
															#line 532 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		new (&static_cast<_testActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_testActorState();
		static_cast<_testActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(FDBStandalone<RangeResultRef> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont5(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(FDBStandalone<RangeResultRef> && r,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_testActor*>(this)->actor_wait_state > 0) static_cast<_testActor*>(this)->actor_wait_state = 0;
		static_cast<_testActor*>(this)->ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >::remove();

	}
	void a_callback_fire(ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> const& value) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >*,FDBStandalone<RangeResultRef> && value) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >*,Error err) 
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 43 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	Reference<Transaction> tr;
															#line 50 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	std::vector<Future<Version>> versions;
															#line 52 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	double starttime;
															#line 53 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	int i;
															#line 623 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
};
// This generated class is to be used only via _test()
															#line 40 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
class _testActor final : public Actor<Void>, public ActorCallback< _testActor, 0, Version >, public ActorCallback< _testActor, 1, Version >, public ActorCallback< _testActor, 2, Optional<FDBStandalone<ValueRef>> >, public ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >, public FastAllocated<_testActor>, public _testActorState<_testActor> {
															#line 628 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
public:
	using FastAllocated<_testActor>::operator new;
	using FastAllocated<_testActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12841526213302087168UL, 17281607662599268096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _testActor, 0, Version >;
friend struct ActorCallback< _testActor, 1, Version >;
friend struct ActorCallback< _testActor, 2, Optional<FDBStandalone<ValueRef>> >;
friend struct ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >;
															#line 40 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	_testActor() 
															#line 648 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		 : Actor<Void>(),
		   _testActorState<_testActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_test", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4334721828795126528UL, 3740463851443303424UL);
		ActorExecutionContextHelper __helper(static_cast<_testActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_test");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_test", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _testActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _testActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _testActor, 2, Optional<FDBStandalone<ValueRef>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _testActor, 3, FDBStandalone<RangeResultRef> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 40 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
[[nodiscard]] Future<Void> _test(  ) {
															#line 40 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	return Future<Void>(new _testActor());
															#line 684 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
}

#line 82 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"

void fdb_flow_test() {
	API* fdb = FDB::API::selectAPIVersion(FDB_API_VERSION);
	fdb->setupNetwork();
	startThread(networkThread, fdb);

	g_network = newNet2(TLSConfig());

	openTraceFile({}, 1000000, 1000000, ".");
	systemMonitor();
	uncancellable(recurring(&systemMonitor, 5.0, TaskPriority::FlushTrace));

	Future<Void> t = _test();

	g_network->run();
}

// FDB object used by bindings
namespace FDB {
class DatabaseImpl : public Database, NonCopyable {
public:
	virtual ~DatabaseImpl() { fdb_database_destroy(db); }

	Reference<Transaction> createTransaction() override;
	void setDatabaseOption(FDBDatabaseOption option, Optional<StringRef> value = Optional<StringRef>()) override;
	Future<int64_t> rebootWorker(const StringRef& address, bool check = false, int duration = 0) override;
	Future<Void> forceRecoveryWithDataLoss(const StringRef& dcid) override;
	Future<Void> createSnapshot(const StringRef& uid, const StringRef& snap_command) override;

private:
	FDBDatabase* db;
	explicit DatabaseImpl(FDBDatabase* db) : db(db) {}

	friend class API;
};

class TransactionImpl : public Transaction, private NonCopyable, public FastAllocated<TransactionImpl> {
	friend class DatabaseImpl;

public:
	virtual ~TransactionImpl() {
		if (tr) {
			fdb_transaction_destroy(tr);
		}
	}

	void setReadVersion(Version v) override;
	Future<Version> getReadVersion() override;

	Future<Optional<FDBStandalone<ValueRef>>> get(const Key& key, bool snapshot = false) override;
	Future<FDBStandalone<KeyRef>> getKey(const KeySelector& key, bool snapshot = false) override;

	Future<Void> watch(const Key& key) override;

	using Transaction::getRange;
	Future<FDBStandalone<RangeResultRef>> getRange(const KeySelector& begin,
	                                               const KeySelector& end,
	                                               GetRangeLimits limits = GetRangeLimits(),
	                                               bool snapshot = false,
	                                               bool reverse = false,
	                                               FDBStreamingMode streamingMode = FDB_STREAMING_MODE_SERIAL) override;

	Future<int64_t> getEstimatedRangeSizeBytes(const KeyRange& keys) override;
	Future<FDBStandalone<VectorRef<KeyRef>>> getRangeSplitPoints(const KeyRange& range, int64_t chunkSize) override;

	void addReadConflictRange(KeyRangeRef const& keys) override;
	void addReadConflictKey(KeyRef const& key) override;
	void addWriteConflictRange(KeyRangeRef const& keys) override;
	void addWriteConflictKey(KeyRef const& key) override;

	void atomicOp(const KeyRef& key, const ValueRef& operand, FDBMutationType operationType) override;
	void set(const KeyRef& key, const ValueRef& value) override;
	void clear(const KeyRangeRef& range) override;
	void clear(const KeyRef& key) override;

	Future<Void> commit() override;
	Version getCommittedVersion() override;
	Future<FDBStandalone<StringRef>> getVersionstamp() override;

	void setOption(FDBTransactionOption option, Optional<StringRef> value = Optional<StringRef>()) override;

	Future<int64_t> getApproximateSize() override;
	Future<Void> onError(Error const& e) override;

	void cancel() override;
	void reset() override;

	TransactionImpl() : tr(nullptr) {}
	TransactionImpl(TransactionImpl&& r) noexcept {
		tr = r.tr;
		r.tr = nullptr;
	}
	TransactionImpl& operator=(TransactionImpl&& r) noexcept {
		tr = r.tr;
		r.tr = nullptr;
		return *this;
	}

private:
	FDBTransaction* tr;

	explicit TransactionImpl(FDBDatabase* db);
};

static inline void throw_on_error(fdb_error_t e) {
	if (e)
		throw Error(e);
}

void CFuture::blockUntilReady() {
	throw_on_error(fdb_future_block_until_ready(f));
}

void backToFutureCallback(FDBFuture* f, void* data) {
	g_network->onMainThread(Promise<Void>((SAV<Void>*)data),
	                        TaskPriority::DefaultOnMainThread); // SOMEDAY: think about this priority
}

// backToFuture<Type>( FDBFuture*, (FDBFuture* -> Type) ) -> Future<Type>
// Takes an FDBFuture (from the alien client world, with callbacks potentially firing on an alien thread)
//   and converts it into a Future<T> (with callbacks working on this thread, cancellation etc).
// You must pass as the second parameter a function which takes a ready FDBFuture* and returns a value of Type
															#line 810 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
// This generated class is to be used only via backToFuture()
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
template <class T, class Function, class BackToFutureActor>
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
class BackToFutureActorState {
															#line 816 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
public:
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	BackToFutureActorState(FDBFuture* const& _f,Function const& convertValue) 
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		 : _f(_f),
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		   convertValue(convertValue),
															#line 206 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		   f(new CFuture(_f))
															#line 827 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
	{
		fdb_probe_actor_create("backToFuture", reinterpret_cast<unsigned long>(this));

	}
	~BackToFutureActorState() 
	{
		fdb_probe_actor_destroy("backToFuture", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 208 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			Promise<Void> ready;
															#line 209 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			Future<Void> onReady = ready.getFuture();
															#line 211 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			throw_on_error(fdb_future_set_callback(f->f, backToFutureCallback, ready.extractRawPointer()));
															#line 212 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			StrictFuture<Void> __when_expr_0 = onReady;
															#line 212 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			if (static_cast<BackToFutureActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 850 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BackToFutureActor*>(this)->actor_wait_state = 1;
															#line 212 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BackToFutureActor, 0, Void >*>(static_cast<BackToFutureActor*>(this)));
															#line 855 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BackToFutureActorState();
		static_cast<BackToFutureActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 214 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (!static_cast<BackToFutureActor*>(this)->SAV<T>::futures) { (void)(convertValue(f)); this->~BackToFutureActorState(); static_cast<BackToFutureActor*>(this)->destroy(); return 0; }
															#line 878 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		new (&static_cast<BackToFutureActor*>(this)->SAV< T >::value()) T(convertValue(f));
		this->~BackToFutureActorState();
		static_cast<BackToFutureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 214 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
		if (!static_cast<BackToFutureActor*>(this)->SAV<T>::futures) { (void)(convertValue(f)); this->~BackToFutureActorState(); static_cast<BackToFutureActor*>(this)->destroy(); return 0; }
															#line 890 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		new (&static_cast<BackToFutureActor*>(this)->SAV< T >::value()) T(convertValue(f));
		this->~BackToFutureActorState();
		static_cast<BackToFutureActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BackToFutureActor*>(this)->actor_wait_state > 0) static_cast<BackToFutureActor*>(this)->actor_wait_state = 0;
		static_cast<BackToFutureActor*>(this)->ActorCallback< BackToFutureActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BackToFutureActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("backToFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackToFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backToFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BackToFutureActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("backToFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BackToFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backToFuture", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BackToFutureActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("backToFuture", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BackToFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("backToFuture", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	FDBFuture* _f;
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	Function convertValue;
															#line 206 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	Reference<CFuture> f;
															#line 979 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
};
// This generated class is to be used only via backToFuture()
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
template <class T, class Function>
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
class BackToFutureActor final : public Actor<T>, public ActorCallback< BackToFutureActor<T, Function>, 0, Void >, public FastAllocated<BackToFutureActor<T, Function>>, public BackToFutureActorState<T, Function, BackToFutureActor<T, Function>> {
															#line 986 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
public:
	using FastAllocated<BackToFutureActor<T, Function>>::operator new;
	using FastAllocated<BackToFutureActor<T, Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8022673456235251712UL, 2078863522035121408UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BackToFutureActor<T, Function>, 0, Void >;
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	BackToFutureActor(FDBFuture* const& _f,Function const& convertValue) 
															#line 1003 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
		 : Actor<T>(),
		   BackToFutureActorState<T, Function, BackToFutureActor<T, Function>>(_f, convertValue),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("backToFuture", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4931096360270685696UL, 9597506270948411904UL);
		ActorExecutionContextHelper __helper(static_cast<BackToFutureActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("backToFuture");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("backToFuture", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BackToFutureActor<T, Function>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
template <class T, class Function>
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
[[nodiscard]] static Future<T> backToFuture( FDBFuture* const& _f, Function const& convertValue ) {
															#line 204 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"
	return Future<T>(new BackToFutureActor<T, Function>(_f, convertValue));
															#line 1037 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/build_output/bindings/flow/fdb_flow.actor.g.cpp"
}

#line 216 "/codebuild/output/src2120458913/src/github.com/apple/foundationdb/bindings/flow/fdb_flow.actor.cpp"

void API::setNetworkOption(FDBNetworkOption option, Optional<StringRef> value) {
	if (value.present())
		throw_on_error(fdb_network_set_option(option, value.get().begin(), value.get().size()));
	else
		throw_on_error(fdb_network_set_option(option, nullptr, 0));
}

API* API::instance = nullptr;
API::API(int version) : version(version) {}

API* API::selectAPIVersion(int apiVersion) {
	if (API::instance) {
		if (apiVersion != API::instance->version) {
			throw api_version_already_set();
		} else {
			return API::instance;
		}
	}

	if (apiVersion < 500 || apiVersion > FDB_API_VERSION) {
		throw api_version_not_supported();
	}

	throw_on_error(fdb_select_api_version_impl(apiVersion, FDB_API_VERSION));

	API::instance = new API(apiVersion);
	return API::instance;
}

bool API::isAPIVersionSelected() {
	return API::instance != nullptr;
}

API* API::getInstance() {
	if (API::instance == nullptr) {
		throw api_version_unset();
	} else {
		return API::instance;
	}
}

void API::setupNetwork() {
	throw_on_error(fdb_setup_network());
}

void API::runNetwork() {
	throw_on_error(fdb_run_network());
}

void API::stopNetwork() {
	throw_on_error(fdb_stop_network());
}

bool API::evaluatePredicate(FDBErrorPredicate pred, Error const& e) {
	return fdb_error_predicate(pred, e.code());
}

Reference<Database> API::createDatabase(std::string const& connFilename) {
	FDBDatabase* db;
	throw_on_error(fdb_create_database(connFilename.c_str(), &db));
	return Reference<Database>(new DatabaseImpl(db));
}

int API::getAPIVersion() const {
	return version;
}

Reference<Transaction> DatabaseImpl::createTransaction() {
	return Reference<Transaction>(new TransactionImpl(db));
}

void DatabaseImpl::setDatabaseOption(FDBDatabaseOption option, Optional<StringRef> value) {
	if (value.present())
		throw_on_error(fdb_database_set_option(db, option, value.get().begin(), value.get().size()));
	else
		throw_on_error(fdb_database_set_option(db, option, nullptr, 0));
}

Future<int64_t> DatabaseImpl::rebootWorker(const StringRef& address, bool check, int duration) {
	return backToFuture<int64_t>(fdb_database_reboot_worker(db, address.begin(), address.size(), check, duration),
	                             [](Reference<CFuture> f) {
		                             int64_t res;

		                             throw_on_error(fdb_future_get_int64(f->f, &res));

		                             return res;
	                             });
}

Future<Void> DatabaseImpl::forceRecoveryWithDataLoss(const StringRef& dcid) {
	return backToFuture<Void>(fdb_database_force_recovery_with_data_loss(db, dcid.begin(), dcid.size()),
	                          [](Reference<CFuture> f) {
		                          throw_on_error(fdb_future_get_error(f->f));
		                          return Void();
	                          });
}

Future<Void> DatabaseImpl::createSnapshot(const StringRef& uid, const StringRef& snap_command) {
	return backToFuture<Void>(
	    fdb_database_create_snapshot(db, uid.begin(), uid.size(), snap_command.begin(), snap_command.size()),
	    [](Reference<CFuture> f) {
		    throw_on_error(fdb_future_get_error(f->f));
		    return Void();
	    });
}

TransactionImpl::TransactionImpl(FDBDatabase* db) {
	throw_on_error(fdb_database_create_transaction(db, &tr));
}

void TransactionImpl::setReadVersion(Version v) {
	fdb_transaction_set_read_version(tr, v);
}

Future<Version> TransactionImpl::getReadVersion() {
	return backToFuture<Version>(fdb_transaction_get_read_version(tr), [](Reference<CFuture> f) {
		Version value;

		throw_on_error(fdb_future_get_int64(f->f, &value));

		return value;
	});
}

Future<Optional<FDBStandalone<ValueRef>>> TransactionImpl::get(const Key& key, bool snapshot) {
	return backToFuture<Optional<FDBStandalone<ValueRef>>>(
	    fdb_transaction_get(tr, key.begin(), key.size(), snapshot), [](Reference<CFuture> f) {
		    fdb_bool_t present;
		    uint8_t const* value;
		    int value_length;

		    throw_on_error(fdb_future_get_value(f->f, &present, &value, &value_length));

		    if (present) {
			    return Optional<FDBStandalone<ValueRef>>(FDBStandalone<ValueRef>(f, ValueRef(value, value_length)));
		    } else {
			    return Optional<FDBStandalone<ValueRef>>();
		    }
	    });
}

Future<Void> TransactionImpl::watch(const Key& key) {
	return backToFuture<Void>(fdb_transaction_watch(tr, key.begin(), key.size()), [](Reference<CFuture> f) {
		throw_on_error(fdb_future_get_error(f->f));
		return Void();
	});
}

Future<FDBStandalone<KeyRef>> TransactionImpl::getKey(const KeySelector& key, bool snapshot) {
	return backToFuture<FDBStandalone<KeyRef>>(
	    fdb_transaction_get_key(tr, key.key.begin(), key.key.size(), key.orEqual, key.offset, snapshot),
	    [](Reference<CFuture> f) {
		    uint8_t const* key;
		    int key_length;

		    throw_on_error(fdb_future_get_key(f->f, &key, &key_length));

		    return FDBStandalone<KeyRef>(f, KeyRef(key, key_length));
	    });
}

Future<FDBStandalone<RangeResultRef>> TransactionImpl::getRange(const KeySelector& begin,
                                                                const KeySelector& end,
                                                                GetRangeLimits limits,
                                                                bool snapshot,
                                                                bool reverse,
                                                                FDBStreamingMode streamingMode) {
	// FIXME: iteration
	return backToFuture<FDBStandalone<RangeResultRef>>(
	    fdb_transaction_get_range(tr,
	                              begin.key.begin(),
	                              begin.key.size(),
	                              begin.orEqual,
	                              begin.offset,
	                              end.key.begin(),
	                              end.key.size(),
	                              end.orEqual,
	                              end.offset,
	                              limits.rows,
	                              limits.bytes,
	                              streamingMode,
	                              1,
	                              snapshot,
	                              reverse),
	    [](Reference<CFuture> f) {
		    FDBKeyValue const* kv;
		    int count;
		    fdb_bool_t more;

		    throw_on_error(fdb_future_get_keyvalue_array(f->f, &kv, &count, &more));

		    return FDBStandalone<RangeResultRef>(f,
		                                         RangeResultRef(VectorRef<KeyValueRef>((KeyValueRef*)kv, count), more));
	    });
}

Future<int64_t> TransactionImpl::getEstimatedRangeSizeBytes(const KeyRange& keys) {
	return backToFuture<int64_t>(fdb_transaction_get_estimated_range_size_bytes(
	                                 tr, keys.begin.begin(), keys.begin.size(), keys.end.begin(), keys.end.size()),
	                             [](Reference<CFuture> f) {
		                             int64_t bytes;
		                             throw_on_error(fdb_future_get_int64(f->f, &bytes));
		                             return bytes;
	                             });
}

Future<FDBStandalone<VectorRef<KeyRef>>> TransactionImpl::getRangeSplitPoints(const KeyRange& range,
                                                                              int64_t chunkSize) {
	return backToFuture<FDBStandalone<VectorRef<KeyRef>>>(
	    fdb_transaction_get_range_split_points(
	        tr, range.begin.begin(), range.begin.size(), range.end.begin(), range.end.size(), chunkSize),
	    [](Reference<CFuture> f) {
		    FDBKey const* ks;
		    int count;
		    throw_on_error(fdb_future_get_key_array(f->f, &ks, &count));

		    return FDBStandalone<VectorRef<KeyRef>>(f, VectorRef<KeyRef>((KeyRef*)ks, count));
	    });
}

void TransactionImpl::addReadConflictRange(KeyRangeRef const& keys) {
	throw_on_error(fdb_transaction_add_conflict_range(
	    tr, keys.begin.begin(), keys.begin.size(), keys.end.begin(), keys.end.size(), FDB_CONFLICT_RANGE_TYPE_READ));
}

void TransactionImpl::addReadConflictKey(KeyRef const& key) {
	return addReadConflictRange(KeyRange(KeyRangeRef(key, keyAfter(key))));
}

void TransactionImpl::addWriteConflictRange(KeyRangeRef const& keys) {
	throw_on_error(fdb_transaction_add_conflict_range(
	    tr, keys.begin.begin(), keys.begin.size(), keys.end.begin(), keys.end.size(), FDB_CONFLICT_RANGE_TYPE_WRITE));
}

void TransactionImpl::addWriteConflictKey(KeyRef const& key) {
	return addWriteConflictRange(KeyRange(KeyRangeRef(key, keyAfter(key))));
}

void TransactionImpl::atomicOp(const KeyRef& key, const ValueRef& operand, FDBMutationType operationType) {
	fdb_transaction_atomic_op(tr, key.begin(), key.size(), operand.begin(), operand.size(), operationType);
}

void TransactionImpl::set(const KeyRef& key, const ValueRef& value) {
	fdb_transaction_set(tr, key.begin(), key.size(), value.begin(), value.size());
}

void TransactionImpl::clear(const KeyRangeRef& range) {
	fdb_transaction_clear_range(tr, range.begin.begin(), range.begin.size(), range.end.begin(), range.end.size());
}

void TransactionImpl::clear(const KeyRef& key) {
	fdb_transaction_clear(tr, key.begin(), key.size());
}

Future<Void> TransactionImpl::commit() {
	return backToFuture<Void>(fdb_transaction_commit(tr), [](Reference<CFuture> f) {
		throw_on_error(fdb_future_get_error(f->f));
		return Void();
	});
}

Version TransactionImpl::getCommittedVersion() {
	Version v;

	throw_on_error(fdb_transaction_get_committed_version(tr, &v));
	return v;
}

Future<FDBStandalone<StringRef>> TransactionImpl::getVersionstamp() {
	return backToFuture<FDBStandalone<KeyRef>>(fdb_transaction_get_versionstamp(tr), [](Reference<CFuture> f) {
		uint8_t const* key;
		int key_length;

		throw_on_error(fdb_future_get_key(f->f, &key, &key_length));

		return FDBStandalone<StringRef>(f, StringRef(key, key_length));
	});
}

void TransactionImpl::setOption(FDBTransactionOption option, Optional<StringRef> value) {
	if (value.present()) {
		throw_on_error(fdb_transaction_set_option(tr, option, value.get().begin(), value.get().size()));
	} else {
		throw_on_error(fdb_transaction_set_option(tr, option, nullptr, 0));
	}
}

Future<int64_t> TransactionImpl::getApproximateSize() {
	return backToFuture<int64_t>(fdb_transaction_get_approximate_size(tr), [](Reference<CFuture> f) {
		int64_t size = 0;
		throw_on_error(fdb_future_get_int64(f->f, &size));
		return size;
	});
}

Future<Void> TransactionImpl::onError(Error const& e) {
	return backToFuture<Void>(fdb_transaction_on_error(tr, e.code()), [](Reference<CFuture> f) {
		throw_on_error(fdb_future_get_error(f->f));
		return Void();
	});
}

void TransactionImpl::cancel() {
	fdb_transaction_cancel(tr);
}

void TransactionImpl::reset() {
	fdb_transaction_reset(tr);
}

} // namespace FDB
