#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleValidation.actor.h"
/*
 * BlobGranuleValidation.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_BLOBGRANULEVALIDATION_ACTOR_G_H)
#define FDBSERVER_BLOBGRANULEVALIDATION_ACTOR_G_H
#include "fdbserver/BlobGranuleValidation.actor.g.h"
#elif !defined(FDBSERVER_BLOBGRANULEVALIDATION_ACTOR_H)
#define FDBSERVER_BLOBGRANULEVALIDATION_ACTOR_H

#pragma once

#include "flow/flow.h"
#include "fdbclient/BlobGranuleReader.actor.h"
#include "fdbclient/CommitTransaction.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/BlobGranuleCommon.h"
#include "flow/actorcompiler.h" // has to be last include

/* Contains utility functions for validating blob granule data */

															#line 40 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleValidation.actor.g.h"
[[nodiscard]] Future<std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>>> readFromBlob( Database const& cx, Reference<BlobConnectionProvider> const& bstore, KeyRange const& range, Version const& beginVersion, Version const& readVersion, Optional<Reference<Tenant>> const& tenant = Optional<Reference<Tenant>>() );

#line 45 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleValidation.actor.h"

															#line 45 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleValidation.actor.g.h"
[[nodiscard]] Future<std::pair<RangeResult, Version>> readFromFDB( Database const& cx, KeyRange const& range );

#line 47 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleValidation.actor.h"

bool compareFDBAndBlob(RangeResult fdb,
                       std::pair<RangeResult, Standalone<VectorRef<BlobGranuleChunkRef>>> blob,
                       KeyRange range,
                       Version v,
                       bool debug);

void printGranuleChunks(const Standalone<VectorRef<BlobGranuleChunkRef>>& chunks);

															#line 58 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleValidation.actor.g.h"
[[nodiscard]] Future<Void> clearAndAwaitMerge( Database const& cx, KeyRange const& range );

#line 57 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleValidation.actor.h"

															#line 63 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleValidation.actor.g.h"
[[nodiscard]] Future<Void> validateGranuleSummaries( Database const& cx, KeyRange const& range, Optional<Reference<Tenant>> const& tenantName, Promise<Void> const& testComplete );

#line 62 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleValidation.actor.h"

															#line 68 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleValidation.actor.g.h"
[[nodiscard]] Future<Void> validateForceFlushing( Database const& cx, KeyRange const& range, double const& testDuration, Promise<Void> const& testComplete );

#line 67 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleValidation.actor.h"

															#line 73 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleValidation.actor.g.h"
[[nodiscard]] Future<Void> checkFeedCleanup( Database const& cx, bool const& debug );

#line 69 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleValidation.actor.h"

															#line 78 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/BlobGranuleValidation.actor.g.h"
[[nodiscard]] Future<Void> killBlobWorkers( Database const& cx );

#line 71 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/BlobGranuleValidation.actor.h"
#include "flow/unactorcompiler.h"

#endif
