#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
/*
 * LogSystemPeekCursor.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/LogSystem.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/MutationTracking.h"
#include "fdbrpc/ReplicationUtils.h"
#include "flow/DebugTrace.h"
#include "flow/actorcompiler.h" // has to be last include

// create a peek stream for cursor when it's possible
															#line 32 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via tryEstablishPeekStream()
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class TryEstablishPeekStreamActor>
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class TryEstablishPeekStreamActorState {
															#line 39 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TryEstablishPeekStreamActorState(ILogSystem::ServerPeekCursor* const& self) 
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self)
															#line 46 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this));

	}
	~TryEstablishPeekStreamActorState() 
	{
		fdb_probe_actor_destroy("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 31 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (self->peekReplyStream.present())
															#line 61 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 32 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (!static_cast<TryEstablishPeekStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TryEstablishPeekStreamActorState(); static_cast<TryEstablishPeekStreamActor*>(this)->destroy(); return 0; }
															#line 65 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				new (&static_cast<TryEstablishPeekStreamActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~TryEstablishPeekStreamActorState();
				static_cast<TryEstablishPeekStreamActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 33 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (!self->interf || !self->interf->get().present())
															#line 75 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 34 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->peekReplyStream.reset();
															#line 35 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					this->~TryEstablishPeekStreamActorState();
															#line 81 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					static_cast<TryEstablishPeekStreamActor*>(this)->sendAndDelPromiseRef(Never());
					return 0;
				}
			}
															#line 37 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = IFailureMonitor::failureMonitor().onStateEqual(self->interf->get().interf().peekStreamMessages.getEndpoint(), FailureStatus(false));
															#line 37 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<TryEstablishPeekStreamActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 90 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryEstablishPeekStreamActor*>(this)->actor_wait_state = 1;
															#line 37 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryEstablishPeekStreamActor, 0, Void >*>(static_cast<TryEstablishPeekStreamActor*>(this)));
															#line 95 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryEstablishPeekStreamActorState();
		static_cast<TryEstablishPeekStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 40 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		auto req = TLogPeekStreamRequest(self->messageVersion.version, self->tag, self->returnIfBlocked, std::numeric_limits<int>::max(), self->end.version);
															#line 45 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->peekReplyStream = self->interf->get().interf().peekStreamMessages.getReplyStream(req);
															#line 46 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent(SevDebug, "SPC_StreamCreated", self->randomID) .detail("Tag", self->tag) .detail("PeerAddr", self->interf->get().interf().peekStreamMessages.getEndpoint().getPrimaryAddress()) .detail("PeerAddress", self->interf->get().interf().peekStreamMessages.getEndpoint().getPrimaryAddress()) .detail("PeerToken", self->interf->get().interf().peekStreamMessages.getEndpoint().token);
															#line 51 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<TryEstablishPeekStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TryEstablishPeekStreamActorState(); static_cast<TryEstablishPeekStreamActor*>(this)->destroy(); return 0; }
															#line 124 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<TryEstablishPeekStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TryEstablishPeekStreamActorState();
		static_cast<TryEstablishPeekStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 40 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		auto req = TLogPeekStreamRequest(self->messageVersion.version, self->tag, self->returnIfBlocked, std::numeric_limits<int>::max(), self->end.version);
															#line 45 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->peekReplyStream = self->interf->get().interf().peekStreamMessages.getReplyStream(req);
															#line 46 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent(SevDebug, "SPC_StreamCreated", self->randomID) .detail("Tag", self->tag) .detail("PeerAddr", self->interf->get().interf().peekStreamMessages.getEndpoint().getPrimaryAddress()) .detail("PeerAddress", self->interf->get().interf().peekStreamMessages.getEndpoint().getPrimaryAddress()) .detail("PeerToken", self->interf->get().interf().peekStreamMessages.getEndpoint().token);
															#line 51 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<TryEstablishPeekStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TryEstablishPeekStreamActorState(); static_cast<TryEstablishPeekStreamActor*>(this)->destroy(); return 0; }
															#line 142 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<TryEstablishPeekStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TryEstablishPeekStreamActorState();
		static_cast<TryEstablishPeekStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryEstablishPeekStreamActor*>(this)->actor_wait_state > 0) static_cast<TryEstablishPeekStreamActor*>(this)->actor_wait_state = 0;
		static_cast<TryEstablishPeekStreamActor*>(this)->ActorCallback< TryEstablishPeekStreamActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryEstablishPeekStreamActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryEstablishPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryEstablishPeekStreamActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryEstablishPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryEstablishPeekStreamActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryEstablishPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::ServerPeekCursor* self;
															#line 227 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via tryEstablishPeekStream()
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class TryEstablishPeekStreamActor final : public Actor<Void>, public ActorCallback< TryEstablishPeekStreamActor, 0, Void >, public FastAllocated<TryEstablishPeekStreamActor>, public TryEstablishPeekStreamActorState<TryEstablishPeekStreamActor> {
															#line 232 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<TryEstablishPeekStreamActor>::operator new;
	using FastAllocated<TryEstablishPeekStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2714389335694543616UL, 15162907287518128128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryEstablishPeekStreamActor, 0, Void >;
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TryEstablishPeekStreamActor(ILogSystem::ServerPeekCursor* const& self) 
															#line 249 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   TryEstablishPeekStreamActorState<TryEstablishPeekStreamActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5311170033092055552UL, 18251925820463390208UL);
		ActorExecutionContextHelper __helper(static_cast<TryEstablishPeekStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryEstablishPeekStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryEstablishPeekStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryEstablishPeekStreamActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> tryEstablishPeekStream( ILogSystem::ServerPeekCursor* const& self ) {
															#line 30 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new TryEstablishPeekStreamActor(self));
															#line 282 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 53 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

ILogSystem::ServerPeekCursor::ServerPeekCursor(Reference<AsyncVar<OptionalInterface<TLogInterface>>> const& interf,
                                               Tag tag,
                                               Version begin,
                                               Version end,
                                               bool returnIfBlocked,
                                               bool parallelGetMore)
  : interf(interf), tag(tag), rd(results.arena, results.messages, Unversioned()), messageVersion(begin), end(end),
    poppedVersion(0), hasMsg(false), randomID(deterministicRandom()->randomUniqueID()),
    returnIfBlocked(returnIfBlocked), onlySpilled(false), parallelGetMore(parallelGetMore),
    usePeekStream(SERVER_KNOBS->PEEK_USING_STREAMING), sequence(0), lastReset(0), resetCheck(Void()), slowReplies(0),
    fastReplies(0), unknownReplies(0) {
	this->results.maxKnownVersion = 0;
	this->results.minKnownCommittedVersion = 0;
	DebugLogTraceEvent(SevDebug, "SPC_Starting", randomID)
	    .detail("Tag", tag.toString())
	    .detail("Parallel", parallelGetMore)
	    .detail("Interf", interf && interf->get().present() ? interf->get().id() : UID())
	    .detail("UsePeekStream", usePeekStream)
	    .detail("Begin", begin)
	    .detail("End", end);
}

ILogSystem::ServerPeekCursor::ServerPeekCursor(TLogPeekReply const& results,
                                               LogMessageVersion const& messageVersion,
                                               LogMessageVersion const& end,
                                               TagsAndMessage const& message,
                                               bool hasMsg,
                                               Version poppedVersion,
                                               Tag tag)
  : tag(tag), results(results), rd(results.arena, results.messages, Unversioned()), messageVersion(messageVersion),
    end(end), poppedVersion(poppedVersion), messageAndTags(message), hasMsg(hasMsg),
    randomID(deterministicRandom()->randomUniqueID()), returnIfBlocked(false), onlySpilled(false),
    parallelGetMore(false), usePeekStream(false), sequence(0), lastReset(0), resetCheck(Void()), slowReplies(0),
    fastReplies(0), unknownReplies(0) {
	//TraceEvent("SPC_Clone", randomID);
	this->results.maxKnownVersion = 0;
	this->results.minKnownCommittedVersion = 0;
	if (hasMsg)
		nextMessage();

	advanceTo(messageVersion);
}

Reference<ILogSystem::IPeekCursor> ILogSystem::ServerPeekCursor::cloneNoMore() {
	return makeReference<ILogSystem::ServerPeekCursor>(
	    results, messageVersion, end, messageAndTags, hasMsg, poppedVersion, tag);
}

void ILogSystem::ServerPeekCursor::setProtocolVersion(ProtocolVersion version) {
	rd.setProtocolVersion(version);
}

Arena& ILogSystem::ServerPeekCursor::arena() {
	return results.arena;
}

ArenaReader* ILogSystem::ServerPeekCursor::reader() {
	return &rd;
}

bool ILogSystem::ServerPeekCursor::hasMessage() const {
	//TraceEvent("SPC_HasMessage", randomID).detail("HasMsg", hasMsg);
	return hasMsg;
}

void ILogSystem::ServerPeekCursor::nextMessage() {
	DebugLogTraceEvent("SPC_NextMessage", randomID)
	    .detail("Tag", tag.toString())
	    .detail("MessageVersion", messageVersion.toString());
	ASSERT(hasMsg);
	if (rd.empty()) {
		messageVersion.reset(std::min(results.end, end.version));
		hasMsg = false;
		return;
	}
	if (*(int32_t*)rd.peekBytes(4) == VERSION_HEADER) {
		// A version
		int32_t dummy;
		Version ver;
		rd >> dummy >> ver;

		//TraceEvent("SPC_ProcessSeq", randomID).detail("MessageVersion", messageVersion.toString()).detail("Ver", ver).detail("Tag", tag.toString());
		// ASSERT( ver >= messageVersion.version );

		messageVersion.reset(ver);

		if (messageVersion >= end) {
			messageVersion = end;
			hasMsg = false;
			return;
		}
		ASSERT(!rd.empty());
	}

	messageAndTags.loadFromArena(&rd, &messageVersion.sub);
	DEBUG_TAGS_AND_MESSAGE("ServerPeekCursor", messageVersion.version, messageAndTags.getRawMessage(), this->randomID);
	// Rewind and consume the header so that reader() starts from the message.
	rd.rewind();
	rd.readBytes(TagsAndMessage::getHeaderSize(messageAndTags.tags.size()));
	hasMsg = true;
	DebugLogTraceEvent("SPC_NextMessageB", randomID)
	    .detail("Tag", tag.toString())
	    .detail("MessageVersion", messageVersion.toString());
}

StringRef ILogSystem::ServerPeekCursor::getMessage() {
	DebugLogTraceEvent("SPC_GetMessage", randomID).detail("Tag", tag.toString());
	StringRef message = messageAndTags.getMessageWithoutTags();
	rd.readBytes(message.size()); // Consumes the message.
	return message;
}

StringRef ILogSystem::ServerPeekCursor::getMessageWithTags() {
	StringRef rawMessage = messageAndTags.getRawMessage();
	rd.readBytes(rawMessage.size() -
	             TagsAndMessage::getHeaderSize(messageAndTags.tags.size())); // Consumes the message.
	return rawMessage;
}

VectorRef<Tag> ILogSystem::ServerPeekCursor::getTags() const {
	return messageAndTags.tags;
}

void ILogSystem::ServerPeekCursor::advanceTo(LogMessageVersion n) {
	//TraceEvent("SPC_AdvanceTo", randomID).detail("N", n.toString());
	while (messageVersion < n && hasMessage()) {
		getMessage();
		nextMessage();
	}

	if (hasMessage())
		return;

	// if( more.isValid() && !more.isReady() ) more.cancel();

	if (messageVersion < n) {
		messageVersion = n;
	}
}

// This function is called after the cursor received one TLogPeekReply to update its members, which is the common logic
// in getMore helper functions.
void updateCursorWithReply(ILogSystem::ServerPeekCursor* self, const TLogPeekReply& res) {
	self->results = res;
	self->onlySpilled = res.onlySpilled;
	if (res.popped.present())
		self->poppedVersion = std::min(std::max(self->poppedVersion, res.popped.get()), self->end.version);
	self->rd = ArenaReader(self->results.arena, self->results.messages, Unversioned());
	LogMessageVersion skipSeq = self->messageVersion;
	self->hasMsg = true;
	self->nextMessage();
	self->advanceTo(skipSeq);
}

															#line 441 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via resetChecker()
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class ResetCheckerActor>
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ResetCheckerActorState {
															#line 448 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ResetCheckerActorState(ILogSystem::ServerPeekCursor* const& self,NetworkAddress const& addr) 
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   addr(addr)
															#line 457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("resetChecker", reinterpret_cast<unsigned long>(this));

	}
	~ResetCheckerActorState() 
	{
		fdb_probe_actor_destroy("resetChecker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->slowReplies = 0;
															#line 210 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->unknownReplies = 0;
															#line 211 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->fastReplies = 0;
															#line 212 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->PEEK_STATS_INTERVAL);
															#line 212 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<ResetCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 480 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResetCheckerActor*>(this)->actor_wait_state = 1;
															#line 212 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResetCheckerActor, 0, Void >*>(static_cast<ResetCheckerActor*>(this)));
															#line 485 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResetCheckerActorState();
		static_cast<ResetCheckerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 213 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		TraceEvent("SlowPeekStats", self->randomID) .detail("PeerAddress", addr) .detail("SlowReplies", self->slowReplies) .detail("FastReplies", self->fastReplies) .detail("UnknownReplies", self->unknownReplies);
															#line 219 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->slowReplies >= SERVER_KNOBS->PEEK_STATS_SLOW_AMOUNT && self->slowReplies / double(self->slowReplies + self->fastReplies) >= SERVER_KNOBS->PEEK_STATS_SLOW_RATIO)
															#line 510 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			TraceEvent("ConnectionResetSlowPeek", self->randomID) .detail("PeerAddress", addr) .detail("SlowReplies", self->slowReplies) .detail("FastReplies", self->fastReplies) .detail("UnknownReplies", self->unknownReplies);
															#line 227 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			FlowTransport::transport().resetConnection(addr);
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->lastReset = now();
															#line 518 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 230 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ResetCheckerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetCheckerActorState(); static_cast<ResetCheckerActor*>(this)->destroy(); return 0; }
															#line 522 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ResetCheckerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetCheckerActorState();
		static_cast<ResetCheckerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 213 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		TraceEvent("SlowPeekStats", self->randomID) .detail("PeerAddress", addr) .detail("SlowReplies", self->slowReplies) .detail("FastReplies", self->fastReplies) .detail("UnknownReplies", self->unknownReplies);
															#line 219 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->slowReplies >= SERVER_KNOBS->PEEK_STATS_SLOW_AMOUNT && self->slowReplies / double(self->slowReplies + self->fastReplies) >= SERVER_KNOBS->PEEK_STATS_SLOW_RATIO)
															#line 536 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			TraceEvent("ConnectionResetSlowPeek", self->randomID) .detail("PeerAddress", addr) .detail("SlowReplies", self->slowReplies) .detail("FastReplies", self->fastReplies) .detail("UnknownReplies", self->unknownReplies);
															#line 227 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			FlowTransport::transport().resetConnection(addr);
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->lastReset = now();
															#line 544 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 230 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ResetCheckerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetCheckerActorState(); static_cast<ResetCheckerActor*>(this)->destroy(); return 0; }
															#line 548 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ResetCheckerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetCheckerActorState();
		static_cast<ResetCheckerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResetCheckerActor*>(this)->actor_wait_state > 0) static_cast<ResetCheckerActor*>(this)->actor_wait_state = 0;
		static_cast<ResetCheckerActor*>(this)->ActorCallback< ResetCheckerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetCheckerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetCheckerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResetCheckerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetChecker", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::ServerPeekCursor* self;
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	NetworkAddress addr;
															#line 635 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via resetChecker()
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ResetCheckerActor final : public Actor<Void>, public ActorCallback< ResetCheckerActor, 0, Void >, public FastAllocated<ResetCheckerActor>, public ResetCheckerActorState<ResetCheckerActor> {
															#line 640 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<ResetCheckerActor>::operator new;
	using FastAllocated<ResetCheckerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1424864727367988992UL, 9204240656213523456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResetCheckerActor, 0, Void >;
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ResetCheckerActor(ILogSystem::ServerPeekCursor* const& self,NetworkAddress const& addr) 
															#line 657 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   ResetCheckerActorState<ResetCheckerActor>(self, addr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resetChecker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5674855262629608192UL, 6168468558473721088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resetChecker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resetChecker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResetCheckerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> resetChecker( ILogSystem::ServerPeekCursor* const& self, NetworkAddress const& addr ) {
															#line 208 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new ResetCheckerActor(self, addr));
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 232 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

															#line 695 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via recordRequestMetrics()
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class RecordRequestMetricsActor>
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class RecordRequestMetricsActorState {
															#line 702 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	RecordRequestMetricsActorState(ILogSystem::ServerPeekCursor* const& self,NetworkAddress const& addr,Future<TLogPeekReply> const& in) 
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   addr(addr),
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   in(in)
															#line 713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("recordRequestMetrics", reinterpret_cast<unsigned long>(this));

	}
	~RecordRequestMetricsActorState() 
	{
		fdb_probe_actor_destroy("recordRequestMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 237 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				startTime = now();
															#line 238 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				StrictFuture<TLogPeekReply> __when_expr_0 = in;
															#line 238 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (static_cast<RecordRequestMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 733 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RecordRequestMetricsActor*>(this)->actor_wait_state = 1;
															#line 238 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecordRequestMetricsActor, 0, TLogPeekReply >*>(static_cast<RecordRequestMetricsActor*>(this)));
															#line 738 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecordRequestMetricsActorState();
		static_cast<RecordRequestMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 255 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (e.code() != error_code_broken_promise)
															#line 768 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 256 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 772 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
															#line 257 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = Never();
															#line 257 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<RecordRequestMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 778 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<RecordRequestMetricsActor*>(this)->actor_wait_state = 2;
															#line 257 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RecordRequestMetricsActor, 1, Void >*>(static_cast<RecordRequestMetricsActor*>(this)));
															#line 783 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(TLogPeekReply const& t,int loopDepth) 
	{
															#line 239 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (now() - self->lastReset > SERVER_KNOBS->PEEK_RESET_INTERVAL)
															#line 798 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 240 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (now() - startTime > SERVER_KNOBS->PEEK_MAX_LATENCY)
															#line 802 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 241 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (t.messages.size() >= SERVER_KNOBS->DESIRED_TOTAL_BYTES || SERVER_KNOBS->PEEK_COUNT_SMALL_MESSAGES)
															#line 806 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 242 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (self->resetCheck.isReady())
															#line 810 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					{
															#line 243 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
						self->resetCheck = resetChecker(self, addr);
															#line 814 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					}
															#line 245 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->slowReplies++;
															#line 818 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
				else
				{
															#line 247 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->unknownReplies++;
															#line 824 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
			}
			else
			{
															#line 250 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->fastReplies++;
															#line 831 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
		}
															#line 253 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<RecordRequestMetricsActor*>(this)->SAV<TLogPeekReply>::futures) { (void)(t); this->~RecordRequestMetricsActorState(); static_cast<RecordRequestMetricsActor*>(this)->destroy(); return 0; }
															#line 836 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<RecordRequestMetricsActor*>(this)->SAV< TLogPeekReply >::value()) TLogPeekReply(t);
		this->~RecordRequestMetricsActorState();
		static_cast<RecordRequestMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TLogPeekReply && t,int loopDepth) 
	{
															#line 239 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (now() - self->lastReset > SERVER_KNOBS->PEEK_RESET_INTERVAL)
															#line 848 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 240 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (now() - startTime > SERVER_KNOBS->PEEK_MAX_LATENCY)
															#line 852 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 241 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (t.messages.size() >= SERVER_KNOBS->DESIRED_TOTAL_BYTES || SERVER_KNOBS->PEEK_COUNT_SMALL_MESSAGES)
															#line 856 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 242 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (self->resetCheck.isReady())
															#line 860 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					{
															#line 243 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
						self->resetCheck = resetChecker(self, addr);
															#line 864 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					}
															#line 245 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->slowReplies++;
															#line 868 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
				else
				{
															#line 247 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->unknownReplies++;
															#line 874 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
			}
			else
			{
															#line 250 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->fastReplies++;
															#line 881 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
		}
															#line 253 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<RecordRequestMetricsActor*>(this)->SAV<TLogPeekReply>::futures) { (void)(t); this->~RecordRequestMetricsActorState(); static_cast<RecordRequestMetricsActor*>(this)->destroy(); return 0; }
															#line 886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<RecordRequestMetricsActor*>(this)->SAV< TLogPeekReply >::value()) TLogPeekReply(t);
		this->~RecordRequestMetricsActorState();
		static_cast<RecordRequestMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(TLogPeekReply const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TLogPeekReply && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecordRequestMetricsActor*>(this)->actor_wait_state > 0) static_cast<RecordRequestMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<RecordRequestMetricsActor*>(this)->ActorCallback< RecordRequestMetricsActor, 0, TLogPeekReply >::remove();

	}
	void a_callback_fire(ActorCallback< RecordRequestMetricsActor, 0, TLogPeekReply >*,TLogPeekReply const& value) 
	{
		fdb_probe_actor_enter("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecordRequestMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecordRequestMetricsActor, 0, TLogPeekReply >*,TLogPeekReply && value) 
	{
		fdb_probe_actor_enter("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecordRequestMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecordRequestMetricsActor, 0, TLogPeekReply >*,Error err) 
	{
		fdb_probe_actor_enter("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecordRequestMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 973 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 258 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 981 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RecordRequestMetricsActor*>(this)->actor_wait_state > 0) static_cast<RecordRequestMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<RecordRequestMetricsActor*>(this)->ActorCallback< RecordRequestMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecordRequestMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecordRequestMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RecordRequestMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecordRequestMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RecordRequestMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecordRequestMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recordRequestMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::ServerPeekCursor* self;
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	NetworkAddress addr;
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	Future<TLogPeekReply> in;
															#line 237 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	double startTime;
															#line 1068 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via recordRequestMetrics()
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class RecordRequestMetricsActor final : public Actor<TLogPeekReply>, public ActorCallback< RecordRequestMetricsActor, 0, TLogPeekReply >, public ActorCallback< RecordRequestMetricsActor, 1, Void >, public FastAllocated<RecordRequestMetricsActor>, public RecordRequestMetricsActorState<RecordRequestMetricsActor> {
															#line 1073 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<RecordRequestMetricsActor>::operator new;
	using FastAllocated<RecordRequestMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5081711845563829760UL, 2961958582528498688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TLogPeekReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecordRequestMetricsActor, 0, TLogPeekReply >;
friend struct ActorCallback< RecordRequestMetricsActor, 1, Void >;
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	RecordRequestMetricsActor(ILogSystem::ServerPeekCursor* const& self,NetworkAddress const& addr,Future<TLogPeekReply> const& in) 
															#line 1091 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<TLogPeekReply>(),
		   RecordRequestMetricsActorState<RecordRequestMetricsActor>(self, addr, in),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recordRequestMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2339828406215683072UL, 3358350829946382592UL);
		ActorExecutionContextHelper __helper(static_cast<RecordRequestMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recordRequestMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recordRequestMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecordRequestMetricsActor, 0, TLogPeekReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RecordRequestMetricsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<TLogPeekReply> recordRequestMetrics( ILogSystem::ServerPeekCursor* const& self, NetworkAddress const& addr, Future<TLogPeekReply> const& in ) {
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<TLogPeekReply>(new RecordRequestMetricsActor(self, addr, in));
															#line 1125 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 261 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

															#line 1130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via serverPeekParallelGetMore()
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class ServerPeekParallelGetMoreActor>
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ServerPeekParallelGetMoreActorState {
															#line 1137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ServerPeekParallelGetMoreActorState(ILogSystem::ServerPeekCursor* const& self,TaskPriority const& taskID) 
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   taskID(taskID)
															#line 1146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this));

	}
	~ServerPeekParallelGetMoreActorState() 
	{
		fdb_probe_actor_destroy("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 263 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!self->interf || self->isExhausted())
															#line 1161 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (self->hasMessage())
															#line 1165 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 265 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (!static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekParallelGetMoreActorState(); static_cast<ServerPeekParallelGetMoreActor*>(this)->destroy(); return 0; }
															#line 1169 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					new (&static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ServerPeekParallelGetMoreActorState();
					static_cast<ServerPeekParallelGetMoreActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 266 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				this->~ServerPeekParallelGetMoreActorState();
															#line 1177 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				static_cast<ServerPeekParallelGetMoreActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 269 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!self->interfaceChanged.isValid())
															#line 1183 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 270 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->interfaceChanged = self->interf->onChange();
															#line 1187 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
															#line 273 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			;
															#line 1191 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerPeekParallelGetMoreActorState();
		static_cast<ServerPeekParallelGetMoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 274 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent("SPC_GetMoreP", self->randomID) .detail("Tag", self->tag.toString()) .detail("Has", self->hasMessage()) .detail("Begin", self->messageVersion.version) .detail("Parallel", self->parallelGetMore) .detail("Seq", self->sequence) .detail("Sizes", self->futureResults.size()) .detail("Interf", self->interf->get().present() ? self->interf->get().id() : UID());
															#line 282 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		expectedBegin = self->messageVersion.version;
															#line 1223 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		try {
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (self->parallelGetMore || self->onlySpilled)
															#line 1227 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 285 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				for(;self->futureResults.size() < SERVER_KNOBS->PARALLEL_GET_MORE_REQUESTS && self->interf->get().present();) {
															#line 287 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->futureResults.push_back(recordRequestMetrics( self, self->interf->get().interf().peekMessages.getEndpoint().getPrimaryAddress(), self->interf->get().interf().peekMessages.getReply( TLogPeekRequest(self->messageVersion.version, self->tag, self->returnIfBlocked, self->onlySpilled, std::make_pair(self->randomID, self->sequence++), self->end.version), taskID)));
															#line 1233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
															#line 299 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (self->sequence == std::numeric_limits<decltype(self->sequence)>::max())
															#line 1237 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 300 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					return a_body1loopBody1Catch1(operation_obsolete(), loopDepth);
															#line 1241 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
			}
			else
			{
															#line 302 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (self->futureResults.size() == 0)
															#line 1248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 303 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (!static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekParallelGetMoreActorState(); static_cast<ServerPeekParallelGetMoreActor*>(this)->destroy(); return 0; }
															#line 1252 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					new (&static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ServerPeekParallelGetMoreActorState();
					static_cast<ServerPeekParallelGetMoreActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 306 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (self->hasMessage())
															#line 1261 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 307 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (!static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekParallelGetMoreActorState(); static_cast<ServerPeekParallelGetMoreActor*>(this)->destroy(); return 0; }
															#line 1265 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				new (&static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ServerPeekParallelGetMoreActorState();
				static_cast<ServerPeekParallelGetMoreActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 310 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<TLogPeekReply> __when_expr_0 = self->interf->get().present() ? self->futureResults.front() : Never();
															#line 309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<ServerPeekParallelGetMoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1275 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 325 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->interfaceChanged;
															#line 1279 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<ServerPeekParallelGetMoreActor*>(this)->actor_wait_state = 1;
															#line 310 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServerPeekParallelGetMoreActor, 0, TLogPeekReply >*>(static_cast<ServerPeekParallelGetMoreActor*>(this)));
															#line 325 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServerPeekParallelGetMoreActor, 1, Void >*>(static_cast<ServerPeekParallelGetMoreActor*>(this)));
															#line 1286 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 334 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			DebugLogTraceEvent("PeekCursorError", self->randomID) .error(e) .detail("Tag", self->tag.toString()) .detail("Begin", self->messageVersion.version) .detail("Interf", self->interf->get().present() ? self->interf->get().id() : UID());
															#line 340 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 1310 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 341 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->end.reset(self->messageVersion.version);
															#line 342 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (!static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekParallelGetMoreActorState(); static_cast<ServerPeekParallelGetMoreActor*>(this)->destroy(); return 0; }
															#line 1316 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				new (&static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ServerPeekParallelGetMoreActorState();
				static_cast<ServerPeekParallelGetMoreActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 343 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (e.code() == error_code_timed_out || e.code() == error_code_operation_obsolete)
															#line 1326 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 344 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					TraceEvent ev("PeekCursorTimedOut", self->randomID);
															#line 351 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					CODE_PROBE(e.code() == error_code_timed_out, "peek cursor timed out");
															#line 352 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (g_network->isSimulated() && now() >= g_simulator->connectionFailureEnableTime + FLOW_KNOBS->SIM_SPEEDUP_AFTER_SECONDS + SERVER_KNOBS->PEEK_TRACKER_EXPIRATION_TIME)
															#line 1334 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					{
															#line 355 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
						ASSERT_WE_THINK(e.code() == error_code_operation_obsolete || SERVER_KNOBS->PEEK_TRACKER_EXPIRATION_TIME < 10);
															#line 1338 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					}
															#line 358 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->interfaceChanged = self->interf->onChange();
															#line 359 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->randomID = deterministicRandom()->randomUniqueID();
															#line 360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->sequence = 0;
															#line 361 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->futureResults.clear();
															#line 362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					ev.error(e) .detail("Tag", self->tag.toString()) .detail("Begin", self->messageVersion.version) .detail("NewID", self->randomID) .detail("Interf", self->interf->get().present() ? self->interf->get().id() : UID());
															#line 1350 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
				else
				{
															#line 368 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1356 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogPeekReply const& res,int loopDepth) 
	{
															#line 311 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (res.begin.get() != expectedBegin)
															#line 1379 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 312 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			return a_body1loopBody1Catch1(operation_obsolete(), loopDepth);
															#line 1383 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 314 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		expectedBegin = res.end;
															#line 315 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->futureResults.pop_front();
															#line 316 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		updateCursorWithReply(self, res);
															#line 317 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent("SPC_GetMoreReply", self->randomID) .detail("Has", self->hasMessage()) .detail("Tag", self->tag.toString()) .detail("End", res.end) .detail("Size", self->futureResults.size()) .detail("Popped", res.popped.present() ? res.popped.get() : 0);
															#line 323 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekParallelGetMoreActorState(); static_cast<ServerPeekParallelGetMoreActor*>(this)->destroy(); return 0; }
															#line 1395 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekParallelGetMoreActorState();
		static_cast<ServerPeekParallelGetMoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogPeekReply && res,int loopDepth) 
	{
															#line 311 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (res.begin.get() != expectedBegin)
															#line 1407 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 312 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			return a_body1loopBody1Catch1(operation_obsolete(), loopDepth);
															#line 1411 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 314 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		expectedBegin = res.end;
															#line 315 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->futureResults.pop_front();
															#line 316 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		updateCursorWithReply(self, res);
															#line 317 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent("SPC_GetMoreReply", self->randomID) .detail("Has", self->hasMessage()) .detail("Tag", self->tag.toString()) .detail("End", res.end) .detail("Size", self->futureResults.size()) .detail("Popped", res.popped.present() ? res.popped.get() : 0);
															#line 323 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekParallelGetMoreActorState(); static_cast<ServerPeekParallelGetMoreActor*>(this)->destroy(); return 0; }
															#line 1423 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekParallelGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekParallelGetMoreActorState();
		static_cast<ServerPeekParallelGetMoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 326 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->interfaceChanged = self->interf->onChange();
															#line 327 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->randomID = deterministicRandom()->randomUniqueID();
															#line 328 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->sequence = 0;
															#line 329 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->onlySpilled = false;
															#line 330 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->futureResults.clear();
															#line 1443 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 326 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->interfaceChanged = self->interf->onChange();
															#line 327 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->randomID = deterministicRandom()->randomUniqueID();
															#line 328 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->sequence = 0;
															#line 329 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->onlySpilled = false;
															#line 330 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->futureResults.clear();
															#line 1460 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerPeekParallelGetMoreActor*>(this)->actor_wait_state > 0) static_cast<ServerPeekParallelGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<ServerPeekParallelGetMoreActor*>(this)->ActorCallback< ServerPeekParallelGetMoreActor, 0, TLogPeekReply >::remove();
		static_cast<ServerPeekParallelGetMoreActor*>(this)->ActorCallback< ServerPeekParallelGetMoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerPeekParallelGetMoreActor, 0, TLogPeekReply >*,TLogPeekReply const& value) 
	{
		fdb_probe_actor_enter("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekParallelGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerPeekParallelGetMoreActor, 0, TLogPeekReply >*,TLogPeekReply && value) 
	{
		fdb_probe_actor_enter("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekParallelGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServerPeekParallelGetMoreActor, 0, TLogPeekReply >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekParallelGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerPeekParallelGetMoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekParallelGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServerPeekParallelGetMoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekParallelGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServerPeekParallelGetMoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekParallelGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::ServerPeekCursor* self;
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TaskPriority taskID;
															#line 282 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	Version expectedBegin;
															#line 1605 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via serverPeekParallelGetMore()
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ServerPeekParallelGetMoreActor final : public Actor<Void>, public ActorCallback< ServerPeekParallelGetMoreActor, 0, TLogPeekReply >, public ActorCallback< ServerPeekParallelGetMoreActor, 1, Void >, public FastAllocated<ServerPeekParallelGetMoreActor>, public ServerPeekParallelGetMoreActorState<ServerPeekParallelGetMoreActor> {
															#line 1610 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<ServerPeekParallelGetMoreActor>::operator new;
	using FastAllocated<ServerPeekParallelGetMoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13434637342940872192UL, 10235589911613752576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServerPeekParallelGetMoreActor, 0, TLogPeekReply >;
friend struct ActorCallback< ServerPeekParallelGetMoreActor, 1, Void >;
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ServerPeekParallelGetMoreActor(ILogSystem::ServerPeekCursor* const& self,TaskPriority const& taskID) 
															#line 1628 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   ServerPeekParallelGetMoreActorState<ServerPeekParallelGetMoreActor>(self, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8537038224421268480UL, 14487980567865639936UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekParallelGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serverPeekParallelGetMore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serverPeekParallelGetMore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServerPeekParallelGetMoreActor, 0, TLogPeekReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> serverPeekParallelGetMore( ILogSystem::ServerPeekCursor* const& self, TaskPriority const& taskID ) {
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new ServerPeekParallelGetMoreActor(self, taskID));
															#line 1661 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 373 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

															#line 1666 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via serverPeekStreamGetMore()
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class ServerPeekStreamGetMoreActor>
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ServerPeekStreamGetMoreActorState {
															#line 1673 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ServerPeekStreamGetMoreActorState(ILogSystem::ServerPeekCursor* const& self,TaskPriority const& taskID) 
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   taskID(taskID)
															#line 1682 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this));

	}
	~ServerPeekStreamGetMoreActorState() 
	{
		fdb_probe_actor_destroy("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 375 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!self->interf || self->isExhausted())
															#line 1697 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 376 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->peekReplyStream.reset();
															#line 377 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (self->hasMessage())
															#line 1703 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 378 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (!static_cast<ServerPeekStreamGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekStreamGetMoreActorState(); static_cast<ServerPeekStreamGetMoreActor*>(this)->destroy(); return 0; }
															#line 1707 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					new (&static_cast<ServerPeekStreamGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ServerPeekStreamGetMoreActorState();
					static_cast<ServerPeekStreamGetMoreActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 379 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				this->~ServerPeekStreamGetMoreActorState();
															#line 1715 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				static_cast<ServerPeekStreamGetMoreActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 382 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			;
															#line 1721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerPeekStreamGetMoreActorState();
		static_cast<ServerPeekStreamGetMoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 384 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			expectedBegin = self->messageVersion.version;
															#line 385 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			fPeekReply = self->peekReplyStream.present() ? map(waitAndForward(self->peekReplyStream.get().getFuture()), [](const TLogPeekStreamReply& r) { return r.rep; }) : Never();
															#line 390 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->peekReplyStream.present() ? Never() : tryEstablishPeekStream(self);
															#line 389 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1758 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->interf->onChange();
															#line 1762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 395 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<TLogPeekReply> __when_expr_2 = self->peekReplyStream.present() ? recordRequestMetrics( self, self->interf->get().interf().peekStreamMessages.getEndpoint().getPrimaryAddress(), fPeekReply) : Never();
															#line 1766 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
			static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state = 1;
															#line 390 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServerPeekStreamGetMoreActor, 0, Void >*>(static_cast<ServerPeekStreamGetMoreActor*>(this)));
															#line 391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServerPeekStreamGetMoreActor, 1, Void >*>(static_cast<ServerPeekStreamGetMoreActor*>(this)));
															#line 395 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServerPeekStreamGetMoreActor, 2, TLogPeekReply >*>(static_cast<ServerPeekStreamGetMoreActor*>(this)));
															#line 1775 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 420 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			DebugLogTraceEvent(SevDebug, "SPC_GetMoreB_Error", self->randomID) .errorUnsuppressed(e) .detail("Tag", self->tag);
															#line 423 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (e.code() == error_code_connection_failed || e.code() == error_code_operation_obsolete || e.code() == error_code_request_maybe_delivered)
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 426 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->peekReplyStream.reset();
															#line 427 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				StrictFuture<Void> __when_expr_4 = delay(0);
															#line 427 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1807 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
				static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state = 3;
															#line 427 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ServerPeekStreamGetMoreActor, 4, Void >*>(static_cast<ServerPeekStreamGetMoreActor*>(this)));
															#line 1812 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 428 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (e.code() == error_code_end_of_stream)
															#line 1819 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 429 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->peekReplyStream.reset();
															#line 430 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->end.reset(self->messageVersion.version);
															#line 431 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (!static_cast<ServerPeekStreamGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekStreamGetMoreActorState(); static_cast<ServerPeekStreamGetMoreActor*>(this)->destroy(); return 0; }
															#line 1827 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					new (&static_cast<ServerPeekStreamGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~ServerPeekStreamGetMoreActorState();
					static_cast<ServerPeekStreamGetMoreActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 433 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1837 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->onlySpilled = false;
															#line 393 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->peekReplyStream.reset();
															#line 1873 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->onlySpilled = false;
															#line 393 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->peekReplyStream.reset();
															#line 1884 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(TLogPeekReply const& res,int loopDepth) 
	{
															#line 402 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (res.begin.get() != expectedBegin)
															#line 1893 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 403 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			return a_body1loopBody1Catch1(operation_obsolete(), loopDepth);
															#line 1897 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 405 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		updateCursorWithReply(self, res);
															#line 406 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		expectedBegin = res.end;
															#line 407 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent(SevDebug, "SPC_GetMoreB", self->randomID) .detail("Tag", self->tag) .detail("Has", self->hasMessage()) .detail("End", res.end) .detail("Popped", res.popped.present() ? res.popped.get() : 0);
															#line 415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0, taskID);
															#line 415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1909 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state = 2;
															#line 415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >*>(static_cast<ServerPeekStreamGetMoreActor*>(this)));
															#line 1914 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(TLogPeekReply && res,int loopDepth) 
	{
															#line 402 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (res.begin.get() != expectedBegin)
															#line 1923 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 403 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			return a_body1loopBody1Catch1(operation_obsolete(), loopDepth);
															#line 1927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 405 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		updateCursorWithReply(self, res);
															#line 406 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		expectedBegin = res.end;
															#line 407 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent(SevDebug, "SPC_GetMoreB", self->randomID) .detail("Tag", self->tag) .detail("Has", self->hasMessage()) .detail("End", res.end) .detail("Popped", res.popped.present() ? res.popped.get() : 0);
															#line 415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0, taskID);
															#line 415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1939 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1when3when1(__when_expr_3.get(), loopDepth); };
		static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state = 2;
															#line 415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >*>(static_cast<ServerPeekStreamGetMoreActor*>(this)));
															#line 1944 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state > 0) static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<ServerPeekStreamGetMoreActor*>(this)->ActorCallback< ServerPeekStreamGetMoreActor, 0, Void >::remove();
		static_cast<ServerPeekStreamGetMoreActor*>(this)->ActorCallback< ServerPeekStreamGetMoreActor, 1, Void >::remove();
		static_cast<ServerPeekStreamGetMoreActor*>(this)->ActorCallback< ServerPeekStreamGetMoreActor, 2, TLogPeekReply >::remove();

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServerPeekStreamGetMoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServerPeekStreamGetMoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1when3cont1(Void const& _,int loopDepth) 
	{
															#line 416 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekStreamGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekStreamGetMoreActorState(); static_cast<ServerPeekStreamGetMoreActor*>(this)->destroy(); return 0; }
															#line 2075 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekStreamGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekStreamGetMoreActorState();
		static_cast<ServerPeekStreamGetMoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when3cont1(Void && _,int loopDepth) 
	{
															#line 416 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekStreamGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekStreamGetMoreActorState(); static_cast<ServerPeekStreamGetMoreActor*>(this)->destroy(); return 0; }
															#line 2087 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekStreamGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekStreamGetMoreActorState();
		static_cast<ServerPeekStreamGetMoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when3cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state > 0) static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<ServerPeekStreamGetMoreActor*>(this)->ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 2, TLogPeekReply >*,TLogPeekReply const& value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 2, TLogPeekReply >*,TLogPeekReply && value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ServerPeekStreamGetMoreActor, 2, TLogPeekReply >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state > 0) static_cast<ServerPeekStreamGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<ServerPeekStreamGetMoreActor*>(this)->ActorCallback< ServerPeekStreamGetMoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ServerPeekStreamGetMoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ServerPeekStreamGetMoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::ServerPeekCursor* self;
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TaskPriority taskID;
															#line 384 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	Version expectedBegin;
															#line 385 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	Future<TLogPeekReply> fPeekReply;
															#line 2341 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via serverPeekStreamGetMore()
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ServerPeekStreamGetMoreActor final : public Actor<Void>, public ActorCallback< ServerPeekStreamGetMoreActor, 0, Void >, public ActorCallback< ServerPeekStreamGetMoreActor, 1, Void >, public ActorCallback< ServerPeekStreamGetMoreActor, 2, TLogPeekReply >, public ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >, public ActorCallback< ServerPeekStreamGetMoreActor, 4, Void >, public FastAllocated<ServerPeekStreamGetMoreActor>, public ServerPeekStreamGetMoreActorState<ServerPeekStreamGetMoreActor> {
															#line 2346 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<ServerPeekStreamGetMoreActor>::operator new;
	using FastAllocated<ServerPeekStreamGetMoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12842441796528837632UL, 3234250771455475200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServerPeekStreamGetMoreActor, 0, Void >;
friend struct ActorCallback< ServerPeekStreamGetMoreActor, 1, Void >;
friend struct ActorCallback< ServerPeekStreamGetMoreActor, 2, TLogPeekReply >;
friend struct ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >;
friend struct ActorCallback< ServerPeekStreamGetMoreActor, 4, Void >;
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ServerPeekStreamGetMoreActor(ILogSystem::ServerPeekCursor* const& self,TaskPriority const& taskID) 
															#line 2367 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   ServerPeekStreamGetMoreActorState<ServerPeekStreamGetMoreActor>(self, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9473550890512656896UL, 12966144503364222720UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekStreamGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serverPeekStreamGetMore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serverPeekStreamGetMore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServerPeekStreamGetMoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ServerPeekStreamGetMoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ServerPeekStreamGetMoreActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> serverPeekStreamGetMore( ILogSystem::ServerPeekCursor* const& self, TaskPriority const& taskID ) {
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new ServerPeekStreamGetMoreActor(self, taskID));
															#line 2402 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 438 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

															#line 2407 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via serverPeekGetMore()
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class ServerPeekGetMoreActor>
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ServerPeekGetMoreActorState {
															#line 2414 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ServerPeekGetMoreActorState(ILogSystem::ServerPeekCursor* const& self,TaskPriority const& taskID) 
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   taskID(taskID)
															#line 2423 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("serverPeekGetMore", reinterpret_cast<unsigned long>(this));

	}
	~ServerPeekGetMoreActorState() 
	{
		fdb_probe_actor_destroy("serverPeekGetMore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!self->interf || self->isExhausted())
															#line 2438 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 441 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				this->~ServerPeekGetMoreActorState();
															#line 2442 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				static_cast<ServerPeekGetMoreActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
			try {
															#line 444 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				;
															#line 2449 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerPeekGetMoreActorState();
		static_cast<ServerPeekGetMoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 471 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 2479 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 472 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->end.reset(self->messageVersion.version);
															#line 473 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (!static_cast<ServerPeekGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekGetMoreActorState(); static_cast<ServerPeekGetMoreActor*>(this)->destroy(); return 0; }
															#line 2485 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				new (&static_cast<ServerPeekGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ServerPeekGetMoreActorState();
				static_cast<ServerPeekGetMoreActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 475 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2493 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 446 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<TLogPeekReply> __when_expr_0 = self->interf->get().present() ? brokenPromiseToNever(self->interf->get().interf().peekMessages.getReply( TLogPeekRequest(self->messageVersion.version, self->tag, self->returnIfBlocked, self->onlySpilled, Optional<std::pair<UID, int>>(), self->end.version), taskID)) : Never();
															#line 445 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<ServerPeekGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2516 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 465 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->interf->onChange();
															#line 2520 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ServerPeekGetMoreActor*>(this)->actor_wait_state = 1;
															#line 446 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServerPeekGetMoreActor, 0, TLogPeekReply >*>(static_cast<ServerPeekGetMoreActor*>(this)));
															#line 465 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServerPeekGetMoreActor, 1, Void >*>(static_cast<ServerPeekGetMoreActor*>(this)));
															#line 2527 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogPeekReply const& res,int loopDepth) 
	{
															#line 457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		updateCursorWithReply(self, res);
															#line 458 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent("SPC_GetMoreB", self->randomID) .detail("Tag", self->tag.toString()) .detail("Has", self->hasMessage()) .detail("End", res.end) .detail("Popped", res.popped.present() ? res.popped.get() : 0);
															#line 463 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekGetMoreActorState(); static_cast<ServerPeekGetMoreActor*>(this)->destroy(); return 0; }
															#line 2546 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekGetMoreActorState();
		static_cast<ServerPeekGetMoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(TLogPeekReply && res,int loopDepth) 
	{
															#line 457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		updateCursorWithReply(self, res);
															#line 458 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		DebugLogTraceEvent("SPC_GetMoreB", self->randomID) .detail("Tag", self->tag.toString()) .detail("Has", self->hasMessage()) .detail("End", res.end) .detail("Popped", res.popped.present() ? res.popped.get() : 0);
															#line 463 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekGetMoreActorState(); static_cast<ServerPeekGetMoreActor*>(this)->destroy(); return 0; }
															#line 2562 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekGetMoreActorState();
		static_cast<ServerPeekGetMoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 466 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->onlySpilled = false;
															#line 2574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 466 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->onlySpilled = false;
															#line 2583 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerPeekGetMoreActor*>(this)->actor_wait_state > 0) static_cast<ServerPeekGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<ServerPeekGetMoreActor*>(this)->ActorCallback< ServerPeekGetMoreActor, 0, TLogPeekReply >::remove();
		static_cast<ServerPeekGetMoreActor*>(this)->ActorCallback< ServerPeekGetMoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerPeekGetMoreActor, 0, TLogPeekReply >*,TLogPeekReply const& value) 
	{
		fdb_probe_actor_enter("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerPeekGetMoreActor, 0, TLogPeekReply >*,TLogPeekReply && value) 
	{
		fdb_probe_actor_enter("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServerPeekGetMoreActor, 0, TLogPeekReply >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerPeekGetMoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServerPeekGetMoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServerPeekGetMoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::ServerPeekCursor* self;
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TaskPriority taskID;
															#line 2713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via serverPeekGetMore()
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ServerPeekGetMoreActor final : public Actor<Void>, public ActorCallback< ServerPeekGetMoreActor, 0, TLogPeekReply >, public ActorCallback< ServerPeekGetMoreActor, 1, Void >, public FastAllocated<ServerPeekGetMoreActor>, public ServerPeekGetMoreActorState<ServerPeekGetMoreActor> {
															#line 2718 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<ServerPeekGetMoreActor>::operator new;
	using FastAllocated<ServerPeekGetMoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2337397219617726464UL, 9874381288319994368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServerPeekGetMoreActor, 0, TLogPeekReply >;
friend struct ActorCallback< ServerPeekGetMoreActor, 1, Void >;
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ServerPeekGetMoreActor(ILogSystem::ServerPeekCursor* const& self,TaskPriority const& taskID) 
															#line 2736 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   ServerPeekGetMoreActorState<ServerPeekGetMoreActor>(self, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serverPeekGetMore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9602898158102820608UL, 9969600990556359424UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serverPeekGetMore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serverPeekGetMore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServerPeekGetMoreActor, 0, TLogPeekReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> serverPeekGetMore( ILogSystem::ServerPeekCursor* const& self, TaskPriority const& taskID ) {
															#line 439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new ServerPeekGetMoreActor(self, taskID));
															#line 2769 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

Future<Void> ILogSystem::ServerPeekCursor::getMore(TaskPriority taskID) {
	DebugLogTraceEvent("SPC_GetMore", randomID)
	    .detail("Tag", tag.toString())
	    .detail("HasMessage", hasMessage())
	    .detail("More", !more.isValid() || more.isReady())
	    .detail("Parallel", parallelGetMore)
	    .detail("MessageVersion", messageVersion.toString())
	    .detail("End", end.toString());
	if (hasMessage() && !parallelGetMore)
		return Void();
	if (!more.isValid() || more.isReady()) {
		if (usePeekStream &&
		    (tag.locality >= 0 || tag.locality == tagLocalityLogRouter || tag.locality == tagLocalityRemoteLog)) {
			more = serverPeekStreamGetMore(this, taskID);
		} else if (parallelGetMore || onlySpilled || futureResults.size()) {
			more = serverPeekParallelGetMore(this, taskID);
		} else {
			more = serverPeekGetMore(this, taskID);
		}
	}
	return more;
}

															#line 2797 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via serverPeekOnFailed()
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class ServerPeekOnFailedActor>
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ServerPeekOnFailedActorState {
															#line 2804 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ServerPeekOnFailedActorState(ILogSystem::ServerPeekCursor const* const& self) 
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self)
															#line 2811 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("serverPeekOnFailed", reinterpret_cast<unsigned long>(this));

	}
	~ServerPeekOnFailedActorState() 
	{
		fdb_probe_actor_destroy("serverPeekOnFailed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 503 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			;
															#line 2826 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ServerPeekOnFailedActorState();
		static_cast<ServerPeekOnFailedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 505 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->interf->get().present() ? IFailureMonitor::failureMonitor().onStateEqual( self->interf->get().interf().peekMessages.getEndpoint(), FailureStatus()) : Never();
															#line 504 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<ServerPeekOnFailedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2858 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 511 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->interf->get().present() ? IFailureMonitor::failureMonitor().onStateEqual( self->interf->get().interf().peekStreamMessages.getEndpoint(), FailureStatus()) : Never();
															#line 2862 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 517 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->interf->onChange();
															#line 2866 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
		static_cast<ServerPeekOnFailedActor*>(this)->actor_wait_state = 1;
															#line 505 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ServerPeekOnFailedActor, 0, Void >*>(static_cast<ServerPeekOnFailedActor*>(this)));
															#line 511 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ServerPeekOnFailedActor, 1, Void >*>(static_cast<ServerPeekOnFailedActor*>(this)));
															#line 517 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ServerPeekOnFailedActor, 2, Void >*>(static_cast<ServerPeekOnFailedActor*>(this)));
															#line 2875 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 509 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekOnFailedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekOnFailedActorState(); static_cast<ServerPeekOnFailedActor*>(this)->destroy(); return 0; }
															#line 2890 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekOnFailedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekOnFailedActorState();
		static_cast<ServerPeekOnFailedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 509 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekOnFailedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekOnFailedActorState(); static_cast<ServerPeekOnFailedActor*>(this)->destroy(); return 0; }
															#line 2902 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekOnFailedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekOnFailedActorState();
		static_cast<ServerPeekOnFailedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 515 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekOnFailedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekOnFailedActorState(); static_cast<ServerPeekOnFailedActor*>(this)->destroy(); return 0; }
															#line 2914 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekOnFailedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekOnFailedActorState();
		static_cast<ServerPeekOnFailedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 515 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<ServerPeekOnFailedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ServerPeekOnFailedActorState(); static_cast<ServerPeekOnFailedActor*>(this)->destroy(); return 0; }
															#line 2926 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<ServerPeekOnFailedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ServerPeekOnFailedActorState();
		static_cast<ServerPeekOnFailedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ServerPeekOnFailedActor*>(this)->actor_wait_state > 0) static_cast<ServerPeekOnFailedActor*>(this)->actor_wait_state = 0;
		static_cast<ServerPeekOnFailedActor*>(this)->ActorCallback< ServerPeekOnFailedActor, 0, Void >::remove();
		static_cast<ServerPeekOnFailedActor*>(this)->ActorCallback< ServerPeekOnFailedActor, 1, Void >::remove();
		static_cast<ServerPeekOnFailedActor*>(this)->ActorCallback< ServerPeekOnFailedActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ServerPeekOnFailedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerPeekOnFailedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ServerPeekOnFailedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ServerPeekOnFailedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServerPeekOnFailedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ServerPeekOnFailedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ServerPeekOnFailedActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ServerPeekOnFailedActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ServerPeekOnFailedActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::ServerPeekCursor const* self;
															#line 3127 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via serverPeekOnFailed()
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class ServerPeekOnFailedActor final : public Actor<Void>, public ActorCallback< ServerPeekOnFailedActor, 0, Void >, public ActorCallback< ServerPeekOnFailedActor, 1, Void >, public ActorCallback< ServerPeekOnFailedActor, 2, Void >, public FastAllocated<ServerPeekOnFailedActor>, public ServerPeekOnFailedActorState<ServerPeekOnFailedActor> {
															#line 3132 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<ServerPeekOnFailedActor>::operator new;
	using FastAllocated<ServerPeekOnFailedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6762451814870469632UL, 14289879233845746432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ServerPeekOnFailedActor, 0, Void >;
friend struct ActorCallback< ServerPeekOnFailedActor, 1, Void >;
friend struct ActorCallback< ServerPeekOnFailedActor, 2, Void >;
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ServerPeekOnFailedActor(ILogSystem::ServerPeekCursor const* const& self) 
															#line 3151 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   ServerPeekOnFailedActorState<ServerPeekOnFailedActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6219439930134373120UL, 4747642235680888576UL);
		ActorExecutionContextHelper __helper(static_cast<ServerPeekOnFailedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("serverPeekOnFailed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("serverPeekOnFailed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ServerPeekOnFailedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> serverPeekOnFailed( ILogSystem::ServerPeekCursor const* const& self ) {
															#line 502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new ServerPeekOnFailedActor(self));
															#line 3184 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 521 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

Future<Void> ILogSystem::ServerPeekCursor::onFailed() const {
	return serverPeekOnFailed(this);
}

bool ILogSystem::ServerPeekCursor::isActive() const {
	if (!interf->get().present())
		return false;
	if (isExhausted())
		return false;
	return IFailureMonitor::failureMonitor()
	           .getState(interf->get().interf().peekMessages.getEndpoint())
	           .isAvailable() &&
	       IFailureMonitor::failureMonitor()
	           .getState(interf->get().interf().peekStreamMessages.getEndpoint())
	           .isAvailable();
}

bool ILogSystem::ServerPeekCursor::isExhausted() const {
	return messageVersion >= end;
}

const LogMessageVersion& ILogSystem::ServerPeekCursor::version() const {
	return messageVersion;
} // Call only after nextMessage().  The sequence of the current message, or results.end if nextMessage() has returned
  // false.

Version ILogSystem::ServerPeekCursor::getMinKnownCommittedVersion() const {
	return results.minKnownCommittedVersion;
}

Optional<UID> ILogSystem::ServerPeekCursor::getPrimaryPeekLocation() const {
	if (interf && interf->get().present()) {
		return interf->get().id();
	}
	return Optional<UID>();
}

Optional<UID> ILogSystem::ServerPeekCursor::getCurrentPeekLocation() const {
	return ILogSystem::ServerPeekCursor::getPrimaryPeekLocation();
}

Version ILogSystem::ServerPeekCursor::popped() const {
	return poppedVersion;
}

ILogSystem::MergedPeekCursor::MergedPeekCursor(std::vector<Reference<ILogSystem::IPeekCursor>> const& serverCursors,
                                               Version begin)
  : serverCursors(serverCursors), tag(invalidTag), bestServer(-1), currentCursor(0), readQuorum(serverCursors.size()),
    messageVersion(begin), hasNextMessage(false), randomID(deterministicRandom()->randomUniqueID()),
    tLogReplicationFactor(0) {
	sortedVersions.resize(serverCursors.size());
}

ILogSystem::MergedPeekCursor::MergedPeekCursor(
    std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>> const& logServers,
    int bestServer,
    int readQuorum,
    Tag tag,
    Version begin,
    Version end,
    bool parallelGetMore,
    std::vector<LocalityData> const& tLogLocalities,
    Reference<IReplicationPolicy> const tLogPolicy,
    int tLogReplicationFactor)
  : tag(tag), bestServer(bestServer), currentCursor(0), readQuorum(readQuorum), messageVersion(begin),
    hasNextMessage(false), randomID(deterministicRandom()->randomUniqueID()),
    tLogReplicationFactor(tLogReplicationFactor) {
	if (tLogPolicy) {
		logSet = makeReference<LogSet>();
		logSet->tLogPolicy = tLogPolicy;
		logSet->tLogLocalities = tLogLocalities;
		filterLocalityDataForPolicy(logSet->tLogPolicy, &logSet->tLogLocalities);
		logSet->updateLocalitySet(logSet->tLogLocalities);
	}

	for (int i = 0; i < logServers.size(); i++) {
		auto cursor = makeReference<ILogSystem::ServerPeekCursor>(
		    logServers[i], tag, begin, end, bestServer >= 0, parallelGetMore);
		//TraceEvent("MPC_Starting", randomID).detail("Cursor", cursor->randomID).detail("End", end);
		serverCursors.push_back(cursor);
	}
	sortedVersions.resize(serverCursors.size());
}

ILogSystem::MergedPeekCursor::MergedPeekCursor(std::vector<Reference<ILogSystem::IPeekCursor>> const& serverCursors,
                                               LogMessageVersion const& messageVersion,
                                               int bestServer,
                                               int readQuorum,
                                               Optional<LogMessageVersion> nextVersion,
                                               Reference<LogSet> logSet,
                                               int tLogReplicationFactor)
  : logSet(logSet), serverCursors(serverCursors), bestServer(bestServer), currentCursor(0), readQuorum(readQuorum),
    nextVersion(nextVersion), messageVersion(messageVersion), hasNextMessage(false),
    randomID(deterministicRandom()->randomUniqueID()), tLogReplicationFactor(tLogReplicationFactor) {
	sortedVersions.resize(serverCursors.size());
	calcHasMessage();
}

Reference<ILogSystem::IPeekCursor> ILogSystem::MergedPeekCursor::cloneNoMore() {
	std::vector<Reference<ILogSystem::IPeekCursor>> cursors;
	for (auto it : serverCursors) {
		cursors.push_back(it->cloneNoMore());
	}
	return makeReference<ILogSystem::MergedPeekCursor>(
	    cursors, messageVersion, bestServer, readQuorum, nextVersion, logSet, tLogReplicationFactor);
}

void ILogSystem::MergedPeekCursor::setProtocolVersion(ProtocolVersion version) {
	for (auto it : serverCursors)
		if (it->hasMessage())
			it->setProtocolVersion(version);
}

Arena& ILogSystem::MergedPeekCursor::arena() {
	return serverCursors[currentCursor]->arena();
}

ArenaReader* ILogSystem::MergedPeekCursor::reader() {
	return serverCursors[currentCursor]->reader();
}

void ILogSystem::MergedPeekCursor::calcHasMessage() {
	if (bestServer >= 0) {
		if (nextVersion.present())
			serverCursors[bestServer]->advanceTo(nextVersion.get());
		if (serverCursors[bestServer]->hasMessage()) {
			messageVersion = serverCursors[bestServer]->version();
			currentCursor = bestServer;
			hasNextMessage = true;

			for (auto& c : serverCursors)
				c->advanceTo(messageVersion);

			return;
		}

		auto bestVersion = serverCursors[bestServer]->version();
		for (auto& c : serverCursors)
			c->advanceTo(bestVersion);
	}

	hasNextMessage = false;
	updateMessage(false);

	if (!hasNextMessage && logSet) {
		updateMessage(true);
	}
}

void ILogSystem::MergedPeekCursor::updateMessage(bool usePolicy) {
	loop {
		bool advancedPast = false;
		sortedVersions.clear();
		for (int i = 0; i < serverCursors.size(); i++) {
			auto& serverCursor = serverCursors[i];
			if (nextVersion.present())
				serverCursor->advanceTo(nextVersion.get());
			sortedVersions.push_back(std::pair<LogMessageVersion, int>(serverCursor->version(), i));
		}

		if (usePolicy) {
			ASSERT(logSet->tLogPolicy);
			std::sort(sortedVersions.begin(), sortedVersions.end());

			locations.clear();
			for (auto sortedVersion : sortedVersions) {
				locations.push_back(logSet->logEntryArray[sortedVersion.second]);
				if (locations.size() >= tLogReplicationFactor && logSet->satisfiesPolicy(locations)) {
					messageVersion = sortedVersion.first;
					break;
				}
			}
		} else {
			std::nth_element(sortedVersions.begin(), sortedVersions.end() - readQuorum, sortedVersions.end());
			messageVersion = sortedVersions[sortedVersions.size() - readQuorum].first;
		}

		for (int i = 0; i < serverCursors.size(); i++) {
			auto& c = serverCursors[i];
			auto start = c->version();
			c->advanceTo(messageVersion);
			if (start <= messageVersion && messageVersion < c->version()) {
				advancedPast = true;
				CODE_PROBE(true, "Merge peek cursor advanced past desired sequence", probe::decoration::rare);
			}
		}

		if (!advancedPast)
			break;
	}

	for (int i = 0; i < serverCursors.size(); i++) {
		auto& c = serverCursors[i];
		ASSERT_WE_THINK(!c->hasMessage() ||
		                c->version() >= messageVersion); // Seems like the loop above makes this unconditionally true
		if (c->version() == messageVersion && c->hasMessage()) {
			hasNextMessage = true;
			currentCursor = i;
			break;
		}
	}
}

bool ILogSystem::MergedPeekCursor::hasMessage() const {
	return hasNextMessage;
}

void ILogSystem::MergedPeekCursor::nextMessage() {
	nextVersion = version();
	nextVersion.get().sub++;
	serverCursors[currentCursor]->nextMessage();
	calcHasMessage();
	ASSERT(hasMessage() || !version().sub);
}

StringRef ILogSystem::MergedPeekCursor::getMessage() {
	return serverCursors[currentCursor]->getMessage();
}

StringRef ILogSystem::MergedPeekCursor::getMessageWithTags() {
	return serverCursors[currentCursor]->getMessageWithTags();
}

VectorRef<Tag> ILogSystem::MergedPeekCursor::getTags() const {
	return serverCursors[currentCursor]->getTags();
}

void ILogSystem::MergedPeekCursor::advanceTo(LogMessageVersion n) {
	bool canChange = false;
	for (auto& c : serverCursors) {
		if (c->version() < n) {
			canChange = true;
			c->advanceTo(n);
		}
	}
	if (canChange) {
		calcHasMessage();
	}
}

															#line 3429 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via mergedPeekGetMore()
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class MergedPeekGetMoreActor>
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class MergedPeekGetMoreActorState {
															#line 3436 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	MergedPeekGetMoreActorState(ILogSystem::MergedPeekCursor* const& self,LogMessageVersion const& startVersion,TaskPriority const& taskID) 
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   startVersion(startVersion),
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   taskID(taskID)
															#line 3447 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("mergedPeekGetMore", reinterpret_cast<unsigned long>(this));

	}
	~MergedPeekGetMoreActorState() 
	{
		fdb_probe_actor_destroy("mergedPeekGetMore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 765 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			;
															#line 3462 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MergedPeekGetMoreActorState();
		static_cast<MergedPeekGetMoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 767 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->bestServer >= 0 && self->serverCursors[self->bestServer]->isActive())
															#line 3492 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 768 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			ASSERT(!self->serverCursors[self->bestServer]->hasMessage());
															#line 769 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->serverCursors[self->bestServer]->getMore(taskID) || self->serverCursors[self->bestServer]->onFailed();
															#line 769 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<MergedPeekGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3500 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MergedPeekGetMoreActor*>(this)->actor_wait_state = 1;
															#line 769 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MergedPeekGetMoreActor, 0, Void >*>(static_cast<MergedPeekGetMoreActor*>(this)));
															#line 3505 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 772 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			std::vector<Future<Void>> q;
															#line 773 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			for( auto& c : self->serverCursors ) {
															#line 774 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (!c->hasMessage())
															#line 3516 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 775 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					q.push_back(c->getMore(taskID));
															#line 3520 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
			}
															#line 776 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_1 = quorum(q, 1);
															#line 776 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<MergedPeekGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3527 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<MergedPeekGetMoreActor*>(this)->actor_wait_state = 2;
															#line 776 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MergedPeekGetMoreActor, 1, Void >*>(static_cast<MergedPeekGetMoreActor*>(this)));
															#line 3532 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 778 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->calcHasMessage();
															#line 780 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->hasMessage() || self->version() > startVersion)
															#line 3544 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 781 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!static_cast<MergedPeekGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MergedPeekGetMoreActorState(); static_cast<MergedPeekGetMoreActor*>(this)->destroy(); return 0; }
															#line 3548 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			new (&static_cast<MergedPeekGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MergedPeekGetMoreActorState();
			static_cast<MergedPeekGetMoreActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MergedPeekGetMoreActor*>(this)->actor_wait_state > 0) static_cast<MergedPeekGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<MergedPeekGetMoreActor*>(this)->ActorCallback< MergedPeekGetMoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MergedPeekGetMoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MergedPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MergedPeekGetMoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MergedPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MergedPeekGetMoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MergedPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MergedPeekGetMoreActor*>(this)->actor_wait_state > 0) static_cast<MergedPeekGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<MergedPeekGetMoreActor*>(this)->ActorCallback< MergedPeekGetMoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MergedPeekGetMoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MergedPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MergedPeekGetMoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MergedPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MergedPeekGetMoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MergedPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::MergedPeekCursor* self;
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	LogMessageVersion startVersion;
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TaskPriority taskID;
															#line 3738 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via mergedPeekGetMore()
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class MergedPeekGetMoreActor final : public Actor<Void>, public ActorCallback< MergedPeekGetMoreActor, 0, Void >, public ActorCallback< MergedPeekGetMoreActor, 1, Void >, public FastAllocated<MergedPeekGetMoreActor>, public MergedPeekGetMoreActorState<MergedPeekGetMoreActor> {
															#line 3743 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<MergedPeekGetMoreActor>::operator new;
	using FastAllocated<MergedPeekGetMoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6950303917476734464UL, 16050985414195627008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MergedPeekGetMoreActor, 0, Void >;
friend struct ActorCallback< MergedPeekGetMoreActor, 1, Void >;
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	MergedPeekGetMoreActor(ILogSystem::MergedPeekCursor* const& self,LogMessageVersion const& startVersion,TaskPriority const& taskID) 
															#line 3761 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   MergedPeekGetMoreActorState<MergedPeekGetMoreActor>(self, startVersion, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13055090458905274880UL, 13900509504588872960UL);
		ActorExecutionContextHelper __helper(static_cast<MergedPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mergedPeekGetMore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mergedPeekGetMore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MergedPeekGetMoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MergedPeekGetMoreActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> mergedPeekGetMore( ILogSystem::MergedPeekCursor* const& self, LogMessageVersion const& startVersion, TaskPriority const& taskID ) {
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new MergedPeekGetMoreActor(self, startVersion, taskID));
															#line 3795 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 785 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

Future<Void> ILogSystem::MergedPeekCursor::getMore(TaskPriority taskID) {
	if (more.isValid() && !more.isReady()) {
		return more;
	}

	if (!serverCursors.size())
		return Never();

	auto startVersion = version();
	calcHasMessage();
	if (hasMessage())
		return Void();
	if (nextVersion.present())
		advanceTo(nextVersion.get());
	ASSERT(!hasMessage());
	if (version() > startVersion)
		return Void();

	more = mergedPeekGetMore(this, startVersion, taskID);
	return more;
}

Future<Void> ILogSystem::MergedPeekCursor::onFailed() const {
	ASSERT(false);
	return Never();
}

bool ILogSystem::MergedPeekCursor::isActive() const {
	ASSERT(false);
	return false;
}

bool ILogSystem::MergedPeekCursor::isExhausted() const {
	return serverCursors[currentCursor]->isExhausted();
}

const LogMessageVersion& ILogSystem::MergedPeekCursor::version() const {
	return messageVersion;
}

Version ILogSystem::MergedPeekCursor::getMinKnownCommittedVersion() const {
	return serverCursors[currentCursor]->getMinKnownCommittedVersion();
}

Optional<UID> ILogSystem::MergedPeekCursor::getPrimaryPeekLocation() const {
	if (bestServer >= 0) {
		return serverCursors[bestServer]->getPrimaryPeekLocation();
	}
	return Optional<UID>();
}

Optional<UID> ILogSystem::MergedPeekCursor::getCurrentPeekLocation() const {
	if (currentCursor >= 0) {
		return serverCursors[currentCursor]->getPrimaryPeekLocation();
	}
	return Optional<UID>();
}

Version ILogSystem::MergedPeekCursor::popped() const {
	Version poppedVersion = 0;
	for (auto& c : serverCursors)
		poppedVersion = std::max(poppedVersion, c->popped());
	return poppedVersion;
}

ILogSystem::SetPeekCursor::SetPeekCursor(std::vector<Reference<LogSet>> const& logSets,
                                         int bestSet,
                                         int bestServer,
                                         Tag tag,
                                         Version begin,
                                         Version end,
                                         bool parallelGetMore)
  : logSets(logSets), tag(tag), bestSet(bestSet), bestServer(bestServer), currentSet(bestSet), currentCursor(0),
    messageVersion(begin), hasNextMessage(false), useBestSet(true), randomID(deterministicRandom()->randomUniqueID()) {
	serverCursors.resize(logSets.size());
	int maxServers = 0;
	for (int i = 0; i < logSets.size(); i++) {
		for (int j = 0; j < logSets[i]->logServers.size(); j++) {
			auto cursor = makeReference<ILogSystem::ServerPeekCursor>(
			    logSets[i]->logServers[j], tag, begin, end, true, parallelGetMore);
			serverCursors[i].push_back(cursor);
		}
		maxServers = std::max<int>(maxServers, serverCursors[i].size());
	}
	sortedVersions.resize(maxServers);
}

ILogSystem::SetPeekCursor::SetPeekCursor(std::vector<Reference<LogSet>> const& logSets,
                                         std::vector<std::vector<Reference<IPeekCursor>>> const& serverCursors,
                                         LogMessageVersion const& messageVersion,
                                         int bestSet,
                                         int bestServer,
                                         Optional<LogMessageVersion> nextVersion,
                                         bool useBestSet)
  : logSets(logSets), serverCursors(serverCursors), bestSet(bestSet), bestServer(bestServer), currentSet(bestSet),
    currentCursor(0), nextVersion(nextVersion), messageVersion(messageVersion), hasNextMessage(false),
    useBestSet(useBestSet), randomID(deterministicRandom()->randomUniqueID()) {
	int maxServers = 0;
	for (int i = 0; i < logSets.size(); i++) {
		maxServers = std::max<int>(maxServers, serverCursors[i].size());
	}
	sortedVersions.resize(maxServers);
	calcHasMessage();
}

Reference<ILogSystem::IPeekCursor> ILogSystem::SetPeekCursor::cloneNoMore() {
	std::vector<std::vector<Reference<ILogSystem::IPeekCursor>>> cursors;
	cursors.resize(logSets.size());
	for (int i = 0; i < logSets.size(); i++) {
		for (int j = 0; j < logSets[i]->logServers.size(); j++) {
			cursors[i].push_back(serverCursors[i][j]->cloneNoMore());
		}
	}
	return makeReference<ILogSystem::SetPeekCursor>(
	    logSets, cursors, messageVersion, bestSet, bestServer, nextVersion, useBestSet);
}

void ILogSystem::SetPeekCursor::setProtocolVersion(ProtocolVersion version) {
	for (auto& cursors : serverCursors) {
		for (auto& it : cursors) {
			if (it->hasMessage()) {
				it->setProtocolVersion(version);
			}
		}
	}
}

Arena& ILogSystem::SetPeekCursor::arena() {
	return serverCursors[currentSet][currentCursor]->arena();
}

ArenaReader* ILogSystem::SetPeekCursor::reader() {
	return serverCursors[currentSet][currentCursor]->reader();
}

void ILogSystem::SetPeekCursor::calcHasMessage() {
	if (bestSet >= 0 && bestServer >= 0) {
		if (nextVersion.present()) {
			//TraceEvent("LPC_CalcNext").detail("Ver", messageVersion.toString()).detail("Tag", tag.toString()).detail("HasNextMessage", hasNextMessage).detail("NextVersion", nextVersion.get().toString());
			serverCursors[bestSet][bestServer]->advanceTo(nextVersion.get());
		}
		if (serverCursors[bestSet][bestServer]->hasMessage()) {
			messageVersion = serverCursors[bestSet][bestServer]->version();
			currentSet = bestSet;
			currentCursor = bestServer;
			hasNextMessage = true;

			//TraceEvent("LPC_Calc1").detail("Ver", messageVersion.toString()).detail("Tag", tag.toString()).detail("HasNextMessage", hasNextMessage);

			for (auto& cursors : serverCursors) {
				for (auto& c : cursors) {
					c->advanceTo(messageVersion);
				}
			}

			return;
		}

		auto bestVersion = serverCursors[bestSet][bestServer]->version();
		for (auto& cursors : serverCursors) {
			for (auto& c : cursors) {
				c->advanceTo(bestVersion);
			}
		}
	}

	hasNextMessage = false;
	if (useBestSet) {
		updateMessage(bestSet, false); // Use Quorum logic

		//TraceEvent("LPC_Calc2").detail("Ver", messageVersion.toString()).detail("Tag", tag.toString()).detail("HasNextMessage", hasNextMessage);
		if (!hasNextMessage) {
			updateMessage(bestSet, true);
			//TraceEvent("LPC_Calc3").detail("Ver", messageVersion.toString()).detail("Tag", tag.toString()).detail("HasNextMessage", hasNextMessage);
		}
	} else {
		for (int i = 0; i < logSets.size() && !hasNextMessage; i++) {
			if (i != bestSet) {
				updateMessage(i, false); // Use Quorum logic
			}
		}
		//TraceEvent("LPC_Calc4").detail("Ver", messageVersion.toString()).detail("Tag", tag.toString()).detail("HasNextMessage", hasNextMessage);
		for (int i = 0; i < logSets.size() && !hasNextMessage; i++) {
			if (i != bestSet) {
				updateMessage(i, true);
			}
		}
		//TraceEvent("LPC_Calc5").detail("Ver", messageVersion.toString()).detail("Tag", tag.toString()).detail("HasNextMessage", hasNextMessage);
	}
}

void ILogSystem::SetPeekCursor::updateMessage(int logIdx, bool usePolicy) {
	loop {
		bool advancedPast = false;
		sortedVersions.clear();
		for (int i = 0; i < serverCursors[logIdx].size(); i++) {
			auto& serverCursor = serverCursors[logIdx][i];
			if (nextVersion.present())
				serverCursor->advanceTo(nextVersion.get());
			sortedVersions.push_back(std::pair<LogMessageVersion, int>(serverCursor->version(), i));
			//TraceEvent("LPC_Update1").detail("Ver", messageVersion.toString()).detail("Tag", tag.toString()).detail("HasNextMessage", hasNextMessage).detail("ServerVer", serverCursor->version().toString()).detail("I", i);
		}

		if (usePolicy) {
			std::sort(sortedVersions.begin(), sortedVersions.end());
			locations.clear();
			for (auto sortedVersion : sortedVersions) {
				locations.push_back(logSets[logIdx]->logEntryArray[sortedVersion.second]);
				if (locations.size() >= logSets[logIdx]->tLogReplicationFactor &&
				    logSets[logIdx]->satisfiesPolicy(locations)) {
					messageVersion = sortedVersion.first;
					break;
				}
			}
		} else {
			//(int)oldLogData[i].logServers.size() + 1 - oldLogData[i].tLogReplicationFactor
			std::nth_element(sortedVersions.begin(),
			                 sortedVersions.end() -
			                     (logSets[logIdx]->logServers.size() + 1 - logSets[logIdx]->tLogReplicationFactor),
			                 sortedVersions.end());
			messageVersion = sortedVersions[sortedVersions.size() - (logSets[logIdx]->logServers.size() + 1 -
			                                                         logSets[logIdx]->tLogReplicationFactor)]
			                     .first;
		}

		for (auto& cursors : serverCursors) {
			for (auto& c : cursors) {
				auto start = c->version();
				c->advanceTo(messageVersion);
				if (start <= messageVersion && messageVersion < c->version()) {
					advancedPast = true;
					CODE_PROBE(true, "Merge peek cursor with logIdx advanced past desired sequence");
				}
			}
		}

		if (!advancedPast)
			break;
	}

	for (int i = 0; i < serverCursors[logIdx].size(); i++) {
		auto& c = serverCursors[logIdx][i];
		ASSERT_WE_THINK(!c->hasMessage() ||
		                c->version() >= messageVersion); // Seems like the loop above makes this unconditionally true
		if (c->version() == messageVersion && c->hasMessage()) {
			hasNextMessage = true;
			currentSet = logIdx;
			currentCursor = i;
			break;
		}
	}
}

bool ILogSystem::SetPeekCursor::hasMessage() const {
	return hasNextMessage;
}

void ILogSystem::SetPeekCursor::nextMessage() {
	nextVersion = version();
	nextVersion.get().sub++;
	serverCursors[currentSet][currentCursor]->nextMessage();
	calcHasMessage();
	ASSERT(hasMessage() || !version().sub);
}

StringRef ILogSystem::SetPeekCursor::getMessage() {
	return serverCursors[currentSet][currentCursor]->getMessage();
}

StringRef ILogSystem::SetPeekCursor::getMessageWithTags() {
	return serverCursors[currentSet][currentCursor]->getMessageWithTags();
}

VectorRef<Tag> ILogSystem::SetPeekCursor::getTags() const {
	return serverCursors[currentSet][currentCursor]->getTags();
}

void ILogSystem::SetPeekCursor::advanceTo(LogMessageVersion n) {
	bool canChange = false;
	for (auto& cursors : serverCursors) {
		for (auto& c : cursors) {
			if (c->version() < n) {
				canChange = true;
				c->advanceTo(n);
			}
		}
	}
	if (canChange) {
		calcHasMessage();
	}
}

															#line 4092 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via setPeekGetMore()
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class SetPeekGetMoreActor>
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class SetPeekGetMoreActorState {
															#line 4099 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	SetPeekGetMoreActorState(ILogSystem::SetPeekCursor* const& self,LogMessageVersion const& startVersion,TaskPriority const& taskID) 
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   startVersion(startVersion),
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   taskID(taskID)
															#line 4110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("setPeekGetMore", reinterpret_cast<unsigned long>(this));

	}
	~SetPeekGetMoreActorState() 
	{
		fdb_probe_actor_destroy("setPeekGetMore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1081 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			;
															#line 4125 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetPeekGetMoreActorState();
		static_cast<SetPeekGetMoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1083 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->bestServer >= 0 && self->bestSet >= 0 && self->serverCursors[self->bestSet][self->bestServer]->isActive())
															#line 4155 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1085 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			ASSERT(!self->serverCursors[self->bestSet][self->bestServer]->hasMessage());
															#line 1087 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->serverCursors[self->bestSet][self->bestServer]->getMore(taskID) || self->serverCursors[self->bestSet][self->bestServer]->onFailed();
															#line 1087 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state = 1;
															#line 1087 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetPeekGetMoreActor, 0, Void >*>(static_cast<SetPeekGetMoreActor*>(this)));
															#line 4168 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1092 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			bool bestSetValid = self->bestSet >= 0;
															#line 1093 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (bestSetValid)
															#line 4177 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 1094 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->locations.clear();
															#line 1095 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				for(int i = 0;i < self->serverCursors[self->bestSet].size();i++) {
															#line 1096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (!self->serverCursors[self->bestSet][i]->isActive() && self->serverCursors[self->bestSet][i]->version() <= self->messageVersion)
															#line 4185 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					{
															#line 1098 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
						self->locations.push_back(self->logSets[self->bestSet]->logEntryArray[i]);
															#line 4189 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					}
				}
															#line 1101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				bestSetValid = self->locations.size() < self->logSets[self->bestSet]->tLogReplicationFactor || !self->logSets[self->bestSet]->satisfiesPolicy(self->locations);
															#line 4194 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
															#line 1104 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (bestSetValid || self->logSets.size() == 1)
															#line 4198 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 1105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (!self->useBestSet)
															#line 4202 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 1106 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->useBestSet = true;
															#line 1107 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->calcHasMessage();
															#line 1108 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (self->hasMessage() || self->version() > startVersion)
															#line 4210 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					{
															#line 1109 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
						if (!static_cast<SetPeekGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetPeekGetMoreActorState(); static_cast<SetPeekGetMoreActor*>(this)->destroy(); return 0; }
															#line 4214 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
						new (&static_cast<SetPeekGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
						this->~SetPeekGetMoreActorState();
						static_cast<SetPeekGetMoreActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 1113 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				std::vector<Future<Void>> q;
															#line 1114 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				for( auto& c : self->serverCursors[self->bestSet] ) {
															#line 1115 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					if (!c->hasMessage())
															#line 4227 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
					{
															#line 1116 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
						q.push_back(c->getMore(taskID));
															#line 1117 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
						if (c->isActive())
															#line 4233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
						{
															#line 1118 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
							q.push_back(c->onFailed());
															#line 4237 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
						}
					}
				}
															#line 1122 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				StrictFuture<Void> __when_expr_1 = quorum(q, 1);
															#line 1122 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4245 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state = 2;
															#line 1122 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetPeekGetMoreActor, 1, Void >*>(static_cast<SetPeekGetMoreActor*>(this)));
															#line 4250 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1126 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				std::vector<Future<Void>> q;
															#line 1128 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				for( auto& cursors : self->serverCursors ) {
															#line 1129 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					for( auto& c : cursors ) {
															#line 1130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
						if (!c->hasMessage())
															#line 4263 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
						{
															#line 1131 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
							q.push_back(c->getMore(taskID));
															#line 4267 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
						}
					}
				}
															#line 1135 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				StrictFuture<Void> __when_expr_2 = quorum(q, 1);
															#line 1135 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4275 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
				static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state = 3;
															#line 1135 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetPeekGetMoreActor, 2, Void >*>(static_cast<SetPeekGetMoreActor*>(this)));
															#line 4280 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				loopDepth = 0;
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1139 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->calcHasMessage();
															#line 1141 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->hasMessage() || self->version() > startVersion)
															#line 4293 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1142 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!static_cast<SetPeekGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetPeekGetMoreActorState(); static_cast<SetPeekGetMoreActor*>(this)->destroy(); return 0; }
															#line 4297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			new (&static_cast<SetPeekGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SetPeekGetMoreActorState();
			static_cast<SetPeekGetMoreActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->useBestSet = true;
															#line 4311 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->useBestSet = true;
															#line 4320 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state > 0) static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<SetPeekGetMoreActor*>(this)->ActorCallback< SetPeekGetMoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetPeekGetMoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetPeekGetMoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetPeekGetMoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state > 0) static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<SetPeekGetMoreActor*>(this)->ActorCallback< SetPeekGetMoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetPeekGetMoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetPeekGetMoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetPeekGetMoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 1136 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->useBestSet = false;
															#line 4497 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 1136 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->useBestSet = false;
															#line 4506 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state > 0) static_cast<SetPeekGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<SetPeekGetMoreActor*>(this)->ActorCallback< SetPeekGetMoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetPeekGetMoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetPeekGetMoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetPeekGetMoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::SetPeekCursor* self;
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	LogMessageVersion startVersion;
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TaskPriority taskID;
															#line 4592 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via setPeekGetMore()
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class SetPeekGetMoreActor final : public Actor<Void>, public ActorCallback< SetPeekGetMoreActor, 0, Void >, public ActorCallback< SetPeekGetMoreActor, 1, Void >, public ActorCallback< SetPeekGetMoreActor, 2, Void >, public FastAllocated<SetPeekGetMoreActor>, public SetPeekGetMoreActorState<SetPeekGetMoreActor> {
															#line 4597 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<SetPeekGetMoreActor>::operator new;
	using FastAllocated<SetPeekGetMoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17745301366013955072UL, 16007135086436460288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetPeekGetMoreActor, 0, Void >;
friend struct ActorCallback< SetPeekGetMoreActor, 1, Void >;
friend struct ActorCallback< SetPeekGetMoreActor, 2, Void >;
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	SetPeekGetMoreActor(ILogSystem::SetPeekCursor* const& self,LogMessageVersion const& startVersion,TaskPriority const& taskID) 
															#line 4616 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   SetPeekGetMoreActorState<SetPeekGetMoreActor>(self, startVersion, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setPeekGetMore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14828228830539680512UL, 11228975627246258432UL);
		ActorExecutionContextHelper __helper(static_cast<SetPeekGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setPeekGetMore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setPeekGetMore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetPeekGetMoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetPeekGetMoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetPeekGetMoreActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> setPeekGetMore( ILogSystem::SetPeekCursor* const& self, LogMessageVersion const& startVersion, TaskPriority const& taskID ) {
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new SetPeekGetMoreActor(self, startVersion, taskID));
															#line 4651 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 1145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

Future<Void> ILogSystem::SetPeekCursor::getMore(TaskPriority taskID) {
	if (more.isValid() && !more.isReady()) {
		return more;
	}

	auto startVersion = version();
	calcHasMessage();
	if (hasMessage())
		return Void();
	if (nextVersion.present())
		advanceTo(nextVersion.get());
	ASSERT(!hasMessage());
	if (version() > startVersion)
		return Void();

	more = setPeekGetMore(this, startVersion, taskID);
	return more;
}

Future<Void> ILogSystem::SetPeekCursor::onFailed() const {
	ASSERT(false);
	return Never();
}

bool ILogSystem::SetPeekCursor::isActive() const {
	ASSERT(false);
	return false;
}

bool ILogSystem::SetPeekCursor::isExhausted() const {
	return serverCursors[currentSet][currentCursor]->isExhausted();
}

const LogMessageVersion& ILogSystem::SetPeekCursor::version() const {
	return messageVersion;
}

Version ILogSystem::SetPeekCursor::getMinKnownCommittedVersion() const {
	return serverCursors[currentSet][currentCursor]->getMinKnownCommittedVersion();
}

Optional<UID> ILogSystem::SetPeekCursor::getPrimaryPeekLocation() const {
	if (bestServer >= 0 && bestSet >= 0) {
		return serverCursors[bestSet][bestServer]->getPrimaryPeekLocation();
	}
	return Optional<UID>();
}

Optional<UID> ILogSystem::SetPeekCursor::getCurrentPeekLocation() const {
	if (currentCursor >= 0 && currentSet >= 0) {
		return serverCursors[currentSet][currentCursor]->getPrimaryPeekLocation();
	}
	return Optional<UID>();
}

Version ILogSystem::SetPeekCursor::popped() const {
	Version poppedVersion = 0;
	for (auto& cursors : serverCursors) {
		for (auto& c : cursors) {
			poppedVersion = std::max(poppedVersion, c->popped());
		}
	}
	return poppedVersion;
}

ILogSystem::MultiCursor::MultiCursor(std::vector<Reference<IPeekCursor>> cursors,
                                     std::vector<LogMessageVersion> epochEnds)
  : cursors(cursors), epochEnds(epochEnds), poppedVersion(0) {
	for (int i = 0; i < std::min<int>(cursors.size(), SERVER_KNOBS->MULTI_CURSOR_PRE_FETCH_LIMIT); i++) {
		cursors[cursors.size() - i - 1]->getMore();
	}
}

Reference<ILogSystem::IPeekCursor> ILogSystem::MultiCursor::cloneNoMore() {
	return cursors.back()->cloneNoMore();
}

void ILogSystem::MultiCursor::setProtocolVersion(ProtocolVersion version) {
	cursors.back()->setProtocolVersion(version);
}

Arena& ILogSystem::MultiCursor::arena() {
	return cursors.back()->arena();
}

ArenaReader* ILogSystem::MultiCursor::reader() {
	return cursors.back()->reader();
}

bool ILogSystem::MultiCursor::hasMessage() const {
	return cursors.back()->hasMessage();
}

void ILogSystem::MultiCursor::nextMessage() {
	cursors.back()->nextMessage();
}

StringRef ILogSystem::MultiCursor::getMessage() {
	return cursors.back()->getMessage();
}

StringRef ILogSystem::MultiCursor::getMessageWithTags() {
	return cursors.back()->getMessageWithTags();
}

VectorRef<Tag> ILogSystem::MultiCursor::getTags() const {
	return cursors.back()->getTags();
}

void ILogSystem::MultiCursor::advanceTo(LogMessageVersion n) {
	while (cursors.size() > 1 && n >= epochEnds.back()) {
		poppedVersion = std::max(poppedVersion, cursors.back()->popped());
		cursors.pop_back();
		epochEnds.pop_back();
	}
	cursors.back()->advanceTo(n);
}

Future<Void> ILogSystem::MultiCursor::getMore(TaskPriority taskID) {
	LogMessageVersion startVersion = cursors.back()->version();
	while (cursors.size() > 1 && cursors.back()->version() >= epochEnds.back()) {
		poppedVersion = std::max(poppedVersion, cursors.back()->popped());
		cursors.pop_back();
		epochEnds.pop_back();
	}
	if (cursors.back()->version() > startVersion) {
		return Void();
	}
	return cursors.back()->getMore(taskID);
}

Future<Void> ILogSystem::MultiCursor::onFailed() const {
	return cursors.back()->onFailed();
}

bool ILogSystem::MultiCursor::isActive() const {
	return cursors.back()->isActive();
}

bool ILogSystem::MultiCursor::isExhausted() const {
	return cursors.back()->isExhausted();
}

const LogMessageVersion& ILogSystem::MultiCursor::version() const {
	return cursors.back()->version();
}

Version ILogSystem::MultiCursor::getMinKnownCommittedVersion() const {
	return cursors.back()->getMinKnownCommittedVersion();
}

Optional<UID> ILogSystem::MultiCursor::getPrimaryPeekLocation() const {
	return cursors.back()->getPrimaryPeekLocation();
}

Optional<UID> ILogSystem::MultiCursor::getCurrentPeekLocation() const {
	return cursors.back()->getCurrentPeekLocation();
}

Version ILogSystem::MultiCursor::popped() const {
	return std::max(poppedVersion, cursors.back()->popped());
}

ILogSystem::BufferedCursor::BufferedCursor(std::vector<Reference<IPeekCursor>> cursors,
                                           Version begin,
                                           Version end,
                                           bool withTags,
                                           bool canDiscardPopped)
  : cursors(cursors), messageIndex(0), messageVersion(begin), end(end), hasNextMessage(false), withTags(withTags),
    knownUnique(false), minKnownCommittedVersion(0), poppedVersion(0), initialPoppedVersion(0),
    canDiscardPopped(canDiscardPopped), randomID(deterministicRandom()->randomUniqueID()) {
	targetQueueSize = SERVER_KNOBS->DESIRED_OUTSTANDING_MESSAGES / cursors.size();
	messages.reserve(SERVER_KNOBS->DESIRED_OUTSTANDING_MESSAGES);
	cursorMessages.resize(cursors.size());
}

ILogSystem::BufferedCursor::BufferedCursor(
    std::vector<Reference<AsyncVar<OptionalInterface<TLogInterface>>>> const& logServers,
    Tag tag,
    Version begin,
    Version end,
    bool parallelGetMore)
  : messageIndex(0), messageVersion(begin), end(end), hasNextMessage(false), withTags(true), knownUnique(true),
    minKnownCommittedVersion(0), poppedVersion(0), initialPoppedVersion(0), canDiscardPopped(false),
    randomID(deterministicRandom()->randomUniqueID()) {
	targetQueueSize = SERVER_KNOBS->DESIRED_OUTSTANDING_MESSAGES / logServers.size();
	messages.reserve(SERVER_KNOBS->DESIRED_OUTSTANDING_MESSAGES);
	cursorMessages.resize(logServers.size());
	for (int i = 0; i < logServers.size(); i++) {
		auto cursor =
		    makeReference<ILogSystem::ServerPeekCursor>(logServers[i], tag, begin, end, false, parallelGetMore);
		cursors.push_back(cursor);
	}
}

Reference<ILogSystem::IPeekCursor> ILogSystem::BufferedCursor::cloneNoMore() {
	ASSERT(false);
	return Reference<ILogSystem::IPeekCursor>();
}

void ILogSystem::BufferedCursor::setProtocolVersion(ProtocolVersion version) {
	for (auto& c : cursors) {
		c->setProtocolVersion(version);
	}
}

Arena& ILogSystem::BufferedCursor::arena() {
	return messages[messageIndex].arena;
}

ArenaReader* ILogSystem::BufferedCursor::reader() {
	ASSERT(false);
	return cursors[0]->reader();
}

bool ILogSystem::BufferedCursor::hasMessage() const {
	return hasNextMessage;
}

void ILogSystem::BufferedCursor::nextMessage() {
	messageIndex++;
	if (messageIndex == messages.size()) {
		hasNextMessage = false;
	}
}

StringRef ILogSystem::BufferedCursor::getMessage() {
	ASSERT(!withTags);
	return messages[messageIndex].message;
}

StringRef ILogSystem::BufferedCursor::getMessageWithTags() {
	ASSERT(withTags);
	return messages[messageIndex].message;
}

VectorRef<Tag> ILogSystem::BufferedCursor::getTags() const {
	ASSERT(withTags);
	return messages[messageIndex].tags;
}

void ILogSystem::BufferedCursor::advanceTo(LogMessageVersion n) {
	ASSERT(false);
}

															#line 4901 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via bufferedGetMoreLoader()
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class BufferedGetMoreLoaderActor>
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class BufferedGetMoreLoaderActorState {
															#line 4908 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	BufferedGetMoreLoaderActorState(ILogSystem::BufferedCursor* const& self,Reference<ILogSystem::IPeekCursor> const& cursor,int const& idx,TaskPriority const& taskID) 
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   cursor(cursor),
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   idx(idx),
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   taskID(taskID)
															#line 4921 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this));

	}
	~BufferedGetMoreLoaderActorState() 
	{
		fdb_probe_actor_destroy("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1395 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			;
															#line 4936 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BufferedGetMoreLoaderActorState();
		static_cast<BufferedGetMoreLoaderActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1396 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1396 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4968 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state = 1;
															#line 1396 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreLoaderActor, 0, Void >*>(static_cast<BufferedGetMoreLoaderActor*>(this)));
															#line 4973 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1397 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (cursor->version().version >= self->end || self->cursorMessages[idx].size() > self->targetQueueSize)
															#line 4982 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1398 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!static_cast<BufferedGetMoreLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BufferedGetMoreLoaderActorState(); static_cast<BufferedGetMoreLoaderActor*>(this)->destroy(); return 0; }
															#line 4986 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			new (&static_cast<BufferedGetMoreLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BufferedGetMoreLoaderActorState();
			static_cast<BufferedGetMoreLoaderActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1400 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cursor->getMore(taskID);
															#line 1400 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4996 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state = 2;
															#line 1400 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreLoaderActor, 1, Void >*>(static_cast<BufferedGetMoreLoaderActor*>(this)));
															#line 5001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1397 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (cursor->version().version >= self->end || self->cursorMessages[idx].size() > self->targetQueueSize)
															#line 5010 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1398 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!static_cast<BufferedGetMoreLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BufferedGetMoreLoaderActorState(); static_cast<BufferedGetMoreLoaderActor*>(this)->destroy(); return 0; }
															#line 5014 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			new (&static_cast<BufferedGetMoreLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BufferedGetMoreLoaderActorState();
			static_cast<BufferedGetMoreLoaderActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1400 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cursor->getMore(taskID);
															#line 1400 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5024 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state = 2;
															#line 1400 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreLoaderActor, 1, Void >*>(static_cast<BufferedGetMoreLoaderActor*>(this)));
															#line 5029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state > 0) static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<BufferedGetMoreLoaderActor*>(this)->ActorCallback< BufferedGetMoreLoaderActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreLoaderActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreLoaderActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BufferedGetMoreLoaderActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1401 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->poppedVersion = std::max(self->poppedVersion, cursor->popped());
															#line 1402 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->minKnownCommittedVersion = std::max(self->minKnownCommittedVersion, cursor->getMinKnownCommittedVersion());
															#line 1404 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->canDiscardPopped)
															#line 5117 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1405 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->initialPoppedVersion = std::max(self->initialPoppedVersion, cursor->popped());
															#line 5121 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1407 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (cursor->version().version >= self->end)
															#line 5125 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1408 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!static_cast<BufferedGetMoreLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BufferedGetMoreLoaderActorState(); static_cast<BufferedGetMoreLoaderActor*>(this)->destroy(); return 0; }
															#line 5129 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			new (&static_cast<BufferedGetMoreLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BufferedGetMoreLoaderActorState();
			static_cast<BufferedGetMoreLoaderActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1410 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		for(;cursor->hasMessage();) {
															#line 1411 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->cursorMessages[idx].push_back(ILogSystem::BufferedCursor::BufferedMessage( cursor->arena(), !self->withTags ? cursor->getMessage() : cursor->getMessageWithTags(), !self->withTags ? VectorRef<Tag>() : cursor->getTags(), cursor->version()));
															#line 1416 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			cursor->nextMessage();
															#line 5141 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1401 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->poppedVersion = std::max(self->poppedVersion, cursor->popped());
															#line 1402 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->minKnownCommittedVersion = std::max(self->minKnownCommittedVersion, cursor->getMinKnownCommittedVersion());
															#line 1404 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->canDiscardPopped)
															#line 5155 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1405 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->initialPoppedVersion = std::max(self->initialPoppedVersion, cursor->popped());
															#line 5159 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1407 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (cursor->version().version >= self->end)
															#line 5163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1408 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (!static_cast<BufferedGetMoreLoaderActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BufferedGetMoreLoaderActorState(); static_cast<BufferedGetMoreLoaderActor*>(this)->destroy(); return 0; }
															#line 5167 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			new (&static_cast<BufferedGetMoreLoaderActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BufferedGetMoreLoaderActorState();
			static_cast<BufferedGetMoreLoaderActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1410 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		for(;cursor->hasMessage();) {
															#line 1411 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->cursorMessages[idx].push_back(ILogSystem::BufferedCursor::BufferedMessage( cursor->arena(), !self->withTags ? cursor->getMessage() : cursor->getMessageWithTags(), !self->withTags ? VectorRef<Tag>() : cursor->getTags(), cursor->version()));
															#line 1416 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			cursor->nextMessage();
															#line 5179 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state > 0) static_cast<BufferedGetMoreLoaderActor*>(this)->actor_wait_state = 0;
		static_cast<BufferedGetMoreLoaderActor*>(this)->ActorCallback< BufferedGetMoreLoaderActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreLoaderActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreLoaderActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BufferedGetMoreLoaderActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::BufferedCursor* self;
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	Reference<ILogSystem::IPeekCursor> cursor;
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	int idx;
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TaskPriority taskID;
															#line 5268 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via bufferedGetMoreLoader()
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class BufferedGetMoreLoaderActor final : public Actor<Void>, public ActorCallback< BufferedGetMoreLoaderActor, 0, Void >, public ActorCallback< BufferedGetMoreLoaderActor, 1, Void >, public FastAllocated<BufferedGetMoreLoaderActor>, public BufferedGetMoreLoaderActorState<BufferedGetMoreLoaderActor> {
															#line 5273 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<BufferedGetMoreLoaderActor>::operator new;
	using FastAllocated<BufferedGetMoreLoaderActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(491378555384678912UL, 10821310284378813440UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BufferedGetMoreLoaderActor, 0, Void >;
friend struct ActorCallback< BufferedGetMoreLoaderActor, 1, Void >;
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	BufferedGetMoreLoaderActor(ILogSystem::BufferedCursor* const& self,Reference<ILogSystem::IPeekCursor> const& cursor,int const& idx,TaskPriority const& taskID) 
															#line 5291 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   BufferedGetMoreLoaderActorState<BufferedGetMoreLoaderActor>(self, cursor, idx, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11246066823965918976UL, 3870226826348662528UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreLoaderActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bufferedGetMoreLoader");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bufferedGetMoreLoader", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BufferedGetMoreLoaderActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BufferedGetMoreLoaderActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> bufferedGetMoreLoader( ILogSystem::BufferedCursor* const& self, Reference<ILogSystem::IPeekCursor> const& cursor, int const& idx, TaskPriority const& taskID ) {
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new BufferedGetMoreLoaderActor(self, cursor, idx, taskID));
															#line 5325 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 1420 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

															#line 5330 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
namespace {
// This generated class is to be used only via bufferedGetMore()
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
template <class BufferedGetMoreActor>
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class BufferedGetMoreActorState {
															#line 5337 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	BufferedGetMoreActorState(ILogSystem::BufferedCursor* const& self,TaskPriority const& taskID) 
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		 : self(self),
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		   taskID(taskID)
															#line 5346 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
	{
		fdb_probe_actor_create("bufferedGetMore", reinterpret_cast<unsigned long>(this));

	}
	~BufferedGetMoreActorState() 
	{
		fdb_probe_actor_destroy("bufferedGetMore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1422 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (self->messageVersion.version >= self->end)
															#line 5361 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 1423 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 1423 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5367 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 1;
															#line 1423 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreActor, 0, Void >*>(static_cast<BufferedGetMoreActor*>(this)));
															#line 5372 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BufferedGetMoreActorState();
		static_cast<BufferedGetMoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1427 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->messages.clear();
															#line 1429 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		std::vector<Future<Void>> loaders;
															#line 1430 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		loaders.reserve(self->cursors.size());
															#line 1432 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		for(int i = 0;i < self->cursors.size();i++) {
															#line 1433 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			loaders.push_back(bufferedGetMoreLoader(self, self->cursors[i], i, taskID));
															#line 5408 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1436 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		allLoaders = waitForAll(loaders);
															#line 1437 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		minVersion = Version();
															#line 1438 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		;
															#line 5416 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1424 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 5425 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1424 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 5433 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state > 0) static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<BufferedGetMoreActor*>(this)->ActorCallback< BufferedGetMoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BufferedGetMoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1460 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_3 = yield();
															#line 1460 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5518 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 4;
															#line 1460 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreActor, 3, Void >*>(static_cast<BufferedGetMoreActor*>(this)));
															#line 5523 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_1 = allLoaders || delay(SERVER_KNOBS->DESIRED_GET_MORE_DELAY, taskID);
															#line 1439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5541 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 2;
															#line 1439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreActor, 1, Void >*>(static_cast<BufferedGetMoreActor*>(this)));
															#line 5546 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		minVersion = self->end;
															#line 1441 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		for(int i = 0;i < self->cursors.size();i++) {
															#line 1442 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			auto cursor = self->cursors[i];
															#line 1443 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			for(;cursor->hasMessage();) {
															#line 1444 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->cursorMessages[i].push_back(ILogSystem::BufferedCursor::BufferedMessage( cursor->arena(), !self->withTags ? cursor->getMessage() : cursor->getMessageWithTags(), !self->withTags ? VectorRef<Tag>() : cursor->getTags(), cursor->version()));
															#line 1449 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				cursor->nextMessage();
															#line 5578 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
															#line 1451 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			minVersion = std::min(minVersion, cursor->version().version);
															#line 5582 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1453 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (minVersion > self->messageVersion.version)
															#line 5586 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1456 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (allLoaders.isReady())
															#line 5592 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 1457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5598 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 3;
															#line 1457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreActor, 2, Void >*>(static_cast<BufferedGetMoreActor*>(this)));
															#line 5603 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		minVersion = self->end;
															#line 1441 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		for(int i = 0;i < self->cursors.size();i++) {
															#line 1442 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			auto cursor = self->cursors[i];
															#line 1443 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			for(;cursor->hasMessage();) {
															#line 1444 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->cursorMessages[i].push_back(ILogSystem::BufferedCursor::BufferedMessage( cursor->arena(), !self->withTags ? cursor->getMessage() : cursor->getMessageWithTags(), !self->withTags ? VectorRef<Tag>() : cursor->getTags(), cursor->version()));
															#line 1449 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				cursor->nextMessage();
															#line 5627 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
															#line 1451 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			minVersion = std::min(minVersion, cursor->version().version);
															#line 5631 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1453 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (minVersion > self->messageVersion.version)
															#line 5635 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1456 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (allLoaders.isReady())
															#line 5641 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 1457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 3;
															#line 1457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreActor, 2, Void >*>(static_cast<BufferedGetMoreActor*>(this)));
															#line 5652 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state > 0) static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<BufferedGetMoreActor*>(this)->ActorCallback< BufferedGetMoreActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BufferedGetMoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state > 0) static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<BufferedGetMoreActor*>(this)->ActorCallback< BufferedGetMoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BufferedGetMoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1462 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		for( auto& it : self->cursorMessages ) {
															#line 1463 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			for(;!it.empty() && it.front().version.version < minVersion;) {
															#line 1464 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->messages.push_back(it.front());
															#line 1465 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				it.pop_front();
															#line 5840 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
		}
															#line 1468 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->knownUnique)
															#line 5845 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1469 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			std::sort(self->messages.begin(), self->messages.end());
															#line 5849 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
		else
		{
															#line 1471 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			uniquify(self->messages);
															#line 5855 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1474 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->messageVersion = LogMessageVersion(minVersion);
															#line 1475 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->messageIndex = 0;
															#line 1476 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->hasNextMessage = self->messages.size() > 0;
															#line 1478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_4 = yield();
															#line 1478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5867 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 5;
															#line 1478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreActor, 4, Void >*>(static_cast<BufferedGetMoreActor*>(this)));
															#line 5872 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1462 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		for( auto& it : self->cursorMessages ) {
															#line 1463 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			for(;!it.empty() && it.front().version.version < minVersion;) {
															#line 1464 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->messages.push_back(it.front());
															#line 1465 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				it.pop_front();
															#line 5887 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
		}
															#line 1468 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->knownUnique)
															#line 5892 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1469 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			std::sort(self->messages.begin(), self->messages.end());
															#line 5896 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
		else
		{
															#line 1471 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			uniquify(self->messages);
															#line 5902 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1474 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->messageVersion = LogMessageVersion(minVersion);
															#line 1475 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->messageIndex = 0;
															#line 1476 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		self->hasNextMessage = self->messages.size() > 0;
															#line 1478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		StrictFuture<Void> __when_expr_4 = yield();
															#line 1478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5914 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 5;
															#line 1478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BufferedGetMoreActor, 4, Void >*>(static_cast<BufferedGetMoreActor*>(this)));
															#line 5919 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state > 0) static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<BufferedGetMoreActor*>(this)->ActorCallback< BufferedGetMoreActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BufferedGetMoreActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 1479 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->canDiscardPopped && self->poppedVersion > self->version().version)
															#line 6003 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1480 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			TraceEvent(SevWarn, "DiscardingPoppedData", self->randomID) .detail("Version", self->version().version) .detail("Popped", self->poppedVersion);
															#line 1483 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->messageVersion = std::max(self->messageVersion, LogMessageVersion(self->poppedVersion));
															#line 1484 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			for( auto cursor : self->cursors ) {
															#line 1485 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				cursor->advanceTo(self->messageVersion);
															#line 6013 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
															#line 1487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->messageIndex = self->messages.size();
															#line 1488 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (self->messages.size() > 0 && self->messages[self->messages.size() - 1].version.version < self->poppedVersion)
															#line 6019 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 1490 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->hasNextMessage = false;
															#line 6023 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
			else
			{
															#line 1492 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				auto iter = std::lower_bound(self->messages.begin(), self->messages.end(), ILogSystem::BufferedCursor::BufferedMessage(self->poppedVersion));
															#line 1495 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->hasNextMessage = iter != self->messages.end();
															#line 1496 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (self->hasNextMessage)
															#line 6033 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 1497 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->messageIndex = iter - self->messages.begin();
															#line 6037 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
			}
		}
															#line 1501 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->hasNextMessage)
															#line 6043 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->canDiscardPopped = false;
															#line 6047 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1504 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<BufferedGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BufferedGetMoreActorState(); static_cast<BufferedGetMoreActor*>(this)->destroy(); return 0; }
															#line 6051 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<BufferedGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BufferedGetMoreActorState();
		static_cast<BufferedGetMoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 1479 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->canDiscardPopped && self->poppedVersion > self->version().version)
															#line 6063 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1480 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			TraceEvent(SevWarn, "DiscardingPoppedData", self->randomID) .detail("Version", self->version().version) .detail("Popped", self->poppedVersion);
															#line 1483 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->messageVersion = std::max(self->messageVersion, LogMessageVersion(self->poppedVersion));
															#line 1484 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			for( auto cursor : self->cursors ) {
															#line 1485 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				cursor->advanceTo(self->messageVersion);
															#line 6073 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
															#line 1487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->messageIndex = self->messages.size();
															#line 1488 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			if (self->messages.size() > 0 && self->messages[self->messages.size() - 1].version.version < self->poppedVersion)
															#line 6079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			{
															#line 1490 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->hasNextMessage = false;
															#line 6083 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
			}
			else
			{
															#line 1492 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				auto iter = std::lower_bound(self->messages.begin(), self->messages.end(), ILogSystem::BufferedCursor::BufferedMessage(self->poppedVersion));
															#line 1495 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				self->hasNextMessage = iter != self->messages.end();
															#line 1496 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
				if (self->hasNextMessage)
															#line 6093 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				{
															#line 1497 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
					self->messageIndex = iter - self->messages.begin();
															#line 6097 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
				}
			}
		}
															#line 1501 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (self->hasNextMessage)
															#line 6103 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		{
															#line 1502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
			self->canDiscardPopped = false;
															#line 6107 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		}
															#line 1504 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
		if (!static_cast<BufferedGetMoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BufferedGetMoreActorState(); static_cast<BufferedGetMoreActor*>(this)->destroy(); return 0; }
															#line 6111 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		new (&static_cast<BufferedGetMoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BufferedGetMoreActorState();
		static_cast<BufferedGetMoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BufferedGetMoreActor*>(this)->actor_wait_state > 0) static_cast<BufferedGetMoreActor*>(this)->actor_wait_state = 0;
		static_cast<BufferedGetMoreActor*>(this)->ActorCallback< BufferedGetMoreActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BufferedGetMoreActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BufferedGetMoreActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	ILogSystem::BufferedCursor* self;
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	TaskPriority taskID;
															#line 1436 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	Future<Void> allLoaders;
															#line 1437 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	Version minVersion;
															#line 6202 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
};
// This generated class is to be used only via bufferedGetMore()
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
class BufferedGetMoreActor final : public Actor<Void>, public ActorCallback< BufferedGetMoreActor, 0, Void >, public ActorCallback< BufferedGetMoreActor, 1, Void >, public ActorCallback< BufferedGetMoreActor, 2, Void >, public ActorCallback< BufferedGetMoreActor, 3, Void >, public ActorCallback< BufferedGetMoreActor, 4, Void >, public FastAllocated<BufferedGetMoreActor>, public BufferedGetMoreActorState<BufferedGetMoreActor> {
															#line 6207 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
public:
	using FastAllocated<BufferedGetMoreActor>::operator new;
	using FastAllocated<BufferedGetMoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12493892588520534528UL, 5585028218776807680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BufferedGetMoreActor, 0, Void >;
friend struct ActorCallback< BufferedGetMoreActor, 1, Void >;
friend struct ActorCallback< BufferedGetMoreActor, 2, Void >;
friend struct ActorCallback< BufferedGetMoreActor, 3, Void >;
friend struct ActorCallback< BufferedGetMoreActor, 4, Void >;
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	BufferedGetMoreActor(ILogSystem::BufferedCursor* const& self,TaskPriority const& taskID) 
															#line 6228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
		 : Actor<Void>(),
		   BufferedGetMoreActorState<BufferedGetMoreActor>(self, taskID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bufferedGetMore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11347473108718297600UL, 1890116336899146752UL);
		ActorExecutionContextHelper __helper(static_cast<BufferedGetMoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bufferedGetMore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bufferedGetMore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BufferedGetMoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BufferedGetMoreActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BufferedGetMoreActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BufferedGetMoreActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BufferedGetMoreActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
[[nodiscard]] Future<Void> bufferedGetMore( ILogSystem::BufferedCursor* const& self, TaskPriority const& taskID ) {
															#line 1421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"
	return Future<Void>(new BufferedGetMoreActor(self, taskID));
															#line 6265 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbserver/LogSystemPeekCursor.actor.g.cpp"
}

#line 1506 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbserver/LogSystemPeekCursor.actor.cpp"

Future<Void> ILogSystem::BufferedCursor::getMore(TaskPriority taskID) {
	if (hasMessage()) {
		return Void();
	}

	if (!more.isValid() || more.isReady()) {
		more = bufferedGetMore(this, taskID);
	}
	return more;
}

Future<Void> ILogSystem::BufferedCursor::onFailed() const {
	ASSERT(false);
	return Never();
}

bool ILogSystem::BufferedCursor::isActive() const {
	ASSERT(false);
	return false;
}

bool ILogSystem::BufferedCursor::isExhausted() const {
	ASSERT(false);
	return false;
}

const LogMessageVersion& ILogSystem::BufferedCursor::version() const {
	if (hasNextMessage) {
		return messages[messageIndex].version;
	}
	return messageVersion;
}

Version ILogSystem::BufferedCursor::getMinKnownCommittedVersion() const {
	return minKnownCommittedVersion;
}

Optional<UID> ILogSystem::BufferedCursor::getPrimaryPeekLocation() const {
	return Optional<UID>();
}

Optional<UID> ILogSystem::BufferedCursor::getCurrentPeekLocation() const {
	return Optional<UID>();
}

Version ILogSystem::BufferedCursor::popped() const {
	if (initialPoppedVersion == poppedVersion) {
		return 0;
	}
	return poppedVersion;
}
