#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
/*
 * LoadBalance.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(FLOW_LOADBALANCE_ACTOR_G_H)
#define FLOW_LOADBALANCE_ACTOR_G_H
#include "fdbrpc/LoadBalance.actor.g.h"
#elif !defined(FLOW_LOADBALANCE_ACTOR_H)
#define FLOW_LOADBALANCE_ACTOR_H

#include "flow/BooleanParam.h"
#include "flow/flow.h"
#include "flow/Error.h"
#include "flow/Knobs.h"

#include "fdbrpc/FailureMonitor.h"
#include "fdbrpc/fdbrpc.h"
#include "fdbrpc/Locality.h"
#include "fdbrpc/QueueModel.h"
#include "fdbrpc/MultiInterface.h"
#include "fdbrpc/simulator.h" // for checking tss simulation mode
#include "fdbrpc/TSSComparison.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 47 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
[[nodiscard]] Future<Void> allAlternativesFailedDelay( Future<Void> const& okFuture );

#line 46 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

enum ComparisonType { TSS_COMPARISON, REPLICA_COMPARISON };

enum RequiredReplicas { BEST_EFFORT = -2, ALL_REPLICAS = -1 };

struct ModelHolder : NonCopyable, public ReferenceCounted<ModelHolder> {
	QueueModel* model;
	bool released;
	double startTime;
	double delta;
	uint64_t token;

	ModelHolder(QueueModel* model, uint64_t token) : model(model), released(false), startTime(now()), token(token) {
		if (model) {
			delta = model->addRequest(token);
		}
	}

	void release(bool clean, bool futureVersion, double penalty, bool measureLatency = true) {
		if (model && !released) {
			released = true;
			double latency = (clean || measureLatency) ? now() - startTime : 0.0;
			model->endRequest(token, latency, penalty, delta, clean, futureVersion);
		}
	}

	~ModelHolder() { release(false, false, -1.0, false); }
};

// Subclasses must initialize all members in their default constructors
// Subclasses must serialize all members
struct LoadBalancedReply {
	double penalty;
	Optional<Error> error;
	LoadBalancedReply() : penalty(1.0) {}
};

Optional<LoadBalancedReply> getLoadBalancedReply(const LoadBalancedReply* reply);
Optional<LoadBalancedReply> getLoadBalancedReply(const void*);

															#line 91 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via tssComparison()
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P, class TssComparisonActor>
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class TssComparisonActorState {
															#line 98 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TssComparisonActorState(Req const& req,Future<ErrorOr<Resp>> const& fSource,Future<ErrorOr<Resp>> const& fTss,TSSEndpointData const& tssData,uint64_t const& srcEndpointId,Reference<MultiInterface<Multi>> const& ssTeam,RequestStream<Req, P> Interface::* const& channel) 
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : req(req),
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   fSource(fSource),
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   fTss(fTss),
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   tssData(tssData),
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   srcEndpointId(srcEndpointId),
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   ssTeam(ssTeam),
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   channel(channel),
															#line 94 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   startTime(now()),
															#line 95 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   fTssWithTimeout(timeout(fTss, FLOW_KNOBS->LOAD_BALANCE_TSS_TIMEOUT)),
															#line 96 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   finished(0),
															#line 97 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   srcEndTime(),
															#line 98 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   tssEndTime(),
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   srcErrorCode(error_code_success),
															#line 101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   tssErrorCode(error_code_success),
															#line 102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   src(),
															#line 103 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   tss()
															#line 135 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("tssComparison", reinterpret_cast<unsigned long>(this));

	}
	~TssComparisonActorState() 
	{
		fdb_probe_actor_destroy("tssComparison", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			;
															#line 150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TssComparisonActorState();
		static_cast<TssComparisonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 125 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		++tssData.metrics->requests;
															#line 127 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (src.isError())
															#line 175 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 128 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			srcErrorCode = src.getError().code();
															#line 129 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			tssData.metrics->ssError(srcErrorCode);
															#line 181 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 131 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!tss.present())
															#line 185 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 132 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			++tssData.metrics->tssTimeouts;
															#line 189 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		else
		{
															#line 133 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (tss.get().isError())
															#line 195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 134 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				tssErrorCode = tss.get().getError().code();
															#line 135 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				tssData.metrics->tssError(tssErrorCode);
															#line 201 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!src.isError() && tss.present() && !tss.get().isError())
															#line 206 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 138 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Optional<LoadBalancedReply> srcLB = getLoadBalancedReply(&src.get());
															#line 139 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Optional<LoadBalancedReply> tssLB = getLoadBalancedReply(&tss.get().get());
															#line 140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT(srcLB.present() == tssLB.present());
															#line 144 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!srcLB.present() || (!srcLB.get().error.present() && !tssLB.get().error.present()))
															#line 216 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 147 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				tssData.metrics->recordLatency(req, srcEndTime - startTime, tssEndTime - startTime);
															#line 149 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!TSS_doCompare(src.get(), tss.get().get()))
															#line 222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					CODE_PROBE(true, "TSS Mismatch");
															#line 151 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					mismatchEvent = TraceEvent((g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(req, TSS_COMPARISON));
															#line 156 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					mismatchEvent.setMaxEventLength(FLOW_KNOBS->TSS_LARGE_TRACE_SIZE);
															#line 157 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					mismatchEvent.detail("TSSID", tssData.tssId);
															#line 159 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_VERIFY_SS && ssTeam->size() > 1)
															#line 234 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 160 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						CODE_PROBE(true, "checking TSS mismatch against rest of storage team");
															#line 164 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						restOfTeamFutures = std::vector<Future<ErrorOr<Resp>>>();
															#line 165 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						restOfTeamFutures.reserve(ssTeam->size() - 1);
															#line 166 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						for(int i = 0;i < ssTeam->size();i++) {
															#line 167 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 168 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (si->getEndpoint().token.first() != srcEndpointId)
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 170 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								resetReply(req);
															#line 171 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								restOfTeamFutures.push_back(si->tryGetReply(req));
															#line 254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
						}
															#line 175 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						StrictFuture<Void> __when_expr_2 = waitForAllReady(restOfTeamFutures);
															#line 175 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (static_cast<TssComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 261 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
						static_cast<TssComparisonActor*>(this)->actor_wait_state = 2;
															#line 175 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TssComparisonActor, 2, Void >*>(static_cast<TssComparisonActor*>(this)));
															#line 266 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont9(loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1cont8(loopDepth);
				}
			}
			else
			{
															#line 227 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (tssLB.present() && tssLB.get().error.present())
															#line 283 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					tssErrorCode = tssLB.get().error.get().code();
															#line 229 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					tssData.metrics->tssError(tssErrorCode);
															#line 289 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 230 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (srcLB.present() && srcLB.get().error.present())
															#line 295 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 231 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						srcErrorCode = srcLB.get().error.get().code();
															#line 232 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						tssData.metrics->ssError(srcErrorCode);
															#line 301 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
				loopDepth = a_body1cont7(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 107 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_0 = store(src, fSource);
															#line 106 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<TssComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 327 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 115 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_1 = store(tss, fTssWithTimeout);
															#line 331 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<TssComparisonActor*>(this)->actor_wait_state = 1;
															#line 107 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TssComparisonActor, 0, Void >*>(static_cast<TssComparisonActor*>(this)));
															#line 115 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TssComparisonActor, 1, Void >*>(static_cast<TssComparisonActor*>(this)));
															#line 338 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		srcEndTime = now();
															#line 109 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		fSource = Never();
															#line 110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		finished++;
															#line 111 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (finished == 2)
															#line 372 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		srcEndTime = now();
															#line 109 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		fSource = Never();
															#line 110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		finished++;
															#line 111 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (finished == 2)
															#line 390 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		tssEndTime = now();
															#line 117 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		fTssWithTimeout = Never();
															#line 118 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		finished++;
															#line 119 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (finished == 2)
															#line 408 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 116 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		tssEndTime = now();
															#line 117 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		fTssWithTimeout = Never();
															#line 118 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		finished++;
															#line 119 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (finished == 2)
															#line 426 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TssComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssComparisonActor*>(this)->ActorCallback< TssComparisonActor, 0, Void >::remove();
		static_cast<TssComparisonActor*>(this)->ActorCallback< TssComparisonActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TssComparisonActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TssComparisonActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 236 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (srcErrorCode != error_code_success && tssErrorCode != error_code_success && srcErrorCode != tssErrorCode)
															#line 559 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 238 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			TraceEvent("TSSErrorMismatch") .suppressFor(1.0) .detail("TSSID", tssData.tssId) .detail("SSError", srcErrorCode) .detail("TSSError", tssErrorCode);
															#line 563 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 245 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<TssComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TssComparisonActorState(); static_cast<TssComparisonActor*>(this)->destroy(); return 0; }
															#line 567 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<TssComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TssComparisonActorState();
		static_cast<TssComparisonActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 202 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (tssData.metrics->shouldRecordDetailedMismatch())
															#line 591 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 203 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			TSS_traceMismatch(mismatchEvent, req, src.get(), tss.get().get(), TSS_COMPARISON);
															#line 205 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			CODE_PROBE(FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Full TSS Mismatch");
															#line 206 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			CODE_PROBE(!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL, "Tracing Partial TSS Mismatch and storing the rest in FDB");
															#line 209 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!FLOW_KNOBS->LOAD_BALANCE_TSS_MISMATCH_TRACE_FULL)
															#line 601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 210 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				mismatchEvent.disable();
															#line 211 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				UID mismatchUID = deterministicRandom()->randomUniqueID();
															#line 212 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				tssData.metrics->recordDetailedMismatchData(mismatchUID, mismatchEvent.getFields().toString());
															#line 215 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent summaryEvent((g_network->isSimulated() && g_simulator->tssMode == ISimulator::TSSMode::EnabledDropMutations) ? SevWarnAlways : SevError, LB_mismatchTraceName(req, TSS_COMPARISON));
															#line 220 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				summaryEvent.detail("TSSID", tssData.tssId).detail("MismatchId", mismatchUID);
															#line 613 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
		else
		{
															#line 224 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			mismatchEvent.disable();
															#line 620 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numError = 0;
															#line 178 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchSS = 0;
															#line 179 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchTSS = 0;
															#line 180 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchNeither = 0;
															#line 181 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( Future<ErrorOr<Resp>> f : restOfTeamFutures ) {
															#line 182 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!f.canGet() || f.get().isError())
															#line 640 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 183 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				numError++;
															#line 644 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 185 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				Optional<LoadBalancedReply> fLB = getLoadBalancedReply(&f.get().get());
															#line 186 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (fLB.present() && fLB.get().error.present())
															#line 652 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 187 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					numError++;
															#line 656 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 188 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (TSS_doCompare(src.get(), f.get().get()))
															#line 662 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 189 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numMatchSS++;
															#line 666 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 190 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (TSS_doCompare(tss.get().get(), f.get().get()))
															#line 672 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 191 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							numMatchTSS++;
															#line 676 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
						else
						{
															#line 193 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							numMatchNeither++;
															#line 682 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
				}
			}
		}
															#line 197 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		mismatchEvent.detail("TeamCheckErrors", numError) .detail("TeamCheckMatchSS", numMatchSS) .detail("TeamCheckMatchTSS", numMatchTSS) .detail("TeamCheckMatchNeither", numMatchNeither);
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numError = 0;
															#line 178 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchSS = 0;
															#line 179 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchTSS = 0;
															#line 180 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMatchNeither = 0;
															#line 181 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( Future<ErrorOr<Resp>> f : restOfTeamFutures ) {
															#line 182 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!f.canGet() || f.get().isError())
															#line 709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 183 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				numError++;
															#line 713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 185 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				Optional<LoadBalancedReply> fLB = getLoadBalancedReply(&f.get().get());
															#line 186 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (fLB.present() && fLB.get().error.present())
															#line 721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 187 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					numError++;
															#line 725 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 188 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (TSS_doCompare(src.get(), f.get().get()))
															#line 731 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 189 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numMatchSS++;
															#line 735 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 190 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (TSS_doCompare(tss.get().get(), f.get().get()))
															#line 741 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 191 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							numMatchTSS++;
															#line 745 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
						else
						{
															#line 193 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							numMatchNeither++;
															#line 751 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
				}
			}
		}
															#line 197 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		mismatchEvent.detail("TeamCheckErrors", numError) .detail("TeamCheckMatchSS", numMatchSS) .detail("TeamCheckMatchTSS", numMatchTSS) .detail("TeamCheckMatchNeither", numMatchNeither);
															#line 759 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TssComparisonActor*>(this)->actor_wait_state > 0) static_cast<TssComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<TssComparisonActor*>(this)->ActorCallback< TssComparisonActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TssComparisonActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TssComparisonActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Req req;
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<ErrorOr<Resp>> fSource;
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<ErrorOr<Resp>> fTss;
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TSSEndpointData tssData;
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	uint64_t srcEndpointId;
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Reference<MultiInterface<Multi>> ssTeam;
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Req, P> Interface::* channel;
															#line 94 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double startTime;
															#line 95 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<Optional<ErrorOr<Resp>>> fTssWithTimeout;
															#line 96 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int finished;
															#line 97 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double srcEndTime;
															#line 98 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double tssEndTime;
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int srcErrorCode;
															#line 101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int tssErrorCode;
															#line 102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	ErrorOr<Resp> src;
															#line 103 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Optional<ErrorOr<Resp>> tss;
															#line 151 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TraceEvent mismatchEvent;
															#line 164 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	std::vector<Future<ErrorOr<Resp>>> restOfTeamFutures;
															#line 875 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via tssComparison()
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P>
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class TssComparisonActor final : public Actor<Void>, public ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >, public ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >, public ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 2, Void >, public FastAllocated<TssComparisonActor<Req, Resp, Interface, Multi, P>>, public TssComparisonActorState<Req, Resp, Interface, Multi, P, TssComparisonActor<Req, Resp, Interface, Multi, P>> {
															#line 882 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<TssComparisonActor<Req, Resp, Interface, Multi, P>>::operator new;
	using FastAllocated<TssComparisonActor<Req, Resp, Interface, Multi, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15397443553153033472UL, 9074619198195777024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >;
friend struct ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >;
friend struct ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 2, Void >;
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TssComparisonActor(Req const& req,Future<ErrorOr<Resp>> const& fSource,Future<ErrorOr<Resp>> const& fTss,TSSEndpointData const& tssData,uint64_t const& srcEndpointId,Reference<MultiInterface<Multi>> const& ssTeam,RequestStream<Req, P> Interface::* const& channel) 
															#line 901 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<Void>(),
		   TssComparisonActorState<Req, Resp, Interface, Multi, P, TssComparisonActor<Req, Resp, Interface, Multi, P>>(req, fSource, fTss, tssData, srcEndpointId, ssTeam, channel),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tssComparison", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8553245748359799296UL, 10319318729022024192UL);
		ActorExecutionContextHelper __helper(static_cast<TssComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tssComparison");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tssComparison", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TssComparisonActor<Req, Resp, Interface, Multi, P>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P>
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<Void> tssComparison( Req const& req, Future<ErrorOr<Resp>> const& fSource, Future<ErrorOr<Resp>> const& fTss, TSSEndpointData const& tssData, uint64_t const& srcEndpointId, Reference<MultiInterface<Multi>> const& ssTeam, RequestStream<Req, P> Interface::* const& channel ) {
															#line 86 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<Void>(new TssComparisonActor<Req, Resp, Interface, Multi, P>(req, fSource, fTss, tssData, srcEndpointId, ssTeam, channel));
															#line 937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 247 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

															#line 942 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via waitForQuorumReplies()
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Resp, class WaitForQuorumRepliesActor>
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class WaitForQuorumRepliesActorState {
															#line 949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	WaitForQuorumRepliesActorState(std::vector<Future<Optional<ErrorOr<Resp>>>>* const& replies,int const& required) 
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : replies(replies),
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   required(required),
															#line 250 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   outstandingReplies((int)replies->size()),
															#line 251 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   requiredReplies(std::min(required, (int)replies->size())),
															#line 252 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   ongoingReplies()
															#line 964 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("waitForQuorumReplies", reinterpret_cast<unsigned long>(this));

	}
	~WaitForQuorumRepliesActorState() 
	{
		fdb_probe_actor_destroy("waitForQuorumReplies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			;
															#line 979 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForQuorumRepliesActorState();
		static_cast<WaitForQuorumRepliesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 281 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<WaitForQuorumRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForQuorumRepliesActorState(); static_cast<WaitForQuorumRepliesActor*>(this)->destroy(); return 0; }
															#line 1002 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<WaitForQuorumRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForQuorumRepliesActorState();
		static_cast<WaitForQuorumRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ongoingReplies.clear();
															#line 255 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( auto& reply : (*replies) ) {
															#line 256 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!reply.isReady())
															#line 1025 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 257 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ongoingReplies.push_back(reply);
															#line 1029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
															#line 260 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(ongoingReplies.size() == outstandingReplies);
															#line 262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (requiredReplies == 0 || outstandingReplies == 0)
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 266 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_0 = quorum(ongoingReplies, std::min(requiredReplies, outstandingReplies));
															#line 266 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<WaitForQuorumRepliesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1044 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WaitForQuorumRepliesActor*>(this)->actor_wait_state = 1;
															#line 266 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForQuorumRepliesActor, 0, Void >*>(static_cast<WaitForQuorumRepliesActor*>(this)));
															#line 1049 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 268 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( auto& reply : ongoingReplies ) {
															#line 269 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (reply.isReady())
															#line 1073 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 270 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				outstandingReplies--;
															#line 271 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!reply.isError() && reply.get().present() && !reply.get().get().isError())
															#line 1079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 272 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					Optional<LoadBalancedReply> lbReply = getLoadBalancedReply(&reply.get().get().get());
															#line 273 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (lbReply.present() && !lbReply.get().error.present())
															#line 1085 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 274 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						requiredReplies--;
															#line 1089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 268 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( auto& reply : ongoingReplies ) {
															#line 269 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (reply.isReady())
															#line 1104 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 270 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				outstandingReplies--;
															#line 271 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!reply.isError() && reply.get().present() && !reply.get().get().isError())
															#line 1110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 272 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					Optional<LoadBalancedReply> lbReply = getLoadBalancedReply(&reply.get().get().get());
															#line 273 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (lbReply.present() && !lbReply.get().error.present())
															#line 1116 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 274 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						requiredReplies--;
															#line 1120 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForQuorumRepliesActor*>(this)->actor_wait_state > 0) static_cast<WaitForQuorumRepliesActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForQuorumRepliesActor*>(this)->ActorCallback< WaitForQuorumRepliesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForQuorumRepliesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuorumRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForQuorumRepliesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuorumRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForQuorumRepliesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuorumRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	std::vector<Future<Optional<ErrorOr<Resp>>>>* replies;
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int required;
															#line 250 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int outstandingReplies;
															#line 251 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int requiredReplies;
															#line 252 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	std::vector<Future<Optional<ErrorOr<Resp>>>> ongoingReplies;
															#line 1214 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via waitForQuorumReplies()
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Resp>
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class WaitForQuorumRepliesActor final : public Actor<Void>, public ActorCallback< WaitForQuorumRepliesActor<Resp>, 0, Void >, public FastAllocated<WaitForQuorumRepliesActor<Resp>>, public WaitForQuorumRepliesActorState<Resp, WaitForQuorumRepliesActor<Resp>> {
															#line 1221 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<WaitForQuorumRepliesActor<Resp>>::operator new;
	using FastAllocated<WaitForQuorumRepliesActor<Resp>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3338416081075171072UL, 1595544321243268096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForQuorumRepliesActor<Resp>, 0, Void >;
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	WaitForQuorumRepliesActor(std::vector<Future<Optional<ErrorOr<Resp>>>>* const& replies,int const& required) 
															#line 1238 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<Void>(),
		   WaitForQuorumRepliesActorState<Resp, WaitForQuorumRepliesActor<Resp>>(replies, required),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16083508386102982912UL, 1306394814074811392UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForQuorumRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForQuorumReplies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForQuorumReplies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForQuorumRepliesActor<Resp>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Resp>
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<Void> waitForQuorumReplies( std::vector<Future<Optional<ErrorOr<Resp>>>>* const& replies, int const& required ) {
															#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<Void>(new WaitForQuorumRepliesActor<Resp>(replies, required));
															#line 1273 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 283 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

															#line 1278 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via replicaComparison()
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P, class ReplicaComparisonActor>
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class ReplicaComparisonActorState {
															#line 1285 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	ReplicaComparisonActorState(Req const& req,Future<ErrorOr<Resp>> const& fSource,uint64_t const& srcEndpointId,Reference<MultiInterface<Multi>> const& ssTeam,RequestStream<Req, P> Interface::* const& channel,int const& requiredReplicas) 
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : req(req),
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   fSource(fSource),
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   srcEndpointId(srcEndpointId),
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   ssTeam(ssTeam),
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   channel(channel),
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   requiredReplicas(requiredReplicas),
															#line 291 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   src()
															#line 1304 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("replicaComparison", reinterpret_cast<unsigned long>(this));

	}
	~ReplicaComparisonActorState() 
	{
		fdb_probe_actor_destroy("replicaComparison", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 293 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (ssTeam->size() <= 1 || requiredReplicas == 0)
															#line 1319 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!static_cast<ReplicaComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplicaComparisonActorState(); static_cast<ReplicaComparisonActor*>(this)->destroy(); return 0; }
															#line 1323 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				new (&static_cast<ReplicaComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ReplicaComparisonActorState();
				static_cast<ReplicaComparisonActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_0 = store(src, fSource);
															#line 297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1333 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 1;
															#line 297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplicaComparisonActor, 0, Void >*>(static_cast<ReplicaComparisonActor*>(this)));
															#line 1338 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplicaComparisonActorState();
		static_cast<ReplicaComparisonActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (src.isError())
															#line 1361 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 300 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT_WE_THINK(false);
															#line 301 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (requiredReplicas == ALL_REPLICAS)
															#line 1367 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 302 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(src.getError(), loopDepth);
															#line 1371 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 305 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			srcLB = getLoadBalancedReply(&src.get());
															#line 307 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (srcLB.present() && srcLB.get().error.present())
															#line 1381 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 308 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ASSERT_WE_THINK(false);
															#line 309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (requiredReplicas == ALL_REPLICAS)
															#line 1387 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 310 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					return a_body1Catch1(srcLB.get().error.get(), loopDepth);
															#line 1391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				loopDepth = a_body1cont6(loopDepth);
			}
			else
			{
															#line 312 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!srcLB.present() || !srcLB.get().error.present())
															#line 1399 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 314 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					std::vector<uint64_t> candidates;
															#line 317 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = 0;i < ssTeam->size();i++) {
															#line 318 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 319 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (si->getEndpoint().token.first() == srcEndpointId)
															#line 1409 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
							continue;
						}
															#line 323 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!IFailureMonitor::failureMonitor().getState(si->getEndpoint()).failed)
															#line 1415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 324 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							candidates.push_back(si->getEndpoint().token.first());
															#line 1419 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
						else
						{
															#line 325 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (requiredReplicas == ALL_REPLICAS)
															#line 1425 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 326 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								TraceEvent(SevWarnAlways, "UnreachableStorageServer").detail("SSID", ssTeam->getInterface(i).id());
															#line 327 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								return a_body1Catch1(unreachable_storage_replica(), loopDepth);
															#line 1431 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
						}
					}
															#line 330 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					int numReplicaToRead = candidates.size();
															#line 331 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (requiredReplicas != BEST_EFFORT && requiredReplicas != ALL_REPLICAS)
															#line 1439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 332 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						ASSERT(requiredReplicas > 0);
															#line 333 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numReplicaToRead = std::min((int)candidates.size(), requiredReplicas);
															#line 334 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (FLOW_KNOBS->ENABLE_WARNING_READ_CONSISTENCY_CHECK_NOT_ENOUGH_REPLICA && candidates.size() < requiredReplicas)
															#line 1447 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 336 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							TraceEvent(SevWarn, "ReplicaConsistencyCheckNotEnoughReplica") .suppressFor(5.0) .detail("RequiredReplicas", requiredReplicas) .detail("AvailableReplicas", candidates.size());
															#line 1451 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
															#line 342 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					restOfTeamFutures = std::vector<Future<Optional<ErrorOr<Resp>>>>();
															#line 343 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					restOfTeamFutures.reserve(numReplicaToRead);
															#line 345 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					deterministicRandom()->randomShuffle(candidates);
															#line 346 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					candidates.erase(candidates.begin() + numReplicaToRead, candidates.end());
															#line 347 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					std::unordered_set<uint64_t> ssToRead(candidates.begin(), candidates.end());
															#line 349 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = 0;i < ssTeam->size();i++) {
															#line 350 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 351 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!ssToRead.contains(si->getEndpoint().token.first()))
															#line 1470 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
							continue;
						}
															#line 355 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						resetReply(req);
															#line 356 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						restOfTeamFutures.push_back( (requiredReplicas == BEST_EFFORT ? timeout(si->tryGetReply(req), FLOW_KNOBS->LOAD_BALANCE_FETCH_REPLICA_TIMEOUT) : timeout(errorOr(si->getReply(req)), FLOW_KNOBS->LOAD_BALANCE_FETCH_REPLICA_TIMEOUT)));
															#line 1478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
															#line 362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					StrictFuture<Void> __when_expr_1 = waitForAllReady(restOfTeamFutures);
															#line 362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1484 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 2;
															#line 362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplicaComparisonActor, 1, Void >*>(static_cast<ReplicaComparisonActor*>(this)));
															#line 1489 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont9(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (src.isError())
															#line 1505 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 300 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT_WE_THINK(false);
															#line 301 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (requiredReplicas == ALL_REPLICAS)
															#line 1511 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 302 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(src.getError(), loopDepth);
															#line 1515 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 305 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			srcLB = getLoadBalancedReply(&src.get());
															#line 307 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (srcLB.present() && srcLB.get().error.present())
															#line 1525 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 308 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ASSERT_WE_THINK(false);
															#line 309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (requiredReplicas == ALL_REPLICAS)
															#line 1531 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 310 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					return a_body1Catch1(srcLB.get().error.get(), loopDepth);
															#line 1535 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				loopDepth = a_body1cont6(loopDepth);
			}
			else
			{
															#line 312 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!srcLB.present() || !srcLB.get().error.present())
															#line 1543 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 314 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					std::vector<uint64_t> candidates;
															#line 317 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = 0;i < ssTeam->size();i++) {
															#line 318 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 319 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (si->getEndpoint().token.first() == srcEndpointId)
															#line 1553 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
							continue;
						}
															#line 323 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!IFailureMonitor::failureMonitor().getState(si->getEndpoint()).failed)
															#line 1559 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 324 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							candidates.push_back(si->getEndpoint().token.first());
															#line 1563 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
						else
						{
															#line 325 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (requiredReplicas == ALL_REPLICAS)
															#line 1569 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 326 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								TraceEvent(SevWarnAlways, "UnreachableStorageServer").detail("SSID", ssTeam->getInterface(i).id());
															#line 327 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								return a_body1Catch1(unreachable_storage_replica(), loopDepth);
															#line 1575 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
						}
					}
															#line 330 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					int numReplicaToRead = candidates.size();
															#line 331 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (requiredReplicas != BEST_EFFORT && requiredReplicas != ALL_REPLICAS)
															#line 1583 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 332 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						ASSERT(requiredReplicas > 0);
															#line 333 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numReplicaToRead = std::min((int)candidates.size(), requiredReplicas);
															#line 334 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (FLOW_KNOBS->ENABLE_WARNING_READ_CONSISTENCY_CHECK_NOT_ENOUGH_REPLICA && candidates.size() < requiredReplicas)
															#line 1591 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 336 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							TraceEvent(SevWarn, "ReplicaConsistencyCheckNotEnoughReplica") .suppressFor(5.0) .detail("RequiredReplicas", requiredReplicas) .detail("AvailableReplicas", candidates.size());
															#line 1595 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
															#line 342 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					restOfTeamFutures = std::vector<Future<Optional<ErrorOr<Resp>>>>();
															#line 343 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					restOfTeamFutures.reserve(numReplicaToRead);
															#line 345 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					deterministicRandom()->randomShuffle(candidates);
															#line 346 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					candidates.erase(candidates.begin() + numReplicaToRead, candidates.end());
															#line 347 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					std::unordered_set<uint64_t> ssToRead(candidates.begin(), candidates.end());
															#line 349 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = 0;i < ssTeam->size();i++) {
															#line 350 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Req, P> const* si = &ssTeam->get(i, channel);
															#line 351 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!ssToRead.contains(si->getEndpoint().token.first()))
															#line 1614 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
							continue;
						}
															#line 355 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						resetReply(req);
															#line 356 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						restOfTeamFutures.push_back( (requiredReplicas == BEST_EFFORT ? timeout(si->tryGetReply(req), FLOW_KNOBS->LOAD_BALANCE_FETCH_REPLICA_TIMEOUT) : timeout(errorOr(si->getReply(req)), FLOW_KNOBS->LOAD_BALANCE_FETCH_REPLICA_TIMEOUT)));
															#line 1622 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
															#line 362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					StrictFuture<Void> __when_expr_1 = waitForAllReady(restOfTeamFutures);
															#line 362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1628 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 2;
															#line 362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplicaComparisonActor, 1, Void >*>(static_cast<ReplicaComparisonActor*>(this)));
															#line 1633 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont9(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state > 0) static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<ReplicaComparisonActor*>(this)->ActorCallback< ReplicaComparisonActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplicaComparisonActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplicaComparisonActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplicaComparisonActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 445 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<ReplicaComparisonActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReplicaComparisonActorState(); static_cast<ReplicaComparisonActor*>(this)->destroy(); return 0; }
															#line 1724 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<ReplicaComparisonActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReplicaComparisonActorState();
		static_cast<ReplicaComparisonActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 364 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numError = 0;
															#line 365 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMismatch = 0;
															#line 366 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numFetchReplicaTimeout = 0;
															#line 367 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int replicaErrorCode = error_code_success;
															#line 368 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int successfulReplies = 0;
															#line 369 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( Future<Optional<ErrorOr<Resp>>> f : restOfTeamFutures ) {
															#line 370 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!f.isReady())
															#line 1760 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 371 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ASSERT(requiredReplicas > 0);
															#line 1764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				continue;
			}
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (f.isError())
															#line 1769 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 375 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				numError++;
															#line 376 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				replicaErrorCode = f.getError().code();
															#line 1775 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 377 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!f.get().present())
															#line 1781 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 378 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					numFetchReplicaTimeout++;
															#line 379 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					replicaErrorCode = error_code_timed_out;
															#line 1787 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 380 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (f.get().get().isError())
															#line 1793 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 381 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numError++;
															#line 382 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						replicaErrorCode = f.get().get().getError().code();
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 384 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						Optional<LoadBalancedReply> fLB = getLoadBalancedReply(&f.get().get().get());
															#line 386 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						ASSERT(srcLB.present() == fLB.present());
															#line 389 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (fLB.present())
															#line 1809 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 390 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (fLB.get().error.present())
															#line 1813 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								numError++;
															#line 392 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								replicaErrorCode = fLB.get().error.get().code();
															#line 1819 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
							else
							{
															#line 394 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (!TSS_doCompare( src.get(), f.get().get().get()))
															#line 1825 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 397 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									numMismatch++;
															#line 398 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									TraceEvent mismatchEvent( (requiredReplicas == BEST_EFFORT || requiredReplicas == ALL_REPLICAS) ? SevError : SevWarnAlways, LB_mismatchTraceName(req, REPLICA_COMPARISON));
															#line 403 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									mismatchEvent.detail("ReplicaFetchErrors", numError) .detail("ReplicaFetchTimeouts", numFetchReplicaTimeout);
															#line 406 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									TSS_traceMismatch( mismatchEvent, req, src.get(), f.get().get().get(), REPLICA_COMPARISON);
															#line 1835 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
															#line 409 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (++successfulReplies == requiredReplicas)
															#line 1839 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
									break;
								}
							}
						}
					}
				}
			}
															#line 418 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (replicaErrorCode == error_code_wrong_shard_server)
															#line 1850 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 419 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent(SevWarnAlways, "ReplicaComparisonReadError") .suppressFor(1.0) .detail("TeamSize", restOfTeamFutures.size() + 1) .detail("RequiredReplies", requiredReplicas) .detail("SSError", error_code_wrong_shard_server);
															#line 424 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(wrong_shard_server(), loopDepth);
															#line 1856 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
															#line 428 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (numMismatch)
															#line 1861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 429 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(storage_replica_comparison_error(), loopDepth);
															#line 1865 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		else
		{
															#line 430 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (((numError || numFetchReplicaTimeout) && (requiredReplicas == ALL_REPLICAS)) || (successfulReplies != requiredReplicas && requiredReplicas > 0 && restOfTeamFutures.size() >= requiredReplicas))
															#line 1871 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 433 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				const char* type = numError ? "ReplicaComparisonReadError" : "ReplicaComparisonTimeoutError";
															#line 434 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent(SevWarnAlways, type) .detail("TeamSize", restOfTeamFutures.size() + 1) .detail("RequiredReplies", requiredReplicas) .detail("SuccessfulReplies", successfulReplies) .detail("SSError", replicaErrorCode);
															#line 440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(Error((requiredReplicas == ALL_REPLICAS) ? replicaErrorCode : error_code_unreachable_storage_replica), loopDepth);
															#line 1879 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 364 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numError = 0;
															#line 365 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numMismatch = 0;
															#line 366 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int numFetchReplicaTimeout = 0;
															#line 367 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int replicaErrorCode = error_code_success;
															#line 368 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		int successfulReplies = 0;
															#line 369 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for( Future<Optional<ErrorOr<Resp>>> f : restOfTeamFutures ) {
															#line 370 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!f.isReady())
															#line 1902 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 371 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ASSERT(requiredReplicas > 0);
															#line 1906 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				continue;
			}
															#line 374 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (f.isError())
															#line 1911 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 375 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				numError++;
															#line 376 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				replicaErrorCode = f.getError().code();
															#line 1917 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 377 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (!f.get().present())
															#line 1923 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 378 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					numFetchReplicaTimeout++;
															#line 379 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					replicaErrorCode = error_code_timed_out;
															#line 1929 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
				else
				{
															#line 380 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (f.get().get().isError())
															#line 1935 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 381 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						numError++;
															#line 382 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						replicaErrorCode = f.get().get().getError().code();
															#line 1941 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 384 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						Optional<LoadBalancedReply> fLB = getLoadBalancedReply(&f.get().get().get());
															#line 386 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						ASSERT(srcLB.present() == fLB.present());
															#line 389 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (fLB.present())
															#line 1951 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 390 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (fLB.get().error.present())
															#line 1955 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								numError++;
															#line 392 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								replicaErrorCode = fLB.get().error.get().code();
															#line 1961 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
							else
							{
															#line 394 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (!TSS_doCompare( src.get(), f.get().get().get()))
															#line 1967 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 397 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									numMismatch++;
															#line 398 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									TraceEvent mismatchEvent( (requiredReplicas == BEST_EFFORT || requiredReplicas == ALL_REPLICAS) ? SevError : SevWarnAlways, LB_mismatchTraceName(req, REPLICA_COMPARISON));
															#line 403 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									mismatchEvent.detail("ReplicaFetchErrors", numError) .detail("ReplicaFetchTimeouts", numFetchReplicaTimeout);
															#line 406 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									TSS_traceMismatch( mismatchEvent, req, src.get(), f.get().get().get(), REPLICA_COMPARISON);
															#line 1977 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
															#line 409 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (++successfulReplies == requiredReplicas)
															#line 1981 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
									break;
								}
							}
						}
					}
				}
			}
															#line 418 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (replicaErrorCode == error_code_wrong_shard_server)
															#line 1992 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 419 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent(SevWarnAlways, "ReplicaComparisonReadError") .suppressFor(1.0) .detail("TeamSize", restOfTeamFutures.size() + 1) .detail("RequiredReplies", requiredReplicas) .detail("SSError", error_code_wrong_shard_server);
															#line 424 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(wrong_shard_server(), loopDepth);
															#line 1998 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
															#line 428 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (numMismatch)
															#line 2003 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 429 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(storage_replica_comparison_error(), loopDepth);
															#line 2007 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		else
		{
															#line 430 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (((numError || numFetchReplicaTimeout) && (requiredReplicas == ALL_REPLICAS)) || (successfulReplies != requiredReplicas && requiredReplicas > 0 && restOfTeamFutures.size() >= requiredReplicas))
															#line 2013 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 433 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				const char* type = numError ? "ReplicaComparisonReadError" : "ReplicaComparisonTimeoutError";
															#line 434 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				TraceEvent(SevWarnAlways, type) .detail("TeamSize", restOfTeamFutures.size() + 1) .detail("RequiredReplies", requiredReplicas) .detail("SuccessfulReplies", successfulReplies) .detail("SSError", replicaErrorCode);
															#line 440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				return a_body1Catch1(Error((requiredReplicas == ALL_REPLICAS) ? replicaErrorCode : error_code_unreachable_storage_replica), loopDepth);
															#line 2021 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
		}
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReplicaComparisonActor*>(this)->actor_wait_state > 0) static_cast<ReplicaComparisonActor*>(this)->actor_wait_state = 0;
		static_cast<ReplicaComparisonActor*>(this)->ActorCallback< ReplicaComparisonActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplicaComparisonActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReplicaComparisonActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReplicaComparisonActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Req req;
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<ErrorOr<Resp>> fSource;
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	uint64_t srcEndpointId;
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Reference<MultiInterface<Multi>> ssTeam;
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Req, P> Interface::* channel;
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int requiredReplicas;
															#line 291 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	ErrorOr<Resp> src;
															#line 305 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Optional<LoadBalancedReply> srcLB;
															#line 342 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	std::vector<Future<Optional<ErrorOr<Resp>>>> restOfTeamFutures;
															#line 2121 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via replicaComparison()
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P>
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class ReplicaComparisonActor final : public Actor<Void>, public ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >, public ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >, public FastAllocated<ReplicaComparisonActor<Req, Resp, Interface, Multi, P>>, public ReplicaComparisonActorState<Req, Resp, Interface, Multi, P, ReplicaComparisonActor<Req, Resp, Interface, Multi, P>> {
															#line 2128 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<ReplicaComparisonActor<Req, Resp, Interface, Multi, P>>::operator new;
	using FastAllocated<ReplicaComparisonActor<Req, Resp, Interface, Multi, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1434807961641850112UL, 17496779435550977280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >;
friend struct ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >;
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	ReplicaComparisonActor(Req const& req,Future<ErrorOr<Resp>> const& fSource,uint64_t const& srcEndpointId,Reference<MultiInterface<Multi>> const& ssTeam,RequestStream<Req, P> Interface::* const& channel,int const& requiredReplicas) 
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<Void>(),
		   ReplicaComparisonActorState<Req, Resp, Interface, Multi, P, ReplicaComparisonActor<Req, Resp, Interface, Multi, P>>(req, fSource, srcEndpointId, ssTeam, channel, requiredReplicas),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("replicaComparison", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1852103863548525312UL, 15097773629334850048UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicaComparisonActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("replicaComparison");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("replicaComparison", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReplicaComparisonActor<Req, Resp, Interface, Multi, P>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Req, class Resp, class Interface, class Multi, bool P>
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<Void> replicaComparison( Req const& req, Future<ErrorOr<Resp>> const& fSource, uint64_t const& srcEndpointId, Reference<MultiInterface<Multi>> const& ssTeam, RequestStream<Req, P> Interface::* const& channel, int const& requiredReplicas ) {
															#line 284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<Void>(new ReplicaComparisonActor<Req, Resp, Interface, Multi, P>(req, fSource, srcEndpointId, ssTeam, channel, requiredReplicas));
															#line 2182 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 447 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

FDB_BOOLEAN_PARAM(AtMostOnce);
FDB_BOOLEAN_PARAM(TriedAllOptions);

// Stores state for a request made by the load balancer
template <class Request, class Interface, class Multi, bool P>
struct RequestData : NonCopyable {
	typedef ErrorOr<REPLY_TYPE(Request)> Reply;

	Future<Reply> response;
	Reference<ModelHolder> modelHolder;
	TriedAllOptions triedAllOptions{ false };
	RequestStream<Request, P> const* requestStream = nullptr;

	bool requestStarted = false; // true once the request has been sent to an alternative
	bool requestProcessed = false; // true once a response has been received and handled by checkAndProcessResult

	bool compareReplicas = false;
	Future<Void> comparisonResult;

	RequestData(bool compareReplicas = false) : compareReplicas(compareReplicas) {}

	// Whether or not the response future is valid
	// This is true once setupRequest is called, even though at that point the response is Never().
	bool isValid() { return response.isValid(); }

	static void maybeDuplicateTSSRequest(RequestStream<Request, P> const* stream,
	                                     Request& request,
	                                     QueueModel* model,
	                                     Future<Reply> ssResponse,
	                                     Reference<MultiInterface<Multi>> alternatives,
	                                     RequestStream<Request, P> Interface::* channel) {
		if (model) {
			// Send parallel request to TSS pair, if it exists
			Optional<TSSEndpointData> tssData = model->getTssData(stream->getEndpoint().token.first());

			if (tssData.present()) {
				CODE_PROBE(true, "duplicating request to TSS");
				resetReply(request);
				// FIXME: optimize to avoid creating new netNotifiedQueue for each message
				RequestStream<Request, P> tssRequestStream(tssData.get().endpoint);
				Future<ErrorOr<REPLY_TYPE(Request)>> fTssResult = tssRequestStream.tryGetReply(request);
				model->addActor.send(tssComparison(request,
				                                   ssResponse,
				                                   fTssResult,
				                                   tssData.get(),
				                                   stream->getEndpoint().token.first(),
				                                   alternatives,
				                                   channel));
			}
		}
	}

	Future<Void> maybeDoReplicaComparison(Request& request,
	                                      QueueModel* model,
	                                      Reference<MultiInterface<Multi>> alternatives,
	                                      RequestStream<Request, P> Interface::* channel,
	                                      int requiredReplicas) {
		if (model && (compareReplicas || FLOW_KNOBS->ENABLE_REPLICA_CONSISTENCY_CHECK_ON_READS)) {
			ASSERT(requestStream != nullptr);
			if (compareReplicas) {
				// In case compareReplicas == true, we may read extra requiredReplicas replica.
				// The value of compareReplicas is decided by the caller and the knobs.
				// If the caller is fetchKeys, when ENABLE_REPLICA_CONSISTENCY_CHECK_ON_DATA_MOVEMENT is on,
				// the value is DATAMOVE_CONSISTENCY_CHECK_REQUIRED_REPLICAS.
				// If the caller is backup agents, when ENABLE_REPLICA_CONSISTENCY_CHECK_ON_BACKUP_READS is on,
				// the value is BACKUP_CONSISTENCY_CHECK_REQUIRED_REPLICAS.
				// Otherwise, the value is 0.
				return replicaComparison(request,
				                         response,
				                         requestStream->getEndpoint().token.first(),
				                         alternatives,
				                         channel,
				                         requiredReplicas);
			}
			// In case ENABLE_REPLICA_CONSISTENCY_CHECK_ON_READS is on, we read extra
			// READ_CONSISTENCY_CHECK_REQUIRED_REPLICAS replica and conduct consistency
			// check among replica for any read request.
			return replicaComparison(request,
			                         response,
			                         requestStream->getEndpoint().token.first(),
			                         alternatives,
			                         channel,
			                         FLOW_KNOBS->READ_CONSISTENCY_CHECK_REQUIRED_REPLICAS);
		}
		return Void();
	}

	// Initializes the request state and starts it, possibly after a backoff delay
	void startRequest(
	    double backoff,
	    TriedAllOptions triedAllOptions,
	    RequestStream<Request, P> const* stream,
	    Request& request,
	    QueueModel* model,
	    Reference<MultiInterface<Multi>> alternatives, // alternatives and channel passed through for TSS check
	    RequestStream<Request, P> Interface::* channel) {
		modelHolder = Reference<ModelHolder>();
		requestStream = stream;
		requestStarted = false;

		if (backoff > 0) {
			response = mapAsync(delay(backoff), [this, stream, &request, model, alternatives, channel](Void _) {
				requestStarted = true;
				modelHolder = Reference<ModelHolder>(new ModelHolder(model, stream->getEndpoint().token.first()));
				Future<Reply> resp = stream->tryGetReply(request);
				maybeDuplicateTSSRequest(stream, request, model, resp, alternatives, channel);
				return resp;
			});
		} else {
			requestStarted = true;
			modelHolder = Reference<ModelHolder>(new ModelHolder(model, stream->getEndpoint().token.first()));
			response = stream->tryGetReply(request);
			maybeDuplicateTSSRequest(stream, request, model, response, alternatives, channel);
		}

		requestProcessed = false;
		this->triedAllOptions = triedAllOptions;
	}

	// Implementation of the logic to handle a response.
	// Checks the state of the response, updates the queue model, and returns one of the following outcomes:
	// A return value of true means that the request completed successfully
	// A return value of false means that the request failed but should be retried
	// A return value with an error means that the error should be thrown back to original caller
	static ErrorOr<bool> checkAndProcessResultImpl(Reply const& result,
	                                               Reference<ModelHolder> modelHolder,
	                                               AtMostOnce atMostOnce,
	                                               TriedAllOptions triedAllOptions) {
		ASSERT(modelHolder);

		Optional<LoadBalancedReply> loadBalancedReply;
		if (!result.isError()) {
			loadBalancedReply = getLoadBalancedReply(&result.get());
		}

		int errCode;
		if (loadBalancedReply.present()) {
			errCode = loadBalancedReply.get().error.present() ? loadBalancedReply.get().error.get().code()
			                                                  : error_code_success;
		} else {
			errCode = result.isError() ? result.getError().code() : error_code_success;
		}

		bool maybeDelivered = errCode == error_code_broken_promise || errCode == error_code_request_maybe_delivered;
		bool receivedResponse =
		    loadBalancedReply.present() ? !loadBalancedReply.get().error.present() : result.present();
		receivedResponse = receivedResponse || (!maybeDelivered && errCode != error_code_process_behind);
		bool futureVersion = errCode == error_code_future_version || errCode == error_code_process_behind;

		modelHolder->release(
		    receivedResponse, futureVersion, loadBalancedReply.present() ? loadBalancedReply.get().penalty : -1.0);

		if (errCode == error_code_server_overloaded) {
			return false;
		}

		if (loadBalancedReply.present() && !loadBalancedReply.get().error.present()) {
			return true;
		}

		if (!loadBalancedReply.present() && result.present()) {
			return true;
		}

		if (receivedResponse) {
			return loadBalancedReply.present() ? loadBalancedReply.get().error.get() : result.getError();
		}

		if (atMostOnce && maybeDelivered) {
			return request_maybe_delivered();
		}

		if (triedAllOptions && errCode == error_code_process_behind) {
			return process_behind();
		}

		return false;
	}

	// Checks the state of the response, updates the queue model, and returns one of the following outcomes:
	// A return value of true means that the request completed successfully
	// A return value of false means that the request failed but should be retried
	// In the event of a non-retryable failure, an error is thrown indicating the failure
	bool checkAndProcessResult(AtMostOnce atMostOnce) {
		ASSERT(response.isReady());
		requestProcessed = true;

		ErrorOr<bool> outcome =
		    checkAndProcessResultImpl(response.get(), std::move(modelHolder), atMostOnce, triedAllOptions);

		if (outcome.isError()) {
			throw outcome.getError();
		} else if (!outcome.get()) {
			response = Future<Reply>();
		}

		return outcome.get();
	}

	// Convert this request to a lagging request. Such a request is no longer being waited on, but it still needs to be
	// processed so we can update the queue model.
	void makeLaggingRequest() {
		ASSERT(response.isValid());
		ASSERT(modelHolder);
		ASSERT(modelHolder->model);

		QueueModel* model = modelHolder->model;
		if (model->laggingRequestCount > FLOW_KNOBS->MAX_LAGGING_REQUESTS_OUTSTANDING ||
		    model->laggingRequests.isReady()) {
			model->laggingRequests.cancel();
			model->laggingRequestCount = 0;
			model->addActor = PromiseStream<Future<Void>>();
			model->laggingRequests = actorCollection(model->addActor.getFuture(), &model->laggingRequestCount);
		}

		// We need to process the lagging request in order to update the queue model
		Reference<ModelHolder> holderCapture = std::move(modelHolder);
		auto triedAllOptionsCapture = triedAllOptions;
		Future<Void> updateModel = map(response, [holderCapture, triedAllOptionsCapture](Reply result) {
			checkAndProcessResultImpl(result, holderCapture, AtMostOnce::False, triedAllOptionsCapture);
			return Void();
		});
		model->addActor.send(updateModel);
	}

	~RequestData() {
		// If the request has been started but hasn't completed, mark it as a lagging request
		if (requestStarted && !requestProcessed && modelHolder && modelHolder->model) {
			makeLaggingRequest();
		}
	}
};

// Try to get a reply from one of the alternatives until success, cancellation, or certain errors.
// Load balancing has a budget to race requests to a second alternative if the first request is slow.
// Tries to take into account failMon's information for load balancing and avoiding failed servers.
// If ALL the servers are failed and the list of servers is not fresh, throws an exception to let the caller refresh the
// list of servers.
// When model is set, load balance among alternatives in the same DC aims to balance request queue length on these
// interfaces. If too many interfaces in the same DC are bad, try remote interfaces.
// If compareReplicas is set, does a consistency check by fetching and comparing results from storage
// replicas (as many as specified by "requiredReplicas") and throws an exception if an inconsistency is found.
															#line 2429 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via loadBalance()
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P, class LoadBalanceActor>
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class LoadBalanceActorState {
															#line 2436 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	LoadBalanceActorState(Reference<MultiInterface<Multi>> const& alternatives,RequestStream<Request, P> Interface::* const& channel,Request const& request = Request(),TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint,AtMostOnce const& atMostOnce = AtMostOnce::False,QueueModel* const& model = nullptr,bool const& compareReplicas = false,int const& requiredReplicas = 0) 
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : alternatives(alternatives),
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   channel(channel),
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   request(request),
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   taskID(taskID),
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   atMostOnce(atMostOnce),
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   model(model),
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   compareReplicas(compareReplicas),
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   requiredReplicas(requiredReplicas),
															#line 702 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   firstRequestData(compareReplicas),
															#line 703 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   secondRequestData(compareReplicas),
															#line 705 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   firstRequestEndpoint(),
															#line 706 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   secondDelay(Never()),
															#line 708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   requestFinished(),
															#line 709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   startTime(now()),
															#line 711 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   triedAllOptions(TriedAllOptions::False)
															#line 2471 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("loadBalance", reinterpret_cast<unsigned long>(this));

	}
	~LoadBalanceActorState() 
	{
		fdb_probe_actor_destroy("loadBalance", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			setReplyPriority(request, taskID);
															#line 714 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!alternatives)
															#line 2488 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 715 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				this->~LoadBalanceActorState();
															#line 2492 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				static_cast<LoadBalanceActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 717 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT(alternatives->size());
															#line 719 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			bestAlt = deterministicRandom()->randomInt(0, alternatives->countBest());
															#line 720 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			nextAlt = deterministicRandom()->randomInt(0, std::max(alternatives->size() - 1, 1));
															#line 721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt >= bestAlt)
															#line 2504 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 722 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				nextAlt++;
															#line 2508 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 724 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (model)
															#line 2512 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 725 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				double bestMetric = 1e9;
															#line 726 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				double nextMetric = 1e9;
															#line 727 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				double bestTime = 1e9;
															#line 728 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				double nextTime = 1e9;
															#line 729 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				int badServers = 0;
															#line 731 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				for(int i = 0;i < alternatives->size();i++) {
															#line 734 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (badServers < std::min(i, FLOW_KNOBS->LOAD_BALANCE_MAX_BAD_OPTIONS + 1) && i == alternatives->countBest())
															#line 2528 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
						break;
					}
					else
					{
															#line 740 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (badServers == alternatives->countBest() && i == badServers)
															#line 2536 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 741 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							TraceEvent("AllLocalAlternativesFailed") .suppressFor(1.0) .detail("Alternatives", alternatives->description()) .detail("Total", alternatives->size()) .detail("Best", alternatives->countBest());
															#line 2540 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
															#line 748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					RequestStream<Request, P> const* thisStream = &alternatives->get(i, channel);
															#line 749 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (!IFailureMonitor::failureMonitor().getState(thisStream->getEndpoint()).failed)
															#line 2547 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 750 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						auto const& qd = model->getMeasurement(thisStream->getEndpoint().token.first());
															#line 751 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (now() > qd.failedUntil)
															#line 2553 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 752 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							double thisMetric = qd.smoothOutstanding.smoothTotal();
															#line 753 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							double thisTime = qd.latency;
															#line 754 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (FLOW_KNOBS->LOAD_BALANCE_PENALTY_IS_BAD && qd.penalty > 1.001)
															#line 2561 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 758 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								++badServers;
															#line 2565 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
															#line 761 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (thisMetric < bestMetric)
															#line 2569 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (i != bestAlt)
															#line 2573 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 763 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextAlt = bestAlt;
															#line 764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextMetric = bestMetric;
															#line 765 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextTime = bestTime;
															#line 2581 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
															#line 767 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								bestAlt = i;
															#line 768 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								bestMetric = thisMetric;
															#line 769 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								bestTime = thisTime;
															#line 2589 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							}
							else
							{
															#line 770 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (thisMetric < nextMetric)
															#line 2595 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 771 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextAlt = i;
															#line 772 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextMetric = thisMetric;
															#line 773 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextTime = thisTime;
															#line 2603 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
							}
						}
						else
						{
															#line 776 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							++badServers;
															#line 2611 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						}
					}
					else
					{
															#line 779 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						++badServers;
															#line 2618 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
															#line 782 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (nextMetric > 1e8)
															#line 2623 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 786 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					for(int i = alternatives->countBest();i < alternatives->size();i++) {
															#line 787 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						RequestStream<Request, P> const* thisStream = &alternatives->get(i, channel);
															#line 788 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						if (!IFailureMonitor::failureMonitor().getState(thisStream->getEndpoint()).failed)
															#line 2631 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
						{
															#line 789 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							auto const& qd = model->getMeasurement(thisStream->getEndpoint().token.first());
															#line 790 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
							if (now() > qd.failedUntil)
															#line 2637 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
							{
															#line 791 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								double thisMetric = qd.smoothOutstanding.smoothTotal();
															#line 792 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								double thisTime = qd.latency;
															#line 794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
								if (thisMetric < nextMetric)
															#line 2645 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								{
															#line 795 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextAlt = i;
															#line 796 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextMetric = thisMetric;
															#line 797 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
									nextTime = thisTime;
															#line 2653 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
								}
							}
						}
					}
				}
															#line 804 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (nextTime < 1e9)
															#line 2661 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 806 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (bestTime > FLOW_KNOBS->INSTANT_SECOND_REQUEST_MULTIPLIER * (model->secondMultiplier * (nextTime) + FLOW_KNOBS->BASE_SECOND_REQUEST_TIME))
															#line 2665 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 808 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						secondDelay = Void();
															#line 2669 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
					else
					{
															#line 810 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						secondDelay = delay(model->secondMultiplier * nextTime + FLOW_KNOBS->BASE_SECOND_REQUEST_TIME);
															#line 2675 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
				}
				else
				{
															#line 813 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					secondDelay = Never();
															#line 2682 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
			}
															#line 817 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			startAlt = nextAlt;
															#line 818 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			startDistance = (bestAlt + alternatives->size() - startAlt) % alternatives->size();
															#line 820 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			numAttempts = 0;
															#line 821 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = 0;
															#line 823 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			;
															#line 2695 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 824 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (now() - startTime > (g_network->isSimulated() ? 30.0 : 600.0))
															#line 2725 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 825 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			TraceEvent ev(g_network->isSimulated() ? SevWarn : SevWarnAlways, "LoadBalanceTooLong");
															#line 826 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.suppressFor(1.0);
															#line 827 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.detail("Duration", now() - startTime);
															#line 828 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.detail("NumAttempts", numAttempts);
															#line 829 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.detail("Backoff", backoff);
															#line 830 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ev.detail("TriedAllOptions", triedAllOptions);
															#line 831 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (ev.isEnabled())
															#line 2741 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 832 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ev.log();
															#line 833 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				for(int alternativeNum = 0;alternativeNum < alternatives->size();alternativeNum++) {
															#line 834 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					RequestStream<Request, P> const* thisStream = &alternatives->get(alternativeNum, channel);
															#line 835 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					TraceEvent(SevWarn, "LoadBalanceTooLongEndpoint") .detail("Addr", thisStream->getEndpoint().getPrimaryAddress()) .detail("Token", thisStream->getEndpoint().token) .detail("Failed", IFailureMonitor::failureMonitor().getState(thisStream->getEndpoint()).failed);
															#line 2751 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
			}
		}
															#line 846 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		stream = nullptr;
															#line 847 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		distance = LBDistance::Type();
															#line 848 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for(int alternativeNum = 0;alternativeNum < alternatives->size();alternativeNum++) {
															#line 849 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			int useAlt = nextAlt;
															#line 850 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt == startAlt)
															#line 2765 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 851 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				useAlt = bestAlt;
															#line 2769 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 852 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if ((nextAlt + alternatives->size() - startAlt) % alternatives->size() <= startDistance)
															#line 2775 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 853 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					useAlt = (nextAlt + alternatives->size() - 1) % alternatives->size();
															#line 2779 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
			}
															#line 855 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			stream = &alternatives->get(useAlt, channel);
															#line 856 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			distance = alternatives->getDistance(useAlt);
															#line 857 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!IFailureMonitor::failureMonitor().getState(stream->getEndpoint()).failed && (!firstRequestEndpoint.present() || stream->getEndpoint().token.first() != firstRequestEndpoint.get()))
															#line 2788 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
				break;
			}
															#line 860 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			nextAlt = (nextAlt + 1) % alternatives->size();
															#line 861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt == startAlt)
															#line 2796 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 862 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				triedAllOptions = TriedAllOptions::True;
															#line 2800 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 863 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			stream = nullptr;
															#line 864 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			distance = LBDistance::DISTANT;
															#line 2806 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 867 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!stream && !firstRequestData.isValid())
															#line 2810 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 870 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			std::vector<Future<Void>> ok(alternatives->size());
															#line 871 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			for(int i = 0;i < ok.size();i++) {
															#line 872 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ok[i] = IFailureMonitor::failureMonitor().onStateEqual(alternatives->get(i, channel).getEndpoint(), FailureStatus(false));
															#line 2818 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 876 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Future<Void> okFuture = quorum(ok, 1);
															#line 878 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!alternatives->alwaysFresh())
															#line 2824 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 880 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (now() - g_network->networkInfo.newestAlternativesFailure > 1 || deterministicRandom()->random01() < 0.01)
															#line 2828 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 882 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					TraceEvent("AllAlternativesFailed").detail("Alternatives", alternatives->description());
															#line 2832 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
															#line 884 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				StrictFuture<Void> __when_expr_0 = allAlternativesFailedDelay(okFuture);
															#line 884 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2838 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<LoadBalanceActor*>(this)->actor_wait_state = 1;
															#line 884 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 0, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 2843 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				StrictFuture<Void> __when_expr_1 = okFuture;
															#line 886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2852 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<LoadBalanceActor*>(this)->actor_wait_state = 2;
															#line 886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 1, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 2857 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				loopDepth = 0;
			}
		}
		else
		{
															#line 890 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!stream)
															#line 2865 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 892 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				StrictFuture<Void> __when_expr_2 = success(firstRequestData.response);
															#line 892 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2871 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
				static_cast<LoadBalanceActor*>(this)->actor_wait_state = 3;
															#line 892 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 2, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 2876 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 903 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (firstRequestData.isValid())
															#line 2883 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 905 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (distance == LBDistance::DISTANT)
															#line 2887 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 906 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						TraceEvent("LBDistant2nd") .suppressFor(0.1) .detail("Distance", (int)distance) .detail("BackOff", backoff) .detail("TriedAllOptions", triedAllOptions) .detail("Alternatives", alternatives->description()) .detail("Token", stream->getEndpoint().token) .detail("Total", alternatives->size()) .detail("Best", alternatives->countBest()) .detail("Attempts", numAttempts);
															#line 2891 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
															#line 917 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					secondRequestData.startRequest(backoff, triedAllOptions, stream, request, model, alternatives, channel);
															#line 919 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					firstRequestSuccessful = false;
															#line 920 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					secondRequestSuccessful = false;
															#line 922 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					;
															#line 2901 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					loopDepth = a_body1loopBody1loopHead1(loopDepth);
				}
				else
				{
															#line 957 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					if (distance == LBDistance::DISTANT)
															#line 2908 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					{
															#line 958 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
						TraceEvent("LBDistant") .suppressFor(0.1) .detail("Distance", (int)distance) .detail("BackOff", backoff) .detail("TriedAllOptions", triedAllOptions) .detail("Alternatives", alternatives->description()) .detail("Token", stream->getEndpoint().token) .detail("Total", alternatives->size()) .detail("Best", alternatives->countBest()) .detail("Attempts", numAttempts);
															#line 2912 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					}
															#line 969 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					firstRequestData.startRequest(backoff, triedAllOptions, stream, request, model, alternatives, channel);
															#line 970 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					firstRequestEndpoint = stream->getEndpoint().token.first();
															#line 972 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					;
															#line 2920 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
					loopDepth = a_body1loopBody1loopHead2(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1013 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		nextAlt = (nextAlt + 1) % alternatives->size();
															#line 1014 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (nextAlt == startAlt)
															#line 2934 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1015 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			triedAllOptions = TriedAllOptions::True;
															#line 2938 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1016 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		resetReply(request, taskID);
															#line 1017 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		secondDelay = Never();
															#line 2944 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
															#line 889 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		numAttempts = 0;
															#line 2953 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(Void const& _,int loopDepth) 
	{
															#line 893 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3142 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_3 = firstRequestData.maybeDoReplicaComparison(request, model, alternatives, channel, requiredReplicas);
															#line 895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3148 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont17when1(__when_expr_3.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 4;
															#line 895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 3, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3153 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont17cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont17(Void && _,int loopDepth) 
	{
															#line 893 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3167 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_3 = firstRequestData.maybeDoReplicaComparison(request, model, alternatives, channel, requiredReplicas);
															#line 895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3173 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont17when1(__when_expr_3.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 4;
															#line 895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 3, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3178 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont17cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont17cont1(int loopDepth) 
	{
															#line 902 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		firstRequestEndpoint = Optional<uint64_t>();
															#line 3267 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17cont2(Void const& _,int loopDepth) 
	{
															#line 898 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(firstRequestData.response.isReady());
															#line 899 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(firstRequestData.response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3278 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(firstRequestData.response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont17cont2(Void && _,int loopDepth) 
	{
															#line 898 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(firstRequestData.response.isReady());
															#line 899 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(firstRequestData.response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3292 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(firstRequestData.response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont17when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont17when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont17when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont18(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19(int loopDepth) 
	{
															#line 940 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestSuccessful || secondRequestSuccessful)
															#line 3385 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 942 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			requestData = firstRequestSuccessful ? &firstRequestData : &secondRequestData;
															#line 944 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_6 = requestData->maybeDoReplicaComparison(request, model, alternatives, channel, requiredReplicas);
															#line 944 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3393 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont19when1(__when_expr_6.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 6;
															#line 944 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 6, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3398 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont19cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 923 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_4 = success(firstRequestData.response.isValid() ? firstRequestData.response : Never());
															#line 922 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
															#line 931 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_5 = success(secondRequestData.response);
															#line 3425 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when2(__when_expr_5.get(), loopDepth); };
		static_cast<LoadBalanceActor*>(this)->actor_wait_state = 5;
															#line 923 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 4, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 931 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 5, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3432 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont19(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3460 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 925 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			firstRequestSuccessful = true;
															#line 3464 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 929 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		firstRequestEndpoint = Optional<uint64_t>();
															#line 3469 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 925 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			firstRequestSuccessful = true;
															#line 3482 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 929 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		firstRequestEndpoint = Optional<uint64_t>();
															#line 3487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 932 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (secondRequestData.checkAndProcessResult(atMostOnce))
															#line 3496 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 933 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			secondRequestSuccessful = true;
															#line 3500 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 932 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (secondRequestData.checkAndProcessResult(atMostOnce))
															#line 3510 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 933 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			secondRequestSuccessful = true;
															#line 3514 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 4, Void >::remove();
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont19cont1(int loopDepth) 
	{
															#line 950 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (++numAttempts >= alternatives->size())
															#line 3645 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 951 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = std::min( FLOW_KNOBS->LOAD_BALANCE_MAX_BACKOFF, std::max(FLOW_KNOBS->LOAD_BALANCE_START_BACKOFF, backoff * FLOW_KNOBS->LOAD_BALANCE_BACKOFF_RATE));
															#line 3649 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19cont2(Void const& _,int loopDepth) 
	{
															#line 946 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(requestData->response.isReady());
															#line 947 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(requestData->response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3661 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(requestData->response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont19cont2(Void && _,int loopDepth) 
	{
															#line 946 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(requestData->response.isReady());
															#line 947 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(requestData->response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3675 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(requestData->response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont19when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont19when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont21(int loopDepth) 
	{
															#line 1006 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (++numAttempts >= alternatives->size())
															#line 3762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1007 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = std::min( FLOW_KNOBS->LOAD_BALANCE_MAX_BACKOFF, std::max(FLOW_KNOBS->LOAD_BALANCE_START_BACKOFF, backoff * FLOW_KNOBS->LOAD_BALANCE_BACKOFF_RATE));
															#line 3766 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody2(int loopDepth) 
	{
															#line 974 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_7 = success(firstRequestData.response);
															#line 973 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3785 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody2when1(__when_expr_7.get(), loopDepth); };
															#line 995 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<Void> __when_expr_8 = secondDelay;
															#line 3789 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody2when2(__when_expr_8.get(), loopDepth); };
		static_cast<LoadBalanceActor*>(this)->actor_wait_state = 7;
															#line 974 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 7, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 995 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 8, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3796 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break2(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont21(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody2cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1(Void const& _,int loopDepth) 
	{
															#line 975 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (model)
															#line 3824 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 976 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondMultiplier = std::max(model->secondMultiplier - FLOW_KNOBS->SECOND_REQUEST_MULTIPLIER_DECAY, 1.0);
															#line 978 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondBudget = std::min(model->secondBudget + FLOW_KNOBS->SECOND_REQUEST_BUDGET_GROWTH, FLOW_KNOBS->SECOND_REQUEST_MAX_BUDGET);
															#line 3830 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3834 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_9 = firstRequestData.maybeDoReplicaComparison( request, model, alternatives, channel, requiredReplicas);
															#line 985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3840 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody2when1when1(__when_expr_9.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 8;
															#line 985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 9, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3845 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody2when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1(Void && _,int loopDepth) 
	{
															#line 975 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (model)
															#line 3859 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 976 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondMultiplier = std::max(model->secondMultiplier - FLOW_KNOBS->SECOND_REQUEST_MULTIPLIER_DECAY, 1.0);
															#line 978 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondBudget = std::min(model->secondBudget + FLOW_KNOBS->SECOND_REQUEST_BUDGET_GROWTH, FLOW_KNOBS->SECOND_REQUEST_MAX_BUDGET);
															#line 3865 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (firstRequestData.checkAndProcessResult(atMostOnce))
															#line 3869 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_9 = firstRequestData.maybeDoReplicaComparison( request, model, alternatives, channel, requiredReplicas);
															#line 985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<LoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3875 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody2when1when1(__when_expr_9.get(), loopDepth); };
			static_cast<LoadBalanceActor*>(this)->actor_wait_state = 8;
															#line 985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< LoadBalanceActor, 9, Void >*>(static_cast<LoadBalanceActor*>(this)));
															#line 3880 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody2when1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when2(Void const& _,int loopDepth) 
	{
															#line 996 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		secondDelay = Never();
															#line 997 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (model && model->secondBudget >= 1.0)
															#line 3896 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 998 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondMultiplier += FLOW_KNOBS->SECOND_REQUEST_MULTIPLIER_GROWTH;
															#line 999 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondBudget -= 1.0;
															#line 3902 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			return a_body1loopBody1break2(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when2(Void && _,int loopDepth) 
	{
															#line 996 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		secondDelay = Never();
															#line 997 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (model && model->secondBudget >= 1.0)
															#line 3915 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 998 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondMultiplier += FLOW_KNOBS->SECOND_REQUEST_MULTIPLIER_GROWTH;
															#line 999 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			model->secondBudget -= 1.0;
															#line 3921 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			return a_body1loopBody1break2(loopDepth==0?0:loopDepth-1); // break
		}
		loopDepth = a_body1loopBody1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 7, Void >::remove();
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 8, Void >::remove();

	}
	int a_body1loopBody1loopBody2when1cont1(int loopDepth) 
	{
															#line 992 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		firstRequestEndpoint = Optional<uint64_t>();
															#line 3939 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		return a_body1loopBody1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1cont3(Void const& _,int loopDepth) 
	{
															#line 988 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(firstRequestData.response.isReady());
															#line 989 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(firstRequestData.response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3950 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(firstRequestData.response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1cont3(Void && _,int loopDepth) 
	{
															#line 988 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		ASSERT(firstRequestData.response.isReady());
															#line 989 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!static_cast<LoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(firstRequestData.response.get().get()); this->~LoadBalanceActorState(); static_cast<LoadBalanceActor*>(this)->destroy(); return 0; }
															#line 3964 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		new (&static_cast<LoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(firstRequestData.response.get().get());
		this->~LoadBalanceActorState();
		static_cast<LoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody2when1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody2when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody2when1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<LoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<LoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<LoadBalanceActor*>(this)->ActorCallback< LoadBalanceActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody2when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1loopBody2when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody2when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< LoadBalanceActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1loopBody2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< LoadBalanceActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), 8);

	}
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Reference<MultiInterface<Multi>> alternatives;
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Request, P> Interface::* channel;
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Request request;
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TaskPriority taskID;
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	AtMostOnce atMostOnce;
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	QueueModel* model;
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	bool compareReplicas;
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int requiredReplicas;
															#line 702 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestData<Request, Interface, Multi, P> firstRequestData;
															#line 703 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestData<Request, Interface, Multi, P> secondRequestData;
															#line 705 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Optional<uint64_t> firstRequestEndpoint;
															#line 706 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Future<Void> secondDelay;
															#line 708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Promise<Void> requestFinished;
															#line 709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double startTime;
															#line 711 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TriedAllOptions triedAllOptions;
															#line 719 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int bestAlt;
															#line 720 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int nextAlt;
															#line 817 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int startAlt;
															#line 818 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int startDistance;
															#line 820 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int numAttempts;
															#line 821 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double backoff;
															#line 846 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Request, P> const* stream;
															#line 847 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	LBDistance::Type distance;
															#line 919 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	bool firstRequestSuccessful;
															#line 920 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	bool secondRequestSuccessful;
															#line 942 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestData<Request, Interface, Multi, P>* requestData;
															#line 4213 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via loadBalance()
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P>
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class LoadBalanceActor final : public Actor<REPLY_TYPE(Request)>, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 0, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 1, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 2, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 3, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 4, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 5, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 6, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 7, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 9, Void >, public ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 8, Void >, public FastAllocated<LoadBalanceActor<Interface, Request, Multi, P>>, public LoadBalanceActorState<Interface, Request, Multi, P, LoadBalanceActor<Interface, Request, Multi, P>> {
															#line 4220 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<LoadBalanceActor<Interface, Request, Multi, P>>::operator new;
	using FastAllocated<LoadBalanceActor<Interface, Request, Multi, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3397030529716291840UL, 16398609180881910016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<REPLY_TYPE(Request)>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 0, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 1, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 2, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 3, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 4, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 5, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 6, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 7, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 9, Void >;
friend struct ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 8, Void >;
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	LoadBalanceActor(Reference<MultiInterface<Multi>> const& alternatives,RequestStream<Request, P> Interface::* const& channel,Request const& request = Request(),TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint,AtMostOnce const& atMostOnce = AtMostOnce::False,QueueModel* const& model = nullptr,bool const& compareReplicas = false,int const& requiredReplicas = 0) 
															#line 4246 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<REPLY_TYPE(Request)>(),
		   LoadBalanceActorState<Interface, Request, Multi, P, LoadBalanceActor<Interface, Request, Multi, P>>(alternatives, channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadBalance", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12051063900488922880UL, 14234974990573568000UL);
		ActorExecutionContextHelper __helper(static_cast<LoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadBalance");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadBalance", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 6, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 7, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< LoadBalanceActor<Interface, Request, Multi, P>, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P>
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<REPLY_TYPE(Request)> loadBalance( Reference<MultiInterface<Multi>> const& alternatives, RequestStream<Request, P> Interface::* const& channel, Request const& request = Request(), TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint, AtMostOnce const& atMostOnce = AtMostOnce::False, QueueModel* const& model = nullptr, bool const& compareReplicas = false, int const& requiredReplicas = 0 ) {
															#line 690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<REPLY_TYPE(Request)>(new LoadBalanceActor<Interface, Request, Multi, P>(alternatives, channel, request, taskID, atMostOnce, model, compareReplicas, requiredReplicas));
															#line 4288 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 1020 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

// Subclasses must initialize all members in their default constructors
// Subclasses must serialize all members
struct BasicLoadBalancedReply {
	int processBusyTime;
	BasicLoadBalancedReply() : processBusyTime(0) {}
};

Optional<BasicLoadBalancedReply> getBasicLoadBalancedReply(const BasicLoadBalancedReply* reply);
Optional<BasicLoadBalancedReply> getBasicLoadBalancedReply(const void*);

// A simpler version of LoadBalance that does not send second requests where the list of servers are always fresh
//
// If |alternativeChosen| is not null, then atMostOnce must be True, and if the returned future completes successfully
// then *alternativeChosen will be the alternative to which the message was sent. *alternativeChosen must outlive the
// returned future.
															#line 4308 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
namespace {
// This generated class is to be used only via basicLoadBalance()
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P, class BasicLoadBalanceActor>
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class BasicLoadBalanceActorState {
															#line 4315 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	BasicLoadBalanceActorState(Reference<ModelInterface<Multi>> const& alternatives,RequestStream<Request, P> Interface::* const& channel,Request const& request = Request(),TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint,AtMostOnce const& atMostOnce = AtMostOnce::False,int* const& alternativeChosen = nullptr) 
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		 : alternatives(alternatives),
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   channel(channel),
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   request(request),
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   taskID(taskID),
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   atMostOnce(atMostOnce),
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		   alternativeChosen(alternativeChosen)
															#line 4332 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
	{
		fdb_probe_actor_create("basicLoadBalance", reinterpret_cast<unsigned long>(this));

	}
	~BasicLoadBalanceActorState() 
	{
		fdb_probe_actor_destroy("basicLoadBalance", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1043 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT(alternativeChosen == nullptr || atMostOnce == AtMostOnce::True);
															#line 1044 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			setReplyPriority(request, taskID);
															#line 1045 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!alternatives)
															#line 4351 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1046 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				this->~BasicLoadBalanceActorState();
															#line 4355 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				static_cast<BasicLoadBalanceActor*>(this)->sendAndDelPromiseRef(Never());
				return 0;
			}
															#line 1048 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			ASSERT(alternatives->size() && alternatives->alwaysFresh());
															#line 1050 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			bestAlt = alternatives->getBest();
															#line 1051 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			nextAlt = deterministicRandom()->randomInt(0, std::max(alternatives->size() - 1, 1));
															#line 1052 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt >= bestAlt)
															#line 4367 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1053 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				nextAlt++;
															#line 4371 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1055 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			startAlt = nextAlt;
															#line 1056 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			startDistance = (bestAlt + alternatives->size() - startAlt) % alternatives->size();
															#line 1058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			numAttempts = 0;
															#line 1059 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = 0;
															#line 1060 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			useAlt = int();
															#line 1061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			;
															#line 4385 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BasicLoadBalanceActorState();
		static_cast<BasicLoadBalanceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1063 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		stream = nullptr;
															#line 1064 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		for(int alternativeNum = 0;alternativeNum < alternatives->size();alternativeNum++) {
															#line 1065 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			useAlt = nextAlt;
															#line 1066 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (nextAlt == startAlt)
															#line 4421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1067 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				useAlt = bestAlt;
															#line 4425 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
			else
			{
															#line 1068 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if ((nextAlt + alternatives->size() - startAlt) % alternatives->size() <= startDistance)
															#line 4431 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				{
															#line 1069 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
					useAlt = (nextAlt + alternatives->size() - 1) % alternatives->size();
															#line 4435 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				}
			}
															#line 1071 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			stream = &alternatives->get(useAlt, channel);
															#line 1072 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (alternativeChosen != nullptr)
															#line 4442 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1073 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				*alternativeChosen = useAlt;
															#line 4446 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1075 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!IFailureMonitor::failureMonitor().getState(stream->getEndpoint()).failed)
															#line 4450 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
				break;
			}
															#line 1077 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			nextAlt = (nextAlt + 1) % alternatives->size();
															#line 1078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			stream = nullptr;
															#line 4458 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1081 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (!stream)
															#line 4462 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1084 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			std::vector<Future<Void>> ok(alternatives->size());
															#line 1085 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			for(int i = 0;i < ok.size();i++) {
															#line 1086 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				ok[i] = IFailureMonitor::failureMonitor().onStateEqual(alternatives->get(i, channel).getEndpoint(), FailureStatus(false));
															#line 4470 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			StrictFuture<Void> __when_expr_0 = quorum(ok, 1);
															#line 1089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4476 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 1;
															#line 1089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BasicLoadBalanceActor, 0, Void >*>(static_cast<BasicLoadBalanceActor*>(this)));
															#line 4481 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 1093 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (backoff > 0.0)
															#line 4488 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1094 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				StrictFuture<Void> __when_expr_1 = delay(backoff);
															#line 1094 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4494 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 2;
															#line 1094 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BasicLoadBalanceActor, 1, Void >*>(static_cast<BasicLoadBalanceActor*>(this)));
															#line 4499 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont11(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1124 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		nextAlt = (nextAlt + 1) % alternatives->size();
															#line 1125 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		resetReply(request, taskID);
															#line 4516 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 1091 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		numAttempts = 0;
															#line 4525 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 1091 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		numAttempts = 0;
															#line 4534 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<BasicLoadBalanceActor*>(this)->ActorCallback< BasicLoadBalanceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BasicLoadBalanceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
															#line 1097 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		StrictFuture<ErrorOr<REPLY_TYPE(Request)>> __when_expr_2 = stream->tryGetReply(request);
															#line 1097 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4620 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont11when1(__when_expr_2.get(), loopDepth); };
		static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 3;
															#line 1097 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >*>(static_cast<BasicLoadBalanceActor*>(this)));
															#line 4625 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<BasicLoadBalanceActor*>(this)->ActorCallback< BasicLoadBalanceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BasicLoadBalanceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont11cont1(ErrorOr<REPLY_TYPE(Request)> const& result,int loopDepth) 
	{
															#line 1099 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (result.present())
															#line 4721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Optional<BasicLoadBalancedReply> loadBalancedReply = getBasicLoadBalancedReply(&result.get());
															#line 1101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (loadBalancedReply.present())
															#line 4727 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				alternatives->updateRecent(useAlt, loadBalancedReply.get().processBusyTime);
															#line 4731 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!static_cast<BasicLoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(result.get()); this->~BasicLoadBalanceActorState(); static_cast<BasicLoadBalanceActor*>(this)->destroy(); return 0; }
															#line 4735 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			new (&static_cast<BasicLoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(result.get());
			this->~BasicLoadBalanceActorState();
			static_cast<BasicLoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1108 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (result.getError().code() != error_code_broken_promise && result.getError().code() != error_code_request_maybe_delivered)
															#line 4743 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(result.getError(), std::max(0, loopDepth - 1));
															#line 4747 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1113 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (atMostOnce)
															#line 4751 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1114 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(request_maybe_delivered(), std::max(0, loopDepth - 1));
															#line 4755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1117 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (++numAttempts >= alternatives->size())
															#line 4759 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1118 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = std::min( FLOW_KNOBS->LOAD_BALANCE_MAX_BACKOFF, std::max(FLOW_KNOBS->LOAD_BALANCE_START_BACKOFF, backoff * FLOW_KNOBS->LOAD_BALANCE_BACKOFF_RATE));
															#line 4763 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont1(ErrorOr<REPLY_TYPE(Request)> && result,int loopDepth) 
	{
															#line 1099 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (result.present())
															#line 4773 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			Optional<BasicLoadBalancedReply> loadBalancedReply = getBasicLoadBalancedReply(&result.get());
															#line 1101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (loadBalancedReply.present())
															#line 4779 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			{
															#line 1102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
				alternatives->updateRecent(useAlt, loadBalancedReply.get().processBusyTime);
															#line 4783 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			}
															#line 1105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			if (!static_cast<BasicLoadBalanceActor*>(this)->SAV<REPLY_TYPE(Request)>::futures) { (void)(result.get()); this->~BasicLoadBalanceActorState(); static_cast<BasicLoadBalanceActor*>(this)->destroy(); return 0; }
															#line 4787 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
			new (&static_cast<BasicLoadBalanceActor*>(this)->SAV< REPLY_TYPE(Request) >::value()) REPLY_TYPE(Request)(result.get());
			this->~BasicLoadBalanceActorState();
			static_cast<BasicLoadBalanceActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1108 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (result.getError().code() != error_code_broken_promise && result.getError().code() != error_code_request_maybe_delivered)
															#line 4795 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(result.getError(), std::max(0, loopDepth - 1));
															#line 4799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1113 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (atMostOnce)
															#line 4803 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1114 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			return a_body1Catch1(request_maybe_delivered(), std::max(0, loopDepth - 1));
															#line 4807 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
															#line 1117 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
		if (++numAttempts >= alternatives->size())
															#line 4811 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		{
															#line 1118 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
			backoff = std::min( FLOW_KNOBS->LOAD_BALANCE_MAX_BACKOFF, std::max(FLOW_KNOBS->LOAD_BALANCE_START_BACKOFF, backoff * FLOW_KNOBS->LOAD_BALANCE_BACKOFF_RATE));
															#line 4815 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(ErrorOr<REPLY_TYPE(Request)> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(ErrorOr<REPLY_TYPE(Request)> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state > 0) static_cast<BasicLoadBalanceActor*>(this)->actor_wait_state = 0;
		static_cast<BasicLoadBalanceActor*>(this)->ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >::remove();

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >*,ErrorOr<REPLY_TYPE(Request)> const& value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >*,ErrorOr<REPLY_TYPE(Request)> && value) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BasicLoadBalanceActor, 2, ErrorOr<REPLY_TYPE(Request)> >*,Error err) 
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Reference<ModelInterface<Multi>> alternatives;
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Request, P> Interface::* channel;
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	Request request;
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	TaskPriority taskID;
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	AtMostOnce atMostOnce;
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int* alternativeChosen;
															#line 1050 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int bestAlt;
															#line 1051 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int nextAlt;
															#line 1055 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int startAlt;
															#line 1056 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int startDistance;
															#line 1058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int numAttempts;
															#line 1059 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	double backoff;
															#line 1060 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	int useAlt;
															#line 1063 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	RequestStream<Request, P> const* stream;
															#line 4924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
};
// This generated class is to be used only via basicLoadBalance()
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P>
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
class BasicLoadBalanceActor final : public Actor<REPLY_TYPE(Request)>, public ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 0, Void >, public ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 1, Void >, public ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 2, ErrorOr<REPLY_TYPE(Request)> >, public FastAllocated<BasicLoadBalanceActor<Interface, Request, Multi, P>>, public BasicLoadBalanceActorState<Interface, Request, Multi, P, BasicLoadBalanceActor<Interface, Request, Multi, P>> {
															#line 4931 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
public:
	using FastAllocated<BasicLoadBalanceActor<Interface, Request, Multi, P>>::operator new;
	using FastAllocated<BasicLoadBalanceActor<Interface, Request, Multi, P>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10627592456018806016UL, 16179949483958509568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<REPLY_TYPE(Request)>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 0, Void >;
friend struct ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 1, Void >;
friend struct ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 2, ErrorOr<REPLY_TYPE(Request)> >;
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	BasicLoadBalanceActor(Reference<ModelInterface<Multi>> const& alternatives,RequestStream<Request, P> Interface::* const& channel,Request const& request = Request(),TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint,AtMostOnce const& atMostOnce = AtMostOnce::False,int* const& alternativeChosen = nullptr) 
															#line 4950 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
		 : Actor<REPLY_TYPE(Request)>(),
		   BasicLoadBalanceActorState<Interface, Request, Multi, P, BasicLoadBalanceActor<Interface, Request, Multi, P>>(alternatives, channel, request, taskID, atMostOnce, alternativeChosen),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("basicLoadBalance", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5600668509463549440UL, 16700316307983848448UL);
		ActorExecutionContextHelper __helper(static_cast<BasicLoadBalanceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("basicLoadBalance");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("basicLoadBalance", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BasicLoadBalanceActor<Interface, Request, Multi, P>, 2, ErrorOr<REPLY_TYPE(Request)> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
template <class Interface, class Request, class Multi, bool P>
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
[[nodiscard]] Future<REPLY_TYPE(Request)> basicLoadBalance( Reference<ModelInterface<Multi>> const& alternatives, RequestStream<Request, P> Interface::* const& channel, Request const& request = Request(), TaskPriority const& taskID = TaskPriority::DefaultPromiseEndpoint, AtMostOnce const& atMostOnce = AtMostOnce::False, int* const& alternativeChosen = nullptr ) {
															#line 1036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"
	return Future<REPLY_TYPE(Request)>(new BasicLoadBalanceActor<Interface, Request, Multi, P>(alternatives, channel, request, taskID, atMostOnce, alternativeChosen));
															#line 4987 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbrpc/include/fdbrpc/LoadBalance.actor.g.h"
}

#line 1128 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbrpc/include/fdbrpc/LoadBalance.actor.h"

#include "flow/unactorcompiler.h"

#endif
