#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
/*
 * AsyncFileS3BlobStore.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(FDBRPC_ASYNCFILEBLOBSTORE_ACTOR_G_H)
#define FDBRPC_ASYNCFILEBLOBSTORE_ACTOR_G_H
#include "fdbclient/AsyncFileS3BlobStore.actor.g.h"
#elif !defined(FDBRPC_ASYNCFILES3BLOBSTORE_ACTOR_H)
#define FDBRPC_ASYNCFILES3BLOBSTORE_ACTOR_H

#include <sstream>
#include <time.h>

#include "flow/IAsyncFile.h"
#include "flow/serialize.h"
#include "flow/Net2Packet.h"
#include "flow/IRateControl.h"
#include "fdbclient/S3BlobStore.h"
#include "md5/md5.h"
#include "libb64/encode.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 45 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
namespace {
// This generated class is to be used only via joinErrorGroup()
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
template <typename T, class JoinErrorGroupActor>
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class JoinErrorGroupActorState {
															#line 52 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	JoinErrorGroupActorState(Future<T> const& f,Promise<Void> const& p) 
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		 : f(f),
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		   p(p)
															#line 61 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
	{
		fdb_probe_actor_create("joinErrorGroup", reinterpret_cast<unsigned long>(this));

	}
	~JoinErrorGroupActorState() 
	{
		fdb_probe_actor_destroy("joinErrorGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 46 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				StrictFuture<Void> __when_expr_0 = success(f) || p.getFuture();
															#line 46 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				if (static_cast<JoinErrorGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 79 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<JoinErrorGroupActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< JoinErrorGroupActor, 0, Void >*>(static_cast<JoinErrorGroupActor*>(this)));
															#line 84 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~JoinErrorGroupActorState();
		static_cast<JoinErrorGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 49 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			if (p.canBeSet())
															#line 114 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			{
															#line 50 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				p.sendError(e);
															#line 118 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			}
															#line 51 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 122 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<JoinErrorGroupActor*>(this)->SAV<T>::futures) { (void)(f.get()); this->~JoinErrorGroupActorState(); static_cast<JoinErrorGroupActor*>(this)->destroy(); return 0; }
															#line 136 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<JoinErrorGroupActor*>(this)->SAV< T >::value()) T(f.get());
		this->~JoinErrorGroupActorState();
		static_cast<JoinErrorGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<JoinErrorGroupActor*>(this)->SAV<T>::futures) { (void)(f.get()); this->~JoinErrorGroupActorState(); static_cast<JoinErrorGroupActor*>(this)->destroy(); return 0; }
															#line 148 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<JoinErrorGroupActor*>(this)->SAV< T >::value()) T(f.get());
		this->~JoinErrorGroupActorState();
		static_cast<JoinErrorGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<JoinErrorGroupActor*>(this)->actor_wait_state > 0) static_cast<JoinErrorGroupActor*>(this)->actor_wait_state = 0;
		static_cast<JoinErrorGroupActor*>(this)->ActorCallback< JoinErrorGroupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< JoinErrorGroupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("joinErrorGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinErrorGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinErrorGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< JoinErrorGroupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("joinErrorGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<JoinErrorGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinErrorGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< JoinErrorGroupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("joinErrorGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<JoinErrorGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("joinErrorGroup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	Future<T> f;
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	Promise<Void> p;
															#line 235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
};
// This generated class is to be used only via joinErrorGroup()
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
template <typename T>
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class JoinErrorGroupActor final : public Actor<T>, public ActorCallback< JoinErrorGroupActor<T>, 0, Void >, public FastAllocated<JoinErrorGroupActor<T>>, public JoinErrorGroupActorState<T, JoinErrorGroupActor<T>> {
															#line 242 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
	using FastAllocated<JoinErrorGroupActor<T>>::operator new;
	using FastAllocated<JoinErrorGroupActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2061701403842938368UL, 10098519763936157952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< JoinErrorGroupActor<T>, 0, Void >;
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	JoinErrorGroupActor(Future<T> const& f,Promise<Void> const& p) 
															#line 259 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		 : Actor<T>(),
		   JoinErrorGroupActorState<T, JoinErrorGroupActor<T>>(f, p),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("joinErrorGroup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7598614670685095168UL, 15195604202272775424UL);
		ActorExecutionContextHelper __helper(static_cast<JoinErrorGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("joinErrorGroup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("joinErrorGroup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< JoinErrorGroupActor<T>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
template <typename T>
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
[[nodiscard]] static Future<T> joinErrorGroup( Future<T> const& f, Promise<Void> const& p ) {
															#line 43 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	return Future<T>(new JoinErrorGroupActor<T>(f, p));
															#line 294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
}

#line 54 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
// This class represents a write-only file that lives in an S3-style blob store.  It writes using the REST API,
// using multi-part upload and beginning to transfer each part as soon as it is large enough.
// All write operations file operations must be sequential and contiguous.
// Limits on part sizes, upload speed, and concurrent uploads are taken from the S3BlobStoreEndpoint being used.
class AsyncFileS3BlobStoreWrite final : public IAsyncFile, public ReferenceCounted<AsyncFileS3BlobStoreWrite> {
public:
	void addref() override { ReferenceCounted<AsyncFileS3BlobStoreWrite>::addref(); }
	void delref() override { ReferenceCounted<AsyncFileS3BlobStoreWrite>::delref(); }

	virtual StringRef getClassName() override { return "AsyncFileS3BlobStoreWrite"_sr; }

	struct Part : ReferenceCounted<Part> {
		Part(int n, int minSize)
		  : number(n), writer(content.getWriteBuffer(minSize), nullptr, Unversioned()), length(0) {
			etag = std::string();
			::MD5_Init(&content_md5_buf);
		}
		virtual ~Part() { etag.cancel(); }
		Future<std::string> etag;
		int number;
		UnsentPacketQueue content;
		std::string md5string;
		PacketWriter writer;
		int length;
		void write(const uint8_t* buf, int len) {
			writer.serializeBytes(buf, len);
			::MD5_Update(&content_md5_buf, buf, len);
			length += len;
		}
		// MD5 sum can only be finalized once, further calls will do nothing so new writes will be reflected in the sum.
		void finalizeMD5() {
			if (md5string.empty()) {
				std::string sumBytes;
				sumBytes.resize(16);
				::MD5_Final((unsigned char*)sumBytes.data(), &content_md5_buf);
				md5string = base64::encoder::from_string(sumBytes);
				md5string.resize(md5string.size() - 1);
			}
		}

	private:
		MD5_CTX content_md5_buf;
	};

	Future<int> read(void* data, int length, int64_t offset) override { throw file_not_readable(); }

																#line 344 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
// This generated class is to be used only via write_impl()
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
template <class Write_implActor>
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class Write_implActorState {
															#line 350 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	Write_implActorState(Reference<AsyncFileS3BlobStoreWrite> const& f,const uint8_t* const& data,int const& length) 
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		 : f(f),
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		   data(data),
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		   length(length),
															#line 101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		   p(f->m_parts.back().getPtr())
															#line 363 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
	{
		fdb_probe_actor_create("write_impl", reinterpret_cast<unsigned long>(this));

	}
	~Write_implActorState() 
	{
		fdb_probe_actor_destroy("write_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			;
															#line 378 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Write_implActorState();
		static_cast<Write_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 118 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		p->write((const uint8_t*)data, length);
															#line 119 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<Write_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Write_implActorState(); static_cast<Write_implActor*>(this)->destroy(); return 0; }
															#line 403 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<Write_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Write_implActorState();
		static_cast<Write_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 104 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!(p->length + length >= f->m_bstore->knobs.multipart_min_part_size))
															#line 422 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 106 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		int finishlen = f->m_bstore->knobs.multipart_min_part_size - p->length;
															#line 107 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		p->write((const uint8_t*)data, finishlen);
															#line 110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		length -= finishlen;
															#line 111 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		data = (const uint8_t*)data + finishlen;
															#line 114 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		StrictFuture<Void> __when_expr_0 = f->endCurrentPart(f.getPtr(), true);
															#line 114 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (static_cast<Write_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 438 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<Write_implActor*>(this)->actor_wait_state = 1;
															#line 114 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Write_implActor, 0, Void >*>(static_cast<Write_implActor*>(this)));
															#line 443 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		p = f->m_parts.back().getPtr();
															#line 465 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 115 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		p = f->m_parts.back().getPtr();
															#line 474 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Write_implActor*>(this)->actor_wait_state > 0) static_cast<Write_implActor*>(this)->actor_wait_state = 0;
		static_cast<Write_implActor*>(this)->ActorCallback< Write_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Write_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("write_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Write_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("write_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Write_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("write_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Write_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("write_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Write_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("write_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Write_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("write_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	Reference<AsyncFileS3BlobStoreWrite> f;
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	const uint8_t* data;
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	int length;
															#line 101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	Part* p;
															#line 562 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
};
// This generated class is to be used only via write_impl()
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class Write_implActor final : public Actor<Void>, public ActorCallback< Write_implActor, 0, Void >, public FastAllocated<Write_implActor>, public Write_implActorState<Write_implActor> {
															#line 567 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
	using FastAllocated<Write_implActor>::operator new;
	using FastAllocated<Write_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9243472465496743168UL, 2283643967144783616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Write_implActor, 0, Void >;
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	Write_implActor(Reference<AsyncFileS3BlobStoreWrite> const& f,const uint8_t* const& data,int const& length) 
															#line 584 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		 : Actor<Void>(),
		   Write_implActorState<Write_implActor>(f, data, length),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("write_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9097952400270967040UL, 7491439827751099648UL);
		ActorExecutionContextHelper __helper(static_cast<Write_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("write_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("write_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Write_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
[[nodiscard]] static Future<Void> write_impl( Reference<AsyncFileS3BlobStoreWrite> const& f, const uint8_t* const& data, int const& length ) {
															#line 100 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	return Future<Void>(new Write_implActor(f, data, length));
															#line 616 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
}

#line 121 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"

	Future<Void> write(void const* data, int length, int64_t offset) override {
		if (offset != m_cursor)
			throw non_sequential_op();
		m_cursor += length;

		return m_error.getFuture() ||
		       write_impl(Reference<AsyncFileS3BlobStoreWrite>::addRef(this), (const uint8_t*)data, length);
	}

	Future<Void> truncate(int64_t size) override {
		if (size != m_cursor)
			return non_sequential_op();
		return Void();
	}

																#line 636 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
// This generated class is to be used only via doPartUpload()
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
template <class DoPartUploadActor>
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class DoPartUploadActorState {
															#line 642 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	DoPartUploadActorState(AsyncFileS3BlobStoreWrite* const& f,Part* const& p) 
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		 : f(f),
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		   p(p)
															#line 651 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
	{
		fdb_probe_actor_create("doPartUpload", reinterpret_cast<unsigned long>(this));

	}
	~DoPartUploadActorState() 
	{
		fdb_probe_actor_destroy("doPartUpload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 138 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			p->finalizeMD5();
															#line 139 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			StrictFuture<std::string> __when_expr_0 = f->getUploadID();
															#line 139 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			if (static_cast<DoPartUploadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 670 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoPartUploadActor*>(this)->actor_wait_state = 1;
															#line 139 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoPartUploadActor, 0, std::string >*>(static_cast<DoPartUploadActor*>(this)));
															#line 675 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoPartUploadActorState();
		static_cast<DoPartUploadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::string const& upload_id,int loopDepth) 
	{
															#line 140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		StrictFuture<std::string> __when_expr_1 = f->m_bstore->uploadPart( f->m_bucket, f->m_object, upload_id, p->number, &p->content, p->length, p->md5string);
															#line 140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (static_cast<DoPartUploadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 700 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoPartUploadActor*>(this)->actor_wait_state = 2;
															#line 140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoPartUploadActor, 1, std::string >*>(static_cast<DoPartUploadActor*>(this)));
															#line 705 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::string && upload_id,int loopDepth) 
	{
															#line 140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		StrictFuture<std::string> __when_expr_1 = f->m_bstore->uploadPart( f->m_bucket, f->m_object, upload_id, p->number, &p->content, p->length, p->md5string);
															#line 140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (static_cast<DoPartUploadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 716 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoPartUploadActor*>(this)->actor_wait_state = 2;
															#line 140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoPartUploadActor, 1, std::string >*>(static_cast<DoPartUploadActor*>(this)));
															#line 721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::string const& upload_id,int loopDepth) 
	{
		loopDepth = a_body1cont1(upload_id, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && upload_id,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(upload_id), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoPartUploadActor*>(this)->actor_wait_state > 0) static_cast<DoPartUploadActor*>(this)->actor_wait_state = 0;
		static_cast<DoPartUploadActor*>(this)->ActorCallback< DoPartUploadActor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoPartUploadActor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doPartUpload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoPartUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPartUpload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoPartUploadActor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doPartUpload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoPartUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPartUpload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoPartUploadActor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doPartUpload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoPartUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPartUpload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(std::string const& etag,int loopDepth) 
	{
															#line 142 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<DoPartUploadActor*>(this)->SAV<std::string>::futures) { (void)(etag); this->~DoPartUploadActorState(); static_cast<DoPartUploadActor*>(this)->destroy(); return 0; }
															#line 805 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<DoPartUploadActor*>(this)->SAV< std::string >::value()) std::string(etag);
		this->~DoPartUploadActorState();
		static_cast<DoPartUploadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(std::string && etag,int loopDepth) 
	{
															#line 142 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<DoPartUploadActor*>(this)->SAV<std::string>::futures) { (void)(etag); this->~DoPartUploadActorState(); static_cast<DoPartUploadActor*>(this)->destroy(); return 0; }
															#line 817 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<DoPartUploadActor*>(this)->SAV< std::string >::value()) std::string(etag);
		this->~DoPartUploadActorState();
		static_cast<DoPartUploadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::string const& etag,int loopDepth) 
	{
		loopDepth = a_body1cont2(etag, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::string && etag,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(etag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoPartUploadActor*>(this)->actor_wait_state > 0) static_cast<DoPartUploadActor*>(this)->actor_wait_state = 0;
		static_cast<DoPartUploadActor*>(this)->ActorCallback< DoPartUploadActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoPartUploadActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doPartUpload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoPartUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPartUpload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoPartUploadActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doPartUpload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoPartUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPartUpload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoPartUploadActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doPartUpload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoPartUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doPartUpload", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	AsyncFileS3BlobStoreWrite* f;
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	Part* p;
															#line 904 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
};
// This generated class is to be used only via doPartUpload()
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class DoPartUploadActor final : public Actor<std::string>, public ActorCallback< DoPartUploadActor, 0, std::string >, public ActorCallback< DoPartUploadActor, 1, std::string >, public FastAllocated<DoPartUploadActor>, public DoPartUploadActorState<DoPartUploadActor> {
															#line 909 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
	using FastAllocated<DoPartUploadActor>::operator new;
	using FastAllocated<DoPartUploadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3072646214659711232UL, 5743362193283471104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoPartUploadActor, 0, std::string >;
friend struct ActorCallback< DoPartUploadActor, 1, std::string >;
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	DoPartUploadActor(AsyncFileS3BlobStoreWrite* const& f,Part* const& p) 
															#line 927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		 : Actor<std::string>(),
		   DoPartUploadActorState<DoPartUploadActor>(f, p),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doPartUpload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3798542477178304256UL, 239296174055850240UL);
		ActorExecutionContextHelper __helper(static_cast<DoPartUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doPartUpload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doPartUpload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoPartUploadActor, 0, std::string >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoPartUploadActor, 1, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
[[nodiscard]] static Future<std::string> doPartUpload( AsyncFileS3BlobStoreWrite* const& f, Part* const& p ) {
															#line 137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	return Future<std::string>(new DoPartUploadActor(f, p));
															#line 960 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
}

#line 144 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"

																#line 965 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
// This generated class is to be used only via doFinishUpload()
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
template <class DoFinishUploadActor>
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class DoFinishUploadActorState {
															#line 971 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	DoFinishUploadActorState(AsyncFileS3BlobStoreWrite* const& f) 
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		 : f(f)
															#line 978 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
	{
		fdb_probe_actor_create("doFinishUpload", reinterpret_cast<unsigned long>(this));

	}
	~DoFinishUploadActorState() 
	{
		fdb_probe_actor_destroy("doFinishUpload", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			if (f->m_parts.size() == 1)
															#line 993 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			{
															#line 148 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				Reference<Part> part = f->m_parts.back();
															#line 149 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				part->finalizeMD5();
															#line 150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				StrictFuture<Void> __when_expr_0 = f->m_bstore->writeEntireFileFromBuffer( f->m_bucket, f->m_object, &part->content, part->length, part->md5string);
															#line 150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				if (static_cast<DoFinishUploadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1003 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoFinishUploadActor*>(this)->actor_wait_state = 1;
															#line 150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoFinishUploadActor, 0, Void >*>(static_cast<DoFinishUploadActor*>(this)));
															#line 1008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoFinishUploadActorState();
		static_cast<DoFinishUploadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 156 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		StrictFuture<Void> __when_expr_1 = f->endCurrentPart(f);
															#line 156 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (static_cast<DoFinishUploadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1038 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoFinishUploadActor*>(this)->actor_wait_state = 2;
															#line 156 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoFinishUploadActor, 1, Void >*>(static_cast<DoFinishUploadActor*>(this)));
															#line 1043 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<DoFinishUploadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFinishUploadActorState(); static_cast<DoFinishUploadActor*>(this)->destroy(); return 0; }
															#line 1052 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<DoFinishUploadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoFinishUploadActorState();
		static_cast<DoFinishUploadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<DoFinishUploadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFinishUploadActorState(); static_cast<DoFinishUploadActor*>(this)->destroy(); return 0; }
															#line 1064 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<DoFinishUploadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoFinishUploadActorState();
		static_cast<DoFinishUploadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoFinishUploadActor*>(this)->actor_wait_state > 0) static_cast<DoFinishUploadActor*>(this)->actor_wait_state = 0;
		static_cast<DoFinishUploadActor*>(this)->ActorCallback< DoFinishUploadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFinishUploadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoFinishUploadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoFinishUploadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		partSet = S3BlobStoreEndpoint::MultiPartSetT();
															#line 159 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		p = std::vector<Reference<Part>>::iterator();
															#line 163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		p = f->m_parts.begin();
															#line 1155 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		partSet = S3BlobStoreEndpoint::MultiPartSetT();
															#line 159 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		p = std::vector<Reference<Part>>::iterator();
															#line 163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		p = f->m_parts.begin();
															#line 1168 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoFinishUploadActor*>(this)->actor_wait_state > 0) static_cast<DoFinishUploadActor*>(this)->actor_wait_state = 0;
		static_cast<DoFinishUploadActor*>(this)->ActorCallback< DoFinishUploadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFinishUploadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoFinishUploadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoFinishUploadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 171 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		StrictFuture<Void> __when_expr_3 = f->m_bstore->finishMultiPartUpload(f->m_bucket, f->m_object, f->m_upload_id.get(), partSet);
															#line 171 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (static_cast<DoFinishUploadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoFinishUploadActor*>(this)->actor_wait_state = 4;
															#line 171 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoFinishUploadActor, 3, Void >*>(static_cast<DoFinishUploadActor*>(this)));
															#line 1259 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!(p != f->m_parts.end()))
															#line 1275 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 164 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		StrictFuture<std::string> __when_expr_2 = (*p)->etag;
															#line 164 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (static_cast<DoFinishUploadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1283 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoFinishUploadActor*>(this)->actor_wait_state = 3;
															#line 164 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoFinishUploadActor, 2, std::string >*>(static_cast<DoFinishUploadActor*>(this)));
															#line 1288 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(std::string const& tag,int loopDepth) 
	{
															#line 165 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if ((*p)->length > 0)
															#line 1310 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		{
															#line 166 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			partSet[(*p)->number] = tag;
															#line 1314 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		}
															#line 163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		++p;
															#line 1318 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(std::string && tag,int loopDepth) 
	{
															#line 165 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if ((*p)->length > 0)
															#line 1327 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		{
															#line 166 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			partSet[(*p)->number] = tag;
															#line 1331 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		}
															#line 163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		++p;
															#line 1335 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(std::string const& tag,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(tag, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(std::string && tag,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1cont1(std::move(tag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoFinishUploadActor*>(this)->actor_wait_state > 0) static_cast<DoFinishUploadActor*>(this)->actor_wait_state = 0;
		static_cast<DoFinishUploadActor*>(this)->ActorCallback< DoFinishUploadActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoFinishUploadActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoFinishUploadActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoFinishUploadActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<DoFinishUploadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFinishUploadActorState(); static_cast<DoFinishUploadActor*>(this)->destroy(); return 0; }
															#line 1419 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<DoFinishUploadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoFinishUploadActorState();
		static_cast<DoFinishUploadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<DoFinishUploadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoFinishUploadActorState(); static_cast<DoFinishUploadActor*>(this)->destroy(); return 0; }
															#line 1431 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<DoFinishUploadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoFinishUploadActorState();
		static_cast<DoFinishUploadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoFinishUploadActor*>(this)->actor_wait_state > 0) static_cast<DoFinishUploadActor*>(this)->actor_wait_state = 0;
		static_cast<DoFinishUploadActor*>(this)->ActorCallback< DoFinishUploadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoFinishUploadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoFinishUploadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoFinishUploadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	AsyncFileS3BlobStoreWrite* f;
															#line 158 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	S3BlobStoreEndpoint::MultiPartSetT partSet;
															#line 159 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	std::vector<Reference<Part>>::iterator p;
															#line 1520 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
};
// This generated class is to be used only via doFinishUpload()
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class DoFinishUploadActor final : public Actor<Void>, public ActorCallback< DoFinishUploadActor, 0, Void >, public ActorCallback< DoFinishUploadActor, 1, Void >, public ActorCallback< DoFinishUploadActor, 2, std::string >, public ActorCallback< DoFinishUploadActor, 3, Void >, public FastAllocated<DoFinishUploadActor>, public DoFinishUploadActorState<DoFinishUploadActor> {
															#line 1525 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
	using FastAllocated<DoFinishUploadActor>::operator new;
	using FastAllocated<DoFinishUploadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3059516456178818816UL, 13603263090421571584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoFinishUploadActor, 0, Void >;
friend struct ActorCallback< DoFinishUploadActor, 1, Void >;
friend struct ActorCallback< DoFinishUploadActor, 2, std::string >;
friend struct ActorCallback< DoFinishUploadActor, 3, Void >;
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	DoFinishUploadActor(AsyncFileS3BlobStoreWrite* const& f) 
															#line 1545 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		 : Actor<Void>(),
		   DoFinishUploadActorState<DoFinishUploadActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doFinishUpload", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17184741657238247680UL, 2778250830263876352UL);
		ActorExecutionContextHelper __helper(static_cast<DoFinishUploadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doFinishUpload");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doFinishUpload", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoFinishUploadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoFinishUploadActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoFinishUploadActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoFinishUploadActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
[[nodiscard]] static Future<Void> doFinishUpload( AsyncFileS3BlobStoreWrite* const& f ) {
															#line 145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	return Future<Void>(new DoFinishUploadActor(f));
															#line 1580 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
}

#line 175 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"

	// Ready once all data has been sent AND acknowledged from the remote side
	Future<Void> sync() override {
		// Only initiate the finish operation once, and also prevent further writing.
		if (!m_finished.isValid()) {
			m_finished = doFinishUpload(this);
			m_cursor = -1; // Cause future write attempts to fail
		}

		return m_finished;
	}

	//
	// Flush can't really do what the caller would "want" for a blob store file.  The caller would probably notionally
	// want all bytes written to be at least in transit to the blob store, but that is not very feasible.  The blob
	// store has a minimum size requirement for all but the final part, and parts must be sent with a header that
	// specifies their size.  So in the case of a write buffer that does not meet the part minimum size the part could
	// be sent but then if there is any more data written then that part needs to be sent again in its entirety.  So a
	// client that calls flush often could generate far more blob store write traffic than they intend to.
	Future<Void> flush() override { return Void(); }

	Future<int64_t> size() const override { return m_cursor; }

	Future<Void> readZeroCopy(void** data, int* length, int64_t offset) override {
		TraceEvent(SevError, "ReadZeroCopyNotSupported").detail("FileType", "S3BlobStoreWrite");
		return platform_error();
	}
	void releaseZeroCopy(void* data, int length, int64_t offset) override {}

	int64_t debugFD() const override { return -1; }

	~AsyncFileS3BlobStoreWrite() override {
		m_upload_id.cancel();
		m_finished.cancel();
		m_parts.clear(); // Contains futures
	}

	std::string getFilename() const override { return m_object; }

private:
	Reference<S3BlobStoreEndpoint> m_bstore;
	std::string m_bucket;
	std::string m_object;

	int64_t m_cursor;

	Future<std::string> m_upload_id;
	Future<Void> m_finished;
	std::vector<Reference<Part>> m_parts;
	Promise<Void> m_error;
	FlowLock m_concurrentUploads;

	// End the current part and start uploading it, but also wait for a part to finish if too many are in transit.
																#line 1637 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
// This generated class is to be used only via endCurrentPart()
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
template <class EndCurrentPartActor>
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class EndCurrentPartActorState {
															#line 1643 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	EndCurrentPartActorState(AsyncFileS3BlobStoreWrite* const& f,bool const& startNew = false) 
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		 : f(f),
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		   startNew(startNew)
															#line 1652 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
	{
		fdb_probe_actor_create("endCurrentPart", reinterpret_cast<unsigned long>(this));

	}
	~EndCurrentPartActorState() 
	{
		fdb_probe_actor_destroy("endCurrentPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 229 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			if (f->m_parts.back()->length == 0)
															#line 1667 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			{
															#line 230 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
				if (!static_cast<EndCurrentPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EndCurrentPartActorState(); static_cast<EndCurrentPartActor*>(this)->destroy(); return 0; }
															#line 1671 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
				new (&static_cast<EndCurrentPartActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~EndCurrentPartActorState();
				static_cast<EndCurrentPartActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			StrictFuture<Void> __when_expr_0 = f->m_concurrentUploads.take();
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			if (static_cast<EndCurrentPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1681 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EndCurrentPartActor*>(this)->actor_wait_state = 1;
															#line 233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EndCurrentPartActor, 0, Void >*>(static_cast<EndCurrentPartActor*>(this)));
															#line 1686 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EndCurrentPartActorState();
		static_cast<EndCurrentPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 237 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		auto releaser = std::make_shared<FlowLock::Releaser>(f->m_concurrentUploads, 1);
															#line 238 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		f->m_parts.back()->etag = holdWhile(std::move(releaser), joinErrorGroup(doPartUpload(f, f->m_parts.back().getPtr()), f->m_error));
															#line 242 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (startNew)
															#line 1713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		{
															#line 243 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			f->m_parts.push_back( Reference<Part>(new Part(f->m_parts.size() + 1, f->m_bstore->knobs.multipart_min_part_size)));
															#line 1717 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		}
															#line 246 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<EndCurrentPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EndCurrentPartActorState(); static_cast<EndCurrentPartActor*>(this)->destroy(); return 0; }
															#line 1721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<EndCurrentPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EndCurrentPartActorState();
		static_cast<EndCurrentPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 237 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		auto releaser = std::make_shared<FlowLock::Releaser>(f->m_concurrentUploads, 1);
															#line 238 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		f->m_parts.back()->etag = holdWhile(std::move(releaser), joinErrorGroup(doPartUpload(f, f->m_parts.back().getPtr()), f->m_error));
															#line 242 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (startNew)
															#line 1737 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		{
															#line 243 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
			f->m_parts.push_back( Reference<Part>(new Part(f->m_parts.size() + 1, f->m_bstore->knobs.multipart_min_part_size)));
															#line 1741 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		}
															#line 246 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
		if (!static_cast<EndCurrentPartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~EndCurrentPartActorState(); static_cast<EndCurrentPartActor*>(this)->destroy(); return 0; }
															#line 1745 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		new (&static_cast<EndCurrentPartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~EndCurrentPartActorState();
		static_cast<EndCurrentPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EndCurrentPartActor*>(this)->actor_wait_state > 0) static_cast<EndCurrentPartActor*>(this)->actor_wait_state = 0;
		static_cast<EndCurrentPartActor*>(this)->ActorCallback< EndCurrentPartActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EndCurrentPartActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("endCurrentPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndCurrentPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endCurrentPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EndCurrentPartActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("endCurrentPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EndCurrentPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endCurrentPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EndCurrentPartActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("endCurrentPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EndCurrentPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("endCurrentPart", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	AsyncFileS3BlobStoreWrite* f;
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	bool startNew;
															#line 1832 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
};
// This generated class is to be used only via endCurrentPart()
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
class EndCurrentPartActor final : public Actor<Void>, public ActorCallback< EndCurrentPartActor, 0, Void >, public FastAllocated<EndCurrentPartActor>, public EndCurrentPartActorState<EndCurrentPartActor> {
															#line 1837 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
public:
	using FastAllocated<EndCurrentPartActor>::operator new;
	using FastAllocated<EndCurrentPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1843481738204416512UL, 14117473115037542144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EndCurrentPartActor, 0, Void >;
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	EndCurrentPartActor(AsyncFileS3BlobStoreWrite* const& f,bool const& startNew = false) 
															#line 1854 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
		 : Actor<Void>(),
		   EndCurrentPartActorState<EndCurrentPartActor>(f, startNew),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("endCurrentPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3225052295399508992UL, 9462334222054050048UL);
		ActorExecutionContextHelper __helper(static_cast<EndCurrentPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("endCurrentPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("endCurrentPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EndCurrentPartActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
[[nodiscard]] static Future<Void> endCurrentPart( AsyncFileS3BlobStoreWrite* const& f, bool const& startNew = false ) {
															#line 228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"
	return Future<Void>(new EndCurrentPartActor(f, startNew));
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.g.h"
}

#line 248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/AsyncFileS3BlobStore.actor.h"

	Future<std::string> getUploadID() {
		if (!m_upload_id.isValid())
			m_upload_id = m_bstore->beginMultiPartUpload(m_bucket, m_object);
		return m_upload_id;
	}

public:
	AsyncFileS3BlobStoreWrite(Reference<S3BlobStoreEndpoint> bstore, std::string bucket, std::string object)
	  : m_bstore(bstore), m_bucket(bucket), m_object(object), m_cursor(0),
	    m_concurrentUploads(bstore->knobs.concurrent_writes_per_file) {

		// Add first part
		m_parts.push_back(makeReference<Part>(1, m_bstore->knobs.multipart_min_part_size));
	}
};

// This class represents a read-only file that lives in an S3-style blob store.  It reads using the REST API.
class AsyncFileS3BlobStoreRead final : public IAsyncFile, public ReferenceCounted<AsyncFileS3BlobStoreRead> {
public:
	void addref() override { ReferenceCounted<AsyncFileS3BlobStoreRead>::addref(); }
	void delref() override { ReferenceCounted<AsyncFileS3BlobStoreRead>::delref(); }

	virtual StringRef getClassName() override { return "AsyncFileS3BlobStoreRead"_sr; }

	Future<int> read(void* data, int length, int64_t offset) override;

	Future<Void> write(void const* data, int length, int64_t offset) override { throw file_not_writable(); }
	Future<Void> truncate(int64_t size) override { throw file_not_writable(); }

	Future<Void> sync() override { return Void(); }
	Future<Void> flush() override { return Void(); }

	Future<int64_t> size() const override;

	Future<Void> readZeroCopy(void** data, int* length, int64_t offset) override {
		TraceEvent(SevError, "ReadZeroCopyNotSupported").detail("FileType", "S3BlobStoreRead");
		return platform_error();
	}
	void releaseZeroCopy(void* data, int length, int64_t offset) override {}

	int64_t debugFD() const override { return -1; }

	std::string getFilename() const override { return m_object; }

	~AsyncFileS3BlobStoreRead() override {}

	Reference<S3BlobStoreEndpoint> m_bstore;
	std::string m_bucket;
	std::string m_object;
	mutable Future<int64_t> m_size;

	AsyncFileS3BlobStoreRead(Reference<S3BlobStoreEndpoint> bstore, std::string bucket, std::string object)
	  : m_bstore(bstore), m_bucket(bucket), m_object(object) {}
};

#include "flow/unactorcompiler.h"
#endif
