#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
/*
 * backup.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "flow/ApiVersion.h"
#include "fmt/format.h"
#include "fdbclient/BackupTLSConfig.h"
#include "fdbbackup/Decode.h"
#include "fdbclient/JsonBuilder.h"
#include "flow/Arena.h"
#include "flow/ArgParseUtil.h"
#include "flow/Error.h"
#include "flow/SystemMonitor.h"
#include "flow/Trace.h"
#define BOOST_DATE_TIME_NO_LIB
#include <boost/interprocess/managed_shared_memory.hpp>

#include "flow/flow.h"
#include "flow/FastAlloc.h"
#include "flow/serialize.h"
#include "flow/IRandom.h"
#include "flow/genericactors.actor.h"
#include "flow/TLSConfig.actor.h"

#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/Status.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/ClusterConnectionFile.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/IKnobCollection.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "fdbclient/S3BlobStore.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/json_spirit/json_spirit_writer_template.h"

#include "flow/Platform.h"

#include <stdarg.h>
#include <stdio.h>
#include <cinttypes>
#include <algorithm> // std::transform
#include <string>
#include <iostream>
#include <ctime>

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
#define NOMINMAX
#include <Windows.h>
#endif
#include <time.h>

#ifdef __linux__
#include <execinfo.h>
#ifdef ALLOC_INSTRUMENTATION
#include <cxxabi.h>
#endif
#endif

#include "fdbclient/versions.h"
#include "fdbclient/BuildFlags.h"

#include "SimpleOpt/SimpleOpt.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// Type of program being executed
enum class ProgramExe { AGENT, BACKUP, RESTORE, FASTRESTORE_TOOL, DR_AGENT, DB_BACKUP, UNDEFINED };

enum class BackupType {
	UNDEFINED = 0,
	START,
	MODIFY,
	STATUS,
	ABORT,
	WAIT,
	DISCONTINUE,
	PAUSE,
	RESUME,
	EXPIRE,
	DELETE_BACKUP,
	DESCRIBE,
	LIST,
	QUERY,
	DUMP,
	CLEANUP,
	TAGS,
};

enum class DBType { UNDEFINED = 0, START, STATUS, SWITCH, ABORT, PAUSE, RESUME };

// New fast restore reuses the type from legacy slow restore
enum class RestoreType { UNKNOWN, START, STATUS, ABORT, WAIT };

//
enum {
	// Backup constants
	OPT_DESTCONTAINER,
	OPT_SNAPSHOTINTERVAL,
	OPT_INITIAL_SNAPSHOT_INTERVAL,
	OPT_ERRORLIMIT,
	OPT_NOSTOPWHENDONE,
	OPT_EXPIRE_BEFORE_VERSION,
	OPT_EXPIRE_BEFORE_DATETIME,
	OPT_EXPIRE_DELETE_BEFORE_DAYS,
	OPT_EXPIRE_RESTORABLE_AFTER_VERSION,
	OPT_EXPIRE_RESTORABLE_AFTER_DATETIME,
	OPT_EXPIRE_MIN_RESTORABLE_DAYS,
	OPT_BASEURL,
	OPT_BLOB_CREDENTIALS,
	OPT_DESCRIBE_DEEP,
	OPT_DESCRIBE_TIMESTAMPS,
	OPT_DUMP_BEGIN,
	OPT_DUMP_END,
	OPT_JSON,
	OPT_DELETE_DATA,
	OPT_MIN_CLEANUP_SECONDS,
	OPT_USE_PARTITIONED_LOG,
	OPT_ENCRYPT_FILES,

	// Backup and Restore constants
	OPT_PROXY,
	OPT_TAGNAME,
	OPT_BACKUPKEYS,
	OPT_BACKUPKEYS_FILE,
	OPT_WAITFORDONE,
	OPT_BACKUPKEYS_FILTER,
	OPT_INCREMENTALONLY,
	OPT_ENCRYPTION_KEY_FILE,

	// Backup Modify
	OPT_MOD_ACTIVE_INTERVAL,
	OPT_MOD_VERIFY_UID,

	// Restore constants
	OPT_RESTORECONTAINER,
	OPT_RESTORE_VERSION,
	OPT_RESTORE_SNAPSHOT_VERSION,
	OPT_RESTORE_TIMESTAMP,
	OPT_PREFIX_ADD,
	OPT_PREFIX_REMOVE,
	OPT_RESTORE_CLUSTERFILE_DEST,
	OPT_RESTORE_CLUSTERFILE_ORIG,
	OPT_RESTORE_BEGIN_VERSION,
	OPT_RESTORE_INCONSISTENT_SNAPSHOT_ONLY,
	// The two restore options below allow callers of fdbrestore to divide a normal restore into one which restores just
	// the system keyspace and another that restores just the user key space. This is unlike the backup command where
	// all keys (both system and user) will be backed up together
	OPT_RESTORE_USER_DATA,
	OPT_RESTORE_SYSTEM_DATA,

	// Shared constants
	OPT_CLUSTERFILE,
	OPT_QUIET,
	OPT_DRYRUN,
	OPT_FORCE,
	OPT_HELP,
	OPT_DEVHELP,
	OPT_VERSION,
	OPT_BUILD_FLAGS,
	OPT_PARENTPID,
	OPT_CRASHONERROR,
	OPT_NOBUFSTDOUT,
	OPT_BUFSTDOUTERR,
	OPT_TRACE,
	OPT_TRACE_DIR,
	OPT_KNOB,
	OPT_TRACE_LOG_GROUP,
	OPT_MEMLIMIT,
	OPT_VMEMLIMIT,
	OPT_LOCALITY,

	// DB constants
	OPT_SOURCE_CLUSTER,
	OPT_DEST_CLUSTER,
	OPT_CLEANUP,
	OPT_DSTONLY,

	OPT_TRACE_FORMAT,

	// blob granules backup/restore
	OPT_BLOB_MANIFEST_URL,
};

// Top level binary commands.
CSimpleOpt::SOption g_rgOptions[] = { { OPT_VERSION, "-v", SO_NONE },
	                                  { OPT_VERSION, "--version", SO_NONE },
	                                  { OPT_BUILD_FLAGS, "--build-flags", SO_NONE },
	                                  { OPT_HELP, "-?", SO_NONE },
	                                  { OPT_HELP, "-h", SO_NONE },
	                                  { OPT_HELP, "--help", SO_NONE },

	                                  SO_END_OF_OPTIONS };

CSimpleOpt::SOption g_rgAgentOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_VERSION, "--version", SO_NONE },
	{ OPT_VERSION, "-v", SO_NONE },
	{ OPT_BUILD_FLAGS, "--build-flags", SO_NONE },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_LOCALITY, "--locality-", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupStartOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_WAITFORDONE, "-w", SO_NONE },
	{ OPT_WAITFORDONE, "--waitfordone", SO_NONE },
	{ OPT_NOSTOPWHENDONE, "-z", SO_NONE },
	{ OPT_NOSTOPWHENDONE, "--no-stop-when-done", SO_NONE },
	{ OPT_DESTCONTAINER, "-d", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "--destcontainer", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	// Enable "-p" option after GA
	// { OPT_USE_PARTITIONED_LOG, "-p",                 SO_NONE },
	{ OPT_USE_PARTITIONED_LOG, "--partitioned-log-experimental", SO_NONE },
	{ OPT_SNAPSHOTINTERVAL, "-s", SO_REQ_SEP },
	{ OPT_SNAPSHOTINTERVAL, "--snapshot-interval", SO_REQ_SEP },
	{ OPT_INITIAL_SNAPSHOT_INTERVAL, "--initial-snapshot-interval", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_BACKUPKEYS, "-k", SO_REQ_SEP },
	{ OPT_BACKUPKEYS_FILE, "--keys-file", SO_REQ_SEP },
	{ OPT_BACKUPKEYS, "--keys", SO_REQ_SEP },
	{ OPT_DRYRUN, "-n", SO_NONE },
	{ OPT_DRYRUN, "--dryrun", SO_NONE },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_INCREMENTALONLY, "--incremental", SO_NONE },
	{ OPT_ENCRYPTION_KEY_FILE, "--encryption-key-file", SO_REQ_SEP },
	{ OPT_ENCRYPT_FILES, "--encrypt-files", SO_REQ_SEP },
	{ OPT_BLOB_MANIFEST_URL, "--blob-manifest-url", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupModifyOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_MOD_VERIFY_UID, "--verify-uid", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "-d", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "--destcontainer", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	{ OPT_SNAPSHOTINTERVAL, "-s", SO_REQ_SEP },
	{ OPT_SNAPSHOTINTERVAL, "--snapshot-interval", SO_REQ_SEP },
	{ OPT_MOD_ACTIVE_INTERVAL, "--active-snapshot-interval", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupStatusOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_ERRORLIMIT, "-e", SO_REQ_SEP },
	{ OPT_ERRORLIMIT, "--errorlimit", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_JSON, "--json", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupAbortOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupCleanupOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_DELETE_DATA, "--delete-data", SO_NONE },
	{ OPT_MIN_CLEANUP_SECONDS, "--min-cleanup-seconds", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupDiscontinueOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_WAITFORDONE, "-w", SO_NONE },
	{ OPT_WAITFORDONE, "--waitfordone", SO_NONE },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupWaitOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_NOSTOPWHENDONE, "-z", SO_NONE },
	{ OPT_NOSTOPWHENDONE, "--no-stop-when-done", SO_NONE },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupPauseOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupExpireOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "-d", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "--destcontainer", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_FORCE, "-f", SO_NONE },
	{ OPT_FORCE, "--force", SO_NONE },
	{ OPT_EXPIRE_RESTORABLE_AFTER_VERSION, "--restorable-after-version", SO_REQ_SEP },
	{ OPT_EXPIRE_RESTORABLE_AFTER_DATETIME, "--restorable-after-timestamp", SO_REQ_SEP },
	{ OPT_EXPIRE_BEFORE_VERSION, "--expire-before-version", SO_REQ_SEP },
	{ OPT_EXPIRE_BEFORE_DATETIME, "--expire-before-timestamp", SO_REQ_SEP },
	{ OPT_EXPIRE_MIN_RESTORABLE_DAYS, "--min-restorable-days", SO_REQ_SEP },
	{ OPT_EXPIRE_DELETE_BEFORE_DAYS, "--delete-before-days", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupDeleteOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_DESTCONTAINER, "-d", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "--destcontainer", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupDescribeOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "-d", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "--destcontainer", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_DESCRIBE_DEEP, "--deep", SO_NONE },
	{ OPT_DESCRIBE_TIMESTAMPS, "--version-timestamps", SO_NONE },
	{ OPT_JSON, "--json", SO_NONE },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupDumpOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "-d", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "--destcontainer", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_DUMP_BEGIN, "--begin", SO_REQ_SEP },
	{ OPT_DUMP_END, "--end", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupTagsOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_CLUSTERFILE, "-C", SO_REQ_SEP },
	{ OPT_CLUSTERFILE, "--cluster-file", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupListOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_BASEURL, "-b", SO_REQ_SEP },
	{ OPT_BASEURL, "--base-url", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgBackupQueryOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_RESTORE_TIMESTAMP, "--query-restore-timestamp", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "-d", SO_REQ_SEP },
	{ OPT_DESTCONTAINER, "--destcontainer", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	{ OPT_RESTORE_VERSION, "-qrv", SO_REQ_SEP },
	{ OPT_RESTORE_VERSION, "--query-restore-version", SO_REQ_SEP },
	{ OPT_RESTORE_SNAPSHOT_VERSION, "--query-restore-snapshot-version", SO_REQ_SEP },
	{ OPT_BACKUPKEYS_FILTER, "-k", SO_REQ_SEP },
	{ OPT_BACKUPKEYS_FILTER, "--keys", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_VERSION, "-v", SO_NONE },
	{ OPT_VERSION, "--version", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

// g_rgRestoreOptions is used by fdbrestore and fastrestore_tool
CSimpleOpt::SOption g_rgRestoreOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_RESTORE_CLUSTERFILE_DEST, "--dest-cluster-file", SO_REQ_SEP },
	{ OPT_RESTORE_CLUSTERFILE_ORIG, "--orig-cluster-file", SO_REQ_SEP },
	{ OPT_RESTORE_TIMESTAMP, "--timestamp", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_RESTORECONTAINER, "-r", SO_REQ_SEP },
	{ OPT_PROXY, "--proxy", SO_REQ_SEP },
	{ OPT_PREFIX_ADD, "--add-prefix", SO_REQ_SEP },
	{ OPT_PREFIX_REMOVE, "--remove-prefix", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_BACKUPKEYS, "-k", SO_REQ_SEP },
	{ OPT_BACKUPKEYS_FILE, "--keys-file", SO_REQ_SEP },
	{ OPT_BACKUPKEYS, "--keys", SO_REQ_SEP },
	{ OPT_WAITFORDONE, "-w", SO_NONE },
	{ OPT_WAITFORDONE, "--waitfordone", SO_NONE },
	{ OPT_RESTORE_USER_DATA, "--user-data", SO_NONE },
	{ OPT_RESTORE_SYSTEM_DATA, "--system-metadata", SO_NONE },
	{ OPT_RESTORE_VERSION, "--version", SO_REQ_SEP },
	{ OPT_RESTORE_VERSION, "-v", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_DRYRUN, "-n", SO_NONE },
	{ OPT_DRYRUN, "--dryrun", SO_NONE },
	{ OPT_FORCE, "-f", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_BLOB_CREDENTIALS, "--blob-credentials", SO_REQ_SEP },
	{ OPT_INCREMENTALONLY, "--incremental", SO_NONE },
	{ OPT_RESTORE_BEGIN_VERSION, "--begin-version", SO_REQ_SEP },
	{ OPT_RESTORE_INCONSISTENT_SNAPSHOT_ONLY, "--inconsistent-snapshot-only", SO_NONE },
	{ OPT_ENCRYPTION_KEY_FILE, "--encryption-key-file", SO_REQ_SEP },
	{ OPT_BLOB_MANIFEST_URL, "--blob-manifest-url", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgDBAgentOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_SOURCE_CLUSTER, "-s", SO_REQ_SEP },
	{ OPT_SOURCE_CLUSTER, "--source", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "-d", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "--destination", SO_REQ_SEP },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	{ OPT_VERSION, "--version", SO_NONE },
	{ OPT_VERSION, "-v", SO_NONE },
	{ OPT_BUILD_FLAGS, "--build-flags", SO_NONE },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_LOCALITY, "--locality-", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgDBStartOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_SOURCE_CLUSTER, "-s", SO_REQ_SEP },
	{ OPT_SOURCE_CLUSTER, "--source", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "-d", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "--destination", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_BACKUPKEYS, "-k", SO_REQ_SEP },
	{ OPT_BACKUPKEYS_FILE, "--keys-file", SO_REQ_SEP },
	{ OPT_BACKUPKEYS, "--keys", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgDBStatusOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_SOURCE_CLUSTER, "-s", SO_REQ_SEP },
	{ OPT_SOURCE_CLUSTER, "--source", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "-d", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "--destination", SO_REQ_SEP },
	{ OPT_ERRORLIMIT, "-e", SO_REQ_SEP },
	{ OPT_ERRORLIMIT, "--errorlimit", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgDBSwitchOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_SOURCE_CLUSTER, "-s", SO_REQ_SEP },
	{ OPT_SOURCE_CLUSTER, "--source", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "-d", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "--destination", SO_REQ_SEP },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_FORCE, "-f", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgDBAbortOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_SOURCE_CLUSTER, "-s", SO_REQ_SEP },
	{ OPT_SOURCE_CLUSTER, "--source", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "-d", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "--destination", SO_REQ_SEP },
	{ OPT_CLEANUP, "--cleanup", SO_NONE },
	{ OPT_DSTONLY, "--dstonly", SO_NONE },
	{ OPT_TAGNAME, "-t", SO_REQ_SEP },
	{ OPT_TAGNAME, "--tagname", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

CSimpleOpt::SOption g_rgDBPauseOptions[] = {
#ifdef _WIN32
	{ OPT_PARENTPID, "--parentpid", SO_REQ_SEP },
#endif
	{ OPT_SOURCE_CLUSTER, "-s", SO_REQ_SEP },
	{ OPT_SOURCE_CLUSTER, "--source", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "-d", SO_REQ_SEP },
	{ OPT_DEST_CLUSTER, "--destination", SO_REQ_SEP },
	{ OPT_TRACE, "--log", SO_NONE },
	{ OPT_TRACE_DIR, "--logdir", SO_REQ_SEP },
	{ OPT_TRACE_FORMAT, "--trace-format", SO_REQ_SEP },
	{ OPT_TRACE_LOG_GROUP, "--loggroup", SO_REQ_SEP },
	{ OPT_QUIET, "-q", SO_NONE },
	{ OPT_QUIET, "--quiet", SO_NONE },
	{ OPT_CRASHONERROR, "--crash", SO_NONE },
	{ OPT_MEMLIMIT, "-m", SO_REQ_SEP },
	{ OPT_MEMLIMIT, "--memory", SO_REQ_SEP },
	{ OPT_VMEMLIMIT, "--memory-vsize", SO_REQ_SEP },
	{ OPT_HELP, "-?", SO_NONE },
	{ OPT_HELP, "-h", SO_NONE },
	{ OPT_HELP, "--help", SO_NONE },
	{ OPT_DEVHELP, "--dev-help", SO_NONE },
	{ OPT_KNOB, "--knob-", SO_REQ_SEP },
	TLS_OPTION_FLAGS,
	SO_END_OF_OPTIONS
};

const KeyRef exeAgent = "backup_agent"_sr;
const KeyRef exeBackup = "fdbbackup"_sr;
const KeyRef exeRestore = "fdbrestore"_sr;
const KeyRef exeFastRestoreTool = "fastrestore_tool"_sr; // must be lower case
const KeyRef exeDatabaseAgent = "dr_agent"_sr;
const KeyRef exeDatabaseBackup = "fdbdr"_sr;

extern const char* getSourceVersion();

#ifdef _WIN32
void parentWatcher(void* parentHandle) {
	HANDLE parent = (HANDLE)parentHandle;
	int signal = WaitForSingleObject(parent, INFINITE);
	CloseHandle(parentHandle);
	if (signal == WAIT_OBJECT_0)
		criticalError(FDB_EXIT_SUCCESS, "ParentProcessExited", "Parent process exited");
	TraceEvent(SevError, "ParentProcessWaitFailed").detail("RetCode", signal).GetLastError();
}

#endif

static void printVersion() {
	printf("FoundationDB " FDB_VT_PACKAGE_NAME " (v" FDB_VT_VERSION ")\n");
	printf("source version %s\n", getSourceVersion());
	printf("protocol %llx\n", (long long)currentProtocolVersion().version());
}

static void printBuildInformation() {
	printf("%s", jsonBuildInformation().c_str());
}

const char* BlobCredentialInfo =
    "  BLOB CREDENTIALS\n"
    "     Blob account secret keys can optionally be omitted from blobstore:// URLs, in which case they will be\n"
    "     loaded, if possible, from 1 or more blob credentials definition files.\n\n"
    "     These files can be specified with the --blob-credentials argument described above or via the environment "
    "variable\n"
    "     FDB_BLOB_CREDENTIALS, whose value is a colon-separated list of files.  The command line takes priority over\n"
    "     over the environment but all files from both sources are used.\n\n"
    "     At connect time, the specified files are read in order and the first matching account specification "
    "(user@host)\n"
    "     will be used to obtain the secret key.\n\n"
    "     The JSON schema is:\n"
    "        { \"accounts\" : { \"user@host\" : { \"secret\" : \"SECRETKEY\" }, \"user2@host2\" : { \"secret\" : "
    "\"SECRET\" } } }\n";

static void printHelpTeaser(const char* name) {
	fprintf(stderr, "Try `%s --help' for more information.\n", name);
}

static void printAgentUsage(bool devhelp) {
	printf("FoundationDB " FDB_VT_PACKAGE_NAME " (v" FDB_VT_VERSION ")\n");
	printf("Usage: %s [OPTIONS]\n\n", exeAgent.toString().c_str());
	printf("  -C CONNFILE    The path of a file containing the connection string for the\n"
	       "                 FoundationDB cluster. The default is first the value of the\n"
	       "                 FDB_CLUSTER_FILE environment variable, then `./fdb.cluster',\n"
	       "                 then `%s'.\n",
	       platform::getDefaultClusterFilePath().c_str());
	printf("  --log          Enables trace file logging for the CLI session.\n"
	       "  --logdir PATH  Specifies the output directory for trace files. If\n"
	       "                 unspecified, defaults to the current directory. Has\n"
	       "                 no effect unless --log is specified.\n");
	printf("  --loggroup LOG_GROUP\n"
	       "                 Sets the LogGroup field with the specified value for all\n"
	       "                 events in the trace output (defaults to `default').\n");
	printf("  --trace-format FORMAT\n"
	       "                 Select the format of the trace files. xml (the default) and json are supported.\n"
	       "                 Has no effect unless --log is specified.\n");
	printf("  -m SIZE, --memory SIZE\n"
	       "                 Memory limit. The default value is 8GiB. When specified\n"
	       "                 without a unit, MiB is assumed.\n");
	printf(TLS_HELP);
	printf("  --build-flags  Print build information and exit.\n");
	printf("  -v, --version  Print version information and exit.\n");
	printf("  -h, --help     Display this help and exit.\n");

	if (devhelp) {
#ifdef _WIN32
		printf("  -n             Create a new console.\n");
		printf("  -q             Disable error dialog on crash.\n");
		printf("  --parentpid PID\n");
		printf("                 Specify a process after whose termination to exit.\n");
#endif
	}

	printf("\n");
	puts(BlobCredentialInfo);

	return;
}

void printBackupContainerInfo() {
	printf("                 Backup URL forms:\n\n");
	std::vector<std::string> formats = IBackupContainer::getURLFormats();
	for (const auto& f : formats)
		printf("                     %s\n", f.c_str());
	printf("\n");
}

static void printBackupUsage(bool devhelp) {
	printf("FoundationDB " FDB_VT_PACKAGE_NAME " (v" FDB_VT_VERSION ")\n");
	printf("Usage: %s [TOP_LEVEL_OPTIONS] (start | status | abort | wait | discontinue | pause | resume | expire | "
	       "delete | describe | list | query | cleanup | tags) [ACTION_OPTIONS]\n\n",
	       exeBackup.toString().c_str());
	printf(" TOP LEVEL OPTIONS:\n");
	printf("  --build-flags  Print build information and exit.\n");
	printf("  -v, --version  Print version information and exit.\n");
	printf("  -h, --help     Display this help and exit.\n");
	printf("\n");

	printf(" ACTION OPTIONS:\n");
	printf("  -C CONNFILE    The path of a file containing the connection string for the\n"
	       "                 FoundationDB cluster. The default is first the value of the\n"
	       "                 FDB_CLUSTER_FILE environment variable, then `./fdb.cluster',\n"
	       "                 then `%s'.\n",
	       platform::getDefaultClusterFilePath().c_str());
	printf("  -d, --destcontainer URL\n"
	       "                 The Backup container URL for start, modify, describe, query, expire, and delete "
	       "operations.\n");
	printBackupContainerInfo();
	printf("  -b, --base-url BASEURL\n"
	       "                 Base backup URL for list operations.  This looks like a Backup URL but without a backup "
	       "name.\n");
	printf("  --blob-credentials FILE\n"
	       "                 File containing blob credentials in JSON format.  Can be specified multiple times for "
	       "multiple files.  See below for more details.\n");
	printf("  --expire-before-timestamp DATETIME\n"
	       "                 Datetime cutoff for expire operations.  Requires a cluster file and will use "
	       "version/timestamp metadata\n"
	       "                 in the database to obtain a cutoff version very close to the timestamp given in %s.\n",
	       BackupAgentBase::timeFormat().c_str());
	printf("  --expire-before-version VERSION\n"
	       "                 Version cutoff for expire operations.  Deletes data files containing no data at or after "
	       "VERSION.\n");
	printf("  --delete-before-days NUM_DAYS\n"
	       "                 Another way to specify version cutoff for expire operations.  Deletes data files "
	       "containing no data at or after a\n"
	       "                 version approximately NUM_DAYS days worth of versions prior to the latest log version in "
	       "the backup.\n");
	printf("  --query-restore-snapshot-version VERSION\n"
	       "                 For query operations, set the snapshot version, inclusive, used to restore a backup.\n"
	       "                 Set -1 to use the latest valid snapshot,\n"
	       "                 Set -3 to use the oldest valid snapshot.\n");
	printf("  -qrv --query-restore-version VERSION\n"
	       "                 For query operations, set target version for restoring a backup. Set -1 for maximum\n"
	       "                 restorable version (default) and -3 for minimum restorable version.\n");
	printf(
	    "  --query-restore-timestamp DATETIME\n"
	    "                 For query operations, instead of a numeric version, use this to specify a timestamp in %s\n",
	    BackupAgentBase::timeFormat().c_str());
	printf(
	    "                 and it will be converted to a version from that time using metadata in the cluster file.\n");
	printf("  --restorable-after-timestamp DATETIME\n"
	       "                 For expire operations, set minimum acceptable restorability to the version equivalent of "
	       "DATETIME and later.\n");
	printf("  --restorable-after-version VERSION\n"
	       "                 For expire operations, set minimum acceptable restorability to the VERSION and later.\n");
	printf("  --min-restorable-days NUM-DAYS\n"
	       "                 For expire operations, set minimum acceptable restorability to approximately NUM_DAYS "
	       "days worth of versions\n"
	       "                 prior to the latest log version in the backup.\n");
	printf("  --version-timestamps\n");
	printf("                 For describe operations, lookup versions in the database to obtain timestamps.  A cluster "
	       "file is required.\n");
	printf(
	    "  -f, --force    For expire operations, force expiration even if minimum restorability would be violated.\n");
	printf("  -s, --snapshot-interval DURATION\n"
	       "                 For start or modify operations, specifies the backup's default target snapshot interval "
	       "as DURATION seconds.  Defaults to %d for start operations.\n",
	       CLIENT_KNOBS->BACKUP_DEFAULT_SNAPSHOT_INTERVAL_SEC);
	printf("  --active-snapshot-interval DURATION\n"
	       "                 For modify operations, sets the desired interval for the backup's currently active "
	       "snapshot, relative to the start of the snapshot.\n");
	printf("  --verify-uid UID\n"
	       "                 Specifies a UID to verify against the BackupUID of the running backup.  If provided, the "
	       "UID is verified in the same transaction\n"
	       "                 which sets the new backup parameters (if the UID matches).\n");
	printf("  -e ERRORLIMIT  The maximum number of errors printed by status (default is 10).\n");
	printf("  -k KEYS        List of key ranges to backup or to filter the backup in query operations.\n"
	       "                 If not specified, the entire database will be backed up or no filter will be applied.\n");
	printf("  --keys-file FILE\n"
	       "                 Same as -k option, except keys are specified in the input file.\n");
	printf("  --partitioned-log-experimental  Starts with new type of backup system using partitioned logs.\n");
	printf("  -n, --dryrun   For backup start or restore start, performs a trial run with no actual changes made.\n");
	printf("  --log          Enables trace file logging for the CLI session.\n"
	       "  --logdir PATH  Specifies the output directory for trace files. If\n"
	       "                 unspecified, defaults to the current directory. Has\n"
	       "                 no effect unless --log is specified.\n");
	printf("  --loggroup LOG_GROUP\n"
	       "                 Sets the LogGroup field with the specified value for all\n"
	       "                 events in the trace output (defaults to `default').\n");
	printf("  --trace-format FORMAT\n"
	       "                 Select the format of the trace files. xml (the default) and json are supported.\n"
	       "                 Has no effect unless --log is specified.\n");
	printf("  --max-cleanup-seconds SECONDS\n"
	       "                 Specifies the amount of time a backup or DR needs to be stale before cleanup will\n"
	       "                 remove mutations for it. By default this is set to one hour.\n");
	printf("  --delete-data\n"
	       "                 This flag will cause cleanup to remove mutations for the most stale backup or DR.\n");
	printf("  --incremental\n"
	       "                 Performs incremental backup without the base backup.\n"
	       "                 This option indicates to the backup agent that it will only need to record the log files, "
	       "and ignore the range files.\n");
	printf("  --encryption-key-file"
	       "                 The AES-256-GCM key in the provided file is used for encrypting backup files.\n");
	printf("  --encrypt-files 0/1"
	       "                 If passed, this argument will allow the user to override the database encryption state to "
	       "either enable (1) or disable (0) encryption at rest with snapshot backups. This option refers to block "
	       "level encryption of snapshot backups while --encryption-key-file (above) refers to file level encryption. "
	       "Generally, these two options should not be used together.\n");
	printf("  --blob-manifest-url URL\n"
	       "                 Perform blob manifest backup. Manifest files are stored to the destination URL.\n"
	       "                 Blob granules should be enabled first for manifest backup.\n");

	printf(TLS_HELP);
	printf("  -w, --wait     Wait for the backup to complete (allowed with `start' and `discontinue').\n");
	printf("  -z, --no-stop-when-done\n"
	       "                 Do not stop backup when restorable.\n");
	printf("  -h, --help     Display this help and exit.\n");

	if (devhelp) {
#ifdef _WIN32
		printf("  -n             Create a new console.\n");
		printf("  -q             Disable error dialog on crash.\n");
		printf("  --parentpid PID\n");
		printf("                 Specify a process after whose termination to exit.\n");
#endif
		printf("  --deep         For describe operations, do not use cached metadata.  Warning: Very slow\n");
	}
	printf("\n"
	       "  KEYS FORMAT:   \"<BEGINKEY> <ENDKEY>\" [...]\n");
	printf("\n");
	puts(BlobCredentialInfo);

	return;
}

static void printRestoreUsage(bool devhelp) {
	printf("FoundationDB " FDB_VT_PACKAGE_NAME " (v" FDB_VT_VERSION ")\n");
	printf("Usage: %s [TOP_LEVEL_OPTIONS] (start | status | abort | wait) [OPTIONS]\n\n",
	       exeRestore.toString().c_str());

	printf(" TOP LEVEL OPTIONS:\n");
	printf("  --build-flags  Print build information and exit.\n");
	printf("  -v, --version  Print version information and exit.\n");
	printf("  -h, --help     Display this help and exit.\n");
	printf("\n");

	printf(" ACTION OPTIONS:\n");
	// printf("  FOLDERS        Paths to folders containing the backup files.\n");
	printf("  Options for all commands:\n\n");
	printf("  --dest-cluster-file CONNFILE\n");
	printf("                 The cluster file to restore data into.\n");
	printf("  -t, --tagname TAGNAME\n");
	printf("                 The restore tag to act on.  Default is 'default'\n");
	printf("\n");
	printf("  Options for start:\n\n");
	printf("  -r URL         The Backup URL for the restore to read from.\n");
	printBackupContainerInfo();
	printf("  -w, --waitfordone\n");
	printf("                 Wait for the restore to complete before exiting.  Prints progress updates.\n");
	printf("  -k KEYS        List of key ranges from the backup to restore.\n");
	printf("  --keys-file FILE\n"
	       "                 Same as -k option, except keys are specified in the input file.\n");
	printf("  --remove-prefix PREFIX\n");
	printf("                 Prefix to remove from the restored keys.\n");
	printf("  --add-prefix PREFIX\n");
	printf("                 Prefix to add to the restored keys\n");
	printf("  -n, --dryrun   Perform a trial run with no changes made.\n");
	printf("  --log          Enables trace file logging for the CLI session.\n"
	       "  --logdir PATH  Specifies the output directory for trace files. If\n"
	       "                 unspecified, defaults to the current directory. Has\n"
	       "                 no effect unless --log is specified.\n");
	printf("  --loggroup LOG_GROUP\n"
	       "                 Sets the LogGroup field with the specified value for all\n"
	       "                 events in the trace output (defaults to `default').\n");
	printf("  --trace-format FORMAT\n"
	       "                 Select the format of the trace files. xml (the default) and json are supported.\n"
	       "                 Has no effect unless --log is specified.\n");
	printf("  --incremental\n"
	       "                 Performs incremental restore without the base backup.\n"
	       "                 This tells the backup agent to only replay the log files from the backup source.\n"
	       "                 This also allows a restore to be performed into a non-empty destination database.\n");
	printf("  --begin-version\n"
	       "                 To be used in conjunction with incremental restore.\n"
	       "                 Indicates to the backup agent to only begin replaying log files from a certain version, "
	       "instead of the entire set.\n");
	printf("  --encryption-key-file"
	       "                 The AES-256-GCM key in the provided file is used for decrypting backup files.\n");
	printf("  --blob-manifest-url URL\n"
	       "                 Restore from blob granules. Manifest files are stored to the destination URL.\n");
	printf(TLS_HELP);
	printf("  -v DBVERSION   The version at which the database will be restored.\n");
	printf("  --timestamp    Instead of a numeric version, use this to specify a timestamp in %s\n",
	       BackupAgentBase::timeFormat().c_str());
	printf(
	    "                 and it will be converted to a version from that time using metadata in orig_cluster_file.\n");
	printf("  --orig-cluster-file CONNFILE\n");
	printf("                 The cluster file for the original database from which the backup was created.  The "
	       "original database\n");
	printf("                 is only needed to convert a --timestamp argument to a database version.\n");
	printf("  --user-data\n"
	       "                  Restore only the user keyspace. This option should NOT be used alongside "
	       "--system-metadata (below) and CANNOT be used alongside other specified key ranges.\n");
	printf(
	    "  --system-metadata\n"
	    "                 Restore only the relevant system keyspace. This option "
	    "should NOT be used alongside --user-data (above) and CANNOT be used alongside other specified key ranges.\n");

	if (devhelp) {
#ifdef _WIN32
		printf("  -q             Disable error dialog on crash.\n");
		printf("  --parentpid PID\n");
		printf("                 Specify a process after whose termination to exit.\n");
#endif
	}

	printf("\n"
	       "  KEYS FORMAT:   \"<BEGINKEY> <ENDKEY>\" [...]\n");
	printf("\n");
	puts(BlobCredentialInfo);

	return;
}

static void printFastRestoreUsage(bool devhelp) {
	printf(" NOTE: Fast restore aims to support the same fdbrestore option list.\n");
	printf("       But fast restore is still under development. The options may not be fully supported.\n");
	printf(" Supported options are: --dest-cluster-file, -r, --waitfordone, --logdir\n");
	printRestoreUsage(devhelp);
	return;
}

static void printDBAgentUsage(bool devhelp) {
	printf("FoundationDB " FDB_VT_PACKAGE_NAME " (v" FDB_VT_VERSION ")\n");
	printf("Usage: %s [OPTIONS]\n\n", exeDatabaseAgent.toString().c_str());
	printf("  -d, --destination CONNFILE\n"
	       "                 The path of a file containing the connection string for the\n"
	       "                 destination FoundationDB cluster.\n");
	printf("  -s, --source CONNFILE\n"
	       "                 The path of a file containing the connection string for the\n"
	       "                 source FoundationDB cluster.\n");
	printf("  --log          Enables trace file logging for the CLI session.\n"
	       "  --logdir PATH  Specifies the output directory for trace files. If\n"
	       "                 unspecified, defaults to the current directory. Has\n"
	       "                 no effect unless --log is specified.\n");
	printf("  --loggroup LOG_GROUP\n"
	       "                 Sets the LogGroup field with the specified value for all\n"
	       "                 events in the trace output (defaults to `default').\n");
	printf("  --trace-format FORMAT\n"
	       "                 Select the format of the trace files. xml (the default) and json are supported.\n"
	       "                 Has no effect unless --log is specified.\n");
	printf("  -m, --memory SIZE\n"
	       "                 Memory limit. The default value is 8GiB. When specified\n"
	       "                 without a unit, MiB is assumed.\n");
	printf(TLS_HELP);
	printf("  --build-flags  Print build information and exit.\n");
	printf("  -v, --version  Print version information and exit.\n");
	printf("  -h, --help     Display this help and exit.\n");
	if (devhelp) {
#ifdef _WIN32
		printf("  -n             Create a new console.\n");
		printf("  -q             Disable error dialog on crash.\n");
		printf("  --parentpid PID\n");
		printf("                 Specify a process after whose termination to exit.\n");
#endif
	}

	return;
}

static void printDBBackupUsage(bool devhelp) {
	printf("FoundationDB " FDB_VT_PACKAGE_NAME " (v" FDB_VT_VERSION ")\n");
	printf("Usage: %s [TOP_LEVEL_OPTIONS] (start | status | switch | abort | pause | resume) [OPTIONS]\n\n",
	       exeDatabaseBackup.toString().c_str());

	printf(" TOP LEVEL OPTIONS:\n");
	printf("  --build-flags  Print build information and exit.\n");
	printf("  -v, --version  Print version information and exit.\n");
	printf("  -h, --help     Display this help and exit.\n");
	printf("\n");

	printf(" ACTION OPTIONS:\n");
	printf("  -d, --destination CONNFILE\n"
	       "                 The path of a file containing the connection string for the\n");
	printf("                 destination FoundationDB cluster.\n");
	printf("  -s, --source CONNFILE\n"
	       "                 The path of a file containing the connection string for the\n"
	       "                 source FoundationDB cluster.\n");
	printf("  -e ERRORLIMIT  The maximum number of errors printed by status (default is 10).\n");
	printf("  -k KEYS        List of key ranges to backup.\n"
	       "                 If not specified, the entire database will be backed up.\n");
	printf("  --keys-file FILE\n"
	       "                 Same as -k option, except keys are specified in the input file.\n");
	printf("  --cleanup      Abort will attempt to stop mutation logging on the source cluster.\n");
	printf("  --dstonly      Abort will not make any changes on the source cluster.\n");
	printf(TLS_HELP);
	printf("  --log          Enables trace file logging for the CLI session.\n"
	       "  --logdir PATH  Specifies the output directory for trace files. If\n"
	       "                 unspecified, defaults to the current directory. Has\n"
	       "                 no effect unless --log is specified.\n");
	printf("  --loggroup LOG_GROUP\n"
	       "                 Sets the LogGroup field with the specified value for all\n"
	       "                 events in the trace output (defaults to `default').\n");
	printf("  --trace-format FORMAT\n"
	       "                 Select the format of the trace files. xml (the default) and json are supported.\n"
	       "                 Has no effect unless --log is specified.\n");
	printf("  -h, --help     Display this help and exit.\n");
	printf("\n"
	       "  KEYS FORMAT:   \"<BEGINKEY> <ENDKEY>\" [...]\n");

	if (devhelp) {
#ifdef _WIN32
		printf("  -n             Create a new console.\n");
		printf("  -q             Disable error dialog on crash.\n");
		printf("  --parentpid PID\n");
		printf("                 Specify a process after whose termination to exit.\n");
#endif
	}

	return;
}

static void printUsage(ProgramExe programExe, bool devhelp) {

	switch (programExe) {
	case ProgramExe::AGENT:
		printAgentUsage(devhelp);
		break;
	case ProgramExe::BACKUP:
		printBackupUsage(devhelp);
		break;
	case ProgramExe::RESTORE:
		printRestoreUsage(devhelp);
		break;
	case ProgramExe::FASTRESTORE_TOOL:
		printFastRestoreUsage(devhelp);
		break;
	case ProgramExe::DR_AGENT:
		printDBAgentUsage(devhelp);
		break;
	case ProgramExe::DB_BACKUP:
		printDBBackupUsage(devhelp);
		break;
	case ProgramExe::UNDEFINED:
	default:
		break;
	}

	return;
}

extern bool g_crashOnError;

// Return the type of program executable based on the name of executable file
ProgramExe getProgramType(std::string programExe) {
	ProgramExe enProgramExe = ProgramExe::UNDEFINED;

	// lowercase the string
	std::transform(programExe.begin(), programExe.end(), programExe.begin(), ::tolower);

	// Remove the extension, if Windows
#ifdef _WIN32
	size_t lastDot = programExe.find_last_of(".");
	if (lastDot != std::string::npos) {
		size_t lastSlash = programExe.find_last_of("\\");

		// Ensure last dot is after last slash, if present
		if ((lastSlash == std::string::npos) || (lastSlash < lastDot)) {
			programExe = programExe.substr(0, lastDot);
		}
	}
#endif
	// For debugging convenience, remove .debug suffix if present.
	if (StringRef(programExe).endsWith(".debug"_sr))
		programExe = programExe.substr(0, programExe.size() - 6);

	// Check if backup agent
	if ((programExe.length() >= exeAgent.size()) &&
	    (programExe.compare(programExe.length() - exeAgent.size(), exeAgent.size(), (const char*)exeAgent.begin()) ==
	     0)) {
		enProgramExe = ProgramExe::AGENT;
	}

	// Check if backup
	else if ((programExe.length() >= exeBackup.size()) &&
	         (programExe.compare(
	              programExe.length() - exeBackup.size(), exeBackup.size(), (const char*)exeBackup.begin()) == 0)) {
		enProgramExe = ProgramExe::BACKUP;
	}

	// Check if restore
	else if ((programExe.length() >= exeRestore.size()) &&
	         (programExe.compare(
	              programExe.length() - exeRestore.size(), exeRestore.size(), (const char*)exeRestore.begin()) == 0)) {
		enProgramExe = ProgramExe::RESTORE;
	}

	// Check if restore
	else if ((programExe.length() >= exeFastRestoreTool.size()) &&
	         (programExe.compare(programExe.length() - exeFastRestoreTool.size(),
	                             exeFastRestoreTool.size(),
	                             (const char*)exeFastRestoreTool.begin()) == 0)) {
		enProgramExe = ProgramExe::FASTRESTORE_TOOL;
	}

	// Check if db agent
	else if ((programExe.length() >= exeDatabaseAgent.size()) &&
	         (programExe.compare(programExe.length() - exeDatabaseAgent.size(),
	                             exeDatabaseAgent.size(),
	                             (const char*)exeDatabaseAgent.begin()) == 0)) {
		enProgramExe = ProgramExe::DR_AGENT;
	}

	// Check if db backup
	else if ((programExe.length() >= exeDatabaseBackup.size()) &&
	         (programExe.compare(programExe.length() - exeDatabaseBackup.size(),
	                             exeDatabaseBackup.size(),
	                             (const char*)exeDatabaseBackup.begin()) == 0)) {
		enProgramExe = ProgramExe::DB_BACKUP;
	}

	return enProgramExe;
}

BackupType getBackupType(std::string backupType) {
	BackupType enBackupType = BackupType::UNDEFINED;

	// lowercase the string
	std::transform(backupType.begin(), backupType.end(), backupType.begin(), ::tolower);

	static std::map<std::string, BackupType> values;
	if (values.empty()) {
		values["start"] = BackupType::START;
		values["status"] = BackupType::STATUS;
		values["abort"] = BackupType::ABORT;
		values["cleanup"] = BackupType::CLEANUP;
		values["wait"] = BackupType::WAIT;
		values["discontinue"] = BackupType::DISCONTINUE;
		values["pause"] = BackupType::PAUSE;
		values["resume"] = BackupType::RESUME;
		values["expire"] = BackupType::EXPIRE;
		values["delete"] = BackupType::DELETE_BACKUP;
		values["describe"] = BackupType::DESCRIBE;
		values["list"] = BackupType::LIST;
		values["query"] = BackupType::QUERY;
		values["dump"] = BackupType::DUMP;
		values["modify"] = BackupType::MODIFY;
		values["tags"] = BackupType::TAGS;
	}

	auto i = values.find(backupType);
	if (i != values.end())
		enBackupType = i->second;

	return enBackupType;
}

RestoreType getRestoreType(std::string name) {
	if (name == "start")
		return RestoreType::START;
	if (name == "abort")
		return RestoreType::ABORT;
	if (name == "status")
		return RestoreType::STATUS;
	if (name == "wait")
		return RestoreType::WAIT;
	return RestoreType::UNKNOWN;
}

DBType getDBType(std::string dbType) {
	DBType enBackupType = DBType::UNDEFINED;

	// lowercase the string
	std::transform(dbType.begin(), dbType.end(), dbType.begin(), ::tolower);

	static std::map<std::string, DBType> values;
	if (values.empty()) {
		values["start"] = DBType::START;
		values["status"] = DBType::STATUS;
		values["switch"] = DBType::SWITCH;
		values["abort"] = DBType::ABORT;
		values["pause"] = DBType::PAUSE;
		values["resume"] = DBType::RESUME;
	}

	auto i = values.find(dbType);
	if (i != values.end())
		enBackupType = i->second;

	return enBackupType;
}

															#line 1526 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via getLayerStatus()
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class GetLayerStatusActor>
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class GetLayerStatusActorState {
															#line 1533 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	GetLayerStatusActorState(Reference<ReadYourWritesTransaction> const& tr,IPAddress const& localIP,std::string const& name,std::string const& id,ProgramExe const& exe,Database const& dest,Snapshot const& snapshot = Snapshot::False) 
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : tr(tr),
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   localIP(localIP),
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   name(name),
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   id(id),
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   exe(exe),
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dest(dest),
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   snapshot(snapshot)
															#line 1552 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("getLayerStatus", reinterpret_cast<unsigned long>(this));

	}
	~GetLayerStatusActorState() 
	{
		fdb_probe_actor_destroy("getLayerStatus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1537 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr->getReadVersion();
															#line 1537 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1569 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 1;
															#line 1537 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor, 0, Version >*>(static_cast<GetLayerStatusActor*>(this)));
															#line 1574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLayerStatusActorState();
		static_cast<GetLayerStatusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1539 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layersRootValue = json_spirit::mValue();
															#line 1540 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		JSONDoc layersRoot(layersRootValue);
															#line 1541 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		JSONDoc op = layersRoot.subDoc(name);
															#line 1544 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot = op.subDoc("$expires");
															#line 1546 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		op.create("version") = readVer + 120 * CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 1548 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("instances_running.$sum") = 1;
															#line 1549 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("last_updated.$max") = now();
															#line 1551 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o = layerRoot.subDoc("instances." + id);
															#line 1553 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("version") = FDB_VT_VERSION;
															#line 1554 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("id") = id;
															#line 1555 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("last_updated") = now();
															#line 1556 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("memory_usage") = (int64_t)getMemoryUsage();
															#line 1557 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("resident_size") = (int64_t)getResidentMemoryUsage();
															#line 1558 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("main_thread_cpu_seconds") = getProcessorTimeThread();
															#line 1559 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("process_cpu_seconds") = getProcessorTimeProcess();
															#line 1560 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("configured_workers") = CLIENT_KNOBS->BACKUP_TASKS_PER_AGENT;
															#line 1561 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("processID") = ::getpid();
															#line 1562 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("locality") = tr->getDatabase()->clientLocality.toJSON<json_spirit::mObject>();
															#line 1563 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		o.create("networkAddress") = localIP.toString();
															#line 1565 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (exe == ProgramExe::AGENT)
															#line 1635 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1566 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			static S3BlobStoreEndpoint::Stats last_stats;
															#line 1567 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			static double last_ts = 0;
															#line 1568 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			S3BlobStoreEndpoint::Stats current_stats = S3BlobStoreEndpoint::s_stats;
															#line 1569 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			JSONDoc blobstats = o.create("blob_stats");
															#line 1570 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			blobstats.create("total") = current_stats.getJSON();
															#line 1571 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			S3BlobStoreEndpoint::Stats diff = current_stats - last_stats;
															#line 1572 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			json_spirit::mObject diffObj = diff.getJSON();
															#line 1573 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (last_ts > 0)
															#line 1653 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				diffObj["bytes_per_second"] = double(current_stats.bytes_sent - last_stats.bytes_sent) / (now() - last_ts);
															#line 1657 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1575 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			blobstats.create("recent") = diffObj;
															#line 1576 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			last_stats = current_stats;
															#line 1577 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			last_ts = now();
															#line 1579 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			JSONDoc totalBlobStats = layerRoot.subDoc("blob_recent_io");
															#line 1580 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			for( auto& p : diffObj ) {
															#line 1581 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				totalBlobStats.create(p.first + ".$sum") = p.second;
															#line 1671 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1583 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fba = FileBackupAgent();
															#line 1584 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<std::vector<KeyBackedTag>> __when_expr_1 = getAllBackupTags(tr, snapshot);
															#line 1584 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1679 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 2;
															#line 1584 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor, 1, std::vector<KeyBackedTag> >*>(static_cast<GetLayerStatusActor*>(this)));
															#line 1684 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 1642 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (exe == ProgramExe::DR_AGENT)
															#line 1691 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1643 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				dba = DatabaseBackupAgent();
															#line 1644 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tr2 = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(dest));
															#line 1645 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tr2->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1646 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tr2->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<RangeResult> __when_expr_4 = tr2->getRange(dba.tagNames.range(), 10000, snapshot);
															#line 1647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1705 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1when2(__when_expr_4.get(), loopDepth); };
				static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 5;
															#line 1647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor, 4, RangeResult >*>(static_cast<GetLayerStatusActor*>(this)));
															#line 1710 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont11(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1when1(Version const& __readVer,int loopDepth) 
	{
															#line 1537 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		readVer = __readVer;
															#line 1725 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __readVer,int loopDepth) 
	{
		readVer = std::move(__readVer);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor*>(this)->ActorCallback< GetLayerStatusActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1697 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		std::string json = json_spirit::write_string(layersRootValue);
															#line 1698 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<GetLayerStatusActor*>(this)->SAV<std::string>::futures) { (void)(json); this->~GetLayerStatusActorState(); static_cast<GetLayerStatusActor*>(this)->destroy(); return 0; }
															#line 1806 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<GetLayerStatusActor*>(this)->SAV< std::string >::value()) std::string(json);
		this->~GetLayerStatusActorState();
		static_cast<GetLayerStatusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1585 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagLastRestorableVersions = std::vector<Future<Optional<Version>>>();
															#line 1586 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagStates = std::vector<Future<EBackupState>>();
															#line 1587 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagContainers = std::vector<Future<Reference<IBackupContainer>>>();
															#line 1588 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagRangeBytes = std::vector<Future<int64_t>>();
															#line 1589 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagLogBytes = std::vector<Future<int64_t>>();
															#line 1590 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		fBackupPaused = tr->get(fba.taskBucket->getPauseKey(), snapshot);
															#line 1592 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1593 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1594 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tag = std::vector<KeyBackedTag>::iterator();
															#line 1595 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		backupTagUids = std::vector<UID>();
															#line 1596 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tag = backupTags.begin();
															#line 1838 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyBackedTag> const& __backupTags,int loopDepth) 
	{
															#line 1584 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		backupTags = __backupTags;
															#line 1847 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<KeyBackedTag> && __backupTags,int loopDepth) 
	{
		backupTags = std::move(__backupTags);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor*>(this)->ActorCallback< GetLayerStatusActor, 1, std::vector<KeyBackedTag> >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 1, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 1, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor, 1, std::vector<KeyBackedTag> >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 1608 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = waitForAll(tagLastRestorableVersions) && waitForAll(tagStates) && waitForAll(tagContainers) && waitForAll(tagRangeBytes) && waitForAll(tagLogBytes) && success(fBackupPaused);
															#line 1608 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1928 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 4;
															#line 1608 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor, 3, Void >*>(static_cast<GetLayerStatusActor*>(this)));
															#line 1933 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 1596 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!(tag != backupTags.end()))
															#line 1949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1597 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<UidAndAbortedFlagT> __when_expr_2 = tag->getOrThrow(tr, snapshot);
															#line 1597 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1957 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 3;
															#line 1597 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor, 2, UidAndAbortedFlagT >*>(static_cast<GetLayerStatusActor*>(this)));
															#line 1962 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(UidAndAbortedFlagT const& uidAndAbortedFlag,int loopDepth) 
	{
															#line 1598 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		BackupConfig config(uidAndAbortedFlag.first);
															#line 1599 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		backupTagUids.push_back(config.getUid());
															#line 1601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagStates.push_back(config.stateEnum().getOrThrow(tr, snapshot));
															#line 1602 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagRangeBytes.push_back(config.rangeBytesWritten().getD(tr, snapshot, 0));
															#line 1603 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagLogBytes.push_back(config.logBytesWritten().getD(tr, snapshot, 0));
															#line 1604 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagContainers.push_back(config.backupContainer().getOrThrow(tr, snapshot));
															#line 1605 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagLastRestorableVersions.push_back(fba.getLastRestorable(tr, StringRef(tag->tagName), snapshot));
															#line 1596 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tag++;
															#line 1998 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(UidAndAbortedFlagT && uidAndAbortedFlag,int loopDepth) 
	{
															#line 1598 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		BackupConfig config(uidAndAbortedFlag.first);
															#line 1599 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		backupTagUids.push_back(config.getUid());
															#line 1601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagStates.push_back(config.stateEnum().getOrThrow(tr, snapshot));
															#line 1602 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagRangeBytes.push_back(config.rangeBytesWritten().getD(tr, snapshot, 0));
															#line 1603 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagLogBytes.push_back(config.logBytesWritten().getD(tr, snapshot, 0));
															#line 1604 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagContainers.push_back(config.backupContainer().getOrThrow(tr, snapshot));
															#line 1605 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagLastRestorableVersions.push_back(fba.getLastRestorable(tr, StringRef(tag->tagName), snapshot));
															#line 1596 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tag++;
															#line 2021 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(UidAndAbortedFlagT const& uidAndAbortedFlag,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(uidAndAbortedFlag, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(UidAndAbortedFlagT && uidAndAbortedFlag,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(uidAndAbortedFlag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor*>(this)->ActorCallback< GetLayerStatusActor, 2, UidAndAbortedFlagT >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 2, UidAndAbortedFlagT >*,UidAndAbortedFlagT const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 2, UidAndAbortedFlagT >*,UidAndAbortedFlagT && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor, 2, UidAndAbortedFlagT >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 1611 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		JSONDoc tagsRoot = layerRoot.subDoc("tags.$latest");
															#line 1612 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("tags.timestamp") = now();
															#line 1613 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("total_workers.$sum") = fBackupPaused.get().present() ? 0 : CLIENT_KNOBS->BACKUP_TASKS_PER_AGENT;
															#line 1615 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("paused.$latest") = fBackupPaused.get().present();
															#line 1617 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		int j = 0;
															#line 1618 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for( KeyBackedTag eachTag : backupTags ) {
															#line 1619 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			EBackupState status = tagStates[j].get();
															#line 1620 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			const char* statusText = fba.getStateText(status);
															#line 1623 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			JSONDoc tagRoot = tagsRoot.subDoc(eachTag.tagName);
															#line 1624 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("current_container") = tagContainers[j].get()->getURL();
															#line 1625 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("current_status") = statusText;
															#line 1626 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (tagLastRestorableVersions[j].get().present())
															#line 2127 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1627 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				Version last_restorable_version = tagLastRestorableVersions[j].get().get();
															#line 1628 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				double last_restorable_seconds_behind = ((double)readVer - last_restorable_version) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 1630 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tagRoot.create("last_restorable_version") = last_restorable_version;
															#line 1631 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tagRoot.create("last_restorable_seconds_behind") = last_restorable_seconds_behind;
															#line 2137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1633 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("running_backup") = (status == EBackupState::STATE_RUNNING_DIFFERENTIAL || status == EBackupState::STATE_RUNNING);
															#line 1635 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("running_backup_is_restorable") = (status == EBackupState::STATE_RUNNING_DIFFERENTIAL);
															#line 1636 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("range_bytes_written") = tagRangeBytes[j].get();
															#line 1637 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("mutation_log_bytes_written") = tagLogBytes[j].get();
															#line 1638 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("mutation_stream_id") = backupTagUids[j].toString();
															#line 1640 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			j++;
															#line 2151 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 1611 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		JSONDoc tagsRoot = layerRoot.subDoc("tags.$latest");
															#line 1612 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("tags.timestamp") = now();
															#line 1613 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("total_workers.$sum") = fBackupPaused.get().present() ? 0 : CLIENT_KNOBS->BACKUP_TASKS_PER_AGENT;
															#line 1615 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("paused.$latest") = fBackupPaused.get().present();
															#line 1617 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		int j = 0;
															#line 1618 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for( KeyBackedTag eachTag : backupTags ) {
															#line 1619 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			EBackupState status = tagStates[j].get();
															#line 1620 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			const char* statusText = fba.getStateText(status);
															#line 1623 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			JSONDoc tagRoot = tagsRoot.subDoc(eachTag.tagName);
															#line 1624 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("current_container") = tagContainers[j].get()->getURL();
															#line 1625 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("current_status") = statusText;
															#line 1626 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (tagLastRestorableVersions[j].get().present())
															#line 2183 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1627 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				Version last_restorable_version = tagLastRestorableVersions[j].get().get();
															#line 1628 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				double last_restorable_seconds_behind = ((double)readVer - last_restorable_version) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 1630 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tagRoot.create("last_restorable_version") = last_restorable_version;
															#line 1631 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tagRoot.create("last_restorable_seconds_behind") = last_restorable_seconds_behind;
															#line 2193 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1633 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("running_backup") = (status == EBackupState::STATE_RUNNING_DIFFERENTIAL || status == EBackupState::STATE_RUNNING);
															#line 1635 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("running_backup_is_restorable") = (status == EBackupState::STATE_RUNNING_DIFFERENTIAL);
															#line 1636 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("range_bytes_written") = tagRangeBytes[j].get();
															#line 1637 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("mutation_log_bytes_written") = tagLogBytes[j].get();
															#line 1638 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("mutation_stream_id") = backupTagUids[j].toString();
															#line 1640 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			j++;
															#line 2207 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor*>(this)->ActorCallback< GetLayerStatusActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 1648 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		backupVersion = std::vector<Future<Optional<Key>>>();
															#line 1649 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		backupStatus = std::vector<Future<EBackupState>>();
															#line 1650 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagRangeBytesDR = std::vector<Future<int64_t>>();
															#line 1651 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagLogBytesDR = std::vector<Future<int64_t>>();
															#line 1652 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		fDRPaused = tr->get(dba.taskBucket->getPauseKey(), snapshot);
															#line 1654 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		drTagUids = std::vector<UID>();
															#line 1655 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for(int i = 0;i < tagNames.size();i++) {
															#line 1656 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			backupVersion.push_back(tr2->get(tagNames[i].value.withPrefix(applyMutationsBeginRange.begin), snapshot));
															#line 1657 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			UID tagUID = BinaryReader::fromStringRef<UID>(tagNames[i].value, Unversioned());
															#line 1658 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			drTagUids.push_back(tagUID);
															#line 1659 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			backupStatus.push_back(dba.getStateValue(tr2, tagUID, snapshot));
															#line 1660 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRangeBytesDR.push_back(dba.getRangeBytesWritten(tr2, tagUID, snapshot));
															#line 1661 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagLogBytesDR.push_back(dba.getLogBytesWritten(tr2, tagUID, snapshot));
															#line 2322 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 1664 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAll(backupStatus) && waitForAll(backupVersion) && waitForAll(tagRangeBytesDR) && waitForAll(tagLogBytesDR) && success(fDRPaused);
															#line 1664 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2328 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
		static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 6;
															#line 1664 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor, 5, Void >*>(static_cast<GetLayerStatusActor*>(this)));
															#line 2333 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when2(RangeResult const& __tagNames,int loopDepth) 
	{
															#line 1647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tagNames = __tagNames;
															#line 2342 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(RangeResult && __tagNames,int loopDepth) 
	{
		tagNames = std::move(__tagNames);
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor*>(this)->ActorCallback< GetLayerStatusActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(Void const& _,int loopDepth) 
	{
															#line 1667 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		JSONDoc tagsRoot = layerRoot.subDoc("tags.$latest");
															#line 1668 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("tags.timestamp") = now();
															#line 1669 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("total_workers.$sum") = fDRPaused.get().present() ? 0 : CLIENT_KNOBS->BACKUP_TASKS_PER_AGENT;
															#line 1670 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("paused.$latest") = fDRPaused.get().present();
															#line 1672 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for(int i = 0;i < tagNames.size();i++) {
															#line 1673 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			std::string tagName = dba.sourceTagNames.unpack(tagNames[i].key).getString(0).toString();
															#line 1675 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			auto status = backupStatus[i].get();
															#line 1677 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			JSONDoc tagRoot = tagsRoot.create(tagName);
															#line 1678 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("running_backup") = (status == EBackupState::STATE_RUNNING_DIFFERENTIAL || status == EBackupState::STATE_RUNNING);
															#line 1680 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("running_backup_is_restorable") = (status == EBackupState::STATE_RUNNING_DIFFERENTIAL);
															#line 1681 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("range_bytes_written") = tagRangeBytesDR[i].get();
															#line 1682 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("mutation_log_bytes_written") = tagLogBytesDR[i].get();
															#line 1683 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("mutation_stream_id") = drTagUids[i].toString();
															#line 1685 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (backupVersion[i].get().present())
															#line 2447 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1686 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				double seconds_behind = ((double)readVer - BinaryReader::fromStringRef<Version>( backupVersion[i].get().get(), Unversioned())) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 1689 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tagRoot.create("seconds_behind") = seconds_behind;
															#line 2453 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1693 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("backup_state") = BackupAgentBase::getStateText(status);
															#line 2457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1(Void && _,int loopDepth) 
	{
															#line 1667 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		JSONDoc tagsRoot = layerRoot.subDoc("tags.$latest");
															#line 1668 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("tags.timestamp") = now();
															#line 1669 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("total_workers.$sum") = fDRPaused.get().present() ? 0 : CLIENT_KNOBS->BACKUP_TASKS_PER_AGENT;
															#line 1670 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		layerRoot.create("paused.$latest") = fDRPaused.get().present();
															#line 1672 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for(int i = 0;i < tagNames.size();i++) {
															#line 1673 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			std::string tagName = dba.sourceTagNames.unpack(tagNames[i].key).getString(0).toString();
															#line 1675 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			auto status = backupStatus[i].get();
															#line 1677 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			JSONDoc tagRoot = tagsRoot.create(tagName);
															#line 1678 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("running_backup") = (status == EBackupState::STATE_RUNNING_DIFFERENTIAL || status == EBackupState::STATE_RUNNING);
															#line 1680 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("running_backup_is_restorable") = (status == EBackupState::STATE_RUNNING_DIFFERENTIAL);
															#line 1681 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("range_bytes_written") = tagRangeBytesDR[i].get();
															#line 1682 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("mutation_log_bytes_written") = tagLogBytesDR[i].get();
															#line 1683 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("mutation_stream_id") = drTagUids[i].toString();
															#line 1685 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (backupVersion[i].get().present())
															#line 2493 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1686 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				double seconds_behind = ((double)readVer - BinaryReader::fromStringRef<Version>( backupVersion[i].get().get(), Unversioned())) / CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
															#line 1689 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				tagRoot.create("seconds_behind") = seconds_behind;
															#line 2499 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1693 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tagRoot.create("backup_state") = BackupAgentBase::getStateText(status);
															#line 2503 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<GetLayerStatusActor*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor*>(this)->ActorCallback< GetLayerStatusActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	IPAddress localIP;
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string name;
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string id;
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ProgramExe exe;
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database dest;
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Snapshot snapshot;
															#line 1537 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version readVer;
															#line 1539 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	json_spirit::mValue layersRootValue;
															#line 1544 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	JSONDoc layerRoot;
															#line 1551 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	JSONDoc o;
															#line 1583 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent fba;
															#line 1584 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<KeyBackedTag> backupTags;
															#line 1585 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<Optional<Version>>> tagLastRestorableVersions;
															#line 1586 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<EBackupState>> tagStates;
															#line 1587 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<Reference<IBackupContainer>>> tagContainers;
															#line 1588 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<int64_t>> tagRangeBytes;
															#line 1589 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<int64_t>> tagLogBytes;
															#line 1590 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<Optional<Value>> fBackupPaused;
															#line 1594 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<KeyBackedTag>::iterator tag;
															#line 1595 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<UID> backupTagUids;
															#line 1643 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DatabaseBackupAgent dba;
															#line 1644 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr2;
															#line 1647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RangeResult tagNames;
															#line 1648 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<Optional<Key>>> backupVersion;
															#line 1649 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<EBackupState>> backupStatus;
															#line 1650 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<int64_t>> tagRangeBytesDR;
															#line 1651 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<Future<int64_t>> tagLogBytesDR;
															#line 1652 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<Optional<Value>> fDRPaused;
															#line 1654 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::vector<UID> drTagUids;
															#line 2644 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via getLayerStatus()
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class GetLayerStatusActor final : public Actor<std::string>, public ActorCallback< GetLayerStatusActor, 0, Version >, public ActorCallback< GetLayerStatusActor, 1, std::vector<KeyBackedTag> >, public ActorCallback< GetLayerStatusActor, 2, UidAndAbortedFlagT >, public ActorCallback< GetLayerStatusActor, 3, Void >, public ActorCallback< GetLayerStatusActor, 4, RangeResult >, public ActorCallback< GetLayerStatusActor, 5, Void >, public FastAllocated<GetLayerStatusActor>, public GetLayerStatusActorState<GetLayerStatusActor> {
															#line 2649 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<GetLayerStatusActor>::operator new;
	using FastAllocated<GetLayerStatusActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6333570093883164928UL, 6410635078083029760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLayerStatusActor, 0, Version >;
friend struct ActorCallback< GetLayerStatusActor, 1, std::vector<KeyBackedTag> >;
friend struct ActorCallback< GetLayerStatusActor, 2, UidAndAbortedFlagT >;
friend struct ActorCallback< GetLayerStatusActor, 3, Void >;
friend struct ActorCallback< GetLayerStatusActor, 4, RangeResult >;
friend struct ActorCallback< GetLayerStatusActor, 5, Void >;
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	GetLayerStatusActor(Reference<ReadYourWritesTransaction> const& tr,IPAddress const& localIP,std::string const& name,std::string const& id,ProgramExe const& exe,Database const& dest,Snapshot const& snapshot = Snapshot::False) 
															#line 2671 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<std::string>(),
		   GetLayerStatusActorState<GetLayerStatusActor>(tr, localIP, name, id, exe, dest, snapshot),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1635849480871618048UL, 3711702260765326592UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLayerStatus");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLayerStatusActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLayerStatusActor, 1, std::vector<KeyBackedTag> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetLayerStatusActor, 2, UidAndAbortedFlagT >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetLayerStatusActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GetLayerStatusActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< GetLayerStatusActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<std::string> getLayerStatus( Reference<ReadYourWritesTransaction> const& tr, IPAddress const& localIP, std::string const& name, std::string const& id, ProgramExe const& exe, Database const& dest, Snapshot const& snapshot = Snapshot::False ) {
															#line 1524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<std::string>(new GetLayerStatusActor(tr, localIP, name, id, exe, dest, snapshot));
															#line 2709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 1700 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

// Check for unparsable or expired statuses and delete them.
// First checks the first doc in the key range, and if it is valid, alive and not "me" then
// returns.  Otherwise, checks the rest of the range as well.
															#line 2717 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via cleanupStatus()
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class CleanupStatusActor>
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class CleanupStatusActorState {
															#line 2724 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	CleanupStatusActorState(Reference<ReadYourWritesTransaction> const& tr,std::string const& rootKey,std::string const& name,std::string const& id,int const& limit = 1) 
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : tr(tr),
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   rootKey(rootKey),
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   name(name),
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   id(id),
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   limit(limit)
															#line 2739 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanupStatus", reinterpret_cast<unsigned long>(this));

	}
	~CleanupStatusActorState() 
	{
		fdb_probe_actor_destroy("cleanupStatus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(KeyRangeRef(rootKey, strinc(rootKey)), limit, Snapshot::True);
															#line 1709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<CleanupStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2756 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CleanupStatusActor*>(this)->actor_wait_state = 1;
															#line 1709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupStatusActor, 0, RangeResult >*>(static_cast<CleanupStatusActor*>(this)));
															#line 2761 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupStatusActorState();
		static_cast<CleanupStatusActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1710 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		readMore = false;
															#line 1711 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		i = int();
															#line 1712 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		i = 0;
															#line 2788 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __docs,int loopDepth) 
	{
															#line 1709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		docs = __docs;
															#line 2797 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __docs,int loopDepth) 
	{
		docs = std::move(__docs);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupStatusActor*>(this)->actor_wait_state > 0) static_cast<CleanupStatusActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStatusActor*>(this)->ActorCallback< CleanupStatusActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStatusActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cleanupStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupStatusActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cleanupStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupStatusActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<CleanupStatusActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStatusActorState(); static_cast<CleanupStatusActor*>(this)->destroy(); return 0; }
															#line 2876 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<CleanupStatusActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanupStatusActorState();
		static_cast<CleanupStatusActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1712 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!(i < docs.size()))
															#line 2895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		json_spirit::mValue docValue;
															#line 2901 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		try {
															#line 1715 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			json_spirit::read_string(docs[i].value.toString(), docValue);
															#line 1716 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			JSONDoc doc(docValue);
															#line 1718 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			JSONDoc::expires_reference_version = tr->getReadVersion().get();
															#line 1720 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			doc.cleanOps();
															#line 1721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!doc.has(name + ".last_updated"))
															#line 2913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1722 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1cont1loopBody1Catch1(Error(), loopDepth);
															#line 2917 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1726 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (limit == 1 && doc.has(name + ".instances." + id))
															#line 2921 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1727 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				readMore = true;
															#line 2925 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 1736 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (readMore)
															#line 2954 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1737 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			limit = 10000;
															#line 1738 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr->getRange(KeyRangeRef(rootKey, strinc(rootKey)), limit, Snapshot::True);
															#line 1738 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<CleanupStatusActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2962 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CleanupStatusActor*>(this)->actor_wait_state = 2;
															#line 1738 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanupStatusActor, 1, RangeResult >*>(static_cast<CleanupStatusActor*>(this)));
															#line 2967 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1730 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevWarn, "RemovedDeadBackupLayerStatus").errorUnsuppressed(e).detail("Key", docs[i].key);
															#line 1731 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->clear(docs[i].key);
															#line 1733 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (limit == 1)
															#line 2986 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1734 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				readMore = true;
															#line 2990 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont7(int loopDepth) 
	{
															#line 1712 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		++i;
															#line 3019 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(RangeResult const& docs2,int loopDepth) 
	{
															#line 1739 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		docs = std::move(docs2);
															#line 1740 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		readMore = false;
															#line 3030 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont8(RangeResult && docs2,int loopDepth) 
	{
															#line 1739 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		docs = std::move(docs2);
															#line 1740 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		readMore = false;
															#line 3041 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(RangeResult const& docs2,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(docs2, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(RangeResult && docs2,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont8(std::move(docs2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanupStatusActor*>(this)->actor_wait_state > 0) static_cast<CleanupStatusActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStatusActor*>(this)->ActorCallback< CleanupStatusActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStatusActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("cleanupStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanupStatusActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("cleanupStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanupStatusActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStatus", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string rootKey;
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string name;
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string id;
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int limit;
															#line 1709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RangeResult docs;
															#line 1710 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool readMore;
															#line 1711 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int i;
															#line 3137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via cleanupStatus()
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class CleanupStatusActor final : public Actor<Void>, public ActorCallback< CleanupStatusActor, 0, RangeResult >, public ActorCallback< CleanupStatusActor, 1, RangeResult >, public FastAllocated<CleanupStatusActor>, public CleanupStatusActorState<CleanupStatusActor> {
															#line 3142 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<CleanupStatusActor>::operator new;
	using FastAllocated<CleanupStatusActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7042290463523545600UL, 11773055650988107520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupStatusActor, 0, RangeResult >;
friend struct ActorCallback< CleanupStatusActor, 1, RangeResult >;
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	CleanupStatusActor(Reference<ReadYourWritesTransaction> const& tr,std::string const& rootKey,std::string const& name,std::string const& id,int const& limit = 1) 
															#line 3160 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   CleanupStatusActorState<CleanupStatusActor>(tr, rootKey, name, id, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupStatus", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7764623388921042432UL, 12378116011328262656UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStatusActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupStatus");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupStatus", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupStatusActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanupStatusActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> cleanupStatus( Reference<ReadYourWritesTransaction> const& tr, std::string const& rootKey, std::string const& name, std::string const& id, int const& limit = 1 ) {
															#line 1704 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new CleanupStatusActor(tr, rootKey, name, id, limit));
															#line 3194 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 1746 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

// Get layer status document for just this layer
															#line 3200 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via getLayerStatus()
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class GetLayerStatusActor1>
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class GetLayerStatusActor1State {
															#line 3207 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	GetLayerStatusActor1State(Database const& src,std::string const& rootKey) 
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : src(src),
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   rootKey(rootKey),
															#line 1749 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tr(src)
															#line 3218 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("getLayerStatus", reinterpret_cast<unsigned long>(this));

	}
	~GetLayerStatusActor1State() 
	{
		fdb_probe_actor_destroy("getLayerStatus", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1751 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 3233 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLayerStatusActor1State();
		static_cast<GetLayerStatusActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1753 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1754 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef(rootKey, strinc(rootKey)), GetRangeLimits::ROW_LIMIT_UNLIMITED);
															#line 1755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3270 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 1;
															#line 1755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor1, 0, RangeResult >*>(static_cast<GetLayerStatusActor1*>(this)));
															#line 3275 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1770 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 1770 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3299 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 4;
															#line 1770 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor1, 3, Void >*>(static_cast<GetLayerStatusActor1*>(this)));
															#line 3304 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1757 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		statusDoc = json_spirit::mObject();
															#line 1758 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		modifier = JSONDoc(statusDoc);
															#line 1759 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		RangeForbody1loopBody1cont2Iterator0 = std::begin(kvPairs);
															#line 3323 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __kvPairs,int loopDepth) 
	{
															#line 1755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		kvPairs = __kvPairs;
															#line 3332 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __kvPairs,int loopDepth) 
	{
		kvPairs = std::move(__kvPairs);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor1*>(this)->ActorCallback< GetLayerStatusActor1, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor1, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor1, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor1, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1766 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		JSONDoc::expires_reference_version = (uint64_t)tr.getReadVersion().get();
															#line 1767 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		modifier.cleanOps();
															#line 1768 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<GetLayerStatusActor1*>(this)->SAV<json_spirit::mObject>::futures) { (void)(statusDoc); this->~GetLayerStatusActor1State(); static_cast<GetLayerStatusActor1*>(this)->destroy(); return 0; }
															#line 3415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<GetLayerStatusActor1*>(this)->SAV< json_spirit::mObject >::value()) json_spirit::mObject(std::move(statusDoc)); // state_var_RVO
		this->~GetLayerStatusActor1State();
		static_cast<GetLayerStatusActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 1759 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!(RangeForbody1loopBody1cont2Iterator0 != std::end(kvPairs)))
															#line 3434 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1759 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		auto& kv = *RangeForbody1loopBody1cont2Iterator0;
															#line 3440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1760 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			docValue = json_spirit::mValue();
															#line 1761 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			json_spirit::read_string(kv.value.toString(), docValue);
															#line 1762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = yield();
															#line 1762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3450 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 2;
															#line 1762 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor1, 1, Void >*>(static_cast<GetLayerStatusActor1*>(this)));
															#line 3455 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 1759 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		++RangeForbody1loopBody1cont2Iterator0;
															#line 3478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1763 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		modifier.absorb(docValue);
															#line 1764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield();
															#line 1764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3491 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 3;
															#line 1764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor1, 2, Void >*>(static_cast<GetLayerStatusActor1*>(this)));
															#line 3496 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1763 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		modifier.absorb(docValue);
															#line 1764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield();
															#line 1764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3509 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 3;
															#line 1764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetLayerStatusActor1, 2, Void >*>(static_cast<GetLayerStatusActor1*>(this)));
															#line 3514 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor1*>(this)->ActorCallback< GetLayerStatusActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor1*>(this)->ActorCallback< GetLayerStatusActor1, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor1, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor1, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor1, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GetLayerStatusActor1*>(this)->actor_wait_state > 0) static_cast<GetLayerStatusActor1*>(this)->actor_wait_state = 0;
		static_cast<GetLayerStatusActor1*>(this)->ActorCallback< GetLayerStatusActor1, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor1, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetLayerStatusActor1, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetLayerStatusActor1, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database src;
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string rootKey;
															#line 1749 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Transaction tr;
															#line 1755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RangeResult kvPairs;
															#line 1757 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	json_spirit::mObject statusDoc;
															#line 1758 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	JSONDoc modifier;
															#line 1759 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	decltype(std::begin(std::declval<RangeResult>())) RangeForbody1loopBody1cont2Iterator0;
															#line 1760 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	json_spirit::mValue docValue;
															#line 3784 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via getLayerStatus()
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class GetLayerStatusActor1 final : public Actor<json_spirit::mObject>, public ActorCallback< GetLayerStatusActor1, 0, RangeResult >, public ActorCallback< GetLayerStatusActor1, 1, Void >, public ActorCallback< GetLayerStatusActor1, 2, Void >, public ActorCallback< GetLayerStatusActor1, 3, Void >, public FastAllocated<GetLayerStatusActor1>, public GetLayerStatusActor1State<GetLayerStatusActor1> {
															#line 3789 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<GetLayerStatusActor1>::operator new;
	using FastAllocated<GetLayerStatusActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6333570093883164928UL, 6410635078083029760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<json_spirit::mObject>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLayerStatusActor1, 0, RangeResult >;
friend struct ActorCallback< GetLayerStatusActor1, 1, Void >;
friend struct ActorCallback< GetLayerStatusActor1, 2, Void >;
friend struct ActorCallback< GetLayerStatusActor1, 3, Void >;
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	GetLayerStatusActor1(Database const& src,std::string const& rootKey) 
															#line 3809 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<json_spirit::mObject>(),
		   GetLayerStatusActor1State<GetLayerStatusActor1>(src, rootKey),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLayerStatus", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15691917703021786880UL, 14697070454649251072UL);
		ActorExecutionContextHelper __helper(static_cast<GetLayerStatusActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLayerStatus");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLayerStatus", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLayerStatusActor1, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLayerStatusActor1, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetLayerStatusActor1, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GetLayerStatusActor1, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<json_spirit::mObject> getLayerStatus( Database const& src, std::string const& rootKey ) {
															#line 1748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<json_spirit::mObject>(new GetLayerStatusActor1(src, rootKey));
															#line 3845 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 1774 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

// Read layer status for this layer and get the total count of agent processes (instances) then adjust the poll delay
// based on that and BACKUP_AGGREGATE_POLL_RATE
															#line 3852 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via updateAgentPollRate()
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class UpdateAgentPollRateActor>
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class UpdateAgentPollRateActorState {
															#line 3859 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	UpdateAgentPollRateActorState(Database const& src,std::string const& rootKey,std::string const& name,std::shared_ptr<double> const& pollDelay) 
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : src(src),
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   rootKey(rootKey),
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   name(name),
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   pollDelay(pollDelay)
															#line 3872 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("updateAgentPollRate", reinterpret_cast<unsigned long>(this));

	}
	~UpdateAgentPollRateActorState() 
	{
		fdb_probe_actor_destroy("updateAgentPollRate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1781 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 3887 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateAgentPollRateActorState();
		static_cast<UpdateAgentPollRateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1783 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<json_spirit::mObject> __when_expr_0 = getLayerStatus(src, rootKey);
															#line 1783 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<UpdateAgentPollRateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3920 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateAgentPollRateActor*>(this)->actor_wait_state = 1;
															#line 1783 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateAgentPollRateActor, 0, json_spirit::mObject >*>(static_cast<UpdateAgentPollRateActor*>(this)));
															#line 3925 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1795 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(CLIENT_KNOBS->BACKUP_AGGREGATE_POLL_RATE_UPDATE_INTERVAL);
															#line 1795 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<UpdateAgentPollRateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3942 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateAgentPollRateActor*>(this)->actor_wait_state = 2;
															#line 1795 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateAgentPollRateActor, 1, Void >*>(static_cast<UpdateAgentPollRateActor*>(this)));
															#line 3947 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1793 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevWarn, "BackupAgentPollRateUpdateError").error(e);
															#line 3957 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(json_spirit::mObject const& status,int loopDepth) 
	{
															#line 1784 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		int64_t processes = 0;
															#line 1786 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (JSONDoc(status).tryGet<int64_t>(name + ".instances_running", processes) && processes > 0)
															#line 3974 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1790 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			*pollDelay = (double)processes / CLIENT_KNOBS->BACKUP_AGGREGATE_POLL_RATE;
															#line 3978 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(json_spirit::mObject && status,int loopDepth) 
	{
															#line 1784 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		int64_t processes = 0;
															#line 1786 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (JSONDoc(status).tryGet<int64_t>(name + ".instances_running", processes) && processes > 0)
															#line 3990 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1790 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			*pollDelay = (double)processes / CLIENT_KNOBS->BACKUP_AGGREGATE_POLL_RATE;
															#line 3994 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(json_spirit::mObject const& status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(json_spirit::mObject && status,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateAgentPollRateActor*>(this)->actor_wait_state > 0) static_cast<UpdateAgentPollRateActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateAgentPollRateActor*>(this)->ActorCallback< UpdateAgentPollRateActor, 0, json_spirit::mObject >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateAgentPollRateActor, 0, json_spirit::mObject >*,json_spirit::mObject const& value) 
	{
		fdb_probe_actor_enter("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateAgentPollRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateAgentPollRateActor, 0, json_spirit::mObject >*,json_spirit::mObject && value) 
	{
		fdb_probe_actor_enter("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateAgentPollRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateAgentPollRateActor, 0, json_spirit::mObject >*,Error err) 
	{
		fdb_probe_actor_enter("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateAgentPollRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateAgentPollRateActor*>(this)->actor_wait_state > 0) static_cast<UpdateAgentPollRateActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateAgentPollRateActor*>(this)->ActorCallback< UpdateAgentPollRateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateAgentPollRateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateAgentPollRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateAgentPollRateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateAgentPollRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateAgentPollRateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateAgentPollRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateAgentPollRate", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database src;
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string rootKey;
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string name;
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::shared_ptr<double> pollDelay;
															#line 4183 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via updateAgentPollRate()
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class UpdateAgentPollRateActor final : public Actor<Void>, public ActorCallback< UpdateAgentPollRateActor, 0, json_spirit::mObject >, public ActorCallback< UpdateAgentPollRateActor, 1, Void >, public FastAllocated<UpdateAgentPollRateActor>, public UpdateAgentPollRateActorState<UpdateAgentPollRateActor> {
															#line 4188 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<UpdateAgentPollRateActor>::operator new;
	using FastAllocated<UpdateAgentPollRateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11151762276701919232UL, 17469633843195044608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateAgentPollRateActor, 0, json_spirit::mObject >;
friend struct ActorCallback< UpdateAgentPollRateActor, 1, Void >;
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	UpdateAgentPollRateActor(Database const& src,std::string const& rootKey,std::string const& name,std::shared_ptr<double> const& pollDelay) 
															#line 4206 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateAgentPollRateActorState<UpdateAgentPollRateActor>(src, rootKey, name, pollDelay),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateAgentPollRate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10393670972920825344UL, 11266331069948355584UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateAgentPollRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateAgentPollRate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateAgentPollRate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateAgentPollRateActor, 0, json_spirit::mObject >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateAgentPollRateActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> updateAgentPollRate( Database const& src, std::string const& rootKey, std::string const& name, std::shared_ptr<double> const& pollDelay ) {
															#line 1777 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new UpdateAgentPollRateActor(src, rootKey, name, pollDelay));
															#line 4240 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 1798 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 4245 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via statusUpdateActor()
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class StatusUpdateActorActor>
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class StatusUpdateActorActorState {
															#line 4252 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	StatusUpdateActorActorState(Database const& statusUpdateDest,std::string const& name,ProgramExe const& exe,std::shared_ptr<double> const& pollDelay,Database const& taskDest = Database(),std::string const& id = nondeterministicRandom()->randomUniqueID().toString()) 
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : statusUpdateDest(statusUpdateDest),
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   name(name),
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   exe(exe),
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   pollDelay(pollDelay),
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   taskDest(taskDest),
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   id(id),
															#line 1805 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   metaKey(layerStatusMetaPrefixRange.begin.toString() + "json/" + name),
															#line 1806 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   rootKey(backupStatusPrefixRange.begin.toString() + name + "/json"),
															#line 1807 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   instanceKey(rootKey + "/" + "agent-" + id),
															#line 1808 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tr(new ReadYourWritesTransaction(statusUpdateDest)),
															#line 1809 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   pollRateUpdater(),
															#line 1814 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   localIP()
															#line 4281 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("statusUpdateActor", reinterpret_cast<unsigned long>(this));

	}
	~StatusUpdateActorActorState() 
	{
		fdb_probe_actor_destroy("statusUpdateActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1816 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 4296 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusUpdateActorActorState();
		static_cast<StatusUpdateActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1827 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		;
															#line 4319 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1818 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			localIP = statusUpdateDest->getConnectionRecord()->getConnectionString().determineLocalSourceIP();
															#line 4336 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1821 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevWarn, "AgentCouldNotDetermineLocalIP").error(e);
															#line 1822 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 1822 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4375 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 1;
															#line 1822 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 0, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 4380 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1851 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		;
															#line 4482 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1828 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tr->reset();
															#line 4498 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		try {
															#line 1830 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 4502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1845 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevWarnAlways, "UnableToWriteLayerStatusMetaKey").errorUnsuppressed(e);
															#line 1846 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 1846 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4541 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 4;
															#line 1846 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 3, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 4546 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1832 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1833 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1834 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->set(metaKey, rootKey);
															#line 1835 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 1835 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4583 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 2;
															#line 1835 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 1, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 4588 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1838 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevWarnAlways, "LayerStatusMetaKeyUpdateError").errorUnsuppressed(e);
															#line 1839 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 1839 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4627 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 3;
															#line 1839 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 2, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 4632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1852 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tr->reset();
															#line 4915 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		try {
															#line 1854 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 4919 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont2loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1880 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevWarnAlways, "UnableToWriteBackupStatus").error(e);
															#line 1881 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_9 = delay(10.0);
															#line 1881 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4945 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_9.get(), loopDepth); };
			static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 10;
															#line 1881 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 9, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 4950 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 1871 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(CLIENT_KNOBS->BACKUP_STATUS_DELAY * ((1.0 - CLIENT_KNOBS->BACKUP_STATUS_JITTER) + 2 * deterministicRandom()->random01() * CLIENT_KNOBS->BACKUP_STATUS_JITTER));
															#line 1871 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4967 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont2loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_8.get(), loopDepth); };
		static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 9;
															#line 1871 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 8, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 4972 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 1856 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1857 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1858 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			futureStatusDoc = getLayerStatus(tr, localIP, name, id, exe, taskDest, Snapshot::True);
															#line 1860 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_4 = cleanupStatus(tr, rootKey, name, id);
															#line 1860 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4997 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 5;
															#line 1860 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 4, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 5002 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1866 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevWarnAlways, "LayerBackupStatusUpdateError").errorUnsuppressed(e);
															#line 1867 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr->onError(e);
															#line 1867 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5041 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont2loopBody1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 8;
															#line 1867 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 7, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 5046 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<std::string> __when_expr_5 = futureStatusDoc;
															#line 1861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5063 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 6;
															#line 1861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 5, std::string >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 5068 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<std::string> __when_expr_5 = futureStatusDoc;
															#line 1861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 6;
															#line 1861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 5, std::string >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 5084 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1loopBody1cont3(std::string const& statusdoc,int loopDepth) 
	{
															#line 1862 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tr->set(instanceKey, statusdoc);
															#line 1863 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr->commit();
															#line 1863 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5172 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 7;
															#line 1863 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 6, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 5177 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont3(std::string && statusdoc,int loopDepth) 
	{
															#line 1862 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tr->set(instanceKey, statusdoc);
															#line 1863 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr->commit();
															#line 1863 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5190 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1cont3when1(__when_expr_6.get(), loopDepth); };
		static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 7;
															#line 1863 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< StatusUpdateActorActor, 6, Void >*>(static_cast<StatusUpdateActorActor*>(this)));
															#line 5195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2when1(std::string const& statusdoc,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont3(statusdoc, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2when1(std::string && statusdoc,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont3(std::move(statusdoc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 5, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 5, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 5, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 5, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 1877 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!pollRateUpdater.isValid())
															#line 5453 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1878 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			pollRateUpdater = updateAgentPollRate(statusUpdateDest, rootKey, name, pollDelay);
															#line 5457 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont2loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 1877 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!pollRateUpdater.isValid())
															#line 5467 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1878 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			pollRateUpdater = updateAgentPollRate(statusUpdateDest, rootKey, name, pollDelay);
															#line 5471 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont2loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont2loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<StatusUpdateActorActor*>(this)->actor_wait_state > 0) static_cast<StatusUpdateActorActor*>(this)->actor_wait_state = 0;
		static_cast<StatusUpdateActorActor*>(this)->ActorCallback< StatusUpdateActorActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< StatusUpdateActorActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< StatusUpdateActorActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database statusUpdateDest;
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string name;
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ProgramExe exe;
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::shared_ptr<double> pollDelay;
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database taskDest;
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string id;
															#line 1805 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string metaKey;
															#line 1806 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string rootKey;
															#line 1807 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string instanceKey;
															#line 1808 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 1809 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<Void> pollRateUpdater;
															#line 1814 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	IPAddress localIP;
															#line 1858 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<std::string> futureStatusDoc;
															#line 5678 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via statusUpdateActor()
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class StatusUpdateActorActor final : public Actor<Void>, public ActorCallback< StatusUpdateActorActor, 0, Void >, public ActorCallback< StatusUpdateActorActor, 1, Void >, public ActorCallback< StatusUpdateActorActor, 2, Void >, public ActorCallback< StatusUpdateActorActor, 3, Void >, public ActorCallback< StatusUpdateActorActor, 4, Void >, public ActorCallback< StatusUpdateActorActor, 5, std::string >, public ActorCallback< StatusUpdateActorActor, 6, Void >, public ActorCallback< StatusUpdateActorActor, 7, Void >, public ActorCallback< StatusUpdateActorActor, 8, Void >, public ActorCallback< StatusUpdateActorActor, 9, Void >, public FastAllocated<StatusUpdateActorActor>, public StatusUpdateActorActorState<StatusUpdateActorActor> {
															#line 5683 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<StatusUpdateActorActor>::operator new;
	using FastAllocated<StatusUpdateActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2480666196585055232UL, 17011774447814785280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StatusUpdateActorActor, 0, Void >;
friend struct ActorCallback< StatusUpdateActorActor, 1, Void >;
friend struct ActorCallback< StatusUpdateActorActor, 2, Void >;
friend struct ActorCallback< StatusUpdateActorActor, 3, Void >;
friend struct ActorCallback< StatusUpdateActorActor, 4, Void >;
friend struct ActorCallback< StatusUpdateActorActor, 5, std::string >;
friend struct ActorCallback< StatusUpdateActorActor, 6, Void >;
friend struct ActorCallback< StatusUpdateActorActor, 7, Void >;
friend struct ActorCallback< StatusUpdateActorActor, 8, Void >;
friend struct ActorCallback< StatusUpdateActorActor, 9, Void >;
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	StatusUpdateActorActor(Database const& statusUpdateDest,std::string const& name,ProgramExe const& exe,std::shared_ptr<double> const& pollDelay,Database const& taskDest = Database(),std::string const& id = nondeterministicRandom()->randomUniqueID().toString()) 
															#line 5709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   StatusUpdateActorActorState<StatusUpdateActorActor>(statusUpdateDest, name, exe, pollDelay, taskDest, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusUpdateActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4823883803907263488UL, 10923794394775959808UL);
		ActorExecutionContextHelper __helper(static_cast<StatusUpdateActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusUpdateActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusUpdateActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 5, std::string >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< StatusUpdateActorActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> statusUpdateActor( Database const& statusUpdateDest, std::string const& name, ProgramExe const& exe, std::shared_ptr<double> const& pollDelay, Database const& taskDest = Database(), std::string const& id = nondeterministicRandom()->randomUniqueID().toString() ) {
															#line 1799 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new StatusUpdateActorActor(statusUpdateDest, name, exe, pollDelay, taskDest, id));
															#line 5751 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 1885 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 5756 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via runDBAgent()
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class RunDBAgentActor>
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class RunDBAgentActorState {
															#line 5763 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RunDBAgentActorState(Database const& src,Database const& dest) 
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : src(src),
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dest(dest),
															#line 1887 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   pollDelay(std::make_shared<double>(1.0 / CLIENT_KNOBS->BACKUP_AGGREGATE_POLL_RATE))
															#line 5774 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("runDBAgent", reinterpret_cast<unsigned long>(this));

	}
	~RunDBAgentActorState() 
	{
		fdb_probe_actor_destroy("runDBAgent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1888 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			std::string id = nondeterministicRandom()->randomUniqueID().toString();
															#line 1889 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			status = statusUpdateActor(src, "dr_backup", ProgramExe::DR_AGENT, pollDelay, dest, id);
															#line 1890 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			status_other = statusUpdateActor(dest, "dr_backup_dest", ProgramExe::DR_AGENT, pollDelay, dest, id);
															#line 1893 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			backupAgent = DatabaseBackupAgent(src);
															#line 1895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 5797 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunDBAgentActorState();
		static_cast<RunDBAgentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1910 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<RunDBAgentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunDBAgentActorState(); static_cast<RunDBAgentActor*>(this)->destroy(); return 0; }
															#line 5820 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<RunDBAgentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunDBAgentActorState();
		static_cast<RunDBAgentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1897 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_0 = backupAgent.run(dest, pollDelay, CLIENT_KNOBS->BACKUP_TASKS_PER_AGENT);
															#line 1897 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunDBAgentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5842 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunDBAgentActor*>(this)->actor_wait_state = 1;
															#line 1897 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunDBAgentActor, 0, Void >*>(static_cast<RunDBAgentActor*>(this)));
															#line 5847 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1900 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 5882 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1901 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1903 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevError, "DA_runAgent").error(e);
															#line 1904 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: DR agent encountered fatal error `%s'\n", e.what());
															#line 1906 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1906 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunDBAgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5896 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunDBAgentActor*>(this)->actor_wait_state = 2;
															#line 1906 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunDBAgentActor, 1, Void >*>(static_cast<RunDBAgentActor*>(this)));
															#line 5901 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunDBAgentActor*>(this)->actor_wait_state > 0) static_cast<RunDBAgentActor*>(this)->actor_wait_state = 0;
		static_cast<RunDBAgentActor*>(this)->ActorCallback< RunDBAgentActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDBAgentActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDBAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDBAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDBAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunDBAgentActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDBAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDBAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDBAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunDBAgentActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDBAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDBAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDBAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunDBAgentActor*>(this)->actor_wait_state > 0) static_cast<RunDBAgentActor*>(this)->actor_wait_state = 0;
		static_cast<RunDBAgentActor*>(this)->ActorCallback< RunDBAgentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDBAgentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDBAgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDBAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDBAgent", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunDBAgentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDBAgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDBAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDBAgent", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunDBAgentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDBAgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDBAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDBAgent", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database src;
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database dest;
															#line 1887 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::shared_ptr<double> pollDelay;
															#line 1889 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<Void> status;
															#line 1890 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<Void> status_other;
															#line 1893 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 6098 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via runDBAgent()
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class RunDBAgentActor final : public Actor<Void>, public ActorCallback< RunDBAgentActor, 0, Void >, public ActorCallback< RunDBAgentActor, 1, Void >, public FastAllocated<RunDBAgentActor>, public RunDBAgentActorState<RunDBAgentActor> {
															#line 6103 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<RunDBAgentActor>::operator new;
	using FastAllocated<RunDBAgentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16226562739932739584UL, 11525961048231271936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunDBAgentActor, 0, Void >;
friend struct ActorCallback< RunDBAgentActor, 1, Void >;
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RunDBAgentActor(Database const& src,Database const& dest) 
															#line 6121 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   RunDBAgentActorState<RunDBAgentActor>(src, dest),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runDBAgent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10731264677041498624UL, 9967315911940015360UL);
		ActorExecutionContextHelper __helper(static_cast<RunDBAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runDBAgent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runDBAgent", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunDBAgentActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunDBAgentActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> runDBAgent( Database const& src, Database const& dest ) {
															#line 1886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new RunDBAgentActor(src, dest));
															#line 6155 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 1912 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 6160 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via runAgent()
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class RunAgentActor>
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class RunAgentActorState {
															#line 6167 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RunAgentActorState(Database const& db) 
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 1914 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   pollDelay(std::make_shared<double>(1.0 / CLIENT_KNOBS->BACKUP_AGGREGATE_POLL_RATE)),
															#line 1915 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   status(statusUpdateActor(db, "backup", ProgramExe::AGENT, pollDelay)),
															#line 1917 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   backupAgent()
															#line 6180 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("runAgent", reinterpret_cast<unsigned long>(this));

	}
	~RunAgentActorState() 
	{
		fdb_probe_actor_destroy("runAgent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1919 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 6195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunAgentActorState();
		static_cast<RunAgentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1934 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<RunAgentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunAgentActorState(); static_cast<RunAgentActor*>(this)->destroy(); return 0; }
															#line 6218 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<RunAgentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunAgentActorState();
		static_cast<RunAgentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1921 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_0 = backupAgent.run(db, pollDelay, CLIENT_KNOBS->BACKUP_TASKS_PER_AGENT);
															#line 1921 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunAgentActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6240 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunAgentActor*>(this)->actor_wait_state = 1;
															#line 1921 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunAgentActor, 0, Void >*>(static_cast<RunAgentActor*>(this)));
															#line 6245 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_operation_cancelled)
															#line 6280 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1925 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 6284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent(SevError, "BA_runAgent").error(e);
															#line 1928 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: backup agent encountered fatal error `%s'\n", e.what());
															#line 1930 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 1930 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunAgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunAgentActor*>(this)->actor_wait_state = 2;
															#line 1930 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunAgentActor, 1, Void >*>(static_cast<RunAgentActor*>(this)));
															#line 6299 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunAgentActor*>(this)->actor_wait_state > 0) static_cast<RunAgentActor*>(this)->actor_wait_state = 0;
		static_cast<RunAgentActor*>(this)->ActorCallback< RunAgentActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunAgentActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunAgentActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunAgentActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunAgentActor*>(this)->actor_wait_state > 0) static_cast<RunAgentActor*>(this)->actor_wait_state = 0;
		static_cast<RunAgentActor*>(this)->ActorCallback< RunAgentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunAgentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runAgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAgent", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunAgentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runAgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAgent", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunAgentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runAgent", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runAgent", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 1914 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::shared_ptr<double> pollDelay;
															#line 1915 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<Void> status;
															#line 1917 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 6492 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via runAgent()
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class RunAgentActor final : public Actor<Void>, public ActorCallback< RunAgentActor, 0, Void >, public ActorCallback< RunAgentActor, 1, Void >, public FastAllocated<RunAgentActor>, public RunAgentActorState<RunAgentActor> {
															#line 6497 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<RunAgentActor>::operator new;
	using FastAllocated<RunAgentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1883805301174710784UL, 3457379839079094784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunAgentActor, 0, Void >;
friend struct ActorCallback< RunAgentActor, 1, Void >;
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RunAgentActor(Database const& db) 
															#line 6515 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   RunAgentActorState<RunAgentActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runAgent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6428210632939638016UL, 4561003514158763520UL);
		ActorExecutionContextHelper __helper(static_cast<RunAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runAgent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runAgent", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunAgentActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunAgentActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> runAgent( Database const& db ) {
															#line 1913 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new RunAgentActor(db));
															#line 6549 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 1936 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 6554 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via submitDBBackup()
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class SubmitDBBackupActor>
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class SubmitDBBackupActorState {
															#line 6561 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	SubmitDBBackupActorState(Database const& src,Database const& dest,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,std::string const& tagName) 
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : src(src),
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dest(dest),
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   backupRanges(backupRanges),
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName)
															#line 6574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("submitDBBackup", reinterpret_cast<unsigned long>(this));

	}
	~SubmitDBBackupActorState() 
	{
		fdb_probe_actor_destroy("submitDBBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1942 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = DatabaseBackupAgent(src);
															#line 1943 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				ASSERT(!backupRanges.empty());
															#line 1945 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.submitBackup( dest, KeyRef(tagName), backupRanges, StopWhenDone::False, StringRef(), StringRef(), LockDB::True);
															#line 1945 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<SubmitDBBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6596 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SubmitDBBackupActor*>(this)->actor_wait_state = 1;
															#line 1945 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SubmitDBBackupActor, 0, Void >*>(static_cast<SubmitDBBackupActor*>(this)));
															#line 6601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SubmitDBBackupActorState();
		static_cast<SubmitDBBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1980 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<SubmitDBBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SubmitDBBackupActorState(); static_cast<SubmitDBBackupActor*>(this)->destroy(); return 0; }
															#line 6630 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<SubmitDBBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SubmitDBBackupActorState();
		static_cast<SubmitDBBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1963 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6643 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 1964 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 6647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 1965 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			switch (e.code()) { case error_code_backup_error: fprintf(stderr, "ERROR: An error was encountered during submission\n"); break; case error_code_backup_duplicate: fprintf(stderr, "ERROR: A DR is already running on tag `%s'\n", printable(StringRef(tagName)).c_str()); break; default: fprintf(stderr, "ERROR: %s\n", e.what()); break; };
															#line 1977 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(backup_error(), loopDepth);
															#line 6653 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<bool> __when_expr_1 = backupAgent.checkActive(dest);
															#line 1949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<SubmitDBBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6669 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitDBBackupActor*>(this)->actor_wait_state = 2;
															#line 1949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitDBBackupActor, 1, bool >*>(static_cast<SubmitDBBackupActor*>(this)));
															#line 6674 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<bool> __when_expr_1 = backupAgent.checkActive(dest);
															#line 1949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<SubmitDBBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6685 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitDBBackupActor*>(this)->actor_wait_state = 2;
															#line 1949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitDBBackupActor, 1, bool >*>(static_cast<SubmitDBBackupActor*>(this)));
															#line 6690 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SubmitDBBackupActor*>(this)->actor_wait_state > 0) static_cast<SubmitDBBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitDBBackupActor*>(this)->ActorCallback< SubmitDBBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitDBBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SubmitDBBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SubmitDBBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(bool const& agentRunning,int loopDepth) 
	{
															#line 1951 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!agentRunning)
															#line 6774 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1952 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The DR on tag `%s' was successfully submitted but no DR agents are responding.\n", printable(StringRef(tagName)).c_str());
															#line 1956 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6780 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 1958 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The DR on tag `%s' was successfully submitted.\n", printable(StringRef(tagName)).c_str());
															#line 6786 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(bool && agentRunning,int loopDepth) 
	{
															#line 1951 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!agentRunning)
															#line 6796 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 1952 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The DR on tag `%s' was successfully submitted but no DR agents are responding.\n", printable(StringRef(tagName)).c_str());
															#line 1956 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6802 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 1958 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The DR on tag `%s' was successfully submitted.\n", printable(StringRef(tagName)).c_str());
															#line 6808 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool const& agentRunning,int loopDepth) 
	{
		loopDepth = a_body1cont3(agentRunning, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(bool && agentRunning,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(agentRunning), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SubmitDBBackupActor*>(this)->actor_wait_state > 0) static_cast<SubmitDBBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitDBBackupActor*>(this)->ActorCallback< SubmitDBBackupActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitDBBackupActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("submitDBBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitDBBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SubmitDBBackupActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("submitDBBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitDBBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SubmitDBBackupActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("submitDBBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitDBBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database src;
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database dest;
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 1942 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 6912 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via submitDBBackup()
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class SubmitDBBackupActor final : public Actor<Void>, public ActorCallback< SubmitDBBackupActor, 0, Void >, public ActorCallback< SubmitDBBackupActor, 1, bool >, public FastAllocated<SubmitDBBackupActor>, public SubmitDBBackupActorState<SubmitDBBackupActor> {
															#line 6917 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<SubmitDBBackupActor>::operator new;
	using FastAllocated<SubmitDBBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17310817675442688256UL, 7382597563096188928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SubmitDBBackupActor, 0, Void >;
friend struct ActorCallback< SubmitDBBackupActor, 1, bool >;
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	SubmitDBBackupActor(Database const& src,Database const& dest,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,std::string const& tagName) 
															#line 6935 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   SubmitDBBackupActorState<SubmitDBBackupActor>(src, dest, backupRanges, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("submitDBBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5923879030974673408UL, 2268739855062825984UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("submitDBBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("submitDBBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SubmitDBBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SubmitDBBackupActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> submitDBBackup( Database const& src, Database const& dest, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, std::string const& tagName ) {
															#line 1937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new SubmitDBBackupActor(src, dest, backupRanges, tagName));
															#line 6969 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 1982 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 6974 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via submitBackup()
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class SubmitBackupActor>
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class SubmitBackupActorState {
															#line 6981 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	SubmitBackupActorState(Database const& db,std::string const& url,Optional<std::string> const& proxy,int const& initialSnapshotIntervalSeconds,int const& snapshotIntervalSeconds,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,bool const& encryptionEnabled,std::string const& tagName,bool const& dryRun,WaitForComplete const& waitForCompletion,StopWhenDone const& stopWhenDone,UsePartitionedLog const& usePartitionedLog,IncrementalBackupOnly const& incrementalBackupOnly,Optional<std::string> const& encryptionKeyFile,Optional<std::string> const& blobManifestUrl) 
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   url(url),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   initialSnapshotIntervalSeconds(initialSnapshotIntervalSeconds),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   snapshotIntervalSeconds(snapshotIntervalSeconds),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   backupRanges(backupRanges),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   encryptionEnabled(encryptionEnabled),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dryRun(dryRun),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   waitForCompletion(waitForCompletion),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   stopWhenDone(stopWhenDone),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   usePartitionedLog(usePartitionedLog),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   incrementalBackupOnly(incrementalBackupOnly),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   encryptionKeyFile(encryptionKeyFile),
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   blobManifestUrl(blobManifestUrl)
															#line 7016 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("submitBackup", reinterpret_cast<unsigned long>(this));

	}
	~SubmitBackupActorState() 
	{
		fdb_probe_actor_destroy("submitBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1999 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = FileBackupAgent();
															#line 2000 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				ASSERT(!backupRanges.empty());
															#line 2002 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (dryRun)
															#line 7036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2003 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					tag = makeBackupTag(tagName);
															#line 2004 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					StrictFuture<Optional<UidAndAbortedFlagT>> __when_expr_0 = tag.get(db.getReference());
															#line 2004 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7044 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<SubmitBackupActor*>(this)->actor_wait_state = 1;
															#line 2004 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 0, Optional<UidAndAbortedFlagT> >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7049 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 2040 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					StrictFuture<Void> __when_expr_3 = backupAgent.submitBackup(db, KeyRef(url), proxy, initialSnapshotIntervalSeconds, snapshotIntervalSeconds, tagName, backupRanges, encryptionEnabled, stopWhenDone, usePartitionedLog, incrementalBackupOnly, encryptionKeyFile, blobManifestUrl);
															#line 2040 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1when2(__when_expr_3.get(), loopDepth); };
					static_cast<SubmitBackupActor*>(this)->actor_wait_state = 4;
															#line 2040 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 3, Void >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7063 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					loopDepth = 0;
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SubmitBackupActorState();
		static_cast<SubmitBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2093 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<SubmitBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SubmitBackupActorState(); static_cast<SubmitBackupActor*>(this)->destroy(); return 0; }
															#line 7093 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<SubmitBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SubmitBackupActorState();
		static_cast<SubmitBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2076 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7106 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2077 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			switch (e.code()) { case error_code_backup_error: fprintf(stderr, "ERROR: An error was encountered during submission\n"); break; case error_code_backup_duplicate: fprintf(stderr, "ERROR: A backup is already running on tag `%s'\n", printable(StringRef(tagName)).c_str()); break; default: fprintf(stderr, "ERROR: %s\n", e.what()); break; };
															#line 2090 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(backup_error(), loopDepth);
															#line 7116 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<UidAndAbortedFlagT> const& uidFlag,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (uidFlag.present())
															#line 7136 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2007 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			BackupConfig config(uidFlag.get().first);
															#line 2008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<EBackupState> __when_expr_1 = config.stateEnum().getOrThrow(db.getReference());
															#line 2008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7144 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
			static_cast<SubmitBackupActor*>(this)->actor_wait_state = 2;
															#line 2008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 1, EBackupState >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7149 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<UidAndAbortedFlagT> && uidFlag,int loopDepth) 
	{
															#line 2006 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (uidFlag.present())
															#line 7163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2007 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			BackupConfig config(uidFlag.get().first);
															#line 2008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<EBackupState> __when_expr_1 = config.stateEnum().getOrThrow(db.getReference());
															#line 2008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7171 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
			static_cast<SubmitBackupActor*>(this)->actor_wait_state = 2;
															#line 2008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 1, EBackupState >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7176 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<UidAndAbortedFlagT> const& uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont3(uidFlag, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<UidAndAbortedFlagT> && uidFlag,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(uidFlag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SubmitBackupActor*>(this)->actor_wait_state > 0) static_cast<SubmitBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBackupActor*>(this)->ActorCallback< SubmitBackupActor, 0, Optional<UidAndAbortedFlagT> >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 0, Optional<UidAndAbortedFlagT> >*,Optional<UidAndAbortedFlagT> const& value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 0, Optional<UidAndAbortedFlagT> >*,Optional<UidAndAbortedFlagT> && value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SubmitBackupActor, 0, Optional<UidAndAbortedFlagT> >*,Error err) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2016 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForCompletion)
															#line 7265 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2017 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("Submitted and now waiting for the backup on tag `%s' to complete. (DRY RUN)\n", printable(StringRef(tagName)).c_str());
															#line 7269 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont8(loopDepth);
		}
		else
		{
															#line 2023 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<bool> __when_expr_2 = backupAgent.checkActive(db);
															#line 2023 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7278 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<SubmitBackupActor*>(this)->actor_wait_state = 3;
															#line 2023 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 2, bool >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7283 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont5(EBackupState const& backupStatus,int loopDepth) 
	{
															#line 2011 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (BackupAgentBase::isRunnable(backupStatus))
															#line 7293 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2012 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(backup_duplicate(), loopDepth);
															#line 7297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(EBackupState && backupStatus,int loopDepth) 
	{
															#line 2011 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (BackupAgentBase::isRunnable(backupStatus))
															#line 7307 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2012 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(backup_duplicate(), loopDepth);
															#line 7311 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(EBackupState const& backupStatus,int loopDepth) 
	{
		loopDepth = a_body1cont5(backupStatus, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(EBackupState && backupStatus,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(backupStatus), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SubmitBackupActor*>(this)->actor_wait_state > 0) static_cast<SubmitBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBackupActor*>(this)->ActorCallback< SubmitBackupActor, 1, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 1, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 1, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SubmitBackupActor, 1, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(bool const& agentRunning,int loopDepth) 
	{
															#line 2025 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!agentRunning)
															#line 7402 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2026 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully submitted but no backup agents are responding. " "(DRY RUN)\n", printable(StringRef(tagName)).c_str());
															#line 2031 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7408 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2033 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully submitted. (DRY RUN)\n", printable(StringRef(tagName)).c_str());
															#line 7414 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(bool && agentRunning,int loopDepth) 
	{
															#line 2025 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!agentRunning)
															#line 7424 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2026 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully submitted but no backup agents are responding. " "(DRY RUN)\n", printable(StringRef(tagName)).c_str());
															#line 2031 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7430 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2033 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully submitted. (DRY RUN)\n", printable(StringRef(tagName)).c_str());
															#line 7436 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(bool const& agentRunning,int loopDepth) 
	{
		loopDepth = a_body1cont10(agentRunning, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(bool && agentRunning,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(agentRunning), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SubmitBackupActor*>(this)->actor_wait_state > 0) static_cast<SubmitBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBackupActor*>(this)->ActorCallback< SubmitBackupActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SubmitBackupActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 2055 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForCompletion)
															#line 7521 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2056 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("Submitted and now waiting for the backup on tag `%s' to complete.\n", printable(StringRef(tagName)).c_str());
															#line 2058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_4 = success(backupAgent.waitBackup(db, tagName));
															#line 2058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7529 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
			static_cast<SubmitBackupActor*>(this)->actor_wait_state = 5;
															#line 2058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 4, Void >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7534 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<bool> __when_expr_5 = backupAgent.checkActive(db);
															#line 2061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7543 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont11when2(__when_expr_5.get(), loopDepth); };
			static_cast<SubmitBackupActor*>(this)->actor_wait_state = 6;
															#line 2061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 5, bool >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7548 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 2055 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForCompletion)
															#line 7558 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2056 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("Submitted and now waiting for the backup on tag `%s' to complete.\n", printable(StringRef(tagName)).c_str());
															#line 2058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_4 = success(backupAgent.waitBackup(db, tagName));
															#line 2058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7566 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
			static_cast<SubmitBackupActor*>(this)->actor_wait_state = 5;
															#line 2058 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 4, Void >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7571 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<bool> __when_expr_5 = backupAgent.checkActive(db);
															#line 2061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<SubmitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7580 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont11when2(__when_expr_5.get(), loopDepth); };
			static_cast<SubmitBackupActor*>(this)->actor_wait_state = 6;
															#line 2061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< SubmitBackupActor, 5, bool >*>(static_cast<SubmitBackupActor*>(this)));
															#line 7585 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SubmitBackupActor*>(this)->actor_wait_state > 0) static_cast<SubmitBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBackupActor*>(this)->ActorCallback< SubmitBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SubmitBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SubmitBackupActor*>(this)->actor_wait_state > 0) static_cast<SubmitBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBackupActor*>(this)->ActorCallback< SubmitBackupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SubmitBackupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont3(bool const& agentRunning,int loopDepth) 
	{
															#line 2063 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!agentRunning)
															#line 7763 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2064 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully submitted but no backup agents are responding.\n", printable(StringRef(tagName)).c_str());
															#line 2068 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7769 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2070 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully submitted.\n", printable(StringRef(tagName)).c_str());
															#line 7775 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont3(bool && agentRunning,int loopDepth) 
	{
															#line 2063 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!agentRunning)
															#line 7785 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2064 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully submitted but no backup agents are responding.\n", printable(StringRef(tagName)).c_str());
															#line 2068 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7791 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2070 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully submitted.\n", printable(StringRef(tagName)).c_str());
															#line 7797 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when2(bool const& agentRunning,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(agentRunning, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when2(bool && agentRunning,int loopDepth) 
	{
		loopDepth = a_body1cont11cont3(std::move(agentRunning), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<SubmitBackupActor*>(this)->actor_wait_state > 0) static_cast<SubmitBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitBackupActor*>(this)->ActorCallback< SubmitBackupActor, 5, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 5, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< SubmitBackupActor, 5, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< SubmitBackupActor, 5, bool >*,Error err) 
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string url;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int initialSnapshotIntervalSeconds;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int snapshotIntervalSeconds;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool encryptionEnabled;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool dryRun;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	WaitForComplete waitForCompletion;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	StopWhenDone stopWhenDone;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	UsePartitionedLog usePartitionedLog;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	IncrementalBackupOnly incrementalBackupOnly;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> encryptionKeyFile;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> blobManifestUrl;
															#line 1999 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 2003 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	KeyBackedTag tag;
															#line 7925 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via submitBackup()
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class SubmitBackupActor final : public Actor<Void>, public ActorCallback< SubmitBackupActor, 0, Optional<UidAndAbortedFlagT> >, public ActorCallback< SubmitBackupActor, 1, EBackupState >, public ActorCallback< SubmitBackupActor, 2, bool >, public ActorCallback< SubmitBackupActor, 3, Void >, public ActorCallback< SubmitBackupActor, 4, Void >, public ActorCallback< SubmitBackupActor, 5, bool >, public FastAllocated<SubmitBackupActor>, public SubmitBackupActorState<SubmitBackupActor> {
															#line 7930 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<SubmitBackupActor>::operator new;
	using FastAllocated<SubmitBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7893694034803164672UL, 3814211784094075648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SubmitBackupActor, 0, Optional<UidAndAbortedFlagT> >;
friend struct ActorCallback< SubmitBackupActor, 1, EBackupState >;
friend struct ActorCallback< SubmitBackupActor, 2, bool >;
friend struct ActorCallback< SubmitBackupActor, 3, Void >;
friend struct ActorCallback< SubmitBackupActor, 4, Void >;
friend struct ActorCallback< SubmitBackupActor, 5, bool >;
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	SubmitBackupActor(Database const& db,std::string const& url,Optional<std::string> const& proxy,int const& initialSnapshotIntervalSeconds,int const& snapshotIntervalSeconds,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,bool const& encryptionEnabled,std::string const& tagName,bool const& dryRun,WaitForComplete const& waitForCompletion,StopWhenDone const& stopWhenDone,UsePartitionedLog const& usePartitionedLog,IncrementalBackupOnly const& incrementalBackupOnly,Optional<std::string> const& encryptionKeyFile,Optional<std::string> const& blobManifestUrl) 
															#line 7952 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   SubmitBackupActorState<SubmitBackupActor>(db, url, proxy, initialSnapshotIntervalSeconds, snapshotIntervalSeconds, backupRanges, encryptionEnabled, tagName, dryRun, waitForCompletion, stopWhenDone, usePartitionedLog, incrementalBackupOnly, encryptionKeyFile, blobManifestUrl),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("submitBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18359099997353481472UL, 11552600649657417216UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("submitBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("submitBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SubmitBackupActor, 0, Optional<UidAndAbortedFlagT> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SubmitBackupActor, 1, EBackupState >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SubmitBackupActor, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SubmitBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SubmitBackupActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< SubmitBackupActor, 5, bool >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> submitBackup( Database const& db, std::string const& url, Optional<std::string> const& proxy, int const& initialSnapshotIntervalSeconds, int const& snapshotIntervalSeconds, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, bool const& encryptionEnabled, std::string const& tagName, bool const& dryRun, WaitForComplete const& waitForCompletion, StopWhenDone const& stopWhenDone, UsePartitionedLog const& usePartitionedLog, IncrementalBackupOnly const& incrementalBackupOnly, Optional<std::string> const& encryptionKeyFile, Optional<std::string> const& blobManifestUrl ) {
															#line 1983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new SubmitBackupActor(db, url, proxy, initialSnapshotIntervalSeconds, snapshotIntervalSeconds, backupRanges, encryptionEnabled, tagName, dryRun, waitForCompletion, stopWhenDone, usePartitionedLog, incrementalBackupOnly, encryptionKeyFile, blobManifestUrl));
															#line 7990 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2095 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 7995 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via switchDBBackup()
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class SwitchDBBackupActor>
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class SwitchDBBackupActorState {
															#line 8002 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	SwitchDBBackupActorState(Database const& src,Database const& dest,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,std::string const& tagName,ForceAction const& forceAction) 
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : src(src),
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dest(dest),
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   backupRanges(backupRanges),
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   forceAction(forceAction)
															#line 8017 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("switchDBBackup", reinterpret_cast<unsigned long>(this));

	}
	~SwitchDBBackupActorState() 
	{
		fdb_probe_actor_destroy("switchDBBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = DatabaseBackupAgent(src);
															#line 2103 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				ASSERT(!backupRanges.empty());
															#line 2105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.atomicSwitchover(dest, KeyRef(tagName), backupRanges, StringRef(), StringRef(), forceAction);
															#line 2105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<SwitchDBBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8039 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SwitchDBBackupActor*>(this)->actor_wait_state = 1;
															#line 2105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SwitchDBBackupActor, 0, Void >*>(static_cast<SwitchDBBackupActor*>(this)));
															#line 8044 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SwitchDBBackupActorState();
		static_cast<SwitchDBBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2127 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<SwitchDBBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SwitchDBBackupActorState(); static_cast<SwitchDBBackupActor*>(this)->destroy(); return 0; }
															#line 8073 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<SwitchDBBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SwitchDBBackupActorState();
		static_cast<SwitchDBBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 8086 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2111 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8090 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2112 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			switch (e.code()) { case error_code_backup_error: fprintf(stderr, "ERROR: An error was encountered during submission\n"); break; case error_code_backup_duplicate: fprintf(stderr, "ERROR: A DR is already running on tag `%s'\n", printable(StringRef(tagName)).c_str()); break; default: fprintf(stderr, "ERROR: %s\n", e.what()); break; };
															#line 2124 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(backup_error(), loopDepth);
															#line 8096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2106 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The DR on tag `%s' was successfully switched.\n", printable(StringRef(tagName)).c_str());
															#line 8110 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2106 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The DR on tag `%s' was successfully switched.\n", printable(StringRef(tagName)).c_str());
															#line 8119 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SwitchDBBackupActor*>(this)->actor_wait_state > 0) static_cast<SwitchDBBackupActor*>(this)->actor_wait_state = 0;
		static_cast<SwitchDBBackupActor*>(this)->ActorCallback< SwitchDBBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SwitchDBBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("switchDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SwitchDBBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("switchDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SwitchDBBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("switchDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("switchDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database src;
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database dest;
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ForceAction forceAction;
															#line 2102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 8224 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via switchDBBackup()
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class SwitchDBBackupActor final : public Actor<Void>, public ActorCallback< SwitchDBBackupActor, 0, Void >, public FastAllocated<SwitchDBBackupActor>, public SwitchDBBackupActorState<SwitchDBBackupActor> {
															#line 8229 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<SwitchDBBackupActor>::operator new;
	using FastAllocated<SwitchDBBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2703844730967448832UL, 8241334716218842368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SwitchDBBackupActor, 0, Void >;
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	SwitchDBBackupActor(Database const& src,Database const& dest,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,std::string const& tagName,ForceAction const& forceAction) 
															#line 8246 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   SwitchDBBackupActorState<SwitchDBBackupActor>(src, dest, backupRanges, tagName, forceAction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("switchDBBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12934258304895371520UL, 10286419738032076800UL);
		ActorExecutionContextHelper __helper(static_cast<SwitchDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("switchDBBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("switchDBBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SwitchDBBackupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> switchDBBackup( Database const& src, Database const& dest, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, std::string const& tagName, ForceAction const& forceAction ) {
															#line 2096 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new SwitchDBBackupActor(src, dest, backupRanges, tagName, forceAction));
															#line 8279 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2129 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 8284 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via statusDBBackup()
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class StatusDBBackupActor>
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class StatusDBBackupActorState {
															#line 8291 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	StatusDBBackupActorState(Database const& src,Database const& dest,std::string const& tagName,int const& errorLimit) 
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : src(src),
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dest(dest),
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   errorLimit(errorLimit)
															#line 8304 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("statusDBBackup", reinterpret_cast<unsigned long>(this));

	}
	~StatusDBBackupActorState() 
	{
		fdb_probe_actor_destroy("statusDBBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2132 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = DatabaseBackupAgent(src);
															#line 2134 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<std::string> __when_expr_0 = backupAgent.getStatus(dest, errorLimit, StringRef(tagName));
															#line 2134 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<StatusDBBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8324 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StatusDBBackupActor*>(this)->actor_wait_state = 1;
															#line 2134 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StatusDBBackupActor, 0, std::string >*>(static_cast<StatusDBBackupActor*>(this)));
															#line 8329 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusDBBackupActorState();
		static_cast<StatusDBBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2143 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<StatusDBBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StatusDBBackupActorState(); static_cast<StatusDBBackupActor*>(this)->destroy(); return 0; }
															#line 8358 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<StatusDBBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StatusDBBackupActorState();
		static_cast<StatusDBBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 8371 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2138 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8375 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2139 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8381 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::string const& statusText,int loopDepth) 
	{
															#line 2135 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("%s\n", statusText.c_str());
															#line 8395 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::string && statusText,int loopDepth) 
	{
															#line 2135 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("%s\n", statusText.c_str());
															#line 8404 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string const& statusText,int loopDepth) 
	{
		loopDepth = a_body1cont2(statusText, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && statusText,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(statusText), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusDBBackupActor*>(this)->actor_wait_state > 0) static_cast<StatusDBBackupActor*>(this)->actor_wait_state = 0;
		static_cast<StatusDBBackupActor*>(this)->ActorCallback< StatusDBBackupActor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusDBBackupActor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StatusDBBackupActor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StatusDBBackupActor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database src;
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database dest;
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int errorLimit;
															#line 2132 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 8507 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via statusDBBackup()
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class StatusDBBackupActor final : public Actor<Void>, public ActorCallback< StatusDBBackupActor, 0, std::string >, public FastAllocated<StatusDBBackupActor>, public StatusDBBackupActorState<StatusDBBackupActor> {
															#line 8512 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<StatusDBBackupActor>::operator new;
	using FastAllocated<StatusDBBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13862009610394462208UL, 8319525703173323008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StatusDBBackupActor, 0, std::string >;
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	StatusDBBackupActor(Database const& src,Database const& dest,std::string const& tagName,int const& errorLimit) 
															#line 8529 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   StatusDBBackupActorState<StatusDBBackupActor>(src, dest, tagName, errorLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusDBBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6784743132643920896UL, 17988946486094774528UL);
		ActorExecutionContextHelper __helper(static_cast<StatusDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusDBBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusDBBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StatusDBBackupActor, 0, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> statusDBBackup( Database const& src, Database const& dest, std::string const& tagName, int const& errorLimit ) {
															#line 2130 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new StatusDBBackupActor(src, dest, tagName, errorLimit));
															#line 8562 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2145 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 8567 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via statusBackup()
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class StatusBackupActor>
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class StatusBackupActorState {
															#line 8574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	StatusBackupActorState(Database const& db,std::string const& tagName,ShowErrors const& showErrors,bool const& json) 
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   showErrors(showErrors),
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   json(json)
															#line 8587 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("statusBackup", reinterpret_cast<unsigned long>(this));

	}
	~StatusBackupActorState() 
	{
		fdb_probe_actor_destroy("statusBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2148 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = FileBackupAgent();
															#line 2150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<std::string> __when_expr_0 = json ? backupAgent.getStatusJSON(db, tagName) : backupAgent.getStatus(db, showErrors, tagName);
															#line 2150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<StatusBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8607 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StatusBackupActor*>(this)->actor_wait_state = 1;
															#line 2150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StatusBackupActor, 0, std::string >*>(static_cast<StatusBackupActor*>(this)));
															#line 8612 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StatusBackupActorState();
		static_cast<StatusBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2160 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<StatusBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StatusBackupActorState(); static_cast<StatusBackupActor*>(this)->destroy(); return 0; }
															#line 8641 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<StatusBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StatusBackupActorState();
		static_cast<StatusBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2154 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 8654 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2155 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8658 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2156 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2157 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8664 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::string const& statusText,int loopDepth) 
	{
															#line 2152 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("%s\n", statusText.c_str());
															#line 8678 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::string && statusText,int loopDepth) 
	{
															#line 2152 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("%s\n", statusText.c_str());
															#line 8687 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string const& statusText,int loopDepth) 
	{
		loopDepth = a_body1cont2(statusText, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::string && statusText,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(statusText), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StatusBackupActor*>(this)->actor_wait_state > 0) static_cast<StatusBackupActor*>(this)->actor_wait_state = 0;
		static_cast<StatusBackupActor*>(this)->ActorCallback< StatusBackupActor, 0, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< StatusBackupActor, 0, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("statusBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StatusBackupActor, 0, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("statusBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StatusBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StatusBackupActor, 0, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("statusBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StatusBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("statusBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ShowErrors showErrors;
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool json;
															#line 2148 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 8790 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via statusBackup()
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class StatusBackupActor final : public Actor<Void>, public ActorCallback< StatusBackupActor, 0, std::string >, public FastAllocated<StatusBackupActor>, public StatusBackupActorState<StatusBackupActor> {
															#line 8795 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<StatusBackupActor>::operator new;
	using FastAllocated<StatusBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5071138102255367168UL, 5685289484496296192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StatusBackupActor, 0, std::string >;
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	StatusBackupActor(Database const& db,std::string const& tagName,ShowErrors const& showErrors,bool const& json) 
															#line 8812 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   StatusBackupActorState<StatusBackupActor>(db, tagName, showErrors, json),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("statusBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3971972535890685952UL, 15106399922911370240UL);
		ActorExecutionContextHelper __helper(static_cast<StatusBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("statusBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("statusBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StatusBackupActor, 0, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> statusBackup( Database const& db, std::string const& tagName, ShowErrors const& showErrors, bool const& json ) {
															#line 2146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new StatusBackupActor(db, tagName, showErrors, json));
															#line 8845 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2162 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 8850 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via abortDBBackup()
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class AbortDBBackupActor>
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class AbortDBBackupActorState {
															#line 8857 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	AbortDBBackupActorState(Database const& src,Database const& dest,std::string const& tagName,PartialBackup const& partial,DstOnly const& dstOnly) 
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : src(src),
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dest(dest),
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   partial(partial),
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dstOnly(dstOnly)
															#line 8872 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("abortDBBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortDBBackupActorState() 
	{
		fdb_probe_actor_destroy("abortDBBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2169 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = DatabaseBackupAgent(src);
															#line 2171 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.abortBackup(dest, Key(tagName), partial, AbortOldBackup::False, dstOnly);
															#line 2171 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<AbortDBBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8892 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AbortDBBackupActor*>(this)->actor_wait_state = 1;
															#line 2171 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortDBBackupActor, 0, Void >*>(static_cast<AbortDBBackupActor*>(this)));
															#line 8897 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortDBBackupActorState();
		static_cast<AbortDBBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2192 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<AbortDBBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortDBBackupActorState(); static_cast<AbortDBBackupActor*>(this)->destroy(); return 0; }
															#line 8926 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<AbortDBBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortDBBackupActorState();
		static_cast<AbortDBBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2176 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 8939 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2177 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 8943 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2178 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			switch (e.code()) { case error_code_backup_error: fprintf(stderr, "ERROR: An error was encountered during submission\n"); break; case error_code_backup_unneeded: fprintf(stderr, "ERROR: A DR was not running on tag `%s'\n", printable(StringRef(tagName)).c_str()); break; default: fprintf(stderr, "ERROR: %s\n", e.what()); break; };
															#line 2189 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2172 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_1 = backupAgent.unlockBackup(dest, Key(tagName));
															#line 2172 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<AbortDBBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8965 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortDBBackupActor*>(this)->actor_wait_state = 2;
															#line 2172 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortDBBackupActor, 1, Void >*>(static_cast<AbortDBBackupActor*>(this)));
															#line 8970 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2172 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_1 = backupAgent.unlockBackup(dest, Key(tagName));
															#line 2172 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<AbortDBBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8981 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<AbortDBBackupActor*>(this)->actor_wait_state = 2;
															#line 2172 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AbortDBBackupActor, 1, Void >*>(static_cast<AbortDBBackupActor*>(this)));
															#line 8986 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortDBBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortDBBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortDBBackupActor*>(this)->ActorCallback< AbortDBBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AbortDBBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("abortDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortDBBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("abortDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortDBBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("abortDBBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortDBBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 2174 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The DR on tag `%s' was successfully aborted.\n", printable(StringRef(tagName)).c_str());
															#line 9070 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 2174 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The DR on tag `%s' was successfully aborted.\n", printable(StringRef(tagName)).c_str());
															#line 9079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AbortDBBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortDBBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortDBBackupActor*>(this)->ActorCallback< AbortDBBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AbortDBBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("abortDBBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortDBBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AbortDBBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("abortDBBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortDBBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AbortDBBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("abortDBBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortDBBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database src;
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database dest;
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	PartialBackup partial;
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DstOnly dstOnly;
															#line 2169 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 9184 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via abortDBBackup()
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class AbortDBBackupActor final : public Actor<Void>, public ActorCallback< AbortDBBackupActor, 0, Void >, public ActorCallback< AbortDBBackupActor, 1, Void >, public FastAllocated<AbortDBBackupActor>, public AbortDBBackupActorState<AbortDBBackupActor> {
															#line 9189 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<AbortDBBackupActor>::operator new;
	using FastAllocated<AbortDBBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6529595093237506048UL, 6375203782996999424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortDBBackupActor, 0, Void >;
friend struct ActorCallback< AbortDBBackupActor, 1, Void >;
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	AbortDBBackupActor(Database const& src,Database const& dest,std::string const& tagName,PartialBackup const& partial,DstOnly const& dstOnly) 
															#line 9207 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   AbortDBBackupActorState<AbortDBBackupActor>(src, dest, tagName, partial, dstOnly),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortDBBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5239347996023089664UL, 12701265163772387328UL);
		ActorExecutionContextHelper __helper(static_cast<AbortDBBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortDBBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortDBBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortDBBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AbortDBBackupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> abortDBBackup( Database const& src, Database const& dest, std::string const& tagName, PartialBackup const& partial, DstOnly const& dstOnly ) {
															#line 2163 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new AbortDBBackupActor(src, dest, tagName, partial, dstOnly));
															#line 9241 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2194 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 9246 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via abortBackup()
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class AbortBackupActor>
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class AbortBackupActorState {
															#line 9253 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	AbortBackupActorState(Database const& db,std::string const& tagName) 
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName)
															#line 9262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("abortBackup", reinterpret_cast<unsigned long>(this));

	}
	~AbortBackupActorState() 
	{
		fdb_probe_actor_destroy("abortBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2197 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = FileBackupAgent();
															#line 2199 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.abortBackup(db, tagName);
															#line 2199 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<AbortBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9282 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AbortBackupActor*>(this)->actor_wait_state = 1;
															#line 2199 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AbortBackupActor, 0, Void >*>(static_cast<AbortBackupActor*>(this)));
															#line 9287 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AbortBackupActorState();
		static_cast<AbortBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2219 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<AbortBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~AbortBackupActorState(); static_cast<AbortBackupActor*>(this)->destroy(); return 0; }
															#line 9316 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<AbortBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~AbortBackupActorState();
		static_cast<AbortBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2203 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9329 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2204 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 9333 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2205 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			switch (e.code()) { case error_code_backup_error: fprintf(stderr, "ERROR: An error was encountered during submission\n"); break; case error_code_backup_unneeded: fprintf(stderr, "ERROR: A backup was not running on tag `%s'\n", printable(StringRef(tagName)).c_str()); break; default: fprintf(stderr, "ERROR: %s\n", e.what()); break; };
															#line 2216 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9339 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2201 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The backup on tag `%s' was successfully aborted.\n", printable(StringRef(tagName)).c_str());
															#line 9353 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2201 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The backup on tag `%s' was successfully aborted.\n", printable(StringRef(tagName)).c_str());
															#line 9362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AbortBackupActor*>(this)->actor_wait_state > 0) static_cast<AbortBackupActor*>(this)->actor_wait_state = 0;
		static_cast<AbortBackupActor*>(this)->ActorCallback< AbortBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AbortBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("abortBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AbortBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("abortBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AbortBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AbortBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("abortBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AbortBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("abortBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2197 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 9461 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via abortBackup()
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class AbortBackupActor final : public Actor<Void>, public ActorCallback< AbortBackupActor, 0, Void >, public FastAllocated<AbortBackupActor>, public AbortBackupActorState<AbortBackupActor> {
															#line 9466 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<AbortBackupActor>::operator new;
	using FastAllocated<AbortBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2946093121078717440UL, 9104121675730957312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AbortBackupActor, 0, Void >;
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	AbortBackupActor(Database const& db,std::string const& tagName) 
															#line 9483 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   AbortBackupActorState<AbortBackupActor>(db, tagName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("abortBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4039161521281262080UL, 3232322567260270848UL);
		ActorExecutionContextHelper __helper(static_cast<AbortBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("abortBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("abortBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AbortBackupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> abortBackup( Database const& db, std::string const& tagName ) {
															#line 2195 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new AbortBackupActor(db, tagName));
															#line 9516 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2221 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 9521 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via cleanupMutations()
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class CleanupMutationsActor>
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class CleanupMutationsActorState {
															#line 9528 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	CleanupMutationsActorState(Database const& db,DeleteData const& deleteData) 
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   deleteData(deleteData)
															#line 9537 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanupMutations", reinterpret_cast<unsigned long>(this));

	}
	~CleanupMutationsActorState() 
	{
		fdb_probe_actor_destroy("cleanupMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2224 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = cleanupBackup(db, deleteData);
															#line 2224 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<CleanupMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9555 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CleanupMutationsActor*>(this)->actor_wait_state = 1;
															#line 2224 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupMutationsActor, 0, Void >*>(static_cast<CleanupMutationsActor*>(this)));
															#line 9560 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupMutationsActorState();
		static_cast<CleanupMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2232 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<CleanupMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupMutationsActorState(); static_cast<CleanupMutationsActor*>(this)->destroy(); return 0; }
															#line 9589 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<CleanupMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanupMutationsActorState();
		static_cast<CleanupMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2226 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9602 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2227 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 9606 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2228 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2229 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9612 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupMutationsActor*>(this)->actor_wait_state > 0) static_cast<CleanupMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupMutationsActor*>(this)->ActorCallback< CleanupMutationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupMutationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupMutationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupMutationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DeleteData deleteData;
															#line 9726 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via cleanupMutations()
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class CleanupMutationsActor final : public Actor<Void>, public ActorCallback< CleanupMutationsActor, 0, Void >, public FastAllocated<CleanupMutationsActor>, public CleanupMutationsActorState<CleanupMutationsActor> {
															#line 9731 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<CleanupMutationsActor>::operator new;
	using FastAllocated<CleanupMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11187275153453608448UL, 15644399907901125120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupMutationsActor, 0, Void >;
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	CleanupMutationsActor(Database const& db,DeleteData const& deleteData) 
															#line 9748 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   CleanupMutationsActorState<CleanupMutationsActor>(db, deleteData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9065717875616278016UL, 12212151061674520064UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupMutationsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> cleanupMutations( Database const& db, DeleteData const& deleteData ) {
															#line 2222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new CleanupMutationsActor(db, deleteData));
															#line 9781 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2234 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 9786 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via waitBackup()
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class WaitBackupActor>
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class WaitBackupActorState {
															#line 9793 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	WaitBackupActorState(Database const& db,std::string const& tagName,StopWhenDone const& stopWhenDone) 
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   stopWhenDone(stopWhenDone)
															#line 9804 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("waitBackup", reinterpret_cast<unsigned long>(this));

	}
	~WaitBackupActorState() 
	{
		fdb_probe_actor_destroy("waitBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2237 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = FileBackupAgent();
															#line 2239 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<EBackupState> __when_expr_0 = backupAgent.waitBackup(db, tagName, stopWhenDone);
															#line 2239 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<WaitBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9824 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitBackupActor*>(this)->actor_wait_state = 1;
															#line 2239 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitBackupActor, 0, EBackupState >*>(static_cast<WaitBackupActor*>(this)));
															#line 9829 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitBackupActorState();
		static_cast<WaitBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2251 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<WaitBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitBackupActorState(); static_cast<WaitBackupActor*>(this)->destroy(); return 0; }
															#line 9858 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<WaitBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitBackupActorState();
		static_cast<WaitBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2245 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 9871 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2246 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 9875 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2247 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2248 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9881 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(EBackupState const& status,int loopDepth) 
	{
															#line 2241 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The backup on tag `%s' %s.\n", printable(StringRef(tagName)).c_str(), BackupAgentBase::getStateText(status));
															#line 9895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(EBackupState && status,int loopDepth) 
	{
															#line 2241 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The backup on tag `%s' %s.\n", printable(StringRef(tagName)).c_str(), BackupAgentBase::getStateText(status));
															#line 9904 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EBackupState const& status,int loopDepth) 
	{
		loopDepth = a_body1cont2(status, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EBackupState && status,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(status), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitBackupActor*>(this)->actor_wait_state > 0) static_cast<WaitBackupActor*>(this)->actor_wait_state = 0;
		static_cast<WaitBackupActor*>(this)->ActorCallback< WaitBackupActor, 0, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< WaitBackupActor, 0, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("waitBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitBackupActor, 0, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("waitBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitBackupActor, 0, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("waitBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	StopWhenDone stopWhenDone;
															#line 2237 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 10005 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via waitBackup()
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class WaitBackupActor final : public Actor<Void>, public ActorCallback< WaitBackupActor, 0, EBackupState >, public FastAllocated<WaitBackupActor>, public WaitBackupActorState<WaitBackupActor> {
															#line 10010 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<WaitBackupActor>::operator new;
	using FastAllocated<WaitBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1160632528777655040UL, 15483098718621555200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitBackupActor, 0, EBackupState >;
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	WaitBackupActor(Database const& db,std::string const& tagName,StopWhenDone const& stopWhenDone) 
															#line 10027 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   WaitBackupActorState<WaitBackupActor>(db, tagName, stopWhenDone),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8100323752981523712UL, 9179565398015093504UL);
		ActorExecutionContextHelper __helper(static_cast<WaitBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitBackupActor, 0, EBackupState >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> waitBackup( Database const& db, std::string const& tagName, StopWhenDone const& stopWhenDone ) {
															#line 2235 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new WaitBackupActor(db, tagName, stopWhenDone));
															#line 10060 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2253 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 10065 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via discontinueBackup()
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class DiscontinueBackupActor>
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class DiscontinueBackupActorState {
															#line 10072 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DiscontinueBackupActorState(Database const& db,std::string const& tagName,WaitForComplete const& waitForCompletion) 
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   waitForCompletion(waitForCompletion)
															#line 10083 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("discontinueBackup", reinterpret_cast<unsigned long>(this));

	}
	~DiscontinueBackupActorState() 
	{
		fdb_probe_actor_destroy("discontinueBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2256 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = FileBackupAgent();
															#line 2258 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.discontinueBackup(db, StringRef(tagName));
															#line 2258 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<DiscontinueBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 10103 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DiscontinueBackupActor*>(this)->actor_wait_state = 1;
															#line 2258 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiscontinueBackupActor, 0, Void >*>(static_cast<DiscontinueBackupActor*>(this)));
															#line 10108 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiscontinueBackupActorState();
		static_cast<DiscontinueBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2291 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<DiscontinueBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiscontinueBackupActorState(); static_cast<DiscontinueBackupActor*>(this)->destroy(); return 0; }
															#line 10137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<DiscontinueBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiscontinueBackupActorState();
		static_cast<DiscontinueBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2270 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 10150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2271 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 10154 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2272 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			switch (e.code()) { case error_code_backup_error: fprintf(stderr, "ERROR: An encounter was error during submission\n"); break; case error_code_backup_unneeded: fprintf(stderr, "ERROR: A backup in not running on tag `%s'\n", printable(StringRef(tagName)).c_str()); break; case error_code_backup_duplicate: fprintf(stderr, "ERROR: The backup on tag `%s' is already discontinued\n", printable(StringRef(tagName)).c_str()); break; default: fprintf(stderr, "ERROR: %s\n", e.what()); break; };
															#line 2288 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 10160 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2261 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForCompletion)
															#line 10174 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("Discontinued and now waiting for the backup on tag `%s' to complete.\n", printable(StringRef(tagName)).c_str());
															#line 2264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(backupAgent.waitBackup(db, tagName));
															#line 2264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<DiscontinueBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 10182 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DiscontinueBackupActor*>(this)->actor_wait_state = 2;
															#line 2264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DiscontinueBackupActor, 1, Void >*>(static_cast<DiscontinueBackupActor*>(this)));
															#line 10187 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2266 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully discontinued.\n", printable(StringRef(tagName)).c_str());
															#line 10194 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2261 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForCompletion)
															#line 10204 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("Discontinued and now waiting for the backup on tag `%s' to complete.\n", printable(StringRef(tagName)).c_str());
															#line 2264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(backupAgent.waitBackup(db, tagName));
															#line 2264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<DiscontinueBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 10212 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DiscontinueBackupActor*>(this)->actor_wait_state = 2;
															#line 2264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DiscontinueBackupActor, 1, Void >*>(static_cast<DiscontinueBackupActor*>(this)));
															#line 10217 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2266 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("The backup on tag `%s' was successfully discontinued.\n", printable(StringRef(tagName)).c_str());
															#line 10224 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiscontinueBackupActor*>(this)->actor_wait_state > 0) static_cast<DiscontinueBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DiscontinueBackupActor*>(this)->ActorCallback< DiscontinueBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiscontinueBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("discontinueBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscontinueBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discontinueBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiscontinueBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("discontinueBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscontinueBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discontinueBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiscontinueBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("discontinueBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiscontinueBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discontinueBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DiscontinueBackupActor*>(this)->actor_wait_state > 0) static_cast<DiscontinueBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DiscontinueBackupActor*>(this)->ActorCallback< DiscontinueBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiscontinueBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("discontinueBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscontinueBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discontinueBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DiscontinueBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("discontinueBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiscontinueBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discontinueBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DiscontinueBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("discontinueBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiscontinueBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("discontinueBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	WaitForComplete waitForCompletion;
															#line 2256 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 10419 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via discontinueBackup()
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class DiscontinueBackupActor final : public Actor<Void>, public ActorCallback< DiscontinueBackupActor, 0, Void >, public ActorCallback< DiscontinueBackupActor, 1, Void >, public FastAllocated<DiscontinueBackupActor>, public DiscontinueBackupActorState<DiscontinueBackupActor> {
															#line 10424 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<DiscontinueBackupActor>::operator new;
	using FastAllocated<DiscontinueBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15508616038856254720UL, 9615217687363300352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiscontinueBackupActor, 0, Void >;
friend struct ActorCallback< DiscontinueBackupActor, 1, Void >;
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DiscontinueBackupActor(Database const& db,std::string const& tagName,WaitForComplete const& waitForCompletion) 
															#line 10442 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   DiscontinueBackupActorState<DiscontinueBackupActor>(db, tagName, waitForCompletion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("discontinueBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2337492052312507648UL, 9767043327415872512UL);
		ActorExecutionContextHelper __helper(static_cast<DiscontinueBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("discontinueBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("discontinueBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiscontinueBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DiscontinueBackupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> discontinueBackup( Database const& db, std::string const& tagName, WaitForComplete const& waitForCompletion ) {
															#line 2254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new DiscontinueBackupActor(db, tagName, waitForCompletion));
															#line 10476 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2293 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 10481 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via changeBackupResumed()
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class ChangeBackupResumedActor>
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ChangeBackupResumedActorState {
															#line 10488 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ChangeBackupResumedActorState(Database const& db,bool const& pause) 
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   pause(pause)
															#line 10497 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("changeBackupResumed", reinterpret_cast<unsigned long>(this));

	}
	~ChangeBackupResumedActorState() 
	{
		fdb_probe_actor_destroy("changeBackupResumed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2296 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				FileBackupAgent backupAgent;
															#line 2297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.changePause(db, pause);
															#line 2297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<ChangeBackupResumedActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 10517 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ChangeBackupResumedActor*>(this)->actor_wait_state = 1;
															#line 2297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeBackupResumedActor, 0, Void >*>(static_cast<ChangeBackupResumedActor*>(this)));
															#line 10522 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeBackupResumedActorState();
		static_cast<ChangeBackupResumedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2306 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<ChangeBackupResumedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeBackupResumedActorState(); static_cast<ChangeBackupResumedActor*>(this)->destroy(); return 0; }
															#line 10551 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<ChangeBackupResumedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeBackupResumedActorState();
		static_cast<ChangeBackupResumedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2300 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 10564 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2301 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 10568 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2302 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2303 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 10574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2298 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("All backup agents have been %s.\n", pause ? "paused" : "resumed");
															#line 10588 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2298 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("All backup agents have been %s.\n", pause ? "paused" : "resumed");
															#line 10597 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeBackupResumedActor*>(this)->actor_wait_state > 0) static_cast<ChangeBackupResumedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeBackupResumedActor*>(this)->ActorCallback< ChangeBackupResumedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeBackupResumedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeBackupResumed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeBackupResumedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeBackupResumed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeBackupResumedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeBackupResumed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeBackupResumedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeBackupResumed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeBackupResumedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeBackupResumed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeBackupResumedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeBackupResumed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool pause;
															#line 10694 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via changeBackupResumed()
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ChangeBackupResumedActor final : public Actor<Void>, public ActorCallback< ChangeBackupResumedActor, 0, Void >, public FastAllocated<ChangeBackupResumedActor>, public ChangeBackupResumedActorState<ChangeBackupResumedActor> {
															#line 10699 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<ChangeBackupResumedActor>::operator new;
	using FastAllocated<ChangeBackupResumedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11477002918737931264UL, 1403169894595199232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeBackupResumedActor, 0, Void >;
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ChangeBackupResumedActor(Database const& db,bool const& pause) 
															#line 10716 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeBackupResumedActorState<ChangeBackupResumedActor>(db, pause),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeBackupResumed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5740272444162856192UL, 3490498534983205632UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeBackupResumedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeBackupResumed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeBackupResumed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeBackupResumedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> changeBackupResumed( Database const& db, bool const& pause ) {
															#line 2294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new ChangeBackupResumedActor(db, pause));
															#line 10749 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2308 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 10754 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via changeDBBackupResumed()
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class ChangeDBBackupResumedActor>
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ChangeDBBackupResumedActorState {
															#line 10761 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ChangeDBBackupResumedActorState(Database const& src,Database const& dest,bool const& pause) 
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : src(src),
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dest(dest),
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   pause(pause)
															#line 10772 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("changeDBBackupResumed", reinterpret_cast<unsigned long>(this));

	}
	~ChangeDBBackupResumedActorState() 
	{
		fdb_probe_actor_destroy("changeDBBackupResumed", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2311 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = DatabaseBackupAgent(src);
															#line 2312 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.taskBucket->changePause(dest, pause);
															#line 2312 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<ChangeDBBackupResumedActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 10792 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ChangeDBBackupResumedActor*>(this)->actor_wait_state = 1;
															#line 2312 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeDBBackupResumedActor, 0, Void >*>(static_cast<ChangeDBBackupResumedActor*>(this)));
															#line 10797 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeDBBackupResumedActorState();
		static_cast<ChangeDBBackupResumedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2321 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<ChangeDBBackupResumedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeDBBackupResumedActorState(); static_cast<ChangeDBBackupResumedActor*>(this)->destroy(); return 0; }
															#line 10826 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<ChangeDBBackupResumedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeDBBackupResumedActorState();
		static_cast<ChangeDBBackupResumedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2315 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 10839 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2316 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 10843 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2317 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2318 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 10849 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2313 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("All DR agents have been %s.\n", pause ? "paused" : "resumed");
															#line 10863 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2313 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("All DR agents have been %s.\n", pause ? "paused" : "resumed");
															#line 10872 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeDBBackupResumedActor*>(this)->actor_wait_state > 0) static_cast<ChangeDBBackupResumedActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeDBBackupResumedActor*>(this)->ActorCallback< ChangeDBBackupResumedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeDBBackupResumedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeDBBackupResumed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeDBBackupResumedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeDBBackupResumed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeDBBackupResumedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeDBBackupResumed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeDBBackupResumedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeDBBackupResumed", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeDBBackupResumedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeDBBackupResumed", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeDBBackupResumedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeDBBackupResumed", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database src;
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database dest;
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool pause;
															#line 2311 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 10973 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via changeDBBackupResumed()
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ChangeDBBackupResumedActor final : public Actor<Void>, public ActorCallback< ChangeDBBackupResumedActor, 0, Void >, public FastAllocated<ChangeDBBackupResumedActor>, public ChangeDBBackupResumedActorState<ChangeDBBackupResumedActor> {
															#line 10978 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<ChangeDBBackupResumedActor>::operator new;
	using FastAllocated<ChangeDBBackupResumedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2041442316472429312UL, 1295567874558526208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeDBBackupResumedActor, 0, Void >;
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ChangeDBBackupResumedActor(Database const& src,Database const& dest,bool const& pause) 
															#line 10995 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeDBBackupResumedActorState<ChangeDBBackupResumedActor>(src, dest, pause),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeDBBackupResumed", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(597146982358788352UL, 9082939010306173184UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeDBBackupResumedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeDBBackupResumed");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeDBBackupResumed", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeDBBackupResumedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> changeDBBackupResumed( Database const& src, Database const& dest, bool const& pause ) {
															#line 2309 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new ChangeDBBackupResumedActor(src, dest, pause));
															#line 11028 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2323 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

Reference<IBackupContainer> openBackupContainer(const char* name,
                                                const std::string& destinationContainer,
                                                const Optional<std::string>& proxy,
                                                const Optional<std::string>& encryptionKeyFile) {
	// Error, if no dest container was specified
	if (destinationContainer.empty()) {
		fprintf(stderr, "ERROR: No backup destination was specified.\n");
		printHelpTeaser(name);
		throw backup_error();
	}

	if (destinationContainer.find("../") != std::string::npos) {
		fprintf(
		    stderr, "ERROR: Backup Container URL '%s' contains directory traversals\n", destinationContainer.c_str());
		printHelpTeaser(name);
		throw backup_invalid_url();
	}

	Reference<IBackupContainer> c;
	try {
		c = IBackupContainer::openContainer(destinationContainer, proxy, encryptionKeyFile);
	} catch (Error& e) {
		std::string msg = format("ERROR: '%s' on URL '%s'", e.what(), destinationContainer.c_str());
		if (e.code() == error_code_backup_invalid_url && !IBackupContainer::lastOpenError.empty()) {
			msg += format(": %s", IBackupContainer::lastOpenError.c_str());
		}
		fprintf(stderr, "%s\n", msg.c_str());
		printHelpTeaser(name);
		throw;
	}

	return c;
}

// Submit the restore request to the database if "performRestore" is true. Otherwise,
// check if the restore can be performed.
															#line 11069 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via runRestore()
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class RunRestoreActor>
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class RunRestoreActorState {
															#line 11076 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RunRestoreActorState(Database const& db,std::string const& originalClusterFile,std::string const& tagName,std::string const& container,Optional<std::string> const& proxy,Standalone<VectorRef<KeyRangeRef>> const& ranges,Version const& beginVersion,Version const& targetVersion,std::string const& targetTimestamp,bool const& performRestore,Verbose const& verbose,WaitForComplete const& waitForDone,std::string const& addPrefix,std::string const& removePrefix,OnlyApplyMutationLogs const& onlyApplyMutationLogs,InconsistentSnapshotOnly const& inconsistentSnapshotOnly,Optional<std::string> const& encryptionKeyFile,Optional<std::string> const& blobManifestUrl) 
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   originalClusterFile(originalClusterFile),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   container(container),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   ranges(ranges),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   beginVersion(beginVersion),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   targetVersion(targetVersion),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   targetTimestamp(targetTimestamp),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   performRestore(performRestore),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   verbose(verbose),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   waitForDone(waitForDone),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   addPrefix(addPrefix),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   removePrefix(removePrefix),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   onlyApplyMutationLogs(onlyApplyMutationLogs),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   inconsistentSnapshotOnly(inconsistentSnapshotOnly),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   encryptionKeyFile(encryptionKeyFile),
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   blobManifestUrl(blobManifestUrl)
															#line 11117 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("runRestore", reinterpret_cast<unsigned long>(this));

	}
	~RunRestoreActorState() 
	{
		fdb_probe_actor_destroy("runRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2378 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			ASSERT(!ranges.empty());
															#line 2380 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (targetVersion != invalidVersion && !targetTimestamp.empty())
															#line 11134 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2381 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				fprintf(stderr, "Restore target version and target timestamp cannot both be specified\n");
															#line 2382 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(restore_error(), loopDepth);
															#line 11140 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2385 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			origDb = Optional<Database>();
															#line 2388 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!targetTimestamp.empty())
															#line 11146 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2389 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (originalClusterFile.empty())
															#line 11150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2390 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					fprintf(stderr, "An original cluster file must be given in order to resolve restore target timestamp '%s'\n", targetTimestamp.c_str());
															#line 2393 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					return a_body1Catch1(restore_error(), loopDepth);
															#line 11156 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				}
															#line 2396 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (!fileExists(originalClusterFile))
															#line 11160 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2397 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					fprintf( stderr, "Original source database cluster file '%s' does not exist.\n", originalClusterFile.c_str());
															#line 2399 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					return a_body1Catch1(restore_error(), loopDepth);
															#line 11166 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				}
															#line 2402 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				origDb = Database::createDatabase(originalClusterFile, ApiVersion::LATEST_VERSION);
															#line 2403 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Version> __when_expr_0 = timeKeeperVersionFromDatetime(targetTimestamp, origDb.get());
															#line 2403 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<RunRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11174 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunRestoreActor*>(this)->actor_wait_state = 1;
															#line 2403 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunRestoreActor, 0, Version >*>(static_cast<RunRestoreActor*>(this)));
															#line 11179 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunRestoreActorState();
		static_cast<RunRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 2409 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			backupAgent = FileBackupAgent();
															#line 2411 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			bc = openBackupContainer(exeRestore.toString().c_str(), container, proxy, encryptionKeyFile);
															#line 2415 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (targetVersion == invalidVersion)
															#line 11212 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2416 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (verbose)
															#line 11216 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2417 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					printf( "No restore target version given, will use maximum restorable version from backup description.\n");
															#line 11220 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				}
															#line 2420 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<BackupDescription> __when_expr_1 = bc->describeBackup();
															#line 2420 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<RunRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 11226 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<RunRestoreActor*>(this)->actor_wait_state = 2;
															#line 2420 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunRestoreActor, 1, BackupDescription >*>(static_cast<RunRestoreActor*>(this)));
															#line 11231 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont8(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Version const& v,int loopDepth) 
	{
															#line 2404 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		fmt::print("Timestamp '{0}' resolves to version {1}\n", targetTimestamp, v);
															#line 2405 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		targetVersion = v;
															#line 11253 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Version && v,int loopDepth) 
	{
															#line 2404 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		fmt::print("Timestamp '{0}' resolves to version {1}\n", targetTimestamp, v);
															#line 2405 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		targetVersion = v;
															#line 11264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont3(v, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunRestoreActor*>(this)->ActorCallback< RunRestoreActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RunRestoreActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunRestoreActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunRestoreActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 2483 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<RunRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunRestoreActorState(); static_cast<RunRestoreActor*>(this)->destroy(); return 0; }
															#line 11348 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<RunRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunRestoreActorState();
		static_cast<RunRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2477 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 11361 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2478 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 11365 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2479 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2480 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 11371 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
															#line 2439 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (performRestore)
															#line 11385 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Version> __when_expr_2 = backupAgent.restore(db, origDb, KeyRef(tagName), KeyRef(container), proxy, ranges, waitForDone, targetVersion, verbose, KeyRef(addPrefix), KeyRef(removePrefix), LockDB::True, UnlockDB::True, onlyApplyMutationLogs, inconsistentSnapshotOnly, beginVersion, encryptionKeyFile, blobManifestUrl);
															#line 2440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 11391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont8when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunRestoreActor*>(this)->actor_wait_state = 3;
															#line 2440 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunRestoreActor, 2, Version >*>(static_cast<RunRestoreActor*>(this)));
															#line 11396 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2464 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Optional<RestorableFileSet>> __when_expr_3 = bc->getRestoreSet(targetVersion, ranges);
															#line 2464 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunRestoreActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 11405 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when2(__when_expr_3.get(), loopDepth); };
			static_cast<RunRestoreActor*>(this)->actor_wait_state = 4;
															#line 2464 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunRestoreActor, 3, Optional<RestorableFileSet> >*>(static_cast<RunRestoreActor*>(this)));
															#line 11410 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont9(BackupDescription const& desc,int loopDepth) 
	{
															#line 2421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (blobManifestUrl.present())
															#line 11420 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2422 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			onlyApplyMutationLogs = OnlyApplyMutationLogs::True;
															#line 11424 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2425 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (onlyApplyMutationLogs && desc.contiguousLogEnd.present())
															#line 11428 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2426 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			targetVersion = desc.contiguousLogEnd.get() - 1;
															#line 11432 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2427 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (desc.maxRestorableVersion.present())
															#line 11438 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2428 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				targetVersion = desc.maxRestorableVersion.get();
															#line 11442 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
			else
			{
															#line 2430 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				fprintf(stderr, "The specified backup is not restorable to any version.\n");
															#line 2431 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1cont1Catch1(restore_error(), loopDepth);
															#line 11450 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
		}
															#line 2434 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (verbose)
															#line 11455 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2435 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("Using target restore version {}\n", targetVersion);
															#line 11459 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(BackupDescription && desc,int loopDepth) 
	{
															#line 2421 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (blobManifestUrl.present())
															#line 11469 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2422 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			onlyApplyMutationLogs = OnlyApplyMutationLogs::True;
															#line 11473 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2425 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (onlyApplyMutationLogs && desc.contiguousLogEnd.present())
															#line 11477 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2426 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			targetVersion = desc.contiguousLogEnd.get() - 1;
															#line 11481 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2427 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (desc.maxRestorableVersion.present())
															#line 11487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2428 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				targetVersion = desc.maxRestorableVersion.get();
															#line 11491 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
			else
			{
															#line 2430 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				fprintf(stderr, "The specified backup is not restorable to any version.\n");
															#line 2431 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1cont1Catch1(restore_error(), loopDepth);
															#line 11499 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
		}
															#line 2434 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (verbose)
															#line 11504 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2435 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("Using target restore version {}\n", targetVersion);
															#line 11508 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont9(desc, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunRestoreActor*>(this)->ActorCallback< RunRestoreActor, 1, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< RunRestoreActor, 1, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunRestoreActor, 1, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunRestoreActor, 1, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont18(int loopDepth) 
	{
		loopDepth = a_body1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont19(Version const& restoredVersion,int loopDepth) 
	{
															#line 2459 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForDone && verbose)
															#line 11599 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2461 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("Restored to version {}\n", restoredVersion);
															#line 11603 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1cont19(Version && restoredVersion,int loopDepth) 
	{
															#line 2459 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForDone && verbose)
															#line 11613 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2461 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("Restored to version {}\n", restoredVersion);
															#line 11617 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Version const& restoredVersion,int loopDepth) 
	{
		loopDepth = a_body1cont19(restoredVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Version && restoredVersion,int loopDepth) 
	{
		loopDepth = a_body1cont19(std::move(restoredVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunRestoreActor*>(this)->ActorCallback< RunRestoreActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RunRestoreActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunRestoreActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunRestoreActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont20(int loopDepth) 
	{
															#line 2466 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!rset.present())
															#line 11702 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2467 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print(stderr, "Insufficient data to restore to version {}.  Describe backup for more information.\n", targetVersion);
															#line 2470 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1cont1Catch1(restore_invalid_version(), loopDepth);
															#line 11708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2473 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		fmt::print("Backup can be used to restore to version {}\n", targetVersion);
															#line 11712 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont18(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(Optional<RestorableFileSet> const& __rset,int loopDepth) 
	{
															#line 2464 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		rset = __rset;
															#line 11721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when2(Optional<RestorableFileSet> && __rset,int loopDepth) 
	{
		rset = std::move(__rset);
		loopDepth = a_body1cont20(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunRestoreActor*>(this)->actor_wait_state > 0) static_cast<RunRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<RunRestoreActor*>(this)->ActorCallback< RunRestoreActor, 3, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< RunRestoreActor, 3, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunRestoreActor, 3, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunRestoreActor, 3, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont18cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string originalClusterFile;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string container;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version beginVersion;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version targetVersion;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string targetTimestamp;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool performRestore;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Verbose verbose;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	WaitForComplete waitForDone;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string addPrefix;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string removePrefix;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	OnlyApplyMutationLogs onlyApplyMutationLogs;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	InconsistentSnapshotOnly inconsistentSnapshotOnly;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> encryptionKeyFile;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> blobManifestUrl;
															#line 2385 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<Database> origDb;
															#line 2409 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 2411 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 2464 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<RestorableFileSet> rset;
															#line 11853 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via runRestore()
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class RunRestoreActor final : public Actor<Void>, public ActorCallback< RunRestoreActor, 0, Version >, public ActorCallback< RunRestoreActor, 1, BackupDescription >, public ActorCallback< RunRestoreActor, 2, Version >, public ActorCallback< RunRestoreActor, 3, Optional<RestorableFileSet> >, public FastAllocated<RunRestoreActor>, public RunRestoreActorState<RunRestoreActor> {
															#line 11858 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<RunRestoreActor>::operator new;
	using FastAllocated<RunRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12655201814388386304UL, 11919834436150829568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunRestoreActor, 0, Version >;
friend struct ActorCallback< RunRestoreActor, 1, BackupDescription >;
friend struct ActorCallback< RunRestoreActor, 2, Version >;
friend struct ActorCallback< RunRestoreActor, 3, Optional<RestorableFileSet> >;
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RunRestoreActor(Database const& db,std::string const& originalClusterFile,std::string const& tagName,std::string const& container,Optional<std::string> const& proxy,Standalone<VectorRef<KeyRangeRef>> const& ranges,Version const& beginVersion,Version const& targetVersion,std::string const& targetTimestamp,bool const& performRestore,Verbose const& verbose,WaitForComplete const& waitForDone,std::string const& addPrefix,std::string const& removePrefix,OnlyApplyMutationLogs const& onlyApplyMutationLogs,InconsistentSnapshotOnly const& inconsistentSnapshotOnly,Optional<std::string> const& encryptionKeyFile,Optional<std::string> const& blobManifestUrl) 
															#line 11878 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   RunRestoreActorState<RunRestoreActor>(db, originalClusterFile, tagName, container, proxy, ranges, beginVersion, targetVersion, targetTimestamp, performRestore, verbose, waitForDone, addPrefix, removePrefix, onlyApplyMutationLogs, inconsistentSnapshotOnly, encryptionKeyFile, blobManifestUrl),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3966921783101984512UL, 18250421531763870208UL);
		ActorExecutionContextHelper __helper(static_cast<RunRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunRestoreActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunRestoreActor, 1, BackupDescription >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunRestoreActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunRestoreActor, 3, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> runRestore( Database const& db, std::string const& originalClusterFile, std::string const& tagName, std::string const& container, Optional<std::string> const& proxy, Standalone<VectorRef<KeyRangeRef>> const& ranges, Version const& beginVersion, Version const& targetVersion, std::string const& targetTimestamp, bool const& performRestore, Verbose const& verbose, WaitForComplete const& waitForDone, std::string const& addPrefix, std::string const& removePrefix, OnlyApplyMutationLogs const& onlyApplyMutationLogs, InconsistentSnapshotOnly const& inconsistentSnapshotOnly, Optional<std::string> const& encryptionKeyFile, Optional<std::string> const& blobManifestUrl ) {
															#line 2360 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new RunRestoreActor(db, originalClusterFile, tagName, container, proxy, ranges, beginVersion, targetVersion, targetTimestamp, performRestore, verbose, waitForDone, addPrefix, removePrefix, onlyApplyMutationLogs, inconsistentSnapshotOnly, encryptionKeyFile, blobManifestUrl));
															#line 11914 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2485 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

// Fast restore agent that kicks off the restore: send restore requests to restore workers.
															#line 11920 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via runFastRestoreTool()
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class RunFastRestoreToolActor>
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class RunFastRestoreToolActorState {
															#line 11927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RunFastRestoreToolActorState(Database const& db,std::string const& tagName,std::string const& container,Optional<std::string> const& proxy,Standalone<VectorRef<KeyRangeRef>> const& ranges,Version const& dbVersion,bool const& performRestore,Verbose const& verbose,WaitForComplete const& waitForDone) 
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   container(container),
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy),
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   ranges(ranges),
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   dbVersion(dbVersion),
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   performRestore(performRestore),
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   verbose(verbose),
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   waitForDone(waitForDone)
															#line 11950 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("runFastRestoreTool", reinterpret_cast<unsigned long>(this));

	}
	~RunFastRestoreToolActorState() 
	{
		fdb_probe_actor_destroy("runFastRestoreTool", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2497 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				backupAgent = FileBackupAgent();
															#line 2498 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				restoreVersion = invalidVersion;
															#line 2500 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (ranges.size() > 1)
															#line 11970 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2501 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					fprintf(stdout, "[WARNING] Currently only a single restore range is tested!\n");
															#line 11974 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				}
															#line 2504 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (ranges.size() == 0)
															#line 11978 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2505 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					ranges.push_back(ranges.arena(), normalKeys);
															#line 11982 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				}
															#line 2508 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				printf("[INFO] runFastRestoreTool: restore_ranges:%d first range:%s\n", ranges.size(), ranges.front().toString().c_str());
															#line 2511 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				TraceEvent ev("FastRestoreTool");
															#line 2512 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				ev.detail("RestoreRanges", ranges.size());
															#line 2513 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				for(int i = 0;i < ranges.size();++i) {
															#line 2514 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					ev.detail(format("Range%d", i), ranges[i]);
															#line 11994 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				}
															#line 2517 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (performRestore)
															#line 11998 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2518 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					if (dbVersion == invalidVersion)
															#line 12002 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					{
															#line 2519 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
						TraceEvent("FastRestoreTool").detail("TargetRestoreVersion", "Largest restorable version");
															#line 2520 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
						StrictFuture<BackupDescription> __when_expr_0 = IBackupContainer::openContainer(container, proxy, {})->describeBackup();
															#line 2520 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
						if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12010 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
						if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
						static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 1;
															#line 2520 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
						__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunFastRestoreToolActor, 0, BackupDescription >*>(static_cast<RunFastRestoreToolActor*>(this)));
															#line 12015 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
						loopDepth = a_body1cont6(loopDepth);
					}
				}
				else
				{
															#line 2559 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					bc = IBackupContainer::openContainer(container, proxy, {});
															#line 2560 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					StrictFuture<BackupDescription> __when_expr_3 = bc->describeBackup();
															#line 2560 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12031 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1when2(__when_expr_3.get(), loopDepth); };
					static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 4;
															#line 2560 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunFastRestoreToolActor, 3, BackupDescription >*>(static_cast<RunFastRestoreToolActor*>(this)));
															#line 12036 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					loopDepth = 0;
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunFastRestoreToolActorState();
		static_cast<RunFastRestoreToolActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2598 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<RunFastRestoreToolActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunFastRestoreToolActorState(); static_cast<RunFastRestoreToolActor*>(this)->destroy(); return 0; }
															#line 12066 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<RunFastRestoreToolActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunFastRestoreToolActorState();
		static_cast<RunFastRestoreToolActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2592 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 12079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2593 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 12083 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2594 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2595 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 12089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2587 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForDone && verbose)
															#line 12103 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2589 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("Restored to version {0}{1}\n", restoreVersion, (performRestore) ? "" : " (DRY RUN)");
															#line 12107 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 2529 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		randomUID = deterministicRandom()->randomUniqueID();
															#line 2530 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		TraceEvent("FastRestoreTool") .detail("SubmitRestoreRequests", ranges.size()) .detail("RestoreUID", randomUID);
															#line 2533 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_1 = backupAgent.submitParallelRestore(db, KeyRef(tagName), ranges, KeyRef(container), proxy, dbVersion, LockDB::True, randomUID, ""_sr, ""_sr);
															#line 2533 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12123 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont6when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 2;
															#line 2533 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunFastRestoreToolActor, 1, Void >*>(static_cast<RunFastRestoreToolActor*>(this)));
															#line 12128 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7(BackupDescription const& desc,int loopDepth) 
	{
															#line 2521 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!desc.maxRestorableVersion.present())
															#line 12137 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2522 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "The specified backup is not restorable to any version.\n");
															#line 2523 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(restore_error(), loopDepth);
															#line 12143 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2526 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		dbVersion = desc.maxRestorableVersion.get();
															#line 2527 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		TraceEvent("FastRestoreTool").detail("TargetRestoreVersion", dbVersion);
															#line 12149 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(BackupDescription && desc,int loopDepth) 
	{
															#line 2521 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!desc.maxRestorableVersion.present())
															#line 12158 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2522 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "The specified backup is not restorable to any version.\n");
															#line 2523 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(restore_error(), loopDepth);
															#line 12164 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2526 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		dbVersion = desc.maxRestorableVersion.get();
															#line 2527 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		TraceEvent("FastRestoreTool").detail("TargetRestoreVersion", dbVersion);
															#line 12170 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont7(desc, loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state > 0) static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 0;
		static_cast<RunFastRestoreToolActor*>(this)->ActorCallback< RunFastRestoreToolActor, 0, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 0, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 0, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunFastRestoreToolActor, 0, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 2544 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForDone)
															#line 12254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2546 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent("FastRestoreTool").detail("BackupAndParallelRestore", "WaitForRestoreToFinish");
															#line 2547 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = backupAgent.parallelRestoreFinish(db, randomUID);
															#line 2547 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12262 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 3;
															#line 2547 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunFastRestoreToolActor, 2, Void >*>(static_cast<RunFastRestoreToolActor*>(this)));
															#line 12267 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2550 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent("FastRestoreTool") .detail("RestoreUID", randomUID) .detail("OperationGuide", "Manually unlock DB when restore finishes");
															#line 2553 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("WARNING: DB will be in locked state after restore. Need UID:%s to unlock DB\n", randomUID.toString().c_str());
															#line 12276 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 2544 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (waitForDone)
															#line 12286 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2546 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent("FastRestoreTool").detail("BackupAndParallelRestore", "WaitForRestoreToFinish");
															#line 2547 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = backupAgent.parallelRestoreFinish(db, randomUID);
															#line 2547 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12294 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont10when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 3;
															#line 2547 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunFastRestoreToolActor, 2, Void >*>(static_cast<RunFastRestoreToolActor*>(this)));
															#line 12299 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2550 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent("FastRestoreTool") .detail("RestoreUID", randomUID) .detail("OperationGuide", "Manually unlock DB when restore finishes");
															#line 2553 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("WARNING: DB will be in locked state after restore. Need UID:%s to unlock DB\n", randomUID.toString().c_str());
															#line 12308 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state > 0) static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 0;
		static_cast<RunFastRestoreToolActor*>(this)->ActorCallback< RunFastRestoreToolActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunFastRestoreToolActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10cont1(int loopDepth) 
	{
															#line 2557 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		restoreVersion = dbVersion;
															#line 12393 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 2548 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		TraceEvent("FastRestoreTool").detail("BackupAndParallelRestore", "RestoreFinished");
															#line 12402 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2(Void && _,int loopDepth) 
	{
															#line 2548 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		TraceEvent("FastRestoreTool").detail("BackupAndParallelRestore", "RestoreFinished");
															#line 12411 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state > 0) static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 0;
		static_cast<RunFastRestoreToolActor*>(this)->ActorCallback< RunFastRestoreToolActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunFastRestoreToolActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 2562 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (dbVersion <= 0)
															#line 12495 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2563 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_4 = description.resolveVersionTimes(db);
															#line 2563 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12501 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont11when1(__when_expr_4.get(), loopDepth); };
			static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 5;
															#line 2563 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunFastRestoreToolActor, 4, Void >*>(static_cast<RunFastRestoreToolActor*>(this)));
															#line 12506 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2571 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			restoreVersion = dbVersion;
															#line 12513 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when2(BackupDescription const& __description,int loopDepth) 
	{
															#line 2560 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		description = __description;
															#line 12523 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1when2(BackupDescription && __description,int loopDepth) 
	{
		description = std::move(__description);
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state > 0) static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 0;
		static_cast<RunFastRestoreToolActor*>(this)->ActorCallback< RunFastRestoreToolActor, 3, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 3, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 3, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunFastRestoreToolActor, 3, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11cont1(int loopDepth) 
	{
															#line 2574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Optional<RestorableFileSet>> __when_expr_5 = bc->getRestoreSet(restoreVersion);
															#line 2574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 12604 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont11cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 6;
															#line 2574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunFastRestoreToolActor, 5, Optional<RestorableFileSet> >*>(static_cast<RunFastRestoreToolActor*>(this)));
															#line 12609 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11cont2(Void const& _,int loopDepth) 
	{
															#line 2564 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (description.maxRestorableVersion.present())
															#line 12618 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2565 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			restoreVersion = description.maxRestorableVersion.get();
															#line 12622 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2567 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "Backup is not restorable\n");
															#line 2568 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(restore_invalid_version(), loopDepth);
															#line 12630 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont2(Void && _,int loopDepth) 
	{
															#line 2564 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (description.maxRestorableVersion.present())
															#line 12640 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2565 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			restoreVersion = description.maxRestorableVersion.get();
															#line 12644 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2567 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "Backup is not restorable\n");
															#line 2568 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(restore_invalid_version(), loopDepth);
															#line 12652 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state > 0) static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 0;
		static_cast<RunFastRestoreToolActor*>(this)->ActorCallback< RunFastRestoreToolActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunFastRestoreToolActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11cont7(int loopDepth) 
	{
															#line 2575 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!rset.present())
															#line 12737 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2576 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print(stderr, "Insufficient data to restore to version {}\n", restoreVersion);
															#line 2577 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch2(restore_invalid_version(), loopDepth);
															#line 12743 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2581 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (verbose)
															#line 12747 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2582 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("[DRY RUN] Restoring backup to version: {}\n", restoreVersion);
															#line 2583 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("{}\n", description.toString());
															#line 12753 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Optional<RestorableFileSet> const& __rset,int loopDepth) 
	{
															#line 2574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		rset = __rset;
															#line 12763 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1when1(Optional<RestorableFileSet> && __rset,int loopDepth) 
	{
		rset = std::move(__rset);
		loopDepth = a_body1cont11cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state > 0) static_cast<RunFastRestoreToolActor*>(this)->actor_wait_state = 0;
		static_cast<RunFastRestoreToolActor*>(this)->ActorCallback< RunFastRestoreToolActor, 5, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 5, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunFastRestoreToolActor, 5, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont11cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunFastRestoreToolActor, 5, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string container;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version dbVersion;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool performRestore;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Verbose verbose;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	WaitForComplete waitForDone;
															#line 2497 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	FileBackupAgent backupAgent;
															#line 2498 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version restoreVersion;
															#line 2529 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	UID randomUID;
															#line 2559 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 2560 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	BackupDescription description;
															#line 2574 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<RestorableFileSet> rset;
															#line 12881 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via runFastRestoreTool()
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class RunFastRestoreToolActor final : public Actor<Void>, public ActorCallback< RunFastRestoreToolActor, 0, BackupDescription >, public ActorCallback< RunFastRestoreToolActor, 1, Void >, public ActorCallback< RunFastRestoreToolActor, 2, Void >, public ActorCallback< RunFastRestoreToolActor, 3, BackupDescription >, public ActorCallback< RunFastRestoreToolActor, 4, Void >, public ActorCallback< RunFastRestoreToolActor, 5, Optional<RestorableFileSet> >, public FastAllocated<RunFastRestoreToolActor>, public RunFastRestoreToolActorState<RunFastRestoreToolActor> {
															#line 12886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<RunFastRestoreToolActor>::operator new;
	using FastAllocated<RunFastRestoreToolActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13466878117917919488UL, 11556320086442189312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunFastRestoreToolActor, 0, BackupDescription >;
friend struct ActorCallback< RunFastRestoreToolActor, 1, Void >;
friend struct ActorCallback< RunFastRestoreToolActor, 2, Void >;
friend struct ActorCallback< RunFastRestoreToolActor, 3, BackupDescription >;
friend struct ActorCallback< RunFastRestoreToolActor, 4, Void >;
friend struct ActorCallback< RunFastRestoreToolActor, 5, Optional<RestorableFileSet> >;
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	RunFastRestoreToolActor(Database const& db,std::string const& tagName,std::string const& container,Optional<std::string> const& proxy,Standalone<VectorRef<KeyRangeRef>> const& ranges,Version const& dbVersion,bool const& performRestore,Verbose const& verbose,WaitForComplete const& waitForDone) 
															#line 12908 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   RunFastRestoreToolActorState<RunFastRestoreToolActor>(db, tagName, container, proxy, ranges, dbVersion, performRestore, verbose, waitForDone),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runFastRestoreTool", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9317572082126141440UL, 9250210667758411264UL);
		ActorExecutionContextHelper __helper(static_cast<RunFastRestoreToolActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runFastRestoreTool");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runFastRestoreTool", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunFastRestoreToolActor, 0, BackupDescription >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunFastRestoreToolActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunFastRestoreToolActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunFastRestoreToolActor, 3, BackupDescription >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunFastRestoreToolActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunFastRestoreToolActor, 5, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> runFastRestoreTool( Database const& db, std::string const& tagName, std::string const& container, Optional<std::string> const& proxy, Standalone<VectorRef<KeyRangeRef>> const& ranges, Version const& dbVersion, bool const& performRestore, Verbose const& verbose, WaitForComplete const& waitForDone ) {
															#line 2487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new RunFastRestoreToolActor(db, tagName, container, proxy, ranges, dbVersion, performRestore, verbose, waitForDone));
															#line 12946 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2600 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 12951 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via dumpBackupData()
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class DumpBackupDataActor>
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class DumpBackupDataActorState {
															#line 12958 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DumpBackupDataActorState(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy,Version const& beginVersion,Version const& endVersion) 
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : name(name),
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   destinationContainer(destinationContainer),
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy),
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   beginVersion(beginVersion),
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   endVersion(endVersion),
															#line 2606 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   c(openBackupContainer(name, destinationContainer, proxy, {}))
															#line 12975 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpBackupData", reinterpret_cast<unsigned long>(this));

	}
	~DumpBackupDataActorState() 
	{
		fdb_probe_actor_destroy("dumpBackupData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2608 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (beginVersion < 0 || endVersion < 0)
															#line 12990 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2609 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<BackupDescription> __when_expr_0 = c->describeBackup();
															#line 2609 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<DumpBackupDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12996 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DumpBackupDataActor*>(this)->actor_wait_state = 1;
															#line 2609 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpBackupDataActor, 0, BackupDescription >*>(static_cast<DumpBackupDataActor*>(this)));
															#line 13001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpBackupDataActorState();
		static_cast<DumpBackupDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2625 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		fmt::print("Scanning version range {0} to {1}\n", beginVersion, endVersion);
															#line 2626 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<BackupFileList> __when_expr_1 = c->dumpFileList(beginVersion, endVersion);
															#line 2626 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<DumpBackupDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13033 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DumpBackupDataActor*>(this)->actor_wait_state = 2;
															#line 2626 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpBackupDataActor, 1, BackupFileList >*>(static_cast<DumpBackupDataActor*>(this)));
															#line 13038 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(BackupDescription const& desc,int loopDepth) 
	{
															#line 2611 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!desc.maxLogEnd.present())
															#line 13047 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2612 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: Backup must have log data in order to use relative begin/end versions.\n");
															#line 2613 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(backup_invalid_info(), loopDepth);
															#line 13053 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2616 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (beginVersion < 0)
															#line 13057 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2617 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			beginVersion += desc.maxLogEnd.get();
															#line 13061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2620 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (endVersion < 0)
															#line 13065 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2621 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			endVersion += desc.maxLogEnd.get();
															#line 13069 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(BackupDescription && desc,int loopDepth) 
	{
															#line 2611 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!desc.maxLogEnd.present())
															#line 13079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2612 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: Backup must have log data in order to use relative begin/end versions.\n");
															#line 2613 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(backup_invalid_info(), loopDepth);
															#line 13085 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2616 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (beginVersion < 0)
															#line 13089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2617 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			beginVersion += desc.maxLogEnd.get();
															#line 13093 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2620 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (endVersion < 0)
															#line 13097 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2621 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			endVersion += desc.maxLogEnd.get();
															#line 13101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont2(desc, loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpBackupDataActor*>(this)->actor_wait_state > 0) static_cast<DumpBackupDataActor*>(this)->actor_wait_state = 0;
		static_cast<DumpBackupDataActor*>(this)->ActorCallback< DumpBackupDataActor, 0, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< DumpBackupDataActor, 0, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("dumpBackupData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpBackupData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpBackupDataActor, 0, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("dumpBackupData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpBackupData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpBackupDataActor, 0, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("dumpBackupData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpBackupData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(BackupFileList const& files,int loopDepth) 
	{
															#line 2627 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		files.toStream(stdout);
															#line 2629 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<DumpBackupDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpBackupDataActorState(); static_cast<DumpBackupDataActor*>(this)->destroy(); return 0; }
															#line 13188 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<DumpBackupDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DumpBackupDataActorState();
		static_cast<DumpBackupDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(BackupFileList && files,int loopDepth) 
	{
															#line 2627 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		files.toStream(stdout);
															#line 2629 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<DumpBackupDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpBackupDataActorState(); static_cast<DumpBackupDataActor*>(this)->destroy(); return 0; }
															#line 13202 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<DumpBackupDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DumpBackupDataActorState();
		static_cast<DumpBackupDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(BackupFileList const& files,int loopDepth) 
	{
		loopDepth = a_body1cont7(files, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupFileList && files,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(files), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpBackupDataActor*>(this)->actor_wait_state > 0) static_cast<DumpBackupDataActor*>(this)->actor_wait_state = 0;
		static_cast<DumpBackupDataActor*>(this)->ActorCallback< DumpBackupDataActor, 1, BackupFileList >::remove();

	}
	void a_callback_fire(ActorCallback< DumpBackupDataActor, 1, BackupFileList >*,BackupFileList const& value) 
	{
		fdb_probe_actor_enter("dumpBackupData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpBackupData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpBackupDataActor, 1, BackupFileList >*,BackupFileList && value) 
	{
		fdb_probe_actor_enter("dumpBackupData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpBackupData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpBackupDataActor, 1, BackupFileList >*,Error err) 
	{
		fdb_probe_actor_enter("dumpBackupData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpBackupData", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	const char* name;
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string destinationContainer;
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version beginVersion;
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version endVersion;
															#line 2606 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<IBackupContainer> c;
															#line 13297 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via dumpBackupData()
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class DumpBackupDataActor final : public Actor<Void>, public ActorCallback< DumpBackupDataActor, 0, BackupDescription >, public ActorCallback< DumpBackupDataActor, 1, BackupFileList >, public FastAllocated<DumpBackupDataActor>, public DumpBackupDataActorState<DumpBackupDataActor> {
															#line 13302 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<DumpBackupDataActor>::operator new;
	using FastAllocated<DumpBackupDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17215818133343927040UL, 11679698332761558272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpBackupDataActor, 0, BackupDescription >;
friend struct ActorCallback< DumpBackupDataActor, 1, BackupFileList >;
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DumpBackupDataActor(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy,Version const& beginVersion,Version const& endVersion) 
															#line 13320 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   DumpBackupDataActorState<DumpBackupDataActor>(name, destinationContainer, proxy, beginVersion, endVersion),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpBackupData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8930482840486603776UL, 8984801671887685632UL);
		ActorExecutionContextHelper __helper(static_cast<DumpBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpBackupData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpBackupData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpBackupDataActor, 0, BackupDescription >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpBackupDataActor, 1, BackupFileList >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> dumpBackupData( const char* const& name, std::string const& destinationContainer, Optional<std::string> const& proxy, Version const& beginVersion, Version const& endVersion ) {
															#line 2601 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new DumpBackupDataActor(name, destinationContainer, proxy, beginVersion, endVersion));
															#line 13354 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2631 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 13359 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via expireBackupData()
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class ExpireBackupDataActor>
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ExpireBackupDataActorState {
															#line 13366 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ExpireBackupDataActorState(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy,Version const& endVersion,std::string const& endDatetime,Database const& db,bool const& force,Version const& restorableAfterVersion,std::string const& restorableAfterDatetime,Optional<std::string> const& encryptionKeyFile) 
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : name(name),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   destinationContainer(destinationContainer),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   endVersion(endVersion),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   endDatetime(endDatetime),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   db(db),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   force(force),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   restorableAfterVersion(restorableAfterVersion),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   restorableAfterDatetime(restorableAfterDatetime),
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   encryptionKeyFile(encryptionKeyFile)
															#line 13391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("expireBackupData", reinterpret_cast<unsigned long>(this));

	}
	~ExpireBackupDataActorState() 
	{
		fdb_probe_actor_destroy("expireBackupData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2642 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!endDatetime.empty())
															#line 13406 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2643 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Version> __when_expr_0 = timeKeeperVersionFromDatetime(endDatetime, db);
															#line 2643 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<ExpireBackupDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13412 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExpireBackupDataActor*>(this)->actor_wait_state = 1;
															#line 2643 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExpireBackupDataActor, 0, Version >*>(static_cast<ExpireBackupDataActor*>(this)));
															#line 13417 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExpireBackupDataActorState();
		static_cast<ExpireBackupDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!restorableAfterDatetime.empty())
															#line 13445 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2648 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Version> __when_expr_1 = timeKeeperVersionFromDatetime(restorableAfterDatetime, db);
															#line 2648 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<ExpireBackupDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 13451 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ExpireBackupDataActor*>(this)->actor_wait_state = 2;
															#line 2648 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExpireBackupDataActor, 1, Version >*>(static_cast<ExpireBackupDataActor*>(this)));
															#line 13456 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Version const& v,int loopDepth) 
	{
															#line 2644 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		endVersion = v;
															#line 13470 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Version && v,int loopDepth) 
	{
															#line 2644 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		endVersion = v;
															#line 13479 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExpireBackupDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireBackupDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireBackupDataActor*>(this)->ActorCallback< ExpireBackupDataActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireBackupDataActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExpireBackupDataActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExpireBackupDataActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 2652 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (endVersion == invalidVersion)
															#line 13563 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2653 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: No version or date/time is specified.\n");
															#line 2654 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printHelpTeaser(name);
															#line 2655 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(backup_error(), loopDepth);
															#line 13571 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		try {
															#line 2660 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			Reference<IBackupContainer> c = openBackupContainer(name, destinationContainer, proxy, encryptionKeyFile);
															#line 2662 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			progress = IBackupContainer::ExpireProgress();
															#line 2663 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			lastProgress = std::string();
															#line 2664 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			expire = c->expireData(endVersion, force, &progress, restorableAfterVersion);
															#line 2666 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 13584 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1cont4loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Version const& v,int loopDepth) 
	{
															#line 2649 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		restorableAfterVersion = v;
															#line 13599 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Version && v,int loopDepth) 
	{
															#line 2649 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		restorableAfterVersion = v;
															#line 13608 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont5(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExpireBackupDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireBackupDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireBackupDataActor*>(this)->ActorCallback< ExpireBackupDataActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireBackupDataActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExpireBackupDataActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExpireBackupDataActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 2705 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<ExpireBackupDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExpireBackupDataActorState(); static_cast<ExpireBackupDataActor*>(this)->destroy(); return 0; }
															#line 13692 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<ExpireBackupDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExpireBackupDataActorState();
		static_cast<ExpireBackupDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2694 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 13705 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2695 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 13709 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2696 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_backup_cannot_expire)
															#line 13713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2697 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				fprintf(stderr, "ERROR: Requested expiration would be unsafe.  Backup would not meet minimum restorability.  Use " "--force to delete data anyway.\n");
															#line 13717 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
			else
			{
															#line 2701 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				fprintf(stderr, "ERROR: %s\n", e.what());
															#line 13723 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2702 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 13727 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
															#line 2682 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		std::string p = progress.toString();
															#line 2683 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		int spaces = lastProgress.size() - p.size();
															#line 2684 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("\r%s%s\n", p.c_str(), (spaces > 0 ? std::string(spaces, ' ').c_str() : ""));
															#line 2686 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (endVersion < 0)
															#line 13747 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2687 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("All data before {0} versions ({1}" " days) prior to latest backup log has been deleted.\n", -endVersion, -endVersion / ((int64_t)24 * 3600 * CLIENT_KNOBS->CORE_VERSIONSPERSECOND));
															#line 13751 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2692 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fmt::print("All data before version {} has been deleted.\n", endVersion);
															#line 13757 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 2668 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5);
															#line 2667 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<ExpireBackupDataActor*>(this)->actor_wait_state < 0) return a_body1cont4Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13776 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont4Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 2676 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = expire;
															#line 13780 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont4Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when2(__when_expr_3.get(), loopDepth); };
		static_cast<ExpireBackupDataActor*>(this)->actor_wait_state = 3;
															#line 2668 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExpireBackupDataActor, 2, Void >*>(static_cast<ExpireBackupDataActor*>(this)));
															#line 2676 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ExpireBackupDataActor, 3, Void >*>(static_cast<ExpireBackupDataActor*>(this)));
															#line 13787 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 2669 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		std::string p = progress.toString();
															#line 2670 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (p != lastProgress)
															#line 13817 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2671 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			int spaces = lastProgress.size() - p.size();
															#line 2672 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("\r%s%s", p.c_str(), (spaces > 0 ? std::string(spaces, ' ').c_str() : ""));
															#line 2673 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			lastProgress = p;
															#line 13825 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
															#line 2669 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		std::string p = progress.toString();
															#line 2670 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (p != lastProgress)
															#line 13837 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2671 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			int spaces = lastProgress.size() - p.size();
															#line 2672 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("\r%s%s", p.c_str(), (spaces > 0 ? std::string(spaces, ' ').c_str() : ""));
															#line 2673 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			lastProgress = p;
															#line 13845 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when2(Void const& _,int loopDepth) 
	{
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont4loopBody1when2(Void && _,int loopDepth) 
	{
		return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ExpireBackupDataActor*>(this)->actor_wait_state > 0) static_cast<ExpireBackupDataActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireBackupDataActor*>(this)->ActorCallback< ExpireBackupDataActor, 2, Void >::remove();
		static_cast<ExpireBackupDataActor*>(this)->ActorCallback< ExpireBackupDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireBackupDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExpireBackupDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExpireBackupDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExpireBackupDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ExpireBackupDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ExpireBackupDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4Catch1(error, 0);
		} catch (...) {
			a_body1cont4Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	const char* name;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string destinationContainer;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version endVersion;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string endDatetime;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool force;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version restorableAfterVersion;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string restorableAfterDatetime;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> encryptionKeyFile;
															#line 2662 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	IBackupContainer::ExpireProgress progress;
															#line 2663 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string lastProgress;
															#line 2664 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<Void> expire;
															#line 14023 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via expireBackupData()
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ExpireBackupDataActor final : public Actor<Void>, public ActorCallback< ExpireBackupDataActor, 0, Version >, public ActorCallback< ExpireBackupDataActor, 1, Version >, public ActorCallback< ExpireBackupDataActor, 2, Void >, public ActorCallback< ExpireBackupDataActor, 3, Void >, public FastAllocated<ExpireBackupDataActor>, public ExpireBackupDataActorState<ExpireBackupDataActor> {
															#line 14028 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<ExpireBackupDataActor>::operator new;
	using FastAllocated<ExpireBackupDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18223973686630398976UL, 192519764754490112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExpireBackupDataActor, 0, Version >;
friend struct ActorCallback< ExpireBackupDataActor, 1, Version >;
friend struct ActorCallback< ExpireBackupDataActor, 2, Void >;
friend struct ActorCallback< ExpireBackupDataActor, 3, Void >;
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ExpireBackupDataActor(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy,Version const& endVersion,std::string const& endDatetime,Database const& db,bool const& force,Version const& restorableAfterVersion,std::string const& restorableAfterDatetime,Optional<std::string> const& encryptionKeyFile) 
															#line 14048 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   ExpireBackupDataActorState<ExpireBackupDataActor>(name, destinationContainer, proxy, endVersion, endDatetime, db, force, restorableAfterVersion, restorableAfterDatetime, encryptionKeyFile),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("expireBackupData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17451744003062206464UL, 9755375272534428928UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireBackupDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("expireBackupData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("expireBackupData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExpireBackupDataActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExpireBackupDataActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ExpireBackupDataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> expireBackupData( const char* const& name, std::string const& destinationContainer, Optional<std::string> const& proxy, Version const& endVersion, std::string const& endDatetime, Database const& db, bool const& force, Version const& restorableAfterVersion, std::string const& restorableAfterDatetime, Optional<std::string> const& encryptionKeyFile ) {
															#line 2632 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new ExpireBackupDataActor(name, destinationContainer, proxy, endVersion, endDatetime, db, force, restorableAfterVersion, restorableAfterDatetime, encryptionKeyFile));
															#line 14083 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2707 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 14088 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteBackupContainer()
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class DeleteBackupContainerActor>
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class DeleteBackupContainerActorState {
															#line 14095 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DeleteBackupContainerActorState(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy) 
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : name(name),
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   destinationContainer(destinationContainer),
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy)
															#line 14106 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteBackupContainer", reinterpret_cast<unsigned long>(this));

	}
	~DeleteBackupContainerActorState() 
	{
		fdb_probe_actor_destroy("deleteBackupContainer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2712 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				c = openBackupContainer(name, destinationContainer, proxy, {});
															#line 2713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				numDeleted = 0;
															#line 2714 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				done = c->deleteContainer(&numDeleted);
															#line 2716 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				lastUpdate = -1;
															#line 2717 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				printf("Deleting %s...\n", destinationContainer.c_str());
															#line 2719 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				;
															#line 14132 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteBackupContainerActorState();
		static_cast<DeleteBackupContainerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2741 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<DeleteBackupContainerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteBackupContainerActorState(); static_cast<DeleteBackupContainerActor*>(this)->destroy(); return 0; }
															#line 14161 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<DeleteBackupContainerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteBackupContainerActorState();
		static_cast<DeleteBackupContainerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2735 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14174 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2736 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 14178 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2737 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2738 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 14184 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2732 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("\r%d objects deleted\n", numDeleted);
															#line 2733 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("The entire container has been deleted.\n");
															#line 14200 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_0 = done;
															#line 2720 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<DeleteBackupContainerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 14218 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 2724 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5);
															#line 14222 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteBackupContainerActor*>(this)->actor_wait_state = 1;
															#line 2721 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteBackupContainerActor, 0, Void >*>(static_cast<DeleteBackupContainerActor*>(this)));
															#line 2724 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteBackupContainerActor, 1, Void >*>(static_cast<DeleteBackupContainerActor*>(this)));
															#line 14229 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 2725 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (numDeleted != lastUpdate)
															#line 14269 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2726 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("\r%d...", numDeleted);
															#line 2727 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			lastUpdate = numDeleted;
															#line 14275 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 2725 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (numDeleted != lastUpdate)
															#line 14285 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2726 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("\r%d...", numDeleted);
															#line 2727 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			lastUpdate = numDeleted;
															#line 14291 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteBackupContainerActor*>(this)->actor_wait_state > 0) static_cast<DeleteBackupContainerActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteBackupContainerActor*>(this)->ActorCallback< DeleteBackupContainerActor, 0, Void >::remove();
		static_cast<DeleteBackupContainerActor*>(this)->ActorCallback< DeleteBackupContainerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteBackupContainerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteBackupContainerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteBackupContainerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteBackupContainerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteBackupContainerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteBackupContainerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteBackupContainer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	const char* name;
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string destinationContainer;
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 2712 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<IBackupContainer> c;
															#line 2713 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int numDeleted;
															#line 2714 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Future<Void> done;
															#line 2716 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int lastUpdate;
															#line 14445 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via deleteBackupContainer()
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class DeleteBackupContainerActor final : public Actor<Void>, public ActorCallback< DeleteBackupContainerActor, 0, Void >, public ActorCallback< DeleteBackupContainerActor, 1, Void >, public FastAllocated<DeleteBackupContainerActor>, public DeleteBackupContainerActorState<DeleteBackupContainerActor> {
															#line 14450 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<DeleteBackupContainerActor>::operator new;
	using FastAllocated<DeleteBackupContainerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5039920728189102336UL, 7264104561677041664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteBackupContainerActor, 0, Void >;
friend struct ActorCallback< DeleteBackupContainerActor, 1, Void >;
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DeleteBackupContainerActor(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy) 
															#line 14468 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteBackupContainerActorState<DeleteBackupContainerActor>(name, destinationContainer, proxy),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteBackupContainer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2926737720739387392UL, 651473716829138176UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteBackupContainerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteBackupContainer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteBackupContainer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteBackupContainerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> deleteBackupContainer( const char* const& name, std::string const& destinationContainer, Optional<std::string> const& proxy ) {
															#line 2708 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new DeleteBackupContainerActor(name, destinationContainer, proxy));
															#line 14501 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2743 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 14506 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via describeBackup()
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class DescribeBackupActor>
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class DescribeBackupActorState {
															#line 14513 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DescribeBackupActorState(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy,bool const& deep,Optional<Database> const& cx,bool const& json,Optional<std::string> const& encryptionKeyFile) 
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : name(name),
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   destinationContainer(destinationContainer),
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy),
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   deep(deep),
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   cx(cx),
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   json(json),
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   encryptionKeyFile(encryptionKeyFile)
															#line 14532 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("describeBackup", reinterpret_cast<unsigned long>(this));

	}
	~DescribeBackupActorState() 
	{
		fdb_probe_actor_destroy("describeBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2752 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				Reference<IBackupContainer> c = openBackupContainer(name, destinationContainer, proxy, encryptionKeyFile);
															#line 2753 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<BackupDescription> __when_expr_0 = c->describeBackup(deep);
															#line 2753 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 14552 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DescribeBackupActor*>(this)->actor_wait_state = 1;
															#line 2753 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 0, BackupDescription >*>(static_cast<DescribeBackupActor*>(this)));
															#line 14557 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DescribeBackupActorState();
		static_cast<DescribeBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2764 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<DescribeBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DescribeBackupActorState(); static_cast<DescribeBackupActor*>(this)->destroy(); return 0; }
															#line 14586 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<DescribeBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DescribeBackupActorState();
		static_cast<DescribeBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2758 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 14599 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2759 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 14603 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2760 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: %s\n", e.what());
															#line 2761 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 14609 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 2754 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (cx.present())
															#line 14623 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = desc.resolveVersionTimes(cx.get());
															#line 2755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<DescribeBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 14629 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<DescribeBackupActor*>(this)->actor_wait_state = 2;
															#line 2755 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DescribeBackupActor, 1, Void >*>(static_cast<DescribeBackupActor*>(this)));
															#line 14634 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 2753 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		desc = __desc;
															#line 14648 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 0, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 0, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 0, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 0, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 2756 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("%s\n", (json ? desc.toJSON() : desc.toString()).c_str());
															#line 14727 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DescribeBackupActor*>(this)->actor_wait_state > 0) static_cast<DescribeBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DescribeBackupActor*>(this)->ActorCallback< DescribeBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DescribeBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DescribeBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	const char* name;
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string destinationContainer;
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool deep;
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<Database> cx;
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	bool json;
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> encryptionKeyFile;
															#line 2753 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	BackupDescription desc;
															#line 14848 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via describeBackup()
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class DescribeBackupActor final : public Actor<Void>, public ActorCallback< DescribeBackupActor, 0, BackupDescription >, public ActorCallback< DescribeBackupActor, 1, Void >, public FastAllocated<DescribeBackupActor>, public DescribeBackupActorState<DescribeBackupActor> {
															#line 14853 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<DescribeBackupActor>::operator new;
	using FastAllocated<DescribeBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9882461804372713728UL, 10779012382665305600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DescribeBackupActor, 0, BackupDescription >;
friend struct ActorCallback< DescribeBackupActor, 1, Void >;
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	DescribeBackupActor(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy,bool const& deep,Optional<Database> const& cx,bool const& json,Optional<std::string> const& encryptionKeyFile) 
															#line 14871 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   DescribeBackupActorState<DescribeBackupActor>(name, destinationContainer, proxy, deep, cx, json, encryptionKeyFile),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("describeBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10658787011351424256UL, 7417613107694102528UL);
		ActorExecutionContextHelper __helper(static_cast<DescribeBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("describeBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("describeBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DescribeBackupActor, 0, BackupDescription >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DescribeBackupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> describeBackup( const char* const& name, std::string const& destinationContainer, Optional<std::string> const& proxy, bool const& deep, Optional<Database> const& cx, bool const& json, Optional<std::string> const& encryptionKeyFile ) {
															#line 2744 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new DescribeBackupActor(name, destinationContainer, proxy, deep, cx, json, encryptionKeyFile));
															#line 14905 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2766 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

static void reportBackupQueryError(UID operationId, JsonBuilderObject& result, std::string errorMessage) {
	result["error"] = errorMessage;
	printf("%s\n", result.getJson().c_str());
	TraceEvent("BackupQueryFailure").detail("OperationId", operationId).detail("Reason", errorMessage);
}

std::pair<Version, Version> getMaxMinRestorableVersions(const BackupDescription& desc, bool mayOnlyApplyMutationLog) {
	Version maxRestorableVersion = invalidVersion;
	Version minRestorableVersion = invalidVersion;
	if (desc.maxRestorableVersion.present()) {
		maxRestorableVersion = desc.maxRestorableVersion.get();
	} else if (mayOnlyApplyMutationLog && desc.contiguousLogEnd.present()) {
		maxRestorableVersion = desc.contiguousLogEnd.get();
	}

	if (desc.minRestorableVersion.present()) {
		minRestorableVersion = desc.minRestorableVersion.get();
	} else if (mayOnlyApplyMutationLog && desc.minLogBegin.present()) {
		minRestorableVersion = desc.minLogBegin.get();
	}

	return std::make_pair(maxRestorableVersion, minRestorableVersion);
}

// If restoreVersion is invalidVersion or latestVersion, use the maximum or minimum restorable version respectively for
// selected key ranges. If restoreTimestamp is specified, any specified restoreVersion will be overridden to the version
// resolved to that timestamp.
															#line 14937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via queryBackup()
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class QueryBackupActor>
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class QueryBackupActorState {
															#line 14944 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	QueryBackupActorState(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy,Standalone<VectorRef<KeyRangeRef>> const& keyRangesFilter,Version const& restoreVersion,Version const& snapshotVersion,std::string const& originalClusterFile,std::string const& restoreTimestamp,Verbose const& verbose,Optional<Database> const& cx) 
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : name(name),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   destinationContainer(destinationContainer),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   keyRangesFilter(keyRangesFilter),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   restoreVersion(restoreVersion),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   snapshotVersion(snapshotVersion),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   originalClusterFile(originalClusterFile),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   restoreTimestamp(restoreTimestamp),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   verbose(verbose),
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   cx(cx),
															#line 2804 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   operationId(deterministicRandom()->randomUniqueID()),
															#line 2805 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   result(),
															#line 2806 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   errorMessage()
															#line 14975 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("queryBackup", reinterpret_cast<unsigned long>(this));

	}
	~QueryBackupActorState() 
	{
		fdb_probe_actor_destroy("queryBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2807 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			result["key_ranges_filter"] = printable(keyRangesFilter);
															#line 2808 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			result["destination_container"] = destinationContainer;
															#line 2810 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent("BackupQueryStart") .detail("OperationId", operationId) .detail("DestinationContainer", destinationContainer) .detail("KeyRangesFilter", printable(keyRangesFilter)) .detail("SpecifiedRestoreVersion", restoreVersion) .detail("SpecifiedSnapshotVersion", snapshotVersion) .detail("RestoreTimestamp", restoreTimestamp) .detail("BackupClusterFile", originalClusterFile);
															#line 2820 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!restoreTimestamp.empty())
															#line 14996 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2821 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (originalClusterFile.empty())
															#line 15000 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2822 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					reportBackupQueryError( operationId, result, format("an original cluster file must be given in order to resolve restore target timestamp '%s'", restoreTimestamp.c_str()));
															#line 2827 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15006 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~QueryBackupActorState();
					static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2830 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (!fileExists(originalClusterFile))
															#line 15014 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				{
															#line 2831 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					reportBackupQueryError(operationId, result, format("The specified original source database cluster file '%s' does not exist\n", originalClusterFile.c_str()));
															#line 2835 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15020 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~QueryBackupActorState();
					static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 2838 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				Database origDb = Database::createDatabase(originalClusterFile, ApiVersion::LATEST_VERSION);
															#line 2839 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<Version> __when_expr_0 = timeKeeperVersionFromDatetime(restoreTimestamp, origDb);
															#line 2839 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<QueryBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 15032 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<QueryBackupActor*>(this)->actor_wait_state = 1;
															#line 2839 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< QueryBackupActor, 0, Version >*>(static_cast<QueryBackupActor*>(this)));
															#line 15037 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~QueryBackupActorState();
		static_cast<QueryBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2845 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		totalRangeFilesSize = 0;
															#line 2846 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		totalLogFilesSize = 0;
															#line 2847 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		rangeFilesJson = JsonBuilderArray();
															#line 2848 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		logFilesJson = JsonBuilderArray();
															#line 15071 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		try {
															#line 2850 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			bc = openBackupContainer(name, destinationContainer, proxy, {});
															#line 2851 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_1 = bc->describeBackup();
															#line 2851 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<QueryBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<QueryBackupActor*>(this)->actor_wait_state = 2;
															#line 2851 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< QueryBackupActor, 1, BackupDescription >*>(static_cast<QueryBackupActor*>(this)));
															#line 15084 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Version const& v,int loopDepth) 
	{
															#line 2840 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		result["restore_timestamp"] = restoreTimestamp;
															#line 2841 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		result["restore_timestamp_resolved_version"] = v;
															#line 2842 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		restoreVersion = v;
															#line 15103 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Version && v,int loopDepth) 
	{
															#line 2840 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		result["restore_timestamp"] = restoreTimestamp;
															#line 2841 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		result["restore_timestamp_resolved_version"] = v;
															#line 2842 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		restoreVersion = v;
															#line 15116 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<QueryBackupActor*>(this)->actor_wait_state > 0) static_cast<QueryBackupActor*>(this)->actor_wait_state = 0;
		static_cast<QueryBackupActor*>(this)->ActorCallback< QueryBackupActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< QueryBackupActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 2971 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		result["total_range_files_size"] = totalRangeFilesSize;
															#line 2972 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		result["total_log_files_size"] = totalLogFilesSize;
															#line 2974 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (verbose)
															#line 15204 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2975 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			result["ranges"] = rangeFilesJson;
															#line 2976 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			result["logs"] = logFilesJson;
															#line 15210 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2979 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		printf("%s\n", result.getJson().c_str());
															#line 2980 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15216 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~QueryBackupActorState();
		static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2967 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			reportBackupQueryError(operationId, result, e.what());
															#line 2968 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15231 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~QueryBackupActorState();
			static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(BackupDescription const& desc,int loopDepth) 
	{
															#line 2854 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		auto [maxRestorableVersion, minRestorableVersion] = getMaxMinRestorableVersions(desc, !keyRangesFilter.empty());
															#line 2855 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (restoreVersion == invalidVersion)
															#line 15251 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2856 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			restoreVersion = maxRestorableVersion;
															#line 15255 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2858 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (restoreVersion == earliestVersion)
															#line 15259 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2859 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			restoreVersion = minRestorableVersion;
															#line 15263 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (snapshotVersion == earliestVersion)
															#line 15267 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2862 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			snapshotVersion = minRestorableVersion;
															#line 15271 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2864 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		TraceEvent("BackupQueryResolveRestoreVersion") .detail("RestoreVersion", restoreVersion) .detail("SnapshotVersion", snapshotVersion);
															#line 2867 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (restoreVersion < 0)
															#line 15277 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2868 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			reportBackupQueryError(operationId, result, errorMessage = format("the specified restorable version %lld is not valid", restoreVersion));
															#line 2872 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15283 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~QueryBackupActorState();
			static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2875 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		fileSet = Optional<RestorableFileSet>();
															#line 2876 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (snapshotVersion != invalidVersion)
															#line 15293 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2879 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(fileSet, bc->getRestoreSet(snapshotVersion, keyRangesFilter));
															#line 2879 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<QueryBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15299 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont7when1(__when_expr_2.get(), loopDepth); };
			static_cast<QueryBackupActor*>(this)->actor_wait_state = 3;
															#line 2879 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< QueryBackupActor, 2, Void >*>(static_cast<QueryBackupActor*>(this)));
															#line 15304 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_4 = store(fileSet, bc->getRestoreSet(restoreVersion, keyRangesFilter));
															#line 2927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<QueryBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15313 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when2(__when_expr_4.get(), loopDepth); };
			static_cast<QueryBackupActor*>(this)->actor_wait_state = 5;
															#line 2927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< QueryBackupActor, 4, Void >*>(static_cast<QueryBackupActor*>(this)));
															#line 15318 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont7(BackupDescription && desc,int loopDepth) 
	{
															#line 2854 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		auto [maxRestorableVersion, minRestorableVersion] = getMaxMinRestorableVersions(desc, !keyRangesFilter.empty());
															#line 2855 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (restoreVersion == invalidVersion)
															#line 15330 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2856 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			restoreVersion = maxRestorableVersion;
															#line 15334 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2858 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (restoreVersion == earliestVersion)
															#line 15338 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2859 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			restoreVersion = minRestorableVersion;
															#line 15342 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2861 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (snapshotVersion == earliestVersion)
															#line 15346 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2862 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			snapshotVersion = minRestorableVersion;
															#line 15350 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 2864 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		TraceEvent("BackupQueryResolveRestoreVersion") .detail("RestoreVersion", restoreVersion) .detail("SnapshotVersion", snapshotVersion);
															#line 2867 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (restoreVersion < 0)
															#line 15356 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2868 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			reportBackupQueryError(operationId, result, errorMessage = format("the specified restorable version %lld is not valid", restoreVersion));
															#line 2872 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~QueryBackupActorState();
			static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2875 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		fileSet = Optional<RestorableFileSet>();
															#line 2876 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (snapshotVersion != invalidVersion)
															#line 15372 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2879 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(fileSet, bc->getRestoreSet(snapshotVersion, keyRangesFilter));
															#line 2879 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<QueryBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15378 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont7when1(__when_expr_2.get(), loopDepth); };
			static_cast<QueryBackupActor*>(this)->actor_wait_state = 3;
															#line 2879 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< QueryBackupActor, 2, Void >*>(static_cast<QueryBackupActor*>(this)));
															#line 15383 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_4 = store(fileSet, bc->getRestoreSet(restoreVersion, keyRangesFilter));
															#line 2927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<QueryBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15392 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when2(__when_expr_4.get(), loopDepth); };
			static_cast<QueryBackupActor*>(this)->actor_wait_state = 5;
															#line 2927 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< QueryBackupActor, 4, Void >*>(static_cast<QueryBackupActor*>(this)));
															#line 15397 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont7(desc, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<QueryBackupActor*>(this)->actor_wait_state > 0) static_cast<QueryBackupActor*>(this)->actor_wait_state = 0;
		static_cast<QueryBackupActor*>(this)->ActorCallback< QueryBackupActor, 1, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 1, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 1, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< QueryBackupActor, 1, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 2930 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (fileSet.present())
															#line 15482 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2931 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			result["restore_version"] = fileSet.get().targetVersion;
															#line 2932 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			for( const auto& rangeFile : fileSet.get().ranges ) {
															#line 2933 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				JsonBuilderObject object;
															#line 2934 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_name"] = rangeFile.fileName;
															#line 2935 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_size"] = rangeFile.fileSize;
															#line 2936 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["version"] = rangeFile.version;
															#line 2937 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["key_range"] = fileSet.get().keyRanges.count(rangeFile.fileName) == 0 ? "none" : fileSet.get().keyRanges.at(rangeFile.fileName).toString();
															#line 2940 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				rangeFilesJson.push_back(object);
															#line 2941 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				totalRangeFilesSize += rangeFile.fileSize;
															#line 15502 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2943 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			for( const auto& log : fileSet.get().logs ) {
															#line 2944 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				JsonBuilderObject object;
															#line 2945 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_name"] = log.fileName;
															#line 2946 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_size"] = log.fileSize;
															#line 2947 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["begin_version"] = log.beginVersion;
															#line 2948 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["end_version"] = log.endVersion;
															#line 2949 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				logFilesJson.push_back(object);
															#line 2950 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				totalLogFilesSize += log.fileSize;
															#line 15520 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2953 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent("BackupQueryReceivedRestorableFilesSet") .detail("DestinationContainer", destinationContainer) .detail("KeyRangesFilter", printable(keyRangesFilter)) .detail("ActualRestoreVersion", fileSet.get().targetVersion) .detail("NumRangeFiles", fileSet.get().ranges.size()) .detail("NumLogFiles", fileSet.get().logs.size()) .detail("RangeFilesBytes", totalRangeFilesSize) .detail("LogFilesBytes", totalLogFilesSize);
															#line 15524 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2961 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (snapshotVersion == invalidVersion)
															#line 15530 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2962 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				reportBackupQueryError(operationId, result, "no restorable files set found for specified key ranges");
															#line 2963 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15536 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~QueryBackupActorState();
				static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
															#line 2880 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (fileSet.present())
															#line 15551 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2881 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			result["snapshot_version"] = fileSet.get().targetVersion;
															#line 2882 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			for( const auto& rangeFile : fileSet.get().ranges ) {
															#line 2883 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				JsonBuilderObject object;
															#line 2884 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_name"] = rangeFile.fileName;
															#line 2885 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_size"] = rangeFile.fileSize;
															#line 2886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["version"] = rangeFile.version;
															#line 2887 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["key_range"] = fileSet.get().keyRanges.count(rangeFile.fileName) == 0 ? "none" : fileSet.get().keyRanges.at(rangeFile.fileName).toString();
															#line 2890 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				rangeFilesJson.push_back(object);
															#line 2891 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				totalRangeFilesSize += rangeFile.fileSize;
															#line 15571 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2893 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			for( const auto& log : fileSet.get().logs ) {
															#line 2894 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				JsonBuilderObject object;
															#line 2895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_name"] = log.fileName;
															#line 2896 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_size"] = log.fileSize;
															#line 2897 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["begin_version"] = log.beginVersion;
															#line 2898 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["end_version"] = log.endVersion;
															#line 2899 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				logFilesJson.push_back(object);
															#line 2900 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				totalLogFilesSize += log.fileSize;
															#line 15589 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2903 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			snapshotVersion = fileSet.get().targetVersion;
															#line 2905 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent("BackupQueryReceivedRestorableFilesSetFromSnapshot") .detail("SnapshotVersion", snapshotVersion) .detail("DestinationContainer", destinationContainer) .detail("KeyRangesFilter", printable(keyRangesFilter)) .detail("ActualRestoreVersion", fileSet.get().targetVersion) .detail("NumRangeFiles", fileSet.get().ranges.size()) .detail("NumLogFiles", fileSet.get().logs.size()) .detail("RangeFilesBytes", totalRangeFilesSize) .detail("LogFilesBytes", totalLogFilesSize);
															#line 15595 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2915 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			reportBackupQueryError( operationId, result, format("no restorable files set found for specified key ranges from snapshotVersion %lld", snapshotVersion));
															#line 2920 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15603 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~QueryBackupActorState();
			static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(fileSet, bc->getRestoreSet(restoreVersion, keyRangesFilter, true, snapshotVersion));
															#line 2924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<QueryBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15613 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont13when1(__when_expr_3.get(), loopDepth); };
		static_cast<QueryBackupActor*>(this)->actor_wait_state = 4;
															#line 2924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< QueryBackupActor, 3, Void >*>(static_cast<QueryBackupActor*>(this)));
															#line 15618 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
															#line 2880 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (fileSet.present())
															#line 15627 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 2881 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			result["snapshot_version"] = fileSet.get().targetVersion;
															#line 2882 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			for( const auto& rangeFile : fileSet.get().ranges ) {
															#line 2883 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				JsonBuilderObject object;
															#line 2884 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_name"] = rangeFile.fileName;
															#line 2885 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_size"] = rangeFile.fileSize;
															#line 2886 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["version"] = rangeFile.version;
															#line 2887 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["key_range"] = fileSet.get().keyRanges.count(rangeFile.fileName) == 0 ? "none" : fileSet.get().keyRanges.at(rangeFile.fileName).toString();
															#line 2890 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				rangeFilesJson.push_back(object);
															#line 2891 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				totalRangeFilesSize += rangeFile.fileSize;
															#line 15647 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2893 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			for( const auto& log : fileSet.get().logs ) {
															#line 2894 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				JsonBuilderObject object;
															#line 2895 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_name"] = log.fileName;
															#line 2896 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["file_size"] = log.fileSize;
															#line 2897 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["begin_version"] = log.beginVersion;
															#line 2898 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				object["end_version"] = log.endVersion;
															#line 2899 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				logFilesJson.push_back(object);
															#line 2900 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				totalLogFilesSize += log.fileSize;
															#line 15665 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2903 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			snapshotVersion = fileSet.get().targetVersion;
															#line 2905 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			TraceEvent("BackupQueryReceivedRestorableFilesSetFromSnapshot") .detail("SnapshotVersion", snapshotVersion) .detail("DestinationContainer", destinationContainer) .detail("KeyRangesFilter", printable(keyRangesFilter)) .detail("ActualRestoreVersion", fileSet.get().targetVersion) .detail("NumRangeFiles", fileSet.get().ranges.size()) .detail("NumLogFiles", fileSet.get().logs.size()) .detail("RangeFilesBytes", totalRangeFilesSize) .detail("LogFilesBytes", totalLogFilesSize);
															#line 15671 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		else
		{
															#line 2915 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			reportBackupQueryError( operationId, result, format("no restorable files set found for specified key ranges from snapshotVersion %lld", snapshotVersion));
															#line 2920 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!static_cast<QueryBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~QueryBackupActorState(); static_cast<QueryBackupActor*>(this)->destroy(); return 0; }
															#line 15679 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			new (&static_cast<QueryBackupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~QueryBackupActorState();
			static_cast<QueryBackupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 2924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(fileSet, bc->getRestoreSet(restoreVersion, keyRangesFilter, true, snapshotVersion));
															#line 2924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<QueryBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 15689 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont13when1(__when_expr_3.get(), loopDepth); };
		static_cast<QueryBackupActor*>(this)->actor_wait_state = 4;
															#line 2924 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< QueryBackupActor, 3, Void >*>(static_cast<QueryBackupActor*>(this)));
															#line 15694 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<QueryBackupActor*>(this)->actor_wait_state > 0) static_cast<QueryBackupActor*>(this)->actor_wait_state = 0;
		static_cast<QueryBackupActor*>(this)->ActorCallback< QueryBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< QueryBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont13cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont13cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<QueryBackupActor*>(this)->actor_wait_state > 0) static_cast<QueryBackupActor*>(this)->actor_wait_state = 0;
		static_cast<QueryBackupActor*>(this)->ActorCallback< QueryBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< QueryBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<QueryBackupActor*>(this)->actor_wait_state > 0) static_cast<QueryBackupActor*>(this)->actor_wait_state = 0;
		static_cast<QueryBackupActor*>(this)->ActorCallback< QueryBackupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< QueryBackupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< QueryBackupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont21(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	const char* name;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string destinationContainer;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> keyRangesFilter;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version restoreVersion;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Version snapshotVersion;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string originalClusterFile;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string restoreTimestamp;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Verbose verbose;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<Database> cx;
															#line 2804 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	UID operationId;
															#line 2805 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	JsonBuilderObject result;
															#line 2806 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string errorMessage;
															#line 2845 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int64_t totalRangeFilesSize;
															#line 2846 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	int64_t totalLogFilesSize;
															#line 2847 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	JsonBuilderArray rangeFilesJson;
															#line 2848 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	JsonBuilderArray logFilesJson;
															#line 2850 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 2875 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<RestorableFileSet> fileSet;
															#line 15999 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via queryBackup()
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class QueryBackupActor final : public Actor<Void>, public ActorCallback< QueryBackupActor, 0, Version >, public ActorCallback< QueryBackupActor, 1, BackupDescription >, public ActorCallback< QueryBackupActor, 2, Void >, public ActorCallback< QueryBackupActor, 3, Void >, public ActorCallback< QueryBackupActor, 4, Void >, public FastAllocated<QueryBackupActor>, public QueryBackupActorState<QueryBackupActor> {
															#line 16004 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<QueryBackupActor>::operator new;
	using FastAllocated<QueryBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2846906443873612800UL, 6716268662578079744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< QueryBackupActor, 0, Version >;
friend struct ActorCallback< QueryBackupActor, 1, BackupDescription >;
friend struct ActorCallback< QueryBackupActor, 2, Void >;
friend struct ActorCallback< QueryBackupActor, 3, Void >;
friend struct ActorCallback< QueryBackupActor, 4, Void >;
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	QueryBackupActor(const char* const& name,std::string const& destinationContainer,Optional<std::string> const& proxy,Standalone<VectorRef<KeyRangeRef>> const& keyRangesFilter,Version const& restoreVersion,Version const& snapshotVersion,std::string const& originalClusterFile,std::string const& restoreTimestamp,Verbose const& verbose,Optional<Database> const& cx) 
															#line 16025 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   QueryBackupActorState<QueryBackupActor>(name, destinationContainer, proxy, keyRangesFilter, restoreVersion, snapshotVersion, originalClusterFile, restoreTimestamp, verbose, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("queryBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7267887550367718912UL, 14283492521167099904UL);
		ActorExecutionContextHelper __helper(static_cast<QueryBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("queryBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("queryBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< QueryBackupActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< QueryBackupActor, 1, BackupDescription >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< QueryBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< QueryBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< QueryBackupActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> queryBackup( const char* const& name, std::string const& destinationContainer, Optional<std::string> const& proxy, Standalone<VectorRef<KeyRangeRef>> const& keyRangesFilter, Version const& restoreVersion, Version const& snapshotVersion, std::string const& originalClusterFile, std::string const& restoreTimestamp, Verbose const& verbose, Optional<Database> const& cx ) {
															#line 2794 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new QueryBackupActor(name, destinationContainer, proxy, keyRangesFilter, restoreVersion, snapshotVersion, originalClusterFile, restoreTimestamp, verbose, cx));
															#line 16062 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 2982 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 16067 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via listBackup()
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class ListBackupActor>
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ListBackupActorState {
															#line 16074 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ListBackupActorState(std::string const& baseUrl,Optional<std::string> const& proxy) 
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : baseUrl(baseUrl),
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   proxy(proxy)
															#line 16083 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("listBackup", reinterpret_cast<unsigned long>(this));

	}
	~ListBackupActorState() 
	{
		fdb_probe_actor_destroy("listBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				StrictFuture<std::vector<std::string>> __when_expr_0 = IBackupContainer::listContainers(baseUrl, proxy);
															#line 2985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				if (static_cast<ListBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16101 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListBackupActor*>(this)->actor_wait_state = 1;
															#line 2985 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListBackupActor, 0, std::vector<std::string> >*>(static_cast<ListBackupActor*>(this)));
															#line 16106 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListBackupActorState();
		static_cast<ListBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2998 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<ListBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListBackupActorState(); static_cast<ListBackupActor*>(this)->destroy(); return 0; }
															#line 16135 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<ListBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListBackupActorState();
		static_cast<ListBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2990 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			std::string msg = format("ERROR: %s", e.what());
															#line 2991 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_backup_invalid_url && !IBackupContainer::lastOpenError.empty())
															#line 16150 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 2992 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				msg += format(": %s", IBackupContainer::lastOpenError.c_str());
															#line 16154 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 2994 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "%s\n", msg.c_str());
															#line 2995 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 16160 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::string> const& containers,int loopDepth) 
	{
															#line 2986 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for( std::string container : containers ) {
															#line 2987 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("%s\n", container.c_str());
															#line 16176 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::string> && containers,int loopDepth) 
	{
															#line 2986 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for( std::string container : containers ) {
															#line 2987 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("%s\n", container.c_str());
															#line 16188 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> const& containers,int loopDepth) 
	{
		loopDepth = a_body1cont2(containers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> && containers,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(containers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListBackupActor*>(this)->actor_wait_state > 0) static_cast<ListBackupActor*>(this)->actor_wait_state = 0;
		static_cast<ListBackupActor*>(this)->ActorCallback< ListBackupActor, 0, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ListBackupActor, 0, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("listBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListBackupActor, 0, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("listBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListBackupActor, 0, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("listBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string baseUrl;
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<std::string> proxy;
															#line 16286 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via listBackup()
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ListBackupActor final : public Actor<Void>, public ActorCallback< ListBackupActor, 0, std::vector<std::string> >, public FastAllocated<ListBackupActor>, public ListBackupActorState<ListBackupActor> {
															#line 16291 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<ListBackupActor>::operator new;
	using FastAllocated<ListBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11264451329351779584UL, 17264550678581434112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListBackupActor, 0, std::vector<std::string> >;
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ListBackupActor(std::string const& baseUrl,Optional<std::string> const& proxy) 
															#line 16308 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   ListBackupActorState<ListBackupActor>(baseUrl, proxy),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16861122483231224320UL, 1388739841715306496UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListBackupActor, 0, std::vector<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> listBackup( std::string const& baseUrl, Optional<std::string> const& proxy ) {
															#line 2983 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new ListBackupActor(baseUrl, proxy));
															#line 16341 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 3000 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

															#line 16346 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via listBackupTags()
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class ListBackupTagsActor>
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ListBackupTagsActorState {
															#line 16353 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ListBackupTagsActorState(Database const& cx) 
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : cx(cx),
															#line 3002 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx))
															#line 16362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("listBackupTags", reinterpret_cast<unsigned long>(this));

	}
	~ListBackupTagsActorState() 
	{
		fdb_probe_actor_destroy("listBackupTags", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3003 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			;
															#line 16377 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListBackupTagsActorState();
		static_cast<ListBackupTagsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 3005 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 3006 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 3007 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<std::vector<KeyBackedTag>> __when_expr_0 = getAllBackupTags(tr);
															#line 3007 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<ListBackupTagsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16414 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListBackupTagsActor*>(this)->actor_wait_state = 1;
															#line 3007 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListBackupTagsActor, 0, std::vector<KeyBackedTag> >*>(static_cast<ListBackupTagsActor*>(this)));
															#line 16419 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3013 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 3013 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<ListBackupTagsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 16443 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ListBackupTagsActor*>(this)->actor_wait_state = 2;
															#line 3013 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListBackupTagsActor, 1, Void >*>(static_cast<ListBackupTagsActor*>(this)));
															#line 16448 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
															#line 3008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for( const auto& tag : tags ) {
															#line 3009 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("%s\n", tag.tagName.c_str());
															#line 16465 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3011 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<ListBackupTagsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListBackupTagsActorState(); static_cast<ListBackupTagsActor*>(this)->destroy(); return 0; }
															#line 16469 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<ListBackupTagsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListBackupTagsActorState();
		static_cast<ListBackupTagsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
															#line 3008 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		for( const auto& tag : tags ) {
															#line 3009 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			printf("%s\n", tag.tagName.c_str());
															#line 16483 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3011 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<ListBackupTagsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListBackupTagsActorState(); static_cast<ListBackupTagsActor*>(this)->destroy(); return 0; }
															#line 16487 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<ListBackupTagsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListBackupTagsActorState();
		static_cast<ListBackupTagsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyBackedTag> const& tags,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(tags, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<KeyBackedTag> && tags,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(tags), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListBackupTagsActor*>(this)->actor_wait_state > 0) static_cast<ListBackupTagsActor*>(this)->actor_wait_state = 0;
		static_cast<ListBackupTagsActor*>(this)->ActorCallback< ListBackupTagsActor, 0, std::vector<KeyBackedTag> >::remove();

	}
	void a_callback_fire(ActorCallback< ListBackupTagsActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> const& value) 
	{
		fdb_probe_actor_enter("listBackupTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackupTags", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListBackupTagsActor, 0, std::vector<KeyBackedTag> >*,std::vector<KeyBackedTag> && value) 
	{
		fdb_probe_actor_enter("listBackupTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackupTags", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListBackupTagsActor, 0, std::vector<KeyBackedTag> >*,Error err) 
	{
		fdb_probe_actor_enter("listBackupTags", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackupTags", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListBackupTagsActor*>(this)->actor_wait_state > 0) static_cast<ListBackupTagsActor*>(this)->actor_wait_state = 0;
		static_cast<ListBackupTagsActor*>(this)->ActorCallback< ListBackupTagsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListBackupTagsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listBackupTags", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackupTags", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListBackupTagsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listBackupTags", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackupTags", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListBackupTagsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listBackupTags", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBackupTags", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database cx;
															#line 3002 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 16661 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via listBackupTags()
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ListBackupTagsActor final : public Actor<Void>, public ActorCallback< ListBackupTagsActor, 0, std::vector<KeyBackedTag> >, public ActorCallback< ListBackupTagsActor, 1, Void >, public FastAllocated<ListBackupTagsActor>, public ListBackupTagsActorState<ListBackupTagsActor> {
															#line 16666 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<ListBackupTagsActor>::operator new;
	using FastAllocated<ListBackupTagsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10179224708816182528UL, 17164701872272519168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListBackupTagsActor, 0, std::vector<KeyBackedTag> >;
friend struct ActorCallback< ListBackupTagsActor, 1, Void >;
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ListBackupTagsActor(Database const& cx) 
															#line 16684 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   ListBackupTagsActorState<ListBackupTagsActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listBackupTags", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14260492099184732416UL, 15398095976796240640UL);
		ActorExecutionContextHelper __helper(static_cast<ListBackupTagsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listBackupTags");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listBackupTags", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListBackupTagsActor, 0, std::vector<KeyBackedTag> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListBackupTagsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> listBackupTags( Database const& cx ) {
															#line 3001 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new ListBackupTagsActor(cx));
															#line 16718 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 3017 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

struct BackupModifyOptions {
	Optional<std::string> verifyUID;
	Optional<std::string> destURL;
	Optional<std::string> proxy;
	Optional<int> snapshotIntervalSeconds;
	Optional<int> activeSnapshotIntervalSeconds;
	bool hasChanges() const {
		return destURL.present() || snapshotIntervalSeconds.present() || activeSnapshotIntervalSeconds.present();
	}
};

															#line 16734 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
namespace {
// This generated class is to be used only via modifyBackup()
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
template <class ModifyBackupActor>
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ModifyBackupActorState {
															#line 16741 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ModifyBackupActorState(Database const& db,std::string const& tagName,BackupModifyOptions const& options) 
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		 : db(db),
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   tagName(tagName),
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		   options(options)
															#line 16752 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
	{
		fdb_probe_actor_create("modifyBackup", reinterpret_cast<unsigned long>(this));

	}
	~ModifyBackupActorState() 
	{
		fdb_probe_actor_destroy("modifyBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 3030 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (!options.hasChanges())
															#line 16767 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 3031 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				fprintf(stderr, "No changes were specified, nothing to do!\n");
															#line 3032 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(backup_error(), loopDepth);
															#line 16773 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 3035 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tag = makeBackupTag(tagName);
															#line 3037 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			bc = Reference<IBackupContainer>();
															#line 3038 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (options.destURL.present())
															#line 16781 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 3039 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				bc = openBackupContainer(exeBackup.toString().c_str(), options.destURL.get(), options.proxy, {});
															#line 16785 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
				try {
															#line 3041 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					StrictFuture<Void> __when_expr_0 = timeoutError(bc->create(), 30);
															#line 3041 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					if (static_cast<ModifyBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 16791 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ModifyBackupActor*>(this)->actor_wait_state = 1;
															#line 3041 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ModifyBackupActor, 0, Void >*>(static_cast<ModifyBackupActor*>(this)));
															#line 16796 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1Catch2(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1Catch2(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ModifyBackupActorState();
		static_cast<ModifyBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 3053 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(db));
															#line 3054 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		;
															#line 16832 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3043 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 16848 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			{
															#line 3044 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 16852 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			}
															#line 3045 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "ERROR: Could not create backup container at '%s': %s\n", options.destURL.get().c_str(), e.what());
															#line 3049 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1Catch1(backup_error(), loopDepth);
															#line 16858 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ModifyBackupActor*>(this)->actor_wait_state > 0) static_cast<ModifyBackupActor*>(this)->actor_wait_state = 0;
		static_cast<ModifyBackupActor*>(this)->ActorCallback< ModifyBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ModifyBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
															#line 3109 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!static_cast<ModifyBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ModifyBackupActorState(); static_cast<ModifyBackupActor*>(this)->destroy(); return 0; }
															#line 16972 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		new (&static_cast<ModifyBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ModifyBackupActorState();
		static_cast<ModifyBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 3056 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 3057 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 3059 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Optional<UidAndAbortedFlagT>> __when_expr_1 = tag.get(db.getReference());
															#line 3059 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<ModifyBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 16998 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ModifyBackupActor*>(this)->actor_wait_state = 2;
															#line 3059 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ModifyBackupActor, 1, Optional<UidAndAbortedFlagT> >*>(static_cast<ModifyBackupActor*>(this)));
															#line 17003 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 3105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr->onError(e);
															#line 3105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<ModifyBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 17040 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ModifyBackupActor*>(this)->actor_wait_state = 6;
															#line 3105 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ModifyBackupActor, 5, Void >*>(static_cast<ModifyBackupActor*>(this)));
															#line 17045 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 3061 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!uidFlag.present())
															#line 17060 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3062 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "No backup exists on tag '%s'\n", tagName.c_str());
															#line 3063 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1cont1loopBody1Catch1(backup_error(), loopDepth);
															#line 17066 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3066 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (uidFlag.get().second)
															#line 17070 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3067 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "Cannot modify aborted backup on tag '%s'\n", tagName.c_str());
															#line 3068 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1cont1loopBody1Catch1(backup_error(), loopDepth);
															#line 17076 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3071 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		config = BackupConfig(uidFlag.get().first);
															#line 3072 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<EBackupState> __when_expr_2 = config.stateEnum().getOrThrow(tr, Snapshot::False, backup_invalid_info());
															#line 3072 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<ModifyBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17084 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ModifyBackupActor*>(this)->actor_wait_state = 3;
															#line 3072 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ModifyBackupActor, 2, EBackupState >*>(static_cast<ModifyBackupActor*>(this)));
															#line 17089 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<UidAndAbortedFlagT> const& __uidFlag,int loopDepth) 
	{
															#line 3059 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		uidFlag = __uidFlag;
															#line 17098 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<UidAndAbortedFlagT> && __uidFlag,int loopDepth) 
	{
		uidFlag = std::move(__uidFlag);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ModifyBackupActor*>(this)->actor_wait_state > 0) static_cast<ModifyBackupActor*>(this)->actor_wait_state = 0;
		static_cast<ModifyBackupActor*>(this)->ActorCallback< ModifyBackupActor, 1, Optional<UidAndAbortedFlagT> >::remove();

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 1, Optional<UidAndAbortedFlagT> >*,Optional<UidAndAbortedFlagT> const& value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 1, Optional<UidAndAbortedFlagT> >*,Optional<UidAndAbortedFlagT> && value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ModifyBackupActor, 1, Optional<UidAndAbortedFlagT> >*,Error err) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(EBackupState const& s,int loopDepth) 
	{
															#line 3073 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!FileBackupAgent::isRunnable(s))
															#line 17177 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3074 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "Backup on tag '%s' is not runnable.\n", tagName.c_str());
															#line 3075 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1cont1loopBody1Catch1(backup_error(), loopDepth);
															#line 17183 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (options.verifyUID.present() && options.verifyUID.get() != uidFlag.get().first.toString())
															#line 17187 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "UID verification failed, backup on tag '%s' is '%s' but '%s' was specified.\n", tagName.c_str(), uidFlag.get().first.toString().c_str(), options.verifyUID.get().c_str());
															#line 3084 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1cont1loopBody1Catch1(backup_error(), loopDepth);
															#line 17193 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3087 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (options.snapshotIntervalSeconds.present())
															#line 17197 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3088 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			config.snapshotIntervalSeconds().set(tr, options.snapshotIntervalSeconds.get());
															#line 17201 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3091 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (options.activeSnapshotIntervalSeconds.present())
															#line 17205 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3092 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Version> __when_expr_3 = config.snapshotBeginVersion().getOrThrow(tr, Snapshot::False, backup_error());
															#line 3092 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<ModifyBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17211 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<ModifyBackupActor*>(this)->actor_wait_state = 4;
															#line 3092 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ModifyBackupActor, 3, Version >*>(static_cast<ModifyBackupActor*>(this)));
															#line 17216 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(EBackupState && s,int loopDepth) 
	{
															#line 3073 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (!FileBackupAgent::isRunnable(s))
															#line 17230 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3074 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "Backup on tag '%s' is not runnable.\n", tagName.c_str());
															#line 3075 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1cont1loopBody1Catch1(backup_error(), loopDepth);
															#line 17236 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3078 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (options.verifyUID.present() && options.verifyUID.get() != uidFlag.get().first.toString())
															#line 17240 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3079 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			fprintf(stderr, "UID verification failed, backup on tag '%s' is '%s' but '%s' was specified.\n", tagName.c_str(), uidFlag.get().first.toString().c_str(), options.verifyUID.get().c_str());
															#line 3084 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			return a_body1cont1loopBody1Catch1(backup_error(), loopDepth);
															#line 17246 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3087 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (options.snapshotIntervalSeconds.present())
															#line 17250 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3088 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			config.snapshotIntervalSeconds().set(tr, options.snapshotIntervalSeconds.get());
															#line 17254 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3091 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (options.activeSnapshotIntervalSeconds.present())
															#line 17258 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3092 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			StrictFuture<Version> __when_expr_3 = config.snapshotBeginVersion().getOrThrow(tr, Snapshot::False, backup_error());
															#line 3092 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			if (static_cast<ModifyBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17264 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<ModifyBackupActor*>(this)->actor_wait_state = 4;
															#line 3092 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ModifyBackupActor, 3, Version >*>(static_cast<ModifyBackupActor*>(this)));
															#line 17269 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(EBackupState const& s,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(EBackupState && s,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ModifyBackupActor*>(this)->actor_wait_state > 0) static_cast<ModifyBackupActor*>(this)->actor_wait_state = 0;
		static_cast<ModifyBackupActor*>(this)->ActorCallback< ModifyBackupActor, 2, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 2, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 2, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ModifyBackupActor, 2, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont6(int loopDepth) 
	{
															#line 3098 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (options.destURL.present())
															#line 17358 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		{
															#line 3099 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
			config.backupContainer().set(tr, bc);
															#line 17362 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		}
															#line 3102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		StrictFuture<Void> __when_expr_4 = tr->commit();
															#line 3102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		if (static_cast<ModifyBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 17368 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<ModifyBackupActor*>(this)->actor_wait_state = 5;
															#line 3102 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ModifyBackupActor, 4, Void >*>(static_cast<ModifyBackupActor*>(this)));
															#line 17373 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Version const& begin,int loopDepth) 
	{
															#line 3093 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		config.snapshotTargetEndVersion().set(tr, begin + ((int64_t)options.activeSnapshotIntervalSeconds.get() * CLIENT_KNOBS->CORE_VERSIONSPERSECOND));
															#line 17382 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont10(Version && begin,int loopDepth) 
	{
															#line 3093 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
		config.snapshotTargetEndVersion().set(tr, begin + ((int64_t)options.activeSnapshotIntervalSeconds.get() * CLIENT_KNOBS->CORE_VERSIONSPERSECOND));
															#line 17391 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Version const& begin,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(begin, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Version && begin,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont10(std::move(begin), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ModifyBackupActor*>(this)->actor_wait_state > 0) static_cast<ModifyBackupActor*>(this)->actor_wait_state = 0;
		static_cast<ModifyBackupActor*>(this)->ActorCallback< ModifyBackupActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ModifyBackupActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont11(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont11(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ModifyBackupActor*>(this)->actor_wait_state > 0) static_cast<ModifyBackupActor*>(this)->actor_wait_state = 0;
		static_cast<ModifyBackupActor*>(this)->ActorCallback< ModifyBackupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ModifyBackupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ModifyBackupActor*>(this)->actor_wait_state > 0) static_cast<ModifyBackupActor*>(this)->actor_wait_state = 0;
		static_cast<ModifyBackupActor*>(this)->ActorCallback< ModifyBackupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ModifyBackupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ModifyBackupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Database db;
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	std::string tagName;
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	BackupModifyOptions options;
															#line 3035 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	KeyBackedTag tag;
															#line 3037 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 3053 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 3059 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	Optional<UidAndAbortedFlagT> uidFlag;
															#line 3071 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	BackupConfig config;
															#line 17661 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
};
// This generated class is to be used only via modifyBackup()
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
class ModifyBackupActor final : public Actor<Void>, public ActorCallback< ModifyBackupActor, 0, Void >, public ActorCallback< ModifyBackupActor, 1, Optional<UidAndAbortedFlagT> >, public ActorCallback< ModifyBackupActor, 2, EBackupState >, public ActorCallback< ModifyBackupActor, 3, Version >, public ActorCallback< ModifyBackupActor, 4, Void >, public ActorCallback< ModifyBackupActor, 5, Void >, public FastAllocated<ModifyBackupActor>, public ModifyBackupActorState<ModifyBackupActor> {
															#line 17666 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
public:
	using FastAllocated<ModifyBackupActor>::operator new;
	using FastAllocated<ModifyBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14484607696359297024UL, 11217486560074529536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ModifyBackupActor, 0, Void >;
friend struct ActorCallback< ModifyBackupActor, 1, Optional<UidAndAbortedFlagT> >;
friend struct ActorCallback< ModifyBackupActor, 2, EBackupState >;
friend struct ActorCallback< ModifyBackupActor, 3, Version >;
friend struct ActorCallback< ModifyBackupActor, 4, Void >;
friend struct ActorCallback< ModifyBackupActor, 5, Void >;
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	ModifyBackupActor(Database const& db,std::string const& tagName,BackupModifyOptions const& options) 
															#line 17688 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
		 : Actor<Void>(),
		   ModifyBackupActorState<ModifyBackupActor>(db, tagName, options),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("modifyBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16192591773595447296UL, 6515210018949880064UL);
		ActorExecutionContextHelper __helper(static_cast<ModifyBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("modifyBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("modifyBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ModifyBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ModifyBackupActor, 1, Optional<UidAndAbortedFlagT> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ModifyBackupActor, 2, EBackupState >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ModifyBackupActor, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ModifyBackupActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ModifyBackupActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
[[nodiscard]] Future<Void> modifyBackup( Database const& db, std::string const& tagName, BackupModifyOptions const& options ) {
															#line 3029 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"
	return Future<Void>(new ModifyBackupActor(db, tagName, options));
															#line 17726 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/build_output/fdbbackup/backup.actor.g.cpp"
}

#line 3111 "/codebuild/output/src2680131183/src/github.com/apple/foundationdb/fdbbackup/backup.actor.cpp"

static std::vector<std::vector<StringRef>> parseLine(std::string& line, bool& err, bool& partial) {
	err = false;
	partial = false;

	bool quoted = false;
	std::vector<StringRef> buf;
	std::vector<std::vector<StringRef>> ret;

	size_t i = line.find_first_not_of(' ');
	size_t offset = i;

	bool forcetoken = false;

	while (i <= line.length()) {
		switch (line[i]) {
		case ';':
			if (!quoted) {
				if (i > offset)
					buf.push_back(StringRef((uint8_t*)(line.data() + offset), i - offset));
				ret.push_back(std::move(buf));
				offset = i = line.find_first_not_of(' ', i + 1);
			} else
				i++;
			break;
		case '"':
			quoted = !quoted;
			line.erase(i, 1);
			if (quoted)
				forcetoken = true;
			break;
		case ' ':
			if (!quoted) {
				buf.push_back(StringRef((uint8_t*)(line.data() + offset), i - offset));
				offset = i = line.find_first_not_of(' ', i);
				forcetoken = false;
			} else
				i++;
			break;
		case '\\':
			if (i + 2 > line.length()) {
				err = true;
				ret.push_back(std::move(buf));
				return ret;
			}
			switch (line[i + 1]) {
				char ent, save;
			case '"':
			case '\\':
			case ' ':
			case ';':
				line.erase(i, 1);
				break;
			case 'x':
				if (i + 4 > line.length()) {
					err = true;
					ret.push_back(std::move(buf));
					return ret;
				}
				char* pEnd;
				save = line[i + 4];
				line[i + 4] = 0;
				ent = char(strtoul(line.data() + i + 2, &pEnd, 16));
				if (*pEnd) {
					err = true;
					ret.push_back(std::move(buf));
					return ret;
				}
				line[i + 4] = save;
				line.replace(i, 4, 1, ent);
				break;
			default:
				err = true;
				ret.push_back(std::move(buf));
				return ret;
			}
		default:
			i++;
		}
	}

	i -= 1;
	if (i > offset || forcetoken)
		buf.push_back(StringRef((uint8_t*)(line.data() + offset), i - offset));

	ret.push_back(std::move(buf));

	if (quoted)
		partial = true;

	return ret;
}

static void addKeyRange(std::string optionValue, Standalone<VectorRef<KeyRangeRef>>& keyRanges) {
	bool err = false, partial = false;
	[[maybe_unused]] int tokenArray = 0;

	auto parsed = parseLine(optionValue, err, partial);

	for (auto tokens : parsed) {
		tokenArray++;

		/*
		int tokenIndex = 0;
		for (auto token : tokens)
		{
		    tokenIndex++;

		    printf("%4d token #%2d: %s\n", tokenArray, tokenIndex, printable(token).c_str());
		}
		*/

		// Process the keys
		// <begin> [end]
		switch (tokens.size()) {
			// empty
		case 0:
			break;

			// single key range
		case 1:
			keyRanges.push_back_deep(keyRanges.arena(), KeyRangeRef(tokens.at(0), strinc(tokens.at(0))));
			break;

			// full key range
		case 2:
			try {
				keyRanges.push_back_deep(keyRanges.arena(), KeyRangeRef(tokens.at(0), tokens.at(1)));
			} catch (Error& e) {
				fprintf(stderr,
				        "ERROR: Invalid key range `%s %s' reported error %s\n",
				        tokens.at(0).toString().c_str(),
				        tokens.at(1).toString().c_str(),
				        e.what());
				throw invalid_option_value();
			}
			break;

			// Too many keys
		default:
			fmt::print(stderr, "ERROR: Invalid key range identified with {} keys", tokens.size());
			throw invalid_option_value();
			break;
		}
	}

	return;
}

Version parseVersion(const char* str) {
	StringRef s((const uint8_t*)str, strlen(str));

	if (s.endsWith("days"_sr) || s.endsWith("d"_sr)) {
		float days;
		if (sscanf(str, "%f", &days) != 1) {
			fprintf(stderr, "Could not parse version: %s\n", str);
			flushAndExit(FDB_EXIT_ERROR);
		}
		return (double)CLIENT_KNOBS->CORE_VERSIONSPERSECOND * 24 * 3600 * -days;
	}

	Version ver;
	if (sscanf(str, "%" SCNd64, &ver) != 1) {
		fprintf(stderr, "Could not parse version: %s\n", str);
		flushAndExit(FDB_EXIT_ERROR);
	}
	return ver;
}

#ifdef ALLOC_INSTRUMENTATION
extern uint8_t* g_extra_memory;
#endif

// Creates a connection to a cluster. Optionally prints an error if the connection fails.
Optional<Database> connectToCluster(std::string const& clusterFile,
                                    LocalityData const& localities,
                                    bool quiet = false) {
	auto resolvedClusterFile = ClusterConnectionFile::lookupClusterFileName(clusterFile);
	Reference<ClusterConnectionFile> ccf;

	Optional<Database> db;

	try {
		ccf = makeReference<ClusterConnectionFile>(resolvedClusterFile.first);
	} catch (Error& e) {
		if (!quiet)
			fprintf(stderr, "%s\n", ClusterConnectionFile::getErrorString(resolvedClusterFile, e).c_str());
		return db;
	}

	try {
		db = Database::createDatabase(ccf, ApiVersion::LATEST_VERSION, IsInternal::True, localities);
	} catch (Error& e) {
		if (!quiet) {
			fprintf(stderr, "ERROR: %s\n", e.what());
			fprintf(stderr, "ERROR: Unable to connect to cluster from `%s'\n", ccf->getLocation().c_str());
		}
		return db;
	}

	return db;
};

int main(int argc, char* argv[]) {
	platformInit();

	int status = FDB_EXIT_SUCCESS;

	std::string commandLine;
	for (int a = 0; a < argc; a++) {
		if (a)
			commandLine += ' ';
		commandLine += argv[a];
	}

	try {
#ifdef ALLOC_INSTRUMENTATION
		g_extra_memory = new uint8_t[1000000];
#endif
		registerCrashHandler();

		// Set default of line buffering standard out and error
		setvbuf(stdout, NULL, _IONBF, 0);
		setvbuf(stderr, NULL, _IONBF, 0);

		ProgramExe programExe = getProgramType(argv[0]);
		BackupType backupType = BackupType::UNDEFINED;
		RestoreType restoreType = RestoreType::UNKNOWN;
		DBType dbType = DBType::UNDEFINED;

		std::unique_ptr<CSimpleOpt> args;

		switch (programExe) {
		case ProgramExe::AGENT:
			args = std::make_unique<CSimpleOpt>(argc, argv, g_rgAgentOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
			break;
		case ProgramExe::DR_AGENT:
			args = std::make_unique<CSimpleOpt>(argc, argv, g_rgDBAgentOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
			break;
		case ProgramExe::BACKUP:
			// Display backup help, if no arguments
			if (argc < 2) {
				printBackupUsage(false);
				return FDB_EXIT_ERROR;
			} else {
				// Get the backup type
				backupType = getBackupType(argv[1]);

				// Create the appropriate simple opt
				switch (backupType) {
				case BackupType::START:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupStartOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::STATUS:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupStatusOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::ABORT:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupAbortOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::CLEANUP:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupCleanupOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::WAIT:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupWaitOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::DISCONTINUE:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupDiscontinueOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::PAUSE:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupPauseOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::RESUME:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupPauseOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::EXPIRE:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupExpireOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::DELETE_BACKUP:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupDeleteOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::DESCRIBE:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupDescribeOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::DUMP:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupDumpOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::LIST:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupListOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::QUERY:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupQueryOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::MODIFY:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupModifyOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::TAGS:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgBackupTagsOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case BackupType::UNDEFINED:
				default:
					args =
					    std::make_unique<CSimpleOpt>(argc, argv, g_rgOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				}
			}
			break;
		case ProgramExe::DB_BACKUP:
			// Display backup help, if no arguments
			if (argc < 2) {
				printDBBackupUsage(false);
				return FDB_EXIT_ERROR;
			} else {
				// Get the backup type
				dbType = getDBType(argv[1]);

				// Create the appropriate simple opt
				switch (dbType) {
				case DBType::START:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgDBStartOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case DBType::STATUS:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgDBStatusOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case DBType::SWITCH:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgDBSwitchOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case DBType::ABORT:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgDBAbortOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case DBType::PAUSE:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgDBPauseOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case DBType::RESUME:
					args = std::make_unique<CSimpleOpt>(
					    argc - 1, &argv[1], g_rgDBPauseOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				case DBType::UNDEFINED:
				default:
					args =
					    std::make_unique<CSimpleOpt>(argc, argv, g_rgOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
					break;
				}
			}
			break;
		case ProgramExe::RESTORE:
			if (argc < 2) {
				printRestoreUsage(false);
				return FDB_EXIT_ERROR;
			}
			// Get the restore operation type
			restoreType = getRestoreType(argv[1]);
			if (restoreType == RestoreType::UNKNOWN) {
				args = std::make_unique<CSimpleOpt>(argc, argv, g_rgOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
			} else {
				args = std::make_unique<CSimpleOpt>(
				    argc - 1, argv + 1, g_rgRestoreOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
			}
			break;
		case ProgramExe::FASTRESTORE_TOOL:
			if (argc < 2) {
				printFastRestoreUsage(false);
				return FDB_EXIT_ERROR;
			}
			// Get the restore operation type
			restoreType = getRestoreType(argv[1]);
			if (restoreType == RestoreType::UNKNOWN) {
				args = std::make_unique<CSimpleOpt>(argc, argv, g_rgOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
			} else {
				args = std::make_unique<CSimpleOpt>(
				    argc - 1, argv + 1, g_rgRestoreOptions, SO_O_EXACT | SO_O_HYPHEN_TO_UNDERSCORE);
			}
			break;
		case ProgramExe::UNDEFINED:
		default:
			fprintf(stderr, "FoundationDB " FDB_VT_PACKAGE_NAME " (v" FDB_VT_VERSION ")\n");
			fprintf(stderr, "ERROR: Unable to determine program type based on executable `%s'\n", argv[0]);
			return FDB_EXIT_ERROR;
			break;
		}

		Optional<std::string> proxy;
		std::string p;
		if (platform::getEnvironmentVar("HTTP_PROXY", p) || platform::getEnvironmentVar("HTTPS_PROXY", p)) {
			proxy = p;
		}
		std::string destinationContainer;
		bool describeDeep = false;
		bool describeTimestamps = false;
		int initialSnapshotIntervalSeconds =
		    0; // The initial snapshot has a desired duration of 0, meaning go as fast as possible.
		int snapshotIntervalSeconds = CLIENT_KNOBS->BACKUP_DEFAULT_SNAPSHOT_INTERVAL_SEC;
		std::string clusterFile;
		std::string sourceClusterFile;
		std::string baseUrl;
		std::string expireDatetime;
		Version expireVersion = invalidVersion;
		std::string expireRestorableAfterDatetime;
		Version expireRestorableAfterVersion = std::numeric_limits<Version>::max();
		std::vector<std::pair<std::string, std::string>> knobs;
		std::string tagName = BackupAgentBase::getDefaultTag().toString();
		bool tagProvided = false;
		std::string restoreContainer;
		std::string addPrefix;
		std::string removePrefix;
		Standalone<VectorRef<KeyRangeRef>> backupKeys;
		Standalone<VectorRef<KeyRangeRef>> backupKeysFilter;
		int maxErrors = 20;
		Version beginVersion = invalidVersion;
		Version restoreVersion = invalidVersion;
		Version snapshotVersion = invalidVersion;
		std::string restoreTimestamp;
		WaitForComplete waitForDone{ false };
		StopWhenDone stopWhenDone{ true };
		UsePartitionedLog usePartitionedLog{ false }; // Set to true to use new backup system
		IncrementalBackupOnly incrementalBackupOnly{ false };
		OnlyApplyMutationLogs onlyApplyMutationLogs{ false };
		InconsistentSnapshotOnly inconsistentSnapshotOnly{ false };
		ForceAction forceAction{ false };
		bool trace = false;
		bool quietDisplay = false;
		bool dryRun = false;
		bool restoreSystemKeys = false;
		bool restoreUserKeys = false;
		bool encryptionEnabled = true;
		bool encryptSnapshotFilesPresent = false;
		std::string traceDir = "";
		std::string traceFormat = "";
		std::string traceLogGroup;
		uint64_t traceRollSize = TRACE_DEFAULT_ROLL_SIZE;
		uint64_t traceMaxLogsSize = TRACE_DEFAULT_MAX_LOGS_SIZE;
		ESOError lastError;
		PartialBackup partial{ true };
		DstOnly dstOnly{ false };
		LocalityData localities;
		uint64_t memLimit = 8LL << 30;
		uint64_t virtualMemLimit = 0; // unlimited
		Optional<uint64_t> ti;
		BackupTLSConfig tlsConfig;
		Version dumpBegin = 0;
		Version dumpEnd = std::numeric_limits<Version>::max();
		std::string restoreClusterFileDest;
		std::string restoreClusterFileOrig;
		bool jsonOutput = false;
		DeleteData deleteData{ false };
		Optional<std::string> encryptionKeyFile;
		Optional<std::string> blobManifestUrl;

		BackupModifyOptions modifyOptions;

		if (argc == 1) {
			printUsage(programExe, false);
			return FDB_EXIT_ERROR;
		}

#ifdef _WIN32
		// Windows needs a gentle nudge to format floats correctly
		//_set_output_format(_TWO_DIGIT_EXPONENT);
#endif

		while (args->Next()) {
			lastError = args->LastError();

			switch (lastError) {
			case SO_SUCCESS:
				break;

			case SO_ARG_INVALID_DATA:
				fprintf(stderr, "ERROR: invalid argument to option `%s'\n", args->OptionText());
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;

			case SO_ARG_INVALID:
				fprintf(stderr, "ERROR: argument given for option `%s'\n", args->OptionText());
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;

			case SO_ARG_MISSING:
				fprintf(stderr, "ERROR: missing argument for option `%s'\n", args->OptionText());
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;

			case SO_OPT_INVALID:
				fprintf(stderr, "ERROR: unknown option `%s'\n", args->OptionText());
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;

			default:
				fprintf(stderr, "ERROR: argument given for option `%s'\n", args->OptionText());
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;
			}

			int optId = args->OptionId();
			switch (optId) {
			case OPT_HELP:
				printUsage(programExe, false);
				return FDB_EXIT_SUCCESS;
				break;
			case OPT_DEVHELP:
				printUsage(programExe, true);
				return FDB_EXIT_SUCCESS;
				break;
			case OPT_VERSION:
				printVersion();
				return FDB_EXIT_SUCCESS;
				break;
			case OPT_BUILD_FLAGS:
				printBuildInformation();
				return FDB_EXIT_SUCCESS;
				break;
			case OPT_NOBUFSTDOUT:
				setvbuf(stdout, NULL, _IONBF, 0);
				setvbuf(stderr, NULL, _IONBF, 0);
				break;
			case OPT_BUFSTDOUTERR:
				setvbuf(stdout, NULL, _IOFBF, BUFSIZ);
				setvbuf(stderr, NULL, _IOFBF, BUFSIZ);
				break;
			case OPT_QUIET:
				quietDisplay = true;
				break;
			case OPT_DRYRUN:
				dryRun = true;
				break;
			case OPT_DELETE_DATA:
				deleteData.set(true);
				break;
			case OPT_MIN_CLEANUP_SECONDS:
				knobs.emplace_back("min_cleanup_seconds", args->OptionArg());
				break;
			case OPT_FORCE:
				forceAction.set(true);
				break;
			case OPT_TRACE:
				trace = true;
				break;
			case OPT_TRACE_DIR:
				trace = true;
				traceDir = args->OptionArg();
				break;
			case OPT_TRACE_FORMAT:
				if (!validateTraceFormat(args->OptionArg())) {
					fprintf(stderr, "WARNING: Unrecognized trace format `%s'\n", args->OptionArg());
				}
				traceFormat = args->OptionArg();
				break;
			case OPT_TRACE_LOG_GROUP:
				traceLogGroup = args->OptionArg();
				break;
			case OPT_LOCALITY: {
				Optional<std::string> localityKey = extractPrefixedArgument("--locality", args->OptionSyntax());
				if (!localityKey.present()) {
					fprintf(stderr, "ERROR: unable to parse locality key '%s'\n", args->OptionSyntax());
					return FDB_EXIT_ERROR;
				}
				Standalone<StringRef> key = StringRef(localityKey.get());
				std::transform(key.begin(), key.end(), mutateString(key), ::tolower);
				localities.set(key, Standalone<StringRef>(std::string(args->OptionArg())));
				break;
			}
			case OPT_EXPIRE_BEFORE_DATETIME:
				expireDatetime = args->OptionArg();
				break;
			case OPT_EXPIRE_RESTORABLE_AFTER_DATETIME:
				expireRestorableAfterDatetime = args->OptionArg();
				break;
			case OPT_EXPIRE_BEFORE_VERSION:
			case OPT_EXPIRE_RESTORABLE_AFTER_VERSION:
			case OPT_EXPIRE_MIN_RESTORABLE_DAYS:
			case OPT_EXPIRE_DELETE_BEFORE_DAYS: {
				const char* a = args->OptionArg();
				long long ver = 0;
				if (!sscanf(a, "%lld", &ver)) {
					fprintf(stderr, "ERROR: Could not parse expiration version `%s'\n", a);
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}

				// Interpret the value as days worth of versions relative to now (negative)
				if (optId == OPT_EXPIRE_MIN_RESTORABLE_DAYS || optId == OPT_EXPIRE_DELETE_BEFORE_DAYS) {
					ver = -ver * 24 * 60 * 60 * CLIENT_KNOBS->CORE_VERSIONSPERSECOND;
				}

				if (optId == OPT_EXPIRE_BEFORE_VERSION || optId == OPT_EXPIRE_DELETE_BEFORE_DAYS)
					expireVersion = ver;
				else
					expireRestorableAfterVersion = ver;
				break;
			}
			case OPT_RESTORE_TIMESTAMP:
				restoreTimestamp = args->OptionArg();
				break;
			case OPT_BASEURL:
				baseUrl = args->OptionArg();
				break;
			case OPT_ENCRYPT_FILES: {
				const char* a = args->OptionArg();
				int encryptFiles;
				if (!sscanf(a, "%d", &encryptFiles)) {
					fprintf(stderr, "ERROR: Could not parse encrypt-files `%s'\n", a);
					return FDB_EXIT_ERROR;
				}
				if (encryptFiles != 0 && encryptFiles != 1) {
					fprintf(stderr, "ERROR: encrypt-files must be either 0 or 1\n");
					return FDB_EXIT_ERROR;
				}
				encryptSnapshotFilesPresent = true;
				if (encryptFiles == 0) {
					encryptionEnabled = false;
				} else {
					encryptionEnabled = true;
				}
				break;
			}
			case OPT_RESTORE_CLUSTERFILE_DEST:
				restoreClusterFileDest = args->OptionArg();
				break;
			case OPT_RESTORE_CLUSTERFILE_ORIG:
				restoreClusterFileOrig = args->OptionArg();
				break;
			case OPT_CLUSTERFILE:
				clusterFile = args->OptionArg();
				break;
			case OPT_DEST_CLUSTER:
				clusterFile = args->OptionArg();
				break;
			case OPT_SOURCE_CLUSTER:
				sourceClusterFile = args->OptionArg();
				break;
			case OPT_CLEANUP:
				partial.set(false);
				break;
			case OPT_DSTONLY:
				dstOnly.set(true);
				break;
			case OPT_KNOB: {
				Optional<std::string> knobName = extractPrefixedArgument("--knob", args->OptionSyntax());
				if (!knobName.present()) {
					fprintf(stderr, "ERROR: unable to parse knob option '%s'\n", args->OptionSyntax());
					return FDB_EXIT_ERROR;
				}
				knobs.emplace_back(knobName.get(), args->OptionArg());
				break;
			}
			case OPT_BACKUPKEYS:
				try {
					addKeyRange(args->OptionArg(), backupKeys);
				} catch (Error&) {
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				break;
			case OPT_BACKUPKEYS_FILE:
				try {
					std::string line = readFileBytes(args->OptionArg(), 64 * 1024 * 1024);
					addKeyRange(line, backupKeys);
				} catch (Error&) {
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				break;
			case OPT_BACKUPKEYS_FILTER:
				try {
					addKeyRange(args->OptionArg(), backupKeysFilter);
				} catch (Error&) {
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				break;
			case OPT_PROXY:
				proxy = args->OptionArg();
				if (!Hostname::isHostname(proxy.get()) && !NetworkAddress::parseOptional(proxy.get()).present()) {
					fprintf(stderr, "ERROR: Proxy format should be either IP:port or host:port\n");
					return FDB_EXIT_ERROR;
				}
				modifyOptions.proxy = proxy;
				break;
			case OPT_DESTCONTAINER:
				destinationContainer = args->OptionArg();
				// If the url starts with '/' then prepend "file://" for backwards compatibility
				if (StringRef(destinationContainer).startsWith("/"_sr))
					destinationContainer = std::string("file://") + destinationContainer;
				modifyOptions.destURL = destinationContainer;
				break;
			case OPT_SNAPSHOTINTERVAL:
			case OPT_INITIAL_SNAPSHOT_INTERVAL:
			case OPT_MOD_ACTIVE_INTERVAL: {
				const char* a = args->OptionArg();
				int seconds;
				if (!sscanf(a, "%d", &seconds)) {
					fprintf(stderr, "ERROR: Could not parse snapshot interval `%s'\n", a);
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				if (optId == OPT_SNAPSHOTINTERVAL) {
					snapshotIntervalSeconds = seconds;
					modifyOptions.snapshotIntervalSeconds = seconds;
				} else if (optId == OPT_INITIAL_SNAPSHOT_INTERVAL) {
					initialSnapshotIntervalSeconds = seconds;
				} else if (optId == OPT_MOD_ACTIVE_INTERVAL) {
					modifyOptions.activeSnapshotIntervalSeconds = seconds;
				}
				break;
			}
			case OPT_MOD_VERIFY_UID:
				modifyOptions.verifyUID = args->OptionArg();
				break;
			case OPT_WAITFORDONE:
				waitForDone.set(true);
				break;
			case OPT_NOSTOPWHENDONE:
				stopWhenDone.set(false);
				break;
			case OPT_USE_PARTITIONED_LOG:
				usePartitionedLog.set(true);
				break;
			case OPT_INCREMENTALONLY:
				incrementalBackupOnly.set(true);
				onlyApplyMutationLogs.set(true);
				break;
			case OPT_ENCRYPTION_KEY_FILE:
				encryptionKeyFile = args->OptionArg();
				break;
			case OPT_RESTORECONTAINER:
				restoreContainer = args->OptionArg();
				// If the url starts with '/' then prepend "file://" for backwards compatibility
				if (StringRef(restoreContainer).startsWith("/"_sr))
					restoreContainer = std::string("file://") + restoreContainer;
				break;
			case OPT_DESCRIBE_DEEP:
				describeDeep = true;
				break;
			case OPT_DESCRIBE_TIMESTAMPS:
				describeTimestamps = true;
				break;
			case OPT_PREFIX_ADD: {
				bool err = false;
				addPrefix = decode_hex_string(args->OptionArg(), err);
				if (err) {
					fprintf(stderr, "ERROR: Could not parse add prefix\n");
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				break;
			}
			case OPT_PREFIX_REMOVE: {
				bool err = false;
				removePrefix = decode_hex_string(args->OptionArg(), err);
				if (err) {
					fprintf(stderr, "ERROR: Could not parse remove prefix\n");
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				break;
			}
			case OPT_ERRORLIMIT: {
				const char* a = args->OptionArg();
				if (!sscanf(a, "%d", &maxErrors)) {
					fprintf(stderr, "ERROR: Could not parse max number of errors `%s'\n", a);
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				break;
			}
			case OPT_RESTORE_BEGIN_VERSION: {
				const char* a = args->OptionArg();
				long long ver = 0;
				if (!sscanf(a, "%lld", &ver)) {
					fprintf(stderr, "ERROR: Could not parse database beginVersion `%s'\n", a);
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				beginVersion = ver;
				break;
			}
			case OPT_RESTORE_VERSION: {
				const char* a = args->OptionArg();
				long long ver = 0;
				if (!sscanf(a, "%lld", &ver)) {
					fprintf(stderr, "ERROR: Could not parse database version `%s'\n", a);
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				restoreVersion = ver;
				break;
			}
			case OPT_RESTORE_SNAPSHOT_VERSION: {
				const char* a = args->OptionArg();
				long long ver = 0;
				if (!sscanf(a, "%lld", &ver)) {
					fprintf(stderr, "ERROR: Could not parse database version `%s'\n", a);
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				snapshotVersion = ver;
				break;
			}
			case OPT_RESTORE_USER_DATA: {
				restoreUserKeys = true;
				break;
			}
			case OPT_RESTORE_SYSTEM_DATA: {
				restoreSystemKeys = true;
				break;
			}
			case OPT_RESTORE_INCONSISTENT_SNAPSHOT_ONLY: {
				inconsistentSnapshotOnly.set(true);
				break;
			}
#ifdef _WIN32
			case OPT_PARENTPID: {
				auto pid_str = args->OptionArg();
				int parent_pid = atoi(pid_str);
				auto pHandle = OpenProcess(SYNCHRONIZE, FALSE, parent_pid);
				if (!pHandle) {
					TraceEvent("ParentProcessOpenError").GetLastError();
					fprintf(stderr, "Could not open parent process at pid %d (error %d)", parent_pid, GetLastError());
					throw platform_error();
				}
				startThread(&parentWatcher, pHandle);
				break;
			}
#endif
			case OPT_TAGNAME:
				tagName = args->OptionArg();
				tagProvided = true;
				break;
			case OPT_CRASHONERROR:
				g_crashOnError = true;
				break;
			case OPT_MEMLIMIT:
				ti = parse_with_suffix(args->OptionArg(), "MiB");
				if (!ti.present()) {
					fprintf(stderr, "ERROR: Could not parse memory limit from `%s'\n", args->OptionArg());
					printHelpTeaser(argv[0]);
					flushAndExit(FDB_EXIT_ERROR);
				}
				memLimit = ti.get();
				break;
			case OPT_VMEMLIMIT:
				ti = parse_with_suffix(args->OptionArg(), "MiB");
				if (!ti.present()) {
					fprintf(stderr, "ERROR: Could not parse virtual memory limit from `%s'\n", args->OptionArg());
					printHelpTeaser(argv[0]);
					flushAndExit(FDB_EXIT_ERROR);
				}
				virtualMemLimit = ti.get();
				break;
			case OPT_BLOB_CREDENTIALS:
				tlsConfig.blobCredentials.push_back(args->OptionArg());
				break;
			case TLSConfig::OPT_TLS_PLUGIN:
				args->OptionArg();
				break;
			case TLSConfig::OPT_TLS_CERTIFICATES:
				tlsConfig.tlsCertPath = args->OptionArg();
				break;
			case TLSConfig::OPT_TLS_PASSWORD:
				tlsConfig.tlsPassword = args->OptionArg();
				break;
			case TLSConfig::OPT_TLS_CA_FILE:
				tlsConfig.tlsCAPath = args->OptionArg();
				break;
			case TLSConfig::OPT_TLS_KEY:
				tlsConfig.tlsKeyPath = args->OptionArg();
				break;
			case TLSConfig::OPT_TLS_VERIFY_PEERS:
				tlsConfig.tlsVerifyPeers = args->OptionArg();
				break;
			case OPT_DUMP_BEGIN:
				dumpBegin = parseVersion(args->OptionArg());
				break;
			case OPT_DUMP_END:
				dumpEnd = parseVersion(args->OptionArg());
				break;
			case OPT_JSON:
				jsonOutput = true;
				break;
			case OPT_BLOB_MANIFEST_URL: {
				blobManifestUrl = args->OptionArg();
				break;
			}
			}
		}

		if (encryptionKeyFile.present() && encryptSnapshotFilesPresent) {
			fprintf(stderr, "WARNING: Use of --encrypt-files and --encryption-key-file together is discouraged\n");
		}

		// Process the extra arguments
		for (int argLoop = 0; argLoop < args->FileCount(); argLoop++) {
			switch (programExe) {
			case ProgramExe::AGENT:
				fprintf(stderr, "ERROR: Backup Agent does not support argument value `%s'\n", args->File(argLoop));
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;

				// Add the backup key range
			case ProgramExe::BACKUP:
				// Error, if the keys option was not specified
				if (backupKeys.size() == 0) {
					fprintf(stderr, "ERROR: Unknown backup option value `%s'\n", args->File(argLoop));
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				// Otherwise, assume the item is a key range
				else {
					try {
						addKeyRange(args->File(argLoop), backupKeys);
					} catch (Error&) {
						printHelpTeaser(argv[0]);
						return FDB_EXIT_ERROR;
					}
				}
				break;

			case ProgramExe::RESTORE:
				fprintf(stderr, "ERROR: FDB Restore does not support argument value `%s'\n", args->File(argLoop));
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;

			case ProgramExe::FASTRESTORE_TOOL:
				fprintf(
				    stderr, "ERROR: FDB Fast Restore Tool does not support argument value `%s'\n", args->File(argLoop));
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;

			case ProgramExe::DR_AGENT:
				fprintf(stderr, "ERROR: DR Agent does not support argument value `%s'\n", args->File(argLoop));
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;

			case ProgramExe::DB_BACKUP:
				// Error, if the keys option was not specified
				if (backupKeys.size() == 0) {
					fprintf(stderr, "ERROR: Unknown DR option value `%s'\n", args->File(argLoop));
					printHelpTeaser(argv[0]);
					return FDB_EXIT_ERROR;
				}
				// Otherwise, assume the item is a key range
				else {
					try {
						addKeyRange(args->File(argLoop), backupKeys);
					} catch (Error&) {
						printHelpTeaser(argv[0]);
						return FDB_EXIT_ERROR;
					}
				}
				break;

			case ProgramExe::UNDEFINED:
			default:
				return FDB_EXIT_ERROR;
			}
		}

		if (restoreSystemKeys && restoreUserKeys) {
			fprintf(stderr, "ERROR: Please only specify one of --user-data or --system-metadata, not both\n");
			return FDB_EXIT_ERROR;
		}

		if (trace) {
			if (!traceLogGroup.empty())
				setNetworkOption(FDBNetworkOptions::TRACE_LOG_GROUP, StringRef(traceLogGroup));

			if (traceDir.empty())
				setNetworkOption(FDBNetworkOptions::TRACE_ENABLE);
			else
				setNetworkOption(FDBNetworkOptions::TRACE_ENABLE, StringRef(traceDir));
			if (!traceFormat.empty()) {
				setNetworkOption(FDBNetworkOptions::TRACE_FORMAT, StringRef(traceFormat));
			}

			setNetworkOption(FDBNetworkOptions::ENABLE_SLOW_TASK_PROFILING);
		}
		setNetworkOption(FDBNetworkOptions::DISABLE_CLIENT_STATISTICS_LOGGING);

		// deferred TLS options
		if (!tlsConfig.setupTLS()) {
			return 1;
		}

		Error::init();
		std::set_new_handler(&platform::outOfMemory);
		setMemoryQuota(virtualMemLimit);

		Database db;
		Database sourceDb;
		FileBackupAgent ba;
		Key tag;
		Future<Optional<Void>> f;
		Future<Optional<int>> fstatus;
		Reference<IBackupContainer> c;

		try {
			setupNetwork(0, UseMetrics::True);
		} catch (Error& e) {
			fprintf(stderr, "ERROR: %s\n", e.what());
			return FDB_EXIT_ERROR;
		}

		Future<Void> memoryUsageMonitor = startMemoryUsageMonitor(memLimit);

		IKnobCollection::setupKnobs(knobs);
		// Reinitialize knobs in order to update knobs that are dependent on explicitly set knobs
		IKnobCollection::getMutableGlobalKnobCollection().initialize(Randomize::False, IsSimulated::False);

		TraceEvent("ProgramStart")
		    .setMaxEventLength(12000)
		    .detail("SourceVersion", getSourceVersion())
		    .detail("Version", FDB_VT_VERSION)
		    .detail("PackageName", FDB_VT_PACKAGE_NAME)
		    .detailf("ActualTime", "%lld", DEBUG_DETERMINISM ? 0 : time(NULL))
		    .setMaxFieldLength(10000)
		    .detail("CommandLine", commandLine)
		    .setMaxFieldLength(0)
		    .detail("MemoryLimit", memLimit)
		    .detail("Proxy", proxy.orDefault(""))
		    .trackLatest("ProgramStart");

		// Ordinarily, this is done when the network is run. However, network thread should be set before TraceEvents
		// are logged. This thread will eventually run the network, so call it now.
		TraceEvent::setNetworkThread();

		// Sets up blob credentials, including one from the environment FDB_BLOB_CREDENTIALS.
		tlsConfig.setupBlobCredentials();

		// Opens a trace file if trace is set (and if a trace file isn't already open)
		// For most modes, initCluster() will open a trace file, but some fdbbackup operations do not require
		// a cluster so they should use this instead.
		auto initTraceFile = [&]() {
			if (trace)
				openTraceFile({}, traceRollSize, traceMaxLogsSize, traceDir, "trace", traceLogGroup);
		};

		auto initCluster = [&](bool quiet = false) {
			Optional<Database> result = connectToCluster(clusterFile, localities, quiet);
			if (result.present()) {
				db = result.get();
				// Make sure we are setting a transaction timeout and retry limit to prevent cases
				// where the fdbbackup command hangs infinitely. 60 seconds should be more than
				// enough for all cases to finish and 5 retries should also be good enough for
				// most cases.
				int64_t timeout = 60000;
				db->setOption(FDBDatabaseOptions::TRANSACTION_TIMEOUT,
				              Optional<StringRef>(StringRef((const uint8_t*)&timeout, sizeof(timeout))));
				int64_t retryLimit = 5;
				db->setOption(FDBDatabaseOptions::TRANSACTION_RETRY_LIMIT,
				              Optional<StringRef>(StringRef((const uint8_t*)&retryLimit, sizeof(retryLimit))));
			}

			return result.present();
		};

		auto initSourceCluster = [&](bool required, bool quiet = false) {
			if (!sourceClusterFile.size() && required) {
				if (!quiet) {
					fprintf(stderr, "ERROR: source cluster file is required\n");
				}
				return false;
			}

			Optional<Database> result = connectToCluster(sourceClusterFile, localities, quiet);
			if (result.present()) {
				sourceDb = result.get();
				// Make sure we are setting a transaction timeout and retry limit to prevent cases
				// where the fdbbackup command hangs infinitely. 60 seconds should be more than
				// enough for all cases to finish and 5 retries should also be good enough for
				// most cases.
				int64_t timeout = 60000;
				sourceDb->setOption(FDBDatabaseOptions::TRANSACTION_TIMEOUT,
				                    Optional<StringRef>(StringRef((const uint8_t*)&timeout, sizeof(timeout))));
				int64_t retryLimit = 5;
				sourceDb->setOption(FDBDatabaseOptions::TRANSACTION_RETRY_LIMIT,
				                    Optional<StringRef>(StringRef((const uint8_t*)&retryLimit, sizeof(retryLimit))));
			}

			return result.present();
		};

		// The fastrestore tool does not yet support multiple ranges and is incompatible with tenants
		// or other features that back up data in the system keys
		if (!restoreSystemKeys && !restoreUserKeys && backupKeys.empty() &&
		    programExe != ProgramExe::FASTRESTORE_TOOL) {
			addDefaultBackupRanges(backupKeys);
		}

		if ((restoreSystemKeys || restoreUserKeys) && programExe == ProgramExe::FASTRESTORE_TOOL) {
			fprintf(stderr, "ERROR: Options: --user-data and --system-metadata are not supported with fastrestore\n");
			return FDB_EXIT_ERROR;
		}

		if ((restoreUserKeys || restoreSystemKeys) && !backupKeys.empty()) {
			fprintf(stderr,
			        "ERROR: Cannot specify additional ranges when using --user-data or --system-metadata "
			        "options\n");
			return FDB_EXIT_ERROR;
		}
		if (restoreUserKeys) {
			backupKeys.push_back_deep(backupKeys.arena(), normalKeys);
		} else if (restoreSystemKeys) {
			for (const auto& r : getSystemBackupRanges()) {
				backupKeys.push_back_deep(backupKeys.arena(), r);
			}
		}

		switch (programExe) {
		case ProgramExe::AGENT:
			if (!initCluster())
				return FDB_EXIT_ERROR;
			fileBackupAgentProxy = proxy;
			f = stopAfter(runAgent(db));
			break;
		case ProgramExe::BACKUP:
			switch (backupType) {
			case BackupType::START: {
				if (!initCluster())
					return FDB_EXIT_ERROR;
				// Test out the backup url to make sure it parses.  Doesn't test to make sure it's actually writeable.
				openBackupContainer(argv[0], destinationContainer, proxy, encryptionKeyFile);
				f = stopAfter(submitBackup(db,
				                           destinationContainer,
				                           proxy,
				                           initialSnapshotIntervalSeconds,
				                           snapshotIntervalSeconds,
				                           backupKeys,
				                           encryptionEnabled,
				                           tagName,
				                           dryRun,
				                           waitForDone,
				                           stopWhenDone,
				                           usePartitionedLog,
				                           incrementalBackupOnly,
				                           encryptionKeyFile,
				                           blobManifestUrl));
				break;
			}

			case BackupType::MODIFY: {
				if (!initCluster())
					return FDB_EXIT_ERROR;

				f = stopAfter(modifyBackup(db, tagName, modifyOptions));
				break;
			}

			case BackupType::STATUS:
				if (!initCluster())
					return FDB_EXIT_ERROR;
				f = stopAfter(statusBackup(db, tagName, ShowErrors::True, jsonOutput));
				break;

			case BackupType::ABORT:
				if (!initCluster())
					return FDB_EXIT_ERROR;
				f = stopAfter(abortBackup(db, tagName));
				break;

			case BackupType::CLEANUP:
				if (!initCluster())
					return FDB_EXIT_ERROR;
				f = stopAfter(cleanupMutations(db, deleteData));
				break;

			case BackupType::WAIT:
				if (!initCluster())
					return FDB_EXIT_ERROR;
				f = stopAfter(waitBackup(db, tagName, stopWhenDone));
				break;

			case BackupType::DISCONTINUE:
				if (!initCluster())
					return FDB_EXIT_ERROR;
				f = stopAfter(discontinueBackup(db, tagName, waitForDone));
				break;

			case BackupType::PAUSE:
				if (!initCluster())
					return FDB_EXIT_ERROR;
				f = stopAfter(changeBackupResumed(db, true));
				break;

			case BackupType::RESUME:
				if (!initCluster())
					return FDB_EXIT_ERROR;
				f = stopAfter(changeBackupResumed(db, false));
				break;

			case BackupType::EXPIRE:
				initTraceFile();
				// Must have a usable cluster if either expire DateTime options were used
				if (!expireDatetime.empty() || !expireRestorableAfterDatetime.empty()) {
					if (!initCluster())
						return FDB_EXIT_ERROR;
				}
				f = stopAfter(expireBackupData(argv[0],
				                               destinationContainer,
				                               proxy,
				                               expireVersion,
				                               expireDatetime,
				                               db,
				                               forceAction,
				                               expireRestorableAfterVersion,
				                               expireRestorableAfterDatetime,
				                               encryptionKeyFile));
				break;

			case BackupType::DELETE_BACKUP:
				initTraceFile();
				f = stopAfter(deleteBackupContainer(argv[0], destinationContainer, proxy));
				break;

			case BackupType::DESCRIBE:
				initTraceFile();
				// If timestamp lookups are desired, require a cluster file
				if (describeTimestamps && !initCluster())
					return FDB_EXIT_ERROR;

				// Only pass database optionDatabase Describe will lookup version timestamps if a cluster file was
				// given, but quietly skip them if not.
				f = stopAfter(describeBackup(argv[0],
				                             destinationContainer,
				                             proxy,
				                             describeDeep,
				                             describeTimestamps ? Optional<Database>(db) : Optional<Database>(),
				                             jsonOutput,
				                             encryptionKeyFile));
				break;

			case BackupType::LIST:
				initTraceFile();
				f = stopAfter(listBackup(baseUrl, proxy));
				break;

			case BackupType::TAGS:
				if (!initCluster())
					return FDB_EXIT_ERROR;
				f = stopAfter(listBackupTags(db));
				break;

			case BackupType::QUERY:
				initTraceFile();
				f = stopAfter(queryBackup(argv[0],
				                          destinationContainer,
				                          proxy,
				                          backupKeysFilter,
				                          restoreVersion,
				                          snapshotVersion,
				                          restoreClusterFileOrig,
				                          restoreTimestamp,
				                          Verbose{ !quietDisplay },
				                          db));
				break;

			case BackupType::DUMP:
				initTraceFile();
				f = stopAfter(dumpBackupData(argv[0], destinationContainer, proxy, dumpBegin, dumpEnd));
				break;

			case BackupType::UNDEFINED:
			default:
				fprintf(stderr, "ERROR: Unsupported backup action %s\n", argv[1]);
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;
			}

			break;
		case ProgramExe::RESTORE:
			if (dryRun) {
				if (restoreType != RestoreType::START) {
					fprintf(stderr, "Restore dry run only works for 'start' command\n");
					return FDB_EXIT_ERROR;
				}

				// Must explicitly call trace file options handling if not calling Database::createDatabase()
				initTraceFile();
			} else {
				if (restoreClusterFileDest.empty()) {
					fprintf(stderr, "Restore destination cluster file must be specified explicitly.\n");
					return FDB_EXIT_ERROR;
				}

				if (!fileExists(restoreClusterFileDest)) {
					fprintf(stderr,
					        "Restore destination cluster file '%s' does not exist.\n",
					        restoreClusterFileDest.c_str());
					return FDB_EXIT_ERROR;
				}

				try {
					db = Database::createDatabase(restoreClusterFileDest, ApiVersion::LATEST_VERSION);
				} catch (Error& e) {
					fprintf(stderr,
					        "Restore destination cluster file '%s' invalid: %s\n",
					        restoreClusterFileDest.c_str(),
					        e.what());
					return FDB_EXIT_ERROR;
				}
			}

			switch (restoreType) {
			case RestoreType::START:
				f = stopAfter(runRestore(db,
				                         restoreClusterFileOrig,
				                         tagName,
				                         restoreContainer,
				                         proxy,
				                         backupKeys,
				                         beginVersion,
				                         restoreVersion,
				                         restoreTimestamp,
				                         !dryRun,
				                         Verbose{ !quietDisplay },
				                         waitForDone,
				                         addPrefix,
				                         removePrefix,
				                         onlyApplyMutationLogs,
				                         inconsistentSnapshotOnly,
				                         encryptionKeyFile,
				                         blobManifestUrl));

				break;
			case RestoreType::WAIT:
				f = stopAfter(success(ba.waitRestore(db, KeyRef(tagName), Verbose::True)));
				break;
			case RestoreType::ABORT:
				f = stopAfter(
				    map(ba.abortRestore(db, KeyRef(tagName)), [tagName](FileBackupAgent::ERestoreState s) -> Void {
					    printf("RESTORE_ABORT Tag: %s  State: %s\n",
					           tagName.c_str(),
					           FileBackupAgent::restoreStateText(s).toString().c_str());
					    return Void();
				    }));
				break;
			case RestoreType::STATUS:
				// If no tag is specifically provided then print all tag status, don't just use "default"
				if (tagProvided)
					tag = tagName;
				f = stopAfter(map(ba.restoreStatus(db, KeyRef(tag)), [](std::string s) -> Void {
					printf("%s\n", s.c_str());
					return Void();
				}));
				break;
			default:
				throw restore_error();
			}
			break;
		case ProgramExe::FASTRESTORE_TOOL:
			// Support --dest-cluster-file option as fdbrestore does
			if (dryRun) {
				if (restoreType != RestoreType::START) {
					fprintf(stderr, "Restore dry run only works for 'start' command\n");
					return FDB_EXIT_ERROR;
				}

				// Must explicitly call trace file options handling if not calling Database::createDatabase()
				initTraceFile();
			} else {
				if (restoreClusterFileDest.empty()) {
					fprintf(stderr, "Restore destination cluster file must be specified explicitly.\n");
					return FDB_EXIT_ERROR;
				}

				if (!fileExists(restoreClusterFileDest)) {
					fprintf(stderr,
					        "Restore destination cluster file '%s' does not exist.\n",
					        restoreClusterFileDest.c_str());
					return FDB_EXIT_ERROR;
				}

				try {
					db = Database::createDatabase(restoreClusterFileDest, ApiVersion::LATEST_VERSION);
				} catch (Error& e) {
					fprintf(stderr,
					        "Restore destination cluster file '%s' invalid: %s\n",
					        restoreClusterFileDest.c_str(),
					        e.what());
					return FDB_EXIT_ERROR;
				}
			}
			// TODO: We have not implemented the code commented out in this case
			switch (restoreType) {
			case RestoreType::START:
				f = stopAfter(runFastRestoreTool(db,
				                                 tagName,
				                                 restoreContainer,
				                                 proxy,
				                                 backupKeys,
				                                 restoreVersion,
				                                 !dryRun,
				                                 Verbose{ !quietDisplay },
				                                 waitForDone));
				break;
			case RestoreType::WAIT:
				printf("[TODO][ERROR] FastRestore does not support RESTORE_WAIT yet!\n");
				throw restore_error();
				//					f = stopAfter( success(ba.waitRestore(db, KeyRef(tagName), true)) );
				break;
			case RestoreType::ABORT:
				printf("[TODO][ERROR] FastRestore does not support RESTORE_ABORT yet!\n");
				throw restore_error();
				//					f = stopAfter( map(ba.abortRestore(db, KeyRef(tagName)),
				//[tagName](FileBackupAgent::ERestoreState s) -> Void { 						printf("Tag: %s  State:
				//%s\n", tagName.c_str(),
				// FileBackupAgent::restoreStateText(s).toString().c_str()); 						return Void();
				//					}) );
				break;
			case RestoreType::STATUS:
				printf("[TODO][ERROR] FastRestore does not support RESTORE_STATUS yet!\n");
				throw restore_error();
				// If no tag is specifically provided then print all tag status, don't just use "default"
				if (tagProvided)
					tag = tagName;
				//					f = stopAfter( map(ba.restoreStatus(db, KeyRef(tag)), [](std::string s) -> Void {
				//						printf("%s\n", s.c_str());
				//						return Void();
				//					}) );
				break;
			default:
				throw restore_error();
			}
			break;
		case ProgramExe::DR_AGENT:
			if (!initCluster() || !initSourceCluster(true)) {
				return FDB_EXIT_ERROR;
			}
			f = stopAfter(runDBAgent(sourceDb, db));
			break;
		case ProgramExe::DB_BACKUP:
			if (!initCluster() || !initSourceCluster(dbType != DBType::ABORT || !dstOnly)) {
				return FDB_EXIT_ERROR;
			}
			switch (dbType) {
			case DBType::START:
				f = stopAfter(submitDBBackup(sourceDb, db, backupKeys, tagName));
				break;
			case DBType::STATUS:
				f = stopAfter(statusDBBackup(sourceDb, db, tagName, maxErrors));
				break;
			case DBType::SWITCH:
				f = stopAfter(switchDBBackup(sourceDb, db, backupKeys, tagName, forceAction));
				break;
			case DBType::ABORT:
				f = stopAfter(abortDBBackup(sourceDb, db, tagName, partial, dstOnly));
				break;
			case DBType::PAUSE:
				f = stopAfter(changeDBBackupResumed(sourceDb, db, true));
				break;
			case DBType::RESUME:
				f = stopAfter(changeDBBackupResumed(sourceDb, db, false));
				break;
			case DBType::UNDEFINED:
			default:
				fprintf(stderr, "ERROR: Unsupported DR action %s\n", argv[1]);
				printHelpTeaser(argv[0]);
				return FDB_EXIT_ERROR;
				break;
			}
			break;
		case ProgramExe::UNDEFINED:
		default:
			return FDB_EXIT_ERROR;
		}

		runNetwork();

		if (f.isValid() && f.isReady() && !f.isError() && !f.get().present()) {
			status = FDB_EXIT_ERROR;
		}

		if (fstatus.isValid() && fstatus.isReady() && !fstatus.isError() && fstatus.get().present()) {
			status = fstatus.get().get();
		}

#ifdef ALLOC_INSTRUMENTATION
		{
			std::cout << "Page Counts: " << FastAllocator<16>::pageCount << " " << FastAllocator<32>::pageCount << " "
			          << FastAllocator<64>::pageCount << " " << FastAllocator<128>::pageCount << " "
			          << FastAllocator<256>::pageCount << " " << FastAllocator<512>::pageCount << " "
			          << FastAllocator<1024>::pageCount << " " << FastAllocator<2048>::pageCount << " "
			          << FastAllocator<4096>::pageCount << " " << FastAllocator<8192>::pageCount << " "
			          << FastAllocator<16384>::pageCount << std::endl;

			std::vector<std::pair<std::string, const char*>> typeNames;
			for (auto i = allocInstr.begin(); i != allocInstr.end(); ++i) {
				std::string s;

#ifdef __linux__
				char* demangled = abi::__cxa_demangle(i->first, NULL, NULL, NULL);
				if (demangled) {
					s = demangled;
					if (StringRef(s).startsWith("(anonymous namespace)::"_sr))
						s = s.substr("(anonymous namespace)::"_sr.size());
					free(demangled);
				} else
					s = i->first;
#else
				s = i->first;
				if (StringRef(s).startsWith("class `anonymous namespace'::"_sr))
					s = s.substr("class `anonymous namespace'::"_sr.size());
				else if (StringRef(s).startsWith("class "_sr))
					s = s.substr("class "_sr.size());
				else if (StringRef(s).startsWith("struct "_sr))
					s = s.substr("struct "_sr.size());
#endif

				typeNames.emplace_back(s, i->first);
			}
			std::sort(typeNames.begin(), typeNames.end());
			for (int i = 0; i < typeNames.size(); i++) {
				const char* n = typeNames[i].second;
				auto& f = allocInstr[n];
				printf("%+d\t%+d\t%d\t%d\t%s\n",
				       f.allocCount,
				       -f.deallocCount,
				       f.allocCount - f.deallocCount,
				       f.maxAllocated,
				       typeNames[i].first.c_str());
			}

			// We're about to exit and clean up data structures, this will wreak havoc on allocation recording
			memSample_entered = true;
		}
#endif
	} catch (Error& e) {
		TraceEvent(SevError, "MainError").error(e);
		status = FDB_EXIT_MAIN_ERROR;
	} catch (boost::system::system_error& e) {
		if (g_network) {
			TraceEvent(SevError, "MainError").error(unknown_error()).detail("RootException", e.what());
		} else {
			fprintf(stderr, "ERROR: %s (%d)\n", e.what(), e.code().value());
		}
		status = FDB_EXIT_MAIN_EXCEPTION;
	} catch (std::exception& e) {
		TraceEvent(SevError, "MainError").error(unknown_error()).detail("RootException", e.what());
		status = FDB_EXIT_MAIN_EXCEPTION;
	}

	flushAndExit(status);
}
