/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.DatabaseOptions;
import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.FDBTenant;
import com.apple.foundationdb.FDBTransaction;
import com.apple.foundationdb.FutureBool;
import com.apple.foundationdb.FutureInt64;
import com.apple.foundationdb.FutureKey;
import com.apple.foundationdb.FutureKeyRangeArray;
import com.apple.foundationdb.FutureVoid;
import com.apple.foundationdb.KeyRangeArrayResult;
import com.apple.foundationdb.NativeObjectWrapper;
import com.apple.foundationdb.OptionConsumer;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Tenant;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

class FDBDatabase
extends NativeObjectWrapper
implements Database,
OptionConsumer {
    private DatabaseOptions options;
    private final Executor executor;
    private final EventKeeper eventKeeper;

    protected FDBDatabase(long l, Executor executor) {
        this(l, executor, null);
    }

    protected FDBDatabase(long l, Executor executor, EventKeeper eventKeeper) {
        super(l);
        this.executor = executor;
        this.options = new DatabaseOptions(this);
        if (FDB.instance().getAPIVersion() >= 730) {
            this.options.setTransactionUsedDuringCommitProtectionDisable();
        }
        this.eventKeeper = eventKeeper;
    }

    @Override
    public DatabaseOptions options() {
        return this.options;
    }

    @Override
    public <T> T run(Function<? super Transaction, T> function, Executor executor) {
        Transaction transaction = this.createTransaction(executor);
        while (true) {
            try {
                T t = function.apply(transaction);
                transaction.commit().join();
                T t2 = t;
                return t2;
            }
            catch (RuntimeException runtimeException) {
                transaction = transaction.onError(runtimeException).join();
                continue;
            }
            break;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public <T> T read(Function<? super ReadTransaction, T> function, Executor executor) {
        return this.run(function, executor);
    }

    @Override
    public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> function, Executor executor) {
        AtomicReference<Transaction> atomicReference = new AtomicReference<Transaction>(this.createTransaction(executor));
        AtomicReference atomicReference2 = new AtomicReference();
        return ((CompletableFuture)AsyncUtil.whileTrue(() -> {
            CompletableFuture completableFuture = AsyncUtil.applySafely(function, atomicReference.get());
            return AsyncUtil.composeHandleAsync(completableFuture.thenComposeAsync(object -> ((Transaction)atomicReference.get()).commit().thenApply(void_ -> {
                atomicReference2.set(object);
                return false;
            }), executor), (bl, throwable) -> {
                if (throwable == null) {
                    return CompletableFuture.completedFuture(bl);
                }
                if (!(throwable instanceof RuntimeException)) {
                    throw new CompletionException((Throwable)throwable);
                }
                return ((Transaction)atomicReference.get()).onError((Throwable)throwable).thenApply(transaction -> {
                    atomicReference.set((Transaction)transaction);
                    return true;
                });
            }, executor);
        }, executor).thenApply(void_ -> atomicReference2.get())).whenComplete((object, throwable) -> ((Transaction)atomicReference.get()).close());
    }

    @Override
    public <T> CompletableFuture<T> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<T>> function, Executor executor) {
        return this.runAsync(function, executor);
    }

    protected void finalize() throws Throwable {
        try {
            this.checkUnclosed("Database");
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Tenant openTenant(byte[] byArray, Executor executor) {
        return this.openTenant(byArray, executor, this.eventKeeper);
    }

    @Override
    public Tenant openTenant(Tuple tuple) {
        return this.openTenant(tuple.pack());
    }

    @Override
    public Tenant openTenant(Tuple tuple, Executor executor) {
        return this.openTenant(tuple.pack(), executor);
    }

    @Override
    public Tenant openTenant(byte[] byArray, Executor executor, EventKeeper eventKeeper) {
        this.pointerReadLock.lock();
        Tenant tenant = null;
        try {
            Tenant tenant2 = tenant = new FDBTenant(this.Database_openTenant(this.getPtr(), byArray), this, byArray, executor, eventKeeper);
            return tenant2;
        }
        catch (RuntimeException runtimeException) {
            if (tenant != null) {
                tenant.close();
            }
            throw runtimeException;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public Tenant openTenant(Tuple tuple, Executor executor, EventKeeper eventKeeper) {
        return this.openTenant(tuple.pack(), executor, eventKeeper);
    }

    @Override
    public Transaction createTransaction(Executor executor) {
        return this.createTransaction(executor, this.eventKeeper);
    }

    @Override
    public Transaction createTransaction(Executor executor, EventKeeper eventKeeper) {
        this.pointerReadLock.lock();
        Transaction transaction = null;
        try {
            transaction = new FDBTransaction(this.Database_createTransaction(this.getPtr()), this, executor, eventKeeper);
            if (FDB.instance().getAPIVersion() < 730) {
                transaction.options().setUsedDuringCommitProtectionDisable();
            }
            Transaction transaction2 = transaction;
            return transaction2;
        }
        catch (RuntimeException runtimeException) {
            if (transaction != null) {
                transaction.close();
            }
            throw runtimeException;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public void setOption(int n, byte[] byArray) {
        this.pointerReadLock.lock();
        try {
            this.Database_setOption(this.getPtr(), n, byArray);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public double getMainThreadBusyness() {
        this.pointerReadLock.lock();
        try {
            double d = this.Database_getMainThreadBusyness(this.getPtr());
            return d;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<byte[]> purgeBlobGranules(byte[] byArray, byte[] byArray2, long l, boolean bl, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureKey futureKey = new FutureKey(this.Database_purgeBlobGranules(this.getPtr(), byArray, byArray2, l, bl), executor, this.eventKeeper);
            return futureKey;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> waitPurgeGranulesComplete(byte[] byArray, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureVoid futureVoid = new FutureVoid(this.Database_waitPurgeGranulesComplete(this.getPtr(), byArray), executor);
            return futureVoid;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> blobbifyRange(byte[] byArray, byte[] byArray2, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureBool futureBool = new FutureBool(this.Database_blobbifyRange(this.getPtr(), byArray, byArray2), executor);
            return futureBool;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> blobbifyRangeBlocking(byte[] byArray, byte[] byArray2, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureBool futureBool = new FutureBool(this.Database_blobbifyRangeBlocking(this.getPtr(), byArray, byArray2), executor);
            return futureBool;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> unblobbifyRange(byte[] byArray, byte[] byArray2, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureBool futureBool = new FutureBool(this.Database_unblobbifyRange(this.getPtr(), byArray, byArray2), executor);
            return futureBool;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<KeyRangeArrayResult> listBlobbifiedRanges(byte[] byArray, byte[] byArray2, int n, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureKeyRangeArray futureKeyRangeArray = new FutureKeyRangeArray(this.Database_listBlobbifiedRanges(this.getPtr(), byArray, byArray2, n), executor);
            return futureKeyRangeArray;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Long> verifyBlobRange(byte[] byArray, byte[] byArray2, long l, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureInt64 futureInt64 = new FutureInt64(this.Database_verifyBlobRange(this.getPtr(), byArray, byArray2, l), executor);
            return futureInt64;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> flushBlobRange(byte[] byArray, byte[] byArray2, boolean bl, long l, Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureBool futureBool = new FutureBool(this.Database_flushBlobRange(this.getPtr(), byArray, byArray2, bl, l), executor);
            return futureBool;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    protected void closeInternal(long l) {
        this.Database_dispose(l);
    }

    @Override
    public CompletableFuture<byte[]> getClientStatus(Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureKey futureKey = new FutureKey(this.Database_getClientStatus(this.getPtr()), executor, this.eventKeeper);
            return futureKey;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    private native long Database_openTenant(long var1, byte[] var3);

    private native long Database_createTransaction(long var1);

    private native void Database_dispose(long var1);

    private native void Database_setOption(long var1, int var3, byte[] var4) throws FDBException;

    private native double Database_getMainThreadBusyness(long var1);

    private native long Database_purgeBlobGranules(long var1, byte[] var3, byte[] var4, long var5, boolean var7);

    private native long Database_waitPurgeGranulesComplete(long var1, byte[] var3);

    private native long Database_blobbifyRange(long var1, byte[] var3, byte[] var4);

    private native long Database_blobbifyRangeBlocking(long var1, byte[] var3, byte[] var4);

    private native long Database_unblobbifyRange(long var1, byte[] var3, byte[] var4);

    private native long Database_listBlobbifiedRanges(long var1, byte[] var3, byte[] var4, int var5);

    private native long Database_verifyBlobRange(long var1, byte[] var3, byte[] var4, long var5);

    private native long Database_flushBlobRange(long var1, byte[] var3, byte[] var4, boolean var5, long var6);

    private native long Database_getClientStatus(long var1);
}

