#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
/*
 * RestoreMultiRanges.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct RestoreMultiRangesWorkload : TestWorkload {

	FileBackupAgent backupAgent;
	Reference<IBackupContainer> backupContainer;
	Optional<std::string> encryptionKeyFileName;

	RestoreMultiRangesWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		if (getOption(options, "encrypted"_sr, deterministicRandom()->random01() < 0.5)) {
			encryptionKeyFileName = "simfdb/" + getTestEncryptionFileName();
		}
	}

	static constexpr const char* NAME = "RestoreMultiRanges";

																#line 46 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
// This generated class is to be used only via clearDatabase()
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
template <class ClearDatabaseActor>
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
class ClearDatabaseActorState {
															#line 52 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
public:
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	ClearDatabaseActorState(Database const& cx) 
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		 : cx(cx),
															#line 45 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		   tr(cx)
															#line 61 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	~ClearDatabaseActorState() 
	{
		fdb_probe_actor_destroy("clearDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 46 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			;
															#line 76 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 48 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.clear(normalKeys);
															#line 49 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 49 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 1;
															#line 49 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 0, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 116 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 52 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 52 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 140 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearDatabaseActor, 1, Void >*>(static_cast<ClearDatabaseActor*>(this)));
															#line 145 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 50 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (!static_cast<ClearDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDatabaseActorState(); static_cast<ClearDatabaseActor*>(this)->destroy(); return 0; }
															#line 160 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		new (&static_cast<ClearDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 50 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (!static_cast<ClearDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearDatabaseActorState(); static_cast<ClearDatabaseActor*>(this)->destroy(); return 0; }
															#line 172 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		new (&static_cast<ClearDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearDatabaseActorState();
		static_cast<ClearDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearDatabaseActor*>(this)->actor_wait_state > 0) static_cast<ClearDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<ClearDatabaseActor*>(this)->ActorCallback< ClearDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Database cx;
															#line 45 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Transaction tr;
															#line 346 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearDatabase()
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
class ClearDatabaseActor final : public Actor<Void>, public ActorCallback< ClearDatabaseActor, 0, Void >, public ActorCallback< ClearDatabaseActor, 1, Void >, public FastAllocated<ClearDatabaseActor>, public ClearDatabaseActorState<ClearDatabaseActor> {
															#line 351 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearDatabaseActor>::operator new;
	using FastAllocated<ClearDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17292824227862071040UL, 12115098782408240384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearDatabaseActor, 0, Void >;
friend struct ActorCallback< ClearDatabaseActor, 1, Void >;
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	ClearDatabaseActor(Database const& cx) 
															#line 369 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearDatabaseActorState<ClearDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2535882093937434112UL, 5291521835449874944UL);
		ActorExecutionContextHelper __helper(static_cast<ClearDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
[[nodiscard]] static Future<Void> clearDatabase( Database const& cx ) {
															#line 44 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	return Future<Void>(new ClearDatabaseActor(cx));
															#line 402 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
}

#line 56 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"

																#line 407 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
// This generated class is to be used only via prepareDatabase()
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
template <class PrepareDatabaseActor>
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
class PrepareDatabaseActorState {
															#line 413 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
public:
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	PrepareDatabaseActorState(Database const& cx) 
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		 : cx(cx),
															#line 58 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		   tr(cx)
															#line 422 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("prepareDatabase", reinterpret_cast<unsigned long>(this));

	}
	~PrepareDatabaseActorState() 
	{
		fdb_probe_actor_destroy("prepareDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			;
															#line 437 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrepareDatabaseActorState();
		static_cast<PrepareDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 61 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.reset();
															#line 62 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.set("a"_sr, "a"_sr);
															#line 63 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.set("aaaa"_sr, "aaaa"_sr);
															#line 64 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.set("b"_sr, "b"_sr);
															#line 65 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.set("bb"_sr, "bb"_sr);
															#line 66 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.set("bbb"_sr, "bbb"_sr);
															#line 67 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 67 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<PrepareDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 482 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrepareDatabaseActor*>(this)->actor_wait_state = 1;
															#line 67 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrepareDatabaseActor, 0, Void >*>(static_cast<PrepareDatabaseActor*>(this)));
															#line 487 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 70 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<PrepareDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 511 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PrepareDatabaseActor*>(this)->actor_wait_state = 2;
															#line 70 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrepareDatabaseActor, 1, Void >*>(static_cast<PrepareDatabaseActor*>(this)));
															#line 516 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (!static_cast<PrepareDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrepareDatabaseActorState(); static_cast<PrepareDatabaseActor*>(this)->destroy(); return 0; }
															#line 531 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		new (&static_cast<PrepareDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrepareDatabaseActorState();
		static_cast<PrepareDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 68 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (!static_cast<PrepareDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrepareDatabaseActorState(); static_cast<PrepareDatabaseActor*>(this)->destroy(); return 0; }
															#line 543 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		new (&static_cast<PrepareDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrepareDatabaseActorState();
		static_cast<PrepareDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrepareDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PrepareDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PrepareDatabaseActor*>(this)->ActorCallback< PrepareDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrepareDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("prepareDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrepareDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("prepareDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrepareDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("prepareDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrepareDatabaseActor*>(this)->actor_wait_state > 0) static_cast<PrepareDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<PrepareDatabaseActor*>(this)->ActorCallback< PrepareDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrepareDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("prepareDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrepareDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("prepareDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrepareDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("prepareDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("prepareDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Database cx;
															#line 58 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Transaction tr;
															#line 717 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
};
// This generated class is to be used only via prepareDatabase()
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
class PrepareDatabaseActor final : public Actor<Void>, public ActorCallback< PrepareDatabaseActor, 0, Void >, public ActorCallback< PrepareDatabaseActor, 1, Void >, public FastAllocated<PrepareDatabaseActor>, public PrepareDatabaseActorState<PrepareDatabaseActor> {
															#line 722 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
public:
	using FastAllocated<PrepareDatabaseActor>::operator new;
	using FastAllocated<PrepareDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9380058621187992832UL, 10849291452206488576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrepareDatabaseActor, 0, Void >;
friend struct ActorCallback< PrepareDatabaseActor, 1, Void >;
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	PrepareDatabaseActor(Database const& cx) 
															#line 740 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PrepareDatabaseActorState<PrepareDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("prepareDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7665125942555443456UL, 4251802118512433408UL);
		ActorExecutionContextHelper __helper(static_cast<PrepareDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("prepareDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("prepareDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrepareDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrepareDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
[[nodiscard]] static Future<Void> prepareDatabase( Database const& cx ) {
															#line 57 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	return Future<Void>(new PrepareDatabaseActor(cx));
															#line 773 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
}

#line 74 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"

	static void logTestData(const VectorRef<KeyValueRef>& data) {
		TraceEvent("TestFailureDetail").log();
		int index = 0;
		for (auto& entry : data) {
			TraceEvent("CurrentDataEntry")
			    .detail("Index", index)
			    .detail("Key", entry.key.toString())
			    .detail("Value", entry.value.toString());
			index++;
		}
	}

																#line 790 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
// This generated class is to be used only via verifyDatabase()
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
template <class VerifyDatabaseActor>
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
class VerifyDatabaseActorState {
															#line 796 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
public:
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	VerifyDatabaseActorState(Database const& cx) 
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		 : cx(cx),
															#line 88 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 805 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("verifyDatabase", reinterpret_cast<unsigned long>(this));

	}
	~VerifyDatabaseActorState() 
	{
		fdb_probe_actor_destroy("verifyDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 89 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			TraceEvent("RestoreMultiRanges_Verify").detail("UID", randomID);
															#line 90 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr = Transaction(cx);
															#line 91 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			range = KeyRangeRef("a"_sr, "z"_sr);
															#line 92 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			;
															#line 826 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyDatabaseActorState();
		static_cast<VerifyDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 94 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.reset();
															#line 95 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			tr.debugTransaction(randomID);
															#line 96 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(range, 10);
															#line 96 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<VerifyDatabaseActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 863 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VerifyDatabaseActor*>(this)->actor_wait_state = 1;
															#line 96 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyDatabaseActor, 0, RangeResult >*>(static_cast<VerifyDatabaseActor*>(this)));
															#line 868 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 118 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<VerifyDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 892 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<VerifyDatabaseActor*>(this)->actor_wait_state = 2;
															#line 118 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyDatabaseActor, 1, Void >*>(static_cast<VerifyDatabaseActor*>(this)));
															#line 897 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& kvs,int loopDepth) 
	{
															#line 97 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (kvs.size() != 4)
															#line 912 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		{
															#line 98 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			logTestData(kvs);
															#line 99 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			TraceEvent(SevError, "TestFailureInfo") .detail("DataSize", kvs.size()) .detail("Expect", 4) .detail("Workload", NAME);
															#line 103 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (!static_cast<VerifyDatabaseActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyDatabaseActorState(); static_cast<VerifyDatabaseActor*>(this)->destroy(); return 0; }
															#line 920 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			new (&static_cast<VerifyDatabaseActor*>(this)->SAV< bool >::value()) bool(false);
			this->~VerifyDatabaseActorState();
			static_cast<VerifyDatabaseActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 105 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		KeyRef keys[4] = { "a"_sr, "aaaa"_sr, "bb"_sr, "bbb"_sr };
															#line 106 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		for(size_t i = 0;i < 4;++i) {
															#line 107 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (kvs[i].key != keys[i])
															#line 932 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			{
															#line 108 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
				TraceEvent(SevError, "TestFailureInfo") .detail("ExpectKey", keys[i]) .detail("Got", kvs[i].key) .detail("Index", i);
															#line 112 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
				if (!static_cast<VerifyDatabaseActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyDatabaseActorState(); static_cast<VerifyDatabaseActor*>(this)->destroy(); return 0; }
															#line 938 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
				new (&static_cast<VerifyDatabaseActor*>(this)->SAV< bool >::value()) bool(false);
				this->~VerifyDatabaseActorState();
				static_cast<VerifyDatabaseActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 115 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_VerifyPassed");
															#line 116 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (!static_cast<VerifyDatabaseActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VerifyDatabaseActorState(); static_cast<VerifyDatabaseActor*>(this)->destroy(); return 0; }
															#line 949 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		new (&static_cast<VerifyDatabaseActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VerifyDatabaseActorState();
		static_cast<VerifyDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && kvs,int loopDepth) 
	{
															#line 97 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (kvs.size() != 4)
															#line 961 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		{
															#line 98 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			logTestData(kvs);
															#line 99 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			TraceEvent(SevError, "TestFailureInfo") .detail("DataSize", kvs.size()) .detail("Expect", 4) .detail("Workload", NAME);
															#line 103 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (!static_cast<VerifyDatabaseActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyDatabaseActorState(); static_cast<VerifyDatabaseActor*>(this)->destroy(); return 0; }
															#line 969 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			new (&static_cast<VerifyDatabaseActor*>(this)->SAV< bool >::value()) bool(false);
			this->~VerifyDatabaseActorState();
			static_cast<VerifyDatabaseActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 105 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		KeyRef keys[4] = { "a"_sr, "aaaa"_sr, "bb"_sr, "bbb"_sr };
															#line 106 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		for(size_t i = 0;i < 4;++i) {
															#line 107 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (kvs[i].key != keys[i])
															#line 981 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			{
															#line 108 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
				TraceEvent(SevError, "TestFailureInfo") .detail("ExpectKey", keys[i]) .detail("Got", kvs[i].key) .detail("Index", i);
															#line 112 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
				if (!static_cast<VerifyDatabaseActor*>(this)->SAV<bool>::futures) { (void)(false); this->~VerifyDatabaseActorState(); static_cast<VerifyDatabaseActor*>(this)->destroy(); return 0; }
															#line 987 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
				new (&static_cast<VerifyDatabaseActor*>(this)->SAV< bool >::value()) bool(false);
				this->~VerifyDatabaseActorState();
				static_cast<VerifyDatabaseActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 115 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_VerifyPassed");
															#line 116 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (!static_cast<VerifyDatabaseActor*>(this)->SAV<bool>::futures) { (void)(true); this->~VerifyDatabaseActorState(); static_cast<VerifyDatabaseActor*>(this)->destroy(); return 0; }
															#line 998 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		new (&static_cast<VerifyDatabaseActor*>(this)->SAV< bool >::value()) bool(true);
		this->~VerifyDatabaseActorState();
		static_cast<VerifyDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& kvs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(kvs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && kvs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(kvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyDatabaseActor*>(this)->actor_wait_state > 0) static_cast<VerifyDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyDatabaseActor*>(this)->ActorCallback< VerifyDatabaseActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyDatabaseActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("verifyDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyDatabaseActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("verifyDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyDatabaseActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("verifyDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyDatabaseActor*>(this)->actor_wait_state > 0) static_cast<VerifyDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyDatabaseActor*>(this)->ActorCallback< VerifyDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Database cx;
															#line 88 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	UID randomID;
															#line 90 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Transaction tr;
															#line 91 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	KeyRangeRef range;
															#line 1176 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
};
// This generated class is to be used only via verifyDatabase()
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
class VerifyDatabaseActor final : public Actor<bool>, public ActorCallback< VerifyDatabaseActor, 0, RangeResult >, public ActorCallback< VerifyDatabaseActor, 1, Void >, public FastAllocated<VerifyDatabaseActor>, public VerifyDatabaseActorState<VerifyDatabaseActor> {
															#line 1181 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
public:
	using FastAllocated<VerifyDatabaseActor>::operator new;
	using FastAllocated<VerifyDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(509892058487908096UL, 3054868073454510336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyDatabaseActor, 0, RangeResult >;
friend struct ActorCallback< VerifyDatabaseActor, 1, Void >;
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	VerifyDatabaseActor(Database const& cx) 
															#line 1199 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   VerifyDatabaseActorState<VerifyDatabaseActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3839563989924118016UL, 7212794594607412992UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyDatabaseActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
[[nodiscard]] static Future<bool> verifyDatabase( Database const& cx ) {
															#line 87 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	return Future<bool>(new VerifyDatabaseActor(cx));
															#line 1232 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
}

#line 122 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"

																#line 1237 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
template <class _startActor>
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
class _startActorState {
															#line 1243 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
public:
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	_startActorState(RestoreMultiRangesWorkload* const& self,Database const& cx) 
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		 : self(self),
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		   cx(cx)
															#line 1252 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			TraceEvent("RestoreMultiRanges_StartBackup");
															#line 125 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_0 = clearDatabase(cx);
															#line 125 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1271 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 125 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1276 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		StrictFuture<Void> __when_expr_1 = prepareDatabase(cx);
															#line 126 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1301 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 126 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1306 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		StrictFuture<Void> __when_expr_1 = prepareDatabase(cx);
															#line 126 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1317 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 126 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1322 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (self->encryptionKeyFileName.present())
															#line 1406 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		{
															#line 129 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_2 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 129 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1412 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 129 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1417 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (self->encryptionKeyFileName.present())
															#line 1431 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		{
															#line 129 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_2 = BackupContainerFileSystem::createTestEncryptionKeyFile(self->encryptionKeyFileName.get());
															#line 129 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1437 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 129 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1442 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 132 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		backupContainer = "file://simfdb/backups/";
															#line 133 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		tagName = "default";
															#line 134 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		backupRanges = Standalone<VectorRef<KeyRangeRef>>();
															#line 135 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef("a"_sr, "z"_sr));
															#line 136 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_SubmitBackup");
															#line 1539 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		try {
															#line 138 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			StrictFuture<Void> __when_expr_3 = self->backupAgent.submitBackup(cx, StringRef(backupContainer), {}, deterministicRandom()->randomInt(0, 60), deterministicRandom()->randomInt(0, 100), tagName, backupRanges, true, StopWhenDone::True, UsePartitionedLog::False, IncrementalBackupOnly::False, self->encryptionKeyFileName);
															#line 138 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont3Catch1(actor_cancelled(), loopDepth);
															#line 1545 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont3Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 138 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1550 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 155 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_WaitBackup");
															#line 156 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		container = Reference<IBackupContainer>();
															#line 157 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		StrictFuture<Void> __when_expr_4 = success(self->backupAgent.waitBackup(cx, tagName, StopWhenDone::True, &container));
															#line 157 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1658 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 157 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1663 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 151 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 1673 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			{
															#line 152 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1677 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_ClearDatabase");
															#line 160 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		StrictFuture<Void> __when_expr_5 = clearDatabase(cx);
															#line 160 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1797 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 160 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1802 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_ClearDatabase");
															#line 160 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		StrictFuture<Void> __when_expr_5 = clearDatabase(cx);
															#line 160 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1815 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 160 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1820 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_Restore");
															#line 163 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		ranges = Standalone<VectorRef<KeyRangeRef>>();
															#line 164 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		ranges.push_back_deep(ranges.arena(), KeyRangeRef("a"_sr, "aaaaa"_sr));
															#line 165 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		ranges.push_back_deep(ranges.arena(), KeyRangeRef("bb"_sr, "bbbbb"_sr));
															#line 166 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(self->backupAgent.restore(cx, cx, Key(tagName), Key(container->getURL()), {}, ranges, WaitForComplete::True, ::invalidVersion, Verbose::True, Key(), Key(), LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, self->encryptionKeyFileName));
															#line 166 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1914 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 166 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1919 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_Restore");
															#line 163 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		ranges = Standalone<VectorRef<KeyRangeRef>>();
															#line 164 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		ranges.push_back_deep(ranges.arena(), KeyRangeRef("a"_sr, "aaaaa"_sr));
															#line 165 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		ranges.push_back_deep(ranges.arena(), KeyRangeRef("bb"_sr, "bbbbb"_sr));
															#line 166 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		StrictFuture<Void> __when_expr_6 = success(self->backupAgent.restore(cx, cx, Key(tagName), Key(container->getURL()), {}, ranges, WaitForComplete::True, ::invalidVersion, Verbose::True, Key(), Key(), LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, ::invalidVersion, self->encryptionKeyFileName));
															#line 166 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1938 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 166 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 1943 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_Success");
															#line 184 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2029 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 183 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		TraceEvent("RestoreMultiRanges_Success");
															#line 184 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2043 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	RestoreMultiRangesWorkload* self;
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Database cx;
															#line 132 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	std::string backupContainer;
															#line 133 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	std::string tagName;
															#line 134 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 156 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Reference<IBackupContainer> container;
															#line 163 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 2140 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2145 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11709154179848826368UL, 6007932047786078976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	_startActor(RestoreMultiRangesWorkload* const& self,Database const& cx) 
															#line 2168 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
[[nodiscard]] static Future<Void> _start( RestoreMultiRangesWorkload* const& self, Database const& cx ) {
															#line 123 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 2206 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/RestoreMultiRanges.actor.g.cpp.py_gen"
}

#line 186 "/codebuild/output/src948217385/src/github.com/apple/foundationdb/fdbserver/workloads/RestoreMultiRanges.actor.cpp"

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override { return clientId ? Void() : _start(this, cx); }
	Future<bool> check(Database const& cx) override { return verifyDatabase(cx); }
	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<RestoreMultiRangesWorkload> RestoreMultiRangesWorkloadFactory;
