#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
/*
 * RemoteIKeyValueStore.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_REMOTE_IKEYVALUESTORE_ACTOR_G_H)
#define FDBSERVER_REMOTE_IKEYVALUESTORE_ACTOR_G_H
#include "fdbserver/RemoteIKeyValueStore.actor.g.h"
#elif !defined(FDBSERVER_REMOTE_IKEYVALUESTORE_ACTOR_H)
#define FDBSERVER_REMOTE_IKEYVALUESTORE_ACTOR_H

#include "flow/ActorCollection.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/network.h"
#include "fdbrpc/FlowProcess.actor.h"
#include "fdbrpc/FlowTransport.h"
#include "fdbrpc/fdbrpc.h"
#include "fdbclient/FDBTypes.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/Knobs.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct IKVSCommitReply {
	constexpr static FileIdentifier file_identifier = 3958189;
	StorageBytes storeBytes;

	IKVSCommitReply() : storeBytes(0, 0, 0, 0) {}
	IKVSCommitReply(const StorageBytes& sb) : storeBytes(sb) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, storeBytes);
	}
};

struct RemoteKVSProcessInterface {

	constexpr static FileIdentifier file_identifier = 3491838;
	RequestStream<struct GetRemoteKVSProcessInterfaceRequest> getProcessInterface;
	RequestStream<struct OpenKVStoreRequest> openKVStore;

	UID uniqueID = deterministicRandom()->randomUniqueID();

	UID id() const { return uniqueID; }

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, getProcessInterface, openKVStore);
	}
};

struct IKVSInterface {
	constexpr static FileIdentifier file_identifier = 4929113;
	RequestStream<struct IKVSGetValueRequest> getValue;
	RequestStream<struct IKVSSetRequest> set;
	RequestStream<struct IKVSClearRequest> clear;
	RequestStream<struct IKVSCommitRequest> commit;
	RequestStream<struct IKVSReadValuePrefixRequest> readValuePrefix;
	RequestStream<struct IKVSReadRangeRequest> readRange;
	RequestStream<struct IKVSGetStorageByteRequest> getStorageBytes;
	RequestStream<struct IKVSGetErrorRequest> getError;
	RequestStream<struct IKVSOnClosedRequest> onClosed;
	RequestStream<struct IKVSDisposeRequest> dispose;
	RequestStream<struct IKVSCloseRequest> close;

	UID uniqueID;

	UID id() const { return uniqueID; }

	KeyValueStoreType storeType;

	KeyValueStoreType type() const { return storeType; }

	IKVSInterface() {}

	IKVSInterface(KeyValueStoreType type) : uniqueID(deterministicRandom()->randomUniqueID()), storeType(type) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar,
		           getValue,
		           set,
		           clear,
		           commit,
		           readValuePrefix,
		           readRange,
		           getStorageBytes,
		           getError,
		           onClosed,
		           dispose,
		           close,
		           uniqueID);
	}
};

struct GetRemoteKVSProcessInterfaceRequest {
	constexpr static FileIdentifier file_identifier = 8382983;
	ReplyPromise<struct RemoteKVSProcessInterface> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct OpenKVStoreRequest {
	constexpr static FileIdentifier file_identifier = 5918682;
	KeyValueStoreType storeType;
	std::string filename;
	UID logID;
	int64_t memoryLimit;
	bool checkChecksums;
	bool checkIntegrity;
	ReplyPromise<struct IKVSInterface> reply;

	OpenKVStoreRequest() {};

	OpenKVStoreRequest(KeyValueStoreType storeType,
	                   std::string filename,
	                   UID logID,
	                   int64_t memoryLimit,
	                   bool checkChecksums = false,
	                   bool checkIntegrity = false)
	  : storeType(storeType), filename(filename), logID(logID), memoryLimit(memoryLimit),
	    checkChecksums(checkChecksums), checkIntegrity(checkIntegrity) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, storeType, filename, logID, memoryLimit, checkChecksums, checkIntegrity, reply);
	}
};

struct IKVSGetValueRequest {
	constexpr static FileIdentifier file_identifier = 1029439;
	KeyRef key;
	Optional<ReadOptions> options;
	ReplyPromise<Optional<Value>> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, key, options, reply);
	}
};

struct IKVSSetRequest {
	constexpr static FileIdentifier file_identifier = 7283948;
	KeyValueRef keyValue;
	ReplyPromise<Void> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, keyValue, reply);
	}
};

struct IKVSClearRequest {
	constexpr static FileIdentifier file_identifier = 2838575;
	KeyRangeRef range;
	ReplyPromise<Void> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, range, reply);
	}
};

struct IKVSCommitRequest {
	constexpr static FileIdentifier file_identifier = 2985129;
	bool sequential;
	ReplyPromise<IKVSCommitReply> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, sequential, reply);
	}
};

struct IKVSReadValuePrefixRequest {
	constexpr static FileIdentifier file_identifier = 1928374;
	KeyRef key;
	int maxLength;
	Optional<ReadOptions> options;
	ReplyPromise<Optional<Value>> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, key, maxLength, options, reply);
	}
};

// Use this instead of RangeResult as reply for better serialization performance
struct IKVSReadRangeReply {
	constexpr static FileIdentifier file_identifier = 6682449;
	Arena arena;
	VectorRef<KeyValueRef, VecSerStrategy::String> data;
	bool more;
	Optional<KeyRef> readThrough;
	bool readToBegin;
	bool readThroughEnd;

	IKVSReadRangeReply() = default;

	explicit IKVSReadRangeReply(const RangeResult& res)
	  : arena(res.arena()), data(static_cast<const VectorRef<KeyValueRef>&>(res)), more(res.more),
	    readThrough(res.readThrough), readToBegin(res.readToBegin), readThroughEnd(res.readThroughEnd) {}

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, data, more, readThrough, readToBegin, readThroughEnd, arena);
	}

	RangeResult toRangeResult() const {
		RangeResult r(RangeResultRef(data, more, readThrough), arena);
		r.readToBegin = readToBegin;
		r.readThroughEnd = readThroughEnd;
		return r;
	}
};

struct IKVSReadRangeRequest {
	constexpr static FileIdentifier file_identifier = 5918394;
	KeyRangeRef keys;
	int rowLimit;
	int byteLimit;
	Optional<ReadOptions> options;
	ReplyPromise<IKVSReadRangeReply> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, keys, rowLimit, byteLimit, options, reply);
	}
};

struct IKVSGetStorageByteRequest {
	constexpr static FileIdentifier file_identifier = 3512344;
	ReplyPromise<StorageBytes> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct IKVSGetErrorRequest {
	constexpr static FileIdentifier file_identifier = 3942891;
	ReplyPromise<Void> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct IKVSOnClosedRequest {
	constexpr static FileIdentifier file_identifier = 1923894;
	ReplyPromise<Void> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct IKVSDisposeRequest {
	constexpr static FileIdentifier file_identifier = 1235952;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar);
	}
};

struct IKVSCloseRequest {
	constexpr static FileIdentifier file_identifier = 13859172;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar);
	}
};

															#line 306 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
[[nodiscard]] Future<Void> runIKVS( OpenKVStoreRequest const& openReq, IKVSInterface const& ikvsInterface );

#line 305 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"

struct KeyValueStoreProcess : FlowProcess {
	RemoteKVSProcessInterface kvsIf;
	Standalone<StringRef> serializedIf;

	Endpoint ssProcess; // endpoint for the storage process
	RequestStream<FlowProcessRegistrationRequest> ssRequestStream;

	KeyValueStoreProcess() {
		TraceEvent(SevDebug, "InitKeyValueStoreProcess").log();
		ObjectWriter writer(IncludeVersion());
		writer.serialize(kvsIf);
		serializedIf = writer.toString();
	}

	void registerEndpoint(Endpoint p) override {
		ssProcess = p;
		ssRequestStream = RequestStream<FlowProcessRegistrationRequest>(p);
	}

	StringRef name() const override { return _name; }
	StringRef serializedInterface() const override { return serializedIf; }

																#line 333 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
// This generated class is to be used only via _run()
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
template <class _runActor>
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class _runActorState {
															#line 339 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	_runActorState(KeyValueStoreProcess* const& self) 
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		 : self(self),
															#line 329 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		   actors(true)
															#line 348 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
	{
		fdb_probe_actor_create("_run", reinterpret_cast<unsigned long>(this));

	}
	~_runActorState() 
	{
		fdb_probe_actor_destroy("_run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 330 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			TraceEvent("WaitingForOpenKVStoreRequest").log();
															#line 331 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			;
															#line 365 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_runActorState();
		static_cast<_runActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 333 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		auto __when_expr_0 = self->kvsIf.openKVStore.getFuture();
															#line 395 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<OpenKVStoreRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<OpenKVStoreRequest>>::value, "invalid type");
															#line 332 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (static_cast<_runActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 399 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 338 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		StrictFuture<ErrorOr<Void>> __when_expr_1 = errorOr(actors.getResult());
															#line 403 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<_runActor*>(this)->actor_wait_state = 1;
															#line 333 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< _runActor, 0, OpenKVStoreRequest >*>(static_cast<_runActor*>(this)));
															#line 338 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _runActor, 1, ErrorOr<Void> >*>(static_cast<_runActor*>(this)));
															#line 410 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(OpenKVStoreRequest const& req,int loopDepth) 
	{
															#line 334 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent("OpenKVStoreRequestReceived").log();
															#line 335 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		IKVSInterface interf;
															#line 336 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		actors.add(runIKVS(req, interf));
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(OpenKVStoreRequest && req,int loopDepth) 
	{
															#line 334 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent("OpenKVStoreRequestReceived").log();
															#line 335 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		IKVSInterface interf;
															#line 336 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		actors.add(runIKVS(req, interf));
															#line 442 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 339 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (e.isError())
															#line 451 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		{
															#line 340 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			TraceEvent("KeyValueStoreProcessRunActorError").errorUnsuppressed(e.getError());
															#line 341 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 457 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
		else
		{
															#line 343 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			TraceEvent("KeyValueStoreProcessFinished").log();
															#line 344 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			if (!static_cast<_runActor*>(this)->SAV<Void>::futures) { (void)(e.get()); this->~_runActorState(); static_cast<_runActor*>(this)->destroy(); return 0; }
															#line 465 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			new (&static_cast<_runActor*>(this)->SAV< Void >::value()) Void(e.get());
			this->~_runActorState();
			static_cast<_runActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when2(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 339 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (e.isError())
															#line 478 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		{
															#line 340 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			TraceEvent("KeyValueStoreProcessRunActorError").errorUnsuppressed(e.getError());
															#line 341 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 484 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
		else
		{
															#line 343 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			TraceEvent("KeyValueStoreProcessFinished").log();
															#line 344 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			if (!static_cast<_runActor*>(this)->SAV<Void>::futures) { (void)(e.get()); this->~_runActorState(); static_cast<_runActor*>(this)->destroy(); return 0; }
															#line 492 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			new (&static_cast<_runActor*>(this)->SAV< Void >::value()) Void(e.get());
			this->~_runActorState();
			static_cast<_runActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_runActor*>(this)->actor_wait_state > 0) static_cast<_runActor*>(this)->actor_wait_state = 0;
		static_cast<_runActor*>(this)->ActorSingleCallback< _runActor, 0, OpenKVStoreRequest >::remove();
		static_cast<_runActor*>(this)->ActorCallback< _runActor, 1, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< _runActor, 0, OpenKVStoreRequest >*,OpenKVStoreRequest const& value) 
	{
		fdb_probe_actor_enter("_run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_runActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< _runActor, 0, OpenKVStoreRequest >*,OpenKVStoreRequest && value) 
	{
		fdb_probe_actor_enter("_run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_runActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< _runActor, 0, OpenKVStoreRequest >*,Error err) 
	{
		fdb_probe_actor_enter("_run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_runActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _runActor, 1, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("_run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_runActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _runActor, 1, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("_run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_runActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _runActor, 1, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("_run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_runActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_run", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	KeyValueStoreProcess* self;
															#line 329 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	ActorCollection actors;
															#line 626 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
};
// This generated class is to be used only via _run()
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class _runActor final : public Actor<Void>, public ActorSingleCallback< _runActor, 0, OpenKVStoreRequest >, public ActorCallback< _runActor, 1, ErrorOr<Void> >, public FastAllocated<_runActor>, public _runActorState<_runActor> {
															#line 631 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
	using FastAllocated<_runActor>::operator new;
	using FastAllocated<_runActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10078569803023525376UL, 9243580766061107200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< _runActor, 0, OpenKVStoreRequest >;
friend struct ActorCallback< _runActor, 1, ErrorOr<Void> >;
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	_runActor(KeyValueStoreProcess* const& self) 
															#line 649 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		 : Actor<Void>(),
		   _runActorState<_runActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3881373219414283776UL, 14178660549394042112UL);
		ActorExecutionContextHelper __helper(static_cast<_runActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< _runActor, 0, OpenKVStoreRequest >*)0, actor_cancelled()); break;
		}

	}
};
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
[[nodiscard]] static Future<Void> _run( KeyValueStoreProcess* const& self ) {
															#line 328 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	return Future<Void>(new _runActor(self));
															#line 681 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
}

#line 350 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"

	Future<Void> run() override { return _run(this); }

	static StringRef _name;
};

struct RemoteIKeyValueStore : public IKeyValueStore {
	RemoteKVSProcessInterface kvsProcess;
	IKVSInterface interf;
	Future<Void> initialized;
	Future<int> returnCode;
	StorageBytes storageBytes;

	RemoteIKeyValueStore() : storageBytes(0, 0, 0, 0) {}

	Future<Void> init() override {
		TraceEvent(SevInfo, "RemoteIKeyValueStoreInit").log();
		return initialized;
	}

	Future<Void> getError() const override { return getErrorImpl(this, returnCode); }
	Future<Void> onClosed() const override { return onCloseImpl(this); }

	void dispose() override {
		TraceEvent(SevDebug, "RemoteIKVSDisposeRequest").backtrace();
		interf.dispose.send(IKVSDisposeRequest{});
		// hold the future to not cancel the spawned process
		uncancellable(returnCode);
		delete this;
	}
	void close() override {
		TraceEvent(SevDebug, "RemoteIKVSCloseRequest").backtrace();
		interf.close.send(IKVSCloseRequest{});
		// hold the future to not cancel the spawned process
		uncancellable(returnCode);
		delete this;
	}

	KeyValueStoreType getType() const override { return interf.type(); }

	void set(KeyValueRef keyValue, const Arena* arena = nullptr) override {
		interf.set.send(IKVSSetRequest{ keyValue, ReplyPromise<Void>() });
	}
	void clear(KeyRangeRef range, const Arena* arena = nullptr) override {
		interf.clear.send(IKVSClearRequest{ range, ReplyPromise<Void>() });
	}

	Future<Void> commit(bool sequential = false) override {
		Future<IKVSCommitReply> commitReply =
		    interf.commit.getReply(IKVSCommitRequest{ sequential, ReplyPromise<IKVSCommitReply>() });
		return commitAndGetStorageBytes(this, commitReply);
	}

	Future<Optional<Value>> readValue(KeyRef key, Optional<ReadOptions> options = Optional<ReadOptions>()) override {
		return readValueImpl(this, IKVSGetValueRequest{ key, options, ReplyPromise<Optional<Value>>() });
	}

	Future<Optional<Value>> readValuePrefix(KeyRef key,
	                                        int maxLength,
	                                        Optional<ReadOptions> options = Optional<ReadOptions>()) override {
		return interf.readValuePrefix.getReply(
		    IKVSReadValuePrefixRequest{ key, maxLength, options, ReplyPromise<Optional<Value>>() });
	}

	Future<RangeResult> readRange(KeyRangeRef keys,
	                              int rowLimit = 1 << 30,
	                              int byteLimit = 1 << 30,
	                              Optional<ReadOptions> options = Optional<ReadOptions>()) override {
		IKVSReadRangeRequest req{ keys, rowLimit, byteLimit, options, ReplyPromise<IKVSReadRangeReply>() };
		return fmap([](const IKVSReadRangeReply& reply) { return reply.toRangeResult(); },
		            interf.readRange.getReply(req));
	}

	StorageBytes getStorageBytes() const override { return storageBytes; }

	void consumeInterface(StringRef intf) {
		kvsProcess = ObjectReader::fromStringRef<RemoteKVSProcessInterface>(intf, IncludeVersion());
	}

																#line 764 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
// This generated class is to be used only via commitAndGetStorageBytes()
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
template <class CommitAndGetStorageBytesActor>
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class CommitAndGetStorageBytesActorState {
															#line 770 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	CommitAndGetStorageBytesActorState(RemoteIKeyValueStore* const& self,Future<IKVSCommitReply> const& commitReplyFuture) 
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		 : self(self),
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		   commitReplyFuture(commitReplyFuture)
															#line 779 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
	{
		fdb_probe_actor_create("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this));

	}
	~CommitAndGetStorageBytesActorState() 
	{
		fdb_probe_actor_destroy("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 431 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			StrictFuture<IKVSCommitReply> __when_expr_0 = commitReplyFuture;
															#line 431 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			if (static_cast<CommitAndGetStorageBytesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 796 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CommitAndGetStorageBytesActor*>(this)->actor_wait_state = 1;
															#line 431 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitAndGetStorageBytesActor, 0, IKVSCommitReply >*>(static_cast<CommitAndGetStorageBytesActor*>(this)));
															#line 801 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitAndGetStorageBytesActorState();
		static_cast<CommitAndGetStorageBytesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(IKVSCommitReply const& commitReply,int loopDepth) 
	{
															#line 432 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		self->storageBytes = commitReply.storeBytes;
															#line 433 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (!static_cast<CommitAndGetStorageBytesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitAndGetStorageBytesActorState(); static_cast<CommitAndGetStorageBytesActor*>(this)->destroy(); return 0; }
															#line 826 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		new (&static_cast<CommitAndGetStorageBytesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitAndGetStorageBytesActorState();
		static_cast<CommitAndGetStorageBytesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(IKVSCommitReply && commitReply,int loopDepth) 
	{
															#line 432 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		self->storageBytes = commitReply.storeBytes;
															#line 433 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (!static_cast<CommitAndGetStorageBytesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitAndGetStorageBytesActorState(); static_cast<CommitAndGetStorageBytesActor*>(this)->destroy(); return 0; }
															#line 840 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		new (&static_cast<CommitAndGetStorageBytesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitAndGetStorageBytesActorState();
		static_cast<CommitAndGetStorageBytesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(IKVSCommitReply const& commitReply,int loopDepth) 
	{
		loopDepth = a_body1cont1(commitReply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(IKVSCommitReply && commitReply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(commitReply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitAndGetStorageBytesActor*>(this)->actor_wait_state > 0) static_cast<CommitAndGetStorageBytesActor*>(this)->actor_wait_state = 0;
		static_cast<CommitAndGetStorageBytesActor*>(this)->ActorCallback< CommitAndGetStorageBytesActor, 0, IKVSCommitReply >::remove();

	}
	void a_callback_fire(ActorCallback< CommitAndGetStorageBytesActor, 0, IKVSCommitReply >*,IKVSCommitReply const& value) 
	{
		fdb_probe_actor_enter("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndGetStorageBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitAndGetStorageBytesActor, 0, IKVSCommitReply >*,IKVSCommitReply && value) 
	{
		fdb_probe_actor_enter("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndGetStorageBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitAndGetStorageBytesActor, 0, IKVSCommitReply >*,Error err) 
	{
		fdb_probe_actor_enter("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndGetStorageBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	RemoteIKeyValueStore* self;
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	Future<IKVSCommitReply> commitReplyFuture;
															#line 927 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
};
// This generated class is to be used only via commitAndGetStorageBytes()
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class CommitAndGetStorageBytesActor final : public Actor<Void>, public ActorCallback< CommitAndGetStorageBytesActor, 0, IKVSCommitReply >, public FastAllocated<CommitAndGetStorageBytesActor>, public CommitAndGetStorageBytesActorState<CommitAndGetStorageBytesActor> {
															#line 932 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
	using FastAllocated<CommitAndGetStorageBytesActor>::operator new;
	using FastAllocated<CommitAndGetStorageBytesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14699144242926292736UL, 2095089969803410688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitAndGetStorageBytesActor, 0, IKVSCommitReply >;
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	CommitAndGetStorageBytesActor(RemoteIKeyValueStore* const& self,Future<IKVSCommitReply> const& commitReplyFuture) 
															#line 949 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		 : Actor<Void>(),
		   CommitAndGetStorageBytesActorState<CommitAndGetStorageBytesActor>(self, commitReplyFuture),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2407582962188321024UL, 8255524001550300416UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndGetStorageBytesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitAndGetStorageBytes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitAndGetStorageBytes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitAndGetStorageBytesActor, 0, IKVSCommitReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
[[nodiscard]] static Future<Void> commitAndGetStorageBytes( RemoteIKeyValueStore* const& self, Future<IKVSCommitReply> const& commitReplyFuture ) {
															#line 429 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	return Future<Void>(new CommitAndGetStorageBytesActor(self, commitReplyFuture));
															#line 981 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
}

#line 435 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"

																#line 986 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
// This generated class is to be used only via readValueImpl()
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
template <class ReadValueImplActor>
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class ReadValueImplActorState {
															#line 992 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	ReadValueImplActorState(RemoteIKeyValueStore* const& self,IKVSGetValueRequest const& req) 
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		 : self(self),
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		   req(req)
															#line 1001 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
	{
		fdb_probe_actor_create("readValueImpl", reinterpret_cast<unsigned long>(this));

	}
	~ReadValueImplActorState() 
	{
		fdb_probe_actor_destroy("readValueImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 437 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			StrictFuture<Optional<Value>> __when_expr_0 = self->interf.getValue.getReply(req);
															#line 437 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			if (static_cast<ReadValueImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1018 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadValueImplActor*>(this)->actor_wait_state = 1;
															#line 437 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadValueImplActor, 0, Optional<Value> >*>(static_cast<ReadValueImplActor*>(this)));
															#line 1023 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadValueImplActorState();
		static_cast<ReadValueImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 438 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (!static_cast<ReadValueImplActor*>(this)->SAV<Optional<Value>>::futures) { (void)(val); this->~ReadValueImplActorState(); static_cast<ReadValueImplActor*>(this)->destroy(); return 0; }
															#line 1046 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		new (&static_cast<ReadValueImplActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(val);
		this->~ReadValueImplActorState();
		static_cast<ReadValueImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 438 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (!static_cast<ReadValueImplActor*>(this)->SAV<Optional<Value>>::futures) { (void)(val); this->~ReadValueImplActorState(); static_cast<ReadValueImplActor*>(this)->destroy(); return 0; }
															#line 1058 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		new (&static_cast<ReadValueImplActor*>(this)->SAV< Optional<Value> >::value()) Optional<Value>(val);
		this->~ReadValueImplActorState();
		static_cast<ReadValueImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadValueImplActor*>(this)->actor_wait_state > 0) static_cast<ReadValueImplActor*>(this)->actor_wait_state = 0;
		static_cast<ReadValueImplActor*>(this)->ActorCallback< ReadValueImplActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadValueImplActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readValueImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadValueImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readValueImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadValueImplActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readValueImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadValueImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readValueImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadValueImplActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readValueImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadValueImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readValueImpl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	RemoteIKeyValueStore* self;
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	IKVSGetValueRequest req;
															#line 1145 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
};
// This generated class is to be used only via readValueImpl()
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class ReadValueImplActor final : public Actor<Optional<Value>>, public ActorCallback< ReadValueImplActor, 0, Optional<Value> >, public FastAllocated<ReadValueImplActor>, public ReadValueImplActorState<ReadValueImplActor> {
															#line 1150 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
	using FastAllocated<ReadValueImplActor>::operator new;
	using FastAllocated<ReadValueImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17039249574595201280UL, 5739505568945196032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Value>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadValueImplActor, 0, Optional<Value> >;
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	ReadValueImplActor(RemoteIKeyValueStore* const& self,IKVSGetValueRequest const& req) 
															#line 1167 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		 : Actor<Optional<Value>>(),
		   ReadValueImplActorState<ReadValueImplActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readValueImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10171728534385990400UL, 6016164372557901056UL);
		ActorExecutionContextHelper __helper(static_cast<ReadValueImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readValueImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readValueImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadValueImplActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
[[nodiscard]] static Future<Optional<Value>> readValueImpl( RemoteIKeyValueStore* const& self, IKVSGetValueRequest const& req ) {
															#line 436 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	return Future<Optional<Value>>(new ReadValueImplActor(self, req));
															#line 1199 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
}

#line 440 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"

																#line 1204 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
// This generated class is to be used only via getErrorImpl()
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
template <class GetErrorImplActor>
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class GetErrorImplActorState {
															#line 1210 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	GetErrorImplActorState(const RemoteIKeyValueStore* const& self,Future<int> const& returnCode) 
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		 : self(self),
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		   returnCode(returnCode)
															#line 1219 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
	{
		fdb_probe_actor_create("getErrorImpl", reinterpret_cast<unsigned long>(this));

	}
	~GetErrorImplActorState() 
	{
		fdb_probe_actor_destroy("getErrorImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 443 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			StrictFuture<Void> __when_expr_0 = self->initialized;
															#line 442 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			if (static_cast<GetErrorImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1236 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 444 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REMOTE_KV_STORE_MAX_INIT_DURATION);
															#line 1240 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<GetErrorImplActor*>(this)->actor_wait_state = 1;
															#line 443 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetErrorImplActor, 0, Void >*>(static_cast<GetErrorImplActor*>(this)));
															#line 444 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetErrorImplActor, 1, Void >*>(static_cast<GetErrorImplActor*>(this)));
															#line 1247 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetErrorImplActorState();
		static_cast<GetErrorImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 450 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		connectionCheckingDelay = delay(FLOW_KNOBS->FAILURE_DETECTION_DELAY);
															#line 451 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		storeError = errorOr(self->interf.getError.getReply(IKVSGetErrorRequest{}));
															#line 452 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		childAddr = self->interf.getError.getEndpoint().getPrimaryAddress();
															#line 453 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		;
															#line 1276 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 445 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent(SevError, "RemoteIKVSInitTooLong") .detail("TimeLimit", SERVER_KNOBS->REMOTE_KV_STORE_MAX_INIT_DURATION);
															#line 447 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1299 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 445 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent(SevError, "RemoteIKVSInitTooLong") .detail("TimeLimit", SERVER_KNOBS->REMOTE_KV_STORE_MAX_INIT_DURATION);
															#line 447 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1309 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetErrorImplActor*>(this)->actor_wait_state > 0) static_cast<GetErrorImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetErrorImplActor*>(this)->ActorCallback< GetErrorImplActor, 0, Void >::remove();
		static_cast<GetErrorImplActor*>(this)->ActorCallback< GetErrorImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetErrorImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetErrorImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 454 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		StrictFuture<ErrorOr<Void>> __when_expr_2 = storeError;
															#line 453 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (static_cast<GetErrorImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1447 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
															#line 463 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		StrictFuture<int> __when_expr_3 = returnCode;
															#line 1451 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_3.get(), loopDepth); };
															#line 470 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		StrictFuture<Void> __when_expr_4 = connectionCheckingDelay;
															#line 1455 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_4.get(), loopDepth); };
		static_cast<GetErrorImplActor*>(this)->actor_wait_state = 2;
															#line 454 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetErrorImplActor, 2, ErrorOr<Void> >*>(static_cast<GetErrorImplActor*>(this)));
															#line 463 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetErrorImplActor, 3, int >*>(static_cast<GetErrorImplActor*>(this)));
															#line 470 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GetErrorImplActor, 4, Void >*>(static_cast<GetErrorImplActor*>(this)));
															#line 1464 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 455 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent(SevDebug, "RemoteIKVSGetError") .errorUnsuppressed(e.isError() ? e.getError() : success()) .backtrace();
															#line 458 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (e.isError())
															#line 1481 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		{
															#line 459 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 1485 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
		else
		{
															#line 461 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			this->~GetErrorImplActorState();
															#line 1491 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			static_cast<GetErrorImplActor*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 455 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent(SevDebug, "RemoteIKVSGetError") .errorUnsuppressed(e.isError() ? e.getError() : success()) .backtrace();
															#line 458 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (e.isError())
															#line 1504 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		{
															#line 459 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 1508 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
		else
		{
															#line 461 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			this->~GetErrorImplActorState();
															#line 1514 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			static_cast<GetErrorImplActor*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(int const& res,int loopDepth) 
	{
															#line 464 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent(res != 0 ? SevError : SevInfo, "SpawnedProcessDied").detail("Res", res);
															#line 465 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (res)
															#line 1527 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		{
															#line 466 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(please_reboot_kv_store(), std::max(0, loopDepth - 1));
															#line 1531 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
		else
		{
															#line 468 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			this->~GetErrorImplActorState();
															#line 1537 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			static_cast<GetErrorImplActor*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(int && res,int loopDepth) 
	{
															#line 464 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent(res != 0 ? SevError : SevInfo, "SpawnedProcessDied").detail("Res", res);
															#line 465 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (res)
															#line 1550 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		{
															#line 466 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(please_reboot_kv_store(), std::max(0, loopDepth - 1));
															#line 1554 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
		else
		{
															#line 468 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			this->~GetErrorImplActorState();
															#line 1560 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
			static_cast<GetErrorImplActor*>(this)->sendAndDelPromiseRef(Never());
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 473 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (IFailureMonitor::failureMonitor().getState(childAddr).isFailed())
															#line 1571 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		{
															#line 474 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			TraceEvent(SevError, "RemoteKVStoreConnectionStuck").log();
															#line 475 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(please_reboot_kv_store(), std::max(0, loopDepth - 1));
															#line 1577 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
															#line 477 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		connectionCheckingDelay = delay(FLOW_KNOBS->FAILURE_DETECTION_DELAY);
															#line 1581 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 473 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (IFailureMonitor::failureMonitor().getState(childAddr).isFailed())
															#line 1590 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		{
															#line 474 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			TraceEvent(SevError, "RemoteKVStoreConnectionStuck").log();
															#line 475 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(please_reboot_kv_store(), std::max(0, loopDepth - 1));
															#line 1596 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
															#line 477 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		connectionCheckingDelay = delay(FLOW_KNOBS->FAILURE_DETECTION_DELAY);
															#line 1600 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetErrorImplActor*>(this)->actor_wait_state > 0) static_cast<GetErrorImplActor*>(this)->actor_wait_state = 0;
		static_cast<GetErrorImplActor*>(this)->ActorCallback< GetErrorImplActor, 2, ErrorOr<Void> >::remove();
		static_cast<GetErrorImplActor*>(this)->ActorCallback< GetErrorImplActor, 3, int >::remove();
		static_cast<GetErrorImplActor*>(this)->ActorCallback< GetErrorImplActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 2, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 2, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetErrorImplActor, 2, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetErrorImplActor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GetErrorImplActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GetErrorImplActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	const RemoteIKeyValueStore* self;
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	Future<int> returnCode;
															#line 450 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	Future<Void> connectionCheckingDelay;
															#line 451 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	Future<ErrorOr<Void>> storeError;
															#line 452 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	NetworkAddress childAddr;
															#line 1794 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
};
// This generated class is to be used only via getErrorImpl()
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class GetErrorImplActor final : public Actor<Void>, public ActorCallback< GetErrorImplActor, 0, Void >, public ActorCallback< GetErrorImplActor, 1, Void >, public ActorCallback< GetErrorImplActor, 2, ErrorOr<Void> >, public ActorCallback< GetErrorImplActor, 3, int >, public ActorCallback< GetErrorImplActor, 4, Void >, public FastAllocated<GetErrorImplActor>, public GetErrorImplActorState<GetErrorImplActor> {
															#line 1799 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
	using FastAllocated<GetErrorImplActor>::operator new;
	using FastAllocated<GetErrorImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7095593133874651392UL, 591161822667140096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetErrorImplActor, 0, Void >;
friend struct ActorCallback< GetErrorImplActor, 1, Void >;
friend struct ActorCallback< GetErrorImplActor, 2, ErrorOr<Void> >;
friend struct ActorCallback< GetErrorImplActor, 3, int >;
friend struct ActorCallback< GetErrorImplActor, 4, Void >;
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	GetErrorImplActor(const RemoteIKeyValueStore* const& self,Future<int> const& returnCode) 
															#line 1820 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		 : Actor<Void>(),
		   GetErrorImplActorState<GetErrorImplActor>(self, returnCode),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getErrorImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11170566171133649408UL, 12224313258987257088UL);
		ActorExecutionContextHelper __helper(static_cast<GetErrorImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getErrorImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getErrorImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetErrorImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetErrorImplActor, 2, ErrorOr<Void> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
[[nodiscard]] static Future<Void> getErrorImpl( const RemoteIKeyValueStore* const& self, Future<int> const& returnCode ) {
															#line 441 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	return Future<Void>(new GetErrorImplActor(self, returnCode));
															#line 1853 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
}

#line 481 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"

																#line 1858 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
// This generated class is to be used only via onCloseImpl()
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
template <class OnCloseImplActor>
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class OnCloseImplActorState {
															#line 1864 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	OnCloseImplActorState(const RemoteIKeyValueStore* const& self) 
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		 : self(self)
															#line 1871 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
	{
		fdb_probe_actor_create("onCloseImpl", reinterpret_cast<unsigned long>(this));

	}
	~OnCloseImplActorState() 
	{
		fdb_probe_actor_destroy("onCloseImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 484 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
				StrictFuture<Void> __when_expr_0 = self->initialized;
															#line 484 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
				if (static_cast<OnCloseImplActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1889 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<OnCloseImplActor*>(this)->actor_wait_state = 1;
															#line 484 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnCloseImplActor, 0, Void >*>(static_cast<OnCloseImplActor*>(this)));
															#line 1894 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnCloseImplActorState();
		static_cast<OnCloseImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 491 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (!static_cast<OnCloseImplActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnCloseImplActorState(); static_cast<OnCloseImplActor*>(this)->destroy(); return 0; }
															#line 1923 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		new (&static_cast<OnCloseImplActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnCloseImplActorState();
		static_cast<OnCloseImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 488 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			TraceEvent(SevInfo, "RemoteIKVSOnCloseImplError").errorUnsuppressed(e).backtrace();
															#line 489 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 1938 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		StrictFuture<Void> __when_expr_1 = self->interf.onClosed.getReply(IKVSOnClosedRequest{});
															#line 485 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (static_cast<OnCloseImplActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1954 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnCloseImplActor*>(this)->actor_wait_state = 2;
															#line 485 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnCloseImplActor, 1, Void >*>(static_cast<OnCloseImplActor*>(this)));
															#line 1959 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		StrictFuture<Void> __when_expr_1 = self->interf.onClosed.getReply(IKVSOnClosedRequest{});
															#line 485 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		if (static_cast<OnCloseImplActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1970 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnCloseImplActor*>(this)->actor_wait_state = 2;
															#line 485 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnCloseImplActor, 1, Void >*>(static_cast<OnCloseImplActor*>(this)));
															#line 1975 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnCloseImplActor*>(this)->actor_wait_state > 0) static_cast<OnCloseImplActor*>(this)->actor_wait_state = 0;
		static_cast<OnCloseImplActor*>(this)->ActorCallback< OnCloseImplActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnCloseImplActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onCloseImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnCloseImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onCloseImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnCloseImplActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onCloseImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnCloseImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onCloseImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnCloseImplActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onCloseImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnCloseImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onCloseImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 486 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent(SevDebug, "RemoteIKVSOnCloseImplOnClosedFinished");
															#line 2059 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 486 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
		TraceEvent(SevDebug, "RemoteIKVSOnCloseImplOnClosedFinished");
															#line 2068 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OnCloseImplActor*>(this)->actor_wait_state > 0) static_cast<OnCloseImplActor*>(this)->actor_wait_state = 0;
		static_cast<OnCloseImplActor*>(this)->ActorCallback< OnCloseImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnCloseImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onCloseImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnCloseImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onCloseImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OnCloseImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onCloseImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnCloseImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onCloseImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OnCloseImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onCloseImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnCloseImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onCloseImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	const RemoteIKeyValueStore* self;
															#line 2163 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
};
// This generated class is to be used only via onCloseImpl()
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
class OnCloseImplActor final : public Actor<Void>, public ActorCallback< OnCloseImplActor, 0, Void >, public ActorCallback< OnCloseImplActor, 1, Void >, public FastAllocated<OnCloseImplActor>, public OnCloseImplActorState<OnCloseImplActor> {
															#line 2168 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
public:
	using FastAllocated<OnCloseImplActor>::operator new;
	using FastAllocated<OnCloseImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14229431343469170944UL, 2491148810380129536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OnCloseImplActor, 0, Void >;
friend struct ActorCallback< OnCloseImplActor, 1, Void >;
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	OnCloseImplActor(const RemoteIKeyValueStore* const& self) 
															#line 2186 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
		 : Actor<Void>(),
		   OnCloseImplActorState<OnCloseImplActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onCloseImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10128853632561119744UL, 2087996866795524864UL);
		ActorExecutionContextHelper __helper(static_cast<OnCloseImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onCloseImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onCloseImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnCloseImplActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OnCloseImplActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
[[nodiscard]] static Future<Void> onCloseImpl( const RemoteIKeyValueStore* const& self ) {
															#line 482 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"
	return Future<Void>(new OnCloseImplActor(self));
															#line 2219 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.g.h"
}

#line 493 "/codebuild/output/src4012789340/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/RemoteIKeyValueStore.actor.h"

	Future<EncryptionAtRestMode> encryptionMode() override {
		return EncryptionAtRestMode(EncryptionAtRestMode::DISABLED);
	}
};

Future<Void> runFlowProcess(std::string const& name, Endpoint endpoint);

#include "flow/unactorcompiler.h"
#endif