#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
/*
 * MetaclusterOperationContext.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_METACLUSTEROPERATIONCONTEXT_ACTOR_G_H)
#define METACLUSTER_METACLUSTEROPERATIONCONTEXT_ACTOR_G_H
#include "metacluster/MetaclusterOperationContext.actor.g.h"
#elif !defined(METACLUSTER_METACLUSTEROPERATIONCONTEXT_ACTOR_H)
#define METACLUSTER_METACLUSTEROPERATIONCONTEXT_ACTOR_H

#include "fdbclient/IClientApi.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/VersionedMap.h"
#include "fdbrpc/TenantName.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"

#include "metacluster/GetCluster.actor.h"
#include "metacluster/MetaclusterMetadata.h"
#include "metacluster/MetaclusterTypes.h"
#include "metacluster/MetaclusterUtil.actor.h"

#include "flow/actorcompiler.h" // has to be last include

FDB_BOOLEAN_PARAM(RunOnDisconnectedCluster);
FDB_BOOLEAN_PARAM(RunOnMismatchedCluster);

namespace metacluster {

template <class DB>
struct MetaclusterOperationContext {
	Reference<DB> managementDb;
	Reference<IDatabase> dataClusterDb;

	Optional<ClusterName> clusterName;

	Optional<MetaclusterRegistrationEntry> metaclusterRegistration;
	Optional<DataClusterMetadata> dataClusterMetadata;
	bool dataClusterIsRegistered = true;

	std::set<DataClusterState> extraSupportedDataClusterStates;

	MetaclusterOperationContext(Reference<DB> managementDb,
	                            Optional<ClusterName> clusterName = {},
	                            std::set<DataClusterState> extraSupportedDataClusterStates = {})
	  : managementDb(managementDb), clusterName(clusterName),
	    extraSupportedDataClusterStates(extraSupportedDataClusterStates) {}

	void checkClusterState() {
		DataClusterState clusterState =
		    dataClusterMetadata.present() ? dataClusterMetadata.get().entry.clusterState : DataClusterState::READY;
		if (clusterState != DataClusterState::READY && extraSupportedDataClusterStates.count(clusterState) == 0) {
			if (clusterState == DataClusterState::REGISTERING) {
				CODE_PROBE(true, "Run metacluster transaction on registering cluster");
				throw cluster_not_found();
			} else if (clusterState == DataClusterState::REMOVING) {
				CODE_PROBE(true, "Run metacluster transaction on removing cluster");
				throw cluster_removed();
			} else if (clusterState == DataClusterState::RESTORING) {
				CODE_PROBE(true, "Run metacluster transaction on restoring cluster");
				throw cluster_restoring();
			}

			ASSERT(false);
		}
	}

	// Run a transaction on the management cluster. This verifies that the cluster is a management cluster and
	// matches the same metacluster that we've run any previous transactions on. If a clusterName is set, it also
	// verifies that the specified cluster is present. Stores the metaclusterRegistration entry and, if a
	// clusterName is set, the dataClusterMetadata and dataClusterDb in the context.
																#line 95 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
// This generated class is to be used only via runManagementTransaction()
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
template <class Function, class RunManagementTransactionActor>
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
class RunManagementTransactionActorState {
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
public:
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	RunManagementTransactionActorState(MetaclusterOperationContext* const& self,Function const& func) 
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		 : self(self),
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		   func(func),
															#line 96 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		   tr(self->managementDb->createTransaction()),
															#line 97 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		   clusterPresentAtStart(self->clusterName.present())
															#line 114 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
	{
		fdb_probe_actor_create("runManagementTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RunManagementTransactionActorState() 
	{
		fdb_probe_actor_destroy("runManagementTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 98 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			;
															#line 129 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunManagementTransactionActorState();
		static_cast<RunManagementTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 102 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (!clusterPresentAtStart)
															#line 160 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			{
															#line 103 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				CODE_PROBE(true, "Retry management transaction with unconfigured cluster");
															#line 104 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				self->clearCluster();
															#line 166 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			}
															#line 108 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 109 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			dataClusterMetadataFuture = Future<Optional<DataClusterMetadata>>();
															#line 110 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (self->clusterName.present())
															#line 174 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			{
															#line 111 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				dataClusterMetadataFuture = tryGetClusterTransaction(tr, self->clusterName.get());
															#line 178 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			}
															#line 115 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_0 = metadata::metaclusterRegistration().get(tr);
															#line 115 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 184 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 1;
															#line 115 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunManagementTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >*>(static_cast<RunManagementTransactionActor*>(this)));
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 175 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			StrictFuture<Void> __when_expr_5 = safeThreadFutureToFuture(tr->onError(e));
															#line 175 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 213 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 6;
															#line 175 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RunManagementTransactionActor, 5, Void >*>(static_cast<RunManagementTransactionActor*>(this)));
															#line 218 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 118 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		currentDataClusterMetadata = Optional<DataClusterMetadata>();
															#line 119 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (self->clusterName.present())
															#line 235 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 120 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			StrictFuture<Void> __when_expr_1 = store(currentDataClusterMetadata, dataClusterMetadataFuture);
															#line 120 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 241 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 2;
															#line 120 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunManagementTransactionActor, 1, Void >*>(static_cast<RunManagementTransactionActor*>(this)));
															#line 246 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> const& __currentMetaclusterRegistration,int loopDepth) 
	{
															#line 115 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		currentMetaclusterRegistration = __currentMetaclusterRegistration;
															#line 260 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> && __currentMetaclusterRegistration,int loopDepth) 
	{
		currentMetaclusterRegistration = std::move(__currentMetaclusterRegistration);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementTransactionActor*>(this)->ActorCallback< RunManagementTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunManagementTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!currentMetaclusterRegistration.present() || currentMetaclusterRegistration.get().clusterType != ClusterType::METACLUSTER_MANAGEMENT)
															#line 339 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 127 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			CODE_PROBE(true, "Run management transaction on non-management cluster");
															#line 128 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			return a_body1loopBody1Catch1(invalid_metacluster_operation(), loopDepth);
															#line 345 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		}
		else
		{
															#line 129 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (self->metaclusterRegistration.present() && !self->metaclusterRegistration.get().matches(currentMetaclusterRegistration.get()))
															#line 351 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			{
															#line 131 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				CODE_PROBE(true, "Run management transaction on wrong management cluster", probe::decoration::rare);
															#line 132 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				return a_body1loopBody1Catch1(metacluster_mismatch(), loopDepth);
															#line 357 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			}
		}
															#line 138 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (self->clusterName.present())
															#line 362 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 139 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (!currentDataClusterMetadata.present())
															#line 366 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			{
															#line 140 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				CODE_PROBE(true, "Run management transaction using deleted data cluster");
															#line 141 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				return a_body1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 372 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			}
			else
			{
															#line 143 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				currentMetaclusterRegistration = currentMetaclusterRegistration.get().toDataClusterRegistration( self->clusterName.get(), currentDataClusterMetadata.get().entry.id);
															#line 378 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			}
		}
															#line 149 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!self->metaclusterRegistration.present())
															#line 383 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 150 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			self->metaclusterRegistration = currentMetaclusterRegistration;
															#line 387 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		}
															#line 155 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (self->dataClusterMetadata.present() && self->dataClusterMetadata.get().entry.id != currentDataClusterMetadata.get().entry.id)
															#line 391 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 157 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			CODE_PROBE(true, "Run management transaction using wrong data cluster");
															#line 158 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			return a_body1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 397 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		}
		else
		{
															#line 159 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (self->clusterName.present())
															#line 403 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			{
															#line 160 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				self->dataClusterMetadata = currentDataClusterMetadata;
															#line 161 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				if (!self->dataClusterDb)
															#line 409 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
				{
															#line 162 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
					StrictFuture<Void> __when_expr_2 = store(self->dataClusterDb, util::openDatabase(self->dataClusterMetadata.get().connectionString));
															#line 162 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
					if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 415 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_2.get(), loopDepth); };
					static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 3;
															#line 162 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunManagementTransactionActor, 2, Void >*>(static_cast<RunManagementTransactionActor*>(this)));
															#line 420 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1cont17(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont16(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementTransactionActor*>(this)->ActorCallback< RunManagementTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunManagementTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 167 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		self->checkClusterState();
															#line 169 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		StrictFuture<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())> __when_expr_3 = func(tr);
															#line 169 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 531 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 4;
															#line 169 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunManagementTransactionActor, 3, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*>(static_cast<RunManagementTransactionActor*>(this)));
															#line 536 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont16(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont17(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont18(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementTransactionActor*>(this)->ActorCallback< RunManagementTransactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunManagementTransactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont19(int loopDepth) 
	{
															#line 172 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		StrictFuture<Void> __when_expr_4 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 172 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 646 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont19when1(__when_expr_4.get(), loopDepth); };
		static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 5;
															#line 172 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunManagementTransactionActor, 4, Void >*>(static_cast<RunManagementTransactionActor*>(this)));
															#line 651 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) const& __result,int loopDepth) 
	{
															#line 169 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		result = __result;
															#line 660 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont19(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementTransactionActor*>(this)->ActorCallback< RunManagementTransactionActor, 3, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 3, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*,decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 3, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*,decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunManagementTransactionActor, 3, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont19cont1(Void const& _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!static_cast<RunManagementTransactionActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>::futures) { (void)(result); this->~RunManagementTransactionActorState(); static_cast<RunManagementTransactionActor*>(this)->destroy(); return 0; }
															#line 739 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		new (&static_cast<RunManagementTransactionActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunManagementTransactionActorState();
		static_cast<RunManagementTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont19cont1(Void && _,int loopDepth) 
	{
															#line 173 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!static_cast<RunManagementTransactionActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>::futures) { (void)(result); this->~RunManagementTransactionActorState(); static_cast<RunManagementTransactionActor*>(this)->destroy(); return 0; }
															#line 751 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		new (&static_cast<RunManagementTransactionActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunManagementTransactionActorState();
		static_cast<RunManagementTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont19when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont19cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementTransactionActor*>(this)->ActorCallback< RunManagementTransactionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont19when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont19when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunManagementTransactionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RunManagementTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunManagementTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunManagementTransactionActor*>(this)->ActorCallback< RunManagementTransactionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RunManagementTransactionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RunManagementTransactionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	MetaclusterOperationContext* self;
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Function func;
															#line 96 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 97 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	bool clusterPresentAtStart;
															#line 109 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Future<Optional<DataClusterMetadata>> dataClusterMetadataFuture;
															#line 115 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Optional<MetaclusterRegistrationEntry> currentMetaclusterRegistration;
															#line 118 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Optional<DataClusterMetadata> currentDataClusterMetadata;
															#line 169 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) result;
															#line 937 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
};
// This generated class is to be used only via runManagementTransaction()
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
template <class Function>
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
class RunManagementTransactionActor final : public Actor<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>, public ActorCallback< RunManagementTransactionActor<Function>, 0, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< RunManagementTransactionActor<Function>, 1, Void >, public ActorCallback< RunManagementTransactionActor<Function>, 2, Void >, public ActorCallback< RunManagementTransactionActor<Function>, 3, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >, public ActorCallback< RunManagementTransactionActor<Function>, 4, Void >, public ActorCallback< RunManagementTransactionActor<Function>, 5, Void >, public FastAllocated<RunManagementTransactionActor<Function>>, public RunManagementTransactionActorState<Function, RunManagementTransactionActor<Function>> {
															#line 944 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
public:
	using FastAllocated<RunManagementTransactionActor<Function>>::operator new;
	using FastAllocated<RunManagementTransactionActor<Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15986001690139968256UL, 12052423135027454720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunManagementTransactionActor<Function>, 0, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< RunManagementTransactionActor<Function>, 1, Void >;
friend struct ActorCallback< RunManagementTransactionActor<Function>, 2, Void >;
friend struct ActorCallback< RunManagementTransactionActor<Function>, 3, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >;
friend struct ActorCallback< RunManagementTransactionActor<Function>, 4, Void >;
friend struct ActorCallback< RunManagementTransactionActor<Function>, 5, Void >;
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	RunManagementTransactionActor(MetaclusterOperationContext* const& self,Function const& func) 
															#line 966 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		 : Actor<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>(),
		   RunManagementTransactionActorState<Function, RunManagementTransactionActor<Function>>(self, func),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runManagementTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4571352353785687296UL, 14719376444857708032UL);
		ActorExecutionContextHelper __helper(static_cast<RunManagementTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runManagementTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runManagementTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunManagementTransactionActor<Function>, 0, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunManagementTransactionActor<Function>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunManagementTransactionActor<Function>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunManagementTransactionActor<Function>, 3, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunManagementTransactionActor<Function>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RunManagementTransactionActor<Function>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
template <class Function>
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
[[nodiscard]] static Future<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())> runManagementTransaction( MetaclusterOperationContext* const& self, Function const& func ) {
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	return Future<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>(new RunManagementTransactionActor<Function>(self, func));
															#line 1005 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
}

#line 179 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"

	template <class Function>
	Future<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())>
	runManagementTransaction(Function func) {
		return runManagementTransaction(this, func);
	}

	// Runs a transaction on the data cluster. This requires that a cluster name be set and that a transaction has
	// already been run on the management cluster to populate the needed metadata. This verifies that the data
	// cluster has the expected ID and is part of the metacluster that previous transactions have run on.
																#line 1019 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
// This generated class is to be used only via runDataClusterTransaction()
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
template <class Function, class RunDataClusterTransactionActor>
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
class RunDataClusterTransactionActorState {
															#line 1025 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
public:
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	RunDataClusterTransactionActorState(MetaclusterOperationContext* const& self,Function const& func,RunOnDisconnectedCluster const& runOnDisconnectedCluster,RunOnMismatchedCluster const& runOnMismatchedCluster) 
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		 : self(self),
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		   func(func),
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		   runOnDisconnectedCluster(runOnDisconnectedCluster),
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		   runOnMismatchedCluster(runOnMismatchedCluster)
															#line 1038 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
	{
		fdb_probe_actor_create("runDataClusterTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RunDataClusterTransactionActorState() 
	{
		fdb_probe_actor_destroy("runDataClusterTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 195 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			ASSERT(self->dataClusterDb);
															#line 196 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			ASSERT(runOnDisconnectedCluster || self->dataClusterMetadata.present());
															#line 197 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			ASSERT(self->metaclusterRegistration.present() && (runOnDisconnectedCluster || self->metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA));
															#line 201 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			self->checkClusterState();
															#line 203 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			tr = self->dataClusterDb->createTransaction();
															#line 204 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			;
															#line 1063 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunDataClusterTransactionActorState();
		static_cast<RunDataClusterTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 206 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 208 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			checkRestoring = !self->extraSupportedDataClusterStates.count(DataClusterState::RESTORING);
															#line 209 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			activeRestoreIdFuture = Future<KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>>>();
															#line 210 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (checkRestoring && self->clusterName.present())
															#line 1100 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			{
															#line 211 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				activeRestoreIdFuture = metadata::activeRestoreIds().getRange(tr, {}, {}, 1);
															#line 1104 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			}
															#line 214 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_0 = metadata::metaclusterRegistration().get(tr);
															#line 214 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1110 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 1;
															#line 214 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >*>(static_cast<RunDataClusterTransactionActor*>(this)));
															#line 1115 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 249 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->onError(e));
															#line 249 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1139 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 5;
															#line 249 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterTransactionActor, 4, Void >*>(static_cast<RunDataClusterTransactionActor*>(this)));
															#line 1144 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 218 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!currentMetaclusterRegistration.present())
															#line 1159 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 219 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (!runOnDisconnectedCluster)
															#line 1163 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			{
															#line 220 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				CODE_PROBE(true, "Run data cluster transaction on non-data cluster");
															#line 221 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				return a_body1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 1169 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			}
		}
		else
		{
															#line 223 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (currentMetaclusterRegistration.get().clusterType != ClusterType::METACLUSTER_DATA)
															#line 1176 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			{
															#line 224 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				CODE_PROBE(true, "Run data cluster transaction on non-data cluster", probe::decoration::rare);
															#line 225 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				return a_body1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 1182 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			}
			else
			{
															#line 226 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
				if (!self->metaclusterRegistration.get().matches(currentMetaclusterRegistration.get()))
															#line 1188 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
				{
															#line 227 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
					if (!runOnMismatchedCluster)
															#line 1192 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
					{
															#line 228 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
						CODE_PROBE(true, "Run data cluster transaction on wrong data cluster");
															#line 229 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
						return a_body1loopBody1Catch1(cluster_removed(), loopDepth);
															#line 1198 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
					}
				}
			}
		}
															#line 233 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (checkRestoring)
															#line 1205 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 234 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			StrictFuture<KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>>> __when_expr_1 = activeRestoreIdFuture;
															#line 234 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1211 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 2;
															#line 234 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> >*>(static_cast<RunDataClusterTransactionActor*>(this)));
															#line 1216 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> const& __currentMetaclusterRegistration,int loopDepth) 
	{
															#line 214 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		currentMetaclusterRegistration = __currentMetaclusterRegistration;
															#line 1230 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> && __currentMetaclusterRegistration,int loopDepth) 
	{
		currentMetaclusterRegistration = std::move(__currentMetaclusterRegistration);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterTransactionActor*>(this)->ActorCallback< RunDataClusterTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunDataClusterTransactionActor, 0, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 242 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		self->dataClusterIsRegistered = currentMetaclusterRegistration.present();
															#line 243 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		StrictFuture<decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue())> __when_expr_2 = func(tr);
															#line 243 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1313 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 3;
															#line 243 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterTransactionActor, 2, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*>(static_cast<RunDataClusterTransactionActor*>(this)));
															#line 1318 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont12(KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> const& activeRestoreId,int loopDepth) 
	{
															#line 236 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!activeRestoreId.results.empty())
															#line 1327 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 237 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			CODE_PROBE(true, "Run data cluster transaction on restoring data cluster");
															#line 238 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			return a_body1loopBody1Catch1(cluster_restoring(), loopDepth);
															#line 1333 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> && activeRestoreId,int loopDepth) 
	{
															#line 236 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!activeRestoreId.results.empty())
															#line 1343 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 237 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			CODE_PROBE(true, "Run data cluster transaction on restoring data cluster");
															#line 238 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			return a_body1loopBody1Catch1(cluster_restoring(), loopDepth);
															#line 1349 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> const& activeRestoreId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(activeRestoreId, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> && activeRestoreId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(activeRestoreId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterTransactionActor*>(this)->ActorCallback< RunDataClusterTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> >*,KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> const& value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> >*,KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> && value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunDataClusterTransactionActor, 1, KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont13(int loopDepth) 
	{
															#line 246 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->commit());
															#line 246 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1436 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont13when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 4;
															#line 246 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunDataClusterTransactionActor, 3, Void >*>(static_cast<RunDataClusterTransactionActor*>(this)));
															#line 1441 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) const& __result,int loopDepth) 
	{
															#line 243 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		result = __result;
															#line 1450 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1loopBody1cont13(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterTransactionActor*>(this)->ActorCallback< RunDataClusterTransactionActor, 2, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 2, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*,decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) const& value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 2, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*,decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) && value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunDataClusterTransactionActor, 2, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont13cont1(Void const& _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!static_cast<RunDataClusterTransactionActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())>::futures) { (void)(result); this->~RunDataClusterTransactionActorState(); static_cast<RunDataClusterTransactionActor*>(this)->destroy(); return 0; }
															#line 1529 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		new (&static_cast<RunDataClusterTransactionActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ITransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunDataClusterTransactionActorState();
		static_cast<RunDataClusterTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont13cont1(Void && _,int loopDepth) 
	{
															#line 247 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!static_cast<RunDataClusterTransactionActor*>(this)->SAV<decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())>::futures) { (void)(result); this->~RunDataClusterTransactionActorState(); static_cast<RunDataClusterTransactionActor*>(this)->destroy(); return 0; }
															#line 1541 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		new (&static_cast<RunDataClusterTransactionActor*>(this)->SAV< decltype(std::declval<Function>()(Reference<ITransaction>()).getValue()) >::value()) decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())(std::move(result)); // state_var_RVO
		this->~RunDataClusterTransactionActorState();
		static_cast<RunDataClusterTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterTransactionActor*>(this)->ActorCallback< RunDataClusterTransactionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunDataClusterTransactionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state > 0) static_cast<RunDataClusterTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RunDataClusterTransactionActor*>(this)->ActorCallback< RunDataClusterTransactionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RunDataClusterTransactionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RunDataClusterTransactionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	MetaclusterOperationContext* self;
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Function func;
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	RunOnDisconnectedCluster runOnDisconnectedCluster;
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	RunOnMismatchedCluster runOnMismatchedCluster;
															#line 203 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Reference<ITransaction> tr;
															#line 208 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	bool checkRestoring;
															#line 209 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Future<KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>>> activeRestoreIdFuture;
															#line 214 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Optional<MetaclusterRegistrationEntry> currentMetaclusterRegistration;
															#line 243 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) result;
															#line 1729 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
};
// This generated class is to be used only via runDataClusterTransaction()
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
template <class Function>
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
class RunDataClusterTransactionActor final : public Actor<decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())>, public ActorCallback< RunDataClusterTransactionActor<Function>, 0, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< RunDataClusterTransactionActor<Function>, 1, KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> >, public ActorCallback< RunDataClusterTransactionActor<Function>, 2, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >, public ActorCallback< RunDataClusterTransactionActor<Function>, 3, Void >, public ActorCallback< RunDataClusterTransactionActor<Function>, 4, Void >, public FastAllocated<RunDataClusterTransactionActor<Function>>, public RunDataClusterTransactionActorState<Function, RunDataClusterTransactionActor<Function>> {
															#line 1736 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
public:
	using FastAllocated<RunDataClusterTransactionActor<Function>>::operator new;
	using FastAllocated<RunDataClusterTransactionActor<Function>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12230233363278364928UL, 7958872238656056576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunDataClusterTransactionActor<Function>, 0, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< RunDataClusterTransactionActor<Function>, 1, KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> >;
friend struct ActorCallback< RunDataClusterTransactionActor<Function>, 2, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >;
friend struct ActorCallback< RunDataClusterTransactionActor<Function>, 3, Void >;
friend struct ActorCallback< RunDataClusterTransactionActor<Function>, 4, Void >;
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	RunDataClusterTransactionActor(MetaclusterOperationContext* const& self,Function const& func,RunOnDisconnectedCluster const& runOnDisconnectedCluster,RunOnMismatchedCluster const& runOnMismatchedCluster) 
															#line 1757 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		 : Actor<decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())>(),
		   RunDataClusterTransactionActorState<Function, RunDataClusterTransactionActor<Function>>(self, func, runOnDisconnectedCluster, runOnMismatchedCluster),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5083317267213914880UL, 1437328255455222272UL);
		ActorExecutionContextHelper __helper(static_cast<RunDataClusterTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runDataClusterTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runDataClusterTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunDataClusterTransactionActor<Function>, 0, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunDataClusterTransactionActor<Function>, 1, KeyBackedRangeResult<std::pair<ClusterName, metadata::RestoreId>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunDataClusterTransactionActor<Function>, 2, decltype(std::declval<Function>()(Reference<typename DB::TransactionT>()).getValue()) >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunDataClusterTransactionActor<Function>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RunDataClusterTransactionActor<Function>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
template <class Function>
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
[[nodiscard]] static Future<decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())> runDataClusterTransaction( MetaclusterOperationContext* const& self, Function const& func, RunOnDisconnectedCluster const& runOnDisconnectedCluster, RunOnMismatchedCluster const& runOnMismatchedCluster ) {
															#line 189 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	return Future<decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())>(new RunDataClusterTransactionActor<Function>(self, func, runOnDisconnectedCluster, runOnMismatchedCluster));
															#line 1795 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
}

#line 253 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"

	template <class Function>
	Future<decltype(std::declval<Function>()(Reference<ITransaction>()).getValue())> runDataClusterTransaction(
	    Function func,
	    RunOnDisconnectedCluster runOnDisconnectedCluster = RunOnDisconnectedCluster::False,
	    RunOnMismatchedCluster runOnMismatchedCluster = RunOnMismatchedCluster::False) {
		return runDataClusterTransaction(this, func, runOnDisconnectedCluster, runOnMismatchedCluster);
	}

																#line 1808 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
// This generated class is to be used only via updateClusterName()
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
template <class UpdateClusterNameActor>
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
class UpdateClusterNameActorState {
															#line 1814 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
public:
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	UpdateClusterNameActorState(MetaclusterOperationContext* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		 : self(self),
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		   tr(tr)
															#line 1823 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
	{
		fdb_probe_actor_create("updateClusterName", reinterpret_cast<unsigned long>(this));

	}
	~UpdateClusterNameActorState() 
	{
		fdb_probe_actor_destroy("updateClusterName", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 264 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			StrictFuture<DataClusterMetadata> __when_expr_0 = getClusterTransaction(tr, self->clusterName.get());
															#line 264 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (static_cast<UpdateClusterNameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1840 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateClusterNameActor*>(this)->actor_wait_state = 1;
															#line 264 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateClusterNameActor, 0, DataClusterMetadata >*>(static_cast<UpdateClusterNameActor*>(this)));
															#line 1845 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateClusterNameActorState();
		static_cast<UpdateClusterNameActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 266 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		self->metaclusterRegistration = self->metaclusterRegistration.get().toDataClusterRegistration( self->clusterName.get(), currentDataClusterMetadata.entry.id);
															#line 269 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		self->dataClusterMetadata = currentDataClusterMetadata;
															#line 270 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!self->dataClusterDb)
															#line 1872 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		{
															#line 271 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			StrictFuture<Void> __when_expr_1 = store(self->dataClusterDb, util::openDatabase(self->dataClusterMetadata.get().connectionString));
															#line 271 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			if (static_cast<UpdateClusterNameActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1878 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateClusterNameActor*>(this)->actor_wait_state = 2;
															#line 271 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateClusterNameActor, 1, Void >*>(static_cast<UpdateClusterNameActor*>(this)));
															#line 1883 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DataClusterMetadata const& __currentDataClusterMetadata,int loopDepth) 
	{
															#line 264 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		currentDataClusterMetadata = __currentDataClusterMetadata;
															#line 1897 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DataClusterMetadata && __currentDataClusterMetadata,int loopDepth) 
	{
		currentDataClusterMetadata = std::move(__currentDataClusterMetadata);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateClusterNameActor*>(this)->actor_wait_state > 0) static_cast<UpdateClusterNameActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateClusterNameActor*>(this)->ActorCallback< UpdateClusterNameActor, 0, DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateClusterNameActor, 0, DataClusterMetadata >*,DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("updateClusterName", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterNameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterName", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateClusterNameActor, 0, DataClusterMetadata >*,DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("updateClusterName", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterNameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterName", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateClusterNameActor, 0, DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("updateClusterName", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterNameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterName", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 274 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		self->checkClusterState();
															#line 276 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
		if (!static_cast<UpdateClusterNameActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateClusterNameActorState(); static_cast<UpdateClusterNameActor*>(this)->destroy(); return 0; }
															#line 1978 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		new (&static_cast<UpdateClusterNameActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateClusterNameActorState();
		static_cast<UpdateClusterNameActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateClusterNameActor*>(this)->actor_wait_state > 0) static_cast<UpdateClusterNameActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateClusterNameActor*>(this)->ActorCallback< UpdateClusterNameActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateClusterNameActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateClusterName", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterNameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterName", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateClusterNameActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateClusterName", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterNameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterName", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateClusterNameActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateClusterName", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterNameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterName", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	MetaclusterOperationContext* self;
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 264 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	DataClusterMetadata currentDataClusterMetadata;
															#line 2079 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
};
// This generated class is to be used only via updateClusterName()
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
class UpdateClusterNameActor final : public Actor<Void>, public ActorCallback< UpdateClusterNameActor, 0, DataClusterMetadata >, public ActorCallback< UpdateClusterNameActor, 1, Void >, public FastAllocated<UpdateClusterNameActor>, public UpdateClusterNameActorState<UpdateClusterNameActor> {
															#line 2084 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
public:
	using FastAllocated<UpdateClusterNameActor>::operator new;
	using FastAllocated<UpdateClusterNameActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(438846519491331072UL, 5136178032560071168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateClusterNameActor, 0, DataClusterMetadata >;
friend struct ActorCallback< UpdateClusterNameActor, 1, Void >;
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	UpdateClusterNameActor(MetaclusterOperationContext* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 2102 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
		 : Actor<Void>(),
		   UpdateClusterNameActorState<UpdateClusterNameActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateClusterName", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(907069281503645952UL, 4356631494224225792UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterNameActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateClusterName");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateClusterName", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateClusterNameActor, 0, DataClusterMetadata >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateClusterNameActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
[[nodiscard]] static Future<Void> updateClusterName( MetaclusterOperationContext* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"
	return Future<Void>(new UpdateClusterNameActor(self, tr));
															#line 2135 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterOperationContext.actor.g.h"
}

#line 278 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterOperationContext.actor.h"

	// Sets the cluster used in this context. This must be called from a management cluster transaction, and it
	// will load the cluster metadata and connect to the cluster.
	Future<Void> setCluster(Reference<typename DB::TransactionT> tr, ClusterName clusterName) {
		ASSERT(!this->clusterName.present());
		ASSERT(!dataClusterMetadata.present());
		ASSERT(metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_MANAGEMENT);
		this->clusterName = clusterName;
		return updateClusterName(this, tr);
	}

	// Clears the chosen cluster for this context. This is useful if we are retrying a transaction that expects an
	// uninitialized cluster.
	void clearCluster() {
		clusterName = {};
		dataClusterMetadata = {};
		dataClusterDb = {};
		if (metaclusterRegistration.present() &&
		    metaclusterRegistration.get().clusterType == ClusterType::METACLUSTER_DATA) {
			metaclusterRegistration = metaclusterRegistration.get().toManagementClusterRegistration();
		}
	}
};
} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif