#define POST_ACTOR_COMPILER 1
#line 2 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"

/*
 * MetaclusterConsistency.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated version of this file.  In intellisense use the source
// version.
#if defined(NO_INTELLISENSE) && !defined(WORKLOADS_METACLUSTERCONSISTENCY_ACTOR_G_H)
#define WORKLOADS_METACLUSTERCONSISTENCY_ACTOR_G_H
#include "metacluster/MetaclusterConsistency.actor.g.h"
#elif !defined(WORKLOADS_METACLUSTERCONSISTENCY_ACTOR_H)
#define WORKLOADS_METACLUSTERCONSISTENCY_ACTOR_H

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "flow/BooleanParam.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterData.actor.h"
#include "metacluster/MetaclusterUtil.actor.h"
#include "metacluster/TenantConsistency.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace metacluster::util {
FDB_BOOLEAN_PARAM(AllowPartialMetaclusterOperations);

template <class DB>
class MetaclusterConsistencyCheck {
private:
	Reference<DB> managementDb;
	AllowPartialMetaclusterOperations allowPartialMetaclusterOperations = AllowPartialMetaclusterOperations::True;
	MetaclusterData<DB> metaclusterData;

	// Note: this check can only be run on metaclusters with a reasonable number of tenants, as should be
	// the case with the current metacluster simulation workloads
	static inline const int metaclusterMaxTenants = 10e6;

																#line 60 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
// This generated class is to be used only via checkManagementSystemKeys()
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
template <class CheckManagementSystemKeysActor>
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
class CheckManagementSystemKeysActorState {
															#line 66 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
public:
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	CheckManagementSystemKeysActorState(MetaclusterConsistencyCheck* const& self) 
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		 : self(self),
															#line 59 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		   tr(self->managementDb->createTransaction())
															#line 75 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
	{
		fdb_probe_actor_create("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	~CheckManagementSystemKeysActorState() 
	{
		fdb_probe_actor_destroy("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			;
															#line 90 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckManagementSystemKeysActorState();
		static_cast<CheckManagementSystemKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 62 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 63 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			systemTenantSubspaceKeysFuture = tr->getRange(prefixRange(TenantMetadata::subspace()), 2);
															#line 65 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			StrictFuture<RangeResult> __when_expr_0 = safeThreadFutureToFuture(systemTenantSubspaceKeysFuture);
															#line 65 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			if (static_cast<CheckManagementSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 127 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckManagementSystemKeysActor*>(this)->actor_wait_state = 1;
															#line 65 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckManagementSystemKeysActor, 0, RangeResult >*>(static_cast<CheckManagementSystemKeysActor*>(this)));
															#line 132 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 71 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			if (static_cast<CheckManagementSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 156 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckManagementSystemKeysActor*>(this)->actor_wait_state = 2;
															#line 71 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckManagementSystemKeysActor, 1, Void >*>(static_cast<CheckManagementSystemKeysActor*>(this)));
															#line 161 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& systemTenantSubspaceKeys,int loopDepth) 
	{
															#line 68 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(systemTenantSubspaceKeys.size() == 1);
															#line 69 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!static_cast<CheckManagementSystemKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckManagementSystemKeysActorState(); static_cast<CheckManagementSystemKeysActor*>(this)->destroy(); return 0; }
															#line 178 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		new (&static_cast<CheckManagementSystemKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckManagementSystemKeysActorState();
		static_cast<CheckManagementSystemKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && systemTenantSubspaceKeys,int loopDepth) 
	{
															#line 68 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(systemTenantSubspaceKeys.size() == 1);
															#line 69 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!static_cast<CheckManagementSystemKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckManagementSystemKeysActorState(); static_cast<CheckManagementSystemKeysActor*>(this)->destroy(); return 0; }
															#line 192 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		new (&static_cast<CheckManagementSystemKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckManagementSystemKeysActorState();
		static_cast<CheckManagementSystemKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& systemTenantSubspaceKeys,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(systemTenantSubspaceKeys, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && systemTenantSubspaceKeys,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(systemTenantSubspaceKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckManagementSystemKeysActor*>(this)->actor_wait_state > 0) static_cast<CheckManagementSystemKeysActor*>(this)->actor_wait_state = 0;
		static_cast<CheckManagementSystemKeysActor*>(this)->ActorCallback< CheckManagementSystemKeysActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckManagementSystemKeysActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckManagementSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckManagementSystemKeysActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckManagementSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckManagementSystemKeysActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckManagementSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckManagementSystemKeysActor*>(this)->actor_wait_state > 0) static_cast<CheckManagementSystemKeysActor*>(this)->actor_wait_state = 0;
		static_cast<CheckManagementSystemKeysActor*>(this)->ActorCallback< CheckManagementSystemKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckManagementSystemKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckManagementSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckManagementSystemKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckManagementSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckManagementSystemKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckManagementSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	MetaclusterConsistencyCheck* self;
															#line 59 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 63 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	typename transaction_future_type<typename DB::TransactionT, RangeResult>::type systemTenantSubspaceKeysFuture;
															#line 368 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
};
// This generated class is to be used only via checkManagementSystemKeys()
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
class CheckManagementSystemKeysActor final : public Actor<Void>, public ActorCallback< CheckManagementSystemKeysActor, 0, RangeResult >, public ActorCallback< CheckManagementSystemKeysActor, 1, Void >, public FastAllocated<CheckManagementSystemKeysActor>, public CheckManagementSystemKeysActorState<CheckManagementSystemKeysActor> {
															#line 373 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
public:
	using FastAllocated<CheckManagementSystemKeysActor>::operator new;
	using FastAllocated<CheckManagementSystemKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11895273704421158656UL, 1620086569281825280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckManagementSystemKeysActor, 0, RangeResult >;
friend struct ActorCallback< CheckManagementSystemKeysActor, 1, Void >;
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	CheckManagementSystemKeysActor(MetaclusterConsistencyCheck* const& self) 
															#line 391 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		 : Actor<Void>(),
		   CheckManagementSystemKeysActorState<CheckManagementSystemKeysActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9938749004335930112UL, 7821699638485753856UL);
		ActorExecutionContextHelper __helper(static_cast<CheckManagementSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkManagementSystemKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkManagementSystemKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckManagementSystemKeysActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckManagementSystemKeysActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
[[nodiscard]] static Future<Void> checkManagementSystemKeys( MetaclusterConsistencyCheck* const& self ) {
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	return Future<Void>(new CheckManagementSystemKeysActor(self));
															#line 424 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
}

#line 75 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"

	void validateManagementCluster() {
		auto const& data = metaclusterData.managementMetadata;

		ASSERT(data.metaclusterRegistration.present());
		ASSERT_EQ(data.metaclusterRegistration.get().clusterType, ClusterType::METACLUSTER_MANAGEMENT);
		ASSERT(data.metaclusterRegistration.get().id == data.metaclusterRegistration.get().metaclusterId &&
		       data.metaclusterRegistration.get().name == data.metaclusterRegistration.get().metaclusterName);
		ASSERT_GE(data.metaclusterRegistration.get().version, MetaclusterVersion::MIN_SUPPORTED);
		ASSERT_LE(data.metaclusterRegistration.get().version, MetaclusterVersion::MAX_SUPPORTED);
		ASSERT(!data.maxRestoreId.present());

		ASSERT_LE(data.dataClusters.size(), CLIENT_KNOBS->MAX_DATA_CLUSTERS);
		ASSERT_LE(data.tenantData.tenantCount, metaclusterMaxTenants);
		ASSERT(data.clusterTenantCounts.results.size() <= data.dataClusters.size() && !data.clusterTenantCounts.more);
		ASSERT_EQ(data.tenantData.tenantMap.size(), data.tenantData.tenantCount);
		ASSERT_LE(data.tenantData.tenantGroupMap.size(), data.tenantData.tenantCount);
		ASSERT(data.tenantIdPrefix.present());
		ASSERT_LE(data.clusterAllocatedMap.size(), data.dataClusters.size());

		if (data.tenantData.lastTenantId != -1) {
			CODE_PROBE(true, "Validating last tenant ID");
			ASSERT(TenantAPI::getTenantIdPrefix(data.tenantData.lastTenantId) == data.tenantIdPrefix.get());
		}

		// Validate various properties for each data cluster
		int numFoundInAllocatedMap = 0;
		int numFoundInTenantGroupMap = 0;
		for (auto const& [clusterName, clusterMetadata] : data.dataClusters) {
			// If the cluster has capacity, it should be in the capacity index and have the correct count of
			// allocated tenants stored there.
			// If the cluster has disabled auto tenant assignment, then it mustn't exist in the capacity index.
			auto allocatedItr = data.clusterAllocatedMap.find(clusterName);
			if (!clusterMetadata.entry.hasCapacity() ||
			    clusterMetadata.entry.autoTenantAssignment == AutoTenantAssignment::DISABLED) {
				CODE_PROBE(!clusterMetadata.entry.hasCapacity(), "Checking cluster with no capacity");
				ASSERT(allocatedItr == data.clusterAllocatedMap.end());
			} else if (allocatedItr != data.clusterAllocatedMap.end()) {
				ASSERT_EQ(allocatedItr->second, clusterMetadata.entry.allocated.numTenantGroups);
				ASSERT_EQ(AutoTenantAssignment::ENABLED, clusterMetadata.entry.autoTenantAssignment);
				++numFoundInAllocatedMap;
			} else {
				CODE_PROBE(true, "Non-ready cluster missing from capacity index", probe::decoration::rare);
				ASSERT_NE(clusterMetadata.entry.clusterState, DataClusterState::READY);
			}

			// Check that the number of tenant groups in the cluster is smaller than the allocated number of tenant
			// groups.
			auto tenantGroupItr = data.clusterTenantGroupMap.find(clusterName);
			if (tenantGroupItr != data.clusterTenantGroupMap.end()) {
				ASSERT_LE(tenantGroupItr->second.size(), clusterMetadata.entry.allocated.numTenantGroups);
				++numFoundInTenantGroupMap;
			}
		}
		// Check that we exhausted the cluster capacity index and the cluster tenant group index
		ASSERT_EQ(numFoundInAllocatedMap, data.clusterAllocatedMap.size());
		ASSERT_EQ(numFoundInTenantGroupMap, data.clusterTenantGroupMap.size());

		// Check that our cluster tenant counters match the number of tenants in the cluster index
		std::map<ClusterName, int64_t> countsMap(data.clusterTenantCounts.results.begin(),
		                                         data.clusterTenantCounts.results.end());
		int64_t totalTenants = 0;
		for (auto const& [cluster, clusterTenants] : data.clusterTenantMap) {
			auto itr = countsMap.find(cluster);
			ASSERT((clusterTenants.empty() && itr == countsMap.end()) || itr->second == clusterTenants.size());
			totalTenants += clusterTenants.size();
		}
		ASSERT_EQ(totalTenants, data.tenantData.tenantCount);

		// Iterate through all tenants and verify related metadata
		std::map<ClusterName, int> clusterAllocated;
		std::set<TenantGroupName> processedTenantGroups;
		for (auto const& [tenantId, entry] : data.tenantData.tenantMap) {
			// Each tenant should be assigned to the same cluster where it is stored in the cluster tenant index
			auto clusterItr = data.clusterTenantMap.find(entry.assignedCluster);
			ASSERT(clusterItr != data.clusterTenantMap.end());
			ASSERT(clusterItr->second.count(tenantId));

			if (entry.tenantGroup.present()) {
				// Count the number of tenant groups allocated in each cluster
				if (processedTenantGroups.insert(entry.tenantGroup.get()).second) {
					++clusterAllocated[entry.assignedCluster];
				}
				// The tenant group should be stored in the same cluster where it is stored in the cluster tenant
				// group index
				auto clusterTenantGroupItr = data.clusterTenantGroupMap.find(entry.assignedCluster);
				ASSERT(clusterTenantGroupItr != data.clusterTenantGroupMap.end());
				ASSERT(clusterTenantGroupItr->second.count(entry.tenantGroup.get()));
			} else {
				// Track the actual tenant group allocation per cluster (a tenant with no group counts against the
				// allocation)
				CODE_PROBE(true, "Counting ungrouped tenant");
				++clusterAllocated[entry.assignedCluster];
			}
		}

		// The actual allocation for each cluster should match what is stored in the cluster metadata
		for (auto const& [name, allocated] : clusterAllocated) {
			auto itr = data.dataClusters.find(name);
			ASSERT(itr != data.dataClusters.end());
			ASSERT_EQ(allocated, itr->second.entry.allocated.numTenantGroups);
		}

		// Each tenant group in the tenant group map should be present in the cluster tenant group map
		// and have the correct cluster assigned to it.
		for (auto const& [name, entry] : data.tenantData.tenantGroupMap) {
			auto clusterItr = data.clusterTenantGroupMap.find(entry.assignedCluster);
			ASSERT(clusterItr->second.count(name));
		}

		// The cluster tenant group map should have the same number of tenant groups as the full tenant group map
		int totalTenantGroups = 0;
		for (auto const& [_, groups] : data.clusterTenantGroupMap) {
			totalTenantGroups += groups.size();
		}
		ASSERT_EQ(totalTenantGroups, data.tenantData.tenantGroupMap.size());
	}

																#line 546 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
// This generated class is to be used only via validateDataCluster()
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
template <class ValidateDataClusterActor>
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
class ValidateDataClusterActorState {
															#line 552 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
public:
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	ValidateDataClusterActorState(MetaclusterConsistencyCheck* const& self,ClusterName const& clusterName,DataClusterMetadata const& clusterMetadata) 
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		 : self(self),
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		   clusterName(clusterName),
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		   clusterMetadata(clusterMetadata)
															#line 563 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
	{
		fdb_probe_actor_create("validateDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~ValidateDataClusterActorState() 
	{
		fdb_probe_actor_destroy("validateDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 197 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				StrictFuture<Reference<IDatabase>> __when_expr_0 = openDatabase(clusterMetadata.connectionString);
															#line 197 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				if (static_cast<ValidateDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 581 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ValidateDataClusterActor*>(this)->actor_wait_state = 1;
															#line 197 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateDataClusterActor, 0, Reference<IDatabase> >*>(static_cast<ValidateDataClusterActor*>(this)));
															#line 586 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateDataClusterActorState();
		static_cast<ValidateDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 311 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!static_cast<ValidateDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateDataClusterActorState(); static_cast<ValidateDataClusterActor*>(this)->destroy(); return 0; }
															#line 615 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		new (&static_cast<ValidateDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateDataClusterActorState();
		static_cast<ValidateDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 305 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			TraceEvent(SevError, "MetaclusterConsistencyDataClusterValidationFailed") .error(e) .detail("ClusterName", clusterName);
															#line 308 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(false);
															#line 630 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 198 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		tenantConsistencyCheck = TenantConsistencyCheck<IDatabase, StandardTenantTypes>(dataDb, &TenantMetadata::instance());
															#line 200 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		StrictFuture<Void> __when_expr_1 = tenantConsistencyCheck.run();
															#line 200 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (static_cast<ValidateDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 649 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateDataClusterActor*>(this)->actor_wait_state = 2;
															#line 200 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateDataClusterActor, 1, Void >*>(static_cast<ValidateDataClusterActor*>(this)));
															#line 654 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> const& __dataDb,int loopDepth) 
	{
															#line 197 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		dataDb = __dataDb;
															#line 663 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IDatabase> && __dataDb,int loopDepth) 
	{
		dataDb = std::move(__dataDb);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ValidateDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDataClusterActor*>(this)->ActorCallback< ValidateDataClusterActor, 0, Reference<IDatabase> >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDataClusterActor, 0, Reference<IDatabase> >*,Reference<IDatabase> const& value) 
	{
		fdb_probe_actor_enter("validateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateDataClusterActor, 0, Reference<IDatabase> >*,Reference<IDatabase> && value) 
	{
		fdb_probe_actor_enter("validateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateDataClusterActor, 0, Reference<IDatabase> >*,Error err) 
	{
		fdb_probe_actor_enter("validateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto dataClusterItr = self->metaclusterData.dataClusterMetadata.find(clusterName);
															#line 203 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(dataClusterItr != self->metaclusterData.dataClusterMetadata.end());
															#line 204 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto const& data = dataClusterItr->second;
															#line 205 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto const& managementData = self->metaclusterData.managementMetadata;
															#line 207 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(data.metaclusterRegistration.present());
															#line 208 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT_EQ(data.metaclusterRegistration.get().clusterType, ClusterType::METACLUSTER_DATA);
															#line 209 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(data.metaclusterRegistration.get().matches(managementData.metaclusterRegistration.get()));
															#line 210 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(data.metaclusterRegistration.get().name == clusterName);
															#line 211 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(data.metaclusterRegistration.get().id == clusterMetadata.entry.id);
															#line 212 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT_GE(data.metaclusterRegistration.get().version, MetaclusterVersion::MIN_SUPPORTED);
															#line 213 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT_LE(data.metaclusterRegistration.get().version, MetaclusterVersion::MAX_SUPPORTED);
															#line 214 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT_EQ(data.metaclusterRegistration.get().version, managementData.metaclusterRegistration.get().version);
															#line 216 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (data.tenantData.lastTenantId >= 0)
															#line 766 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 217 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_EQ(TenantAPI::getTenantIdPrefix(data.tenantData.lastTenantId), managementData.tenantIdPrefix.get());
															#line 219 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_LE(data.tenantData.lastTenantId, managementData.tenantData.lastTenantId);
															#line 772 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
		else
		{
															#line 221 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			CODE_PROBE(true, "Data cluster has no tenants with current tenant ID prefix");
															#line 222 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			for( auto const& [id, tenant] : data.tenantData.tenantMap ) {
															#line 223 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_NE(TenantAPI::getTenantIdPrefix(id), managementData.tenantIdPrefix.get());
															#line 782 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
		}
															#line 227 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		std::set<int64_t> expectedTenants;
															#line 228 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto clusterTenantMapItr = managementData.clusterTenantMap.find(clusterName);
															#line 229 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (clusterTenantMapItr != managementData.clusterTenantMap.end())
															#line 791 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 230 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			expectedTenants = clusterTenantMapItr->second;
															#line 795 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
															#line 233 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		std::set<TenantGroupName> tenantGroupsWithCompletedTenants;
															#line 234 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!self->allowPartialMetaclusterOperations)
															#line 801 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 235 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_EQ(data.tenantData.tenantMap.size(), expectedTenants.size());
															#line 805 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
		else
		{
															#line 237 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_LE(data.tenantData.tenantMap.size(), expectedTenants.size());
															#line 238 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			for( auto const& tenantId : expectedTenants ) {
															#line 239 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				auto tenantMapItr = managementData.tenantData.tenantMap.find(tenantId);
															#line 240 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT(tenantMapItr != managementData.tenantData.tenantMap.end());
															#line 241 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				MetaclusterTenantMapEntry const& metaclusterEntry = tenantMapItr->second;
															#line 242 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				if (!data.tenantData.tenantMap.count(tenantId))
															#line 821 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				{
															#line 243 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					ASSERT(metaclusterEntry.tenantState == TenantState::REGISTERING || metaclusterEntry.tenantState == TenantState::REMOVING || metaclusterEntry.tenantState == TenantState::ERROR);
															#line 825 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				}
				else
				{
															#line 246 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					if (metaclusterEntry.tenantGroup.present())
															#line 831 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
					{
															#line 247 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
						tenantGroupsWithCompletedTenants.insert(metaclusterEntry.tenantGroup.get());
															#line 835 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
					}
				}
			}
		}
															#line 252 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		for( auto const& [tenantId, entry] : data.tenantData.tenantMap ) {
															#line 253 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(expectedTenants.count(tenantId));
															#line 254 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			auto tenantMapItr = managementData.tenantData.tenantMap.find(tenantId);
															#line 255 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(tenantMapItr != managementData.tenantData.tenantMap.end());
															#line 256 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			MetaclusterTenantMapEntry const& metaclusterEntry = tenantMapItr->second;
															#line 257 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_EQ(entry.id, metaclusterEntry.id);
															#line 259 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			if (!self->allowPartialMetaclusterOperations)
															#line 854 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			{
															#line 260 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_EQ(metaclusterEntry.tenantState, TenantState::READY);
															#line 261 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT(entry.tenantName == metaclusterEntry.tenantName);
															#line 860 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
			else
			{
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				if (entry.tenantName != metaclusterEntry.tenantName)
															#line 866 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				{
															#line 263 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					ASSERT(metaclusterEntry.renameDestination.present() && entry.tenantName == metaclusterEntry.renameDestination.get());
															#line 870 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				}
			}
															#line 266 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			if (metaclusterEntry.tenantState != TenantState::UPDATING_CONFIGURATION && metaclusterEntry.tenantState != TenantState::REMOVING)
															#line 875 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			{
															#line 268 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_EQ(entry.configurationSequenceNum, metaclusterEntry.configurationSequenceNum);
															#line 879 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
			else
			{
															#line 270 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_LE(entry.configurationSequenceNum, metaclusterEntry.configurationSequenceNum);
															#line 885 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
															#line 273 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			if (entry.configurationSequenceNum == metaclusterEntry.configurationSequenceNum)
															#line 889 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			{
															#line 274 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT(entry.tenantGroup == metaclusterEntry.tenantGroup);
															#line 275 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_EQ(entry.tenantLockState, metaclusterEntry.tenantLockState);
															#line 276 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT(entry.tenantLockId == metaclusterEntry.tenantLockId);
															#line 897 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
		}
															#line 280 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		std::set<TenantGroupName> expectedTenantGroups;
															#line 281 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto clusterTenantGroupItr = managementData.clusterTenantGroupMap.find(clusterName);
															#line 282 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (clusterTenantGroupItr != managementData.clusterTenantGroupMap.end())
															#line 906 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 283 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			expectedTenantGroups = clusterTenantGroupItr->second;
															#line 910 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
															#line 285 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!self->allowPartialMetaclusterOperations)
															#line 914 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 286 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_EQ(data.tenantData.tenantGroupMap.size(), expectedTenantGroups.size());
															#line 918 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
		else
		{
															#line 288 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_LE(data.tenantData.tenantGroupMap.size(), expectedTenantGroups.size());
															#line 289 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			for( auto const& name : expectedTenantGroups ) {
															#line 290 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				if (!data.tenantData.tenantGroupMap.count(name))
															#line 928 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				{
															#line 291 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					auto itr = tenantGroupsWithCompletedTenants.find(name);
															#line 292 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					ASSERT(itr == tenantGroupsWithCompletedTenants.end());
															#line 934 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				}
			}
		}
															#line 296 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		for( auto const& [name, entry] : data.tenantData.tenantGroupMap ) {
															#line 297 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(expectedTenantGroups.count(name));
															#line 298 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			expectedTenantGroups.erase(name);
															#line 944 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
															#line 301 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		for( auto const& name : expectedTenantGroups ) {
															#line 302 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(tenantGroupsWithCompletedTenants.count(name) == 0);
															#line 950 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
		loopDepth = a_body1cont29(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto dataClusterItr = self->metaclusterData.dataClusterMetadata.find(clusterName);
															#line 203 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(dataClusterItr != self->metaclusterData.dataClusterMetadata.end());
															#line 204 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto const& data = dataClusterItr->second;
															#line 205 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto const& managementData = self->metaclusterData.managementMetadata;
															#line 207 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(data.metaclusterRegistration.present());
															#line 208 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT_EQ(data.metaclusterRegistration.get().clusterType, ClusterType::METACLUSTER_DATA);
															#line 209 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(data.metaclusterRegistration.get().matches(managementData.metaclusterRegistration.get()));
															#line 210 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(data.metaclusterRegistration.get().name == clusterName);
															#line 211 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT(data.metaclusterRegistration.get().id == clusterMetadata.entry.id);
															#line 212 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT_GE(data.metaclusterRegistration.get().version, MetaclusterVersion::MIN_SUPPORTED);
															#line 213 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT_LE(data.metaclusterRegistration.get().version, MetaclusterVersion::MAX_SUPPORTED);
															#line 214 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		ASSERT_EQ(data.metaclusterRegistration.get().version, managementData.metaclusterRegistration.get().version);
															#line 216 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (data.tenantData.lastTenantId >= 0)
															#line 984 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 217 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_EQ(TenantAPI::getTenantIdPrefix(data.tenantData.lastTenantId), managementData.tenantIdPrefix.get());
															#line 219 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_LE(data.tenantData.lastTenantId, managementData.tenantData.lastTenantId);
															#line 990 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
		else
		{
															#line 221 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			CODE_PROBE(true, "Data cluster has no tenants with current tenant ID prefix");
															#line 222 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			for( auto const& [id, tenant] : data.tenantData.tenantMap ) {
															#line 223 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_NE(TenantAPI::getTenantIdPrefix(id), managementData.tenantIdPrefix.get());
															#line 1000 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
		}
															#line 227 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		std::set<int64_t> expectedTenants;
															#line 228 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto clusterTenantMapItr = managementData.clusterTenantMap.find(clusterName);
															#line 229 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (clusterTenantMapItr != managementData.clusterTenantMap.end())
															#line 1009 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 230 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			expectedTenants = clusterTenantMapItr->second;
															#line 1013 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
															#line 233 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		std::set<TenantGroupName> tenantGroupsWithCompletedTenants;
															#line 234 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!self->allowPartialMetaclusterOperations)
															#line 1019 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 235 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_EQ(data.tenantData.tenantMap.size(), expectedTenants.size());
															#line 1023 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
		else
		{
															#line 237 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_LE(data.tenantData.tenantMap.size(), expectedTenants.size());
															#line 238 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			for( auto const& tenantId : expectedTenants ) {
															#line 239 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				auto tenantMapItr = managementData.tenantData.tenantMap.find(tenantId);
															#line 240 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT(tenantMapItr != managementData.tenantData.tenantMap.end());
															#line 241 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				MetaclusterTenantMapEntry const& metaclusterEntry = tenantMapItr->second;
															#line 242 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				if (!data.tenantData.tenantMap.count(tenantId))
															#line 1039 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				{
															#line 243 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					ASSERT(metaclusterEntry.tenantState == TenantState::REGISTERING || metaclusterEntry.tenantState == TenantState::REMOVING || metaclusterEntry.tenantState == TenantState::ERROR);
															#line 1043 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				}
				else
				{
															#line 246 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					if (metaclusterEntry.tenantGroup.present())
															#line 1049 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
					{
															#line 247 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
						tenantGroupsWithCompletedTenants.insert(metaclusterEntry.tenantGroup.get());
															#line 1053 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
					}
				}
			}
		}
															#line 252 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		for( auto const& [tenantId, entry] : data.tenantData.tenantMap ) {
															#line 253 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(expectedTenants.count(tenantId));
															#line 254 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			auto tenantMapItr = managementData.tenantData.tenantMap.find(tenantId);
															#line 255 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(tenantMapItr != managementData.tenantData.tenantMap.end());
															#line 256 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			MetaclusterTenantMapEntry const& metaclusterEntry = tenantMapItr->second;
															#line 257 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_EQ(entry.id, metaclusterEntry.id);
															#line 259 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			if (!self->allowPartialMetaclusterOperations)
															#line 1072 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			{
															#line 260 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_EQ(metaclusterEntry.tenantState, TenantState::READY);
															#line 261 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT(entry.tenantName == metaclusterEntry.tenantName);
															#line 1078 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
			else
			{
															#line 262 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				if (entry.tenantName != metaclusterEntry.tenantName)
															#line 1084 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				{
															#line 263 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					ASSERT(metaclusterEntry.renameDestination.present() && entry.tenantName == metaclusterEntry.renameDestination.get());
															#line 1088 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				}
			}
															#line 266 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			if (metaclusterEntry.tenantState != TenantState::UPDATING_CONFIGURATION && metaclusterEntry.tenantState != TenantState::REMOVING)
															#line 1093 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			{
															#line 268 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_EQ(entry.configurationSequenceNum, metaclusterEntry.configurationSequenceNum);
															#line 1097 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
			else
			{
															#line 270 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_LE(entry.configurationSequenceNum, metaclusterEntry.configurationSequenceNum);
															#line 1103 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
															#line 273 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			if (entry.configurationSequenceNum == metaclusterEntry.configurationSequenceNum)
															#line 1107 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			{
															#line 274 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT(entry.tenantGroup == metaclusterEntry.tenantGroup);
															#line 275 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT_EQ(entry.tenantLockState, metaclusterEntry.tenantLockState);
															#line 276 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				ASSERT(entry.tenantLockId == metaclusterEntry.tenantLockId);
															#line 1115 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			}
		}
															#line 280 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		std::set<TenantGroupName> expectedTenantGroups;
															#line 281 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		auto clusterTenantGroupItr = managementData.clusterTenantGroupMap.find(clusterName);
															#line 282 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (clusterTenantGroupItr != managementData.clusterTenantGroupMap.end())
															#line 1124 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 283 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			expectedTenantGroups = clusterTenantGroupItr->second;
															#line 1128 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
															#line 285 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!self->allowPartialMetaclusterOperations)
															#line 1132 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		{
															#line 286 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_EQ(data.tenantData.tenantGroupMap.size(), expectedTenantGroups.size());
															#line 1136 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
		else
		{
															#line 288 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT_LE(data.tenantData.tenantGroupMap.size(), expectedTenantGroups.size());
															#line 289 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			for( auto const& name : expectedTenantGroups ) {
															#line 290 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				if (!data.tenantData.tenantGroupMap.count(name))
															#line 1146 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				{
															#line 291 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					auto itr = tenantGroupsWithCompletedTenants.find(name);
															#line 292 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
					ASSERT(itr == tenantGroupsWithCompletedTenants.end());
															#line 1152 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				}
			}
		}
															#line 296 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		for( auto const& [name, entry] : data.tenantData.tenantGroupMap ) {
															#line 297 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(expectedTenantGroups.count(name));
															#line 298 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			expectedTenantGroups.erase(name);
															#line 1162 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
															#line 301 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		for( auto const& name : expectedTenantGroups ) {
															#line 302 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(tenantGroupsWithCompletedTenants.count(name) == 0);
															#line 1168 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
		loopDepth = a_body1cont29(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ValidateDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateDataClusterActor*>(this)->ActorCallback< ValidateDataClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateDataClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("validateDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateDataClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("validateDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateDataClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("validateDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validateDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont29(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	MetaclusterConsistencyCheck* self;
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	ClusterName clusterName;
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	DataClusterMetadata clusterMetadata;
															#line 197 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	Reference<IDatabase> dataDb;
															#line 198 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	TenantConsistencyCheck<IDatabase, StandardTenantTypes> tenantConsistencyCheck;
															#line 1272 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
};
// This generated class is to be used only via validateDataCluster()
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
class ValidateDataClusterActor final : public Actor<Void>, public ActorCallback< ValidateDataClusterActor, 0, Reference<IDatabase> >, public ActorCallback< ValidateDataClusterActor, 1, Void >, public FastAllocated<ValidateDataClusterActor>, public ValidateDataClusterActorState<ValidateDataClusterActor> {
															#line 1277 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
public:
	using FastAllocated<ValidateDataClusterActor>::operator new;
	using FastAllocated<ValidateDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13122619403347215360UL, 9317548146231900672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateDataClusterActor, 0, Reference<IDatabase> >;
friend struct ActorCallback< ValidateDataClusterActor, 1, Void >;
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	ValidateDataClusterActor(MetaclusterConsistencyCheck* const& self,ClusterName const& clusterName,DataClusterMetadata const& clusterMetadata) 
															#line 1295 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		 : Actor<Void>(),
		   ValidateDataClusterActorState<ValidateDataClusterActor>(self, clusterName, clusterMetadata),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validateDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11935325907290913280UL, 3988857646871575552UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validateDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validateDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateDataClusterActor, 0, Reference<IDatabase> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateDataClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
[[nodiscard]] static Future<Void> validateDataCluster( MetaclusterConsistencyCheck* const& self, ClusterName const& clusterName, DataClusterMetadata const& clusterMetadata ) {
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	return Future<Void>(new ValidateDataClusterActor(self, clusterName, clusterMetadata));
															#line 1328 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
}

#line 313 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"

																#line 1333 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
// This generated class is to be used only via run()
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
template <class RunActor>
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
class RunActorState {
															#line 1339 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
public:
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	RunActorState(MetaclusterConsistencyCheck* const& self) 
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		 : self(self),
															#line 315 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		   managementTenantConsistencyCheck(self->managementDb, &metadata::management::tenantMetadata())
															#line 1348 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 319 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				StrictFuture<Void> __when_expr_0 = managementTenantConsistencyCheck.run() && self->metaclusterData.load() && checkManagementSystemKeys(self);
															#line 319 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1366 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 319 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 1371 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 326 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		self->validateManagementCluster();
															#line 328 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		dataClusterChecks = std::vector<Future<Void>>();
															#line 329 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		dataClusterItr = std::map<ClusterName, DataClusterMetadata>::iterator();
															#line 330 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		for( auto const& [clusterName, clusterMetadata] : self->metaclusterData.managementMetadata.dataClusters ) {
															#line 331 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			dataClusterChecks.push_back(validateDataCluster(self, clusterName, clusterMetadata));
															#line 1408 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		}
															#line 333 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(dataClusterChecks);
															#line 333 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1414 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 333 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 1419 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 322 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			TraceEvent(SevError, "MetaclusterConsistencyManagementClusterValidationFailed").error(e);
															#line 323 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
			ASSERT(false);
															#line 1431 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 335 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 1546 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 335 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 1558 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	MetaclusterConsistencyCheck* self;
															#line 315 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	TenantConsistencyCheck<DB, MetaclusterTenantTypes> managementTenantConsistencyCheck;
															#line 328 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	std::vector<Future<Void>> dataClusterChecks;
															#line 329 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	std::map<ClusterName, DataClusterMetadata>::iterator dataClusterItr;
															#line 1649 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
};
// This generated class is to be used only via run()
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorCallback< RunActor, 1, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 1654 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12884986623785787136UL, 9887371461582773504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorCallback< RunActor, 1, Void >;
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	RunActor(MetaclusterConsistencyCheck* const& self) 
															#line 1672 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
[[nodiscard]] static Future<Void> run( MetaclusterConsistencyCheck* const& self ) {
															#line 314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"
	return Future<Void>(new RunActor(self));
															#line 1705 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterConsistency.actor.g.h"
}

#line 337 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterConsistency.actor.h"

public:
	MetaclusterConsistencyCheck() {}
	MetaclusterConsistencyCheck(Reference<DB> managementDb,
	                            AllowPartialMetaclusterOperations allowPartialMetaclusterOperations)
	  : managementDb(managementDb), metaclusterData(managementDb),
	    allowPartialMetaclusterOperations(allowPartialMetaclusterOperations) {}

	Future<Void> run() { return run(this); }
};
} // namespace metacluster::util

#include "flow/unactorcompiler.h"

#endif
