#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
/*
 * RangeConfigCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>
#include <algorithm>
#include <boost/lexical_cast/bad_lexical_cast.hpp>
#include <list>

#include "fdbcli/fdbcli.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/DataDistributionConfig.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 36 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
// This generated class is to be used only via rangeConfigCommandActor()
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
template <class RangeConfigCommandActorActor>
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
class RangeConfigCommandActorActorState {
															#line 42 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
public:
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	RangeConfigCommandActorActorState(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		 : cx(cx),
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		   tokens(tokens),
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		   fail([&](std::string msg) { if (!msg.empty()) { fmt::print(stderr, "ERROR: {}\n", msg); } printUsage(tokens[0]); return false; }),
															#line 43 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		   args(tokens.begin() + 1, tokens.end()),
															#line 44 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		   nextArg([&]() { ASSERT(!args.empty()); auto s = args.front(); args.pop_front(); return s; }),
															#line 50 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		   nextArgInt([&]() { if (args.empty()) { throw boost::bad_lexical_cast(); } return boost::lexical_cast<int>(nextArg().toString()); })
															#line 59 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~RangeConfigCommandActorActorState() 
	{
		fdb_probe_actor_destroy("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 57 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
			if (args.size() < 1)
															#line 74 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
			{
															#line 58 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				if (!static_cast<RangeConfigCommandActorActor*>(this)->SAV<bool>::futures) { (void)(fail("No subcommand given.")); this->~RangeConfigCommandActorActorState(); static_cast<RangeConfigCommandActorActor*>(this)->destroy(); return 0; }
															#line 78 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
				new (&static_cast<RangeConfigCommandActorActor*>(this)->SAV< bool >::value()) bool(fail("No subcommand given."));
				this->~RangeConfigCommandActorActorState();
				static_cast<RangeConfigCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 61 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
			cmd = nextArg();
															#line 63 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
			if (cmd == "show"_sr)
															#line 88 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
			{
															#line 64 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				includeDefault = false;
															#line 66 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				for(;!args.empty();) {
															#line 67 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					auto arg = nextArg();
															#line 68 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					if (arg == "includeDefault"_sr)
															#line 98 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
					{
															#line 69 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
						includeDefault = true;
															#line 102 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
					}
					else
					{
															#line 71 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
						if (!static_cast<RangeConfigCommandActorActor*>(this)->SAV<bool>::futures) { (void)(fail(fmt::format("Unknown argument: '{}'", arg.printable()))); this->~RangeConfigCommandActorActorState(); static_cast<RangeConfigCommandActorActor*>(this)->destroy(); return 0; }
															#line 108 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
						new (&static_cast<RangeConfigCommandActorActor*>(this)->SAV< bool >::value()) bool(fail(fmt::format("Unknown argument: '{}'", arg.printable())));
						this->~RangeConfigCommandActorActorState();
						static_cast<RangeConfigCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 75 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				StrictFuture<Reference<DDConfiguration::RangeConfigMapSnapshot>> __when_expr_0 = DDConfiguration().userRangeConfig().getSnapshot( SystemDBWriteLockedNow(cx.getReference()), allKeys.begin, allKeys.end);
															#line 75 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				if (static_cast<RangeConfigCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 119 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RangeConfigCommandActorActor*>(this)->actor_wait_state = 1;
															#line 75 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RangeConfigCommandActorActor, 0, Reference<DDConfiguration::RangeConfigMapSnapshot> >*>(static_cast<RangeConfigCommandActorActor*>(this)));
															#line 124 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				if (cmd == "update"_sr || cmd == "set"_sr)
															#line 131 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
				{
															#line 83 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					if (args.size() < 3)
															#line 135 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
					{
															#line 84 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
						if (!static_cast<RangeConfigCommandActorActor*>(this)->SAV<bool>::futures) { (void)(fail("Begin, end, and at least one configuration option are required.")); this->~RangeConfigCommandActorActorState(); static_cast<RangeConfigCommandActorActor*>(this)->destroy(); return 0; }
															#line 139 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
						new (&static_cast<RangeConfigCommandActorActor*>(this)->SAV< bool >::value()) bool(fail("Begin, end, and at least one configuration option are required."));
						this->~RangeConfigCommandActorActorState();
						static_cast<RangeConfigCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 87 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					begin = nextArg();
															#line 88 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					end = nextArg();
															#line 89 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					if (end <= begin)
															#line 151 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
					{
															#line 90 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
						if (!static_cast<RangeConfigCommandActorActor*>(this)->SAV<bool>::futures) { (void)(fail("Range end must be > range begin.")); this->~RangeConfigCommandActorActorState(); static_cast<RangeConfigCommandActorActor*>(this)->destroy(); return 0; }
															#line 155 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
						new (&static_cast<RangeConfigCommandActorActor*>(this)->SAV< bool >::value()) bool(fail("Range end must be > range begin."));
						this->~RangeConfigCommandActorActorState();
						static_cast<RangeConfigCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					rangeConfig = DDRangeConfig();
															#line 95 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					;
															#line 165 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
					loopDepth = a_body1loopHead1(loopDepth);
				}
				else
				{
															#line 117 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					if (!static_cast<RangeConfigCommandActorActor*>(this)->SAV<bool>::futures) { (void)(fail(fmt::format("Unknown command: '{}'", cmd.printable()))); this->~RangeConfigCommandActorActorState(); static_cast<RangeConfigCommandActorActor*>(this)->destroy(); return 0; }
															#line 172 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
					new (&static_cast<RangeConfigCommandActorActor*>(this)->SAV< bool >::value()) bool(fail(fmt::format("Unknown command: '{}'", cmd.printable())));
					this->~RangeConfigCommandActorActorState();
					static_cast<RangeConfigCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RangeConfigCommandActorActorState();
		static_cast<RangeConfigCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 120 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		if (!static_cast<RangeConfigCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~RangeConfigCommandActorActorState(); static_cast<RangeConfigCommandActorActor*>(this)->destroy(); return 0; }
															#line 200 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
		new (&static_cast<RangeConfigCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~RangeConfigCommandActorActorState();
		static_cast<RangeConfigCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Reference<DDConfiguration::RangeConfigMapSnapshot> const& config,int loopDepth) 
	{
															#line 78 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		fmt::print( "{}\n", json_spirit::write_string(DDConfiguration::toJSON(*config, includeDefault), json_spirit::pretty_print));
															#line 212 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Reference<DDConfiguration::RangeConfigMapSnapshot> && config,int loopDepth) 
	{
															#line 78 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		fmt::print( "{}\n", json_spirit::write_string(DDConfiguration::toJSON(*config, includeDefault), json_spirit::pretty_print));
															#line 221 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<DDConfiguration::RangeConfigMapSnapshot> const& config,int loopDepth) 
	{
		loopDepth = a_body1cont3(config, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<DDConfiguration::RangeConfigMapSnapshot> && config,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(config), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RangeConfigCommandActorActor*>(this)->actor_wait_state > 0) static_cast<RangeConfigCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<RangeConfigCommandActorActor*>(this)->ActorCallback< RangeConfigCommandActorActor, 0, Reference<DDConfiguration::RangeConfigMapSnapshot> >::remove();

	}
	void a_callback_fire(ActorCallback< RangeConfigCommandActorActor, 0, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Reference<DDConfiguration::RangeConfigMapSnapshot> const& value) 
	{
		fdb_probe_actor_enter("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangeConfigCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RangeConfigCommandActorActor, 0, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Reference<DDConfiguration::RangeConfigMapSnapshot> && value) 
	{
		fdb_probe_actor_enter("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangeConfigCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RangeConfigCommandActorActor, 0, Reference<DDConfiguration::RangeConfigMapSnapshot> >*,Error err) 
	{
		fdb_probe_actor_enter("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangeConfigCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 95 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		if (!(!args.empty()))
															#line 324 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 96 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		option = nextArg();
															#line 330 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
		try {
															#line 99 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
			if (option == "replication"_sr)
															#line 334 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
			{
															#line 100 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				rangeConfig.replicationFactor = nextArgInt();
															#line 338 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
			}
			else
			{
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
				if (option == "teamID"_sr)
															#line 344 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
				{
															#line 102 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					rangeConfig.teamID = nextArgInt();
															#line 348 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
				}
				else
				{
															#line 103 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
					if (option == "default"_sr)
															#line 354 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
					{
															#line 104 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
						rangeConfig = DDRangeConfig();
															#line 358 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
					}
					else
					{
															#line 106 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
						if (!static_cast<RangeConfigCommandActorActor*>(this)->SAV<bool>::futures) { (void)(fail(fmt::format("Unknown range option: '{}'", option.printable()))); this->~RangeConfigCommandActorActorState(); static_cast<RangeConfigCommandActorActor*>(this)->destroy(); return 0; }
															#line 364 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
						new (&static_cast<RangeConfigCommandActorActor*>(this)->SAV< bool >::value()) bool(fail(fmt::format("Unknown range option: '{}'", option.printable())));
						this->~RangeConfigCommandActorActorState();
						static_cast<RangeConfigCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
			loopDepth = a_body1loopBody1cont10(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 113 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = DDConfiguration().userRangeConfig().updateRange( SystemDBWriteLockedNow(cx.getReference()), begin, end, rangeConfig, cmd == "set"_sr);
															#line 113 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		if (static_cast<RangeConfigCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 401 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RangeConfigCommandActorActor*>(this)->actor_wait_state = 2;
															#line 113 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RangeConfigCommandActorActor, 1, Void >*>(static_cast<RangeConfigCommandActorActor*>(this)));
															#line 406 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
			if (!static_cast<RangeConfigCommandActorActor*>(this)->SAV<bool>::futures) { (void)(fail( fmt::format("Required argument for range option '{}' missing or invalid.", option.toString()))); this->~RangeConfigCommandActorActorState(); static_cast<RangeConfigCommandActorActor*>(this)->destroy(); return 0; }
															#line 416 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
			new (&static_cast<RangeConfigCommandActorActor*>(this)->SAV< bool >::value()) bool(fail( fmt::format("Required argument for range option '{}' missing or invalid.", option.toString())));
			this->~RangeConfigCommandActorActorState();
			static_cast<RangeConfigCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RangeConfigCommandActorActor*>(this)->actor_wait_state > 0) static_cast<RangeConfigCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<RangeConfigCommandActorActor*>(this)->ActorCallback< RangeConfigCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RangeConfigCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangeConfigCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RangeConfigCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RangeConfigCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RangeConfigCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RangeConfigCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	Database cx;
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	std::function<bool(std::string)> fail;
															#line 43 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	std::list<StringRef> args;
															#line 44 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	std::function<StringRef()> nextArg;
															#line 50 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	std::function<int()> nextArgInt;
															#line 61 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	StringRef cmd;
															#line 64 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	bool includeDefault;
															#line 87 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	KeyRef begin;
															#line 88 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	KeyRef end;
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	DDRangeConfig rangeConfig;
															#line 96 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	StringRef option;
															#line 554 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
};
// This generated class is to be used only via rangeConfigCommandActor()
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
class RangeConfigCommandActorActor final : public Actor<bool>, public ActorCallback< RangeConfigCommandActorActor, 0, Reference<DDConfiguration::RangeConfigMapSnapshot> >, public ActorCallback< RangeConfigCommandActorActor, 1, Void >, public FastAllocated<RangeConfigCommandActorActor>, public RangeConfigCommandActorActorState<RangeConfigCommandActorActor> {
															#line 559 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
public:
	using FastAllocated<RangeConfigCommandActorActor>::operator new;
	using FastAllocated<RangeConfigCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11365624382881339136UL, 4277393705386320384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RangeConfigCommandActorActor, 0, Reference<DDConfiguration::RangeConfigMapSnapshot> >;
friend struct ActorCallback< RangeConfigCommandActorActor, 1, Void >;
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	RangeConfigCommandActorActor(Database const& cx,std::vector<StringRef> const& tokens) 
															#line 577 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
		 : Actor<bool>(),
		   RangeConfigCommandActorActorState<RangeConfigCommandActorActor>(cx, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12675754758142288384UL, 676202352540060928UL);
		ActorExecutionContextHelper __helper(static_cast<RangeConfigCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("rangeConfigCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("rangeConfigCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RangeConfigCommandActorActor, 0, Reference<DDConfiguration::RangeConfigMapSnapshot> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RangeConfigCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
[[nodiscard]] Future<bool> rangeConfigCommandActor( Database const& cx, std::vector<StringRef> const& tokens ) {
															#line 34 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"
	return Future<bool>(new RangeConfigCommandActorActor(cx, tokens));
															#line 610 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/RangeConfigCommand.actor.g.cpp"
}

#line 122 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/RangeConfigCommand.actor.cpp"

std::vector<const char*> rangeConfigGenerator(std::vector<StringRef> const& tokens, bool inArgument) {
	if (tokens.size() == 1) {
		return { "<show|set|update>", "[ARGS]" };
	}
	auto cmd = tokens[1];
	if (cmd == "show"_sr && tokens.size() == 2) {
		return { "[includeDefault]" };
	} else if (cmd == "set"_sr || cmd == "update"_sr) {
		static std::vector<const char*> opts = {
			"<BEGINKEY>", "<ENDKEY>", "[default]", "[replication <N>]", "[teamID <N>]"
		};
		// Subtract the two known tokens, command and subcommand, and then possibly two more tokens for begin and end if
		// present
		return std::vector<const char*>(opts.begin() + std::min<size_t>(tokens.size(), 4) - 2, opts.end());
	} else {
		return {};
	}
}

CommandFactory rangeConfigFactory(
    "rangeconfig",
    CommandHelp(
        "rangeconfig <show> [includeDefault] | <update|set> <BEGINKEY> <ENDKEY> [default] [replication <N>] [teamID "
        "<N>]",
        "Show or change the per-keyrange configuration options.",
        "The `show' command will print the range configuration in JSON.  By default, ranges with no configured "
        "options are not shown, these are called 'default ranges' and can be shown with the `includeDefault' flag.\n\n"
        "The `update' command will apply the given options to the given key range.  Any option not explicitly given "
        "will remain at its present setting for the range in the configuration.\n\n"
        "The `set' command will change the given key range to be exactly given configuration, meaning that any option "
        "not explicitly given will be changed to unset for the range.\n\n"
        "Range Options:\n"
        "  default - Resets the configuration to apply to have no options set.  This can be used with `set' to "
        "explicitly clear all configured options for a range.\n\n"
        "  replication <N> - Set replication factor for the range.  Ranges set to a replication factor lower than the "
        "cluster's configured replication level will be treated as the same as the cluster's replication level.\n\n"
        "  teamID <N> - This provides a way to indicate that shards should be on different teams.  Ranges with "
        "different teamID settings should be assigned to different storage teams.  Shards with the same team ID can be "
        "assigned to the same storage team, but nothing enforces this.\n\n"
        "Note that key range configuration options do not alter the shard map directly, rather they are hints which "
        "DataDistribution should honor.\n\n"
        "For help with escaping BEGINKEY or ENDKEY, see `help escaping'.\n"),
    nullptr,
    &rangeConfigGenerator);
} // namespace fdb_cli
