#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
/*
 * BlobRangeCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

															#line 37 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
// This generated class is to be used only via getLatestReadVersion()
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
template <class GetLatestReadVersionActor>
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class GetLatestReadVersionActorState {
															#line 43 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	GetLatestReadVersionActorState(Database const& db) 
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		 : db(db),
															#line 36 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   tr(db)
															#line 52 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("getLatestReadVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetLatestReadVersionActorState() 
	{
		fdb_probe_actor_destroy("getLatestReadVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			;
															#line 67 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLatestReadVersionActorState();
		static_cast<GetLatestReadVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 39 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 39 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 100 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state = 1;
															#line 39 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLatestReadVersionActor, 0, Version >*>(static_cast<GetLatestReadVersionActor*>(this)));
															#line 105 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 43 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 129 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state = 2;
															#line 43 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLatestReadVersionActor, 1, Void >*>(static_cast<GetLatestReadVersionActor*>(this)));
															#line 134 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& rv,int loopDepth) 
	{
															#line 40 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("Resolved latest read version as {0}\n", rv);
															#line 41 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<GetLatestReadVersionActor*>(this)->SAV<Version>::futures) { (void)(rv); this->~GetLatestReadVersionActorState(); static_cast<GetLatestReadVersionActor*>(this)->destroy(); return 0; }
															#line 151 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<GetLatestReadVersionActor*>(this)->SAV< Version >::value()) Version(rv);
		this->~GetLatestReadVersionActorState();
		static_cast<GetLatestReadVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && rv,int loopDepth) 
	{
															#line 40 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("Resolved latest read version as {0}\n", rv);
															#line 41 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<GetLatestReadVersionActor*>(this)->SAV<Version>::futures) { (void)(rv); this->~GetLatestReadVersionActorState(); static_cast<GetLatestReadVersionActor*>(this)->destroy(); return 0; }
															#line 165 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<GetLatestReadVersionActor*>(this)->SAV< Version >::value()) Version(rv);
		this->~GetLatestReadVersionActorState();
		static_cast<GetLatestReadVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLatestReadVersionActor*>(this)->ActorCallback< GetLatestReadVersionActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< GetLatestReadVersionActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLatestReadVersionActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLatestReadVersionActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLatestReadVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLatestReadVersionActor*>(this)->ActorCallback< GetLatestReadVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLatestReadVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLatestReadVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLatestReadVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Database db;
															#line 36 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Transaction tr;
															#line 339 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
};
// This generated class is to be used only via getLatestReadVersion()
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class GetLatestReadVersionActor final : public Actor<Version>, public ActorCallback< GetLatestReadVersionActor, 0, Version >, public ActorCallback< GetLatestReadVersionActor, 1, Void >, public FastAllocated<GetLatestReadVersionActor>, public GetLatestReadVersionActorState<GetLatestReadVersionActor> {
															#line 344 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
	using FastAllocated<GetLatestReadVersionActor>::operator new;
	using FastAllocated<GetLatestReadVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5403400788765370624UL, 7631784147034800640UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLatestReadVersionActor, 0, Version >;
friend struct ActorCallback< GetLatestReadVersionActor, 1, Void >;
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	GetLatestReadVersionActor(Database const& db) 
															#line 362 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		 : Actor<Version>(),
		   GetLatestReadVersionActorState<GetLatestReadVersionActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLatestReadVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8866154676546024192UL, 7536349278348617472UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestReadVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLatestReadVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLatestReadVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLatestReadVersionActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLatestReadVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
[[nodiscard]] Future<Version> getLatestReadVersion( Database const& db ) {
															#line 35 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	return Future<Version>(new GetLatestReadVersionActor(db));
															#line 395 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
}

#line 47 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"

// print after delay if not cancelled
															#line 401 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
// This generated class is to be used only via printAfterDelay()
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
template <class PrintAfterDelayActor>
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class PrintAfterDelayActorState {
															#line 407 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	PrintAfterDelayActorState(double const& delaySeconds,std::string const& message) 
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		 : delaySeconds(delaySeconds),
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   message(message)
															#line 416 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("printAfterDelay", reinterpret_cast<unsigned long>(this));

	}
	~PrintAfterDelayActorState() 
	{
		fdb_probe_actor_destroy("printAfterDelay", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 50 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(delaySeconds);
															#line 50 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (static_cast<PrintAfterDelayActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 433 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintAfterDelayActor*>(this)->actor_wait_state = 1;
															#line 50 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintAfterDelayActor, 0, Void >*>(static_cast<PrintAfterDelayActor*>(this)));
															#line 438 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintAfterDelayActorState();
		static_cast<PrintAfterDelayActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 51 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("{}\n", message);
															#line 52 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<PrintAfterDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintAfterDelayActorState(); static_cast<PrintAfterDelayActor*>(this)->destroy(); return 0; }
															#line 463 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<PrintAfterDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintAfterDelayActorState();
		static_cast<PrintAfterDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 51 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("{}\n", message);
															#line 52 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<PrintAfterDelayActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintAfterDelayActorState(); static_cast<PrintAfterDelayActor*>(this)->destroy(); return 0; }
															#line 477 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<PrintAfterDelayActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintAfterDelayActorState();
		static_cast<PrintAfterDelayActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintAfterDelayActor*>(this)->actor_wait_state > 0) static_cast<PrintAfterDelayActor*>(this)->actor_wait_state = 0;
		static_cast<PrintAfterDelayActor*>(this)->ActorCallback< PrintAfterDelayActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintAfterDelayActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printAfterDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintAfterDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printAfterDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintAfterDelayActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printAfterDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintAfterDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printAfterDelay", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintAfterDelayActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printAfterDelay", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintAfterDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printAfterDelay", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	double delaySeconds;
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	std::string message;
															#line 564 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
};
// This generated class is to be used only via printAfterDelay()
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class PrintAfterDelayActor final : public Actor<Void>, public ActorCallback< PrintAfterDelayActor, 0, Void >, public FastAllocated<PrintAfterDelayActor>, public PrintAfterDelayActorState<PrintAfterDelayActor> {
															#line 569 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
	using FastAllocated<PrintAfterDelayActor>::operator new;
	using FastAllocated<PrintAfterDelayActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11755091518284902656UL, 16734630183913372416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintAfterDelayActor, 0, Void >;
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	PrintAfterDelayActor(double const& delaySeconds,std::string const& message) 
															#line 586 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		 : Actor<Void>(),
		   PrintAfterDelayActorState<PrintAfterDelayActor>(delaySeconds, message),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printAfterDelay", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18176689668881696512UL, 8936555925374057216UL);
		ActorExecutionContextHelper __helper(static_cast<PrintAfterDelayActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printAfterDelay");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printAfterDelay", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintAfterDelayActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
[[nodiscard]] Future<Void> printAfterDelay( double const& delaySeconds, std::string const& message ) {
															#line 49 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	return Future<Void>(new PrintAfterDelayActor(delaySeconds, message));
															#line 618 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
}

#line 54 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"

															#line 623 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
// This generated class is to be used only via doBlobPurge()
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
template <class DoBlobPurgeActor>
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class DoBlobPurgeActorState {
															#line 629 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	DoBlobPurgeActorState(Database const& db,Optional<Reference<Tenant>> const& tenant,Key const& startKey,Key const& endKey,Optional<Version> const& version,bool const& force) 
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		 : db(db),
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   tenant(tenant),
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   startKey(startKey),
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   endKey(endKey),
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   version(version),
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   force(force),
															#line 61 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   purgeVersion()
															#line 648 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("doBlobPurge", reinterpret_cast<unsigned long>(this));

	}
	~DoBlobPurgeActorState() 
	{
		fdb_probe_actor_destroy("doBlobPurge", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 62 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (version.present())
															#line 663 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			{
															#line 63 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				purgeVersion = version.get();
															#line 667 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 65 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(purgeVersion, getLatestReadVersion(db));
															#line 65 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				if (static_cast<DoBlobPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 676 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DoBlobPurgeActor*>(this)->actor_wait_state = 1;
															#line 65 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBlobPurgeActor, 0, Void >*>(static_cast<DoBlobPurgeActor*>(this)));
															#line 681 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBlobPurgeActorState();
		static_cast<DoBlobPurgeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 68 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		StrictFuture<Key> __when_expr_1 = db->purgeBlobGranules(KeyRange(KeyRangeRef(startKey, endKey)), purgeVersion, tenant, force);
															#line 68 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (static_cast<DoBlobPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 707 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoBlobPurgeActor*>(this)->actor_wait_state = 2;
															#line 68 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBlobPurgeActor, 1, Key >*>(static_cast<DoBlobPurgeActor*>(this)));
															#line 712 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBlobPurgeActor*>(this)->actor_wait_state > 0) static_cast<DoBlobPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobPurgeActor*>(this)->ActorCallback< DoBlobPurgeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobPurgeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBlobPurgeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBlobPurgeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 71 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("Blob purge registered for [{0} - {1}) @ {2}\n", startKey.printable(), endKey.printable(), purgeVersion);
															#line 73 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		printWarningActor = printAfterDelay( 5.0, "Waiting for purge to complete. (interrupting this wait with CTRL+C will not cancel the purge)");
															#line 75 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		StrictFuture<Void> __when_expr_2 = db->waitPurgeGranulesComplete(purgeKey);
															#line 75 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (static_cast<DoBlobPurgeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 814 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoBlobPurgeActor*>(this)->actor_wait_state = 3;
															#line 75 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBlobPurgeActor, 2, Void >*>(static_cast<DoBlobPurgeActor*>(this)));
															#line 819 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Key const& __purgeKey,int loopDepth) 
	{
															#line 68 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		purgeKey = __purgeKey;
															#line 828 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Key && __purgeKey,int loopDepth) 
	{
		purgeKey = std::move(__purgeKey);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBlobPurgeActor*>(this)->actor_wait_state > 0) static_cast<DoBlobPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobPurgeActor*>(this)->ActorCallback< DoBlobPurgeActor, 1, Key >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobPurgeActor, 1, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBlobPurgeActor, 1, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBlobPurgeActor, 1, Key >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 77 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("Blob purge complete for [{0} - {1}) @ {2}\n", startKey.printable(), endKey.printable(), purgeVersion);
															#line 79 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<DoBlobPurgeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobPurgeActorState(); static_cast<DoBlobPurgeActor*>(this)->destroy(); return 0; }
															#line 909 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<DoBlobPurgeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBlobPurgeActorState();
		static_cast<DoBlobPurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 77 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("Blob purge complete for [{0} - {1}) @ {2}\n", startKey.printable(), endKey.printable(), purgeVersion);
															#line 79 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<DoBlobPurgeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobPurgeActorState(); static_cast<DoBlobPurgeActor*>(this)->destroy(); return 0; }
															#line 923 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<DoBlobPurgeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBlobPurgeActorState();
		static_cast<DoBlobPurgeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBlobPurgeActor*>(this)->actor_wait_state > 0) static_cast<DoBlobPurgeActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobPurgeActor*>(this)->ActorCallback< DoBlobPurgeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobPurgeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBlobPurgeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBlobPurgeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Database db;
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Key startKey;
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Key endKey;
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Optional<Version> version;
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	bool force;
															#line 61 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Version purgeVersion;
															#line 68 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Key purgeKey;
															#line 73 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Future<Void> printWarningActor;
															#line 1024 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
};
// This generated class is to be used only via doBlobPurge()
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class DoBlobPurgeActor final : public Actor<Void>, public ActorCallback< DoBlobPurgeActor, 0, Void >, public ActorCallback< DoBlobPurgeActor, 1, Key >, public ActorCallback< DoBlobPurgeActor, 2, Void >, public FastAllocated<DoBlobPurgeActor>, public DoBlobPurgeActorState<DoBlobPurgeActor> {
															#line 1029 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
	using FastAllocated<DoBlobPurgeActor>::operator new;
	using FastAllocated<DoBlobPurgeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4189918140513037056UL, 12613050689150111744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBlobPurgeActor, 0, Void >;
friend struct ActorCallback< DoBlobPurgeActor, 1, Key >;
friend struct ActorCallback< DoBlobPurgeActor, 2, Void >;
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	DoBlobPurgeActor(Database const& db,Optional<Reference<Tenant>> const& tenant,Key const& startKey,Key const& endKey,Optional<Version> const& version,bool const& force) 
															#line 1048 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		 : Actor<Void>(),
		   DoBlobPurgeActorState<DoBlobPurgeActor>(db, tenant, startKey, endKey, version, force),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBlobPurge", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10935682854491392512UL, 2272184628761562624UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobPurgeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBlobPurge");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBlobPurge", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBlobPurgeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBlobPurgeActor, 1, Key >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBlobPurgeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
[[nodiscard]] Future<Void> doBlobPurge( Database const& db, Optional<Reference<Tenant>> const& tenant, Key const& startKey, Key const& endKey, Optional<Version> const& version, bool const& force ) {
															#line 55 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	return Future<Void>(new DoBlobPurgeActor(db, tenant, startKey, endKey, version, force));
															#line 1082 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
}

#line 81 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"

															#line 1087 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
// This generated class is to be used only via doBlobCheck()
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
template <class DoBlobCheckActor>
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class DoBlobCheckActorState {
															#line 1093 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	DoBlobCheckActorState(Database const& db,Optional<Reference<Tenant>> const& tenant,Key const& startKey,Key const& endKey,Optional<Version> const& version) 
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		 : db(db),
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   tenant(tenant),
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   startKey(startKey),
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   endKey(endKey),
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   version(version),
															#line 87 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   elapsed(-timer_monotonic())
															#line 1110 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("doBlobCheck", reinterpret_cast<unsigned long>(this));

	}
	~DoBlobCheckActorState() 
	{
		fdb_probe_actor_destroy("doBlobCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 89 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			StrictFuture<Version> __when_expr_0 = db->verifyBlobRange(KeyRangeRef(startKey, endKey), version, tenant);
															#line 89 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (static_cast<DoBlobCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1127 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBlobCheckActor*>(this)->actor_wait_state = 1;
															#line 89 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBlobCheckActor, 0, Version >*>(static_cast<DoBlobCheckActor*>(this)));
															#line 1132 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBlobCheckActorState();
		static_cast<DoBlobCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 91 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		elapsed += timer_monotonic();
															#line 93 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("Blob check complete for [{0} - {1}) @ {2} in {3:.6f} seconds\n", startKey.printable(), endKey.printable(), readVersionOut, elapsed);
															#line 98 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<DoBlobCheckActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobCheckActorState(); static_cast<DoBlobCheckActor*>(this)->destroy(); return 0; }
															#line 1159 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<DoBlobCheckActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBlobCheckActorState();
		static_cast<DoBlobCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __readVersionOut,int loopDepth) 
	{
															#line 89 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		readVersionOut = __readVersionOut;
															#line 1171 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __readVersionOut,int loopDepth) 
	{
		readVersionOut = std::move(__readVersionOut);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBlobCheckActor*>(this)->actor_wait_state > 0) static_cast<DoBlobCheckActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobCheckActor*>(this)->ActorCallback< DoBlobCheckActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobCheckActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("doBlobCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBlobCheckActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("doBlobCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBlobCheckActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobCheck", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Database db;
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Key startKey;
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Key endKey;
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Optional<Version> version;
															#line 87 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	double elapsed;
															#line 89 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Version readVersionOut;
															#line 1260 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
};
// This generated class is to be used only via doBlobCheck()
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class DoBlobCheckActor final : public Actor<Void>, public ActorCallback< DoBlobCheckActor, 0, Version >, public FastAllocated<DoBlobCheckActor>, public DoBlobCheckActorState<DoBlobCheckActor> {
															#line 1265 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
	using FastAllocated<DoBlobCheckActor>::operator new;
	using FastAllocated<DoBlobCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11695401170560357632UL, 5790193816752137216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBlobCheckActor, 0, Version >;
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	DoBlobCheckActor(Database const& db,Optional<Reference<Tenant>> const& tenant,Key const& startKey,Key const& endKey,Optional<Version> const& version) 
															#line 1282 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		 : Actor<Void>(),
		   DoBlobCheckActorState<DoBlobCheckActor>(db, tenant, startKey, endKey, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBlobCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10083809562489251072UL, 15191845835881566208UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBlobCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBlobCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBlobCheckActor, 0, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
[[nodiscard]] Future<Void> doBlobCheck( Database const& db, Optional<Reference<Tenant>> const& tenant, Key const& startKey, Key const& endKey, Optional<Version> const& version ) {
															#line 82 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	return Future<Void>(new DoBlobCheckActor(db, tenant, startKey, endKey, version));
															#line 1314 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
}

#line 100 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"

															#line 1319 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
// This generated class is to be used only via doBlobFlush()
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
template <class DoBlobFlushActor>
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class DoBlobFlushActorState {
															#line 1325 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	DoBlobFlushActorState(Database const& db,Optional<Reference<Tenant>> const& tenant,Key const& startKey,Key const& endKey,Optional<Version> const& version,bool const& compact) 
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		 : db(db),
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   tenant(tenant),
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   startKey(startKey),
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   endKey(endKey),
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   version(version),
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   compact(compact),
															#line 107 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   elapsed(-timer_monotonic()),
															#line 108 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   keyRange(KeyRangeRef(startKey, endKey))
															#line 1346 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("doBlobFlush", reinterpret_cast<unsigned long>(this));

	}
	~DoBlobFlushActorState() 
	{
		fdb_probe_actor_destroy("doBlobFlush", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 109 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			StrictFuture<bool> __when_expr_0 = db->flushBlobRange(keyRange, compact, version, tenant);
															#line 109 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (static_cast<DoBlobFlushActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1363 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBlobFlushActor*>(this)->actor_wait_state = 1;
															#line 109 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBlobFlushActor, 0, bool >*>(static_cast<DoBlobFlushActor*>(this)));
															#line 1368 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBlobFlushActorState();
		static_cast<DoBlobFlushActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& result,int loopDepth) 
	{
															#line 110 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		elapsed += timer_monotonic();
															#line 112 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("Blob Flush [{0} - {1}) {2} in {3:.6f} seconds\n", startKey.printable(), endKey.printable(), result ? "succeeded" : "failed", elapsed);
															#line 118 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<DoBlobFlushActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobFlushActorState(); static_cast<DoBlobFlushActor*>(this)->destroy(); return 0; }
															#line 1395 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<DoBlobFlushActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBlobFlushActorState();
		static_cast<DoBlobFlushActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && result,int loopDepth) 
	{
															#line 110 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		elapsed += timer_monotonic();
															#line 112 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		fmt::print("Blob Flush [{0} - {1}) {2} in {3:.6f} seconds\n", startKey.printable(), endKey.printable(), result ? "succeeded" : "failed", elapsed);
															#line 118 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<DoBlobFlushActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBlobFlushActorState(); static_cast<DoBlobFlushActor*>(this)->destroy(); return 0; }
															#line 1411 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<DoBlobFlushActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBlobFlushActorState();
		static_cast<DoBlobFlushActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBlobFlushActor*>(this)->actor_wait_state > 0) static_cast<DoBlobFlushActor*>(this)->actor_wait_state = 0;
		static_cast<DoBlobFlushActor*>(this)->ActorCallback< DoBlobFlushActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< DoBlobFlushActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("doBlobFlush", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobFlushActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobFlush", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBlobFlushActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("doBlobFlush", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobFlushActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobFlush", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBlobFlushActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("doBlobFlush", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobFlushActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBlobFlush", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Database db;
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Optional<Reference<Tenant>> tenant;
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Key startKey;
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Key endKey;
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Optional<Version> version;
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	bool compact;
															#line 107 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	double elapsed;
															#line 108 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	KeyRange keyRange;
															#line 1510 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
};
// This generated class is to be used only via doBlobFlush()
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class DoBlobFlushActor final : public Actor<Void>, public ActorCallback< DoBlobFlushActor, 0, bool >, public FastAllocated<DoBlobFlushActor>, public DoBlobFlushActorState<DoBlobFlushActor> {
															#line 1515 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
	using FastAllocated<DoBlobFlushActor>::operator new;
	using FastAllocated<DoBlobFlushActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1274549228604428032UL, 4884859549906820096UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBlobFlushActor, 0, bool >;
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	DoBlobFlushActor(Database const& db,Optional<Reference<Tenant>> const& tenant,Key const& startKey,Key const& endKey,Optional<Version> const& version,bool const& compact) 
															#line 1532 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		 : Actor<Void>(),
		   DoBlobFlushActorState<DoBlobFlushActor>(db, tenant, startKey, endKey, version, compact),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBlobFlush", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8771146995378615040UL, 17647843697162062080UL);
		ActorExecutionContextHelper __helper(static_cast<DoBlobFlushActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBlobFlush");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBlobFlush", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBlobFlushActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
[[nodiscard]] Future<Void> doBlobFlush( Database const& db, Optional<Reference<Tenant>> const& tenant, Key const& startKey, Key const& endKey, Optional<Version> const& version, bool const& compact ) {
															#line 101 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	return Future<Void>(new DoBlobFlushActor(db, tenant, startKey, endKey, version, compact));
															#line 1564 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
}

#line 120 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"

} // namespace

namespace fdb_cli {

															#line 1573 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
// This generated class is to be used only via blobRangeCommandActor()
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
template <class BlobRangeCommandActorActor>
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class BlobRangeCommandActorActorState {
															#line 1579 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	BlobRangeCommandActorActorState(Database const& localDb,Optional<TenantMapEntry> const& tenantEntry,std::vector<StringRef> const& tokens) 
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		 : localDb(localDb),
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   tenantEntry(tenantEntry),
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		   tokens(tokens)
															#line 1590 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("blobRangeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~BlobRangeCommandActorActorState() 
	{
		fdb_probe_actor_destroy("blobRangeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 129 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (tokens.size() != 4 && tokens.size() != 5)
															#line 1605 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			{
															#line 130 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 131 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				if (!static_cast<BlobRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRangeCommandActorActorState(); static_cast<BlobRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1611 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
				new (&static_cast<BlobRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~BlobRangeCommandActorActorState();
				static_cast<BlobRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 134 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			Optional<Reference<Tenant>> tenant;
															#line 135 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (tenantEntry.present())
															#line 1621 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			{
															#line 136 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				tenant = Reference<Tenant>(new Tenant(tenantEntry.get().id));
															#line 1625 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			}
															#line 139 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			Key begin = tokens[2];
															#line 140 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			Key end = tokens[3];
															#line 142 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			if (end > "\xff"_sr)
															#line 1633 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
			{
															#line 144 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				fmt::print("Cannot blobbify system keyspace! Problematic End Key: {0}\n", tokens[3].printable());
															#line 145 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				if (!static_cast<BlobRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRangeCommandActorActorState(); static_cast<BlobRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1639 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
				new (&static_cast<BlobRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~BlobRangeCommandActorActorState();
				static_cast<BlobRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 146 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
				if (tokens[2] >= tokens[3])
															#line 1649 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
				{
															#line 147 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
					fmt::print("Invalid blob range [{0} - {1})\n", tokens[2].printable(), tokens[3].printable());
															#line 1653 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
					loopDepth = a_body1cont5(loopDepth);
				}
				else
				{
															#line 149 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
					if (tokencmp(tokens[1], "start") || tokencmp(tokens[1], "stop"))
															#line 1660 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
					{
															#line 150 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
						starting = tokencmp(tokens[1], "start");
															#line 151 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
						if (tokens.size() > 4)
															#line 1666 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
						{
															#line 152 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 153 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							if (!static_cast<BlobRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRangeCommandActorActorState(); static_cast<BlobRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1672 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							new (&static_cast<BlobRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~BlobRangeCommandActorActorState();
							static_cast<BlobRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 155 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
						fmt::print("{0} blobbify range for [{1} - {2})\n", starting ? "Starting" : "Stopping", tokens[2].printable(), tokens[3].printable());
															#line 159 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
						success = false;
															#line 160 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
						if (starting)
															#line 1684 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
						{
															#line 161 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							StrictFuture<Void> __when_expr_0 = store(success, localDb->blobbifyRange(KeyRangeRef(begin, end), tenant));
															#line 161 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1690 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
							static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 1;
															#line 161 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BlobRangeCommandActorActor, 0, Void >*>(static_cast<BlobRangeCommandActorActor*>(this)));
															#line 1695 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 163 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							StrictFuture<Void> __when_expr_1 = store(success, localDb->unblobbifyRange(KeyRangeRef(begin, end), tenant));
															#line 163 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1704 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
							static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 2;
															#line 163 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BlobRangeCommandActorActor, 1, Void >*>(static_cast<BlobRangeCommandActorActor*>(this)));
															#line 1709 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							loopDepth = 0;
						}
					}
					else
					{
															#line 177 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
						if (tokencmp(tokens[1], "purge") || tokencmp(tokens[1], "forcepurge") || tokencmp(tokens[1], "check") || tokencmp(tokens[1], "flush") || tokencmp(tokens[1], "compact"))
															#line 1717 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
						{
															#line 179 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							bool purge = tokencmp(tokens[1], "purge") || tokencmp(tokens[1], "forcepurge");
															#line 180 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							bool forcePurge = tokencmp(tokens[1], "forcepurge");
															#line 182 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							Optional<Version> version;
															#line 183 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							if (tokens.size() > 4)
															#line 1727 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							{
															#line 184 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								Version v;
															#line 185 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								int n = 0;
															#line 186 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								if (sscanf(tokens[4].toString().c_str(), "%" PRId64 "%n", &v, &n) != 1 || n != tokens[4].size())
															#line 1735 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
								{
															#line 187 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
									printUsage(tokens[0]);
															#line 188 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
									if (!static_cast<BlobRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRangeCommandActorActorState(); static_cast<BlobRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1741 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
									new (&static_cast<BlobRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
									this->~BlobRangeCommandActorActorState();
									static_cast<BlobRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
															#line 190 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								version = v;
															#line 1749 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							}
															#line 193 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							fmt::print("{0} blob range [{1} - {2}){3}", tokens[1].printable(), tokens[2].printable(), tokens[3].printable(), forcePurge ? " (force)" : "");
															#line 198 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							if (version.present())
															#line 1755 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							{
															#line 199 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								fmt::print(" @ {0}", version.get());
															#line 1759 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							}
															#line 201 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							fmt::print("\n");
															#line 203 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							if (purge)
															#line 1765 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							{
															#line 204 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								StrictFuture<Void> __when_expr_2 = doBlobPurge(localDb, tenant, begin, end, version, forcePurge);
															#line 204 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1771 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
								if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
								static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 3;
															#line 204 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BlobRangeCommandActorActor, 2, Void >*>(static_cast<BlobRangeCommandActorActor*>(this)));
															#line 1776 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
															#line 206 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
								if (tokencmp(tokens[1], "check"))
															#line 1783 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
								{
															#line 207 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
									StrictFuture<Void> __when_expr_3 = doBlobCheck(localDb, tenant, begin, end, version);
															#line 207 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
									if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1789 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
									if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when4(__when_expr_3.get(), loopDepth); };
									static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 4;
															#line 207 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
									__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BlobRangeCommandActorActor, 3, Void >*>(static_cast<BlobRangeCommandActorActor*>(this)));
															#line 1794 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
									loopDepth = 0;
								}
								else
								{
															#line 208 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
									if (tokencmp(tokens[1], "flush"))
															#line 1801 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
									{
															#line 209 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
										StrictFuture<Void> __when_expr_4 = doBlobFlush(localDb, tenant, begin, end, version, false);
															#line 209 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
										if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1807 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
										if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1when5(__when_expr_4.get(), loopDepth); };
										static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 5;
															#line 209 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
										__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BlobRangeCommandActorActor, 4, Void >*>(static_cast<BlobRangeCommandActorActor*>(this)));
															#line 1812 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
										loopDepth = 0;
									}
									else
									{
															#line 210 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
										if (tokencmp(tokens[1], "compact"))
															#line 1819 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
										{
															#line 211 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
											StrictFuture<Void> __when_expr_5 = doBlobFlush(localDb, tenant, begin, end, version, true);
															#line 211 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
											if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1825 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
											if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1when6(__when_expr_5.get(), loopDepth); };
											static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 6;
															#line 211 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
											__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BlobRangeCommandActorActor, 5, Void >*>(static_cast<BlobRangeCommandActorActor*>(this)));
															#line 1830 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
											loopDepth = 0;
										}
										else
										{
															#line 213 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
											ASSERT(false);
															#line 1837 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
											loopDepth = a_body1cont25(loopDepth);
										}
									}
								}
							}
						}
						else
						{
															#line 217 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 218 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
							if (!static_cast<BlobRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~BlobRangeCommandActorActorState(); static_cast<BlobRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1850 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
							new (&static_cast<BlobRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~BlobRangeCommandActorActorState();
							static_cast<BlobRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BlobRangeCommandActorActorState();
		static_cast<BlobRangeCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 221 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<BlobRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~BlobRangeCommandActorActorState(); static_cast<BlobRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1880 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<BlobRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~BlobRangeCommandActorActorState();
		static_cast<BlobRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
															#line 165 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (success)
															#line 1904 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		{
															#line 166 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			fmt::print("{0} updated blob range [{1} - {2}) succeeded\n", starting ? "Starting" : "Stopping", tokens[2].printable(), tokens[3].printable());
															#line 1908 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		}
		else
		{
															#line 171 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
			fmt::print("{0} blobbify range for [{1} - {2}) failed\n", starting ? "Starting" : "Stopping", tokens[2].printable(), tokens[3].printable());
															#line 1914 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		}
															#line 176 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
		if (!static_cast<BlobRangeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(success); this->~BlobRangeCommandActorActorState(); static_cast<BlobRangeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1918 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		new (&static_cast<BlobRangeCommandActorActor*>(this)->SAV< bool >::value()) bool(std::move(success)); // state_var_RVO
		this->~BlobRangeCommandActorActorState();
		static_cast<BlobRangeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRangeCommandActorActor*>(this)->ActorCallback< BlobRangeCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BlobRangeCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRangeCommandActorActor*>(this)->ActorCallback< BlobRangeCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BlobRangeCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont20(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont20(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont20(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRangeCommandActorActor*>(this)->ActorCallback< BlobRangeCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BlobRangeCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont21(int loopDepth) 
	{
		loopDepth = a_body1cont16(loopDepth);

		return loopDepth;
	}
	int a_body1cont22(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont22(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRangeCommandActorActor*>(this)->ActorCallback< BlobRangeCommandActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BlobRangeCommandActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont23(int loopDepth) 
	{
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont24(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1cont24(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont24(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont24(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRangeCommandActorActor*>(this)->ActorCallback< BlobRangeCommandActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BlobRangeCommandActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont25(int loopDepth) 
	{
		loopDepth = a_body1cont23(loopDepth);

		return loopDepth;
	}
	int a_body1cont26(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont25(loopDepth);

		return loopDepth;
	}
	int a_body1cont26(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont25(loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont26(_, loopDepth);

		return loopDepth;
	}
	int a_body1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont26(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<BlobRangeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<BlobRangeCommandActorActor*>(this)->ActorCallback< BlobRangeCommandActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BlobRangeCommandActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BlobRangeCommandActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Database localDb;
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	Optional<TenantMapEntry> tenantEntry;
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 150 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	bool starting;
															#line 159 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	bool success;
															#line 2488 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
};
// This generated class is to be used only via blobRangeCommandActor()
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
class BlobRangeCommandActorActor final : public Actor<bool>, public ActorCallback< BlobRangeCommandActorActor, 0, Void >, public ActorCallback< BlobRangeCommandActorActor, 1, Void >, public ActorCallback< BlobRangeCommandActorActor, 2, Void >, public ActorCallback< BlobRangeCommandActorActor, 3, Void >, public ActorCallback< BlobRangeCommandActorActor, 4, Void >, public ActorCallback< BlobRangeCommandActorActor, 5, Void >, public FastAllocated<BlobRangeCommandActorActor>, public BlobRangeCommandActorActorState<BlobRangeCommandActorActor> {
															#line 2493 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
public:
	using FastAllocated<BlobRangeCommandActorActor>::operator new;
	using FastAllocated<BlobRangeCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1757574777446138368UL, 4381394332245037312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BlobRangeCommandActorActor, 0, Void >;
friend struct ActorCallback< BlobRangeCommandActorActor, 1, Void >;
friend struct ActorCallback< BlobRangeCommandActorActor, 2, Void >;
friend struct ActorCallback< BlobRangeCommandActorActor, 3, Void >;
friend struct ActorCallback< BlobRangeCommandActorActor, 4, Void >;
friend struct ActorCallback< BlobRangeCommandActorActor, 5, Void >;
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	BlobRangeCommandActorActor(Database const& localDb,Optional<TenantMapEntry> const& tenantEntry,std::vector<StringRef> const& tokens) 
															#line 2515 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
		 : Actor<bool>(),
		   BlobRangeCommandActorActorState<BlobRangeCommandActorActor>(localDb, tenantEntry, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15494957109971741184UL, 9699375716599467264UL);
		ActorExecutionContextHelper __helper(static_cast<BlobRangeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("blobRangeCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("blobRangeCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BlobRangeCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BlobRangeCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BlobRangeCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BlobRangeCommandActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BlobRangeCommandActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BlobRangeCommandActorActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
[[nodiscard]] Future<bool> blobRangeCommandActor( Database const& localDb, Optional<TenantMapEntry> const& tenantEntry, std::vector<StringRef> const& tokens ) {
															#line 125 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"
	return Future<bool>(new BlobRangeCommandActorActor(localDb, tenantEntry, tokens));
															#line 2552 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/build_output/fdbcli/BlobRangeCommand.actor.g.cpp"
}

#line 223 "/codebuild/output/src3343592895/src/github.com/apple/foundationdb/fdbcli/BlobRangeCommand.actor.cpp"

CommandFactory blobRangeFactory(
    "blobrange",
    CommandHelp("blobrange <start|stop|check|purge|forcepurge|flush|compact> <startkey> <endkey> [version]", "", ""));
} // namespace fdb_cli
