#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
/*
 * flowbench.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "benchmark/benchmark.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "flow/ThreadHelper.actor.h"
#include <thread>

															#line 29 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
namespace {
// This generated class is to be used only via stopNetworkAfter()
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
template <class T, class StopNetworkAfterActor>
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
class StopNetworkAfterActorState {
															#line 36 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
public:
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
	StopNetworkAfterActorState(Future<T> const& what) 
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
		 : what(what)
															#line 43 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
	{
		fdb_probe_actor_create("stopNetworkAfter", reinterpret_cast<unsigned long>(this));

	}
	~StopNetworkAfterActorState() 
	{
		fdb_probe_actor_destroy("stopNetworkAfter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 30 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
				StrictFuture<T> __when_expr_0 = what;
															#line 30 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
				if (static_cast<StopNetworkAfterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 61 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StopNetworkAfterActor*>(this)->actor_wait_state = 1;
															#line 30 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StopNetworkAfterActor, 0, T >*>(static_cast<StopNetworkAfterActor*>(this)));
															#line 66 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StopNetworkAfterActorState();
		static_cast<StopNetworkAfterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& __current_error,int loopDepth=0) 
	{
		try {
															#line 34 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
			g_network->stop();
															#line 35 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
			return a_body1Catch1(__current_error, loopDepth);
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(T const& t,int loopDepth) 
	{
															#line 31 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
		g_network->stop();
															#line 32 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
		if (!static_cast<StopNetworkAfterActor*>(this)->SAV<T>::futures) { (void)(t); this->~StopNetworkAfterActorState(); static_cast<StopNetworkAfterActor*>(this)->destroy(); return 0; }
															#line 114 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
		new (&static_cast<StopNetworkAfterActor*>(this)->SAV< T >::value()) T(t);
		this->~StopNetworkAfterActorState();
		static_cast<StopNetworkAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(T && t,int loopDepth) 
	{
															#line 31 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
		g_network->stop();
															#line 32 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
		if (!static_cast<StopNetworkAfterActor*>(this)->SAV<T>::futures) { (void)(t); this->~StopNetworkAfterActorState(); static_cast<StopNetworkAfterActor*>(this)->destroy(); return 0; }
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
		new (&static_cast<StopNetworkAfterActor*>(this)->SAV< T >::value()) T(t);
		this->~StopNetworkAfterActorState();
		static_cast<StopNetworkAfterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(T const& t,int loopDepth) 
	{
		loopDepth = a_body1cont2(t, loopDepth);

		return loopDepth;
	}
	int a_body1when1(T && t,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(t), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StopNetworkAfterActor*>(this)->actor_wait_state > 0) static_cast<StopNetworkAfterActor*>(this)->actor_wait_state = 0;
		static_cast<StopNetworkAfterActor*>(this)->ActorCallback< StopNetworkAfterActor, 0, T >::remove();

	}
	void a_callback_fire(ActorCallback< StopNetworkAfterActor, 0, T >*,T const& value) 
	{
		fdb_probe_actor_enter("stopNetworkAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopNetworkAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopNetworkAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StopNetworkAfterActor, 0, T >*,T && value) 
	{
		fdb_probe_actor_enter("stopNetworkAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StopNetworkAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopNetworkAfter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StopNetworkAfterActor, 0, T >*,Error err) 
	{
		fdb_probe_actor_enter("stopNetworkAfter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StopNetworkAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("stopNetworkAfter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
	Future<T> what;
															#line 213 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
};
// This generated class is to be used only via stopNetworkAfter()
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
template <class T>
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
class StopNetworkAfterActor final : public Actor<T>, public ActorCallback< StopNetworkAfterActor<T>, 0, T >, public FastAllocated<StopNetworkAfterActor<T>>, public StopNetworkAfterActorState<T, StopNetworkAfterActor<T>> {
															#line 220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
public:
	using FastAllocated<StopNetworkAfterActor<T>>::operator new;
	using FastAllocated<StopNetworkAfterActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15039480912803556608UL, 7490136012510873600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<T>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StopNetworkAfterActor<T>, 0, T >;
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
	StopNetworkAfterActor(Future<T> const& what) 
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
		 : Actor<T>(),
		   StopNetworkAfterActorState<T, StopNetworkAfterActor<T>>(what),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("stopNetworkAfter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5440916104915410176UL, 16460411745428950528UL);
		ActorExecutionContextHelper __helper(static_cast<StopNetworkAfterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("stopNetworkAfter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("stopNetworkAfter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StopNetworkAfterActor<T>, 0, T >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
template <class T>
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
[[nodiscard]] Future<T> stopNetworkAfter( Future<T> const& what ) {
															#line 27 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"
	return Future<T>(new StopNetworkAfterActor<T>(what));
															#line 272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/flowbench/flowbench.actor.g.cpp"
}

#line 38 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/flowbench/flowbench.actor.cpp"

int main(int argc, char** argv) {
	benchmark::Initialize(&argc, argv);
	if (benchmark::ReportUnrecognizedArguments(argc, argv)) {
		return 1;
	}
	setupNetwork();
	Promise<Void> benchmarksDone;
	std::thread benchmarkThread([&]() {
		benchmark::RunSpecifiedBenchmarks();
		onMainThreadVoid([&]() { benchmarksDone.send(Void()); });
	});
	auto f = stopNetworkAfter(benchmarksDone.getFuture());
	runNetwork();
	benchmarkThread.join();
}
