#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
/*
 * ReadWrite.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>
#include <utility>
#include <vector>

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbserver/workloads/ReadWriteWorkload.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/TDMetric.actor.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct SkewedReadWriteWorkload : ReadWriteCommon {
	static constexpr auto NAME = "SkewedReadWrite";
	// server based hot traffic setting
	int skewRound = 0; // skewDuration = ceil(testDuration / skewRound)
	double hotServerFraction = 0, hotServerShardFraction = 1.0; // set > 0 to issue hot key based on shard map
	double hotServerReadFrac, hotServerWriteFrac; // hot many traffic goes to hot servers
	double hotReadWriteServerOverlap; // the portion of intersection of write and hot server

	// hot server state
	typedef std::vector<std::pair<int64_t, int64_t>> IndexRangeVec;
	// keyForIndex generate key from index. So for a shard range, recording the start and end is enough
	std::vector<std::pair<UID, IndexRangeVec>> serverShards; // storage server and the shards it owns
	std::map<UID, StorageServerInterface> serverInterfaces;
	int hotServerCount = 0, currentHotRound = -1;

	SkewedReadWriteWorkload(WorkloadContext const& wcx) : ReadWriteCommon(wcx) {
		descriptionString = getOption(options, "description"_sr, "SkewedReadWrite"_sr);
		hotServerFraction = getOption(options, "hotServerFraction"_sr, 0.2);
		hotServerShardFraction = getOption(options, "hotServerShardFraction"_sr, 1.0);
		hotReadWriteServerOverlap = getOption(options, "hotReadWriteServerOverlap"_sr, 0.0);
		skewRound = getOption(options, "skewRound"_sr, 1);
		hotServerReadFrac = getOption(options, "hotServerReadFrac"_sr, 0.8);
		hotServerWriteFrac = getOption(options, "hotServerWriteFrac"_sr, 0.0);
		ASSERT((hotServerReadFrac >= hotServerFraction || hotServerWriteFrac >= hotServerFraction) && skewRound > 0);
	}

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	void debugPrintServerShards() const {
		std::cout << std::hex;
		for (auto it : this->serverShards) {
			std::cout << serverInterfaces.at(it.first).address().toString() << ": [";
			for (auto p : it.second) {
				std::cout << "[" << p.first << "," << p.second << "], ";
			}
			std::cout << "] \n";
		}
	}

	// for each boundary except the last one in boundaries, found the first existed key generated from keyForIndex as
	// beginIdx, found the last existed key generated from keyForIndex the endIdx.
																#line 80 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
// This generated class is to be used only via convertKeyBoundaryToIndexShard()
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class ConvertKeyBoundaryToIndexShardActor>
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class ConvertKeyBoundaryToIndexShardActorState {
															#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	ConvertKeyBoundaryToIndexShardActorState(Database const& cx,SkewedReadWriteWorkload* const& self,Standalone<VectorRef<KeyRef>> const& boundaries) 
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		 : cx(cx),
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   self(self),
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   boundaries(boundaries),
															#line 81 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   res(),
															#line 82 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   i(0)
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
	{
		fdb_probe_actor_create("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this));

	}
	~ConvertKeyBoundaryToIndexShardActorState() 
	{
		fdb_probe_actor_destroy("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 83 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			;
															#line 116 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConvertKeyBoundaryToIndexShardActorState();
		static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 97 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		ASSERT(res.size() == boundaries.size() - 1);
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->SAV<IndexRangeVec>::futures) { (void)(res); this->~ConvertKeyBoundaryToIndexShardActorState(); static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->destroy(); return 0; }
															#line 141 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		new (&static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->SAV< IndexRangeVec >::value()) IndexRangeVec(std::move(res)); // state_var_RVO
		this->~ConvertKeyBoundaryToIndexShardActorState();
		static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 83 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!(i < boundaries.size() - 1))
															#line 160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		KeyRangeRef currentShard = KeyRangeRef(boundaries[i], boundaries[i + 1]);
															#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_0 = runRYWTransaction( cx, [currentShard](Reference<ReadYourWritesTransaction> tr) -> Future<std::vector<RangeResult>> { std::vector<Future<RangeResult>> f; f.push_back(tr->getRange(currentShard, 1, Snapshot::False, Reverse::False)); f.push_back(tr->getRange(currentShard, 1, Snapshot::False, Reverse::True)); return getAll(f); });
															#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 170 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->actor_wait_state = 1;
															#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConvertKeyBoundaryToIndexShardActor, 0, std::vector<RangeResult> >*>(static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)));
															#line 175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::vector<RangeResult> const& ranges,int loopDepth) 
	{
															#line 93 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		ASSERT(ranges[0].size() == 1 && ranges[1].size() == 1);
															#line 94 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		res.emplace_back(self->indexForKey(ranges[0][0].key), self->indexForKey(ranges[1][0].key));
															#line 83 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		++i;
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(std::vector<RangeResult> && ranges,int loopDepth) 
	{
															#line 93 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		ASSERT(ranges[0].size() == 1 && ranges[1].size() == 1);
															#line 94 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		res.emplace_back(self->indexForKey(ranges[0][0].key), self->indexForKey(ranges[1][0].key));
															#line 83 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		++i;
															#line 214 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<RangeResult> const& ranges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(ranges, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<RangeResult> && ranges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(ranges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->actor_wait_state > 0) static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->actor_wait_state = 0;
		static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->ActorCallback< ConvertKeyBoundaryToIndexShardActor, 0, std::vector<RangeResult> >::remove();

	}
	void a_callback_fire(ActorCallback< ConvertKeyBoundaryToIndexShardActor, 0, std::vector<RangeResult> >*,std::vector<RangeResult> const& value) 
	{
		fdb_probe_actor_enter("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConvertKeyBoundaryToIndexShardActor, 0, std::vector<RangeResult> >*,std::vector<RangeResult> && value) 
	{
		fdb_probe_actor_enter("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConvertKeyBoundaryToIndexShardActor, 0, std::vector<RangeResult> >*,Error err) 
	{
		fdb_probe_actor_enter("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Database cx;
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	SkewedReadWriteWorkload* self;
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Standalone<VectorRef<KeyRef>> boundaries;
															#line 81 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	IndexRangeVec res;
															#line 82 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	int i;
															#line 304 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
};
// This generated class is to be used only via convertKeyBoundaryToIndexShard()
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class ConvertKeyBoundaryToIndexShardActor final : public Actor<IndexRangeVec>, public ActorCallback< ConvertKeyBoundaryToIndexShardActor, 0, std::vector<RangeResult> >, public FastAllocated<ConvertKeyBoundaryToIndexShardActor>, public ConvertKeyBoundaryToIndexShardActorState<ConvertKeyBoundaryToIndexShardActor> {
															#line 309 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
	using FastAllocated<ConvertKeyBoundaryToIndexShardActor>::operator new;
	using FastAllocated<ConvertKeyBoundaryToIndexShardActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(460155212740689664UL, 10210742282592419584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<IndexRangeVec>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConvertKeyBoundaryToIndexShardActor, 0, std::vector<RangeResult> >;
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	ConvertKeyBoundaryToIndexShardActor(Database const& cx,SkewedReadWriteWorkload* const& self,Standalone<VectorRef<KeyRef>> const& boundaries) 
															#line 326 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		 : Actor<IndexRangeVec>(),
		   ConvertKeyBoundaryToIndexShardActorState<ConvertKeyBoundaryToIndexShardActor>(cx, self, boundaries),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12623907862686153216UL, 7311913768398504960UL);
		ActorExecutionContextHelper __helper(static_cast<ConvertKeyBoundaryToIndexShardActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("convertKeyBoundaryToIndexShard");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("convertKeyBoundaryToIndexShard", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConvertKeyBoundaryToIndexShardActor, 0, std::vector<RangeResult> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
[[nodiscard]] static Future<IndexRangeVec> convertKeyBoundaryToIndexShard( Database const& cx, SkewedReadWriteWorkload* const& self, Standalone<VectorRef<KeyRef>> const& boundaries ) {
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	return Future<IndexRangeVec>(new ConvertKeyBoundaryToIndexShardActor(cx, self, boundaries));
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
}

#line 100 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"

																#line 363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
// This generated class is to be used only via updateServerShards()
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class UpdateServerShardsActor>
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class UpdateServerShardsActorState {
															#line 369 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	UpdateServerShardsActorState(Database const& cx,SkewedReadWriteWorkload* const& self) 
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		 : cx(cx),
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   self(self),
															#line 102 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   serverList(),
															#line 103 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   range(),
															#line 104 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx))
															#line 384 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
	{
		fdb_probe_actor_create("updateServerShards", reinterpret_cast<unsigned long>(this));

	}
	~UpdateServerShardsActorState() 
	{
		fdb_probe_actor_destroy("updateServerShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 105 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			;
															#line 399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateServerShardsActorState();
		static_cast<UpdateServerShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 119 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->serverInterfaces.clear();
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(int i = 0;i < serverList.size();i++) {
															#line 121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			auto ssi = decodeServerListValue(serverList[i].value);
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->serverInterfaces.emplace(ssi.id(), ssi);
															#line 428 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->serverShards.clear();
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		Key workloadBegin = self->keyForIndex(0), workloadEnd = self->keyForIndex(self->nodeCount);
															#line 129 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		Key leftEdge(allKeys.begin);
															#line 130 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		std::vector<UID> leftServer;
															#line 131 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		KeyRangeRef workloadRange(workloadBegin, workloadEnd);
															#line 132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		beginServers = std::map<Key, std::vector<UID>>();
															#line 134 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(auto kv = range.begin();kv != range.end();kv++) {
															#line 135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (serverHasKey(kv->value))
															#line 446 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			{
															#line 136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				auto [id, key] = serverKeysDecodeServerBegin(kv->key);
															#line 138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				if (workloadRange.contains(key))
															#line 452 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
				{
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
					beginServers[key].push_back(id);
															#line 456 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
				}
				else
				{
															#line 140 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
					if (workloadBegin > key && key > leftEdge)
															#line 462 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
					{
															#line 141 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
						leftEdge = key;
															#line 142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
						leftServer.clear();
															#line 468 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
					}
				}
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				if (key == leftEdge)
															#line 473 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
				{
															#line 146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
					leftServer.push_back(id);
															#line 477 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
				}
			}
		}
															#line 150 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		ASSERT(beginServers.size() == 0 || beginServers.begin()->first >= workloadBegin);
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (beginServers.size() == 0 || beginServers.begin()->first > workloadBegin)
															#line 485 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 153 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			beginServers[workloadBegin] = leftServer;
															#line 489 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		Standalone<VectorRef<KeyRef>> keyBegins;
															#line 156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(auto p = beginServers.begin();p != beginServers.end();++p) {
															#line 157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			keyBegins.push_back(keyBegins.arena(), p->first);
															#line 497 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		keyBegins.push_back_deep(keyBegins.arena(), workloadEnd);
															#line 162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<IndexRangeVec> __when_expr_3 = convertKeyBoundaryToIndexShard(cx, self, keyBegins);
															#line 162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 505 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 4;
															#line 162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< UpdateServerShardsActor, 3, IndexRangeVec >*>(static_cast<UpdateServerShardsActor*>(this)));
															#line 510 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 108 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 109 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			serverListF = tr->getRange(serverListKeys, CLIENT_KNOBS->TOO_MANY);
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			rangeF = tr->getRange(serverKeysRange, CLIENT_KNOBS->TOO_MANY);
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(serverList, serverListF);
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 535 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 1;
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateServerShardsActor, 0, Void >*>(static_cast<UpdateServerShardsActor*>(this)));
															#line 540 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 577 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 3;
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateServerShardsActor, 2, Void >*>(static_cast<UpdateServerShardsActor*>(this)));
															#line 582 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(range, rangeF);
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 599 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 2;
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateServerShardsActor, 1, Void >*>(static_cast<UpdateServerShardsActor*>(this)));
															#line 604 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = store(range, rangeF);
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 615 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 2;
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateServerShardsActor, 1, Void >*>(static_cast<UpdateServerShardsActor*>(this)));
															#line 620 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state > 0) static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateServerShardsActor*>(this)->ActorCallback< UpdateServerShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateServerShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateServerShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateServerShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state > 0) static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateServerShardsActor*>(this)->ActorCallback< UpdateServerShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateServerShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateServerShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateServerShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state > 0) static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateServerShardsActor*>(this)->ActorCallback< UpdateServerShardsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateServerShardsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateServerShardsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateServerShardsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2(IndexRangeVec const& indexShards,int loopDepth) 
	{
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		ASSERT(beginServers.size() == indexShards.size());
															#line 166 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		std::map<UID, IndexRangeVec> serverShards;
															#line 167 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		int i = 0;
															#line 168 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(auto p = beginServers.begin();p != beginServers.end();++p) {
															#line 169 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			for(int j = 0;j < p->second.size();++j) {
															#line 170 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				serverShards[p->second[j]].emplace_back(indexShards[i]);
															#line 888 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			++i;
															#line 892 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for( auto it : serverShards ) {
															#line 176 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->serverShards.emplace_back(it);
															#line 898 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!static_cast<UpdateServerShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateServerShardsActorState(); static_cast<UpdateServerShardsActor*>(this)->destroy(); return 0; }
															#line 902 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		new (&static_cast<UpdateServerShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateServerShardsActorState();
		static_cast<UpdateServerShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(IndexRangeVec && indexShards,int loopDepth) 
	{
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		ASSERT(beginServers.size() == indexShards.size());
															#line 166 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		std::map<UID, IndexRangeVec> serverShards;
															#line 167 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		int i = 0;
															#line 168 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(auto p = beginServers.begin();p != beginServers.end();++p) {
															#line 169 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			for(int j = 0;j < p->second.size();++j) {
															#line 170 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				serverShards[p->second[j]].emplace_back(indexShards[i]);
															#line 924 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			++i;
															#line 928 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for( auto it : serverShards ) {
															#line 176 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->serverShards.emplace_back(it);
															#line 934 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!static_cast<UpdateServerShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateServerShardsActorState(); static_cast<UpdateServerShardsActor*>(this)->destroy(); return 0; }
															#line 938 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		new (&static_cast<UpdateServerShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateServerShardsActorState();
		static_cast<UpdateServerShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(IndexRangeVec const& indexShards,int loopDepth) 
	{
		loopDepth = a_body1cont2(indexShards, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(IndexRangeVec && indexShards,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(indexShards), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<UpdateServerShardsActor*>(this)->actor_wait_state > 0) static_cast<UpdateServerShardsActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateServerShardsActor*>(this)->ActorCallback< UpdateServerShardsActor, 3, IndexRangeVec >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateServerShardsActor, 3, IndexRangeVec >*,IndexRangeVec const& value) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< UpdateServerShardsActor, 3, IndexRangeVec >*,IndexRangeVec && value) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< UpdateServerShardsActor, 3, IndexRangeVec >*,Error err) 
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Database cx;
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	SkewedReadWriteWorkload* self;
															#line 102 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	RangeResult serverList;
															#line 103 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	RangeResult range;
															#line 104 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 109 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Future<RangeResult> serverListF;
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Future<RangeResult> rangeF;
															#line 132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	std::map<Key, std::vector<UID>> beginServers;
															#line 1037 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
};
// This generated class is to be used only via updateServerShards()
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class UpdateServerShardsActor final : public Actor<Void>, public ActorCallback< UpdateServerShardsActor, 0, Void >, public ActorCallback< UpdateServerShardsActor, 1, Void >, public ActorCallback< UpdateServerShardsActor, 2, Void >, public ActorCallback< UpdateServerShardsActor, 3, IndexRangeVec >, public FastAllocated<UpdateServerShardsActor>, public UpdateServerShardsActorState<UpdateServerShardsActor> {
															#line 1042 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
	using FastAllocated<UpdateServerShardsActor>::operator new;
	using FastAllocated<UpdateServerShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18284005966097028864UL, 347329041387440384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateServerShardsActor, 0, Void >;
friend struct ActorCallback< UpdateServerShardsActor, 1, Void >;
friend struct ActorCallback< UpdateServerShardsActor, 2, Void >;
friend struct ActorCallback< UpdateServerShardsActor, 3, IndexRangeVec >;
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	UpdateServerShardsActor(Database const& cx,SkewedReadWriteWorkload* const& self) 
															#line 1062 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateServerShardsActorState<UpdateServerShardsActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateServerShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1756197284203453696UL, 4424718960269615616UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateServerShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateServerShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateServerShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateServerShardsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateServerShardsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateServerShardsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< UpdateServerShardsActor, 3, IndexRangeVec >*)0, actor_cancelled()); break;
		}

	}
};
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
[[nodiscard]] static Future<Void> updateServerShards( Database const& cx, SkewedReadWriteWorkload* const& self ) {
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	return Future<Void>(new UpdateServerShardsActor(cx, self));
															#line 1097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
}

#line 183 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"

																#line 1102 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
// This generated class is to be used only via readOp()
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class Trans, class ReadOpActor>
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class ReadOpActorState {
															#line 1108 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	ReadOpActorState(Trans* const& tr,std::vector<int64_t> const& keys,SkewedReadWriteWorkload* const& self,bool const& shouldRecord) 
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		 : tr(tr),
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   keys(keys),
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   self(self),
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   shouldRecord(shouldRecord)
															#line 1121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
	{
		fdb_probe_actor_create("readOp", reinterpret_cast<unsigned long>(this));

	}
	~ReadOpActorState() 
	{
		fdb_probe_actor_destroy("readOp", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (!keys.size())
															#line 1136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			{
															#line 187 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				if (!static_cast<ReadOpActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadOpActorState(); static_cast<ReadOpActor*>(this)->destroy(); return 0; }
															#line 1140 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
				new (&static_cast<ReadOpActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ReadOpActorState();
				static_cast<ReadOpActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 189 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			std::vector<Future<Void>> readers;
															#line 190 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			for(int op = 0;op < keys.size();op++) {
															#line 191 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				++self->totalReadsMetric;
															#line 192 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				readers.push_back(self->logLatency(tr->get(self->keyForIndex(keys[op])), shouldRecord));
															#line 1154 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(readers);
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (static_cast<ReadOpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadOpActor*>(this)->actor_wait_state = 1;
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadOpActor, 0, Void >*>(static_cast<ReadOpActor*>(this)));
															#line 1165 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadOpActorState();
		static_cast<ReadOpActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!static_cast<ReadOpActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadOpActorState(); static_cast<ReadOpActor*>(this)->destroy(); return 0; }
															#line 1188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		new (&static_cast<ReadOpActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadOpActorState();
		static_cast<ReadOpActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!static_cast<ReadOpActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadOpActorState(); static_cast<ReadOpActor*>(this)->destroy(); return 0; }
															#line 1200 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		new (&static_cast<ReadOpActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadOpActorState();
		static_cast<ReadOpActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadOpActor*>(this)->actor_wait_state > 0) static_cast<ReadOpActor*>(this)->actor_wait_state = 0;
		static_cast<ReadOpActor*>(this)->ActorCallback< ReadOpActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadOpActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadOpActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadOpActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Trans* tr;
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	std::vector<int64_t> keys;
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	SkewedReadWriteWorkload* self;
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	bool shouldRecord;
															#line 1291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
};
// This generated class is to be used only via readOp()
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class Trans>
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class ReadOpActor final : public Actor<Void>, public ActorCallback< ReadOpActor<Trans>, 0, Void >, public FastAllocated<ReadOpActor<Trans>>, public ReadOpActorState<Trans, ReadOpActor<Trans>> {
															#line 1298 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
	using FastAllocated<ReadOpActor<Trans>>::operator new;
	using FastAllocated<ReadOpActor<Trans>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1380513304896996864UL, 10467349854075691776UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadOpActor<Trans>, 0, Void >;
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	ReadOpActor(Trans* const& tr,std::vector<int64_t> const& keys,SkewedReadWriteWorkload* const& self,bool const& shouldRecord) 
															#line 1315 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		 : Actor<Void>(),
		   ReadOpActorState<Trans, ReadOpActor<Trans>>(tr, keys, self, shouldRecord),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readOp", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15853825162189741056UL, 8477943874070745600UL);
		ActorExecutionContextHelper __helper(static_cast<ReadOpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readOp");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readOp", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadOpActor<Trans>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class Trans>
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
[[nodiscard]] Future<Void> readOp( Trans* const& tr, std::vector<int64_t> const& keys, SkewedReadWriteWorkload* const& self, bool const& shouldRecord ) {
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	return Future<Void>(new ReadOpActor<Trans>(tr, keys, self, shouldRecord));
															#line 1349 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
}

#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"

	void startReadWriteClients(Database cx, std::vector<Future<Void>>& clients) {
		clientBegin = now();
		for (int c = 0; c < actorCount; c++) {
			Future<Void> worker;
			if (useRYW)
				worker =
				    randomReadWriteClient<ReadYourWritesTransaction>(cx, this, actorCount / transactionsPerSecond, c);
			else
				worker = randomReadWriteClient<Transaction>(cx, this, actorCount / transactionsPerSecond, c);
			clients.push_back(worker);
		}
	}

																#line 1367 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class _startActor>
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class _startActorState {
															#line 1373 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	_startActorState(Database const& cx,SkewedReadWriteWorkload* const& self) 
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		 : cx(cx),
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   self(self),
															#line 213 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   clients()
															#line 1384 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 214 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (self->enableReadLatencyLogging)
															#line 1399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			{
															#line 215 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				clients.push_back(self->tracePeriodically());
															#line 1403 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = updateServerShards(cx, self);
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1409 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1414 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->currentHotRound = 0;
															#line 1437 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->currentHotRound = 0;
															#line 1446 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 227 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1530 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!(self->currentHotRound < self->skewRound))
															#line 1549 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 219 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->setHotServers();
															#line 220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->startReadWriteClients(cx, clients);
															#line 221 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeout(waitForAll(clients), self->testDuration / self->skewRound, Void());
															#line 221 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1561 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 221 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1566 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		clients.clear();
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1592 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1597 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		clients.clear();
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1610 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1615 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_3 = updateServerShards(cx, self);
															#line 224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1701 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1706 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_3 = updateServerShards(cx, self);
															#line 224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1717 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		++self->currentHotRound;
															#line 1806 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		++self->currentHotRound;
															#line 1815 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Database cx;
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	SkewedReadWriteWorkload* self;
															#line 213 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	std::vector<Future<Void>> clients;
															#line 1901 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1906 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(948444657172109312UL, 9589894259750233088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	_startActor(Database const& cx,SkewedReadWriteWorkload* const& self) 
															#line 1926 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, SkewedReadWriteWorkload* const& self ) {
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1961 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
}

#line 229 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"

	// calculate hot server count
	void setHotServers() {
		hotServerCount = ceil(hotServerFraction * serverShards.size());
		std::cout << "Choose " << hotServerCount << "/" << serverShards.size() << "/" << serverInterfaces.size()
		          << " hot servers: [";
		int begin = currentHotRound * hotServerCount;
		for (int i = 0; i < hotServerCount; ++i) {
			int idx = (begin + i) % serverShards.size();
			std::cout << serverInterfaces.at(serverShards[idx].first).address().toString() << ",";
		}
		std::cout << "]\n";
	}

	int64_t getRandomKeyFromHotServer(bool hotServerRead = true) {
		ASSERT(hotServerCount > 0);
		int begin = currentHotRound * hotServerCount;
		if (!hotServerRead) {
			begin += hotServerCount * (1.0 - hotReadWriteServerOverlap); // calculate non-overlap part offset
		}
		int idx = deterministicRandom()->randomInt(begin, begin + hotServerCount) % serverShards.size();
		int shardMax = std::min(serverShards[idx].second.size(),
		                        (size_t)ceil(serverShards[idx].second.size() * hotServerShardFraction));
		int shardIdx = deterministicRandom()->randomInt(0, shardMax);
		return deterministicRandom()->randomInt64(serverShards[idx].second[shardIdx].first,
		                                          serverShards[idx].second[shardIdx].second + 1);
	}

	int64_t getRandomKey(uint64_t nodeCount, bool hotServerRead = true) {
		auto random = deterministicRandom()->random01();
		if (hotServerFraction > 0) {
			if ((hotServerRead && random < hotServerReadFrac) || (!hotServerRead && random < hotServerWriteFrac)) {
				return getRandomKeyFromHotServer(hotServerRead);
			}
		}
		return deterministicRandom()->randomInt64(0, nodeCount);
	}

																#line 2003 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
// This generated class is to be used only via randomReadWriteClient()
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class Trans, class RandomReadWriteClientActor>
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class RandomReadWriteClientActorState {
															#line 2009 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	RandomReadWriteClientActorState(Database const& cx,SkewedReadWriteWorkload* const& self,double const& delay,int const& clientIndex) 
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		 : cx(cx),
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   self(self),
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   delay(delay),
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   clientIndex(clientIndex),
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   lastTime(now()),
															#line 270 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   GRVStartTime(),
															#line 271 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		   debugID()
															#line 2028 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
	{
		fdb_probe_actor_create("randomReadWriteClient", reinterpret_cast<unsigned long>(this));

	}
	~RandomReadWriteClientActorState() 
	{
		fdb_probe_actor_destroy("randomReadWriteClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 273 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			;
															#line 2043 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RandomReadWriteClientActorState();
		static_cast<RandomReadWriteClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, delay);
															#line 274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2075 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 1;
															#line 274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 0, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 2080 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		tstart = now();
															#line 277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		aTransaction = deterministicRandom()->random01() > self->alpha;
															#line 279 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		keys = std::vector<int64_t>();
															#line 280 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		values = std::vector<Value>();
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		extra_ranges = std::vector<KeyRange>();
															#line 282 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		int reads = aTransaction ? self->readsPerTransactionA : self->readsPerTransactionB;
															#line 283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		writes = aTransaction ? self->writesPerTransactionA : self->writesPerTransactionB;
															#line 284 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(int op = 0;op < reads;op++) {
															#line 285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			keys.push_back(self->getRandomKey(self->nodeCount));
															#line 2105 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 287 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		values.reserve(writes);
															#line 288 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(int op = 0;op < writes;op++) {
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			values.push_back(self->randomValue());
															#line 2113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		tr = Trans(cx);
															#line 293 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (tstart - self->clientBegin > self->debugTime && tstart - self->clientBegin <= self->debugTime + self->debugInterval)
															#line 2119 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 295 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			debugID = deterministicRandom()->randomUniqueID();
															#line 296 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			tr.debugTransaction(debugID);
															#line 297 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.first(), "ReadWrite.randomReadWriteClient.Before");
															#line 2127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
		else
		{
															#line 299 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			debugID = UID();
															#line 2133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 302 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->transactionSuccessMetric->retries = 0;
															#line 303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->transactionSuccessMetric->commitLatency = -1;
															#line 305 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		;
															#line 2141 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 276 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		tstart = now();
															#line 277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		aTransaction = deterministicRandom()->random01() > self->alpha;
															#line 279 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		keys = std::vector<int64_t>();
															#line 280 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		values = std::vector<Value>();
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		extra_ranges = std::vector<KeyRange>();
															#line 282 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		int reads = aTransaction ? self->readsPerTransactionA : self->readsPerTransactionB;
															#line 283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		writes = aTransaction ? self->writesPerTransactionA : self->writesPerTransactionB;
															#line 284 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(int op = 0;op < reads;op++) {
															#line 285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			keys.push_back(self->getRandomKey(self->nodeCount));
															#line 2166 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 287 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		values.reserve(writes);
															#line 288 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(int op = 0;op < writes;op++) {
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			values.push_back(self->randomValue());
															#line 2174 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		tr = Trans(cx);
															#line 293 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (tstart - self->clientBegin > self->debugTime && tstart - self->clientBegin <= self->debugTime + self->debugInterval)
															#line 2180 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 295 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			debugID = deterministicRandom()->randomUniqueID();
															#line 296 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			tr.debugTransaction(debugID);
															#line 297 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.first(), "ReadWrite.randomReadWriteClient.Before");
															#line 2188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
		else
		{
															#line 299 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			debugID = UID();
															#line 2194 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 302 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->transactionSuccessMetric->retries = 0;
															#line 303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->transactionSuccessMetric->commitLatency = -1;
															#line 305 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		;
															#line 2202 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 352 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (debugID != UID())
															#line 2286 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 353 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.first(), "ReadWrite.randomReadWriteClient.After");
															#line 2290 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 355 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		tr = Trans();
															#line 357 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		double transactionLatency = now() - tstart;
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->transactionSuccessMetric->totalLatency = transactionLatency * 1e9;
															#line 359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->transactionSuccessMetric->log();
															#line 361 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 2302 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 362 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (aTransaction)
															#line 2306 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			{
															#line 363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				++self->aTransactions;
															#line 2310 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
			else
			{
															#line 365 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				++self->bTransactions;
															#line 2316 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
															#line 367 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->latencies.addSample(transactionLatency);
															#line 2320 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 307 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			GRVStartTime = now();
															#line 308 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->transactionFailureMetric->startLatency = -1;
															#line 310 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			double grvLatency = now() - GRVStartTime;
															#line 311 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->transactionSuccessMetric->startLatency = grvLatency * 1e9;
															#line 312 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->transactionFailureMetric->startLatency = grvLatency * 1e9;
															#line 313 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (self->shouldRecord())
															#line 2348 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			{
															#line 314 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				self->GRVLatencies.addSample(grvLatency);
															#line 2352 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
															#line 316 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			readStart = now();
															#line 317 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->readOp(&tr, keys, self, self->shouldRecord());
															#line 317 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2360 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 2;
															#line 317 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 1, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 2365 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 339 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->transactionFailureMetric->errorCode = e.code();
															#line 340 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->transactionFailureMetric->log();
															#line 342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2406 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 4;
															#line 342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 3, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 2411 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		double readLatency = now() - readStart;
															#line 320 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 2428 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 321 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->fullReadLatencies.addSample(readLatency);
															#line 2432 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!writes)
															#line 2436 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 326 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(int op = 0;op < writes;op++) {
															#line 327 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			tr.set(self->keyForIndex(self->getRandomKey(self->nodeCount, false), false), values[op]);
															#line 2444 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		commitStart = now();
															#line 330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2452 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 3;
															#line 330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 2, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 2457 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		double readLatency = now() - readStart;
															#line 320 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 2468 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 321 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->fullReadLatencies.addSample(readLatency);
															#line 2472 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (!writes)
															#line 2476 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 326 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		for(int op = 0;op < writes;op++) {
															#line 327 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			tr.set(self->keyForIndex(self->getRandomKey(self->nodeCount, false), false), values[op]);
															#line 2484 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
															#line 329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		commitStart = now();
															#line 330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2492 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 3;
															#line 330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RandomReadWriteClientActor, 2, Void >*>(static_cast<RandomReadWriteClientActor*>(this)));
															#line 2497 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		double commitLatency = now() - commitStart;
															#line 333 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->transactionSuccessMetric->commitLatency = commitLatency * 1e9;
															#line 334 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 2585 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->commitLatencies.addSample(commitLatency);
															#line 2589 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		double commitLatency = now() - commitStart;
															#line 333 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		self->transactionSuccessMetric->commitLatency = commitLatency * 1e9;
															#line 334 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 2603 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			self->commitLatencies.addSample(commitLatency);
															#line 2607 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 344 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		++self->transactionSuccessMetric->retries;
															#line 345 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		++self->totalRetriesMetric;
															#line 347 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 2696 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 348 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			++self->retries;
															#line 2700 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 344 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		++self->transactionSuccessMetric->retries;
															#line 345 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		++self->totalRetriesMetric;
															#line 347 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		if (self->shouldRecord())
															#line 2714 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		{
															#line 348 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			++self->retries;
															#line 2718 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state > 0) static_cast<RandomReadWriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<RandomReadWriteClientActor*>(this)->ActorCallback< RandomReadWriteClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RandomReadWriteClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RandomReadWriteClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Database cx;
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	SkewedReadWriteWorkload* self;
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	double delay;
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	int clientIndex;
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	double lastTime;
															#line 270 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	double GRVStartTime;
															#line 271 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	UID debugID;
															#line 276 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	double tstart;
															#line 277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	bool aTransaction;
															#line 279 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	std::vector<int64_t> keys;
															#line 280 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	std::vector<Value> values;
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	std::vector<KeyRange> extra_ranges;
															#line 283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	int writes;
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	Trans tr;
															#line 316 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	double readStart;
															#line 329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	double commitStart;
															#line 2831 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
};
// This generated class is to be used only via randomReadWriteClient()
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class Trans>
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class RandomReadWriteClientActor final : public Actor<Void>, public ActorCallback< RandomReadWriteClientActor<Trans>, 0, Void >, public ActorCallback< RandomReadWriteClientActor<Trans>, 1, Void >, public ActorCallback< RandomReadWriteClientActor<Trans>, 2, Void >, public ActorCallback< RandomReadWriteClientActor<Trans>, 3, Void >, public FastAllocated<RandomReadWriteClientActor<Trans>>, public RandomReadWriteClientActorState<Trans, RandomReadWriteClientActor<Trans>> {
															#line 2838 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
	using FastAllocated<RandomReadWriteClientActor<Trans>>::operator new;
	using FastAllocated<RandomReadWriteClientActor<Trans>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8478825217575979520UL, 595832542517331456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 0, Void >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 1, Void >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 2, Void >;
friend struct ActorCallback< RandomReadWriteClientActor<Trans>, 3, Void >;
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	RandomReadWriteClientActor(Database const& cx,SkewedReadWriteWorkload* const& self,double const& delay,int const& clientIndex) 
															#line 2858 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		 : Actor<Void>(),
		   RandomReadWriteClientActorState<Trans, RandomReadWriteClientActor<Trans>>(cx, self, delay, clientIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("randomReadWriteClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12898104532379093504UL, 5927556942979663104UL);
		ActorExecutionContextHelper __helper(static_cast<RandomReadWriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("randomReadWriteClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("randomReadWriteClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RandomReadWriteClientActor<Trans>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class Trans>
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
[[nodiscard]] Future<Void> randomReadWriteClient( Database const& cx, SkewedReadWriteWorkload* const& self, double const& delay, int const& clientIndex ) {
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	return Future<Void>(new RandomReadWriteClientActor<Trans>(cx, self, delay, clientIndex));
															#line 2895 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
}

#line 371 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
};

WorkloadFactory<SkewedReadWriteWorkload> SkewedReadWriteWorkloadFactory;

															#line 2903 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase375()
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
template <class FlowTestCase375Actor>
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class FlowTestCase375ActorState {
															#line 2910 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	FlowTestCase375ActorState(UnitTestParameters const& params) 
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
		 : params(params)
															#line 2917 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase375", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase375ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase375", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 376 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			WorkloadContext wcx;
															#line 377 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			wcx.clientId = 1;
															#line 378 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			wcx.clientCount = 1;
															#line 379 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			wcx.sharedRandomNumber = 1;
															#line 381 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			auto wk = TestWorkloadImpl<SkewedReadWriteWorkload>(wcx);
															#line 382 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			for(int i = 0;i < 1000;++i) {
															#line 383 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				auto idx = deterministicRandom()->randomInt64(0, wk.nodeCount);
															#line 384 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				Key k = wk.keyForIndex(idx);
															#line 385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				auto parse = wk.indexForKey(k);
															#line 387 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				ASSERT(parse == idx);
															#line 2950 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
															#line 389 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			for(int i = 0;i < 1000;++i) {
															#line 390 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				auto idx = deterministicRandom()->randomInt64(0, wk.nodeCount);
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				Key k = wk.keyForIndex(idx, true);
															#line 392 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				auto parse = wk.indexForKey(k, true);
															#line 393 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
				ASSERT(parse == idx);
															#line 2962 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			}
															#line 395 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
			if (!static_cast<FlowTestCase375Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase375ActorState(); static_cast<FlowTestCase375Actor*>(this)->destroy(); return 0; }
															#line 2966 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
			new (&static_cast<FlowTestCase375Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase375ActorState();
			static_cast<FlowTestCase375Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase375ActorState();
		static_cast<FlowTestCase375Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	UnitTestParameters params;
															#line 2990 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase375()
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
class FlowTestCase375Actor final : public Actor<Void>, public FastAllocated<FlowTestCase375Actor>, public FlowTestCase375ActorState<FlowTestCase375Actor> {
															#line 2995 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase375Actor>::operator new;
	using FastAllocated<FlowTestCase375Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(71706526102932992UL, 9349876620126761984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	FlowTestCase375Actor(UnitTestParameters const& params) 
															#line 3011 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase375ActorState<FlowTestCase375Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase375", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17713018226751864576UL, 17416990819907966976UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase375Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase375");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase375", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
static Future<Void> flowTestCase375( UnitTestParameters const& params ) {
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
	return Future<Void>(new FlowTestCase375Actor(params));
															#line 3043 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SkewedReadWrite.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase375, "/KVWorkload/methods/ParseKeyForIndex")

#line 397 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/SkewedReadWrite.actor.cpp"
