#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
/*
 * ClientWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#include <fmt/format.h>

#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // has to be last include

class WorkloadProcessState {
	IPAddress childAddress;
	std::string processName;
	Future<Void> processActor;
	Promise<Void> init;

	WorkloadProcessState(int clientId) : clientId(clientId) { processActor = processStart(this); }

	~WorkloadProcessState() {
		TraceEvent("ShutdownClientForWorkload", id).log();
		g_simulator->destroyProcess(childProcess);
	}

																#line 46 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
// This generated class is to be used only via initializationDone()
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class InitializationDoneActor>
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class InitializationDoneActorState {
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	InitializationDoneActorState(WorkloadProcessState* const& self,ISimulator::ProcessInfo* const& parent) 
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		 : self(self),
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   parent(parent)
															#line 61 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("initializationDone", reinterpret_cast<unsigned long>(this));

	}
	~InitializationDoneActorState() 
	{
		fdb_probe_actor_destroy("initializationDone", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 45 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_simulator->onProcess(parent, TaskPriority::DefaultYield);
															#line 45 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (static_cast<InitializationDoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitializationDoneActor*>(this)->actor_wait_state = 1;
															#line 45 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitializationDoneActor, 0, Void >*>(static_cast<InitializationDoneActor*>(this)));
															#line 83 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitializationDoneActorState();
		static_cast<InitializationDoneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 46 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		self->init.send(Void());
															#line 47 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = Never();
															#line 47 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (static_cast<InitializationDoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitializationDoneActor*>(this)->actor_wait_state = 2;
															#line 47 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializationDoneActor, 1, Void >*>(static_cast<InitializationDoneActor*>(this)));
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 46 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		self->init.send(Void());
															#line 47 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = Never();
															#line 47 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (static_cast<InitializationDoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitializationDoneActor*>(this)->actor_wait_state = 2;
															#line 47 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializationDoneActor, 1, Void >*>(static_cast<InitializationDoneActor*>(this)));
															#line 133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitializationDoneActor*>(this)->actor_wait_state > 0) static_cast<InitializationDoneActor*>(this)->actor_wait_state = 0;
		static_cast<InitializationDoneActor*>(this)->ActorCallback< InitializationDoneActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializationDoneActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initializationDone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializationDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializationDone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitializationDoneActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initializationDone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializationDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializationDone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitializationDoneActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initializationDone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializationDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializationDone", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		ASSERT(false);
															#line 49 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (!static_cast<InitializationDoneActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializationDoneActorState(); static_cast<InitializationDoneActor*>(this)->destroy(); return 0; }
															#line 219 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		new (&static_cast<InitializationDoneActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializationDoneActorState();
		static_cast<InitializationDoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 48 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		ASSERT(false);
															#line 49 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (!static_cast<InitializationDoneActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializationDoneActorState(); static_cast<InitializationDoneActor*>(this)->destroy(); return 0; }
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		new (&static_cast<InitializationDoneActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializationDoneActorState();
		static_cast<InitializationDoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitializationDoneActor*>(this)->actor_wait_state > 0) static_cast<InitializationDoneActor*>(this)->actor_wait_state = 0;
		static_cast<InitializationDoneActor*>(this)->ActorCallback< InitializationDoneActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializationDoneActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initializationDone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializationDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializationDone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitializationDoneActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initializationDone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializationDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializationDone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitializationDoneActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initializationDone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializationDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializationDone", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	WorkloadProcessState* self;
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ISimulator::ProcessInfo* parent;
															#line 320 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
};
// This generated class is to be used only via initializationDone()
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class InitializationDoneActor final : public Actor<Void>, public ActorCallback< InitializationDoneActor, 0, Void >, public ActorCallback< InitializationDoneActor, 1, Void >, public FastAllocated<InitializationDoneActor>, public InitializationDoneActorState<InitializationDoneActor> {
															#line 325 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
	using FastAllocated<InitializationDoneActor>::operator new;
	using FastAllocated<InitializationDoneActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12045655225745641984UL, 9622434226952625920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitializationDoneActor, 0, Void >;
friend struct ActorCallback< InitializationDoneActor, 1, Void >;
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	InitializationDoneActor(WorkloadProcessState* const& self,ISimulator::ProcessInfo* const& parent) 
															#line 343 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   InitializationDoneActorState<InitializationDoneActor>(self, parent),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initializationDone", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16384567402191419392UL, 5407696360481014272UL);
		ActorExecutionContextHelper __helper(static_cast<InitializationDoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initializationDone");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initializationDone", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitializationDoneActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitializationDoneActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
[[nodiscard]] static Future<Void> initializationDone( WorkloadProcessState* const& self, ISimulator::ProcessInfo* const& parent ) {
															#line 44 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	return Future<Void>(new InitializationDoneActor(self, parent));
															#line 376 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
}

#line 51 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"

																#line 381 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
// This generated class is to be used only via processStart()
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class ProcessStartActor>
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class ProcessStartActorState {
															#line 387 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ProcessStartActorState(WorkloadProcessState* const& self) 
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		 : self(self),
															#line 53 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   parent(g_simulator->getCurrentProcess()),
															#line 54 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   futures()
															#line 398 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("processStart", reinterpret_cast<unsigned long>(this));

	}
	~ProcessStartActorState() 
	{
		fdb_probe_actor_destroy("processStart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 55 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (parent->address.isV6())
															#line 413 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			{
															#line 56 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
				self->childAddress = IPAddress::parse(fmt::format("2001:fdb1:fdb2:fdb3:fdb4:fdb5:fdb6:{:04x}", self->clientId + 2)).get();
															#line 417 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			}
			else
			{
															#line 59 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
				self->childAddress = IPAddress::parse(fmt::format("192.168.0.{}", self->clientId + 2)).get();
															#line 423 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			}
															#line 61 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			self->processName = fmt::format("TestClient{}", self->clientId);
															#line 62 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			Standalone<StringRef> newZoneId(deterministicRandom()->randomUniqueID().toString());
															#line 63 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			auto locality = LocalityData(Optional<Standalone<StringRef>>(), newZoneId, newZoneId, parent->locality.dcId());
															#line 64 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			auto dataFolder = joinPath(popPath(parent->dataFolder), deterministicRandom()->randomUniqueID().toString());
															#line 65 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			platform::createDirectory(dataFolder);
															#line 66 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			TraceEvent("StartingClientWorkloadProcess", self->id) .detail("Name", self->processName) .detail("Address", self->childAddress);
															#line 69 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			self->childProcess = g_simulator->newProcess(self->processName.c_str(), self->childAddress, 1, parent->address.isTLS(), 1, locality, ProcessClass(ProcessClass::TesterClass, ProcessClass::AutoSource), dataFolder.c_str(), parent->coordinationFolder.c_str(), parent->protocolVersion, false);
															#line 80 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			self->childProcess->excludeFromRestarts = true;
															#line 81 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_simulator->onProcess(self->childProcess, TaskPriority::DefaultYield);
															#line 81 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (static_cast<ProcessStartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 445 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProcessStartActor*>(this)->actor_wait_state = 1;
															#line 81 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessStartActor, 0, Void >*>(static_cast<ProcessStartActor*>(this)));
															#line 450 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessStartActorState();
		static_cast<ProcessStartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 83 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			FlowTransport::createInstance(true, 1, WLTOKEN_RESERVED_COUNT);
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			Sim2FileSystem::newFileSystem();
															#line 85 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			auto addr = g_simulator->getCurrentProcess()->address;
															#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			futures.push_back(FlowTransport::transport().bind(addr, addr));
															#line 87 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			futures.push_back(success((self->childProcess->onShutdown())));
															#line 88 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			TraceEvent("ClientWorkloadProcessInitialized", self->id).log();
															#line 89 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			futures.push_back(initializationDone(self, parent));
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAny(futures);
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (static_cast<ProcessStartActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 490 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ProcessStartActor*>(this)->actor_wait_state = 2;
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessStartActor, 1, Void >*>(static_cast<ProcessStartActor*>(this)));
															#line 495 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 83 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			FlowTransport::createInstance(true, 1, WLTOKEN_RESERVED_COUNT);
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			Sim2FileSystem::newFileSystem();
															#line 85 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			auto addr = g_simulator->getCurrentProcess()->address;
															#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			futures.push_back(FlowTransport::transport().bind(addr, addr));
															#line 87 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			futures.push_back(success((self->childProcess->onShutdown())));
															#line 88 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			TraceEvent("ClientWorkloadProcessInitialized", self->id).log();
															#line 89 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			futures.push_back(initializationDone(self, parent));
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = waitForAny(futures);
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (static_cast<ProcessStartActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 527 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ProcessStartActor*>(this)->actor_wait_state = 2;
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessStartActor, 1, Void >*>(static_cast<ProcessStartActor*>(this)));
															#line 532 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessStartActor*>(this)->actor_wait_state > 0) static_cast<ProcessStartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStartActor*>(this)->ActorCallback< ProcessStartActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStartActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessStartActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessStartActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 97 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		ASSERT(false);
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (!static_cast<ProcessStartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessStartActorState(); static_cast<ProcessStartActor*>(this)->destroy(); return 0; }
															#line 624 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		new (&static_cast<ProcessStartActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ProcessStartActorState();
		static_cast<ProcessStartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 92 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 637 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			{
															#line 93 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
				if (!static_cast<ProcessStartActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ProcessStartActorState(); static_cast<ProcessStartActor*>(this)->destroy(); return 0; }
															#line 641 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
				new (&static_cast<ProcessStartActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ProcessStartActorState();
				static_cast<ProcessStartActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 95 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			ASSERT(false);
															#line 649 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessStartActor*>(this)->actor_wait_state > 0) static_cast<ProcessStartActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessStartActor*>(this)->ActorCallback< ProcessStartActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessStartActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processStart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessStartActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processStart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessStartActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processStart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processStart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	WorkloadProcessState* self;
															#line 53 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ISimulator::ProcessInfo* parent;
															#line 54 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 766 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
};
// This generated class is to be used only via processStart()
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class ProcessStartActor final : public Actor<Void>, public ActorCallback< ProcessStartActor, 0, Void >, public ActorCallback< ProcessStartActor, 1, Void >, public FastAllocated<ProcessStartActor>, public ProcessStartActorState<ProcessStartActor> {
															#line 771 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
	using FastAllocated<ProcessStartActor>::operator new;
	using FastAllocated<ProcessStartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10802759546686864384UL, 10369111409711184128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessStartActor, 0, Void >;
friend struct ActorCallback< ProcessStartActor, 1, Void >;
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ProcessStartActor(WorkloadProcessState* const& self) 
															#line 789 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ProcessStartActorState<ProcessStartActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processStart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18261818386273492736UL, 12007918010196422400UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessStartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processStart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processStart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessStartActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessStartActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
[[nodiscard]] static Future<Void> processStart( WorkloadProcessState* const& self ) {
															#line 52 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	return Future<Void>(new ProcessStartActor(self));
															#line 822 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
}

#line 100 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"

	static std::vector<WorkloadProcessState*>& states() {
		static std::vector<WorkloadProcessState*> res;
		return res;
	}

public:
	static WorkloadProcessState* instance(int clientId) {
		states().resize(std::max(states().size(), size_t(clientId + 1)), nullptr);
		auto& res = states()[clientId];
		if (res == nullptr) {
			res = new WorkloadProcessState(clientId);
		}
		return res;
	}

	Future<Void> initialized() const { return init.getFuture(); }

	UID id = deterministicRandom()->randomUniqueID();
	int clientId;
	ISimulator::ProcessInfo* childProcess;
};

struct WorkloadProcess {
	WorkloadProcessState* processState;
	WorkloadContext childWorkloadContext;
	UID id = deterministicRandom()->randomUniqueID();
	Database cx;
	Future<Void> databaseOpened;
	Reference<TestWorkload> child;
	std::string desc;

	void createDatabase(ClientWorkload::CreateWorkload const& childCreator, WorkloadContext const& wcx) {
		try {
			child = childCreator(wcx);
			TraceEvent("ClientWorkloadOpenDatabase", id).detail("ClusterFileLocation", child->ccr->getLocation());
			cx = Database::createDatabase(child->ccr, ApiVersion::LATEST_VERSION);
			desc = child->description();
		} catch (Error&) {
			throw;
		} catch (...) {
			ASSERT(false);
		}
	}

																#line 871 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
// This generated class is to be used only via openDatabase()
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class OpenDatabaseActor>
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class OpenDatabaseActorState {
															#line 877 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	OpenDatabaseActorState(WorkloadProcess* const& self,ClientWorkload::CreateWorkload const& childCreator,WorkloadContext const& wcx) 
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		 : self(self),
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   childCreator(childCreator),
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   wcx(wcx),
															#line 148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   parent(g_simulator->getCurrentProcess()),
															#line 149 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   err()
															#line 892 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("openDatabase", reinterpret_cast<unsigned long>(this));

	}
	~OpenDatabaseActorState() 
	{
		fdb_probe_actor_destroy("openDatabase", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			wcx.dbInfo = Reference<AsyncVar<struct ServerDBInfo> const>();
															#line 151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->processState->initialized();
															#line 151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 911 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 1;
															#line 151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 0, Void >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 916 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = g_simulator->onProcess(self->childProcess(), TaskPriority::DefaultYield);
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 941 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 2;
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 1, Void >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 946 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = g_simulator->onProcess(self->childProcess(), TaskPriority::DefaultYield);
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 957 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 2;
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 1, Void >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 962 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<OpenDatabaseActor*>(this)->ActorCallback< OpenDatabaseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OpenDatabaseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		try {
															#line 154 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			self->createDatabase(childCreator, wcx);
															#line 1047 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		try {
															#line 154 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			self->createDatabase(childCreator, wcx);
															#line 1063 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<OpenDatabaseActor*>(this)->ActorCallback< OpenDatabaseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OpenDatabaseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 159 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = g_simulator->onProcess(parent, TaskPriority::DefaultYield);
															#line 159 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 3;
															#line 159 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OpenDatabaseActor, 2, Void >*>(static_cast<OpenDatabaseActor*>(this)));
															#line 1160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			ASSERT(e.code() != error_code_actor_cancelled);
															#line 157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			err = e;
															#line 1172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (err.present())
															#line 1200 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			return a_body1Catch1(err.get(), loopDepth);
															#line 1204 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		}
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (!static_cast<OpenDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 1208 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		new (&static_cast<OpenDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (err.present())
															#line 1220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			return a_body1Catch1(err.get(), loopDepth);
															#line 1224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		}
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (!static_cast<OpenDatabaseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OpenDatabaseActorState(); static_cast<OpenDatabaseActor*>(this)->destroy(); return 0; }
															#line 1228 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		new (&static_cast<OpenDatabaseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OpenDatabaseActorState();
		static_cast<OpenDatabaseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<OpenDatabaseActor*>(this)->actor_wait_state > 0) static_cast<OpenDatabaseActor*>(this)->actor_wait_state = 0;
		static_cast<OpenDatabaseActor*>(this)->ActorCallback< OpenDatabaseActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OpenDatabaseActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OpenDatabaseActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	WorkloadProcess* self;
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ClientWorkload::CreateWorkload childCreator;
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	WorkloadContext wcx;
															#line 148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ISimulator::ProcessInfo* parent;
															#line 149 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	Optional<Error> err;
															#line 1321 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
};
// This generated class is to be used only via openDatabase()
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class OpenDatabaseActor final : public Actor<Void>, public ActorCallback< OpenDatabaseActor, 0, Void >, public ActorCallback< OpenDatabaseActor, 1, Void >, public ActorCallback< OpenDatabaseActor, 2, Void >, public FastAllocated<OpenDatabaseActor>, public OpenDatabaseActorState<OpenDatabaseActor> {
															#line 1326 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
	using FastAllocated<OpenDatabaseActor>::operator new;
	using FastAllocated<OpenDatabaseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17248224535639949312UL, 1310920466769762048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OpenDatabaseActor, 0, Void >;
friend struct ActorCallback< OpenDatabaseActor, 1, Void >;
friend struct ActorCallback< OpenDatabaseActor, 2, Void >;
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	OpenDatabaseActor(WorkloadProcess* const& self,ClientWorkload::CreateWorkload const& childCreator,WorkloadContext const& wcx) 
															#line 1345 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   OpenDatabaseActorState<OpenDatabaseActor>(self, childCreator, wcx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("openDatabase", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17000073936038550016UL, 17255821604456520192UL);
		ActorExecutionContextHelper __helper(static_cast<OpenDatabaseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("openDatabase");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("openDatabase", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OpenDatabaseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OpenDatabaseActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< OpenDatabaseActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
[[nodiscard]] static Future<Void> openDatabase( WorkloadProcess* const& self, ClientWorkload::CreateWorkload const& childCreator, WorkloadContext const& wcx ) {
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	return Future<Void>(new OpenDatabaseActor(self, childCreator, wcx));
															#line 1379 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
}

#line 165 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"

	ISimulator::ProcessInfo* childProcess() { return processState->childProcess; }

	int clientId() const { return processState->clientId; }

	WorkloadProcess(ClientWorkload::CreateWorkload const& childCreator, WorkloadContext const& wcx)
	  : processState(WorkloadProcessState::instance(wcx.clientId)) {
		TraceEvent("StartingClientWorkload", id).detail("OnClientProcess", processState->id);
		childWorkloadContext.clientCount = wcx.clientCount;
		childWorkloadContext.clientId = wcx.clientId;
		childWorkloadContext.ccr = wcx.ccr;
		childWorkloadContext.options = wcx.options;
		childWorkloadContext.sharedRandomNumber = wcx.sharedRandomNumber;
		databaseOpened = openDatabase(this, childCreator, childWorkloadContext);
	}

																#line 1399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
// This generated class is to be used only via destroy()
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class DestroyActor>
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class DestroyActorState {
															#line 1405 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	DestroyActorState(WorkloadProcess* const& self) 
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		 : self(self),
															#line 182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   parent(g_simulator->getCurrentProcess())
															#line 1414 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("destroy", reinterpret_cast<unsigned long>(this));

	}
	~DestroyActorState() 
	{
		fdb_probe_actor_destroy("destroy", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 183 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_simulator->onProcess(self->childProcess(), TaskPriority::DefaultYield);
															#line 183 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1431 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			static_cast<DestroyActor*>(this)->actor_wait_state = 1;
															#line 183 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DestroyActor, 0, Void >*>(static_cast<DestroyActor*>(this)));
															#line 1435 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<DestroyActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		TraceEvent("DeleteWorkloadProcess").backtrace();
															#line 185 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		delete self;
															#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = g_simulator->onProcess(parent, TaskPriority::DefaultYield);
															#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		static_cast<DestroyActor*>(this)->actor_wait_state = 2;
															#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DestroyActor, 1, Void >*>(static_cast<DestroyActor*>(this)));
															#line 1467 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		TraceEvent("DeleteWorkloadProcess").backtrace();
															#line 185 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		delete self;
															#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = g_simulator->onProcess(parent, TaskPriority::DefaultYield);
															#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1482 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		static_cast<DestroyActor*>(this)->actor_wait_state = 2;
															#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DestroyActor, 1, Void >*>(static_cast<DestroyActor*>(this)));
															#line 1486 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DestroyActor*>(this)->actor_wait_state > 0) static_cast<DestroyActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyActor*>(this)->ActorCallback< DestroyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DestroyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroy", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DestroyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroy", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroy", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DestroyActor*>(this)->actor_wait_state > 0) static_cast<DestroyActor*>(this)->actor_wait_state = 0;
		static_cast<DestroyActor*>(this)->ActorCallback< DestroyActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DestroyActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("destroy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroy", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DestroyActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("destroy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroy", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DestroyActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("destroy", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("destroy", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		delete static_cast<DestroyActor*>(this);
															#line 1657 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	WorkloadProcess* self;
															#line 182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ISimulator::ProcessInfo* parent;
															#line 1666 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
};
// This generated class is to be used only via destroy()
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class DestroyActor final : public Actor<void>, public ActorCallback< DestroyActor, 0, Void >, public ActorCallback< DestroyActor, 1, Void >, public FastAllocated<DestroyActor>, public DestroyActorState<DestroyActor> {
															#line 1671 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
	using FastAllocated<DestroyActor>::operator new;
	using FastAllocated<DestroyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3773800657640167936UL, 2066112029161532160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< DestroyActor, 0, Void >;
friend struct ActorCallback< DestroyActor, 1, Void >;
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	DestroyActor(WorkloadProcess* const& self) 
															#line 1689 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		 : Actor<void>(),
		   DestroyActorState<DestroyActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("destroy", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(479933456537565440UL, 4651518792965485056UL);
		ActorExecutionContextHelper __helper(static_cast<DestroyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("destroy");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("destroy", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
static void destroy( WorkloadProcess* const& self ) {
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	new DestroyActor(self);
															#line 1712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
}

#line 188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"

	std::string description() { return desc; }

	// This actor will keep a reference to a future alive, switch to another process and then return. If the future
	// count of `f` is 1, this will cause the future to be destroyed in the process `process`
																#line 1721 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
// This generated class is to be used only via cancelChild()
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class T, class CancelChildActor>
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class CancelChildActorState {
															#line 1727 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	CancelChildActorState(ISimulator::ProcessInfo* const& process,Future<T> const& f) 
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		 : process(process),
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   f(f)
															#line 1736 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("cancelChild", reinterpret_cast<unsigned long>(this));

	}
	~CancelChildActorState() 
	{
		fdb_probe_actor_destroy("cancelChild", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_simulator->onProcess(process, TaskPriority::DefaultYield);
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1753 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			static_cast<CancelChildActor*>(this)->actor_wait_state = 1;
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancelChildActor, 0, Void >*>(static_cast<CancelChildActor*>(this)));
															#line 1757 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<CancelChildActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancelChildActor*>(this)->actor_wait_state > 0) static_cast<CancelChildActor*>(this)->actor_wait_state = 0;
		static_cast<CancelChildActor*>(this)->ActorCallback< CancelChildActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelChildActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelChild", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelChildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelChild", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancelChildActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelChild", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelChildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelChild", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancelChildActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelChild", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelChildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelChild", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		delete static_cast<CancelChildActor*>(this);
															#line 1866 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ISimulator::ProcessInfo* process;
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	Future<T> f;
															#line 1875 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
};
// This generated class is to be used only via cancelChild()
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class T>
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class CancelChildActor final : public Actor<void>, public ActorCallback< CancelChildActor<T>, 0, Void >, public FastAllocated<CancelChildActor<T>>, public CancelChildActorState<T, CancelChildActor<T>> {
															#line 1882 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
	using FastAllocated<CancelChildActor<T>>::operator new;
	using FastAllocated<CancelChildActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2859452541459469824UL, 16205708917302409984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< CancelChildActor<T>, 0, Void >;
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	CancelChildActor(ISimulator::ProcessInfo* const& process,Future<T> const& f) 
															#line 1899 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		 : Actor<void>(),
		   CancelChildActorState<T, CancelChildActor<T>>(process, f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancelChild", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10512297580688250368UL, 8733449525406707712UL);
		ActorExecutionContextHelper __helper(static_cast<CancelChildActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancelChild");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancelChild", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class T>
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
static void cancelChild( ISimulator::ProcessInfo* const& process, Future<T> const& f ) {
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	new CancelChildActor<T>(process, f);
															#line 1924 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
}

#line 197 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"

																#line 1929 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
// This generated class is to be used only via runActor()
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class Ret, class Fun, class RunActorActor>
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class RunActorActorState {
															#line 1935 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	RunActorActorState(WorkloadProcess* const& self,Optional<TenantName> const& defaultTenant,Fun const& f) 
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		 : self(self),
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   defaultTenant(defaultTenant),
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   f(f),
															#line 200 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   err(),
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   res(),
															#line 202 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   fut(),
															#line 203 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		   parent(g_simulator->getCurrentProcess())
															#line 1954 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("runActor", reinterpret_cast<unsigned long>(this));

	}
	~RunActorActorState() 
	{
		fdb_probe_actor_destroy("runActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 204 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->databaseOpened;
															#line 204 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (static_cast<RunActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1971 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunActorActor*>(this)->actor_wait_state = 1;
															#line 204 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActorActor, 0, Void >*>(static_cast<RunActorActor*>(this)));
															#line 1976 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorActorState();
		static_cast<RunActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 205 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = g_simulator->onProcess(self->childProcess(), TaskPriority::DefaultYield);
															#line 205 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (static_cast<RunActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2001 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunActorActor*>(this)->actor_wait_state = 2;
															#line 205 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActorActor, 1, Void >*>(static_cast<RunActorActor*>(this)));
															#line 2006 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 205 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = g_simulator->onProcess(self->childProcess(), TaskPriority::DefaultYield);
															#line 205 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (static_cast<RunActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunActorActor*>(this)->actor_wait_state = 2;
															#line 205 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActorActor, 1, Void >*>(static_cast<RunActorActor*>(this)));
															#line 2022 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActorActor*>(this)->actor_wait_state > 0) static_cast<RunActorActor*>(this)->actor_wait_state = 0;
		static_cast<RunActorActor*>(this)->ActorCallback< RunActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		self->cx->defaultTenant = defaultTenant;
															#line 2106 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		try {
															#line 208 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			fut = f(self->cx);
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Ret> __when_expr_2 = fut;
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (static_cast<RunActorActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 2114 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunActorActor*>(this)->actor_wait_state = 3;
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActorActor, 2, Ret >*>(static_cast<RunActorActor*>(this)));
															#line 2119 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		self->cx->defaultTenant = defaultTenant;
															#line 2134 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		try {
															#line 208 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			fut = f(self->cx);
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			StrictFuture<Ret> __when_expr_2 = fut;
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (static_cast<RunActorActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunActorActor*>(this)->actor_wait_state = 3;
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActorActor, 2, Ret >*>(static_cast<RunActorActor*>(this)));
															#line 2147 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActorActor*>(this)->actor_wait_state > 0) static_cast<RunActorActor*>(this)->actor_wait_state = 0;
		static_cast<RunActorActor*>(this)->ActorCallback< RunActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		fut = Future<Ret>();
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = g_simulator->onProcess(parent, TaskPriority::DefaultYield);
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (static_cast<RunActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2241 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<RunActorActor*>(this)->actor_wait_state = 4;
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunActorActor, 3, Void >*>(static_cast<RunActorActor*>(this)));
															#line 2246 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 216 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			cancelChild(self->childProcess(), fut);
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2258 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			{
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2262 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			}
															#line 220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			err = e;
															#line 2266 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Ret const& r,int loopDepth) 
	{
															#line 210 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		res = r;
															#line 2281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Ret && r,int loopDepth) 
	{
															#line 210 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		res = r;
															#line 2290 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Ret const& r,int loopDepth) 
	{
		loopDepth = a_body1cont4(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Ret && r,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunActorActor*>(this)->actor_wait_state > 0) static_cast<RunActorActor*>(this)->actor_wait_state = 0;
		static_cast<RunActorActor*>(this)->ActorCallback< RunActorActor, 2, Ret >::remove();

	}
	void a_callback_fire(ActorCallback< RunActorActor, 2, Ret >*,Ret const& value) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActorActor, 2, Ret >*,Ret && value) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActorActor, 2, Ret >*,Error err) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (err.present())
															#line 2387 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		{
															#line 225 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			return a_body1Catch1(err.get(), loopDepth);
															#line 2391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		}
															#line 227 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (!static_cast<RunActorActor*>(this)->SAV<Ret>::futures) { (void)(res); this->~RunActorActorState(); static_cast<RunActorActor*>(this)->destroy(); return 0; }
															#line 2395 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		new (&static_cast<RunActorActor*>(this)->SAV< Ret >::value()) Ret(std::move(res)); // state_var_RVO
		this->~RunActorActorState();
		static_cast<RunActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (err.present())
															#line 2407 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		{
															#line 225 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
			return a_body1Catch1(err.get(), loopDepth);
															#line 2411 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		}
															#line 227 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
		if (!static_cast<RunActorActor*>(this)->SAV<Ret>::futures) { (void)(res); this->~RunActorActorState(); static_cast<RunActorActor*>(this)->destroy(); return 0; }
															#line 2415 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		new (&static_cast<RunActorActor*>(this)->SAV< Ret >::value()) Ret(std::move(res)); // state_var_RVO
		this->~RunActorActorState();
		static_cast<RunActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunActorActor*>(this)->actor_wait_state > 0) static_cast<RunActorActor*>(this)->actor_wait_state = 0;
		static_cast<RunActorActor*>(this)->ActorCallback< RunActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	WorkloadProcess* self;
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	Optional<TenantName> defaultTenant;
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	Fun f;
															#line 200 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	Optional<Error> err;
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	Ret res;
															#line 202 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	Future<Ret> fut;
															#line 203 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	ISimulator::ProcessInfo* parent;
															#line 2512 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
};
// This generated class is to be used only via runActor()
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class Ret, class Fun>
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
class RunActorActor final : public Actor<Ret>, public ActorCallback< RunActorActor<Ret, Fun>, 0, Void >, public ActorCallback< RunActorActor<Ret, Fun>, 1, Void >, public ActorCallback< RunActorActor<Ret, Fun>, 2, Ret >, public ActorCallback< RunActorActor<Ret, Fun>, 3, Void >, public FastAllocated<RunActorActor<Ret, Fun>>, public RunActorActorState<Ret, Fun, RunActorActor<Ret, Fun>> {
															#line 2519 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
public:
	using FastAllocated<RunActorActor<Ret, Fun>>::operator new;
	using FastAllocated<RunActorActor<Ret, Fun>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(655127833255311360UL, 7349079525084924416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Ret>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActorActor<Ret, Fun>, 0, Void >;
friend struct ActorCallback< RunActorActor<Ret, Fun>, 1, Void >;
friend struct ActorCallback< RunActorActor<Ret, Fun>, 2, Ret >;
friend struct ActorCallback< RunActorActor<Ret, Fun>, 3, Void >;
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	RunActorActor(WorkloadProcess* const& self,Optional<TenantName> const& defaultTenant,Fun const& f) 
															#line 2539 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
		 : Actor<Ret>(),
		   RunActorActorState<Ret, Fun, RunActorActor<Ret, Fun>>(self, defaultTenant, f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3981409362923934976UL, 9833813193018407168UL);
		ActorExecutionContextHelper __helper(static_cast<RunActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActorActor<Ret, Fun>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActorActor<Ret, Fun>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunActorActor<Ret, Fun>, 2, Ret >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunActorActor<Ret, Fun>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
template <class Ret, class Fun>
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
[[nodiscard]] Future<Ret> runActor( WorkloadProcess* const& self, Optional<TenantName> const& defaultTenant, Fun const& f ) {
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
	return Future<Ret>(new RunActorActor<Ret, Fun>(self, defaultTenant, f));
															#line 2576 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientWorkload.actor.g.cpp"
}

#line 229 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/ClientWorkload.actor.cpp"
};

ClientWorkload::ClientWorkload(CreateWorkload const& childCreator, WorkloadContext const& wcx)
  : TestWorkload(wcx), impl(new WorkloadProcess(childCreator, wcx)) {}

ClientWorkload::~ClientWorkload() {
	TraceEvent(SevDebug, "DestroyClientWorkload").backtrace();
	WorkloadProcess::destroy(impl);
}

std::string ClientWorkload::description() const {
	return impl->description();
}

Future<Void> ClientWorkload::initialized() {
	return impl->databaseOpened;
}

Future<Void> ClientWorkload::setup(Database const& cx) {
	return impl->runActor<Void>(impl, cx->defaultTenant, [this](Database const& db) { return impl->child->setup(db); });
}
Future<Void> ClientWorkload::start(Database const& cx) {
	return impl->runActor<Void>(impl, cx->defaultTenant, [this](Database const& db) { return impl->child->start(db); });
}
Future<bool> ClientWorkload::check(Database const& cx) {
	return impl->runActor<bool>(impl, cx->defaultTenant, [this](Database const& db) { return impl->child->check(db); });
}
Future<std::vector<PerfMetric>> ClientWorkload::getMetrics() {
	return impl->runActor<std::vector<PerfMetric>>(
	    impl, Optional<TenantName>(), [this](Database const& db) { return impl->child->getMetrics(); });
}
void ClientWorkload::getMetrics(std::vector<PerfMetric>& m) {
	ASSERT(false);
}

double ClientWorkload::getCheckTimeout() const {
	return impl->child->getCheckTimeout();
}
