#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
/*
 * BlobRestoreWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/ClientKnobs.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/BlobGranuleReader.actor.h"
#include "fdbclient/BlobRestoreCommon.h"
#include "fdbserver/BlobGranuleValidation.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"
#include "flow/Error.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// This workload provides building blocks to test blob restore. The following 2 functions are offered:
//   1) SetupBlob - blobbify key ranges so that we could backup fdb to a blob storage
//   2) PerformRestore - Start blob restore to the extra db instance and wait until it finishes
//
// A general flow to test blob restore:
//   1) start two db instances and blobbify normalKeys for the default db
//   2) submit mutation log only backup to the default db with IncrementalBackup
//   3) start cycle workload to write data to the default db
//   4) perform blob restore to the extra db
//   5) verify data in the extra db
//
// Please refer to BlobRestoreBasic.toml to see how to run a blob restore test with the help from IncrementalBackup
// and Cycle.
//
struct BlobRestoreWorkload : TestWorkload {
	static constexpr auto NAME = "BlobRestoreWorkload";
	BlobRestoreWorkload(WorkloadContext const& wcx) : TestWorkload(wcx), tenantData_(wcx.dbInfo) {
		ASSERT(g_simulator->extraDatabases.size() == 1); // extra db must be enabled
		extraDb_ = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0]);
		setupBlob_ = getOption(options, "setupBlob"_sr, false);
		performRestore_ = getOption(options, "performRestore"_sr, false);
		restoreToVersion_ = getOption(options, "restoreToVersion"_sr, false);
		readBatchSize_ = getOption(options, "readBatchSize"_sr, 3000);
		blobManifestUrl_ = getOption(options, "blobManifestUrl"_sr, "file://simfdb/fdbblob/manifest"_sr);
		mlogsUrl_ = getOption(options, "backupDir"_sr, "file://simfdb/backups/"_sr);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

																#line 76 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class _startActor>
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class _startActorState {
															#line 82 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	_startActorState(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   self(self),
															#line 75 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   result(false)
															#line 93 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (self->setupBlob_)
															#line 108 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			{
															#line 77 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
				fmt::print("Blobbify normal range\n");
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(result, cx->blobbifyRange(normalKeys));
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 116 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 78 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 81 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (self->performRestore_)
															#line 149 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 82 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Perform blob restore\n");
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = disableManifestBackup(cx);
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 117 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 263 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		Reference<BlobConnectionProvider> manifestStore = BlobConnectionProvider::newBlobConnectionProvider(self->blobManifestUrl_.toString());
															#line 89 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		Reference<BackupContainerFileSystem> container = manifestStore->getForRead("");
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<BackupContainerFileSystem::FilesAndSizesT> __when_expr_2 = container->listFiles("");
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >*>(static_cast<_startActor*>(this)));
															#line 286 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		Reference<BlobConnectionProvider> manifestStore = BlobConnectionProvider::newBlobConnectionProvider(self->blobManifestUrl_.toString());
															#line 89 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		Reference<BackupContainerFileSystem> container = manifestStore->getForRead("");
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<BackupContainerFileSystem::FilesAndSizesT> __when_expr_2 = container->listFiles("");
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 301 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 90 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >*>(static_cast<_startActor*>(this)));
															#line 306 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(BackupContainerFileSystem::FilesAndSizesT const& filesAndSizes,int loopDepth) 
	{
															#line 91 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (filesAndSizes.empty())
															#line 390 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Skip blob restore test because of missing manifest\n");
															#line 93 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Skip blob restore test because of missing manifest", probe::decoration::rare);
															#line 94 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 398 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(self->restoreTargetVersion_, getRestoreVersion(cx, self));
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 408 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 413 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(BackupContainerFileSystem::FilesAndSizesT && filesAndSizes,int loopDepth) 
	{
															#line 91 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (filesAndSizes.empty())
															#line 422 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 92 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Skip blob restore test because of missing manifest\n");
															#line 93 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Skip blob restore test because of missing manifest", probe::decoration::rare);
															#line 94 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 430 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(self->restoreTargetVersion_, getRestoreVersion(cx, self));
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 440 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 98 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 445 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(BackupContainerFileSystem::FilesAndSizesT const& filesAndSizes,int loopDepth) 
	{
		loopDepth = a_body1cont5(filesAndSizes, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(BackupContainerFileSystem::FilesAndSizesT && filesAndSizes,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(filesAndSizes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >*,BackupContainerFileSystem::FilesAndSizesT const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >*,BackupContainerFileSystem::FilesAndSizesT && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (self->restoreTargetVersion_ == invalidVersion)
															#line 529 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 100 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Skip blob restore test because of missing mutation logs");
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 535 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 103 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("Restore target version {}\n", self->restoreTargetVersion_);
															#line 106 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		Optional<Version> targetVersion;
															#line 107 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (self->restoreToVersion_)
															#line 547 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 108 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			targetVersion = self->restoreTargetVersion_;
															#line 551 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitRestore(self);
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 557 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 562 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (self->restoreTargetVersion_ == invalidVersion)
															#line 571 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 100 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Skip blob restore test because of missing mutation logs");
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 577 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~_startActorState();
			static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 103 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("Restore target version {}\n", self->restoreTargetVersion_);
															#line 106 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		Optional<Version> targetVersion;
															#line 107 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (self->restoreToVersion_)
															#line 589 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 108 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			targetVersion = self->restoreTargetVersion_;
															#line 593 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = submitRestore(self);
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 599 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 604 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		futures = std::vector<Future<Void>>();
															#line 113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		futures.push_back(self->runBackupAgent(self));
															#line 114 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		futures.push_back(self->monitorProgress(cx, self));
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAny(futures);
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 696 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 701 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		futures = std::vector<Future<Void>>();
															#line 113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		futures.push_back(self->runBackupAgent(self));
															#line 114 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		futures.push_back(self->monitorProgress(cx, self));
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAny(futures);
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 718 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 723 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Database cx;
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 75 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	bool result;
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	std::vector<Future<Void>> futures;
															#line 898 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 903 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6570315721063032576UL, 14720527212863230464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	_startActor(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, BackupContainerFileSystem::FilesAndSizesT >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BlobRestoreWorkload* const& self ) {
															#line 74 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 962 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 119 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

																#line 967 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via submitRestore()
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class SubmitRestoreActor>
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class SubmitRestoreActorState {
															#line 973 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	SubmitRestoreActorState(BlobRestoreWorkload* const& self) 
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : self(self),
															#line 121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   mlogsUrl()
															#line 982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("submitRestore", reinterpret_cast<unsigned long>(this));

	}
	~SubmitRestoreActorState() 
	{
		fdb_probe_actor_destroy("submitRestore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<std::vector<std::string>> __when_expr_0 = IBackupContainer::listContainers(self->mlogsUrl_.toString(), {});
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<SubmitRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 999 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SubmitRestoreActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SubmitRestoreActor, 0, std::vector<std::string> >*>(static_cast<SubmitRestoreActor*>(this)));
															#line 1004 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SubmitRestoreActorState();
		static_cast<SubmitRestoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 124 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (containers.size() == 0)
															#line 1027 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			return a_body1Catch1(blob_restore_missing_logs(), loopDepth);
															#line 1031 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
															#line 127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		mlogsUrl = containers.back();
															#line 129 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 130 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		ranges.push_back(ranges.arena(), normalKeys);
															#line 131 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		addDefaultBackupRanges(ranges);
															#line 133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Version> __when_expr_1 = self->backupAgent_.restore(self->extraDb_, {}, "default"_sr, KeyRef(mlogsUrl), {}, ranges, WaitForComplete::False, self->restoreTargetVersion_, Verbose::True, ""_sr, ""_sr, LockDB::True, UnlockDB::True, OnlyApplyMutationLogs::False, InconsistentSnapshotOnly::False, invalidVersion, {}, self->blobManifestUrl_.toString());
															#line 133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<SubmitRestoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1045 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SubmitRestoreActor*>(this)->actor_wait_state = 2;
															#line 133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SubmitRestoreActor, 1, Version >*>(static_cast<SubmitRestoreActor*>(this)));
															#line 1050 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> const& __containers,int loopDepth) 
	{
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		containers = __containers;
															#line 1059 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> && __containers,int loopDepth) 
	{
		containers = std::move(__containers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SubmitRestoreActor*>(this)->actor_wait_state > 0) static_cast<SubmitRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitRestoreActor*>(this)->ActorCallback< SubmitRestoreActor, 0, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitRestoreActor, 0, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("submitRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SubmitRestoreActor, 0, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("submitRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SubmitRestoreActor, 0, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("submitRestore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitRestore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Version const& version,int loopDepth) 
	{
															#line 151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("Submit blob restore to version {} \n", version);
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<SubmitRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SubmitRestoreActorState(); static_cast<SubmitRestoreActor*>(this)->destroy(); return 0; }
															#line 1140 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<SubmitRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SubmitRestoreActorState();
		static_cast<SubmitRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Version && version,int loopDepth) 
	{
															#line 151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("Submit blob restore to version {} \n", version);
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<SubmitRestoreActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SubmitRestoreActorState(); static_cast<SubmitRestoreActor*>(this)->destroy(); return 0; }
															#line 1154 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<SubmitRestoreActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SubmitRestoreActorState();
		static_cast<SubmitRestoreActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Version const& version,int loopDepth) 
	{
		loopDepth = a_body1cont2(version, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && version,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(version), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SubmitRestoreActor*>(this)->actor_wait_state > 0) static_cast<SubmitRestoreActor*>(this)->actor_wait_state = 0;
		static_cast<SubmitRestoreActor*>(this)->ActorCallback< SubmitRestoreActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< SubmitRestoreActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("submitRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SubmitRestoreActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("submitRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitRestore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SubmitRestoreActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("submitRestore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("submitRestore", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	std::string mlogsUrl;
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	std::vector<std::string> containers;
															#line 1243 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via submitRestore()
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class SubmitRestoreActor final : public Actor<Void>, public ActorCallback< SubmitRestoreActor, 0, std::vector<std::string> >, public ActorCallback< SubmitRestoreActor, 1, Version >, public FastAllocated<SubmitRestoreActor>, public SubmitRestoreActorState<SubmitRestoreActor> {
															#line 1248 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<SubmitRestoreActor>::operator new;
	using FastAllocated<SubmitRestoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(867729213940570368UL, 9193554998474149632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SubmitRestoreActor, 0, std::vector<std::string> >;
friend struct ActorCallback< SubmitRestoreActor, 1, Version >;
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	SubmitRestoreActor(BlobRestoreWorkload* const& self) 
															#line 1266 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   SubmitRestoreActorState<SubmitRestoreActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("submitRestore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2085210769069589760UL, 11475995420770013184UL);
		ActorExecutionContextHelper __helper(static_cast<SubmitRestoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("submitRestore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("submitRestore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SubmitRestoreActor, 0, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SubmitRestoreActor, 1, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> submitRestore( BlobRestoreWorkload* const& self ) {
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Void>(new SubmitRestoreActor(self));
															#line 1299 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 154 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

																#line 1304 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via getRestoreVersion()
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class GetRestoreVersionActor>
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class GetRestoreVersionActorState {
															#line 1310 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	GetRestoreVersionActorState(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   self(self),
															#line 156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   targetVersion(),
															#line 157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   baseUrl(self->mlogsUrl_.toString())
															#line 1323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getRestoreVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetRestoreVersionActorState() 
	{
		fdb_probe_actor_destroy("getRestoreVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<std::vector<std::string>> __when_expr_0 = IBackupContainer::listContainers(baseUrl, {});
															#line 158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<GetRestoreVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1340 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetRestoreVersionActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRestoreVersionActor, 0, std::vector<std::string> >*>(static_cast<GetRestoreVersionActor*>(this)));
															#line 1345 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRestoreVersionActorState();
		static_cast<GetRestoreVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 159 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (containers.size() == 0)
															#line 1368 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("missing mutation logs {}\n", baseUrl);
															#line 161 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Skip blob restore test because of missing log backups");
															#line 162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (!static_cast<GetRestoreVersionActor*>(this)->SAV<Version>::futures) { (void)(invalidVersion); this->~GetRestoreVersionActorState(); static_cast<GetRestoreVersionActor*>(this)->destroy(); return 0; }
															#line 1376 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			new (&static_cast<GetRestoreVersionActor*>(this)->SAV< Version >::value()) Version(invalidVersion);
			this->~GetRestoreVersionActorState();
			static_cast<GetRestoreVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		bc = IBackupContainer::openContainer(containers.front(), {}, {});
															#line 165 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<BackupDescription> __when_expr_1 = bc->describeBackup(true);
															#line 165 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<GetRestoreVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1388 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetRestoreVersionActor*>(this)->actor_wait_state = 2;
															#line 165 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRestoreVersionActor, 1, BackupDescription >*>(static_cast<GetRestoreVersionActor*>(this)));
															#line 1393 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> const& __containers,int loopDepth) 
	{
															#line 158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		containers = __containers;
															#line 1402 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::string> && __containers,int loopDepth) 
	{
		containers = std::move(__containers);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRestoreVersionActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreVersionActor*>(this)->ActorCallback< GetRestoreVersionActor, 0, std::vector<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreVersionActor, 0, std::vector<std::string> >*,std::vector<std::string> const& value) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRestoreVersionActor, 0, std::vector<std::string> >*,std::vector<std::string> && value) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRestoreVersionActor, 0, std::vector<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(BackupDescription const& desc,int loopDepth) 
	{
															#line 166 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!desc.contiguousLogEnd.present())
															#line 1481 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("missing mutation logs {}\n", baseUrl);
															#line 168 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Skip blob restore test because of invalid log backup");
															#line 169 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (!static_cast<GetRestoreVersionActor*>(this)->SAV<Version>::futures) { (void)(invalidVersion); this->~GetRestoreVersionActorState(); static_cast<GetRestoreVersionActor*>(this)->destroy(); return 0; }
															#line 1489 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			new (&static_cast<GetRestoreVersionActor*>(this)->SAV< Version >::value()) Version(invalidVersion);
			this->~GetRestoreVersionActorState();
			static_cast<GetRestoreVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 171 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		targetVersion = desc.contiguousLogEnd.get() - 1;
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (self->restoreToVersion_)
															#line 1499 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			targetVersion -= deterministicRandom()->randomInt(1, 100000);
															#line 1503 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
		try {
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_2 = readFromBlob(cx, targetVersion, self);
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<GetRestoreVersionActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 1510 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreVersionActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<GetRestoreVersionActor*>(this)));
															#line 1515 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(BackupDescription && desc,int loopDepth) 
	{
															#line 166 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!desc.contiguousLogEnd.present())
															#line 1530 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("missing mutation logs {}\n", baseUrl);
															#line 168 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Skip blob restore test because of invalid log backup");
															#line 169 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (!static_cast<GetRestoreVersionActor*>(this)->SAV<Version>::futures) { (void)(invalidVersion); this->~GetRestoreVersionActorState(); static_cast<GetRestoreVersionActor*>(this)->destroy(); return 0; }
															#line 1538 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			new (&static_cast<GetRestoreVersionActor*>(this)->SAV< Version >::value()) Version(invalidVersion);
			this->~GetRestoreVersionActorState();
			static_cast<GetRestoreVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 171 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		targetVersion = desc.contiguousLogEnd.get() - 1;
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (self->restoreToVersion_)
															#line 1548 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 174 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			targetVersion -= deterministicRandom()->randomInt(1, 100000);
															#line 1552 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
		try {
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_2 = readFromBlob(cx, targetVersion, self);
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<GetRestoreVersionActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch1(actor_cancelled(), loopDepth);
															#line 1559 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetRestoreVersionActor*>(this)->actor_wait_state = 3;
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<GetRestoreVersionActor*>(this)));
															#line 1564 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription const& desc,int loopDepth) 
	{
		loopDepth = a_body1cont2(desc, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BackupDescription && desc,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(desc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetRestoreVersionActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreVersionActor*>(this)->ActorCallback< GetRestoreVersionActor, 1, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreVersionActor, 1, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRestoreVersionActor, 1, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRestoreVersionActor, 1, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<GetRestoreVersionActor*>(this)->SAV<Version>::futures) { (void)(targetVersion); this->~GetRestoreVersionActorState(); static_cast<GetRestoreVersionActor*>(this)->destroy(); return 0; }
															#line 1654 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<GetRestoreVersionActor*>(this)->SAV< Version >::value()) Version(std::move(targetVersion)); // state_var_RVO
		this->~GetRestoreVersionActorState();
		static_cast<GetRestoreVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 180 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Couldn't read blob data at version {}\n", targetVersion);
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			CODE_PROBE(true, "Skip blob restore test because of missing blob data");
															#line 182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (!static_cast<GetRestoreVersionActor*>(this)->SAV<Version>::futures) { (void)(invalidVersion); this->~GetRestoreVersionActorState(); static_cast<GetRestoreVersionActor*>(this)->destroy(); return 0; }
															#line 1671 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			new (&static_cast<GetRestoreVersionActor*>(this)->SAV< Version >::value()) Version(invalidVersion);
			this->~GetRestoreVersionActorState();
			static_cast<GetRestoreVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<VectorRef<KeyValueRef>> const& __src_,int loopDepth) 
	{
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		src_ = __src_;
															#line 1695 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<VectorRef<KeyValueRef>> && __src_,int loopDepth) 
	{
		src_ = std::move(__src_);
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetRestoreVersionActor*>(this)->actor_wait_state > 0) static_cast<GetRestoreVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetRestoreVersionActor*>(this)->ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> const& value) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> && value) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Database cx;
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Version targetVersion;
															#line 157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	std::string baseUrl;
															#line 158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	std::vector<std::string> containers;
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> src_;
															#line 1797 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via getRestoreVersion()
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class GetRestoreVersionActor final : public Actor<Version>, public ActorCallback< GetRestoreVersionActor, 0, std::vector<std::string> >, public ActorCallback< GetRestoreVersionActor, 1, BackupDescription >, public ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >, public FastAllocated<GetRestoreVersionActor>, public GetRestoreVersionActorState<GetRestoreVersionActor> {
															#line 1802 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<GetRestoreVersionActor>::operator new;
	using FastAllocated<GetRestoreVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8578378430026489600UL, 7596440856873237760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRestoreVersionActor, 0, std::vector<std::string> >;
friend struct ActorCallback< GetRestoreVersionActor, 1, BackupDescription >;
friend struct ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >;
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	GetRestoreVersionActor(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 1821 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Version>(),
		   GetRestoreVersionActorState<GetRestoreVersionActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRestoreVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5877307346283204864UL, 10469719123335978752UL);
		ActorExecutionContextHelper __helper(static_cast<GetRestoreVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRestoreVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRestoreVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRestoreVersionActor, 0, std::vector<std::string> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetRestoreVersionActor, 1, BackupDescription >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetRestoreVersionActor, 2, Standalone<VectorRef<KeyValueRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Version> getRestoreVersion( Database const& cx, BlobRestoreWorkload* const& self ) {
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Version>(new GetRestoreVersionActor(cx, self));
															#line 1855 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

	static Future<Void> disableManifestBackup(Database cx) {
		return runRYWTransaction(cx, [](Reference<ReadYourWritesTransaction> tr) -> Future<Void> {
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
			BlobGranuleBackupConfig().enabled().set(tr, false);
			return Void();
		});
	}

	// Start backup agent on the extra db
																#line 1871 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via runBackupAgent()
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class RunBackupAgentActor>
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class RunBackupAgentActorState {
															#line 1877 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	RunBackupAgentActorState(BlobRestoreWorkload* const& self) 
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : self(self),
															#line 199 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   future(self->backupAgent_.run( self->extraDb_, 1.0 / CLIENT_KNOBS->BACKUP_AGGREGATE_POLL_RATE, CLIENT_KNOBS->SIM_BACKUP_TASKS_PER_AGENT))
															#line 1886 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("runBackupAgent", reinterpret_cast<unsigned long>(this));

	}
	~RunBackupAgentActorState() 
	{
		fdb_probe_actor_destroy("runBackupAgent", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Never());
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<RunBackupAgentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1903 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunBackupAgentActor*>(this)->actor_wait_state = 1;
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunBackupAgentActor, 0, Void >*>(static_cast<RunBackupAgentActor*>(this)));
															#line 1908 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunBackupAgentActorState();
		static_cast<RunBackupAgentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 1931 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 202 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		return a_body1Catch1(internal_error(), loopDepth);
															#line 1939 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunBackupAgentActor*>(this)->actor_wait_state > 0) static_cast<RunBackupAgentActor*>(this)->actor_wait_state = 0;
		static_cast<RunBackupAgentActor*>(this)->ActorCallback< RunBackupAgentActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunBackupAgentActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runBackupAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunBackupAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runBackupAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunBackupAgentActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runBackupAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunBackupAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runBackupAgent", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunBackupAgentActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runBackupAgent", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunBackupAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runBackupAgent", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 199 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Future<Void> future;
															#line 2022 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via runBackupAgent()
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class RunBackupAgentActor final : public Actor<Void>, public ActorCallback< RunBackupAgentActor, 0, Void >, public FastAllocated<RunBackupAgentActor>, public RunBackupAgentActorState<RunBackupAgentActor> {
															#line 2027 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<RunBackupAgentActor>::operator new;
	using FastAllocated<RunBackupAgentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5111056021534932480UL, 9260522426263457280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunBackupAgentActor, 0, Void >;
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	RunBackupAgentActor(BlobRestoreWorkload* const& self) 
															#line 2044 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RunBackupAgentActorState<RunBackupAgentActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runBackupAgent", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1236433023477131776UL, 17165381489677437440UL);
		ActorExecutionContextHelper __helper(static_cast<RunBackupAgentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runBackupAgent");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runBackupAgent", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunBackupAgentActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] Future<Void> runBackupAgent( BlobRestoreWorkload* const& self ) {
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Void>(new RunBackupAgentActor(self));
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 204 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

	// Monitor restore progress and copy data back to original db after successful restore
																#line 2082 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via monitorProgress()
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class MonitorProgressActor>
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class MonitorProgressActorState {
															#line 2088 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	MonitorProgressActorState(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   self(self)
															#line 2097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorProgress", reinterpret_cast<unsigned long>(this));

	}
	~MonitorProgressActorState() 
	{
		fdb_probe_actor_destroy("monitorProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 207 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			;
															#line 2112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorProgressActorState();
		static_cast<MonitorProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 208 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		auto controller = makeReference<BlobRestoreController>(self->extraDb_, normalKeys);
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<BlobRestorePhase> __when_expr_0 = BlobRestoreController::currentPhase(controller);
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorProgressActor*>(this)->actor_wait_state = 1;
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorProgressActor, 0, BlobRestorePhase >*>(static_cast<MonitorProgressActor*>(this)));
															#line 2151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 210 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (phase == BlobRestorePhase::DONE)
															#line 2160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = verify(cx, self);
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<MonitorProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2166 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorProgressActor*>(this)->actor_wait_state = 2;
															#line 212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorProgressActor, 1, Void >*>(static_cast<MonitorProgressActor*>(this)));
															#line 2171 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase const& __phase,int loopDepth) 
	{
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		phase = __phase;
															#line 2185 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(BlobRestorePhase && __phase,int loopDepth) 
	{
		phase = std::move(__phase);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProgressActor*>(this)->ActorCallback< MonitorProgressActor, 0, BlobRestorePhase >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 0, BlobRestorePhase >*,BlobRestorePhase const& value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 0, BlobRestorePhase >*,BlobRestorePhase && value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorProgressActor, 0, BlobRestorePhase >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 226 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (phase == BlobRestorePhase::ERROR)
															#line 2264 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 227 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			auto db = SystemDBWriteLockedNow(self->extraDb_.getReference());
															#line 228 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<std::string> __when_expr_4 = BlobGranuleRestoreConfig().error().getD(db);
															#line 228 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<MonitorProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<MonitorProgressActor*>(this)->actor_wait_state = 5;
															#line 228 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MonitorProgressActor, 4, std::string >*>(static_cast<MonitorProgressActor*>(this)));
															#line 2277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		kt = ISimulator::KillType::RebootProcessAndSwitch;
															#line 216 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		g_simulator->killAll(kt, true);
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		g_simulator->toggleGlobalSwitchCluster();
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(2);
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2299 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProgressActor*>(this)->actor_wait_state = 3;
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProgressActor, 2, Void >*>(static_cast<MonitorProgressActor*>(this)));
															#line 2304 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 215 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		kt = ISimulator::KillType::RebootProcessAndSwitch;
															#line 216 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		g_simulator->killAll(kt, true);
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		g_simulator->toggleGlobalSwitchCluster();
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(2);
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2321 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MonitorProgressActor*>(this)->actor_wait_state = 3;
															#line 218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorProgressActor, 2, Void >*>(static_cast<MonitorProgressActor*>(this)));
															#line 2326 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProgressActor*>(this)->ActorCallback< MonitorProgressActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorProgressActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 219 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		g_simulator->killAll(kt, true);
															#line 220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		g_simulator->toggleGlobalSwitchCluster();
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = flushBlobRanges(self->extraDb_, self, {});
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2416 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorProgressActor*>(this)->actor_wait_state = 4;
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorProgressActor, 3, Void >*>(static_cast<MonitorProgressActor*>(this)));
															#line 2421 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 219 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		g_simulator->killAll(kt, true);
															#line 220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		g_simulator->toggleGlobalSwitchCluster();
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_3 = flushBlobRanges(self->extraDb_, self, {});
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2436 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<MonitorProgressActor*>(this)->actor_wait_state = 4;
															#line 222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MonitorProgressActor, 3, Void >*>(static_cast<MonitorProgressActor*>(this)));
															#line 2441 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProgressActor*>(this)->ActorCallback< MonitorProgressActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorProgressActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<MonitorProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorProgressActorState(); static_cast<MonitorProgressActor*>(this)->destroy(); return 0; }
															#line 2525 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<MonitorProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorProgressActorState();
		static_cast<MonitorProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<MonitorProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorProgressActorState(); static_cast<MonitorProgressActor*>(this)->destroy(); return 0; }
															#line 2537 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<MonitorProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorProgressActorState();
		static_cast<MonitorProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProgressActor*>(this)->ActorCallback< MonitorProgressActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MonitorProgressActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = delay(5);
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2626 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<MonitorProgressActor*>(this)->actor_wait_state = 6;
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MonitorProgressActor, 5, Void >*>(static_cast<MonitorProgressActor*>(this)));
															#line 2631 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(std::string const& error,int loopDepth) 
	{
															#line 229 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("Unexpected restore error code = {}\n", error);
															#line 230 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		ASSERT(phase != BlobRestorePhase::ERROR);
															#line 2642 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(std::string && error,int loopDepth) 
	{
															#line 229 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("Unexpected restore error code = {}\n", error);
															#line 230 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		ASSERT(phase != BlobRestorePhase::ERROR);
															#line 2653 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string const& error,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(error, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string && error,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(error), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProgressActor*>(this)->ActorCallback< MonitorProgressActor, 4, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 4, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 4, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MonitorProgressActor, 4, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<MonitorProgressActor*>(this)->actor_wait_state > 0) static_cast<MonitorProgressActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorProgressActor*>(this)->ActorCallback< MonitorProgressActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MonitorProgressActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MonitorProgressActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Database cx;
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestorePhase phase;
															#line 215 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	ISimulator::KillType kt;
															#line 2828 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via monitorProgress()
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class MonitorProgressActor final : public Actor<Void>, public ActorCallback< MonitorProgressActor, 0, BlobRestorePhase >, public ActorCallback< MonitorProgressActor, 1, Void >, public ActorCallback< MonitorProgressActor, 2, Void >, public ActorCallback< MonitorProgressActor, 3, Void >, public ActorCallback< MonitorProgressActor, 4, std::string >, public ActorCallback< MonitorProgressActor, 5, Void >, public FastAllocated<MonitorProgressActor>, public MonitorProgressActorState<MonitorProgressActor> {
															#line 2833 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<MonitorProgressActor>::operator new;
	using FastAllocated<MonitorProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8167023490097581312UL, 2221643802472746496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorProgressActor, 0, BlobRestorePhase >;
friend struct ActorCallback< MonitorProgressActor, 1, Void >;
friend struct ActorCallback< MonitorProgressActor, 2, Void >;
friend struct ActorCallback< MonitorProgressActor, 3, Void >;
friend struct ActorCallback< MonitorProgressActor, 4, std::string >;
friend struct ActorCallback< MonitorProgressActor, 5, Void >;
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	MonitorProgressActor(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 2855 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorProgressActorState<MonitorProgressActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(98964086939236352UL, 8989180065223468800UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorProgressActor, 0, BlobRestorePhase >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorProgressActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MonitorProgressActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MonitorProgressActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MonitorProgressActor, 4, std::string >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< MonitorProgressActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] Future<Void> monitorProgress( Database const& cx, BlobRestoreWorkload* const& self ) {
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Void>(new MonitorProgressActor(cx, self));
															#line 2892 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 236 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

																#line 2897 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via readFromStorageServer()
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class ReadFromStorageServerActor>
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class ReadFromStorageServerActorState {
															#line 2903 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	ReadFromStorageServerActorState(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   self(self)
															#line 2912 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("readFromStorageServer", reinterpret_cast<unsigned long>(this));

	}
	~ReadFromStorageServerActorState() 
	{
		fdb_probe_actor_destroy("readFromStorageServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = cx->listBlobbifiedRanges(normalKeys, CLIENT_KNOBS->TOO_MANY);
															#line 239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2929 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state = 1;
															#line 239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadFromStorageServerActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<ReadFromStorageServerActor*>(this)));
															#line 2934 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadFromStorageServerActorState();
		static_cast<ReadFromStorageServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 241 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		data = Standalone<VectorRef<KeyValueRef>>();
															#line 242 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		tr = Transaction(cx);
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(ranges);
															#line 2961 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRangeRef>> const& __ranges,int loopDepth) 
	{
															#line 239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		ranges = __ranges;
															#line 2970 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRangeRef>> && __ranges,int loopDepth) 
	{
		ranges = std::move(__ranges);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state > 0) static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromStorageServerActor*>(this)->ActorCallback< ReadFromStorageServerActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromStorageServerActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadFromStorageServerActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadFromStorageServerActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 266 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<ReadFromStorageServerActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(data); this->~ReadFromStorageServerActorState(); static_cast<ReadFromStorageServerActor*>(this)->destroy(); return 0; }
															#line 3049 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<ReadFromStorageServerActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(std::move(data)); // state_var_RVO
		this->~ReadFromStorageServerActorState();
		static_cast<ReadFromStorageServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(ranges)))
															#line 3068 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		auto& range = *RangeForbody1cont1Iterator0;
															#line 3074 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			begin = firstGreaterOrEqual(range.begin);
															#line 246 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			end = firstGreaterOrEqual(range.end);
															#line 247 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			rows = Standalone<VectorRef<KeyValueRef>>();
															#line 248 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			;
															#line 3084 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 3107 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 264 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		data.append_deep(data.arena(), rows.begin(), rows.size());
															#line 3116 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 250 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			GetRangeLimits limits(self->readBatchSize_);
															#line 251 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			limits.minRows = 0;
															#line 252 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(begin, end, limits, Snapshot::True);
															#line 252 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state = 2;
															#line 252 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadFromStorageServerActor, 1, RangeResult >*>(static_cast<ReadFromStorageServerActor*>(this)));
															#line 3144 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 261 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 261 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state = 3;
															#line 261 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadFromStorageServerActor, 2, Void >*>(static_cast<ReadFromStorageServerActor*>(this)));
															#line 3186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		for( auto& row : result ) {
															#line 254 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			rows.push_back_deep(rows.arena(), KeyValueRef(row.key, row.value));
															#line 3203 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
															#line 256 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!result.more)
															#line 3207 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 259 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		begin = result.nextBeginKeySelector();
															#line 3213 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult const& __result,int loopDepth) 
	{
															#line 252 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		result = __result;
															#line 3222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(RangeResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state > 0) static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromStorageServerActor*>(this)->ActorCallback< ReadFromStorageServerActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromStorageServerActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadFromStorageServerActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadFromStorageServerActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state > 0) static_cast<ReadFromStorageServerActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromStorageServerActor*>(this)->ActorCallback< ReadFromStorageServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromStorageServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadFromStorageServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadFromStorageServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Database cx;
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 241 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 242 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Transaction tr;
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	decltype(std::begin(std::declval<Standalone<VectorRef<KeyRangeRef>>>())) RangeForbody1cont1Iterator0;
															#line 245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	KeySelectorRef begin;
															#line 246 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	KeySelectorRef end;
															#line 247 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> rows;
															#line 252 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	RangeResult result;
															#line 3417 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via readFromStorageServer()
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class ReadFromStorageServerActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< ReadFromStorageServerActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< ReadFromStorageServerActor, 1, RangeResult >, public ActorCallback< ReadFromStorageServerActor, 2, Void >, public FastAllocated<ReadFromStorageServerActor>, public ReadFromStorageServerActorState<ReadFromStorageServerActor> {
															#line 3422 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<ReadFromStorageServerActor>::operator new;
	using FastAllocated<ReadFromStorageServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14814183861240910336UL, 8902981837735752960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadFromStorageServerActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< ReadFromStorageServerActor, 1, RangeResult >;
friend struct ActorCallback< ReadFromStorageServerActor, 2, Void >;
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	ReadFromStorageServerActor(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 3441 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   ReadFromStorageServerActorState<ReadFromStorageServerActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readFromStorageServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6523777130471825408UL, 3329759942737251840UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromStorageServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readFromStorageServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readFromStorageServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadFromStorageServerActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadFromStorageServerActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadFromStorageServerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyValueRef>>> readFromStorageServer( Database const& cx, BlobRestoreWorkload* const& self ) {
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new ReadFromStorageServerActor(cx, self));
															#line 3475 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

																#line 3480 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via readFromBlob()
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class ReadFromBlobActor>
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class ReadFromBlobActorState {
															#line 3486 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	ReadFromBlobActorState(Database const& cx,Version const& readVersion,BlobRestoreWorkload* const& self) 
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   readVersion(readVersion),
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   self(self)
															#line 3497 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("readFromBlob", reinterpret_cast<unsigned long>(this));

	}
	~ReadFromBlobActorState() 
	{
		fdb_probe_actor_destroy("readFromBlob", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = cx->listBlobbifiedRanges(normalKeys, CLIENT_KNOBS->TOO_MANY);
															#line 272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3514 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 1;
															#line 272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 3519 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadFromBlobActorState();
		static_cast<ReadFromBlobActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		data = Standalone<VectorRef<KeyValueRef>>();
															#line 275 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		tr = Transaction(cx);
															#line 277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (SERVER_KNOBS->BG_METADATA_SOURCE == "tenant")
															#line 3546 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 278 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = loadBGTenantMap(&self->tenantData_, &tr);
															#line 278 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3552 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 2;
															#line 278 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 1, Void >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 3557 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRangeRef>> const& __ranges,int loopDepth) 
	{
															#line 272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		ranges = __ranges;
															#line 3571 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRangeRef>> && __ranges,int loopDepth) 
	{
		ranges = std::move(__ranges);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		RangeForbody1cont2Iterator0 = std::begin(ranges);
															#line 3650 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<ReadFromBlobActor*>(this)->SAV<Standalone<VectorRef<KeyValueRef>>>::futures) { (void)(data); this->~ReadFromBlobActorState(); static_cast<ReadFromBlobActor*>(this)->destroy(); return 0; }
															#line 3746 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<ReadFromBlobActor*>(this)->SAV< Standalone<VectorRef<KeyValueRef>> >::value()) Standalone<VectorRef<KeyValueRef>>(std::move(data)); // state_var_RVO
		this->~ReadFromBlobActorState();
		static_cast<ReadFromBlobActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!(RangeForbody1cont2Iterator0 != std::end(ranges)))
															#line 3765 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		auto& range_ = *RangeForbody1cont2Iterator0;
															#line 3771 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 282 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			range = range_;
															#line 283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			;
															#line 3777 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1cont2loopBody1loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		++RangeForbody1cont2Iterator0;
															#line 3800 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<BlobGranuleChunkRef>>> __when_expr_2 = tr.readBlobGranules(range, 0, readVersion);
															#line 285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3825 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 3;
															#line 285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 2, Standalone<VectorRef<BlobGranuleChunkRef>> >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 3830 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 299 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 299 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3867 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1cont2loopBody1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 6;
															#line 299 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 5, Void >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 3872 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 287 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		i = int();
															#line 288 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		i = 0;
															#line 3889 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> const& __chunks,int loopDepth) 
	{
															#line 285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		chunks = __chunks;
															#line 3898 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> && __chunks,int loopDepth) 
	{
		chunks = std::move(__chunks);
		loopDepth = a_body1cont2loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 2, Standalone<VectorRef<BlobGranuleChunkRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 2, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 2, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 2, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1loopBody1cont3(int loopDepth) 
	{
		return a_body1cont2loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 288 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!(i < chunks.size()))
															#line 3990 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont2loopBody1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Reference<BlobConnectionProvider>> __when_expr_3 = loadBStoreForTenant(&self->tenantData_, range);
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3998 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1loopBody1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 4;
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 3, Reference<BlobConnectionProvider> >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 4003 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = readBlobGranule(chunks[i], range, 0, readVersion, blobConn);
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4027 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont2loopBody1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1loopBody1cont2loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 5;
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ReadFromBlobActor, 4, RangeResult >*>(static_cast<ReadFromBlobActor*>(this)));
															#line 4032 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2loopBody1when1(Reference<BlobConnectionProvider> const& __blobConn,int loopDepth) 
	{
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		blobConn = __blobConn;
															#line 4041 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2loopBody1when1(Reference<BlobConnectionProvider> && __blobConn,int loopDepth) 
	{
		blobConn = std::move(__blobConn);
		loopDepth = a_body1cont2loopBody1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 3, Reference<BlobConnectionProvider> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 3, Reference<BlobConnectionProvider> >*,Reference<BlobConnectionProvider> const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 3, Reference<BlobConnectionProvider> >*,Reference<BlobConnectionProvider> && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 3, Reference<BlobConnectionProvider> >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1loopBody1cont2loopBody1cont3(int loopDepth) 
	{
															#line 292 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		for( auto& r : rows ) {
															#line 293 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			data.push_back_deep(data.arena(), r);
															#line 4122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
															#line 295 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("Read trunk {} size {}\n", chunks[i].keyRange.toString(), rows.size());
															#line 288 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		++i;
															#line 4128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopBody1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2loopBody1cont1when1(RangeResult const& __rows,int loopDepth) 
	{
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		rows = __rows;
															#line 4137 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1loopBody1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1cont2loopBody1cont1when1(RangeResult && __rows,int loopDepth) 
	{
		rows = std::move(__rows);
		loopDepth = a_body1cont2loopBody1loopBody1cont2loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ReadFromBlobActor*>(this)->actor_wait_state > 0) static_cast<ReadFromBlobActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromBlobActor*>(this)->ActorCallback< ReadFromBlobActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ReadFromBlobActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ReadFromBlobActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Database cx;
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Version readVersion;
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> data;
															#line 275 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Transaction tr;
															#line 281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	decltype(std::begin(std::declval<Standalone<VectorRef<KeyRangeRef>>>())) RangeForbody1cont2Iterator0;
															#line 282 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	KeyRangeRef range;
															#line 285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<BlobGranuleChunkRef>> chunks;
															#line 287 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	int i;
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Reference<BlobConnectionProvider> blobConn;
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	RangeResult rows;
															#line 4323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via readFromBlob()
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class ReadFromBlobActor final : public Actor<Standalone<VectorRef<KeyValueRef>>>, public ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< ReadFromBlobActor, 1, Void >, public ActorCallback< ReadFromBlobActor, 2, Standalone<VectorRef<BlobGranuleChunkRef>> >, public ActorCallback< ReadFromBlobActor, 3, Reference<BlobConnectionProvider> >, public ActorCallback< ReadFromBlobActor, 4, RangeResult >, public ActorCallback< ReadFromBlobActor, 5, Void >, public FastAllocated<ReadFromBlobActor>, public ReadFromBlobActorState<ReadFromBlobActor> {
															#line 4328 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<ReadFromBlobActor>::operator new;
	using FastAllocated<ReadFromBlobActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14995275119506348032UL, 2541320130011553536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<VectorRef<KeyValueRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< ReadFromBlobActor, 1, Void >;
friend struct ActorCallback< ReadFromBlobActor, 2, Standalone<VectorRef<BlobGranuleChunkRef>> >;
friend struct ActorCallback< ReadFromBlobActor, 3, Reference<BlobConnectionProvider> >;
friend struct ActorCallback< ReadFromBlobActor, 4, RangeResult >;
friend struct ActorCallback< ReadFromBlobActor, 5, Void >;
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	ReadFromBlobActor(Database const& cx,Version const& readVersion,BlobRestoreWorkload* const& self) 
															#line 4350 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Standalone<VectorRef<KeyValueRef>>>(),
		   ReadFromBlobActorState<ReadFromBlobActor>(cx, readVersion, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readFromBlob", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6246917362517798400UL, 3517552783028558336UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromBlobActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readFromBlob");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readFromBlob", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadFromBlobActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadFromBlobActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadFromBlobActor, 2, Standalone<VectorRef<BlobGranuleChunkRef>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ReadFromBlobActor, 3, Reference<BlobConnectionProvider> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ReadFromBlobActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ReadFromBlobActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Standalone<VectorRef<KeyValueRef>>> readFromBlob( Database const& cx, Version const& readVersion, BlobRestoreWorkload* const& self ) {
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Standalone<VectorRef<KeyValueRef>>>(new ReadFromBlobActor(cx, readVersion, self));
															#line 4387 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 305 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

	static bool compare(VectorRef<KeyValueRef> src, VectorRef<KeyValueRef> dest) {
		if (src.size() != dest.size()) {
			fmt::print("Size mismatch src {} dest {}\n", src.size(), dest.size());
			int i = 0;
			for (; i < src.size() && i < dest.size(); ++i) {
				if (src[i].key != dest[i].key || src[i].value != dest[i].value) {
					fmt::print("First mismatch row at {}\n", i);
					fmt::print("  src {} = {}\n", src[i].key.printable(), src[i].value.printable());
					fmt::print("  dest {} = {}\n", dest[i].key.printable(), dest[i].value.printable());
					break;
				}
			}
			while (i < src.size()) {
				fmt::print("  src {} = {}\n", src[i].key.printable(), src[i].value.printable());
				i++;
			}
			while (i < dest.size()) {
				fmt::print("  dest {} = {}\n", dest[i].key.printable(), dest[i].value.printable());
				i++;
			}
			TraceEvent(SevError, "TestFailure")
			    .detail("Reason", "Size Mismatch")
			    .detail("Src", dest.size())
			    .detail("Dest", src.size());
			return false;
		}

		for (int i = 0; i < src.size(); ++i) {
			if (src[i].key != dest[i].key) {
				fmt::print("Key mismatch at {} src {} dest {}\n", i, src[i].key.printable(), dest[i].key.printable());
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Key Mismatch")
				    .detail("Index", i)
				    .detail("SrcKey", src[i].key.printable())
				    .detail("DestKey", dest[i].key.printable());
				return false;
			}
			if (src[i].value != dest[i].value) {
				fmt::print("Value mismatch at {}\n", i);
				TraceEvent(SevError, "TestFailure")
				    .detail("Reason", "Value Mismatch")
				    .detail("Index", i)
				    .detail("Key", src[i].key.printable())
				    .detail("SrcValue", src[i].value.printable())
				    .detail("DestValue", dest[i].value.printable());
				return false;
			}
		}
		fmt::print("Restore src({} rows) and dest({} rows) are consistent\n", src.size(), dest.size());
		return true;
	}

																#line 4444 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via flushBlobRanges()
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class FlushBlobRangesActor>
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class FlushBlobRangesActorState {
															#line 4450 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	FlushBlobRangesActorState(Database const& cx,BlobRestoreWorkload* const& self,Optional<Version> const& version) 
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   self(self),
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   version(version)
															#line 4461 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("flushBlobRanges", reinterpret_cast<unsigned long>(this));

	}
	~FlushBlobRangesActorState() 
	{
		fdb_probe_actor_destroy("flushBlobRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_0 = cx->listBlobbifiedRanges(normalKeys, CLIENT_KNOBS->TOO_MANY);
															#line 359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4478 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 1;
															#line 359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlushBlobRangesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<FlushBlobRangesActor*>(this)));
															#line 4483 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlushBlobRangesActorState();
		static_cast<FlushBlobRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 361 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		;
															#line 4506 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRangeRef>> const& __ranges,int loopDepth) 
	{
															#line 359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		ranges = __ranges;
															#line 4515 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRangeRef>> && __ranges,int loopDepth) 
	{
		ranges = std::move(__ranges);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state > 0) static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 0;
		static_cast<FlushBlobRangesActor*>(this)->ActorCallback< FlushBlobRangesActor, 0, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlushBlobRangesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			RangeForbody1cont1loopBody1Iterator0 = std::begin(ranges);
															#line 4602 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 382 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (e.code() != error_code_tag_throttled && e.code() != error_code_grv_proxy_memory_limit_exceeded)
															#line 4624 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			{
															#line 383 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
				fmt::print("Cannot flush blob ranges {}\n", e.what());
															#line 384 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
				return a_body1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 4630 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			}
															#line 386 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(2);
															#line 386 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4636 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 5;
															#line 386 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlushBlobRangesActor, 4, Void >*>(static_cast<FlushBlobRangesActor*>(this)));
															#line 4641 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 380 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<FlushBlobRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlushBlobRangesActorState(); static_cast<FlushBlobRangesActor*>(this)->destroy(); return 0; }
															#line 4656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<FlushBlobRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlushBlobRangesActorState();
		static_cast<FlushBlobRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!(RangeForbody1cont1loopBody1Iterator0 != std::end(ranges)))
															#line 4675 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		auto& r = *RangeForbody1cont1loopBody1Iterator0;
															#line 4681 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 364 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			range = r;
															#line 365 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			;
															#line 4687 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = a_body1cont1loopBody1loopBody1loopHead1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		++RangeForbody1cont1loopBody1Iterator0;
															#line 4710 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 374 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<bool> __when_expr_3 = cx->flushBlobRange(range, false, version);
															#line 374 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4721 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 4;
															#line 374 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlushBlobRangesActor, 3, bool >*>(static_cast<FlushBlobRangesActor*>(this)));
															#line 4726 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 366 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Version> __when_expr_1 = cx->verifyBlobRange(range, {}, {});
															#line 366 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4744 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 2;
															#line 366 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlushBlobRangesActor, 1, Version >*>(static_cast<FlushBlobRangesActor*>(this)));
															#line 4749 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont1(Version const& v,int loopDepth) 
	{
															#line 367 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (v != invalidVersion)
															#line 4771 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 368 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Validated blob range {} at {}\n", range.toString(), v);
															#line 4775 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			return a_body1cont1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 371 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(2.0);
															#line 371 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4782 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 3;
															#line 371 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlushBlobRangesActor, 2, Void >*>(static_cast<FlushBlobRangesActor*>(this)));
															#line 4787 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont1(Version && v,int loopDepth) 
	{
															#line 367 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (v != invalidVersion)
															#line 4796 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 368 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Validated blob range {} at {}\n", range.toString(), v);
															#line 4800 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			return a_body1cont1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 371 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(2.0);
															#line 371 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 4807 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 3;
															#line 371 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlushBlobRangesActor, 2, Void >*>(static_cast<FlushBlobRangesActor*>(this)));
															#line 4812 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state > 0) static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 0;
		static_cast<FlushBlobRangesActor*>(this)->ActorCallback< FlushBlobRangesActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlushBlobRangesActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state > 0) static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 0;
		static_cast<FlushBlobRangesActor*>(this)->ActorCallback< FlushBlobRangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlushBlobRangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1loopBody1cont4(bool const& flush,int loopDepth) 
	{
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!flush)
															#line 4983 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 376 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Cannot flush to version {} \n", version.present() ? version.get() : -1);
															#line 377 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			return a_body1cont1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 4989 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont4(bool && flush,int loopDepth) 
	{
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!flush)
															#line 4999 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 376 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Cannot flush to version {} \n", version.present() ? version.get() : -1);
															#line 377 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			return a_body1cont1loopBody1Catch1(internal_error(), std::max(0, loopDepth - 1));
															#line 5005 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(bool const& flush,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(flush, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont3when1(bool && flush,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont4(std::move(flush), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state > 0) static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 0;
		static_cast<FlushBlobRangesActor*>(this)->ActorCallback< FlushBlobRangesActor, 3, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 3, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 3, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlushBlobRangesActor, 3, bool >*,Error err) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlushBlobRangesActor*>(this)->actor_wait_state > 0) static_cast<FlushBlobRangesActor*>(this)->actor_wait_state = 0;
		static_cast<FlushBlobRangesActor*>(this)->ActorCallback< FlushBlobRangesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlushBlobRangesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlushBlobRangesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Database cx;
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Optional<Version> version;
															#line 359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	decltype(std::begin(std::declval<Standalone<VectorRef<KeyRangeRef>>>())) RangeForbody1cont1loopBody1Iterator0;
															#line 364 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	KeyRange range;
															#line 5185 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via flushBlobRanges()
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class FlushBlobRangesActor final : public Actor<Void>, public ActorCallback< FlushBlobRangesActor, 0, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< FlushBlobRangesActor, 1, Version >, public ActorCallback< FlushBlobRangesActor, 2, Void >, public ActorCallback< FlushBlobRangesActor, 3, bool >, public ActorCallback< FlushBlobRangesActor, 4, Void >, public FastAllocated<FlushBlobRangesActor>, public FlushBlobRangesActorState<FlushBlobRangesActor> {
															#line 5190 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<FlushBlobRangesActor>::operator new;
	using FastAllocated<FlushBlobRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1634235493579230208UL, 1825080668608718848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlushBlobRangesActor, 0, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< FlushBlobRangesActor, 1, Version >;
friend struct ActorCallback< FlushBlobRangesActor, 2, Void >;
friend struct ActorCallback< FlushBlobRangesActor, 3, bool >;
friend struct ActorCallback< FlushBlobRangesActor, 4, Void >;
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	FlushBlobRangesActor(Database const& cx,BlobRestoreWorkload* const& self,Optional<Version> const& version) 
															#line 5211 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   FlushBlobRangesActorState<FlushBlobRangesActor>(cx, self, version),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flushBlobRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15705000199235880448UL, 17372931830211191040UL);
		ActorExecutionContextHelper __helper(static_cast<FlushBlobRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flushBlobRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flushBlobRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlushBlobRangesActor, 0, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlushBlobRangesActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlushBlobRangesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlushBlobRangesActor, 3, bool >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlushBlobRangesActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> flushBlobRanges( Database const& cx, BlobRestoreWorkload* const& self, Optional<Version> const& version ) {
															#line 358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Void>(new FlushBlobRangesActor(cx, self, version));
															#line 5247 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 390 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

																#line 5252 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
// This generated class is to be used only via verify()
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
template <class VerifyActor>
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class VerifyActorState {
															#line 5258 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	VerifyActorState(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		 : cx(cx),
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		   self(self)
															#line 5267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("verify", reinterpret_cast<unsigned long>(this));

	}
	~VerifyActorState() 
	{
		fdb_probe_actor_destroy("verify", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 393 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = flushBlobRanges(cx, self, self->restoreTargetVersion_);
															#line 393 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			if (static_cast<VerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5284 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<VerifyActor*>(this)->actor_wait_state = 1;
															#line 393 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyActor, 0, Void >*>(static_cast<VerifyActor*>(this)));
															#line 5289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~VerifyActorState();
		static_cast<VerifyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_1 = readFromBlob(cx, self->restoreTargetVersion_, self);
															#line 396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<VerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5314 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyActor*>(this)->actor_wait_state = 2;
															#line 396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<VerifyActor*>(this)));
															#line 5319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_1 = readFromBlob(cx, self->restoreTargetVersion_, self);
															#line 396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<VerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<VerifyActor*>(this)->actor_wait_state = 2;
															#line 396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<VerifyActor*>(this)));
															#line 5335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyActor*>(this)->actor_wait_state > 0) static_cast<VerifyActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyActor*>(this)->ActorCallback< VerifyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 397 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("read src {} \n", src.size());
															#line 399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		StrictFuture<Standalone<VectorRef<KeyValueRef>>> __when_expr_2 = readFromStorageServer(self->extraDb_, self);
															#line 399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (static_cast<VerifyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5423 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<VerifyActor*>(this)->actor_wait_state = 3;
															#line 399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< VerifyActor, 2, Standalone<VectorRef<KeyValueRef>> >*>(static_cast<VerifyActor*>(this)));
															#line 5428 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyValueRef>> const& __src,int loopDepth) 
	{
															#line 396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		src = __src;
															#line 5437 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<VectorRef<KeyValueRef>> && __src,int loopDepth) 
	{
		src = std::move(__src);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyActor*>(this)->actor_wait_state > 0) static_cast<VerifyActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyActor*>(this)->ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> const& value) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> && value) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 400 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		fmt::print("read dest {} \n", dest.size());
															#line 401 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!compare(src, dest))
															#line 5518 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		{
															#line 402 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
			fmt::print("Verification fails\n");
															#line 5522 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		}
															#line 404 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		if (!static_cast<VerifyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~VerifyActorState(); static_cast<VerifyActor*>(this)->destroy(); return 0; }
															#line 5526 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		new (&static_cast<VerifyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~VerifyActorState();
		static_cast<VerifyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<VectorRef<KeyValueRef>> const& __dest,int loopDepth) 
	{
															#line 399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
		dest = __dest;
															#line 5538 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<VectorRef<KeyValueRef>> && __dest,int loopDepth) 
	{
		dest = std::move(__dest);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<VerifyActor*>(this)->actor_wait_state > 0) static_cast<VerifyActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyActor*>(this)->ActorCallback< VerifyActor, 2, Standalone<VectorRef<KeyValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyActor, 2, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> const& value) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< VerifyActor, 2, Standalone<VectorRef<KeyValueRef>> >*,Standalone<VectorRef<KeyValueRef>> && value) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< VerifyActor, 2, Standalone<VectorRef<KeyValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Database cx;
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	BlobRestoreWorkload* self;
															#line 396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> src;
															#line 399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> dest;
															#line 5621 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
};
// This generated class is to be used only via verify()
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
class VerifyActor final : public Actor<Void>, public ActorCallback< VerifyActor, 0, Void >, public ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >, public ActorCallback< VerifyActor, 2, Standalone<VectorRef<KeyValueRef>> >, public FastAllocated<VerifyActor>, public VerifyActorState<VerifyActor> {
															#line 5626 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
public:
	using FastAllocated<VerifyActor>::operator new;
	using FastAllocated<VerifyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10333693205294198272UL, 9316269533637359104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyActor, 0, Void >;
friend struct ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >;
friend struct ActorCallback< VerifyActor, 2, Standalone<VectorRef<KeyValueRef>> >;
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	VerifyActor(Database const& cx,BlobRestoreWorkload* const& self) 
															#line 5645 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   VerifyActorState<VerifyActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verify", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4885784437958244096UL, 790856369138454528UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verify");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verify", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< VerifyActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< VerifyActor, 1, Standalone<VectorRef<KeyValueRef>> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< VerifyActor, 2, Standalone<VectorRef<KeyValueRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
[[nodiscard]] static Future<Void> verify( Database const& cx, BlobRestoreWorkload* const& self ) {
															#line 391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"
	return Future<Void>(new VerifyActor(cx, self));
															#line 5679 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobRestoreWorkload.actor.g.cpp"
}

#line 406 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobRestoreWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override { out.emplace("Attrition"); }

private:
	Database extraDb_;
	bool setupBlob_;
	bool performRestore_;
	int readBatchSize_;
	bool restoreToVersion_;
	Version restoreTargetVersion_;
	Standalone<StringRef> blobManifestUrl_;
	Standalone<StringRef> mlogsUrl_;
	Reference<BlobConnectionProvider> blobConn_;
	BGTenantMap tenantData_;
	FileBackupAgent backupAgent_;
};

WorkloadFactory<BlobRestoreWorkload> BlobRestoreWorkloadFactory;
