#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
/*
 * BlobGranuleMergeBoundariesWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/Arena.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/Util.h"
#include <cstring>
#include <limits>

#include "flow/actorcompiler.h" // This must be the last #include.

/*
 * Verifies that, depending on the specified functionality for splitting a tuple prefix with
 * bg_key_tuple_truncate_offset=1 Writes several normal granules' worth of data to one tuple prefix, and validates the
 * desired configuration of splitting within a tuple prefix being allowed/disallowed.
 */
struct BlobGranuleMergeBoundariesWorkload : TestWorkload {
	static constexpr auto NAME = "BlobGranuleMergeBoundaries";
	int targetGranules;
	bool initAfter;
	int nodeCount;
	int targetValueLen;

	Optional<TenantName> tenantName;
	Optional<Reference<Tenant>> tenant;

	BlobGranuleMergeBoundariesWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		targetGranules = 3 + sharedRandomNumber % 6;
		sharedRandomNumber /= 6;
		initAfter = (sharedRandomNumber % 4) == 0;
		sharedRandomNumber /= 4;
		targetValueLen = 100 * (1 + sharedRandomNumber % 10);
		sharedRandomNumber /= 10;

		int64_t targetBytes = targetGranules * SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES;
		targetBytes = std::max<int64_t>(
		    1000000, targetBytes); // write at least 1 MB to avoid very small granule/byte sample issues
		nodeCount = (int)(targetBytes / targetValueLen);

		tenantName = "bgMergeBoundsTenant"_sr;

		// FIXME: maybe enable for completeness at some point? We probably will never convert non-empty ranges to blob
		// after 71.3
		initAfter = false;

		TraceEvent("BlobGranuleMergeBoundariesWorkloadInit")
		    .detail("TargetGranules", targetGranules)
		    .detail("InitAfter", initAfter)
		    .detail("TargetValSize", targetValueLen)
		    .detail("TargetBytes", targetBytes)
		    .detail("GranuleSize", SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_BYTES)
		    .detail("NodeCount", nodeCount);
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
// This generated class is to be used only via setUpBlobRange()
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
template <class SetUpBlobRangeActor>
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
class SetUpBlobRangeActorState {
															#line 92 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
public:
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	SetUpBlobRangeActorState(Database const& cx,BlobGranuleMergeBoundariesWorkload* const& self) 
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		 : cx(cx),
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		   self(self)
															#line 101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("setUpBlobRange", reinterpret_cast<unsigned long>(this));

	}
	~SetUpBlobRangeActorState() 
	{
		fdb_probe_actor_destroy("setUpBlobRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 85 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			StrictFuture<bool> __when_expr_0 = cx->blobbifyRange(normalKeys, self->tenant);
															#line 85 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 118 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state = 1;
															#line 85 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetUpBlobRangeActor, 0, bool >*>(static_cast<SetUpBlobRangeActor*>(this)));
															#line 123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& success,int loopDepth) 
	{
															#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		ASSERT(success);
															#line 87 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (!static_cast<SetUpBlobRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetUpBlobRangeActorState(); static_cast<SetUpBlobRangeActor*>(this)->destroy(); return 0; }
															#line 148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		new (&static_cast<SetUpBlobRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(bool && success,int loopDepth) 
	{
															#line 86 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		ASSERT(success);
															#line 87 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (!static_cast<SetUpBlobRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetUpBlobRangeActorState(); static_cast<SetUpBlobRangeActor*>(this)->destroy(); return 0; }
															#line 162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		new (&static_cast<SetUpBlobRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetUpBlobRangeActorState();
		static_cast<SetUpBlobRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& success,int loopDepth) 
	{
		loopDepth = a_body1cont1(success, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && success,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(success), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state > 0) static_cast<SetUpBlobRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetUpBlobRangeActor*>(this)->ActorCallback< SetUpBlobRangeActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< SetUpBlobRangeActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetUpBlobRangeActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetUpBlobRangeActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	Database cx;
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	BlobGranuleMergeBoundariesWorkload* self;
															#line 249 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
};
// This generated class is to be used only via setUpBlobRange()
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
class SetUpBlobRangeActor final : public Actor<Void>, public ActorCallback< SetUpBlobRangeActor, 0, bool >, public FastAllocated<SetUpBlobRangeActor>, public SetUpBlobRangeActorState<SetUpBlobRangeActor> {
															#line 254 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
public:
	using FastAllocated<SetUpBlobRangeActor>::operator new;
	using FastAllocated<SetUpBlobRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11984092843511032320UL, 8060572583486121472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetUpBlobRangeActor, 0, bool >;
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	SetUpBlobRangeActor(Database const& cx,BlobGranuleMergeBoundariesWorkload* const& self) 
															#line 271 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   SetUpBlobRangeActorState<SetUpBlobRangeActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setUpBlobRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4237211082324110336UL, 6312788034730357504UL);
		ActorExecutionContextHelper __helper(static_cast<SetUpBlobRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setUpBlobRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setUpBlobRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetUpBlobRangeActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
[[nodiscard]] Future<Void> setUpBlobRange( Database const& cx, BlobGranuleMergeBoundariesWorkload* const& self ) {
															#line 84 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	return Future<Void>(new SetUpBlobRangeActor(cx, self));
															#line 303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
}

#line 89 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"

	// Functions required by `bulkSetup()`
	// key is always a 2-tuple with the same first element and a different last element
	Key keyForIndex(int n) { return Tuple::makeTuple(7, n).pack(); }
	Value value(int n) {
		// FIXME: shared with BlobGranuleCorrectnessWorkload
		int valLen = deterministicRandom()->randomInt(1, 2 * targetValueLen);
		valLen = std::max(10, valLen);
		std::string v(valLen, 'z');
		auto valFormatted = format("%08x", n);
		ASSERT(valFormatted.size() <= v.size());

		for (int i = 0; i < valFormatted.size(); i++) {
			v[i] = valFormatted[i];
		}
		// copy into an arena
		// TODO do this in original arena? a bit more efficient that way
		Arena a;
		return Standalone<StringRef>(StringRef(a, v), a);
	}
	Standalone<KeyValueRef> operator()(int n) { return KeyValueRef(keyForIndex(n), value(n)); }

																#line 329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
template <class _setupActor>
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
class _setupActorState {
															#line 335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
public:
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	_setupActorState(Database const& cx,BlobGranuleMergeBoundariesWorkload* const& self) 
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		 : cx(cx),
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		   self(self)
															#line 344 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (self->clientId != 0)
															#line 359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			{
															#line 113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
				if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
				new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~_setupActorState();
				static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			TraceEvent("BlobGranuleMergeBoundariesInit") .detail("TargetGranules", self->targetGranules) .detail("InitAfter", self->initAfter);
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(ManagementAPI::changeConfig(cx.getReference(), "blob_granules_enabled=1", true));
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 380 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = TenantAPI::createTenant(cx.getReference(), self->tenantName.get());
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 405 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >*>(static_cast<_setupActor*>(this)));
															#line 410 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = TenantAPI::createTenant(cx.getReference(), self->tenantName.get());
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 421 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >*>(static_cast<_setupActor*>(this)));
															#line 426 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 124 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		self->tenant = makeReference<Tenant>(cx, self->tenantName.get());
															#line 126 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (!self->initAfter)
															#line 514 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
															#line 127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->setUpBlobRange(cx, self);
															#line 127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 520 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 525 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		ASSERT(entry.present());
															#line 124 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		self->tenant = makeReference<Tenant>(cx, self->tenantName.get());
															#line 126 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (!self->initAfter)
															#line 543 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
															#line 127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->setUpBlobRange(cx, self);
															#line 127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 549 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 3;
															#line 127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 2, Void >*>(static_cast<_setupActor*>(this)));
															#line 554 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesLoading");
															#line 146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_5 = bulkSetup(cx, self, self->nodeCount * self->clientCount, Promise<double>(), true, 0.0, 1e12, std::vector<uint64_t>(), Promise<std::vector<std::pair<uint64_t, double>>>(), 0, 0.1, 0, 0, { self->tenant.get() });
															#line 146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 647 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 6;
															#line 146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 5, Void >*>(static_cast<_setupActor*>(this)));
															#line 652 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesSetupVerifying");
															#line 130 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		;
															#line 663 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesSetupVerifying");
															#line 130 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		;
															#line 674 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = a_body1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _setupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _setupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1(int loopDepth) 
	{
															#line 131 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Version> __when_expr_3 = cx->verifyBlobRange(normalKeys, latestVersion, self->tenant);
															#line 131 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 773 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 4;
															#line 131 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 3, Version >*>(static_cast<_setupActor*>(this)));
															#line 778 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(Version const& checkVersion,int loopDepth) 
	{
															#line 132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (checkVersion != -1)
															#line 800 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesSetupVerifyRetrying");
															#line 138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(1.0);
															#line 138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 810 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 5;
															#line 138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 4, Void >*>(static_cast<_setupActor*>(this)));
															#line 815 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1(Version && checkVersion,int loopDepth) 
	{
															#line 132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (checkVersion != -1)
															#line 824 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
			return a_body1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesSetupVerifyRetrying");
															#line 138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(1.0);
															#line 138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 834 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont5loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<_setupActor*>(this)->actor_wait_state = 5;
															#line 138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 4, Void >*>(static_cast<_setupActor*>(this)));
															#line 839 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Version const& checkVersion,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(checkVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1when1(Version && checkVersion,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont1(std::move(checkVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 3, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _setupActor, 3, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _setupActor, 3, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _setupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _setupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesLoadingComplete");
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (self->initAfter)
															#line 1012 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_6 = self->setUpBlobRange(cx, self);
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1018 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 7;
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 6, Void >*>(static_cast<_setupActor*>(this)));
															#line 1023 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesLoadingComplete");
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (self->initAfter)
															#line 1039 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_6 = self->setUpBlobRange(cx, self);
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1045 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont7when1(__when_expr_6.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 7;
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 6, Void >*>(static_cast<_setupActor*>(this)));
															#line 1050 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _setupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _setupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 167 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesSetupComplete");
															#line 168 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 1141 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _setupActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _setupActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	Database cx;
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	BlobGranuleMergeBoundariesWorkload* self;
															#line 1240 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >, public ActorCallback< _setupActor, 2, Void >, public ActorCallback< _setupActor, 3, Version >, public ActorCallback< _setupActor, 4, Void >, public ActorCallback< _setupActor, 5, Void >, public ActorCallback< _setupActor, 6, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 1245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5213557601096295680UL, 8771027213845676800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >;
friend struct ActorCallback< _setupActor, 2, Void >;
friend struct ActorCallback< _setupActor, 3, Version >;
friend struct ActorCallback< _setupActor, 4, Void >;
friend struct ActorCallback< _setupActor, 5, Void >;
friend struct ActorCallback< _setupActor, 6, Void >;
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	_setupActor(Database const& cx,BlobGranuleMergeBoundariesWorkload* const& self) 
															#line 1268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _setupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _setupActor, 3, Version >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _setupActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _setupActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _setupActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, BlobGranuleMergeBoundariesWorkload* const& self ) {
															#line 111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 1306 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
}

#line 170 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override {
		// no test phase
		return Void();
	}

	Future<bool> check(Database const& cx) override { return _check(cx, this); }

																#line 1318 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
template <class _checkActor>
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
class _checkActorState {
															#line 1324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
public:
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	_checkActorState(Database const& cx,BlobGranuleMergeBoundariesWorkload* const& self) 
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		 : cx(cx),
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		   self(self)
															#line 1333 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 179 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (self->clientId != 0)
															#line 1348 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			{
															#line 180 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1352 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			tuplePrefix = Tuple::makeTuple(7).pack();
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			tupleRange = KeyRange(KeyRangeRef(tuplePrefix, strinc(tuplePrefix)));
															#line 185 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			TraceEvent("BlobGranuleMergeBoundariesCheckStart").detail("Range", tupleRange);
															#line 186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			;
															#line 1366 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		tr = Transaction(cx, self->tenant);
															#line 199 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		;
															#line 1391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 187 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Version> __when_expr_0 = cx->verifyBlobRange(tupleRange, latestVersion, self->tenant);
															#line 187 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1409 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 187 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Version >*>(static_cast<_checkActor*>(this)));
															#line 1414 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Version const& checkVersion,int loopDepth) 
	{
															#line 188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (checkVersion != -1)
															#line 1436 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
															#line 189 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			TraceEvent("BlobGranuleMergeBoundariesCheckRead").detail("CheckVersion", checkVersion);
															#line 1440 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesCheckRetrying");
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1449 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 1454 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Version && checkVersion,int loopDepth) 
	{
															#line 188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (checkVersion != -1)
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
															#line 189 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			TraceEvent("BlobGranuleMergeBoundariesCheckRead").detail("CheckVersion", checkVersion);
															#line 1467 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesCheckRetrying");
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1476 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 1481 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& checkVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(checkVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && checkVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(checkVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 221 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesCheckDone");
															#line 223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1654 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRangeRef>>> __when_expr_2 = tr.getBlobGranuleRanges(tupleRange, 1000000);
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1676 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 3;
															#line 201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 2, Standalone<VectorRef<KeyRangeRef>> >*>(static_cast<_checkActor*>(this)));
															#line 1681 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1718 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 4;
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 3, Void >*>(static_cast<_checkActor*>(this)));
															#line 1723 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
															#line 202 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesCheckGranules") .detail("GranuleCount", granules.size()) .detail("EnableSplitTruncated", SERVER_KNOBS->BG_ENABLE_SPLIT_TRUNCATED) .detail("TruncateOffset", SERVER_KNOBS->BG_KEY_TUPLE_TRUNCATE_OFFSET);
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (SERVER_KNOBS->BG_ENABLE_SPLIT_TRUNCATED)
															#line 1740 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
															#line 211 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			ASSERT(granules.size() >= 1);
															#line 1744 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		}
		else
		{
															#line 213 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			ASSERT(granules.size() == 1);
															#line 1750 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		}
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
															#line 202 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		TraceEvent("BlobGranuleMergeBoundariesCheckGranules") .detail("GranuleCount", granules.size()) .detail("EnableSplitTruncated", SERVER_KNOBS->BG_ENABLE_SPLIT_TRUNCATED) .detail("TruncateOffset", SERVER_KNOBS->BG_KEY_TUPLE_TRUNCATE_OFFSET);
															#line 206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
		if (SERVER_KNOBS->BG_ENABLE_SPLIT_TRUNCATED)
															#line 1762 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		{
															#line 211 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			ASSERT(granules.size() >= 1);
															#line 1766 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		}
		else
		{
															#line 213 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
			ASSERT(granules.size() == 1);
															#line 1772 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		}
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> const& granules,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(granules, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<VectorRef<KeyRangeRef>> && granules,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(granules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 2, Standalone<VectorRef<KeyRangeRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _checkActor, 2, Standalone<VectorRef<KeyRangeRef>> >*,Standalone<VectorRef<KeyRangeRef>> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _checkActor, 2, Standalone<VectorRef<KeyRangeRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _checkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _checkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	Database cx;
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	BlobGranuleMergeBoundariesWorkload* self;
															#line 182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	Key tuplePrefix;
															#line 184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	KeyRange tupleRange;
															#line 198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	Transaction tr;
															#line 1950 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Version >, public ActorCallback< _checkActor, 1, Void >, public ActorCallback< _checkActor, 2, Standalone<VectorRef<KeyRangeRef>> >, public ActorCallback< _checkActor, 3, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1955 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5686289996666124544UL, 15420597353467370240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Version >;
friend struct ActorCallback< _checkActor, 1, Void >;
friend struct ActorCallback< _checkActor, 2, Standalone<VectorRef<KeyRangeRef>> >;
friend struct ActorCallback< _checkActor, 3, Void >;
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	_checkActor(Database const& cx,BlobGranuleMergeBoundariesWorkload* const& self) 
															#line 1975 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _checkActor, 2, Standalone<VectorRef<KeyRangeRef>> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _checkActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, BlobGranuleMergeBoundariesWorkload* const& self ) {
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 2010 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.g.cpp"
}

#line 225 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/workloads/BlobGranuleMergeBoundariesWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<BlobGranuleMergeBoundariesWorkload> BlobGranuleMergeBoundariesWorkloadFactory;
