#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
/*
 * worker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdlib>
#include <tuple>
#include <boost/lexical_cast.hpp>
#include <unordered_map>

#include "fdbclient/FDBTypes.h"
#include "fdbserver/BlobMigratorInterface.h"
#include "flow/ApiVersion.h"
#include "flow/CodeProbe.h"
#include "flow/IAsyncFile.h"
#include "fdbrpc/Locality.h"
#include "fdbclient/GetEncryptCipherKeys_impl.actor.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/ProcessInterface.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbclient/versions.h"
#include "fdbserver/Knobs.h"
#include "flow/ActorCollection.h"
#include "flow/Error.h"
#include "flow/FileIdentifier.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/NetworkAddress.h"
#include "flow/ObjectSerializer.h"
#include "flow/Platform.h"
#include "flow/ProtocolVersion.h"
#include "flow/SystemMonitor.h"
#include "flow/TDMetric.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/MetricLogger.actor.h"
#include "fdbserver/BackupInterface.h"
#include "fdbclient/EncryptKeyProxyInterface.h"
#include "fdbserver/RoleLineage.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/IKeyValueStore.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/TesterInterface.actor.h" // for poisson()
#include "fdbserver/IDiskQueue.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbserver/DataDistributorInterface.h"
#include "fdbserver/BlobManagerInterface.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/FDBExecHelper.actor.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/ConfigNode.h"
#include "fdbserver/LocalConfiguration.h"
#include "fdbserver/RemoteIKeyValueStore.actor.h"
#include "fdbclient/MonitorLeader.h"
#include "fdbclient/ClientWorkerInterface.h"
#include "flow/Profiler.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"
#include "flow/network.h"
#include "flow/serialize.h"
#include "flow/ChaosMetrics.h"
#include "fdbrpc/SimulatorProcessInfo.h"

#ifdef __linux__
#include <fcntl.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#endif
#if defined(__linux__) || defined(__FreeBSD__)
#ifdef USE_GPERFTOOLS
#include "gperftools/profiler.h"
#include "gperftools/heap-profiler.h"
#endif
#include <unistd.h>
#include <thread>
#include <execinfo.h>
#endif
#include "flow/actorcompiler.h" // This must be the last #include.

#if CENABLED(0, NOT_IN_CLEAN)
extern IKeyValueStore* keyValueStoreCompressTestData(IKeyValueStore* store);
#define KV_STORE(filename, uid) keyValueStoreCompressTestData(keyValueStoreSQLite(filename, uid))
#elif CENABLED(0, NOT_IN_CLEAN)
#define KV_STORE(filename, uid) keyValueStoreSQLite(filename, uid)
#else
#define KV_STORE(filename, uid) keyValueStoreMemory(filename, uid)
#endif

template class RequestStream<RecruitMasterRequest, false>;
template struct NetNotifiedQueue<RecruitMasterRequest, false>;

template class RequestStream<RegisterMasterRequest, false>;
template struct NetNotifiedQueue<RegisterMasterRequest, false>;

template class RequestStream<InitializeCommitProxyRequest, false>;
template struct NetNotifiedQueue<InitializeCommitProxyRequest, false>;

template class RequestStream<InitializeGrvProxyRequest, false>;
template struct NetNotifiedQueue<InitializeGrvProxyRequest, false>;

template class RequestStream<GetServerDBInfoRequest, false>;
template struct NetNotifiedQueue<GetServerDBInfoRequest, false>;
template class GetEncryptCipherKeys<ServerDBInfo>;

namespace {
RoleLineageCollector roleLineageCollector;
}

															#line 130 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via tryDBInfoBroadcast()
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class TryDBInfoBroadcastActor>
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TryDBInfoBroadcastActorState {
															#line 137 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TryDBInfoBroadcastActorState(RequestStream<UpdateServerDBInfoRequest> const& stream,UpdateServerDBInfoRequest const& req) 
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : stream(stream),
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   req(req)
															#line 146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this));

	}
	~TryDBInfoBroadcastActorState() 
	{
		fdb_probe_actor_destroy("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 130 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<std::vector<Endpoint>>> __when_expr_0 = stream.getReplyUnlessFailedFor(req, SERVER_KNOBS->DBINFO_FAILED_DELAY, 0);
															#line 130 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state = 1;
															#line 130 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*>(static_cast<TryDBInfoBroadcastActor*>(this)));
															#line 168 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<std::vector<Endpoint>> const& rep,int loopDepth) 
	{
															#line 132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rep.present())
															#line 191 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(rep.get()); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 195 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(rep.get());
			this->~TryDBInfoBroadcastActorState();
			static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.broadcastInfo.push_back(stream.getEndpoint());
															#line 136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(req.broadcastInfo); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 205 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(req.broadcastInfo);
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(ErrorOr<std::vector<Endpoint>> && rep,int loopDepth) 
	{
															#line 132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rep.present())
															#line 217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(rep.get()); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 221 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(rep.get());
			this->~TryDBInfoBroadcastActorState();
			static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.broadcastInfo.push_back(stream.getEndpoint());
															#line 136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<TryDBInfoBroadcastActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(req.broadcastInfo); this->~TryDBInfoBroadcastActorState(); static_cast<TryDBInfoBroadcastActor*>(this)->destroy(); return 0; }
															#line 231 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<TryDBInfoBroadcastActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(req.broadcastInfo);
		this->~TryDBInfoBroadcastActorState();
		static_cast<TryDBInfoBroadcastActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<Endpoint>> const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1when1(ErrorOr<std::vector<Endpoint>> && rep,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state > 0) static_cast<TryDBInfoBroadcastActor*>(this)->actor_wait_state = 0;
		static_cast<TryDBInfoBroadcastActor*>(this)->ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >::remove();

	}
	void a_callback_fire(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,ErrorOr<std::vector<Endpoint>> const& value) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,ErrorOr<std::vector<Endpoint>> && value) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*,Error err) 
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RequestStream<UpdateServerDBInfoRequest> stream;
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateServerDBInfoRequest req;
															#line 318 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via tryDBInfoBroadcast()
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TryDBInfoBroadcastActor final : public Actor<std::vector<Endpoint>>, public ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >, public FastAllocated<TryDBInfoBroadcastActor>, public TryDBInfoBroadcastActorState<TryDBInfoBroadcastActor> {
															#line 323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<TryDBInfoBroadcastActor>::operator new;
	using FastAllocated<TryDBInfoBroadcastActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14659212830551746816UL, 9181798484140615680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Endpoint>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >;
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TryDBInfoBroadcastActor(RequestStream<UpdateServerDBInfoRequest> const& stream,UpdateServerDBInfoRequest const& req) 
															#line 340 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<std::vector<Endpoint>>(),
		   TryDBInfoBroadcastActorState<TryDBInfoBroadcastActor>(stream, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4829059694717746176UL, 12815649290741346816UL);
		ActorExecutionContextHelper __helper(static_cast<TryDBInfoBroadcastActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryDBInfoBroadcast");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryDBInfoBroadcast", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryDBInfoBroadcastActor, 0, ErrorOr<std::vector<Endpoint>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<std::vector<Endpoint>> tryDBInfoBroadcast( RequestStream<UpdateServerDBInfoRequest> const& stream, UpdateServerDBInfoRequest const& req ) {
															#line 128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<std::vector<Endpoint>>(new TryDBInfoBroadcastActor(stream, req));
															#line 373 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 378 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via broadcastDBInfoRequest()
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class BroadcastDBInfoRequestActor>
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class BroadcastDBInfoRequestActorState {
															#line 385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	BroadcastDBInfoRequestActorState(UpdateServerDBInfoRequest const& req,int const& sendAmount,Optional<Endpoint> const& sender,bool const& sendReply) 
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req),
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sendAmount(sendAmount),
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sender(sender),
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sendReply(sendReply),
															#line 143 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   replies(),
															#line 144 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   reply(req.reply)
															#line 402 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this));

	}
	~BroadcastDBInfoRequestActorState() 
	{
		fdb_probe_actor_destroy("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			resetReply(req);
															#line 146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			int currentStream = 0;
															#line 147 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> broadcastEndpoints = req.broadcastInfo;
															#line 148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			for(int i = 0;i < sendAmount && currentStream < broadcastEndpoints.size();i++) {
															#line 149 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::vector<Endpoint> endpoints;
															#line 150 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				RequestStream<UpdateServerDBInfoRequest> cur(broadcastEndpoints[currentStream++]);
															#line 151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				for(;currentStream < broadcastEndpoints.size() * (i + 1) / sendAmount;) {
															#line 152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					endpoints.push_back(broadcastEndpoints[currentStream++]);
															#line 431 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
															#line 154 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				req.broadcastInfo = endpoints;
															#line 155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				replies.push_back(tryDBInfoBroadcast(cur, req));
															#line 156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				resetReply(req);
															#line 439 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(replies);
															#line 158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 445 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*>(static_cast<BroadcastDBInfoRequestActor*>(this)));
															#line 450 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::vector<Endpoint> notUpdated;
															#line 160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sender.present())
															#line 475 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.push_back(sender.get());
															#line 479 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& it : replies ) {
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.insert(notUpdated.end(), it.get().begin(), it.get().end());
															#line 485 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 166 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sendReply)
															#line 489 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			reply.send(notUpdated);
															#line 493 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 169 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<BroadcastDBInfoRequestActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(notUpdated); this->~BroadcastDBInfoRequestActorState(); static_cast<BroadcastDBInfoRequestActor*>(this)->destroy(); return 0; }
															#line 497 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<BroadcastDBInfoRequestActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(notUpdated);
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 159 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::vector<Endpoint> notUpdated;
															#line 160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sender.present())
															#line 511 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 161 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.push_back(sender.get());
															#line 515 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 163 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& it : replies ) {
															#line 164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			notUpdated.insert(notUpdated.end(), it.get().begin(), it.get().end());
															#line 521 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 166 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (sendReply)
															#line 525 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 167 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			reply.send(notUpdated);
															#line 529 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 169 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<BroadcastDBInfoRequestActor*>(this)->SAV<std::vector<Endpoint>>::futures) { (void)(notUpdated); this->~BroadcastDBInfoRequestActorState(); static_cast<BroadcastDBInfoRequestActor*>(this)->destroy(); return 0; }
															#line 533 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<BroadcastDBInfoRequestActor*>(this)->SAV< std::vector<Endpoint> >::value()) std::vector<Endpoint>(notUpdated);
		this->~BroadcastDBInfoRequestActorState();
		static_cast<BroadcastDBInfoRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state > 0) static_cast<BroadcastDBInfoRequestActor*>(this)->actor_wait_state = 0;
		static_cast<BroadcastDBInfoRequestActor*>(this)->ActorCallback< BroadcastDBInfoRequestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateServerDBInfoRequest req;
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int sendAmount;
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<Endpoint> sender;
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool sendReply;
															#line 143 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<Future<std::vector<Endpoint>>> replies;
															#line 144 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ReplyPromise<std::vector<Endpoint>> reply;
															#line 628 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via broadcastDBInfoRequest()
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class BroadcastDBInfoRequestActor final : public Actor<std::vector<Endpoint>>, public ActorCallback< BroadcastDBInfoRequestActor, 0, Void >, public FastAllocated<BroadcastDBInfoRequestActor>, public BroadcastDBInfoRequestActorState<BroadcastDBInfoRequestActor> {
															#line 633 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<BroadcastDBInfoRequestActor>::operator new;
	using FastAllocated<BroadcastDBInfoRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5723988733996594688UL, 2649178656303685632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<Endpoint>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BroadcastDBInfoRequestActor, 0, Void >;
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	BroadcastDBInfoRequestActor(UpdateServerDBInfoRequest const& req,int const& sendAmount,Optional<Endpoint> const& sender,bool const& sendReply) 
															#line 650 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<std::vector<Endpoint>>(),
		   BroadcastDBInfoRequestActorState<BroadcastDBInfoRequestActor>(req, sendAmount, sender, sendReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7360236551166211584UL, 3807311166382409728UL);
		ActorExecutionContextHelper __helper(static_cast<BroadcastDBInfoRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("broadcastDBInfoRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("broadcastDBInfoRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BroadcastDBInfoRequestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<std::vector<Endpoint>> broadcastDBInfoRequest( UpdateServerDBInfoRequest const& req, int const& sendAmount, Optional<Endpoint> const& sender, bool const& sendReply ) {
															#line 139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<std::vector<Endpoint>>(new BroadcastDBInfoRequestActor(req, sendAmount, sender, sendReply));
															#line 683 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 171 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 688 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via extractClientInfo()
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ExtractClientInfoActor>
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClientInfoActorState {
															#line 695 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClientInfoActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<ClientDBInfo>> const& info) 
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : db(db),
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   info(info),
															#line 174 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastCommitProxyUIDs(),
															#line 175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastCommitProxies(),
															#line 176 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastGrvProxyUIDs(),
															#line 177 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastGrvProxies()
															#line 712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("extractClientInfo", reinterpret_cast<unsigned long>(this));

	}
	~ExtractClientInfoActorState() 
	{
		fdb_probe_actor_destroy("extractClientInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 727 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExtractClientInfoActorState();
		static_cast<ExtractClientInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 179 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ClientDBInfo ni = db->get().client;
															#line 180 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		shrinkProxyList(ni, lastCommitProxyUIDs, lastCommitProxies, lastGrvProxyUIDs, lastGrvProxies);
															#line 181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		info->setUnconditional(ni);
															#line 182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ExtractClientInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 765 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ExtractClientInfoActor*>(this)->actor_wait_state = 1;
															#line 182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExtractClientInfoActor, 0, Void >*>(static_cast<ExtractClientInfoActor*>(this)));
															#line 770 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExtractClientInfoActor*>(this)->actor_wait_state > 0) static_cast<ExtractClientInfoActor*>(this)->actor_wait_state = 0;
		static_cast<ExtractClientInfoActor*>(this)->ActorCallback< ExtractClientInfoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExtractClientInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExtractClientInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExtractClientInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClientDBInfo>> info;
															#line 174 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<UID> lastCommitProxyUIDs;
															#line 175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<CommitProxyInterface> lastCommitProxies;
															#line 176 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<UID> lastGrvProxyUIDs;
															#line 177 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::vector<GrvProxyInterface> lastGrvProxies;
															#line 874 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via extractClientInfo()
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ExtractClientInfoActor final : public Actor<Void>, public ActorCallback< ExtractClientInfoActor, 0, Void >, public FastAllocated<ExtractClientInfoActor>, public ExtractClientInfoActorState<ExtractClientInfoActor> {
															#line 879 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ExtractClientInfoActor>::operator new;
	using FastAllocated<ExtractClientInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1912166422449189120UL, 8858664212380216576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExtractClientInfoActor, 0, Void >;
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExtractClientInfoActor(Reference<AsyncVar<ServerDBInfo> const> const& db,Reference<AsyncVar<ClientDBInfo>> const& info) 
															#line 896 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ExtractClientInfoActorState<ExtractClientInfoActor>(db, info),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("extractClientInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(936284430390917120UL, 5465665005456452352UL);
		ActorExecutionContextHelper __helper(static_cast<ExtractClientInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("extractClientInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("extractClientInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExtractClientInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] static Future<Void> extractClientInfo( Reference<AsyncVar<ServerDBInfo> const> const& db, Reference<AsyncVar<ClientDBInfo>> const& info ) {
															#line 172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ExtractClientInfoActor(db, info));
															#line 929 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 185 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

Database openDBOnServer(Reference<AsyncVar<ServerDBInfo> const> const& db,
                        TaskPriority taskID,
                        LockAware lockAware,
                        EnableLocalityLoadBalance enableLocalityLoadBalance) {
	auto info = makeReference<AsyncVar<ClientDBInfo>>();
	auto cx = DatabaseContext::create(info,
	                                  extractClientInfo(db, info),
	                                  enableLocalityLoadBalance ? db->get().myLocality : LocalityData(),
	                                  enableLocalityLoadBalance,
	                                  taskID,
	                                  lockAware);
	cx->globalConfig->init(db, std::addressof(db->get().client));
	cx->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
	cx->globalConfig->trigger(samplingWindow, samplingProfilerUpdateWindow);
	return cx;
}

struct ErrorInfo {
	Error error;
	const Role& role;
	UID id;
	ErrorInfo(Error e, const Role& role, UID id) : error(e), role(role), id(id) {}
	template <class Ar>
	void serialize(Ar&) {
		ASSERT(false);
	}
};

Error checkIOTimeout(Error const& e) {
	// Convert all_errors to io_timeout if global timeout bool was set
	bool timeoutOccurred = (bool)g_network->global(INetwork::enASIOTimedOut);
	// In simulation, have to check global timed out flag for both this process and the machine process on which IO is
	// done
	if (g_network->isSimulated() && !timeoutOccurred)
		timeoutOccurred = g_simulator->getCurrentProcess()->machine->machineProcess->global(INetwork::enASIOTimedOut);

	if (timeoutOccurred) {
		CODE_PROBE(true, "Timeout occurred");
		Error timeout = io_timeout();
		// Preserve injectedness of error
		if (e.isInjectedFault())
			timeout = timeout.asInjectedFault();
		return timeout;
	}
	return e;
}

															#line 981 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via forwardError()
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ForwardErrorActor>
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ForwardErrorActorState {
															#line 988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ForwardErrorActorState(PromiseStream<ErrorInfo> const& errors,Role const& role,UID const& id,Future<Void> const& process) 
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : errors(errors),
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   role(role),
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   process(process)
															#line 1001 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("forwardError", reinterpret_cast<unsigned long>(this));

	}
	~ForwardErrorActorState() 
	{
		fdb_probe_actor_destroy("forwardError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 235 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = process;
															#line 235 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ForwardErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1019 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ForwardErrorActor*>(this)->actor_wait_state = 1;
															#line 235 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ForwardErrorActor, 0, Void >*>(static_cast<ForwardErrorActor*>(this)));
															#line 1024 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errors.send(ErrorInfo(e, role, id));
															#line 240 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1056 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ForwardErrorActorState();
			static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 236 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errors.send(ErrorInfo(success(), role, id));
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 236 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errors.send(ErrorInfo(success(), role, id));
															#line 237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ForwardErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ForwardErrorActorState(); static_cast<ForwardErrorActor*>(this)->destroy(); return 0; }
															#line 1090 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ForwardErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ForwardErrorActorState();
		static_cast<ForwardErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ForwardErrorActor*>(this)->actor_wait_state > 0) static_cast<ForwardErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ForwardErrorActor*>(this)->ActorCallback< ForwardErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ForwardErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ForwardErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	PromiseStream<ErrorInfo> errors;
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Role role;
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> process;
															#line 1181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via forwardError()
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ForwardErrorActor final : public Actor<Void>, public ActorCallback< ForwardErrorActor, 0, Void >, public FastAllocated<ForwardErrorActor>, public ForwardErrorActorState<ForwardErrorActor> {
															#line 1186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ForwardErrorActor>::operator new;
	using FastAllocated<ForwardErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5428566258293345280UL, 4137105105540640768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ForwardErrorActor, 0, Void >;
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ForwardErrorActor(PromiseStream<ErrorInfo> const& errors,Role const& role,UID const& id,Future<Void> const& process) 
															#line 1203 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ForwardErrorActorState<ForwardErrorActor>(errors, role, id, process),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("forwardError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1301226801814355968UL, 15803518444079550976UL);
		ActorExecutionContextHelper __helper(static_cast<ForwardErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("forwardError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("forwardError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ForwardErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> forwardError( PromiseStream<ErrorInfo> const& errors, Role const& role, UID const& id, Future<Void> const& process ) {
															#line 233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ForwardErrorActor(errors, role, id, process));
															#line 1236 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 243 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 1241 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via handleIOErrors()
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class HandleIOErrorsActor>
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HandleIOErrorsActorState {
															#line 1248 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HandleIOErrorsActorState(Future<Void> const& actor,Future<ErrorOr<Void>> const& storeError,UID const& id,Future<Void> const& onClosed = Void()) 
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : actor(actor),
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeError(storeError),
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   onClosed(onClosed)
															#line 1261 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("handleIOErrors", reinterpret_cast<unsigned long>(this));

	}
	~HandleIOErrorsActorState() 
	{
		fdb_probe_actor_destroy("handleIOErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 249 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(actor);
															#line 248 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1278 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Void>> __when_expr_1 = storeError;
															#line 1282 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 1;
															#line 249 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HandleIOErrorsActorState();
		static_cast<HandleIOErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Void> const& __e,int loopDepth) 
	{
															#line 249 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e = __e;
															#line 250 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_please_reboot)
															#line 1314 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
			loopDepth = a_body1when1cont1(loopDepth);
		}
		else
		{
															#line 253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onClosed;
															#line 253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 2;
															#line 253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 2, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(ErrorOr<Void> && __e,int loopDepth) 
	{
		e = std::move(__e);
															#line 250 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_please_reboot)
															#line 1340 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
			loopDepth = a_body1when1cont1(loopDepth);
		}
		else
		{
															#line 253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = onClosed;
															#line 253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1350 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when1when1(__when_expr_2.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 2;
															#line 253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 2, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1355 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when2(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerTerminatingByIOError", id).errorUnsuppressed(e.getError());
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		actor.cancel();
															#line 272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_file_not_found)
															#line 1369 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 273 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker terminated with file_not_found error");
															#line 274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 275 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() == error_code_lock_file_failure)
															#line 1385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 276 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Unable to lock file", probe::context::net2, probe::assert::noSim);
															#line 277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 279 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e.getError(), loopDepth);
															#line 1396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when2(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerTerminatingByIOError", id).errorUnsuppressed(e.getError());
															#line 269 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		actor.cancel();
															#line 272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_file_not_found)
															#line 1408 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 273 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker terminated with file_not_found error");
															#line 274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1414 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 275 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() == error_code_lock_file_failure)
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 276 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Unable to lock file", probe::context::net2, probe::assert::noSim);
															#line 277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(please_reboot_kv_store(), loopDepth);
															#line 1430 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 279 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		return a_body1Catch1(e.getError(), loopDepth);
															#line 1435 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >::remove();
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >::remove();

	}
	int a_body1when1cont1(int loopDepth) 
	{
															#line 255 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError() && e.getError().code() == error_code_broken_promise && !storeError.isReady())
															#line 1450 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 256 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(0.00001 + FLOW_KNOBS->MAX_BUGGIFIED_DELAY);
															#line 256 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1456 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when1cont1when1(__when_expr_3.get(), loopDepth); };
			static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 3;
															#line 256 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HandleIOErrorsActor, 3, Void >*>(static_cast<HandleIOErrorsActor*>(this)));
															#line 1461 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1when1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1when1cont3(int loopDepth) 
	{
															#line 258 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (storeError.isReady() && storeError.isError() && storeError.getError().code() != error_code_file_not_found)
															#line 1562 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 260 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(storeError.get().getError(), loopDepth);
															#line 1566 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 262 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.isError())
															#line 1570 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 263 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e.getError(), loopDepth);
															#line 1574 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 265 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<HandleIOErrorsActor*>(this)->SAV<Void>::futures) { (void)(e.get()); this->~HandleIOErrorsActorState(); static_cast<HandleIOErrorsActor*>(this)->destroy(); return 0; }
															#line 1580 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<HandleIOErrorsActor*>(this)->SAV< Void >::value()) Void(e.get());
			this->~HandleIOErrorsActorState();
			static_cast<HandleIOErrorsActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1when1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1when1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<HandleIOErrorsActor*>(this)->actor_wait_state > 0) static_cast<HandleIOErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<HandleIOErrorsActor*>(this)->ActorCallback< HandleIOErrorsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> actor;
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<ErrorOr<Void>> storeError;
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> onClosed;
															#line 249 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Void> e;
															#line 1800 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via handleIOErrors()
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HandleIOErrorsActor final : public Actor<Void>, public ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >, public ActorCallback< HandleIOErrorsActor, 2, Void >, public ActorCallback< HandleIOErrorsActor, 3, Void >, public ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >, public FastAllocated<HandleIOErrorsActor>, public HandleIOErrorsActorState<HandleIOErrorsActor> {
															#line 1805 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<HandleIOErrorsActor>::operator new;
	using FastAllocated<HandleIOErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10876652271066004480UL, 371795437877284864UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< HandleIOErrorsActor, 2, Void >;
friend struct ActorCallback< HandleIOErrorsActor, 3, Void >;
friend struct ActorCallback< HandleIOErrorsActor, 1, ErrorOr<Void> >;
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HandleIOErrorsActor(Future<Void> const& actor,Future<ErrorOr<Void>> const& storeError,UID const& id,Future<Void> const& onClosed = Void()) 
															#line 1825 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   HandleIOErrorsActorState<HandleIOErrorsActor>(actor, storeError, id, onClosed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("handleIOErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6206421713096993792UL, 16845784795105158144UL);
		ActorExecutionContextHelper __helper(static_cast<HandleIOErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("handleIOErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("handleIOErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< HandleIOErrorsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> handleIOErrors( Future<Void> const& actor, Future<ErrorOr<Void>> const& storeError, UID const& id, Future<Void> const& onClosed = Void() ) {
															#line 244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new HandleIOErrorsActor(actor, storeError, id, onClosed));
															#line 1860 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

Future<Void> handleIOErrors(Future<Void> actor, IClosable* store, UID id, Future<Void> onClosed = Void()) {
	Future<ErrorOr<Void>> storeError = actor.isReady() ? Never() : errorOr(store->getError());
	return handleIOErrors(actor, storeError, id, onClosed);
}

															#line 1870 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerHandleErrors()
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerHandleErrorsActor>
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerHandleErrorsActorState {
															#line 1877 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerHandleErrorsActorState(FutureStream<ErrorInfo> const& errors) 
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : errors(errors)
															#line 1884 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerHandleErrors", reinterpret_cast<unsigned long>(this));

	}
	~WorkerHandleErrorsActorState() 
	{
		fdb_probe_actor_destroy("workerHandleErrors", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 290 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 1899 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerHandleErrorsActorState();
		static_cast<WorkerHandleErrorsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<ErrorInfo> __when_expr_0 = errors;
															#line 290 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1931 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state = 1;
															#line 291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*>(static_cast<WorkerHandleErrorsActor*>(this)));
															#line 1936 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorInfo const& _err,int loopDepth) 
	{
															#line 292 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ErrorInfo err = _err;
															#line 293 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool ok = err.error.code() == error_code_success || err.error.code() == error_code_please_reboot || err.error.code() == error_code_actor_cancelled || err.error.code() == error_code_remote_kvs_cancelled || err.error.code() == error_code_coordinators_changed || err.error.code() == error_code_shutdown_in_progress || err.error.code() == error_code_audit_storage_task_outdated;
															#line 300 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ok)
															#line 1955 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 301 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			err.error = checkIOTimeout(err.error);
															#line 1959 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 304 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		endRole(err.role, err.id, "Error", ok, err.error);
															#line 306 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err.error.code() == error_code_please_reboot || (err.role == Role::SHARED_TRANSACTION_LOG && (err.error.code() == error_code_io_error || err.error.code() == error_code_io_timeout)) || (SERVER_KNOBS->STORAGE_SERVER_REBOOT_ON_IO_TIMEOUT && err.role == Role::STORAGE_SERVER && err.error.code() == error_code_io_timeout))
															#line 1965 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 311 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(err.error, std::max(0, loopDepth - 1));
															#line 1969 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorInfo && _err,int loopDepth) 
	{
															#line 292 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ErrorInfo err = _err;
															#line 293 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool ok = err.error.code() == error_code_success || err.error.code() == error_code_please_reboot || err.error.code() == error_code_actor_cancelled || err.error.code() == error_code_remote_kvs_cancelled || err.error.code() == error_code_coordinators_changed || err.error.code() == error_code_shutdown_in_progress || err.error.code() == error_code_audit_storage_task_outdated;
															#line 300 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ok)
															#line 1983 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 301 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			err.error = checkIOTimeout(err.error);
															#line 1987 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 304 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		endRole(err.role, err.id, "Error", ok, err.error);
															#line 306 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err.error.code() == error_code_please_reboot || (err.role == Role::SHARED_TRANSACTION_LOG && (err.error.code() == error_code_io_error || err.error.code() == error_code_io_timeout)) || (SERVER_KNOBS->STORAGE_SERVER_REBOOT_ON_IO_TIMEOUT && err.role == Role::STORAGE_SERVER && err.error.code() == error_code_io_timeout))
															#line 1993 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 311 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(err.error, std::max(0, loopDepth - 1));
															#line 1997 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state > 0) static_cast<WorkerHandleErrorsActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerHandleErrorsActor*>(this)->ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,ErrorInfo const& value) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,ErrorInfo && value) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*,Error err) 
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FutureStream<ErrorInfo> errors;
															#line 2068 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via workerHandleErrors()
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerHandleErrorsActor final : public Actor<Void>, public ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >, public FastAllocated<WorkerHandleErrorsActor>, public WorkerHandleErrorsActorState<WorkerHandleErrorsActor> {
															#line 2073 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<WorkerHandleErrorsActor>::operator new;
	using FastAllocated<WorkerHandleErrorsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14542139309306969600UL, 1921398082382520576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >;
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerHandleErrorsActor(FutureStream<ErrorInfo> const& errors) 
															#line 2090 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerHandleErrorsActorState<WorkerHandleErrorsActor>(errors),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerHandleErrors", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8795450729902019072UL, 3187225731259694336UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerHandleErrorsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerHandleErrors");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerHandleErrors", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< WorkerHandleErrorsActor, 0, ErrorInfo >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerHandleErrors( FutureStream<ErrorInfo> const& errors ) {
															#line 289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerHandleErrorsActor(errors));
															#line 2123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 315 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Improve simulation code coverage by sometimes deferring the destruction of workerInterface (and therefore "endpoint
// not found" responses to clients
//		for an extra second, so that clients are more likely to see broken_promise errors
															#line 2131 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via zombie()
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T, class ZombieActor>
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ZombieActorState {
															#line 2138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ZombieActorState(T const& workerInterface,Future<Void> const& worker) 
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : workerInterface(workerInterface),
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   worker(worker)
															#line 2147 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("zombie", reinterpret_cast<unsigned long>(this));

	}
	~ZombieActorState() 
	{
		fdb_probe_actor_destroy("zombie", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 322 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = worker;
															#line 322 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2165 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ZombieActor*>(this)->actor_wait_state = 1;
															#line 322 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 0, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2170 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ZombieActorState();
		static_cast<ZombieActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 327 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2200 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (BUGGIFY)
															#line 2214 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ZombieActor*>(this)->actor_wait_state = 2;
															#line 324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 1, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2225 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (BUGGIFY)
															#line 2239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<ZombieActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ZombieActor*>(this)->actor_wait_state = 2;
															#line 324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ZombieActor, 1, Void >*>(static_cast<ZombieActor*>(this)));
															#line 2250 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ZombieActor*>(this)->actor_wait_state > 0) static_cast<ZombieActor*>(this)->actor_wait_state = 0;
		static_cast<ZombieActor*>(this)->ActorCallback< ZombieActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZombieActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ZombieActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ZombieActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 325 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ZombieActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ZombieActorState(); static_cast<ZombieActor*>(this)->destroy(); return 0; }
															#line 2339 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ZombieActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ZombieActorState();
		static_cast<ZombieActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ZombieActor*>(this)->actor_wait_state > 0) static_cast<ZombieActor*>(this)->actor_wait_state = 0;
		static_cast<ZombieActor*>(this)->ActorCallback< ZombieActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ZombieActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ZombieActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ZombieActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	T workerInterface;
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> worker;
															#line 2438 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via zombie()
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T>
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ZombieActor final : public Actor<Void>, public ActorCallback< ZombieActor<T>, 0, Void >, public ActorCallback< ZombieActor<T>, 1, Void >, public FastAllocated<ZombieActor<T>>, public ZombieActorState<T, ZombieActor<T>> {
															#line 2445 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ZombieActor<T>>::operator new;
	using FastAllocated<ZombieActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2814359565965580032UL, 3217271935521781504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ZombieActor<T>, 0, Void >;
friend struct ActorCallback< ZombieActor<T>, 1, Void >;
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ZombieActor(T const& workerInterface,Future<Void> const& worker) 
															#line 2463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ZombieActorState<T, ZombieActor<T>>(workerInterface, worker),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("zombie", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17103515626195448064UL, 1853427329179145472UL);
		ActorExecutionContextHelper __helper(static_cast<ZombieActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("zombie");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("zombie", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ZombieActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ZombieActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class T>
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> zombie( T const& workerInterface, Future<Void> const& worker ) {
															#line 319 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ZombieActor<T>(workerInterface, worker));
															#line 2499 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 2504 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via loadedPonger()
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class LoadedPongerActor>
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class LoadedPongerActorState {
															#line 2511 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LoadedPongerActorState(FutureStream<LoadedPingRequest> const& pings) 
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : pings(pings),
															#line 332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   payloadBack(std::string(20480, '.'))
															#line 2520 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("loadedPonger", reinterpret_cast<unsigned long>(this));

	}
	~LoadedPongerActorState() 
	{
		fdb_probe_actor_destroy("loadedPonger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 334 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 2535 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadedPongerActorState();
		static_cast<LoadedPongerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<LoadedPingRequest> __when_expr_0 = pings;
															#line 335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<LoadedPongerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2567 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<LoadedPongerActor*>(this)->actor_wait_state = 1;
															#line 335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*>(static_cast<LoadedPongerActor*>(this)));
															#line 2572 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest const& pong,int loopDepth) 
	{
															#line 336 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LoadedReply rep;
															#line 337 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.payload = (pong.loadReply ? payloadBack : ""_sr);
															#line 338 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.id = pong.id;
															#line 339 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		pong.reply.send(rep);
															#line 2587 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(LoadedPingRequest && pong,int loopDepth) 
	{
															#line 336 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LoadedReply rep;
															#line 337 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.payload = (pong.loadReply ? payloadBack : ""_sr);
															#line 338 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rep.id = pong.id;
															#line 339 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		pong.reply.send(rep);
															#line 2602 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest const& pong,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(pong, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(LoadedPingRequest && pong,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(pong), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadedPongerActor*>(this)->actor_wait_state > 0) static_cast<LoadedPongerActor*>(this)->actor_wait_state = 0;
		static_cast<LoadedPongerActor*>(this)->ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,LoadedPingRequest const& value) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,LoadedPingRequest && value) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*,Error err) 
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FutureStream<LoadedPingRequest> pings;
															#line 332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Standalone<StringRef> payloadBack;
															#line 2686 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via loadedPonger()
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class LoadedPongerActor final : public Actor<Void>, public ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >, public FastAllocated<LoadedPongerActor>, public LoadedPongerActorState<LoadedPongerActor> {
															#line 2691 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<LoadedPongerActor>::operator new;
	using FastAllocated<LoadedPongerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6470837299408630784UL, 9082567864007896576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >;
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LoadedPongerActor(FutureStream<LoadedPingRequest> const& pings) 
															#line 2708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   LoadedPongerActorState<LoadedPongerActor>(pings),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadedPonger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17672933219176974592UL, 1478809613757852416UL);
		ActorExecutionContextHelper __helper(static_cast<LoadedPongerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadedPonger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadedPonger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< LoadedPongerActor, 0, LoadedPingRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> loadedPonger( FutureStream<LoadedPingRequest> const& pings ) {
															#line 331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new LoadedPongerActor(pings));
															#line 2741 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

StringRef fileStoragePrefix = "storage-"_sr;
StringRef testingStoragePrefix = "testingstorage-"_sr;
StringRef fileLogDataPrefix = "log-"_sr;
StringRef fileVersionedLogDataPrefix = "log2-"_sr;
StringRef fileLogQueuePrefix = "logqueue-"_sr;
StringRef tlogQueueExtension = "fdq"_sr;
StringRef fileBlobWorkerPrefix = "bw-"_sr;

enum class FilesystemCheck {
	FILES_ONLY,
	DIRECTORIES_ONLY,
	FILES_AND_DIRECTORIES,
};

struct KeyValueStoreSuffix {
	KeyValueStoreType type;
	std::string suffix;
	FilesystemCheck check;
};

KeyValueStoreSuffix bTreeV1Suffix = { KeyValueStoreType::SSD_BTREE_V1, ".fdb", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix bTreeV2Suffix = { KeyValueStoreType::SSD_BTREE_V2, ".sqlite", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix memorySuffix = { KeyValueStoreType::MEMORY, "-0.fdq", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix memoryRTSuffix = { KeyValueStoreType::MEMORY_RADIXTREE, "-0.fdr", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix redwoodSuffix = { KeyValueStoreType::SSD_REDWOOD_V1, ".redwood-v1", FilesystemCheck::FILES_ONLY };
KeyValueStoreSuffix rocksdbSuffix = { KeyValueStoreType::SSD_ROCKSDB_V1,
	                                  ".rocksdb",
	                                  FilesystemCheck::DIRECTORIES_ONLY };
KeyValueStoreSuffix shardedRocksdbSuffix = { KeyValueStoreType::SSD_SHARDED_ROCKSDB,
	                                         ".shardedrocksdb",
	                                         FilesystemCheck::DIRECTORIES_ONLY };

std::string validationFilename = "_validate";

std::string filenameFromSample(KeyValueStoreType storeType, std::string folder, std::string sample_filename) {
	if (storeType == KeyValueStoreType::SSD_BTREE_V1)
		return joinPath(folder, sample_filename);
	else if (storeType == KeyValueStoreType::SSD_BTREE_V2)
		return joinPath(folder, sample_filename);
	else if (storeType == KeyValueStoreType::MEMORY || storeType == KeyValueStoreType::MEMORY_RADIXTREE)
		return joinPath(folder, sample_filename.substr(0, sample_filename.size() - 5));
	else if (storeType == KeyValueStoreType::SSD_REDWOOD_V1)
		return joinPath(folder, sample_filename);
	else if (storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
		return joinPath(folder, sample_filename);
	else if (storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
		return joinPath(folder, sample_filename);
	UNREACHABLE();
}

std::string filenameFromId(KeyValueStoreType storeType, std::string folder, std::string prefix, UID id) {

	if (storeType == KeyValueStoreType::SSD_BTREE_V1)
		return joinPath(folder, prefix + id.toString() + ".fdb");
	else if (storeType == KeyValueStoreType::SSD_BTREE_V2)
		return joinPath(folder, prefix + id.toString() + ".sqlite");
	else if (storeType == KeyValueStoreType::MEMORY || storeType == KeyValueStoreType::MEMORY_RADIXTREE)
		return joinPath(folder, prefix + id.toString() + "-");
	else if (storeType == KeyValueStoreType::SSD_REDWOOD_V1)
		return joinPath(folder, prefix + id.toString() + ".redwood-v1");
	else if (storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
		return joinPath(folder, prefix + id.toString() + ".rocksdb");
	else if (storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
		return joinPath(folder, prefix + id.toString() + ".shardedrocksdb");

	TraceEvent(SevError, "UnknownStoreType").detail("StoreType", storeType.toString());
	UNREACHABLE();
}

struct TLogOptions {
	TLogOptions() = default;
	TLogOptions(TLogVersion v, TLogSpillType s) : version(v), spillType(s) {}

	TLogVersion version = TLogVersion::DEFAULT;
	TLogSpillType spillType = TLogSpillType::UNSET;

	static ErrorOr<TLogOptions> FromStringRef(StringRef s) {
		TLogOptions options;
		for (StringRef key = s.eat("_"), value = s.eat("_"); s.size() != 0 || key.size();
		     key = s.eat("_"), value = s.eat("_")) {
			if (key.size() != 0 && value.size() == 0)
				return default_error_or();

			if (key == "V"_sr) {
				ErrorOr<TLogVersion> tLogVersion = TLogVersion::FromStringRef(value);
				if (tLogVersion.isError())
					return tLogVersion.getError();
				options.version = tLogVersion.get();
			} else if (key == "LS"_sr) {
				ErrorOr<TLogSpillType> tLogSpillType = TLogSpillType::FromStringRef(value);
				if (tLogSpillType.isError())
					return tLogSpillType.getError();
				options.spillType = tLogSpillType.get();
			} else {
				return default_error_or();
			}
		}
		return options;
	}

	bool operator==(const TLogOptions& o) {
		return version == o.version && (spillType == o.spillType || version >= TLogVersion::V5);
	}

	std::string toPrefix() const {
		std::string toReturn = "";
		switch (version) {
		case TLogVersion::UNSET:
			ASSERT(false);
		case TLogVersion::V2:
			return "";
		case TLogVersion::V3:
		case TLogVersion::V4:
			toReturn =
			    "V_" + boost::lexical_cast<std::string>(version) + "_LS_" + boost::lexical_cast<std::string>(spillType);
			break;
		case TLogVersion::V5:
		case TLogVersion::V6:
		case TLogVersion::V7:
			toReturn = "V_" + boost::lexical_cast<std::string>(version);
			break;
		}
		ASSERT_WE_THINK(FromStringRef(toReturn).get() == *this);
		return toReturn + "-";
	}

	DiskQueueVersion getDiskQueueVersion() const {
		if (version < TLogVersion::V3) {
			ASSERT(false); // no longer supported
			return DiskQueueVersion::V0;
		}
		if (version < TLogVersion::V7)
			return DiskQueueVersion::V1;
		return DiskQueueVersion::V2;
	}
};

TLogFn tLogFnForOptions(TLogOptions options) {
	switch (options.version) {
	case TLogVersion::V2:
	case TLogVersion::V3:
	case TLogVersion::V4:
		ASSERT(false); // V2 to V4 are no longer supported

	case TLogVersion::V5:
	case TLogVersion::V6:
	case TLogVersion::V7:
		return tLog;
	default:
		ASSERT(false);
	}
	return tLog;
}

struct DiskStore {
	enum COMPONENT { TLogData, Storage, BlobWorker, UNSET };

	UID storeID = UID();
	std::string filename = ""; // For KVStoreMemory just the base filename to be passed to IDiskQueue
	COMPONENT storedComponent = UNSET;
	KeyValueStoreType storeType = KeyValueStoreType::END;
	TLogOptions tLogOptions;
};

std::vector<DiskStore> getDiskStores(std::string folder,
                                     std::string suffix,
                                     KeyValueStoreType type,
                                     FilesystemCheck check) {
	std::vector<DiskStore> result;
	std::vector<std::string> files;

	if (check == FilesystemCheck::FILES_ONLY || check == FilesystemCheck::FILES_AND_DIRECTORIES) {
		files = platform::listFiles(folder, suffix);
	}
	if (check == FilesystemCheck::DIRECTORIES_ONLY || check == FilesystemCheck::FILES_AND_DIRECTORIES) {
		for (const auto& directory : platform::listDirectories(folder)) {
			if (StringRef(directory).endsWith(suffix)) {
				files.push_back(directory);
			}
		}
	}

	for (int idx = 0; idx < files.size(); idx++) {
		DiskStore store;
		store.storeType = type;

		StringRef filename = StringRef(files[idx]);
		Standalone<StringRef> prefix;
		if (filename.startsWith(fileStoragePrefix)) {
			store.storedComponent = DiskStore::Storage;
			prefix = fileStoragePrefix;
		} else if (filename.startsWith(testingStoragePrefix)) {
			store.storedComponent = DiskStore::Storage;
			prefix = testingStoragePrefix;
		} else if (filename.startsWith(fileVersionedLogDataPrefix)) {
			store.storedComponent = DiskStore::TLogData;
			// Use the option string that's in the file rather than tLogOptions.toPrefix(),
			// because they might be different if a new option was introduced in this version.
			StringRef optionsString = filename.removePrefix(fileVersionedLogDataPrefix).eat("-");
			TraceEvent("DiskStoreVersioned").detail("Filename", filename);
			ErrorOr<TLogOptions> tLogOptions = TLogOptions::FromStringRef(optionsString);
			if (tLogOptions.isError()) {
				TraceEvent(SevWarn, "DiskStoreMalformedFilename").detail("Filename", filename);
				continue;
			}
			TraceEvent("DiskStoreVersionedSuccess").detail("Filename", filename);
			store.tLogOptions = tLogOptions.get();
			prefix = filename.substr(0, fileVersionedLogDataPrefix.size() + optionsString.size() + 1);
		} else if (filename.startsWith(fileLogDataPrefix)) {
			TraceEvent("DiskStoreUnversioned").detail("Filename", filename);
			store.storedComponent = DiskStore::TLogData;
			store.tLogOptions.version = TLogVersion::V2;
			store.tLogOptions.spillType = TLogSpillType::VALUE;
			prefix = fileLogDataPrefix;
		} else if (filename.startsWith(fileBlobWorkerPrefix)) {
			store.storedComponent = DiskStore::BlobWorker;
			prefix = fileBlobWorkerPrefix;
		} else {
			continue;
		}

		store.storeID = UID::fromString(files[idx].substr(prefix.size(), 32));
		store.filename = filenameFromSample(type, folder, files[idx]);
		result.push_back(store);
	}
	return result;
}

std::vector<DiskStore> getDiskStores(std::string folder) {
	auto result = getDiskStores(folder, bTreeV1Suffix.suffix, bTreeV1Suffix.type, bTreeV1Suffix.check);
	auto result1 = getDiskStores(folder, bTreeV2Suffix.suffix, bTreeV2Suffix.type, bTreeV2Suffix.check);
	result.insert(result.end(), result1.begin(), result1.end());
	auto result2 = getDiskStores(folder, memorySuffix.suffix, memorySuffix.type, memorySuffix.check);
	result.insert(result.end(), result2.begin(), result2.end());
	auto result3 = getDiskStores(folder, redwoodSuffix.suffix, redwoodSuffix.type, redwoodSuffix.check);
	result.insert(result.end(), result3.begin(), result3.end());
	auto result4 = getDiskStores(folder, memoryRTSuffix.suffix, memoryRTSuffix.type, memoryRTSuffix.check);
	result.insert(result.end(), result4.begin(), result4.end());
	auto result5 = getDiskStores(folder, rocksdbSuffix.suffix, rocksdbSuffix.type, rocksdbSuffix.check);
	result.insert(result.end(), result5.begin(), result5.end());
	auto result6 =
	    getDiskStores(folder, shardedRocksdbSuffix.suffix, shardedRocksdbSuffix.type, shardedRocksdbSuffix.check);
	result.insert(result.end(), result6.begin(), result6.end());
	return result;
}

// Register the worker interf to cluster controller (cc) and
// re-register the worker when key roles interface, e.g., cc, dd, ratekeeper, change.
															#line 2994 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via registrationClient()
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RegistrationClientActor>
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegistrationClientActorState {
															#line 3001 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegistrationClientActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf,Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf,Reference<AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>> const> const& bmInterf,Reference<AsyncVar<Optional<BlobMigratorInterface>> const> const& blobMigratorInterf,Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf,Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf,Reference<AsyncVar<bool> const> const& degraded,Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<std::set<std::string>> const> const& issues,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,ConfigBroadcastInterface const& configBroadcastInterface,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Promise<Void> const& recoveredDiskFiles,Reference<AsyncVar<Optional<UID>>> const& clusterId) 
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccInterface(ccInterface),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(interf),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   initialClass(initialClass),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ddInterf(ddInterf),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rkInterf(rkInterf),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   bmInterf(bmInterf),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   blobMigratorInterf(blobMigratorInterf),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ekpInterf(ekpInterf),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   csInterf(csInterf),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   degraded(degraded),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   connRecord(connRecord),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   issues(issues),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configNode(configNode),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   localConfig(localConfig),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configBroadcastInterface(configBroadcastInterface),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   recoveredDiskFiles(recoveredDiskFiles),
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 614 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   requestGeneration(0),
															#line 615 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   processClass(initialClass),
															#line 616 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   scInterf(new AsyncVar<Optional<std::pair<uint16_t, StorageServerInterface>>>()),
															#line 618 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cacheProcessFuture(),
															#line 619 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cacheErrorsFuture(),
															#line 620 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   incorrectTime(),
															#line 621 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   firstReg(true)
															#line 3058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("registrationClient", reinterpret_cast<unsigned long>(this));

	}
	~RegistrationClientActorState() 
	{
		fdb_probe_actor_destroy("registrationClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 622 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 3073 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegistrationClientActorState();
		static_cast<RegistrationClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 623 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		storedConnectionString = ClusterConnectionString();
															#line 624 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = true;
															#line 625 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (connRecord)
															#line 3107 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 626 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<bool> __when_expr_0 = connRecord->upToDate(storedConnectionString);
															#line 626 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<RegistrationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RegistrationClientActor*>(this)->actor_wait_state = 1;
															#line 626 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 0, bool >*>(static_cast<RegistrationClientActor*>(this)));
															#line 3118 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 629 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (upToDate)
															#line 3132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 630 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			incorrectTime = Optional<double>();
															#line 3136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 633 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RegisterWorkerRequest request( interf, initialClass, processClass, asyncPriorityInfo->get(), requestGeneration++, ddInterf->get(), rkInterf->get(), bmInterf->get().present() ? bmInterf->get().get().second : Optional<BlobManagerInterface>(), blobMigratorInterf->get(), ekpInterf->get(), csInterf->get(), degraded->get(), localConfig.isValid() ? localConfig->lastSeenVersion() : Optional<Version>(), localConfig.isValid() ? localConfig->configClassSet() : Optional<ConfigClassSet>(), recoveredDiskFiles.isSet(), configBroadcastInterface, clusterId->get());
															#line 652 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto const& i : issues->get() ) {
															#line 653 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.issues.push_back_deep(request.issues.arena(), i);
															#line 3144 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!upToDate)
															#line 3148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 657 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.issues.push_back_deep(request.issues.arena(), "incorrect_cluster_file_contents"_sr);
															#line 658 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string connectionString = connRecord->getConnectionString().toString();
															#line 659 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!incorrectTime.present())
															#line 3156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 660 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				incorrectTime = now();
															#line 3160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 665 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(now() - incorrectTime.get() > 300 ? SevWarnAlways : SevWarn, "IncorrectClusterFileContents") .detail("ClusterFile", connRecord->toString()) .detail("StoredConnectionString", storedConnectionString.toString()) .detail("CurrentConnectionString", connectionString);
															#line 3164 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 670 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto peers = FlowTransport::transport().getIncompatiblePeers();
															#line 671 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(auto it = peers->begin();it != peers->end();) {
															#line 672 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (now() - it->second.second > FLOW_KNOBS->INCOMPATIBLE_PEER_DELAY_BEFORE_LOGGING)
															#line 3172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 673 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				request.incompatiblePeers.push_back(it->first);
															#line 674 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				it = peers->erase(it);
															#line 3178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 676 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				it++;
															#line 3184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 680 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ccInterfacePresent = ccInterface->get().present();
															#line 681 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ccInterfacePresent)
															#line 3191 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 682 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			request.requestDbInfo = (ccInterface->get().get().id() != dbInfo->get().clusterInterface.id());
															#line 683 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (firstReg)
															#line 3197 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 684 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				request.requestDbInfo = true;
															#line 685 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				firstReg = false;
															#line 3203 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 687 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("WorkerRegister") .detail("CCID", ccInterface->get().get().id()) .detail("Generation", requestGeneration) .detail("RecoveredDiskFiles", recoveredDiskFiles.isSet()) .detail("ClusterId", clusterId->get());
															#line 3207 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 693 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		registrationReply = ccInterfacePresent ? brokenPromiseToNever(ccInterface->get().get().registerWorker.getReply(request)) : Never();
															#line 696 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recovered = recoveredDiskFiles.isSet() ? Never() : recoveredDiskFiles.getFuture();
															#line 697 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startTime = now();
															#line 698 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		;
															#line 3217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool const& upToDateResult,int loopDepth) 
	{
															#line 627 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = upToDateResult;
															#line 3226 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(bool && upToDateResult,int loopDepth) 
	{
															#line 627 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		upToDate = upToDateResult;
															#line 3235 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& upToDateResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(upToDateResult, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && upToDateResult,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(upToDateResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state > 0) static_cast<RegistrationClientActor*>(this)->actor_wait_state = 0;
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 699 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<RegisterWorkerReply> __when_expr_1 = registrationReply;
															#line 698 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3334 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 707 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->UNKNOWN_CC_TIMEOUT);
															#line 3338 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = ccInterface->onChange();
															#line 3342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
															#line 715 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = ddInterf->onChange();
															#line 3346 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when4(__when_expr_4.get(), loopDepth); };
															#line 718 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_5 = rkInterf->onChange();
															#line 3350 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when5(__when_expr_5.get(), loopDepth); };
															#line 721 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_6 = csInterf->onChange();
															#line 3354 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when6(__when_expr_6.get(), loopDepth); };
															#line 724 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_7 = bmInterf->onChange();
															#line 3358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when7(__when_expr_7.get(), loopDepth); };
															#line 727 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_8 = blobMigratorInterf->onChange();
															#line 3362 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when8(__when_expr_8.get(), loopDepth); };
															#line 730 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_9 = ekpInterf->onChange();
															#line 3366 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when9(__when_expr_9.get(), loopDepth); };
															#line 733 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_10 = degraded->onChange();
															#line 3370 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when10(__when_expr_10.get(), loopDepth); };
															#line 736 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_11 = FlowTransport::transport().onIncompatibleChanged();
															#line 3374 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when11(__when_expr_11.get(), loopDepth); };
															#line 739 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_12 = issues->onChange();
															#line 3378 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when12(__when_expr_12.get(), loopDepth); };
															#line 742 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_13 = recovered;
															#line 3382 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when13(__when_expr_13.get(), loopDepth); };
															#line 745 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_14 = clusterId->onChange();
															#line 3386 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1when14(__when_expr_14.get(), loopDepth); };
		static_cast<RegistrationClientActor*>(this)->actor_wait_state = 2;
															#line 699 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*>(static_cast<RegistrationClientActor*>(this)));
															#line 707 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 2, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 3, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 715 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 4, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 718 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 5, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 721 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 6, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 724 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 7, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 727 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 8, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 730 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 9, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 733 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 10, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 736 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 11, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 739 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 12, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 742 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 13, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 745 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< RegistrationClientActor, 14, Void >*>(static_cast<RegistrationClientActor*>(this)));
															#line 3417 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RegisterWorkerReply const& reply,int loopDepth) 
	{
															#line 700 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		processClass = reply.processClass;
															#line 701 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		asyncPriorityInfo->set(reply.priorityInfo);
															#line 702 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerRegisterReply") .detail("CCID", ccInterface->get().get().id()) .detail("ProcessClass", reply.processClass.toString());
															#line 3449 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(RegisterWorkerReply && reply,int loopDepth) 
	{
															#line 700 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		processClass = reply.processClass;
															#line 701 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		asyncPriorityInfo->set(reply.priorityInfo);
															#line 702 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("WorkerRegisterReply") .detail("CCID", ccInterface->get().get().id()) .detail("ProcessClass", reply.processClass.toString());
															#line 3462 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ccInterfacePresent)
															#line 3471 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 709 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarn, "WorkerRegisterTimeout").detail("WaitTime", now() - startTime);
															#line 3475 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!ccInterfacePresent)
															#line 3485 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 709 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarn, "WorkerRegisterTimeout").detail("WaitTime", now() - startTime);
															#line 3489 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when3(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when4(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when4(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when5(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when5(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when7(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when7(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when8(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when8(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when9(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when9(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when10(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when10(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when11(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when11(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when12(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when12(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when13(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when13(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when14(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when14(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegistrationClientActor*>(this)->actor_wait_state > 0) static_cast<RegistrationClientActor*>(this)->actor_wait_state = 0;
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 2, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 3, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 4, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 5, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 6, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 7, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 8, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 9, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 10, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 11, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 12, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 13, Void >::remove();
		static_cast<RegistrationClientActor*>(this)->ActorCallback< RegistrationClientActor, 14, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,RegisterWorkerReply const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,RegisterWorkerReply && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 12, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when12(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 12, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 12, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when13(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when13(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 14, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when14(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< RegistrationClientActor, 14, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when14(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< RegistrationClientActor, 14, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ClusterControllerPriorityInfo>> asyncPriorityInfo;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass initialClass;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<DataDistributorInterface>> const> ddInterf;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<RatekeeperInterface>> const> rkInterf;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>> const> bmInterf;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<BlobMigratorInterface>> const> blobMigratorInterf;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> ekpInterf;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> csInterf;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool> const> degraded;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<IClusterConnectionRecord> connRecord;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>> const> issues;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<ConfigNode> configNode;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<LocalConfiguration> localConfig;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ConfigBroadcastInterface configBroadcastInterface;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void> recoveredDiskFiles;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 614 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Generation requestGeneration;
															#line 615 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProcessClass processClass;
															#line 616 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<std::pair<uint16_t, StorageServerInterface>>>> scInterf;
															#line 618 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> cacheProcessFuture;
															#line 619 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> cacheErrorsFuture;
															#line 620 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<double> incorrectTime;
															#line 621 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool firstReg;
															#line 623 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ClusterConnectionString storedConnectionString;
															#line 624 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool upToDate;
															#line 680 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool ccInterfacePresent;
															#line 693 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<RegisterWorkerReply> registrationReply;
															#line 696 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> recovered;
															#line 697 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	double startTime;
															#line 4520 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via registrationClient()
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RegistrationClientActor final : public Actor<Void>, public ActorCallback< RegistrationClientActor, 0, bool >, public ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >, public ActorCallback< RegistrationClientActor, 2, Void >, public ActorCallback< RegistrationClientActor, 3, Void >, public ActorCallback< RegistrationClientActor, 4, Void >, public ActorCallback< RegistrationClientActor, 5, Void >, public ActorCallback< RegistrationClientActor, 6, Void >, public ActorCallback< RegistrationClientActor, 7, Void >, public ActorCallback< RegistrationClientActor, 8, Void >, public ActorCallback< RegistrationClientActor, 9, Void >, public ActorCallback< RegistrationClientActor, 10, Void >, public ActorCallback< RegistrationClientActor, 11, Void >, public ActorCallback< RegistrationClientActor, 12, Void >, public ActorCallback< RegistrationClientActor, 13, Void >, public ActorCallback< RegistrationClientActor, 14, Void >, public FastAllocated<RegistrationClientActor>, public RegistrationClientActorState<RegistrationClientActor> {
															#line 4525 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RegistrationClientActor>::operator new;
	using FastAllocated<RegistrationClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15098153114675511296UL, 3152992638156076800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegistrationClientActor, 0, bool >;
friend struct ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >;
friend struct ActorCallback< RegistrationClientActor, 2, Void >;
friend struct ActorCallback< RegistrationClientActor, 3, Void >;
friend struct ActorCallback< RegistrationClientActor, 4, Void >;
friend struct ActorCallback< RegistrationClientActor, 5, Void >;
friend struct ActorCallback< RegistrationClientActor, 6, Void >;
friend struct ActorCallback< RegistrationClientActor, 7, Void >;
friend struct ActorCallback< RegistrationClientActor, 8, Void >;
friend struct ActorCallback< RegistrationClientActor, 9, Void >;
friend struct ActorCallback< RegistrationClientActor, 10, Void >;
friend struct ActorCallback< RegistrationClientActor, 11, Void >;
friend struct ActorCallback< RegistrationClientActor, 12, Void >;
friend struct ActorCallback< RegistrationClientActor, 13, Void >;
friend struct ActorCallback< RegistrationClientActor, 14, Void >;
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RegistrationClientActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf,Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf,Reference<AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>> const> const& bmInterf,Reference<AsyncVar<Optional<BlobMigratorInterface>> const> const& blobMigratorInterf,Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf,Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf,Reference<AsyncVar<bool> const> const& degraded,Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<std::set<std::string>> const> const& issues,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,ConfigBroadcastInterface const& configBroadcastInterface,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,Promise<Void> const& recoveredDiskFiles,Reference<AsyncVar<Optional<UID>>> const& clusterId) 
															#line 4556 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RegistrationClientActorState<RegistrationClientActor>(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, bmInterf, blobMigratorInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registrationClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3853273321946395648UL, 10112439968674810368UL);
		ActorExecutionContextHelper __helper(static_cast<RegistrationClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registrationClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registrationClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegistrationClientActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegistrationClientActor, 1, RegisterWorkerReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> registrationClient( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, WorkerInterface const& interf, Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo, ProcessClass const& initialClass, Reference<AsyncVar<Optional<DataDistributorInterface>> const> const& ddInterf, Reference<AsyncVar<Optional<RatekeeperInterface>> const> const& rkInterf, Reference<AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>> const> const& bmInterf, Reference<AsyncVar<Optional<BlobMigratorInterface>> const> const& blobMigratorInterf, Reference<AsyncVar<Optional<EncryptKeyProxyInterface>> const> const& ekpInterf, Reference<AsyncVar<Optional<ConsistencyScanInterface>> const> const& csInterf, Reference<AsyncVar<bool> const> const& degraded, Reference<IClusterConnectionRecord> const& connRecord, Reference<AsyncVar<std::set<std::string>> const> const& issues, Reference<ConfigNode> const& configNode, Reference<LocalConfiguration> const& localConfig, ConfigBroadcastInterface const& configBroadcastInterface, Reference<AsyncVar<ServerDBInfo>> const& dbInfo, Promise<Void> const& recoveredDiskFiles, Reference<AsyncVar<Optional<UID>>> const& clusterId ) {
															#line 591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RegistrationClientActor(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, bmInterf, blobMigratorInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId));
															#line 4590 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 751 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Returns true if `address` is used in the db (indicated by `dbInfo`) transaction system and in the db's primary DC.
bool addressInDbAndPrimaryDc(
    const NetworkAddress& address,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	const auto& dbi = dbInfo->get();

	if (dbi.master.addresses().contains(address)) {
		return true;
	}

	if (dbi.distributor.present() && dbi.distributor.get().address() == address) {
		return true;
	}

	if (dbi.ratekeeper.present() && dbi.ratekeeper.get().address() == address) {
		return true;
	}

	if (dbi.consistencyScan.present() && dbi.consistencyScan.get().address() == address) {
		return true;
	}

	if (dbi.blobManager.present() && dbi.blobManager.get().address() == address) {
		return true;
	}

	if (dbi.blobMigrator.present() && dbi.blobMigrator.get().address() == address) {
		return true;
	}

	if (dbi.client.encryptKeyProxy.present() && dbi.client.encryptKeyProxy.get().address() == address) {
		return true;
	}

	for (const auto& resolver : dbi.resolvers) {
		if (resolver.address() == address) {
			return true;
		}
	}

	for (const auto& grvProxy : dbi.client.grvProxies) {
		if (grvProxy.addresses().contains(address)) {
			return true;
		}
	}

	for (const auto& commitProxy : dbi.client.commitProxies) {
		if (commitProxy.addresses().contains(address)) {
			return true;
		}
	}

	auto localityIsInPrimaryDc = [&dbInfo](const LocalityData& locality) {
		return locality.dcId() == dbInfo->get().master.locality.dcId();
	};

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		for (const auto& tlog : logSet.tLogs) {
			if (!tlog.present()) {
				continue;
			}

			if (!localityIsInPrimaryDc(tlog.interf().filteredLocality)) {
				continue;
			}

			if (tlog.interf().addresses().contains(address)) {
				return true;
			}
		}
	}

	if (storageServers.present() &&
	    (std::find(storageServers.get().begin(), storageServers.get().end(), address) != storageServers.get().end())) {
		return true;
	}

	return false;
}

bool addressesInDbAndPrimaryDc(
    const NetworkAddressList& addresses,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	return addressInDbAndPrimaryDc(addresses.address, dbInfo, storageServers) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndPrimaryDc(addresses.secondaryAddress.get(), dbInfo, storageServers));
}

namespace {

															#line 4687 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase844()
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase844Actor>
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase844ActorState {
															#line 4693 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase844ActorState(UnitTestParameters const& params) 
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4700 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase844", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase844ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase844", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 846 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 847 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 848 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 849 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 852 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress testAddress(IPAddress(0x13131313), 1);
															#line 853 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.getCommitVersion = RequestStream<struct GetCommitVersionRequest>(Endpoint({ testAddress }, UID(1, 2)));
															#line 857 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 858 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 859 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 863 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 864 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 865 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 866 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 867 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 868 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 871 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localTlog(testLocal);
															#line 872 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localTlog.initEndpoints();
															#line 873 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(localTlog));
															#line 874 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 877 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.clear();
															#line 878 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(testAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 881 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress grvProxyAddress(IPAddress(0x26262626), 1);
															#line 882 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			GrvProxyInterface grvProxyInterf;
															#line 883 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			grvProxyInterf.getConsistentReadVersion = PublicRequestStream<struct GetReadVersionRequest>(Endpoint({ grvProxyAddress }, UID(1, 2)));
															#line 885 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.client.grvProxies.push_back(grvProxyInterf);
															#line 886 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(grvProxyAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 888 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress commitProxyAddress(IPAddress(0x37373737), 1);
															#line 889 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CommitProxyInterface commitProxyInterf;
															#line 890 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			commitProxyInterf.commit = PublicRequestStream<struct CommitTransactionRequest>(Endpoint({ commitProxyAddress }, UID(1, 2)));
															#line 892 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.client.commitProxies.push_back(commitProxyInterf);
															#line 893 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimaryDc(commitProxyAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 895 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase844Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase844ActorState(); static_cast<FlowTestCase844Actor*>(this)->destroy(); return 0; }
															#line 4777 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase844Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase844ActorState();
			static_cast<FlowTestCase844Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase844ActorState();
		static_cast<FlowTestCase844Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 4801 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase844()
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase844Actor final : public Actor<Void>, public FastAllocated<FlowTestCase844Actor>, public FlowTestCase844ActorState<FlowTestCase844Actor> {
															#line 4806 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase844Actor>::operator new;
	using FastAllocated<FlowTestCase844Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4818238056122470912UL, 8591776399688244736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase844Actor(UnitTestParameters const& params) 
															#line 4822 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase844ActorState<FlowTestCase844Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase844", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3849843000070919424UL, 9517891389823208960UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase844Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase844");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase844", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase844( UnitTestParameters const& params ) {
															#line 844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase844Actor(params));
															#line 4853 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase844, "/fdbserver/worker/addressInDbAndPrimaryDc")

#line 897 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

// Returns true if `address` is used in the db (indicated by `dbInfo`) transaction system and in the db's primary
// satellite DC.
bool addressInDbAndPrimarySatelliteDc(const NetworkAddress& address, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	for (const auto& logSet : dbInfo->get().logSystemConfig.tLogs) {
		if (logSet.isLocal && logSet.locality == tagLocalitySatellite) {
			for (const auto& tlog : logSet.tLogs) {
				if (tlog.present() && tlog.interf().addresses().contains(address)) {
					return true;
				}
			}
		}
	}

	return false;
}

bool addressesInDbAndPrimarySatelliteDc(const NetworkAddressList& addresses,
                                        Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	return addressInDbAndPrimarySatelliteDc(addresses.address, dbInfo) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndPrimarySatelliteDc(addresses.secondaryAddress.get(), dbInfo));
}

namespace {

															#line 4886 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase925()
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase925Actor>
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase925ActorState {
															#line 4892 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase925ActorState(UnitTestParameters const& params) 
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 4899 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase925", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase925ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase925", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 927 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 928 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 929 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 930 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 934 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 935 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().locality = tagLocalitySatellite;
															#line 936 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 937 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 941 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress satelliteTLogAddress(IPAddress(0x13131313), 1);
															#line 942 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface satelliteTLog(testLocal);
															#line 943 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.initEndpoints();
															#line 944 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ satelliteTLogAddress }, UID(1, 2)));
															#line 945 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(satelliteTLog));
															#line 946 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndPrimarySatelliteDc(satelliteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 949 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress primaryTLogAddress(IPAddress(0x26262626), 1);
															#line 950 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 951 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 952 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface primaryTLog(testLocal);
															#line 953 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			primaryTLog.initEndpoints();
															#line 954 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			primaryTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ primaryTLogAddress }, UID(1, 2)));
															#line 955 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(primaryTLog));
															#line 956 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(primaryTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 959 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress remoteTLogAddress(IPAddress(0x37373737), 1);
															#line 960 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 961 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 962 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTLog(fakeRemote);
															#line 963 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTLog.initEndpoints();
															#line 964 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ remoteTLogAddress }, UID(1, 2)));
															#line 966 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 967 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 968 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTLog));
															#line 969 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndPrimarySatelliteDc(remoteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 971 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase925Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase925ActorState(); static_cast<FlowTestCase925Actor*>(this)->destroy(); return 0; }
															#line 4980 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase925Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase925ActorState();
			static_cast<FlowTestCase925Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase925ActorState();
		static_cast<FlowTestCase925Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5004 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase925()
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase925Actor final : public Actor<Void>, public FastAllocated<FlowTestCase925Actor>, public FlowTestCase925ActorState<FlowTestCase925Actor> {
															#line 5009 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase925Actor>::operator new;
	using FastAllocated<FlowTestCase925Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1993562195556921600UL, 2868163884597996288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase925Actor(UnitTestParameters const& params) 
															#line 5025 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase925ActorState<FlowTestCase925Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase925", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14589486975773429248UL, 4755134495037430016UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase925Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase925");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase925", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase925( UnitTestParameters const& params ) {
															#line 925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase925Actor(params));
															#line 5056 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase925, "/fdbserver/worker/addressInDbAndPrimarySatelliteDc")

#line 973 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

bool addressInDbAndRemoteDc(const NetworkAddress& address,
                            Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                            Optional<std::vector<NetworkAddress>> storageServers) {
	const auto& dbi = dbInfo->get();

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		if (logSet.isLocal || logSet.locality == tagLocalitySatellite) {
			continue;
		}
		for (const auto& tlog : logSet.tLogs) {
			if (tlog.present() && tlog.interf().addresses().contains(address)) {
				return true;
			}
		}

		for (const auto& logRouter : logSet.logRouters) {
			if (logRouter.present() && logRouter.interf().addresses().contains(address)) {
				return true;
			}
		}
	}

	if (storageServers.present() &&
	    (std::find(storageServers.get().begin(), storageServers.get().end(), address) != storageServers.get().end())) {
		return true;
	}

	return false;
}

bool addressesInDbAndRemoteDc(
    const NetworkAddressList& addresses,
    Reference<AsyncVar<ServerDBInfo> const> dbInfo,
    Optional<std::vector<NetworkAddress>> storageServers = Optional<std::vector<NetworkAddress>>{}) {
	return addressInDbAndRemoteDc(addresses.address, dbInfo, storageServers) ||
	       (addresses.secondaryAddress.present() &&
	        addressInDbAndRemoteDc(addresses.secondaryAddress.get(), dbInfo, storageServers));
}

namespace {

															#line 5105 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase1017()
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase1017Actor>
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1017ActorState {
															#line 5111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1017ActorState(UnitTestParameters const& params) 
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 5118 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1017", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1017ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1017", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1019 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 1020 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 1021 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 1022 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 1025 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1026 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 1027 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface<TLogInterface>());
															#line 1028 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1030 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localTlog(testLocal);
															#line 1031 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localTlog.initEndpoints();
															#line 1032 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(localTlog));
															#line 1033 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1036 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 1037 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 1038 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 1039 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 1041 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1042 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 1043 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 1044 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndRemoteDc(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1047 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress logRouterAddress(IPAddress(0x26262626), 1);
															#line 1048 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteLogRouter(fakeRemote);
															#line 1049 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.initEndpoints();
															#line 1050 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ logRouterAddress }, UID(1, 2)));
															#line 1051 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(remoteLogRouter));
															#line 1052 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressInDbAndRemoteDc(logRouterAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1055 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1056 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().locality = tagLocalitySatellite;
															#line 1057 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress satelliteTLogAddress(IPAddress(0x13131313), 1);
															#line 1058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface satelliteTLog(fakeRemote);
															#line 1059 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.initEndpoints();
															#line 1060 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			satelliteTLog.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ satelliteTLogAddress }, UID(1, 2)));
															#line 1061 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(satelliteTLog));
															#line 1062 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressInDbAndRemoteDc(satelliteTLogAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1064 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase1017Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1017ActorState(); static_cast<FlowTestCase1017Actor*>(this)->destroy(); return 0; }
															#line 5201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase1017Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1017ActorState();
			static_cast<FlowTestCase1017Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1017ActorState();
		static_cast<FlowTestCase1017Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5225 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1017()
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1017Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1017Actor>, public FlowTestCase1017ActorState<FlowTestCase1017Actor> {
															#line 5230 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1017Actor>::operator new;
	using FastAllocated<FlowTestCase1017Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15925105176203088128UL, 3175889414030314752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1017Actor(UnitTestParameters const& params) 
															#line 5246 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1017ActorState<FlowTestCase1017Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1017", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3514728760888269056UL, 11591407490992457728UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1017Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1017");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1017", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase1017( UnitTestParameters const& params ) {
															#line 1017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase1017Actor(params));
															#line 5277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1017, "/fdbserver/worker/addressInDbAndRemoteDc")

#line 1066 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

bool addressIsRemoteLogRouter(const NetworkAddress& address, Reference<AsyncVar<ServerDBInfo> const> dbInfo) {
	const auto& dbi = dbInfo->get();

	for (const auto& logSet : dbi.logSystemConfig.tLogs) {
		if (!logSet.isLocal) {
			for (const auto& logRouter : logSet.logRouters) {
				if (logRouter.present() && logRouter.interf().addresses().contains(address)) {
					return true;
				}
			}
		}
	}

	return false;
}

namespace {

															#line 5303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
// This generated class is to be used only via flowTestCase1087()
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class FlowTestCase1087Actor>
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1087ActorState {
															#line 5309 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1087ActorState(UnitTestParameters const& params) 
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : params(params)
															#line 5316 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1087", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1087ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1087", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1089 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ServerDBInfo testDbInfo;
															#line 1090 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData testLocal;
															#line 1091 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testLocal.set("dcid"_sr, StringRef(std::to_string(1)));
															#line 1092 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.master.locality = testLocal;
															#line 1095 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1096 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = true;
															#line 1097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface<TLogInterface>());
															#line 1098 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface localLogRouter(testLocal);
															#line 1102 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			localLogRouter.initEndpoints();
															#line 1103 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(localLogRouter));
															#line 1104 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1107 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalityData fakeRemote;
															#line 1108 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			fakeRemote.set("dcid"_sr, StringRef(std::to_string(2)));
															#line 1109 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteTlog(fakeRemote);
															#line 1110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteTlog.initEndpoints();
															#line 1112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.push_back(TLogSet());
															#line 1113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().isLocal = false;
															#line 1114 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().tLogs.push_back(OptionalInterface(remoteTlog));
															#line 1115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!addressIsRemoteLogRouter(g_network->getLocalAddress(), makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1118 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			NetworkAddress logRouterAddress(IPAddress(0x26262626), 1);
															#line 1119 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TLogInterface remoteLogRouter(fakeRemote);
															#line 1120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.initEndpoints();
															#line 1121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			remoteLogRouter.peekMessages = RequestStream<struct TLogPeekRequest>(Endpoint({ logRouterAddress }, UID(1, 2)));
															#line 1122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			testDbInfo.logSystemConfig.tLogs.back().logRouters.push_back(OptionalInterface(remoteLogRouter));
															#line 1123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(addressIsRemoteLogRouter(logRouterAddress, makeReference<AsyncVar<ServerDBInfo>>(testDbInfo)));
															#line 1125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<FlowTestCase1087Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1087ActorState(); static_cast<FlowTestCase1087Actor*>(this)->destroy(); return 0; }
															#line 5383 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<FlowTestCase1087Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase1087ActorState();
			static_cast<FlowTestCase1087Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1087ActorState();
		static_cast<FlowTestCase1087Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UnitTestParameters params;
															#line 5407 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1087()
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class FlowTestCase1087Actor final : public Actor<Void>, public FastAllocated<FlowTestCase1087Actor>, public FlowTestCase1087ActorState<FlowTestCase1087Actor> {
															#line 5412 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1087Actor>::operator new;
	using FastAllocated<FlowTestCase1087Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17900217538138934528UL, 3047103122091899648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	FlowTestCase1087Actor(UnitTestParameters const& params) 
															#line 5428 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1087ActorState<FlowTestCase1087Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1087", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13985542094659026688UL, 7710840589945726464UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1087Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1087");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1087", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
static Future<Void> flowTestCase1087( UnitTestParameters const& params ) {
															#line 1087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new FlowTestCase1087Actor(params));
															#line 5459 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1087, "/fdbserver/worker/addressIsRemoteLogRouter")

#line 1127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

} // namespace

// Returns true if the `peer` has enough measurement samples that should be checked by the health monitor.
bool shouldCheckPeer(Reference<Peer> peer) {
	TraceEvent(SevDebug, "ShouldCheckPeer")
	    .suppressFor(0.1)
	    .detail("ConnectFailedCount", peer->connectFailedCount)
	    .detail("PingLatencyPopulationSize", peer->pingLatencies.getPopulationSize());

	if (peer->connectFailedCount != 0) {
		return true;
	}

	if (peer->pingLatencies.getPopulationSize() >= SERVER_KNOBS->PEER_LATENCY_CHECK_MIN_POPULATION) {
		// Ignore peers that don't have enough samples.
		// TODO(zhewu): Currently, FlowTransport latency monitor clears ping latency samples on a
		// regular basis, which may affect the measurement count. Currently,
		// WORKER_HEALTH_MONITOR_INTERVAL is much smaller than the ping clearance interval, so it may be
		// ok. If this ends to be a problem, we need to consider keep track of last ping latencies
		// logged.
		return true;
	}

	return false;
}

// Returns true if `address` is a degraded/disconnected peer in `lastReq` sent to CC.
bool isDegradedPeer(const UpdateWorkerHealthRequest& lastReq, const NetworkAddress& address) {
	if (std::find(lastReq.degradedPeers.begin(), lastReq.degradedPeers.end(), address) != lastReq.degradedPeers.end()) {
		return true;
	}

	if (std::find(lastReq.disconnectedPeers.begin(), lastReq.disconnectedPeers.end(), address) !=
	    lastReq.disconnectedPeers.end()) {
		return true;
	}

	return false;
}

struct PrimaryAndRemoteAddresses {
	std::vector<NetworkAddress> primary;
	std::vector<NetworkAddress> remote;
};

// Check if the current worker is a transaction worker, and is experiencing degraded or disconnected peers.
UpdateWorkerHealthRequest doPeerHealthCheck(const WorkerInterface& interf,
                                            const LocalityData& locality,
                                            Reference<AsyncVar<ServerDBInfo> const> dbInfo,
                                            const UpdateWorkerHealthRequest& lastReq,
                                            Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck,
                                            Optional<PrimaryAndRemoteAddresses> storageServers) {
	const auto& allPeers = FlowTransport::transport().getAllPeers();

	// Check remote log router connectivity only when remote TLogs are recruited and in use.
	bool checkRemoteLogRouterConnectivity = dbInfo->get().recoveryState == RecoveryState::ALL_LOGS_RECRUITED ||
	                                        dbInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED;
	UpdateWorkerHealthRequest req;

	enum WorkerLocation { None, Primary, Satellite, Remote };
	WorkerLocation workerLocation = None;
	if (addressesInDbAndPrimaryDc(interf.addresses(),
	                              dbInfo,
	                              storageServers.present() ? storageServers.get().primary
	                                                       : Optional<std::vector<NetworkAddress>>{})) {
		workerLocation = Primary;
	} else if (addressesInDbAndRemoteDc(interf.addresses(),
	                                    dbInfo,
	                                    storageServers.present() ? storageServers.get().remote
	                                                             : Optional<std::vector<NetworkAddress>>{})) {
		workerLocation = Remote;
	} else if (addressesInDbAndPrimarySatelliteDc(interf.addresses(), dbInfo)) {
		workerLocation = Satellite;
	}

	TraceEvent(SevInfo, "DoPeerHealthCheck")
	    .detail("WorkerLocation", workerLocation)
	    .detail("StorageServersPresent", storageServers.present())
	    .detail("StorageServersPrimarySize",
	            storageServers.present() ? std::to_string(storageServers.get().primary.size()) : "NA")
	    .detail("StorageServersRemoteSize",
	            storageServers.present() ? std::to_string(storageServers.get().remote.size()) : "NA");

	if (workerLocation == None && !enablePrimaryTxnSystemHealthCheck->get()) {
		// This worker doesn't need to monitor anything if it is not in transaction system or in remote satellite.
		return req;
	}

	for (const auto& [address, peer] : allPeers) {
		if (!shouldCheckPeer(peer)) {
			continue;
		}

		bool degradedPeer = false;
		bool disconnectedPeer = false;

		// If peer->lastLoggedTime == 0, we just started monitor this peer and haven't logged it once yet.
		double lastLoggedTime = peer->lastLoggedTime <= 0.0 ? peer->lastConnectTime : peer->lastLoggedTime;

		TraceEvent(SevDebug, "PeerHealthMonitor")
		    .suppressFor(5.0)
		    .detail("Peer", address)
		    .detail("PeerAddress", address)
		    .detail("Force", enablePrimaryTxnSystemHealthCheck->get())
		    .detail("Elapsed", now() - lastLoggedTime)
		    .detail("Disconnected", disconnectedPeer)
		    .detail("MinLatency", peer->pingLatencies.min())
		    .detail("MaxLatency", peer->pingLatencies.max())
		    .detail("MeanLatency", peer->pingLatencies.mean())
		    .detail("MedianLatency", peer->pingLatencies.median())
		    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE)
		    .detail("CheckedPercentileLatency",
		            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE))
		    .detail("PingCount", peer->pingLatencies.getPopulationSize())
		    .detail("PingTimeoutCount", peer->timeoutCount)
		    .detail("ConnectionFailureCount", peer->connectFailedCount)
		    .detail("WorkerLocation", workerLocation)
		    .detail("PeerInPrimaryDc", addressInDbAndPrimaryDc(address, dbInfo))
		    .detail("PeerInRemoteDc", addressInDbAndRemoteDc(address, dbInfo))
		    .detail("PeerInPrimarySatelliteDc", addressInDbAndPrimarySatelliteDc(address, dbInfo))
		    .detail("PeerIsRemoteLogRouter", addressIsRemoteLogRouter(address, dbInfo));

		if ((workerLocation == Primary && addressInDbAndPrimaryDc(address, dbInfo)) ||
		    (workerLocation == Remote && addressInDbAndRemoteDc(address, dbInfo))) {
			// Monitors intra DC latencies between servers that in the primary or remote DC's transaction
			// systems. Note that currently we are not monitor storage servers, since lagging in storage
			// servers today already can trigger server exclusion by data distributor.

			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				disconnectedPeer = true;
			} else if (peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE) >
			               SERVER_KNOBS->PEER_LATENCY_DEGRADATION_THRESHOLD ||
			           peer->timeoutCount / (double)(peer->pingLatencies.getPopulationSize()) >
			               SERVER_KNOBS->PEER_TIMEOUT_PERCENTAGE_DEGRADATION_THRESHOLD) {
				degradedPeer = true;
			}
			if (disconnectedPeer || degradedPeer) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", disconnectedPeer)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE)
				    .detail("CheckedPercentileLatency",
				            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE))
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
			}
		} else if (workerLocation == Primary && addressInDbAndPrimarySatelliteDc(address, dbInfo)) {
			// Monitors inter DC latencies between servers in primary and primary satellite DC. Note that
			// TLog workers in primary satellite DC are on the critical path of serving a commit.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				disconnectedPeer = true;
			} else if (peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE) >
			               SERVER_KNOBS->PEER_LATENCY_DEGRADATION_THRESHOLD_SATELLITE ||
			           peer->timeoutCount / (double)(peer->pingLatencies.getPopulationSize()) >
			               SERVER_KNOBS->PEER_TIMEOUT_PERCENTAGE_DEGRADATION_THRESHOLD) {
				degradedPeer = true;
			}

			if (disconnectedPeer || degradedPeer) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("Satellite", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", disconnectedPeer)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("CheckedPercentile", SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE)
				    .detail("CheckedPercentileLatency",
				            peer->pingLatencies.percentile(SERVER_KNOBS->PEER_LATENCY_DEGRADATION_PERCENTILE_SATELLITE))
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
			}
		} else if (checkRemoteLogRouterConnectivity && (workerLocation == Primary || workerLocation == Satellite) &&
		           addressIsRemoteLogRouter(address, dbInfo)) {
			// Monitor remote log router's connectivity to the primary DCs' transaction system. We ignore
			// latency based degradation between primary region and remote region due to that remote region
			// may be distant from primary region.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("WorkerLocation", workerLocation)
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("RemoteLogRouter", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", true)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
				disconnectedPeer = true;
			}
		} else if (enablePrimaryTxnSystemHealthCheck->get() &&
		           (addressInDbAndPrimaryDc(address, dbInfo) || addressInDbAndPrimarySatelliteDc(address, dbInfo))) {
			// For force checking, we only detect connection timeout. Currently this should only be used during recovery
			// and only used in TLogs.
			if (peer->connectFailedCount >= SERVER_KNOBS->PEER_DEGRADATION_CONNECTION_FAILURE_COUNT) {
				TraceEvent("HealthMonitorDetectDegradedPeer")
				    .detail("WorkerLocation", workerLocation)
				    .detail("Peer", address)
				    .detail("PeerAddress", address)
				    .detail("ExtensiveConnectivityCheck", true)
				    .detail("Elapsed", now() - lastLoggedTime)
				    .detail("Disconnected", true)
				    .detail("MinLatency", peer->pingLatencies.min())
				    .detail("MaxLatency", peer->pingLatencies.max())
				    .detail("MeanLatency", peer->pingLatencies.mean())
				    .detail("MedianLatency", peer->pingLatencies.median())
				    .detail("PingCount", peer->pingLatencies.getPopulationSize())
				    .detail("PingTimeoutCount", peer->timeoutCount)
				    .detail("ConnectionFailureCount", peer->connectFailedCount);
				disconnectedPeer = true;
			}
		}

		if (disconnectedPeer) {
			req.disconnectedPeers.push_back(address);
		} else if (degradedPeer) {
			req.degradedPeers.push_back(address);
		} else if (isDegradedPeer(lastReq, address)) {
			TraceEvent("HealthMonitorDetectRecoveredPeer").detail("Peer", address).detail("PeerAddress", address);
			req.recoveredPeers.push_back(address);
		}
	}

	if (SERVER_KNOBS->WORKER_HEALTH_REPORT_RECENT_DESTROYED_PEER) {
		// When the worker cannot connect to a remote peer, the peer maybe erased from the list returned
		// from getAllPeers(). Therefore, we also look through all the recent closed peers in the flow
		// transport's health monitor. Note that all the closed peers stored here are caused by connection
		// failure, but not normal connection close. Therefore, we report all such peers if they are also
		// part of the transaction sub system.
		// Note that we don't need to calculate recovered peer in this case since all the recently closed peers are
		// considered permanently closed peers.
		for (const auto& address : FlowTransport::transport().healthMonitor()->getRecentClosedPeers()) {
			if (allPeers.find(address) != allPeers.end()) {
				// We have checked this peer in the above for loop.
				continue;
			}

			if ((workerLocation == Primary && addressInDbAndPrimaryDc(address, dbInfo)) ||
			    (workerLocation == Remote && addressInDbAndRemoteDc(address, dbInfo)) ||
			    (workerLocation == Primary && addressInDbAndPrimarySatelliteDc(address, dbInfo)) ||
			    (checkRemoteLogRouterConnectivity && (workerLocation == Primary || workerLocation == Satellite) &&
			     addressIsRemoteLogRouter(address, dbInfo))) {
				TraceEvent("HealthMonitorDetectRecentClosedPeer")
				    .suppressFor(30)
				    .detail("Peer", address)
				    .detail("PeerAddress", address);
				req.disconnectedPeers.push_back(address);
			}
		}
	}

	if (g_network->isSimulated()) {
		// Invariant check in simulation: for any peers that shouldn't be checked, we won't include it in the
		// UpdateWorkerHealthRequest sent to CC.
		for (const auto& [address, peer] : allPeers) {
			if (!shouldCheckPeer(peer)) {
				for (const auto& disconnectedPeer : req.disconnectedPeers) {
					ASSERT(address != disconnectedPeer);
				}
				for (const auto& degradedPeer : req.degradedPeers) {
					ASSERT(address != degradedPeer);
				}
				for (const auto& recoveredPeer : req.recoveredPeers) {
					ASSERT(address != recoveredPeer);
				}
			}
		}
	}

	return req;
}

static Optional<Standalone<StringRef>> getPrimaryDCId(const ServerDBInfo& dbInfo) {
	return dbInfo.master.locality.dcId();
}

// Makes a "best effort" to return the network addresses of primary and remote storage servers.
// Both primary and secondary (if present) addresses are returned.
// This actor makes a network call, and if that call fails, an empty optional is returned in addition to a
// TraceEvent being logged. Intentionally, this actor does not implement a retry policy, but the client can
// choose to retry by waiting on this actor again.
															#line 5761 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via getStorageServers()
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class GetStorageServersActor>
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class GetStorageServersActorState {
															#line 5768 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	GetStorageServersActorState(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : db(db),
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 1426 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ret(),
															#line 1427 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   tr(db)
															#line 5781 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	~GetStorageServersActorState() 
	{
		fdb_probe_actor_destroy("getStorageServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1429 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 1430 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1431 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1432 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<std::vector<std::pair<StorageServerInterface, ProcessClass>>> __when_expr_0 = NativeAPI::getServerListAndProcessClasses(&tr);
															#line 1432 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<GetStorageServersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5805 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetStorageServersActor*>(this)->actor_wait_state = 1;
															#line 1432 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*>(static_cast<GetStorageServersActor*>(this)));
															#line 5810 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1459 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<GetStorageServersActor*>(this)->SAV<Optional<PrimaryAndRemoteAddresses>>::futures) { (void)(ret); this->~GetStorageServersActorState(); static_cast<GetStorageServersActor*>(this)->destroy(); return 0; }
															#line 5839 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<GetStorageServersActor*>(this)->SAV< Optional<PrimaryAndRemoteAddresses> >::value()) Optional<PrimaryAndRemoteAddresses>(std::move(ret)); // state_var_RVO
		this->~GetStorageServersActorState();
		static_cast<GetStorageServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1455 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 5852 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1456 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("GetStorageServersError").error(e);
															#line 5856 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
															#line 1434 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		PrimaryAndRemoteAddresses storageServers;
															#line 1435 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const auto primaryDCId = getPrimaryDCId(dbInfo->get());
															#line 1436 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& [ssi, _] : results ) {
															#line 1437 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool primarySS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() == primaryDCId.get();
															#line 1439 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool remoteSS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() != primaryDCId.get();
															#line 1441 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN && primarySS)
															#line 5882 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1442 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				storageServers.primary.push_back(ssi.address());
															#line 1443 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (ssi.secondaryAddress().present())
															#line 5888 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 1444 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.primary.push_back(ssi.secondaryAddress().get());
															#line 5892 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
			else
			{
															#line 1446 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN && remoteSS)
															#line 5899 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 1447 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.remote.push_back(ssi.address());
															#line 1448 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (ssi.secondaryAddress().present())
															#line 5905 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 1449 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						storageServers.remote.push_back(ssi.secondaryAddress().get());
															#line 5909 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
				}
			}
		}
															#line 1453 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ret = storageServers;
															#line 5916 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
															#line 1434 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		PrimaryAndRemoteAddresses storageServers;
															#line 1435 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const auto primaryDCId = getPrimaryDCId(dbInfo->get());
															#line 1436 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( auto& [ssi, _] : results ) {
															#line 1437 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool primarySS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() == primaryDCId.get();
															#line 1439 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const bool remoteSS = ssi.locality.dcId().present() && primaryDCId.present() && ssi.locality.dcId().get() != primaryDCId.get();
															#line 1441 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN && primarySS)
															#line 5935 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1442 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				storageServers.primary.push_back(ssi.address());
															#line 1443 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (ssi.secondaryAddress().present())
															#line 5941 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 1444 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.primary.push_back(ssi.secondaryAddress().get());
															#line 5945 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
			else
			{
															#line 1446 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN && remoteSS)
															#line 5952 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 1447 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					storageServers.remote.push_back(ssi.address());
															#line 1448 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (ssi.secondaryAddress().present())
															#line 5958 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 1449 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						storageServers.remote.push_back(ssi.secondaryAddress().get());
															#line 5962 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
				}
			}
		}
															#line 1453 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ret = storageServers;
															#line 5969 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont2(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<StorageServerInterface, ProcessClass>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetStorageServersActor*>(this)->actor_wait_state > 0) static_cast<GetStorageServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetStorageServersActor*>(this)->ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> const& value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,std::vector<std::pair<StorageServerInterface, ProcessClass>> && value) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*,Error err) 
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Database db;
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1426 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<PrimaryAndRemoteAddresses> ret;
															#line 1427 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Transaction tr;
															#line 6070 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via getStorageServers()
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class GetStorageServersActor final : public Actor<Optional<PrimaryAndRemoteAddresses>>, public ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >, public FastAllocated<GetStorageServersActor>, public GetStorageServersActorState<GetStorageServersActor> {
															#line 6075 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<GetStorageServersActor>::operator new;
	using FastAllocated<GetStorageServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16716978525382892288UL, 3210986365957052416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<PrimaryAndRemoteAddresses>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >;
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	GetStorageServersActor(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo) 
															#line 6092 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Optional<PrimaryAndRemoteAddresses>>(),
		   GetStorageServersActorState<GetStorageServersActor>(db, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getStorageServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(503193769027834112UL, 12559137560131112960UL);
		ActorExecutionContextHelper __helper(static_cast<GetStorageServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getStorageServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getStorageServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetStorageServersActor, 0, std::vector<std::pair<StorageServerInterface, ProcessClass>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Optional<PrimaryAndRemoteAddresses>> getStorageServers( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo ) {
															#line 1424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Optional<PrimaryAndRemoteAddresses>>(new GetStorageServersActor(db, dbInfo));
															#line 6125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1461 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// The actor that actively monitors the health of local and peer servers, and reports anomaly to the cluster controller.
															#line 6131 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via healthMonitor()
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class HealthMonitorActor>
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HealthMonitorActorState {
															#line 6138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HealthMonitorActorState(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck) 
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccInterface(ccInterface),
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(interf),
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   enablePrimaryTxnSystemHealthCheck(enablePrimaryTxnSystemHealthCheck),
															#line 1468 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   req(),
															#line 1469 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   db()
															#line 6157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("healthMonitor", reinterpret_cast<unsigned long>(this));

	}
	~HealthMonitorActorState() 
	{
		fdb_probe_actor_destroy("healthMonitor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1470 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->GRAY_FAILURE_ALLOW_PRIMARY_SS_TO_COMPLAIN || SERVER_KNOBS->GRAY_FAILURE_ALLOW_REMOTE_SS_TO_COMPLAIN)
															#line 6172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1472 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				db = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, LockAware::True);
															#line 6176 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 1474 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 6180 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMonitorActorState();
		static_cast<HealthMonitorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1475 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		nextHealthCheckDelay = Never();
															#line 1476 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const RecoveryState& recoveryState = dbInfo->get().recoveryState;
															#line 1477 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const bool primaryTxnSystemHealthCheckEnabled = enablePrimaryTxnSystemHealthCheck->get();
															#line 1478 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		const bool ccInterfacePresent = ccInterface->get().present();
															#line 1479 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent(SevInfo, "WorkerHealthMonitor") .detail("DBInfoRecoveryState", recoveryState) .detail("PrimaryTxnSystemHealthCheckEnabled", primaryTxnSystemHealthCheckEnabled) .detail("CCInterfacePresent", ccInterface->get().present());
															#line 1483 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if ((recoveryState >= RecoveryState::ACCEPTING_COMMITS || primaryTxnSystemHealthCheckEnabled) && ccInterfacePresent)
															#line 6220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1485 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			nextHealthCheckDelay = delay(SERVER_KNOBS->WORKER_HEALTH_MONITOR_INTERVAL);
															#line 1486 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			storageServers = Optional<PrimaryAndRemoteAddresses>();
															#line 1487 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (db.present())
															#line 6228 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1488 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(storageServers, getStorageServers(db.get(), dbInfo));
															#line 1488 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<HealthMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6234 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<HealthMonitorActor*>(this)->actor_wait_state = 1;
															#line 1488 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 0, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 6239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1514 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextHealthCheckDelay;
															#line 1513 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6260 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 1515 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = ccInterface->onChange();
															#line 6264 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when2(__when_expr_2.get(), loopDepth); };
															#line 1516 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = dbInfo->onChange();
															#line 6268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when3(__when_expr_3.get(), loopDepth); };
															#line 1517 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = enablePrimaryTxnSystemHealthCheck->onChange();
															#line 6272 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when4(__when_expr_4.get(), loopDepth); };
		static_cast<HealthMonitorActor*>(this)->actor_wait_state = 2;
															#line 1514 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 1, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1515 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 2, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1516 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 3, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 1517 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< HealthMonitorActor, 4, Void >*>(static_cast<HealthMonitorActor*>(this)));
															#line 6283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1490 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req = doPeerHealthCheck(interf, locality, dbInfo, req, enablePrimaryTxnSystemHealthCheck, storageServers);
															#line 1492 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!req.disconnectedPeers.empty() || !req.degradedPeers.empty() || !req.recoveredPeers.empty())
															#line 6294 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1493 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (g_network->isSimulated())
															#line 6298 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1496 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				for( const auto& recoveredPeer : req.recoveredPeers ) {
															#line 1497 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					for( const auto& disconnectedPeer : req.disconnectedPeers ) {
															#line 1498 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						ASSERT(recoveredPeer != disconnectedPeer);
															#line 6306 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
															#line 1500 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					for( const auto& degradedPeer : req.degradedPeers ) {
															#line 1501 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						ASSERT(recoveredPeer != degradedPeer);
															#line 6312 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
				}
			}
															#line 1507 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.address = FlowTransport::transport().getLocalAddress();
															#line 1508 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (ccInterface->get().present())
															#line 6320 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1509 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ccInterface->get().get().updateWorkerHealth.send(req);
															#line 6324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state > 0) static_cast<HealthMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HealthMonitorActor*>(this)->actor_wait_state > 0) static_cast<HealthMonitorActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 1, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 2, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 3, Void >::remove();
		static_cast<HealthMonitorActor*>(this)->ActorCallback< HealthMonitorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< HealthMonitorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< HealthMonitorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> ccInterface;
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerInterface interf;
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<bool>> enablePrimaryTxnSystemHealthCheck;
															#line 1468 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateWorkerHealthRequest req;
															#line 1469 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<Database> db;
															#line 1475 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> nextHealthCheckDelay;
															#line 1486 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Optional<PrimaryAndRemoteAddresses> storageServers;
															#line 6727 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via healthMonitor()
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class HealthMonitorActor final : public Actor<Void>, public ActorCallback< HealthMonitorActor, 0, Void >, public ActorCallback< HealthMonitorActor, 1, Void >, public ActorCallback< HealthMonitorActor, 2, Void >, public ActorCallback< HealthMonitorActor, 3, Void >, public ActorCallback< HealthMonitorActor, 4, Void >, public FastAllocated<HealthMonitorActor>, public HealthMonitorActorState<HealthMonitorActor> {
															#line 6732 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<HealthMonitorActor>::operator new;
	using FastAllocated<HealthMonitorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11017755779752567296UL, 3071956725218841600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HealthMonitorActor, 0, Void >;
friend struct ActorCallback< HealthMonitorActor, 1, Void >;
friend struct ActorCallback< HealthMonitorActor, 2, Void >;
friend struct ActorCallback< HealthMonitorActor, 3, Void >;
friend struct ActorCallback< HealthMonitorActor, 4, Void >;
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	HealthMonitorActor(Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,WorkerInterface const& interf,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck) 
															#line 6753 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   HealthMonitorActorState<HealthMonitorActor>(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMonitor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11146410862898602752UL, 8671132782290732288UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMonitorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMonitor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMonitor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HealthMonitorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HealthMonitorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> healthMonitor( Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface, WorkerInterface const& interf, LocalityData const& locality, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<AsyncVar<bool>> const& enablePrimaryTxnSystemHealthCheck ) {
															#line 1463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new HealthMonitorActor(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck));
															#line 6787 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1521 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS)
// A set of threads that should be profiled
std::set<std::thread::id> profiledThreads;

// Returns whether or not a given thread should be profiled
int filter_in_thread(void* arg) {
	return profiledThreads.contains(std::this_thread::get_id()) ? 1 : 0;
}
#endif

// Enables the calling thread to be profiled
void registerThreadForProfiling() {
#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS)
	// Not sure if this is actually needed, but a call to backtrace was advised here:
	// http://groups.google.com/group/google-perftools/browse_thread/thread/0dfd74532e038eb8/2686d9f24ac4365f?pli=1
	profiledThreads.insert(std::this_thread::get_id());
	const int num_levels = 100;
	void* pc[num_levels];
	backtrace(pc, num_levels);
#endif
}

// Starts or stops the CPU profiler
void updateCpuProfiler(ProfilerRequest req) {
	switch (req.type) {
	case ProfilerRequest::Type::GPROF:
#if (defined(__linux__) || defined(__FreeBSD__)) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
		switch (req.action) {
		case ProfilerRequest::Action::ENABLE: {
			const char* path = (const char*)req.outputFile.begin();
			ProfilerOptions* options = new ProfilerOptions();
			options->filter_in_thread = &filter_in_thread;
			options->filter_in_thread_arg = nullptr;
			ProfilerStartWithOptions(path, options);
			break;
		}
		case ProfilerRequest::Action::DISABLE:
			ProfilerStop();
			break;
		case ProfilerRequest::Action::RUN:
			ASSERT(false); // User should have called runProfiler.
			break;
		}
#endif
		break;
	case ProfilerRequest::Type::FLOW:
		switch (req.action) {
		case ProfilerRequest::Action::ENABLE:
			startProfiling(g_network, {}, req.outputFile);
			break;
		case ProfilerRequest::Action::DISABLE:
			stopProfiling();
			break;
		case ProfilerRequest::Action::RUN:
			ASSERT(false); // User should have called runProfiler.
			break;
		}
		break;
	default:
		ASSERT(false);
		break;
	}
}

															#line 6856 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via runCpuProfiler()
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RunCpuProfilerActor>
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunCpuProfilerActorState {
															#line 6863 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunCpuProfilerActorState(ProfilerRequest const& req) 
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req)
															#line 6870 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("runCpuProfiler", reinterpret_cast<unsigned long>(this));

	}
	~RunCpuProfilerActorState() 
	{
		fdb_probe_actor_destroy("runCpuProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1587 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.action == ProfilerRequest::Action::RUN)
															#line 6885 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1588 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				req.action = ProfilerRequest::Action::ENABLE;
															#line 1589 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateCpuProfiler(req);
															#line 1590 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(req.duration);
															#line 1590 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<RunCpuProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6895 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunCpuProfilerActor*>(this)->actor_wait_state = 1;
															#line 1590 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunCpuProfilerActor, 0, Void >*>(static_cast<RunCpuProfilerActor*>(this)));
															#line 6900 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1595 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateCpuProfiler(req);
															#line 1596 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6909 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunCpuProfilerActorState();
				static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.action = ProfilerRequest::Action::DISABLE;
															#line 1592 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		updateCpuProfiler(req);
															#line 1593 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.action = ProfilerRequest::Action::DISABLE;
															#line 1592 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		updateCpuProfiler(req);
															#line 1593 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunCpuProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunCpuProfilerActorState(); static_cast<RunCpuProfilerActor*>(this)->destroy(); return 0; }
															#line 6956 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunCpuProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunCpuProfilerActorState();
		static_cast<RunCpuProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunCpuProfilerActor*>(this)->actor_wait_state > 0) static_cast<RunCpuProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<RunCpuProfilerActor*>(this)->ActorCallback< RunCpuProfilerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunCpuProfilerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunCpuProfilerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunCpuProfilerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest req;
															#line 7041 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via runCpuProfiler()
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunCpuProfilerActor final : public Actor<Void>, public ActorCallback< RunCpuProfilerActor, 0, Void >, public FastAllocated<RunCpuProfilerActor>, public RunCpuProfilerActorState<RunCpuProfilerActor> {
															#line 7046 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RunCpuProfilerActor>::operator new;
	using FastAllocated<RunCpuProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(21117211373265152UL, 17655389122937956608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunCpuProfilerActor, 0, Void >;
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunCpuProfilerActor(ProfilerRequest const& req) 
															#line 7063 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RunCpuProfilerActorState<RunCpuProfilerActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runCpuProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9421576084395799552UL, 13013016949884672512UL);
		ActorExecutionContextHelper __helper(static_cast<RunCpuProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runCpuProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runCpuProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunCpuProfilerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> runCpuProfiler( ProfilerRequest const& req ) {
															#line 1586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RunCpuProfilerActor(req));
															#line 7096 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1599 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

void runHeapProfiler(const char* msg) {
#if defined(__linux__) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
	if (IsHeapProfilerRunning()) {
		HeapProfilerDump(msg);
	} else {
		TraceEvent("ProfilerError").detail("Message", "HeapProfiler not running");
	}
#else
	TraceEvent("ProfilerError").detail("Message", "HeapProfiler Unsupported");
#endif
}

															#line 7113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via runProfiler()
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class RunProfilerActor>
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunProfilerActorState {
															#line 7120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunProfilerActorState(ProfilerRequest const& req) 
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : req(req)
															#line 7127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("runProfiler", reinterpret_cast<unsigned long>(this));

	}
	~RunProfilerActorState() 
	{
		fdb_probe_actor_destroy("runProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1613 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.type == ProfilerRequest::Type::GPROF_HEAP)
															#line 7142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1614 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				runHeapProfiler("User triggered heap dump");
															#line 7146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
			else
			{
															#line 1616 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = runCpuProfiler(req);
															#line 1616 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<RunProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunProfilerActor*>(this)->actor_wait_state = 1;
															#line 1616 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunProfilerActor, 0, Void >*>(static_cast<RunProfilerActor*>(this)));
															#line 7160 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunProfilerActorState();
		static_cast<RunProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1619 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<RunProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunProfilerActorState(); static_cast<RunProfilerActor*>(this)->destroy(); return 0; }
															#line 7184 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<RunProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunProfilerActorState();
		static_cast<RunProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunProfilerActor*>(this)->actor_wait_state > 0) static_cast<RunProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<RunProfilerActor*>(this)->ActorCallback< RunProfilerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunProfilerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunProfilerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunProfilerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ProfilerRequest req;
															#line 7281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via runProfiler()
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class RunProfilerActor final : public Actor<Void>, public ActorCallback< RunProfilerActor, 0, Void >, public FastAllocated<RunProfilerActor>, public RunProfilerActorState<RunProfilerActor> {
															#line 7286 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<RunProfilerActor>::operator new;
	using FastAllocated<RunProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5860590086021745664UL, 8211971154751387904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunProfilerActor, 0, Void >;
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	RunProfilerActor(ProfilerRequest const& req) 
															#line 7303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   RunProfilerActorState<RunProfilerActor>(req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14649713953804097280UL, 18193392918468773120UL);
		ActorExecutionContextHelper __helper(static_cast<RunProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunProfilerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> runProfiler( ProfilerRequest const& req ) {
															#line 1612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new RunProfilerActor(req));
															#line 7336 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1621 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

bool checkHighMemory(int64_t threshold, bool* error) {
#if defined(__linux__) && defined(USE_GPERFTOOLS) && !defined(VALGRIND)
	*error = false;
	uint64_t page_size = sysconf(_SC_PAGESIZE);
	int fd = open("/proc/self/statm", O_RDONLY | O_CLOEXEC);
	if (fd < 0) {
		TraceEvent("OpenStatmFileFailure").log();
		*error = true;
		return false;
	}

	const int buf_sz = 256;
	char stat_buf[buf_sz];
	ssize_t stat_nread = read(fd, stat_buf, buf_sz);
	if (stat_nread < 0) {
		TraceEvent("ReadStatmFileFailure").log();
		*error = true;
		return false;
	}

	uint64_t vmsize, rss;
	sscanf(stat_buf, "%lu %lu", &vmsize, &rss);
	rss *= page_size;
	if (rss >= threshold) {
		return true;
	}
#else
	TraceEvent("CheckHighMemoryUnsupported").log();
	*error = true;
#endif
	return false;
}

// Runs heap profiler when RSS memory usage is high.
															#line 7375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorHighMemory()
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorHighMemoryActor>
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorHighMemoryActorState {
															#line 7382 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorHighMemoryActorState(int64_t const& threshold) 
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : threshold(threshold)
															#line 7389 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorHighMemory", reinterpret_cast<unsigned long>(this));

	}
	~MonitorHighMemoryActorState() 
	{
		fdb_probe_actor_destroy("monitorHighMemory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1657 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (threshold <= 0)
															#line 7404 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1658 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<MonitorHighMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorHighMemoryActorState(); static_cast<MonitorHighMemoryActor*>(this)->destroy(); return 0; }
															#line 7408 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<MonitorHighMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~MonitorHighMemoryActorState();
				static_cast<MonitorHighMemoryActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1660 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 7416 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorHighMemoryActorState();
		static_cast<MonitorHighMemoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1670 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<MonitorHighMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MonitorHighMemoryActorState(); static_cast<MonitorHighMemoryActor*>(this)->destroy(); return 0; }
															#line 7439 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<MonitorHighMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MonitorHighMemoryActorState();
		static_cast<MonitorHighMemoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1661 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool err = false;
															#line 1662 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool highmem = checkHighMemory(threshold, &err);
															#line 1663 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err)
															#line 7462 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1666 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (highmem)
															#line 7468 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1667 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			runHeapProfiler("Highmem heap dump");
															#line 7472 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1668 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->HEAP_PROFILER_INTERVAL);
															#line 1668 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7478 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state = 1;
															#line 1668 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorHighMemoryActor, 0, Void >*>(static_cast<MonitorHighMemoryActor*>(this)));
															#line 7483 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state > 0) static_cast<MonitorHighMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorHighMemoryActor*>(this)->ActorCallback< MonitorHighMemoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorHighMemoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t threshold;
															#line 7590 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via monitorHighMemory()
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorHighMemoryActor final : public Actor<Void>, public ActorCallback< MonitorHighMemoryActor, 0, Void >, public FastAllocated<MonitorHighMemoryActor>, public MonitorHighMemoryActorState<MonitorHighMemoryActor> {
															#line 7595 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<MonitorHighMemoryActor>::operator new;
	using FastAllocated<MonitorHighMemoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12093048793161071360UL, 17842797755144434688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorHighMemoryActor, 0, Void >;
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorHighMemoryActor(int64_t const& threshold) 
															#line 7612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorHighMemoryActorState<MonitorHighMemoryActor>(threshold),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorHighMemory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3552868021743521024UL, 13539544626851908096UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorHighMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorHighMemory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorHighMemory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorHighMemoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorHighMemory( int64_t const& threshold ) {
															#line 1656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorHighMemoryActor(threshold));
															#line 7645 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1672 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

struct StorageDiskCleaner {
	KeyValueStoreType storeType;
	LocalityData locality;
	std::string filename;
	Future<Void> future;
};

struct TrackRunningStorage {
	UID self;
	KeyValueStoreType storeType;
	LocalityData locality;
	std::string filename;
	std::set<std::pair<UID, KeyValueStoreType>>* runningStorages;
	std::unordered_map<UID, StorageDiskCleaner>* storageCleaners;

	TrackRunningStorage(UID self,
	                    KeyValueStoreType storeType,
	                    LocalityData locality,
	                    const std::string& filename,
	                    std::set<std::pair<UID, KeyValueStoreType>>* runningStorages,
	                    std::unordered_map<UID, StorageDiskCleaner>* storageCleaners)
	  : self(self), storeType(storeType), locality(locality), filename(filename), runningStorages(runningStorages),
	    storageCleaners(storageCleaners) {
		TraceEvent("StorageServerAddedToRunningStorage", self);
		runningStorages->emplace(self, storeType);
	}
	~TrackRunningStorage() {
		runningStorages->erase(std::make_pair(self, storeType));
		TraceEvent("StorageServerRemoveFromRunningStorage", self);

		// Start a disk cleaner except for tss data store
		try {
			if (basename(filename).find(testingStoragePrefix.toString()) != 0) {
				if (!storageCleaners->contains(self)) {
					StorageDiskCleaner cleaner;
					cleaner.storeType = storeType;
					cleaner.locality = locality;
					cleaner.filename = filename;
					cleaner.future = Void(); // cleaner task will start later
					storageCleaners->insert({ self, cleaner });
					TraceEvent("AddStorageCleaner", self).detail("Size", storageCleaners->size());
				}
			}
		} catch (Error& e) {
			TraceEvent("SkipStorageCleaner", self).error(e).detail("File", filename);
		}
	};
};

															#line 7699 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via storageServerRollbackRebooter()
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class StorageServerRollbackRebooterActor>
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class StorageServerRollbackRebooterActorState {
															#line 7706 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageServerRollbackRebooterActorState(std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages,std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners,Future<Void> const& prevStorageServer,KeyValueStoreType const& storeType,std::string const& filename,UID const& id,LocalityData const& locality,bool const& isTss,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& folder,ActorCollection* const& filesClosed,int64_t const& memoryLimit,IKeyValueStore* const& store,bool const& validateDataFiles,Promise<Void>* const& rebootKVStore,Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor) 
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : runningStorages(runningStorages),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storageCleaners(storageCleaners),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   prevStorageServer(prevStorageServer),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeType(storeType),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filename(filename),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   isTss(isTss),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   db(db),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filesClosed(filesClosed),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   store(store),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   validateDataFiles(validateDataFiles),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVStore(rebootKVStore),
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   encryptionMonitor(encryptionMonitor),
															#line 1738 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   _(id, storeType, locality, filename, runningStorages, storageCleaners)
															#line 7745 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	~StorageServerRollbackRebooterActorState() 
	{
		fdb_probe_actor_destroy("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1739 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 7760 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageServerRollbackRebooterActorState();
		static_cast<StorageServerRollbackRebooterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1740 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(prevStorageServer);
															#line 1740 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7792 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 1;
															#line 1740 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7797 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 1741 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 7806 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1742 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageServerRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerRollbackRebooterActorState(); static_cast<StorageServerRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 7810 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<StorageServerRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageServerRollbackRebooterActorState();
			static_cast<StorageServerRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1743 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_please_reboot_kv_store)
															#line 7820 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1745 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 7824 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 1747 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageServerRequestedReboot", id) .detail("RebootStorageEngine", e.getError().code() == error_code_please_reboot_kv_store) .log();
															#line 1751 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_please_reboot_kv_store)
															#line 7831 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1753 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed->add(rebootKVStore->getFuture());
															#line 1754 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REBOOT_KV_STORE_DELAY);
															#line 1754 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7839 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 2;
															#line 1754 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 1741 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 7858 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1742 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageServerRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageServerRollbackRebooterActorState(); static_cast<StorageServerRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 7862 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<StorageServerRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageServerRollbackRebooterActorState();
			static_cast<StorageServerRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1743 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_please_reboot_kv_store)
															#line 7872 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1745 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 7876 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 1747 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageServerRequestedReboot", id) .detail("RebootStorageEngine", e.getError().code() == error_code_please_reboot_kv_store) .log();
															#line 1751 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (e.getError().code() == error_code_please_reboot_kv_store)
															#line 7883 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1753 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed->add(rebootKVStore->getFuture());
															#line 1754 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->REBOOT_KV_STORE_DELAY);
															#line 1754 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7891 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 2;
															#line 1754 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*>(static_cast<StorageServerRollbackRebooterActor*>(this)));
															#line 7896 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> const& e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(e, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> && e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerRollbackRebooterActor*>(this)->ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1778 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 1779 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = id;
															#line 1780 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 1781 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.tssPairID = isTss ? Optional<UID>(UID()) : Optional<UID>();
															#line 1784 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 1786 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 1787 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 1788 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 1789 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getMappedKeyValues);
															#line 1790 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 1791 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 1792 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 1793 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getReadHotRanges);
															#line 1794 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 1795 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 1796 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 1797 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 1798 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 1799 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 1800 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValuesStream);
															#line 1801 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedStream);
															#line 1802 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedPop);
															#line 1803 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 1805 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<ErrorOr<Void>> storeError = errorOr(store->getError());
															#line 1806 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageServer = storageServer(store, recruited, db, folder, Promise<Void>(), Reference<IClusterConnectionRecord>(nullptr), encryptionMonitor);
															#line 1813 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageServer = handleIOErrors(prevStorageServer, storeError, id, store->onClosed());
															#line 8035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 1756 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		store = openKVStore( storeType, filename, id, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && deterministicRandom()->coinflip()) : true), db);
															#line 1769 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> nextRebootKVStorePromise;
															#line 1770 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed->add(store->onClosed() || nextRebootKVStorePromise .getFuture() );
															#line 1774 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->send(Void());
															#line 1775 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->swap(nextRebootKVStorePromise);
															#line 8052 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 1756 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		store = openKVStore( storeType, filename, id, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && deterministicRandom()->coinflip()) : true), db);
															#line 1769 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> nextRebootKVStorePromise;
															#line 1770 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed->add(store->onClosed() || nextRebootKVStorePromise .getFuture() );
															#line 1774 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->send(Void());
															#line 1775 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootKVStore->swap(nextRebootKVStorePromise);
															#line 8069 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageServerRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageServerRollbackRebooterActor*>(this)->ActorCallback< StorageServerRollbackRebooterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::set<std::pair<UID, KeyValueStoreType>>* runningStorages;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner>* storageCleaners;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> prevStorageServer;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	KeyValueStoreType storeType;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string filename;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool isTss;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ActorCollection* filesClosed;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	IKeyValueStore* store;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool validateDataFiles;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Promise<Void>* rebootKVStore;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<GetEncryptCipherKeysMonitor> encryptionMonitor;
															#line 1738 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TrackRunningStorage _;
															#line 8183 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via storageServerRollbackRebooter()
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class StorageServerRollbackRebooterActor final : public Actor<Void>, public ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >, public ActorCallback< StorageServerRollbackRebooterActor, 1, Void >, public FastAllocated<StorageServerRollbackRebooterActor>, public StorageServerRollbackRebooterActorState<StorageServerRollbackRebooterActor> {
															#line 8188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<StorageServerRollbackRebooterActor>::operator new;
	using FastAllocated<StorageServerRollbackRebooterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13582142577824325888UL, 5612857009905991424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >;
friend struct ActorCallback< StorageServerRollbackRebooterActor, 1, Void >;
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageServerRollbackRebooterActor(std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages,std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners,Future<Void> const& prevStorageServer,KeyValueStoreType const& storeType,std::string const& filename,UID const& id,LocalityData const& locality,bool const& isTss,Reference<AsyncVar<ServerDBInfo> const> const& db,std::string const& folder,ActorCollection* const& filesClosed,int64_t const& memoryLimit,IKeyValueStore* const& store,bool const& validateDataFiles,Promise<Void>* const& rebootKVStore,Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor) 
															#line 8206 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   StorageServerRollbackRebooterActorState<StorageServerRollbackRebooterActor>(runningStorages, storageCleaners, prevStorageServer, storeType, filename, id, locality, isTss, db, folder, filesClosed, memoryLimit, store, validateDataFiles, rebootKVStore, encryptionMonitor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9711723034093058560UL, 17546821082729568512UL);
		ActorExecutionContextHelper __helper(static_cast<StorageServerRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageServerRollbackRebooter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageServerRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageServerRollbackRebooterActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StorageServerRollbackRebooterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> storageServerRollbackRebooter( std::set<std::pair<UID, KeyValueStoreType>>* const& runningStorages, std::unordered_map<UID, StorageDiskCleaner>* const& storageCleaners, Future<Void> const& prevStorageServer, KeyValueStoreType const& storeType, std::string const& filename, UID const& id, LocalityData const& locality, bool const& isTss, Reference<AsyncVar<ServerDBInfo> const> const& db, std::string const& folder, ActorCollection* const& filesClosed, int64_t const& memoryLimit, IKeyValueStore* const& store, bool const& validateDataFiles, Promise<Void>* const& rebootKVStore, Reference<GetEncryptCipherKeysMonitor> const& encryptionMonitor ) {
															#line 1722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new StorageServerRollbackRebooterActor(runningStorages, storageCleaners, prevStorageServer, storeType, filename, id, locality, isTss, db, folder, filesClosed, memoryLimit, store, validateDataFiles, rebootKVStore, encryptionMonitor));
															#line 8240 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1816 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 8245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via storageCacheRollbackRebooter()
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class StorageCacheRollbackRebooterActor>
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class StorageCacheRollbackRebooterActorState {
															#line 8252 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageCacheRollbackRebooterActorState(Future<Void> const& prevStorageCache,UID const& id,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : prevStorageCache(prevStorageCache),
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   id(id),
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   db(db)
															#line 8265 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	~StorageCacheRollbackRebooterActorState() 
	{
		fdb_probe_actor_destroy("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1821 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 8280 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StorageCacheRollbackRebooterActorState();
		static_cast<StorageCacheRollbackRebooterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1822 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<ErrorOr<Void>> __when_expr_0 = errorOr(prevStorageCache);
															#line 1822 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<StorageCacheRollbackRebooterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8312 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<StorageCacheRollbackRebooterActor*>(this)->actor_wait_state = 1;
															#line 1822 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StorageCacheRollbackRebooterActor, 0, ErrorOr<Void> >*>(static_cast<StorageCacheRollbackRebooterActor*>(this)));
															#line 8317 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> const& e,int loopDepth) 
	{
															#line 1823 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 8326 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1824 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageCacheRequestedReboot1", id).log();
															#line 1825 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageCacheRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageCacheRollbackRebooterActorState(); static_cast<StorageCacheRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 8332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<StorageCacheRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageCacheRollbackRebooterActorState();
			static_cast<StorageCacheRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1826 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_worker_removed)
															#line 8342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1828 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("StorageCacheRequestedReboot2", id).detail("Code", e.getError().code());
															#line 1829 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 8348 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 1832 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageCacheRequestedReboot", id).log();
															#line 1834 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 1835 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = deterministicRandom()->randomUniqueID();
															#line 1836 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 1837 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 1839 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 1840 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 1841 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 1842 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 1843 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 1844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 1845 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 1846 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 1847 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 1848 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 1849 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 1851 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageCache = storageCacheServer(recruited, 0, db);
															#line 8385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(ErrorOr<Void> && e,int loopDepth) 
	{
															#line 1823 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!e.isError())
															#line 8394 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1824 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageCacheRequestedReboot1", id).log();
															#line 1825 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!static_cast<StorageCacheRollbackRebooterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StorageCacheRollbackRebooterActorState(); static_cast<StorageCacheRollbackRebooterActor*>(this)->destroy(); return 0; }
															#line 8400 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			new (&static_cast<StorageCacheRollbackRebooterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~StorageCacheRollbackRebooterActorState();
			static_cast<StorageCacheRollbackRebooterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1826 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.getError().code() != error_code_please_reboot && e.getError().code() != error_code_worker_removed)
															#line 8410 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1828 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("StorageCacheRequestedReboot2", id).detail("Code", e.getError().code());
															#line 1829 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e.getError(), std::max(0, loopDepth - 1));
															#line 8416 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 1832 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("StorageCacheRequestedReboot", id).log();
															#line 1834 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 1835 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = deterministicRandom()->randomUniqueID();
															#line 1836 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 1837 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 1839 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 1840 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 1841 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 1842 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 1843 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 1844 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 1845 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 1846 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 1847 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 1848 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 1849 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 1851 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		prevStorageCache = storageCacheServer(recruited, 0, db);
															#line 8453 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> const& e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(e, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Void> && e,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(e), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StorageCacheRollbackRebooterActor*>(this)->actor_wait_state > 0) static_cast<StorageCacheRollbackRebooterActor*>(this)->actor_wait_state = 0;
		static_cast<StorageCacheRollbackRebooterActor*>(this)->ActorCallback< StorageCacheRollbackRebooterActor, 0, ErrorOr<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< StorageCacheRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> const& value) 
	{
		fdb_probe_actor_enter("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageCacheRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StorageCacheRollbackRebooterActor, 0, ErrorOr<Void> >*,ErrorOr<Void> && value) 
	{
		fdb_probe_actor_enter("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StorageCacheRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StorageCacheRollbackRebooterActor, 0, ErrorOr<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StorageCacheRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> prevStorageCache;
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID id;
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	LocalityData locality;
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 8541 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via storageCacheRollbackRebooter()
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class StorageCacheRollbackRebooterActor final : public Actor<Void>, public ActorCallback< StorageCacheRollbackRebooterActor, 0, ErrorOr<Void> >, public FastAllocated<StorageCacheRollbackRebooterActor>, public StorageCacheRollbackRebooterActorState<StorageCacheRollbackRebooterActor> {
															#line 8546 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<StorageCacheRollbackRebooterActor>::operator new;
	using FastAllocated<StorageCacheRollbackRebooterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2475238339463650304UL, 2604183657418862080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StorageCacheRollbackRebooterActor, 0, ErrorOr<Void> >;
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageCacheRollbackRebooterActor(Future<Void> const& prevStorageCache,UID const& id,LocalityData const& locality,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 8563 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   StorageCacheRollbackRebooterActorState<StorageCacheRollbackRebooterActor>(prevStorageCache, id, locality, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9744194165488605440UL, 3323553480485889792UL);
		ActorExecutionContextHelper __helper(static_cast<StorageCacheRollbackRebooterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("storageCacheRollbackRebooter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("storageCacheRollbackRebooter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StorageCacheRollbackRebooterActor, 0, ErrorOr<Void> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> storageCacheRollbackRebooter( Future<Void> const& prevStorageCache, UID const& id, LocalityData const& locality, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new StorageCacheRollbackRebooterActor(prevStorageCache, id, locality, db));
															#line 8596 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1854 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// FIXME:  This will not work correctly in simulation as all workers would share the same roles map
std::set<std::pair<std::string, std::string>> g_roles;

Standalone<StringRef> roleString(std::set<std::pair<std::string, std::string>> roles, bool with_ids) {
	std::string result;
	for (auto& r : roles) {
		if (!result.empty())
			result.append(",");
		result.append(r.first);
		if (with_ids) {
			result.append(":");
			result.append(r.second);
		}
	}
	return StringRef(result);
}

void startRole(const Role& role,
               UID roleId,
               UID workerId,
               const std::map<std::string, std::string>& details,
               const std::string& origination) {
	if (role.includeInTraceRoles) {
		addTraceRole(role.abbreviation);
	}

	TraceEvent ev("Role", roleId);
	ev.detail("As", role.roleName)
	    .detail("Transition", "Begin")
	    .detail("Origination", origination)
	    .detail("OnWorker", workerId);
	for (auto it = details.begin(); it != details.end(); it++)
		ev.detail(it->first.c_str(), it->second);

	ev.trackLatest(roleId.shortString() + ".Role");

	// Update roles map, log Roles metrics
	g_roles.insert({ role.roleName, roleId.shortString() });
	StringMetricHandle("Roles"_sr) = roleString(g_roles, false);
	StringMetricHandle("RolesWithIDs"_sr) = roleString(g_roles, true);
	if (g_network->isSimulated())
		g_simulator->addRole(g_network->getLocalAddress(), role.roleName);
}

void endRole(const Role& role, UID id, std::string reason, bool ok, Error e) {
	{
		TraceEvent ev("Role", id);
		if (e.code() != invalid_error_code)
			ev.errorUnsuppressed(e);
		ev.detail("Transition", "End").detail("As", role.roleName).detail("Reason", reason);

		ev.trackLatest(id.shortString() + ".Role");
	}

	if (!ok) {
		std::string type = role.roleName + "Failed";

		TraceEvent err(SevError, type.c_str(), id);
		if (e.code() != invalid_error_code) {
			err.errorUnsuppressed(e);
		}
		err.detail("Reason", reason);
	}

	latestEventCache.clear(id.shortString());

	// Update roles map, log Roles metrics
	g_roles.erase({ role.roleName, id.shortString() });
	StringMetricHandle("Roles"_sr) = roleString(g_roles, false);
	StringMetricHandle("RolesWithIDs"_sr) = roleString(g_roles, true);
	if (g_network->isSimulated())
		g_simulator->removeRole(g_network->getLocalAddress(), role.roleName);

	if (role.includeInTraceRoles) {
		removeTraceRole(role.abbreviation);
	}
}

															#line 8679 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via traceRole()
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class TraceRoleActor>
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TraceRoleActorState {
															#line 8686 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TraceRoleActorState(Role const& role,UID const& roleId) 
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : role(role),
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   roleId(roleId)
															#line 8695 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("traceRole", reinterpret_cast<unsigned long>(this));

	}
	~TraceRoleActorState() 
	{
		fdb_probe_actor_destroy("traceRole", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1934 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 8710 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TraceRoleActorState();
		static_cast<TraceRoleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1935 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL);
															#line 1935 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<TraceRoleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8742 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TraceRoleActor*>(this)->actor_wait_state = 1;
															#line 1935 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TraceRoleActor, 0, Void >*>(static_cast<TraceRoleActor*>(this)));
															#line 8747 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1936 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Role", roleId).detail("Transition", "Refresh").detail("As", role.roleName);
															#line 8756 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1936 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Role", roleId).detail("Transition", "Refresh").detail("As", role.roleName);
															#line 8765 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TraceRoleActor*>(this)->actor_wait_state > 0) static_cast<TraceRoleActor*>(this)->actor_wait_state = 0;
		static_cast<TraceRoleActor*>(this)->ActorCallback< TraceRoleActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TraceRoleActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TraceRoleActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TraceRoleActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Role role;
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID roleId;
															#line 8849 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via traceRole()
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class TraceRoleActor final : public Actor<Void>, public ActorCallback< TraceRoleActor, 0, Void >, public FastAllocated<TraceRoleActor>, public TraceRoleActorState<TraceRoleActor> {
															#line 8854 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<TraceRoleActor>::operator new;
	using FastAllocated<TraceRoleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17131402118762139648UL, 1987612911828864256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TraceRoleActor, 0, Void >;
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	TraceRoleActor(Role const& role,UID const& roleId) 
															#line 8871 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   TraceRoleActorState<TraceRoleActor>(role, roleId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("traceRole", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14398465994869201920UL, 9614722329871585280UL);
		ActorExecutionContextHelper __helper(static_cast<TraceRoleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("traceRole");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("traceRole", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TraceRoleActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> traceRole( Role const& role, UID const& roleId ) {
															#line 1933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new TraceRoleActor(role, roleId));
															#line 8904 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1939 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 8909 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerSnapCreate()
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerSnapCreateActor>
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerSnapCreateActorState {
															#line 8916 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapCreateActorState(WorkerSnapRequest const& snapReq,std::string const& snapFolder,std::map<std::string, WorkerSnapRequest>* const& snapReqMap,std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap) 
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : snapReq(snapReq),
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapFolder(snapFolder),
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqMap(snapReqMap),
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqResultMap(snapReqResultMap),
															#line 1946 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapArg(snapReq.snapPayload),
															#line 1947 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqKey(snapReq.snapUID.toString() + snapReq.role.toString())
															#line 8933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerSnapCreate", reinterpret_cast<unsigned long>(this));

	}
	~WorkerSnapCreateActorState() 
	{
		fdb_probe_actor_destroy("workerSnapCreate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1949 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<int> __when_expr_0 = execHelper(&snapArg, snapReq.snapUID, snapFolder, snapReq.role.toString());
															#line 1949 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8951 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state = 1;
															#line 1949 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerSnapCreateActor, 0, int >*>(static_cast<WorkerSnapCreateActor*>(this)));
															#line 8956 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerSnapCreateActorState();
		static_cast<WorkerSnapCreateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1976 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<WorkerSnapCreateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WorkerSnapCreateActorState(); static_cast<WorkerSnapCreateActor*>(this)->destroy(); return 0; }
															#line 8985 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<WorkerSnapCreateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WorkerSnapCreateActorState();
		static_cast<WorkerSnapCreateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1967 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("ExecHelperError").errorUnsuppressed(e);
															#line 1968 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 9000 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1969 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap->at(snapReqKey).reply.sendError(e);
															#line 1970 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap->erase(snapReqKey);
															#line 1971 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(e);
															#line 9008 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 1973 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 9014 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int const& err,int loopDepth) 
	{
															#line 1950 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string uidStr = snapReq.snapUID.toString();
															#line 1951 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ExecTraceWorker") .detail("Uid", uidStr) .detail("Status", err) .detail("Role", snapReq.role) .detail("Value", snapFolder) .detail("ExecPayload", snapReq.snapPayload);
															#line 1957 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err != 0)
															#line 9034 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1958 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(operation_failed(), loopDepth);
															#line 9038 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1960 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReq.role.toString() == "storage")
															#line 9042 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1961 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			printStorageVersionInfo();
															#line 9046 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1963 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->at(snapReqKey).reply.send(Void());
															#line 1964 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->erase(snapReqKey);
															#line 1965 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(Void());
															#line 9054 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(int && err,int loopDepth) 
	{
															#line 1950 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string uidStr = snapReq.snapUID.toString();
															#line 1951 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ExecTraceWorker") .detail("Uid", uidStr) .detail("Status", err) .detail("Role", snapReq.role) .detail("Value", snapFolder) .detail("ExecPayload", snapReq.snapPayload);
															#line 1957 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (err != 0)
															#line 9067 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1958 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch2(operation_failed(), loopDepth);
															#line 9071 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1960 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReq.role.toString() == "storage")
															#line 9075 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 1961 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			printStorageVersionInfo();
															#line 9079 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 1963 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->at(snapReqKey).reply.send(Void());
															#line 1964 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReqMap->erase(snapReqKey);
															#line 1965 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		(*snapReqResultMap)[snapReqKey] = ErrorOr<Void>(Void());
															#line 9087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int const& err,int loopDepth) 
	{
		loopDepth = a_body1cont2(err, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && err,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(err), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state > 0) static_cast<WorkerSnapCreateActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerSnapCreateActor*>(this)->ActorCallback< WorkerSnapCreateActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerSnapCreateActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerSnapCreateActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerSnapCreateActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapRequest snapReq;
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string snapFolder;
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, WorkerSnapRequest>* snapReqMap;
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::map<std::string, ErrorOr<Void>>* snapReqResultMap;
															#line 1946 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ExecCmdValueString snapArg;
															#line 1947 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string snapReqKey;
															#line 9192 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via workerSnapCreate()
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerSnapCreateActor final : public Actor<Void>, public ActorCallback< WorkerSnapCreateActor, 0, int >, public FastAllocated<WorkerSnapCreateActor>, public WorkerSnapCreateActorState<WorkerSnapCreateActor> {
															#line 9197 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<WorkerSnapCreateActor>::operator new;
	using FastAllocated<WorkerSnapCreateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7223252839778035968UL, 8321011544943390720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WorkerSnapCreateActor, 0, int >;
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerSnapCreateActor(WorkerSnapRequest const& snapReq,std::string const& snapFolder,std::map<std::string, WorkerSnapRequest>* const& snapReqMap,std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap) 
															#line 9214 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   WorkerSnapCreateActorState<WorkerSnapCreateActor>(snapReq, snapFolder, snapReqMap, snapReqResultMap),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("workerSnapCreate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10166740224002249728UL, 13188349297975825664UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerSnapCreateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("workerSnapCreate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("workerSnapCreate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WorkerSnapCreateActor, 0, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> workerSnapCreate( WorkerSnapRequest const& snapReq, std::string const& snapFolder, std::map<std::string, WorkerSnapRequest>* const& snapReqMap, std::map<std::string, ErrorOr<Void>>* const& snapReqResultMap ) {
															#line 1940 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new WorkerSnapCreateActor(snapReq, snapFolder, snapReqMap, snapReqResultMap));
															#line 9247 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 1978 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// TODO: `issues` is right now only updated by `monitorTraceLogIssues` and thus is being `set` on every update.
// It could be changed to `insert` and `trigger` later if we want to use it as a generic way for the caller of this
// function to report issues to cluster controller.
															#line 9255 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorTraceLogIssues()
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class MonitorTraceLogIssuesActor>
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorTraceLogIssuesActorState {
															#line 9262 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorTraceLogIssuesActorState(Reference<AsyncVar<std::set<std::string>>> const& issues) 
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : issues(issues),
															#line 1983 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   pingTimeout(false)
															#line 9271 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this));

	}
	~MonitorTraceLogIssuesActorState() 
	{
		fdb_probe_actor_destroy("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1984 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 9286 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorTraceLogIssuesActorState();
		static_cast<MonitorTraceLogIssuesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1985 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->TRACE_LOG_FLUSH_FAILURE_CHECK_INTERVAL_SECONDS);
															#line 1985 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9318 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 1;
															#line 1985 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 9323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1986 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> pingAck = pingTraceLogWriterThread();
															#line 9332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 1988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingAck, SERVER_KNOBS->TRACE_LOG_PING_TIMEOUT_SECONDS);
															#line 1988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9338 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 2;
															#line 1988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 9343 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1986 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> pingAck = pingTraceLogWriterThread();
															#line 9358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 1988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = timeoutError(pingAck, SERVER_KNOBS->TRACE_LOG_PING_TIMEOUT_SECONDS);
															#line 1988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 9364 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 2;
															#line 1988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*>(static_cast<MonitorTraceLogIssuesActor*>(this)));
															#line 9369 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state > 0) static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTraceLogIssuesActor*>(this)->ActorCallback< MonitorTraceLogIssuesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 1996 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::set<std::string> _issues;
															#line 1997 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retrieveTraceLogIssues(_issues);
															#line 1998 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (pingTimeout)
															#line 9463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2000 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			_issues.insert("trace_log_writer_thread_unresponsive");
															#line 2001 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			pingTimeout = false;
															#line 9469 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2003 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		issues->set(_issues);
															#line 9473 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1990 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_timed_out)
															#line 9483 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 1991 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				pingTimeout = true;
															#line 9487 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 1993 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 9493 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state > 0) static_cast<MonitorTraceLogIssuesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorTraceLogIssuesActor*>(this)->ActorCallback< MonitorTraceLogIssuesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<std::set<std::string>>> issues;
															#line 1983 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	bool pingTimeout;
															#line 9609 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via monitorTraceLogIssues()
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class MonitorTraceLogIssuesActor final : public Actor<Void>, public ActorCallback< MonitorTraceLogIssuesActor, 0, Void >, public ActorCallback< MonitorTraceLogIssuesActor, 1, Void >, public FastAllocated<MonitorTraceLogIssuesActor>, public MonitorTraceLogIssuesActorState<MonitorTraceLogIssuesActor> {
															#line 9614 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<MonitorTraceLogIssuesActor>::operator new;
	using FastAllocated<MonitorTraceLogIssuesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2801383683989354752UL, 8980826161902169088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorTraceLogIssuesActor, 0, Void >;
friend struct ActorCallback< MonitorTraceLogIssuesActor, 1, Void >;
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	MonitorTraceLogIssuesActor(Reference<AsyncVar<std::set<std::string>>> const& issues) 
															#line 9632 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorTraceLogIssuesActorState<MonitorTraceLogIssuesActor>(issues),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17589411279920321024UL, 1269187454341278720UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorTraceLogIssuesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorTraceLogIssues");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorTraceLogIssues", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorTraceLogIssuesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MonitorTraceLogIssuesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> monitorTraceLogIssues( Reference<AsyncVar<std::set<std::string>>> const& issues ) {
															#line 1982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new MonitorTraceLogIssuesActor(issues));
															#line 9666 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2006 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

class SharedLogsKey {
	TLogVersion logVersion;
	TLogSpillType spillType;
	KeyValueStoreType storeType;

public:
	SharedLogsKey(const TLogOptions& options, KeyValueStoreType kvst)
	  : logVersion(options.version), spillType(options.spillType), storeType(kvst) {
		if (logVersion >= TLogVersion::V5)
			spillType = TLogSpillType::UNSET;
	}

	bool operator<(const SharedLogsKey& other) const {
		return std::tie(logVersion, spillType, storeType) <
		       std::tie(other.logVersion, other.spillType, other.storeType);
	}
};

struct SharedLogsValue {
	Future<Void> actor = Void();
	UID uid = UID();
	PromiseStream<InitializeTLogRequest> requests;

	SharedLogsValue() = default;
	SharedLogsValue(Future<Void> actor, UID uid, PromiseStream<InitializeTLogRequest> requests)
	  : actor(actor), uid(uid), requests(requests) {}
};

															#line 9699 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via chaosMetricsLogger()
															#line 2035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ChaosMetricsLoggerActor>
															#line 2035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ChaosMetricsLoggerActorState {
															#line 9706 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetricsLoggerActorState() 
															#line 2035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	{
															#line 9712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		fdb_probe_actor_create("chaosMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	~ChaosMetricsLoggerActorState() 
	{
		fdb_probe_actor_destroy("chaosMetricsLogger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2037 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto res = g_network->global(INetwork::enChaosMetrics);
															#line 2038 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!res)
															#line 9728 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2039 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<ChaosMetricsLoggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChaosMetricsLoggerActorState(); static_cast<ChaosMetricsLoggerActor*>(this)->destroy(); return 0; }
															#line 9732 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<ChaosMetricsLoggerActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~ChaosMetricsLoggerActorState();
				static_cast<ChaosMetricsLoggerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2041 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetrics = static_cast<ChaosMetrics*>(res);
															#line 2042 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			chaosMetrics->clear();
															#line 2044 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 9744 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChaosMetricsLoggerActorState();
		static_cast<ChaosMetricsLoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 2045 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(FLOW_KNOBS->CHAOS_LOGGING_INTERVAL);
															#line 2045 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9776 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state = 1;
															#line 2045 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChaosMetricsLoggerActor, 0, Void >*>(static_cast<ChaosMetricsLoggerActor*>(this)));
															#line 9781 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 2047 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("ChaosMetrics");
															#line 2048 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		double elapsed = now() - chaosMetrics->startTime;
															#line 2049 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Elapsed", elapsed);
															#line 2050 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->getFields(&e);
															#line 2051 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.trackLatest("ChaosMetrics");
															#line 2052 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->clear();
															#line 9800 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 2047 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("ChaosMetrics");
															#line 2048 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		double elapsed = now() - chaosMetrics->startTime;
															#line 2049 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Elapsed", elapsed);
															#line 2050 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->getFields(&e);
															#line 2051 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.trackLatest("ChaosMetrics");
															#line 2052 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		chaosMetrics->clear();
															#line 9819 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state > 0) static_cast<ChaosMetricsLoggerActor*>(this)->actor_wait_state = 0;
		static_cast<ChaosMetricsLoggerActor*>(this)->ActorCallback< ChaosMetricsLoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChaosMetricsLoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2041 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetrics* chaosMetrics;
															#line 9901 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via chaosMetricsLogger()
															#line 2035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ChaosMetricsLoggerActor final : public Actor<Void>, public ActorCallback< ChaosMetricsLoggerActor, 0, Void >, public FastAllocated<ChaosMetricsLoggerActor>, public ChaosMetricsLoggerActorState<ChaosMetricsLoggerActor> {
															#line 9906 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ChaosMetricsLoggerActor>::operator new;
	using FastAllocated<ChaosMetricsLoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4419334150808498688UL, 16687956165584723968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChaosMetricsLoggerActor, 0, Void >;
															#line 2035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ChaosMetricsLoggerActor() 
															#line 9923 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ChaosMetricsLoggerActorState<ChaosMetricsLoggerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11301253459754392576UL, 10330861438325872384UL);
		ActorExecutionContextHelper __helper(static_cast<ChaosMetricsLoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("chaosMetricsLogger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("chaosMetricsLogger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChaosMetricsLoggerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> chaosMetricsLogger(  ) {
															#line 2035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ChaosMetricsLoggerActor());
															#line 9956 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2055 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// like genericactors setWhenDoneOrError, but we need to take into account the bm epoch. We don't want to reset it if
// this manager was replaced by a later manager (with a higher epoch) on this worker
															#line 9963 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via resetBlobManagerWhenDoneOrError()
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class ResetBlobManagerWhenDoneOrErrorActor>
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ResetBlobManagerWhenDoneOrErrorActorState {
															#line 9970 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ResetBlobManagerWhenDoneOrErrorActorState(Future<Void> const& blobManagerProcess,Reference<AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>>> const& var,int64_t const& epoch) 
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : blobManagerProcess(blobManagerProcess),
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   var(var),
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   epoch(epoch)
															#line 9981 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this));

	}
	~ResetBlobManagerWhenDoneOrErrorActorState() 
	{
		fdb_probe_actor_destroy("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 2063 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = blobManagerProcess;
															#line 2063 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9999 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->actor_wait_state = 1;
															#line 2063 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResetBlobManagerWhenDoneOrErrorActor, 0, Void >*>(static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)));
															#line 10004 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResetBlobManagerWhenDoneOrErrorActorState();
		static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2068 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (var->get().present() && var->get().get().first == epoch)
															#line 10033 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2069 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			var->set(Optional<std::pair<int64_t, BlobManagerInterface>>());
															#line 10037 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2071 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetBlobManagerWhenDoneOrErrorActorState(); static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->destroy(); return 0; }
															#line 10041 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetBlobManagerWhenDoneOrErrorActorState();
		static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2065 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 10054 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2066 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 10058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->actor_wait_state > 0) static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->actor_wait_state = 0;
		static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->ActorCallback< ResetBlobManagerWhenDoneOrErrorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetBlobManagerWhenDoneOrErrorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetBlobManagerWhenDoneOrErrorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResetBlobManagerWhenDoneOrErrorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Future<Void> blobManagerProcess;
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>>> var;
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t epoch;
															#line 10176 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via resetBlobManagerWhenDoneOrError()
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class ResetBlobManagerWhenDoneOrErrorActor final : public Actor<Void>, public ActorCallback< ResetBlobManagerWhenDoneOrErrorActor, 0, Void >, public FastAllocated<ResetBlobManagerWhenDoneOrErrorActor>, public ResetBlobManagerWhenDoneOrErrorActorState<ResetBlobManagerWhenDoneOrErrorActor> {
															#line 10181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<ResetBlobManagerWhenDoneOrErrorActor>::operator new;
	using FastAllocated<ResetBlobManagerWhenDoneOrErrorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6258074141625001984UL, 1273262841343994880UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResetBlobManagerWhenDoneOrErrorActor, 0, Void >;
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ResetBlobManagerWhenDoneOrErrorActor(Future<Void> const& blobManagerProcess,Reference<AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>>> const& var,int64_t const& epoch) 
															#line 10198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   ResetBlobManagerWhenDoneOrErrorActorState<ResetBlobManagerWhenDoneOrErrorActor>(blobManagerProcess, var, epoch),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10568912203552531712UL, 81042422459053056UL);
		ActorExecutionContextHelper __helper(static_cast<ResetBlobManagerWhenDoneOrErrorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("resetBlobManagerWhenDoneOrError");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("resetBlobManagerWhenDoneOrError", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResetBlobManagerWhenDoneOrErrorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> resetBlobManagerWhenDoneOrError( Future<Void> const& blobManagerProcess, Reference<AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>>> const& var, int64_t const& epoch ) {
															#line 2058 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new ResetBlobManagerWhenDoneOrErrorActor(blobManagerProcess, var, epoch));
															#line 10231 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2073 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

static const std::string clusterIdFilename = "clusterId";

															#line 10238 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via createClusterIdFile()
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class CreateClusterIdFileActor>
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CreateClusterIdFileActorState {
															#line 10245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CreateClusterIdFileActorState(std::string const& folder,UID const& clusterId) 
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : folder(folder),
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2077 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterIdPath(joinPath(folder, clusterIdFilename))
															#line 10256 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("createClusterIdFile", reinterpret_cast<unsigned long>(this));

	}
	~CreateClusterIdFileActorState() 
	{
		fdb_probe_actor_destroy("createClusterIdFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2078 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (fileExists(clusterIdPath))
															#line 10271 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2079 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 10275 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CreateClusterIdFileActorState();
				static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2081 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 10283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2083 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<ErrorOr<Reference<IAsyncFile>>> __when_expr_0 = errorOr(IAsyncFileSystem::filesystem(g_network)->open( clusterIdPath, IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_LOCK, 0600));
															#line 2083 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10316 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 1;
															#line 2083 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 10321 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2104 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 10337 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2105 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 10341 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 2107 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!e.isInjectedFault())
															#line 10345 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2108 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				fprintf(stderr, "ERROR: error creating or opening cluster id file `%s'.\n", joinPath(folder, clusterIdFilename).c_str());
															#line 10349 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 2112 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "OpenClusterIdError").error(e);
															#line 2113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 10355 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 2087 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (clusterIdFile.isError() && clusterIdFile.getError().code() == error_code_file_not_found && !fileExists(clusterIdPath))
															#line 10369 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2089 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( clusterIdPath, IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_LOCK | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2089 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 2;
															#line 2089 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 10380 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 2101 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1loopBody1Catch1(clusterIdFile.getError(), loopDepth);
															#line 10387 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Reference<IAsyncFile>> const& __clusterIdFile,int loopDepth) 
	{
															#line 2083 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = __clusterIdFile;
															#line 10396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ErrorOr<Reference<IAsyncFile>> && __clusterIdFile,int loopDepth) 
	{
		clusterIdFile = std::move(__clusterIdFile);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,ErrorOr<Reference<IAsyncFile>> && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Reference<IAsyncFile> const& _clusterIdFile,int loopDepth) 
	{
															#line 2094 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = _clusterIdFile;
															#line 2095 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BinaryWriter wr(IncludeVersion());
															#line 2096 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		wr << clusterId;
															#line 2097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clusterIdFile.get()->write(wr.getData(), wr.getLength(), 0);
															#line 2097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10483 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 3;
															#line 2097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 2, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 10488 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Reference<IAsyncFile> && _clusterIdFile,int loopDepth) 
	{
															#line 2094 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterIdFile = _clusterIdFile;
															#line 2095 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BinaryWriter wr(IncludeVersion());
															#line 2096 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		wr << clusterId;
															#line 2097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = clusterIdFile.get()->write(wr.getData(), wr.getLength(), 0);
															#line 2097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10505 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 3;
															#line 2097 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 2, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 10510 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> const& _clusterIdFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_clusterIdFile, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> && _clusterIdFile,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_clusterIdFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 2098 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clusterIdFile.get()->sync();
															#line 2098 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10596 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 4;
															#line 2098 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 3, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 10601 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 2098 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = clusterIdFile.get()->sync();
															#line 2098 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10612 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 4;
															#line 2098 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateClusterIdFileActor, 3, Void >*>(static_cast<CreateClusterIdFileActor*>(this)));
															#line 10617 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 2099 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 10701 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 2099 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CreateClusterIdFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CreateClusterIdFileActorState(); static_cast<CreateClusterIdFileActor*>(this)->destroy(); return 0; }
															#line 10713 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CreateClusterIdFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CreateClusterIdFileActorState();
		static_cast<CreateClusterIdFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state > 0) static_cast<CreateClusterIdFileActor*>(this)->actor_wait_state = 0;
		static_cast<CreateClusterIdFileActor*>(this)->ActorCallback< CreateClusterIdFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateClusterIdFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID clusterId;
															#line 2077 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string clusterIdPath;
															#line 2083 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	ErrorOr<Reference<IAsyncFile>> clusterIdFile;
															#line 10804 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via createClusterIdFile()
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CreateClusterIdFileActor final : public Actor<Void>, public ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >, public ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< CreateClusterIdFileActor, 2, Void >, public ActorCallback< CreateClusterIdFileActor, 3, Void >, public FastAllocated<CreateClusterIdFileActor>, public CreateClusterIdFileActorState<CreateClusterIdFileActor> {
															#line 10809 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<CreateClusterIdFileActor>::operator new;
	using FastAllocated<CreateClusterIdFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12741187449536205312UL, 9757379828748056064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >;
friend struct ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< CreateClusterIdFileActor, 2, Void >;
friend struct ActorCallback< CreateClusterIdFileActor, 3, Void >;
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CreateClusterIdFileActor(std::string const& folder,UID const& clusterId) 
															#line 10829 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   CreateClusterIdFileActorState<CreateClusterIdFileActor>(folder, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createClusterIdFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2623832799678928640UL, 8068581988244134144UL);
		ActorExecutionContextHelper __helper(static_cast<CreateClusterIdFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createClusterIdFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createClusterIdFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 0, ErrorOr<Reference<IAsyncFile>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateClusterIdFileActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> createClusterIdFile( std::string const& folder, UID const& clusterId ) {
															#line 2076 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new CreateClusterIdFileActor(folder, clusterId));
															#line 10865 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2117 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Updates this processes cluster ID based off the cluster ID received in the
// ServerDBInfo. Persists the cluster ID to disk if it does not already exist.
															#line 10872 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via updateClusterId()
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class UpdateClusterIdActor>
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class UpdateClusterIdActorState {
															#line 10879 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateClusterIdActorState(UID const& ccClusterId,Reference<AsyncVar<Optional<UID>>> const& clusterId,std::string const& folder) 
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : ccClusterId(ccClusterId),
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder)
															#line 10890 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("updateClusterId", reinterpret_cast<unsigned long>(this));

	}
	~UpdateClusterIdActorState() 
	{
		fdb_probe_actor_destroy("updateClusterId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!clusterId->get().present() && ccClusterId.isValid())
															#line 10905 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = createClusterIdFile(folder, ccClusterId);
															#line 2122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<UpdateClusterIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10911 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<UpdateClusterIdActor*>(this)->actor_wait_state = 1;
															#line 2122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateClusterIdActor, 0, Void >*>(static_cast<UpdateClusterIdActor*>(this)));
															#line 10916 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateClusterIdActorState();
		static_cast<UpdateClusterIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<UpdateClusterIdActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateClusterIdActorState(); static_cast<UpdateClusterIdActor*>(this)->destroy(); return 0; }
															#line 10944 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<UpdateClusterIdActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateClusterIdActorState();
		static_cast<UpdateClusterIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 2123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterId->set(ccClusterId);
															#line 10956 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 2123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		clusterId->set(ccClusterId);
															#line 10965 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateClusterIdActor*>(this)->actor_wait_state > 0) static_cast<UpdateClusterIdActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateClusterIdActor*>(this)->ActorCallback< UpdateClusterIdActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateClusterIdActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateClusterIdActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateClusterIdActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID ccClusterId;
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<Optional<UID>>> clusterId;
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string folder;
															#line 11051 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via updateClusterId()
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class UpdateClusterIdActor final : public Actor<Void>, public ActorCallback< UpdateClusterIdActor, 0, Void >, public FastAllocated<UpdateClusterIdActor>, public UpdateClusterIdActorState<UpdateClusterIdActor> {
															#line 11056 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<UpdateClusterIdActor>::operator new;
	using FastAllocated<UpdateClusterIdActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11262064531680791040UL, 5683289167639355904UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateClusterIdActor, 0, Void >;
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UpdateClusterIdActor(UID const& ccClusterId,Reference<AsyncVar<Optional<UID>>> const& clusterId,std::string const& folder) 
															#line 11073 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateClusterIdActorState<UpdateClusterIdActor>(ccClusterId, clusterId, folder),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateClusterId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10009873598315805184UL, 15517297218935779072UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateClusterIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateClusterId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateClusterId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateClusterIdActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> updateClusterId( UID const& ccClusterId, Reference<AsyncVar<Optional<UID>>> const& clusterId, std::string const& folder ) {
															#line 2120 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new UpdateClusterIdActor(ccClusterId, clusterId, folder));
															#line 11106 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2127 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 11111 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteStorageFile()
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class DeleteStorageFileActor>
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class DeleteStorageFileActorState {
															#line 11118 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	DeleteStorageFileActorState(KeyValueStoreType const& storeType,std::string const& filename,UID const& storeID,int64_t const& memoryLimit,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : storeType(storeType),
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filename(filename),
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeID(storeID),
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 2133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   kvs(openKVStore(storeType, filename, storeID, memoryLimit, false, false, false, dbInfo, {}))
															#line 11135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteStorageFile", reinterpret_cast<unsigned long>(this));

	}
	~DeleteStorageFileActorState() 
	{
		fdb_probe_actor_destroy("deleteStorageFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2134 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = ready(kvs->init());
															#line 2134 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<DeleteStorageFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteStorageFileActor*>(this)->actor_wait_state = 1;
															#line 2134 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteStorageFileActor, 0, Void >*>(static_cast<DeleteStorageFileActor*>(this)));
															#line 11157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("KVSRemoved").detail("Reason", "WorkerRemoved");
															#line 2136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		kvs->dispose();
															#line 2137 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CODE_PROBE(true, "Removed stale disk file");
															#line 2138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RemoveStorageDisk").detail("Filename", filename).detail("StoreID", storeID);
															#line 2139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<DeleteStorageFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteStorageFileActorState(); static_cast<DeleteStorageFileActor*>(this)->destroy(); return 0; }
															#line 11188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<DeleteStorageFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("KVSRemoved").detail("Reason", "WorkerRemoved");
															#line 2136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		kvs->dispose();
															#line 2137 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CODE_PROBE(true, "Removed stale disk file");
															#line 2138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RemoveStorageDisk").detail("Filename", filename).detail("StoreID", storeID);
															#line 2139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<DeleteStorageFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteStorageFileActorState(); static_cast<DeleteStorageFileActor*>(this)->destroy(); return 0; }
															#line 11208 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<DeleteStorageFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteStorageFileActorState();
		static_cast<DeleteStorageFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteStorageFileActor*>(this)->actor_wait_state > 0) static_cast<DeleteStorageFileActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteStorageFileActor*>(this)->ActorCallback< DeleteStorageFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteStorageFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteStorageFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteStorageFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	KeyValueStoreType storeType;
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::string filename;
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID storeID;
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	IKeyValueStore* kvs;
															#line 11303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via deleteStorageFile()
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class DeleteStorageFileActor final : public Actor<Void>, public ActorCallback< DeleteStorageFileActor, 0, Void >, public FastAllocated<DeleteStorageFileActor>, public DeleteStorageFileActorState<DeleteStorageFileActor> {
															#line 11308 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<DeleteStorageFileActor>::operator new;
	using FastAllocated<DeleteStorageFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14072486441606679808UL, 15063666907394853888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteStorageFileActor, 0, Void >;
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	DeleteStorageFileActor(KeyValueStoreType const& storeType,std::string const& filename,UID const& storeID,int64_t const& memoryLimit,Reference<AsyncVar<ServerDBInfo>> const& dbInfo) 
															#line 11325 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteStorageFileActorState<DeleteStorageFileActor>(storeType, filename, storeID, memoryLimit, dbInfo),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteStorageFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7303347310383014400UL, 15168961707397160448UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteStorageFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteStorageFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteStorageFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteStorageFileActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> deleteStorageFile( KeyValueStoreType const& storeType, std::string const& filename, UID const& storeID, int64_t const& memoryLimit, Reference<AsyncVar<ServerDBInfo>> const& dbInfo ) {
															#line 2128 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new DeleteStorageFileActor(storeType, filename, storeID, memoryLimit, dbInfo));
															#line 11358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2141 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

															#line 11363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via cleanupStaleStorageDisk()
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class CleanupStaleStorageDiskActor>
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CleanupStaleStorageDiskActorState {
															#line 11370 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CleanupStaleStorageDiskActorState(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,std::unordered_map<UID, StorageDiskCleaner>* const& cleaners,UID const& storeID,StorageDiskCleaner const& cleaner,int64_t const& memoryLimit) 
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : dbInfo(dbInfo),
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cleaners(cleaners),
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storeID(storeID),
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   cleaner(cleaner),
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2147 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   retries(0)
															#line 11387 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this));

	}
	~CleanupStaleStorageDiskActorState() 
	{
		fdb_probe_actor_destroy("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 11402 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupStaleStorageDiskActorState();
		static_cast<CleanupStaleStorageDiskActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 2150 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (retries > SERVER_KNOBS->STORAGE_DISK_CLEANUP_MAX_RETRIES)
															#line 11433 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("SkipDiskCleanup").detail("Filename", cleaner.filename).detail("StoreID", storeID);
															#line 2152 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 11439 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CleanupStaleStorageDiskActorState();
				static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2155 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerLivenessCheck").detail("StoreID", storeID).detail("Retry", retries);
															#line 2156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Reference<CommitProxyInfo> commitProxies(new CommitProxyInfo(dbInfo->get().client.commitProxies));
															#line 2157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (commitProxies->size() == 0)
															#line 11451 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("SkipDiskCleanup").log();
															#line 2159 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 11457 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CleanupStaleStorageDiskActorState();
				static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 2161 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			GetStorageServerRejoinInfoRequest request(storeID, cleaner.locality.dcId());
															#line 2162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<GetStorageServerRejoinInfoReply> __when_expr_0 = basicLoadBalance(commitProxies, &CommitProxyInterface::getStorageServerRejoinInfo, request);
															#line 2162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11469 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 1;
															#line 2162 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 11474 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 2179 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(SERVER_KNOBS->STORAGE_DISK_CLEANUP_RETRY_INTERVAL);
															#line 2179 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11491 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 3;
															#line 2179 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 11496 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2168 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() == error_code_worker_removed)
															#line 11506 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2170 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (fileExists(cleaner.filename))
															#line 11510 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2171 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					StrictFuture<Void> __when_expr_1 = deleteStorageFile(cleaner.storeType, cleaner.filename, storeID, memoryLimit, dbInfo);
															#line 2171 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11516 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
					static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 2;
															#line 2171 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*>(static_cast<CleanupStaleStorageDiskActor*>(this)));
															#line 11521 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetStorageServerRejoinInfoReply const& _rep,int loopDepth) 
	{
															#line 2165 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retries++;
															#line 11546 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(GetStorageServerRejoinInfoReply && _rep,int loopDepth) 
	{
															#line 2165 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		retries++;
															#line 11555 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetStorageServerRejoinInfoReply const& _rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetStorageServerRejoinInfoReply && _rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,GetStorageServerRejoinInfoReply const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,GetStorageServerRejoinInfoReply && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 2175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		cleaners->erase(storeID);
															#line 2176 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!static_cast<CleanupStaleStorageDiskActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupStaleStorageDiskActorState(); static_cast<CleanupStaleStorageDiskActor*>(this)->destroy(); return 0; }
															#line 11660 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		new (&static_cast<CleanupStaleStorageDiskActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CleanupStaleStorageDiskActorState();
		static_cast<CleanupStaleStorageDiskActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state > 0) static_cast<CleanupStaleStorageDiskActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupStaleStorageDiskActor*>(this)->ActorCallback< CleanupStaleStorageDiskActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	Reference<AsyncVar<ServerDBInfo>> dbInfo;
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	std::unordered_map<UID, StorageDiskCleaner>* cleaners;
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	UID storeID;
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	StorageDiskCleaner cleaner;
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int64_t memoryLimit;
															#line 2147 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	int retries;
															#line 11854 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
};
// This generated class is to be used only via cleanupStaleStorageDisk()
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class CleanupStaleStorageDiskActor final : public Actor<Void>, public ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >, public ActorCallback< CleanupStaleStorageDiskActor, 1, Void >, public ActorCallback< CleanupStaleStorageDiskActor, 2, Void >, public FastAllocated<CleanupStaleStorageDiskActor>, public CleanupStaleStorageDiskActorState<CleanupStaleStorageDiskActor> {
															#line 11859 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
	using FastAllocated<CleanupStaleStorageDiskActor>::operator new;
	using FastAllocated<CleanupStaleStorageDiskActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7303204064878342912UL, 5322285979321597952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >;
friend struct ActorCallback< CleanupStaleStorageDiskActor, 1, Void >;
friend struct ActorCallback< CleanupStaleStorageDiskActor, 2, Void >;
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	CleanupStaleStorageDiskActor(Reference<AsyncVar<ServerDBInfo>> const& dbInfo,std::unordered_map<UID, StorageDiskCleaner>* const& cleaners,UID const& storeID,StorageDiskCleaner const& cleaner,int64_t const& memoryLimit) 
															#line 11878 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		 : Actor<Void>(),
		   CleanupStaleStorageDiskActorState<CleanupStaleStorageDiskActor>(dbInfo, cleaners, storeID, cleaner, memoryLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10954477009460037888UL, 11591692359139200000UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupStaleStorageDiskActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanupStaleStorageDisk");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanupStaleStorageDisk", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 0, GetStorageServerRejoinInfoReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CleanupStaleStorageDiskActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
[[nodiscard]] Future<Void> cleanupStaleStorageDisk( Reference<AsyncVar<ServerDBInfo>> const& dbInfo, std::unordered_map<UID, StorageDiskCleaner>* const& cleaners, UID const& storeID, StorageDiskCleaner const& cleaner, int64_t const& memoryLimit ) {
															#line 2142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	return Future<Void>(new CleanupStaleStorageDiskActor(dbInfo, cleaners, storeID, cleaner, memoryLimit));
															#line 11913 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
}

#line 2182 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"

// Delete storage server data files if it's not alive anymore
void cleanupStorageDisks(Reference<AsyncVar<ServerDBInfo>> dbInfo,
                         std::unordered_map<UID, StorageDiskCleaner>& storageCleaners,
                         int64_t memoryLimit) {
	for (auto& cleaner : storageCleaners) {
		if (cleaner.second.future.isReady()) {
			CODE_PROBE(true, "Cleanup stale disk stores for double recruitment");
			cleaner.second.future =
			    cleanupStaleStorageDisk(dbInfo, &storageCleaners, cleaner.first, cleaner.second, memoryLimit);
		}
	}
}

															#line 11931 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
namespace {
// This generated class is to be used only via workerServer()
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
template <class WorkerServerActor>
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
class WorkerServerActorState {
															#line 11938 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
public:
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
	WorkerServerActorState(Reference<IClusterConnectionRecord> const& connRecord,Reference<AsyncVar<Optional<ClusterControllerFullInterface>> const> const& ccInterface,LocalityData const& locality,Reference<AsyncVar<ClusterControllerPriorityInfo>> const& asyncPriorityInfo,ProcessClass const& initialClass,std::string const& folder,int64_t const& memoryLimit,std::string const& metricsConnFile,std::string const& metricsPrefix,int64_t const& memoryProfileThreshold,std::string const& _coordFolder,std::string const& whitelistBinPaths,Reference<AsyncVar<ServerDBInfo>> const& dbInfo,ConfigBroadcastInterface const& configBroadcastInterface,Reference<ConfigNode> const& configNode,Reference<LocalConfiguration> const& localConfig,Reference<AsyncVar<Optional<UID>>> const& clusterId,bool const& consistencyCheckUrgentMode) 
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		 : connRecord(connRecord),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ccInterface(ccInterface),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   locality(locality),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   asyncPriorityInfo(asyncPriorityInfo),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   initialClass(initialClass),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   folder(folder),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryLimit(memoryLimit),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsConnFile(metricsConnFile),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsPrefix(metricsPrefix),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   memoryProfileThreshold(memoryProfileThreshold),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   _coordFolder(_coordFolder),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   whitelistBinPaths(whitelistBinPaths),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   dbInfo(dbInfo),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configBroadcastInterface(configBroadcastInterface),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   configNode(configNode),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   localConfig(localConfig),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   clusterId(clusterId),
															#line 2196 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   consistencyCheckUrgentMode(consistencyCheckUrgentMode),
															#line 2214 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   errors(),
															#line 2215 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ddInterf(new AsyncVar<Optional<DataDistributorInterface>>()),
															#line 2217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rkInterf(new AsyncVar<Optional<RatekeeperInterface>>()),
															#line 2218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   bmEpochAndInterf(new AsyncVar<Optional<std::pair<int64_t, BlobManagerInterface>>>()),
															#line 2220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   blobMigratorInterf(new AsyncVar<Optional<BlobMigratorInterface>>()),
															#line 2222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastBMRecruitRequestId(),
															#line 2223 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   ekpInterf(new AsyncVar<Optional<EncryptKeyProxyInterface>>()),
															#line 2225 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   csInterf(new AsyncVar<Optional<ConsistencyScanInterface>>()),
															#line 2227 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   handleErrors(workerHandleErrors(errors.getFuture())),
															#line 2228 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   errorForwarders(false),
															#line 2229 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   loggingTrigger(Void()),
															#line 2230 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   loggingDelay(SERVER_KNOBS->WORKER_LOGGING_INTERVAL),
															#line 2232 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVSPromise(),
															#line 2233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   rebootKVSPromise2(),
															#line 2234 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   filesClosed(true),
															#line 2235 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   stopping(),
															#line 2236 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storageCache(),
															#line 2237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   metricsLogger(),
															#line 2238 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   chaosMetricsActor(),
															#line 2239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   degraded(FlowTransport::transport().getDegraded()),
															#line 2245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   sharedLogs(),
															#line 2246 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   activeSharedTLog(new AsyncVar<UID>()),
															#line 2247 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   backupWorkerCache(),
															#line 2248 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   blobWorkerFuture(Void()),
															#line 2250 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastSnapReq(),
															#line 2252 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqMap(),
															#line 2253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   snapReqResultMap(),
															#line 2254 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   lastSnapTime(-SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP),
															#line 2255 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   coordFolder(abspath(_coordFolder)),
															#line 2257 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   interf(locality),
															#line 2259 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   runningStorages(),
															#line 2264 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		   storageCleaners()
															#line 12043 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
	{
		fdb_probe_actor_create("workerServer", reinterpret_cast<unsigned long>(this));

	}
	~WorkerServerActorState() 
	{
		fdb_probe_actor_destroy("workerServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2266 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			interf.initEndpoints();
															#line 2268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			issues = Reference<AsyncVar<std::set<std::string>>>(new AsyncVar<std::set<std::string>>());
															#line 2270 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			updateClusterIdFuture = Future<Void>();
															#line 2274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			enablePrimaryTxnSystemHealthCheck = makeReference<AsyncVar<bool>>(false);
															#line 2276 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 12066 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent(SevInfo, "ChaosFeaturesEnabled");
															#line 2278 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				chaosMetricsActor = chaosMetricsLogger();
															#line 12072 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 2281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			folder = abspath(folder);
															#line 2283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (metricsPrefix.size() > 0)
															#line 12078 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2284 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (metricsConnFile.size() > 0)
															#line 12082 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
					try {
															#line 2286 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						db = Database::createDatabase(metricsConnFile, ApiVersion::LATEST_VERSION, IsInternal::True, locality);
															#line 2288 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						metricsLogger = runMetrics(db, KeyRef(metricsPrefix));
															#line 2289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						db->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 12091 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						loopDepth = a_body1cont6(loopDepth);
					}
					catch (Error& error) {
						loopDepth = a_body1Catch2(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1Catch2(unknown_error(), loopDepth);
					}
				}
				else
				{
															#line 2294 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto lockAware = metricsPrefix.size() && metricsPrefix[0] == '\xff' ? LockAware::True : LockAware::False;
															#line 2295 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto database = openDBOnServer(dbInfo, TaskPriority::DefaultEndpoint, lockAware);
															#line 2296 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					metricsLogger = runMetrics(database, KeyRef(metricsPrefix));
															#line 2297 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					database->globalConfig->trigger(samplingFrequency, samplingProfilerUpdateFrequency);
															#line 12110 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					loopDepth = a_body1cont3(loopDepth);
				}
			}
			else
			{
															#line 2300 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				metricsLogger = runMetrics();
															#line 12118 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WorkerServerActorState();
		static_cast<WorkerServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 2303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(resetAfter(degraded, SERVER_KNOBS->DEGRADED_RESET_INTERVAL, false, SERVER_KNOBS->DEGRADED_WARNING_LIMIT, SERVER_KNOBS->DEGRADED_WARNING_RESET_DELAY, "DegradedReset"));
															#line 2309 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(loadedPonger(interf.debugPing.getFuture()));
															#line 2310 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(waitFailureServer(interf.waitFailure.getFuture()));
															#line 2311 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(monitorTraceLogIssues(issues));
															#line 2312 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( testerServerCore(interf.testerInterface, connRecord, dbInfo, locality, consistencyCheckUrgentMode ? "ConsistencyCheckUrgent" : Optional<std::string>()));
															#line 2318 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(monitorHighMemory(memoryProfileThreshold));
															#line 2320 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed.add(stopping.getFuture());
															#line 2322 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		initializeSystemMonitorMachineState(SystemMonitorMachineState(folder, locality.dcId(), locality.zoneId(), locality.machineId(), locality.dataHallId(), g_network->getLocalAddress().ip, FDB_VT_VERSION));
															#line 12156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2331 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto recruited = interf;
															#line 2332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.clientInterface.reboot);
															#line 2333 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.clientInterface.profiler);
															#line 2334 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.tLog);
															#line 2335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.master);
															#line 2336 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.commitProxy);
															#line 2337 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.grvProxy);
															#line 2338 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.resolver);
															#line 2339 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.storage);
															#line 2340 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.debugPing);
															#line 2341 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.coordinationPing);
															#line 2342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2343 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.setMetricsRate);
															#line 2344 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.eventLogRequest);
															#line 2345 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.traceBatchDumpRequest);
															#line 2346 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.updateServerDBInfo);
															#line 12190 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2349 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recoveries = std::vector<Future<Void>>();
															#line 12194 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 2352 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			stores = getDiskStores(folder);
															#line 2353 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			validateDataFiles = deleteFile(joinPath(folder, validationFilename));
															#line 2354 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			index = 0;
															#line 2355 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			;
															#line 12204 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevWarnAlways, "TDMetricsBadClusterFile").error(e).detail("ConnFile", metricsConnFile);
															#line 12232 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& err,int loopDepth=0) 
	{
		try {
															#line 3509 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			for( auto f : recoveries ) {
															#line 3510 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				f.cancel();
															#line 12263 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 3511 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = err;
															#line 3512 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool ok = e.code() == error_code_please_reboot || e.code() == error_code_actor_cancelled || e.code() == error_code_please_reboot_delete || e.code() == error_code_local_config_changed || e.code() == error_code_invalid_cluster_id;
															#line 3515 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			endRole(Role::WORKER, interf.id(), "WorkerError", ok, e);
															#line 3516 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.clear(false);
															#line 3517 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			sharedLogs.clear();
															#line 3520 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			blobWorkerFuture.cancel();
															#line 3522 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 12279 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3526 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				stopping.send(Void());
															#line 3527 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_31 = filesClosed.getResult();
															#line 3527 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12287 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_31.isReady()) { if (__when_expr_31.isError()) return a_body1Catch1(__when_expr_31.getError(), loopDepth); else return a_body1cont1Catch1when1(__when_expr_31.get(), loopDepth); };
				static_cast<WorkerServerActor*>(this)->actor_wait_state = 5;
															#line 3527 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_31.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 31, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12292 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
															#line 2565 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool hasCache = false;
															#line 2567 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (initialClass.classType() == ProcessClass::StorageCacheClass)
															#line 12314 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2568 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			hasCache = true;
															#line 2569 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited;
															#line 2570 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 2571 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2573 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 2574 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::STORAGE_CACHE, recruited.id(), interf.id(), details);
															#line 2577 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 2578 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 2579 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 2580 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2581 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 2582 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 2583 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 2584 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 2585 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2586 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2587 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2588 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 2590 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto f = storageCacheServer(recruited, 0, dbInfo);
															#line 2591 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			f = storageCacheRollbackRebooter(f, recruited.id(), recruited.locality, dbInfo);
															#line 2592 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::STORAGE_CACHE, recruited.id(), f));
															#line 12358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2595 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2596 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["Locality"] = locality.toString();
															#line 2597 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["DataFolder"] = folder;
															#line 2598 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["StoresPresent"] = format("%d", stores.size());
															#line 2599 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["CachePresent"] = hasCache ? "true" : "false";
															#line 2600 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::WORKER, interf.id(), interf.id(), details);
															#line 2601 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(traceRole(Role::WORKER, interf.id()));
															#line 2614 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> recoveredDiskFiles;
															#line 2615 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> recoverDiskFiles = trigger( [=]() { TraceEvent("DiskFileRecoveriesComplete", interf.id()); recoveredDiskFiles.send(Void()); }, waitForAll(recoveries));
															#line 2621 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(recoverDiskFiles);
															#line 2623 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(registrationClient(ccInterface, interf, asyncPriorityInfo, initialClass, ddInterf, rkInterf, bmEpochAndInterf, blobMigratorInterf, ekpInterf, csInterf, degraded, connRecord, issues, configNode, localConfig, configBroadcastInterface, dbInfo, recoveredDiskFiles, clusterId));
															#line 2643 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (configNode.isValid())
															#line 12384 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2644 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(brokenPromiseToNever(localConfig->consume(configBroadcastInterface)));
															#line 12388 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2647 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (SERVER_KNOBS->ENABLE_WORKER_HEALTH_MONITOR)
															#line 12392 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2648 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( healthMonitor(ccInterface, interf, locality, dbInfo, enablePrimaryTxnSystemHealthCheck));
															#line 12396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2652 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		;
															#line 12400 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 2355 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!(index < stores.size()))
															#line 12416 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 2356 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		s = stores[index];
															#line 2358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (s.storedComponent == DiskStore::Storage)
															#line 12424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2361 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (index >= 2 && SERVER_KNOBS->WORKER_START_STORAGE_DELAY > 0.0)
															#line 12428 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2362 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->WORKER_START_STORAGE_DELAY);
															#line 2362 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12434 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1cont1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WorkerServerActor*>(this)->actor_wait_state = 1;
															#line 2362 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 0, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12439 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1loopBody1cont3(loopDepth);
			}
		}
		else
		{
															#line 2454 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (s.storedComponent == DiskStore::TLogData)
															#line 12451 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2455 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				LocalLineage _;
															#line 2456 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 2457 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::string logQueueBasename;
															#line 2458 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const std::string filename = basename(s.filename);
															#line 2459 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (StringRef(filename).startsWith(fileLogDataPrefix))
															#line 12463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2460 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					logQueueBasename = fileLogQueuePrefix.toString();
															#line 12467 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 2462 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					StringRef optionsString = StringRef(filename).removePrefix(fileVersionedLogDataPrefix).eat("-");
															#line 2463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					logQueueBasename = fileLogQueuePrefix.toString() + optionsString.toString() + "-";
															#line 12475 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
															#line 2465 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT_WE_THINK(abspath(parentDirectory(s.filename)) == folder);
															#line 2466 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				IKeyValueStore* kv = openKVStore(s.storeType, s.filename, s.storeID, memoryLimit, validateDataFiles, false, false, dbInfo, EncryptionAtRestMode());
															#line 2475 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const DiskQueueVersion dqv = s.tLogOptions.getDiskQueueVersion();
															#line 2476 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				const int64_t diskQueueWarnSize = s.tLogOptions.spillType == TLogSpillType::VALUE ? 10 * SERVER_KNOBS->TARGET_BYTES_PER_TLOG : -1;
															#line 2478 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				IDiskQueue* queue = openDiskQueue(joinPath(folder, logQueueBasename + s.storeID.toString() + "-"), tlogQueueExtension.toString(), s.storeID, dqv, diskQueueWarnSize);
															#line 2483 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(kv->onClosed());
															#line 2484 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(queue->onClosed());
															#line 2486 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::map<std::string, std::string> details;
															#line 2487 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				details["StorageEngine"] = s.storeType.toString();
															#line 2488 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				startRole(Role::SHARED_TRANSACTION_LOG, s.storeID, interf.id(), details, "Restored");
															#line 2490 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Promise<Void> oldLog;
															#line 2491 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Promise<Void> recovery;
															#line 2492 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TLogFn tLogFn = tLogFnForOptions(s.tLogOptions);
															#line 2493 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto& logData = sharedLogs[SharedLogsKey(s.tLogOptions, s.storeType)];
															#line 2494 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.push_back(SharedLogsValue());
															#line 2497 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Future<Void> tl = tLogFn(kv, queue, dbInfo, locality, logData.back().requests, s.storeID, interf.id(), true, oldLog, recovery, folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 2511 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				recoveries.push_back(recovery.getFuture());
															#line 2512 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				activeSharedTLog->set(s.storeID);
															#line 2514 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tl = handleIOErrors(tl, kv, s.storeID);
															#line 2515 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				tl = handleIOErrors(tl, queue, s.storeID);
															#line 2516 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.back().actor = oldLog.getFuture() || tl;
															#line 2517 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				logData.back().uid = s.storeID;
															#line 2518 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, s.storeID, tl));
															#line 12523 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2519 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (s.storedComponent == DiskStore::BlobWorker)
															#line 12529 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2520 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (blobWorkerFuture.isReady() && SERVER_KNOBS->BLOB_WORKER_DISK_ENABLED)
															#line 12533 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 2521 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						LocalLineage _;
															#line 2522 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::BlobWorker;
															#line 2524 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						BlobWorkerInterface recruited(locality, deterministicRandom()->randomUniqueID());
															#line 2525 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						recruited.initEndpoints();
															#line 2527 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						std::map<std::string, std::string> details;
															#line 2528 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						details["StorageEngine"] = s.storeType.toString();
															#line 2529 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						startRole(Role::BLOB_WORKER, recruited.id(), interf.id(), details, "Restored");
															#line 2531 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						DUMPTOKEN(recruited.waitFailure);
															#line 2532 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						DUMPTOKEN(recruited.blobGranuleFileRequest);
															#line 2533 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						DUMPTOKEN(recruited.assignBlobRangeRequest);
															#line 2534 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						DUMPTOKEN(recruited.revokeBlobRangeRequest);
															#line 2535 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						DUMPTOKEN(recruited.granuleAssignmentsRequest);
															#line 2536 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						DUMPTOKEN(recruited.granuleStatusStreamRequest);
															#line 2537 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						DUMPTOKEN(recruited.haltBlobWorker);
															#line 2538 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						DUMPTOKEN(recruited.minBlobVersionRequest);
															#line 2540 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						IKeyValueStore* data = openKVStore(s.storeType, s.filename, recruited.id(), memoryLimit, false, false, false, dbInfo, Optional<EncryptionAtRestMode>(), FLOW_KNOBS->BLOB_WORKER_PAGE_CACHE);
															#line 2550 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						filesClosed.add(data->onClosed());
															#line 2552 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						Promise<Void> recovery;
															#line 2553 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						Future<Void> bw = blobWorker(recruited, recovery, dbInfo, data);
															#line 2554 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						recoveries.push_back(recovery.getFuture());
															#line 2555 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						bw = handleIOErrors(bw, data, recruited.id());
															#line 2556 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						blobWorkerFuture = bw;
															#line 2557 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						errorForwarders.add(forwardError(errors, Role::BLOB_WORKER, recruited.id(), bw));
															#line 12581 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
					else
					{
															#line 2559 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						CODE_PROBE(true, "Multiple blob workers after reboot", probe::decoration::rare);
															#line 2560 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						recoveries.push_back(deleteStorageFile(s.storeType, s.filename, s.storeID, memoryLimit, dbInfo));
															#line 12589 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
				}
			}
			loopDepth = a_body1cont1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 2355 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		++index;
															#line 12615 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(int loopDepth) 
	{
															#line 2364 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2365 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 2367 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 2368 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		IKeyValueStore* kv = openKVStore( s.storeType, s.filename, s.storeID, memoryLimit, false, validateDataFiles, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( s.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && s.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, Optional<EncryptionAtRestMode>(), 0, encryptionMonitor);
															#line 2385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> kvClosed = kv->onClosed() || rebootKVSPromise.getFuture();
															#line 2388 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		filesClosed.add(kvClosed);
															#line 2391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string tssPrefix = testingStoragePrefix.toString();
															#line 2394 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		bool isTss = s.filename.find(tssPrefix) != std::string::npos;
															#line 2395 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 2397 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StorageServerInterface recruited;
															#line 2398 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.uniqueID = s.storeID;
															#line 2399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2400 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.tssPairID = isTss ? Optional<UID>(UID()) : Optional<UID>();
															#line 2404 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2406 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 2407 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["StorageEngine"] = s.storeType.toString();
															#line 2408 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["IsTSS"] = isTss ? "Yes" : "No";
															#line 2410 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(ssRole, recruited.id(), interf.id(), details, "Restored");
															#line 2412 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getValue);
															#line 2413 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKey);
															#line 2414 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValues);
															#line 2415 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getMappedKeyValues);
															#line 2416 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getShardState);
															#line 2417 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitMetrics);
															#line 2418 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.splitMetrics);
															#line 2419 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getReadHotRanges);
															#line 2420 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 2421 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageMetrics);
															#line 2422 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2423 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 2424 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 2425 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.watchValue);
															#line 2426 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyValuesStream);
															#line 2427 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedStream);
															#line 2428 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedPop);
															#line 2429 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 2431 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<ErrorOr<Void>> storeError = errorOr(kv->getError());
															#line 2432 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Promise<Void> recovery;
															#line 2433 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> f = storageServer(kv, recruited, dbInfo, folder, recovery, connRecord, encryptionMonitor);
															#line 2434 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recoveries.push_back(recovery.getFuture());
															#line 2436 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		f = handleIOErrors(f, storeError, s.storeID, kvClosed);
															#line 2437 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		f = storageServerRollbackRebooter(&runningStorages, &storageCleaners, f, s.storeType, s.filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, kv, validateDataFiles, &rebootKVSPromise, encryptionMonitor);
															#line 2453 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(forwardError(errors, ssRole, recruited.id(), f));
															#line 12708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont11loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1(int loopDepth) 
	{
															#line 2653 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<UpdateServerDBInfoRequest> __when_expr_1 = interf.updateServerDBInfo.getFuture();
															#line 2652 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 12813 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 2696 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<RebootRequest> __when_expr_2 = interf.clientInterface.reboot.getFuture();
															#line 12817 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when2(__when_expr_2.pop(), loopDepth); };
															#line 2727 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<SetFailureInjection> __when_expr_3 = interf.clientInterface.setFailureInjection.getFuture();
															#line 12821 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when3(__when_expr_3.pop(), loopDepth); };
															#line 2743 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<ProfilerRequest> __when_expr_4 = interf.clientInterface.profiler.getFuture();
															#line 12825 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 2764 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<RecruitMasterRequest> __when_expr_5 = interf.master.getFuture();
															#line 12829 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when5(__when_expr_5.pop(), loopDepth); };
															#line 2786 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeDataDistributorRequest> __when_expr_6 = interf.dataDistributor.getFuture();
															#line 12833 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when6(__when_expr_6.pop(), loopDepth); };
															#line 2812 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeRatekeeperRequest> __when_expr_7 = interf.ratekeeper.getFuture();
															#line 12837 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when7(__when_expr_7.pop(), loopDepth); };
															#line 2839 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeConsistencyScanRequest> __when_expr_8 = interf.consistencyScan.getFuture();
															#line 12841 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when8(__when_expr_8.pop(), loopDepth); };
															#line 2864 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeBlobManagerRequest> __when_expr_9 = interf.blobManager.getFuture();
															#line 12845 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when9(__when_expr_9.pop(), loopDepth); };
															#line 2907 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeBlobMigratorRequest> __when_expr_10 = interf.blobMigrator.getFuture();
															#line 12849 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when10(__when_expr_10.pop(), loopDepth); };
															#line 2950 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeBackupRequest> __when_expr_11 = interf.backup.getFuture();
															#line 12853 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when11(__when_expr_11.pop(), loopDepth); };
															#line 2972 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeEncryptKeyProxyRequest> __when_expr_12 = interf.encryptKeyProxy.getFuture();
															#line 12857 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when12(__when_expr_12.pop(), loopDepth); };
															#line 3001 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeTLogRequest> __when_expr_13 = interf.tLog.getFuture();
															#line 12861 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1Catch1(__when_expr_13.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when13(__when_expr_13.pop(), loopDepth); };
															#line 3077 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeStorageRequest> __when_expr_14 = interf.storage.getFuture();
															#line 12865 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1Catch1(__when_expr_14.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when14(__when_expr_14.pop(), loopDepth); };
															#line 3227 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeBlobWorkerRequest> __when_expr_15 = interf.blobWorker.getFuture();
															#line 12869 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont1Catch1(__when_expr_15.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when15(__when_expr_15.pop(), loopDepth); };
															#line 3273 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeCommitProxyRequest> __when_expr_16 = interf.commitProxy.getFuture();
															#line 12873 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont1Catch1(__when_expr_16.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when16(__when_expr_16.pop(), loopDepth); };
															#line 3300 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeGrvProxyRequest> __when_expr_17 = interf.grvProxy.getFuture();
															#line 12877 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when17(__when_expr_17.pop(), loopDepth); };
															#line 3322 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeResolverRequest> __when_expr_18 = interf.resolver.getFuture();
															#line 12881 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when18(__when_expr_18.pop(), loopDepth); };
															#line 3341 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<InitializeLogRouterRequest> __when_expr_19 = interf.logRouter.getFuture();
															#line 12885 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont1Catch1(__when_expr_19.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when19(__when_expr_19.pop(), loopDepth); };
															#line 3368 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<CoordinationPingMessage> __when_expr_20 = interf.coordinationPing.getFuture();
															#line 12889 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_20.isReady()) { if (__when_expr_20.isError()) return a_body1cont1Catch1(__when_expr_20.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when20(__when_expr_20.pop(), loopDepth); };
															#line 3373 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<SetMetricsLogRateRequest> __when_expr_21 = interf.setMetricsRate.getFuture();
															#line 12893 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_21.isReady()) { if (__when_expr_21.isError()) return a_body1cont1Catch1(__when_expr_21.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when21(__when_expr_21.pop(), loopDepth); };
															#line 3382 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<EventLogRequest> __when_expr_22 = interf.eventLogRequest.getFuture();
															#line 12897 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_22.isReady()) { if (__when_expr_22.isError()) return a_body1cont1Catch1(__when_expr_22.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when22(__when_expr_22.pop(), loopDepth); };
															#line 3390 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<TraceBatchDumpRequest> __when_expr_23 = interf.traceBatchDumpRequest.getFuture();
															#line 12901 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_23.isReady()) { if (__when_expr_23.isError()) return a_body1cont1Catch1(__when_expr_23.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when23(__when_expr_23.pop(), loopDepth); };
															#line 3394 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<DiskStoreRequest> __when_expr_24 = interf.diskStoreRequest.getFuture();
															#line 12905 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_24.isReady()) { if (__when_expr_24.isError()) return a_body1cont1Catch1(__when_expr_24.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when24(__when_expr_24.pop(), loopDepth); };
															#line 3448 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_25 = loggingTrigger;
															#line 12909 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_25.isReady()) { if (__when_expr_25.isError()) return a_body1cont1Catch1(__when_expr_25.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when25(__when_expr_25.get(), loopDepth); };
															#line 3452 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		FutureStream<WorkerSnapRequest> __when_expr_26 = interf.workerSnapReq.getFuture();
															#line 12913 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_26.isReady()) { if (__when_expr_26.isError()) return a_body1cont1Catch1(__when_expr_26.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when26(__when_expr_26.pop(), loopDepth); };
															#line 3504 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_27 = errorForwarders.getResult();
															#line 12917 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_27.isReady()) { if (__when_expr_27.isError()) return a_body1cont1Catch1(__when_expr_27.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when27(__when_expr_27.get(), loopDepth); };
															#line 3505 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_28 = handleErrors;
															#line 12921 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_28.isReady()) { if (__when_expr_28.isError()) return a_body1cont1Catch1(__when_expr_28.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when28(__when_expr_28.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 2;
															#line 2653 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 1, UpdateServerDBInfoRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2696 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 2, RebootRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2727 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 3, SetFailureInjection >*>(static_cast<WorkerServerActor*>(this)));
															#line 2743 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 4, ProfilerRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2764 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 5, RecruitMasterRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2786 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 6, InitializeDataDistributorRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2812 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 7, InitializeRatekeeperRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2839 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 8, InitializeConsistencyScanRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2864 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 9, InitializeBlobManagerRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2907 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 10, InitializeBlobMigratorRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2950 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 11, InitializeBackupRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 2972 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 12, InitializeEncryptKeyProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3001 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 13, InitializeTLogRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3077 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 14, InitializeStorageRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3227 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_15.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 15, InitializeBlobWorkerRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3273 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_16.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 16, InitializeCommitProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3300 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 17, InitializeGrvProxyRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3322 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_18.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 18, InitializeResolverRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3341 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 19, InitializeLogRouterRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3368 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_20.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 20, CoordinationPingMessage >*>(static_cast<WorkerServerActor*>(this)));
															#line 3373 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_21.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 21, SetMetricsLogRateRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3382 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_22.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 22, EventLogRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3390 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_23.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 23, TraceBatchDumpRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3394 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_24.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 24, DiskStoreRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3448 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_25.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 25, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 3452 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_26.addCallbackAndClear(static_cast<ActorSingleCallback< WorkerServerActor, 26, WorkerSnapRequest >*>(static_cast<WorkerServerActor*>(this)));
															#line 3504 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_27.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 27, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 3505 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_28.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 28, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 12980 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont11loopHead1(0);

		return loopDepth;
	}
	int a_body1cont11loopBody1when1(UpdateServerDBInfoRequest const& req,int loopDepth) 
	{
															#line 2654 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ServerDBInfo localInfo = BinaryReader::fromStringRef<ServerDBInfo>( req.serializedDbInfo, AssumeVersion(g_network->protocolVersion()));
															#line 2656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		localInfo.myLocality = locality;
															#line 2658 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (localInfo.infoGeneration < dbInfo->get().infoGeneration && localInfo.clusterInterface == dbInfo->get().clusterInterface)
															#line 12999 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2660 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> rep = req.broadcastInfo;
															#line 2661 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rep.push_back(interf.updateServerDBInfo.getEndpoint());
															#line 2662 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(rep);
															#line 13007 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2664 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Optional<Endpoint> notUpdated;
															#line 2665 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!ccInterface->get().present() || localInfo.clusterInterface != ccInterface->get().get())
															#line 13015 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2666 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				notUpdated = interf.updateServerDBInfo.getEndpoint();
															#line 13019 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2667 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (localInfo.infoGeneration > dbInfo->get().infoGeneration || dbInfo->get().clusterInterface != ccInterface->get().get())
															#line 13025 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2669 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("InfoGeneration", localInfo.infoGeneration) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID()) .detail("BlobManagerID", localInfo.blobManager.present() ? localInfo.blobManager.get().id() : UID()) .detail("BlobMigratorID", localInfo.blobMigrator.present() ? localInfo.blobMigrator.get().id() : UID()) .detail("EncryptKeyProxyID", localInfo.client.encryptKeyProxy.present() ? localInfo.client.encryptKeyProxy.get().id() : UID());
															#line 2685 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					dbInfo->set(localInfo);
															#line 13031 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2687 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( success(broadcastDBInfoRequest(req, SERVER_KNOBS->DBINFO_SEND_AMOUNT, notUpdated, true)));
															#line 2690 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!updateClusterIdFuture.isValid() && !clusterId->get().present() && localInfo.client.clusterId.isValid())
															#line 13038 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2692 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateClusterIdFuture = updateClusterId(localInfo.client.clusterId, clusterId, folder);
															#line 13042 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when1(UpdateServerDBInfoRequest && req,int loopDepth) 
	{
															#line 2654 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ServerDBInfo localInfo = BinaryReader::fromStringRef<ServerDBInfo>( req.serializedDbInfo, AssumeVersion(g_network->protocolVersion()));
															#line 2656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		localInfo.myLocality = locality;
															#line 2658 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (localInfo.infoGeneration < dbInfo->get().infoGeneration && localInfo.clusterInterface == dbInfo->get().clusterInterface)
															#line 13057 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2660 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::vector<Endpoint> rep = req.broadcastInfo;
															#line 2661 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rep.push_back(interf.updateServerDBInfo.getEndpoint());
															#line 2662 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(rep);
															#line 13065 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2664 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Optional<Endpoint> notUpdated;
															#line 2665 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!ccInterface->get().present() || localInfo.clusterInterface != ccInterface->get().get())
															#line 13073 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2666 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				notUpdated = interf.updateServerDBInfo.getEndpoint();
															#line 13077 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2667 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (localInfo.infoGeneration > dbInfo->get().infoGeneration || dbInfo->get().clusterInterface != ccInterface->get().get())
															#line 13083 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2669 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent("GotServerDBInfoChange") .detail("ChangeID", localInfo.id) .detail("InfoGeneration", localInfo.infoGeneration) .detail("MasterID", localInfo.master.id()) .detail("RatekeeperID", localInfo.ratekeeper.present() ? localInfo.ratekeeper.get().id() : UID()) .detail("DataDistributorID", localInfo.distributor.present() ? localInfo.distributor.get().id() : UID()) .detail("BlobManagerID", localInfo.blobManager.present() ? localInfo.blobManager.get().id() : UID()) .detail("BlobMigratorID", localInfo.blobMigrator.present() ? localInfo.blobMigrator.get().id() : UID()) .detail("EncryptKeyProxyID", localInfo.client.encryptKeyProxy.present() ? localInfo.client.encryptKeyProxy.get().id() : UID());
															#line 2685 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					dbInfo->set(localInfo);
															#line 13089 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2687 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( success(broadcastDBInfoRequest(req, SERVER_KNOBS->DBINFO_SEND_AMOUNT, notUpdated, true)));
															#line 2690 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!updateClusterIdFuture.isValid() && !clusterId->get().present() && localInfo.client.clusterId.isValid())
															#line 13096 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2692 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				updateClusterIdFuture = updateClusterId(localInfo.client.clusterId, clusterId, folder);
															#line 13100 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when2(RebootRequest const& req,int loopDepth) 
	{
															#line 2697 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootReq = req;
															#line 2700 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RebootRequestSuspendingProcess").detail("Duration", req.waitForDuration);
															#line 2701 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.waitForDuration)
															#line 13115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2702 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushTraceFileVoid();
															#line 2703 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			setProfilingEnabled(0);
															#line 2704 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			g_network->stop();
															#line 2705 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			threadSleep(req.waitForDuration);
															#line 13125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2707 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rebootReq.checkData)
															#line 13129 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_29 = IAsyncFileSystem::filesystem()->open(joinPath(folder, validationFilename), IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1cont1Catch1(__when_expr_29.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when2when1(__when_expr_29.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 3;
															#line 2708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 29, Reference<IAsyncFile> >*>(static_cast<WorkerServerActor*>(this)));
															#line 13140 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1when2(RebootRequest && req,int loopDepth) 
	{
															#line 2697 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		rebootReq = req;
															#line 2700 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("RebootRequestSuspendingProcess").detail("Duration", req.waitForDuration);
															#line 2701 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.waitForDuration)
															#line 13158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2702 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushTraceFileVoid();
															#line 2703 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			setProfilingEnabled(0);
															#line 2704 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			g_network->stop();
															#line 2705 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			threadSleep(req.waitForDuration);
															#line 13168 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2707 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rebootReq.checkData)
															#line 13172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_29 = IAsyncFileSystem::filesystem()->open(joinPath(folder, validationFilename), IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE, 0600);
															#line 2708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			if (__when_expr_29.isReady()) { if (__when_expr_29.isError()) return a_body1cont1Catch1(__when_expr_29.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when2when1(__when_expr_29.get(), loopDepth); };
			static_cast<WorkerServerActor*>(this)->actor_wait_state = 3;
															#line 2708 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			__when_expr_29.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 29, Reference<IAsyncFile> >*>(static_cast<WorkerServerActor*>(this)));
															#line 13183 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11loopBody1when2cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1when3(SetFailureInjection const& req,int loopDepth) 
	{
															#line 2728 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 13197 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2729 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.diskFailure.present())
															#line 13201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2730 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto diskFailureInjector = DiskFailureInjector::injector();
															#line 2731 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				diskFailureInjector->setDiskFailure(req.diskFailure.get().stallInterval, req.diskFailure.get().stallPeriod, req.diskFailure.get().throttlePeriod);
															#line 13207 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2734 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (req.flipBits.present())
															#line 13213 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2735 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto bitFlipper = BitFlipper::flipper();
															#line 2736 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					bitFlipper->setBitFlipPercentage(req.flipBits.get().percentBitFlips);
															#line 13219 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2738 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(Void());
															#line 13224 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2740 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(client_invalid_operation());
															#line 13230 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when3(SetFailureInjection && req,int loopDepth) 
	{
															#line 2728 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (FLOW_KNOBS->ENABLE_CHAOS_FEATURES)
															#line 13240 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2729 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (req.diskFailure.present())
															#line 13244 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2730 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto diskFailureInjector = DiskFailureInjector::injector();
															#line 2731 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				diskFailureInjector->setDiskFailure(req.diskFailure.get().stallInterval, req.diskFailure.get().stallPeriod, req.diskFailure.get().throttlePeriod);
															#line 13250 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2734 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (req.flipBits.present())
															#line 13256 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 2735 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto bitFlipper = BitFlipper::flipper();
															#line 2736 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					bitFlipper->setBitFlipPercentage(req.flipBits.get().percentBitFlips);
															#line 13262 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 2738 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.send(Void());
															#line 13267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2740 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(client_invalid_operation());
															#line 13273 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when4(ProfilerRequest const& req,int loopDepth) 
	{
															#line 2744 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		profilerReq = req;
															#line 13283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 2750 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realLogDir = abspath(SERVER_KNOBS->LOG_DIRECTORY);
															#line 2751 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realOutPath = abspath(realLogDir + "/" + profilerReq.outputFile.toString());
															#line 2752 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (realLogDir.size() < realOutPath.size() && strncmp(realLogDir.c_str(), realOutPath.c_str(), realLogDir.size()) == 0)
															#line 13291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2754 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.outputFile = realOutPath;
															#line 2755 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				uncancellable(runProfiler(profilerReq));
															#line 2756 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.send(Void());
															#line 13299 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2758 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.sendError(client_invalid_operation());
															#line 13305 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont11loopBody1when4cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1when4(ProfilerRequest && req,int loopDepth) 
	{
															#line 2744 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		profilerReq = req;
															#line 13321 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		try {
															#line 2750 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realLogDir = abspath(SERVER_KNOBS->LOG_DIRECTORY);
															#line 2751 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string realOutPath = abspath(realLogDir + "/" + profilerReq.outputFile.toString());
															#line 2752 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (realLogDir.size() < realOutPath.size() && strncmp(realLogDir.c_str(), realOutPath.c_str(), realLogDir.size()) == 0)
															#line 13329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2754 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.outputFile = realOutPath;
															#line 2755 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				uncancellable(runProfiler(profilerReq));
															#line 2756 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.send(Void());
															#line 13337 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2758 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				profilerReq.reply.sendError(client_invalid_operation());
															#line 13343 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			loopDepth = a_body1cont11loopBody1when4cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont11loopBody1when4Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont11loopBody1when4Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1when5(RecruitMasterRequest const& req,int loopDepth) 
	{
															#line 2765 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2766 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Master;
															#line 2767 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		MasterInterface recruited;
															#line 2768 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2769 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2771 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::MASTER, recruited.id(), interf.id());
															#line 2773 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2774 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getCommitVersion);
															#line 2775 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getLiveCommittedVersion);
															#line 2776 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.reportLiveCommittedVersion);
															#line 2777 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.updateRecoveryData);
															#line 2780 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> masterProcess = masterServer( recruited, dbInfo, ccInterface, ServerCoordinators(connRecord), req.lifetime, req.forceRecovery);
															#line 2782 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::MASTER, recruited.id(), masterProcess)));
															#line 2784 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when5(RecruitMasterRequest && req,int loopDepth) 
	{
															#line 2765 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2766 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Master;
															#line 2767 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		MasterInterface recruited;
															#line 2768 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 2769 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2771 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::MASTER, recruited.id(), interf.id());
															#line 2773 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 2774 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getCommitVersion);
															#line 2775 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getLiveCommittedVersion);
															#line 2776 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.reportLiveCommittedVersion);
															#line 2777 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.updateRecoveryData);
															#line 2780 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Future<Void> masterProcess = masterServer( recruited, dbInfo, ccInterface, ServerCoordinators(connRecord), req.lifetime, req.forceRecovery);
															#line 2782 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::MASTER, recruited.id(), masterProcess)));
															#line 2784 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13420 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when6(InitializeDataDistributorRequest const& req,int loopDepth) 
	{
															#line 2787 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2788 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::DataDistributor;
															#line 2789 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DataDistributorInterface recruited(locality, req.reqId);
															#line 2790 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2792 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ddInterf->get().present())
															#line 13437 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2793 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ddInterf->get().get();
															#line 2794 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a data distributor.");
															#line 13443 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2796 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::DATA_DISTRIBUTOR, recruited.id(), interf.id());
															#line 2797 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2799 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> dataDistributorProcess = dataDistributor(recruited, dbInfo, folder);
															#line 2800 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::DATA_DISTRIBUTOR, recruited.id(), setWhenDoneOrError(dataDistributorProcess, ddInterf, Optional<DataDistributorInterface>())));
															#line 2805 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ddInterf->set(Optional<DataDistributorInterface>(recruited));
															#line 13457 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2807 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("DataDistributorReceived", req.reqId) .detail("DataDistributorId", recruited.id()) .detail("Folder", folder);
															#line 2810 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when6(InitializeDataDistributorRequest && req,int loopDepth) 
	{
															#line 2787 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2788 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::DataDistributor;
															#line 2789 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DataDistributorInterface recruited(locality, req.reqId);
															#line 2790 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2792 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ddInterf->get().present())
															#line 13480 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2793 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ddInterf->get().get();
															#line 2794 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a data distributor.");
															#line 13486 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2796 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::DATA_DISTRIBUTOR, recruited.id(), interf.id());
															#line 2797 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2799 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> dataDistributorProcess = dataDistributor(recruited, dbInfo, folder);
															#line 2800 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::DATA_DISTRIBUTOR, recruited.id(), setWhenDoneOrError(dataDistributorProcess, ddInterf, Optional<DataDistributorInterface>())));
															#line 2805 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ddInterf->set(Optional<DataDistributorInterface>(recruited));
															#line 13500 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2807 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("DataDistributorReceived", req.reqId) .detail("DataDistributorId", recruited.id()) .detail("Folder", folder);
															#line 2810 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13506 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when7(InitializeRatekeeperRequest const& req,int loopDepth) 
	{
															#line 2813 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2814 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Ratekeeper;
															#line 2815 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RatekeeperInterface recruited(locality, req.reqId);
															#line 2816 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2818 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rkInterf->get().present())
															#line 13523 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2819 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = rkInterf->get().get();
															#line 2820 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a ratekeeper.");
															#line 13529 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2822 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::RATEKEEPER, recruited.id(), interf.id());
															#line 2823 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2824 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRateInfo);
															#line 2825 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltRatekeeper);
															#line 2826 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.reportCommitCostEstimation);
															#line 2828 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> ratekeeperProcess = ratekeeper(recruited, dbInfo);
															#line 2829 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( forwardError(errors, Role::RATEKEEPER, recruited.id(), setWhenDoneOrError(ratekeeperProcess, rkInterf, Optional<RatekeeperInterface>())));
															#line 2834 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rkInterf->set(Optional<RatekeeperInterface>(recruited));
															#line 13549 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2836 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Ratekeeper_InitRequest", req.reqId).detail("RatekeeperId", recruited.id());
															#line 2837 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13555 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when7(InitializeRatekeeperRequest && req,int loopDepth) 
	{
															#line 2813 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2814 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Ratekeeper;
															#line 2815 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		RatekeeperInterface recruited(locality, req.reqId);
															#line 2816 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2818 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (rkInterf->get().present())
															#line 13572 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2819 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = rkInterf->get().get();
															#line 2820 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a ratekeeper.");
															#line 13578 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2822 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::RATEKEEPER, recruited.id(), interf.id());
															#line 2823 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2824 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRateInfo);
															#line 2825 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltRatekeeper);
															#line 2826 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.reportCommitCostEstimation);
															#line 2828 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> ratekeeperProcess = ratekeeper(recruited, dbInfo);
															#line 2829 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add( forwardError(errors, Role::RATEKEEPER, recruited.id(), setWhenDoneOrError(ratekeeperProcess, rkInterf, Optional<RatekeeperInterface>())));
															#line 2834 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			rkInterf->set(Optional<RatekeeperInterface>(recruited));
															#line 13598 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2836 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("Ratekeeper_InitRequest", req.reqId).detail("RatekeeperId", recruited.id());
															#line 2837 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13604 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when8(InitializeConsistencyScanRequest const& req,int loopDepth) 
	{
															#line 2840 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2841 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::ConsistencyScan;
															#line 2842 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ConsistencyScanInterface recruited(locality, req.reqId);
															#line 2843 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2845 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (csInterf->get().present())
															#line 13621 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2846 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = csInterf->get().get();
															#line 2847 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recovered while already a consistencyscan");
															#line 13627 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2849 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::CONSISTENCYSCAN, recruited.id(), interf.id());
															#line 2850 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2851 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltConsistencyScan);
															#line 2853 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> consistencyScanProcess = consistencyScan(recruited, dbInfo);
															#line 2854 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::CONSISTENCYSCAN, recruited.id(), setWhenDoneOrError(consistencyScanProcess, csInterf, Optional<ConsistencyScanInterface>())));
															#line 2859 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			csInterf->set(Optional<ConsistencyScanInterface>(recruited));
															#line 13643 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2861 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ConsistencyScanReceived", req.reqId).detail("ConsistencyScanId", recruited.id());
															#line 2862 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13649 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when8(InitializeConsistencyScanRequest && req,int loopDepth) 
	{
															#line 2840 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2841 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::ConsistencyScan;
															#line 2842 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ConsistencyScanInterface recruited(locality, req.reqId);
															#line 2843 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2845 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (csInterf->get().present())
															#line 13666 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2846 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = csInterf->get().get();
															#line 2847 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recovered while already a consistencyscan");
															#line 13672 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2849 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::CONSISTENCYSCAN, recruited.id(), interf.id());
															#line 2850 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2851 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltConsistencyScan);
															#line 2853 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> consistencyScanProcess = consistencyScan(recruited, dbInfo);
															#line 2854 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::CONSISTENCYSCAN, recruited.id(), setWhenDoneOrError(consistencyScanProcess, csInterf, Optional<ConsistencyScanInterface>())));
															#line 2859 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			csInterf->set(Optional<ConsistencyScanInterface>(recruited));
															#line 13688 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2861 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("ConsistencyScanReceived", req.reqId).detail("ConsistencyScanId", recruited.id());
															#line 2862 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13694 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when9(InitializeBlobManagerRequest const& req,int loopDepth) 
	{
															#line 2865 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2866 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::BlobManager;
															#line 2867 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BlobManagerInterface recruited(locality, req.reqId, req.epoch);
															#line 2868 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2870 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (bmEpochAndInterf->get().present() && bmEpochAndInterf->get().get().first == req.epoch)
															#line 13711 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2871 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.reqId == lastBMRecruitRequestId);
															#line 2872 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = bmEpochAndInterf->get().get().second;
															#line 2874 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a blob manager.");
															#line 13719 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2875 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (lastBMRecruitRequestId == req.reqId && !bmEpochAndInterf->get().present())
															#line 13725 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2881 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Recruited while formerly the same blob manager.", probe::decoration::rare);
															#line 13729 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2887 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				startRole(Role::BLOB_MANAGER, recruited.id(), interf.id());
															#line 2888 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				DUMPTOKEN(recruited.waitFailure);
															#line 2889 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				DUMPTOKEN(recruited.haltBlobManager);
															#line 2890 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				DUMPTOKEN(recruited.haltBlobGranules);
															#line 2891 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				DUMPTOKEN(recruited.blobManagerExclCheckReq);
															#line 2893 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				lastBMRecruitRequestId = req.reqId;
															#line 2895 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Future<Void> blobManagerProcess = blobManager(recruited, dbInfo, req.epoch);
															#line 2896 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add( forwardError(errors, Role::BLOB_MANAGER, recruited.id(), resetBlobManagerWhenDoneOrError(blobManagerProcess, bmEpochAndInterf, req.epoch)));
															#line 2901 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				bmEpochAndInterf->set( Optional<std::pair<int64_t, BlobManagerInterface>>(std::pair(req.epoch, recruited)));
															#line 13751 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 2904 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("BlobManagerReceived", req.reqId).detail("BlobManagerId", recruited.id());
															#line 2905 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13758 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when9(InitializeBlobManagerRequest && req,int loopDepth) 
	{
															#line 2865 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2866 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::BlobManager;
															#line 2867 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BlobManagerInterface recruited(locality, req.reqId, req.epoch);
															#line 2868 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2870 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (bmEpochAndInterf->get().present() && bmEpochAndInterf->get().get().first == req.epoch)
															#line 13775 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2871 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.reqId == lastBMRecruitRequestId);
															#line 2872 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = bmEpochAndInterf->get().get().second;
															#line 2874 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a blob manager.");
															#line 13783 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2875 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (lastBMRecruitRequestId == req.reqId && !bmEpochAndInterf->get().present())
															#line 13789 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2881 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Recruited while formerly the same blob manager.", probe::decoration::rare);
															#line 13793 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 2887 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				startRole(Role::BLOB_MANAGER, recruited.id(), interf.id());
															#line 2888 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				DUMPTOKEN(recruited.waitFailure);
															#line 2889 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				DUMPTOKEN(recruited.haltBlobManager);
															#line 2890 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				DUMPTOKEN(recruited.haltBlobGranules);
															#line 2891 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				DUMPTOKEN(recruited.blobManagerExclCheckReq);
															#line 2893 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				lastBMRecruitRequestId = req.reqId;
															#line 2895 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				Future<Void> blobManagerProcess = blobManager(recruited, dbInfo, req.epoch);
															#line 2896 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add( forwardError(errors, Role::BLOB_MANAGER, recruited.id(), resetBlobManagerWhenDoneOrError(blobManagerProcess, bmEpochAndInterf, req.epoch)));
															#line 2901 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				bmEpochAndInterf->set( Optional<std::pair<int64_t, BlobManagerInterface>>(std::pair(req.epoch, recruited)));
															#line 13815 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 2904 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("BlobManagerReceived", req.reqId).detail("BlobManagerId", recruited.id());
															#line 2905 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13822 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when10(InitializeBlobMigratorRequest const& req,int loopDepth) 
	{
															#line 2908 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2909 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::BlobMigrator;
															#line 2911 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BlobMigratorInterface recruited(locality, req.reqId);
															#line 2912 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2913 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (blobMigratorInterf->get().present())
															#line 13839 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2914 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = blobMigratorInterf->get().get();
															#line 2915 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a blob migrator.", probe::decoration::rare);
															#line 13845 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2917 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BLOB_MIGRATOR, recruited.id(), interf.id());
															#line 2918 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltBlobMigrator);
															#line 2919 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2920 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getValue);
															#line 2921 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getKey);
															#line 2922 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getKeyValues);
															#line 2923 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getMappedKeyValues);
															#line 2924 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getShardState);
															#line 2925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.waitMetrics);
															#line 2926 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.splitMetrics);
															#line 2927 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getReadHotRanges);
															#line 2928 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getRangeSplitPoints);
															#line 2929 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getStorageMetrics);
															#line 2930 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getQueuingMetrics);
															#line 2931 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getKeyValueStoreType);
															#line 2932 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.watchValue);
															#line 2933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getKeyValuesStream);
															#line 2934 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.changeFeedStream);
															#line 2935 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.changeFeedPop);
															#line 2936 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.changeFeedVersionUpdate);
															#line 2938 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> blobMigratorProcess = blobMigrator(recruited, dbInfo);
															#line 2939 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BLOB_MIGRATOR, recruited.id(), setWhenDoneOrError(blobMigratorProcess, blobMigratorInterf, Optional<BlobMigratorInterface>())));
															#line 2945 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			blobMigratorInterf->set(Optional<BlobMigratorInterface>(recruited));
															#line 13895 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2947 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("BlobMigrator_InitRequest", req.reqId).detail("BlobMigratorId", recruited.id());
															#line 2948 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13901 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when10(InitializeBlobMigratorRequest && req,int loopDepth) 
	{
															#line 2908 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2909 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::BlobMigrator;
															#line 2911 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		BlobMigratorInterface recruited(locality, req.reqId);
															#line 2912 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2913 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (blobMigratorInterf->get().present())
															#line 13918 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2914 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = blobMigratorInterf->get().get();
															#line 2915 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a blob migrator.", probe::decoration::rare);
															#line 13924 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2917 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BLOB_MIGRATOR, recruited.id(), interf.id());
															#line 2918 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltBlobMigrator);
															#line 2919 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2920 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getValue);
															#line 2921 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getKey);
															#line 2922 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getKeyValues);
															#line 2923 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getMappedKeyValues);
															#line 2924 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getShardState);
															#line 2925 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.waitMetrics);
															#line 2926 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.splitMetrics);
															#line 2927 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getReadHotRanges);
															#line 2928 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getRangeSplitPoints);
															#line 2929 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getStorageMetrics);
															#line 2930 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getQueuingMetrics);
															#line 2931 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getKeyValueStoreType);
															#line 2932 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.watchValue);
															#line 2933 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.getKeyValuesStream);
															#line 2934 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.changeFeedStream);
															#line 2935 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.changeFeedPop);
															#line 2936 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.ssi.changeFeedVersionUpdate);
															#line 2938 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> blobMigratorProcess = blobMigrator(recruited, dbInfo);
															#line 2939 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BLOB_MIGRATOR, recruited.id(), setWhenDoneOrError(blobMigratorProcess, blobMigratorInterf, Optional<BlobMigratorInterface>())));
															#line 2945 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			blobMigratorInterf->set(Optional<BlobMigratorInterface>(recruited));
															#line 13974 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2947 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("BlobMigrator_InitRequest", req.reqId).detail("BlobMigratorId", recruited.id());
															#line 2948 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 13980 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when11(InitializeBackupRequest const& req,int loopDepth) 
	{
															#line 2951 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!backupWorkerCache.exists(req.reqId))
															#line 13989 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2952 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2953 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Backup;
															#line 2954 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			BackupInterface recruited(locality);
															#line 2955 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2957 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BACKUP, recruited.id(), interf.id());
															#line 2958 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2960 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBackupReply> backupReady = req.reply;
															#line 2961 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupWorkerCache.set(req.reqId, backupReady.getFuture());
															#line 2962 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> backupProcess = backupWorker(recruited, req, dbInfo);
															#line 2963 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupProcess = backupWorkerCache.removeOnReady(req.reqId, backupProcess);
															#line 2964 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BACKUP, recruited.id(), backupProcess));
															#line 2965 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("BackupInitRequest", req.reqId).detail("BackupId", recruited.id());
															#line 2966 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			InitializeBackupReply reply(recruited, req.backupEpoch);
															#line 2967 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupReady.send(reply);
															#line 14019 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2969 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, backupWorkerCache.get(req.reqId));
															#line 14025 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when11(InitializeBackupRequest && req,int loopDepth) 
	{
															#line 2951 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!backupWorkerCache.exists(req.reqId))
															#line 14035 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2952 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 2953 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Backup;
															#line 2954 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			BackupInterface recruited(locality);
															#line 2955 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 2957 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BACKUP, recruited.id(), interf.id());
															#line 2958 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2960 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBackupReply> backupReady = req.reply;
															#line 2961 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupWorkerCache.set(req.reqId, backupReady.getFuture());
															#line 2962 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> backupProcess = backupWorker(recruited, req, dbInfo);
															#line 2963 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupProcess = backupWorkerCache.removeOnReady(req.reqId, backupProcess);
															#line 2964 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BACKUP, recruited.id(), backupProcess));
															#line 2965 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("BackupInitRequest", req.reqId).detail("BackupId", recruited.id());
															#line 2966 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			InitializeBackupReply reply(recruited, req.backupEpoch);
															#line 2967 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			backupReady.send(reply);
															#line 14065 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2969 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			forwardPromise(req.reply, backupWorkerCache.get(req.reqId));
															#line 14071 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when12(InitializeEncryptKeyProxyRequest const& req,int loopDepth) 
	{
															#line 2973 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2974 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::EncryptKeyProxy;
															#line 2975 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		EncryptKeyProxyInterface recruited(locality, req.reqId);
															#line 2976 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2978 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ekpInterf->get().present())
															#line 14089 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2979 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ekpInterf->get().get();
															#line 2980 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a encryptKeyProxy server.", probe::decoration::rare);
															#line 14095 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::ENCRYPT_KEY_PROXY, recruited.id(), interf.id());
															#line 2983 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2984 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltEncryptKeyProxy);
															#line 2985 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getBaseCipherKeysByIds);
															#line 2986 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBaseCipherKeys);
															#line 2987 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBlobMetadata);
															#line 2988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getHealthStatus);
															#line 2990 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> encryptKeyProxyProcess = encryptKeyProxyServer(recruited, dbInfo, req.encryptMode);
															#line 2991 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::ENCRYPT_KEY_PROXY, recruited.id(), setWhenDoneOrError(encryptKeyProxyProcess, ekpInterf, Optional<EncryptKeyProxyInterface>())));
															#line 2996 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ekpInterf->set(Optional<EncryptKeyProxyInterface>(recruited));
															#line 14119 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2998 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("EncryptKeyProxyReceived", req.reqId).detail("EncryptKeyProxyId", recruited.id());
															#line 2999 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when12(InitializeEncryptKeyProxyRequest && req,int loopDepth) 
	{
															#line 2973 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 2974 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::EncryptKeyProxy;
															#line 2975 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		EncryptKeyProxyInterface recruited(locality, req.reqId);
															#line 2976 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 2978 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (ekpInterf->get().present())
															#line 14142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2979 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited = ekpInterf->get().get();
															#line 2980 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Recruited while already a encryptKeyProxy server.", probe::decoration::rare);
															#line 14148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2982 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::ENCRYPT_KEY_PROXY, recruited.id(), interf.id());
															#line 2983 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 2984 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltEncryptKeyProxy);
															#line 2985 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getBaseCipherKeysByIds);
															#line 2986 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBaseCipherKeys);
															#line 2987 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getLatestBlobMetadata);
															#line 2988 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getHealthStatus);
															#line 2990 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> encryptKeyProxyProcess = encryptKeyProxyServer(recruited, dbInfo, req.encryptMode);
															#line 2991 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError( errors, Role::ENCRYPT_KEY_PROXY, recruited.id(), setWhenDoneOrError(encryptKeyProxyProcess, ekpInterf, Optional<EncryptKeyProxyInterface>())));
															#line 2996 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ekpInterf->set(Optional<EncryptKeyProxyInterface>(recruited));
															#line 14172 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 2998 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("EncryptKeyProxyReceived", req.reqId).detail("EncryptKeyProxyId", recruited.id());
															#line 2999 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14178 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when13(InitializeTLogRequest const& req,int loopDepth) 
	{
															#line 3006 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.logVersion < TLogVersion::MIN_RECRUITABLE)
															#line 14187 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3007 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "InitializeTLogInvalidLogVersion") .detail("Version", req.logVersion) .detail("MinRecruitable", TLogVersion::MIN_RECRUITABLE);
															#line 3010 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(internal_error());
															#line 14193 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3012 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3013 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 3014 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogOptions tLogOptions(req.logVersion, req.spillType);
															#line 3015 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogFn tLogFn = tLogFnForOptions(tLogOptions);
															#line 3016 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto& logData = sharedLogs[SharedLogsKey(tLogOptions, req.storeType)];
															#line 3017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(;!logData.empty() && (!logData.back().actor.isValid() || logData.back().actor.isReady());) {
															#line 3018 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.pop_back();
															#line 14209 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3020 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (logData.empty())
															#line 14213 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3021 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			UID logId = deterministicRandom()->randomUniqueID();
															#line 3022 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 3023 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["ForMaster"] = req.recruitmentID.shortString();
															#line 3024 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 3028 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::SHARED_TRANSACTION_LOG, logId, interf.id(), details);
															#line 3030 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const StringRef prefix = req.logVersion > TLogVersion::V2 ? fileVersionedLogDataPrefix : fileLogDataPrefix;
															#line 3032 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, prefix.toString() + tLogOptions.toPrefix(), logId);
															#line 3034 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore(req.storeType, filename, logId, memoryLimit, false, false, false, dbInfo, EncryptionAtRestMode());
															#line 3043 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const DiskQueueVersion dqv = tLogOptions.getDiskQueueVersion();
															#line 3044 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IDiskQueue* queue = openDiskQueue( joinPath(folder, fileLogQueuePrefix.toString() + tLogOptions.toPrefix() + logId.toString() + "-"), tlogQueueExtension.toString(), logId, dqv);
															#line 3050 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(data->onClosed());
															#line 3051 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(queue->onClosed());
															#line 3053 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.push_back(SharedLogsValue());
															#line 3054 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> tLogCore = tLogFn(data, queue, dbInfo, locality, logData.back().requests, logId, interf.id(), false, Promise<Void>(), Promise<Void>(), folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 3068 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, data, logId);
															#line 3069 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, queue, logId);
															#line 3070 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, logId, tLogCore));
															#line 3071 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().actor = tLogCore;
															#line 3072 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().uid = logId;
															#line 14253 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3074 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		logData.back().requests.send(req);
															#line 3075 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		activeSharedTLog->set(logData.back().uid);
															#line 14259 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when13(InitializeTLogRequest && req,int loopDepth) 
	{
															#line 3006 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.logVersion < TLogVersion::MIN_RECRUITABLE)
															#line 14268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3007 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent(SevError, "InitializeTLogInvalidLogVersion") .detail("Version", req.logVersion) .detail("MinRecruitable", TLogVersion::MIN_RECRUITABLE);
															#line 3010 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(internal_error());
															#line 14274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3012 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3013 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::TLog;
															#line 3014 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogOptions tLogOptions(req.logVersion, req.spillType);
															#line 3015 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogFn tLogFn = tLogFnForOptions(tLogOptions);
															#line 3016 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		auto& logData = sharedLogs[SharedLogsKey(tLogOptions, req.storeType)];
															#line 3017 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for(;!logData.empty() && (!logData.back().actor.isValid() || logData.back().actor.isReady());) {
															#line 3018 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.pop_back();
															#line 14290 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3020 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (logData.empty())
															#line 14294 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3021 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			UID logId = deterministicRandom()->randomUniqueID();
															#line 3022 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 3023 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["ForMaster"] = req.recruitmentID.shortString();
															#line 3024 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 3028 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::SHARED_TRANSACTION_LOG, logId, interf.id(), details);
															#line 3030 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const StringRef prefix = req.logVersion > TLogVersion::V2 ? fileVersionedLogDataPrefix : fileLogDataPrefix;
															#line 3032 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, prefix.toString() + tLogOptions.toPrefix(), logId);
															#line 3034 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore(req.storeType, filename, logId, memoryLimit, false, false, false, dbInfo, EncryptionAtRestMode());
															#line 3043 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			const DiskQueueVersion dqv = tLogOptions.getDiskQueueVersion();
															#line 3044 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IDiskQueue* queue = openDiskQueue( joinPath(folder, fileLogQueuePrefix.toString() + tLogOptions.toPrefix() + logId.toString() + "-"), tlogQueueExtension.toString(), logId, dqv);
															#line 3050 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(data->onClosed());
															#line 3051 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(queue->onClosed());
															#line 3053 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.push_back(SharedLogsValue());
															#line 3054 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> tLogCore = tLogFn(data, queue, dbInfo, locality, logData.back().requests, logId, interf.id(), false, Promise<Void>(), Promise<Void>(), folder, degraded, activeSharedTLog, enablePrimaryTxnSystemHealthCheck);
															#line 3068 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, data, logId);
															#line 3069 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			tLogCore = handleIOErrors(tLogCore, queue, logId);
															#line 3070 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::SHARED_TRANSACTION_LOG, logId, tLogCore));
															#line 3071 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().actor = tLogCore;
															#line 3072 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			logData.back().uid = logId;
															#line 14334 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3074 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		logData.back().requests.send(req);
															#line 3075 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		activeSharedTLog->set(logData.back().uid);
															#line 14340 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when14(InitializeStorageRequest const& req,int loopDepth) 
	{
															#line 3078 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("StorageServerInitProgress", req.interfaceId);
															#line 3079 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Step", "1.RequestReceived");
															#line 3080 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("ReqID", req.reqId);
															#line 3081 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("WorkerID", interf.id());
															#line 3082 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("StorageType", req.storeType.toString());
															#line 3083 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("SeedTag", req.seedTag.toString());
															#line 3084 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("IsTssPair", req.tssPairIDAndVersion.present());
															#line 3085 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.tssPairIDAndVersion.present())
															#line 14363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3086 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("TssPairID", req.tssPairIDAndVersion.get().first);
															#line 14367 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3088 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		int j = 0;
															#line 3089 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( const auto& runningStorage : runningStorages ) {
															#line 3090 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageIDOnSameWorker" + std::to_string(j), runningStorage.first);
															#line 3091 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageEngineOnSameWorker" + std::to_string(j), runningStorage.second);
															#line 3092 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			j++;
															#line 14379 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3100 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!storageCache.exists(req.reqId) && (std::all_of(runningStorages.begin(), runningStorages.end(), [&req](const auto& p) { return p.second != req.storeType; }) || req.seedTag != invalidTag))
															#line 14383 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3105 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.initialClusterVersion >= 0);
															#line 3106 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 3107 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 3113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			cleanupStorageDisks(dbInfo, storageCleaners, memoryLimit);
															#line 3115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool isTss = req.tssPairIDAndVersion.present();
															#line 3116 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited(req.interfaceId);
															#line 3117 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 3118 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.tssPairID = isTss ? req.tssPairIDAndVersion.get().first : Optional<UID>();
															#line 3119 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 3121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 3122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 3123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["IsTSS"] = std::to_string(isTss);
															#line 3124 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 3125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(ssRole, recruited.id(), interf.id(), details);
															#line 3126 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "2.RoleStarted") .detail("WorkerID", interf.id());
															#line 3132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 3133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 3134 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 3135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 3136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 3137 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 3138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 3139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getReadHotRanges);
															#line 3140 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 3141 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 3142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 3143 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3144 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 3145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 3146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValuesStream);
															#line 3147 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedStream);
															#line 3148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedPop);
															#line 3149 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 3151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, isTss ? testingStoragePrefix.toString() : fileStoragePrefix.toString(), recruited.id());
															#line 3156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 3158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore( req.storeType, filename, recruited.id(), memoryLimit, false, false, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( req.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && req.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, req.encryptMode, 0, encryptionMonitor);
															#line 3175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "3.KVStoreOpened") .detail("WorkerID", interf.id());
															#line 3181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> kvClosed = data->onClosed() || rebootKVSPromise2 .getFuture();
															#line 3185 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(kvClosed);
															#line 3186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeStorageReply> storageReady = req.reply;
															#line 3187 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			storageCache.set(req.reqId, storageReady.getFuture());
															#line 3188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<ErrorOr<Void>> storeError = errorOr(data->getError());
															#line 3189 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> s = storageServer(data, recruited, req.seedTag, req.initialClusterVersion, isTss ? req.tssPairIDAndVersion.get().second : 0, storageReady, dbInfo, folder, encryptionMonitor);
															#line 3198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = handleIOErrors(s, storeError, recruited.id(), kvClosed);
															#line 3199 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = storageCache.removeOnReady(req.reqId, s);
															#line 3200 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = storageServerRollbackRebooter(&runningStorages, &storageCleaners, s, req.storeType, filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, data, false, &rebootKVSPromise2, encryptionMonitor);
															#line 3216 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, ssRole, recruited.id(), s));
															#line 14479 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (storageCache.exists(req.reqId))
															#line 14485 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				forwardPromise(req.reply, storageCache.get(req.reqId));
															#line 14489 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 3220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("AttemptedDoubleRecruitment", interf.id()).detail("ForRole", "StorageServer");
															#line 3221 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(map(delay(0.5), [reply = req.reply](Void) { reply.sendError(recruitment_failed()); return Void(); }));
															#line 14497 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when14(InitializeStorageRequest && req,int loopDepth) 
	{
															#line 3078 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent e("StorageServerInitProgress", req.interfaceId);
															#line 3079 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("Step", "1.RequestReceived");
															#line 3080 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("ReqID", req.reqId);
															#line 3081 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("WorkerID", interf.id());
															#line 3082 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("StorageType", req.storeType.toString());
															#line 3083 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("SeedTag", req.seedTag.toString());
															#line 3084 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		e.detail("IsTssPair", req.tssPairIDAndVersion.present());
															#line 3085 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.tssPairIDAndVersion.present())
															#line 14522 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3086 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("TssPairID", req.tssPairIDAndVersion.get().first);
															#line 14526 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3088 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		int j = 0;
															#line 3089 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( const auto& runningStorage : runningStorages ) {
															#line 3090 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageIDOnSameWorker" + std::to_string(j), runningStorage.first);
															#line 3091 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e.detail("RunningStorageEngineOnSameWorker" + std::to_string(j), runningStorage.second);
															#line 3092 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			j++;
															#line 14538 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3100 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (!storageCache.exists(req.reqId) && (std::all_of(runningStorages.begin(), runningStorages.end(), [&req](const auto& p) { return p.second != req.storeType; }) || req.seedTag != invalidTag))
															#line 14542 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3105 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(req.initialClusterVersion >= 0);
															#line 3106 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 3107 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Storage;
															#line 3113 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			cleanupStorageDisks(dbInfo, storageCleaners, memoryLimit);
															#line 3115 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool isTss = req.tssPairIDAndVersion.present();
															#line 3116 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			StorageServerInterface recruited(req.interfaceId);
															#line 3117 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.locality = locality;
															#line 3118 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.tssPairID = isTss ? req.tssPairIDAndVersion.get().first : Optional<UID>();
															#line 3119 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 3121 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::map<std::string, std::string> details;
															#line 3122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["StorageEngine"] = req.storeType.toString();
															#line 3123 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			details["IsTSS"] = std::to_string(isTss);
															#line 3124 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Role ssRole = isTss ? Role::TESTING_STORAGE_SERVER : Role::STORAGE_SERVER;
															#line 3125 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(ssRole, recruited.id(), interf.id(), details);
															#line 3126 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "2.RoleStarted") .detail("WorkerID", interf.id());
															#line 3132 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getValue);
															#line 3133 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKey);
															#line 3134 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValues);
															#line 3135 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getMappedKeyValues);
															#line 3136 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getShardState);
															#line 3137 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitMetrics);
															#line 3138 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.splitMetrics);
															#line 3139 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getReadHotRanges);
															#line 3140 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getRangeSplitPoints);
															#line 3141 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getStorageMetrics);
															#line 3142 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 3143 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3144 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValueStoreType);
															#line 3145 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.watchValue);
															#line 3146 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.getKeyValuesStream);
															#line 3147 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedStream);
															#line 3148 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedPop);
															#line 3149 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.changeFeedVersionUpdate);
															#line 3151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			std::string filename = filenameFromId(req.storeType, folder, isTss ? testingStoragePrefix.toString() : fileStoragePrefix.toString(), recruited.id());
															#line 3156 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Reference<GetEncryptCipherKeysMonitor> encryptionMonitor = makeReference<GetEncryptCipherKeysMonitor>();
															#line 3158 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = openKVStore( req.storeType, filename, recruited.id(), memoryLimit, false, false, SERVER_KNOBS->REMOTE_KV_STORE && (g_network->isSimulated() ? ( req.storeType != KeyValueStoreType::SSD_ROCKSDB_V1 && req.storeType != KeyValueStoreType::SSD_SHARDED_ROCKSDB && deterministicRandom()->coinflip()) : true), dbInfo, req.encryptMode, 0, encryptionMonitor);
															#line 3175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("StorageServerInitProgress", recruited.id()) .detail("ReqID", req.reqId) .detail("StorageType", req.storeType.toString()) .detail("Step", "3.KVStoreOpened") .detail("WorkerID", interf.id());
															#line 3181 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> kvClosed = data->onClosed() || rebootKVSPromise2 .getFuture();
															#line 3185 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			filesClosed.add(kvClosed);
															#line 3186 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeStorageReply> storageReady = req.reply;
															#line 3187 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			storageCache.set(req.reqId, storageReady.getFuture());
															#line 3188 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<ErrorOr<Void>> storeError = errorOr(data->getError());
															#line 3189 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> s = storageServer(data, recruited, req.seedTag, req.initialClusterVersion, isTss ? req.tssPairIDAndVersion.get().second : 0, storageReady, dbInfo, folder, encryptionMonitor);
															#line 3198 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = handleIOErrors(s, storeError, recruited.id(), kvClosed);
															#line 3199 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = storageCache.removeOnReady(req.reqId, s);
															#line 3200 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			s = storageServerRollbackRebooter(&runningStorages, &storageCleaners, s, req.storeType, filename, recruited.id(), recruited.locality, isTss, dbInfo, folder, &filesClosed, memoryLimit, data, false, &rebootKVSPromise2, encryptionMonitor);
															#line 3216 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, ssRole, recruited.id(), s));
															#line 14638 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3217 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (storageCache.exists(req.reqId))
															#line 14644 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3218 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				forwardPromise(req.reply, storageCache.get(req.reqId));
															#line 14648 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 3220 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("AttemptedDoubleRecruitment", interf.id()).detail("ForRole", "StorageServer");
															#line 3221 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(map(delay(0.5), [reply = req.reply](Void) { reply.sendError(recruitment_failed()); return Void(); }));
															#line 14656 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when15(InitializeBlobWorkerRequest const& req,int loopDepth) 
	{
															#line 3228 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (blobWorkerFuture.isReady())
															#line 14667 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3229 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 3230 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::BlobWorker;
															#line 3232 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			BlobWorkerInterface recruited(locality, req.interfaceId);
															#line 3233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 3234 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BLOB_WORKER, recruited.id(), interf.id());
															#line 3236 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 3237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.blobGranuleFileRequest);
															#line 3238 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.assignBlobRangeRequest);
															#line 3239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.revokeBlobRangeRequest);
															#line 3240 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.granuleAssignmentsRequest);
															#line 3241 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.granuleStatusStreamRequest);
															#line 3242 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltBlobWorker);
															#line 3243 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.minBlobVersionRequest);
															#line 3245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = nullptr;
															#line 3246 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->BLOB_WORKER_DISK_ENABLED && req.storeType != KeyValueStoreType::END)
															#line 14699 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3247 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::string filename = filenameFromId(req.storeType, folder, fileBlobWorkerPrefix.toString(), recruited.id());
															#line 3249 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				data = openKVStore(req.storeType, filename, recruited.id(), memoryLimit, false, false, false, dbInfo, req.encryptMode, FLOW_KNOBS->BLOB_WORKER_PAGE_CACHE);
															#line 3259 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(data->onClosed());
															#line 14707 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 3262 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBlobWorkerReply> blobWorkerReady = req.reply;
															#line 3263 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> bw = blobWorker(recruited, blobWorkerReady, dbInfo, data);
															#line 3264 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->BLOB_WORKER_DISK_ENABLED && req.storeType != KeyValueStoreType::END)
															#line 14715 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3265 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				bw = handleIOErrors(bw, data, recruited.id());
															#line 14719 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 3267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			blobWorkerFuture = bw;
															#line 3268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BLOB_WORKER, recruited.id(), bw));
															#line 14725 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3270 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(recruitment_failed());
															#line 14731 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when15(InitializeBlobWorkerRequest && req,int loopDepth) 
	{
															#line 3228 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (blobWorkerFuture.isReady())
															#line 14741 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3229 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			LocalLineage _;
															#line 3230 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::BlobWorker;
															#line 3232 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			BlobWorkerInterface recruited(locality, req.interfaceId);
															#line 3233 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			recruited.initEndpoints();
															#line 3234 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			startRole(Role::BLOB_WORKER, recruited.id(), interf.id());
															#line 3236 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.waitFailure);
															#line 3237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.blobGranuleFileRequest);
															#line 3238 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.assignBlobRangeRequest);
															#line 3239 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.revokeBlobRangeRequest);
															#line 3240 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.granuleAssignmentsRequest);
															#line 3241 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.granuleStatusStreamRequest);
															#line 3242 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.haltBlobWorker);
															#line 3243 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			DUMPTOKEN(recruited.minBlobVersionRequest);
															#line 3245 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			IKeyValueStore* data = nullptr;
															#line 3246 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->BLOB_WORKER_DISK_ENABLED && req.storeType != KeyValueStoreType::END)
															#line 14773 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3247 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				std::string filename = filenameFromId(req.storeType, folder, fileBlobWorkerPrefix.toString(), recruited.id());
															#line 3249 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				data = openKVStore(req.storeType, filename, recruited.id(), memoryLimit, false, false, false, dbInfo, req.encryptMode, FLOW_KNOBS->BLOB_WORKER_PAGE_CACHE);
															#line 3259 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				filesClosed.add(data->onClosed());
															#line 14781 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 3262 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ReplyPromise<InitializeBlobWorkerReply> blobWorkerReady = req.reply;
															#line 3263 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			Future<Void> bw = blobWorker(recruited, blobWorkerReady, dbInfo, data);
															#line 3264 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (SERVER_KNOBS->BLOB_WORKER_DISK_ENABLED && req.storeType != KeyValueStoreType::END)
															#line 14789 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3265 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				bw = handleIOErrors(bw, data, recruited.id());
															#line 14793 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 3267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			blobWorkerFuture = bw;
															#line 3268 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			errorForwarders.add(forwardError(errors, Role::BLOB_WORKER, recruited.id(), bw));
															#line 14799 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3270 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			req.reply.sendError(recruitment_failed());
															#line 14805 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when16(InitializeCommitProxyRequest const& req,int loopDepth) 
	{
															#line 3274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3275 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::CommitProxy;
															#line 3276 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CommitProxyInterface recruited;
															#line 3277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3278 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3279 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3282 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::COMMIT_PROXY, recruited.id(), interf.id(), details);
															#line 3285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3286 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3287 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyServersLocations);
															#line 3288 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageServerRejoinInfo);
															#line 3289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3290 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.txnState);
															#line 3291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getTenantId);
															#line 3293 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie(recruited, forwardError(errors, Role::COMMIT_PROXY, recruited.id(), commitProxyServer(recruited, req, dbInfo, whitelistBinPaths))));
															#line 3298 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14849 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when16(InitializeCommitProxyRequest && req,int loopDepth) 
	{
															#line 3274 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3275 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::CommitProxy;
															#line 3276 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		CommitProxyInterface recruited;
															#line 3277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3278 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3279 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3282 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3283 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::COMMIT_PROXY, recruited.id(), interf.id(), details);
															#line 3285 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3286 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3287 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getKeyServersLocations);
															#line 3288 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getStorageServerRejoinInfo);
															#line 3289 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3290 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.txnState);
															#line 3291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getTenantId);
															#line 3293 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie(recruited, forwardError(errors, Role::COMMIT_PROXY, recruited.id(), commitProxyServer(recruited, req, dbInfo, whitelistBinPaths))));
															#line 3298 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14892 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when17(InitializeGrvProxyRequest const& req,int loopDepth) 
	{
															#line 3301 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3302 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::GrvProxy;
															#line 3303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrvProxyInterface recruited;
															#line 3304 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3305 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3306 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3308 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3309 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3310 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::GRV_PROXY, recruited.id(), interf.id(), details);
															#line 3312 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3313 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3314 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getHealthMetrics);
															#line 3317 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::GRV_PROXY, recruited.id(), grvProxyServer(recruited, req, dbInfo))));
															#line 3320 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14927 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when17(InitializeGrvProxyRequest && req,int loopDepth) 
	{
															#line 3301 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3302 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::GrvProxy;
															#line 3303 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		GrvProxyInterface recruited;
															#line 3304 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.processId = locality.processId();
															#line 3305 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.provisional = false;
															#line 3306 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3308 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3309 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		details["ForMaster"] = req.master.id().shortString();
															#line 3310 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::GRV_PROXY, recruited.id(), interf.id(), details);
															#line 3312 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getConsistentReadVersion);
															#line 3313 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3314 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getHealthMetrics);
															#line 3317 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::GRV_PROXY, recruited.id(), grvProxyServer(recruited, req, dbInfo))));
															#line 3320 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14962 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when18(InitializeResolverRequest const& req,int loopDepth) 
	{
															#line 3323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Resolver;
															#line 3325 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ResolverInterface recruited;
															#line 3326 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 3327 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::RESOLVER, recruited.id(), interf.id(), details);
															#line 3332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.resolve);
															#line 3333 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.metrics);
															#line 3334 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.split);
															#line 3335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3337 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::RESOLVER, recruited.id(), resolver(recruited, req, dbInfo))));
															#line 3339 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 14995 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when18(InitializeResolverRequest && req,int loopDepth) 
	{
															#line 3323 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3324 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::Resolver;
															#line 3325 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		ResolverInterface recruited;
															#line 3326 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.locality = locality;
															#line 3327 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3330 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::RESOLVER, recruited.id(), interf.id(), details);
															#line 3332 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.resolve);
															#line 3333 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.metrics);
															#line 3334 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.split);
															#line 3335 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3337 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add(zombie( recruited, forwardError(errors, Role::RESOLVER, recruited.id(), resolver(recruited, req, dbInfo))));
															#line 3339 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 15028 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when19(InitializeLogRouterRequest const& req,int loopDepth) 
	{
															#line 3342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3343 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::LogRouter;
															#line 3344 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogInterface recruited(locality);
															#line 3345 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3347 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3348 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::LOG_ROUTER, recruited.id(), interf.id(), details);
															#line 3350 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekMessages);
															#line 3351 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekStreamMessages);
															#line 3352 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.popMessages);
															#line 3353 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3354 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.lock);
															#line 3355 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3356 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.confirmRunning);
															#line 3357 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.recoveryFinished);
															#line 3359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.disablePopRequest);
															#line 3360 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.enablePopRequest);
															#line 3361 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.snapRequest);
															#line 3363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::LOG_ROUTER, recruited.id(), logRouter(recruited, req, dbInfo))));
															#line 3366 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 15075 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when19(InitializeLogRouterRequest && req,int loopDepth) 
	{
															#line 3342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		LocalLineage _;
															#line 3343 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		getCurrentLineage()->modify(&RoleLineage::role) = ProcessClass::ClusterRole::LogRouter;
															#line 3344 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TLogInterface recruited(locality);
															#line 3345 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		recruited.initEndpoints();
															#line 3347 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::map<std::string, std::string> details;
															#line 3348 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		startRole(Role::LOG_ROUTER, recruited.id(), interf.id(), details);
															#line 3350 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekMessages);
															#line 3351 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.peekStreamMessages);
															#line 3352 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.popMessages);
															#line 3353 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.commit);
															#line 3354 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.lock);
															#line 3355 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.getQueuingMetrics);
															#line 3356 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.confirmRunning);
															#line 3357 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.waitFailure);
															#line 3358 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.recoveryFinished);
															#line 3359 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.disablePopRequest);
															#line 3360 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.enablePopRequest);
															#line 3361 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		DUMPTOKEN(recruited.snapRequest);
															#line 3363 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		errorForwarders.add( zombie(recruited, forwardError(errors, Role::LOG_ROUTER, recruited.id(), logRouter(recruited, req, dbInfo))));
															#line 3366 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(recruited);
															#line 15122 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when20(CoordinationPingMessage const& m,int loopDepth) 
	{
															#line 3369 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("CoordinationPing", interf.id()) .detail("CCID", m.clusterControllerId) .detail("TimeStep", m.timeStep);
															#line 15131 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when20(CoordinationPingMessage && m,int loopDepth) 
	{
															#line 3369 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("CoordinationPing", interf.id()) .detail("CCID", m.clusterControllerId) .detail("TimeStep", m.timeStep);
															#line 15140 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when21(SetMetricsLogRateRequest const& req,int loopDepth) 
	{
															#line 3374 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("LoggingRateChange", interf.id()) .detail("OldDelay", loggingDelay) .detail("NewLogPS", req.metricsLogsPerSecond);
															#line 3377 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.metricsLogsPerSecond != 0)
															#line 15151 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3378 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingDelay = 1.0 / req.metricsLogsPerSecond;
															#line 3379 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingTrigger = Void();
															#line 15157 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when21(SetMetricsLogRateRequest && req,int loopDepth) 
	{
															#line 3374 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEvent("LoggingRateChange", interf.id()) .detail("OldDelay", loggingDelay) .detail("NewLogPS", req.metricsLogsPerSecond);
															#line 3377 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.metricsLogsPerSecond != 0)
															#line 15169 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3378 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingDelay = 1.0 / req.metricsLogsPerSecond;
															#line 3379 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			loggingTrigger = Void();
															#line 15175 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when22(EventLogRequest const& req,int loopDepth) 
	{
															#line 3383 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEventFields e;
															#line 3384 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.getLastError)
															#line 15187 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.getLatestError();
															#line 15191 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3387 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.get(req.eventName.toString());
															#line 15197 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3388 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(e);
															#line 15201 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when22(EventLogRequest && req,int loopDepth) 
	{
															#line 3383 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		TraceEventFields e;
															#line 3384 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (req.getLastError)
															#line 15212 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.getLatestError();
															#line 15216 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3387 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			e = latestEventCache.get(req.eventName.toString());
															#line 15222 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
															#line 3388 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(e);
															#line 15226 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when23(TraceBatchDumpRequest const& req,int loopDepth) 
	{
															#line 3391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		g_traceBatch.dump();
															#line 3392 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(Void());
															#line 15237 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when23(TraceBatchDumpRequest && req,int loopDepth) 
	{
															#line 3391 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		g_traceBatch.dump();
															#line 3392 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(Void());
															#line 15248 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when24(DiskStoreRequest const& req,int loopDepth) 
	{
															#line 3395 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Standalone<VectorRef<UID>> ids;
															#line 3396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( DiskStore d : getDiskStores(folder) ) {
															#line 3397 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool included = true;
															#line 3398 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!req.includePartialStores)
															#line 15263 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 15267 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3400 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = fileExists(d.filename + ".fdb-wal");
															#line 15271 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 3401 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (d.storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 15277 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 3402 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						included = fileExists(d.filename + ".sqlite-wal");
															#line 15281 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
					else
					{
															#line 3403 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						if (d.storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 15287 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						{
															#line 3404 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							included = fileExists(d.filename + "0.pagerlog") && fileExists(d.filename + "1.pagerlog");
															#line 15291 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						}
						else
						{
															#line 3405 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							if (d.storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 15297 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
							{
															#line 3406 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 15301 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
							}
							else
							{
															#line 3408 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								if (d.storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 15307 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
								{
															#line 3409 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 15311 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
								}
								else
								{
															#line 3411 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									if (d.storeType == KeyValueStoreType::MEMORY)
															#line 15317 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									{
															#line 3412 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdq");
															#line 15321 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									}
									else
									{
															#line 3414 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										ASSERT(d.storeType == KeyValueStoreType::MEMORY_RADIXTREE);
															#line 3415 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdr");
															#line 15329 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									}
								}
							}
						}
					}
				}
															#line 3417 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storedComponent == DiskStore::COMPONENT::TLogData && included)
															#line 15338 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3418 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = false;
															#line 15342 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 3442 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (included)
															#line 15347 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3443 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ids.push_back(ids.arena(), d.storeID);
															#line 15351 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 3446 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(ids);
															#line 15356 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when24(DiskStoreRequest && req,int loopDepth) 
	{
															#line 3395 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		Standalone<VectorRef<UID>> ids;
															#line 3396 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		for( DiskStore d : getDiskStores(folder) ) {
															#line 3397 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			bool included = true;
															#line 3398 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (!req.includePartialStores)
															#line 15371 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storeType == KeyValueStoreType::SSD_BTREE_V1)
															#line 15375 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3400 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = fileExists(d.filename + ".fdb-wal");
															#line 15379 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
				else
				{
															#line 3401 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					if (d.storeType == KeyValueStoreType::SSD_BTREE_V2)
															#line 15385 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					{
															#line 3402 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						included = fileExists(d.filename + ".sqlite-wal");
															#line 15389 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
					}
					else
					{
															#line 3403 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
						if (d.storeType == KeyValueStoreType::SSD_REDWOOD_V1)
															#line 15395 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						{
															#line 3404 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							included = fileExists(d.filename + "0.pagerlog") && fileExists(d.filename + "1.pagerlog");
															#line 15399 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
						}
						else
						{
															#line 3405 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
							if (d.storeType == KeyValueStoreType::SSD_ROCKSDB_V1)
															#line 15405 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
							{
															#line 3406 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 15409 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
							}
							else
							{
															#line 3408 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
								if (d.storeType == KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 15415 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
								{
															#line 3409 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									included = fileExists(joinPath(d.filename, "CURRENT")) && fileExists(joinPath(d.filename, "IDENTITY"));
															#line 15419 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
								}
								else
								{
															#line 3411 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
									if (d.storeType == KeyValueStoreType::MEMORY)
															#line 15425 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									{
															#line 3412 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdq");
															#line 15429 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									}
									else
									{
															#line 3414 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										ASSERT(d.storeType == KeyValueStoreType::MEMORY_RADIXTREE);
															#line 3415 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
										included = fileExists(d.filename + "1.fdr");
															#line 15437 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
									}
								}
							}
						}
					}
				}
															#line 3417 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (d.storedComponent == DiskStore::COMPONENT::TLogData && included)
															#line 15446 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3418 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					included = false;
															#line 15450 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
															#line 3442 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (included)
															#line 15455 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3443 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ids.push_back(ids.arena(), d.storeID);
															#line 15459 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
		}
															#line 3446 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		req.reply.send(ids);
															#line 15464 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when25(Void const& _,int loopDepth) 
	{
															#line 3449 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		systemMonitor();
															#line 3450 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		loggingTrigger = delay(loggingDelay, TaskPriority::FlushTrace);
															#line 15475 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when25(Void && _,int loopDepth) 
	{
															#line 3449 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		systemMonitor();
															#line 3450 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		loggingTrigger = delay(loggingDelay, TaskPriority::FlushTrace);
															#line 15486 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when26(WorkerSnapRequest const& __snapReq,int loopDepth) 
	{
															#line 3452 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		snapReq = __snapReq;
															#line 3453 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string snapReqKey = snapReq.snapUID.toString() + snapReq.role.toString();
															#line 3454 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReqResultMap.contains(snapReqKey))
															#line 15499 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3455 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker received a duplicate finished snapshot request", probe::decoration::rare);
															#line 3456 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto result = snapReqResultMap[snapReqKey];
															#line 3457 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			result.isError() ? snapReq.reply.sendError(result.getError()) : snapReq.reply.send(result.get());
															#line 3458 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("RetryFinishedWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role) .detail("Result", result.isError() ? result.getError().code() : success().code());
															#line 15509 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3462 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (snapReqMap.contains(snapReqKey))
															#line 15515 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Worker received a duplicate ongoing snapshot request", probe::decoration::rare);
															#line 3464 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("RetryOngoingWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role);
															#line 3467 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.role == snapReqMap[snapReqKey].role);
															#line 3468 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.snapPayload == snapReqMap[snapReqKey].snapPayload);
															#line 3473 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey].reply.sendError(duplicate_snapshot_request());
															#line 3474 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 15529 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 3476 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 3477 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated() && (now() - lastSnapTime) < SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)
															#line 15537 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3479 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto okay = lastSnapReq.snapUID != snapReq.snapUID || lastSnapReq.role != snapReq.role;
															#line 3480 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent(okay ? SevInfo : SevError, "RapidSnapRequestsOnSameProcess") .detail("CurrSnapUID", snapReq.snapUID) .detail("PrevSnapUID", lastSnapReq.snapUID) .detail("CurrRole", snapReq.role) .detail("PrevRole", lastSnapReq.role) .detail("GapTime", now() - lastSnapTime);
															#line 15543 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
															#line 3487 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto* snapReqResultMapPtr = &snapReqResultMap;
															#line 3488 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(fmap( [snapReqResultMapPtr, snapReqKey](Void _) { snapReqResultMapPtr->erase(snapReqKey); return Void(); }, delayed(workerSnapCreate(snapReq, snapReq.role.toString() == "coord" ? coordFolder : folder, &snapReqMap, &snapReqResultMap), SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)));
															#line 3498 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 15551 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3499 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapReq = snapReq;
															#line 3500 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapTime = now();
															#line 15557 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when26(WorkerSnapRequest && __snapReq,int loopDepth) 
	{
		snapReq = std::move(__snapReq);
															#line 3453 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		std::string snapReqKey = snapReq.snapUID.toString() + snapReq.role.toString();
															#line 3454 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (snapReqResultMap.contains(snapReqKey))
															#line 15572 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 3455 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			CODE_PROBE(true, "Worker received a duplicate finished snapshot request", probe::decoration::rare);
															#line 3456 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			auto result = snapReqResultMap[snapReqKey];
															#line 3457 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			result.isError() ? snapReq.reply.sendError(result.getError()) : snapReq.reply.send(result.get());
															#line 3458 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("RetryFinishedWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role) .detail("Result", result.isError() ? result.getError().code() : success().code());
															#line 15582 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 3462 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (snapReqMap.contains(snapReqKey))
															#line 15588 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 3463 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				CODE_PROBE(true, "Worker received a duplicate ongoing snapshot request", probe::decoration::rare);
															#line 3464 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				TraceEvent("RetryOngoingWorkerSnapRequest") .detail("SnapUID", snapReq.snapUID.toString()) .detail("Role", snapReq.role);
															#line 3467 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.role == snapReqMap[snapReqKey].role);
															#line 3468 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				ASSERT(snapReq.snapPayload == snapReqMap[snapReqKey].snapPayload);
															#line 3473 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey].reply.sendError(duplicate_snapshot_request());
															#line 3474 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 15602 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
			else
			{
															#line 3476 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				snapReqMap[snapReqKey] = snapReq;
															#line 3477 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated() && (now() - lastSnapTime) < SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)
															#line 15610 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3479 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					auto okay = lastSnapReq.snapUID != snapReq.snapUID || lastSnapReq.role != snapReq.role;
															#line 3480 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					TraceEvent(okay ? SevInfo : SevError, "RapidSnapRequestsOnSameProcess") .detail("CurrSnapUID", snapReq.snapUID) .detail("PrevSnapUID", lastSnapReq.snapUID) .detail("CurrRole", snapReq.role) .detail("PrevRole", lastSnapReq.role) .detail("GapTime", now() - lastSnapTime);
															#line 15616 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
															#line 3487 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				auto* snapReqResultMapPtr = &snapReqResultMap;
															#line 3488 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				errorForwarders.add(fmap( [snapReqResultMapPtr, snapReqKey](Void _) { snapReqResultMapPtr->erase(snapReqKey); return Void(); }, delayed(workerSnapCreate(snapReq, snapReq.role.toString() == "coord" ? coordFolder : folder, &snapReqMap, &snapReqResultMap), SERVER_KNOBS->SNAP_MINIMUM_TIME_GAP)));
															#line 3498 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				if (g_network->isSimulated())
															#line 15624 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				{
															#line 3499 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapReq = snapReq;
															#line 3500 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
					lastSnapTime = now();
															#line 15630 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
				}
			}
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when27(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when27(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when28(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when28(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 1, UpdateServerDBInfoRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 2, RebootRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 3, SetFailureInjection >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 4, ProfilerRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 5, RecruitMasterRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 6, InitializeDataDistributorRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 7, InitializeRatekeeperRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 8, InitializeConsistencyScanRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 9, InitializeBlobManagerRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 10, InitializeBlobMigratorRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 11, InitializeBackupRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 12, InitializeEncryptKeyProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 13, InitializeTLogRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 14, InitializeStorageRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 15, InitializeBlobWorkerRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 16, InitializeCommitProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 17, InitializeGrvProxyRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 18, InitializeResolverRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 19, InitializeLogRouterRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 20, CoordinationPingMessage >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 21, SetMetricsLogRateRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 22, EventLogRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 23, TraceBatchDumpRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 24, DiskStoreRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 25, Void >::remove();
		static_cast<WorkerServerActor*>(this)->ActorSingleCallback< WorkerServerActor, 26, WorkerSnapRequest >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 27, Void >::remove();
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 28, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 1, UpdateServerDBInfoRequest >*,UpdateServerDBInfoRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 1, UpdateServerDBInfoRequest >*,UpdateServerDBInfoRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 1, UpdateServerDBInfoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11loopBody1when2cont1(int loopDepth) 
	{
															#line 2715 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (g_network->isSimulated())
															#line 15756 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		{
															#line 2716 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("SimulatedReboot").detail("Deletion", rebootReq.deleteData);
															#line 2717 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			if (rebootReq.deleteData)
															#line 15762 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			{
															#line 2718 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
				return a_body1cont1Catch1(please_reboot_delete(), std::max(0, loopDepth - 1));
															#line 15766 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			}
															#line 2720 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			return a_body1cont1Catch1(please_reboot(), std::max(0, loopDepth - 1));
															#line 15770 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		else
		{
															#line 2722 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			TraceEvent("ProcessReboot").log();
															#line 2723 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			ASSERT(!rebootReq.deleteData);
															#line 2724 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			flushAndExit(0);
															#line 15780 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		}
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when2cont3(Reference<IAsyncFile> const& checkFile,int loopDepth) 
	{
															#line 2712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_30 = checkFile->sync();
															#line 2712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15792 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1cont1Catch1(__when_expr_30.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when2cont3when1(__when_expr_30.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 4;
															#line 2712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 30, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 15797 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11loopBody1when2cont3(Reference<IAsyncFile> && checkFile,int loopDepth) 
	{
															#line 2712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		StrictFuture<Void> __when_expr_30 = checkFile->sync();
															#line 2712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 15808 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		if (__when_expr_30.isReady()) { if (__when_expr_30.isError()) return a_body1cont1Catch1(__when_expr_30.getError(), std::max(0, loopDepth - 1)); else return a_body1cont11loopBody1when2cont3when1(__when_expr_30.get(), loopDepth); };
		static_cast<WorkerServerActor*>(this)->actor_wait_state = 4;
															#line 2712 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
		__when_expr_30.addCallbackAndClear(static_cast<ActorCallback< WorkerServerActor, 30, Void >*>(static_cast<WorkerServerActor*>(this)));
															#line 15813 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11loopBody1when2when1(Reference<IAsyncFile> const& checkFile,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1when2cont3(checkFile, loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when2when1(Reference<IAsyncFile> && checkFile,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1when2cont3(std::move(checkFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 29, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 29, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont11loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 29, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont11loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 29, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 29);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 29);

	}
	int a_body1cont11loopBody1when2cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when2cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1when2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when2cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1when2cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when2cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1when2cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WorkerServerActor*>(this)->actor_wait_state > 0) static_cast<WorkerServerActor*>(this)->actor_wait_state = 0;
		static_cast<WorkerServerActor*>(this)->ActorCallback< WorkerServerActor, 30, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 30, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11loopBody1when2cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 30, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont11loopBody1when2cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 30, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 30);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 30);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 2, RebootRequest >*,RebootRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 2, RebootRequest >*,RebootRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 2, RebootRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 3, SetFailureInjection >*,SetFailureInjection const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 3, SetFailureInjection >*,SetFailureInjection && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 3, SetFailureInjection >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11loopBody1when4cont1(int loopDepth) 
	{
		loopDepth = a_body1cont11loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11loopBody1when4Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 2761 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/fdbserver/worker.actor.cpp"
			profilerReq.reply.sendError(e);
															#line 16105 "/codebuild/output/src3173567066/src/github.com/apple/foundationdb/build_output/fdbserver/worker.actor.g.cpp"
			loopDepth = a_body1cont11loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont11loopBody1when4cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11loopBody1when4cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 4, ProfilerRequest >*,ProfilerRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 4, ProfilerRequest >*,ProfilerRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 4, ProfilerRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 5, RecruitMasterRequest >*,RecruitMasterRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 5, RecruitMasterRequest >*,RecruitMasterRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 5, RecruitMasterRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 6, InitializeDataDistributorRequest >*,InitializeDataDistributorRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 6, InitializeDataDistributorRequest >*,InitializeDataDistributorRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 6, InitializeDataDistributorRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 7, InitializeRatekeeperRequest >*,InitializeRatekeeperRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 7, InitializeRatekeeperRequest >*,InitializeRatekeeperRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 7, InitializeRatekeeperRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 8, InitializeConsistencyScanRequest >*,InitializeConsistencyScanRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 8, InitializeConsistencyScanRequest >*,InitializeConsistencyScanRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 8, InitializeConsistencyScanRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 9, InitializeBlobManagerRequest >*,InitializeBlobManagerRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 9, InitializeBlobManagerRequest >*,InitializeBlobManagerRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 9, InitializeBlobManagerRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 10, InitializeBlobMigratorRequest >*,InitializeBlobMigratorRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 10, InitializeBlobMigratorRequest >*,InitializeBlobMigratorRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 10, InitializeBlobMigratorRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 11, InitializeBackupRequest >*,InitializeBackupRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when11(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 11, InitializeBackupRequest >*,InitializeBackupRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when11(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 11, InitializeBackupRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 12, InitializeEncryptKeyProxyRequest >*,InitializeEncryptKeyProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when12(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 12, InitializeEncryptKeyProxyRequest >*,InitializeEncryptKeyProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when12(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 12, InitializeEncryptKeyProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 13, InitializeTLogRequest >*,InitializeTLogRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when13(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 13, InitializeTLogRequest >*,InitializeTLogRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when13(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 13, InitializeTLogRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 14, InitializeStorageRequest >*,InitializeStorageRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when14(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 14, InitializeStorageRequest >*,InitializeStorageRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when14(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 14, InitializeStorageRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 15, InitializeBlobWorkerRequest >*,InitializeBlobWorkerRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when15(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 15, InitializeBlobWorkerRequest >*,InitializeBlobWorkerRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when15(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 15, InitializeBlobWorkerRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 16, InitializeCommitProxyRequest >*,InitializeCommitProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when16(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 16, InitializeCommitProxyRequest >*,InitializeCommitProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when16(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 16, InitializeCommitProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 17, InitializeGrvProxyRequest >*,InitializeGrvProxyRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when17(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 17, InitializeGrvProxyRequest >*,InitializeGrvProxyRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when17(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 17, InitializeGrvProxyRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 18, InitializeResolverRequest >*,InitializeResolverRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when18(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 18, InitializeResolverRequest >*,InitializeResolverRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when18(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 18, InitializeResolverRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 19, InitializeLogRouterRequest >*,InitializeLogRouterRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when19(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 19, InitializeLogRouterRequest >*,InitializeLogRouterRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when19(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 19, InitializeLogRouterRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 20, CoordinationPingMessage >*,CoordinationPingMessage const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when20(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 20, CoordinationPingMessage >*,CoordinationPingMessage && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when20(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 20, CoordinationPingMessage >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 20);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 20);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 21, SetMetricsLogRateRequest >*,SetMetricsLogRateRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when21(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 21, SetMetricsLogRateRequest >*,SetMetricsLogRateRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when21(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 21, SetMetricsLogRateRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 21);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 21);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 22, EventLogRequest >*,EventLogRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when22(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 22, EventLogRequest >*,EventLogRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when22(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 22, EventLogRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 22);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 22);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 23, TraceBatchDumpRequest >*,TraceBatchDumpRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when23(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 23, TraceBatchDumpRequest >*,TraceBatchDumpRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when23(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 23, TraceBatchDumpRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 23);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 23);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 24, DiskStoreRequest >*,DiskStoreRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when24(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 24, DiskStoreRequest >*,DiskStoreRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when24(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 24, DiskStoreRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 24);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 24);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 25, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when25(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 25, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when25(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 25, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 25);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 25);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 26, WorkerSnapRequest >*,WorkerSnapRequest const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when26(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorSingleCallback< WorkerServerActor, 26, WorkerSnapRequest >*,WorkerSnapRequest && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when26(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_error(ActorSingleCallback< WorkerServerActor, 26, WorkerSnapRequest >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 26);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 26);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 27, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when27(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 27, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when27(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_error(ActorCallback< WorkerServerActor, 27, Void >*,Error err) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 27);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 27);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 28, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("workerServer", reinterpret_cast<unsigned long>(this), 28);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WorkerServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11loopBody1when28(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("workerServer", reinterpret_cast<unsigned long>(this), 28);

	}
	void a_callback_fire(ActorCallback< WorkerServerActor, 28, Void >*,Void && value) 
	{
		fdb_probe_actor_e