/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.Transaction;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public class WatchTest {
    public static void main(String[] stringArray) {
        FDB fDB = FDB.selectAPIVersion((int)740);
        try (Database database = fDB.open(stringArray[0]);){
            database.options().setLocationCacheSize(42L);
            try (Transaction transaction = database.createTransaction();){
                byte[] byArray = (byte[])transaction.get("a".getBytes()).join();
                System.out.println("`a' -> " + (byArray == null ? "<null>" : new String(byArray)));
                CompletableFuture completableFuture = transaction.watch("a".getBytes());
                System.err.println("Watch started...");
                transaction.commit().join();
                completableFuture.cancel(true);
                try {
                    completableFuture.join();
                    System.out.println("`a' changed");
                }
                catch (FDBException fDBException) {
                    System.out.println("`a' watch error -> " + fDBException.getMessage());
                    if (fDBException.getCode() != 1101) {
                        throw fDBException;
                    }
                }
            }
            WatchTest.raceTest(database);
        }
    }

    public static void raceTest(Database database) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        Random random = new Random();
        try (Transaction transaction = database.createTransaction();){
            byte[] byArray = "hello".getBytes();
            for (int i = 0; i < 10000; ++i) {
                CompletableFuture completableFuture = transaction.watch(byArray);
                AtomicInteger atomicInteger = new AtomicInteger();
                Runnable runnable = () -> {
                    System.err.println("`f' cancel()...");
                    completableFuture.cancel(true);
                    atomicInteger.incrementAndGet();
                };
                Runnable runnable2 = () -> {
                    try {
                        System.err.println("`f' get()...");
                        completableFuture.join();
                        System.err.println("`f' changed");
                    }
                    catch (FDBException fDBException) {
                        System.err.println("`f' watch error -> " + fDBException.getMessage());
                        if (fDBException.getCode() != 1101) {
                            throw fDBException;
                        }
                    }
                    finally {
                        atomicInteger.incrementAndGet();
                    }
                };
                if (random.nextBoolean()) {
                    executorService.execute(runnable);
                    executorService.execute(runnable2);
                } else {
                    executorService.execute(runnable2);
                    executorService.execute(runnable);
                }
                while (atomicInteger.get() != 2) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                System.out.println("Done with " + i);
            }
        }
    }

    private WatchTest() {
    }
}

