#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
/*
 * RemoveCluster.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_REMOVECLUSTER_ACTOR_G_H)
#define METACLUSTER_REMOVECLUSTER_ACTOR_G_H
#include "metacluster/RemoveCluster.actor.g.h"
#elif !defined(METACLUSTER_REMOVECLUSTER_ACTOR_H)
#define METACLUSTER_REMOVECLUSTER_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/ConfigureCluster.h"
#include "metacluster/MetaclusterInternal.actor.h"
#include "metacluster/MetaclusterOperationContext.actor.h"
#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

FDB_BOOLEAN_PARAM(ForceRemove);

namespace internal {
template <class DB>
struct RemoveClusterImpl {
	MetaclusterOperationContext<DB> ctx;

	// Initialization parameters
	Reference<DB> db;
	ClusterType clusterType;
	ClusterName clusterName;
	ForceRemove forceRemove;
	double dataClusterTimeout;

	// Optional parameters that are set by internal users
	Optional<UID> clusterId;
	std::set<DataClusterState> legalClusterStates;

	// Parameters set in markClusterRemoving
	Optional<int64_t> lastTenantId;

	// Output parameter indicating whether the data cluster was updated during the removal
	bool dataClusterUpdated = false;

	RemoveClusterImpl(Reference<DB> db,
	                  ClusterName clusterName,
	                  ClusterType clusterType,
	                  ForceRemove forceRemove,
	                  double dataClusterTimeout)
	  : ctx(db,
	        Optional<ClusterName>(),
	        { DataClusterState::REGISTERING, DataClusterState::REMOVING, DataClusterState::RESTORING }),
	    db(db), clusterType(clusterType), clusterName(clusterName), forceRemove(forceRemove),
	    dataClusterTimeout(dataClusterTimeout) {}

	// Returns false if the cluster is no longer present, or true if it is present and the removal should proceed.
																#line 79 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via markClusterRemoving()
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class MarkClusterRemovingActor>
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class MarkClusterRemovingActorState {
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	MarkClusterRemovingActorState(RemoveClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : self(self),
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   tr(tr)
															#line 94 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("markClusterRemoving", reinterpret_cast<unsigned long>(this));

	}
	~MarkClusterRemovingActorState() 
	{
		fdb_probe_actor_destroy("markClusterRemoving", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<DataClusterMetadata> __when_expr_0 = getClusterTransaction(tr, self->clusterName);
															#line 78 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state = 1;
															#line 78 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkClusterRemovingActor, 0, DataClusterMetadata >*>(static_cast<MarkClusterRemovingActor*>(this)));
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkClusterRemovingActorState();
		static_cast<MarkClusterRemovingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 79 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		StrictFuture<Void> __when_expr_1 = self->ctx.setCluster(tr, self->clusterName);
															#line 79 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 141 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state = 2;
															#line 79 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MarkClusterRemovingActor, 1, Void >*>(static_cast<MarkClusterRemovingActor*>(this)));
															#line 146 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(DataClusterMetadata const& __clusterMetadata,int loopDepth) 
	{
															#line 78 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		clusterMetadata = __clusterMetadata;
															#line 155 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DataClusterMetadata && __clusterMetadata,int loopDepth) 
	{
		clusterMetadata = std::move(__clusterMetadata);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state > 0) static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state = 0;
		static_cast<MarkClusterRemovingActor*>(this)->ActorCallback< MarkClusterRemovingActor, 0, DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< MarkClusterRemovingActor, 0, DataClusterMetadata >*,DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkClusterRemovingActor, 0, DataClusterMetadata >*,DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkClusterRemovingActor, 0, DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if ((self->clusterId.present() && clusterMetadata.entry.id != self->clusterId.get()) || (!self->legalClusterStates.empty() && !self->legalClusterStates.count(clusterMetadata.entry.clusterState)))
															#line 234 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 86 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Remove cluster terminating due to invalid state");
															#line 87 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			return a_body1Catch1(operation_failed(), loopDepth);
															#line 240 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!self->forceRemove && self->ctx.dataClusterMetadata.get().entry.allocated.numTenantGroups > 0)
															#line 244 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 91 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Remove nonempty cluster");
															#line 92 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			return a_body1Catch1(cluster_not_empty(), loopDepth);
															#line 250 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
		else
		{
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (self->ctx.dataClusterMetadata.get().entry.clusterState != DataClusterState::REMOVING)
															#line 256 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 96 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				DataClusterEntry updatedEntry = self->ctx.dataClusterMetadata.get().entry;
															#line 97 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				updatedEntry.clusterState = DataClusterState::REMOVING;
															#line 98 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				updatedEntry.capacity.numTenantGroups = 0;
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				metadata::activeRestoreIds().erase(tr, self->clusterName);
															#line 102 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				updateClusterMetadata(tr, self->ctx.clusterName.get(), self->ctx.dataClusterMetadata.get(), Optional<ClusterConnectionString>(), updatedEntry);
															#line 268 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			}
		}
															#line 109 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		metadata::management::clusterCapacityIndex().erase( tr, Tuple::makeTuple(self->ctx.dataClusterMetadata.get().entry.allocated.numTenantGroups, self->ctx.clusterName.get()));
															#line 115 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (self->forceRemove)
															#line 275 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Force remove cluster");
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<Optional<int64_t>> __when_expr_2 = metadata::management::tenantMetadata().lastTenantId.get(tr);
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 283 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state = 3;
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >*>(static_cast<MarkClusterRemovingActor*>(this)));
															#line 288 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 81 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if ((self->clusterId.present() && clusterMetadata.entry.id != self->clusterId.get()) || (!self->legalClusterStates.empty() && !self->legalClusterStates.count(clusterMetadata.entry.clusterState)))
															#line 302 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 86 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Remove cluster terminating due to invalid state");
															#line 87 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			return a_body1Catch1(operation_failed(), loopDepth);
															#line 308 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!self->forceRemove && self->ctx.dataClusterMetadata.get().entry.allocated.numTenantGroups > 0)
															#line 312 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 91 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Remove nonempty cluster");
															#line 92 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			return a_body1Catch1(cluster_not_empty(), loopDepth);
															#line 318 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
		else
		{
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (self->ctx.dataClusterMetadata.get().entry.clusterState != DataClusterState::REMOVING)
															#line 324 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 96 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				DataClusterEntry updatedEntry = self->ctx.dataClusterMetadata.get().entry;
															#line 97 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				updatedEntry.clusterState = DataClusterState::REMOVING;
															#line 98 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				updatedEntry.capacity.numTenantGroups = 0;
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				metadata::activeRestoreIds().erase(tr, self->clusterName);
															#line 102 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				updateClusterMetadata(tr, self->ctx.clusterName.get(), self->ctx.dataClusterMetadata.get(), Optional<ClusterConnectionString>(), updatedEntry);
															#line 336 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			}
		}
															#line 109 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		metadata::management::clusterCapacityIndex().erase( tr, Tuple::makeTuple(self->ctx.dataClusterMetadata.get().entry.allocated.numTenantGroups, self->ctx.clusterName.get()));
															#line 115 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (self->forceRemove)
															#line 343 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Force remove cluster");
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<Optional<int64_t>> __when_expr_2 = metadata::management::tenantMetadata().lastTenantId.get(tr);
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 351 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state = 3;
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >*>(static_cast<MarkClusterRemovingActor*>(this)));
															#line 356 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state > 0) static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state = 0;
		static_cast<MarkClusterRemovingActor*>(this)->ActorCallback< MarkClusterRemovingActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MarkClusterRemovingActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MarkClusterRemovingActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MarkClusterRemovingActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		TraceEvent("MarkedDataClusterRemoving").detail("Name", self->ctx.clusterName.get());
															#line 122 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<MarkClusterRemovingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkClusterRemovingActorState(); static_cast<MarkClusterRemovingActor*>(this)->destroy(); return 0; }
															#line 447 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<MarkClusterRemovingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkClusterRemovingActorState();
		static_cast<MarkClusterRemovingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Optional<int64_t> const& lastId,int loopDepth) 
	{
															#line 118 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		self->lastTenantId = lastId;
															#line 459 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<int64_t> && lastId,int loopDepth) 
	{
															#line 118 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		self->lastTenantId = lastId;
															#line 468 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<int64_t> const& lastId,int loopDepth) 
	{
		loopDepth = a_body1cont8(lastId, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<int64_t> && lastId,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(lastId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state > 0) static_cast<MarkClusterRemovingActor*>(this)->actor_wait_state = 0;
		static_cast<MarkClusterRemovingActor*>(this)->ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterImpl* self;
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 78 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	DataClusterMetadata clusterMetadata;
															#line 554 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via markClusterRemoving()
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class MarkClusterRemovingActor final : public Actor<Void>, public ActorCallback< MarkClusterRemovingActor, 0, DataClusterMetadata >, public ActorCallback< MarkClusterRemovingActor, 1, Void >, public ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >, public FastAllocated<MarkClusterRemovingActor>, public MarkClusterRemovingActorState<MarkClusterRemovingActor> {
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<MarkClusterRemovingActor>::operator new;
	using FastAllocated<MarkClusterRemovingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(571556331809898752UL, 3939934442488772608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkClusterRemovingActor, 0, DataClusterMetadata >;
friend struct ActorCallback< MarkClusterRemovingActor, 1, Void >;
friend struct ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >;
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	MarkClusterRemovingActor(RemoveClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr) 
															#line 578 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<Void>(),
		   MarkClusterRemovingActorState<MarkClusterRemovingActor>(self, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markClusterRemoving", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15175731269804087296UL, 10269872678135631104UL);
		ActorExecutionContextHelper __helper(static_cast<MarkClusterRemovingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markClusterRemoving");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markClusterRemoving", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkClusterRemovingActor, 0, DataClusterMetadata >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MarkClusterRemovingActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MarkClusterRemovingActor, 2, Optional<int64_t> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] static Future<Void> markClusterRemoving( RemoveClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr ) {
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<Void>(new MarkClusterRemovingActor(self, tr));
															#line 612 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 124 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"

	// Delete metacluster metadata from the data cluster
																#line 618 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via updateDataCluster()
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class Transaction, class UpdateDataClusterActor>
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class UpdateDataClusterActorState {
															#line 624 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	UpdateDataClusterActorState(RemoveClusterImpl* const& self,Reference<Transaction> const& tr,UID const& clusterId) 
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : self(self),
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   tr(tr),
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   clusterId(clusterId)
															#line 635 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("updateDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~UpdateDataClusterActorState() 
	{
		fdb_probe_actor_destroy("updateDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 128 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (self->ctx.dataClusterIsRegistered)
															#line 650 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 130 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				metadata::metaclusterRegistration().clear(tr);
															#line 131 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				metadata::activeRestoreIds().clear(tr);
															#line 132 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				TenantMetadata::tenantTombstones().clear(tr);
															#line 133 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				TenantMetadata::tombstoneCleanupData().clear(tr);
															#line 139 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				if (self->lastTenantId.present())
															#line 662 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				{
															#line 140 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
					StrictFuture<Optional<int64_t>> __when_expr_0 = TenantMetadata::lastTenantId().get(tr);
															#line 140 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
					if (static_cast<UpdateDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 668 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<UpdateDataClusterActor*>(this)->actor_wait_state = 1;
															#line 140 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateDataClusterActor, 0, Optional<int64_t> >*>(static_cast<UpdateDataClusterActor*>(this)));
															#line 673 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				CODE_PROBE(true, "Data cluster remove non-existent cluster");
															#line 685 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateDataClusterActorState();
		static_cast<UpdateDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 153 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		metadata::registrationTombstones().insert(tr, clusterId);
															#line 155 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		TraceEvent("RemovedMetaclusterRegistrationOnDataCluster") .detail("Name", self->clusterName) .detail("WasRegistered", self->ctx.dataClusterIsRegistered);
															#line 159 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<UpdateDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateDataClusterActorState(); static_cast<UpdateDataClusterActor*>(this)->destroy(); return 0; }
															#line 713 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<UpdateDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateDataClusterActorState();
		static_cast<UpdateDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<int64_t> const& lastId,int loopDepth) 
	{
															#line 141 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!lastId.present() || (TenantAPI::getTenantIdPrefix(lastId.get()) == TenantAPI::getTenantIdPrefix(self->lastTenantId.get()) && lastId.get() < self->lastTenantId.get()))
															#line 731 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 144 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Advance tenant ID on removed cluster");
															#line 145 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			TenantMetadata::lastTenantId().set(tr, self->lastTenantId.get());
															#line 737 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Optional<int64_t> && lastId,int loopDepth) 
	{
															#line 141 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!lastId.present() || (TenantAPI::getTenantIdPrefix(lastId.get()) == TenantAPI::getTenantIdPrefix(self->lastTenantId.get()) && lastId.get() < self->lastTenantId.get()))
															#line 747 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 144 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Advance tenant ID on removed cluster");
															#line 145 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			TenantMetadata::lastTenantId().set(tr, self->lastTenantId.get());
															#line 753 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<int64_t> const& lastId,int loopDepth) 
	{
		loopDepth = a_body1cont3(lastId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<int64_t> && lastId,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(lastId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateDataClusterActor*>(this)->actor_wait_state > 0) static_cast<UpdateDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateDataClusterActor*>(this)->ActorCallback< UpdateDataClusterActor, 0, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterActor, 0, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateDataClusterActor, 0, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateDataClusterActor, 0, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterImpl* self;
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Reference<Transaction> tr;
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	UID clusterId;
															#line 840 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via updateDataCluster()
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class Transaction>
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class UpdateDataClusterActor final : public Actor<Void>, public ActorCallback< UpdateDataClusterActor<Transaction>, 0, Optional<int64_t> >, public FastAllocated<UpdateDataClusterActor<Transaction>>, public UpdateDataClusterActorState<Transaction, UpdateDataClusterActor<Transaction>> {
															#line 847 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<UpdateDataClusterActor<Transaction>>::operator new;
	using FastAllocated<UpdateDataClusterActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13031407050329283328UL, 110194452558192128UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateDataClusterActor<Transaction>, 0, Optional<int64_t> >;
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	UpdateDataClusterActor(RemoveClusterImpl* const& self,Reference<Transaction> const& tr,UID const& clusterId) 
															#line 864 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<Void>(),
		   UpdateDataClusterActorState<Transaction, UpdateDataClusterActor<Transaction>>(self, tr, clusterId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2197521157004316928UL, 13725143648043971840UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateDataClusterActor<Transaction>, 0, Optional<int64_t> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class Transaction>
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] static Future<Void> updateDataCluster( RemoveClusterImpl* const& self, Reference<Transaction> const& tr, UID const& clusterId ) {
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<Void>(new UpdateDataClusterActor<Transaction>(self, tr, clusterId));
															#line 898 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"

	// Returns a pair of bools. The first will be true if all tenants have been purged, and the second will be true if
	// any tenants have been purged
																#line 905 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via purgeTenants()
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class PurgeTenantsActor>
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class PurgeTenantsActorState {
															#line 911 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	PurgeTenantsActorState(RemoveClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::pair<Tuple, Tuple> const& clusterTupleRange) 
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : self(self),
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   tr(tr),
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   clusterTupleRange(clusterTupleRange)
															#line 922 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("purgeTenants", reinterpret_cast<unsigned long>(this));

	}
	~PurgeTenantsActorState() 
	{
		fdb_probe_actor_destroy("purgeTenants", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 167 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			ASSERT(self->ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::REMOVING);
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			tenantEntriesFuture = metadata::management::clusterTenantIndex().getRange( tr, clusterTupleRange.first, clusterTupleRange.second, CLIENT_KNOBS->REMOVE_CLUSTER_TENANT_BATCH_SIZE);
															#line 174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<KeyBackedRangeResult<Tuple>> __when_expr_0 = tenantEntriesFuture;
															#line 174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<PurgeTenantsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 943 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PurgeTenantsActor*>(this)->actor_wait_state = 1;
															#line 174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PurgeTenantsActor, 0, KeyBackedRangeResult<Tuple> >*>(static_cast<PurgeTenantsActor*>(this)));
															#line 948 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PurgeTenantsActorState();
		static_cast<PurgeTenantsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 177 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		int64_t erasedTenants = 0;
															#line 178 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		for( Tuple entry : tenantEntries.results ) {
															#line 179 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			int64_t tenantId = entry.getInt(2);
															#line 180 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			ASSERT(entry.getString(0) == self->ctx.clusterName.get());
															#line 181 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (tenantId != TenantInfo::INVALID_TENANT)
															#line 979 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 182 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				++erasedTenants;
															#line 183 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				metadata::management::tenantMetadata().tenantMap.erase(tr, tenantId);
															#line 985 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			}
															#line 185 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			metadata::management::tenantMetadata().tenantNameIndex.erase(tr, entry.getString(1));
															#line 186 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			metadata::management::tenantMetadata().lastTenantModification.setVersionstamp(tr, Versionstamp(), 0);
															#line 991 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
															#line 190 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!tenantEntries.results.empty())
															#line 995 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 191 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			metadata::management::clusterTenantIndex().erase( tr, clusterTupleRange.first, Tuple::makeTuple(self->ctx.clusterName.get(), keyAfter(tenantEntries.results.rbegin()->getString(1))));
															#line 999 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
															#line 197 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		metadata::management::tenantMetadata().tenantCount.atomicOp(tr, -erasedTenants, MutationRef::AddValue);
															#line 198 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		metadata::management::clusterTenantCount().atomicOp( tr, self->ctx.clusterName.get(), -erasedTenants, MutationRef::AddValue);
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		CODE_PROBE(tenantEntries.more, "More tenants to purge");
															#line 202 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		CODE_PROBE(tenantEntries.results.empty(), "No tenants purged");
															#line 203 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<PurgeTenantsActor*>(this)->SAV<std::pair<bool, bool>>::futures) { (void)(std::make_pair(!tenantEntries.more, !tenantEntries.results.empty())); this->~PurgeTenantsActorState(); static_cast<PurgeTenantsActor*>(this)->destroy(); return 0; }
															#line 1011 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<PurgeTenantsActor*>(this)->SAV< std::pair<bool, bool> >::value()) std::pair<bool, bool>(std::make_pair(!tenantEntries.more, !tenantEntries.results.empty()));
		this->~PurgeTenantsActorState();
		static_cast<PurgeTenantsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<Tuple> const& __tenantEntries,int loopDepth) 
	{
															#line 174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		tenantEntries = __tenantEntries;
															#line 1023 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<Tuple> && __tenantEntries,int loopDepth) 
	{
		tenantEntries = std::move(__tenantEntries);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PurgeTenantsActor*>(this)->actor_wait_state > 0) static_cast<PurgeTenantsActor*>(this)->actor_wait_state = 0;
		static_cast<PurgeTenantsActor*>(this)->ActorCallback< PurgeTenantsActor, 0, KeyBackedRangeResult<Tuple> >::remove();

	}
	void a_callback_fire(ActorCallback< PurgeTenantsActor, 0, KeyBackedRangeResult<Tuple> >*,KeyBackedRangeResult<Tuple> const& value) 
	{
		fdb_probe_actor_enter("purgeTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PurgeTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("purgeTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PurgeTenantsActor, 0, KeyBackedRangeResult<Tuple> >*,KeyBackedRangeResult<Tuple> && value) 
	{
		fdb_probe_actor_enter("purgeTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PurgeTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("purgeTenants", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PurgeTenantsActor, 0, KeyBackedRangeResult<Tuple> >*,Error err) 
	{
		fdb_probe_actor_enter("purgeTenants", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PurgeTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("purgeTenants", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterImpl* self;
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	std::pair<Tuple, Tuple> clusterTupleRange;
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Future<KeyBackedRangeResult<Tuple>> tenantEntriesFuture;
															#line 174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	KeyBackedRangeResult<Tuple> tenantEntries;
															#line 1108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via purgeTenants()
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class PurgeTenantsActor final : public Actor<std::pair<bool, bool>>, public ActorCallback< PurgeTenantsActor, 0, KeyBackedRangeResult<Tuple> >, public FastAllocated<PurgeTenantsActor>, public PurgeTenantsActorState<PurgeTenantsActor> {
															#line 1113 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<PurgeTenantsActor>::operator new;
	using FastAllocated<PurgeTenantsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6001164388505618688UL, 2084979125744966144UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<bool, bool>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PurgeTenantsActor, 0, KeyBackedRangeResult<Tuple> >;
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	PurgeTenantsActor(RemoveClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::pair<Tuple, Tuple> const& clusterTupleRange) 
															#line 1130 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<std::pair<bool, bool>>(),
		   PurgeTenantsActorState<PurgeTenantsActor>(self, tr, clusterTupleRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("purgeTenants", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2605859284542550016UL, 2774724765029523712UL);
		ActorExecutionContextHelper __helper(static_cast<PurgeTenantsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("purgeTenants");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("purgeTenants", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PurgeTenantsActor, 0, KeyBackedRangeResult<Tuple> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] static Future<std::pair<bool, bool>> purgeTenants( RemoveClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr, std::pair<Tuple, Tuple> const& clusterTupleRange ) {
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<std::pair<bool, bool>>(new PurgeTenantsActor(self, tr, clusterTupleRange));
															#line 1162 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 205 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"

	// Returns true if all tenant groups have been purged
																#line 1168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via purgeTenantGroups()
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class PurgeTenantGroupsActor>
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class PurgeTenantGroupsActorState {
															#line 1174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	PurgeTenantGroupsActorState(RemoveClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::pair<Tuple, Tuple> const& clusterTupleRange) 
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : self(self),
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   tr(tr),
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   clusterTupleRange(clusterTupleRange)
															#line 1185 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("purgeTenantGroups", reinterpret_cast<unsigned long>(this));

	}
	~PurgeTenantGroupsActorState() 
	{
		fdb_probe_actor_destroy("purgeTenantGroups", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 210 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			ASSERT(self->ctx.dataClusterMetadata.get().entry.clusterState == DataClusterState::REMOVING);
															#line 213 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			tenantGroupEntriesFuture = metadata::management::clusterTenantGroupIndex().getRange( tr, clusterTupleRange.first, clusterTupleRange.second, CLIENT_KNOBS->REMOVE_CLUSTER_TENANT_BATCH_SIZE);
															#line 218 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<KeyBackedRangeResult<Tuple>> __when_expr_0 = tenantGroupEntriesFuture;
															#line 218 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<PurgeTenantGroupsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1206 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PurgeTenantGroupsActor*>(this)->actor_wait_state = 1;
															#line 218 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PurgeTenantGroupsActor, 0, KeyBackedRangeResult<Tuple> >*>(static_cast<PurgeTenantGroupsActor*>(this)));
															#line 1211 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PurgeTenantGroupsActorState();
		static_cast<PurgeTenantGroupsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 219 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		for( Tuple entry : tenantGroupEntries.results ) {
															#line 220 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			ASSERT(entry.getString(0) == self->ctx.clusterName.get());
															#line 221 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			TenantGroupName tenantGroup = entry.getString(1);
															#line 222 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			metadata::management::tenantMetadata().tenantGroupTenantIndex.erase( tr, Tuple::makeTuple(tenantGroup), Tuple::makeTuple(keyAfter(tenantGroup)));
															#line 224 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			metadata::management::tenantMetadata().tenantGroupMap.erase(tr, tenantGroup);
															#line 1242 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
															#line 227 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!tenantGroupEntries.results.empty())
															#line 1246 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 229 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			metadata::management::clusterTenantGroupIndex().erase( tr, clusterTupleRange.first, Tuple::makeTuple(self->ctx.clusterName.get(), keyAfter(tenantGroupEntries.results.rbegin()->getString(1))));
															#line 1250 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
															#line 236 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		CODE_PROBE(!tenantGroupEntries.more, "More tenant groups to purge");
															#line 237 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<PurgeTenantGroupsActor*>(this)->SAV<bool>::futures) { (void)(!tenantGroupEntries.more); this->~PurgeTenantGroupsActorState(); static_cast<PurgeTenantGroupsActor*>(this)->destroy(); return 0; }
															#line 1256 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<PurgeTenantGroupsActor*>(this)->SAV< bool >::value()) bool(!tenantGroupEntries.more);
		this->~PurgeTenantGroupsActorState();
		static_cast<PurgeTenantGroupsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<Tuple> const& __tenantGroupEntries,int loopDepth) 
	{
															#line 218 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		tenantGroupEntries = __tenantGroupEntries;
															#line 1268 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<Tuple> && __tenantGroupEntries,int loopDepth) 
	{
		tenantGroupEntries = std::move(__tenantGroupEntries);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PurgeTenantGroupsActor*>(this)->actor_wait_state > 0) static_cast<PurgeTenantGroupsActor*>(this)->actor_wait_state = 0;
		static_cast<PurgeTenantGroupsActor*>(this)->ActorCallback< PurgeTenantGroupsActor, 0, KeyBackedRangeResult<Tuple> >::remove();

	}
	void a_callback_fire(ActorCallback< PurgeTenantGroupsActor, 0, KeyBackedRangeResult<Tuple> >*,KeyBackedRangeResult<Tuple> const& value) 
	{
		fdb_probe_actor_enter("purgeTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PurgeTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("purgeTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PurgeTenantGroupsActor, 0, KeyBackedRangeResult<Tuple> >*,KeyBackedRangeResult<Tuple> && value) 
	{
		fdb_probe_actor_enter("purgeTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PurgeTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("purgeTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PurgeTenantGroupsActor, 0, KeyBackedRangeResult<Tuple> >*,Error err) 
	{
		fdb_probe_actor_enter("purgeTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PurgeTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("purgeTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterImpl* self;
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	std::pair<Tuple, Tuple> clusterTupleRange;
															#line 213 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Future<KeyBackedRangeResult<Tuple>> tenantGroupEntriesFuture;
															#line 218 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	KeyBackedRangeResult<Tuple> tenantGroupEntries;
															#line 1353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via purgeTenantGroups()
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class PurgeTenantGroupsActor final : public Actor<bool>, public ActorCallback< PurgeTenantGroupsActor, 0, KeyBackedRangeResult<Tuple> >, public FastAllocated<PurgeTenantGroupsActor>, public PurgeTenantGroupsActorState<PurgeTenantGroupsActor> {
															#line 1358 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<PurgeTenantGroupsActor>::operator new;
	using FastAllocated<PurgeTenantGroupsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4254188074762285824UL, 4389766991770185216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PurgeTenantGroupsActor, 0, KeyBackedRangeResult<Tuple> >;
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	PurgeTenantGroupsActor(RemoveClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::pair<Tuple, Tuple> const& clusterTupleRange) 
															#line 1375 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<bool>(),
		   PurgeTenantGroupsActorState<PurgeTenantGroupsActor>(self, tr, clusterTupleRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("purgeTenantGroups", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9164521940635293440UL, 15818936665710835200UL);
		ActorExecutionContextHelper __helper(static_cast<PurgeTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("purgeTenantGroups");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("purgeTenantGroups", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PurgeTenantGroupsActor, 0, KeyBackedRangeResult<Tuple> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] static Future<bool> purgeTenantGroups( RemoveClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr, std::pair<Tuple, Tuple> const& clusterTupleRange ) {
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<bool>(new PurgeTenantGroupsActor(self, tr, clusterTupleRange));
															#line 1407 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 239 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"

	// Removes the data cluster entry from the management cluster
	void removeDataClusterEntry(Reference<typename DB::TransactionT> tr) {
		metadata::management::dataClusters().erase(tr, ctx.clusterName.get());
		metadata::management::dataClusterConnectionRecords().erase(tr, ctx.clusterName.get());
		metadata::management::clusterTenantCount().erase(tr, ctx.clusterName.get());
	}

	// Removes the next set of metadata from the management cluster; returns true when all specified
	// metadata is removed
																#line 1421 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via managementClusterPurgeSome()
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class ManagementClusterPurgeSomeActor>
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class ManagementClusterPurgeSomeActorState {
															#line 1427 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	ManagementClusterPurgeSomeActorState(RemoveClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::pair<Tuple, Tuple> const& clusterTupleRange,bool* const& deleteTenants) 
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : self(self),
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   tr(tr),
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   clusterTupleRange(clusterTupleRange),
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   deleteTenants(deleteTenants)
															#line 1440 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this));

	}
	~ManagementClusterPurgeSomeActorState() 
	{
		fdb_probe_actor_destroy("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (deleteTenants)
															#line 1455 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 254 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				StrictFuture<std::pair<bool, bool>> __when_expr_0 = purgeTenants(self, tr, clusterTupleRange);
															#line 254 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				if (static_cast<ManagementClusterPurgeSomeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1461 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ManagementClusterPurgeSomeActor*>(this)->actor_wait_state = 1;
															#line 254 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ManagementClusterPurgeSomeActor, 0, std::pair<bool, bool> >*>(static_cast<ManagementClusterPurgeSomeActor*>(this)));
															#line 1466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ManagementClusterPurgeSomeActorState();
		static_cast<ManagementClusterPurgeSomeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 264 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		StrictFuture<bool> __when_expr_1 = purgeTenantGroups(self, tr, clusterTupleRange);
															#line 264 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (static_cast<ManagementClusterPurgeSomeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1496 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ManagementClusterPurgeSomeActor*>(this)->actor_wait_state = 2;
															#line 264 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementClusterPurgeSomeActor, 1, bool >*>(static_cast<ManagementClusterPurgeSomeActor*>(this)));
															#line 1501 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(std::pair<bool, bool> const& deleteResult,int loopDepth) 
	{
															#line 256 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!deleteResult.first)
															#line 1510 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 257 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (!static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ManagementClusterPurgeSomeActorState(); static_cast<ManagementClusterPurgeSomeActor*>(this)->destroy(); return 0; }
															#line 1514 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			new (&static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ManagementClusterPurgeSomeActorState();
			static_cast<ManagementClusterPurgeSomeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 261 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		*deleteTenants = deleteResult.second;
															#line 1522 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::pair<bool, bool> && deleteResult,int loopDepth) 
	{
															#line 256 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!deleteResult.first)
															#line 1531 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 257 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (!static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ManagementClusterPurgeSomeActorState(); static_cast<ManagementClusterPurgeSomeActor*>(this)->destroy(); return 0; }
															#line 1535 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			new (&static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ManagementClusterPurgeSomeActorState();
			static_cast<ManagementClusterPurgeSomeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 261 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		*deleteTenants = deleteResult.second;
															#line 1543 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<bool, bool> const& deleteResult,int loopDepth) 
	{
		loopDepth = a_body1cont2(deleteResult, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::pair<bool, bool> && deleteResult,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(deleteResult), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ManagementClusterPurgeSomeActor*>(this)->actor_wait_state > 0) static_cast<ManagementClusterPurgeSomeActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementClusterPurgeSomeActor*>(this)->ActorCallback< ManagementClusterPurgeSomeActor, 0, std::pair<bool, bool> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementClusterPurgeSomeActor, 0, std::pair<bool, bool> >*,std::pair<bool, bool> const& value) 
	{
		fdb_probe_actor_enter("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeSomeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ManagementClusterPurgeSomeActor, 0, std::pair<bool, bool> >*,std::pair<bool, bool> && value) 
	{
		fdb_probe_actor_enter("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeSomeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ManagementClusterPurgeSomeActor, 0, std::pair<bool, bool> >*,Error err) 
	{
		fdb_probe_actor_enter("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeSomeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(bool const& deletedAllTenantGroups,int loopDepth) 
	{
															#line 265 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!deletedAllTenantGroups)
															#line 1627 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 266 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (!static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ManagementClusterPurgeSomeActorState(); static_cast<ManagementClusterPurgeSomeActor*>(this)->destroy(); return 0; }
															#line 1631 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			new (&static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ManagementClusterPurgeSomeActorState();
			static_cast<ManagementClusterPurgeSomeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 269 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ManagementClusterPurgeSomeActorState(); static_cast<ManagementClusterPurgeSomeActor*>(this)->destroy(); return 0; }
															#line 1639 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ManagementClusterPurgeSomeActorState();
		static_cast<ManagementClusterPurgeSomeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(bool && deletedAllTenantGroups,int loopDepth) 
	{
															#line 265 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!deletedAllTenantGroups)
															#line 1651 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 266 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (!static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ManagementClusterPurgeSomeActorState(); static_cast<ManagementClusterPurgeSomeActor*>(this)->destroy(); return 0; }
															#line 1655 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			new (&static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV< bool >::value()) bool(false);
			this->~ManagementClusterPurgeSomeActorState();
			static_cast<ManagementClusterPurgeSomeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 269 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ManagementClusterPurgeSomeActorState(); static_cast<ManagementClusterPurgeSomeActor*>(this)->destroy(); return 0; }
															#line 1663 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<ManagementClusterPurgeSomeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ManagementClusterPurgeSomeActorState();
		static_cast<ManagementClusterPurgeSomeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& deletedAllTenantGroups,int loopDepth) 
	{
		loopDepth = a_body1cont5(deletedAllTenantGroups, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && deletedAllTenantGroups,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(deletedAllTenantGroups), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ManagementClusterPurgeSomeActor*>(this)->actor_wait_state > 0) static_cast<ManagementClusterPurgeSomeActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementClusterPurgeSomeActor*>(this)->ActorCallback< ManagementClusterPurgeSomeActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementClusterPurgeSomeActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeSomeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ManagementClusterPurgeSomeActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeSomeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ManagementClusterPurgeSomeActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeSomeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterImpl* self;
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	std::pair<Tuple, Tuple> clusterTupleRange;
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	bool* deleteTenants;
															#line 1754 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via managementClusterPurgeSome()
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class ManagementClusterPurgeSomeActor final : public Actor<bool>, public ActorCallback< ManagementClusterPurgeSomeActor, 0, std::pair<bool, bool> >, public ActorCallback< ManagementClusterPurgeSomeActor, 1, bool >, public FastAllocated<ManagementClusterPurgeSomeActor>, public ManagementClusterPurgeSomeActorState<ManagementClusterPurgeSomeActor> {
															#line 1759 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<ManagementClusterPurgeSomeActor>::operator new;
	using FastAllocated<ManagementClusterPurgeSomeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2210186603398683904UL, 2275247790852552960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ManagementClusterPurgeSomeActor, 0, std::pair<bool, bool> >;
friend struct ActorCallback< ManagementClusterPurgeSomeActor, 1, bool >;
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	ManagementClusterPurgeSomeActor(RemoveClusterImpl* const& self,Reference<typename DB::TransactionT> const& tr,std::pair<Tuple, Tuple> const& clusterTupleRange,bool* const& deleteTenants) 
															#line 1777 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<bool>(),
		   ManagementClusterPurgeSomeActorState<ManagementClusterPurgeSomeActor>(self, tr, clusterTupleRange, deleteTenants),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4547523827535090944UL, 14272978799413102592UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeSomeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("managementClusterPurgeSome");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("managementClusterPurgeSome", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ManagementClusterPurgeSomeActor, 0, std::pair<bool, bool> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ManagementClusterPurgeSomeActor, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] static Future<bool> managementClusterPurgeSome( RemoveClusterImpl* const& self, Reference<typename DB::TransactionT> const& tr, std::pair<Tuple, Tuple> const& clusterTupleRange, bool* const& deleteTenants ) {
															#line 249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<bool>(new ManagementClusterPurgeSomeActor(self, tr, clusterTupleRange, deleteTenants));
															#line 1810 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 271 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"

	// Remove all metadata associated with the data cluster from the management cluster
																#line 1816 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via managementClusterPurgeDataCluster()
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class ManagementClusterPurgeDataClusterActor>
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class ManagementClusterPurgeDataClusterActorState {
															#line 1822 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	ManagementClusterPurgeDataClusterActorState(RemoveClusterImpl* const& self) 
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : self(self),
															#line 274 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   clusterTupleRange(std::make_pair( Tuple::makeTuple(self->ctx.clusterName.get()), Tuple::makeTuple(keyAfter(self->ctx.clusterName.get())))),
															#line 277 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   deleteTenants(true)
															#line 1833 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this));

	}
	~ManagementClusterPurgeDataClusterActorState() 
	{
		fdb_probe_actor_destroy("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Purging data cluster");
															#line 280 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			;
															#line 1850 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ManagementClusterPurgeDataClusterActorState();
		static_cast<ManagementClusterPurgeDataClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 292 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		StrictFuture<Void> __when_expr_1 = self->ctx.runManagementTransaction([self = self](Reference<typename DB::TransactionT> tr) { self->removeDataClusterEntry(tr); return Future<Void>(Void()); });
															#line 292 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (static_cast<ManagementClusterPurgeDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1875 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ManagementClusterPurgeDataClusterActor*>(this)->actor_wait_state = 2;
															#line 292 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementClusterPurgeDataClusterActor, 1, Void >*>(static_cast<ManagementClusterPurgeDataClusterActor*>(this)));
															#line 1880 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 281 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		StrictFuture<bool> __when_expr_0 = self->ctx.runManagementTransaction( [self = self, clusterTupleRange = clusterTupleRange, deleteTenants = &deleteTenants]( Reference<typename DB::TransactionT> tr) { return managementClusterPurgeSome(self, tr, clusterTupleRange, deleteTenants); });
															#line 281 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (static_cast<ManagementClusterPurgeDataClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1898 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ManagementClusterPurgeDataClusterActor*>(this)->actor_wait_state = 1;
															#line 281 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ManagementClusterPurgeDataClusterActor, 0, bool >*>(static_cast<ManagementClusterPurgeDataClusterActor*>(this)));
															#line 1903 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool const& clearedAll,int loopDepth) 
	{
															#line 287 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (clearedAll)
															#line 1925 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(bool && clearedAll,int loopDepth) 
	{
															#line 287 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (clearedAll)
															#line 1937 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool const& clearedAll,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(clearedAll, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(bool && clearedAll,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(clearedAll), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ManagementClusterPurgeDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ManagementClusterPurgeDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementClusterPurgeDataClusterActor*>(this)->ActorCallback< ManagementClusterPurgeDataClusterActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementClusterPurgeDataClusterActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ManagementClusterPurgeDataClusterActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ManagementClusterPurgeDataClusterActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 297 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		TraceEvent("RemovedDataCluster").detail("Name", self->ctx.clusterName.get());
															#line 298 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<ManagementClusterPurgeDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ManagementClusterPurgeDataClusterActorState(); static_cast<ManagementClusterPurgeDataClusterActor*>(this)->destroy(); return 0; }
															#line 2026 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<ManagementClusterPurgeDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ManagementClusterPurgeDataClusterActorState();
		static_cast<ManagementClusterPurgeDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 297 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		TraceEvent("RemovedDataCluster").detail("Name", self->ctx.clusterName.get());
															#line 298 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<ManagementClusterPurgeDataClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ManagementClusterPurgeDataClusterActorState(); static_cast<ManagementClusterPurgeDataClusterActor*>(this)->destroy(); return 0; }
															#line 2040 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<ManagementClusterPurgeDataClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ManagementClusterPurgeDataClusterActorState();
		static_cast<ManagementClusterPurgeDataClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ManagementClusterPurgeDataClusterActor*>(this)->actor_wait_state > 0) static_cast<ManagementClusterPurgeDataClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementClusterPurgeDataClusterActor*>(this)->ActorCallback< ManagementClusterPurgeDataClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementClusterPurgeDataClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ManagementClusterPurgeDataClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ManagementClusterPurgeDataClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterImpl* self;
															#line 274 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	std::pair<Tuple, Tuple> clusterTupleRange;
															#line 277 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	bool deleteTenants;
															#line 2129 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via managementClusterPurgeDataCluster()
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class ManagementClusterPurgeDataClusterActor final : public Actor<Void>, public ActorCallback< ManagementClusterPurgeDataClusterActor, 0, bool >, public ActorCallback< ManagementClusterPurgeDataClusterActor, 1, Void >, public FastAllocated<ManagementClusterPurgeDataClusterActor>, public ManagementClusterPurgeDataClusterActorState<ManagementClusterPurgeDataClusterActor> {
															#line 2134 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<ManagementClusterPurgeDataClusterActor>::operator new;
	using FastAllocated<ManagementClusterPurgeDataClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6489639258744754688UL, 2619292307584570368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ManagementClusterPurgeDataClusterActor, 0, bool >;
friend struct ActorCallback< ManagementClusterPurgeDataClusterActor, 1, Void >;
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	ManagementClusterPurgeDataClusterActor(RemoveClusterImpl* const& self) 
															#line 2152 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<Void>(),
		   ManagementClusterPurgeDataClusterActorState<ManagementClusterPurgeDataClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2821971882779818240UL, 14250424915226317312UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterPurgeDataClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("managementClusterPurgeDataCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("managementClusterPurgeDataCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ManagementClusterPurgeDataClusterActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ManagementClusterPurgeDataClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] static Future<Void> managementClusterPurgeDataCluster( RemoveClusterImpl* const& self ) {
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<Void>(new ManagementClusterPurgeDataClusterActor(self));
															#line 2185 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 300 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"

	// Remove the metacluster registration entry on a data cluster without modifying the management cluster.
	// Useful when reconstructing a management cluster when the original is lost.
																#line 2192 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via dataClusterForgetMetacluster()
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class DataClusterForgetMetaclusterActor>
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class DataClusterForgetMetaclusterActorState {
															#line 2198 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	DataClusterForgetMetaclusterActorState(RemoveClusterImpl* const& self) 
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : self(self),
															#line 304 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   tr(self->db->createTransaction())
															#line 2207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this));

	}
	~DataClusterForgetMetaclusterActorState() 
	{
		fdb_probe_actor_destroy("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 305 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Data cluster forget metacluster");
															#line 307 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			;
															#line 2224 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DataClusterForgetMetaclusterActorState();
		static_cast<DataClusterForgetMetaclusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 309 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 310 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_0 = metadata::metaclusterRegistration().get(tr);
															#line 310 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2259 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 1;
															#line 310 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DataClusterForgetMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*>(static_cast<DataClusterForgetMetaclusterActor*>(this)));
															#line 2264 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 341 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 341 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2288 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 4;
															#line 341 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DataClusterForgetMetaclusterActor, 3, Void >*>(static_cast<DataClusterForgetMetaclusterActor*>(this)));
															#line 2293 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 313 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!metaclusterRegistrationEntry.present())
															#line 2308 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 314 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Data cluster already unregistered");
															#line 315 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (!static_cast<DataClusterForgetMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DataClusterForgetMetaclusterActorState(); static_cast<DataClusterForgetMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2314 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			new (&static_cast<DataClusterForgetMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~DataClusterForgetMetaclusterActorState();
			static_cast<DataClusterForgetMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 318 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (metaclusterRegistrationEntry.get().clusterType != ClusterType::METACLUSTER_DATA)
															#line 2322 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 319 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			TraceEvent(SevWarn, "CannotRemoveNonDataCluster") .detail("ClusterName", self->clusterName) .detail("MetaclusterRegistration", metaclusterRegistrationEntry.map(&MetaclusterRegistrationEntry::toString));
															#line 323 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Attempt to remove non-data cluster", probe::decoration::rare);
															#line 324 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			return a_body1loopBody1Catch1(invalid_metacluster_operation(), loopDepth);
															#line 2330 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (metaclusterRegistrationEntry.get().name != self->clusterName)
															#line 2334 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		{
															#line 328 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			TraceEvent(SevWarn, "CannotRemoveDataClusterWithNameMismatch") .detail("ExpectedName", self->clusterName) .detail("MetaclusterRegistration", metaclusterRegistrationEntry.map(&MetaclusterRegistrationEntry::toString));
															#line 332 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Attempt to remove data cluster using incorrect name", probe::decoration::rare);
															#line 333 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			return a_body1loopBody1Catch1(metacluster_mismatch(), loopDepth);
															#line 2342 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		}
															#line 336 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		StrictFuture<Void> __when_expr_1 = updateDataCluster(self, tr, metaclusterRegistrationEntry.get().id);
															#line 336 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2348 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 2;
															#line 336 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DataClusterForgetMetaclusterActor, 1, Void >*>(static_cast<DataClusterForgetMetaclusterActor*>(this)));
															#line 2353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> const& __metaclusterRegistrationEntry,int loopDepth) 
	{
															#line 310 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		metaclusterRegistrationEntry = __metaclusterRegistrationEntry;
															#line 2362 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<MetaclusterRegistrationEntry> && __metaclusterRegistrationEntry,int loopDepth) 
	{
		metaclusterRegistrationEntry = std::move(__metaclusterRegistrationEntry);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DataClusterForgetMetaclusterActor*>(this)->ActorCallback< DataClusterForgetMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< DataClusterForgetMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DataClusterForgetMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DataClusterForgetMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		StrictFuture<Void> __when_expr_2 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 337 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2443 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 337 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >*>(static_cast<DataClusterForgetMetaclusterActor*>(this)));
															#line 2448 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		StrictFuture<Void> __when_expr_2 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 337 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2459 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 3;
															#line 337 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >*>(static_cast<DataClusterForgetMetaclusterActor*>(this)));
															#line 2464 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DataClusterForgetMetaclusterActor*>(this)->ActorCallback< DataClusterForgetMetaclusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataClusterForgetMetaclusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DataClusterForgetMetaclusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DataClusterForgetMetaclusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<DataClusterForgetMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DataClusterForgetMetaclusterActorState(); static_cast<DataClusterForgetMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2548 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<DataClusterForgetMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DataClusterForgetMetaclusterActorState();
		static_cast<DataClusterForgetMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<DataClusterForgetMetaclusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DataClusterForgetMetaclusterActorState(); static_cast<DataClusterForgetMetaclusterActor*>(this)->destroy(); return 0; }
															#line 2560 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<DataClusterForgetMetaclusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DataClusterForgetMetaclusterActorState();
		static_cast<DataClusterForgetMetaclusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DataClusterForgetMetaclusterActor*>(this)->ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state > 0) static_cast<DataClusterForgetMetaclusterActor*>(this)->actor_wait_state = 0;
		static_cast<DataClusterForgetMetaclusterActor*>(this)->ActorCallback< DataClusterForgetMetaclusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DataClusterForgetMetaclusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DataClusterForgetMetaclusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DataClusterForgetMetaclusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterImpl* self;
															#line 304 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 310 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Optional<MetaclusterRegistrationEntry> metaclusterRegistrationEntry;
															#line 2736 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via dataClusterForgetMetacluster()
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class DataClusterForgetMetaclusterActor final : public Actor<Void>, public ActorCallback< DataClusterForgetMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >, public ActorCallback< DataClusterForgetMetaclusterActor, 1, Void >, public ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >, public ActorCallback< DataClusterForgetMetaclusterActor, 3, Void >, public FastAllocated<DataClusterForgetMetaclusterActor>, public DataClusterForgetMetaclusterActorState<DataClusterForgetMetaclusterActor> {
															#line 2741 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<DataClusterForgetMetaclusterActor>::operator new;
	using FastAllocated<DataClusterForgetMetaclusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5512245446080474624UL, 9643231924230767104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DataClusterForgetMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >;
friend struct ActorCallback< DataClusterForgetMetaclusterActor, 1, Void >;
friend struct ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >;
friend struct ActorCallback< DataClusterForgetMetaclusterActor, 3, Void >;
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	DataClusterForgetMetaclusterActor(RemoveClusterImpl* const& self) 
															#line 2761 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<Void>(),
		   DataClusterForgetMetaclusterActorState<DataClusterForgetMetaclusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12493144006811078400UL, 4412345528544485888UL);
		ActorExecutionContextHelper __helper(static_cast<DataClusterForgetMetaclusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dataClusterForgetMetacluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dataClusterForgetMetacluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DataClusterForgetMetaclusterActor, 0, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DataClusterForgetMetaclusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DataClusterForgetMetaclusterActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DataClusterForgetMetaclusterActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] static Future<Void> dataClusterForgetMetacluster( RemoveClusterImpl* const& self ) {
															#line 303 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<Void>(new DataClusterForgetMetaclusterActor(self));
															#line 2796 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 345 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"

																#line 2801 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via run()
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class RunActor>
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class RunActorState {
															#line 2807 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RunActorState(RemoveClusterImpl* const& self) 
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : self(self)
															#line 2814 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 348 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (self->clusterType == ClusterType::METACLUSTER_DATA)
															#line 2829 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 349 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				if (!self->forceRemove)
															#line 2833 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				{
															#line 350 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
					CODE_PROBE(true, "Data cluster forget metacluster without force", probe::decoration::rare);
															#line 351 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
					return a_body1Catch1(invalid_metacluster_operation(), loopDepth);
															#line 2839 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				}
															#line 354 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				StrictFuture<Void> __when_expr_0 = dataClusterForgetMetacluster(self);
															#line 354 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2845 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 354 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 2850 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 360 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<Void> __when_expr_1 = self->ctx.runManagementTransaction( [self = self](Reference<typename DB::TransactionT> tr) { return markClusterRemoving(self, tr); });
															#line 360 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2881 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 360 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunActor, 1, Void >*>(static_cast<RunActor*>(this)));
															#line 2886 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		self->dataClusterUpdated = true;
															#line 356 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 2903 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		self->dataClusterUpdated = true;
															#line 356 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 2917 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
															#line 371 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			Future<Void> f = self->ctx.runDataClusterTransaction( [self = self](Reference<ITransaction> tr) { return updateDataCluster(self, tr, self->ctx.metaclusterRegistration.get().id); }, RunOnDisconnectedCluster::True);
															#line 377 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (self->forceRemove && self->dataClusterTimeout > 0)
															#line 3007 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 378 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				f = timeoutError(f, self->dataClusterTimeout);
															#line 3011 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			}
															#line 381 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<Void> __when_expr_2 = f;
															#line 381 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1cont5Catch1(actor_cancelled(), loopDepth);
															#line 3017 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont5Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 3;
															#line 381 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 3022 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont5Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont5Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 365 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (e.code() != error_code_cluster_removed)
															#line 3038 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 366 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 3042 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			}
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		try {
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<Void> __when_expr_3 = managementClusterPurgeDataCluster(self);
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 3161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont8Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
			static_cast<RunActor*>(this)->actor_wait_state = 4;
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RunActor, 3, Void >*>(static_cast<RunActor*>(this)));
															#line 3166 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont8Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			CODE_PROBE(true, "Data cluster removal timed out");
															#line 387 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (e.code() == error_code_cluster_removed)
															#line 3184 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 388 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				self->dataClusterUpdated = true;
															#line 3188 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			}
			else
			{
															#line 389 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				if (e.code() != error_code_timed_out)
															#line 3194 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				{
															#line 390 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
					return a_body1Catch1(e, loopDepth);
															#line 3198 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
				}
			}
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		self->dataClusterUpdated = true;
															#line 3215 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		self->dataClusterUpdated = true;
															#line 3224 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont5Catch1(error, 0);
		} catch (...) {
			a_body1cont5Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
															#line 403 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<RunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunActorState(); static_cast<RunActor*>(this)->destroy(); return 0; }
															#line 3321 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<RunActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunActorState();
		static_cast<RunActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 399 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (e.code() != error_code_cluster_removed)
															#line 3334 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			{
															#line 400 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 3338 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			}
			loopDepth = a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RunActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RunActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont14cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterImpl* self;
															#line 3452 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via run()
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorCallback< RunActor, 1, Void >, public ActorCallback< RunActor, 2, Void >, public ActorCallback< RunActor, 3, Void >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 3457 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2706166279462858752UL, 8947874469321040896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorCallback< RunActor, 1, Void >;
friend struct ActorCallback< RunActor, 2, Void >;
friend struct ActorCallback< RunActor, 3, Void >;
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RunActor(RemoveClusterImpl* const& self) 
															#line 3477 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RunActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] static Future<Void> run( RemoveClusterImpl* const& self ) {
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<Void>(new RunActor(self));
															#line 3512 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 405 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Future<Void> run() { return run(this); }
};
} // namespace internal

															#line 3520 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
// This generated class is to be used only via removeCluster()
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class DB, class RemoveClusterActor>
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class RemoveClusterActorState {
															#line 3526 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterActorState(Reference<DB> const& db,ClusterName const& name,ClusterType const& clusterType,ForceRemove const& forceRemove,double const& dataClusterTimeout = 0) 
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		 : db(db),
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   name(name),
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   clusterType(clusterType),
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   forceRemove(forceRemove),
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   dataClusterTimeout(dataClusterTimeout),
															#line 415 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		   impl(db, name, clusterType, forceRemove, dataClusterTimeout)
															#line 3543 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
	{
		fdb_probe_actor_create("removeCluster", reinterpret_cast<unsigned long>(this));

	}
	~RemoveClusterActorState() 
	{
		fdb_probe_actor_destroy("removeCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			StrictFuture<Void> __when_expr_0 = impl.run();
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			if (static_cast<RemoveClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3560 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RemoveClusterActor*>(this)->actor_wait_state = 1;
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveClusterActor, 0, Void >*>(static_cast<RemoveClusterActor*>(this)));
															#line 3565 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 417 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<RemoveClusterActor*>(this)->SAV<bool>::futures) { (void)(impl.dataClusterUpdated); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 3588 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<RemoveClusterActor*>(this)->SAV< bool >::value()) bool(impl.dataClusterUpdated);
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 417 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
		if (!static_cast<RemoveClusterActor*>(this)->SAV<bool>::futures) { (void)(impl.dataClusterUpdated); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 3600 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		new (&static_cast<RemoveClusterActor*>(this)->SAV< bool >::value()) bool(impl.dataClusterUpdated);
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveClusterActor*>(this)->ActorCallback< RemoveClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	Reference<DB> db;
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	ClusterName name;
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	ClusterType clusterType;
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	ForceRemove forceRemove;
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	double dataClusterTimeout;
															#line 415 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	internal::RemoveClusterImpl<DB> impl;
															#line 3695 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
};
// This generated class is to be used only via removeCluster()
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class DB>
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
class RemoveClusterActor final : public Actor<bool>, public ActorCallback< RemoveClusterActor<DB>, 0, Void >, public FastAllocated<RemoveClusterActor<DB>>, public RemoveClusterActorState<DB, RemoveClusterActor<DB>> {
															#line 3702 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
public:
	using FastAllocated<RemoveClusterActor<DB>>::operator new;
	using FastAllocated<RemoveClusterActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3465296980721328128UL, 18294834766247650816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveClusterActor<DB>, 0, Void >;
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	RemoveClusterActor(Reference<DB> const& db,ClusterName const& name,ClusterType const& clusterType,ForceRemove const& forceRemove,double const& dataClusterTimeout = 0) 
															#line 3719 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
		 : Actor<bool>(),
		   RemoveClusterActorState<DB, RemoveClusterActor<DB>>(db, name, clusterType, forceRemove, dataClusterTimeout),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(812508501301004544UL, 4934221500031631872UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveClusterActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
template <class DB>
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
[[nodiscard]] Future<bool> removeCluster( Reference<DB> const& db, ClusterName const& name, ClusterType const& clusterType, ForceRemove const& forceRemove, double const& dataClusterTimeout = 0 ) {
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"
	return Future<bool>(new RemoveClusterActor<DB>(db, name, clusterType, forceRemove, dataClusterTimeout));
															#line 3753 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/RemoveCluster.actor.g.h"
}

#line 419 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/metacluster/include/metacluster/RemoveCluster.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif