#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
/*
 * BenchCallback.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "benchmark/benchmark.h"

#include <vector>

#include "fdbclient/FDBTypes.h"
#include "flow/flow.h"
#include "flow/ThreadHelper.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

															#line 33 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
namespace {
// This generated class is to be used only via increment()
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
template <size_t Size, class IncrementActor>
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
class IncrementActorState {
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
public:
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	IncrementActorState(Future<Void> const& f,uint32_t* const& sum) 
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		 : f(f),
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		   sum(sum),
															#line 33 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		   arr()
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
	{
		fdb_probe_actor_create("increment", reinterpret_cast<unsigned long>(this));

	}
	~IncrementActorState() 
	{
		fdb_probe_actor_destroy("increment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f;
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
			if (static_cast<IncrementActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncrementActor*>(this)->actor_wait_state = 1;
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementActor, 0, Void >*>(static_cast<IncrementActor*>(this)));
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 35 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		benchmark::DoNotOptimize(arr);
															#line 36 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		++(*sum);
															#line 37 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		if (!static_cast<IncrementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementActorState(); static_cast<IncrementActor*>(this)->destroy(); return 0; }
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		new (&static_cast<IncrementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 35 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		benchmark::DoNotOptimize(arr);
															#line 36 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		++(*sum);
															#line 37 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		if (!static_cast<IncrementActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementActorState(); static_cast<IncrementActor*>(this)->destroy(); return 0; }
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		new (&static_cast<IncrementActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementActorState();
		static_cast<IncrementActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementActor*>(this)->actor_wait_state > 0) static_cast<IncrementActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActor*>(this)->ActorCallback< IncrementActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	Future<Void> f;
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	uint32_t* sum;
															#line 33 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	std::array<uint8_t, Size> arr;
															#line 205 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
};
// This generated class is to be used only via increment()
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
template <size_t Size>
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
class IncrementActor final : public Actor<Void>, public ActorCallback< IncrementActor<Size>, 0, Void >, public FastAllocated<IncrementActor<Size>>, public IncrementActorState<Size, IncrementActor<Size>> {
															#line 212 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
public:
	using FastAllocated<IncrementActor<Size>>::operator new;
	using FastAllocated<IncrementActor<Size>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12175062215575062784UL, 17396130332444179712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementActor<Size>, 0, Void >;
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	IncrementActor(Future<Void> const& f,uint32_t* const& sum) 
															#line 229 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		 : Actor<Void>(),
		   IncrementActorState<Size, IncrementActor<Size>>(f, sum),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("increment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8333160961439996160UL, 13338264904658082560UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("increment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("increment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementActor<Size>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
template <size_t Size>
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
[[nodiscard]] static Future<Void> increment( Future<Void> const& f, uint32_t* const& sum ) {
															#line 31 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	return Future<Void>(new IncrementActor<Size>(f, sum));
															#line 264 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
}

#line 39 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"

															#line 269 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
namespace {
// This generated class is to be used only via benchCallbackActor()
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
template <size_t Size, class BenchCallbackActorActor>
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
class BenchCallbackActorActorState {
															#line 276 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
public:
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	BenchCallbackActorActorState(benchmark::State* const& benchState) 
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		 : benchState(benchState),
															#line 42 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		   actorCount(benchState->range(0)),
															#line 43 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		   sum()
															#line 287 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
	{
		fdb_probe_actor_create("benchCallbackActor", reinterpret_cast<unsigned long>(this));

	}
	~BenchCallbackActorActorState() 
	{
		fdb_probe_actor_destroy("benchCallbackActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
			;
															#line 302 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BenchCallbackActorActorState();
		static_cast<BenchCallbackActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 56 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		benchState->SetItemsProcessed(actorCount * static_cast<long>(benchState->iterations()));
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		benchState->SetBytesProcessed(actorCount * Size * static_cast<long>(benchState->iterations()));
															#line 58 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		if (!static_cast<BenchCallbackActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BenchCallbackActorActorState(); static_cast<BenchCallbackActorActor*>(this)->destroy(); return 0; }
															#line 329 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		new (&static_cast<BenchCallbackActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BenchCallbackActorActorState();
		static_cast<BenchCallbackActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 44 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		if (!(benchState->KeepRunning()))
															#line 348 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 45 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		sum = 0;
															#line 46 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		Promise<Void> trigger;
															#line 47 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		std::vector<Future<Void>> futures;
															#line 48 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		futures.reserve(actorCount);
															#line 49 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		for(int i = 0;i < actorCount;++i) {
															#line 50 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
			futures.push_back(increment<Size>(trigger.getFuture(), &sum));
															#line 364 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		}
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		trigger.send(Void());
															#line 53 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 53 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		if (static_cast<BenchCallbackActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 372 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<BenchCallbackActorActor*>(this)->actor_wait_state = 1;
															#line 53 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BenchCallbackActorActor, 0, Void >*>(static_cast<BenchCallbackActorActor*>(this)));
															#line 377 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 54 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		benchmark::DoNotOptimize(sum);
															#line 399 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 54 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
		benchmark::DoNotOptimize(sum);
															#line 408 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BenchCallbackActorActor*>(this)->actor_wait_state > 0) static_cast<BenchCallbackActorActor*>(this)->actor_wait_state = 0;
		static_cast<BenchCallbackActorActor*>(this)->ActorCallback< BenchCallbackActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchCallbackActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchCallbackActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchCallbackActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchCallbackActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BenchCallbackActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchCallbackActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchCallbackActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchCallbackActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BenchCallbackActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchCallbackActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchCallbackActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchCallbackActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	benchmark::State* benchState;
															#line 42 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	size_t actorCount;
															#line 43 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	uint32_t sum;
															#line 494 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
};
// This generated class is to be used only via benchCallbackActor()
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
template <size_t Size>
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
class BenchCallbackActorActor final : public Actor<Void>, public ActorCallback< BenchCallbackActorActor<Size>, 0, Void >, public FastAllocated<BenchCallbackActorActor<Size>>, public BenchCallbackActorActorState<Size, BenchCallbackActorActor<Size>> {
															#line 501 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
public:
	using FastAllocated<BenchCallbackActorActor<Size>>::operator new;
	using FastAllocated<BenchCallbackActorActor<Size>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7739970408921237760UL, 6964494023163719936UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BenchCallbackActorActor<Size>, 0, Void >;
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	BenchCallbackActorActor(benchmark::State* const& benchState) 
															#line 518 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
		 : Actor<Void>(),
		   BenchCallbackActorActorState<Size, BenchCallbackActorActor<Size>>(benchState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("benchCallbackActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11688989462973277952UL, 1429939530137126656UL);
		ActorExecutionContextHelper __helper(static_cast<BenchCallbackActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("benchCallbackActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("benchCallbackActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BenchCallbackActorActor<Size>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
template <size_t Size>
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
[[nodiscard]] static Future<Void> benchCallbackActor( benchmark::State* const& benchState ) {
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"
	return Future<Void>(new BenchCallbackActorActor<Size>(benchState));
															#line 553 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/flowbench/BenchCallback.actor.g.cpp"
}

#line 60 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/flowbench/BenchCallback.actor.cpp"

template <size_t Size>
static void bench_callback(benchmark::State& benchState) {
	onMainThread([&benchState]() { return benchCallbackActor<Size>(&benchState); }).blockUntilReady();
}

BENCHMARK_TEMPLATE(bench_callback, 1)->Range(1, 1 << 8)->ReportAggregatesOnly(true);
BENCHMARK_TEMPLATE(bench_callback, 32)->Range(1, 1 << 8)->ReportAggregatesOnly(true);
BENCHMARK_TEMPLATE(bench_callback, 1024)->Range(1, 1 << 8)->ReportAggregatesOnly(true);
