#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
/*
 * LeakTLogInterface.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>

#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/workloads/workloads.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct LeakTLogInterfaceWorkload : TestWorkload {
	static constexpr auto NAME = "LeakTLogInterface";
	TenantName tenantName;
	Reference<Tenant> tenant;
	Standalone<StringRef> fieldName;
	double testDuration;

	LeakTLogInterfaceWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		tenantName = getOption(options, "tenant"_sr, "DefaultTenant"_sr);
		fieldName = getOption(options, "key"_sr, "TLogInterface"_sr);
		testDuration = getOption(options, "testDuration"_sr, 10.0);
	}

	Future<Void> setup(Database const& cx) override {
		tenant = makeReference<Tenant>(cx, tenantName);
		return persistSerializedTLogInterface(this, cx);
	}

	Future<Void> start(Database const& cx) override { return timeout(updateLoop(this, cx), testDuration, Void()); }
	Future<bool> check(Database const& cx) override { return true; }
	virtual void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 53 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
// This generated class is to be used only via persistSerializedTLogInterface()
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
template <class PersistSerializedTLogInterfaceActor>
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
class PersistSerializedTLogInterfaceActorState {
															#line 59 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
public:
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	PersistSerializedTLogInterfaceActorState(LeakTLogInterfaceWorkload* const& self,Database const& cx) 
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		 : self(self),
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		   cx(cx),
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		   tr(cx, self->tenant)
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
	{
		fdb_probe_actor_create("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this));

	}
	~PersistSerializedTLogInterfaceActorState() 
	{
		fdb_probe_actor_destroy("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 53 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			;
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistSerializedTLogInterfaceActorState();
		static_cast<PersistSerializedTLogInterfaceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 54 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		ObjectWriter writer(IncludeVersion());
															#line 55 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		writer.serialize(self->dbInfo->get().logSystemConfig);
															#line 56 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		logSystemString = writer.toString();
															#line 119 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		try {
															#line 58 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			tr.set(self->fieldName, logSystemString);
															#line 59 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 59 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			if (static_cast<PersistSerializedTLogInterfaceActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 127 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistSerializedTLogInterfaceActor*>(this)->actor_wait_state = 1;
															#line 59 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistSerializedTLogInterfaceActor, 0, Void >*>(static_cast<PersistSerializedTLogInterfaceActor*>(this)));
															#line 132 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 63 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			if (static_cast<PersistSerializedTLogInterfaceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 156 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PersistSerializedTLogInterfaceActor*>(this)->actor_wait_state = 2;
															#line 63 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistSerializedTLogInterfaceActor, 1, Void >*>(static_cast<PersistSerializedTLogInterfaceActor*>(this)));
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		TraceEvent("LeakTLogInterface").detail("BytesWritten", logSystemString.size()).log();
															#line 61 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		if (!static_cast<PersistSerializedTLogInterfaceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistSerializedTLogInterfaceActorState(); static_cast<PersistSerializedTLogInterfaceActor*>(this)->destroy(); return 0; }
															#line 178 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		new (&static_cast<PersistSerializedTLogInterfaceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistSerializedTLogInterfaceActorState();
		static_cast<PersistSerializedTLogInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		TraceEvent("LeakTLogInterface").detail("BytesWritten", logSystemString.size()).log();
															#line 61 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		if (!static_cast<PersistSerializedTLogInterfaceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistSerializedTLogInterfaceActorState(); static_cast<PersistSerializedTLogInterfaceActor*>(this)->destroy(); return 0; }
															#line 192 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		new (&static_cast<PersistSerializedTLogInterfaceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistSerializedTLogInterfaceActorState();
		static_cast<PersistSerializedTLogInterfaceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistSerializedTLogInterfaceActor*>(this)->actor_wait_state > 0) static_cast<PersistSerializedTLogInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<PersistSerializedTLogInterfaceActor*>(this)->ActorCallback< PersistSerializedTLogInterfaceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistSerializedTLogInterfaceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistSerializedTLogInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistSerializedTLogInterfaceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistSerializedTLogInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistSerializedTLogInterfaceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistSerializedTLogInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistSerializedTLogInterfaceActor*>(this)->actor_wait_state > 0) static_cast<PersistSerializedTLogInterfaceActor*>(this)->actor_wait_state = 0;
		static_cast<PersistSerializedTLogInterfaceActor*>(this)->ActorCallback< PersistSerializedTLogInterfaceActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistSerializedTLogInterfaceActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistSerializedTLogInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistSerializedTLogInterfaceActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistSerializedTLogInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistSerializedTLogInterfaceActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistSerializedTLogInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	LeakTLogInterfaceWorkload* self;
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	Database cx;
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	Transaction tr;
															#line 56 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	Standalone<StringRef> logSystemString;
															#line 370 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
};
// This generated class is to be used only via persistSerializedTLogInterface()
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
class PersistSerializedTLogInterfaceActor final : public Actor<Void>, public ActorCallback< PersistSerializedTLogInterfaceActor, 0, Void >, public ActorCallback< PersistSerializedTLogInterfaceActor, 1, Void >, public FastAllocated<PersistSerializedTLogInterfaceActor>, public PersistSerializedTLogInterfaceActorState<PersistSerializedTLogInterfaceActor> {
															#line 375 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
public:
	using FastAllocated<PersistSerializedTLogInterfaceActor>::operator new;
	using FastAllocated<PersistSerializedTLogInterfaceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15941818216850622208UL, 3161440256744819712UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistSerializedTLogInterfaceActor, 0, Void >;
friend struct ActorCallback< PersistSerializedTLogInterfaceActor, 1, Void >;
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	PersistSerializedTLogInterfaceActor(LeakTLogInterfaceWorkload* const& self,Database const& cx) 
															#line 393 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		 : Actor<Void>(),
		   PersistSerializedTLogInterfaceActorState<PersistSerializedTLogInterfaceActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13647999951189281536UL, 17524929176711651328UL);
		ActorExecutionContextHelper __helper(static_cast<PersistSerializedTLogInterfaceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistSerializedTLogInterface");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistSerializedTLogInterface", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistSerializedTLogInterfaceActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistSerializedTLogInterfaceActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
[[nodiscard]] static Future<Void> persistSerializedTLogInterface( LeakTLogInterfaceWorkload* const& self, Database const& cx ) {
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	return Future<Void>(new PersistSerializedTLogInterfaceActor(self, cx));
															#line 426 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
}

#line 67 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"

																#line 431 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
// This generated class is to be used only via updateLoop()
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
template <class UpdateLoopActor>
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
class UpdateLoopActorState {
															#line 437 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	UpdateLoopActorState(LeakTLogInterfaceWorkload* const& self,Database const& cx) 
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		 : self(self),
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		   cx(cx)
															#line 446 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLoop", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLoopActorState() 
	{
		fdb_probe_actor_destroy("updateLoop", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
			;
															#line 461 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLoopActorState();
		static_cast<UpdateLoopActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		if (static_cast<UpdateLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 493 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateLoopActor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLoopActor, 0, Void >*>(static_cast<UpdateLoopActor*>(this)));
															#line 498 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		StrictFuture<Void> __when_expr_1 = persistSerializedTLogInterface(self, cx);
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		if (static_cast<UpdateLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 509 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateLoopActor*>(this)->actor_wait_state = 2;
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLoopActor, 1, Void >*>(static_cast<UpdateLoopActor*>(this)));
															#line 514 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		StrictFuture<Void> __when_expr_1 = persistSerializedTLogInterface(self, cx);
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		if (static_cast<UpdateLoopActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 525 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateLoopActor*>(this)->actor_wait_state = 2;
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateLoopActor, 1, Void >*>(static_cast<UpdateLoopActor*>(this)));
															#line 530 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLoopActor*>(this)->actor_wait_state > 0) static_cast<UpdateLoopActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLoopActor*>(this)->ActorCallback< UpdateLoopActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLoopActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLoopActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLoopActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLoop", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLoop", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateLoopActor*>(this)->actor_wait_state > 0) static_cast<UpdateLoopActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLoopActor*>(this)->ActorCallback< UpdateLoopActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLoopActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateLoopActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLoop", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateLoopActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLoop", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLoop", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	LeakTLogInterfaceWorkload* self;
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	Database cx;
															#line 701 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
};
// This generated class is to be used only via updateLoop()
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
class UpdateLoopActor final : public Actor<Void>, public ActorCallback< UpdateLoopActor, 0, Void >, public ActorCallback< UpdateLoopActor, 1, Void >, public FastAllocated<UpdateLoopActor>, public UpdateLoopActorState<UpdateLoopActor> {
															#line 706 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
public:
	using FastAllocated<UpdateLoopActor>::operator new;
	using FastAllocated<UpdateLoopActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7446802066643553024UL, 3819223132485282816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLoopActor, 0, Void >;
friend struct ActorCallback< UpdateLoopActor, 1, Void >;
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	UpdateLoopActor(LeakTLogInterfaceWorkload* const& self,Database const& cx) 
															#line 724 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLoopActorState<UpdateLoopActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLoop", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9579393013954343936UL, 12330677697627601152UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLoopActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLoop");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLoop", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLoopActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateLoopActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
[[nodiscard]] static Future<Void> updateLoop( LeakTLogInterfaceWorkload* const& self, Database const& cx ) {
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
	return Future<Void>(new UpdateLoopActor(self, cx));
															#line 757 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/LeakTLogInterface.actor.g.cpp"
}

#line 74 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/LeakTLogInterface.actor.cpp"
};

WorkloadFactory<LeakTLogInterfaceWorkload> LeakTLogInterfaceWorkload;
