#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
/*
 * DiskDurabilityTest.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cinttypes>
#include "fmt/format.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/IAsyncFile.h"
#include "fdbclient/FDBTypes.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct DiskDurabilityTest : TestWorkload {
	static constexpr auto NAME = "DiskDurabilityTest";
	bool enabled;
	std::string filename;
	KeyRange range, metrics;

	DiskDurabilityTest(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		filename = getOption(options, "filename"_sr, "durability_test.bin"_sr).toString();
		auto prefix = getOption(options, "prefix"_sr, "/DiskDurabilityTest/"_sr);
		range = prefixRange("S"_sr.withPrefix(prefix));
		metrics = prefixRange(prefix);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (enabled)
			return durabilityTest(this, cx);
		return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	static Value encodeValue(int64_t x) {
		x = bigEndian64(x);
		return StringRef((const uint8_t*)&x, sizeof(x));
	}
	Key encodeKey(int64_t x) const { return encodeValue(x).withPrefix(range.begin); }

	static int64_t decodeValue(ValueRef k) {
		ASSERT(k.size() == sizeof(int64_t));
		return bigEndian64(*(int64_t*)k.begin());
	}
	int64_t decodeKey(KeyRef k) const { return decodeValue(k.removePrefix(range.begin)); }

	static void encodePage(uint8_t* page, int64_t value) {
		int64_t* ipage = (int64_t*)page;
		for (int i = 0; i < 4096 / 8; i++)
			ipage[i] = value + i;
	}
	static int64_t decodePage(uint8_t* page) {
		int64_t* ipage = (int64_t*)page;
		for (int i = 0; i < 4096 / 8; i++)
			if (ipage[i] != ipage[0] + i)
				return 0;
		return ipage[0];
	}

																#line 78 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
// This generated class is to be used only via durabilityTest()
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
template <class DurabilityTestActor>
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
class DurabilityTestActorState {
															#line 84 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
public:
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	DurabilityTestActorState(DiskDurabilityTest* const& self,Database const& db) 
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		 : self(self),
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		   db(db)
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
	{
		fdb_probe_actor_create("durabilityTest", reinterpret_cast<unsigned long>(this));

	}
	~DurabilityTestActorState() 
	{
		fdb_probe_actor_destroy("durabilityTest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( self->filename, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNBUFFERED | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_LOCK, 0600);
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DurabilityTestActor*>(this)->actor_wait_state = 1;
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 0, Reference<IAsyncFile> >*>(static_cast<DurabilityTestActor*>(this)));
															#line 115 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DurabilityTestActorState();
		static_cast<DurabilityTestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 82 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		pagedata = std::vector<uint8_t>(4096 * 128);
															#line 83 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		page = (uint8_t*)((intptr_t(&pagedata[0]) | intptr_t(4095)) + 1);
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 144 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DurabilityTestActor*>(this)->actor_wait_state = 2;
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 1, int64_t >*>(static_cast<DurabilityTestActor*>(this)));
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __file,int loopDepth) 
	{
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		file = __file;
															#line 158 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 86 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		failed = false;
															#line 87 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		verifyPages = int();
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		tr = Transaction(db);
															#line 91 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		;
															#line 243 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& __size,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		size = __size;
															#line 252 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && __size,int loopDepth) 
	{
		size = std::move(__size);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (failed)
															#line 331 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		{
															#line 115 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			return a_body1Catch1(operation_failed(), loopDepth);
															#line 335 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		}
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		fmt::print("Verified {0}/{1} pages\n", verifyPages, size / 4096);
															#line 118 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		TraceEvent(SevInfo, "Verified").detail("Pages", verifyPages).detail("Of", size / 4096);
															#line 121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		first = true;
															#line 122 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		;
															#line 345 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			StrictFuture<RangeResult> __when_expr_2 = tr.getRange(self->range, GetRangeLimits(1000000));
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 364 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DurabilityTestActor*>(this)->actor_wait_state = 3;
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 2, RangeResult >*>(static_cast<DurabilityTestActor*>(this)));
															#line 369 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 406 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<DurabilityTestActor*>(this)->actor_wait_state = 5;
															#line 110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 4, Void >*>(static_cast<DurabilityTestActor*>(this)));
															#line 411 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(int loopDepth) 
	{
															#line 94 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		verifyPages = r.size();
															#line 95 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		i = int();
															#line 96 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		i = 0;
															#line 430 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(RangeResult const& __r,int loopDepth) 
	{
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		r = __r;
															#line 439 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(RangeResult && __r,int loopDepth) 
	{
		r = std::move(__r);
		loopDepth = a_body1cont2loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 96 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (!(i < r.size()))
															#line 531 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		{
			return a_body1cont2loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 97 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		StrictFuture<int> __when_expr_3 = file->read(page, 4096, self->decodeKey(r[i].key) * 4096);
															#line 97 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 539 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<DurabilityTestActor*>(this)->actor_wait_state = 4;
															#line 97 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 3, int >*>(static_cast<DurabilityTestActor*>(this)));
															#line 544 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont2loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 98 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (bytesRead != 4096 || self->decodePage(page) != self->decodeValue(r[i].value))
															#line 566 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		{
															#line 99 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			printf("ValidationError\n");
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			TraceEvent(SevError, "ValidationError") .detail("At", self->decodeKey(r[i].key)) .detail("Expected", self->decodeValue(r[i].value)) .detail("Found", self->decodePage(page)) .detail("Read", bytesRead);
															#line 105 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			failed = true;
															#line 574 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		}
															#line 96 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		i++;
															#line 578 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 98 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (bytesRead != 4096 || self->decodePage(page) != self->decodeValue(r[i].value))
															#line 587 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		{
															#line 99 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			printf("ValidationError\n");
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			TraceEvent(SevError, "ValidationError") .detail("At", self->decodeKey(r[i].key)) .detail("Expected", self->decodeValue(r[i].value)) .detail("Found", self->decodePage(page)) .detail("Read", bytesRead);
															#line 105 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			failed = true;
															#line 595 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		}
															#line 96 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		i++;
															#line 599 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 3, int >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 3, int >*,int const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 3, int >*,int && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 3, int >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		targetPages = std::vector<int64_t>();
															#line 124 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		for(int i = deterministicRandom()->randomInt(1, 100);i > 0 && targetPages.size() < size / 4096;i--) {
															#line 125 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			auto p = deterministicRandom()->randomInt(0, size / 4096);
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			if (std::find(targetPages.begin(), targetPages.end(), p) == targetPages.end())
															#line 783 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			{
															#line 127 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
				targetPages.push_back(p);
															#line 787 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			}
		}
															#line 129 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		for(int i = deterministicRandom()->randomInt(1, 4);i > 0;i--) {
															#line 130 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			targetPages.push_back(size / 4096);
															#line 131 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			size += 4096;
															#line 796 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		}
															#line 134 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		targetValues = std::vector<int64_t>(targetPages.size());
															#line 135 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		for( auto& v : targetValues ) {
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			v = deterministicRandom()->randomUniqueID().first();
															#line 804 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		}
															#line 138 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		tr.reset();
															#line 139 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		;
															#line 810 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(int loopDepth) 
	{
															#line 157 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		tr.reset();
															#line 158 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		rv = tr.getReadVersion();
															#line 160 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		std::vector<Future<Void>> fresults;
															#line 162 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		for(int i = 0;i < targetPages.size();i++) {
															#line 163 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			uint8_t* p = page + 4096 * i;
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			self->encodePage(p, targetValues[i]);
															#line 165 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			fresults.push_back(file->write(p, 4096, targetPages[i] * 4096));
															#line 831 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		}
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		StrictFuture<Void> __when_expr_8 = waitForAll(fresults);
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 837 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont1when1(__when_expr_8.get(), loopDepth); };
		static_cast<DurabilityTestActor*>(this)->actor_wait_state = 9;
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 8, Void >*>(static_cast<DurabilityTestActor*>(this)));
															#line 842 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 141 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			for(int i = 0;i < targetPages.size();i++) {
															#line 142 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
				tr.clear(self->encodeKey(targetPages[i]));
															#line 861 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			}
															#line 144 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			if (!first)
															#line 865 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			{
															#line 145 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_5 = tr.get("syncs"_sr.withPrefix(self->metrics.begin));
															#line 145 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
				if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 871 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont3loopBody1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3loopBody1loopBody1when1(__when_expr_5.get(), loopDepth); };
				static_cast<DurabilityTestActor*>(this)->actor_wait_state = 6;
															#line 145 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 5, Optional<Value> >*>(static_cast<DurabilityTestActor*>(this)));
															#line 876 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont3loopBody1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont3loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 154 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			StrictFuture<Void> __when_expr_7 = tr.onError(e);
															#line 154 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 918 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 2)); else return a_body1cont3loopBody1loopBody1Catch1when1(__when_expr_7.get(), loopDepth); };
			static_cast<DurabilityTestActor*>(this)->actor_wait_state = 8;
															#line 154 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 7, Void >*>(static_cast<DurabilityTestActor*>(this)));
															#line 923 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 151 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		StrictFuture<Void> __when_expr_6 = tr.commit();
															#line 151 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 940 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont3loopBody1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont3loopBody1loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<DurabilityTestActor*>(this)->actor_wait_state = 7;
															#line 151 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 6, Void >*>(static_cast<DurabilityTestActor*>(this)));
															#line 945 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont4(Optional<Value> const& v,int loopDepth) 
	{
															#line 146 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		int64_t count = v.present() ? self->decodeValue(v.get()) : 0;
															#line 147 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		count++;
															#line 148 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		tr.set("syncs"_sr.withPrefix(self->metrics.begin), self->encodeValue(count));
															#line 958 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont4(Optional<Value> && v,int loopDepth) 
	{
															#line 146 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		int64_t count = v.present() ? self->decodeValue(v.get()) : 0;
															#line 147 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		count++;
															#line 148 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		tr.set("syncs"_sr.withPrefix(self->metrics.begin), self->encodeValue(count));
															#line 971 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont4(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont4(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont3loopBody1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1cont3loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont3loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont3loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont3loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont3loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		StrictFuture<Void> __when_expr_9 = file->sync();
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1231 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont6when1(__when_expr_9.get(), loopDepth); };
		static_cast<DurabilityTestActor*>(this)->actor_wait_state = 10;
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 9, Void >*>(static_cast<DurabilityTestActor*>(this)));
															#line 1236 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		StrictFuture<Void> __when_expr_9 = file->sync();
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1247 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1cont6when1(__when_expr_9.get(), loopDepth); };
		static_cast<DurabilityTestActor*>(this)->actor_wait_state = 10;
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 9, Void >*>(static_cast<DurabilityTestActor*>(this)));
															#line 1252 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont3loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 172 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		;
															#line 1336 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 172 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		;
															#line 1345 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		loopDepth = a_body1cont3loopBody1cont8loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont3loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont3loopBody1cont9(int loopDepth) 
	{
															#line 183 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
		first = false;
															#line 1429 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1cont8loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1(int loopDepth) 
	{
		try {
															#line 174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			for(int i = 0;i < targetPages.size();i++) {
															#line 175 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
				tr.set(self->encodeKey(targetPages[i]), self->encodeValue(targetValues[i]));
															#line 1448 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			}
															#line 176 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			StrictFuture<Void> __when_expr_10 = tr.commit();
															#line 176 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1cont3loopBody1cont8loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1454 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont3loopBody1cont8loopBody1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont3loopBody1cont8loopBody1when1(__when_expr_10.get(), loopDepth); };
			static_cast<DurabilityTestActor*>(this)->actor_wait_state = 11;
															#line 176 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 10, Void >*>(static_cast<DurabilityTestActor*>(this)));
															#line 1459 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont3loopBody1cont8loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont3loopBody1cont8loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8break1(int loopDepth) 
	{
		try {
			return a_body1cont3loopBody1cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopBody1cont8loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 179 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			StrictFuture<Void> __when_expr_11 = tr.onError(e);
															#line 179 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			if (static_cast<DurabilityTestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1496 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), std::max(0, loopDepth - 2)); else return a_body1cont3loopBody1cont8loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
			static_cast<DurabilityTestActor*>(this)->actor_wait_state = 12;
															#line 179 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
			__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DurabilityTestActor, 11, Void >*>(static_cast<DurabilityTestActor*>(this)));
															#line 1501 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1cont3loopBody1cont8break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1cont3loopBody1cont8break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont3loopBody1cont8loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont3loopBody1cont8loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont3loopBody1cont8loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont3loopBody1cont8loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont3loopBody1cont8loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont3loopBody1cont8loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont8loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont8loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<DurabilityTestActor*>(this)->actor_wait_state > 0) static_cast<DurabilityTestActor*>(this)->actor_wait_state = 0;
		static_cast<DurabilityTestActor*>(this)->ActorCallback< DurabilityTestActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont3loopBody1cont8loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< DurabilityTestActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont3loopBody1cont8loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< DurabilityTestActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), 11);

	}
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	DiskDurabilityTest* self;
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	Database db;
															#line 77 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	Reference<IAsyncFile> file;
															#line 82 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	std::vector<uint8_t> pagedata;
															#line 83 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	uint8_t* page;
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	int64_t size;
															#line 86 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	bool failed;
															#line 87 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	int verifyPages;
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	Transaction tr;
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	RangeResult r;
															#line 95 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	int i;
															#line 121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	bool first;
															#line 123 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	std::vector<int64_t> targetPages;
															#line 134 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	std::vector<int64_t> targetValues;
															#line 158 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	Future<Version> rv;
															#line 1716 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
};
// This generated class is to be used only via durabilityTest()
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
class DurabilityTestActor final : public Actor<Void>, public ActorCallback< DurabilityTestActor, 0, Reference<IAsyncFile> >, public ActorCallback< DurabilityTestActor, 1, int64_t >, public ActorCallback< DurabilityTestActor, 2, RangeResult >, public ActorCallback< DurabilityTestActor, 3, int >, public ActorCallback< DurabilityTestActor, 4, Void >, public ActorCallback< DurabilityTestActor, 5, Optional<Value> >, public ActorCallback< DurabilityTestActor, 6, Void >, public ActorCallback< DurabilityTestActor, 7, Void >, public ActorCallback< DurabilityTestActor, 8, Void >, public ActorCallback< DurabilityTestActor, 9, Void >, public ActorCallback< DurabilityTestActor, 10, Void >, public ActorCallback< DurabilityTestActor, 11, Void >, public FastAllocated<DurabilityTestActor>, public DurabilityTestActorState<DurabilityTestActor> {
															#line 1721 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
public:
	using FastAllocated<DurabilityTestActor>::operator new;
	using FastAllocated<DurabilityTestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3608961795676809472UL, 16626606285576207616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DurabilityTestActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< DurabilityTestActor, 1, int64_t >;
friend struct ActorCallback< DurabilityTestActor, 2, RangeResult >;
friend struct ActorCallback< DurabilityTestActor, 3, int >;
friend struct ActorCallback< DurabilityTestActor, 4, Void >;
friend struct ActorCallback< DurabilityTestActor, 5, Optional<Value> >;
friend struct ActorCallback< DurabilityTestActor, 6, Void >;
friend struct ActorCallback< DurabilityTestActor, 7, Void >;
friend struct ActorCallback< DurabilityTestActor, 8, Void >;
friend struct ActorCallback< DurabilityTestActor, 9, Void >;
friend struct ActorCallback< DurabilityTestActor, 10, Void >;
friend struct ActorCallback< DurabilityTestActor, 11, Void >;
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	DurabilityTestActor(DiskDurabilityTest* const& self,Database const& db) 
															#line 1749 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
		 : Actor<Void>(),
		   DurabilityTestActorState<DurabilityTestActor>(self, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("durabilityTest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3731311549133058560UL, 13149092444771613696UL);
		ActorExecutionContextHelper __helper(static_cast<DurabilityTestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("durabilityTest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("durabilityTest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DurabilityTestActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DurabilityTestActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DurabilityTestActor, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DurabilityTestActor, 3, int >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DurabilityTestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DurabilityTestActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DurabilityTestActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DurabilityTestActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DurabilityTestActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DurabilityTestActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DurabilityTestActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< DurabilityTestActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
[[nodiscard]] static Future<Void> durabilityTest( DiskDurabilityTest* const& self, Database const& db ) {
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
	return Future<Void>(new DurabilityTestActor(self, db));
															#line 1792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DiskDurabilityTest.actor.g.cpp"
}

#line 186 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbserver/workloads/DiskDurabilityTest.actor.cpp"
};
WorkloadFactory<DiskDurabilityTest> DiskDurabilityTestFactory;
