#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
#include "fdbrpc/Base64Encode.h"
#include "fdbrpc/Base64Decode.h"
#include "fdbrpc/FlowTransport.h"
#include "fdbrpc/TokenCache.h"
#include "fdbrpc/TokenSign.h"
#include "fdbrpc/TenantInfo.h"
#include "flow/MkCert.h"
#include "flow/ScopeExit.h"
#include "flow/UnitTest.h"
#include "flow/network.h"

#include <rapidjson/document.h>
#include <rapidjson/writer.h>
#include <rapidjson/stringbuffer.h>

#include <boost/unordered_map.hpp>
#include <boost/unordered_set.hpp>

#include <fmt/format.h>
#include <fmt/ranges.h>
#include <list>
#include <deque>

#include "flow/actorcompiler.h" // has to be last include

using authz::TenantId;

template <class Key, class Value>
class LRUCache {
public:
	using key_type = Key;
	using list_type = std::list<key_type>;
	using mapped_type = Value;
	using map_type = boost::unordered_map<key_type, std::pair<mapped_type, typename list_type::iterator>>;
	using size_type = unsigned;

	explicit LRUCache(size_type capacity) : _capacity(capacity) { _map.reserve(capacity); }

	size_type size() const { return _map.size(); }
	size_type capacity() const { return _capacity; }
	bool empty() const { return _map.empty(); }

	Optional<mapped_type*> get(key_type const& key) {
		auto i = _map.find(key);
		if (i == _map.end()) {
			return Optional<mapped_type*>();
		}
		auto j = i->second.second;
		if (j != _list.begin()) {
			_list.erase(j);
			_list.push_front(i->first);
			i->second.second = _list.begin();
		}
		return &i->second.first;
	}

	template <class K, class V>
	mapped_type* insert(K&& key, V&& value) {
		auto iter = _map.find(key);
		if (iter != _map.end()) {
			return &iter->second.first;
		}
		if (size() == capacity()) {
			auto i = --_list.end();
			_map.erase(*i);
			_list.erase(i);
		}
		_list.push_front(std::forward<K>(key));
		std::tie(iter, std::ignore) =
		    _map.insert(std::make_pair(*_list.begin(), std::make_pair(std::forward<V>(value), _list.begin())));
		return &iter->second.first;
	}

private:
	const size_type _capacity;
	map_type _map;
	list_type _list;
};

															#line 82 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase80()
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
template <class FlowTestCase80Actor>
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
class FlowTestCase80ActorState {
															#line 89 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
public:
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	FlowTestCase80ActorState(UnitTestParameters const& params) 
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		 : params(params)
															#line 96 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase80", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase80ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase80", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 81 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			auto& rng = *deterministicRandom();
															#line 111 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			{
															#line 84 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				LRUCache<int, StringRef> cache(rng.randomInt(2, 10));
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				for(int i = 0;i < 200;++i) {
															#line 86 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					cache.insert(i, "val"_sr);
															#line 87 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					if (i >= cache.capacity())
															#line 121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
					{
															#line 88 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						for(auto j = 0;j <= i - cache.capacity();j++) {
															#line 89 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							ASSERT(!cache.get(j).present());
															#line 127 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
						}
															#line 91 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						for(auto j = i - cache.capacity() + 1;j <= i;j++) {
															#line 92 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							ASSERT(cache.get(j).present());
															#line 133 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
						}
					}
				}
			}
			{
															#line 98 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				LRUCache<int, StringRef> cache(1000);
															#line 99 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				for(auto i = 0;i < 1000;++i) {
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					cache.insert(i, "value"_sr);
															#line 145 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
				}
															#line 102 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				cache.insert(1000, "value"_sr);
															#line 103 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				ASSERT(!cache.get(0).present());
															#line 151 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			}
			{
															#line 107 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				LRUCache<StringRef, Standalone<StringRef>> cache(10);
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				std::deque<std::string> cachedStrings;
															#line 109 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				std::deque<std::string> evictedStrings;
															#line 110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				for(int i = 0;i < 10;++i) {
															#line 111 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					auto str = rng.randomAlphaNumeric(rng.randomInt(100, 1024));
															#line 112 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					Standalone<StringRef> sref(str);
															#line 113 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					cache.insert(sref, sref);
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					cachedStrings.push_back(str);
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
				}
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				for(int i = 0;i < 10;++i) {
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					Standalone<StringRef> existingStr(cachedStrings.back());
															#line 118 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					auto cachedStr = cache.get(existingStr);
															#line 119 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					ASSERT(cachedStr.present());
															#line 120 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					ASSERT(*cachedStr.get() == existingStr);
															#line 121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					if (!evictedStrings.empty())
															#line 184 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
					{
															#line 122 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						Standalone<StringRef> nonexisting(evictedStrings.at(rng.randomInt(0, evictedStrings.size())));
															#line 123 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						ASSERT(!cache.get(nonexisting).present());
															#line 190 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
					}
															#line 125 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					auto str = rng.randomAlphaNumeric(rng.randomInt(100, 1024));
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					Standalone<StringRef> sref(str);
															#line 127 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					evictedStrings.push_back(cachedStrings.front());
															#line 128 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					cachedStrings.pop_front();
															#line 129 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					cachedStrings.push_back(str);
															#line 130 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					cache.insert(sref, sref);
															#line 204 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
				}
			}
															#line 133 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			if (!static_cast<FlowTestCase80Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase80ActorState(); static_cast<FlowTestCase80Actor*>(this)->destroy(); return 0; }
															#line 209 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			new (&static_cast<FlowTestCase80Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase80ActorState();
			static_cast<FlowTestCase80Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase80ActorState();
		static_cast<FlowTestCase80Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	UnitTestParameters params;
															#line 233 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase80()
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
class FlowTestCase80Actor final : public Actor<Void>, public FastAllocated<FlowTestCase80Actor>, public FlowTestCase80ActorState<FlowTestCase80Actor> {
															#line 238 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase80Actor>::operator new;
	using FastAllocated<FlowTestCase80Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14566757269312743424UL, 12864039333978882304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	FlowTestCase80Actor(UnitTestParameters const& params) 
															#line 254 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase80ActorState<FlowTestCase80Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase80", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13551632821443589632UL, 815158233526912768UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase80Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase80");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase80", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
static Future<Void> flowTestCase80( UnitTestParameters const& params ) {
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	return Future<Void>(new FlowTestCase80Actor(params));
															#line 286 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase80, "/fdbrpc/authz/LRUCache")

#line 135 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"

struct CacheEntry {
	Arena arena;
	VectorRef<TenantId> tenants;
	Optional<StringRef> tokenId;
	double expirationTime = 0.0;
};

struct AuditEntry {
	NetworkAddress address;
	TenantId tenantId;
	Optional<Standalone<StringRef>> tokenId;
	bool operator==(const AuditEntry& other) const noexcept = default;
	explicit AuditEntry(NetworkAddress const& address, TenantId tenantId, CacheEntry const& cacheEntry)
	  : address(address), tenantId(tenantId),
	    tokenId(cacheEntry.tokenId.present() ? Standalone<StringRef>(cacheEntry.tokenId.get(), cacheEntry.arena)
	                                         : Optional<Standalone<StringRef>>()) {}
};

std::size_t hash_value(AuditEntry const& value) {
	std::size_t seed = 0;
	boost::hash_combine(seed, value.address);
	boost::hash_combine(seed, value.tenantId);
	if (value.tokenId.present()) {
		boost::hash_combine(seed, value.tokenId.get());
	}
	return seed;
}

struct TokenCacheImpl {
	TokenCacheImpl();
	LRUCache<StringRef, CacheEntry> cache;
	boost::unordered_set<AuditEntry> usedTokens;
	double lastResetTime;

	bool validate(TenantId tenantId, StringRef token);
	bool validateAndAdd(double currentTime, StringRef token, NetworkAddress const& peer);
	void logTokenUsage(double currentTime, AuditEntry&& entry);
};

TokenCacheImpl::TokenCacheImpl() : cache(FLOW_KNOBS->TOKEN_CACHE_SIZE), usedTokens(), lastResetTime(0) {}

TokenCache::TokenCache() : impl(new TokenCacheImpl()) {}
TokenCache::~TokenCache() {
	delete impl;
}

void TokenCache::createInstance() {
	g_network->setGlobal(INetwork::enTokenCache, new TokenCache());
}

TokenCache& TokenCache::instance() {
	return *reinterpret_cast<TokenCache*>(g_network->global(INetwork::enTokenCache));
}

bool TokenCache::validate(TenantId tenantId, StringRef token) {
	return impl->validate(tenantId, token);
}

#define TRACE_INVALID_PARSED_TOKEN(reason, token)                                                                      \
	TraceEvent(SevWarn, "InvalidToken"_audit)                                                                          \
	    .detail("From", peer)                                                                                          \
	    .detail("Reason", reason)                                                                                      \
	    .detail("CurrentTime", currentTime)                                                                            \
	    .detail("Token", toStringRef(arena, token).toStringView())

bool TokenCacheImpl::validateAndAdd(double currentTime, StringRef token, NetworkAddress const& peer) {
	Arena arena;
	authz::jwt::TokenRef t;
	StringRef signInput;
	Optional<StringRef> err;
	bool verifyOutcome;
	if ((err = authz::jwt::parseToken(arena, token, t, signInput)).present()) {
		CODE_PROBE(true, "Token can't be parsed");
		TraceEvent te(SevWarn, "InvalidToken");
		te.detail("From", peer);
		te.detail("Reason", "ParseError");
		te.detail("ErrorDetail", err.get());
		if (signInput.empty()) { // unrecognizable token structure
			te.detail("Token", token.toString());
		} else { // trace with signature part taken out
			te.detail("SignInput", signInput.toString());
		}
		return false;
	}
	auto key = FlowTransport::transport().getPublicKeyByName(t.keyId);
	if (!key.present()) {
		CODE_PROBE(true, "Token referencing non-existing key");
		TRACE_INVALID_PARSED_TOKEN("UnknownKey", t);
		return false;
	} else if (!t.issuedAtUnixTime.present()) {
		CODE_PROBE(true, "Token has no issued-at field");
		TRACE_INVALID_PARSED_TOKEN("NoIssuedAt", t);
		return false;
	} else if (!t.expiresAtUnixTime.present()) {
		CODE_PROBE(true, "Token has no expiration time");
		TRACE_INVALID_PARSED_TOKEN("NoExpirationTime", t);
		return false;
	} else if (double(t.expiresAtUnixTime.get()) <= currentTime) {
		CODE_PROBE(true, "Expired token");
		TRACE_INVALID_PARSED_TOKEN("Expired", t);
		return false;
	} else if (!t.notBeforeUnixTime.present()) {
		CODE_PROBE(true, "Token has no not-before field");
		TRACE_INVALID_PARSED_TOKEN("NoNotBefore", t);
		return false;
	} else if (double(t.notBeforeUnixTime.get()) > currentTime) {
		CODE_PROBE(true, "Token's not-before is in the future");
		TRACE_INVALID_PARSED_TOKEN("TokenNotYetValid", t);
		return false;
	} else if (!t.tenants.present()) {
		CODE_PROBE(true, "Token with no tenants");
		TRACE_INVALID_PARSED_TOKEN("NoTenants", t);
		return false;
	}
	std::tie(verifyOutcome, err) = authz::jwt::verifyToken(signInput, t, key.get());
	if (err.present()) {
		CODE_PROBE(true, "Error while verifying token");
		TRACE_INVALID_PARSED_TOKEN("ErrorWhileVerifyingToken", t).detail("ErrorDetail", err.get());
		return false;
	} else if (!verifyOutcome) {
		CODE_PROBE(true, "Token with invalid signature");
		TRACE_INVALID_PARSED_TOKEN("InvalidSignature", t);
		return false;
	} else {
		CacheEntry c;
		c.expirationTime = t.expiresAtUnixTime.get();
		c.tenants.reserve(c.arena, t.tenants.get().size());
		for (auto tenantId : t.tenants.get()) {
			c.tenants.push_back(c.arena, tenantId);
		}
		if (t.tokenId.present()) {
			c.tokenId = StringRef(c.arena, t.tokenId.get());
		}
		cache.insert(StringRef(c.arena, token), c);
		return true;
	}
}

bool TokenCacheImpl::validate(TenantId tenantId, StringRef token) {
	NetworkAddress peer = FlowTransport::transport().currentDeliveryPeerAddress();
	auto cachedEntry = cache.get(token);
	double currentTime = g_network->timer();

	if (!cachedEntry.present()) {
		if (validateAndAdd(currentTime, token, peer)) {
			cachedEntry = cache.get(token);
		} else {
			return false;
		}
	}

	ASSERT(cachedEntry.present());

	auto& entry = cachedEntry.get();
	if (entry->expirationTime < currentTime) {
		CODE_PROBE(true, "Found expired token in cache");
		TraceEvent(SevWarn, "InvalidToken"_audit).detail("From", peer).detail("Reason", "ExpiredInCache");
		return false;
	}
	bool tenantFound = false;
	for (auto const& t : entry->tenants) {
		if (t == tenantId) {
			tenantFound = true;
			break;
		}
	}
	if (!tenantFound) {
		CODE_PROBE(true, "Valid token doesn't reference tenant");
		TraceEvent(SevWarn, "InvalidToken"_audit)
		    .detail("From", peer)
		    .detail("Reason", "TenantTokenMismatch")
		    .detail("RequestedTenant", fmt::format("{:#x}", tenantId))
		    .detail("TenantsInToken", fmt::format("{:#x}", fmt::join(entry->tenants, " ")));
		return false;
	}
	// audit logging
	if (FLOW_KNOBS->AUDIT_LOGGING_ENABLED)
		logTokenUsage(currentTime, AuditEntry(peer, tenantId, *cachedEntry.get()));
	return true;
}

void TokenCacheImpl::logTokenUsage(double currentTime, AuditEntry&& entry) {
	if (currentTime > lastResetTime + FLOW_KNOBS->AUDIT_TIME_WINDOW) {
		// clear usage cache every AUDIT_TIME_WINDOW seconds
		usedTokens.clear();
		lastResetTime = currentTime;
	}
	auto [iter, inserted] = usedTokens.insert(std::move(entry));
	if (inserted) {
		// access in the context of this (client_ip, tenant, token_id) tuple hasn't been logged in current window. log
		// usage.
		CODE_PROBE(true, "Audit Logging Running");
		TraceEvent("AuditTokenUsed"_audit)
		    .detail("Client", iter->address)
		    .detail("TenantId", fmt::format("{:#x}", iter->tenantId))
		    .detail("TokenId", iter->tokenId)
		    .log();
	}
}

namespace authz::jwt {
extern TokenRef makeRandomTokenSpec(Arena&, IRandom&, authz::Algorithm);
}

															#line 496 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase340()
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
template <class FlowTestCase340Actor>
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
class FlowTestCase340ActorState {
															#line 503 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
public:
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	FlowTestCase340ActorState(UnitTestParameters const& params) 
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		 : params(params)
															#line 510 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase340", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase340ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase340", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 341 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			auto const pubKeyName = "someEcPublicKey"_sr;
															#line 342 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			auto const rsaPubKeyName = "someRsaPublicKey"_sr;
															#line 343 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			auto privateKey = mkcert::makeEcP256();
															#line 344 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			auto publicKey = privateKey.toPublic();
															#line 345 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			auto rsaPrivateKey = mkcert::makeRsa4096Bit();
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			auto rsaPublicKey = rsaPrivateKey.toPublic();
															#line 347 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			std::pair<std::function<void(Arena&, IRandom&, authz::jwt::TokenRef&)>, char const*> badMutations[]{ { [](Arena&, IRandom&, authz::jwt::TokenRef&) { FlowTransport::transport().removeAllPublicKeys(); }, "NoKeyWithSuchName", }, { [](Arena&, IRandom&, authz::jwt::TokenRef& token) { token.expiresAtUnixTime.reset(); }, "NoExpirationTime", }, { [](Arena&, IRandom& rng, authz::jwt::TokenRef& token) { token.expiresAtUnixTime = std::max<double>(g_network->timer() - 10 - rng.random01() * 50, 0); }, "ExpiredToken", }, { [](Arena&, IRandom&, authz::jwt::TokenRef& token) { token.notBeforeUnixTime.reset(); }, "NoNotBefore", }, { [](Arena&, IRandom& rng, authz::jwt::TokenRef& token) { token.notBeforeUnixTime = g_network->timer() + 10 + rng.random01() * 50; }, "TokenNotYetValid", }, { [](Arena&, IRandom&, authz::jwt::TokenRef& token) { token.issuedAtUnixTime.reset(); }, "NoIssuedAt", }, { [](Arena& arena, IRandom&, authz::jwt::TokenRef& token) { token.tenants.reset(); }, "NoTenants", }, { [](Arena& arena, IRandom&, authz::jwt::TokenRef& token) { TenantId* newTenants = new (arena) TenantId[1]; *newTenants = token.tenants.get()[0] + 1; token.tenants = VectorRef<TenantId>(newTenants, 1); }, "UnmatchedTenant", }, { [rsaPubKeyName](Arena& arena, IRandom&, authz::jwt::TokenRef& token) { token.keyId = rsaPubKeyName; }, "UnmatchedSignAlgorithm", }, };
															#line 393 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			auto const numBadMutations = sizeof(badMutations) / sizeof(badMutations[0]);
															#line 394 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			for(auto repeat = 0;repeat < 50;repeat++) {
															#line 395 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				auto arena = Arena();
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				auto& rng = *deterministicRandom();
															#line 397 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				auto validTokenSpec = authz::jwt::makeRandomTokenSpec(arena, rng, authz::Algorithm::ES256);
															#line 398 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				validTokenSpec.keyId = pubKeyName;
															#line 399 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				for(auto i = 0;i <= numBadMutations + 1;i++) {
															#line 400 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					FlowTransport::transport().addPublicKey(pubKeyName, publicKey);
															#line 401 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					FlowTransport::transport().addPublicKey(rsaPubKeyName, rsaPublicKey);
															#line 402 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					auto publicKeyClearGuard = ScopeExit([]() { FlowTransport::transport().removeAllPublicKeys(); });
															#line 403 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					auto signedToken = StringRef();
															#line 404 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					auto tmpArena = Arena();
															#line 405 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
					if (i < numBadMutations)
															#line 563 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
					{
															#line 406 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						auto [mutationFn, mutationDesc] = badMutations[i];
															#line 407 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						auto mutatedTokenSpec = validTokenSpec;
															#line 408 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						mutationFn(tmpArena, rng, mutatedTokenSpec);
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						signedToken = authz::jwt::signToken(tmpArena, mutatedTokenSpec, privateKey);
															#line 410 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						if (TokenCache::instance().validate(validTokenSpec.tenants.get()[0], signedToken))
															#line 575 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
						{
															#line 411 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							fmt::print("Unexpected successful validation at mutation {}, token spec: {}\n", mutationDesc, toStringRef(tmpArena, mutatedTokenSpec).toStringView());
															#line 414 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							ASSERT(false);
															#line 581 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
						}
					}
					else
					{
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
						if (i == numBadMutations)
															#line 588 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
						{
															#line 418 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							signedToken = authz::jwt::signToken(tmpArena, validTokenSpec, privateKey);
															#line 419 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							signedToken.popBack();
															#line 420 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							if (TokenCache::instance().validate(validTokenSpec.tenants.get()[0], signedToken))
															#line 596 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
							{
															#line 421 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
								fmt::print("Unexpected successful validation with a token with truncated signature part\n");
															#line 422 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
								ASSERT(false);
															#line 602 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
							}
						}
						else
						{
															#line 426 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							auto signInput = authz::jwt::makeSignInput(tmpArena, validTokenSpec);
															#line 427 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							auto b64Header = signInput.eat("."_sr);
															#line 428 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							auto payload = base64::url::decode(tmpArena, signInput).get();
															#line 429 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							rapidjson::Document d;
															#line 430 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							d.Parse(reinterpret_cast<const char*>(payload.begin()), payload.size());
															#line 431 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							ASSERT(!d.HasParseError());
															#line 432 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							rapidjson::StringBuffer wrBuf;
															#line 433 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							rapidjson::Writer<rapidjson::StringBuffer> wr(wrBuf);
															#line 434 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							auto tenantsField = d.FindMember("tenants");
															#line 435 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							ASSERT(tenantsField != d.MemberEnd());
															#line 436 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							tenantsField->value.PushBack("ABC#", d.GetAllocator());
															#line 437 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							d.Accept(wr);
															#line 438 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							auto b64ModifiedPayload = base64::url::encode( tmpArena, StringRef(reinterpret_cast<const uint8_t*>(wrBuf.GetString()), wrBuf.GetSize()));
															#line 440 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							signInput = b64Header.withSuffix("."_sr, tmpArena).withSuffix(b64ModifiedPayload, tmpArena);
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							signedToken = authz::jwt::signToken(tmpArena, signInput, validTokenSpec.algorithm, privateKey);
															#line 442 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
							if (TokenCache::instance().validate(validTokenSpec.tenants.get()[0], signedToken))
															#line 639 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
							{
															#line 443 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
								fmt::print( "Unexpected successful validation of a token with tenant name containing non-base64 chars)\n");
															#line 445 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
								ASSERT(false);
															#line 645 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
							}
						}
					}
				}
			}
															#line 450 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			if (TokenCache::instance().validate(TenantInfo::INVALID_TENANT, StringRef()))
															#line 653 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			{
															#line 451 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				fmt::print("Unexpected successful validation of ill-formed token (no signature part)\n");
															#line 452 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				ASSERT(false);
															#line 659 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			}
															#line 454 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			if (TokenCache::instance().validate(TenantInfo::INVALID_TENANT, "1111.22"_sr))
															#line 663 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			{
															#line 455 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				fmt::print("Unexpected successful validation of ill-formed token (no signature part)\n");
															#line 456 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				ASSERT(false);
															#line 669 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			}
															#line 458 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			if (TokenCache::instance().validate(TenantInfo::INVALID_TENANT, "////.////.////"_sr))
															#line 673 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			{
															#line 459 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				fmt::print("Unexpected successful validation of unparseable token\n");
															#line 460 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				ASSERT(false);
															#line 679 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			}
															#line 462 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			fmt::print("TEST OK\n");
															#line 463 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			if (!static_cast<FlowTestCase340Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase340ActorState(); static_cast<FlowTestCase340Actor*>(this)->destroy(); return 0; }
															#line 685 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			new (&static_cast<FlowTestCase340Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase340ActorState();
			static_cast<FlowTestCase340Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase340ActorState();
		static_cast<FlowTestCase340Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	UnitTestParameters params;
															#line 709 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase340()
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
class FlowTestCase340Actor final : public Actor<Void>, public FastAllocated<FlowTestCase340Actor>, public FlowTestCase340ActorState<FlowTestCase340Actor> {
															#line 714 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase340Actor>::operator new;
	using FastAllocated<FlowTestCase340Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8931491662014856704UL, 16504661035456380672UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	FlowTestCase340Actor(UnitTestParameters const& params) 
															#line 730 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase340ActorState<FlowTestCase340Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase340", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2916637392911660800UL, 9276626632474724864UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase340Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase340");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase340", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
static Future<Void> flowTestCase340( UnitTestParameters const& params ) {
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	return Future<Void>(new FlowTestCase340Actor(params));
															#line 762 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase340, "/fdbrpc/authz/TokenCache/BadTokens")

#line 465 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"

															#line 768 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase466()
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
template <class FlowTestCase466Actor>
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
class FlowTestCase466ActorState {
															#line 775 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
public:
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	FlowTestCase466ActorState(UnitTestParameters const& params) 
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		 : params(params),
															#line 468 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		   arena(),
															#line 469 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		   privateKey(mkcert::makeEcP256()),
															#line 470 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		   pubKeyName("somePublicKey"_sr),
															#line 471 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		   publicKeyClearGuard([pubKeyName = pubKeyName]() { FlowTransport::transport().removePublicKey(pubKeyName); }),
															#line 473 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		   tokenSpec(authz::jwt::makeRandomTokenSpec(arena, *deterministicRandom(), authz::Algorithm::ES256)),
															#line 475 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		   signedToken()
															#line 794 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase466", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase466ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase466", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 476 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			FlowTransport::transport().addPublicKey(pubKeyName, privateKey.toPublic());
															#line 477 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			tokenSpec.expiresAtUnixTime = g_network->timer() + 2.0;
															#line 478 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			tokenSpec.keyId = pubKeyName;
															#line 479 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			signedToken = authz::jwt::signToken(arena, tokenSpec, privateKey);
															#line 480 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			if (!TokenCache::instance().validate(tokenSpec.tenants.get()[0], signedToken))
															#line 817 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			{
															#line 481 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				fmt::print("Unexpected failed token validation, token spec: {}, now: {}\n", toStringRef(arena, tokenSpec).toStringView(), g_network->timer());
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
				ASSERT(false);
															#line 823 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			}
															#line 486 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(3.5);
															#line 486 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			if (static_cast<FlowTestCase466Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 829 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase466Actor*>(this)->actor_wait_state = 1;
															#line 486 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase466Actor, 0, Void >*>(static_cast<FlowTestCase466Actor*>(this)));
															#line 834 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase466ActorState();
		static_cast<FlowTestCase466Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 487 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		if (TokenCache::instance().validate(tokenSpec.tenants.get()[0], signedToken))
															#line 857 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		{
															#line 488 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			fmt::print( "Unexpected successful token validation after supposedly expiring in cache, token spec: {}, now: {}\n", toStringRef(arena, tokenSpec).toStringView(), g_network->timer());
															#line 492 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			ASSERT(false);
															#line 863 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		}
															#line 494 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		fmt::print("TEST OK\n");
															#line 495 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		if (!static_cast<FlowTestCase466Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase466ActorState(); static_cast<FlowTestCase466Actor*>(this)->destroy(); return 0; }
															#line 869 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		new (&static_cast<FlowTestCase466Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase466ActorState();
		static_cast<FlowTestCase466Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 487 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		if (TokenCache::instance().validate(tokenSpec.tenants.get()[0], signedToken))
															#line 881 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		{
															#line 488 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			fmt::print( "Unexpected successful token validation after supposedly expiring in cache, token spec: {}, now: {}\n", toStringRef(arena, tokenSpec).toStringView(), g_network->timer());
															#line 492 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
			ASSERT(false);
															#line 887 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		}
															#line 494 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		fmt::print("TEST OK\n");
															#line 495 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
		if (!static_cast<FlowTestCase466Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase466ActorState(); static_cast<FlowTestCase466Actor*>(this)->destroy(); return 0; }
															#line 893 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		new (&static_cast<FlowTestCase466Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase466ActorState();
		static_cast<FlowTestCase466Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase466Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase466Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase466Actor*>(this)->ActorCallback< FlowTestCase466Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase466Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase466", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase466Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase466", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase466Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase466", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase466Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase466", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase466Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase466", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase466Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase466", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	UnitTestParameters params;
															#line 468 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	Arena arena;
															#line 469 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	PrivateKey privateKey;
															#line 470 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	StringRef pubKeyName;
															#line 471 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	ScopeExit<std::function<void()>> publicKeyClearGuard;
															#line 473 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	authz::jwt::TokenRef tokenSpec;
															#line 475 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	StringRef signedToken;
															#line 990 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase466()
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
class FlowTestCase466Actor final : public Actor<Void>, public ActorCallback< FlowTestCase466Actor, 0, Void >, public FastAllocated<FlowTestCase466Actor>, public FlowTestCase466ActorState<FlowTestCase466Actor> {
															#line 995 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase466Actor>::operator new;
	using FastAllocated<FlowTestCase466Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10228398958421618432UL, 3933926844110362112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase466Actor, 0, Void >;
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	FlowTestCase466Actor(UnitTestParameters const& params) 
															#line 1012 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase466ActorState<FlowTestCase466Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase466", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4943206254190998016UL, 1228659128267393792UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase466Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase466");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase466", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase466Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
static Future<Void> flowTestCase466( UnitTestParameters const& params ) {
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
	return Future<Void>(new FlowTestCase466Actor(params));
															#line 1045 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbrpc/TokenCache.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase466, "/fdbrpc/authz/TokenCache/GoodTokens")

#line 497 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbrpc/TokenCache.actor.cpp"
