#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
/*
 * TenantManagement.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_TENANT_MANAGEMENT_ACTOR_G_H)
#define FDBCLIENT_TENANT_MANAGEMENT_ACTOR_G_H
#include "fdbclient/TenantManagement.actor.g.h"
#elif !defined(FDBCLIENT_TENANT_MANAGEMENT_ACTOR_H)
#define FDBCLIENT_TENANT_MANAGEMENT_ACTOR_H

#include <algorithm>
#include <string>
#include <map>
#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/GenericTransactionHelper.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/MetaclusterRegistration.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/Tenant.h"
#include "flow/IRandom.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // has to be last include

namespace TenantAPI {

static const int TENANT_ID_PREFIX_MIN_VALUE = 0;
static const int TENANT_ID_PREFIX_MAX_VALUE = 32767;

template <class Transaction>
Future<Optional<TenantMapEntry>> tryGetTenantTransaction(Transaction tr, int64_t tenantId) {
	tr->setOption(FDBTransactionOptions::RAW_ACCESS);
	return TenantMetadata::tenantMap().get(tr, tenantId);
}

															#line 54 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via tryGetTenantTransaction()
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class TryGetTenantTransactionActor>
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class TryGetTenantTransactionActorState {
															#line 60 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TryGetTenantTransactionActorState(Transaction const& tr,TenantName const& name) 
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   name(name)
															#line 69 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~TryGetTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 54 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 55 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<int64_t>> __when_expr_0 = TenantMetadata::tenantNameIndex().get(tr, name);
															#line 55 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 88 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 55 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >*>(static_cast<TryGetTenantTransactionActor*>(this)));
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetTenantTransactionActorState();
		static_cast<TryGetTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<int64_t> const& tenantId,int loopDepth) 
	{
															#line 56 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantId.present())
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = TenantMetadata::tenantMap().get(tr, tenantId.get());
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantTransactionActor, 1, Optional<TenantMapEntry> >*>(static_cast<TryGetTenantTransactionActor*>(this)));
															#line 127 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 60 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<TryGetTenantTransactionActor*>(this)->SAV<Optional<TenantMapEntry>>::futures) { (void)(Optional<TenantMapEntry>()); this->~TryGetTenantTransactionActorState(); static_cast<TryGetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 134 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<TryGetTenantTransactionActor*>(this)->SAV< Optional<TenantMapEntry> >::value()) Optional<TenantMapEntry>(Optional<TenantMapEntry>());
			this->~TryGetTenantTransactionActorState();
			static_cast<TryGetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<int64_t> && tenantId,int loopDepth) 
	{
															#line 56 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantId.present())
															#line 147 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = TenantMetadata::tenantMap().get(tr, tenantId.get());
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 153 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantTransactionActor, 1, Optional<TenantMapEntry> >*>(static_cast<TryGetTenantTransactionActor*>(this)));
															#line 158 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 60 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<TryGetTenantTransactionActor*>(this)->SAV<Optional<TenantMapEntry>>::futures) { (void)(Optional<TenantMapEntry>()); this->~TryGetTenantTransactionActorState(); static_cast<TryGetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 165 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<TryGetTenantTransactionActor*>(this)->SAV< Optional<TenantMapEntry> >::value()) Optional<TenantMapEntry>(Optional<TenantMapEntry>());
			this->~TryGetTenantTransactionActorState();
			static_cast<TryGetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(Optional<int64_t> const& tenantId,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenantId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<int64_t> && tenantId,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenantId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantTransactionActor*>(this)->ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetTenantTransactionActor, 0, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 58 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<TryGetTenantTransactionActor*>(this)->SAV<Optional<TenantMapEntry>>::futures) { (void)(entry); this->~TryGetTenantTransactionActorState(); static_cast<TryGetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 253 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<TryGetTenantTransactionActor*>(this)->SAV< Optional<TenantMapEntry> >::value()) Optional<TenantMapEntry>(entry);
		this->~TryGetTenantTransactionActorState();
		static_cast<TryGetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 58 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<TryGetTenantTransactionActor*>(this)->SAV<Optional<TenantMapEntry>>::futures) { (void)(entry); this->~TryGetTenantTransactionActorState(); static_cast<TryGetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 265 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<TryGetTenantTransactionActor*>(this)->SAV< Optional<TenantMapEntry> >::value()) Optional<TenantMapEntry>(entry);
		this->~TryGetTenantTransactionActorState();
		static_cast<TryGetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantTransactionActor*>(this)->ActorCallback< TryGetTenantTransactionActor, 1, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName name;
															#line 352 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via tryGetTenantTransaction()
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class TryGetTenantTransactionActor final : public Actor<Optional<TenantMapEntry>>, public ActorCallback< TryGetTenantTransactionActor<Transaction>, 0, Optional<int64_t> >, public ActorCallback< TryGetTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >, public FastAllocated<TryGetTenantTransactionActor<Transaction>>, public TryGetTenantTransactionActorState<Transaction, TryGetTenantTransactionActor<Transaction>> {
															#line 359 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<TryGetTenantTransactionActor<Transaction>>::operator new;
	using FastAllocated<TryGetTenantTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11131829641763986944UL, 5206320961850712320UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<TenantMapEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetTenantTransactionActor<Transaction>, 0, Optional<int64_t> >;
friend struct ActorCallback< TryGetTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >;
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TryGetTenantTransactionActor(Transaction const& tr,TenantName const& name) 
															#line 377 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Optional<TenantMapEntry>>(),
		   TryGetTenantTransactionActorState<Transaction, TryGetTenantTransactionActor<Transaction>>(tr, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2632132613495744256UL, 14272688076436411392UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetTenantTransactionActor<Transaction>, 0, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Optional<TenantMapEntry>> tryGetTenantTransaction( Transaction const& tr, TenantName const& name ) {
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Optional<TenantMapEntry>>(new TryGetTenantTransactionActor<Transaction>(tr, name));
															#line 412 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 63 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 417 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via tryGetTenant()
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class Tenant, class TryGetTenantActor>
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class TryGetTenantActorState {
															#line 423 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TryGetTenantActorState(Reference<DB> const& db,Tenant const& tenant) 
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : db(db),
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenant(tenant),
															#line 66 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tr(db->createTransaction())
															#line 434 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("tryGetTenant", reinterpret_cast<unsigned long>(this));

	}
	~TryGetTenantActorState() 
	{
		fdb_probe_actor_destroy("tryGetTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			;
															#line 449 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetTenantActorState();
		static_cast<TryGetTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 72 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, tenant);
															#line 72 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<TryGetTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 486 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetTenantActor*>(this)->actor_wait_state = 1;
															#line 72 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantActor, 0, Optional<TenantMapEntry> >*>(static_cast<TryGetTenantActor*>(this)));
															#line 491 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 75 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 75 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<TryGetTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 515 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetTenantActor*>(this)->actor_wait_state = 2;
															#line 75 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantActor, 1, Void >*>(static_cast<TryGetTenantActor*>(this)));
															#line 520 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<TryGetTenantActor*>(this)->SAV<Optional<TenantMapEntry>>::futures) { (void)(entry); this->~TryGetTenantActorState(); static_cast<TryGetTenantActor*>(this)->destroy(); return 0; }
															#line 535 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<TryGetTenantActor*>(this)->SAV< Optional<TenantMapEntry> >::value()) Optional<TenantMapEntry>(entry);
		this->~TryGetTenantActorState();
		static_cast<TryGetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<TryGetTenantActor*>(this)->SAV<Optional<TenantMapEntry>>::futures) { (void)(entry); this->~TryGetTenantActorState(); static_cast<TryGetTenantActor*>(this)->destroy(); return 0; }
															#line 547 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<TryGetTenantActor*>(this)->SAV< Optional<TenantMapEntry> >::value()) Optional<TenantMapEntry>(entry);
		this->~TryGetTenantActorState();
		static_cast<TryGetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetTenantActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantActor*>(this)->ActorCallback< TryGetTenantActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetTenantActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetTenantActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetTenantActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantActor*>(this)->ActorCallback< TryGetTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<DB> db;
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Tenant tenant;
															#line 66 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 723 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via tryGetTenant()
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class Tenant>
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class TryGetTenantActor final : public Actor<Optional<TenantMapEntry>>, public ActorCallback< TryGetTenantActor<DB, Tenant>, 0, Optional<TenantMapEntry> >, public ActorCallback< TryGetTenantActor<DB, Tenant>, 1, Void >, public FastAllocated<TryGetTenantActor<DB, Tenant>>, public TryGetTenantActorState<DB, Tenant, TryGetTenantActor<DB, Tenant>> {
															#line 730 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<TryGetTenantActor<DB, Tenant>>::operator new;
	using FastAllocated<TryGetTenantActor<DB, Tenant>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(959281548734358016UL, 7110601422648296192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<TenantMapEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetTenantActor<DB, Tenant>, 0, Optional<TenantMapEntry> >;
friend struct ActorCallback< TryGetTenantActor<DB, Tenant>, 1, Void >;
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TryGetTenantActor(Reference<DB> const& db,Tenant const& tenant) 
															#line 748 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Optional<TenantMapEntry>>(),
		   TryGetTenantActorState<DB, Tenant, TryGetTenantActor<DB, Tenant>>(db, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10458749581686870528UL, 11957054532112398080UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetTenantActor<DB, Tenant>, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetTenantActor<DB, Tenant>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class Tenant>
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Optional<TenantMapEntry>> tryGetTenant( Reference<DB> const& db, Tenant const& tenant ) {
															#line 64 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Optional<TenantMapEntry>>(new TryGetTenantActor<DB, Tenant>(db, tenant));
															#line 783 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 79 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 788 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via getTenantTransaction()
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class Tenant, class GetTenantTransactionActor>
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetTenantTransactionActorState {
															#line 794 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetTenantTransactionActorState(Transaction const& tr,Tenant const& tenant) 
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenant(tenant)
															#line 803 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("getTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("getTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 82 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = tryGetTenantTransaction(tr, tenant);
															#line 82 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<GetTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 820 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantTransactionActor, 0, Optional<TenantMapEntry> >*>(static_cast<GetTenantTransactionActor*>(this)));
															#line 825 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantTransactionActorState();
		static_cast<GetTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 83 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!entry.present())
															#line 848 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 84 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 852 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 87 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetTenantTransactionActor*>(this)->SAV<TenantMapEntry>::futures) { (void)(entry.get()); this->~GetTenantTransactionActorState(); static_cast<GetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 856 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetTenantTransactionActor*>(this)->SAV< TenantMapEntry >::value()) TenantMapEntry(entry.get());
		this->~GetTenantTransactionActorState();
		static_cast<GetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 83 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!entry.present())
															#line 868 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 84 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 872 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 87 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetTenantTransactionActor*>(this)->SAV<TenantMapEntry>::futures) { (void)(entry.get()); this->~GetTenantTransactionActorState(); static_cast<GetTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 876 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetTenantTransactionActor*>(this)->SAV< TenantMapEntry >::value()) TenantMapEntry(entry.get());
		this->~GetTenantTransactionActorState();
		static_cast<GetTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<GetTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantTransactionActor*>(this)->ActorCallback< GetTenantTransactionActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantTransactionActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantTransactionActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantTransactionActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Tenant tenant;
															#line 963 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via getTenantTransaction()
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class Tenant>
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetTenantTransactionActor final : public Actor<TenantMapEntry>, public ActorCallback< GetTenantTransactionActor<Transaction, Tenant>, 0, Optional<TenantMapEntry> >, public FastAllocated<GetTenantTransactionActor<Transaction, Tenant>>, public GetTenantTransactionActorState<Transaction, Tenant, GetTenantTransactionActor<Transaction, Tenant>> {
															#line 970 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<GetTenantTransactionActor<Transaction, Tenant>>::operator new;
	using FastAllocated<GetTenantTransactionActor<Transaction, Tenant>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2477473801994129664UL, 12410012388434531072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TenantMapEntry>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantTransactionActor<Transaction, Tenant>, 0, Optional<TenantMapEntry> >;
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetTenantTransactionActor(Transaction const& tr,Tenant const& tenant) 
															#line 987 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<TenantMapEntry>(),
		   GetTenantTransactionActorState<Transaction, Tenant, GetTenantTransactionActor<Transaction, Tenant>>(tr, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4865543640709564416UL, 2379330836080751872UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantTransactionActor<Transaction, Tenant>, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class Tenant>
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<TenantMapEntry> getTenantTransaction( Transaction const& tr, Tenant const& tenant ) {
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<TenantMapEntry>(new GetTenantTransactionActor<Transaction, Tenant>(tr, tenant));
															#line 1021 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 89 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 1026 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via getTenant()
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class Tenant, class GetTenantActor>
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetTenantActorState {
															#line 1032 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetTenantActorState(Reference<DB> const& db,Tenant const& tenant) 
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : db(db),
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenant(tenant)
															#line 1041 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("getTenant", reinterpret_cast<unsigned long>(this));

	}
	~GetTenantActorState() 
	{
		fdb_probe_actor_destroy("getTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 92 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantMapEntry>> __when_expr_0 = tryGetTenant(db, tenant);
															#line 92 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<GetTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1058 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetTenantActor*>(this)->actor_wait_state = 1;
															#line 92 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetTenantActor, 0, Optional<TenantMapEntry> >*>(static_cast<GetTenantActor*>(this)));
															#line 1063 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!entry.present())
															#line 1086 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 94 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 1090 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 97 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetTenantActor*>(this)->SAV<TenantMapEntry>::futures) { (void)(entry.get()); this->~GetTenantActorState(); static_cast<GetTenantActor*>(this)->destroy(); return 0; }
															#line 1094 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetTenantActor*>(this)->SAV< TenantMapEntry >::value()) TenantMapEntry(entry.get());
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!entry.present())
															#line 1106 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 94 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 1110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 97 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetTenantActor*>(this)->SAV<TenantMapEntry>::futures) { (void)(entry.get()); this->~GetTenantActorState(); static_cast<GetTenantActor*>(this)->destroy(); return 0; }
															#line 1114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetTenantActor*>(this)->SAV< TenantMapEntry >::value()) TenantMapEntry(entry.get());
		this->~GetTenantActorState();
		static_cast<GetTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantMapEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetTenantActor*>(this)->actor_wait_state > 0) static_cast<GetTenantActor*>(this)->actor_wait_state = 0;
		static_cast<GetTenantActor*>(this)->ActorCallback< GetTenantActor, 0, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetTenantActor, 0, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetTenantActor, 0, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<DB> db;
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Tenant tenant;
															#line 1201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via getTenant()
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class Tenant>
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetTenantActor final : public Actor<TenantMapEntry>, public ActorCallback< GetTenantActor<DB, Tenant>, 0, Optional<TenantMapEntry> >, public FastAllocated<GetTenantActor<DB, Tenant>>, public GetTenantActorState<DB, Tenant, GetTenantActor<DB, Tenant>> {
															#line 1208 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<GetTenantActor<DB, Tenant>>::operator new;
	using FastAllocated<GetTenantActor<DB, Tenant>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17509036597934581248UL, 16243112944371415808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TenantMapEntry>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetTenantActor<DB, Tenant>, 0, Optional<TenantMapEntry> >;
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetTenantActor(Reference<DB> const& db,Tenant const& tenant) 
															#line 1225 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<TenantMapEntry>(),
		   GetTenantActorState<DB, Tenant, GetTenantActor<DB, Tenant>>(db, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5539216869899646464UL, 17063241412762073856UL);
		ActorExecutionContextHelper __helper(static_cast<GetTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetTenantActor<DB, Tenant>, 0, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class Tenant>
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<TenantMapEntry> getTenant( Reference<DB> const& db, Tenant const& tenant ) {
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<TenantMapEntry>(new GetTenantActor<DB, Tenant>(db, tenant));
															#line 1259 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 99 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 1264 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via getClusterType()
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class GetClusterTypeActor>
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetClusterTypeActorState {
															#line 1270 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetClusterTypeActorState(Transaction const& tr) 
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr)
															#line 1277 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("getClusterType", reinterpret_cast<unsigned long>(this));

	}
	~GetClusterTypeActorState() 
	{
		fdb_probe_actor_destroy("getClusterType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 102 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<MetaclusterRegistrationEntry>> __when_expr_0 = metacluster::metadata::metaclusterRegistration().get(tr);
															#line 102 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<GetClusterTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1294 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetClusterTypeActor*>(this)->actor_wait_state = 1;
															#line 102 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetClusterTypeActor, 0, Optional<MetaclusterRegistrationEntry> >*>(static_cast<GetClusterTypeActor*>(this)));
															#line 1299 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetClusterTypeActorState();
		static_cast<GetClusterTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterRegistrationEntry> const& metaclusterRegistration,int loopDepth) 
	{
															#line 105 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetClusterTypeActor*>(this)->SAV<ClusterType>::futures) { (void)(metaclusterRegistration.present() ? metaclusterRegistration.get().clusterType : ClusterType::STANDALONE); this->~GetClusterTypeActorState(); static_cast<GetClusterTypeActor*>(this)->destroy(); return 0; }
															#line 1322 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetClusterTypeActor*>(this)->SAV< ClusterType >::value()) ClusterType(metaclusterRegistration.present() ? metaclusterRegistration.get().clusterType : ClusterType::STANDALONE);
		this->~GetClusterTypeActorState();
		static_cast<GetClusterTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<MetaclusterRegistrationEntry> && metaclusterRegistration,int loopDepth) 
	{
															#line 105 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetClusterTypeActor*>(this)->SAV<ClusterType>::futures) { (void)(metaclusterRegistration.present() ? metaclusterRegistration.get().clusterType : ClusterType::STANDALONE); this->~GetClusterTypeActorState(); static_cast<GetClusterTypeActor*>(this)->destroy(); return 0; }
															#line 1334 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetClusterTypeActor*>(this)->SAV< ClusterType >::value()) ClusterType(metaclusterRegistration.present() ? metaclusterRegistration.get().clusterType : ClusterType::STANDALONE);
		this->~GetClusterTypeActorState();
		static_cast<GetClusterTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterRegistrationEntry> const& metaclusterRegistration,int loopDepth) 
	{
		loopDepth = a_body1cont1(metaclusterRegistration, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<MetaclusterRegistrationEntry> && metaclusterRegistration,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(metaclusterRegistration), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetClusterTypeActor*>(this)->actor_wait_state > 0) static_cast<GetClusterTypeActor*>(this)->actor_wait_state = 0;
		static_cast<GetClusterTypeActor*>(this)->ActorCallback< GetClusterTypeActor, 0, Optional<MetaclusterRegistrationEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< GetClusterTypeActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> const& value) 
	{
		fdb_probe_actor_enter("getClusterType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetClusterTypeActor, 0, Optional<MetaclusterRegistrationEntry> >*,Optional<MetaclusterRegistrationEntry> && value) 
	{
		fdb_probe_actor_enter("getClusterType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetClusterTypeActor, 0, Optional<MetaclusterRegistrationEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("getClusterType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getClusterType", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 1419 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via getClusterType()
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetClusterTypeActor final : public Actor<ClusterType>, public ActorCallback< GetClusterTypeActor<Transaction>, 0, Optional<MetaclusterRegistrationEntry> >, public FastAllocated<GetClusterTypeActor<Transaction>>, public GetClusterTypeActorState<Transaction, GetClusterTypeActor<Transaction>> {
															#line 1426 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<GetClusterTypeActor<Transaction>>::operator new;
	using FastAllocated<GetClusterTypeActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(813843074086401280UL, 12501077169870002944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<ClusterType>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetClusterTypeActor<Transaction>, 0, Optional<MetaclusterRegistrationEntry> >;
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetClusterTypeActor(Transaction const& tr) 
															#line 1443 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<ClusterType>(),
		   GetClusterTypeActorState<Transaction, GetClusterTypeActor<Transaction>>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getClusterType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12339173624599678464UL, 9196985126366195712UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getClusterType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getClusterType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetClusterTypeActor<Transaction>, 0, Optional<MetaclusterRegistrationEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<ClusterType> getClusterType( Transaction const& tr ) {
															#line 100 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<ClusterType>(new GetClusterTypeActor<Transaction>(tr));
															#line 1477 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 107 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 1482 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via checkTenantMode()
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class CheckTenantModeActor>
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class CheckTenantModeActorState {
															#line 1488 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	CheckTenantModeActorState(Transaction const& tr,ClusterType const& expectedClusterType) 
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   expectedClusterType(expectedClusterType),
															#line 110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantModeFuture(tr->get(configKeysPrefix.withSuffix("tenant_mode"_sr)))
															#line 1499 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("checkTenantMode", reinterpret_cast<unsigned long>(this));

	}
	~CheckTenantModeActorState() 
	{
		fdb_probe_actor_destroy("checkTenantMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<ClusterType> __when_expr_0 = getClusterType(tr);
															#line 113 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<CheckTenantModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1516 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckTenantModeActor*>(this)->actor_wait_state = 1;
															#line 113 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTenantModeActor, 0, ClusterType >*>(static_cast<CheckTenantModeActor*>(this)));
															#line 1521 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTenantModeActorState();
		static_cast<CheckTenantModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Optional<Value>> __when_expr_1 = safeThreadFutureToFuture(tenantModeFuture);
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CheckTenantModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1546 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckTenantModeActor*>(this)->actor_wait_state = 2;
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckTenantModeActor, 1, Optional<Value> >*>(static_cast<CheckTenantModeActor*>(this)));
															#line 1551 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(ClusterType const& __actualClusterType,int loopDepth) 
	{
															#line 113 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		actualClusterType = __actualClusterType;
															#line 1560 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(ClusterType && __actualClusterType,int loopDepth) 
	{
		actualClusterType = std::move(__actualClusterType);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTenantModeActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantModeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantModeActor*>(this)->ActorCallback< CheckTenantModeActor, 0, ClusterType >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantModeActor, 0, ClusterType >*,ClusterType const& value) 
	{
		fdb_probe_actor_enter("checkTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTenantModeActor, 0, ClusterType >*,ClusterType && value) 
	{
		fdb_probe_actor_enter("checkTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTenantModeActor, 0, ClusterType >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Optional<Value> const& tenantModeValue,int loopDepth) 
	{
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMode tenantMode = TenantMode::fromValue(tenantModeValue.castTo<ValueRef>());
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (actualClusterType != expectedClusterType)
															#line 1641 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 118 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Attempting tenant operation on wrong cluster type");
															#line 119 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(invalid_metacluster_operation(), loopDepth);
															#line 1647 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		else
		{
															#line 120 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (actualClusterType == ClusterType::STANDALONE && tenantMode == TenantMode::DISABLED)
															#line 1653 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Attempting tenant operation on cluster with tenants disabled", probe::decoration::rare);
															#line 122 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				return a_body1Catch1(tenants_disabled(), loopDepth);
															#line 1659 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
		}
															#line 125 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<CheckTenantModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTenantModeActorState(); static_cast<CheckTenantModeActor*>(this)->destroy(); return 0; }
															#line 1664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<CheckTenantModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTenantModeActorState();
		static_cast<CheckTenantModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && tenantModeValue,int loopDepth) 
	{
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMode tenantMode = TenantMode::fromValue(tenantModeValue.castTo<ValueRef>());
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (actualClusterType != expectedClusterType)
															#line 1678 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 118 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Attempting tenant operation on wrong cluster type");
															#line 119 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(invalid_metacluster_operation(), loopDepth);
															#line 1684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		else
		{
															#line 120 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (actualClusterType == ClusterType::STANDALONE && tenantMode == TenantMode::DISABLED)
															#line 1690 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Attempting tenant operation on cluster with tenants disabled", probe::decoration::rare);
															#line 122 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				return a_body1Catch1(tenants_disabled(), loopDepth);
															#line 1696 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
		}
															#line 125 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<CheckTenantModeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckTenantModeActorState(); static_cast<CheckTenantModeActor*>(this)->destroy(); return 0; }
															#line 1701 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<CheckTenantModeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckTenantModeActorState();
		static_cast<CheckTenantModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& tenantModeValue,int loopDepth) 
	{
		loopDepth = a_body1cont2(tenantModeValue, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && tenantModeValue,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(tenantModeValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckTenantModeActor*>(this)->actor_wait_state > 0) static_cast<CheckTenantModeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTenantModeActor*>(this)->ActorCallback< CheckTenantModeActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTenantModeActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkTenantMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckTenantModeActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkTenantMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantMode", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckTenantModeActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkTenantMode", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTenantMode", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType expectedClusterType;
															#line 110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	typename transaction_future_type<Transaction, Optional<Value>>::type tenantModeFuture;
															#line 113 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType actualClusterType;
															#line 1792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via checkTenantMode()
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class CheckTenantModeActor final : public Actor<Void>, public ActorCallback< CheckTenantModeActor<Transaction>, 0, ClusterType >, public ActorCallback< CheckTenantModeActor<Transaction>, 1, Optional<Value> >, public FastAllocated<CheckTenantModeActor<Transaction>>, public CheckTenantModeActorState<Transaction, CheckTenantModeActor<Transaction>> {
															#line 1799 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<CheckTenantModeActor<Transaction>>::operator new;
	using FastAllocated<CheckTenantModeActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11665974393540259840UL, 17391754857515974656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTenantModeActor<Transaction>, 0, ClusterType >;
friend struct ActorCallback< CheckTenantModeActor<Transaction>, 1, Optional<Value> >;
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	CheckTenantModeActor(Transaction const& tr,ClusterType const& expectedClusterType) 
															#line 1817 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Void>(),
		   CheckTenantModeActorState<Transaction, CheckTenantModeActor<Transaction>>(tr, expectedClusterType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTenantMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13910992653918216448UL, 15269587388858730240UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTenantMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTenantMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTenantModeActor<Transaction>, 0, ClusterType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckTenantModeActor<Transaction>, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Void> checkTenantMode( Transaction const& tr, ClusterType const& expectedClusterType ) {
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Void>(new CheckTenantModeActor<Transaction>(tr, expectedClusterType));
															#line 1852 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 127 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

TenantMode tenantModeForClusterType(ClusterType clusterType, TenantMode tenantMode);
int64_t extractTenantIdFromMutation(MutationRef m);
int64_t extractTenantIdFromKeyRef(StringRef s);
bool tenantMapChanging(MutationRef const& mutation, KeyRangeRef const& tenantMapRange);
int64_t computeNextTenantId(int64_t tenantId, int64_t delta);
int64_t getMaxAllowableTenantId(int64_t curTenantId);
int64_t getTenantIdPrefix(int64_t tenantId);

															#line 1865 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via getEffectiveTenantMode()
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class GetEffectiveTenantModeActor>
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetEffectiveTenantModeActorState {
															#line 1871 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetEffectiveTenantModeActorState(Transaction const& tr) 
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 138 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantModeFuture(tr->get(configKeysPrefix.withSuffix("tenant_mode"_sr))),
															#line 140 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   clusterType(),
															#line 141 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantModeValue()
															#line 1884 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this));

	}
	~GetEffectiveTenantModeActorState() 
	{
		fdb_probe_actor_destroy("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 142 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_0 = store(clusterType, getClusterType(tr)) && store(tenantModeValue, safeThreadFutureToFuture(tenantModeFuture));
															#line 142 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<GetEffectiveTenantModeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1901 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetEffectiveTenantModeActor*>(this)->actor_wait_state = 1;
															#line 142 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetEffectiveTenantModeActor, 0, Void >*>(static_cast<GetEffectiveTenantModeActor*>(this)));
															#line 1906 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetEffectiveTenantModeActorState();
		static_cast<GetEffectiveTenantModeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMode tenantMode = TenantMode::fromValue(tenantModeValue.castTo<ValueRef>());
															#line 144 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetEffectiveTenantModeActor*>(this)->SAV<TenantMode>::futures) { (void)(tenantModeForClusterType(clusterType, tenantMode)); this->~GetEffectiveTenantModeActorState(); static_cast<GetEffectiveTenantModeActor*>(this)->destroy(); return 0; }
															#line 1931 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetEffectiveTenantModeActor*>(this)->SAV< TenantMode >::value()) TenantMode(tenantModeForClusterType(clusterType, tenantMode));
		this->~GetEffectiveTenantModeActorState();
		static_cast<GetEffectiveTenantModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 143 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMode tenantMode = TenantMode::fromValue(tenantModeValue.castTo<ValueRef>());
															#line 144 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetEffectiveTenantModeActor*>(this)->SAV<TenantMode>::futures) { (void)(tenantModeForClusterType(clusterType, tenantMode)); this->~GetEffectiveTenantModeActorState(); static_cast<GetEffectiveTenantModeActor*>(this)->destroy(); return 0; }
															#line 1945 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetEffectiveTenantModeActor*>(this)->SAV< TenantMode >::value()) TenantMode(tenantModeForClusterType(clusterType, tenantMode));
		this->~GetEffectiveTenantModeActorState();
		static_cast<GetEffectiveTenantModeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetEffectiveTenantModeActor*>(this)->actor_wait_state > 0) static_cast<GetEffectiveTenantModeActor*>(this)->actor_wait_state = 0;
		static_cast<GetEffectiveTenantModeActor*>(this)->ActorCallback< GetEffectiveTenantModeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetEffectiveTenantModeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetEffectiveTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetEffectiveTenantModeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetEffectiveTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetEffectiveTenantModeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetEffectiveTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 138 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	typename transaction_future_type<Transaction, Optional<Value>>::type tenantModeFuture;
															#line 140 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType clusterType;
															#line 141 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Optional<Value> tenantModeValue;
															#line 2036 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via getEffectiveTenantMode()
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetEffectiveTenantModeActor final : public Actor<TenantMode>, public ActorCallback< GetEffectiveTenantModeActor<Transaction>, 0, Void >, public FastAllocated<GetEffectiveTenantModeActor<Transaction>>, public GetEffectiveTenantModeActorState<Transaction, GetEffectiveTenantModeActor<Transaction>> {
															#line 2043 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<GetEffectiveTenantModeActor<Transaction>>::operator new;
	using FastAllocated<GetEffectiveTenantModeActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4107936131274728192UL, 18371334892091157248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<TenantMode>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetEffectiveTenantModeActor<Transaction>, 0, Void >;
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetEffectiveTenantModeActor(Transaction const& tr) 
															#line 2060 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<TenantMode>(),
		   GetEffectiveTenantModeActorState<Transaction, GetEffectiveTenantModeActor<Transaction>>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(23359578870793984UL, 3215165970941936896UL);
		ActorExecutionContextHelper __helper(static_cast<GetEffectiveTenantModeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getEffectiveTenantMode");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getEffectiveTenantMode", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetEffectiveTenantModeActor<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<TenantMode> getEffectiveTenantMode( Transaction const& tr ) {
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<TenantMode>(new GetEffectiveTenantModeActor<Transaction>(tr));
															#line 2094 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 146 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

// Returns true if the specified ID has already been deleted and false if not. If the ID is old enough
// that we no longer keep tombstones for it, an error is thrown.
															#line 2101 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via checkTombstone()
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class CheckTombstoneActor>
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class CheckTombstoneActorState {
															#line 2107 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	CheckTombstoneActorState(Transaction const& tr,int64_t const& id) 
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   id(id),
															#line 151 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tombstoneFuture(TenantMetadata::tenantTombstones().exists(tr, id))
															#line 2118 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("checkTombstone", reinterpret_cast<unsigned long>(this));

	}
	~CheckTombstoneActorState() 
	{
		fdb_probe_actor_destroy("checkTombstone", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 155 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantTombstoneCleanupData>> __when_expr_0 = TenantMetadata::tombstoneCleanupData().get(tr);
															#line 155 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<CheckTombstoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2135 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckTombstoneActor*>(this)->actor_wait_state = 1;
															#line 155 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckTombstoneActor, 0, Optional<TenantTombstoneCleanupData> >*>(static_cast<CheckTombstoneActor*>(this)));
															#line 2140 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckTombstoneActorState();
		static_cast<CheckTombstoneActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<TenantTombstoneCleanupData> const& tombstoneCleanupData,int loopDepth) 
	{
															#line 156 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tombstoneCleanupData.present() && tombstoneCleanupData.get().tombstonesErasedThrough >= id)
															#line 2163 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 157 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant creation permanently failed");
															#line 158 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_creation_permanently_failed(), loopDepth);
															#line 2169 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<bool> __when_expr_1 = tombstoneFuture;
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CheckTombstoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2175 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckTombstoneActor*>(this)->actor_wait_state = 2;
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckTombstoneActor, 1, bool >*>(static_cast<CheckTombstoneActor*>(this)));
															#line 2180 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<TenantTombstoneCleanupData> && tombstoneCleanupData,int loopDepth) 
	{
															#line 156 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tombstoneCleanupData.present() && tombstoneCleanupData.get().tombstonesErasedThrough >= id)
															#line 2189 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 157 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant creation permanently failed");
															#line 158 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_creation_permanently_failed(), loopDepth);
															#line 2195 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<bool> __when_expr_1 = tombstoneFuture;
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CheckTombstoneActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CheckTombstoneActor*>(this)->actor_wait_state = 2;
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckTombstoneActor, 1, bool >*>(static_cast<CheckTombstoneActor*>(this)));
															#line 2206 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<TenantTombstoneCleanupData> const& tombstoneCleanupData,int loopDepth) 
	{
		loopDepth = a_body1cont1(tombstoneCleanupData, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantTombstoneCleanupData> && tombstoneCleanupData,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tombstoneCleanupData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckTombstoneActor*>(this)->actor_wait_state > 0) static_cast<CheckTombstoneActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTombstoneActor*>(this)->ActorCallback< CheckTombstoneActor, 0, Optional<TenantTombstoneCleanupData> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTombstoneActor, 0, Optional<TenantTombstoneCleanupData> >*,Optional<TenantTombstoneCleanupData> const& value) 
	{
		fdb_probe_actor_enter("checkTombstone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTombstoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTombstone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckTombstoneActor, 0, Optional<TenantTombstoneCleanupData> >*,Optional<TenantTombstoneCleanupData> && value) 
	{
		fdb_probe_actor_enter("checkTombstone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTombstoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTombstone", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckTombstoneActor, 0, Optional<TenantTombstoneCleanupData> >*,Error err) 
	{
		fdb_probe_actor_enter("checkTombstone", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTombstoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTombstone", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 163 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<CheckTombstoneActor*>(this)->SAV<bool>::futures) { (void)(hasTombstone); this->~CheckTombstoneActorState(); static_cast<CheckTombstoneActor*>(this)->destroy(); return 0; }
															#line 2290 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<CheckTombstoneActor*>(this)->SAV< bool >::value()) bool(std::move(hasTombstone)); // state_var_RVO
		this->~CheckTombstoneActorState();
		static_cast<CheckTombstoneActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(bool const& __hasTombstone,int loopDepth) 
	{
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		hasTombstone = __hasTombstone;
															#line 2302 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(bool && __hasTombstone,int loopDepth) 
	{
		hasTombstone = std::move(__hasTombstone);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckTombstoneActor*>(this)->actor_wait_state > 0) static_cast<CheckTombstoneActor*>(this)->actor_wait_state = 0;
		static_cast<CheckTombstoneActor*>(this)->ActorCallback< CheckTombstoneActor, 1, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CheckTombstoneActor, 1, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("checkTombstone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTombstoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTombstone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckTombstoneActor, 1, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("checkTombstone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTombstoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTombstone", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckTombstoneActor, 1, bool >*,Error err) 
	{
		fdb_probe_actor_enter("checkTombstone", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTombstoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkTombstone", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int64_t id;
															#line 151 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<bool> tombstoneFuture;
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	bool hasTombstone;
															#line 2385 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via checkTombstone()
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class CheckTombstoneActor final : public Actor<bool>, public ActorCallback< CheckTombstoneActor<Transaction>, 0, Optional<TenantTombstoneCleanupData> >, public ActorCallback< CheckTombstoneActor<Transaction>, 1, bool >, public FastAllocated<CheckTombstoneActor<Transaction>>, public CheckTombstoneActorState<Transaction, CheckTombstoneActor<Transaction>> {
															#line 2392 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<CheckTombstoneActor<Transaction>>::operator new;
	using FastAllocated<CheckTombstoneActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17610543092035917056UL, 13788617870924113664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckTombstoneActor<Transaction>, 0, Optional<TenantTombstoneCleanupData> >;
friend struct ActorCallback< CheckTombstoneActor<Transaction>, 1, bool >;
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	CheckTombstoneActor(Transaction const& tr,int64_t const& id) 
															#line 2410 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<bool>(),
		   CheckTombstoneActorState<Transaction, CheckTombstoneActor<Transaction>>(tr, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkTombstone", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8841464470257082624UL, 791172445388438528UL);
		ActorExecutionContextHelper __helper(static_cast<CheckTombstoneActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkTombstone");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkTombstone", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckTombstoneActor<Transaction>, 0, Optional<TenantTombstoneCleanupData> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckTombstoneActor<Transaction>, 1, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<bool> checkTombstone( Transaction const& tr, int64_t const& id ) {
															#line 149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<bool>(new CheckTombstoneActor<Transaction>(tr, id));
															#line 2445 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 165 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

// Creates a tenant. If the tenant already exists, the boolean return parameter will be false
// and the existing entry will be returned. If the tenant cannot be created, then the optional will be empty.
															#line 2452 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via createTenantTransaction()
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class CreateTenantTransactionActor>
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class CreateTenantTransactionActorState {
															#line 2458 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	CreateTenantTransactionActorState(Transaction const& tr,TenantMapEntry const& tenantEntry,ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantEntry(tenantEntry),
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   clusterType(clusterType)
															#line 2469 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("createTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("createTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(clusterType != ClusterType::METACLUSTER_MANAGEMENT);
															#line 172 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(tenantEntry.id >= 0);
															#line 174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (tenantEntry.tenantName.startsWith("\xff"_sr))
															#line 2488 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 175 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Invalid tenant name");
															#line 176 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				return a_body1Catch1(invalid_tenant_name(), loopDepth);
															#line 2494 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
															#line 178 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (tenantEntry.tenantGroup.present() && tenantEntry.tenantGroup.get().startsWith("\xff"_sr))
															#line 2498 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 179 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Invalid tenant group name");
															#line 180 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				return a_body1Catch1(invalid_tenant_group_name(), loopDepth);
															#line 2504 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
															#line 183 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 185 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			existingEntryFuture = tryGetTenantTransaction(tr, tenantEntry.tenantName);
															#line 186 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tenantModeCheck = checkTenantMode(tr, clusterType);
															#line 187 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tombstoneFuture = (clusterType == ClusterType::STANDALONE) ? false : checkTombstone(tr, tenantEntry.id);
															#line 189 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			existingTenantGroupEntryFuture = Future<Optional<TenantGroupEntry>>();
															#line 190 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (tenantEntry.tenantGroup.present())
															#line 2518 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 191 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				existingTenantGroupEntryFuture = TenantMetadata::tenantGroupMap().get(tr, tenantEntry.tenantGroup.get());
															#line 2522 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
															#line 194 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_0 = tenantModeCheck;
															#line 194 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2528 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 194 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 0, Void >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 2533 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantTransactionActorState();
		static_cast<CreateTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = existingEntryFuture;
															#line 195 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2558 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 1, Optional<TenantMapEntry> >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 2563 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 195 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = existingEntryFuture;
															#line 195 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2574 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 195 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 1, Optional<TenantMapEntry> >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 2579 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantTransactionActor*>(this)->ActorCallback< CreateTenantTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Optional<TenantMapEntry> const& existingEntry,int loopDepth) 
	{
															#line 196 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (existingEntry.present())
															#line 2663 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 197 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Create tenant already exists");
															#line 198 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<CreateTenantTransactionActor*>(this)->SAV<std::pair<Optional<TenantMapEntry>, bool>>::futures) { (void)(std::make_pair(existingEntry.get(), false)); this->~CreateTenantTransactionActorState(); static_cast<CreateTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 2669 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<CreateTenantTransactionActor*>(this)->SAV< std::pair<Optional<TenantMapEntry>, bool> >::value()) std::pair<Optional<TenantMapEntry>, bool>(std::make_pair(existingEntry.get(), false));
			this->~CreateTenantTransactionActorState();
			static_cast<CreateTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<bool> __when_expr_2 = tombstoneFuture;
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2679 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 3;
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 2, bool >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 2684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Optional<TenantMapEntry> && existingEntry,int loopDepth) 
	{
															#line 196 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (existingEntry.present())
															#line 2693 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 197 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Create tenant already exists");
															#line 198 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<CreateTenantTransactionActor*>(this)->SAV<std::pair<Optional<TenantMapEntry>, bool>>::futures) { (void)(std::make_pair(existingEntry.get(), false)); this->~CreateTenantTransactionActorState(); static_cast<CreateTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 2699 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<CreateTenantTransactionActor*>(this)->SAV< std::pair<Optional<TenantMapEntry>, bool> >::value()) std::pair<Optional<TenantMapEntry>, bool>(std::make_pair(existingEntry.get(), false));
			this->~CreateTenantTransactionActorState();
			static_cast<CreateTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<bool> __when_expr_2 = tombstoneFuture;
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2709 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont5when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 3;
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 2, bool >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 2714 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> const& existingEntry,int loopDepth) 
	{
		loopDepth = a_body1cont5(existingEntry, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> && existingEntry,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(existingEntry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantTransactionActor*>(this)->ActorCallback< CreateTenantTransactionActor, 1, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 202 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (hasTombstone)
															#line 2798 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 203 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(hasTombstone, "Tenant creation blocked by tombstone");
															#line 204 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<CreateTenantTransactionActor*>(this)->SAV<std::pair<Optional<TenantMapEntry>, bool>>::futures) { (void)(std::make_pair(Optional<TenantMapEntry>(), false)); this->~CreateTenantTransactionActorState(); static_cast<CreateTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 2804 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<CreateTenantTransactionActor*>(this)->SAV< std::pair<Optional<TenantMapEntry>, bool> >::value()) std::pair<Optional<TenantMapEntry>, bool>(std::make_pair(Optional<TenantMapEntry>(), false));
			this->~CreateTenantTransactionActorState();
			static_cast<CreateTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		prefixRangeFuture = tr->getRange(prefixRange(tenantEntry.prefix), 1);
															#line 210 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<RangeResult> __when_expr_3 = safeThreadFutureToFuture(prefixRangeFuture);
															#line 210 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2816 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 4;
															#line 210 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 3, RangeResult >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 2821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(bool const& __hasTombstone,int loopDepth) 
	{
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		hasTombstone = __hasTombstone;
															#line 2830 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(bool && __hasTombstone,int loopDepth) 
	{
		hasTombstone = std::move(__hasTombstone);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantTransactionActor*>(this)->ActorCallback< CreateTenantTransactionActor, 2, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 2, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 2, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateTenantTransactionActor, 2, bool >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(RangeResult const& contents,int loopDepth) 
	{
															#line 211 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!contents.empty())
															#line 2909 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 212 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(hasTombstone, "Tenant creation conflict with existing data", probe::decoration::rare);
															#line 213 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_prefix_allocator_conflict(), loopDepth);
															#line 2915 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 216 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantMap().set(tr, tenantEntry.id, tenantEntry);
															#line 217 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantNameIndex().set(tr, tenantEntry.tenantName, tenantEntry.id);
															#line 218 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::lastTenantModification().setVersionstamp(tr, Versionstamp(), 0);
															#line 220 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantEntry.tenantGroup.present())
															#line 2925 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 221 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupTenantIndex().insert( tr, Tuple::makeTuple(tenantEntry.tenantGroup.get(), tenantEntry.tenantName, tenantEntry.id));
															#line 225 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantGroupEntry>> __when_expr_4 = existingTenantGroupEntryFuture;
															#line 225 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2933 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
			static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 5;
															#line 225 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 4, Optional<TenantGroupEntry> >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 2938 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(RangeResult && contents,int loopDepth) 
	{
															#line 211 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!contents.empty())
															#line 2952 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 212 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(hasTombstone, "Tenant creation conflict with existing data", probe::decoration::rare);
															#line 213 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_prefix_allocator_conflict(), loopDepth);
															#line 2958 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 216 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantMap().set(tr, tenantEntry.id, tenantEntry);
															#line 217 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantNameIndex().set(tr, tenantEntry.tenantName, tenantEntry.id);
															#line 218 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::lastTenantModification().setVersionstamp(tr, Versionstamp(), 0);
															#line 220 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantEntry.tenantGroup.present())
															#line 2968 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 221 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupTenantIndex().insert( tr, Tuple::makeTuple(tenantEntry.tenantGroup.get(), tenantEntry.tenantName, tenantEntry.id));
															#line 225 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantGroupEntry>> __when_expr_4 = existingTenantGroupEntryFuture;
															#line 225 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2976 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
			static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 5;
															#line 225 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 4, Optional<TenantGroupEntry> >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 2981 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(RangeResult const& contents,int loopDepth) 
	{
		loopDepth = a_body1cont8(contents, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(RangeResult && contents,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(contents), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantTransactionActor*>(this)->ActorCallback< CreateTenantTransactionActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateTenantTransactionActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 232 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantCount().atomicOp(tr, 1, MutationRef::AddValue);
															#line 236 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<int64_t> __when_expr_5 = TenantMetadata::tenantCount().getD(tr, Snapshot::False, 0);
															#line 236 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3074 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10when1(__when_expr_5.get(), loopDepth); };
		static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 6;
															#line 236 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CreateTenantTransactionActor, 5, int64_t >*>(static_cast<CreateTenantTransactionActor*>(this)));
															#line 3079 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12(Optional<TenantGroupEntry> const& existingTenantGroup,int loopDepth) 
	{
															#line 226 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!existingTenantGroup.present())
															#line 3088 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 227 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupMap().set(tr, tenantEntry.tenantGroup.get(), TenantGroupEntry());
															#line 3092 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Optional<TenantGroupEntry> && existingTenantGroup,int loopDepth) 
	{
															#line 226 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!existingTenantGroup.present())
															#line 3102 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 227 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupMap().set(tr, tenantEntry.tenantGroup.get(), TenantGroupEntry());
															#line 3106 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Optional<TenantGroupEntry> const& existingTenantGroup,int loopDepth) 
	{
		loopDepth = a_body1cont12(existingTenantGroup, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Optional<TenantGroupEntry> && existingTenantGroup,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(existingTenantGroup), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantTransactionActor*>(this)->ActorCallback< CreateTenantTransactionActor, 4, Optional<TenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 4, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 4, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CreateTenantTransactionActor, 4, Optional<TenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10cont1(int64_t const& tenantCount,int loopDepth) 
	{
															#line 237 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantCount > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER)
															#line 3191 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 238 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant creation would exceed cluster capacity");
															#line 239 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 3197 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 242 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<CreateTenantTransactionActor*>(this)->SAV<std::pair<Optional<TenantMapEntry>, bool>>::futures) { (void)(std::make_pair(tenantEntry, true)); this->~CreateTenantTransactionActorState(); static_cast<CreateTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 3201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<CreateTenantTransactionActor*>(this)->SAV< std::pair<Optional<TenantMapEntry>, bool> >::value()) std::pair<Optional<TenantMapEntry>, bool>(std::make_pair(tenantEntry, true));
		this->~CreateTenantTransactionActorState();
		static_cast<CreateTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10cont1(int64_t && tenantCount,int loopDepth) 
	{
															#line 237 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantCount > CLIENT_KNOBS->MAX_TENANTS_PER_CLUSTER)
															#line 3213 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 238 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant creation would exceed cluster capacity");
															#line 239 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(cluster_no_capacity(), loopDepth);
															#line 3219 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 242 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<CreateTenantTransactionActor*>(this)->SAV<std::pair<Optional<TenantMapEntry>, bool>>::futures) { (void)(std::make_pair(tenantEntry, true)); this->~CreateTenantTransactionActorState(); static_cast<CreateTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 3223 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<CreateTenantTransactionActor*>(this)->SAV< std::pair<Optional<TenantMapEntry>, bool> >::value()) std::pair<Optional<TenantMapEntry>, bool>(std::make_pair(tenantEntry, true));
		this->~CreateTenantTransactionActorState();
		static_cast<CreateTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10when1(int64_t const& tenantCount,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(tenantCount, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(int64_t && tenantCount,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(tenantCount), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantTransactionActor*>(this)->ActorCallback< CreateTenantTransactionActor, 5, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 5, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CreateTenantTransactionActor, 5, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CreateTenantTransactionActor, 5, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantMapEntry tenantEntry;
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType clusterType;
															#line 185 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Optional<TenantMapEntry>> existingEntryFuture;
															#line 186 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Void> tenantModeCheck;
															#line 187 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<bool> tombstoneFuture;
															#line 189 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Optional<TenantGroupEntry>> existingTenantGroupEntryFuture;
															#line 201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	bool hasTombstone;
															#line 207 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	typename transaction_future_type<Transaction, RangeResult>::type prefixRangeFuture;
															#line 3324 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via createTenantTransaction()
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class CreateTenantTransactionActor final : public Actor<std::pair<Optional<TenantMapEntry>, bool>>, public ActorCallback< CreateTenantTransactionActor<Transaction>, 0, Void >, public ActorCallback< CreateTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >, public ActorCallback< CreateTenantTransactionActor<Transaction>, 2, bool >, public ActorCallback< CreateTenantTransactionActor<Transaction>, 3, RangeResult >, public ActorCallback< CreateTenantTransactionActor<Transaction>, 4, Optional<TenantGroupEntry> >, public ActorCallback< CreateTenantTransactionActor<Transaction>, 5, int64_t >, public FastAllocated<CreateTenantTransactionActor<Transaction>>, public CreateTenantTransactionActorState<Transaction, CreateTenantTransactionActor<Transaction>> {
															#line 3331 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<CreateTenantTransactionActor<Transaction>>::operator new;
	using FastAllocated<CreateTenantTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8200538369671143424UL, 12524974231901233920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::pair<Optional<TenantMapEntry>, bool>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantTransactionActor<Transaction>, 0, Void >;
friend struct ActorCallback< CreateTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >;
friend struct ActorCallback< CreateTenantTransactionActor<Transaction>, 2, bool >;
friend struct ActorCallback< CreateTenantTransactionActor<Transaction>, 3, RangeResult >;
friend struct ActorCallback< CreateTenantTransactionActor<Transaction>, 4, Optional<TenantGroupEntry> >;
friend struct ActorCallback< CreateTenantTransactionActor<Transaction>, 5, int64_t >;
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	CreateTenantTransactionActor(Transaction const& tr,TenantMapEntry const& tenantEntry,ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 3353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<std::pair<Optional<TenantMapEntry>, bool>>(),
		   CreateTenantTransactionActorState<Transaction, CreateTenantTransactionActor<Transaction>>(tr, tenantEntry, clusterType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12204500930555139328UL, 9770710673183795968UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantTransactionActor<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateTenantTransactionActor<Transaction>, 2, bool >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateTenantTransactionActor<Transaction>, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CreateTenantTransactionActor<Transaction>, 4, Optional<TenantGroupEntry> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CreateTenantTransactionActor<Transaction>, 5, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<std::pair<Optional<TenantMapEntry>, bool>> createTenantTransaction( Transaction const& tr, TenantMapEntry const& tenantEntry, ClusterType const& clusterType = ClusterType::STANDALONE ) {
															#line 168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<std::pair<Optional<TenantMapEntry>, bool>>(new CreateTenantTransactionActor<Transaction>(tr, tenantEntry, clusterType));
															#line 3392 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 244 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 3397 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via getNextTenantId()
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class GetNextTenantIdActor>
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetNextTenantIdActorState {
															#line 3403 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetNextTenantIdActorState(Transaction const& tr) 
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr)
															#line 3410 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("getNextTenantId", reinterpret_cast<unsigned long>(this));

	}
	~GetNextTenantIdActorState() 
	{
		fdb_probe_actor_destroy("getNextTenantId", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 247 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<int64_t>> __when_expr_0 = TenantMetadata::lastTenantId().get(tr);
															#line 247 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<GetNextTenantIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3427 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetNextTenantIdActor*>(this)->actor_wait_state = 1;
															#line 247 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetNextTenantIdActor, 0, Optional<int64_t> >*>(static_cast<GetNextTenantIdActor*>(this)));
															#line 3432 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetNextTenantIdActorState();
		static_cast<GetNextTenantIdActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 248 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!lastId.present())
															#line 3455 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 250 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<int64_t> __when_expr_1 = TenantMetadata::tenantIdPrefix().getD(tr, Snapshot::False, 0);
															#line 250 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<GetNextTenantIdActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3461 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetNextTenantIdActor*>(this)->actor_wait_state = 2;
															#line 250 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetNextTenantIdActor, 1, int64_t >*>(static_cast<GetNextTenantIdActor*>(this)));
															#line 3466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Optional<int64_t> const& __lastId,int loopDepth) 
	{
															#line 247 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		lastId = __lastId;
															#line 3480 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<int64_t> && __lastId,int loopDepth) 
	{
		lastId = std::move(__lastId);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetNextTenantIdActor*>(this)->actor_wait_state > 0) static_cast<GetNextTenantIdActor*>(this)->actor_wait_state = 0;
		static_cast<GetNextTenantIdActor*>(this)->ActorCallback< GetNextTenantIdActor, 0, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< GetNextTenantIdActor, 0, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("getNextTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetNextTenantIdActor, 0, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("getNextTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetNextTenantIdActor, 0, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("getNextTenantId", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextTenantId", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 255 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		int64_t delta = 1;
															#line 256 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (BUGGIFY)
															#line 3561 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 257 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			delta += deterministicRandom()->randomSkewedUInt32(1, 1e9);
															#line 3565 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 260 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<GetNextTenantIdActor*>(this)->SAV<int64_t>::futures) { (void)(TenantAPI::computeNextTenantId(lastId.get(), delta)); this->~GetNextTenantIdActorState(); static_cast<GetNextTenantIdActor*>(this)->destroy(); return 0; }
															#line 3569 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<GetNextTenantIdActor*>(this)->SAV< int64_t >::value()) int64_t(TenantAPI::computeNextTenantId(lastId.get(), delta));
		this->~GetNextTenantIdActorState();
		static_cast<GetNextTenantIdActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int64_t const& tenantIdPrefix,int loopDepth) 
	{
															#line 252 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		lastId = tenantIdPrefix << 48;
															#line 3581 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t && tenantIdPrefix,int loopDepth) 
	{
															#line 252 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		lastId = tenantIdPrefix << 48;
															#line 3590 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& tenantIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont3(tenantIdPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && tenantIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(tenantIdPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetNextTenantIdActor*>(this)->actor_wait_state > 0) static_cast<GetNextTenantIdActor*>(this)->actor_wait_state = 0;
		static_cast<GetNextTenantIdActor*>(this)->ActorCallback< GetNextTenantIdActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< GetNextTenantIdActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("getNextTenantId", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextTenantId", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetNextTenantIdActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("getNextTenantId", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextTenantId", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetNextTenantIdActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("getNextTenantId", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getNextTenantId", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 247 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Optional<int64_t> lastId;
															#line 3674 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via getNextTenantId()
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class GetNextTenantIdActor final : public Actor<int64_t>, public ActorCallback< GetNextTenantIdActor<Transaction>, 0, Optional<int64_t> >, public ActorCallback< GetNextTenantIdActor<Transaction>, 1, int64_t >, public FastAllocated<GetNextTenantIdActor<Transaction>>, public GetNextTenantIdActorState<Transaction, GetNextTenantIdActor<Transaction>> {
															#line 3681 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<GetNextTenantIdActor<Transaction>>::operator new;
	using FastAllocated<GetNextTenantIdActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13820672710864179968UL, 15468519888772860160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetNextTenantIdActor<Transaction>, 0, Optional<int64_t> >;
friend struct ActorCallback< GetNextTenantIdActor<Transaction>, 1, int64_t >;
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	GetNextTenantIdActor(Transaction const& tr) 
															#line 3699 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<int64_t>(),
		   GetNextTenantIdActorState<Transaction, GetNextTenantIdActor<Transaction>>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getNextTenantId", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18421291915255181824UL, 15546882163285743104UL);
		ActorExecutionContextHelper __helper(static_cast<GetNextTenantIdActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getNextTenantId");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getNextTenantId", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetNextTenantIdActor<Transaction>, 0, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetNextTenantIdActor<Transaction>, 1, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<int64_t> getNextTenantId( Transaction const& tr ) {
															#line 245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<int64_t>(new GetNextTenantIdActor<Transaction>(tr));
															#line 3734 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 262 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 3739 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via createTenant()
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class CreateTenantActor>
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class CreateTenantActorState {
															#line 3745 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	CreateTenantActorState(Reference<DB> const& db,TenantName const& name,TenantMapEntry const& tenantEntry = TenantMapEntry(),ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : db(db),
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   name(name),
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantEntry(tenantEntry),
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   clusterType(clusterType),
															#line 268 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tr(db->createTransaction()),
															#line 270 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   checkExistence(clusterType != ClusterType::METACLUSTER_DATA),
															#line 271 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   generateTenantId(tenantEntry.id < 0)
															#line 3764 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("createTenant", reinterpret_cast<unsigned long>(this));

	}
	~CreateTenantActorState() 
	{
		fdb_probe_actor_destroy("createTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 273 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(generateTenantId, "Create tenant with generated ID");
															#line 275 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(clusterType == ClusterType::STANDALONE || !generateTenantId);
															#line 277 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tenantEntry.tenantName = name;
															#line 279 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			;
															#line 3785 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 281 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 282 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 284 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tenantIdFuture = Future<int64_t>();
															#line 285 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (generateTenantId)
															#line 3822 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 286 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				tenantIdFuture = getNextTenantId(tr);
															#line 3826 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
															#line 289 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (checkExistence)
															#line 3830 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 290 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				StrictFuture<Optional<int64_t>> __when_expr_0 = TenantMetadata::tenantNameIndex().get(tr, name);
															#line 290 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3836 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CreateTenantActor*>(this)->actor_wait_state = 1;
															#line 290 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 0, Optional<int64_t> >*>(static_cast<CreateTenantActor*>(this)));
															#line 3841 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 321 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(e.code() == error_code_commit_unknown_result, "Create tenant maybe committed");
															#line 322 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->onError(e));
															#line 322 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3872 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 5;
															#line 322 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 4, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 3877 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 298 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (generateTenantId)
															#line 3892 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 299 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<int64_t> __when_expr_1 = tenantIdFuture;
															#line 299 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3898 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 2;
															#line 299 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 1, int64_t >*>(static_cast<CreateTenantActor*>(this)));
															#line 3903 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont4(Optional<int64_t> const& existingId,int loopDepth) 
	{
															#line 291 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (existingId.present())
															#line 3917 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 292 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1loopBody1Catch1(tenant_already_exists(), loopDepth);
															#line 3921 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 295 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		checkExistence = false;
															#line 3925 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Optional<int64_t> && existingId,int loopDepth) 
	{
															#line 291 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (existingId.present())
															#line 3934 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 292 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1loopBody1Catch1(tenant_already_exists(), loopDepth);
															#line 3938 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 295 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		checkExistence = false;
															#line 3942 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<int64_t> const& existingId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(existingId, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<int64_t> && existingId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(existingId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 0, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 0, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 0, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 304 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<std::pair<Optional<TenantMapEntry>, bool>> __when_expr_2 = createTenantTransaction(tr, tenantEntry, clusterType);
															#line 304 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4028 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_2.get(), loopDepth); };
		static_cast<CreateTenantActor*>(this)->actor_wait_state = 3;
															#line 304 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 2, std::pair<Optional<TenantMapEntry>, bool> >*>(static_cast<CreateTenantActor*>(this)));
															#line 4033 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(int64_t const& tenantId,int loopDepth) 
	{
															#line 300 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		tenantEntry.setId(tenantId);
															#line 301 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::lastTenantId().set(tr, tenantId);
															#line 4044 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(int64_t && tenantId,int loopDepth) 
	{
															#line 300 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		tenantEntry.setId(tenantId);
															#line 301 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::lastTenantId().set(tr, tenantId);
															#line 4055 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int64_t const& tenantId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(tenantId, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int64_t && tenantId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(tenantId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
															#line 307 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (newTenant.second)
															#line 4139 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 308 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(newTenant.first.present());
															#line 309 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_3 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 309 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<CreateTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4147 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_3.get(), loopDepth); };
			static_cast<CreateTenantActor*>(this)->actor_wait_state = 4;
															#line 309 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CreateTenantActor, 3, Void >*>(static_cast<CreateTenantActor*>(this)));
															#line 4152 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont10cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(std::pair<Optional<TenantMapEntry>, bool> const& __newTenant,int loopDepth) 
	{
															#line 304 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		newTenant = __newTenant;
															#line 4166 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(std::pair<Optional<TenantMapEntry>, bool> && __newTenant,int loopDepth) 
	{
		newTenant = std::move(__newTenant);
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 2, std::pair<Optional<TenantMapEntry>, bool> >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 2, std::pair<Optional<TenantMapEntry>, bool> >*,std::pair<Optional<TenantMapEntry>, bool> const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 2, std::pair<Optional<TenantMapEntry>, bool> >*,std::pair<Optional<TenantMapEntry>, bool> && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 2, std::pair<Optional<TenantMapEntry>, bool> >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10cont1(int loopDepth) 
	{
															#line 319 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<CreateTenantActor*>(this)->SAV<Optional<TenantMapEntry>>::futures) { (void)(newTenant.first); this->~CreateTenantActorState(); static_cast<CreateTenantActor*>(this)->destroy(); return 0; }
															#line 4245 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<CreateTenantActor*>(this)->SAV< Optional<TenantMapEntry> >::value()) Optional<TenantMapEntry>(newTenant.first);
		this->~CreateTenantActorState();
		static_cast<CreateTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TraceEvent("CreatedTenant") .detail("Tenant", name) .detail("TenantId", newTenant.first.get().id) .detail("Prefix", newTenant.first.get().prefix) .detail("TenantGroup", tenantEntry.tenantGroup) .detail("Version", tr->getCommittedVersion());
															#line 4257 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2(Void && _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TraceEvent("CreatedTenant") .detail("Tenant", name) .detail("TenantId", newTenant.first.get().id) .detail("Prefix", newTenant.first.get().prefix) .detail("TenantGroup", tenantEntry.tenantGroup) .detail("Version", tr->getCommittedVersion());
															#line 4266 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CreateTenantActor*>(this)->actor_wait_state > 0) static_cast<CreateTenantActor*>(this)->actor_wait_state = 0;
		static_cast<CreateTenantActor*>(this)->ActorCallback< CreateTenantActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CreateTenantActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CreateTenantActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<DB> db;
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName name;
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantMapEntry tenantEntry;
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType clusterType;
															#line 268 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 270 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	bool checkExistence;
															#line 271 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	bool generateTenantId;
															#line 284 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<int64_t> tenantIdFuture;
															#line 304 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	std::pair<Optional<TenantMapEntry>, bool> newTenant;
															#line 4451 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via createTenant()
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class CreateTenantActor final : public Actor<Optional<TenantMapEntry>>, public ActorCallback< CreateTenantActor<DB>, 0, Optional<int64_t> >, public ActorCallback< CreateTenantActor<DB>, 1, int64_t >, public ActorCallback< CreateTenantActor<DB>, 2, std::pair<Optional<TenantMapEntry>, bool> >, public ActorCallback< CreateTenantActor<DB>, 3, Void >, public ActorCallback< CreateTenantActor<DB>, 4, Void >, public FastAllocated<CreateTenantActor<DB>>, public CreateTenantActorState<DB, CreateTenantActor<DB>> {
															#line 4458 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<CreateTenantActor<DB>>::operator new;
	using FastAllocated<CreateTenantActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13550391811760191488UL, 8831054542008284160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<TenantMapEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CreateTenantActor<DB>, 0, Optional<int64_t> >;
friend struct ActorCallback< CreateTenantActor<DB>, 1, int64_t >;
friend struct ActorCallback< CreateTenantActor<DB>, 2, std::pair<Optional<TenantMapEntry>, bool> >;
friend struct ActorCallback< CreateTenantActor<DB>, 3, Void >;
friend struct ActorCallback< CreateTenantActor<DB>, 4, Void >;
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	CreateTenantActor(Reference<DB> const& db,TenantName const& name,TenantMapEntry const& tenantEntry = TenantMapEntry(),ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 4479 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Optional<TenantMapEntry>>(),
		   CreateTenantActorState<DB, CreateTenantActor<DB>>(db, name, tenantEntry, clusterType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("createTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2480746510970185984UL, 428737674404862208UL);
		ActorExecutionContextHelper __helper(static_cast<CreateTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("createTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("createTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CreateTenantActor<DB>, 0, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CreateTenantActor<DB>, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CreateTenantActor<DB>, 2, std::pair<Optional<TenantMapEntry>, bool> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CreateTenantActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CreateTenantActor<DB>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Optional<TenantMapEntry>> createTenant( Reference<DB> const& db, TenantName const& name, TenantMapEntry const& tenantEntry = TenantMapEntry(), ClusterType const& clusterType = ClusterType::STANDALONE ) {
															#line 263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Optional<TenantMapEntry>>(new CreateTenantActor<DB>(db, name, tenantEntry, clusterType));
															#line 4517 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 326 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 4522 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via markTenantTombstones()
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class MarkTenantTombstonesActor>
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class MarkTenantTombstonesActorState {
															#line 4528 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	MarkTenantTombstonesActorState(Transaction const& tr,int64_t const& tenantId) 
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantId(tenantId),
															#line 330 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   latestTombstoneFuture(TenantMetadata::tenantTombstones().getRange(tr, {}, {}, 1, Snapshot::False, Reverse::True)),
															#line 332 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantIdPrefixFuture(TenantMetadata::tenantIdPrefix().getD(tr, Snapshot::False, 0))
															#line 4541 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("markTenantTombstones", reinterpret_cast<unsigned long>(this));

	}
	~MarkTenantTombstonesActorState() 
	{
		fdb_probe_actor_destroy("markTenantTombstones", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 333 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantTombstoneCleanupData>> __when_expr_0 = TenantMetadata::tombstoneCleanupData().get(tr);
															#line 333 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4558 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 1;
															#line 333 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MarkTenantTombstonesActor, 0, Optional<TenantTombstoneCleanupData> >*>(static_cast<MarkTenantTombstonesActor*>(this)));
															#line 4563 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MarkTenantTombstonesActorState();
		static_cast<MarkTenantTombstonesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 334 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Version> __when_expr_1 = safeThreadFutureToFuture(tr->getReadVersion());
															#line 334 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4588 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 2;
															#line 334 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MarkTenantTombstonesActor, 1, Version >*>(static_cast<MarkTenantTombstonesActor*>(this)));
															#line 4593 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Optional<TenantTombstoneCleanupData> const& __cleanupData,int loopDepth) 
	{
															#line 333 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		cleanupData = __cleanupData;
															#line 4602 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<TenantTombstoneCleanupData> && __cleanupData,int loopDepth) 
	{
		cleanupData = std::move(__cleanupData);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantTombstonesActor*>(this)->ActorCallback< MarkTenantTombstonesActor, 0, Optional<TenantTombstoneCleanupData> >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantTombstonesActor, 0, Optional<TenantTombstoneCleanupData> >*,Optional<TenantTombstoneCleanupData> const& value) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MarkTenantTombstonesActor, 0, Optional<TenantTombstoneCleanupData> >*,Optional<TenantTombstoneCleanupData> && value) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MarkTenantTombstonesActor, 0, Optional<TenantTombstoneCleanupData> >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 338 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<int64_t> __when_expr_2 = tenantIdPrefixFuture;
															#line 338 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4683 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 3;
															#line 338 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MarkTenantTombstonesActor, 2, int64_t >*>(static_cast<MarkTenantTombstonesActor*>(this)));
															#line 4688 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Version const& __transactionReadVersion,int loopDepth) 
	{
															#line 334 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		transactionReadVersion = __transactionReadVersion;
															#line 4697 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Version && __transactionReadVersion,int loopDepth) 
	{
		transactionReadVersion = std::move(__transactionReadVersion);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantTombstonesActor*>(this)->ActorCallback< MarkTenantTombstonesActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantTombstonesActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MarkTenantTombstonesActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MarkTenantTombstonesActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int64_t const& tenantIdPrefix,int loopDepth) 
	{
															#line 339 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantIdPrefix != TenantAPI::getTenantIdPrefix(tenantId))
															#line 4776 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Skipping tenant tombstone for tenant with different prefix");
															#line 341 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<MarkTenantTombstonesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantTombstonesActorState(); static_cast<MarkTenantTombstonesActor*>(this)->destroy(); return 0; }
															#line 4782 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<MarkTenantTombstonesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MarkTenantTombstonesActorState();
			static_cast<MarkTenantTombstonesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 345 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!cleanupData.present() || cleanupData.get().nextTombstoneEraseVersion <= transactionReadVersion)
															#line 4790 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			deleteThroughId = cleanupData.present() ? cleanupData.get().nextTombstoneEraseId : -1;
															#line 348 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (deleteThroughId >= 0)
															#line 4796 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 349 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Deleting tenant tombstones");
															#line 350 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				TenantMetadata::tenantTombstones().erase(tr, 0, deleteThroughId + 1);
															#line 4802 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
															#line 353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<KeyBackedRangeResult<int64_t>> __when_expr_3 = latestTombstoneFuture;
															#line 353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 4;
															#line 353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MarkTenantTombstonesActor, 3, KeyBackedRangeResult<int64_t> >*>(static_cast<MarkTenantTombstonesActor*>(this)));
															#line 4813 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 374 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (tenantId > cleanupData.get().tombstonesErasedThrough)
															#line 4820 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 376 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				TenantMetadata::tenantTombstones().insert(tr, tenantId);
															#line 4824 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int64_t && tenantIdPrefix,int loopDepth) 
	{
															#line 339 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantIdPrefix != TenantAPI::getTenantIdPrefix(tenantId))
															#line 4835 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 340 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Skipping tenant tombstone for tenant with different prefix");
															#line 341 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<MarkTenantTombstonesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantTombstonesActorState(); static_cast<MarkTenantTombstonesActor*>(this)->destroy(); return 0; }
															#line 4841 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<MarkTenantTombstonesActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~MarkTenantTombstonesActorState();
			static_cast<MarkTenantTombstonesActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 345 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!cleanupData.present() || cleanupData.get().nextTombstoneEraseVersion <= transactionReadVersion)
															#line 4849 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			deleteThroughId = cleanupData.present() ? cleanupData.get().nextTombstoneEraseId : -1;
															#line 348 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (deleteThroughId >= 0)
															#line 4855 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 349 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Deleting tenant tombstones");
															#line 350 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				TenantMetadata::tenantTombstones().erase(tr, 0, deleteThroughId + 1);
															#line 4861 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
															#line 353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<KeyBackedRangeResult<int64_t>> __when_expr_3 = latestTombstoneFuture;
															#line 353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4867 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 4;
															#line 353 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MarkTenantTombstonesActor, 3, KeyBackedRangeResult<int64_t> >*>(static_cast<MarkTenantTombstonesActor*>(this)));
															#line 4872 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 374 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (tenantId > cleanupData.get().tombstonesErasedThrough)
															#line 4879 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 376 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				TenantMetadata::tenantTombstones().insert(tr, tenantId);
															#line 4883 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& tenantIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont3(tenantIdPrefix, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && tenantIdPrefix,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(tenantIdPrefix), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantTombstonesActor*>(this)->ActorCallback< MarkTenantTombstonesActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantTombstonesActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MarkTenantTombstonesActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MarkTenantTombstonesActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 378 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<MarkTenantTombstonesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~MarkTenantTombstonesActorState(); static_cast<MarkTenantTombstonesActor*>(this)->destroy(); return 0; }
															#line 4969 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<MarkTenantTombstonesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~MarkTenantTombstonesActorState();
		static_cast<MarkTenantTombstonesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(KeyBackedRangeResult<int64_t> const& latestTombstone,int loopDepth) 
	{
															#line 354 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		int64_t nextDeleteThroughId = std::max(deleteThroughId, tenantId);
															#line 355 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!latestTombstone.results.empty())
															#line 4983 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 356 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			nextDeleteThroughId = std::max(nextDeleteThroughId, latestTombstone.results[0]);
															#line 4987 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 361 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantTombstoneCleanupData updatedCleanupData;
															#line 362 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		updatedCleanupData.tombstonesErasedThrough = deleteThroughId;
															#line 363 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		updatedCleanupData.nextTombstoneEraseId = nextDeleteThroughId;
															#line 364 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		updatedCleanupData.nextTombstoneEraseVersion = transactionReadVersion + CLIENT_KNOBS->TENANT_TOMBSTONE_CLEANUP_INTERVAL * CLIENT_KNOBS->VERSIONS_PER_SECOND;
															#line 368 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tombstoneCleanupData().set(tr, updatedCleanupData);
															#line 371 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantId > updatedCleanupData.tombstonesErasedThrough)
															#line 5001 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 372 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantTombstones().insert(tr, tenantId);
															#line 5005 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(KeyBackedRangeResult<int64_t> && latestTombstone,int loopDepth) 
	{
															#line 354 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		int64_t nextDeleteThroughId = std::max(deleteThroughId, tenantId);
															#line 355 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!latestTombstone.results.empty())
															#line 5017 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 356 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			nextDeleteThroughId = std::max(nextDeleteThroughId, latestTombstone.results[0]);
															#line 5021 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 361 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantTombstoneCleanupData updatedCleanupData;
															#line 362 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		updatedCleanupData.tombstonesErasedThrough = deleteThroughId;
															#line 363 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		updatedCleanupData.nextTombstoneEraseId = nextDeleteThroughId;
															#line 364 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		updatedCleanupData.nextTombstoneEraseVersion = transactionReadVersion + CLIENT_KNOBS->TENANT_TOMBSTONE_CLEANUP_INTERVAL * CLIENT_KNOBS->VERSIONS_PER_SECOND;
															#line 368 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tombstoneCleanupData().set(tr, updatedCleanupData);
															#line 371 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantId > updatedCleanupData.tombstonesErasedThrough)
															#line 5035 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 372 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantTombstones().insert(tr, tenantId);
															#line 5039 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyBackedRangeResult<int64_t> const& latestTombstone,int loopDepth) 
	{
		loopDepth = a_body1cont6(latestTombstone, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(KeyBackedRangeResult<int64_t> && latestTombstone,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(latestTombstone), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state > 0) static_cast<MarkTenantTombstonesActor*>(this)->actor_wait_state = 0;
		static_cast<MarkTenantTombstonesActor*>(this)->ActorCallback< MarkTenantTombstonesActor, 3, KeyBackedRangeResult<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< MarkTenantTombstonesActor, 3, KeyBackedRangeResult<int64_t> >*,KeyBackedRangeResult<int64_t> const& value) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MarkTenantTombstonesActor, 3, KeyBackedRangeResult<int64_t> >*,KeyBackedRangeResult<int64_t> && value) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MarkTenantTombstonesActor, 3, KeyBackedRangeResult<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int64_t tenantId;
															#line 330 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<KeyBackedRangeResult<int64_t>> latestTombstoneFuture;
															#line 332 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<int64_t> tenantIdPrefixFuture;
															#line 333 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Optional<TenantTombstoneCleanupData> cleanupData;
															#line 334 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Version transactionReadVersion;
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int64_t deleteThroughId;
															#line 5134 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via markTenantTombstones()
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class MarkTenantTombstonesActor final : public Actor<Void>, public ActorCallback< MarkTenantTombstonesActor<Transaction>, 0, Optional<TenantTombstoneCleanupData> >, public ActorCallback< MarkTenantTombstonesActor<Transaction>, 1, Version >, public ActorCallback< MarkTenantTombstonesActor<Transaction>, 2, int64_t >, public ActorCallback< MarkTenantTombstonesActor<Transaction>, 3, KeyBackedRangeResult<int64_t> >, public FastAllocated<MarkTenantTombstonesActor<Transaction>>, public MarkTenantTombstonesActorState<Transaction, MarkTenantTombstonesActor<Transaction>> {
															#line 5141 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<MarkTenantTombstonesActor<Transaction>>::operator new;
	using FastAllocated<MarkTenantTombstonesActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8539769159866019584UL, 8365932393017718016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MarkTenantTombstonesActor<Transaction>, 0, Optional<TenantTombstoneCleanupData> >;
friend struct ActorCallback< MarkTenantTombstonesActor<Transaction>, 1, Version >;
friend struct ActorCallback< MarkTenantTombstonesActor<Transaction>, 2, int64_t >;
friend struct ActorCallback< MarkTenantTombstonesActor<Transaction>, 3, KeyBackedRangeResult<int64_t> >;
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	MarkTenantTombstonesActor(Transaction const& tr,int64_t const& tenantId) 
															#line 5161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Void>(),
		   MarkTenantTombstonesActorState<Transaction, MarkTenantTombstonesActor<Transaction>>(tr, tenantId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("markTenantTombstones", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9871405848422946048UL, 13456856781044593920UL);
		ActorExecutionContextHelper __helper(static_cast<MarkTenantTombstonesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("markTenantTombstones");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("markTenantTombstones", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MarkTenantTombstonesActor<Transaction>, 0, Optional<TenantTombstoneCleanupData> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MarkTenantTombstonesActor<Transaction>, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MarkTenantTombstonesActor<Transaction>, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MarkTenantTombstonesActor<Transaction>, 3, KeyBackedRangeResult<int64_t> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Void> markTenantTombstones( Transaction const& tr, int64_t const& tenantId ) {
															#line 327 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Void>(new MarkTenantTombstonesActor<Transaction>(tr, tenantId));
															#line 5198 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 380 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

// Deletes a tenant with the given ID. If no matching tenant is found, this function returns without deleting anything.
// This behavior allows the function to be used idempotently: if the transaction is retried after having succeeded, it
// will see that the tenant is absent and do nothing.
															#line 5206 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via deleteTenantTransaction()
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class DeleteTenantTransactionActor>
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class DeleteTenantTransactionActorState {
															#line 5212 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	DeleteTenantTransactionActorState(Transaction const& tr,int64_t const& tenantId,ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantId(tenantId),
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   clusterType(clusterType)
															#line 5223 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("deleteTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("deleteTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 388 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(tenantId != TenantInfo::INVALID_TENANT);
															#line 389 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(clusterType != ClusterType::METACLUSTER_MANAGEMENT);
															#line 391 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 393 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tenantEntryFuture = tryGetTenantTransaction(tr, tenantId);
															#line 394 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_0 = checkTenantMode(tr, clusterType);
															#line 394 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5248 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 394 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantTransactionActor, 0, Void >*>(static_cast<DeleteTenantTransactionActor*>(this)));
															#line 5253 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantTransactionActorState();
		static_cast<DeleteTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = tenantEntryFuture;
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5278 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantTransactionActor, 1, Optional<TenantMapEntry> >*>(static_cast<DeleteTenantTransactionActor*>(this)));
															#line 5283 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Optional<TenantMapEntry>> __when_expr_1 = tenantEntryFuture;
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5294 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantTransactionActor, 1, Optional<TenantMapEntry> >*>(static_cast<DeleteTenantTransactionActor*>(this)));
															#line 5299 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantTransactionActor*>(this)->ActorCallback< DeleteTenantTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 397 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantEntry.present())
															#line 5383 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 398 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			prefixRangeFuture = tr->getRange(prefixRange(tenantEntry.get().prefix), 1);
															#line 401 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<RangeResult> __when_expr_2 = safeThreadFutureToFuture(prefixRangeFuture);
															#line 401 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5391 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 3;
															#line 401 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantTransactionActor, 2, RangeResult >*>(static_cast<DeleteTenantTransactionActor*>(this)));
															#line 5396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 429 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Delete non-existent tenant");
															#line 5403 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> const& __tenantEntry,int loopDepth) 
	{
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		tenantEntry = __tenantEntry;
															#line 5413 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<TenantMapEntry> && __tenantEntry,int loopDepth) 
	{
		tenantEntry = std::move(__tenantEntry);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantTransactionActor*>(this)->ActorCallback< DeleteTenantTransactionActor, 1, Optional<TenantMapEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> const& value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Optional<TenantMapEntry> && value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteTenantTransactionActor, 1, Optional<TenantMapEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 432 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (clusterType == ClusterType::METACLUSTER_DATA)
															#line 5492 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 433 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_4 = markTenantTombstones(tr, tenantId);
															#line 433 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5498 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont3when1(__when_expr_4.get(), loopDepth); };
			static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 5;
															#line 433 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantTransactionActor, 4, Void >*>(static_cast<DeleteTenantTransactionActor*>(this)));
															#line 5503 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(RangeResult const& contents,int loopDepth) 
	{
															#line 402 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!contents.empty())
															#line 5517 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 403 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Attempt deletion of non-empty tenant");
															#line 404 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_empty(), loopDepth);
															#line 5523 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 408 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantMap().erase(tr, tenantId);
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantNameIndex().erase(tr, tenantEntry.get().tenantName);
															#line 410 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantCount().atomicOp(tr, -1, MutationRef::AddValue);
															#line 411 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::lastTenantModification().setVersionstamp(tr, Versionstamp(), 0);
															#line 413 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantEntry.get().tenantGroup.present())
															#line 5535 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 414 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupTenantIndex().erase( tr, Tuple::makeTuple(tenantEntry.get().tenantGroup.get(), tenantEntry.get().tenantName, tenantId));
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<KeyBackedSet<Tuple>::RangeResultType> __when_expr_3 = TenantMetadata::tenantGroupTenantIndex().getRange( tr, Tuple::makeTuple(tenantEntry.get().tenantGroup.get()), Tuple::makeTuple(keyAfter(tenantEntry.get().tenantGroup.get())), 2);
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5543 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 4;
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantTransactionActor, 3, KeyBackedSet<Tuple>::RangeResultType >*>(static_cast<DeleteTenantTransactionActor*>(this)));
															#line 5548 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(RangeResult && contents,int loopDepth) 
	{
															#line 402 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!contents.empty())
															#line 5562 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 403 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Attempt deletion of non-empty tenant");
															#line 404 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_empty(), loopDepth);
															#line 5568 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 408 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantMap().erase(tr, tenantId);
															#line 409 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantNameIndex().erase(tr, tenantEntry.get().tenantName);
															#line 410 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantCount().atomicOp(tr, -1, MutationRef::AddValue);
															#line 411 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::lastTenantModification().setVersionstamp(tr, Versionstamp(), 0);
															#line 413 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantEntry.get().tenantGroup.present())
															#line 5580 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 414 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupTenantIndex().erase( tr, Tuple::makeTuple(tenantEntry.get().tenantGroup.get(), tenantEntry.get().tenantName, tenantId));
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<KeyBackedSet<Tuple>::RangeResultType> __when_expr_3 = TenantMetadata::tenantGroupTenantIndex().getRange( tr, Tuple::makeTuple(tenantEntry.get().tenantGroup.get()), Tuple::makeTuple(keyAfter(tenantEntry.get().tenantGroup.get())), 2);
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5588 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 4;
															#line 416 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantTransactionActor, 3, KeyBackedSet<Tuple>::RangeResultType >*>(static_cast<DeleteTenantTransactionActor*>(this)));
															#line 5593 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult const& contents,int loopDepth) 
	{
		loopDepth = a_body1cont4(contents, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(RangeResult && contents,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(contents), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantTransactionActor*>(this)->ActorCallback< DeleteTenantTransactionActor, 2, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 2, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 2, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DeleteTenantTransactionActor, 2, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(KeyBackedSet<Tuple>::RangeResultType const& tenantsInGroup,int loopDepth) 
	{
															#line 422 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantsInGroup.results.empty() || (tenantsInGroup.results.size() == 1 && tenantsInGroup.results[0].getInt(2) == tenantId))
															#line 5688 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 424 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Deleting tenant results in empty group");
															#line 425 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupMap().erase(tr, tenantEntry.get().tenantGroup.get());
															#line 5694 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(KeyBackedSet<Tuple>::RangeResultType && tenantsInGroup,int loopDepth) 
	{
															#line 422 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenantsInGroup.results.empty() || (tenantsInGroup.results.size() == 1 && tenantsInGroup.results[0].getInt(2) == tenantId))
															#line 5704 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 424 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Deleting tenant results in empty group");
															#line 425 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupMap().erase(tr, tenantEntry.get().tenantGroup.get());
															#line 5710 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(KeyBackedSet<Tuple>::RangeResultType const& tenantsInGroup,int loopDepth) 
	{
		loopDepth = a_body1cont7(tenantsInGroup, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(KeyBackedSet<Tuple>::RangeResultType && tenantsInGroup,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(tenantsInGroup), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantTransactionActor*>(this)->ActorCallback< DeleteTenantTransactionActor, 3, KeyBackedSet<Tuple>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 3, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 3, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DeleteTenantTransactionActor, 3, KeyBackedSet<Tuple>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 436 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<DeleteTenantTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantTransactionActorState(); static_cast<DeleteTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 5795 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<DeleteTenantTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantTransactionActorState();
		static_cast<DeleteTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantTransactionActor*>(this)->ActorCallback< DeleteTenantTransactionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DeleteTenantTransactionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DeleteTenantTransactionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int64_t tenantId;
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType clusterType;
															#line 393 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Optional<TenantMapEntry>> tenantEntryFuture;
															#line 396 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Optional<TenantMapEntry> tenantEntry;
															#line 398 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	typename transaction_future_type<Transaction, RangeResult>::type prefixRangeFuture;
															#line 5902 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via deleteTenantTransaction()
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class DeleteTenantTransactionActor final : public Actor<Void>, public ActorCallback< DeleteTenantTransactionActor<Transaction>, 0, Void >, public ActorCallback< DeleteTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >, public ActorCallback< DeleteTenantTransactionActor<Transaction>, 2, RangeResult >, public ActorCallback< DeleteTenantTransactionActor<Transaction>, 3, KeyBackedSet<Tuple>::RangeResultType >, public ActorCallback< DeleteTenantTransactionActor<Transaction>, 4, Void >, public FastAllocated<DeleteTenantTransactionActor<Transaction>>, public DeleteTenantTransactionActorState<Transaction, DeleteTenantTransactionActor<Transaction>> {
															#line 5909 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<DeleteTenantTransactionActor<Transaction>>::operator new;
	using FastAllocated<DeleteTenantTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2334812937202404096UL, 3400163414340040704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantTransactionActor<Transaction>, 0, Void >;
friend struct ActorCallback< DeleteTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >;
friend struct ActorCallback< DeleteTenantTransactionActor<Transaction>, 2, RangeResult >;
friend struct ActorCallback< DeleteTenantTransactionActor<Transaction>, 3, KeyBackedSet<Tuple>::RangeResultType >;
friend struct ActorCallback< DeleteTenantTransactionActor<Transaction>, 4, Void >;
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	DeleteTenantTransactionActor(Transaction const& tr,int64_t const& tenantId,ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 5930 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Void>(),
		   DeleteTenantTransactionActorState<Transaction, DeleteTenantTransactionActor<Transaction>>(tr, tenantId, clusterType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11633939529319024896UL, 4734983893055960064UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantTransactionActor<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteTenantTransactionActor<Transaction>, 1, Optional<TenantMapEntry> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DeleteTenantTransactionActor<Transaction>, 2, RangeResult >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DeleteTenantTransactionActor<Transaction>, 3, KeyBackedSet<Tuple>::RangeResultType >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DeleteTenantTransactionActor<Transaction>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Void> deleteTenantTransaction( Transaction const& tr, int64_t const& tenantId, ClusterType const& clusterType = ClusterType::STANDALONE ) {
															#line 384 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Void>(new DeleteTenantTransactionActor<Transaction>(tr, tenantId, clusterType));
															#line 5968 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 438 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

// Deletes the tenant with the given name. If tenantId is specified, the tenant being deleted must also have the same
// ID.
															#line 5975 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via deleteTenant()
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class DeleteTenantActor>
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class DeleteTenantActorState {
															#line 5981 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	DeleteTenantActorState(Reference<DB> const& db,TenantName const& name,Optional<int64_t> const& tenantId = Optional<int64_t>(),ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : db(db),
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   name(name),
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantId(tenantId),
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   clusterType(clusterType),
															#line 446 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tr(db->createTransaction()),
															#line 448 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   checkExistence(clusterType == ClusterType::STANDALONE)
															#line 5998 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	~DeleteTenantActorState() 
	{
		fdb_probe_actor_destroy("deleteTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 449 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			;
															#line 6013 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 451 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 452 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 454 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (checkExistence)
															#line 6048 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 455 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				StrictFuture<Optional<int64_t>> __when_expr_0 = TenantMetadata::tenantNameIndex().get(tr, name);
															#line 455 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6054 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DeleteTenantActor*>(this)->actor_wait_state = 1;
															#line 455 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 0, Optional<int64_t> >*>(static_cast<DeleteTenantActor*>(this)));
															#line 6059 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 475 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(e.code() == error_code_commit_unknown_result, "Delete tenant maybe committed");
															#line 476 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_3 = safeThreadFutureToFuture(tr->onError(e));
															#line 476 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6090 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DeleteTenantActor*>(this)->actor_wait_state = 4;
															#line 476 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 3, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 6095 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_1 = deleteTenantTransaction(tr, tenantId.get(), clusterType);
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6112 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DeleteTenantActor*>(this)->actor_wait_state = 2;
															#line 466 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 1, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 6117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<int64_t> const& actualId,int loopDepth) 
	{
															#line 456 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!actualId.present() || (tenantId.present() && tenantId != actualId))
															#line 6126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 457 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(!actualId.present(), "Delete non-existing tenant");
															#line 458 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(actualId.present(), "Delete tenant with incorrect ID", probe::decoration::rare);
															#line 459 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 6134 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 462 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		tenantId = actualId;
															#line 463 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		checkExistence = false;
															#line 6140 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<int64_t> && actualId,int loopDepth) 
	{
															#line 456 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!actualId.present() || (tenantId.present() && tenantId != actualId))
															#line 6149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 457 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(!actualId.present(), "Delete non-existing tenant");
															#line 458 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(actualId.present(), "Delete tenant with incorrect ID", probe::decoration::rare);
															#line 459 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 6157 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 462 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		tenantId = actualId;
															#line 463 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		checkExistence = false;
															#line 6163 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<int64_t> const& actualId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(actualId, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<int64_t> && actualId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(actualId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 0, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 0, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 0, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 467 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_2 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 467 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6249 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<DeleteTenantActor*>(this)->actor_wait_state = 3;
															#line 467 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 2, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 6254 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 467 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_2 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 467 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6265 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<DeleteTenantActor*>(this)->actor_wait_state = 3;
															#line 467 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DeleteTenantActor, 2, Void >*>(static_cast<DeleteTenantActor*>(this)));
															#line 6270 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TraceEvent("DeletedTenant") .detail("Tenant", name) .detail("TenantId", tenantId) .detail("Version", tr->getCommittedVersion());
															#line 473 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 6356 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 469 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TraceEvent("DeletedTenant") .detail("Tenant", name) .detail("TenantId", tenantId) .detail("Version", tr->getCommittedVersion());
															#line 473 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<DeleteTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteTenantActorState(); static_cast<DeleteTenantActor*>(this)->destroy(); return 0; }
															#line 6370 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<DeleteTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteTenantActorState();
		static_cast<DeleteTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DeleteTenantActor*>(this)->actor_wait_state > 0) static_cast<DeleteTenantActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteTenantActor*>(this)->ActorCallback< DeleteTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DeleteTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DeleteTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<DB> db;
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName name;
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Optional<int64_t> tenantId;
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType clusterType;
															#line 446 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 448 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	bool checkExistence;
															#line 6552 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via deleteTenant()
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class DeleteTenantActor final : public Actor<Void>, public ActorCallback< DeleteTenantActor<DB>, 0, Optional<int64_t> >, public ActorCallback< DeleteTenantActor<DB>, 1, Void >, public ActorCallback< DeleteTenantActor<DB>, 2, Void >, public ActorCallback< DeleteTenantActor<DB>, 3, Void >, public FastAllocated<DeleteTenantActor<DB>>, public DeleteTenantActorState<DB, DeleteTenantActor<DB>> {
															#line 6559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<DeleteTenantActor<DB>>::operator new;
	using FastAllocated<DeleteTenantActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16527373988152386560UL, 14732051244347276288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteTenantActor<DB>, 0, Optional<int64_t> >;
friend struct ActorCallback< DeleteTenantActor<DB>, 1, Void >;
friend struct ActorCallback< DeleteTenantActor<DB>, 2, Void >;
friend struct ActorCallback< DeleteTenantActor<DB>, 3, Void >;
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	DeleteTenantActor(Reference<DB> const& db,TenantName const& name,Optional<int64_t> const& tenantId = Optional<int64_t>(),ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 6579 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Void>(),
		   DeleteTenantActorState<DB, DeleteTenantActor<DB>>(db, name, tenantId, clusterType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14546017859301560576UL, 18123705475076122368UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteTenantActor<DB>, 0, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DeleteTenantActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DeleteTenantActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DeleteTenantActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Void> deleteTenant( Reference<DB> const& db, TenantName const& name, Optional<int64_t> const& tenantId = Optional<int64_t>(), ClusterType const& clusterType = ClusterType::STANDALONE ) {
															#line 441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Void>(new DeleteTenantActor<DB>(db, name, tenantId, clusterType));
															#line 6616 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 480 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

// This should only be called from a transaction that has already confirmed that the tenant entry
// is present. The tenantEntry should start with the existing entry and modify only those fields that need
// to be changed. This must only be called on a non-management cluster.
															#line 6624 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via configureTenantTransaction()
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class ConfigureTenantTransactionActor>
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ConfigureTenantTransactionActorState {
															#line 6630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ConfigureTenantTransactionActorState(Transaction const& tr,TenantMapEntry const& originalEntry,TenantMapEntry const& updatedTenantEntry) 
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   originalEntry(originalEntry),
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   updatedTenantEntry(updatedTenantEntry)
															#line 6641 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("configureTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("configureTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 488 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(updatedTenantEntry.id == originalEntry.id);
															#line 490 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 491 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantMap().set(tr, updatedTenantEntry.id, updatedTenantEntry);
															#line 492 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::lastTenantModification().setVersionstamp(tr, Versionstamp(), 0);
															#line 495 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (originalEntry.tenantGroup != updatedTenantEntry.tenantGroup)
															#line 6664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 496 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (updatedTenantEntry.tenantGroup.present() && updatedTenantEntry.tenantGroup.get().startsWith("\xff"_sr))
															#line 6668 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				{
															#line 497 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					CODE_PROBE(true, "Configure with invalid group name");
															#line 498 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					return a_body1Catch1(invalid_tenant_group_name(), loopDepth);
															#line 6674 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				}
															#line 500 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (originalEntry.tenantGroup.present())
															#line 6678 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				{
															#line 501 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					CODE_PROBE(true, "Change tenant group of tenant already in group");
															#line 503 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					TenantMetadata::tenantGroupTenantIndex().erase( tr, Tuple::makeTuple(originalEntry.tenantGroup.get(), originalEntry.tenantName, updatedTenantEntry.id));
															#line 507 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					StrictFuture<KeyBackedSet<Tuple>::RangeResultType> __when_expr_0 = TenantMetadata::tenantGroupTenantIndex().getRange( tr, Tuple::makeTuple(originalEntry.tenantGroup.get()), Tuple::makeTuple(keyAfter(originalEntry.tenantGroup.get())), 2);
															#line 507 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					if (static_cast<ConfigureTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6688 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ConfigureTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 507 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*>(static_cast<ConfigureTenantTransactionActor*>(this)));
															#line 6693 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureTenantTransactionActorState();
		static_cast<ConfigureTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 538 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		ASSERT_EQ(updatedTenantEntry.tenantLockId.present(), updatedTenantEntry.tenantLockState != TenantLockState::UNLOCKED);
															#line 541 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ConfigureTenantTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureTenantTransactionActorState(); static_cast<ConfigureTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 6728 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ConfigureTenantTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureTenantTransactionActorState();
		static_cast<ConfigureTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 519 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (updatedTenantEntry.tenantGroup.present())
															#line 6740 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 521 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantGroupEntry>> __when_expr_1 = TenantMetadata::tenantGroupMap().get(tr, updatedTenantEntry.tenantGroup.get());
															#line 521 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ConfigureTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6746 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 521 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureTenantTransactionActor, 1, Optional<TenantGroupEntry> >*>(static_cast<ConfigureTenantTransactionActor*>(this)));
															#line 6751 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(KeyBackedSet<Tuple>::RangeResultType const& tenants,int loopDepth) 
	{
															#line 513 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenants.results.empty() || (tenants.results.size() == 1 && tenants.results[0].getInt(2) == updatedTenantEntry.id))
															#line 6765 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 515 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Changing tenant group results in empty group");
															#line 516 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupMap().erase(tr, originalEntry.tenantGroup.get());
															#line 6771 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(KeyBackedSet<Tuple>::RangeResultType && tenants,int loopDepth) 
	{
															#line 513 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (tenants.results.empty() || (tenants.results.size() == 1 && tenants.results[0].getInt(2) == updatedTenantEntry.id))
															#line 6781 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 515 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Changing tenant group results in empty group");
															#line 516 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupMap().erase(tr, originalEntry.tenantGroup.get());
															#line 6787 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType const& tenants,int loopDepth) 
	{
		loopDepth = a_body1cont4(tenants, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType && tenants,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantTransactionActor*>(this)->ActorCallback< ConfigureTenantTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureTenantTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<TenantGroupEntry> const& entry,int loopDepth) 
	{
															#line 523 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!entry.present())
															#line 6878 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 524 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Change tenant group to a new group");
															#line 525 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupMap().set(tr, updatedTenantEntry.tenantGroup.get(), TenantGroupEntry());
															#line 6884 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		else
		{
															#line 527 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Change tenant group to an existing group");
															#line 6890 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 531 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantGroupTenantIndex().insert(tr, Tuple::makeTuple(updatedTenantEntry.tenantGroup.get(), updatedTenantEntry.tenantName, updatedTenantEntry.id));
															#line 6894 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Optional<TenantGroupEntry> && entry,int loopDepth) 
	{
															#line 523 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!entry.present())
															#line 6903 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 524 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Change tenant group to a new group");
															#line 525 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupMap().set(tr, updatedTenantEntry.tenantGroup.get(), TenantGroupEntry());
															#line 6909 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		else
		{
															#line 527 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Change tenant group to an existing group");
															#line 6915 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 531 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantGroupTenantIndex().insert(tr, Tuple::makeTuple(updatedTenantEntry.tenantGroup.get(), updatedTenantEntry.tenantName, updatedTenantEntry.id));
															#line 6919 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<TenantGroupEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont8(entry, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<TenantGroupEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<ConfigureTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureTenantTransactionActor*>(this)->ActorCallback< ConfigureTenantTransactionActor, 1, Optional<TenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureTenantTransactionActor, 1, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureTenantTransactionActor, 1, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureTenantTransactionActor, 1, Optional<TenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantMapEntry originalEntry;
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantMapEntry updatedTenantEntry;
															#line 7005 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via configureTenantTransaction()
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ConfigureTenantTransactionActor final : public Actor<Void>, public ActorCallback< ConfigureTenantTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >, public ActorCallback< ConfigureTenantTransactionActor<Transaction>, 1, Optional<TenantGroupEntry> >, public FastAllocated<ConfigureTenantTransactionActor<Transaction>>, public ConfigureTenantTransactionActorState<Transaction, ConfigureTenantTransactionActor<Transaction>> {
															#line 7012 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<ConfigureTenantTransactionActor<Transaction>>::operator new;
	using FastAllocated<ConfigureTenantTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16005056201419106816UL, 3637476326268861184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureTenantTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >;
friend struct ActorCallback< ConfigureTenantTransactionActor<Transaction>, 1, Optional<TenantGroupEntry> >;
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ConfigureTenantTransactionActor(Transaction const& tr,TenantMapEntry const& originalEntry,TenantMapEntry const& updatedTenantEntry) 
															#line 7030 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Void>(),
		   ConfigureTenantTransactionActorState<Transaction, ConfigureTenantTransactionActor<Transaction>>(tr, originalEntry, updatedTenantEntry),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17722469223758140160UL, 6453698946778000128UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureTenantTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureTenantTransactionActor<Transaction>, 1, Optional<TenantGroupEntry> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Void> configureTenantTransaction( Transaction const& tr, TenantMapEntry const& originalEntry, TenantMapEntry const& updatedTenantEntry ) {
															#line 484 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Void>(new ConfigureTenantTransactionActor<Transaction>(tr, originalEntry, updatedTenantEntry));
															#line 7065 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 543 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

template <class TenantMapEntryT>
bool checkLockState(TenantMapEntryT entry, TenantLockState desiredLockState, UID lockId) {
	if (entry.tenantLockId == lockId && entry.tenantLockState == desiredLockState) {
		CODE_PROBE(true, "Attempting lock change to same state");
		return true;
	}

	if (entry.tenantLockId.present() && entry.tenantLockId.get() != lockId) {
		CODE_PROBE(true, "Attempting invalid lock change");
		throw tenant_locked();
	}

	return false;
}

															#line 7085 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via changeLockState()
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class ChangeLockStateActor>
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ChangeLockStateActorState {
															#line 7091 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ChangeLockStateActorState(Transaction const& tr,int64_t const& tenant,TenantLockState const& desiredLockState,UID const& lockId) 
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenant(tenant),
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   desiredLockState(desiredLockState),
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   lockId(lockId),
															#line 561 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantModeCheck(TenantAPI::checkTenantMode(tr, ClusterType::STANDALONE))
															#line 7106 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("changeLockState", reinterpret_cast<unsigned long>(this));

	}
	~ChangeLockStateActorState() 
	{
		fdb_probe_actor_destroy("changeLockState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 562 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<TenantMapEntry> __when_expr_0 = TenantAPI::getTenantTransaction(tr, tenant);
															#line 562 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7123 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 1;
															#line 562 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 0, TenantMapEntry >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 7128 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeLockStateActorState();
		static_cast<ChangeLockStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 564 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_1 = tenantModeCheck;
															#line 564 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7153 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 2;
															#line 564 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 1, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 7158 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry const& __entry,int loopDepth) 
	{
															#line 562 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		entry = __entry;
															#line 7167 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry && __entry,int loopDepth) 
	{
		entry = std::move(__entry);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateActor*>(this)->ActorCallback< ChangeLockStateActor, 0, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 0, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 0, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeLockStateActor, 0, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 566 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!checkLockState(entry, desiredLockState, lockId))
															#line 7246 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 567 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMapEntry newState = entry;
															#line 568 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			newState.tenantLockState = desiredLockState;
															#line 569 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			newState.tenantLockId = (desiredLockState == TenantLockState::UNLOCKED) ? Optional<UID>() : lockId;
															#line 570 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_2 = configureTenantTransaction(tr, entry, newState);
															#line 570 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7258 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 3;
															#line 570 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 2, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 7263 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 566 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!checkLockState(entry, desiredLockState, lockId))
															#line 7277 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 567 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMapEntry newState = entry;
															#line 568 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			newState.tenantLockState = desiredLockState;
															#line 569 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			newState.tenantLockId = (desiredLockState == TenantLockState::UNLOCKED) ? Optional<UID>() : lockId;
															#line 570 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_2 = configureTenantTransaction(tr, entry, newState);
															#line 570 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7289 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 3;
															#line 570 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeLockStateActor, 2, Void >*>(static_cast<ChangeLockStateActor*>(this)));
															#line 7294 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateActor*>(this)->ActorCallback< ChangeLockStateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeLockStateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 573 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ChangeLockStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeLockStateActorState(); static_cast<ChangeLockStateActor*>(this)->destroy(); return 0; }
															#line 7383 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ChangeLockStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeLockStateActorState();
		static_cast<ChangeLockStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeLockStateActor*>(this)->actor_wait_state > 0) static_cast<ChangeLockStateActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeLockStateActor*>(this)->ActorCallback< ChangeLockStateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeLockStateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeLockStateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int64_t tenant;
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantLockState desiredLockState;
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	UID lockId;
															#line 561 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Void> tenantModeCheck;
															#line 562 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantMapEntry entry;
															#line 7490 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via changeLockState()
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ChangeLockStateActor final : public Actor<Void>, public ActorCallback< ChangeLockStateActor<Transaction>, 0, TenantMapEntry >, public ActorCallback< ChangeLockStateActor<Transaction>, 1, Void >, public ActorCallback< ChangeLockStateActor<Transaction>, 2, Void >, public FastAllocated<ChangeLockStateActor<Transaction>>, public ChangeLockStateActorState<Transaction, ChangeLockStateActor<Transaction>> {
															#line 7497 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<ChangeLockStateActor<Transaction>>::operator new;
	using FastAllocated<ChangeLockStateActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2284811048121850368UL, 17146468431640833536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeLockStateActor<Transaction>, 0, TenantMapEntry >;
friend struct ActorCallback< ChangeLockStateActor<Transaction>, 1, Void >;
friend struct ActorCallback< ChangeLockStateActor<Transaction>, 2, Void >;
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ChangeLockStateActor(Transaction const& tr,int64_t const& tenant,TenantLockState const& desiredLockState,UID const& lockId) 
															#line 7516 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Void>(),
		   ChangeLockStateActorState<Transaction, ChangeLockStateActor<Transaction>>(tr, tenant, desiredLockState, lockId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeLockState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11357216008526473216UL, 16339221266547417344UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeLockStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeLockState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeLockState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeLockStateActor<Transaction>, 0, TenantMapEntry >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeLockStateActor<Transaction>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeLockStateActor<Transaction>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Void> changeLockState( Transaction const& tr, int64_t const& tenant, TenantLockState const& desiredLockState, UID const& lockId ) {
															#line 559 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Void>(new ChangeLockStateActor<Transaction>(tr, tenant, desiredLockState, lockId));
															#line 7552 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 575 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

template <class Transaction>
Future<std::vector<std::pair<TenantName, int64_t>>> listTenantsTransaction(Transaction tr,
                                                                           TenantName begin,
                                                                           TenantName end,
                                                                           int limit) {
	tr->setOption(FDBTransactionOptions::RAW_ACCESS);
	auto future = TenantMetadata::tenantNameIndex().getRange(tr, begin, end, limit);
	return fmap([](auto f) -> std::vector<std::pair<TenantName, int64_t>> { return f.results; }, future);
}

template <class DB>
Future<std::vector<std::pair<TenantName, int64_t>>> listTenants(Reference<DB> db,
                                                                TenantName begin,
                                                                TenantName end,
                                                                int limit) {
	return runTransaction(db, [=](Reference<typename DB::TransactionT> tr) {
		tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
		return listTenantsTransaction(tr, begin, end, limit);
	});
}

															#line 7579 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via listTenantGroupTenantsTransaction()
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class ListTenantGroupTenantsTransactionActor>
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ListTenantGroupTenantsTransactionActorState {
															#line 7585 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ListTenantGroupTenantsTransactionActorState(Transaction const& tr,TenantGroupName const& tenantGroup,TenantName const& begin,TenantName const& end,int const& limit) 
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantGroup(tenantGroup),
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   begin(begin),
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   end(end),
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   limit(limit)
															#line 7600 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantGroupTenantsTransactionActorState() 
	{
		fdb_probe_actor_destroy("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 604 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 605 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<KeyBackedSet<Tuple>::RangeResultType> __when_expr_0 = TenantMetadata::tenantGroupTenantIndex().getRange( tr, Tuple::makeTuple(tenantGroup, begin), Tuple::makeTuple(tenantGroup, end), limit);
															#line 605 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ListTenantGroupTenantsTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7619 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListTenantGroupTenantsTransactionActor*>(this)->actor_wait_state = 1;
															#line 605 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*>(static_cast<ListTenantGroupTenantsTransactionActor*>(this)));
															#line 7624 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantGroupTenantsTransactionActorState();
		static_cast<ListTenantGroupTenantsTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedSet<Tuple>::RangeResultType const& result,int loopDepth) 
	{
															#line 607 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		std::vector<std::pair<TenantName, int64_t>> returnResult;
															#line 608 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!result.results.size())
															#line 7649 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 609 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, int64_t>>>::futures) { (void)(returnResult); this->~ListTenantGroupTenantsTransactionActorState(); static_cast<ListTenantGroupTenantsTransactionActor*>(this)->destroy(); return 0; }
															#line 7653 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, int64_t>> >::value()) std::vector<std::pair<TenantName, int64_t>>(returnResult);
			this->~ListTenantGroupTenantsTransactionActorState();
			static_cast<ListTenantGroupTenantsTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 611 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		for( auto const& tupleEntry : result.results ) {
															#line 612 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			returnResult.push_back(std::make_pair(tupleEntry.getString(1), tupleEntry.getInt(2)));
															#line 7663 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 614 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, int64_t>>>::futures) { (void)(returnResult); this->~ListTenantGroupTenantsTransactionActorState(); static_cast<ListTenantGroupTenantsTransactionActor*>(this)->destroy(); return 0; }
															#line 7667 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, int64_t>> >::value()) std::vector<std::pair<TenantName, int64_t>>(returnResult);
		this->~ListTenantGroupTenantsTransactionActorState();
		static_cast<ListTenantGroupTenantsTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedSet<Tuple>::RangeResultType && result,int loopDepth) 
	{
															#line 607 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		std::vector<std::pair<TenantName, int64_t>> returnResult;
															#line 608 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!result.results.size())
															#line 7681 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 609 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, int64_t>>>::futures) { (void)(returnResult); this->~ListTenantGroupTenantsTransactionActorState(); static_cast<ListTenantGroupTenantsTransactionActor*>(this)->destroy(); return 0; }
															#line 7685 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, int64_t>> >::value()) std::vector<std::pair<TenantName, int64_t>>(returnResult);
			this->~ListTenantGroupTenantsTransactionActorState();
			static_cast<ListTenantGroupTenantsTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 611 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		for( auto const& tupleEntry : result.results ) {
															#line 612 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			returnResult.push_back(std::make_pair(tupleEntry.getString(1), tupleEntry.getInt(2)));
															#line 7695 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 614 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, int64_t>>>::futures) { (void)(returnResult); this->~ListTenantGroupTenantsTransactionActorState(); static_cast<ListTenantGroupTenantsTransactionActor*>(this)->destroy(); return 0; }
															#line 7699 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, int64_t>> >::value()) std::vector<std::pair<TenantName, int64_t>>(returnResult);
		this->~ListTenantGroupTenantsTransactionActorState();
		static_cast<ListTenantGroupTenantsTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantGroupTenantsTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListTenantGroupTenantsTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantGroupTenantsTransactionActor*>(this)->ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupTenantsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupTenantsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupTenantsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantGroupName tenantGroup;
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName begin;
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName end;
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int limit;
															#line 7792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via listTenantGroupTenantsTransaction()
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ListTenantGroupTenantsTransactionActor final : public Actor<std::vector<std::pair<TenantName, int64_t>>>, public ActorCallback< ListTenantGroupTenantsTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >, public FastAllocated<ListTenantGroupTenantsTransactionActor<Transaction>>, public ListTenantGroupTenantsTransactionActorState<Transaction, ListTenantGroupTenantsTransactionActor<Transaction>> {
															#line 7799 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<ListTenantGroupTenantsTransactionActor<Transaction>>::operator new;
	using FastAllocated<ListTenantGroupTenantsTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15844605943189651712UL, 11748669907539698944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantName, int64_t>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantGroupTenantsTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >;
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ListTenantGroupTenantsTransactionActor(Transaction const& tr,TenantGroupName const& tenantGroup,TenantName const& begin,TenantName const& end,int const& limit) 
															#line 7816 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<std::vector<std::pair<TenantName, int64_t>>>(),
		   ListTenantGroupTenantsTransactionActorState<Transaction, ListTenantGroupTenantsTransactionActor<Transaction>>(tr, tenantGroup, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15437714249961797888UL, 4104142458071764736UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupTenantsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantGroupTenantsTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantGroupTenantsTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >*)0, actor_cancelled()); break;
		}

	}
};
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantName, int64_t>>> listTenantGroupTenantsTransaction( Transaction const& tr, TenantGroupName const& tenantGroup, TenantName const& begin, TenantName const& end, int const& limit ) {
															#line 598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<std::vector<std::pair<TenantName, int64_t>>>(new ListTenantGroupTenantsTransactionActor<Transaction>(tr, tenantGroup, begin, end, limit));
															#line 7850 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 616 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

template <class DB>
Future<std::vector<std::pair<TenantName, int64_t>>> listTenantGroupTenants(Reference<DB> db,
                                                                           TenantGroupName tenantGroup,
                                                                           TenantName begin,
                                                                           TenantName end,
                                                                           int limit) {
	return runTransaction(db, [=](Reference<typename DB::TransactionT> tr) {
		tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
		return listTenantGroupTenantsTransaction(tr, tenantGroup, begin, end, limit);
	});
}

															#line 7868 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via listTenantMetadataTransaction()
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class ListTenantMetadataTransactionActor>
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ListTenantMetadataTransactionActorState {
															#line 7874 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ListTenantMetadataTransactionActorState(Transaction const& tr,TenantName const& begin,TenantName const& end,int const& limit) 
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   begin(begin),
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   end(end),
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   limit(limit)
															#line 7887 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantMetadataTransactionActorState() 
	{
		fdb_probe_actor_destroy("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 635 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<std::vector<std::pair<TenantName, int64_t>>> __when_expr_0 = listTenantsTransaction(tr, begin, end, limit);
															#line 635 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7904 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state = 1;
															#line 635 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataTransactionActor, 0, std::vector<std::pair<TenantName, int64_t>> >*>(static_cast<ListTenantMetadataTransactionActor*>(this)));
															#line 7909 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantMetadataTransactionActorState();
		static_cast<ListTenantMetadataTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TenantName, int64_t>> const& matchingTenants,int loopDepth) 
	{
															#line 637 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		tenantEntryFutures = std::vector<Future<TenantMapEntry>>();
															#line 638 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		for( auto const& [name, id] : matchingTenants ) {
															#line 639 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tenantEntryFutures.push_back(getTenantTransaction(tr, id));
															#line 7936 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 642 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(tenantEntryFutures);
															#line 642 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7942 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state = 2;
															#line 642 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataTransactionActor, 1, Void >*>(static_cast<ListTenantMetadataTransactionActor*>(this)));
															#line 7947 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<std::pair<TenantName, int64_t>> && matchingTenants,int loopDepth) 
	{
															#line 637 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		tenantEntryFutures = std::vector<Future<TenantMapEntry>>();
															#line 638 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		for( auto const& [name, id] : matchingTenants ) {
															#line 639 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tenantEntryFutures.push_back(getTenantTransaction(tr, id));
															#line 7960 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 642 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_1 = waitForAll(tenantEntryFutures);
															#line 642 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7966 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state = 2;
															#line 642 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataTransactionActor, 1, Void >*>(static_cast<ListTenantMetadataTransactionActor*>(this)));
															#line 7971 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TenantName, int64_t>> const& matchingTenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(matchingTenants, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<std::pair<TenantName, int64_t>> && matchingTenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(matchingTenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataTransactionActor*>(this)->ActorCallback< ListTenantMetadataTransactionActor, 0, std::vector<std::pair<TenantName, int64_t>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,std::vector<std::pair<TenantName, int64_t>> && value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataTransactionActor, 0, std::vector<std::pair<TenantName, int64_t>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 644 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		std::vector<std::pair<TenantName, TenantMapEntry>> results;
															#line 645 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		for( auto const& f : tenantEntryFutures ) {
															#line 646 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			results.emplace_back(f.get().tenantName, f.get());
															#line 8059 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 649 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ListTenantMetadataTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, TenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataTransactionActorState(); static_cast<ListTenantMetadataTransactionActor*>(this)->destroy(); return 0; }
															#line 8063 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ListTenantMetadataTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, TenantMapEntry>> >::value()) std::vector<std::pair<TenantName, TenantMapEntry>>(results);
		this->~ListTenantMetadataTransactionActorState();
		static_cast<ListTenantMetadataTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 644 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		std::vector<std::pair<TenantName, TenantMapEntry>> results;
															#line 645 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		for( auto const& f : tenantEntryFutures ) {
															#line 646 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			results.emplace_back(f.get().tenantName, f.get());
															#line 8079 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 649 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ListTenantMetadataTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, TenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataTransactionActorState(); static_cast<ListTenantMetadataTransactionActor*>(this)->destroy(); return 0; }
															#line 8083 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ListTenantMetadataTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, TenantMapEntry>> >::value()) std::vector<std::pair<TenantName, TenantMapEntry>>(results);
		this->~ListTenantMetadataTransactionActorState();
		static_cast<ListTenantMetadataTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataTransactionActor*>(this)->ActorCallback< ListTenantMetadataTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName begin;
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName end;
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int limit;
															#line 637 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	std::vector<Future<TenantMapEntry>> tenantEntryFutures;
															#line 8176 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via listTenantMetadataTransaction()
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ListTenantMetadataTransactionActor final : public Actor<std::vector<std::pair<TenantName, TenantMapEntry>>>, public ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 0, std::vector<std::pair<TenantName, int64_t>> >, public ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 1, Void >, public FastAllocated<ListTenantMetadataTransactionActor<Transaction>>, public ListTenantMetadataTransactionActorState<Transaction, ListTenantMetadataTransactionActor<Transaction>> {
															#line 8183 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<ListTenantMetadataTransactionActor<Transaction>>::operator new;
	using FastAllocated<ListTenantMetadataTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6354255614565454848UL, 18278807256762705920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantName, TenantMapEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 0, std::vector<std::pair<TenantName, int64_t>> >;
friend struct ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 1, Void >;
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ListTenantMetadataTransactionActor(Transaction const& tr,TenantName const& begin,TenantName const& end,int const& limit) 
															#line 8201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<std::vector<std::pair<TenantName, TenantMapEntry>>>(),
		   ListTenantMetadataTransactionActorState<Transaction, ListTenantMetadataTransactionActor<Transaction>>(tr, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1675706873923236608UL, 11373340560176294656UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantMetadataTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 0, std::vector<std::pair<TenantName, int64_t>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantName, TenantMapEntry>>> listTenantMetadataTransaction( Transaction const& tr, TenantName const& begin, TenantName const& end, int const& limit ) {
															#line 630 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<std::vector<std::pair<TenantName, TenantMapEntry>>>(new ListTenantMetadataTransactionActor<Transaction>(tr, begin, end, limit));
															#line 8236 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 651 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

template <class DB>
Future<std::vector<std::pair<TenantName, TenantMapEntry>>> listTenantMetadata(Reference<DB> db,
                                                                              TenantName begin,
                                                                              TenantName end,
                                                                              int limit) {
	return runTransaction(db, [=](Reference<typename DB::TransactionT> tr) {
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
		tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
		return listTenantMetadataTransaction(tr, begin, end, limit);
	});
}

															#line 8253 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via renameTenantTransaction()
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class RenameTenantTransactionActor>
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class RenameTenantTransactionActorState {
															#line 8259 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	RenameTenantTransactionActorState(Transaction const& tr,TenantName const& oldName,TenantName const& newName,Optional<int64_t> const& tenantId = Optional<int64_t>(),ClusterType const& clusterType = ClusterType::STANDALONE,Optional<int64_t> const& configureSequenceNum = Optional<int64_t>()) 
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   oldName(oldName),
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   newName(newName),
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantId(tenantId),
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   clusterType(clusterType),
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   configureSequenceNum(configureSequenceNum)
															#line 8276 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("renameTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantTransactionActorState() 
	{
		fdb_probe_actor_destroy("renameTenantTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 671 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(clusterType == ClusterType::STANDALONE || (tenantId.present() && configureSequenceNum.present()));
															#line 672 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(clusterType != ClusterType::METACLUSTER_MANAGEMENT);
															#line 674 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 676 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tenantModeCheck = checkTenantMode(tr, clusterType);
															#line 677 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			oldNameIdFuture = tenantId.present() ? Future<Optional<int64_t>>() : TenantMetadata::tenantNameIndex().get(tr, oldName);
															#line 679 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			newNameIdFuture = TenantMetadata::tenantNameIndex().get(tr, newName);
															#line 681 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_0 = tenantModeCheck;
															#line 681 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8305 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 1;
															#line 681 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantTransactionActor, 0, Void >*>(static_cast<RenameTenantTransactionActor*>(this)));
															#line 8310 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantTransactionActorState();
		static_cast<RenameTenantTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 683 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!tenantId.present())
															#line 8333 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_1 = store(tenantId, oldNameIdFuture);
															#line 684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8339 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantTransactionActor, 1, Void >*>(static_cast<RenameTenantTransactionActor*>(this)));
															#line 8344 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 683 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!tenantId.present())
															#line 8358 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_1 = store(tenantId, oldNameIdFuture);
															#line 684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8364 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 2;
															#line 684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantTransactionActor, 1, Void >*>(static_cast<RenameTenantTransactionActor*>(this)));
															#line 8369 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantTransactionActor*>(this)->ActorCallback< RenameTenantTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 691 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<TenantMapEntry> __when_expr_2 = getTenantTransaction(tr, tenantId.get());
															#line 691 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8460 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 3;
															#line 691 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RenameTenantTransactionActor, 2, TenantMapEntry >*>(static_cast<RenameTenantTransactionActor*>(this)));
															#line 8465 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 685 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!tenantId.present())
															#line 8474 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 686 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename transaction tenant not found");
															#line 687 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 8480 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 685 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!tenantId.present())
															#line 8490 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 686 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename transaction tenant not found");
															#line 687 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 8496 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantTransactionActor*>(this)->ActorCallback< RenameTenantTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RenameTenantTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 692 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Optional<int64_t>> __when_expr_3 = newNameIdFuture;
															#line 692 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8583 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 4;
															#line 692 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RenameTenantTransactionActor, 3, Optional<int64_t> >*>(static_cast<RenameTenantTransactionActor*>(this)));
															#line 8588 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(TenantMapEntry const& __entry,int loopDepth) 
	{
															#line 691 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		entry = __entry;
															#line 8597 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(TenantMapEntry && __entry,int loopDepth) 
	{
		entry = std::move(__entry);
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantTransactionActor*>(this)->ActorCallback< RenameTenantTransactionActor, 2, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 2, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 2, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RenameTenantTransactionActor, 2, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Optional<int64_t> const& newNameId,int loopDepth) 
	{
															#line 693 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (entry.tenantName != oldName)
															#line 8676 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 694 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename transaction ID/name mismatch");
															#line 695 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 8682 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 697 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (newNameId.present())
															#line 8686 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 698 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename transaction new name already exists");
															#line 699 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 8692 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 702 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (configureSequenceNum.present())
															#line 8696 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 703 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (entry.configurationSequenceNum > configureSequenceNum.get())
															#line 8700 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 704 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Tenant rename transaction already applied", probe::decoration::rare);
															#line 705 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (!static_cast<RenameTenantTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantTransactionActorState(); static_cast<RenameTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 8706 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				new (&static_cast<RenameTenantTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RenameTenantTransactionActorState();
				static_cast<RenameTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 707 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			entry.configurationSequenceNum = configureSequenceNum.get();
															#line 8714 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 710 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		entry.tenantName = newName;
															#line 712 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantMap().set(tr, tenantId.get(), entry);
															#line 713 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantNameIndex().set(tr, newName, tenantId.get());
															#line 714 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantNameIndex().erase(tr, oldName);
															#line 716 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (entry.tenantGroup.present())
															#line 8726 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 717 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename transaction inside group");
															#line 718 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupTenantIndex().erase( tr, Tuple::makeTuple(entry.tenantGroup.get(), oldName, tenantId.get()));
															#line 720 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupTenantIndex().insert( tr, Tuple::makeTuple(entry.tenantGroup.get(), newName, tenantId.get()));
															#line 8734 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 724 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::lastTenantModification().setVersionstamp(tr, Versionstamp(), 0);
															#line 726 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (clusterType == ClusterType::METACLUSTER_DATA)
															#line 8740 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 727 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_4 = markTenantTombstones(tr, tenantId.get());
															#line 727 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8746 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
			static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 5;
															#line 727 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RenameTenantTransactionActor, 4, Void >*>(static_cast<RenameTenantTransactionActor*>(this)));
															#line 8751 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Optional<int64_t> && newNameId,int loopDepth) 
	{
															#line 693 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (entry.tenantName != oldName)
															#line 8765 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 694 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename transaction ID/name mismatch");
															#line 695 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_not_found(), loopDepth);
															#line 8771 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 697 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (newNameId.present())
															#line 8775 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 698 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename transaction new name already exists");
															#line 699 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1Catch1(tenant_already_exists(), loopDepth);
															#line 8781 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 702 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (configureSequenceNum.present())
															#line 8785 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 703 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (entry.configurationSequenceNum > configureSequenceNum.get())
															#line 8789 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 704 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Tenant rename transaction already applied", probe::decoration::rare);
															#line 705 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (!static_cast<RenameTenantTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantTransactionActorState(); static_cast<RenameTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 8795 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				new (&static_cast<RenameTenantTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RenameTenantTransactionActorState();
				static_cast<RenameTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 707 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			entry.configurationSequenceNum = configureSequenceNum.get();
															#line 8803 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 710 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		entry.tenantName = newName;
															#line 712 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantMap().set(tr, tenantId.get(), entry);
															#line 713 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantNameIndex().set(tr, newName, tenantId.get());
															#line 714 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::tenantNameIndex().erase(tr, oldName);
															#line 716 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (entry.tenantGroup.present())
															#line 8815 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 717 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename transaction inside group");
															#line 718 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupTenantIndex().erase( tr, Tuple::makeTuple(entry.tenantGroup.get(), oldName, tenantId.get()));
															#line 720 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			TenantMetadata::tenantGroupTenantIndex().insert( tr, Tuple::makeTuple(entry.tenantGroup.get(), newName, tenantId.get()));
															#line 8823 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
															#line 724 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TenantMetadata::lastTenantModification().setVersionstamp(tr, Versionstamp(), 0);
															#line 726 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (clusterType == ClusterType::METACLUSTER_DATA)
															#line 8829 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 727 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_4 = markTenantTombstones(tr, tenantId.get());
															#line 727 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8835 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
			static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 5;
															#line 727 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RenameTenantTransactionActor, 4, Void >*>(static_cast<RenameTenantTransactionActor*>(this)));
															#line 8840 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont8(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Optional<int64_t> const& newNameId,int loopDepth) 
	{
		loopDepth = a_body1cont7(newNameId, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Optional<int64_t> && newNameId,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(newNameId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantTransactionActor*>(this)->ActorCallback< RenameTenantTransactionActor, 3, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 3, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 3, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RenameTenantTransactionActor, 3, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 730 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<RenameTenantTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantTransactionActorState(); static_cast<RenameTenantTransactionActor*>(this)->destroy(); return 0; }
															#line 8929 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<RenameTenantTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantTransactionActorState();
		static_cast<RenameTenantTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantTransactionActor*>(this)->ActorCallback< RenameTenantTransactionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RenameTenantTransactionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RenameTenantTransactionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName oldName;
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName newName;
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Optional<int64_t> tenantId;
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType clusterType;
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Optional<int64_t> configureSequenceNum;
															#line 676 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Void> tenantModeCheck;
															#line 677 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Optional<int64_t>> oldNameIdFuture;
															#line 679 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Optional<int64_t>> newNameIdFuture;
															#line 691 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantMapEntry entry;
															#line 9044 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via renameTenantTransaction()
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class RenameTenantTransactionActor final : public Actor<Void>, public ActorCallback< RenameTenantTransactionActor<Transaction>, 0, Void >, public ActorCallback< RenameTenantTransactionActor<Transaction>, 1, Void >, public ActorCallback< RenameTenantTransactionActor<Transaction>, 2, TenantMapEntry >, public ActorCallback< RenameTenantTransactionActor<Transaction>, 3, Optional<int64_t> >, public ActorCallback< RenameTenantTransactionActor<Transaction>, 4, Void >, public FastAllocated<RenameTenantTransactionActor<Transaction>>, public RenameTenantTransactionActorState<Transaction, RenameTenantTransactionActor<Transaction>> {
															#line 9051 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<RenameTenantTransactionActor<Transaction>>::operator new;
	using FastAllocated<RenameTenantTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14559144042733960704UL, 17683595099938274816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantTransactionActor<Transaction>, 0, Void >;
friend struct ActorCallback< RenameTenantTransactionActor<Transaction>, 1, Void >;
friend struct ActorCallback< RenameTenantTransactionActor<Transaction>, 2, TenantMapEntry >;
friend struct ActorCallback< RenameTenantTransactionActor<Transaction>, 3, Optional<int64_t> >;
friend struct ActorCallback< RenameTenantTransactionActor<Transaction>, 4, Void >;
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	RenameTenantTransactionActor(Transaction const& tr,TenantName const& oldName,TenantName const& newName,Optional<int64_t> const& tenantId = Optional<int64_t>(),ClusterType const& clusterType = ClusterType::STANDALONE,Optional<int64_t> const& configureSequenceNum = Optional<int64_t>()) 
															#line 9072 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Void>(),
		   RenameTenantTransactionActorState<Transaction, RenameTenantTransactionActor<Transaction>>(tr, oldName, newName, tenantId, clusterType, configureSequenceNum),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenantTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3655380058639093504UL, 8701225860259579136UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenantTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenantTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantTransactionActor<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RenameTenantTransactionActor<Transaction>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RenameTenantTransactionActor<Transaction>, 2, TenantMapEntry >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RenameTenantTransactionActor<Transaction>, 3, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RenameTenantTransactionActor<Transaction>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Void> renameTenantTransaction( Transaction const& tr, TenantName const& oldName, TenantName const& newName, Optional<int64_t> const& tenantId = Optional<int64_t>(), ClusterType const& clusterType = ClusterType::STANDALONE, Optional<int64_t> const& configureSequenceNum = Optional<int64_t>() ) {
															#line 664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Void>(new RenameTenantTransactionActor<Transaction>(tr, oldName, newName, tenantId, clusterType, configureSequenceNum));
															#line 9110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 732 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 9115 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via renameTenant()
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class RenameTenantActor>
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class RenameTenantActorState {
															#line 9121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	RenameTenantActorState(Reference<DB> const& db,TenantName const& oldName,TenantName const& newName,Optional<int64_t> const& tenantId = Optional<int64_t>(),ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : db(db),
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   oldName(oldName),
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   newName(newName),
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tenantId(tenantId),
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   clusterType(clusterType),
															#line 739 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tr(db->createTransaction())
															#line 9138 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	~RenameTenantActorState() 
	{
		fdb_probe_actor_destroy("renameTenant", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 740 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			ASSERT(clusterType == ClusterType::STANDALONE || tenantId.present());
															#line 742 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			firstTry = true;
															#line 743 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			;
															#line 9157 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 745 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 746 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!tenantId.present())
															#line 9190 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 747 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				StrictFuture<Void> __when_expr_0 = store(tenantId, TenantMetadata::tenantNameIndex().get(tr, oldName));
															#line 747 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9196 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RenameTenantActor*>(this)->actor_wait_state = 1;
															#line 747 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 0, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 9201 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 781 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_5 = safeThreadFutureToFuture(tr->onError(e));
															#line 781 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9230 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<RenameTenantActor*>(this)->actor_wait_state = 6;
															#line 781 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 5, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 9235 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 754 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		newNameIdFuture = TenantMetadata::tenantNameIndex().get(tr, newName);
															#line 755 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<TenantMapEntry> __when_expr_1 = getTenantTransaction(tr, tenantId.get());
															#line 755 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9254 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 2;
															#line 755 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 1, TenantMapEntry >*>(static_cast<RenameTenantActor*>(this)));
															#line 9259 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 748 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!tenantId.present())
															#line 9268 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 749 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename tenant not found");
															#line 750 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 9274 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 748 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!tenantId.present())
															#line 9284 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 749 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename tenant not found");
															#line 750 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 9290 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 756 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Optional<int64_t>> __when_expr_2 = newNameIdFuture;
															#line 756 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9377 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_2.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 3;
															#line 756 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 2, Optional<int64_t> >*>(static_cast<RenameTenantActor*>(this)));
															#line 9382 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(TenantMapEntry const& __entry,int loopDepth) 
	{
															#line 755 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		entry = __entry;
															#line 9391 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(TenantMapEntry && __entry,int loopDepth) 
	{
		entry = std::move(__entry);
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 1, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 1, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 1, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 1, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Optional<int64_t> const& newNameId,int loopDepth) 
	{
															#line 758 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!firstTry && entry.tenantName == newName)
															#line 9470 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 760 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename retried and already succeeded");
															#line 761 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 9476 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RenameTenantActorState();
			static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 762 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (entry.tenantName != oldName)
															#line 9486 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 763 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Tenant rename ID/name mismatch");
															#line 764 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 9492 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
			else
			{
															#line 765 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (newNameId.present() && newNameId.get() != tenantId.get())
															#line 9498 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				{
															#line 766 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					CODE_PROBE(true, "Tenant rename new name already exists");
															#line 767 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					return a_body1loopBody1Catch1(tenant_already_exists(), loopDepth);
															#line 9504 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				}
			}
		}
															#line 770 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		firstTry = false;
															#line 772 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_3 = renameTenantTransaction(tr, oldName, newName, tenantId, clusterType);
															#line 772 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9514 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 4;
															#line 772 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 3, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 9519 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<int64_t> && newNameId,int loopDepth) 
	{
															#line 758 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!firstTry && entry.tenantName == newName)
															#line 9528 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		{
															#line 760 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			CODE_PROBE(true, "Tenant rename retried and already succeeded");
															#line 761 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 9534 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RenameTenantActorState();
			static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 762 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (entry.tenantName != oldName)
															#line 9544 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			{
															#line 763 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				CODE_PROBE(true, "Tenant rename ID/name mismatch");
															#line 764 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				return a_body1loopBody1Catch1(tenant_not_found(), loopDepth);
															#line 9550 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			}
			else
			{
															#line 765 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
				if (newNameId.present() && newNameId.get() != tenantId.get())
															#line 9556 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				{
															#line 766 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					CODE_PROBE(true, "Tenant rename new name already exists");
															#line 767 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
					return a_body1loopBody1Catch1(tenant_already_exists(), loopDepth);
															#line 9562 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
				}
			}
		}
															#line 770 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		firstTry = false;
															#line 772 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_3 = renameTenantTransaction(tr, oldName, newName, tenantId, clusterType);
															#line 772 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9572 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_3.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 4;
															#line 772 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 3, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 9577 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<int64_t> const& newNameId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(newNameId, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<int64_t> && newNameId,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(newNameId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 2, Optional<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 2, Optional<int64_t> >*,Optional<int64_t> const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 2, Optional<int64_t> >*,Optional<int64_t> && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 2, Optional<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 773 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_4 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 773 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9663 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 5;
															#line 773 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 4, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 9668 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 773 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		StrictFuture<Void> __when_expr_4 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 773 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9679 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<RenameTenantActor*>(this)->actor_wait_state = 5;
															#line 773 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RenameTenantActor, 4, Void >*>(static_cast<RenameTenantActor*>(this)));
															#line 9684 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont14(Void const& _,int loopDepth) 
	{
															#line 775 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TraceEvent("TenantRenamed") .detail("OldName", oldName) .detail("NewName", newName) .detail("TenantId", tenantId.get());
															#line 779 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 9770 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont14(Void && _,int loopDepth) 
	{
															#line 775 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		TraceEvent("TenantRenamed") .detail("OldName", oldName) .detail("NewName", newName) .detail("TenantId", tenantId.get());
															#line 779 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<RenameTenantActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RenameTenantActorState(); static_cast<RenameTenantActor*>(this)->destroy(); return 0; }
															#line 9784 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<RenameTenantActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RenameTenantActorState();
		static_cast<RenameTenantActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RenameTenantActor*>(this)->actor_wait_state > 0) static_cast<RenameTenantActor*>(this)->actor_wait_state = 0;
		static_cast<RenameTenantActor*>(this)->ActorCallback< RenameTenantActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RenameTenantActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RenameTenantActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<DB> db;
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName oldName;
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantName newName;
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Optional<int64_t> tenantId;
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ClusterType clusterType;
															#line 739 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 742 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	bool firstTry;
															#line 754 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Future<Optional<int64_t>> newNameIdFuture;
															#line 755 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantMapEntry entry;
															#line 9972 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via renameTenant()
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class RenameTenantActor final : public Actor<Void>, public ActorCallback< RenameTenantActor<DB>, 0, Void >, public ActorCallback< RenameTenantActor<DB>, 1, TenantMapEntry >, public ActorCallback< RenameTenantActor<DB>, 2, Optional<int64_t> >, public ActorCallback< RenameTenantActor<DB>, 3, Void >, public ActorCallback< RenameTenantActor<DB>, 4, Void >, public ActorCallback< RenameTenantActor<DB>, 5, Void >, public FastAllocated<RenameTenantActor<DB>>, public RenameTenantActorState<DB, RenameTenantActor<DB>> {
															#line 9979 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<RenameTenantActor<DB>>::operator new;
	using FastAllocated<RenameTenantActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15394746940524623104UL, 12030193716648691200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RenameTenantActor<DB>, 0, Void >;
friend struct ActorCallback< RenameTenantActor<DB>, 1, TenantMapEntry >;
friend struct ActorCallback< RenameTenantActor<DB>, 2, Optional<int64_t> >;
friend struct ActorCallback< RenameTenantActor<DB>, 3, Void >;
friend struct ActorCallback< RenameTenantActor<DB>, 4, Void >;
friend struct ActorCallback< RenameTenantActor<DB>, 5, Void >;
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	RenameTenantActor(Reference<DB> const& db,TenantName const& oldName,TenantName const& newName,Optional<int64_t> const& tenantId = Optional<int64_t>(),ClusterType const& clusterType = ClusterType::STANDALONE) 
															#line 10001 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Void>(),
		   RenameTenantActorState<DB, RenameTenantActor<DB>>(db, oldName, newName, tenantId, clusterType),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("renameTenant", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(972264867922354944UL, 1896563828629082368UL);
		ActorExecutionContextHelper __helper(static_cast<RenameTenantActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("renameTenant");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("renameTenant", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RenameTenantActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RenameTenantActor<DB>, 1, TenantMapEntry >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RenameTenantActor<DB>, 2, Optional<int64_t> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RenameTenantActor<DB>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RenameTenantActor<DB>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RenameTenantActor<DB>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Void> renameTenant( Reference<DB> const& db, TenantName const& oldName, TenantName const& newName, Optional<int64_t> const& tenantId = Optional<int64_t>(), ClusterType const& clusterType = ClusterType::STANDALONE ) {
															#line 733 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Void>(new RenameTenantActor<DB>(db, oldName, newName, tenantId, clusterType));
															#line 10040 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 785 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

template <class Transaction>
Future<Optional<TenantGroupEntry>> tryGetTenantGroupTransaction(Transaction tr, TenantGroupName name) {
	tr->setOption(FDBTransactionOptions::RAW_ACCESS);
	return TenantMetadata::tenantGroupMap().get(tr, name);
}

															#line 10051 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via tryGetTenantGroup()
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class TryGetTenantGroupActor>
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class TryGetTenantGroupActorState {
															#line 10057 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TryGetTenantGroupActorState(Reference<DB> const& db,TenantGroupName const& name) 
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : db(db),
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   name(name),
															#line 794 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tr(db->createTransaction())
															#line 10068 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("tryGetTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	~TryGetTenantGroupActorState() 
	{
		fdb_probe_actor_destroy("tryGetTenantGroup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 796 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			;
															#line 10083 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TryGetTenantGroupActorState();
		static_cast<TryGetTenantGroupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 798 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 799 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 800 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Optional<TenantGroupEntry>> __when_expr_0 = tryGetTenantGroupTransaction(tr, name);
															#line 800 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10120 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state = 1;
															#line 800 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantGroupActor, 0, Optional<TenantGroupEntry> >*>(static_cast<TryGetTenantGroupActor*>(this)));
															#line 10125 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 803 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 803 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state = 2;
															#line 803 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TryGetTenantGroupActor, 1, Void >*>(static_cast<TryGetTenantGroupActor*>(this)));
															#line 10154 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<TenantGroupEntry> const& entry,int loopDepth) 
	{
															#line 801 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<TryGetTenantGroupActor*>(this)->SAV<Optional<TenantGroupEntry>>::futures) { (void)(entry); this->~TryGetTenantGroupActorState(); static_cast<TryGetTenantGroupActor*>(this)->destroy(); return 0; }
															#line 10169 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<TryGetTenantGroupActor*>(this)->SAV< Optional<TenantGroupEntry> >::value()) Optional<TenantGroupEntry>(entry);
		this->~TryGetTenantGroupActorState();
		static_cast<TryGetTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<TenantGroupEntry> && entry,int loopDepth) 
	{
															#line 801 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<TryGetTenantGroupActor*>(this)->SAV<Optional<TenantGroupEntry>>::futures) { (void)(entry); this->~TryGetTenantGroupActorState(); static_cast<TryGetTenantGroupActor*>(this)->destroy(); return 0; }
															#line 10181 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<TryGetTenantGroupActor*>(this)->SAV< Optional<TenantGroupEntry> >::value()) Optional<TenantGroupEntry>(entry);
		this->~TryGetTenantGroupActorState();
		static_cast<TryGetTenantGroupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<TenantGroupEntry> const& entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(entry, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<TenantGroupEntry> && entry,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantGroupActor*>(this)->ActorCallback< TryGetTenantGroupActor, 0, Optional<TenantGroupEntry> >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantGroupActor, 0, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> const& value) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TryGetTenantGroupActor, 0, Optional<TenantGroupEntry> >*,Optional<TenantGroupEntry> && value) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TryGetTenantGroupActor, 0, Optional<TenantGroupEntry> >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state > 0) static_cast<TryGetTenantGroupActor*>(this)->actor_wait_state = 0;
		static_cast<TryGetTenantGroupActor*>(this)->ActorCallback< TryGetTenantGroupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TryGetTenantGroupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TryGetTenantGroupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TryGetTenantGroupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<DB> db;
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantGroupName name;
															#line 794 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 10357 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via tryGetTenantGroup()
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class TryGetTenantGroupActor final : public Actor<Optional<TenantGroupEntry>>, public ActorCallback< TryGetTenantGroupActor<DB>, 0, Optional<TenantGroupEntry> >, public ActorCallback< TryGetTenantGroupActor<DB>, 1, Void >, public FastAllocated<TryGetTenantGroupActor<DB>>, public TryGetTenantGroupActorState<DB, TryGetTenantGroupActor<DB>> {
															#line 10364 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<TryGetTenantGroupActor<DB>>::operator new;
	using FastAllocated<TryGetTenantGroupActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15234894669066448128UL, 17644242111285972736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<TenantGroupEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TryGetTenantGroupActor<DB>, 0, Optional<TenantGroupEntry> >;
friend struct ActorCallback< TryGetTenantGroupActor<DB>, 1, Void >;
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TryGetTenantGroupActor(Reference<DB> const& db,TenantGroupName const& name) 
															#line 10382 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<Optional<TenantGroupEntry>>(),
		   TryGetTenantGroupActorState<DB, TryGetTenantGroupActor<DB>>(db, name),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9003815954795149312UL, 16597353401135093248UL);
		ActorExecutionContextHelper __helper(static_cast<TryGetTenantGroupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tryGetTenantGroup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tryGetTenantGroup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TryGetTenantGroupActor<DB>, 0, Optional<TenantGroupEntry> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TryGetTenantGroupActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<Optional<TenantGroupEntry>> tryGetTenantGroup( Reference<DB> const& db, TenantGroupName const& name ) {
															#line 792 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<Optional<TenantGroupEntry>>(new TryGetTenantGroupActor<DB>(db, name));
															#line 10417 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 807 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 10422 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via listTenantGroupsTransaction()
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction, class ListTenantGroupsTransactionActor>
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ListTenantGroupsTransactionActorState {
															#line 10428 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ListTenantGroupsTransactionActorState(Transaction const& tr,TenantGroupName const& begin,TenantGroupName const& end,int const& limit) 
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : tr(tr),
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   begin(begin),
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   end(end),
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   limit(limit)
															#line 10441 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantGroupsTransactionActorState() 
	{
		fdb_probe_actor_destroy("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 813 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 815 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>>> __when_expr_0 = TenantMetadata::tenantGroupMap().getRange(tr, begin, end, limit);
															#line 815 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ListTenantGroupsTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10460 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListTenantGroupsTransactionActor*>(this)->actor_wait_state = 1;
															#line 815 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> >*>(static_cast<ListTenantGroupsTransactionActor*>(this)));
															#line 10465 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantGroupsTransactionActorState();
		static_cast<ListTenantGroupsTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> const& results,int loopDepth) 
	{
															#line 818 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ListTenantGroupsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>::futures) { (void)(results.results); this->~ListTenantGroupsTransactionActorState(); static_cast<ListTenantGroupsTransactionActor*>(this)->destroy(); return 0; }
															#line 10488 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ListTenantGroupsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >::value()) std::vector<std::pair<TenantGroupName, TenantGroupEntry>>(results.results);
		this->~ListTenantGroupsTransactionActorState();
		static_cast<ListTenantGroupsTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> && results,int loopDepth) 
	{
															#line 818 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ListTenantGroupsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>::futures) { (void)(results.results); this->~ListTenantGroupsTransactionActorState(); static_cast<ListTenantGroupsTransactionActor*>(this)->destroy(); return 0; }
															#line 10500 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ListTenantGroupsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >::value()) std::vector<std::pair<TenantGroupName, TenantGroupEntry>>(results.results);
		this->~ListTenantGroupsTransactionActorState();
		static_cast<ListTenantGroupsTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantGroupsTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListTenantGroupsTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantGroupsTransactionActor*>(this)->ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> >*,KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> const& value) 
	{
		fdb_probe_actor_enter("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> >*,KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> && value) 
	{
		fdb_probe_actor_enter("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantGroupsTransactionActor, 0, KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Transaction tr;
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantGroupName begin;
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantGroupName end;
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int limit;
															#line 10591 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via listTenantGroupsTransaction()
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ListTenantGroupsTransactionActor final : public Actor<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>, public ActorCallback< ListTenantGroupsTransactionActor<Transaction>, 0, KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> >, public FastAllocated<ListTenantGroupsTransactionActor<Transaction>>, public ListTenantGroupsTransactionActorState<Transaction, ListTenantGroupsTransactionActor<Transaction>> {
															#line 10598 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<ListTenantGroupsTransactionActor<Transaction>>::operator new;
	using FastAllocated<ListTenantGroupsTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9343352157434972672UL, 7000310172308311808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantGroupsTransactionActor<Transaction>, 0, KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> >;
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ListTenantGroupsTransactionActor(Transaction const& tr,TenantGroupName const& begin,TenantGroupName const& end,int const& limit) 
															#line 10615 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>(),
		   ListTenantGroupsTransactionActorState<Transaction, ListTenantGroupsTransactionActor<Transaction>>(tr, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8927590815170552320UL, 3409258469446972928UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantGroupsTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantGroupsTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantGroupsTransactionActor<Transaction>, 0, KeyBackedRangeResult<std::pair<TenantGroupName, TenantGroupEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class Transaction>
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>> listTenantGroupsTransaction( Transaction const& tr, TenantGroupName const& begin, TenantGroupName const& end, int const& limit ) {
															#line 808 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>(new ListTenantGroupsTransactionActor<Transaction>(tr, begin, end, limit));
															#line 10649 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 820 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

															#line 10654 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
// This generated class is to be used only via listTenantGroups()
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB, class ListTenantGroupsActor>
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ListTenantGroupsActorState {
															#line 10660 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ListTenantGroupsActorState(Reference<DB> const& db,TenantGroupName const& begin,TenantGroupName const& end,int const& limit) 
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		 : db(db),
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   begin(begin),
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   end(end),
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   limit(limit),
															#line 826 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		   tr(db->createTransaction())
															#line 10675 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
	{
		fdb_probe_actor_create("listTenantGroups", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantGroupsActorState() 
	{
		fdb_probe_actor_destroy("listTenantGroups", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 828 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			;
															#line 10690 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantGroupsActorState();
		static_cast<ListTenantGroupsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 830 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 831 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 832 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>> __when_expr_0 = listTenantGroupsTransaction(tr, begin, end, limit);
															#line 832 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ListTenantGroupsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10727 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListTenantGroupsActor*>(this)->actor_wait_state = 1;
															#line 832 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*>(static_cast<ListTenantGroupsActor*>(this)));
															#line 10732 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 836 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 836 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			if (static_cast<ListTenantGroupsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10756 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ListTenantGroupsActor*>(this)->actor_wait_state = 2;
															#line 836 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListTenantGroupsActor, 1, Void >*>(static_cast<ListTenantGroupsActor*>(this)));
															#line 10761 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<TenantGroupName, TenantGroupEntry>> const& tenantGroups,int loopDepth) 
	{
															#line 834 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ListTenantGroupsActor*>(this)->SAV<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>::futures) { (void)(tenantGroups); this->~ListTenantGroupsActorState(); static_cast<ListTenantGroupsActor*>(this)->destroy(); return 0; }
															#line 10776 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ListTenantGroupsActor*>(this)->SAV< std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >::value()) std::vector<std::pair<TenantGroupName, TenantGroupEntry>>(tenantGroups);
		this->~ListTenantGroupsActorState();
		static_cast<ListTenantGroupsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(std::vector<std::pair<TenantGroupName, TenantGroupEntry>> && tenantGroups,int loopDepth) 
	{
															#line 834 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
		if (!static_cast<ListTenantGroupsActor*>(this)->SAV<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>::futures) { (void)(tenantGroups); this->~ListTenantGroupsActorState(); static_cast<ListTenantGroupsActor*>(this)->destroy(); return 0; }
															#line 10788 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		new (&static_cast<ListTenantGroupsActor*>(this)->SAV< std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >::value()) std::vector<std::pair<TenantGroupName, TenantGroupEntry>>(tenantGroups);
		this->~ListTenantGroupsActorState();
		static_cast<ListTenantGroupsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<TenantGroupName, TenantGroupEntry>> const& tenantGroups,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(tenantGroups, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<std::pair<TenantGroupName, TenantGroupEntry>> && tenantGroups,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(tenantGroups), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantGroupsActor*>(this)->actor_wait_state > 0) static_cast<ListTenantGroupsActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantGroupsActor*>(this)->ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*,std::vector<std::pair<TenantGroupName, TenantGroupEntry>> const& value) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*,std::vector<std::pair<TenantGroupName, TenantGroupEntry>> && value) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantGroupsActor, 0, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListTenantGroupsActor*>(this)->actor_wait_state > 0) static_cast<ListTenantGroupsActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantGroupsActor*>(this)->ActorCallback< ListTenantGroupsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListTenantGroupsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListTenantGroupsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<DB> db;
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantGroupName begin;
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	TenantGroupName end;
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	int limit;
															#line 826 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 10968 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
};
// This generated class is to be used only via listTenantGroups()
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
class ListTenantGroupsActor final : public Actor<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>, public ActorCallback< ListTenantGroupsActor<DB>, 0, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >, public ActorCallback< ListTenantGroupsActor<DB>, 1, Void >, public FastAllocated<ListTenantGroupsActor<DB>>, public ListTenantGroupsActorState<DB, ListTenantGroupsActor<DB>> {
															#line 10975 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
public:
	using FastAllocated<ListTenantGroupsActor<DB>>::operator new;
	using FastAllocated<ListTenantGroupsActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17264395488383092736UL, 3005928099432131584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantGroupsActor<DB>, 0, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >;
friend struct ActorCallback< ListTenantGroupsActor<DB>, 1, Void >;
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	ListTenantGroupsActor(Reference<DB> const& db,TenantGroupName const& begin,TenantGroupName const& end,int const& limit) 
															#line 10993 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
		 : Actor<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>(),
		   ListTenantGroupsActorState<DB, ListTenantGroupsActor<DB>>(db, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantGroups", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3210088546958859520UL, 16625951499276179968UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantGroups");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantGroups", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantGroupsActor<DB>, 0, std::vector<std::pair<TenantGroupName, TenantGroupEntry>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListTenantGroupsActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
template <class DB>
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>> listTenantGroups( Reference<DB> const& db, TenantGroupName const& begin, TenantGroupName const& end, int const& limit ) {
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"
	return Future<std::vector<std::pair<TenantGroupName, TenantGroupEntry>>>(new ListTenantGroupsActor<DB>(db, begin, end, limit));
															#line 11028 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/TenantManagement.actor.g.h"
}

#line 840 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/TenantManagement.actor.h"

} // namespace TenantAPI

#include "flow/unactorcompiler.h"
#endif
