#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
/*
 * TriggerDDTeamInfoLogCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/SystemData.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 36 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
// This generated class is to be used only via triggerddteaminfologCommandActor()
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
template <class TriggerddteaminfologCommandActorActor>
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
class TriggerddteaminfologCommandActorActorState {
															#line 42 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
public:
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
	TriggerddteaminfologCommandActorActorState(Reference<IDatabase> const& db) 
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
		 : db(db),
															#line 35 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~TriggerddteaminfologCommandActorActorState() 
	{
		fdb_probe_actor_destroy("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 36 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			;
															#line 66 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TriggerddteaminfologCommandActorActorState();
		static_cast<TriggerddteaminfologCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 39 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			std::string v = deterministicRandom()->randomUniqueID().toString();
															#line 41 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			tr->set(triggerDDTeamInfoPrintKey, v);
															#line 42 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 42 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			if (static_cast<TriggerddteaminfologCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 107 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TriggerddteaminfologCommandActorActor*>(this)->actor_wait_state = 1;
															#line 42 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TriggerddteaminfologCommandActorActor, 0, Void >*>(static_cast<TriggerddteaminfologCommandActorActor*>(this)));
															#line 112 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 46 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 46 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			if (static_cast<TriggerddteaminfologCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<TriggerddteaminfologCommandActorActor*>(this)->actor_wait_state = 2;
															#line 46 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TriggerddteaminfologCommandActorActor, 1, Void >*>(static_cast<TriggerddteaminfologCommandActorActor*>(this)));
															#line 141 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
		printf("Triggered team info logging in data distribution.\n");
															#line 44 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
		if (!static_cast<TriggerddteaminfologCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TriggerddteaminfologCommandActorActorState(); static_cast<TriggerddteaminfologCommandActorActor*>(this)->destroy(); return 0; }
															#line 158 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
		new (&static_cast<TriggerddteaminfologCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TriggerddteaminfologCommandActorActorState();
		static_cast<TriggerddteaminfologCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 43 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
		printf("Triggered team info logging in data distribution.\n");
															#line 44 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
		if (!static_cast<TriggerddteaminfologCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~TriggerddteaminfologCommandActorActorState(); static_cast<TriggerddteaminfologCommandActorActor*>(this)->destroy(); return 0; }
															#line 172 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
		new (&static_cast<TriggerddteaminfologCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~TriggerddteaminfologCommandActorActorState();
		static_cast<TriggerddteaminfologCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TriggerddteaminfologCommandActorActor*>(this)->actor_wait_state > 0) static_cast<TriggerddteaminfologCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerddteaminfologCommandActorActor*>(this)->ActorCallback< TriggerddteaminfologCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerddteaminfologCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerddteaminfologCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TriggerddteaminfologCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerddteaminfologCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TriggerddteaminfologCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerddteaminfologCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TriggerddteaminfologCommandActorActor*>(this)->actor_wait_state > 0) static_cast<TriggerddteaminfologCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<TriggerddteaminfologCommandActorActor*>(this)->ActorCallback< TriggerddteaminfologCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TriggerddteaminfologCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerddteaminfologCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TriggerddteaminfologCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerddteaminfologCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TriggerddteaminfologCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerddteaminfologCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 35 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 346 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
};
// This generated class is to be used only via triggerddteaminfologCommandActor()
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
class TriggerddteaminfologCommandActorActor final : public Actor<bool>, public ActorCallback< TriggerddteaminfologCommandActorActor, 0, Void >, public ActorCallback< TriggerddteaminfologCommandActorActor, 1, Void >, public FastAllocated<TriggerddteaminfologCommandActorActor>, public TriggerddteaminfologCommandActorActorState<TriggerddteaminfologCommandActorActor> {
															#line 351 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
public:
	using FastAllocated<TriggerddteaminfologCommandActorActor>::operator new;
	using FastAllocated<TriggerddteaminfologCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(347708657238670336UL, 623252291295907584UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TriggerddteaminfologCommandActorActor, 0, Void >;
friend struct ActorCallback< TriggerddteaminfologCommandActorActor, 1, Void >;
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
	TriggerddteaminfologCommandActorActor(Reference<IDatabase> const& db) 
															#line 369 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
		 : Actor<bool>(),
		   TriggerddteaminfologCommandActorActorState<TriggerddteaminfologCommandActorActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5710309853238684928UL, 10920332308047556352UL);
		ActorExecutionContextHelper __helper(static_cast<TriggerddteaminfologCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("triggerddteaminfologCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("triggerddteaminfologCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TriggerddteaminfologCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TriggerddteaminfologCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
[[nodiscard]] Future<bool> triggerddteaminfologCommandActor( Reference<IDatabase> const& db ) {
															#line 34 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"
	return Future<bool>(new TriggerddteaminfologCommandActorActor(db));
															#line 402 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/TriggerDDTeamInfoLogCommand.actor.g.cpp"
}

#line 50 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/TriggerDDTeamInfoLogCommand.actor.cpp"

CommandFactory triggerddteaminfologFactory(
    "triggerddteaminfolog",
    CommandHelp("triggerddteaminfolog",
                "trigger the data distributor teams logging",
                "Trigger the data distributor to log detailed information about its teams."));

} // namespace fdb_cli
