#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
/*
 * ChangeFeedCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fmt/format.h"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/Schemas.h"
#include "fdbclient/ManagementAPI.actor.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
// This generated class is to be used only via changeFeedList()
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
template <class ChangeFeedListActor>
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
class ChangeFeedListActorState {
															#line 46 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
public:
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	ChangeFeedListActorState(Database const& db) 
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		 : db(db),
															#line 39 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		   tr(db)
															#line 55 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("changeFeedList", reinterpret_cast<unsigned long>(this));

	}
	~ChangeFeedListActorState() 
	{
		fdb_probe_actor_destroy("changeFeedList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 40 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			;
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeFeedListActorState();
		static_cast<ChangeFeedListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 42 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 43 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 44 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 46 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(changeFeedKeys, CLIENT_KNOBS->TOO_MANY);
															#line 46 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			if (static_cast<ChangeFeedListActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 109 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeFeedListActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedListActor, 0, RangeResult >*>(static_cast<ChangeFeedListActor*>(this)));
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 59 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			if (static_cast<ChangeFeedListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 138 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ChangeFeedListActor*>(this)->actor_wait_state = 2;
															#line 59 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedListActor, 1, Void >*>(static_cast<ChangeFeedListActor*>(this)));
															#line 143 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& result,int loopDepth) 
	{
															#line 48 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		ASSERT(!result.more);
															#line 49 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		printf("Found %d change feeds%s\n", result.size(), result.size() == 0 ? "." : ":");
															#line 50 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		for( auto& it : result ) {
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			auto range = std::get<0>(decodeChangeFeedValue(it.value));
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			printf("  %s: `%s' - `%s'\n", it.key.removePrefix(changeFeedPrefix).toString().c_str(), printable(range.begin).c_str(), printable(range.end).c_str());
															#line 166 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		}
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (!static_cast<ChangeFeedListActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeFeedListActorState(); static_cast<ChangeFeedListActor*>(this)->destroy(); return 0; }
															#line 170 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		new (&static_cast<ChangeFeedListActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeFeedListActorState();
		static_cast<ChangeFeedListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && result,int loopDepth) 
	{
															#line 48 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		ASSERT(!result.more);
															#line 49 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		printf("Found %d change feeds%s\n", result.size(), result.size() == 0 ? "." : ":");
															#line 50 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		for( auto& it : result ) {
															#line 51 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			auto range = std::get<0>(decodeChangeFeedValue(it.value));
															#line 52 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			printf("  %s: `%s' - `%s'\n", it.key.removePrefix(changeFeedPrefix).toString().c_str(), printable(range.begin).c_str(), printable(range.end).c_str());
															#line 190 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		}
															#line 57 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (!static_cast<ChangeFeedListActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeFeedListActorState(); static_cast<ChangeFeedListActor*>(this)->destroy(); return 0; }
															#line 194 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		new (&static_cast<ChangeFeedListActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeFeedListActorState();
		static_cast<ChangeFeedListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeFeedListActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedListActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedListActor*>(this)->ActorCallback< ChangeFeedListActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedListActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("changeFeedList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeFeedListActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("changeFeedList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeFeedListActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedList", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeFeedListActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedListActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedListActor*>(this)->ActorCallback< ChangeFeedListActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedListActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeFeedListActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeFeedListActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedList", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Database db;
															#line 39 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 368 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
};
// This generated class is to be used only via changeFeedList()
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
class ChangeFeedListActor final : public Actor<Void>, public ActorCallback< ChangeFeedListActor, 0, RangeResult >, public ActorCallback< ChangeFeedListActor, 1, Void >, public FastAllocated<ChangeFeedListActor>, public ChangeFeedListActorState<ChangeFeedListActor> {
															#line 373 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
public:
	using FastAllocated<ChangeFeedListActor>::operator new;
	using FastAllocated<ChangeFeedListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16510630858401907456UL, 17183159121286946304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeFeedListActor, 0, RangeResult >;
friend struct ActorCallback< ChangeFeedListActor, 1, Void >;
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	ChangeFeedListActor(Database const& db) 
															#line 391 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeFeedListActorState<ChangeFeedListActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeFeedList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12450088260070867968UL, 2795158818696870656UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeFeedList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeFeedList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeFeedListActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeFeedListActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
[[nodiscard]] Future<Void> changeFeedList( Database const& db ) {
															#line 38 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	return Future<Void>(new ChangeFeedListActor(db));
															#line 424 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
}

#line 63 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"

} // namespace

namespace fdb_cli {

															#line 433 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
// This generated class is to be used only via requestVersionUpdate()
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
template <class RequestVersionUpdateActor>
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
class RequestVersionUpdateActorState {
															#line 439 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	RequestVersionUpdateActorState(Database const& localDb,Reference<ChangeFeedData> const& feedData) 
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		 : localDb(localDb),
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		   feedData(feedData)
															#line 448 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("requestVersionUpdate", reinterpret_cast<unsigned long>(this));

	}
	~RequestVersionUpdateActorState() 
	{
		fdb_probe_actor_destroy("requestVersionUpdate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			;
															#line 463 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RequestVersionUpdateActorState();
		static_cast<RequestVersionUpdateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(5.0);
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 495 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RequestVersionUpdateActor, 0, Void >*>(static_cast<RequestVersionUpdateActor*>(this)));
															#line 500 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		Transaction tr(localDb);
															#line 72 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		StrictFuture<Version> __when_expr_1 = tr.getReadVersion();
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 515 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RequestVersionUpdateActor, 1, Version >*>(static_cast<RequestVersionUpdateActor*>(this)));
															#line 520 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		Transaction tr(localDb);
															#line 72 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		tr.setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		StrictFuture<Version> __when_expr_1 = tr.getReadVersion();
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 535 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RequestVersionUpdateActor, 1, Version >*>(static_cast<RequestVersionUpdateActor*>(this)));
															#line 540 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state > 0) static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state = 0;
		static_cast<RequestVersionUpdateActor*>(this)->ActorCallback< RequestVersionUpdateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RequestVersionUpdateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RequestVersionUpdateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RequestVersionUpdateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 74 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		fmt::print("Requesting version {}\n", ver);
															#line 75 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		StrictFuture<Void> __when_expr_2 = feedData->whenAtLeast(ver);
															#line 75 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 628 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state = 3;
															#line 75 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RequestVersionUpdateActor, 2, Void >*>(static_cast<RequestVersionUpdateActor*>(this)));
															#line 633 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Version const& __ver,int loopDepth) 
	{
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		ver = __ver;
															#line 642 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Version && __ver,int loopDepth) 
	{
		ver = std::move(__ver);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state > 0) static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state = 0;
		static_cast<RequestVersionUpdateActor*>(this)->ActorCallback< RequestVersionUpdateActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< RequestVersionUpdateActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RequestVersionUpdateActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RequestVersionUpdateActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		fmt::print("Feed at version {}\n", ver);
															#line 721 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 76 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		fmt::print("Feed at version {}\n", ver);
															#line 730 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state > 0) static_cast<RequestVersionUpdateActor*>(this)->actor_wait_state = 0;
		static_cast<RequestVersionUpdateActor*>(this)->ActorCallback< RequestVersionUpdateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RequestVersionUpdateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RequestVersionUpdateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RequestVersionUpdateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Database localDb;
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Reference<ChangeFeedData> feedData;
															#line 73 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Version ver;
															#line 816 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
};
// This generated class is to be used only via requestVersionUpdate()
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
class RequestVersionUpdateActor final : public Actor<Void>, public ActorCallback< RequestVersionUpdateActor, 0, Void >, public ActorCallback< RequestVersionUpdateActor, 1, Version >, public ActorCallback< RequestVersionUpdateActor, 2, Void >, public FastAllocated<RequestVersionUpdateActor>, public RequestVersionUpdateActorState<RequestVersionUpdateActor> {
															#line 821 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
public:
	using FastAllocated<RequestVersionUpdateActor>::operator new;
	using FastAllocated<RequestVersionUpdateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5654322481401367040UL, 17720619921624615168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RequestVersionUpdateActor, 0, Void >;
friend struct ActorCallback< RequestVersionUpdateActor, 1, Version >;
friend struct ActorCallback< RequestVersionUpdateActor, 2, Void >;
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	RequestVersionUpdateActor(Database const& localDb,Reference<ChangeFeedData> const& feedData) 
															#line 840 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		 : Actor<Void>(),
		   RequestVersionUpdateActorState<RequestVersionUpdateActor>(localDb, feedData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("requestVersionUpdate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8161444621819191552UL, 118505762242926336UL);
		ActorExecutionContextHelper __helper(static_cast<RequestVersionUpdateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("requestVersionUpdate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("requestVersionUpdate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RequestVersionUpdateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RequestVersionUpdateActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RequestVersionUpdateActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
[[nodiscard]] Future<Void> requestVersionUpdate( Database const& localDb, Reference<ChangeFeedData> const& feedData ) {
															#line 68 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	return Future<Void>(new RequestVersionUpdateActor(localDb, feedData));
															#line 874 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
}

#line 79 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"

															#line 879 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
// This generated class is to be used only via changeFeedCommandActor()
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
template <class ChangeFeedCommandActorActor>
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
class ChangeFeedCommandActorActorState {
															#line 885 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
public:
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	ChangeFeedCommandActorActorState(Database const& localDb,Optional<TenantMapEntry> const& tenantEntry,std::vector<StringRef> const& tokens,Future<Void> const& warn) 
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		 : localDb(localDb),
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		   tenantEntry(tenantEntry),
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		   tokens(tokens),
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		   warn(warn)
															#line 898 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("changeFeedCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~ChangeFeedCommandActorActorState() 
	{
		fdb_probe_actor_destroy("changeFeedCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 913 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			{
															#line 85 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 86 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 919 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
				new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~ChangeFeedCommandActorActorState();
				static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 88 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			if (tokencmp(tokens[1], "list"))
															#line 927 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			{
															#line 89 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				if (tokens.size() != 2)
															#line 931 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
				{
															#line 90 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 91 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 937 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
					new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~ChangeFeedCommandActorActorState();
					static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = changeFeedList(localDb);
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 947 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 1;
															#line 93 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedCommandActorActor, 0, Void >*>(static_cast<ChangeFeedCommandActorActor*>(this)));
															#line 952 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 95 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				if (tokencmp(tokens[1], "register"))
															#line 959 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
				{
															#line 96 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					if (tokens.size() != 5)
															#line 963 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
					{
															#line 97 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 98 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 969 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
						new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
						this->~ChangeFeedCommandActorActorState();
						static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
															#line 101 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					KeyRange range;
															#line 102 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					if (tenantEntry.present())
															#line 979 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
					{
															#line 103 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						range = KeyRangeRef(tokens[3], tokens[4]).withPrefix(tenantEntry.get().prefix);
															#line 983 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
					}
					else
					{
															#line 105 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						range = KeyRangeRef(tokens[3], tokens[4]);
															#line 989 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
					}
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					StrictFuture<Void> __when_expr_1 = updateChangeFeed(localDb, tokens[2], ChangeFeedStatus::CHANGE_FEED_CREATE, range);
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 995 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 2;
															#line 108 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedCommandActorActor, 1, Void >*>(static_cast<ChangeFeedCommandActorActor*>(this)));
															#line 1000 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 109 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
					if (tokencmp(tokens[1], "stop"))
															#line 1007 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
					{
															#line 110 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						if (tokens.size() != 3)
															#line 1011 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
						{
															#line 111 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
							printUsage(tokens[0]);
															#line 112 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
							if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1017 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
							new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
							this->~ChangeFeedCommandActorActorState();
							static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
							return 0;
						}
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						StrictFuture<Void> __when_expr_2 = updateChangeFeed(localDb, tokens[2], ChangeFeedStatus::CHANGE_FEED_STOP);
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1027 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
						if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when3(__when_expr_2.get(), loopDepth); };
						static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 3;
															#line 114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedCommandActorActor, 2, Void >*>(static_cast<ChangeFeedCommandActorActor*>(this)));
															#line 1032 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 115 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
						if (tokencmp(tokens[1], "destroy"))
															#line 1039 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
						{
															#line 116 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
							if (tokens.size() != 3)
															#line 1043 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
							{
															#line 117 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								printUsage(tokens[0]);
															#line 118 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1049 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
								new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
								this->~ChangeFeedCommandActorActorState();
								static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 120 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
							StrictFuture<Void> __when_expr_3 = updateChangeFeed(localDb, tokens[2], ChangeFeedStatus::CHANGE_FEED_DESTROY);
															#line 120 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
							if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1059 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
							if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1when4(__when_expr_3.get(), loopDepth); };
							static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 4;
															#line 120 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
							__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedCommandActorActor, 3, Void >*>(static_cast<ChangeFeedCommandActorActor*>(this)));
															#line 1064 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 121 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
							if (tokencmp(tokens[1], "stream"))
															#line 1071 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
							{
															#line 122 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								if (tokens.size() < 3 || tokens.size() > 5)
															#line 1075 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
								{
															#line 123 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									printUsage(tokens[0]);
															#line 124 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1081 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
									new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
									this->~ChangeFeedCommandActorActorState();
									static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
															#line 126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								Version begin = 0;
															#line 127 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								Version end = std::numeric_limits<Version>::max();
															#line 128 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								if (tokens.size() > 3)
															#line 1093 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
								{
															#line 129 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									int n = 0;
															#line 130 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									if (sscanf(tokens[3].toString().c_str(), "%" PRId64 "%n", &begin, &n) != 1 || n != tokens[3].size())
															#line 1099 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
									{
															#line 131 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										printUsage(tokens[0]);
															#line 132 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1105 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
										new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
										this->~ChangeFeedCommandActorActorState();
										static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
								}
															#line 135 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								if (tokens.size() > 4)
															#line 1114 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
								{
															#line 136 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									int n = 0;
															#line 137 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									if (sscanf(tokens[4].toString().c_str(), "%" PRId64 "%n", &end, &n) != 1 || n != tokens[4].size())
															#line 1120 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
									{
															#line 138 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										printUsage(tokens[0]);
															#line 139 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1126 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
										new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
										this->~ChangeFeedCommandActorActorState();
										static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
								}
															#line 142 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								if (warn.isValid())
															#line 1135 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
								{
															#line 143 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									warn.cancel();
															#line 1139 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
								}
															#line 145 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								feedData = makeReference<ChangeFeedData>();
															#line 146 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								feed = localDb->getChangeFeedStream(feedData, tokens[2], begin, end);
															#line 147 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								versionUpdates = requestVersionUpdate(localDb, feedData);
															#line 148 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								printf("\n");
															#line 1149 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
								try {
															#line 150 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									feedInterrupt = LineNoise::onKeyboardInterrupt();
															#line 151 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									;
															#line 1155 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
									loopDepth = a_body1loopHead1(loopDepth);
								}
								catch (Error& error) {
									loopDepth = a_body1Catch2(error, loopDepth);
								} catch (...) {
									loopDepth = a_body1Catch2(unknown_error(), loopDepth);
								}
							}
							else
							{
															#line 176 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
								if (tokencmp(tokens[1], "pop"))
															#line 1168 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
								{
															#line 177 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									if (tokens.size() != 4)
															#line 1172 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
									{
															#line 178 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										printUsage(tokens[0]);
															#line 179 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1178 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
										new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
										this->~ChangeFeedCommandActorActorState();
										static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
															#line 181 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									Version v;
															#line 182 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									int n = 0;
															#line 183 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									if (sscanf(tokens[3].toString().c_str(), "%" PRId64 "%n", &v, &n) != 1 || n != tokens[3].size())
															#line 1190 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
									{
															#line 184 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										printUsage(tokens[0]);
															#line 185 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1196 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
										new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
										this->~ChangeFeedCommandActorActorState();
										static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
										return 0;
									}
									else
									{
															#line 187 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										StrictFuture<Void> __when_expr_6 = localDb->popChangeFeedMutations(tokens[2], v);
															#line 187 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1208 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
										if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1when5(__when_expr_6.get(), loopDepth); };
										static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 6;
															#line 187 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
										__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedCommandActorActor, 6, Void >*>(static_cast<ChangeFeedCommandActorActor*>(this)));
															#line 1213 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
										loopDepth = 0;
									}
								}
								else
								{
															#line 190 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									printUsage(tokens[0]);
															#line 191 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
									if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1223 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
									new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
									this->~ChangeFeedCommandActorActorState();
									static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
							}
						}
					}
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeFeedCommandActorActorState();
		static_cast<ChangeFeedCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 193 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1255 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ChangeFeedCommandActorActorState();
		static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1267 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ChangeFeedCommandActorActorState();
		static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1279 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ChangeFeedCommandActorActorState();
		static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedCommandActorActor*>(this)->ActorCallback< ChangeFeedCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeFeedCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedCommandActorActor*>(this)->ActorCallback< ChangeFeedCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeFeedCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedCommandActorActor*>(this)->ActorCallback< ChangeFeedCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ChangeFeedCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont14(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont15(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont15(_, loopDepth);

		return loopDepth;
	}
	int a_body1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont15(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedCommandActorActor*>(this)->ActorCallback< ChangeFeedCommandActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ChangeFeedCommandActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont17(int loopDepth) 
	{
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 171 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 1652 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			{
															#line 172 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1656 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
				new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
				this->~ChangeFeedCommandActorActorState();
				static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 174 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1664 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont25(int loopDepth) 
	{
															#line 169 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (!static_cast<ChangeFeedCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~ChangeFeedCommandActorActorState(); static_cast<ChangeFeedCommandActorActor*>(this)->destroy(); return 0; }
															#line 1678 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		new (&static_cast<ChangeFeedCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
		this->~ChangeFeedCommandActorActorState();
		static_cast<ChangeFeedCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 153 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		auto __when_expr_4 = feedData->mutations.getFuture();
															#line 1697 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<Standalone<VectorRef<MutationsAndVersionRef>>>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<Standalone<VectorRef<MutationsAndVersionRef>>>>::value, "invalid type");
															#line 152 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1701 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_4.pop(), loopDepth); };
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		StrictFuture<Void> __when_expr_5 = feedInterrupt;
															#line 1705 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_5.get(), loopDepth); };
		static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 5;
															#line 153 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< ChangeFeedCommandActorActor, 4, Standalone<VectorRef<MutationsAndVersionRef>> >*>(static_cast<ChangeFeedCommandActorActor*>(this)));
															#line 161 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ChangeFeedCommandActorActor, 5, Void >*>(static_cast<ChangeFeedCommandActorActor*>(this)));
															#line 1712 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont25(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<MutationsAndVersionRef>> const& res,int loopDepth) 
	{
															#line 155 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		for( auto& it : res ) {
															#line 156 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			for( auto& it2 : it.mutations ) {
															#line 157 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				fmt::print("{0} {1}\n", it.version, it2.toString());
															#line 1744 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<MutationsAndVersionRef>> && res,int loopDepth) 
	{
															#line 155 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		for( auto& it : res ) {
															#line 156 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
			for( auto& it2 : it.mutations ) {
															#line 157 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
				fmt::print("{0} {1}\n", it.version, it2.toString());
															#line 1759 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		feedInterrupt = Future<Void>();
															#line 163 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		feed.cancel();
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		feedData = makeReference<ChangeFeedData>();
															#line 1774 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		feedInterrupt = Future<Void>();
															#line 163 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		feed.cancel();
															#line 164 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
		feedData = makeReference<ChangeFeedData>();
															#line 1787 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedCommandActorActor*>(this)->ActorSingleCallback< ChangeFeedCommandActorActor, 4, Standalone<VectorRef<MutationsAndVersionRef>> >::remove();
		static_cast<ChangeFeedCommandActorActor*>(this)->ActorCallback< ChangeFeedCommandActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ChangeFeedCommandActorActor, 4, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> const& value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< ChangeFeedCommandActorActor, 4, Standalone<VectorRef<MutationsAndVersionRef>> >*,Standalone<VectorRef<MutationsAndVersionRef>> && value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< ChangeFeedCommandActorActor, 4, Standalone<VectorRef<MutationsAndVersionRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ChangeFeedCommandActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont26(int loopDepth) 
	{
		loopDepth = a_body1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1cont27(int loopDepth) 
	{
		loopDepth = a_body1cont26(loopDepth);

		return loopDepth;
	}
	int a_body1cont30(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont27(loopDepth);

		return loopDepth;
	}
	int a_body1cont30(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont27(loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont30(_, loopDepth);

		return loopDepth;
	}
	int a_body1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont30(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state > 0) static_cast<ChangeFeedCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeFeedCommandActorActor*>(this)->ActorCallback< ChangeFeedCommandActorActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ChangeFeedCommandActorActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ChangeFeedCommandActorActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Database localDb;
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Optional<TenantMapEntry> tenantEntry;
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Future<Void> warn;
															#line 145 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Reference<ChangeFeedData> feedData;
															#line 146 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Future<Void> feed;
															#line 147 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Future<Void> versionUpdates;
															#line 150 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	Future<Void> feedInterrupt;
															#line 2028 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
};
// This generated class is to be used only via changeFeedCommandActor()
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
class ChangeFeedCommandActorActor final : public Actor<bool>, public ActorCallback< ChangeFeedCommandActorActor, 0, Void >, public ActorCallback< ChangeFeedCommandActorActor, 1, Void >, public ActorCallback< ChangeFeedCommandActorActor, 2, Void >, public ActorCallback< ChangeFeedCommandActorActor, 3, Void >, public ActorSingleCallback< ChangeFeedCommandActorActor, 4, Standalone<VectorRef<MutationsAndVersionRef>> >, public ActorCallback< ChangeFeedCommandActorActor, 5, Void >, public ActorCallback< ChangeFeedCommandActorActor, 6, Void >, public FastAllocated<ChangeFeedCommandActorActor>, public ChangeFeedCommandActorActorState<ChangeFeedCommandActorActor> {
															#line 2033 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
public:
	using FastAllocated<ChangeFeedCommandActorActor>::operator new;
	using FastAllocated<ChangeFeedCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3607910500676206592UL, 13374566660033041152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeFeedCommandActorActor, 0, Void >;
friend struct ActorCallback< ChangeFeedCommandActorActor, 1, Void >;
friend struct ActorCallback< ChangeFeedCommandActorActor, 2, Void >;
friend struct ActorCallback< ChangeFeedCommandActorActor, 3, Void >;
friend struct ActorSingleCallback< ChangeFeedCommandActorActor, 4, Standalone<VectorRef<MutationsAndVersionRef>> >;
friend struct ActorCallback< ChangeFeedCommandActorActor, 5, Void >;
friend struct ActorCallback< ChangeFeedCommandActorActor, 6, Void >;
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	ChangeFeedCommandActorActor(Database const& localDb,Optional<TenantMapEntry> const& tenantEntry,std::vector<StringRef> const& tokens,Future<Void> const& warn) 
															#line 2056 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
		 : Actor<bool>(),
		   ChangeFeedCommandActorActorState<ChangeFeedCommandActorActor>(localDb, tenantEntry, tokens, warn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8895220825363838720UL, 13572361913667128832UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeFeedCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeFeedCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeFeedCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeFeedCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeFeedCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ChangeFeedCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ChangeFeedCommandActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorSingleCallback< ChangeFeedCommandActorActor, 4, Standalone<VectorRef<MutationsAndVersionRef>> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ChangeFeedCommandActorActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
[[nodiscard]] Future<bool> changeFeedCommandActor( Database const& localDb, Optional<TenantMapEntry> const& tenantEntry, std::vector<StringRef> const& tokens, Future<Void> const& warn ) {
															#line 80 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"
	return Future<bool>(new ChangeFeedCommandActorActor(localDb, tenantEntry, tokens, warn));
															#line 2093 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/build_output/fdbcli/ChangeFeedCommand.actor.g.cpp"
}

#line 195 "/codebuild/output/src3861208925/src/github.com/apple/foundationdb/fdbcli/ChangeFeedCommand.actor.cpp"

CommandFactory changeFeedFactory(
    "changefeed",
    CommandHelp("changefeed <register|destroy|stop|stream|pop|list> <RANGEID> <BEGIN> <END>", "", ""));
} // namespace fdb_cli
